/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLImageElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLImageElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLImageElement* kit(WebCore::HTMLImageElement* obj)
{
    return WEBKIT_DOM_HTML_IMAGE_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLImageElement* core(WebKitDOMHTMLImageElement* request)
{
    return request ? static_cast<WebCore::HTMLImageElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLImageElement* wrapHTMLImageElement(WebCore::HTMLImageElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_IMAGE_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_IMAGE_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLImageElement, webkit_dom_html_image_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_NAME,
    PROP_ALIGN,
    PROP_ALT,
    PROP_BORDER,
    PROP_CROSS_ORIGIN,
    PROP_HEIGHT,
    PROP_HSPACE,
    PROP_IS_MAP,
    PROP_LONG_DESC,
    PROP_SRC,
    PROP_USE_MAP,
    PROP_VSPACE,
    PROP_WIDTH,
    PROP_COMPLETE,
    PROP_LOWSRC,
    PROP_NATURAL_HEIGHT,
    PROP_NATURAL_WIDTH,
    PROP_X,
    PROP_Y,
};

static void webkit_dom_html_image_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLImageElement* self = WEBKIT_DOM_HTML_IMAGE_ELEMENT(object);
    WebCore::HTMLImageElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ALT: {
        coreSelf->setAttribute(WebCore::HTMLNames::altAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_BORDER: {
        coreSelf->setAttribute(WebCore::HTMLNames::borderAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CROSS_ORIGIN: {
        coreSelf->setAttribute(WebCore::HTMLNames::crossoriginAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HEIGHT: {
        coreSelf->setHeight((g_value_get_long(value)));
        break;
    }
    case PROP_HSPACE: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::hspaceAttr, (g_value_get_long(value)));
        break;
    }
    case PROP_IS_MAP: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::ismapAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_LONG_DESC: {
        coreSelf->setAttribute(WebCore::HTMLNames::longdescAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SRC: {
        coreSelf->setAttribute(WebCore::HTMLNames::srcAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_USE_MAP: {
        coreSelf->setAttribute(WebCore::HTMLNames::usemapAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VSPACE: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::vspaceAttr, (g_value_get_long(value)));
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setWidth((g_value_get_long(value)));
        break;
    }
    case PROP_LOWSRC: {
        coreSelf->setAttribute(WebCore::HTMLNames::lowsrcAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_image_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLImageElement* self = WEBKIT_DOM_HTML_IMAGE_ELEMENT(object);
    WebCore::HTMLImageElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_ALT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::altAttr)));
        break;
    }
    case PROP_BORDER: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::borderAttr)));
        break;
    }
    case PROP_CROSS_ORIGIN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::crossoriginAttr)));
        break;
    }
    case PROP_HEIGHT: {
        g_value_set_long(value, coreSelf->height());
        break;
    }
    case PROP_HSPACE: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::hspaceAttr));
        break;
    }
    case PROP_IS_MAP: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::ismapAttr));
        break;
    }
    case PROP_LONG_DESC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::longdescAttr)));
        break;
    }
    case PROP_SRC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::srcAttr)));
        break;
    }
    case PROP_USE_MAP: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::usemapAttr)));
        break;
    }
    case PROP_VSPACE: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::vspaceAttr));
        break;
    }
    case PROP_WIDTH: {
        g_value_set_long(value, coreSelf->width());
        break;
    }
    case PROP_COMPLETE: {
        g_value_set_boolean(value, coreSelf->complete());
        break;
    }
    case PROP_LOWSRC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::lowsrcAttr)));
        break;
    }
    case PROP_NATURAL_HEIGHT: {
        g_value_set_long(value, coreSelf->naturalHeight());
        break;
    }
    case PROP_NATURAL_WIDTH: {
        g_value_set_long(value, coreSelf->naturalWidth());
        break;
    }
    case PROP_X: {
        g_value_set_long(value, coreSelf->x());
        break;
    }
    case PROP_Y: {
        g_value_set_long(value, coreSelf->y());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_image_element_class_init(WebKitDOMHTMLImageElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_image_element_set_property;
    gobjectClass->get_property = webkit_dom_html_image_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_image_element_name", /* short description */
                                                           "read-write  gchar* HTMLImageElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "html_image_element_align", /* short description */
                                                           "read-write  gchar* HTMLImageElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALT,
                                    g_param_spec_string("alt", /* name */
                                                           "html_image_element_alt", /* short description */
                                                           "read-write  gchar* HTMLImageElement.alt", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BORDER,
                                    g_param_spec_string("border", /* name */
                                                           "html_image_element_border", /* short description */
                                                           "read-write  gchar* HTMLImageElement.border", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CROSS_ORIGIN,
                                    g_param_spec_string("cross-origin", /* name */
                                                           "html_image_element_cross-origin", /* short description */
                                                           "read-write  gchar* HTMLImageElement.cross-origin", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_long("height", /* name */
                                                           "html_image_element_height", /* short description */
                                                           "read-write  glong HTMLImageElement.height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HSPACE,
                                    g_param_spec_long("hspace", /* name */
                                                           "html_image_element_hspace", /* short description */
                                                           "read-write  glong HTMLImageElement.hspace", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_IS_MAP,
                                    g_param_spec_boolean("is-map", /* name */
                                                           "html_image_element_is-map", /* short description */
                                                           "read-write  gboolean HTMLImageElement.is-map", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LONG_DESC,
                                    g_param_spec_string("long-desc", /* name */
                                                           "html_image_element_long-desc", /* short description */
                                                           "read-write  gchar* HTMLImageElement.long-desc", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SRC,
                                    g_param_spec_string("src", /* name */
                                                           "html_image_element_src", /* short description */
                                                           "read-write  gchar* HTMLImageElement.src", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_USE_MAP,
                                    g_param_spec_string("use-map", /* name */
                                                           "html_image_element_use-map", /* short description */
                                                           "read-write  gchar* HTMLImageElement.use-map", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VSPACE,
                                    g_param_spec_long("vspace", /* name */
                                                           "html_image_element_vspace", /* short description */
                                                           "read-write  glong HTMLImageElement.vspace", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_long("width", /* name */
                                                           "html_image_element_width", /* short description */
                                                           "read-write  glong HTMLImageElement.width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COMPLETE,
                                    g_param_spec_boolean("complete", /* name */
                                                           "html_image_element_complete", /* short description */
                                                           "read-only  gboolean HTMLImageElement.complete", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LOWSRC,
                                    g_param_spec_string("lowsrc", /* name */
                                                           "html_image_element_lowsrc", /* short description */
                                                           "read-write  gchar* HTMLImageElement.lowsrc", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NATURAL_HEIGHT,
                                    g_param_spec_long("natural-height", /* name */
                                                           "html_image_element_natural-height", /* short description */
                                                           "read-only  glong HTMLImageElement.natural-height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NATURAL_WIDTH,
                                    g_param_spec_long("natural-width", /* name */
                                                           "html_image_element_natural-width", /* short description */
                                                           "read-only  glong HTMLImageElement.natural-width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_X,
                                    g_param_spec_long("x", /* name */
                                                           "html_image_element_x", /* short description */
                                                           "read-only  glong HTMLImageElement.x", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_Y,
                                    g_param_spec_long("y", /* name */
                                                           "html_image_element_y", /* short description */
                                                           "read-only  glong HTMLImageElement.y", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_image_element_init(WebKitDOMHTMLImageElement* request)
{
}

gchar*
webkit_dom_html_image_element_get_name(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_image_element_set_name(WebKitDOMHTMLImageElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_image_element_get_align(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_html_image_element_set_align(WebKitDOMHTMLImageElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

gchar*
webkit_dom_html_image_element_get_alt(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::altAttr));
    return result;
}

void
webkit_dom_html_image_element_set_alt(WebKitDOMHTMLImageElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::altAttr, convertedValue);
}

gchar*
webkit_dom_html_image_element_get_border(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::borderAttr));
    return result;
}

void
webkit_dom_html_image_element_set_border(WebKitDOMHTMLImageElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::borderAttr, convertedValue);
}

gchar*
webkit_dom_html_image_element_get_cross_origin(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::crossoriginAttr));
    return result;
}

void
webkit_dom_html_image_element_set_cross_origin(WebKitDOMHTMLImageElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::crossoriginAttr, convertedValue);
}

glong
webkit_dom_html_image_element_get_height(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    glong result = item->height();
    return result;
}

void
webkit_dom_html_image_element_set_height(WebKitDOMHTMLImageElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    WebCore::HTMLImageElement* item = WebKit::core(self);
    item->setHeight(value);
}

glong
webkit_dom_html_image_element_get_hspace(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::hspaceAttr);
    return result;
}

void
webkit_dom_html_image_element_set_hspace(WebKitDOMHTMLImageElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    WebCore::HTMLImageElement* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::hspaceAttr, value);
}

gboolean
webkit_dom_html_image_element_get_is_map(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), FALSE);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::ismapAttr);
    return result;
}

void
webkit_dom_html_image_element_set_is_map(WebKitDOMHTMLImageElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    WebCore::HTMLImageElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::ismapAttr, value);
}

gchar*
webkit_dom_html_image_element_get_long_desc(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::longdescAttr));
    return result;
}

void
webkit_dom_html_image_element_set_long_desc(WebKitDOMHTMLImageElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::longdescAttr, convertedValue);
}

gchar*
webkit_dom_html_image_element_get_src(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}

void
webkit_dom_html_image_element_set_src(WebKitDOMHTMLImageElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::srcAttr, convertedValue);
}

gchar*
webkit_dom_html_image_element_get_use_map(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::usemapAttr));
    return result;
}

void
webkit_dom_html_image_element_set_use_map(WebKitDOMHTMLImageElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::usemapAttr, convertedValue);
}

glong
webkit_dom_html_image_element_get_vspace(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::vspaceAttr);
    return result;
}

void
webkit_dom_html_image_element_set_vspace(WebKitDOMHTMLImageElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    WebCore::HTMLImageElement* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::vspaceAttr, value);
}

glong
webkit_dom_html_image_element_get_width(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    glong result = item->width();
    return result;
}

void
webkit_dom_html_image_element_set_width(WebKitDOMHTMLImageElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    WebCore::HTMLImageElement* item = WebKit::core(self);
    item->setWidth(value);
}

gboolean
webkit_dom_html_image_element_get_complete(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), FALSE);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gboolean result = item->complete();
    return result;
}

gchar*
webkit_dom_html_image_element_get_lowsrc(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::lowsrcAttr));
    return result;
}

void
webkit_dom_html_image_element_set_lowsrc(WebKitDOMHTMLImageElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::lowsrcAttr, convertedValue);
}

glong
webkit_dom_html_image_element_get_natural_height(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    glong result = item->naturalHeight();
    return result;
}

glong
webkit_dom_html_image_element_get_natural_width(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    glong result = item->naturalWidth();
    return result;
}

glong
webkit_dom_html_image_element_get_x(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    glong result = item->x();
    return result;
}

glong
webkit_dom_html_image_element_get_y(WebKitDOMHTMLImageElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_IMAGE_ELEMENT(self), 0);
    WebCore::HTMLImageElement* item = WebKit::core(self);
    glong result = item->y();
    return result;
}

