// File is generated by Source/WebCore/inspector/CodeGeneratorInspector.py

// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


#include "config.h"
#if ENABLE(INSPECTOR)

#include "InspectorFrontend.h"
#include <wtf/text/WTFString.h>
#include <wtf/text/CString.h>

#include "InspectorFrontendChannel.h"
#include "InspectorValues.h"
#include <wtf/text/WTFString.h>

namespace WebCore {

InspectorFrontend::InspectorFrontend(InspectorFrontendChannel* inspectorFrontendChannel)
    : m_inspector(inspectorFrontendChannel)
    , m_memory(inspectorFrontendChannel)
    , m_page(inspectorFrontendChannel)
    , m_runtime(inspectorFrontendChannel)
    , m_console(inspectorFrontendChannel)
    , m_network(inspectorFrontendChannel)
#if ENABLE(SQL_DATABASE)
    , m_database(inspectorFrontendChannel)
#endif // ENABLE(SQL_DATABASE)
#if ENABLE(INDEXED_DATABASE)
    , m_indexeddb(inspectorFrontendChannel)
#endif // ENABLE(INDEXED_DATABASE)
    , m_domstorage(inspectorFrontendChannel)
    , m_applicationcache(inspectorFrontendChannel)
#if ENABLE(FILE_SYSTEM)
    , m_filesystem(inspectorFrontendChannel)
#endif // ENABLE(FILE_SYSTEM)
    , m_dom(inspectorFrontendChannel)
    , m_css(inspectorFrontendChannel)
    , m_timeline(inspectorFrontendChannel)
#if ENABLE(JAVASCRIPT_DEBUGGER)
    , m_debugger(inspectorFrontendChannel)
#endif // ENABLE(JAVASCRIPT_DEBUGGER)
#if ENABLE(JAVASCRIPT_DEBUGGER)
    , m_domdebugger(inspectorFrontendChannel)
#endif // ENABLE(JAVASCRIPT_DEBUGGER)
#if ENABLE(JAVASCRIPT_DEBUGGER)
    , m_profiler(inspectorFrontendChannel)
#endif // ENABLE(JAVASCRIPT_DEBUGGER)
    , m_heapprofiler(inspectorFrontendChannel)
#if ENABLE(WORKERS)
    , m_worker(inspectorFrontendChannel)
#endif // ENABLE(WORKERS)
    , m_canvas(inspectorFrontendChannel)
    , m_input(inspectorFrontendChannel)
    , m_layertree(inspectorFrontendChannel)
{
}

void InspectorFrontend::Inspector::evaluateForTestInFrontend(int testCallId, const String& script)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Inspector.evaluateForTestInFrontend");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("testCallId", testCallId);
    paramsObject->setString("script", script);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Inspector::inspect(PassRefPtr<TypeBuilder::Runtime::RemoteObject> object, PassRefPtr<InspectorObject> hints)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Inspector.inspect");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("object", object);
    paramsObject->setValue("hints", hints);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Inspector::detached(const String& reason)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Inspector.detached");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("reason", reason);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Memory::addNativeSnapshotChunk(PassRefPtr<TypeBuilder::Memory::HeapSnapshotChunk> chunk)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Memory.addNativeSnapshotChunk");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("chunk", chunk);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::domContentEventFired(double timestamp)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.domContentEventFired");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("timestamp", timestamp);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::loadEventFired(double timestamp)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.loadEventFired");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("timestamp", timestamp);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::frameNavigated(PassRefPtr<TypeBuilder::Page::Frame> frame)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.frameNavigated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("frame", frame);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::frameDetached(const TypeBuilder::Network::FrameId& frameId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.frameDetached");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("frameId", frameId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::frameStartedLoading(const TypeBuilder::Network::FrameId& frameId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.frameStartedLoading");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("frameId", frameId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::frameStoppedLoading(const TypeBuilder::Network::FrameId& frameId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.frameStoppedLoading");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("frameId", frameId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::frameScheduledNavigation(const TypeBuilder::Network::FrameId& frameId, double delay)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.frameScheduledNavigation");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("frameId", frameId);
    paramsObject->setNumber("delay", delay);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::frameClearedScheduledNavigation(const TypeBuilder::Network::FrameId& frameId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.frameClearedScheduledNavigation");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("frameId", frameId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::javascriptDialogOpening(const String& message)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.javascriptDialogOpening");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("message", message);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::javascriptDialogClosed()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.javascriptDialogClosed");
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Page::scriptsEnabled(bool isEnabled)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Page.scriptsEnabled");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setBoolean("isEnabled", isEnabled);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Runtime::executionContextCreated(PassRefPtr<TypeBuilder::Runtime::ExecutionContextDescription> context)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Runtime.executionContextCreated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("context", context);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Console::messageAdded(PassRefPtr<TypeBuilder::Console::ConsoleMessage> message)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Console.messageAdded");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("message", message);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Console::messageRepeatCountUpdated(int count)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Console.messageRepeatCountUpdated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("count", count);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Console::messagesCleared()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Console.messagesCleared");
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::requestWillBeSent(const TypeBuilder::Network::RequestId& requestId, const TypeBuilder::Network::FrameId& frameId, const TypeBuilder::Network::LoaderId& loaderId, const String& documentURL, PassRefPtr<TypeBuilder::Network::Request> request, double timestamp, PassRefPtr<TypeBuilder::Network::Initiator> initiator, PassRefPtr<TypeBuilder::Network::Response> redirectResponse)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.requestWillBeSent");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setString("frameId", frameId);
    paramsObject->setString("loaderId", loaderId);
    paramsObject->setString("documentURL", documentURL);
    paramsObject->setValue("request", request);
    paramsObject->setNumber("timestamp", timestamp);
    paramsObject->setValue("initiator", initiator);
    if (redirectResponse)
        paramsObject->setValue("redirectResponse", redirectResponse);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::requestServedFromCache(const TypeBuilder::Network::RequestId& requestId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.requestServedFromCache");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::responseReceived(const TypeBuilder::Network::RequestId& requestId, const TypeBuilder::Network::FrameId& frameId, const TypeBuilder::Network::LoaderId& loaderId, double timestamp, TypeBuilder::Page::ResourceType::Enum type, PassRefPtr<TypeBuilder::Network::Response> response)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.responseReceived");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setString("frameId", frameId);
    paramsObject->setString("loaderId", loaderId);
    paramsObject->setNumber("timestamp", timestamp);
    paramsObject->setString("type", TypeBuilder::getEnumConstantValue(type));
    paramsObject->setValue("response", response);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::dataReceived(const TypeBuilder::Network::RequestId& requestId, double timestamp, int dataLength, int encodedDataLength)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.dataReceived");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setNumber("timestamp", timestamp);
    paramsObject->setNumber("dataLength", dataLength);
    paramsObject->setNumber("encodedDataLength", encodedDataLength);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::loadingFinished(const TypeBuilder::Network::RequestId& requestId, double timestamp)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.loadingFinished");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setNumber("timestamp", timestamp);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::loadingFailed(const TypeBuilder::Network::RequestId& requestId, double timestamp, const String& errorText, const bool* const canceled)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.loadingFailed");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setNumber("timestamp", timestamp);
    paramsObject->setString("errorText", errorText);
    if (canceled)
        paramsObject->setBoolean("canceled", *canceled);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::requestServedFromMemoryCache(const TypeBuilder::Network::RequestId& requestId, const TypeBuilder::Network::FrameId& frameId, const TypeBuilder::Network::LoaderId& loaderId, const String& documentURL, double timestamp, PassRefPtr<TypeBuilder::Network::Initiator> initiator, PassRefPtr<TypeBuilder::Network::CachedResource> resource)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.requestServedFromMemoryCache");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setString("frameId", frameId);
    paramsObject->setString("loaderId", loaderId);
    paramsObject->setString("documentURL", documentURL);
    paramsObject->setNumber("timestamp", timestamp);
    paramsObject->setValue("initiator", initiator);
    paramsObject->setValue("resource", resource);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::webSocketWillSendHandshakeRequest(const TypeBuilder::Network::RequestId& requestId, double timestamp, PassRefPtr<TypeBuilder::Network::WebSocketRequest> request)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.webSocketWillSendHandshakeRequest");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setNumber("timestamp", timestamp);
    paramsObject->setValue("request", request);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::webSocketHandshakeResponseReceived(const TypeBuilder::Network::RequestId& requestId, double timestamp, PassRefPtr<TypeBuilder::Network::WebSocketResponse> response)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.webSocketHandshakeResponseReceived");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setNumber("timestamp", timestamp);
    paramsObject->setValue("response", response);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::webSocketCreated(const TypeBuilder::Network::RequestId& requestId, const String& url)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.webSocketCreated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setString("url", url);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::webSocketClosed(const TypeBuilder::Network::RequestId& requestId, double timestamp)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.webSocketClosed");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setNumber("timestamp", timestamp);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::webSocketFrameReceived(const TypeBuilder::Network::RequestId& requestId, double timestamp, PassRefPtr<TypeBuilder::Network::WebSocketFrame> response)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.webSocketFrameReceived");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setNumber("timestamp", timestamp);
    paramsObject->setValue("response", response);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::webSocketFrameError(const TypeBuilder::Network::RequestId& requestId, double timestamp, const String& errorMessage)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.webSocketFrameError");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setNumber("timestamp", timestamp);
    paramsObject->setString("errorMessage", errorMessage);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Network::webSocketFrameSent(const TypeBuilder::Network::RequestId& requestId, double timestamp, PassRefPtr<TypeBuilder::Network::WebSocketFrame> response)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Network.webSocketFrameSent");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("requestId", requestId);
    paramsObject->setNumber("timestamp", timestamp);
    paramsObject->setValue("response", response);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

#if ENABLE(SQL_DATABASE)

void InspectorFrontend::Database::addDatabase(PassRefPtr<TypeBuilder::Database::Database> database)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Database.addDatabase");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("database", database);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

#endif // ENABLE(SQL_DATABASE)

#if ENABLE(INDEXED_DATABASE)

#endif // ENABLE(INDEXED_DATABASE)

void InspectorFrontend::DOMStorage::addDOMStorage(PassRefPtr<TypeBuilder::DOMStorage::Entry> storage)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOMStorage.addDOMStorage");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("storage", storage);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOMStorage::domStorageItemsCleared(const TypeBuilder::DOMStorage::StorageId& storageId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOMStorage.domStorageItemsCleared");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("storageId", storageId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOMStorage::domStorageItemRemoved(const TypeBuilder::DOMStorage::StorageId& storageId, const String& key)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOMStorage.domStorageItemRemoved");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("storageId", storageId);
    paramsObject->setString("key", key);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOMStorage::domStorageItemAdded(const TypeBuilder::DOMStorage::StorageId& storageId, const String& key, const String& newValue)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOMStorage.domStorageItemAdded");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("storageId", storageId);
    paramsObject->setString("key", key);
    paramsObject->setString("newValue", newValue);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOMStorage::domStorageItemUpdated(const TypeBuilder::DOMStorage::StorageId& storageId, const String& key, const String& oldValue, const String& newValue)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOMStorage.domStorageItemUpdated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("storageId", storageId);
    paramsObject->setString("key", key);
    paramsObject->setString("oldValue", oldValue);
    paramsObject->setString("newValue", newValue);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::ApplicationCache::applicationCacheStatusUpdated(const TypeBuilder::Network::FrameId& frameId, const String& manifestURL, int status)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "ApplicationCache.applicationCacheStatusUpdated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("frameId", frameId);
    paramsObject->setString("manifestURL", manifestURL);
    paramsObject->setNumber("status", status);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::ApplicationCache::networkStateUpdated(bool isNowOnline)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "ApplicationCache.networkStateUpdated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setBoolean("isNowOnline", isNowOnline);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

#if ENABLE(FILE_SYSTEM)

#endif // ENABLE(FILE_SYSTEM)

void InspectorFrontend::DOM::documentUpdated()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.documentUpdated");
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOM::setChildNodes(int parentId, PassRefPtr<TypeBuilder::Array<TypeBuilder::DOM::Node> > nodes)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.setChildNodes");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("parentId", parentId);
    paramsObject->setValue("nodes", nodes);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOM::attributeModified(int nodeId, const String& name, const String& value)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.attributeModified");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("nodeId", nodeId);
    paramsObject->setString("name", name);
    paramsObject->setString("value", value);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOM::attributeRemoved(int nodeId, const String& name)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.attributeRemoved");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("nodeId", nodeId);
    paramsObject->setString("name", name);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOM::inlineStyleInvalidated(PassRefPtr<TypeBuilder::Array<int> > nodeIds)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.inlineStyleInvalidated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("nodeIds", nodeIds);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOM::characterDataModified(int nodeId, const String& characterData)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.characterDataModified");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("nodeId", nodeId);
    paramsObject->setString("characterData", characterData);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOM::childNodeCountUpdated(int nodeId, int childNodeCount)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.childNodeCountUpdated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("nodeId", nodeId);
    paramsObject->setNumber("childNodeCount", childNodeCount);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOM::childNodeInserted(int parentNodeId, int previousNodeId, PassRefPtr<TypeBuilder::DOM::Node> node)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.childNodeInserted");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("parentNodeId", parentNodeId);
    paramsObject->setNumber("previousNodeId", previousNodeId);
    paramsObject->setValue("node", node);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOM::childNodeRemoved(int parentNodeId, int nodeId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.childNodeRemoved");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("parentNodeId", parentNodeId);
    paramsObject->setNumber("nodeId", nodeId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOM::shadowRootPushed(int hostId, PassRefPtr<TypeBuilder::DOM::Node> root)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.shadowRootPushed");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("hostId", hostId);
    paramsObject->setValue("root", root);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::DOM::shadowRootPopped(int hostId, int rootId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "DOM.shadowRootPopped");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("hostId", hostId);
    paramsObject->setNumber("rootId", rootId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::CSS::mediaQueryResultChanged()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "CSS.mediaQueryResultChanged");
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::CSS::styleSheetChanged(const TypeBuilder::CSS::StyleSheetId& styleSheetId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "CSS.styleSheetChanged");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("styleSheetId", styleSheetId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::CSS::namedFlowCreated(PassRefPtr<TypeBuilder::CSS::NamedFlow> namedFlow)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "CSS.namedFlowCreated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("namedFlow", namedFlow);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::CSS::namedFlowRemoved(int documentNodeId, const String& flowName)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "CSS.namedFlowRemoved");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("documentNodeId", documentNodeId);
    paramsObject->setString("flowName", flowName);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::CSS::regionLayoutUpdated(PassRefPtr<TypeBuilder::CSS::NamedFlow> namedFlow)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "CSS.regionLayoutUpdated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("namedFlow", namedFlow);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Timeline::eventRecorded(PassRefPtr<TypeBuilder::Timeline::TimelineEvent> record)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Timeline.eventRecorded");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("record", record);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

#if ENABLE(JAVASCRIPT_DEBUGGER)

void InspectorFrontend::Debugger::globalObjectCleared()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Debugger.globalObjectCleared");
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Debugger::scriptParsed(const TypeBuilder::Debugger::ScriptId& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, const bool* const isContentScript, const String* const sourceMapURL, const bool* const hasSourceURL)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Debugger.scriptParsed");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("scriptId", scriptId);
    paramsObject->setString("url", url);
    paramsObject->setNumber("startLine", startLine);
    paramsObject->setNumber("startColumn", startColumn);
    paramsObject->setNumber("endLine", endLine);
    paramsObject->setNumber("endColumn", endColumn);
    if (isContentScript)
        paramsObject->setBoolean("isContentScript", *isContentScript);
    if (sourceMapURL)
        paramsObject->setString("sourceMapURL", *sourceMapURL);
    if (hasSourceURL)
        paramsObject->setBoolean("hasSourceURL", *hasSourceURL);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Debugger::scriptFailedToParse(const String& url, const String& scriptSource, int startLine, int errorLine, const String& errorMessage)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Debugger.scriptFailedToParse");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("url", url);
    paramsObject->setString("scriptSource", scriptSource);
    paramsObject->setNumber("startLine", startLine);
    paramsObject->setNumber("errorLine", errorLine);
    paramsObject->setString("errorMessage", errorMessage);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Debugger::breakpointResolved(const TypeBuilder::Debugger::BreakpointId& breakpointId, PassRefPtr<TypeBuilder::Debugger::Location> location)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Debugger.breakpointResolved");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("breakpointId", breakpointId);
    paramsObject->setValue("location", location);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Debugger::paused(PassRefPtr<TypeBuilder::Array<TypeBuilder::Debugger::CallFrame> > callFrames, Reason::Enum reason, PassRefPtr<InspectorObject> data)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Debugger.paused");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("callFrames", callFrames);
    paramsObject->setString("reason", TypeBuilder::getEnumConstantValue(reason));
    if (data)
        paramsObject->setValue("data", data);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Debugger::resumed()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Debugger.resumed");
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

#endif // ENABLE(JAVASCRIPT_DEBUGGER)

#if ENABLE(JAVASCRIPT_DEBUGGER)

void InspectorFrontend::Profiler::addProfileHeader(PassRefPtr<TypeBuilder::Profiler::ProfileHeader> header)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Profiler.addProfileHeader");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("header", header);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Profiler::addHeapSnapshotChunk(int uid, const String& chunk)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Profiler.addHeapSnapshotChunk");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("uid", uid);
    paramsObject->setString("chunk", chunk);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Profiler::finishHeapSnapshot(int uid)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Profiler.finishHeapSnapshot");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("uid", uid);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Profiler::setRecordingProfile(bool isProfiling)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Profiler.setRecordingProfile");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setBoolean("isProfiling", isProfiling);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Profiler::resetProfiles()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Profiler.resetProfiles");
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Profiler::reportHeapSnapshotProgress(int done, int total)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Profiler.reportHeapSnapshotProgress");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("done", done);
    paramsObject->setNumber("total", total);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

#endif // ENABLE(JAVASCRIPT_DEBUGGER)

void InspectorFrontend::HeapProfiler::addProfileHeader(PassRefPtr<TypeBuilder::HeapProfiler::ProfileHeader> header)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "HeapProfiler.addProfileHeader");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setValue("header", header);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::HeapProfiler::addHeapSnapshotChunk(int uid, const String& chunk)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "HeapProfiler.addHeapSnapshotChunk");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("uid", uid);
    paramsObject->setString("chunk", chunk);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::HeapProfiler::finishHeapSnapshot(int uid)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "HeapProfiler.finishHeapSnapshot");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("uid", uid);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::HeapProfiler::resetProfiles()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "HeapProfiler.resetProfiles");
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::HeapProfiler::reportHeapSnapshotProgress(int done, int total)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "HeapProfiler.reportHeapSnapshotProgress");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("done", done);
    paramsObject->setNumber("total", total);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

#if ENABLE(WORKERS)

void InspectorFrontend::Worker::workerCreated(int workerId, const String& url, bool inspectorConnected)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Worker.workerCreated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("workerId", workerId);
    paramsObject->setString("url", url);
    paramsObject->setBoolean("inspectorConnected", inspectorConnected);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Worker::workerTerminated(int workerId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Worker.workerTerminated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("workerId", workerId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Worker::dispatchMessageFromWorker(int workerId, PassRefPtr<InspectorObject> message)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Worker.dispatchMessageFromWorker");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setNumber("workerId", workerId);
    paramsObject->setValue("message", message);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Worker::disconnectedFromWorker()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Worker.disconnectedFromWorker");
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

#endif // ENABLE(WORKERS)

void InspectorFrontend::Canvas::contextCreated(const TypeBuilder::Network::FrameId& frameId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Canvas.contextCreated");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    paramsObject->setString("frameId", frameId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::Canvas::traceLogsRemoved(const TypeBuilder::Network::FrameId* const frameId, const TypeBuilder::Canvas::TraceLogId* const traceLogId)
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "Canvas.traceLogsRemoved");
    RefPtr<InspectorObject> paramsObject = InspectorObject::create();
    if (frameId)
        paramsObject->setString("frameId", *frameId);
    if (traceLogId)
        paramsObject->setString("traceLogId", *traceLogId);
    jsonMessage->setObject("params", paramsObject);
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}

void InspectorFrontend::LayerTree::layerTreeDidChange()
{
    RefPtr<InspectorObject> jsonMessage = InspectorObject::create();
    jsonMessage->setString("method", "LayerTree.layerTreeDidChange");
    if (m_inspectorFrontendChannel)
        m_inspectorFrontendChannel->sendMessageToFrontend(jsonMessage->toJSONString());
}


} // namespace WebCore

#endif // ENABLE(INSPECTOR)
