/* i386-darwin.macho-entry.h
   created from i386-darwin.macho-entry.bin, 8962 (0x2302) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_DARWIN_MACHO_ENTRY_SIZE    8962
#define STUB_I386_DARWIN_MACHO_ENTRY_ADLER32 0x7ff29f11
#define STUB_I386_DARWIN_MACHO_ENTRY_CRC32   0x1d524bc5

unsigned char stub_i386_darwin_macho_entry[8962] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 148, 26,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,232,252,255,255,255, 89,  0,131,124, 36, 16, 73,
/* 0x0040 */ 117, 79, 85,137,229, 83, 86, 87,139,117,  8,139, 77, 12,139, 85,
/* 0x0050 */  16,141, 76, 14,253,137,243,235, 45, 57,206,115, 48, 86, 94,172,
/* 0x0060 */  60,128,114, 10, 60,143,119,  6,128,126,254, 15,116,  6, 44,232,
/* 0x0070 */  60,  1,119,229, 57,206,115, 21, 86,173, 40,208,117,224, 95, 15,
/* 0x0080 */ 200, 41,248,  1,216,171, 57,206,115,  3,172,235,225, 95, 94, 91,
/* 0x0090 */  93,195, 96,139,116, 36, 36,139, 76, 36, 40,  1,241,137, 76, 36,
/* 0x00a0 */  36,139,124, 36, 44, 49,219, 49,201,131,205,255,235, 70,  1,219,
/* 0x00b0 */ 116,  2,243,195,139, 30,131,238,252, 17,219,138, 22,243,195,141,
/* 0x00c0 */   4, 47,131,249,  5,138, 16,118, 30,131,253,252,119, 25,131,233,
/* 0x00d0 */   4,139, 16,131,192,  4,131,233,  4,137, 23,141,127,  4,115,241,
/* 0x00e0 */ 131,193,  4,138, 16,116, 11, 64,136, 23, 73,138, 16,141,127,  1,
/* 0x00f0 */ 117,245,243,195,252,128,124, 36, 52,  8, 15,133,199,  0,  0,  0,
/* 0x0100 */ 235,  4, 70,136, 23, 71,138, 22,  1,219,117,  9,139, 30,131,238,
/* 0x0110 */ 252, 17,219,138, 22,114,235,106,  1, 88,235, 16, 72,  1,219,117,
/* 0x0120 */   9,139, 30,131,238,252, 17,219,138, 22, 17,192,  1,219,117,  9,
/* 0x0130 */ 139, 30,131,238,252, 17,219,138, 22, 17,192,  1,219,117,  9,139,
/* 0x0140 */  30,131,238,252, 17,219,138, 22,115,210,131,232,  3,114, 26,193,
/* 0x0150 */ 224,  8, 15,182,210,  9,208, 70,131,240,255, 15,132,252,255,255,
/* 0x0160 */ 255,209,248,137,197,114, 62,235, 13,  1,219,117,  7,139, 30,131,
/* 0x0170 */ 238,252, 17,219,114, 47, 65,  1,219,117,  7,139, 30,131,238,252,
/* 0x0180 */  17,219,114, 33,  1,219,117,  9,139, 30,131,238,252, 17,219,138,
/* 0x0190 */  22, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,228,
/* 0x01a0 */ 131,193,  2,235, 15,  1,219,117,  9,139, 30,131,238,252, 17,219,
/* 0x01b0 */ 138, 22, 17,201,129,253,  0,251,255,255,131,209,  2,232,130,  0,
/* 0x01c0 */   0,  0,233, 63,255,255,255, 87, 94,128,124, 36, 52,  5, 15,133,
/* 0x01d0 */ 186,  0,  0,  0,235,  4, 70,136, 23, 71,138, 22,  1,219,117,  9,
/* 0x01e0 */ 139, 30,131,238,252, 17,219,138, 22,114,235,106,  1, 88,235, 16,
/* 0x01f0 */  72,  1,219,117,  9,139, 30,131,238,252, 17,219,138, 22, 17,192,
/* 0x0200 */   1,219,117,  9,139, 30,131,238,252, 17,219,138, 22, 17,192,  1,
/* 0x0210 */ 219,117,  9,139, 30,131,238,252, 17,219,138, 22,115,210,131,232,
/* 0x0220 */   3,114, 24,193,224,  8, 15,182,210,  9,208, 70,131,240,255, 15,
/* 0x0230 */ 132,252,255,255,255,209,248,137,197,235, 13,  1,219,117,  9,139,
/* 0x0240 */  30,131,238,252, 17,219,138, 22, 17,201,  1,219,117,  9,139, 30,
/* 0x0250 */ 131,238,252, 17,219,138, 22, 17,201,117, 32, 65,  1,219,117,  9,
/* 0x0260 */ 139, 30,131,238,252, 17,219,138, 22, 17,201,  1,219,117,  7,139,
/* 0x0270 */  30,131,238,252, 17,219,115,228,131,193,  2,129,253,  0,251,255,
/* 0x0280 */ 255,131,209,  1,232,130,  0,  0,  0,233, 76,255,255,255, 87, 94,
/* 0x0290 */ 128,124, 36, 52,  2, 15,133,167,  0,  0,  0,235,  4, 70,136, 23,
/* 0x02a0 */  71,138, 22,  1,219,117,  9,139, 30,131,238,252, 17,219,138, 22,
/* 0x02b0 */ 114,235,106,  1, 88,  1,219,117,  9,139, 30,131,238,252, 17,219,
/* 0x02c0 */ 138, 22, 17,192,  1,219,117,  9,139, 30,131,238,252, 17,219,138,
/* 0x02d0 */  22,115,226,131,232,  3,114, 20,193,224,  8, 15,182,210,  9,208,
/* 0x02e0 */  70,131,240,255, 15,132,252,255,255,255,137,197,106,  1, 88,  1,
/* 0x02f0 */ 219,117,  9,139, 30,131,238,252, 17,219,138, 22, 17,201,  1,219,
/* 0x0300 */ 117,  9,139, 30,131,238,252, 17,219,138, 22, 17,201,117, 33,137,
/* 0x0310 */ 193,131,192,  2,  1,219,117,  9,139, 30,131,238,252, 17,219,138,
/* 0x0320 */  22, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,228,
/* 0x0330 */ 129,253,  0,243,255,255, 17,193,232,130,  0,  0,  0,233, 95,255,
/* 0x0340 */ 255,255,137,229,141,156, 36,  0,  0,  0,  0, 49,192, 80, 57,220,
/* 0x0350 */ 117,251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,195,  4, 83,104,
/* 0x0360 */   0,  0,  0,  0, 86,131,195,  4, 83, 80,199,  3,  0,  0,  0,  0,
/* 0x0370 */ 137,229,139, 85, 40,172, 74,136,193, 36,  7,192,233,  3,187,  0,
/* 0x0380 */ 253,255,255,211,227,141,164, 92,144,241,255,255,131,228,224,106,
/* 0x0390 */   0,106,  0,137,227, 83,131,195,  4,139, 77, 48,255, 49, 87, 83,
/* 0x03a0 */ 131,195,  4,136, 67,  2,172, 74,136,193, 36, 15,136,  3,192,233,
/* 0x03b0 */   4,136, 75,  1, 82, 86, 83, 80, 85, 87, 86, 83,131,236,124,139,
/* 0x03c0 */ 148, 36,144,  0,  0,  0,199, 68, 36,116,  0,  0,  0,  0,198, 68,
/* 0x03d0 */  36,115,  0,139,172, 36,156,  0,  0,  0,141, 66,  4,137, 68, 36,
/* 0x03e0 */ 120,184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217,
/* 0x03f0 */  73,137, 76, 36,108, 15,182, 74,  1,211,224, 72,137, 68, 36,104,
/* 0x0400 */ 139,132, 36,168,  0,  0,  0, 15,182, 50,199, 69,  0,  0,  0,  0,
/* 0x0410 */   0,199, 68, 36, 96,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,
/* 0x0420 */   0,  3,  0,  0,137,116, 36,100,199, 68, 36, 92,  1,  0,  0,  0,
/* 0x0430 */ 199, 68, 36, 88,  1,  0,  0,  0,199, 68, 36, 84,  1,  0,  0,  0,
/* 0x0440 */ 199, 68, 36, 80,  1,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,
/* 0x0450 */ 141,136, 54,  7,  0,  0, 57, 76, 36,116,115, 14,139, 68, 36,120,
/* 0x0460 */ 102,199,  0,  0,  4,131,192,  2,226,246,139,156, 36,148,  0,  0,
/* 0x0470 */   0, 49,255,199, 68, 36, 72,255,255,255,255,137,218,  3,148, 36,
/* 0x0480 */ 152,  0,  0,  0,137, 84, 36, 76, 49,210, 59, 92, 36, 76, 15,132,
/* 0x0490 */ 124,  9,  0,  0, 15,182,  3,193,231,  8, 66, 67,  9,199,131,250,
/* 0x04a0 */   4,126,231,139,140, 36,164,  0,  0,  0, 57, 76, 36,116, 15,131,
/* 0x04b0 */ 100,  9,  0,  0,139,116, 36,116, 35,116, 36,108,139, 68, 36, 96,
/* 0x04c0 */ 139, 84, 36,120,193,224,  4,137,116, 36, 68,  1,240,129,124, 36,
/* 0x04d0 */  72,255,255,255,  0,141, 44, 66,119, 24, 59, 92, 36, 76, 15,132,
/* 0x04e0 */  44,  9,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,
/* 0x04f0 */   9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,183,202,
/* 0x0500 */  15,175,193, 57,199, 15,131,221,  1,  0,  0,137, 68, 36, 72,184,
/* 0x0510 */   0,  8,  0,  0, 41,200,138, 76, 36,100,193,248,  5,190,  1,  0,
/* 0x0520 */   0,  0,141,  4,  2, 15,182, 84, 36,115,102,137, 69,  0,139, 68,
/* 0x0530 */  36,116, 35, 68, 36,104,139,108, 36,120,211,224,185,  8,  0,  0,
/* 0x0540 */   0, 43, 76, 36,100,211,250,  1,208,105,192,  0,  6,  0,  0,131,
/* 0x0550 */ 124, 36, 96,  6,141,132,  5,108, 14,  0,  0,137, 68, 36, 20, 15,
/* 0x0560 */ 142,202,  0,  0,  0,139, 68, 36,116, 43, 68, 36, 92,139,148, 36,
/* 0x0570 */ 160,  0,  0,  0, 15,182,  4,  2,137, 68, 36, 64,209,100, 36, 64,
/* 0x0580 */ 139, 76, 36, 64,141, 20, 54,139,108, 36, 20,129,225,  0,  1,  0,
/* 0x0590 */   0,129,124, 36, 72,255,255,255,  0,141, 68, 77,  0,137, 76, 36,
/* 0x05a0 */  60,141, 44, 16,119, 24, 59, 92, 36, 76, 15,132, 96,  8,  0,  0,
/* 0x05b0 */ 193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68,
/* 0x05c0 */  36, 72,102,139,141,  0,  2,  0,  0,193,232, 11, 15,183,241, 15,
/* 0x05d0 */ 175,198, 57,199,115, 35,137, 68, 36, 72,184,  0,  8,  0,  0, 41,
/* 0x05e0 */ 240,137,214,193,248,  5,131,124, 36, 60,  0,141,  4,  1,102,137,
/* 0x05f0 */ 133,  0,  2,  0,  0,116, 34,235, 46, 41, 68, 36, 72, 41,199,137,
/* 0x0600 */ 200,141,114,  1,102,193,232,  5,102, 41,193,131,124, 36, 60,  0,
/* 0x0610 */ 102,137,141,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,
/* 0x0620 */ 142, 87,255,255,255,235,121,129,254,255,  0,  0,  0,127,113,141,
/* 0x0630 */  20, 54,139,108, 36, 20,  1,213,129,124, 36, 72,255,255,255,  0,
/* 0x0640 */ 119, 24, 59, 92, 36, 76, 15,132,196,  7,  0,  0,193,100, 36, 72,
/* 0x0650 */   8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,
/* 0x0660 */  77,  0,193,232, 11, 15,183,241, 15,175,198, 57,199,115, 25,137,
/* 0x0670 */  68, 36, 72,184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,141,
/* 0x0680 */   4,  1,102,137, 69,  0,235,159, 41, 68, 36, 72, 41,199,137,200,
/* 0x0690 */ 141,114,  1,102,193,232,  5,102, 41,193,102,137, 77,  0,235,135,
/* 0x06a0 */ 139, 84, 36,116,137,240,139,140, 36,160,  0,  0,  0,136, 68, 36,
/* 0x06b0 */ 115,136,  4, 10, 66,131,124, 36, 96,  3,137, 84, 36,116,127, 13,
/* 0x06c0 */ 199, 68, 36, 96,  0,  0,  0,  0,233, 27,  7,  0,  0,131,124, 36,
/* 0x06d0 */  96,  9,127, 10,131,108, 36, 96,  3,233, 10,  7,  0,  0,131,108,
/* 0x06e0 */  36, 96,  6,233,  0,  7,  0,  0,139, 76, 36, 72, 41,199,139,116,
/* 0x06f0 */  36, 96, 41,193,137,208,102,193,232,  5,102, 41,194,129,249,255,
/* 0x0700 */ 255,255,  0,102,137, 85,  0,139,108, 36,120,141,116,117,  0,137,
/* 0x0710 */ 116, 36, 56,119, 22, 59, 92, 36, 76, 15,132,241,  6,  0,  0, 15,
/* 0x0720 */ 182,  3,193,231,  8,193,225,  8, 67,  9,199,139,108, 36, 56,137,
/* 0x0730 */ 200,193,232, 11,102,139,149,128,  1,  0,  0, 15,183,234, 15,175,
/* 0x0740 */ 197, 57,199,115, 82,137,198,184,  0,  8,  0,  0, 41,232,139,108,
/* 0x0750 */  36, 88,193,248,  5,139, 76, 36, 84,141,  4,  2,139, 84, 36, 56,
/* 0x0760 */ 137, 76, 36, 80,139, 76, 36,120,102,137,130,128,  1,  0,  0,139,
/* 0x0770 */  68, 36, 92,137,108, 36, 84,137, 68, 36, 88, 49,192,131,124, 36,
/* 0x0780 */  96,  6, 15,159,192,129,193,100,  6,  0,  0,141,  4, 64,137, 68,
/* 0x0790 */  36, 96,233,116,  2,  0,  0,137,206, 41,199, 41,198,137,208,102,
/* 0x07a0 */ 193,232,  5,139, 76, 36, 56,102, 41,194,129,254,255,255,255,  0,
/* 0x07b0 */ 102,137,145,128,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 77,
/* 0x07c0 */   6,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139,
/* 0x07d0 */ 108, 36, 56,137,242,193,234, 11,102,139,141,152,  1,  0,  0, 15,
/* 0x07e0 */ 183,193, 15,175,208, 57,215, 15,131,227,  0,  0,  0,189,  0,  8,
/* 0x07f0 */   0,  0,137,214, 41,197,199, 68, 36, 52,  0,  8,  0,  0,137,232,
/* 0x0800 */ 193,248,  5,141,  4,  1,139, 76, 36, 56,102,137,129,152,  1,  0,
/* 0x0810 */   0,139, 68, 36, 96,139, 76, 36, 68,193,224,  5,  3, 68, 36,120,
/* 0x0820 */ 129,250,255,255,255,  0,141, 44, 72,119, 22, 59, 92, 36, 76, 15,
/* 0x0830 */ 132,219,  5,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,
/* 0x0840 */ 199,102,139,149,224,  1,  0,  0,137,240,193,232, 11, 15,183,202,
/* 0x0850 */  15,175,193, 57,199,115, 96, 41, 76, 36, 52,193,124, 36, 52,  5,
/* 0x0860 */ 139,116, 36, 52,137, 68, 36, 72,131,124, 36,116,  0,141,  4, 50,
/* 0x0870 */ 102,137,133,224,  1,  0,  0, 15,132,147,  5,  0,  0, 49,192,131,
/* 0x0880 */ 124, 36, 96,  6,139,172, 36,160,  0,  0,  0,139, 84, 36,116, 15,
/* 0x0890 */ 159,192,141, 68,  0,  9,137, 68, 36, 96,139, 68, 36,116, 43, 68,
/* 0x08a0 */  36, 92,138, 68,  5,  0,136, 68, 36,115,136,  4, 42, 66,137, 84,
/* 0x08b0 */  36,116,233, 49,  5,  0,  0, 41,198, 41,199,137,208,102,193,232,
/* 0x08c0 */   5,102, 41,194,102,137,149,224,  1,  0,  0,233, 31,  1,  0,  0,
/* 0x08d0 */ 137,200, 41,214,102,193,232,  5,139,108, 36, 56,102, 41,193, 41,
/* 0x08e0 */ 215,129,254,255,255,255,  0,102,137,141,152,  1,  0,  0,119, 22,
/* 0x08f0 */  59, 92, 36, 76, 15,132, 22,  5,  0,  0, 15,182,  3,193,231,  8,
/* 0x0900 */ 193,230,  8, 67,  9,199,139, 76, 36, 56,137,240,193,232, 11,102,
/* 0x0910 */ 139,145,176,  1,  0,  0, 15,183,202, 15,175,193, 57,199,115, 35,
/* 0x0920 */ 137,198,184,  0,  8,  0,  0, 41,200,139,108, 36, 56,193,248,  5,
/* 0x0930 */ 141,  4,  2,102,137,133,176,  1,  0,  0,139, 68, 36, 88,233,160,
/* 0x0940 */   0,  0,  0,137,241, 41,199, 41,193,137,208,102,193,232,  5,102,
/* 0x0950 */  41,194,139, 68, 36, 56,129,249,255,255,255,  0,102,137,144,176,
/* 0x0960 */   1,  0,  0,119, 22, 59, 92, 36, 76, 15,132,161,  4,  0,  0, 15,
/* 0x0970 */ 182,  3,193,231,  8,193,225,  8, 67,  9,199,139,116, 36, 56,137,
/* 0x0980 */ 200,193,232, 11,102,139,150,200,  1,  0,  0, 15,183,234, 15,175,
/* 0x0990 */ 197, 57,199,115, 32,137,198,184,  0,  8,  0,  0, 41,232,139,108,
/* 0x09a0 */  36, 56,193,248,  5,141,  4,  2,102,137,133,200,  1,  0,  0,139,
/* 0x09b0 */  68, 36, 84,235, 38,137,206, 41,199, 41,198,137,208,102,193,232,
/* 0x09c0 */   5,102, 41,194,139, 68, 36, 56,102,137,144,200,  1,  0,  0,139,
/* 0x09d0 */  84, 36, 84,139, 68, 36, 80,137, 84, 36, 80,139, 76, 36, 88,137,
/* 0x09e0 */  76, 36, 84,139,108, 36, 92,137, 68, 36, 92,137,108, 36, 88, 49,
/* 0x09f0 */ 192,131,124, 36, 96,  6,139, 76, 36,120, 15,159,192,129,193,104,
/* 0x0a00 */  10,  0,  0,141, 68, 64,  8,137, 68, 36, 96,129,254,255,255,255,
/* 0x0a10 */   0,119, 22, 59, 92, 36, 76, 15,132,243,  3,  0,  0, 15,182,  3,
/* 0x0a20 */ 193,231,  8,193,230,  8, 67,  9,199,102,139, 17,137,240,193,232,
/* 0x0a30 */  11, 15,183,234, 15,175,197, 57,199,115, 47,137, 68, 36, 72,184,
/* 0x0a40 */   0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68,
/* 0x0a50 */  36, 44,  0,  0,  0,  0,141,  4,  2,102,137,  1,139, 68, 36, 68,
/* 0x0a60 */ 141, 76,  1,  4,137, 76, 36, 16,235,114, 41,198, 41,199,137,208,
/* 0x0a70 */ 102,193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137, 17,
/* 0x0a80 */ 119, 22, 59, 92, 36, 76, 15,132,132,  3,  0,  0, 15,182,  3,193,
/* 0x0a90 */ 231,  8,193,230,  8, 67,  9,199,102,139, 81,  2,137,240,193,232,
/* 0x0aa0 */  11, 15,183,234, 15,175,197, 57,199,115, 59,137, 68, 36, 72,184,
/* 0x0ab0 */   0,  8,  0,  0, 41,232,193,100, 36, 68,  4,193,248,  5,199, 68,
/* 0x0ac0 */  36, 44,  8,  0,  0,  0,141,  4,  2,139, 84, 36, 68,102,137, 65,
/* 0x0ad0 */   2,141,140, 17,  4,  1,  0,  0,137, 76, 36, 16,199, 68, 36, 48,
/* 0x0ae0 */   3,  0,  0,  0,235, 47, 41,198, 41,199,137,208,137,116, 36, 72,
/* 0x0af0 */ 102,193,232,  5,199, 68, 36, 44, 16,  0,  0,  0,102, 41,194,199,
/* 0x0b00 */  68, 36, 48,  8,  0,  0,  0,102,137, 81,  2,129,193,  4,  2,  0,
/* 0x0b10 */   0,137, 76, 36, 16,139, 76, 36, 48,186,  1,  0,  0,  0,137, 76,
/* 0x0b20 */  36, 40,141, 44, 18,139,116, 36, 16,  1,238,129,124, 36, 72,255,
/* 0x0b30 */ 255,255,  0,119, 24, 59, 92, 36, 76, 15,132,209,  2,  0,  0,193,
/* 0x0b40 */ 100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36,
/* 0x0b50 */  72,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57,199,115,
/* 0x0b60 */  24,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,
/* 0x0b70 */   4,  2,137,234,102,137,  6,235, 21, 41, 68, 36, 72, 41,199,137,
/* 0x0b80 */ 208,102,193,232,  5,102, 41,194,102,137, 22,141, 85,  1,139,116,
/* 0x0b90 */  36, 40, 78,137,116, 36, 40,117,137,138, 76, 36, 48,184,  1,  0,
/* 0x0ba0 */   0,  0,211,224, 41,194,  3, 84, 36, 44,131,124, 36, 96,  3,137,
/* 0x0bb0 */  84, 36, 12, 15,143,231,  1,  0,  0,131, 68, 36, 96,  7,131,250,
/* 0x0bc0 */   3,137,208,126,  5,184,  3,  0,  0,  0,139,116, 36,120,193,224,
/* 0x0bd0 */   7,199, 68, 36, 36,  6,  0,  0,  0,141,132,  6, 96,  3,  0,  0,
/* 0x0be0 */ 137, 68, 36,  8,184,  1,  0,  0,  0,141, 44,  0,139,116, 36,  8,
/* 0x0bf0 */   1,238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76,
/* 0x0c00 */  15,132, 10,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,
/* 0x0c10 */   8, 67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,
/* 0x0c20 */ 202, 15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,
/* 0x0c30 */   0, 41,200,193,248,  5,141,  4,  2,102,137,  6,137,232,235, 21,
/* 0x0c40 */  41, 68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,141,
/* 0x0c50 */  69,  1,102,137, 22,139,108, 36, 36, 77,137,108, 36, 36,117,137,
/* 0x0c60 */ 141, 80,192,131,250,  3,137, 20, 36, 15,142, 39,  1,  0,  0,137,
/* 0x0c70 */ 208,137,214,209,248,131,230,  1,141, 72,255,131,206,  2,131,250,
/* 0x0c80 */  13,137, 76, 36, 32,127, 28,139,108, 36,120,211,230,  1,210,137,
/* 0x0c90 */  52, 36,141, 68,117,  0, 41,208,  5, 94,  5,  0,  0,137, 68, 36,
/* 0x0ca0 */   4,235, 86,141, 80,251,129,124, 36, 72,255,255,255,  0,119, 24,
/* 0x0cb0 */  59, 92, 36, 76, 15,132, 86,  1,  0,  0,193,100, 36, 72,  8, 15,
/* 0x0cc0 */ 182,  3,193,231,  8, 67,  9,199,209,108, 36, 72,  1,246, 59,124,
/* 0x0cd0 */  36, 72,114,  7, 43,124, 36, 72,131,206,  1, 74,117,200,139, 68,
/* 0x0ce0 */  36,120,193,230,  4,137, 52, 36,  5, 68,  6,  0,  0,199, 68, 36,
/* 0x0cf0 */  32,  4,  0,  0,  0,137, 68, 36,  4,199, 68, 36, 28,  1,  0,  0,
/* 0x0d00 */   0,184,  1,  0,  0,  0,139,108, 36,  4,  1,192,137, 68, 36, 24,
/* 0x0d10 */   1,197,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76,
/* 0x0d20 */  15,132,234,  0,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,
/* 0x0d30 */   8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,193,232, 11, 15,
/* 0x0d40 */ 183,242, 15,175,198, 57,199,115, 27,137, 68, 36, 72,184,  0,  8,
/* 0x0d50 */   0,  0, 41,240,193,248,  5,141,  4,  2,102,137, 69,  0,139, 68,
/* 0x0d60 */  36, 24,235, 31, 41, 68, 36, 72, 41,199,137,208,102,193,232,  5,
/* 0x0d70 */ 102, 41,194,139, 68, 36, 24,102,137, 85,  0,139, 84, 36, 28, 64,
/* 0x0d80 */   9, 20, 36,139, 76, 36, 32,209,100, 36, 28, 73,137, 76, 36, 32,
/* 0x0d90 */  15,133,112,255,255,255,139, 52, 36, 70,137,116, 36, 92,116, 89,
/* 0x0da0 */ 139, 76, 36, 12,139,108, 36,116,131,193,  2, 57,108, 36, 92,119,
/* 0x0db0 */  95,139,132, 36,160,  0,  0,  0,137,234, 43, 68, 36, 92,  3,148,
/* 0x0dc0 */  36,160,  0,  0,  0,141, 52, 40,138,  6, 70,136, 68, 36,115,136,
/* 0x0dd0 */   2, 66,255, 68, 36,116, 73,116, 15,139,172, 36,164,  0,  0,  0,
/* 0x0de0 */  57,108, 36,116,114,226,235, 17,139,132, 36,164,  0,  0,  0, 57,
/* 0x0df0 */  68, 36,116, 15,130,187,246,255,255,129,124, 36, 72,255,255,255,
/* 0x0e00 */   0,119, 21, 59, 92, 36, 76,184,  1,  0,  0,  0,116, 41,235,  7,
/* 0x0e10 */ 184,  1,  0,  0,  0,235, 32, 67, 43,156, 36,148,  0,  0,  0, 49,
/* 0x0e20 */ 192,139,148, 36,156,  0,  0,  0,139, 76, 36,116,137, 26,139,156,
/* 0x0e30 */  36,168,  0,  0,  0,137, 11,131,196,124, 91, 94, 95, 93, 85, 87,
/* 0x0e40 */  86, 83,131,236,124,139,148, 36,144,  0,  0,  0,199, 68, 36,116,
/* 0x0e50 */   0,  0,  0,  0,198, 68, 36,115,  0,139,172, 36,156,  0,  0,  0,
/* 0x0e60 */ 141, 66,  4,137, 68, 36,120,184,  1,  0,  0,  0, 15,182, 74,  2,
/* 0x0e70 */ 137,195,211,227,137,217, 73,137, 76, 36,108, 15,182, 74,  1,211,
/* 0x0e80 */ 224, 72,137, 68, 36,104,139,132, 36,168,  0,  0,  0, 15,182, 50,
/* 0x0e90 */ 199, 69,  0,  0,  0,  0,  0,199, 68, 36, 96,  0,  0,  0,  0,199,
/* 0x0ea0 */   0,  0,  0,  0,  0,184,  0,  3,  0,  0,137,116, 36,100,199, 68,
/* 0x0eb0 */  36, 92,  1,  0,  0,  0,199, 68, 36, 88,  1,  0,  0,  0,199, 68,
/* 0x0ec0 */  36, 84,  1,  0,  0,  0,199, 68, 36, 80,  1,  0,  0,  0, 15,182,
/* 0x0ed0 */  74,  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36,116,
/* 0x0ee0 */ 115, 14,139, 68, 36,120,102,199,  0,  0,  4,131,192,  2,226,246,
/* 0x0ef0 */ 139,156, 36,148,  0,  0,  0, 49,255,199, 68, 36, 72,255,255,255,
/* 0x0f00 */ 255,137,218,  3,148, 36,152,  0,  0,  0,137, 84, 36, 76, 49,210,
/* 0x0f10 */  59, 92, 36, 76, 15,132,124,  9,  0,  0, 15,182,  3,193,231,  8,
/* 0x0f20 */  66, 67,  9,199,131,250,  4,126,231,139,140, 36,164,  0,  0,  0,
/* 0x0f30 */  57, 76, 36,116, 15,131,100,  9,  0,  0,139,116, 36,116, 35,116,
/* 0x0f40 */  36,108,139, 68, 36, 96,139, 84, 36,120,193,224,  4,137,116, 36,
/* 0x0f50 */  68,  1,240,129,124, 36, 72,255,255,255,  0,141, 44, 66,119, 24,
/* 0x0f60 */  59, 92, 36, 76, 15,132, 44,  9,  0,  0,193,100, 36, 72,  8, 15,
/* 0x0f70 */ 182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139, 85,  0,
/* 0x0f80 */ 193,232, 11, 15,183,202, 15,175,193, 57,199, 15,131,221,  1,  0,
/* 0x0f90 */   0,137, 68, 36, 72,184,  0,  8,  0,  0, 41,200,138, 76, 36,100,
/* 0x0fa0 */ 193,248,  5,190,  1,  0,  0,  0,141,  4,  2, 15,182, 84, 36,115,
/* 0x0fb0 */ 102,137, 69,  0,139, 68, 36,116, 35, 68, 36,104,139,108, 36,120,
/* 0x0fc0 */ 211,224,185,  8,  0,  0,  0, 43, 76, 36,100,211,250,  1,208,105,
/* 0x0fd0 */ 192,  0,  6,  0,  0,131,124, 36, 96,  6,141,132,  5,108, 14,  0,
/* 0x0fe0 */   0,137, 68, 36, 20, 15,142,202,  0,  0,  0,139, 68, 36,116, 43,
/* 0x0ff0 */  68, 36, 92,139,148, 36,160,  0,  0,  0, 15,182,  4,  2,137, 68,
/* 0x1000 */  36, 64,209,100, 36, 64,139, 76, 36, 64,141, 20, 54,139,108, 36,
/* 0x1010 */  20,129,225,  0,  1,  0,  0,129,124, 36, 72,255,255,255,  0,141,
/* 0x1020 */  68, 77,  0,137, 76, 36, 60,141, 44, 16,119, 24, 59, 92, 36, 76,
/* 0x1030 */  15,132, 96,  8,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,
/* 0x1040 */   8, 67,  9,199,139, 68, 36, 72,102,139,141,  0,  2,  0,  0,193,
/* 0x1050 */ 232, 11, 15,183,241, 15,175,198, 57,199,115, 35,137, 68, 36, 72,
/* 0x1060 */ 184,  0,  8,  0,  0, 41,240,137,214,193,248,  5,131,124, 36, 60,
/* 0x1070 */   0,141,  4,  1,102,137,133,  0,  2,  0,  0,116, 34,235, 46, 41,
/* 0x1080 */  68, 36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,
/* 0x1090 */ 193,131,124, 36, 60,  0,102,137,141,  0,  2,  0,  0,116, 14,129,
/* 0x10a0 */ 254,255,  0,  0,  0, 15,142, 87,255,255,255,235,121,129,254,255,
/* 0x10b0 */   0,  0,  0,127,113,141, 20, 54,139,108, 36, 20,  1,213,129,124,
/* 0x10c0 */  36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132,196,  7,
/* 0x10d0 */   0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,
/* 0x10e0 */ 139, 68, 36, 72,102,139, 77,  0,193,232, 11, 15,183,241, 15,175,
/* 0x10f0 */ 198, 57,199,115, 25,137, 68, 36, 72,184,  0,  8,  0,  0, 41,240,
/* 0x1100 */ 137,214,193,248,  5,141,  4,  1,102,137, 69,  0,235,159, 41, 68,
/* 0x1110 */  36, 72, 41,199,137,200,141,114,  1,102,193,232,  5,102, 41,193,
/* 0x1120 */ 102,137, 77,  0,235,135,139, 84, 36,116,137,240,139,140, 36,160,
/* 0x1130 */   0,  0,  0,136, 68, 36,115,136,  4, 10, 66,131,124, 36, 96,  3,
/* 0x1140 */ 137, 84, 36,116,127, 13,199, 68, 36, 96,  0,  0,  0,  0,233, 27,
/* 0x1150 */   7,  0,  0,131,124, 36, 96,  9,127, 10,131,108, 36, 96,  3,233,
/* 0x1160 */  10,  7,  0,  0,131,108, 36, 96,  6,233,  0,  7,  0,  0,139, 76,
/* 0x1170 */  36, 72, 41,199,139,116, 36, 96, 41,193,137,208,102,193,232,  5,
/* 0x1180 */ 102, 41,194,129,249,255,255,255,  0,102,137, 85,  0,139,108, 36,
/* 0x1190 */ 120,141,116,117,  0,137,116, 36, 56,119, 22, 59, 92, 36, 76, 15,
/* 0x11a0 */ 132,241,  6,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,
/* 0x11b0 */ 199,139,108, 36, 56,137,200,193,232, 11,102,139,149,128,  1,  0,
/* 0x11c0 */   0, 15,183,234, 15,175,197, 57,199,115, 82,137,198,184,  0,  8,
/* 0x11d0 */   0,  0, 41,232,139,108, 36, 88,193,248,  5,139, 76, 36, 84,141,
/* 0x11e0 */   4,  2,139, 84, 36, 56,137, 76, 36, 80,139, 76, 36,120,102,137,
/* 0x11f0 */ 130,128,  1,  0,  0,139, 68, 36, 92,137,108, 36, 84,137, 68, 36,
/* 0x1200 */  88, 49,192,131,124, 36, 96,  6, 15,159,192,129,193,100,  6,  0,
/* 0x1210 */   0,141,  4, 64,137, 68, 36, 96,233,116,  2,  0,  0,137,206, 41,
/* 0x1220 */ 199, 41,198,137,208,102,193,232,  5,139, 76, 36, 56,102, 41,194,
/* 0x1230 */ 129,254,255,255,255,  0,102,137,145,128,  1,  0,  0,119, 22, 59,
/* 0x1240 */  92, 36, 76, 15,132, 77,  6,  0,  0, 15,182,  3,193,231,  8,193,
/* 0x1250 */ 230,  8, 67,  9,199,139,108, 36, 56,137,242,193,234, 11,102,139,
/* 0x1260 */ 141,152,  1,  0,  0, 15,183,193, 15,175,208, 57,215, 15,131,227,
/* 0x1270 */   0,  0,  0,189,  0,  8,  0,  0,137,214, 41,197,199, 68, 36, 52,
/* 0x1280 */   0,  8,  0,  0,137,232,193,248,  5,141,  4,  1,139, 76, 36, 56,
/* 0x1290 */ 102,137,129,152,  1,  0,  0,139, 68, 36, 96,139, 76, 36, 68,193,
/* 0x12a0 */ 224,  5,  3, 68, 36,120,129,250,255,255,255,  0,141, 44, 72,119,
/* 0x12b0 */  22, 59, 92, 36, 76, 15,132,219,  5,  0,  0, 15,182,  3,193,231,
/* 0x12c0 */   8,193,230,  8, 67,  9,199,102,139,149,224,  1,  0,  0,137,240,
/* 0x12d0 */ 193,232, 11, 15,183,202, 15,175,193, 57,199,115, 96, 41, 76, 36,
/* 0x12e0 */  52,193,124, 36, 52,  5,139,116, 36, 52,137, 68, 36, 72,131,124,
/* 0x12f0 */  36,116,  0,141,  4, 50,102,137,133,224,  1,  0,  0, 15,132,147,
/* 0x1300 */   5,  0,  0, 49,192,131,124, 36, 96,  6,139,172, 36,160,  0,  0,
/* 0x1310 */   0,139, 84, 36,116, 15,159,192,141, 68,  0,  9,137, 68, 36, 96,
/* 0x1320 */ 139, 68, 36,116, 43, 68, 36, 92,138, 68,  5,  0,136, 68, 36,115,
/* 0x1330 */ 136,  4, 42, 66,137, 84, 36,116,233, 49,  5,  0,  0, 41,198, 41,
/* 0x1340 */ 199,137,208,102,193,232,  5,102, 41,194,102,137,149,224,  1,  0,
/* 0x1350 */   0,233, 31,  1,  0,  0,137,200, 41,214,102,193,232,  5,139,108,
/* 0x1360 */  36, 56,102, 41,193, 41,215,129,254,255,255,255,  0,102,137,141,
/* 0x1370 */ 152,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,132, 22,  5,  0,  0,
/* 0x1380 */  15,182,  3,193,231,  8,193,230,  8, 67,  9,199,139, 76, 36, 56,
/* 0x1390 */ 137,240,193,232, 11,102,139,145,176,  1,  0,  0, 15,183,202, 15,
/* 0x13a0 */ 175,193, 57,199,115, 35,137,198,184,  0,  8,  0,  0, 41,200,139,
/* 0x13b0 */ 108, 36, 56,193,248,  5,141,  4,  2,102,137,133,176,  1,  0,  0,
/* 0x13c0 */ 139, 68, 36, 88,233,160,  0,  0,  0,137,241, 41,199, 41,193,137,
/* 0x13d0 */ 208,102,193,232,  5,102, 41,194,139, 68, 36, 56,129,249,255,255,
/* 0x13e0 */ 255,  0,102,137,144,176,  1,  0,  0,119, 22, 59, 92, 36, 76, 15,
/* 0x13f0 */ 132,161,  4,  0,  0, 15,182,  3,193,231,  8,193,225,  8, 67,  9,
/* 0x1400 */ 199,139,116, 36, 56,137,200,193,232, 11,102,139,150,200,  1,  0,
/* 0x1410 */   0, 15,183,234, 15,175,197, 57,199,115, 32,137,198,184,  0,  8,
/* 0x1420 */   0,  0, 41,232,139,108, 36, 56,193,248,  5,141,  4,  2,102,137,
/* 0x1430 */ 133,200,  1,  0,  0,139, 68, 36, 84,235, 38,137,206, 41,199, 41,
/* 0x1440 */ 198,137,208,102,193,232,  5,102, 41,194,139, 68, 36, 56,102,137,
/* 0x1450 */ 144,200,  1,  0,  0,139, 84, 36, 84,139, 68, 36, 80,137, 84, 36,
/* 0x1460 */  80,139, 76, 36, 88,137, 76, 36, 84,139,108, 36, 92,137, 68, 36,
/* 0x1470 */  92,137,108, 36, 88, 49,192,131,124, 36, 96,  6,139, 76, 36,120,
/* 0x1480 */  15,159,192,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,
/* 0x1490 */  96,129,254,255,255,255,  0,119, 22, 59, 92, 36, 76, 15,132,243,
/* 0x14a0 */   3,  0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,
/* 0x14b0 */ 139, 17,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115,
/* 0x14c0 */  47,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,
/* 0x14d0 */   4,193,248,  5,199, 68, 36, 44,  0,  0,  0,  0,141,  4,  2,102,
/* 0x14e0 */ 137,  1,139, 68, 36, 68,141, 76,  1,  4,137, 76, 36, 16,235,114,
/* 0x14f0 */  41,198, 41,199,137,208,102,193,232,  5,102, 41,194,129,254,255,
/* 0x1500 */ 255,255,  0,102,137, 17,119, 22, 59, 92, 36, 76, 15,132,132,  3,
/* 0x1510 */   0,  0, 15,182,  3,193,231,  8,193,230,  8, 67,  9,199,102,139,
/* 0x1520 */  81,  2,137,240,193,232, 11, 15,183,234, 15,175,197, 57,199,115,
/* 0x1530 */  59,137, 68, 36, 72,184,  0,  8,  0,  0, 41,232,193,100, 36, 68,
/* 0x1540 */   4,193,248,  5,199, 68, 36, 44,  8,  0,  0,  0,141,  4,  2,139,
/* 0x1550 */  84, 36, 68,102,137, 65,  2,141,140, 17,  4,  1,  0,  0,137, 76,
/* 0x1560 */  36, 16,199, 68, 36, 48,  3,  0,  0,  0,235, 47, 41,198, 41,199,
/* 0x1570 */ 137,208,137,116, 36, 72,102,193,232,  5,199, 68, 36, 44, 16,  0,
/* 0x1580 */   0,  0,102, 41,194,199, 68, 36, 48,  8,  0,  0,  0,102,137, 81,
/* 0x1590 */   2,129,193,  4,  2,  0,  0,137, 76, 36, 16,139, 76, 36, 48,186,
/* 0x15a0 */   1,  0,  0,  0,137, 76, 36, 40,141, 44, 18,139,116, 36, 16,  1,
/* 0x15b0 */ 238,129,124, 36, 72,255,255,255,  0,119, 24, 59, 92, 36, 76, 15,
/* 0x15c0 */ 132,209,  2,  0,  0,193,100, 36, 72,  8, 15,182,  3,193,231,  8,
/* 0x15d0 */  67,  9,199,139, 68, 36, 72,102,139, 22,193,232, 11, 15,183,202,
/* 0x15e0 */  15,175,193, 57,199,115, 24,137, 68, 36, 72,184,  0,  8,  0,  0,
/* 0x15f0 */  41,200,193,248,  5,141,  4,  2,137,234,102,137,  6,235, 21, 41,
/* 0x1600 */  68, 36, 72, 41,199,137,208,102,193,232,  5,102, 41,194,102,137,
/* 0x1610 */  22,141, 85,  1,139,116, 36, 40, 78,137,116, 36, 40,117,137,138,
/* 0x1620 */  76, 36, 48,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 44,
/* 0x1630 */ 131,124, 36, 96,  3,137, 84, 36, 12, 15,143,231,  1,  0,  0,131,
/* 0x1640 */  68, 36, 96,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,
/* 0x1650 */ 139,116, 36,120,193,224,  7,199, 68, 36, 36,  6,  0,  0,  0,141,
/* 0x1660 */ 132,  6, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,141,
/* 0x1670 */  44,  0,139,116, 36,  8,  1,238,129,124, 36, 72,255,255,255,  0,
/* 0x1680 */ 119, 24, 59, 92, 36, 76, 15,132, 10,  2,  0,  0,193,100, 36, 72,
/* 0x1690 */   8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,
/* 0x16a0 */  22,193,232, 11, 15,183,202, 15,175,193, 57,199,115, 24,137, 68,
/* 0x16b0 */  36, 72,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x16c0 */ 137,  6,137,232,235, 21, 41, 68, 36, 72, 41,199,137,208,102,193,
/* 0x16d0 */ 232,  5,102, 41,194,141, 69,  1,102,137, 22,139,108, 36, 36, 77,
/* 0x16e0 */ 137,108, 36, 36,117,137,141, 80,192,131,250,  3,137, 20, 36, 15,
/* 0x16f0 */ 142, 39,  1,  0,  0,137,208,137,214,209,248,131,230,  1,141, 72,
/* 0x1700 */ 255,131,206,  2,131,250, 13,137, 76, 36, 32,127, 28,139,108, 36,
/* 0x1710 */ 120,211,230,  1,210,137, 52, 36,141, 68,117,  0, 41,208,  5, 94,
/* 0x1720 */   5,  0,  0,137, 68, 36,  4,235, 86,141, 80,251,129,124, 36, 72,
/* 0x1730 */ 255,255,255,  0,119, 24, 59, 92, 36, 76, 15,132, 86,  1,  0,  0,
/* 0x1740 */ 193,100, 36, 72,  8, 15,182,  3,193,231,  8, 67,  9,199,209,108,
/* 0x1750 */  36, 72,  1,246, 59,124, 36, 72,114,  7, 43,124, 36, 72,131,206,
/* 0x1760 */   1, 74,117,200,139, 68, 36,120,193,230,  4,137, 52, 36,  5, 68,
/* 0x1770 */   6,  0,  0,199, 68, 36, 32,  4,  0,  0,  0,137, 68, 36,  4,199,
/* 0x1780 */  68, 36, 28,  1,  0,  0,  0,184,  1,  0,  0,  0,139,108, 36,  4,
/* 0x1790 */   1,192,137, 68, 36, 24,  1,197,129,124, 36, 72,255,255,255,  0,
/* 0x17a0 */ 119, 24, 59, 92, 36, 76, 15,132,234,  0,  0,  0,193,100, 36, 72,
/* 0x17b0 */   8, 15,182,  3,193,231,  8, 67,  9,199,139, 68, 36, 72,102,139,
/* 0x17c0 */  85,  0,193,232, 11, 15,183,242, 15,175,198, 57,199,115, 27,137,
/* 0x17d0 */  68, 36, 72,184,  0,  8,  0,  0, 41,240,193,248,  5,141,  4,  2,
/* 0x17e0 */ 102,137, 69,  0,139, 68, 36, 24,235, 31, 41, 68, 36, 72, 41,199,
/* 0x17f0 */ 137,208,102,193,232,  5,102, 41,194,139, 68, 36, 24,102,137, 85,
/* 0x1800 */   0,139, 84, 36, 28, 64,  9, 20, 36,139, 76, 36, 32,209,100, 36,
/* 0x1810 */  28, 73,137, 76, 36, 32, 15,133,112,255,255,255,139, 52, 36, 70,
/* 0x1820 */ 137,116, 36, 92,116, 89,139, 76, 36, 12,139,108, 36,116,131,193,
/* 0x1830 */   2, 57,108, 36, 92,119, 95,139,132, 36,160,  0,  0,  0,137,234,
/* 0x1840 */  43, 68, 36, 92,  3,148, 36,160,  0,  0,  0,141, 52, 40,138,  6,
/* 0x1850 */  70,136, 68, 36,115,136,  2, 66,255, 68, 36,116, 73,116, 15,139,
/* 0x1860 */ 172, 36,164,  0,  0,  0, 57,108, 36,116,114,226,235, 17,139,132,
/* 0x1870 */  36,164,  0,  0,  0, 57, 68, 36,116, 15,130,187,246,255,255,129,
/* 0x1880 */ 124, 36, 72,255,255,255,  0,119, 21, 59, 92, 36, 76,184,  1,  0,
/* 0x1890 */   0,  0,116, 41,235,  7,184,  1,  0,  0,  0,235, 32, 67, 43,156,
/* 0x18a0 */  36,148,  0,  0,  0, 49,192,139,148, 36,156,  0,  0,  0,139, 76,
/* 0x18b0 */  36,116,137, 26,139,156, 36,168,  0,  0,  0,137, 11,131,196,124,
/* 0x18c0 */  91, 94, 95, 93,  3,115,252,  3,123,248, 49,192,141,140, 36,  0,
/* 0x18d0 */ 255,255,255,137,236, 80, 57,204,117,251,137,236, 49,201, 43,124,
/* 0x18e0 */  36, 44,139, 76, 36, 48,137, 57, 43,116, 36, 36,137,116, 36, 28,
/* 0x18f0 */  97,195, 93,141,117,243, 15,183, 69,  0,141, 77,  2, 81,  1,197,
/* 0x1900 */ 137,242,137,247,173, 41,199,137,241,173, 41,193, 81, 41,202, 82,
/* 0x1910 */  87,233,199,  0,  0,  0, 91,141,119, 28, 41,201,  1,206,139, 78,
/* 0x1920 */   4,131, 62,  1,117,246,129,126, 10, 76, 73, 78, 75,117,237,129,
/* 0x1930 */ 126, 14, 69, 68, 73, 84,117,228,139, 78, 24,137,222,106,  5,173,
/* 0x1940 */  80,137,226, 81,255,118,  4, 82, 81,173, 80,173, 86,255,213,131,
/* 0x1950 */ 196, 20, 95, 87, 87,176, 74, 15,182,192,137,225, 13,  0,  0, 12,
/* 0x1960 */   0,232, 12,  0,  0,  0,115,  3,131,200,255,194, 12,  0,176,  4,
/* 0x1970 */ 235,229, 90, 15, 52, 96,137,230,139, 68, 36, 36,131,236,120,137,
/* 0x1980 */ 231, 80,176, 10,170, 88,170,193,232,  8,117,250,106,  8, 88, 80,
/* 0x1990 */ 176, 32,232, 28,  0,  0,  0, 88, 72,117,244,176, 10,170,151, 41,
/* 0x19a0 */ 224,137,225, 80, 81,106,  2,232,194,255,255,255,131,196,120, 97,
/* 0x19b0 */ 194,  4,  0,170,173,232, 16,  0,  0,  0, 48, 49, 50, 51, 52, 53,
/* 0x19c0 */  54, 55, 56, 57, 97, 98, 99,100,101,102, 91,106,  8, 89,193,192,
/* 0x19d0 */   4,137,194,131,224, 15,215,170,146, 73,117,242,195,232, 52,255,
/* 0x19e0 */ 255,255,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,
/* 0x19f0 */ 102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,
/* 0x1a00 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x1a10 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x1a20 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,
/* 0x1a30 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x1a40 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 77, 65,
/* 0x1a50 */  67, 72, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32, 48, 53, 32, 32,
/* 0x1a60 */  48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1a70 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 77, 65,
/* 0x1a80 */  67, 72, 95, 85, 78, 67, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48,
/* 0x1a90 */  32, 32, 48, 32, 32, 48, 51, 57, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1aa0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 78, 82, 86,
/* 0x1ab0 */  95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 98, 99, 32, 32,
/* 0x1ac0 */  48, 32, 32, 48, 32, 32, 48, 51, 57, 32, 32, 50, 42, 42, 48, 32,
/* 0x1ad0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 78, 82,
/* 0x1ae0 */  86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,100, 52, 32,
/* 0x1af0 */  32, 48, 32, 32, 48, 32, 32, 48,102, 53, 32, 32, 50, 42, 42, 48,
/* 0x1b00 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 78,
/* 0x1b10 */  82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 99, 55,
/* 0x1b20 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 57, 32, 32, 50, 42,
/* 0x1b30 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53,
/* 0x1b40 */  32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x1b50 */  98, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 57, 48, 32, 32,
/* 0x1b60 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1b70 */  32, 54, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 32, 32,
/* 0x1b80 */  32, 48, 50,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 50,
/* 0x1b90 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1ba0 */  10, 32, 32, 55, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32,
/* 0x1bb0 */  32, 32, 32, 48, 52, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x1bc0 */  55, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1bd0 */  84, 83, 10, 32, 32, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x1be0 */  48, 32, 32, 32, 32, 48, 97, 56, 54, 32, 32, 48, 32, 32, 48, 32,
/* 0x1bf0 */  32, 48, 51, 98, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1c00 */  84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95, 68,
/* 0x1c10 */  69, 67, 50, 48, 32, 32, 32, 32, 48, 97, 56, 54, 32, 32, 48, 32,
/* 0x1c20 */  32, 48, 32, 32, 48,101, 51,101, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1c30 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 76, 90, 77,
/* 0x1c40 */  65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 49, 97, 32, 32,
/* 0x1c50 */  48, 32, 32, 48, 32, 32, 48, 49, 56, 99, 52, 32, 32, 50, 42, 42,
/* 0x1c60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32,
/* 0x1c70 */  78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 32,
/* 0x1c80 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 56,100,101, 32, 32, 50, 42,
/* 0x1c90 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50,
/* 0x1ca0 */  32, 77, 65, 67, 72, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 48,
/* 0x1cb0 */  49, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56,100,101, 32,
/* 0x1cc0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1cd0 */  32, 49, 51, 32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 32, 32, 32,
/* 0x1ce0 */  32, 32, 48,102, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56,
/* 0x1cf0 */ 102, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1d00 */  84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58,
/* 0x1d10 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1d20 */  32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 48, 32, 78, 82, 86,
/* 0x1d30 */  95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1d40 */  32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 89,
/* 0x1d50 */  32, 48, 32, 77, 65, 67, 72, 77, 65, 73, 78, 89, 10, 48, 48, 48,
/* 0x1d60 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65,
/* 0x1d70 */  67, 72, 77, 65, 73, 78, 90, 32, 48, 32, 77, 65, 67, 72, 77, 65,
/* 0x1d80 */  73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1d90 */  32, 32,100, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 88, 32, 48,
/* 0x1da0 */  32, 77, 65, 67, 72, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48, 48,
/* 0x1db0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72,
/* 0x1dc0 */  95, 85, 78, 67, 32, 48, 32, 77, 65, 67, 72, 95, 85, 78, 67, 10,
/* 0x1dd0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x1de0 */  32, 78, 82, 86, 50, 69, 32, 48, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x1df0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1e00 */  78, 82, 86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x1e10 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x1e20 */  82, 86, 50, 66, 32, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x1e30 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x1e40 */  77, 65, 95, 68, 69, 67, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x1e50 */  68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1e60 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x1e70 */  48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48,
/* 0x1e80 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1e90 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77,
/* 0x1ea0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1eb0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x1ec0 */  67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x1ed0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1ee0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76,
/* 0x1ef0 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x1f00 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 84,
/* 0x1f10 */  65, 73, 76, 32, 48, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 48,
/* 0x1f20 */  48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f30 */  77, 65, 67, 72, 77, 65, 73, 78, 88, 32, 48, 32, 95,115,116, 97,
/* 0x1f40 */ 114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x1f50 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97,
/* 0x1f60 */  95,115,116, 97, 99,107, 95, 97,100,106,117,115,116, 10, 48, 48,
/* 0x1f70 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x1f80 */  85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,117, 95,108,101,
/* 0x1f90 */ 110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x1fa0 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,
/* 0x1fb0 */  99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1fc0 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,
/* 0x1fd0 */ 122,109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 48,
/* 0x1fe0 */  48, 48, 48, 48, 48, 49, 52, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1ff0 */  77, 65, 67, 72, 77, 65, 73, 78, 89, 32, 48, 32,101,110,100, 95,
/* 0x2000 */ 100,101, 99,111,109,112,114,101,115,115, 10, 10, 82, 69, 76, 79,
/* 0x2010 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x2020 */  79, 82, 32, 91, 77, 65, 67, 72, 77, 65, 73, 78, 88, 93, 58, 10,
/* 0x2030 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x2040 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x2050 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x2060 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 77, 65, 67, 72,
/* 0x2070 */  77, 65, 73, 78, 90, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x2080 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x2090 */  82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x20a0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x20b0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 99, 57,
/* 0x20c0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x20d0 */  32, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48,
/* 0x20e0 */  48, 48, 54, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32,
/* 0x20f0 */  32, 32, 32, 32, 32, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 89,
/* 0x2100 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x2110 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93,
/* 0x2120 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x2130 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x2140 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 51, 56,
/* 0x2150 */  54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2160 */  86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32,
/* 0x2170 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x2180 */  32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 89, 10, 10, 82, 69, 76,
/* 0x2190 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x21a0 */  70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70,
/* 0x21b0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x21c0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x21d0 */  48, 48, 48, 48, 97, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x21e0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 95, 72, 69, 65,
/* 0x21f0 */  68, 10, 48, 48, 48, 48, 48, 48, 53, 54, 32, 82, 95, 51, 56, 54,
/* 0x2200 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 77, 65, 67,
/* 0x2210 */  72, 77, 65, 73, 78, 89, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x2220 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x2230 */  76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 93, 58, 10, 79, 70, 70,
/* 0x2240 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x2250 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x2260 */  48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x2270 */  32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,115,116,
/* 0x2280 */  97, 99,107, 95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48,
/* 0x2290 */  48, 49, 52, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x22a0 */  32, 32, 32, 32, 32, 32,108,122,109, 97, 95,117, 95,108,101,110,
/* 0x22b0 */  10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x22c0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97,
/* 0x22d0 */  95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 50, 97, 32,
/* 0x22e0 */  82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x22f0 */  32, 32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,101,
/* 0x2300 */ 115, 10
};
