/* dhparam.c: initial DH parameters for stunnel */
#include "prototypes.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void) {
    static unsigned char dhp_2048[] = {
        0x9f, 0x7e, 0x7a, 0xda, 0x97, 0xce, 0x22, 0xe2, 0x35, 0x68, 0xc9, 0xe9,
        0xc8, 0xe7, 0x19, 0x11, 0x02, 0xbe, 0x30, 0x88, 0x48, 0x89, 0xf1, 0x7d,
        0x0b, 0xcc, 0xc7, 0x38, 0x58, 0x16, 0xb3, 0xca, 0xd3, 0xd0, 0x45, 0xd4,
        0x36, 0x50, 0x25, 0xb3, 0x7e, 0xf8, 0x24, 0x29, 0x7c, 0x4a, 0xbc, 0xee,
        0xe5, 0x1d, 0x2f, 0xef, 0xf3, 0x07, 0xd1, 0x2a, 0x3f, 0xec, 0x31, 0x91,
        0xb2, 0x80, 0xda, 0x96, 0x59, 0x7d, 0xe6, 0x7d, 0x4d, 0x38, 0x40, 0x4a,
        0x00, 0x50, 0x64, 0x96, 0x47, 0x90, 0x4c, 0xc8, 0xe1, 0x3c, 0x1f, 0xda,
        0xb4, 0x89, 0x56, 0x99, 0x1d, 0xff, 0x82, 0xc5, 0x1f, 0x41, 0xfd, 0x1f,
        0xb3, 0xf1, 0x4f, 0xb0, 0x8c, 0xde, 0xda, 0xee, 0xba, 0x3b, 0x25, 0x32,
        0x7a, 0x04, 0x26, 0x7a, 0x44, 0xf2, 0x46, 0xd9, 0xb7, 0x28, 0xa3, 0xdc,
        0xe9, 0x50, 0x00, 0xe7, 0x92, 0x94, 0x5a, 0xe1, 0x4e, 0xc6, 0xc8, 0x82,
        0x42, 0xe2, 0xf1, 0x21, 0x8f, 0xcf, 0xcc, 0x56, 0xff, 0xba, 0x8c, 0xc3,
        0xc8, 0xd8, 0xfe, 0x09, 0x63, 0x2f, 0x33, 0x8f, 0x95, 0xf8, 0x5b, 0x44,
        0xfb, 0xdd, 0x81, 0x67, 0x02, 0x9d, 0xe3, 0x47, 0xf4, 0x93, 0x3d, 0xe5,
        0x34, 0x09, 0xa5, 0x77, 0x2e, 0x92, 0x0f, 0x97, 0x83, 0x71, 0xff, 0xa7,
        0x51, 0x95, 0x4e, 0x4f, 0x28, 0xcf, 0x47, 0x45, 0xe0, 0xe8, 0x3d, 0x7a,
        0x9c, 0xdf, 0x50, 0x2d, 0x91, 0x64, 0x8c, 0xba, 0x5e, 0x1a, 0x11, 0xa2,
        0xd8, 0x26, 0x67, 0x78, 0x61, 0xa1, 0x44, 0x2a, 0xfb, 0xcb, 0xfa, 0x6f,
        0x4f, 0x01, 0x80, 0x5e, 0x00, 0x45, 0x0d, 0x50, 0x1e, 0xaf, 0xd9, 0xf4,
        0x9c, 0x92, 0x1d, 0x6e, 0x64, 0xd3, 0x4d, 0xbd, 0xd3, 0x15, 0xaf, 0x64,
        0x3c, 0x00, 0xf1, 0x89, 0x8f, 0xa5, 0x13, 0xa7, 0x06, 0x92, 0x05, 0xdd,
        0x10, 0x92, 0x61, 0xc7
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.69 */
