/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.35 from the
 * contents of Socket.xs. Do not edit this file, edit Socket.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Socket.xs"
#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <stddef.h>

#ifdef I_SYS_TYPES
#  include <sys/types.h>
#endif
#if !defined(ultrix) /* Avoid double definition. */
#   include <sys/socket.h>
#endif
#if defined(USE_SOCKS) && defined(I_SOCKS)
#   include <socks.h>
#endif
#ifdef MPE
#  define PF_INET AF_INET
#  define PF_UNIX AF_UNIX
#  define SOCK_RAW 3
#endif
#ifdef I_SYS_UN
#  include <sys/un.h>
#endif
/* XXX Configure test for <netinet/in_systm.h needed XXX */
#if defined(NeXT) || defined(__NeXT__)
#  include <netinet/in_systm.h>
#endif
#if defined(__sgi) && !defined(AF_LINK) && defined(PF_LINK) && PF_LINK == AF_LNK
#  undef PF_LINK
#endif
#if defined(I_NETINET_IN) || defined(__ultrix__)
#  include <netinet/in.h>
#endif
#if defined(I_NETINET_IP)
#  include <netinet/ip.h>
#endif
#ifdef I_NETDB
#  if !defined(ultrix)	/* Avoid double definition. */
#   include <netdb.h>
#  endif
#endif
#ifdef I_ARPA_INET
#  include <arpa/inet.h>
#endif
#ifdef I_NETINET_TCP
#  include <netinet/tcp.h>
#endif

#if defined(WIN32) && !defined(UNDER_CE)
# include <ws2tcpip.h>
#endif

#ifdef WIN32

/* VC 6 with its original headers doesn't know about sockaddr_storage, VC 2003 does*/
#ifndef _SS_MAXSIZE

#  define _SS_MAXSIZE 128
#  define _SS_ALIGNSIZE (sizeof(__int64))

#  define _SS_PAD1SIZE (_SS_ALIGNSIZE - sizeof (short))
#  define _SS_PAD2SIZE (_SS_MAXSIZE - (sizeof (short) + _SS_PAD1SIZE \
                                                    + _SS_ALIGNSIZE))

struct sockaddr_storage {
    short ss_family;
    char __ss_pad1[_SS_PAD1SIZE];
    __int64 __ss_align;
    char __ss_pad2[_SS_PAD2SIZE];
};

typedef int socklen_t;

#define in6_addr in_addr6

#define INET_ADDRSTRLEN  22
#define INET6_ADDRSTRLEN 65

#endif

/*
 *  Under Windows, sockaddr_un is defined in afunix.h. Unfortunately
 *  MinGW and SDKs older than 10.0.17063.0 don't have it, so we have to
 *  define it here. Don't worry, it's portable. Windows has ironclad ABI
 *  stability guarantees which means that the definitions will *never*
 *  change.
 */
#ifndef UNIX_PATH_MAX

#define UNIX_PATH_MAX 108

struct sockaddr_un
{
     USHORT sun_family;
     char sun_path[UNIX_PATH_MAX];
};

#endif

static int inet_pton(int af, const char *src, void *dst)
{
  struct sockaddr_storage ss;
  int size = sizeof(ss);
  ss.ss_family = af; /* per MSDN */

  if (WSAStringToAddress((char*)src, af, NULL, (struct sockaddr *)&ss, &size) != 0)
    return 0;

  switch(af) {
    case AF_INET:
      *(struct in_addr *)dst = ((struct sockaddr_in *)&ss)->sin_addr;
      return 1;
    case AF_INET6:
      *(struct in6_addr *)dst = ((struct sockaddr_in6 *)&ss)->sin6_addr;
      return 1;
    default:
      WSASetLastError(WSAEAFNOSUPPORT);
      return -1;
  }
}

static const char *inet_ntop(int af, const void *src, char *dst, socklen_t size)
{
  struct sockaddr_storage ss;
  unsigned long s = size;

  ZeroMemory(&ss, sizeof(ss));
  ss.ss_family = af;

  switch(af) {
    case AF_INET:
      ((struct sockaddr_in *)&ss)->sin_addr = *(struct in_addr *)src;
      break;
    case AF_INET6:
      ((struct sockaddr_in6 *)&ss)->sin6_addr = *(struct in6_addr *)src;
      break;
    default:
      return NULL;
  }

  /* cannot directly use &size because of strict aliasing rules */
  if (WSAAddressToString((struct sockaddr *)&ss, sizeof(ss), NULL, dst, &s) != 0)
    return NULL;
  else
    return dst;
}

#define HAS_INETPTON
#define HAS_INETNTOP
#endif

#ifdef NETWARE
NETDB_DEFINE_CONTEXT
NETINET_DEFINE_CONTEXT
#endif

#ifdef I_SYSUIO
# include <sys/uio.h>
#endif

#ifndef AF_NBS
# undef PF_NBS
#endif

#ifndef AF_X25
# undef PF_X25
#endif

#ifndef INADDR_NONE
# define INADDR_NONE	0xffffffff
#endif /* INADDR_NONE */
#ifndef INADDR_BROADCAST
# define INADDR_BROADCAST	0xffffffff
#endif /* INADDR_BROADCAST */
#ifndef INADDR_LOOPBACK
# define INADDR_LOOPBACK	 0x7F000001
#endif /* INADDR_LOOPBACK */

#ifndef INET_ADDRSTRLEN
#define INET_ADDRSTRLEN 16
#endif

#ifndef C_ARRAY_LENGTH
#define C_ARRAY_LENGTH(arr) (sizeof(arr) / sizeof(*(arr)))
#endif /* !C_ARRAY_LENGTH */

#ifndef PERL_UNUSED_VAR
# define PERL_UNUSED_VAR(x) ((void)x)
#endif /* !PERL_UNUSED_VAR */

#ifndef PERL_UNUSED_ARG
# define PERL_UNUSED_ARG(x) PERL_UNUSED_VAR(x)
#endif /* !PERL_UNUSED_ARG */

#ifndef Newx
# define Newx(v,n,t) New(0,v,n,t)
#endif /* !Newx */

#ifndef SvPVx_nolen
#if defined(__GNUC__) && !defined(PERL_GCC_BRACE_GROUPS_FORBIDDEN)
#  define SvPVx_nolen(sv) ({SV *_sv = (sv); SvPV_nolen(_sv); })
#else /* __GNUC__ */
#  define SvPVx_nolen(sv) ((PL_Sv = (sv)), SvPV_nolen(PL_Sv))
#endif /* __GNU__ */
#endif /* !SvPVx_nolen */

#ifndef croak_sv
# define croak_sv(sv)	croak("%s", SvPVx_nolen(sv))
#endif

#ifndef hv_stores
# define hv_stores(hv, keystr, val) \
	hv_store(hv, ""keystr"", sizeof(keystr)-1, val, 0)
#endif /* !hv_stores */

#ifndef newSVpvn_flags
# define newSVpvn_flags(s,len,flags) my_newSVpvn_flags(aTHX_ s,len,flags)
static SV *my_newSVpvn_flags(pTHX_ const char *s, STRLEN len, U32 flags)
{
  SV *sv = newSVpvn(s, len);
  SvFLAGS(sv) |= (flags & SVf_UTF8);
  return (flags & SVs_TEMP) ? sv_2mortal(sv) : sv;
}
#endif /* !newSVpvn_flags */

#ifndef SvRV_set
# define SvRV_set(sv, val) (SvRV(sv) = (val))
#endif /* !SvRV_set */

#ifndef SvPV_nomg
# define SvPV_nomg SvPV
#endif /* !SvPV_nomg */

#ifndef HEK_FLAGS
# define HEK_FLAGS(hek) 0
# define HVhek_UTF8 1
#endif /* !HEK_FLAGS */

#ifndef hv_common
/* These magic numbers are arbitrarily chosen (copied from perl core in fact)
 * and only have to match between this definition and the code that uses them
 */
# define HV_FETCH_ISSTORE 0x04
# define HV_FETCH_LVALUE  0x10
# define hv_common(hv, keysv, key, klen, flags, act, val, hash) \
	my_hv_common(aTHX_ hv, keysv, key, klen, flags, act, val, hash)
static void *my_hv_common(pTHX_ HV *hv, SV *keysv, const char *key, STRLEN klen,
	int flags, int act, SV *val, U32 hash)
{
	/*
	 * This only handles the usage actually made by the code
	 * generated by ExtUtils::Constant.  EU:C really ought to arrange
	 * portability of its generated code itself.
	 */
	if (!keysv) {
		keysv = sv_2mortal(newSVpvn(key, klen));
		if (flags & HVhek_UTF8)
			SvUTF8_on(keysv);
	}
	if (act == HV_FETCH_LVALUE) {
		return (void*)hv_fetch_ent(hv, keysv, 1, hash);
	} else if (act == HV_FETCH_ISSTORE) {
		return (void*)hv_store_ent(hv, keysv, val, hash);
	} else {
		croak("panic: my_hv_common: act=0x%x", act);
	}
}
#endif /* !hv_common */

#ifndef hv_common_key_len
# define hv_common_key_len(hv, key, kl, act, val, hash) \
	my_hv_common_key_len(aTHX_ hv, key, kl, act, val, hash)
static void *my_hv_common_key_len(pTHX_ HV *hv, const char *key, I32 kl,
	int act, SV *val, U32 hash)
{
	STRLEN klen;
	int flags;
	if (kl < 0) {
		klen = -kl;
		flags = HVhek_UTF8;
	} else {
		klen = kl;
		flags = 0;
	}
	return hv_common(hv, NULL, key, klen, flags, act, val, hash);
}
#endif /* !hv_common_key_len */

#ifndef mPUSHi
# define mPUSHi(i) sv_setiv_mg(PUSHs(sv_newmortal()), (IV)(i))
#endif /* !mPUSHi */
#ifndef mPUSHp
# define mPUSHp(p,l) sv_setpvn_mg(PUSHs(sv_newmortal()), (p), (l))
#endif /* !mPUSHp */
#ifndef mPUSHs
# define mPUSHs(s) PUSHs(sv_2mortal(s))
#endif /* !mPUSHs */

#ifndef CvCONST_on
# undef newCONSTSUB
# define newCONSTSUB(stash, name, val) my_newCONSTSUB(aTHX_ stash, name, val)
static CV *my_newCONSTSUB(pTHX_ HV *stash, char *name, SV *val)
{
	/*
	 * This has to satisfy code generated by ExtUtils::Constant.
	 * It depends on the 5.8+ layout of constant subs.  It has
	 * two calls to newCONSTSUB(): one for real constants, and one
	 * for undefined constants.  In the latter case, it turns the
	 * initially-generated constant subs into something else, and
	 * it needs the return value from newCONSTSUB() which Perl 5.6
	 * doesn't provide.
	 */
	GV *gv;
	CV *cv;
	Perl_newCONSTSUB(aTHX_ stash, name, val);
	ENTER;
	SAVESPTR(PL_curstash);
	PL_curstash = stash;
	gv = gv_fetchpv(name, 0, SVt_PVCV);
	cv = GvCV(gv);
	LEAVE;
	CvXSUBANY(cv).any_ptr = &PL_sv_undef;
	return cv;
}
# define CvCONST_off(cv) my_CvCONST_off(aTHX_ cv)
static void my_CvCONST_off(pTHX_ CV *cv)
{
	op_free(CvROOT(cv));
	CvROOT(cv) = NULL;
	CvSTART(cv) = NULL;
}
#endif /* !CvCONST_on */

#ifndef HAS_INET_ATON

/*
 * Check whether "cp" is a valid ascii representation
 * of an Internet address and convert to a binary address.
 * Returns 1 if the address is valid, 0 if not.
 * This replaces inet_addr, the return value from which
 * cannot distinguish between failure and a local broadcast address.
 */
static int
my_inet_aton(register const char *cp, struct in_addr *addr)
{
	dTHX;
	register U32 val;
	register int base;
	register char c;
	int nparts;
	const char *s;
	unsigned int parts[4];
	register unsigned int *pp = parts;

	if (!cp || !*cp)
		return 0;
	for (;;) {
		/*
		 * Collect number up to ".".
		 * Values are specified as for C:
		 * 0x=hex, 0=octal, other=decimal.
		 */
		val = 0; base = 10;
		if (*cp == '0') {
			if (*++cp == 'x' || *cp == 'X')
				base = 16, cp++;
			else
				base = 8;
		}
		while ((c = *cp) != '\0') {
			if (isDIGIT(c)) {
				val = (val * base) + (c - '0');
				cp++;
				continue;
			}
			if (base == 16 && (s=strchr(PL_hexdigit,c))) {
				val = (val << 4) +
					((s - PL_hexdigit) & 15);
				cp++;
				continue;
			}
			break;
		}
		if (*cp == '.') {
			/*
			 * Internet format:
			 *	a.b.c.d
			 *	a.b.c	(with c treated as 16-bits)
			 *	a.b	(with b treated as 24 bits)
			 */
			if (pp >= parts + 3 || val > 0xff)
				return 0;
			*pp++ = val, cp++;
		} else
			break;
	}
	/*
	 * Check for trailing characters.
	 */
	if (*cp && !isSPACE(*cp))
		return 0;
	/*
	 * Concoct the address according to
	 * the number of parts specified.
	 */
	nparts = pp - parts + 1;	/* force to an int for switch() */
	switch (nparts) {

	case 1:				/* a -- 32 bits */
		break;

	case 2:				/* a.b -- 8.24 bits */
		if (val > 0xffffff)
			return 0;
		val |= parts[0] << 24;
		break;

	case 3:				/* a.b.c -- 8.8.16 bits */
		if (val > 0xffff)
			return 0;
		val |= (parts[0] << 24) | (parts[1] << 16);
		break;

	case 4:				/* a.b.c.d -- 8.8.8.8 bits */
		if (val > 0xff)
			return 0;
		val |= (parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8);
		break;
	}
	addr->s_addr = htonl(val);
	return 1;
}

#undef inet_aton
#define inet_aton my_inet_aton

#endif /* ! HAS_INET_ATON */

/* These are not gni() constants; they're extensions for the perl API */
/* The definitions in Socket.pm and Socket.xs must match */
#define NIx_NOHOST   (1 << 0)
#define NIx_NOSERV   (1 << 1)

/* On Windows, ole2.h defines a macro called "interface". We don't need that,
 * and it will complicate the variables in pack_ip_mreq() etc. (RT87389)
 */
#undef interface

/* STRUCT_OFFSET should have come from from perl.h, but if not,
 * roll our own (not using offsetof() since that is C99). */
#ifndef STRUCT_OFFSET
#  define STRUCT_OFFSET(s,m)  (Size_t)(&(((s *)0)->m))
#endif

static int
not_here(const char *s)
{
    croak("Socket::%s not implemented on this architecture", s);
    return -1;
}

#define PERL_IN_ADDR_S_ADDR_SIZE 4

/*
* Bad assumptions possible here.
*
* Bad Assumption 1: struct in_addr has no other fields
* than the s_addr (which is the field we care about
* in here, really). However, we can be fed either 4-byte
* addresses (from pack("N", ...), or va.b.c.d, or ...),
* or full struct in_addrs (from e.g. pack_sockaddr_in()),
* which may or may not be 4 bytes in size.
*
* Bad Assumption 2: the s_addr field is a simple type
* (such as an int, u_int32_t).	It can be a bit field,
* in which case using & (address-of) on it or taking sizeof()
* wouldn't go over too well.  (Those are not attempted
* now but in case someone thinks to change the below code
* to use addr.s_addr instead of addr, you have been warned.)
*
* Bad Assumption 3: the s_addr is the first field in
* an in_addr, or that its bytes are the first bytes in
* an in_addr.
*
* These bad assumptions are wrong in UNICOS which has
* struct in_addr { struct { u_long  st_addr:32; } s_da };
* #define s_addr s_da.st_addr
* and u_long is 64 bits.
*
* --jhi */

#include "const-c.inc"

#if defined(HAS_GETADDRINFO) && !defined(HAS_GAI_STRERROR)
static const char *gai_strerror(int err)
{
  switch (err)
  {
#ifdef EAI_ADDRFAMILY
  case EAI_ADDRFAMILY:
    return "Address family for hostname is not supported.";
#endif
#ifdef EAI_AGAIN
  case EAI_AGAIN:
    return "The name could not be resolved at this time.";
#endif
#ifdef EAI_BADFLAGS
  case EAI_BADFLAGS:
    return "The flags parameter has an invalid value.";
#endif
#ifdef EAI_FAIL
  case EAI_FAIL:
    return "A non-recoverable error occurred while resolving the name.";
#endif
#ifdef EAI_FAMILY
  case EAI_FAMILY:
    return "The address family was not recognized or length is invalid.";
#endif
#ifdef EAI_MEMORY
  case EAI_MEMORY:
    return "A memory allocation failure occurred.";
#endif
#ifdef EAI_NODATA
  case EAI_NODATA:
    return "No address is associated with the hostname.";
#endif
#ifdef EAI_NONAME
  case EAI_NONAME:
    return "The name does not resolve for the supplied parameters.";
#endif
#ifdef EAI_OVERFLOW
  case EAI_OVERFLOW:
    return "An argument buffer overflowed.";
#endif
#ifdef EAI_SERVICE
  case EAI_SERVICE:
    return "The service parameter was not recognized for the specified socket type.";
#endif
#ifdef EAI_SOCKTYPE
  case EAI_SOCKTYPE:
    return "The specified socket type was not recognized.";
#endif
#ifdef EAI_SYSTEM
  case EAI_SYSTEM:
    return "A system error occurred - see errno.";
#endif
  default:
    return "Unknown error in getaddrinfo().";
  }
}
#endif

#ifdef HAS_GETADDRINFO
static SV *err_to_SV(pTHX_ int err)
{
	SV *ret = sv_newmortal();
	(void) SvUPGRADE(ret, SVt_PVNV);

	if(err) {
		const char *error = gai_strerror(err);
		sv_setpv(ret, error);
	}
	else {
		sv_setpv(ret, "");
	}

	SvIV_set(ret, err); SvIOK_on(ret);

	return ret;
}

static void xs_getaddrinfo(pTHX_ CV *cv)
{
	dXSARGS;

	SV   *host;
	SV   *service;
	SV   *hints;

	char *hostname = NULL;
	char *servicename = NULL;
	STRLEN len;
	struct addrinfo hints_s;
	struct addrinfo *res;
	struct addrinfo *res_iter;
	int err;
	int n_res;

	PERL_UNUSED_ARG(cv);
	if(items > 3)
		croak("Usage: Socket::getaddrinfo(host, service, hints)");

	SP -= items;

	if(items < 1)
		host = &PL_sv_undef;
	else
		host = ST(0);

	if(items < 2)
		service = &PL_sv_undef;
	else
		service = ST(1);

	if(items < 3)
		hints = NULL;
	else
		hints = ST(2);

	SvGETMAGIC(host);
	if(SvOK(host)) {
		hostname = SvPV_nomg(host, len);
		if (!len)
			hostname = NULL;
	}

	SvGETMAGIC(service);
	if(SvOK(service)) {
		servicename = SvPV_nomg(service, len);
		if (!len)
			servicename = NULL;
	}

	Zero(&hints_s, sizeof(hints_s), char);
	hints_s.ai_family = PF_UNSPEC;

	if(hints && SvOK(hints)) {
		HV *hintshash;
		SV **valp;

		if(!SvROK(hints) || SvTYPE(SvRV(hints)) != SVt_PVHV)
			croak("hints is not a HASH reference");

		hintshash = (HV*)SvRV(hints);

		if((valp = hv_fetch(hintshash, "flags", 5, 0)) != NULL && SvOK(*valp))
			hints_s.ai_flags = SvIV(*valp);
		if((valp = hv_fetch(hintshash, "family", 6, 0)) != NULL && SvOK(*valp))
			hints_s.ai_family = SvIV(*valp);
		if((valp = hv_fetch(hintshash, "socktype", 8, 0)) != NULL && SvOK(*valp))
			hints_s.ai_socktype = SvIV(*valp);
		if((valp = hv_fetch(hintshash, "protocol", 8, 0)) != NULL && SvOK(*valp))
			hints_s.ai_protocol = SvIV(*valp);
	}

	err = getaddrinfo(hostname, servicename, &hints_s, &res);

	XPUSHs(err_to_SV(aTHX_ err));

	if(err)
		XSRETURN(1);

	n_res = 0;
	for(res_iter = res; res_iter; res_iter = res_iter->ai_next) {
		HV *res_hv = newHV();

		(void)hv_stores(res_hv, "family",   newSViv(res_iter->ai_family));
		(void)hv_stores(res_hv, "socktype", newSViv(res_iter->ai_socktype));
		(void)hv_stores(res_hv, "protocol", newSViv(res_iter->ai_protocol));

		(void)hv_stores(res_hv, "addr",     newSVpvn((char*)res_iter->ai_addr, res_iter->ai_addrlen));

		if(res_iter->ai_canonname)
			(void)hv_stores(res_hv, "canonname", newSVpv(res_iter->ai_canonname, 0));
		else
			(void)hv_stores(res_hv, "canonname", newSV(0));

		XPUSHs(sv_2mortal(newRV_noinc((SV*)res_hv)));
		n_res++;
	}

	freeaddrinfo(res);

	XSRETURN(1 + n_res);
}
#endif

#ifdef HAS_GETNAMEINFO
static void xs_getnameinfo(pTHX_ CV *cv)
{
	dXSARGS;

	SV  *addr;
	int  flags;
	int  xflags;

	char host[1024];
	char serv[256];
	char *sa; /* we'll cast to struct sockaddr * when necessary */
	STRLEN addr_len;
	int err;

	int want_host, want_serv;

	PERL_UNUSED_ARG(cv);
	if(items < 1 || items > 3)
		croak("Usage: Socket::getnameinfo(addr, flags=0, xflags=0)");

	SP -= items;

	addr = ST(0);
	SvGETMAGIC(addr);

	if(items < 2)
		flags = 0;
	else
		flags = SvIV(ST(1));

	if(items < 3)
		xflags = 0;
	else
		xflags = SvIV(ST(2));

	want_host = !(xflags & NIx_NOHOST);
	want_serv = !(xflags & NIx_NOSERV);

	if(!SvPOKp(addr))
		croak("addr is not a string");

	addr_len = SvCUR(addr);

	/* We need to ensure the sockaddr is aligned, because a random SvPV might
	 * not be due to SvOOK */
	Newx(sa, addr_len, char);
	Copy(SvPV_nolen(addr), sa, addr_len, char);
#ifdef HAS_SOCKADDR_SA_LEN
	((struct sockaddr *)sa)->sa_len = addr_len;
#endif

	err = getnameinfo((struct sockaddr *)sa, addr_len,
			want_host ? host : NULL, want_host ? sizeof(host) : 0,
			want_serv ? serv : NULL, want_serv ? sizeof(serv) : 0,
			flags);

	Safefree(sa);

	XPUSHs(err_to_SV(aTHX_ err));

	if(err)
		XSRETURN(1);

	XPUSHs(want_host ? sv_2mortal(newSVpv(host, 0)) : &PL_sv_undef);
	XPUSHs(want_serv ? sv_2mortal(newSVpv(serv, 0)) : &PL_sv_undef);

	XSRETURN(3);
}
#endif

#line 760 "Socket.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 904 "Socket.c"

/* INCLUDE:  Including 'const-xs.inc' from 'Socket.xs' */


XS_EUPXS(XS_Socket_AUTOLOAD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_AUTOLOAD)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 998 "./const-xs.inc"
	SV *sv = newSVpvn_flags(SvPVX(cv), SvCUR(cv), SVs_TEMP | SvUTF8(cv));
	const COP *cop = PL_curcop;
#line 921 "Socket.c"
#line 1001 "./const-xs.inc"
#ifndef SYMBIAN
	/* It's not obvious how to calculate this at C pre-processor time.
	   However, any compiler optimiser worth its salt should be able to
	   remove the dead code, and hopefully the now-obviously-unused static
	   function too.  */
	HV *constant_missing = (C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? get_missing_hash(aTHX) : NULL;
	if ((C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? hv_exists_ent(constant_missing, sv, 0) : 0) {
	    sv = newSVpvf("Your vendor has not defined Socket macro %" SVf
			  ", used at %" COP_FILE_F " line %" UVuf "\n", 
			  sv, COP_FILE(cop), (UV)CopLINE(cop));
	} else
#endif
	{
	    sv = newSVpvf("%" SVf
                          " is not a valid Socket macro at %"
			  COP_FILE_F " line %" UVuf "\n",
			  sv, COP_FILE(cop), (UV)CopLINE(cop));
	}
	croak_sv(sv_2mortal(sv));
#line 944 "Socket.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'Socket.xs' from 'const-xs.inc' */


XS_EUPXS(XS_Socket_inet_aton); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_inet_aton)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "host");
    {
	char *	host = (char *)SvPV_nolen(ST(0))
;
#line 766 "Socket.xs"
	{
#ifdef HAS_GETADDRINFO
	struct addrinfo *res;
	struct addrinfo hints = {0};
	hints.ai_family = AF_INET;
	if (!getaddrinfo(host, NULL, &hints, &res)) {
		ST(0) = sv_2mortal(newSVpvn(
			(char *)&(((struct sockaddr_in *)res->ai_addr)->sin_addr.s_addr),
			4));
		freeaddrinfo(res);
		XSRETURN(1);
	}
#else
	struct in_addr ip_address;
	struct hostent * phe;
	if ((*host != '\0') && inet_aton(host, &ip_address)) {
		ST(0) = sv_2mortal(newSVpvn((char *)&ip_address, sizeof(ip_address)));
		XSRETURN(1);
	}
#ifdef HAS_GETHOSTBYNAME
	/* gethostbyname is not thread-safe */
	phe = gethostbyname(host);
	if (phe && phe->h_addrtype == AF_INET && phe->h_length == 4) {
		ST(0) = sv_2mortal(newSVpvn((char *)phe->h_addr, phe->h_length));
		XSRETURN(1);
	}
#endif /* HAS_GETHOSTBYNAME */
#endif /* HAS_GETADDRINFO */
	XSRETURN_UNDEF;
	}
#line 994 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_inet_ntoa); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_inet_ntoa)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ip_address_sv");
    {
	SV *	ip_address_sv = ST(0)
;
#line 801 "Socket.xs"
	{
	STRLEN addrlen;
	struct in_addr addr;
	char * ip_address;
	if (DO_UTF8(ip_address_sv) && !sv_utf8_downgrade(ip_address_sv, 1))
		croak("Wide character in %s", "Socket::inet_ntoa");
	ip_address = SvPVbyte(ip_address_sv, addrlen);
	if (addrlen == sizeof(addr) || addrlen == 4)
		addr.s_addr =
		    (unsigned long)(ip_address[0] & 0xFF) << 24 |
		    (unsigned long)(ip_address[1] & 0xFF) << 16 |
		    (unsigned long)(ip_address[2] & 0xFF) <<  8 |
		    (unsigned long)(ip_address[3] & 0xFF);
	else
		croak("Bad arg length for %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::inet_ntoa", (UV)addrlen, (UV)sizeof(addr));
	/* We could use inet_ntoa() but that is broken
	 * in HP-UX + GCC + 64bitint (returns "0.0.0.0"),
	 * so let's use this sprintf() workaround everywhere.
	 * This is also more threadsafe than using inet_ntoa(). */
	ST(0) = sv_2mortal(Perl_newSVpvf(aTHX_ "%d.%d.%d.%d", /* IPv6? */
					 (int)((addr.s_addr >> 24) & 0xFF),
					 (int)((addr.s_addr >> 16) & 0xFF),
					 (int)((addr.s_addr >>  8) & 0xFF),
					 (int)( addr.s_addr        & 0xFF)));
	}
#line 1037 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_sockaddr_family); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_sockaddr_family)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sockaddr");
    {
	SV *	sockaddr = ST(0)
;
#line 833 "Socket.xs"
	STRLEN sockaddr_len;
	char *sockaddr_pv = SvPVbyte(sockaddr, sockaddr_len);
#line 1055 "Socket.c"
#line 836 "Socket.xs"
	if (sockaddr_len < STRUCT_OFFSET(struct sockaddr, sa_data))
		croak("Bad arg length for %s, length is %" UVuf
                      ", should be at least %" UVuf,
		      "Socket::sockaddr_family", (UV)sockaddr_len,
		      (UV)STRUCT_OFFSET(struct sockaddr, sa_data));
	ST(0) = sv_2mortal(newSViv(((struct sockaddr*)sockaddr_pv)->sa_family));
#line 1063 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_pack_sockaddr_un); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_pack_sockaddr_un)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pathname");
    {
	SV *	pathname = ST(0)
;
#line 847 "Socket.xs"
	{
#if defined(I_SYS_UN) || defined(WIN32)
	struct sockaddr_un sun_ad; /* fear using sun */
	STRLEN len;
	char * pathname_pv;
	int addr_len;

	if (!SvOK(pathname))
	    croak("Undefined path for %s", "Socket::pack_sockaddr_un");

	Zero(&sun_ad, sizeof(sun_ad), char);
	sun_ad.sun_family = AF_UNIX;
	pathname_pv = SvPV(pathname,len);
	if (len > sizeof(sun_ad.sun_path)) {
	    warn("Path length (%" UVuf ") is longer than maximum supported length"
	         " (%" UVuf ") and will be truncated",
	         (UV)len, (UV)sizeof(sun_ad.sun_path));
	    len = sizeof(sun_ad.sun_path);
	}
#  ifdef OS2	/* Name should start with \socket\ and contain backslashes! */
	{
		int off;
		char *s, *e;

		if (pathname_pv[0] != '/' && pathname_pv[0] != '\\')
			croak("Relative UNIX domain socket name '%s' unsupported",
			      pathname_pv);
		else if (len < 8
			 || pathname_pv[7] != '/' && pathname_pv[7] != '\\'
			 || !strnicmp(pathname_pv + 1, "socket", 6))
			off = 7;
		else
			off = 0;	/* Preserve names starting with \socket\ */
		Copy("\\socket", sun_ad.sun_path, off, char);
		Copy(pathname_pv, sun_ad.sun_path + off, len, char);

		s = sun_ad.sun_path + off - 1;
		e = s + len + 1;
		while (++s < e)
			if (*s = '/')
				*s = '\\';
	}
#  else	/* !( defined OS2 ) */
	Copy(pathname_pv, sun_ad.sun_path, len, char);
#  endif
	if (0) not_here("dummy");
	if (len > 1 && sun_ad.sun_path[0] == '\0') {
		/* Linux-style abstract-namespace socket.
		 * The name is not a file name, but an array of arbitrary
		 * character, starting with \0 and possibly including \0s,
		 * therefore the length of the structure must denote the
		 * end of that character array */
		addr_len = (char *)&(sun_ad.sun_path) - (char *)&sun_ad + len;
	} else {
		addr_len = sizeof(sun_ad);
	}
#  ifdef HAS_SOCKADDR_SA_LEN
	sun_ad.sun_len = addr_len;
#  endif
	ST(0) = sv_2mortal(newSVpvn((char *)&sun_ad, addr_len));
#else
	ST(0) = (SV*)not_here("pack_sockaddr_un");
#endif

	}
#line 1144 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_unpack_sockaddr_un); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_unpack_sockaddr_un)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sun_sv");
    {
	SV *	sun_sv = ST(0)
;
#line 917 "Socket.xs"
	{
#if defined(I_SYS_UN) || defined(WIN32)
	struct sockaddr_un addr;
	STRLEN sockaddrlen;
	char * sun_ad;
	int addr_len = 0;
	if (!SvOK(sun_sv))
	    croak("Undefined address for %s", "Socket::unpack_sockaddr_un");
	sun_ad = SvPVbyte(sun_sv,sockaddrlen);
#   if defined(__linux__) || defined(HAS_SOCKADDR_SA_LEN)
	/* On Linux or *BSD sockaddrlen on sockets returned by accept, recvfrom,
	   getpeername and getsockname is not equal to sizeof(addr). */
	if (sockaddrlen < sizeof(addr)) {
	  Copy(sun_ad, &addr, sockaddrlen, char);
	  Zero(((char*)&addr) + sockaddrlen, sizeof(addr) - sockaddrlen, char);
	} else {
	  Copy(sun_ad, &addr, sizeof(addr), char);
	}
#     ifdef HAS_SOCKADDR_SA_LEN
	/* In this case, sun_len must be checked */
	if (sockaddrlen != addr.sun_len)
		croak("Invalid arg sun_len field for %s, length is %" UVuf
                      ", but sun_len is %" UVuf,
		      "Socket::unpack_sockaddr_un", (UV)sockaddrlen, (UV)addr.sun_len);
#     endif
#   else
	if (sockaddrlen != sizeof(addr))
		croak("Bad arg length for %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::unpack_sockaddr_un", (UV)sockaddrlen, (UV)sizeof(addr));
	Copy(sun_ad, &addr, sizeof(addr), char);
#   endif

	if (addr.sun_family != AF_UNIX)
		croak("Bad address family for %s, got %d, should be %d",
		      "Socket::unpack_sockaddr_un", addr.sun_family, AF_UNIX);
#   ifdef __linux__
	if (addr.sun_path[0] == '\0') {
		/* Linux-style abstract socket address begins with a nul
		 * and can contain nuls. */
		addr_len = (char *)&addr - (char *)&(addr.sun_path) + sockaddrlen;
	} else
#   endif
	{
#   if defined(HAS_SOCKADDR_SA_LEN)
		/* On *BSD sun_path not always ends with a '\0' */
		int maxlen = addr.sun_len - 2; /* should use STRUCT_OFFSET(struct sockaddr_un, sun_path) instead of 2 */
		if (maxlen > (int)sizeof(addr.sun_path))
		  maxlen = (int)sizeof(addr.sun_path);
#   else
		const int maxlen = (int)sizeof(addr.sun_path);
#   endif
		while (addr_len < maxlen && addr.sun_path[addr_len])
		     addr_len++;
	}

	ST(0) = sv_2mortal(newSVpvn(addr.sun_path, addr_len));
#else
	ST(0) = (SV*)not_here("unpack_sockaddr_un");
#endif
	}
#line 1221 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_pack_sockaddr_in); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_pack_sockaddr_in)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "port_sv, ip_address_sv");
    {
	SV *	port_sv = ST(0)
;
	SV *	ip_address_sv = ST(1)
;
#line 984 "Socket.xs"
	{
	struct sockaddr_in sin;
	struct in_addr addr;
	STRLEN addrlen;
	unsigned short port = 0;
	char * ip_address;
	if (SvOK(port_sv)) {
		port = SvUV(port_sv);
		if (SvUV(port_sv) > 0xFFFF)
			warn("Port number above 0xFFFF, will be truncated to %d for %s",
				port, "Socket::pack_sockaddr_in");
	}
	if (!SvOK(ip_address_sv))
		croak("Undefined address for %s", "Socket::pack_sockaddr_in");
	if (DO_UTF8(ip_address_sv) && !sv_utf8_downgrade(ip_address_sv, 1))
		croak("Wide character in %s", "Socket::pack_sockaddr_in");
	ip_address = SvPVbyte(ip_address_sv, addrlen);
	if (addrlen == sizeof(addr) || addrlen == 4)
		addr.s_addr =
		    (unsigned int)(ip_address[0] & 0xFF) << 24 |
		    (unsigned int)(ip_address[1] & 0xFF) << 16 |
		    (unsigned int)(ip_address[2] & 0xFF) <<  8 |
		    (unsigned int)(ip_address[3] & 0xFF);
	else
		croak("Bad arg length for %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::pack_sockaddr_in",
		      (UV)addrlen, (UV)sizeof(addr));
	Zero(&sin, sizeof(sin), char);
	sin.sin_family = AF_INET;
	sin.sin_port = htons(port);
	sin.sin_addr.s_addr = htonl(addr.s_addr);
#  ifdef HAS_SOCKADDR_SA_LEN
	sin.sin_len = sizeof(sin);
#  endif
	ST(0) = sv_2mortal(newSVpvn((char *)&sin, sizeof(sin)));
	}
#line 1276 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_unpack_sockaddr_in); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_unpack_sockaddr_in)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sin_sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sin_sv = ST(0)
;
#line 1026 "Socket.xs"
	{
	STRLEN sockaddrlen;
	struct sockaddr_in addr;
	SV *ip_address_sv;
	char * sin;
	if (!SvOK(sin_sv))
	    croak("Undefined address for %s", "Socket::unpack_sockaddr_in");
	sin = SvPVbyte(sin_sv,sockaddrlen);
	if (sockaddrlen != sizeof(addr)) {
	    croak("Bad arg length for %s, length is %" UVuf
                  ", should be %" UVuf,
		  "Socket::unpack_sockaddr_in", (UV)sockaddrlen, (UV)sizeof(addr));
	}
	Copy(sin, &addr, sizeof(addr), char);
	if (addr.sin_family != AF_INET) {
	    croak("Bad address family for %s, got %d, should be %d",
		  "Socket::unpack_sockaddr_in", addr.sin_family, AF_INET);
	}
	ip_address_sv = newSVpvn((char *)&addr.sin_addr, sizeof(addr.sin_addr));

	if(GIMME_V == G_ARRAY) {
	    EXTEND(SP, 2);
	    mPUSHi(ntohs(addr.sin_port));
	    mPUSHs(ip_address_sv);
	}
	else {
	    mPUSHs(ip_address_sv);
	}
	}
#line 1323 "Socket.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Socket_pack_sockaddr_in6); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_pack_sockaddr_in6)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "port_sv, sin6_addr, scope_id=0, flowinfo=0");
    {
	SV *	port_sv = ST(0)
;
	SV *	sin6_addr = ST(1)
;
	unsigned long	scope_id;
	unsigned long	flowinfo;

	if (items < 3)
	    scope_id = 0;
	else {
	    scope_id = (unsigned long)SvUV(ST(2))
;
	}

	if (items < 4)
	    flowinfo = 0;
	else {
	    flowinfo = (unsigned long)SvUV(ST(3))
;
	}
#line 1063 "Socket.xs"
	{
#ifdef HAS_SOCKADDR_IN6
	unsigned short port = 0;
	struct sockaddr_in6 sin6;
	char * addrbytes;
	STRLEN addrlen;
	if (SvOK(port_sv)) {
		port = SvUV(port_sv);
		if (SvUV(port_sv) > 0xFFFF)
			warn("Port number above 0xFFFF, will be truncated to %d for %s",
				port, "Socket::pack_sockaddr_in6");
	}
	if (!SvOK(sin6_addr))
		croak("Undefined address for %s", "Socket::pack_sockaddr_in6");
	if (DO_UTF8(sin6_addr) && !sv_utf8_downgrade(sin6_addr, 1))
		croak("Wide character in %s", "Socket::pack_sockaddr_in6");
	addrbytes = SvPVbyte(sin6_addr, addrlen);
	if (addrlen != sizeof(sin6.sin6_addr))
		croak("Bad arg length %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::pack_sockaddr_in6", (UV)addrlen, (UV)sizeof(sin6.sin6_addr));
	Zero(&sin6, sizeof(sin6), char);
	sin6.sin6_family = AF_INET6;
	sin6.sin6_port = htons(port);
	sin6.sin6_flowinfo = htonl(flowinfo);
	Copy(addrbytes, &sin6.sin6_addr, sizeof(sin6.sin6_addr), char);
#  ifdef HAS_SIN6_SCOPE_ID
	sin6.sin6_scope_id = scope_id;
#  else
	if (scope_id != 0)
	    warn("%s cannot represent non-zero scope_id %d",
		 "Socket::pack_sockaddr_in6", scope_id);
#  endif
#  ifdef HAS_SOCKADDR_SA_LEN
	sin6.sin6_len = sizeof(sin6);
#  endif
	ST(0) = sv_2mortal(newSVpvn((char *)&sin6, sizeof(sin6)));
#else
	PERL_UNUSED_VAR(port_sv);
	PERL_UNUSED_VAR(sin6_addr);
	ST(0) = (SV*)not_here("pack_sockaddr_in6");
#endif
	}
#line 1401 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_unpack_sockaddr_in6); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_unpack_sockaddr_in6)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sin6_sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sin6_sv = ST(0)
;
#line 1111 "Socket.xs"
	{
#ifdef HAS_SOCKADDR_IN6
	STRLEN addrlen;
	struct sockaddr_in6 sin6;
	char * addrbytes;
	SV *ip_address_sv;
	if (!SvOK(sin6_sv))
		croak("Undefined address for %s", "Socket::unpack_sockaddr_in6");
	addrbytes = SvPVbyte(sin6_sv, addrlen);
	if (addrlen != sizeof(sin6))
		croak("Bad arg length for %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::unpack_sockaddr_in6", (UV)addrlen, (UV)sizeof(sin6));
	Copy(addrbytes, &sin6, sizeof(sin6), char);
	if (sin6.sin6_family != AF_INET6)
		croak("Bad address family for %s, got %d, should be %d",
		      "Socket::unpack_sockaddr_in6", sin6.sin6_family, AF_INET6);
	ip_address_sv = newSVpvn((char *)&sin6.sin6_addr, sizeof(sin6.sin6_addr));

	if(GIMME_V == G_ARRAY) {
	    EXTEND(SP, 4);
	    mPUSHi(ntohs(sin6.sin6_port));
	    mPUSHs(ip_address_sv);
#  ifdef HAS_SIN6_SCOPE_ID
	    mPUSHi(sin6.sin6_scope_id);
#  else
	    mPUSHi(0);
#  endif
	    mPUSHi(ntohl(sin6.sin6_flowinfo));
	}
	else {
	    mPUSHs(ip_address_sv);
	}
#else
	PERL_UNUSED_VAR(sin6_sv);
	ST(0) = (SV*)not_here("pack_sockaddr_in6");
#endif
	}
#line 1457 "Socket.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Socket_inet_ntop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_inet_ntop)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "af, ip_address_sv");
    {
	int	af = (int)SvIV(ST(0))
;
	SV *	ip_address_sv = ST(1)
;
#line 1155 "Socket.xs"
#ifdef HAS_INETNTOP
	STRLEN addrlen;
#ifdef AF_INET6
	struct in6_addr addr;
	char str[INET6_ADDRSTRLEN];
#else
	struct in_addr addr;
	char str[INET_ADDRSTRLEN];
#endif
	char *ip_address;

	if (DO_UTF8(ip_address_sv) && !sv_utf8_downgrade(ip_address_sv, 1))
		croak("Wide character in %s", "Socket::inet_ntop");

	ip_address = SvPV(ip_address_sv, addrlen);

	switch(af) {
	  case AF_INET:
	    if(addrlen != 4)
		croak("Bad address length for Socket::inet_ntop on AF_INET;"
		      " got %" UVuf ", should be 4", (UV)addrlen);
	    break;
#ifdef AF_INET6
	  case AF_INET6:
	    if(addrlen != 16)
		croak("Bad address length for Socket::inet_ntop on AF_INET6;"
		      " got %" UVuf ", should be 16", (UV)addrlen);
	    break;
#endif
	  default:
		croak("Bad address family for %s, got %d, should be"
#ifdef AF_INET6
		      " either AF_INET or AF_INET6",
#else
		      " AF_INET",
#endif
		      "Socket::inet_ntop", af);
	}

	if(addrlen < sizeof(addr)) {
	    Copy(ip_address, &addr, addrlen, char);
	    Zero(((char*)&addr) + addrlen, sizeof(addr) - addrlen, char);
	}
	else {
	    Copy(ip_address, &addr, sizeof addr, char);
	}
	inet_ntop(af, &addr, str, sizeof str);

	ST(0) = sv_2mortal(newSVpvn(str, strlen(str)));
#else
	PERL_UNUSED_VAR(af);
	PERL_UNUSED_VAR(ip_address_sv);
	ST(0) = (SV*)not_here("inet_ntop");
#endif
#line 1530 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_inet_pton); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_inet_pton)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "af, host");
    {
	int	af = (int)SvIV(ST(0))
;
	const char *	host = (const char *)SvPV_nolen(ST(1))
;
#line 1215 "Socket.xs"
#ifdef HAS_INETPTON
	int ok;
	int addrlen = 0;
#ifdef AF_INET6
	struct in6_addr ip_address;
#else
	struct in_addr ip_address;
#endif

	switch(af) {
	  case AF_INET:
	    addrlen = 4;
	    break;
#ifdef AF_INET6
	  case AF_INET6:
	    addrlen = 16;
	    break;
#endif
	  default:
		croak("Bad address family for %s, got %d, should be"
#ifdef AF_INET6
		      " either AF_INET or AF_INET6",
#else
		      " AF_INET",
#endif
		      "Socket::inet_pton", af);
	}
	ok = (*host != '\0') && inet_pton(af, host, &ip_address);

	ST(0) = sv_newmortal();
	if (ok) {
		sv_setpvn( ST(0), (char *)&ip_address, addrlen);
	}
#else
	PERL_UNUSED_VAR(af);
	PERL_UNUSED_VAR(host);
	ST(0) = (SV*)not_here("inet_pton");
#endif
#line 1586 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_pack_ip_mreq); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_pack_ip_mreq)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "multiaddr, interface=&PL_sv_undef");
    {
	SV *	multiaddr = ST(0)
;
	SV *	interface;

	if (items < 2)
	    interface = &PL_sv_undef;
	else {
	    interface = ST(1)
;
	}
#line 1259 "Socket.xs"
	{
#ifdef HAS_IP_MREQ
	struct ip_mreq mreq;
	char * multiaddrbytes;
	char * interfacebytes;
	STRLEN len;
	if (DO_UTF8(multiaddr) && !sv_utf8_downgrade(multiaddr, 1))
		croak("Wide character in %s", "Socket::pack_ip_mreq");
	multiaddrbytes = SvPVbyte(multiaddr, len);
	if (len != sizeof(mreq.imr_multiaddr))
		croak("Bad arg length %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::pack_ip_mreq", (UV)len, (UV)sizeof(mreq.imr_multiaddr));
	Zero(&mreq, sizeof(mreq), char);
	Copy(multiaddrbytes, &mreq.imr_multiaddr, sizeof(mreq.imr_multiaddr), char);
	if(SvOK(interface)) {
		if (DO_UTF8(interface) && !sv_utf8_downgrade(interface, 1))
			croak("Wide character in %s", "Socket::pack_ip_mreq");
		interfacebytes = SvPVbyte(interface, len);
		if (len != sizeof(mreq.imr_interface))
			croak("Bad arg length %s, length is %" UVuf
                              ", should be %" UVuf,
			      "Socket::pack_ip_mreq", (UV)len, (UV)sizeof(mreq.imr_interface));
		Copy(interfacebytes, &mreq.imr_interface, sizeof(mreq.imr_interface), char);
	}
	else
		mreq.imr_interface.s_addr = INADDR_ANY;
	ST(0) = sv_2mortal(newSVpvn((char *)&mreq, sizeof(mreq)));
#else
	not_here("pack_ip_mreq");
#endif
	}
#line 1642 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_unpack_ip_mreq); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_unpack_ip_mreq)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "mreq_sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	mreq_sv = ST(0)
;
#line 1296 "Socket.xs"
	{
#ifdef HAS_IP_MREQ
	struct ip_mreq mreq;
	STRLEN mreqlen;
	char * mreqbytes = SvPVbyte(mreq_sv, mreqlen);
	if (mreqlen != sizeof(mreq))
		croak("Bad arg length for %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::unpack_ip_mreq", (UV)mreqlen, (UV)sizeof(mreq));
	Copy(mreqbytes, &mreq, sizeof(mreq), char);
	EXTEND(SP, 2);
	mPUSHp((char *)&mreq.imr_multiaddr, sizeof(mreq.imr_multiaddr));
	mPUSHp((char *)&mreq.imr_interface, sizeof(mreq.imr_interface));
#else
	not_here("unpack_ip_mreq");
#endif
	}
#line 1677 "Socket.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Socket_pack_ip_mreq_source); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_pack_ip_mreq_source)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "multiaddr, source, interface=&PL_sv_undef");
    {
	SV *	multiaddr = ST(0)
;
	SV *	source = ST(1)
;
	SV *	interface;

	if (items < 3)
	    interface = &PL_sv_undef;
	else {
	    interface = ST(2)
;
	}
#line 1320 "Socket.xs"
	{
#if defined(HAS_IP_MREQ_SOURCE) && defined (IP_ADD_SOURCE_MEMBERSHIP)
	struct ip_mreq_source mreq;
	char * multiaddrbytes;
	char * sourcebytes;
	char * interfacebytes;
	STRLEN len;
	if (DO_UTF8(multiaddr) && !sv_utf8_downgrade(multiaddr, 1))
		croak("Wide character in %s", "Socket::pack_ip_mreq_source");
	multiaddrbytes = SvPVbyte(multiaddr, len);
	if (len != sizeof(mreq.imr_multiaddr))
		croak("Bad arg length %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::pack_ip_mreq", (UV)len, (UV)sizeof(mreq.imr_multiaddr));
	if (DO_UTF8(source) && !sv_utf8_downgrade(source, 1))
		croak("Wide character in %s", "Socket::pack_ip_mreq_source");
	if (len != sizeof(mreq.imr_sourceaddr))
		croak("Bad arg length %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::pack_ip_mreq", (UV)len, (UV)sizeof(mreq.imr_sourceaddr));
	sourcebytes = SvPVbyte(source, len);
	Zero(&mreq, sizeof(mreq), char);
	Copy(multiaddrbytes, &mreq.imr_multiaddr, sizeof(mreq.imr_multiaddr), char);
	Copy(sourcebytes, &mreq.imr_sourceaddr, sizeof(mreq.imr_sourceaddr), char);
	if(SvOK(interface)) {
		if (DO_UTF8(interface) && !sv_utf8_downgrade(interface, 1))
			croak("Wide character in %s", "Socket::pack_ip_mreq");
		interfacebytes = SvPVbyte(interface, len);
		if (len != sizeof(mreq.imr_interface))
			croak("Bad arg length %s, length is %" UVuf
                              ", should be %" UVuf,
			      "Socket::pack_ip_mreq", (UV)len, (UV)sizeof(mreq.imr_interface));
		Copy(interfacebytes, &mreq.imr_interface, sizeof(mreq.imr_interface), char);
	}
	else
		mreq.imr_interface.s_addr = INADDR_ANY;
	ST(0) = sv_2mortal(newSVpvn((char *)&mreq, sizeof(mreq)));
#else
	PERL_UNUSED_VAR(multiaddr);
	PERL_UNUSED_VAR(source);
	not_here("pack_ip_mreq_source");
#endif
	}
#line 1747 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_unpack_ip_mreq_source); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_unpack_ip_mreq_source)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "mreq_sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	mreq_sv = ST(0)
;
#line 1368 "Socket.xs"
	{
#if defined(HAS_IP_MREQ_SOURCE) && defined (IP_ADD_SOURCE_MEMBERSHIP)
	struct ip_mreq_source mreq;
	STRLEN mreqlen;
	char * mreqbytes = SvPVbyte(mreq_sv, mreqlen);
	if (mreqlen != sizeof(mreq))
		croak("Bad arg length for %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::unpack_ip_mreq_source", (UV)mreqlen, (UV)sizeof(mreq));
	Copy(mreqbytes, &mreq, sizeof(mreq), char);
	EXTEND(SP, 3);
	mPUSHp((char *)&mreq.imr_multiaddr, sizeof(mreq.imr_multiaddr));
	mPUSHp((char *)&mreq.imr_sourceaddr, sizeof(mreq.imr_sourceaddr));
	mPUSHp((char *)&mreq.imr_interface, sizeof(mreq.imr_interface));
#else
	PERL_UNUSED_VAR(mreq_sv);
	not_here("unpack_ip_mreq_source");
#endif
	}
#line 1784 "Socket.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Socket_pack_ipv6_mreq); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_pack_ipv6_mreq)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "multiaddr, ifindex");
    {
	SV *	multiaddr = ST(0)
;
	unsigned int	ifindex = (unsigned int)SvUV(ST(1))
;
#line 1393 "Socket.xs"
	{
#ifdef HAS_IPV6_MREQ
	struct ipv6_mreq mreq;
	char * multiaddrbytes;
	STRLEN len;
	if (DO_UTF8(multiaddr) && !sv_utf8_downgrade(multiaddr, 1))
		croak("Wide character in %s", "Socket::pack_ipv6_mreq");
	multiaddrbytes = SvPVbyte(multiaddr, len);
	if (len != sizeof(mreq.ipv6mr_multiaddr))
		croak("Bad arg length %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::pack_ipv6_mreq", (UV)len, (UV)sizeof(mreq.ipv6mr_multiaddr));
	Zero(&mreq, sizeof(mreq), char);
	Copy(multiaddrbytes, &mreq.ipv6mr_multiaddr, sizeof(mreq.ipv6mr_multiaddr), char);
	mreq.ipv6mr_interface = ifindex;
	ST(0) = sv_2mortal(newSVpvn((char *)&mreq, sizeof(mreq)));
#else
	PERL_UNUSED_VAR(multiaddr);
	PERL_UNUSED_VAR(ifindex);
	not_here("pack_ipv6_mreq");
#endif
	}
#line 1825 "Socket.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Socket_unpack_ipv6_mreq); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Socket_unpack_ipv6_mreq)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "mreq_sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	mreq_sv = ST(0)
;
#line 1420 "Socket.xs"
	{
#ifdef HAS_IPV6_MREQ
	struct ipv6_mreq mreq;
	STRLEN mreqlen;
	char * mreqbytes = SvPVbyte(mreq_sv, mreqlen);
	if (mreqlen != sizeof(mreq))
		croak("Bad arg length for %s, length is %" UVuf
                      ", should be %" UVuf,
		      "Socket::unpack_ipv6_mreq", (UV)mreqlen, (UV)sizeof(mreq));
	Copy(mreqbytes, &mreq, sizeof(mreq), char);
	EXTEND(SP, 2);
	mPUSHp((char *)&mreq.ipv6mr_multiaddr, sizeof(mreq.ipv6mr_multiaddr));
	mPUSHi(mreq.ipv6mr_interface);
#else
	PERL_UNUSED_VAR(mreq_sv);
	not_here("unpack_ipv6_mreq");
#endif
	}
#line 1861 "Socket.c"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Socket); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Socket)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Socket::AUTOLOAD", XS_Socket_AUTOLOAD);
        newXS_deffile("Socket::inet_aton", XS_Socket_inet_aton);
        newXS_deffile("Socket::inet_ntoa", XS_Socket_inet_ntoa);
        newXS_deffile("Socket::sockaddr_family", XS_Socket_sockaddr_family);
        newXS_deffile("Socket::pack_sockaddr_un", XS_Socket_pack_sockaddr_un);
        newXS_deffile("Socket::unpack_sockaddr_un", XS_Socket_unpack_sockaddr_un);
        newXS_deffile("Socket::pack_sockaddr_in", XS_Socket_pack_sockaddr_in);
        newXS_deffile("Socket::unpack_sockaddr_in", XS_Socket_unpack_sockaddr_in);
        newXS_deffile("Socket::pack_sockaddr_in6", XS_Socket_pack_sockaddr_in6);
        newXS_deffile("Socket::unpack_sockaddr_in6", XS_Socket_unpack_sockaddr_in6);
        newXS_deffile("Socket::inet_ntop", XS_Socket_inet_ntop);
        newXS_deffile("Socket::inet_pton", XS_Socket_inet_pton);
        newXS_deffile("Socket::pack_ip_mreq", XS_Socket_pack_ip_mreq);
        newXS_deffile("Socket::unpack_ip_mreq", XS_Socket_unpack_ip_mreq);
        newXS_deffile("Socket::pack_ip_mreq_source", XS_Socket_pack_ip_mreq_source);
        newXS_deffile("Socket::unpack_ip_mreq_source", XS_Socket_unpack_ip_mreq_source);
        newXS_deffile("Socket::pack_ipv6_mreq", XS_Socket_pack_ipv6_mreq);
        newXS_deffile("Socket::unpack_ipv6_mreq", XS_Socket_unpack_ipv6_mreq);

    /* Initialisation Section */

#line 2 "./const-xs.inc"
  {
#if defined(dTHX) && !defined(PERL_NO_GET_CONTEXT)
    dTHX;
#endif
    HV *symbol_table = get_hv("Socket::", GV_ADD);

    static const struct iv_s values_for_iv[] =
      {
#ifdef AF_802
        { "AF_802", 6, AF_802 },
#endif
#ifdef AF_AAL
        { "AF_AAL", 6, AF_AAL },
#endif
#ifdef AF_APPLETALK
        { "AF_APPLETALK", 12, AF_APPLETALK },
#endif
#ifdef AF_CCITT
        { "AF_CCITT", 8, AF_CCITT },
#endif
#ifdef AF_CHAOS
        { "AF_CHAOS", 8, AF_CHAOS },
#endif
#ifdef AF_CTF
        { "AF_CTF", 6, AF_CTF },
#endif
#ifdef AF_DATAKIT
        { "AF_DATAKIT", 10, AF_DATAKIT },
#endif
#ifdef AF_DECnet
        { "AF_DECnet", 9, AF_DECnet },
#endif
#ifdef AF_DLI
        { "AF_DLI", 6, AF_DLI },
#endif
#ifdef AF_ECMA
        { "AF_ECMA", 7, AF_ECMA },
#endif
#ifdef AF_GOSIP
        { "AF_GOSIP", 8, AF_GOSIP },
#endif
#ifdef AF_HYLINK
        { "AF_HYLINK", 9, AF_HYLINK },
#endif
#ifdef AF_IMPLINK
        { "AF_IMPLINK", 10, AF_IMPLINK },
#endif
#ifdef AF_INET
        { "AF_INET", 7, AF_INET },
#endif
#ifdef AF_INET6
        { "AF_INET6", 8, AF_INET6 },
#endif
#ifdef AF_ISO
        { "AF_ISO", 6, AF_ISO },
#endif
#ifdef AF_KEY
        { "AF_KEY", 6, AF_KEY },
#endif
#ifdef AF_LAST
        { "AF_LAST", 7, AF_LAST },
#endif
#ifdef AF_LAT
        { "AF_LAT", 6, AF_LAT },
#endif
#ifdef AF_LINK
        { "AF_LINK", 7, AF_LINK },
#endif
#ifdef AF_LOCAL
        { "AF_LOCAL", 8, AF_LOCAL },
#endif
#ifdef AF_MAX
        { "AF_MAX", 6, AF_MAX },
#endif
#ifdef AF_NBS
        { "AF_NBS", 6, AF_NBS },
#endif
#ifdef AF_NIT
        { "AF_NIT", 6, AF_NIT },
#endif
#ifdef AF_NS
        { "AF_NS", 5, AF_NS },
#endif
#ifdef AF_OSI
        { "AF_OSI", 6, AF_OSI },
#endif
#ifdef AF_OSINET
        { "AF_OSINET", 9, AF_OSINET },
#endif
#ifdef AF_PUP
        { "AF_PUP", 6, AF_PUP },
#endif
#ifdef AF_ROUTE
        { "AF_ROUTE", 8, AF_ROUTE },
#endif
#ifdef AF_SNA
        { "AF_SNA", 6, AF_SNA },
#endif
#ifdef AF_UNIX
        { "AF_UNIX", 7, AF_UNIX },
#endif
#ifdef AF_UNSPEC
        { "AF_UNSPEC", 9, AF_UNSPEC },
#endif
#ifdef AF_USER
        { "AF_USER", 7, AF_USER },
#endif
#ifdef AF_WAN
        { "AF_WAN", 6, AF_WAN },
#endif
#ifdef AF_X25
        { "AF_X25", 6, AF_X25 },
#endif
#ifdef AI_ADDRCONFIG
        { "AI_ADDRCONFIG", 13, AI_ADDRCONFIG },
#endif
#ifdef AI_ALL
        { "AI_ALL", 6, AI_ALL },
#endif
#ifdef AI_CANONIDN
        { "AI_CANONIDN", 11, AI_CANONIDN },
#endif
#ifdef AI_CANONNAME
        { "AI_CANONNAME", 12, AI_CANONNAME },
#endif
#ifdef AI_IDN
        { "AI_IDN", 6, AI_IDN },
#endif
#ifdef AI_NUMERICHOST
        { "AI_NUMERICHOST", 14, AI_NUMERICHOST },
#endif
#ifdef AI_NUMERICSERV
        { "AI_NUMERICSERV", 14, AI_NUMERICSERV },
#endif
#ifdef AI_PASSIVE
        { "AI_PASSIVE", 10, AI_PASSIVE },
#endif
#ifdef AI_V4MAPPED
        { "AI_V4MAPPED", 11, AI_V4MAPPED },
#endif
#ifdef EAI_ADDRFAMILY
        { "EAI_ADDRFAMILY", 14, EAI_ADDRFAMILY },
#endif
#ifdef EAI_AGAIN
        { "EAI_AGAIN", 9, EAI_AGAIN },
#endif
#ifdef EAI_BADFLAGS
        { "EAI_BADFLAGS", 12, EAI_BADFLAGS },
#endif
#ifdef EAI_BADHINTS
        { "EAI_BADHINTS", 12, EAI_BADHINTS },
#endif
#ifdef EAI_FAIL
        { "EAI_FAIL", 8, EAI_FAIL },
#endif
#ifdef EAI_FAMILY
        { "EAI_FAMILY", 10, EAI_FAMILY },
#endif
#ifdef EAI_NODATA
        { "EAI_NODATA", 10, EAI_NODATA },
#endif
#ifdef EAI_NONAME
        { "EAI_NONAME", 10, EAI_NONAME },
#endif
#ifdef EAI_PROTOCOL
        { "EAI_PROTOCOL", 12, EAI_PROTOCOL },
#endif
#ifdef EAI_SERVICE
        { "EAI_SERVICE", 11, EAI_SERVICE },
#endif
#ifdef EAI_SOCKTYPE
        { "EAI_SOCKTYPE", 12, EAI_SOCKTYPE },
#endif
#ifdef EAI_SYSTEM
        { "EAI_SYSTEM", 10, EAI_SYSTEM },
#endif
#ifdef IOV_MAX
        { "IOV_MAX", 7, IOV_MAX },
#endif
#ifdef IP_ADD_MEMBERSHIP
        { "IP_ADD_MEMBERSHIP", 17, IP_ADD_MEMBERSHIP },
#endif
#ifdef IP_ADD_SOURCE_MEMBERSHIP
        { "IP_ADD_SOURCE_MEMBERSHIP", 24, IP_ADD_SOURCE_MEMBERSHIP },
#endif
#ifdef IP_BIND_ADDRESS_NO_PORT
        { "IP_BIND_ADDRESS_NO_PORT", 23, IP_BIND_ADDRESS_NO_PORT },
#endif
#ifdef IP_DROP_MEMBERSHIP
        { "IP_DROP_MEMBERSHIP", 18, IP_DROP_MEMBERSHIP },
#endif
#ifdef IP_DROP_SOURCE_MEMBERSHIP
        { "IP_DROP_SOURCE_MEMBERSHIP", 25, IP_DROP_SOURCE_MEMBERSHIP },
#endif
#ifdef IP_FREEBIND
        { "IP_FREEBIND", 11, IP_FREEBIND },
#endif
#ifdef IP_HDRINCL
        { "IP_HDRINCL", 10, IP_HDRINCL },
#endif
#ifdef IP_MULTICAST_ALL
        { "IP_MULTICAST_ALL", 16, IP_MULTICAST_ALL },
#endif
#ifdef IP_MULTICAST_IF
        { "IP_MULTICAST_IF", 15, IP_MULTICAST_IF },
#endif
#ifdef IP_MULTICAST_LOOP
        { "IP_MULTICAST_LOOP", 17, IP_MULTICAST_LOOP },
#endif
#ifdef IP_MULTICAST_TTL
        { "IP_MULTICAST_TTL", 16, IP_MULTICAST_TTL },
#endif
#ifdef IP_MTU
        { "IP_MTU", 6, IP_MTU },
#endif
#ifdef IP_MTU_DISCOVER
        { "IP_MTU_DISCOVER", 15, IP_MTU_DISCOVER },
#endif
#ifdef IP_NODEFRAG
        { "IP_NODEFRAG", 11, IP_NODEFRAG },
#endif
#ifdef IP_OPTIONS
        { "IP_OPTIONS", 10, IP_OPTIONS },
#endif
#ifdef IP_RECVERR
        { "IP_RECVERR", 10, IP_RECVERR },
#endif
#ifdef IP_RECVOPTS
        { "IP_RECVOPTS", 11, IP_RECVOPTS },
#endif
#ifdef IP_RECVRETOPTS
        { "IP_RECVRETOPTS", 14, IP_RECVRETOPTS },
#endif
#ifdef IP_RETOPTS
        { "IP_RETOPTS", 10, IP_RETOPTS },
#endif
#ifdef IP_TOS
        { "IP_TOS", 6, IP_TOS },
#endif
#ifdef IP_TRANSPARENT
        { "IP_TRANSPARENT", 14, IP_TRANSPARENT },
#endif
#ifdef IP_TTL
        { "IP_TTL", 6, IP_TTL },
#endif
#ifdef IP_PMTUDISC_DO
        { "IP_PMTUDISC_DO", 14, IP_PMTUDISC_DO },
#endif
#ifdef IP_PMTUDISC_DONT
        { "IP_PMTUDISC_DONT", 16, IP_PMTUDISC_DONT },
#endif
#ifdef IP_PMTUDISC_PROBE
        { "IP_PMTUDISC_PROBE", 17, IP_PMTUDISC_PROBE },
#endif
#ifdef IP_PMTUDISC_WANT
        { "IP_PMTUDISC_WANT", 16, IP_PMTUDISC_WANT },
#endif
#ifdef IPTOS_LOWDELAY
        { "IPTOS_LOWDELAY", 14, IPTOS_LOWDELAY },
#endif
#ifdef IPTOS_THROUGHPUT
        { "IPTOS_THROUGHPUT", 16, IPTOS_THROUGHPUT },
#endif
#ifdef IPTOS_RELIABILITY
        { "IPTOS_RELIABILITY", 17, IPTOS_RELIABILITY },
#endif
#ifdef IPTOS_MINCOST
        { "IPTOS_MINCOST", 13, IPTOS_MINCOST },
#endif
#ifdef IPV6_ADDRFROM
        { "IPV6_ADDRFROM", 13, IPV6_ADDRFROM },
#endif
#ifdef IPV6_ADD_MEMBERSHIP
        { "IPV6_ADD_MEMBERSHIP", 19, IPV6_ADD_MEMBERSHIP },
#endif
#ifdef IPV6_DROP_MEMBERSHIP
        { "IPV6_DROP_MEMBERSHIP", 20, IPV6_DROP_MEMBERSHIP },
#endif
#ifdef IPV6_JOIN_GROUP
        { "IPV6_JOIN_GROUP", 15, IPV6_JOIN_GROUP },
#endif
#ifdef IPV6_LEAVE_GROUP
        { "IPV6_LEAVE_GROUP", 16, IPV6_LEAVE_GROUP },
#endif
#ifdef IPV6_MTU
        { "IPV6_MTU", 8, IPV6_MTU },
#endif
#ifdef IPV6_MTU_DISCOVER
        { "IPV6_MTU_DISCOVER", 17, IPV6_MTU_DISCOVER },
#endif
#ifdef IPV6_MULTICAST_HOPS
        { "IPV6_MULTICAST_HOPS", 19, IPV6_MULTICAST_HOPS },
#endif
#ifdef IPV6_MULTICAST_IF
        { "IPV6_MULTICAST_IF", 17, IPV6_MULTICAST_IF },
#endif
#ifdef IPV6_MULTICAST_LOOP
        { "IPV6_MULTICAST_LOOP", 19, IPV6_MULTICAST_LOOP },
#endif
#ifdef IPV6_RECVERR
        { "IPV6_RECVERR", 12, IPV6_RECVERR },
#endif
#ifdef IPV6_ROUTER_ALERT
        { "IPV6_ROUTER_ALERT", 17, IPV6_ROUTER_ALERT },
#endif
#ifdef IPV6_UNICAST_HOPS
        { "IPV6_UNICAST_HOPS", 17, IPV6_UNICAST_HOPS },
#endif
#ifdef IPV6_V6ONLY
        { "IPV6_V6ONLY", 11, IPV6_V6ONLY },
#endif
#ifdef MSG_BCAST
        { "MSG_BCAST", 9, MSG_BCAST },
#endif
#ifdef MSG_BTAG
        { "MSG_BTAG", 8, MSG_BTAG },
#endif
#ifdef MSG_CTLFLAGS
        { "MSG_CTLFLAGS", 12, MSG_CTLFLAGS },
#endif
#ifdef MSG_CTLIGNORE
        { "MSG_CTLIGNORE", 13, MSG_CTLIGNORE },
#endif
#ifdef MSG_DONTWAIT
        { "MSG_DONTWAIT", 12, MSG_DONTWAIT },
#endif
#ifdef MSG_EOF
        { "MSG_EOF", 7, MSG_EOF },
#endif
#ifdef MSG_EOR
        { "MSG_EOR", 7, MSG_EOR },
#endif
#ifdef MSG_ERRQUEUE
        { "MSG_ERRQUEUE", 12, MSG_ERRQUEUE },
#endif
#ifdef MSG_ETAG
        { "MSG_ETAG", 8, MSG_ETAG },
#endif
#ifdef MSG_FASTOPEN
        { "MSG_FASTOPEN", 12, MSG_FASTOPEN },
#endif
#ifdef MSG_FIN
        { "MSG_FIN", 7, MSG_FIN },
#endif
#ifdef MSG_MAXIOVLEN
        { "MSG_MAXIOVLEN", 13, MSG_MAXIOVLEN },
#endif
#ifdef MSG_MCAST
        { "MSG_MCAST", 9, MSG_MCAST },
#endif
#ifdef MSG_NOSIGNAL
        { "MSG_NOSIGNAL", 12, MSG_NOSIGNAL },
#endif
#ifdef MSG_RST
        { "MSG_RST", 7, MSG_RST },
#endif
#ifdef MSG_SYN
        { "MSG_SYN", 7, MSG_SYN },
#endif
#ifdef MSG_TRUNC
        { "MSG_TRUNC", 9, MSG_TRUNC },
#endif
#ifdef MSG_URG
        { "MSG_URG", 7, MSG_URG },
#endif
#ifdef MSG_WAITALL
        { "MSG_WAITALL", 11, MSG_WAITALL },
#endif
#ifdef MSG_WIRE
        { "MSG_WIRE", 8, MSG_WIRE },
#endif
#ifdef NI_DGRAM
        { "NI_DGRAM", 8, NI_DGRAM },
#endif
#ifdef NI_IDN
        { "NI_IDN", 6, NI_IDN },
#endif
#ifdef NI_NAMEREQD
        { "NI_NAMEREQD", 11, NI_NAMEREQD },
#endif
#ifdef NI_NOFQDN
        { "NI_NOFQDN", 9, NI_NOFQDN },
#endif
#ifdef NI_NUMERICHOST
        { "NI_NUMERICHOST", 14, NI_NUMERICHOST },
#endif
#ifdef NI_NUMERICSERV
        { "NI_NUMERICSERV", 14, NI_NUMERICSERV },
#endif
#ifdef PF_802
        { "PF_802", 6, PF_802 },
#endif
#ifdef PF_AAL
        { "PF_AAL", 6, PF_AAL },
#endif
#ifdef PF_APPLETALK
        { "PF_APPLETALK", 12, PF_APPLETALK },
#endif
#ifdef PF_CCITT
        { "PF_CCITT", 8, PF_CCITT },
#endif
#ifdef PF_CHAOS
        { "PF_CHAOS", 8, PF_CHAOS },
#endif
#ifdef PF_CTF
        { "PF_CTF", 6, PF_CTF },
#endif
#ifdef PF_DATAKIT
        { "PF_DATAKIT", 10, PF_DATAKIT },
#endif
#ifdef PF_DECnet
        { "PF_DECnet", 9, PF_DECnet },
#endif
#ifdef PF_DLI
        { "PF_DLI", 6, PF_DLI },
#endif
#ifdef PF_ECMA
        { "PF_ECMA", 7, PF_ECMA },
#endif
#ifdef PF_GOSIP
        { "PF_GOSIP", 8, PF_GOSIP },
#endif
#ifdef PF_HYLINK
        { "PF_HYLINK", 9, PF_HYLINK },
#endif
#ifdef PF_IMPLINK
        { "PF_IMPLINK", 10, PF_IMPLINK },
#endif
#ifdef PF_INET
        { "PF_INET", 7, PF_INET },
#endif
#ifdef PF_INET6
        { "PF_INET6", 8, PF_INET6 },
#endif
#ifdef PF_ISO
        { "PF_ISO", 6, PF_ISO },
#endif
#ifdef PF_KEY
        { "PF_KEY", 6, PF_KEY },
#endif
#ifdef PF_LAST
        { "PF_LAST", 7, PF_LAST },
#endif
#ifdef PF_LAT
        { "PF_LAT", 6, PF_LAT },
#endif
#ifdef PF_LINK
        { "PF_LINK", 7, PF_LINK },
#endif
#ifdef PF_LOCAL
        { "PF_LOCAL", 8, PF_LOCAL },
#endif
#ifdef PF_MAX
        { "PF_MAX", 6, PF_MAX },
#endif
#ifdef PF_NBS
        { "PF_NBS", 6, PF_NBS },
#endif
#ifdef PF_NIT
        { "PF_NIT", 6, PF_NIT },
#endif
#ifdef PF_NS
        { "PF_NS", 5, PF_NS },
#endif
#ifdef PF_OSI
        { "PF_OSI", 6, PF_OSI },
#endif
#ifdef PF_OSINET
        { "PF_OSINET", 9, PF_OSINET },
#endif
#ifdef PF_PUP
        { "PF_PUP", 6, PF_PUP },
#endif
#ifdef PF_ROUTE
        { "PF_ROUTE", 8, PF_ROUTE },
#endif
#ifdef PF_SNA
        { "PF_SNA", 6, PF_SNA },
#endif
#ifdef PF_UNIX
        { "PF_UNIX", 7, PF_UNIX },
#endif
#ifdef PF_UNSPEC
        { "PF_UNSPEC", 9, PF_UNSPEC },
#endif
#ifdef PF_USER
        { "PF_USER", 7, PF_USER },
#endif
#ifdef PF_WAN
        { "PF_WAN", 6, PF_WAN },
#endif
#ifdef PF_X25
        { "PF_X25", 6, PF_X25 },
#endif
#ifdef SCM_CONNECT
        { "SCM_CONNECT", 11, SCM_CONNECT },
#endif
#ifdef SCM_CREDENTIALS
        { "SCM_CREDENTIALS", 15, SCM_CREDENTIALS },
#endif
#ifdef SCM_CREDS
        { "SCM_CREDS", 9, SCM_CREDS },
#endif
#ifdef SCM_TIMESTAMP
        { "SCM_TIMESTAMP", 13, SCM_TIMESTAMP },
#endif
#ifdef SOCK_DGRAM
        { "SOCK_DGRAM", 10, SOCK_DGRAM },
#endif
#ifdef SOCK_RAW
        { "SOCK_RAW", 8, SOCK_RAW },
#endif
#ifdef SOCK_RDM
        { "SOCK_RDM", 8, SOCK_RDM },
#endif
#ifdef SOCK_SEQPACKET
        { "SOCK_SEQPACKET", 14, SOCK_SEQPACKET },
#endif
#ifdef SOCK_STREAM
        { "SOCK_STREAM", 11, SOCK_STREAM },
#endif
#ifdef SOCK_NONBLOCK
        { "SOCK_NONBLOCK", 13, SOCK_NONBLOCK },
#endif
#ifdef SOCK_CLOEXEC
        { "SOCK_CLOEXEC", 12, SOCK_CLOEXEC },
#endif
#ifdef SOL_SOCKET
        { "SOL_SOCKET", 10, SOL_SOCKET },
#endif
#ifdef SOMAXCONN
        { "SOMAXCONN", 9, SOMAXCONN },
#endif
#ifdef SO_ACCEPTCONN
        { "SO_ACCEPTCONN", 13, SO_ACCEPTCONN },
#endif
#ifdef SO_ATTACH_FILTER
        { "SO_ATTACH_FILTER", 16, SO_ATTACH_FILTER },
#endif
#ifdef SO_BACKLOG
        { "SO_BACKLOG", 10, SO_BACKLOG },
#endif
#ifdef SO_BINDTODEVICE
        { "SO_BINDTODEVICE", 15, SO_BINDTODEVICE },
#endif
#ifdef SO_BROADCAST
        { "SO_BROADCAST", 12, SO_BROADCAST },
#endif
#ifdef SO_BSDCOMPAT
        { "SO_BSDCOMPAT", 12, SO_BSDCOMPAT },
#endif
#ifdef SO_BUSY_POLL
        { "SO_BUSY_POLL", 12, SO_BUSY_POLL },
#endif
#ifdef SO_CHAMELEON
        { "SO_CHAMELEON", 12, SO_CHAMELEON },
#endif
#ifdef SO_DEBUG
        { "SO_DEBUG", 8, SO_DEBUG },
#endif
#ifdef SO_DETACH_FILTER
        { "SO_DETACH_FILTER", 16, SO_DETACH_FILTER },
#endif
#ifdef SO_DGRAM_ERRIND
        { "SO_DGRAM_ERRIND", 15, SO_DGRAM_ERRIND },
#endif
#ifdef SO_DOMAIN
        { "SO_DOMAIN", 9, SO_DOMAIN },
#endif
#ifdef SO_DONTLINGER
        { "SO_DONTLINGER", 13, SO_DONTLINGER },
#endif
#ifdef SO_DONTROUTE
        { "SO_DONTROUTE", 12, SO_DONTROUTE },
#endif
#ifdef SO_ERROR
        { "SO_ERROR", 8, SO_ERROR },
#endif
#ifdef SO_FAMILY
        { "SO_FAMILY", 9, SO_FAMILY },
#endif
#ifdef SO_KEEPALIVE
        { "SO_KEEPALIVE", 12, SO_KEEPALIVE },
#endif
#ifdef SO_LINGER
        { "SO_LINGER", 9, SO_LINGER },
#endif
#ifdef SO_LOCK_FILTER
        { "SO_LOCK_FILTER", 14, SO_LOCK_FILTER },
#endif
#ifdef SO_MARK
        { "SO_MARK", 7, SO_MARK },
#endif
#ifdef SO_OOBINLINE
        { "SO_OOBINLINE", 12, SO_OOBINLINE },
#endif
#ifdef SO_PASSCRED
        { "SO_PASSCRED", 11, SO_PASSCRED },
#endif
#ifdef SO_PASSIFNAME
        { "SO_PASSIFNAME", 13, SO_PASSIFNAME },
#endif
#ifdef SO_PEEK_OFF
        { "SO_PEEK_OFF", 11, SO_PEEK_OFF },
#endif
#ifdef SO_PEERCRED
        { "SO_PEERCRED", 11, SO_PEERCRED },
#endif
#ifdef SO_PRIORITY
        { "SO_PRIORITY", 11, SO_PRIORITY },
#endif
#ifdef SO_PROTOCOL
        { "SO_PROTOCOL", 11, SO_PROTOCOL },
#endif
#ifdef SO_PROTOTYPE
        { "SO_PROTOTYPE", 12, SO_PROTOTYPE },
#endif
#ifdef SO_RCVBUF
        { "SO_RCVBUF", 9, SO_RCVBUF },
#endif
#ifdef SO_RCVBUFFORCE
        { "SO_RCVBUFFORCE", 14, SO_RCVBUFFORCE },
#endif
#ifdef SO_RCVLOWAT
        { "SO_RCVLOWAT", 11, SO_RCVLOWAT },
#endif
#ifdef SO_RCVTIMEO
        { "SO_RCVTIMEO", 11, SO_RCVTIMEO },
#endif
#ifdef SO_REUSEADDR
        { "SO_REUSEADDR", 12, SO_REUSEADDR },
#endif
#ifdef SO_REUSEPORT
        { "SO_REUSEPORT", 12, SO_REUSEPORT },
#endif
#ifdef SO_RXQ_OVFL
        { "SO_RXQ_OVFL", 11, SO_RXQ_OVFL },
#endif
#ifdef SO_SECURITY_AUTHENTICATION
        { "SO_SECURITY_AUTHENTICATION", 26, SO_SECURITY_AUTHENTICATION },
#endif
#ifdef SO_SECURITY_ENCRYPTION_NETWORK
        { "SO_SECURITY_ENCRYPTION_NETWORK", 30, SO_SECURITY_ENCRYPTION_NETWORK },
#endif
#ifdef SO_SECURITY_ENCRYPTION_TRANSPORT
        { "SO_SECURITY_ENCRYPTION_TRANSPORT", 32, SO_SECURITY_ENCRYPTION_TRANSPORT },
#endif
#ifdef SO_SNDBUF
        { "SO_SNDBUF", 9, SO_SNDBUF },
#endif
#ifdef SO_SNDBUFFORCE
        { "SO_SNDBUFFORCE", 14, SO_SNDBUFFORCE },
#endif
#ifdef SO_SNDLOWAT
        { "SO_SNDLOWAT", 11, SO_SNDLOWAT },
#endif
#ifdef SO_SNDTIMEO
        { "SO_SNDTIMEO", 11, SO_SNDTIMEO },
#endif
#ifdef SO_STATE
        { "SO_STATE", 8, SO_STATE },
#endif
#ifdef SO_TIMESTAMP
        { "SO_TIMESTAMP", 12, SO_TIMESTAMP },
#endif
#ifdef SO_TYPE
        { "SO_TYPE", 7, SO_TYPE },
#endif
#ifdef SO_USELOOPBACK
        { "SO_USELOOPBACK", 14, SO_USELOOPBACK },
#endif
#ifdef SO_XOPEN
        { "SO_XOPEN", 8, SO_XOPEN },
#endif
#ifdef SO_XSE
        { "SO_XSE", 6, SO_XSE },
#endif
#ifdef TCP_CONGESTION
        { "TCP_CONGESTION", 14, TCP_CONGESTION },
#endif
#ifdef TCP_CONNECTIONTIMEOUT
        { "TCP_CONNECTIONTIMEOUT", 21, TCP_CONNECTIONTIMEOUT },
#endif
#ifdef TCP_CORK
        { "TCP_CORK", 8, TCP_CORK },
#endif
#ifdef TCP_DEFER_ACCEPT
        { "TCP_DEFER_ACCEPT", 16, TCP_DEFER_ACCEPT },
#endif
#ifdef TCP_FASTOPEN
        { "TCP_FASTOPEN", 12, TCP_FASTOPEN },
#endif
#ifdef TCP_INFO
        { "TCP_INFO", 8, TCP_INFO },
#endif
#ifdef TCP_INIT_CWND
        { "TCP_INIT_CWND", 13, TCP_INIT_CWND },
#endif
#ifdef TCP_KEEPALIVE
        { "TCP_KEEPALIVE", 13, TCP_KEEPALIVE },
#endif
#ifdef TCP_KEEPCNT
        { "TCP_KEEPCNT", 11, TCP_KEEPCNT },
#endif
#ifdef TCP_KEEPIDLE
        { "TCP_KEEPIDLE", 12, TCP_KEEPIDLE },
#endif
#ifdef TCP_KEEPINTVL
        { "TCP_KEEPINTVL", 13, TCP_KEEPINTVL },
#endif
#ifdef TCP_LINGER2
        { "TCP_LINGER2", 11, TCP_LINGER2 },
#endif
#ifdef TCP_MAXRT
        { "TCP_MAXRT", 9, TCP_MAXRT },
#endif
#ifdef TCP_MAXSEG
        { "TCP_MAXSEG", 10, TCP_MAXSEG },
#endif
#ifdef TCP_MD5SIG
        { "TCP_MD5SIG", 10, TCP_MD5SIG },
#endif
#ifdef TCP_NODELAY
        { "TCP_NODELAY", 11, TCP_NODELAY },
#endif
#ifdef TCP_NOOPT
        { "TCP_NOOPT", 9, TCP_NOOPT },
#endif
#ifdef TCP_NOPUSH
        { "TCP_NOPUSH", 10, TCP_NOPUSH },
#endif
#ifdef TCP_QUICKACK
        { "TCP_QUICKACK", 12, TCP_QUICKACK },
#endif
#ifdef TCP_SACK_ENABLE
        { "TCP_SACK_ENABLE", 15, TCP_SACK_ENABLE },
#endif
#ifdef TCP_STDURG
        { "TCP_STDURG", 10, TCP_STDURG },
#endif
#ifdef TCP_SYNCNT
        { "TCP_SYNCNT", 10, TCP_SYNCNT },
#endif
#ifdef TCP_USER_TIMEOUT
        { "TCP_USER_TIMEOUT", 16, TCP_USER_TIMEOUT },
#endif
#ifdef TCP_WINDOW_CLAMP
        { "TCP_WINDOW_CLAMP", 16, TCP_WINDOW_CLAMP },
#endif
#ifdef UIO_MAXIOV
        { "UIO_MAXIOV", 10, UIO_MAXIOV },
#endif
#ifdef IPPROTO_IP
        { "IPPROTO_IP", 10, IPPROTO_IP },
#endif
#ifdef IPPROTO_IPV6
        { "IPPROTO_IPV6", 12, IPPROTO_IPV6 },
#endif
#ifdef IPPROTO_RAW
        { "IPPROTO_RAW", 11, IPPROTO_RAW },
#endif
#ifdef IPPROTO_ICMP
        { "IPPROTO_ICMP", 12, IPPROTO_ICMP },
#endif
#ifdef IPPROTO_IGMP
        { "IPPROTO_IGMP", 12, IPPROTO_IGMP },
#endif
#ifdef IPPROTO_TCP
        { "IPPROTO_TCP", 11, IPPROTO_TCP },
#endif
#ifdef IPPROTO_UDP
        { "IPPROTO_UDP", 11, IPPROTO_UDP },
#endif
#ifdef IPPROTO_GRE
        { "IPPROTO_GRE", 11, IPPROTO_GRE },
#endif
#ifdef IPPROTO_ESP
        { "IPPROTO_ESP", 11, IPPROTO_ESP },
#endif
#ifdef IPPROTO_AH
        { "IPPROTO_AH", 10, IPPROTO_AH },
#endif
#ifdef IPPROTO_ICMPV6
        { "IPPROTO_ICMPV6", 14, IPPROTO_ICMPV6 },
#endif
#ifdef IPPROTO_SCTP
        { "IPPROTO_SCTP", 12, IPPROTO_SCTP },
#endif
#ifdef SHUT_RD
        { "SHUT_RD", 7, SHUT_RD },
#endif
#ifdef SHUT_WR
        { "SHUT_WR", 7, SHUT_WR },
#endif
#ifdef SHUT_RDWR
        { "SHUT_RDWR", 9, SHUT_RDWR },
#endif
#if defined(MSG_CTRUNC) || defined(HAS_MSG_CTRUNC) /* might be an enum */
        { "MSG_CTRUNC", 10, MSG_CTRUNC },
#endif
#if defined(MSG_DONTROUTE) || defined(HAS_MSG_DONTROUTE) /* might be an enum */
        { "MSG_DONTROUTE", 13, MSG_DONTROUTE },
#endif
#if defined(MSG_OOB) || defined(HAS_MSG_OOB) /* might be an enum */
        { "MSG_OOB", 7, MSG_OOB },
#endif
#if defined(MSG_PEEK) || defined(HAS_MSG_PEEK) /* might be an enum */
        { "MSG_PEEK", 8, MSG_PEEK },
#endif
#if defined(MSG_PROXY) || defined(HAS_MSG_PROXY) /* might be an enum */
        { "MSG_PROXY", 9, MSG_PROXY },
#endif
#if defined(SCM_RIGHTS) || defined(HAS_SCM_RIGHTS) /* might be an enum */
        { "SCM_RIGHTS", 10, SCM_RIGHTS },
#endif
#ifndef IPPROTO_IP
        /* This is the default value: */
        { "IPPROTO_IP", 10, 0 },
#endif
#ifndef IPPROTO_IPV6
        /* This is the default value: */
        { "IPPROTO_IPV6", 12, 41 },
#endif
#ifndef IPPROTO_RAW
        /* This is the default value: */
        { "IPPROTO_RAW", 11, 255 },
#endif
#ifndef IPPROTO_ICMP
        /* This is the default value: */
        { "IPPROTO_ICMP", 12, 1 },
#endif
#ifndef IPPROTO_IGMP
        /* This is the default value: */
        { "IPPROTO_IGMP", 12, 2 },
#endif
#ifndef IPPROTO_TCP
        /* This is the default value: */
        { "IPPROTO_TCP", 11, 6 },
#endif
#ifndef IPPROTO_UDP
        /* This is the default value: */
        { "IPPROTO_UDP", 11, 17 },
#endif
#ifndef IPPROTO_GRE
        /* This is the default value: */
        { "IPPROTO_GRE", 11, 47 },
#endif
#ifndef IPPROTO_ESP
        /* This is the default value: */
        { "IPPROTO_ESP", 11, 50 },
#endif
#ifndef IPPROTO_AH
        /* This is the default value: */
        { "IPPROTO_AH", 10, 51 },
#endif
#ifndef IPPROTO_ICMPV6
        /* This is the default value: */
        { "IPPROTO_ICMPV6", 14, 58 },
#endif
#ifndef IPPROTO_SCTP
        /* This is the default value: */
        { "IPPROTO_SCTP", 12, 132 },
#endif
#ifndef SHUT_RD
        /* This is the default value: */
        { "SHUT_RD", 7, 0 },
#endif
#ifndef SHUT_WR
        /* This is the default value: */
        { "SHUT_WR", 7, 1 },
#endif
#ifndef SHUT_RDWR
        /* This is the default value: */
        { "SHUT_RDWR", 9, 2 },
#endif
        { NULL, 0, 0 } };
	const struct iv_s *value_for_iv = values_for_iv;
        while (value_for_iv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_iv->name,
				value_for_iv->namelen, newSViv(value_for_iv->value));
            ++value_for_iv;
	}
	if (C_ARRAY_LENGTH(values_for_notfound) > 1) {
#ifndef SYMBIAN
	    HV *const constant_missing = get_missing_hash(aTHX);
#endif
	    const struct notfound_s *value_for_notfound = values_for_notfound;
	    do {

		/* Need to add prototypes, else parsing will vary by platform.  */
		HE *he = (HE*) hv_common_key_len(symbol_table,
						 value_for_notfound->name,
						 value_for_notfound->namelen,
						 HV_FETCH_LVALUE, NULL, 0);
		SV *sv;
#ifndef SYMBIAN
		HEK *hek;
#endif
		if (!he) {
		    croak("Couldn't add key '%s' to %%Socket::",
			  value_for_notfound->name);
		}
		sv = HeVAL(he);
		if (!SvOK(sv) && SvTYPE(sv) != SVt_PVGV) {
		    /* Nothing was here before, so mark a prototype of ""  */
		    sv_setpvn(sv, "", 0);
		} else if (SvPOK(sv) && SvCUR(sv) == 0) {
		    /* There is already a prototype of "" - do nothing  */
		} else {
		    /* Someone has been here before us - have to make a real
		       typeglob.  */
		    /* It turns out to be incredibly hard to deal with all the
		       corner cases of sub foo (); and reporting errors correctly,
		       so lets cheat a bit.  Start with a constant subroutine  */
		    CV *cv = newCONSTSUB(symbol_table,
					 value_for_notfound->name,
					 &PL_sv_yes);
		    /* and then turn it into a non constant declaration only.  */
		    SvREFCNT_dec(CvXSUBANY(cv).any_ptr);
		    CvCONST_off(cv);
		    CvXSUB(cv) = NULL;
		    CvXSUBANY(cv).any_ptr = NULL;
		}
#ifndef SYMBIAN
		hek = HeKEY_hek(he);
		if (!hv_common(constant_missing, NULL, HEK_KEY(hek),
 			       HEK_LEN(hek), HEK_FLAGS(hek), HV_FETCH_ISSTORE,
			       &PL_sv_yes, HEK_HASH(hek)))
		    croak("Couldn't add key '%s' to missing_hash",
			  value_for_notfound->name);
#endif
	    } while ((++value_for_notfound)->name);
	}
#ifdef INADDR_ANY
        {
            SV * temp0;
            struct in_addr ip_address; ip_address.s_addr = htonl(INADDR_ANY);
            temp0 = newSVpvn_flags((char *)&ip_address,sizeof(ip_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "INADDR_ANY",
				    10, SvREFCNT_inc(temp0));
        }
#endif
#ifdef INADDR_LOOPBACK
        {
            SV * temp0;
            struct in_addr ip_address; ip_address.s_addr = htonl(INADDR_LOOPBACK);
            temp0 = newSVpvn_flags((char *)&ip_address,sizeof(ip_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "INADDR_LOOPBACK",
				    15, SvREFCNT_inc(temp0));
        }
#endif
#ifdef INADDR_NONE
        {
            SV * temp0;
            struct in_addr ip_address; ip_address.s_addr = htonl(INADDR_NONE);
            temp0 = newSVpvn_flags((char *)&ip_address,sizeof(ip_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "INADDR_NONE",
				    11, SvREFCNT_inc(temp0));
        }
#endif
#ifdef INADDR_BROADCAST
        {
            SV * temp0;
            struct in_addr ip_address; ip_address.s_addr = htonl(INADDR_BROADCAST);
            temp0 = newSVpvn_flags((char *)&ip_address,sizeof(ip_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "INADDR_BROADCAST",
				    16, SvREFCNT_inc(temp0));
        }
#endif
#ifdef IN6ADDR_ANY_INIT
        {
            SV * temp0;
            struct in6_addr ip6_address = IN6ADDR_ANY_INIT;
            temp0 = newSVpvn_flags((char *)&ip6_address,sizeof(ip6_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "IN6ADDR_ANY",
				    11, SvREFCNT_inc(temp0));
        }
#endif
#ifdef IN6ADDR_LOOPBACK_INIT
        {
            SV * temp0;
            struct in6_addr ip6_address = IN6ADDR_LOOPBACK_INIT;
            temp0 = newSVpvn_flags((char *)&ip6_address,sizeof(ip6_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "IN6ADDR_LOOPBACK",
				    16, SvREFCNT_inc(temp0));
        }
#endif
    /* As we've been creating subroutines, we better invalidate any cached
       methods  */
    mro_method_changed_in(symbol_table);
  }

#line 755 "Socket.xs"
#ifdef HAS_GETADDRINFO
	newXS("Socket::getaddrinfo", xs_getaddrinfo, __FILE__);
#endif
#ifdef HAS_GETNAMEINFO
	newXS("Socket::getnameinfo", xs_getnameinfo, __FILE__);
#endif

#line 2917 "Socket.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

