/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.34 from the
 * contents of GdkPixbuf.xs. Do not edit this file, edit GdkPixbuf.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "xs/GdkPixbuf.xs"
/*
 * Copyright (c) 2003-2008, 2010-2013 by the gtk2-perl team (see the file
 * AUTHORS)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02110-1301  USA.
 *
 * $Id$
 */

#define GDK_PIXBUF_ENABLE_BACKEND 1 /* for gdk_pixbuf_set_option() prototype */
#include "gtk2perl.h"

/* for backwards-compatibility: */
#ifndef Newx
# define Newx(v,n,t) New(0,v,n,t)
#endif

static void
gtk2perl_pixbuf_destroy_notify (guchar * pixels,
                                gpointer data)
{
	PERL_UNUSED_VAR (data);
	Safefree (pixels);
}

#if GTK_CHECK_VERSION (2, 2, 0)

SV *
newSVGdkPixbufFormat (GdkPixbufFormat * format)
{
	gchar * s;
	gchar ** strv;
	int j;
	AV * av;
	HV * stash, * hv = newHV ();

	s = gdk_pixbuf_format_get_name (format);
	gperl_hv_take_sv_s (hv, "name", newSVGChar (s));
	g_free (s);

	s = gdk_pixbuf_format_get_description (format);
	gperl_hv_take_sv_s (hv, "description", newSVGChar (s));
	g_free (s);

	strv = gdk_pixbuf_format_get_mime_types (format);
	av = newAV ();
	for (j = 0 ; strv && strv[j] ; j++)
		av_store (av, j, newSVGChar (strv[j]));
	gperl_hv_take_sv_s (hv, "mime_types", newRV_noinc ((SV*) av));
	g_strfreev (strv);

	strv = gdk_pixbuf_format_get_extensions (format);
	av = newAV ();
	for (j = 0 ; strv && strv[j] ; j++)
		av_store (av, j, newSVGChar (strv[j]));
	gperl_hv_take_sv_s (hv, "extensions", newRV_noinc ((SV*) av));
	g_strfreev (strv);

	gperl_hv_take_sv_s (hv, "is_writable",
			    newSVuv (gdk_pixbuf_format_is_writable (format)));

#if GTK_CHECK_VERSION (2,6,0)
{
	gboolean b;

	b = gdk_pixbuf_format_is_scalable (format);
	gperl_hv_take_sv_s (hv, "is_scalable", newSVuv (b));

	b = gdk_pixbuf_format_is_disabled (format);
	gperl_hv_take_sv_s (hv, "is_disabled", newSVuv (b));

	s = gdk_pixbuf_format_get_license (format);
	gperl_hv_take_sv_s (hv, "license", newSVGChar (s));
	g_free (s);
}
#endif

	/* Store the original format pointer in the hash so that
	   SvGdkPixbufFormat can retrieve and return it. */
	_gperl_attach_mg ((SV*) hv, format);

	stash = gv_stashpv ("Gtk2::Gdk::PixbufFormat", TRUE);
	return sv_bless ((SV*) newRV_noinc ((SV*) hv), stash);
}

GdkPixbufFormat *
SvGdkPixbufFormat (SV * sv)
{
	MAGIC *mg;

	if (!gperl_sv_is_defined (sv) || !SvROK (sv)
	    || !(mg = _gperl_find_mg (SvRV (sv))))
		return NULL;

	return (GdkPixbufFormat *) mg->mg_ptr;
}

#endif /* 2.2.0 */


#if GTK_CHECK_VERSION(2, 4, 0)

static gboolean
save_to_sv_callback (const gchar * data,
                     gsize count,
                     GError ** error,
                     gpointer user_data)
{
        SV * sv = user_data;

        sv_catpvn_nomg (sv, data, count);
        /* XXX no way to find out if that failed. */
	PERL_UNUSED_VAR (error);

        return TRUE;
}

#endif /* 2.4.0 */


#line 144 "xs/GdkPixbuf.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 288 "xs/GdkPixbuf.c"

XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_render_threshold_alpha); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_render_threshold_alpha)
{
    dVAR; dXSARGS;
    if (items != 9)
       croak_xs_usage(cv,  "pixbuf, bitmap, src_x, src_y, dest_x, dest_y, width, height, alpha_threshold");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	GdkBitmap *	bitmap = SvGdkBitmap (ST(1))
;
	int	src_x = (int)SvIV(ST(2))
;
	int	src_y = (int)SvIV(ST(3))
;
	int	dest_x = (int)SvIV(ST(4))
;
	int	dest_y = (int)SvIV(ST(5))
;
	int	width = (int)SvIV(ST(6))
;
	int	height = (int)SvIV(ST(7))
;
	int	alpha_threshold = (int)SvIV(ST(8))
;

	gdk_pixbuf_render_threshold_alpha(pixbuf, bitmap, src_x, src_y, dest_x, dest_y, width, height, alpha_threshold);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_render_to_drawable); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_render_to_drawable)
{
    dVAR; dXSARGS;
    if (items != 12)
       croak_xs_usage(cv,  "pixbuf, drawable, gc, src_x, src_y, dest_x, dest_y, width, height, dither, x_dither, y_dither");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	GdkDrawable *	drawable = SvGdkDrawable (ST(1))
;
	GdkGC *	gc = SvGdkGC (ST(2))
;
	int	src_x = (int)SvIV(ST(3))
;
	int	src_y = (int)SvIV(ST(4))
;
	int	dest_x = (int)SvIV(ST(5))
;
	int	dest_y = (int)SvIV(ST(6))
;
	int	width = (int)SvIV(ST(7))
;
	int	height = (int)SvIV(ST(8))
;
	GdkRgbDither	dither = SvGdkRgbDither (ST(9))
;
	int	x_dither = (int)SvIV(ST(10))
;
	int	y_dither = (int)SvIV(ST(11))
;

	gdk_pixbuf_render_to_drawable(pixbuf, drawable, gc, src_x, src_y, dest_x, dest_y, width, height, dither, x_dither, y_dither);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_render_to_drawable_alpha); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_render_to_drawable_alpha)
{
    dVAR; dXSARGS;
    if (items != 13)
       croak_xs_usage(cv,  "pixbuf, drawable, src_x, src_y, dest_x, dest_y, width, height, alpha_mode, alpha_threshold, dither, x_dither, y_dither");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	GdkDrawable *	drawable = SvGdkDrawable (ST(1))
;
	int	src_x = (int)SvIV(ST(2))
;
	int	src_y = (int)SvIV(ST(3))
;
	int	dest_x = (int)SvIV(ST(4))
;
	int	dest_y = (int)SvIV(ST(5))
;
	int	width = (int)SvIV(ST(6))
;
	int	height = (int)SvIV(ST(7))
;
	GdkPixbufAlphaMode	alpha_mode = SvGdkPixbufAlphaMode (ST(8))
;
	int	alpha_threshold = (int)SvIV(ST(9))
;
	GdkRgbDither	dither = SvGdkRgbDither (ST(10))
;
	int	x_dither = (int)SvIV(ST(11))
;
	int	y_dither = (int)SvIV(ST(12))
;

	gdk_pixbuf_render_to_drawable_alpha(pixbuf, drawable, src_x, src_y, dest_x, dest_y, width, height, alpha_mode, alpha_threshold, dither, x_dither, y_dither);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_render_pixmap_and_mask_for_colormap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_render_pixmap_and_mask_for_colormap)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "pixbuf, colormap, alpha_threshold");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	GdkColormap *	colormap = SvGdkColormap (ST(1))
;
	int	alpha_threshold = (int)SvIV(ST(2))
;
#line 201 "xs/GdkPixbuf.xs"
{
        GdkPixmap *pm;
        GdkBitmap *bm;

        gdk_pixbuf_render_pixmap_and_mask_for_colormap (pixbuf, colormap, &pm, GIMME_V == G_ARRAY ? &bm : 0, alpha_threshold);
        XPUSHs (sv_2mortal (newSVGdkPixmap_noinc (pm)));
        if (GIMME_V == G_ARRAY)
                XPUSHs (sv_2mortal (newSVGdkBitmap_noinc (bm)));
}
#line 425 "xs/GdkPixbuf.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_render_pixmap_and_mask); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_render_pixmap_and_mask)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pixbuf, alpha_threshold");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	int	alpha_threshold = (int)SvIV(ST(1))
;
#line 221 "xs/GdkPixbuf.xs"
{
        GdkPixmap *pm;
        GdkBitmap *bm;

        gdk_pixbuf_render_pixmap_and_mask (pixbuf, &pm, GIMME_V == G_ARRAY ? &bm : 0, alpha_threshold);
        XPUSHs (sv_2mortal (newSVGdkPixmap_noinc (pm)));
        if (GIMME_V == G_ARRAY)
                XPUSHs (sv_2mortal (newSVGdkBitmap_noinc (bm)));
}
#line 455 "xs/GdkPixbuf.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_from_drawable); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_from_drawable)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 9)
       croak_xs_usage(cv,  "dest_or_class, src, cmap, src_x, src_y, dest_x, dest_y, width, height");
    {
	SV *	dest_or_class = ST(0)
;
	SV *	src = ST(1)
;
	GdkColormap_ornull *	cmap = SvGdkColormap_ornull (ST(2))
;
	int	src_x = (int)SvIV(ST(3))
;
	int	src_y = (int)SvIV(ST(4))
;
	int	dest_x = (int)SvIV(ST(5))
;
	int	dest_y = (int)SvIV(ST(6))
;
	int	width = (int)SvIV(ST(7))
;
	int	height = (int)SvIV(ST(8))
;
#line 263 "xs/GdkPixbuf.xs"
	GdkPixbuf * pixbuf, * dest;
#line 490 "xs/GdkPixbuf.c"
	SV *	RETVAL;
#line 265 "xs/GdkPixbuf.xs"
	dest = (gperl_sv_is_defined (dest_or_class) && SvROK (dest_or_class))
	     ? SvGdkPixbuf (dest_or_class)
	     : NULL;
	if (ix == 1)
		pixbuf = gdk_pixbuf_get_from_image (dest,
		                                    SvGdkImage (src),
		                                    cmap, src_x, src_y,
		                                    dest_x, dest_y,
		                                    width, height);
	else
		pixbuf = gdk_pixbuf_get_from_drawable (dest,
		                                       SvGdkDrawable (src),
		                                       cmap, src_x, src_y,
		                                       dest_x, dest_y,
		                                       width, height);
	if (!pixbuf)
		XSRETURN_UNDEF;
	/* we own the output pixbuf if there was no destination supplied. */
	RETVAL = gperl_new_object (G_OBJECT (pixbuf), dest != pixbuf);
#line 512 "xs/GdkPixbuf.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_colorspace); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_colorspace)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pixbuf");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	GdkColorspace	RETVAL;

	RETVAL = gdk_pixbuf_get_colorspace(pixbuf);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkColorspace (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_n_channels); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_n_channels)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pixbuf");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = gdk_pixbuf_get_n_channels(pixbuf);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_has_alpha); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_has_alpha)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pixbuf");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	gboolean	RETVAL;

	RETVAL = gdk_pixbuf_get_has_alpha(pixbuf);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_bits_per_sample); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_bits_per_sample)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pixbuf");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = gdk_pixbuf_get_bits_per_sample(pixbuf);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_pixels); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_pixels)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pixbuf");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
#line 328 "xs/GdkPixbuf.xs"
	guchar * pixels;
	STRLEN size;
#line 611 "xs/GdkPixbuf.c"
	SV *	RETVAL;
#line 331 "xs/GdkPixbuf.xs"
	/* For reference, most pixbuf mallocs are height*rowstride, for
	   example gdk_pixbuf_new() does that.  But gdk_pixbuf_copy()
	   mallocs only the lesser "last row unpadded" size.  If the code
	   here used height*rowstride it would read past the end of such a
	   block.

	   Most of the time rowstride is the next multiple of 4, and a
	   malloced block is the next multiple of 4 too, so it's ok, but for
	   a bigger rowstride it's not.

	   The following calculation adapted from gdk_pixbuf_copy() circa
	   Gtk 2.16.  bits_per_sample is only ever 8 currently, making it
	   simply n_channels many bytes-per-pixel, but the calculation
	   anticipates bits not a multiple of 8.  */

	size = ((gdk_pixbuf_get_height(pixbuf) - 1)
		* gdk_pixbuf_get_rowstride(pixbuf)
		+ gdk_pixbuf_get_width(pixbuf)
		* ((gdk_pixbuf_get_n_channels(pixbuf)
		    * gdk_pixbuf_get_bits_per_sample(pixbuf) + 7) / 8));
	pixels = gdk_pixbuf_get_pixels (pixbuf);
	RETVAL = newSVpv ((gchar *) pixels, size);
#line 636 "xs/GdkPixbuf.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_width)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pixbuf");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = gdk_pixbuf_get_width(pixbuf);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_height); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_height)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pixbuf");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = gdk_pixbuf_get_height(pixbuf);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_rowstride); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_rowstride)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pixbuf");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = gdk_pixbuf_get_rowstride(pixbuf);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_option); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_option)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pixbuf, key");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	const gchar *	key;
	const gchar_ornull *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	RETVAL = gdk_pixbuf_get_option(pixbuf, key);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    /* newSVGChar() allows NULL, but T_GCHAR does not. allow NULL. */
	    if (RETVAL) {
		    sv_setpv ((SV*)RETVALSV, RETVAL);
		    SvUTF8_on (RETVALSV);
	    } else {
		    SvSetSV (RETVALSV, &PL_sv_undef);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if GTK_CHECK_VERSION (2, 2, 0)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_set_option); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_set_option)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "pixbuf, key, value");
    {
	gboolean	RETVAL;
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	const gchar *	key;
	const gchar *	value;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	value = (const gchar *)SvPV_nolen (ST(2))
;

	RETVAL = gdk_pixbuf_set_option(pixbuf, key, value);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif /* 2.2 */

XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new)
{
    dVAR; dXSARGS;
    if (items != 6)
       croak_xs_usage(cv,  "class, colorspace, has_alpha, bits_per_sample, width, height");
    {
	GdkColorspace	colorspace = SvGdkColorspace (ST(1))
;
	gboolean	has_alpha = (bool)SvTRUE(ST(2))
;
	int	bits_per_sample = (int)SvIV(ST(3))
;
	int	width = (int)SvIV(ST(4))
;
	int	height = (int)SvIV(ST(5))
;
	GdkPixbuf_noinc *	RETVAL;

	RETVAL = gdk_pixbuf_new(colorspace, has_alpha, bits_per_sample, width, height);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_copy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_copy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pixbuf");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	GdkPixbuf_noinc *	RETVAL;

	RETVAL = gdk_pixbuf_copy(pixbuf);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_subpixbuf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_subpixbuf)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "src_pixbuf, src_x, src_y, width, height");
    {
	GdkPixbuf *	src_pixbuf = SvGdkPixbuf (ST(0))
;
	int	src_x = (int)SvIV(ST(1))
;
	int	src_y = (int)SvIV(ST(2))
;
	int	width = (int)SvIV(ST(3))
;
	int	height = (int)SvIV(ST(4))
;
	GdkPixbuf_noinc *	RETVAL;

	RETVAL = gdk_pixbuf_new_subpixbuf(src_pixbuf, src_x, src_y, width, height);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, filename");
    {
	GPerlFilename	filename = (GPerlFilename) gperl_filename_from_sv (ST(1))
;
#line 415 "xs/GdkPixbuf.xs"
        GError *error = NULL;
#line 866 "xs/GdkPixbuf.c"
	GdkPixbuf_noinc *	RETVAL;
#line 417 "xs/GdkPixbuf.xs"
	RETVAL = gdk_pixbuf_new_from_file (filename, &error);
	if (!RETVAL)
		gperl_croak_gerror (filename, error);
#line 872 "xs/GdkPixbuf.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if GTK_CHECK_VERSION(2,4,0)
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_file_at_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_file_at_size)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "class, filename, width, height");
    {
#line 431 "xs/GdkPixbuf.xs"
        GError *error = NULL;
#line 896 "xs/GdkPixbuf.c"
	GdkPixbuf_noinc *	RETVAL;
	GPerlFilename	filename = (GPerlFilename) gperl_filename_from_sv (ST(1))
;
	int	width = (int)SvIV(ST(2))
;
	int	height = (int)SvIV(ST(3))
;
#line 433 "xs/GdkPixbuf.xs"
	RETVAL = gdk_pixbuf_new_from_file_at_size
	                              (filename, width, height, &error);
	if (!RETVAL)
		gperl_croak_gerror (filename, error);
#line 909 "xs/GdkPixbuf.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#if GTK_CHECK_VERSION(2,6,0)
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_file_at_scale); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_file_at_scale)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "class, filename, width, height, preserve_aspect_ratio");
    {
#line 450 "xs/GdkPixbuf.xs"
        GError *error = NULL;
#line 934 "xs/GdkPixbuf.c"
	GdkPixbuf_noinc *	RETVAL;
	GPerlFilename	filename = (GPerlFilename) gperl_filename_from_sv (ST(1))
;
	int	width = (int)SvIV(ST(2))
;
	int	height = (int)SvIV(ST(3))
;
	gboolean	preserve_aspect_ratio = (bool)SvTRUE(ST(4))
;
#line 452 "xs/GdkPixbuf.xs"
	RETVAL = gdk_pixbuf_new_from_file_at_scale
	                              (filename, width, height,
	                               preserve_aspect_ratio, &error);
	if (!RETVAL)
		gperl_croak_gerror (filename, error);
#line 950 "xs/GdkPixbuf.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_data)
{
    dVAR; dXSARGS;
    if (items != 8)
       croak_xs_usage(cv,  "class, data, colorspace, has_alpha, bits_per_sample, width, height, rowstride");
    {
	SV *	data = ST(1)
;
	GdkColorspace	colorspace = SvGdkColorspace (ST(2))
;
	gboolean	has_alpha = (bool)SvTRUE(ST(3))
;
	int	bits_per_sample = (int)SvIV(ST(4))
;
	int	width = (int)SvIV(ST(5))
;
	int	height = (int)SvIV(ST(6))
;
	int	rowstride = (int)SvIV(ST(7))
;
#line 496 "xs/GdkPixbuf.xs"
	char *data_ptr, *pix_ptr;
	STRLEN len;
#line 987 "xs/GdkPixbuf.c"
	GdkPixbuf_noinc *	RETVAL;
#line 499 "xs/GdkPixbuf.xs"
	data_ptr = SvPV (data, len);
	Newx (pix_ptr, len, char);
	Copy (data_ptr, pix_ptr, len, char);
	RETVAL = gdk_pixbuf_new_from_data ((const guchar *) pix_ptr,
	                                   colorspace, has_alpha,
					   bits_per_sample,
					   width, height, rowstride,
					   gtk2perl_pixbuf_destroy_notify,
					   NULL);
#line 999 "xs/GdkPixbuf.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_xpm_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_xpm_data)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "class, ...");
    {
#line 556 "xs/GdkPixbuf.xs"
	char ** lines;
	int i;
#line 1021 "xs/GdkPixbuf.c"
	GdkPixbuf_noinc *	RETVAL;
#line 559 "xs/GdkPixbuf.xs"
	/* Add a NULL terminator to protect against a segv if too few lines
	 * are supplied.  GdkPixbuf's io-xpm.c's mem_buffer() recognizes that
	 * as an end of data.  (Not documented, so far as i can tell, but
	 * still a pretty good idea.) */
	lines = g_new (char *, items - 1 + 1);
	for (i = 1; i < items; i++)
		lines[i-1] = SvPV_nolen (ST (i));
	lines[i-1] = NULL;
	RETVAL = gdk_pixbuf_new_from_xpm_data((const char**)lines);
	g_free(lines);
#line 1034 "xs/GdkPixbuf.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_inline); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_new_from_inline)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "class, data, copy_pixels=TRUE");
    {
	SV *	data = ST(1)
;
	gboolean	copy_pixels;
#line 601 "xs/GdkPixbuf.xs"
	GError * error = NULL;
	STRLEN data_length;
	const guchar * raw_data;
#line 1060 "xs/GdkPixbuf.c"
	GdkPixbuf_noinc *	RETVAL;

	if (items < 3)
	    copy_pixels = TRUE;
	else {
	    copy_pixels = (bool)SvTRUE(ST(2))
;
	}
#line 605 "xs/GdkPixbuf.xs"
	raw_data = (const guchar *) SvPV (data, data_length);
	RETVAL = gdk_pixbuf_new_from_inline (data_length, raw_data, 
	                                     copy_pixels, &error);
	if (!RETVAL)
		gperl_croak_gerror (NULL, error);
#line 1075 "xs/GdkPixbuf.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_save); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_save)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "pixbuf, filename, type, ...");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	GPerlFilename	filename = (GPerlFilename) gperl_filename_from_sv (ST(1))
;
	gchar *	type;
#line 643 "xs/GdkPixbuf.xs"
	GError * error = NULL;
	char ** option_keys = NULL;
	char ** option_vals = NULL;
	int i, nkeys;
	gboolean worked;
#line 1105 "xs/GdkPixbuf.c"

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(2));
	type = (gchar *)SvPV_nolen (ST(2))
;
#line 649 "xs/GdkPixbuf.xs"
	/* collect key/val pairs from the argument stack and 
	 * call gdk_pixbuf_savev */
#define FIRST_KEY 3
	nkeys = items - FIRST_KEY;
	if (nkeys % 2)
		croak ("gdk_pixbuf_save expects options as key => value pairs "
		       "(odd number of arguments detected)");
	nkeys /= 2;
	/* always allocate them.  doesn't hurt.  always one longer for the
	 * null-terminator, which is set by g_new0. */
	option_keys = g_new0 (char *, nkeys + 1);
	option_vals = g_new0 (char *, nkeys + 1);

	for (i = 0 ; i < nkeys ; i++) {
		/* NOT copies of the strings.
		   option_vals[] are utf8 for png format "tEXt::Foo" etc.
		   option_keys[] are ascii-only circa gtk 2.18, but presume
		   any non-ascii there would be utf8 too. */
		option_keys[i] = SvGChar (ST (FIRST_KEY + i*2 + 0));
		option_vals[i] = SvGChar (ST (FIRST_KEY + i*2 + 1));
	}

	worked = gdk_pixbuf_savev (pixbuf, filename, type, 
	                           option_keys, option_vals, &error);
	/* don't free the strings themselves! */
	g_free (option_keys);
	g_free (option_vals);
	if (!worked)
		gperl_croak_gerror (filename, error);
#undef FIRST_KEY
#line 1142 "xs/GdkPixbuf.c"
    }
    XSRETURN_EMPTY;
}

#if GTK_CHECK_VERSION(2, 4, 0)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_save_to_buffer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_save_to_buffer)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "pixbuf, type, ...");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	gchar *	type;
#line 704 "xs/GdkPixbuf.xs"
	GError * error = NULL;
	char ** option_keys = NULL;
	char ** option_vals = NULL;
	int i, nkeys;
#line 1166 "xs/GdkPixbuf.c"
	SV *	RETVAL;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	type = (gchar *)SvPV_nolen (ST(1))
;
#line 709 "xs/GdkPixbuf.xs"
	/* collect key/val pairs from the argument stack and 
	 * call gdk_pixbuf_save_to_bufferv */
#define FIRST_KEY 2
	nkeys = (items - FIRST_KEY) / 2;
	/* always allocate them.  doesn't hurt.  always one longer for the
	 * null-terminator, which is set by g_new0. */
	option_keys = g_new0 (char *, nkeys + 1);
	option_vals = g_new0 (char *, nkeys + 1);

	for (i = 0 ; i < nkeys ; i++) {
		/* NOT copies */
		option_keys[i] = SvPV_nolen (ST (FIRST_KEY + i*2 + 0));
		option_vals[i] = SvPV_nolen (ST (FIRST_KEY + i*2 + 1));
	}
#undef FIRST_KEY
        RETVAL = newSV (1024);
	sv_setpvn (RETVAL, "", 0);
        if (! gdk_pixbuf_save_to_callbackv (pixbuf,
                                            save_to_sv_callback, RETVAL,
                                            type, option_keys, option_vals,
                                            &error)) {
                SvREFCNT_dec (RETVAL);
                gperl_croak_gerror (NULL, error);
        }
	/* don't free the strings themselves! */
	g_free (option_keys);
	g_free (option_vals);
#line 1201 "xs/GdkPixbuf.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#endif /* 2.4 */

XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_add_alpha); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_add_alpha)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "pixbuf, substitute_color, r, g, b");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	gboolean	substitute_color = (bool)SvTRUE(ST(1))
;
	guchar	r = (guchar)SvUV(ST(2))
;
	guchar	g = (guchar)SvUV(ST(3))
;
	guchar	b = (guchar)SvUV(ST(4))
;
	GdkPixbuf_noinc *	RETVAL;

	RETVAL = gdk_pixbuf_add_alpha(pixbuf, substitute_color, r, g, b);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_copy_area); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_copy_area)
{
    dVAR; dXSARGS;
    if (items != 8)
       croak_xs_usage(cv,  "src_pixbuf, src_x, src_y, width, height, dest_pixbuf, dest_x, dest_y");
    {
	GdkPixbuf *	src_pixbuf = SvGdkPixbuf (ST(0))
;
	int	src_x = (int)SvIV(ST(1))
;
	int	src_y = (int)SvIV(ST(2))
;
	int	width = (int)SvIV(ST(3))
;
	int	height = (int)SvIV(ST(4))
;
	GdkPixbuf *	dest_pixbuf = SvGdkPixbuf (ST(5))
;
	int	dest_x = (int)SvIV(ST(6))
;
	int	dest_y = (int)SvIV(ST(7))
;

	gdk_pixbuf_copy_area(src_pixbuf, src_x, src_y, width, height, dest_pixbuf, dest_x, dest_y);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_saturate_and_pixelate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_saturate_and_pixelate)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "src, dest, saturation, pixelate");
    {
	GdkPixbuf *	src = SvGdkPixbuf (ST(0))
;
	GdkPixbuf *	dest = SvGdkPixbuf (ST(1))
;
	gfloat	saturation = (float)SvNV(ST(2))
;
	gboolean	pixelate = (bool)SvTRUE(ST(3))
;

	gdk_pixbuf_saturate_and_pixelate(src, dest, saturation, pixelate);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_fill); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_fill)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pixbuf, pixel");
    {
	GdkPixbuf *	pixbuf = SvGdkPixbuf (ST(0))
;
	guint32	pixel = (guint32)SvUV(ST(1))
;

	gdk_pixbuf_fill(pixbuf, pixel);
    }
    XSRETURN_EMPTY;
}

#if GTK_CHECK_VERSION (2, 6, 0)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_rotate_simple); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_rotate_simple)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "src, angle");
    {
	GdkPixbuf_noinc *	RETVAL;
	const GdkPixbuf *	src = SvGdkPixbuf (ST(0))
;
	GdkPixbufRotation	angle = SvGdkPixbufRotation (ST(1))
;

	RETVAL = gdk_pixbuf_rotate_simple(src, angle);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_flip); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_flip)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "src, horizontal");
    {
	GdkPixbuf_noinc *	RETVAL;
	const GdkPixbuf *	src = SvGdkPixbuf (ST(0))
;
	gboolean	horizontal = (bool)SvTRUE(ST(1))
;

	RETVAL = gdk_pixbuf_flip(src, horizontal);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_scale); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_scale)
{
    dVAR; dXSARGS;
    if (items != 11)
       croak_xs_usage(cv,  "src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type");
    {
	GdkPixbuf *	src = SvGdkPixbuf (ST(0))
;
	GdkPixbuf *	dest = SvGdkPixbuf (ST(1))
;
	int	dest_x = (int)SvIV(ST(2))
;
	int	dest_y = (int)SvIV(ST(3))
;
	int	dest_width = (int)SvIV(ST(4))
;
	int	dest_height = (int)SvIV(ST(5))
;
	double	offset_x = (double)SvNV(ST(6))
;
	double	offset_y = (double)SvNV(ST(7))
;
	double	scale_x = (double)SvNV(ST(8))
;
	double	scale_y = (double)SvNV(ST(9))
;
	GdkInterpType	interp_type = SvGdkInterpType (ST(10))
;

	gdk_pixbuf_scale(src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_composite); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_composite)
{
    dVAR; dXSARGS;
    if (items != 12)
       croak_xs_usage(cv,  "src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha");
    {
	GdkPixbuf *	src = SvGdkPixbuf (ST(0))
;
	GdkPixbuf *	dest = SvGdkPixbuf (ST(1))
;
	int	dest_x = (int)SvIV(ST(2))
;
	int	dest_y = (int)SvIV(ST(3))
;
	int	dest_width = (int)SvIV(ST(4))
;
	int	dest_height = (int)SvIV(ST(5))
;
	double	offset_x = (double)SvNV(ST(6))
;
	double	offset_y = (double)SvNV(ST(7))
;
	double	scale_x = (double)SvNV(ST(8))
;
	double	scale_y = (double)SvNV(ST(9))
;
	GdkInterpType	interp_type = SvGdkInterpType (ST(10))
;
	int	overall_alpha = (int)SvIV(ST(11))
;

	gdk_pixbuf_composite(src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_composite_color); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_composite_color)
{
    dVAR; dXSARGS;
    if (items != 17)
       croak_xs_usage(cv,  "src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha, check_x, check_y, check_size, color1, color2");
    {
	GdkPixbuf *	src = SvGdkPixbuf (ST(0))
;
	GdkPixbuf *	dest = SvGdkPixbuf (ST(1))
;
	int	dest_x = (int)SvIV(ST(2))
;
	int	dest_y = (int)SvIV(ST(3))
;
	int	dest_width = (int)SvIV(ST(4))
;
	int	dest_height = (int)SvIV(ST(5))
;
	double	offset_x = (double)SvNV(ST(6))
;
	double	offset_y = (double)SvNV(ST(7))
;
	double	scale_x = (double)SvNV(ST(8))
;
	double	scale_y = (double)SvNV(ST(9))
;
	GdkInterpType	interp_type = SvGdkInterpType (ST(10))
;
	int	overall_alpha = (int)SvIV(ST(11))
;
	int	check_x = (int)SvIV(ST(12))
;
	int	check_y = (int)SvIV(ST(13))
;
	int	check_size = (int)SvIV(ST(14))
;
	guint32	color1 = (guint32)SvUV(ST(15))
;
	guint32	color2 = (guint32)SvUV(ST(16))
;

	gdk_pixbuf_composite_color(src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha, check_x, check_y, check_size, color1, color2);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_scale_simple); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_scale_simple)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "src, dest_width, dest_height, interp_type");
    {
	GdkPixbuf *	src = SvGdkPixbuf (ST(0))
;
	int	dest_width = (int)SvIV(ST(1))
;
	int	dest_height = (int)SvIV(ST(2))
;
	GdkInterpType	interp_type = SvGdkInterpType (ST(3))
;
	GdkPixbuf_noinc_ornull *	RETVAL;

	RETVAL = gdk_pixbuf_scale_simple(src, dest_width, dest_height, interp_type);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_composite_color_simple); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_composite_color_simple)
{
    dVAR; dXSARGS;
    if (items != 8)
       croak_xs_usage(cv,  "src, dest_width, dest_height, interp_type, overall_alpha, check_size, color1, color2");
    {
	GdkPixbuf *	src = SvGdkPixbuf (ST(0))
;
	int	dest_width = (int)SvIV(ST(1))
;
	int	dest_height = (int)SvIV(ST(2))
;
	GdkInterpType	interp_type = SvGdkInterpType (ST(3))
;
	int	overall_alpha = (int)SvIV(ST(4))
;
	int	check_size = (int)SvIV(ST(5))
;
	guint32	color1 = (guint32)SvUV(ST(6))
;
	guint32	color2 = (guint32)SvUV(ST(7))
;
	GdkPixbuf_noinc_ornull *	RETVAL;

	RETVAL = gdk_pixbuf_composite_color_simple(src, dest_width, dest_height, interp_type, overall_alpha, check_size, color1, color2);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc_ornull (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if GTK_CHECK_VERSION (2, 11, 0)
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_apply_embedded_orientation); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_apply_embedded_orientation)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "src");
    {
	GdkPixbuf_noinc *	RETVAL;
	GdkPixbuf *	src = SvGdkPixbuf (ST(0))
;

	RETVAL = gdk_pixbuf_apply_embedded_orientation(src);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_new_from_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_new_from_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, filename");
    {
	GPerlFilename	filename = (GPerlFilename) gperl_filename_from_sv (ST(1))
;
#line 881 "xs/GdkPixbuf.xs"
	GError * error = NULL;
#line 1591 "xs/GdkPixbuf.c"
	GdkPixbufAnimation_noinc *	RETVAL;
#line 883 "xs/GdkPixbuf.xs"
	RETVAL = gdk_pixbuf_animation_new_from_file (filename, &error);
	if (!RETVAL)
		gperl_croak_gerror (filename, error);
#line 1597 "xs/GdkPixbuf.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbufAnimation_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_get_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_get_width)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "animation");
    {
	GdkPixbufAnimation *	animation = SvGdkPixbufAnimation (ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = gdk_pixbuf_animation_get_width(animation);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_get_height); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_get_height)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "animation");
    {
	GdkPixbufAnimation *	animation = SvGdkPixbufAnimation (ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = gdk_pixbuf_animation_get_height(animation);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_is_static_image); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_is_static_image)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "animation");
    {
	GdkPixbufAnimation *	animation = SvGdkPixbufAnimation (ST(0))
;
	gboolean	RETVAL;

	RETVAL = gdk_pixbuf_animation_is_static_image(animation);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_get_static_image); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_get_static_image)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "animation");
    {
	GdkPixbufAnimation *	animation = SvGdkPixbufAnimation (ST(0))
;
	GdkPixbuf *	RETVAL;

	RETVAL = gdk_pixbuf_animation_get_static_image(animation);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_get_iter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimation_get_iter)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "animation, start_time_seconds=0, start_time_microseconds=0");
    {
	GdkPixbufAnimation *	animation = SvGdkPixbufAnimation (ST(0))
;
	guint	start_time_seconds;
	guint	start_time_microseconds;
	GdkPixbufAnimationIter_noinc *	RETVAL;

	if (items < 2)
	    start_time_seconds = 0;
	else {
	    start_time_seconds = (guint)SvUV(ST(1))
;
	}

	if (items < 3)
	    start_time_microseconds = 0;
	else {
	    start_time_microseconds = (guint)SvUV(ST(2))
;
	}
#line 932 "xs/GdkPixbuf.xs"
	if (start_time_microseconds) {
		GTimeVal start_time;
		start_time.tv_sec = start_time_seconds;
		start_time.tv_usec = start_time_microseconds;
		RETVAL = gdk_pixbuf_animation_get_iter (animation,
		                                        &start_time);
	} else
		RETVAL = gdk_pixbuf_animation_get_iter (animation, NULL);
#line 1723 "xs/GdkPixbuf.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbufAnimationIter_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimationIter_get_delay_time); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimationIter_get_delay_time)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "iter");
    {
	int	RETVAL;
	dXSTARG;
	GdkPixbufAnimationIter *	iter = SvGdkPixbufAnimationIter (ST(0))
;

	RETVAL = gdk_pixbuf_animation_iter_get_delay_time(iter);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimationIter_get_pixbuf); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimationIter_get_pixbuf)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "iter");
    {
	GdkPixbuf *	RETVAL;
	GdkPixbufAnimationIter *	iter = SvGdkPixbufAnimationIter (ST(0))
;

	RETVAL = gdk_pixbuf_animation_iter_get_pixbuf(iter);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGdkPixbuf (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimationIter_on_currently_loading_frame); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimationIter_on_currently_loading_frame)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "iter");
    {
	gboolean	RETVAL;
	GdkPixbufAnimationIter *	iter = SvGdkPixbufAnimationIter (ST(0))
;

	RETVAL = gdk_pixbuf_animation_iter_on_currently_loading_frame(iter);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimationIter_advance); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufAnimationIter_advance)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "iter, current_time_seconds=0, current_time_microseconds=0");
    {
	GdkPixbufAnimationIter *	iter = SvGdkPixbufAnimationIter (ST(0))
;
	guint	current_time_seconds;
	guint	current_time_microseconds;
	gboolean	RETVAL;

	if (items < 2)
	    current_time_seconds = 0;
	else {
	    current_time_seconds = (guint)SvUV(ST(1))
;
	}

	if (items < 3)
	    current_time_microseconds = 0;
	else {
	    current_time_microseconds = (guint)SvUV(ST(2))
;
	}
#line 961 "xs/GdkPixbuf.xs"
	if (current_time_microseconds) {
		GTimeVal current_time;
		current_time.tv_sec = current_time_seconds;
		current_time.tv_usec = current_time_microseconds;
		RETVAL = gdk_pixbuf_animation_iter_advance (iter,
		                                            &current_time);
	} else
		RETVAL = gdk_pixbuf_animation_iter_advance (iter, NULL);
#line 1830 "xs/GdkPixbuf.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#if GTK_CHECK_VERSION(2,2,0)
#define XSubPPtmpAAAG 1


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_formats); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_formats)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "class=NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 999 "xs/GdkPixbuf.xs"
	GSList * formats, * i;
#line 1851 "xs/GdkPixbuf.c"
#line 1001 "xs/GdkPixbuf.xs"
	formats = gdk_pixbuf_get_formats ();
	for (i = formats ; i != NULL ; i = i->next) {
		XPUSHs (sv_2mortal (newSVGdkPixbufFormat (i->data)));
	}
	g_slist_free (formats);
	PERL_UNUSED_VAR (ax);
#line 1859 "xs/GdkPixbuf.c"
	PUTBACK;
	return;
    }
}

#endif /* >= 2.2.0 */
#if GTK_CHECK_VERSION(2,4,0)
#define XSubPPtmpAAAH 1


XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_file_info); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__Pixbuf_get_file_info)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, filename");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GPerlFilename	filename = (GPerlFilename) gperl_filename_from_sv (ST(1))
;
#line 1023 "xs/GdkPixbuf.xs"
	GdkPixbufFormat *format;
	gint width = -1;
	gint height = -1;
#line 1885 "xs/GdkPixbuf.c"
#line 1027 "xs/GdkPixbuf.xs"
	format = gdk_pixbuf_get_file_info (filename, &width, &height);
	if (format) {
		EXTEND (sp, 3);
		PUSHs (sv_2mortal (newSVGdkPixbufFormat (format)));
		PUSHs (sv_2mortal (newSViv (width)));
		PUSHs (sv_2mortal (newSViv (height)));
	}
#line 1894 "xs/GdkPixbuf.c"
	PUTBACK;
	return;
    }
}

#endif
#if GTK_CHECK_VERSION(2, 2, 0)
#define XSubPPtmpAAAI 1


XS_EUPXS(XS_Gtk2__Gdk__PixbufFormat_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufFormat_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    {
	SV *	sv = ST(0)
;
#line 1063 "xs/GdkPixbuf.xs"
	_gperl_remove_mg (SvRV (sv));
#line 1916 "xs/GdkPixbuf.c"
    }
    XSRETURN_EMPTY;
}

#endif /* 2.2.0 */
#if GTK_CHECK_VERSION(2, 6, 0)
#define XSubPPtmpAAAJ 1


XS_EUPXS(XS_Gtk2__Gdk__PixbufFormat_set_disabled); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Gdk__PixbufFormat_set_disabled)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "format, disabled");
    {
	GdkPixbufFormat *	format = SvGdkPixbufFormat (ST(0))
;
	gboolean	disabled = (bool)SvTRUE(ST(1))
;

	gdk_pixbuf_format_set_disabled(format, disabled);
    }
    XSRETURN_EMPTY;
}

#endif /* 2.6.0 */
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Gtk2__Gdk__Pixbuf); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Gtk2__Gdk__Pixbuf)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Gtk2::Gdk::Pixbuf::render_threshold_alpha", XS_Gtk2__Gdk__Pixbuf_render_threshold_alpha);
        newXS_deffile("Gtk2::Gdk::Pixbuf::render_to_drawable", XS_Gtk2__Gdk__Pixbuf_render_to_drawable);
        newXS_deffile("Gtk2::Gdk::Pixbuf::render_to_drawable_alpha", XS_Gtk2__Gdk__Pixbuf_render_to_drawable_alpha);
        newXS_deffile("Gtk2::Gdk::Pixbuf::render_pixmap_and_mask_for_colormap", XS_Gtk2__Gdk__Pixbuf_render_pixmap_and_mask_for_colormap);
        newXS_deffile("Gtk2::Gdk::Pixbuf::render_pixmap_and_mask", XS_Gtk2__Gdk__Pixbuf_render_pixmap_and_mask);
        cv = newXS_deffile("Gtk2::Gdk::Pixbuf::get_from_drawable", XS_Gtk2__Gdk__Pixbuf_get_from_drawable);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Gtk2::Gdk::Pixbuf::get_from_image", XS_Gtk2__Gdk__Pixbuf_get_from_drawable);
        XSANY.any_i32 = 1;
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_colorspace", XS_Gtk2__Gdk__Pixbuf_get_colorspace);
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_n_channels", XS_Gtk2__Gdk__Pixbuf_get_n_channels);
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_has_alpha", XS_Gtk2__Gdk__Pixbuf_get_has_alpha);
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_bits_per_sample", XS_Gtk2__Gdk__Pixbuf_get_bits_per_sample);
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_pixels", XS_Gtk2__Gdk__Pixbuf_get_pixels);
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_width", XS_Gtk2__Gdk__Pixbuf_get_width);
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_height", XS_Gtk2__Gdk__Pixbuf_get_height);
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_rowstride", XS_Gtk2__Gdk__Pixbuf_get_rowstride);
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_option", XS_Gtk2__Gdk__Pixbuf_get_option);
#if XSubPPtmpAAAA
        newXS_deffile("Gtk2::Gdk::Pixbuf::set_option", XS_Gtk2__Gdk__Pixbuf_set_option);
#endif
        newXS_deffile("Gtk2::Gdk::Pixbuf::new", XS_Gtk2__Gdk__Pixbuf_new);
        newXS_deffile("Gtk2::Gdk::Pixbuf::copy", XS_Gtk2__Gdk__Pixbuf_copy);
        newXS_deffile("Gtk2::Gdk::Pixbuf::new_subpixbuf", XS_Gtk2__Gdk__Pixbuf_new_subpixbuf);
        newXS_deffile("Gtk2::Gdk::Pixbuf::new_from_file", XS_Gtk2__Gdk__Pixbuf_new_from_file);
#if XSubPPtmpAAAB
        newXS_deffile("Gtk2::Gdk::Pixbuf::new_from_file_at_size", XS_Gtk2__Gdk__Pixbuf_new_from_file_at_size);
#endif
#if XSubPPtmpAAAC
        newXS_deffile("Gtk2::Gdk::Pixbuf::new_from_file_at_scale", XS_Gtk2__Gdk__Pixbuf_new_from_file_at_scale);
#endif
        newXS_deffile("Gtk2::Gdk::Pixbuf::new_from_data", XS_Gtk2__Gdk__Pixbuf_new_from_data);
        newXS_deffile("Gtk2::Gdk::Pixbuf::new_from_xpm_data", XS_Gtk2__Gdk__Pixbuf_new_from_xpm_data);
        newXS_deffile("Gtk2::Gdk::Pixbuf::new_from_inline", XS_Gtk2__Gdk__Pixbuf_new_from_inline);
        newXS_deffile("Gtk2::Gdk::Pixbuf::save", XS_Gtk2__Gdk__Pixbuf_save);
#if XSubPPtmpAAAD
        newXS_deffile("Gtk2::Gdk::Pixbuf::save_to_buffer", XS_Gtk2__Gdk__Pixbuf_save_to_buffer);
#endif
        newXS_deffile("Gtk2::Gdk::Pixbuf::add_alpha", XS_Gtk2__Gdk__Pixbuf_add_alpha);
        newXS_deffile("Gtk2::Gdk::Pixbuf::copy_area", XS_Gtk2__Gdk__Pixbuf_copy_area);
        newXS_deffile("Gtk2::Gdk::Pixbuf::saturate_and_pixelate", XS_Gtk2__Gdk__Pixbuf_saturate_and_pixelate);
        newXS_deffile("Gtk2::Gdk::Pixbuf::fill", XS_Gtk2__Gdk__Pixbuf_fill);
#if XSubPPtmpAAAE
        newXS_deffile("Gtk2::Gdk::Pixbuf::rotate_simple", XS_Gtk2__Gdk__Pixbuf_rotate_simple);
        newXS_deffile("Gtk2::Gdk::Pixbuf::flip", XS_Gtk2__Gdk__Pixbuf_flip);
#endif
        newXS_deffile("Gtk2::Gdk::Pixbuf::scale", XS_Gtk2__Gdk__Pixbuf_scale);
        newXS_deffile("Gtk2::Gdk::Pixbuf::composite", XS_Gtk2__Gdk__Pixbuf_composite);
        newXS_deffile("Gtk2::Gdk::Pixbuf::composite_color", XS_Gtk2__Gdk__Pixbuf_composite_color);
        newXS_deffile("Gtk2::Gdk::Pixbuf::scale_simple", XS_Gtk2__Gdk__Pixbuf_scale_simple);
        newXS_deffile("Gtk2::Gdk::Pixbuf::composite_color_simple", XS_Gtk2__Gdk__Pixbuf_composite_color_simple);
#if XSubPPtmpAAAF
        newXS_deffile("Gtk2::Gdk::Pixbuf::apply_embedded_orientation", XS_Gtk2__Gdk__Pixbuf_apply_embedded_orientation);
#endif
        newXS_deffile("Gtk2::Gdk::PixbufAnimation::new_from_file", XS_Gtk2__Gdk__PixbufAnimation_new_from_file);
        newXS_deffile("Gtk2::Gdk::PixbufAnimation::get_width", XS_Gtk2__Gdk__PixbufAnimation_get_width);
        newXS_deffile("Gtk2::Gdk::PixbufAnimation::get_height", XS_Gtk2__Gdk__PixbufAnimation_get_height);
        newXS_deffile("Gtk2::Gdk::PixbufAnimation::is_static_image", XS_Gtk2__Gdk__PixbufAnimation_is_static_image);
        newXS_deffile("Gtk2::Gdk::PixbufAnimation::get_static_image", XS_Gtk2__Gdk__PixbufAnimation_get_static_image);
        newXS_deffile("Gtk2::Gdk::PixbufAnimation::get_iter", XS_Gtk2__Gdk__PixbufAnimation_get_iter);
        newXS_deffile("Gtk2::Gdk::PixbufAnimationIter::get_delay_time", XS_Gtk2__Gdk__PixbufAnimationIter_get_delay_time);
        newXS_deffile("Gtk2::Gdk::PixbufAnimationIter::get_pixbuf", XS_Gtk2__Gdk__PixbufAnimationIter_get_pixbuf);
        newXS_deffile("Gtk2::Gdk::PixbufAnimationIter::on_currently_loading_frame", XS_Gtk2__Gdk__PixbufAnimationIter_on_currently_loading_frame);
        newXS_deffile("Gtk2::Gdk::PixbufAnimationIter::advance", XS_Gtk2__Gdk__PixbufAnimationIter_advance);
#if XSubPPtmpAAAG
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_formats", XS_Gtk2__Gdk__Pixbuf_get_formats);
#endif
#if XSubPPtmpAAAH
        newXS_deffile("Gtk2::Gdk::Pixbuf::get_file_info", XS_Gtk2__Gdk__Pixbuf_get_file_info);
#endif
#if XSubPPtmpAAAI
        newXS_deffile("Gtk2::Gdk::PixbufFormat::DESTROY", XS_Gtk2__Gdk__PixbufFormat_DESTROY);
#endif
#if XSubPPtmpAAAJ
        newXS_deffile("Gtk2::Gdk::PixbufFormat::set_disabled", XS_Gtk2__Gdk__PixbufFormat_set_disabled);
#endif

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#line 870 "xs/GdkPixbuf.xs"
	/* types like GdkPixbufGifAnim are unknown to us. */
	gperl_object_set_no_warn_unreg_subclass
					(GDK_TYPE_PIXBUF_ANIMATION, TRUE);

#line 946 "xs/GdkPixbuf.xs"
	gperl_object_set_no_warn_unreg_subclass (GDK_TYPE_PIXBUF_ANIMATION_ITER, TRUE);

#if XSubPPtmpAAAG
#endif
#if XSubPPtmpAAAH
#endif
#if XSubPPtmpAAAI
#endif
#if XSubPPtmpAAAJ
#endif
#line 2079 "xs/GdkPixbuf.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

