/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_EXCAVATOR;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_EXCAVATOR.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_EXCAVATOR, sbdtobf16_k_EXCAVATOR, sbf16tos_k_EXCAVATOR, dbf16tod_k_EXCAVATOR,

  samax_k_EXCAVATOR,  samin_k_EXCAVATOR,  smax_k_EXCAVATOR,  smin_k_EXCAVATOR,
  isamax_k_EXCAVATOR, isamin_k_EXCAVATOR, ismax_k_EXCAVATOR, ismin_k_EXCAVATOR,
  snrm2_k_EXCAVATOR,  sasum_k_EXCAVATOR, ssum_k_EXCAVATOR, scopy_k_EXCAVATOR, sbdot_k_EXCAVATOR,
  dsdot_k_EXCAVATOR,
  srot_k_EXCAVATOR,   saxpy_k_EXCAVATOR,  sscal_k_EXCAVATOR, sswap_k_EXCAVATOR,
  sbgemv_n_EXCAVATOR, sbgemv_t_EXCAVATOR, sger_k_EXCAVATOR,
  ssymv_L_EXCAVATOR, ssymv_U_EXCAVATOR,

  sbgemm_kernel_EXCAVATOR, sbgemm_beta_EXCAVATOR,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_EXCAVATOR, sbgemm_itcopy_EXCAVATOR,
#else
  sbgemm_oncopy_EXCAVATOR, sbgemm_otcopy_EXCAVATOR,
#endif
  sbgemm_oncopy_EXCAVATOR, sbgemm_otcopy_EXCAVATOR,

  strsm_kernel_LN_EXCAVATOR, strsm_kernel_LT_EXCAVATOR, strsm_kernel_RN_EXCAVATOR, strsm_kernel_RT_EXCAVATOR,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_EXCAVATOR, strsm_iunncopy_EXCAVATOR, strsm_iutucopy_EXCAVATOR, strsm_iutncopy_EXCAVATOR,
  strsm_ilnucopy_EXCAVATOR, strsm_ilnncopy_EXCAVATOR, strsm_iltucopy_EXCAVATOR, strsm_iltncopy_EXCAVATOR,
#else
  strsm_ounucopy_EXCAVATOR, strsm_ounncopy_EXCAVATOR, strsm_outucopy_EXCAVATOR, strsm_outncopy_EXCAVATOR,
  strsm_olnucopy_EXCAVATOR, strsm_olnncopy_EXCAVATOR, strsm_oltucopy_EXCAVATOR, strsm_oltncopy_EXCAVATOR,
#endif
  strsm_ounucopy_EXCAVATOR, strsm_ounncopy_EXCAVATOR, strsm_outucopy_EXCAVATOR, strsm_outncopy_EXCAVATOR,
  strsm_olnucopy_EXCAVATOR, strsm_olnncopy_EXCAVATOR, strsm_oltucopy_EXCAVATOR, strsm_oltncopy_EXCAVATOR,
  strmm_kernel_RN_EXCAVATOR, strmm_kernel_RT_EXCAVATOR, strmm_kernel_LN_EXCAVATOR, strmm_kernel_LT_EXCAVATOR,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_EXCAVATOR, strmm_iunncopy_EXCAVATOR, strmm_iutucopy_EXCAVATOR, strmm_iutncopy_EXCAVATOR,
  strmm_ilnucopy_EXCAVATOR, strmm_ilnncopy_EXCAVATOR, strmm_iltucopy_EXCAVATOR, strmm_iltncopy_EXCAVATOR,
#else
  strmm_ounucopy_EXCAVATOR, strmm_ounncopy_EXCAVATOR, strmm_outucopy_EXCAVATOR, strmm_outncopy_EXCAVATOR,
  strmm_olnucopy_EXCAVATOR, strmm_olnncopy_EXCAVATOR, strmm_oltucopy_EXCAVATOR, strmm_oltncopy_EXCAVATOR,
#endif
  strmm_ounucopy_EXCAVATOR, strmm_ounncopy_EXCAVATOR, strmm_outucopy_EXCAVATOR, strmm_outncopy_EXCAVATOR,
  strmm_olnucopy_EXCAVATOR, strmm_olnncopy_EXCAVATOR, strmm_oltucopy_EXCAVATOR, strmm_oltncopy_EXCAVATOR,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_EXCAVATOR, ssymm_iltcopy_EXCAVATOR,
#else
  ssymm_outcopy_EXCAVATOR, ssymm_oltcopy_EXCAVATOR,
#endif
  ssymm_outcopy_EXCAVATOR, ssymm_oltcopy_EXCAVATOR,

#ifndef NO_LAPACK
  sneg_tcopy_EXCAVATOR, slaswp_ncopy_EXCAVATOR,
#else
  NULL,NULL,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_EXCAVATOR,  samin_k_EXCAVATOR,  smax_k_EXCAVATOR,  smin_k_EXCAVATOR,
  isamax_k_EXCAVATOR, isamin_k_EXCAVATOR, ismax_k_EXCAVATOR, ismin_k_EXCAVATOR,
  snrm2_k_EXCAVATOR,  sasum_k_EXCAVATOR,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_EXCAVATOR,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_EXCAVATOR, sdot_k_EXCAVATOR,
//  dsdot_k_EXCAVATOR,
  srot_k_EXCAVATOR,   saxpy_k_EXCAVATOR,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_EXCAVATOR,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_EXCAVATOR,
  sgemv_n_EXCAVATOR,  sgemv_t_EXCAVATOR,
#endif
#if BUILD_SINGLE == 1  
  sger_k_EXCAVATOR,
  ssymv_L_EXCAVATOR, ssymv_U_EXCAVATOR,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_EXCAVATOR,
  sgemm_direct_performant_EXCAVATOR,	
#endif

  sgemm_kernel_EXCAVATOR, sgemm_beta_EXCAVATOR,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_EXCAVATOR, sgemm_itcopy_EXCAVATOR,
#else
  sgemm_oncopy_EXCAVATOR, sgemm_otcopy_EXCAVATOR,
#endif
  sgemm_oncopy_EXCAVATOR, sgemm_otcopy_EXCAVATOR,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_EXCAVATOR, strsm_kernel_LT_EXCAVATOR, strsm_kernel_RN_EXCAVATOR, strsm_kernel_RT_EXCAVATOR,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_EXCAVATOR, strsm_iunncopy_EXCAVATOR, strsm_iutucopy_EXCAVATOR, strsm_iutncopy_EXCAVATOR,
  strsm_ilnucopy_EXCAVATOR, strsm_ilnncopy_EXCAVATOR, strsm_iltucopy_EXCAVATOR, strsm_iltncopy_EXCAVATOR,
#else
  strsm_ounucopy_EXCAVATOR, strsm_ounncopy_EXCAVATOR, strsm_outucopy_EXCAVATOR, strsm_outncopy_EXCAVATOR,
  strsm_olnucopy_EXCAVATOR, strsm_olnncopy_EXCAVATOR, strsm_oltucopy_EXCAVATOR, strsm_oltncopy_EXCAVATOR,
#endif
  strsm_ounucopy_EXCAVATOR, strsm_ounncopy_EXCAVATOR, strsm_outucopy_EXCAVATOR, strsm_outncopy_EXCAVATOR,
  strsm_olnucopy_EXCAVATOR, strsm_olnncopy_EXCAVATOR, strsm_oltucopy_EXCAVATOR, strsm_oltncopy_EXCAVATOR,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_EXCAVATOR, strmm_kernel_RT_EXCAVATOR, strmm_kernel_LN_EXCAVATOR, strmm_kernel_LT_EXCAVATOR,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_EXCAVATOR, strmm_iunncopy_EXCAVATOR, strmm_iutucopy_EXCAVATOR, strmm_iutncopy_EXCAVATOR,
  strmm_ilnucopy_EXCAVATOR, strmm_ilnncopy_EXCAVATOR, strmm_iltucopy_EXCAVATOR, strmm_iltncopy_EXCAVATOR,
#else
  strmm_ounucopy_EXCAVATOR, strmm_ounncopy_EXCAVATOR, strmm_outucopy_EXCAVATOR, strmm_outncopy_EXCAVATOR,
  strmm_olnucopy_EXCAVATOR, strmm_olnncopy_EXCAVATOR, strmm_oltucopy_EXCAVATOR, strmm_oltncopy_EXCAVATOR,
#endif
  strmm_ounucopy_EXCAVATOR, strmm_ounncopy_EXCAVATOR, strmm_outucopy_EXCAVATOR, strmm_outncopy_EXCAVATOR,
  strmm_olnucopy_EXCAVATOR, strmm_olnncopy_EXCAVATOR, strmm_oltucopy_EXCAVATOR, strmm_oltncopy_EXCAVATOR,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_EXCAVATOR, ssymm_iltcopy_EXCAVATOR,
#else
  ssymm_outcopy_EXCAVATOR, ssymm_oltcopy_EXCAVATOR,
#endif
  ssymm_outcopy_EXCAVATOR, ssymm_oltcopy_EXCAVATOR,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_EXCAVATOR, slaswp_ncopy_EXCAVATOR,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_EXCAVATOR,  damin_k_EXCAVATOR,  dmax_k_EXCAVATOR,  dmin_k_EXCAVATOR,
  idamax_k_EXCAVATOR, idamin_k_EXCAVATOR, idmax_k_EXCAVATOR, idmin_k_EXCAVATOR,
  dnrm2_k_EXCAVATOR, dasum_k_EXCAVATOR,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_EXCAVATOR,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_EXCAVATOR, ddot_k_EXCAVATOR,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_EXCAVATOR,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_EXCAVATOR,
  daxpy_k_EXCAVATOR,
  dscal_k_EXCAVATOR, 
  dswap_k_EXCAVATOR,
  dgemv_n_EXCAVATOR,  dgemv_t_EXCAVATOR,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_EXCAVATOR,
  dsymv_L_EXCAVATOR,  dsymv_U_EXCAVATOR,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_EXCAVATOR, dgemm_beta_EXCAVATOR,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_EXCAVATOR, dgemm_itcopy_EXCAVATOR,
#else
  dgemm_oncopy_EXCAVATOR, dgemm_otcopy_EXCAVATOR,
#endif
  dgemm_oncopy_EXCAVATOR, dgemm_otcopy_EXCAVATOR,
#endif

#if  (BUILD_DOUBLE==1)  
  dtrsm_kernel_LN_EXCAVATOR, dtrsm_kernel_LT_EXCAVATOR, dtrsm_kernel_RN_EXCAVATOR, dtrsm_kernel_RT_EXCAVATOR,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_EXCAVATOR, dtrsm_iunncopy_EXCAVATOR, dtrsm_iutucopy_EXCAVATOR, dtrsm_iutncopy_EXCAVATOR,
  dtrsm_ilnucopy_EXCAVATOR, dtrsm_ilnncopy_EXCAVATOR, dtrsm_iltucopy_EXCAVATOR, dtrsm_iltncopy_EXCAVATOR,
#else
  dtrsm_ounucopy_EXCAVATOR, dtrsm_ounncopy_EXCAVATOR, dtrsm_outucopy_EXCAVATOR, dtrsm_outncopy_EXCAVATOR,
  dtrsm_olnucopy_EXCAVATOR, dtrsm_olnncopy_EXCAVATOR, dtrsm_oltucopy_EXCAVATOR, dtrsm_oltncopy_EXCAVATOR,
#endif
  dtrsm_ounucopy_EXCAVATOR, dtrsm_ounncopy_EXCAVATOR, dtrsm_outucopy_EXCAVATOR, dtrsm_outncopy_EXCAVATOR,
  dtrsm_olnucopy_EXCAVATOR, dtrsm_olnncopy_EXCAVATOR, dtrsm_oltucopy_EXCAVATOR, dtrsm_oltncopy_EXCAVATOR,
  dtrmm_kernel_RN_EXCAVATOR, dtrmm_kernel_RT_EXCAVATOR, dtrmm_kernel_LN_EXCAVATOR, dtrmm_kernel_LT_EXCAVATOR,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_EXCAVATOR, dtrmm_iunncopy_EXCAVATOR, dtrmm_iutucopy_EXCAVATOR, dtrmm_iutncopy_EXCAVATOR,
  dtrmm_ilnucopy_EXCAVATOR, dtrmm_ilnncopy_EXCAVATOR, dtrmm_iltucopy_EXCAVATOR, dtrmm_iltncopy_EXCAVATOR,
#else
  dtrmm_ounucopy_EXCAVATOR, dtrmm_ounncopy_EXCAVATOR, dtrmm_outucopy_EXCAVATOR, dtrmm_outncopy_EXCAVATOR,
  dtrmm_olnucopy_EXCAVATOR, dtrmm_olnncopy_EXCAVATOR, dtrmm_oltucopy_EXCAVATOR, dtrmm_oltncopy_EXCAVATOR,
#endif
  dtrmm_ounucopy_EXCAVATOR, dtrmm_ounncopy_EXCAVATOR, dtrmm_outucopy_EXCAVATOR, dtrmm_outncopy_EXCAVATOR,
  dtrmm_olnucopy_EXCAVATOR, dtrmm_olnncopy_EXCAVATOR, dtrmm_oltucopy_EXCAVATOR, dtrmm_oltncopy_EXCAVATOR,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_EXCAVATOR, dsymm_iltcopy_EXCAVATOR,
#else
  dsymm_outcopy_EXCAVATOR, dsymm_oltcopy_EXCAVATOR,
#endif
  dsymm_outcopy_EXCAVATOR, dsymm_oltcopy_EXCAVATOR,

#ifndef NO_LAPACK
  dneg_tcopy_EXCAVATOR, dlaswp_ncopy_EXCAVATOR,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_EXCAVATOR,  qamin_k_EXCAVATOR,  qmax_k_EXCAVATOR,  qmin_k_EXCAVATOR,
  iqamax_k_EXCAVATOR, iqamin_k_EXCAVATOR, iqmax_k_EXCAVATOR, iqmin_k_EXCAVATOR,
  qnrm2_k_EXCAVATOR,  qasum_k_EXCAVATOR,  qsum_k_EXCAVATOR, qcopy_k_EXCAVATOR, qdot_k_EXCAVATOR,
  qrot_k_EXCAVATOR,   qaxpy_k_EXCAVATOR,  qscal_k_EXCAVATOR, qswap_k_EXCAVATOR,
  qgemv_n_EXCAVATOR,  qgemv_t_EXCAVATOR,  qger_k_EXCAVATOR,
  qsymv_L_EXCAVATOR,  qsymv_U_EXCAVATOR,

  qgemm_kernel_EXCAVATOR, qgemm_beta_EXCAVATOR,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_EXCAVATOR, qgemm_itcopy_EXCAVATOR,
#else
  qgemm_oncopy_EXCAVATOR, qgemm_otcopy_EXCAVATOR,
#endif
  qgemm_oncopy_EXCAVATOR, qgemm_otcopy_EXCAVATOR,
  qtrsm_kernel_LN_EXCAVATOR, qtrsm_kernel_LT_EXCAVATOR, qtrsm_kernel_RN_EXCAVATOR, qtrsm_kernel_RT_EXCAVATOR,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_EXCAVATOR, qtrsm_iunncopy_EXCAVATOR, qtrsm_iutucopy_EXCAVATOR, qtrsm_iutncopy_EXCAVATOR,
  qtrsm_ilnucopy_EXCAVATOR, qtrsm_ilnncopy_EXCAVATOR, qtrsm_iltucopy_EXCAVATOR, qtrsm_iltncopy_EXCAVATOR,
#else
  qtrsm_ounucopy_EXCAVATOR, qtrsm_ounncopy_EXCAVATOR, qtrsm_outucopy_EXCAVATOR, qtrsm_outncopy_EXCAVATOR,
  qtrsm_olnucopy_EXCAVATOR, qtrsm_olnncopy_EXCAVATOR, qtrsm_oltucopy_EXCAVATOR, qtrsm_oltncopy_EXCAVATOR,
#endif
  qtrsm_ounucopy_EXCAVATOR, qtrsm_ounncopy_EXCAVATOR, qtrsm_outucopy_EXCAVATOR, qtrsm_outncopy_EXCAVATOR,
  qtrsm_olnucopy_EXCAVATOR, qtrsm_olnncopy_EXCAVATOR, qtrsm_oltucopy_EXCAVATOR, qtrsm_oltncopy_EXCAVATOR,
  qtrmm_kernel_RN_EXCAVATOR, qtrmm_kernel_RT_EXCAVATOR, qtrmm_kernel_LN_EXCAVATOR, qtrmm_kernel_LT_EXCAVATOR,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_EXCAVATOR, qtrmm_iunncopy_EXCAVATOR, qtrmm_iutucopy_EXCAVATOR, qtrmm_iutncopy_EXCAVATOR,
  qtrmm_ilnucopy_EXCAVATOR, qtrmm_ilnncopy_EXCAVATOR, qtrmm_iltucopy_EXCAVATOR, qtrmm_iltncopy_EXCAVATOR,
#else
  qtrmm_ounucopy_EXCAVATOR, qtrmm_ounncopy_EXCAVATOR, qtrmm_outucopy_EXCAVATOR, qtrmm_outncopy_EXCAVATOR,
  qtrmm_olnucopy_EXCAVATOR, qtrmm_olnncopy_EXCAVATOR, qtrmm_oltucopy_EXCAVATOR, qtrmm_oltncopy_EXCAVATOR,
#endif
  qtrmm_ounucopy_EXCAVATOR, qtrmm_ounncopy_EXCAVATOR, qtrmm_outucopy_EXCAVATOR, qtrmm_outncopy_EXCAVATOR,
  qtrmm_olnucopy_EXCAVATOR, qtrmm_olnncopy_EXCAVATOR, qtrmm_oltucopy_EXCAVATOR, qtrmm_oltncopy_EXCAVATOR,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_EXCAVATOR, qsymm_iltcopy_EXCAVATOR,
#else
  qsymm_outcopy_EXCAVATOR, qsymm_oltcopy_EXCAVATOR,
#endif
  qsymm_outcopy_EXCAVATOR, qsymm_oltcopy_EXCAVATOR,

#ifndef NO_LAPACK
  qneg_tcopy_EXCAVATOR, qlaswp_ncopy_EXCAVATOR,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_EXCAVATOR, camin_k_EXCAVATOR, icamax_k_EXCAVATOR, icamin_k_EXCAVATOR,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_EXCAVATOR, casum_k_EXCAVATOR, csum_k_EXCAVATOR,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_EXCAVATOR,  cdotu_k_EXCAVATOR, cdotc_k_EXCAVATOR,
#endif
#if (BUILD_COMPLEX)
 csrot_k_EXCAVATOR,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_EXCAVATOR,
  caxpyc_k_EXCAVATOR, 
  cscal_k_EXCAVATOR, 
  cswap_k_EXCAVATOR,

  cgemv_n_EXCAVATOR, cgemv_t_EXCAVATOR, cgemv_r_EXCAVATOR, cgemv_c_EXCAVATOR,
  cgemv_o_EXCAVATOR, cgemv_u_EXCAVATOR, cgemv_s_EXCAVATOR, cgemv_d_EXCAVATOR,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_EXCAVATOR, cgerc_k_EXCAVATOR, cgerv_k_EXCAVATOR, cgerd_k_EXCAVATOR,
  csymv_L_EXCAVATOR, csymv_U_EXCAVATOR,
  chemv_L_EXCAVATOR, chemv_U_EXCAVATOR, chemv_M_EXCAVATOR, chemv_V_EXCAVATOR,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_EXCAVATOR, cgemm_kernel_l_EXCAVATOR, cgemm_kernel_r_EXCAVATOR, cgemm_kernel_b_EXCAVATOR,
  cgemm_beta_EXCAVATOR,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_EXCAVATOR, cgemm_itcopy_EXCAVATOR,
#else
  cgemm_oncopy_EXCAVATOR, cgemm_otcopy_EXCAVATOR,
#endif
  cgemm_oncopy_EXCAVATOR, cgemm_otcopy_EXCAVATOR,

  ctrsm_kernel_LN_EXCAVATOR, ctrsm_kernel_LT_EXCAVATOR, ctrsm_kernel_LR_EXCAVATOR, ctrsm_kernel_LC_EXCAVATOR,
  ctrsm_kernel_RN_EXCAVATOR, ctrsm_kernel_RT_EXCAVATOR, ctrsm_kernel_RR_EXCAVATOR, ctrsm_kernel_RC_EXCAVATOR,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_EXCAVATOR,  ctrsm_iunncopy_EXCAVATOR,  ctrsm_iutucopy_EXCAVATOR,  ctrsm_iutncopy_EXCAVATOR,
  ctrsm_ilnucopy_EXCAVATOR,  ctrsm_ilnncopy_EXCAVATOR,  ctrsm_iltucopy_EXCAVATOR,  ctrsm_iltncopy_EXCAVATOR,
#else
  ctrsm_ounucopy_EXCAVATOR,  ctrsm_ounncopy_EXCAVATOR,  ctrsm_outucopy_EXCAVATOR,  ctrsm_outncopy_EXCAVATOR,
  ctrsm_olnucopy_EXCAVATOR,  ctrsm_olnncopy_EXCAVATOR,  ctrsm_oltucopy_EXCAVATOR,  ctrsm_oltncopy_EXCAVATOR,
#endif
  ctrsm_ounucopy_EXCAVATOR,  ctrsm_ounncopy_EXCAVATOR,  ctrsm_outucopy_EXCAVATOR,  ctrsm_outncopy_EXCAVATOR,
  ctrsm_olnucopy_EXCAVATOR,  ctrsm_olnncopy_EXCAVATOR,  ctrsm_oltucopy_EXCAVATOR,  ctrsm_oltncopy_EXCAVATOR,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_EXCAVATOR,  ctrmm_kernel_RT_EXCAVATOR,  ctrmm_kernel_RR_EXCAVATOR,  ctrmm_kernel_RC_EXCAVATOR,
  ctrmm_kernel_LN_EXCAVATOR,  ctrmm_kernel_LT_EXCAVATOR,  ctrmm_kernel_LR_EXCAVATOR,  ctrmm_kernel_LC_EXCAVATOR,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_EXCAVATOR,  ctrmm_iunncopy_EXCAVATOR,  ctrmm_iutucopy_EXCAVATOR,  ctrmm_iutncopy_EXCAVATOR,
  ctrmm_ilnucopy_EXCAVATOR,  ctrmm_ilnncopy_EXCAVATOR,  ctrmm_iltucopy_EXCAVATOR,  ctrmm_iltncopy_EXCAVATOR,
#else
  ctrmm_ounucopy_EXCAVATOR,  ctrmm_ounncopy_EXCAVATOR,  ctrmm_outucopy_EXCAVATOR,  ctrmm_outncopy_EXCAVATOR,
  ctrmm_olnucopy_EXCAVATOR,  ctrmm_olnncopy_EXCAVATOR,  ctrmm_oltucopy_EXCAVATOR,  ctrmm_oltncopy_EXCAVATOR,
#endif
  ctrmm_ounucopy_EXCAVATOR,  ctrmm_ounncopy_EXCAVATOR,  ctrmm_outucopy_EXCAVATOR,  ctrmm_outncopy_EXCAVATOR,
  ctrmm_olnucopy_EXCAVATOR,  ctrmm_olnncopy_EXCAVATOR,  ctrmm_oltucopy_EXCAVATOR,  ctrmm_oltncopy_EXCAVATOR,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_EXCAVATOR,  csymm_iltcopy_EXCAVATOR,
#else
  csymm_outcopy_EXCAVATOR,  csymm_oltcopy_EXCAVATOR,
#endif
  csymm_outcopy_EXCAVATOR,  csymm_oltcopy_EXCAVATOR,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_EXCAVATOR,  chemm_iltcopy_EXCAVATOR,
#else
  chemm_outcopy_EXCAVATOR,  chemm_oltcopy_EXCAVATOR,
#endif
  chemm_outcopy_EXCAVATOR,  chemm_oltcopy_EXCAVATOR,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_EXCAVATOR,

  cgemm3m_incopyb_EXCAVATOR,  cgemm3m_incopyr_EXCAVATOR,
  cgemm3m_incopyi_EXCAVATOR,  cgemm3m_itcopyb_EXCAVATOR,
  cgemm3m_itcopyr_EXCAVATOR,  cgemm3m_itcopyi_EXCAVATOR,
  cgemm3m_oncopyb_EXCAVATOR,  cgemm3m_oncopyr_EXCAVATOR,
  cgemm3m_oncopyi_EXCAVATOR,  cgemm3m_otcopyb_EXCAVATOR,
  cgemm3m_otcopyr_EXCAVATOR,  cgemm3m_otcopyi_EXCAVATOR,

  csymm3m_iucopyb_EXCAVATOR,  csymm3m_ilcopyb_EXCAVATOR,
  csymm3m_iucopyr_EXCAVATOR,  csymm3m_ilcopyr_EXCAVATOR,
  csymm3m_iucopyi_EXCAVATOR,  csymm3m_ilcopyi_EXCAVATOR,
  csymm3m_oucopyb_EXCAVATOR,  csymm3m_olcopyb_EXCAVATOR,
  csymm3m_oucopyr_EXCAVATOR,  csymm3m_olcopyr_EXCAVATOR,
  csymm3m_oucopyi_EXCAVATOR,  csymm3m_olcopyi_EXCAVATOR,

  chemm3m_iucopyb_EXCAVATOR,  chemm3m_ilcopyb_EXCAVATOR,
  chemm3m_iucopyr_EXCAVATOR,  chemm3m_ilcopyr_EXCAVATOR,
  chemm3m_iucopyi_EXCAVATOR,  chemm3m_ilcopyi_EXCAVATOR,

  chemm3m_oucopyb_EXCAVATOR,  chemm3m_olcopyb_EXCAVATOR,
  chemm3m_oucopyr_EXCAVATOR,  chemm3m_olcopyr_EXCAVATOR,
  chemm3m_oucopyi_EXCAVATOR,  chemm3m_olcopyi_EXCAVATOR,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_EXCAVATOR,
  
   claswp_ncopy_EXCAVATOR,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_EXCAVATOR, zamin_k_EXCAVATOR, izamax_k_EXCAVATOR, izamin_k_EXCAVATOR,
  znrm2_k_EXCAVATOR, zasum_k_EXCAVATOR, zsum_k_EXCAVATOR, zcopy_k_EXCAVATOR,
  zdotu_k_EXCAVATOR, zdotc_k_EXCAVATOR, zdrot_k_EXCAVATOR,
  zaxpy_k_EXCAVATOR, zaxpyc_k_EXCAVATOR, zscal_k_EXCAVATOR, zswap_k_EXCAVATOR,

  zgemv_n_EXCAVATOR, zgemv_t_EXCAVATOR, zgemv_r_EXCAVATOR, zgemv_c_EXCAVATOR,
  zgemv_o_EXCAVATOR, zgemv_u_EXCAVATOR, zgemv_s_EXCAVATOR, zgemv_d_EXCAVATOR,
  zgeru_k_EXCAVATOR, zgerc_k_EXCAVATOR, zgerv_k_EXCAVATOR, zgerd_k_EXCAVATOR,
  zsymv_L_EXCAVATOR, zsymv_U_EXCAVATOR,
  zhemv_L_EXCAVATOR, zhemv_U_EXCAVATOR, zhemv_M_EXCAVATOR, zhemv_V_EXCAVATOR,

  zgemm_kernel_n_EXCAVATOR, zgemm_kernel_l_EXCAVATOR, zgemm_kernel_r_EXCAVATOR, zgemm_kernel_b_EXCAVATOR,
  zgemm_beta_EXCAVATOR,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_EXCAVATOR, zgemm_itcopy_EXCAVATOR,
#else
  zgemm_oncopy_EXCAVATOR, zgemm_otcopy_EXCAVATOR,
#endif
  zgemm_oncopy_EXCAVATOR, zgemm_otcopy_EXCAVATOR,

  ztrsm_kernel_LN_EXCAVATOR, ztrsm_kernel_LT_EXCAVATOR, ztrsm_kernel_LR_EXCAVATOR, ztrsm_kernel_LC_EXCAVATOR,
  ztrsm_kernel_RN_EXCAVATOR, ztrsm_kernel_RT_EXCAVATOR, ztrsm_kernel_RR_EXCAVATOR, ztrsm_kernel_RC_EXCAVATOR,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_EXCAVATOR,  ztrsm_iunncopy_EXCAVATOR,  ztrsm_iutucopy_EXCAVATOR,  ztrsm_iutncopy_EXCAVATOR,
  ztrsm_ilnucopy_EXCAVATOR,  ztrsm_ilnncopy_EXCAVATOR,  ztrsm_iltucopy_EXCAVATOR,  ztrsm_iltncopy_EXCAVATOR,
#else
  ztrsm_ounucopy_EXCAVATOR,  ztrsm_ounncopy_EXCAVATOR,  ztrsm_outucopy_EXCAVATOR,  ztrsm_outncopy_EXCAVATOR,
  ztrsm_olnucopy_EXCAVATOR,  ztrsm_olnncopy_EXCAVATOR,  ztrsm_oltucopy_EXCAVATOR,  ztrsm_oltncopy_EXCAVATOR,
#endif
  ztrsm_ounucopy_EXCAVATOR,  ztrsm_ounncopy_EXCAVATOR,  ztrsm_outucopy_EXCAVATOR,  ztrsm_outncopy_EXCAVATOR,
  ztrsm_olnucopy_EXCAVATOR,  ztrsm_olnncopy_EXCAVATOR,  ztrsm_oltucopy_EXCAVATOR,  ztrsm_oltncopy_EXCAVATOR,

  ztrmm_kernel_RN_EXCAVATOR,  ztrmm_kernel_RT_EXCAVATOR,  ztrmm_kernel_RR_EXCAVATOR,  ztrmm_kernel_RC_EXCAVATOR,
  ztrmm_kernel_LN_EXCAVATOR,  ztrmm_kernel_LT_EXCAVATOR,  ztrmm_kernel_LR_EXCAVATOR,  ztrmm_kernel_LC_EXCAVATOR,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_EXCAVATOR,  ztrmm_iunncopy_EXCAVATOR,  ztrmm_iutucopy_EXCAVATOR,  ztrmm_iutncopy_EXCAVATOR,
  ztrmm_ilnucopy_EXCAVATOR,  ztrmm_ilnncopy_EXCAVATOR,  ztrmm_iltucopy_EXCAVATOR,  ztrmm_iltncopy_EXCAVATOR,
#else
  ztrmm_ounucopy_EXCAVATOR,  ztrmm_ounncopy_EXCAVATOR,  ztrmm_outucopy_EXCAVATOR,  ztrmm_outncopy_EXCAVATOR,
  ztrmm_olnucopy_EXCAVATOR,  ztrmm_olnncopy_EXCAVATOR,  ztrmm_oltucopy_EXCAVATOR,  ztrmm_oltncopy_EXCAVATOR,
#endif
  ztrmm_ounucopy_EXCAVATOR,  ztrmm_ounncopy_EXCAVATOR,  ztrmm_outucopy_EXCAVATOR,  ztrmm_outncopy_EXCAVATOR,
  ztrmm_olnucopy_EXCAVATOR,  ztrmm_olnncopy_EXCAVATOR,  ztrmm_oltucopy_EXCAVATOR,  ztrmm_oltncopy_EXCAVATOR,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_EXCAVATOR,  zsymm_iltcopy_EXCAVATOR,
#else
  zsymm_outcopy_EXCAVATOR,  zsymm_oltcopy_EXCAVATOR,
#endif
  zsymm_outcopy_EXCAVATOR,  zsymm_oltcopy_EXCAVATOR,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_EXCAVATOR,  zhemm_iltcopy_EXCAVATOR,
#else
  zhemm_outcopy_EXCAVATOR,  zhemm_oltcopy_EXCAVATOR,
#endif
  zhemm_outcopy_EXCAVATOR,  zhemm_oltcopy_EXCAVATOR,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_EXCAVATOR,

  zgemm3m_incopyb_EXCAVATOR,  zgemm3m_incopyr_EXCAVATOR,
  zgemm3m_incopyi_EXCAVATOR,  zgemm3m_itcopyb_EXCAVATOR,
  zgemm3m_itcopyr_EXCAVATOR,  zgemm3m_itcopyi_EXCAVATOR,
  zgemm3m_oncopyb_EXCAVATOR,  zgemm3m_oncopyr_EXCAVATOR,
  zgemm3m_oncopyi_EXCAVATOR,  zgemm3m_otcopyb_EXCAVATOR,
  zgemm3m_otcopyr_EXCAVATOR,  zgemm3m_otcopyi_EXCAVATOR,

  zsymm3m_iucopyb_EXCAVATOR,  zsymm3m_ilcopyb_EXCAVATOR,
  zsymm3m_iucopyr_EXCAVATOR,  zsymm3m_ilcopyr_EXCAVATOR,
  zsymm3m_iucopyi_EXCAVATOR,  zsymm3m_ilcopyi_EXCAVATOR,
  zsymm3m_oucopyb_EXCAVATOR,  zsymm3m_olcopyb_EXCAVATOR,
  zsymm3m_oucopyr_EXCAVATOR,  zsymm3m_olcopyr_EXCAVATOR,
  zsymm3m_oucopyi_EXCAVATOR,  zsymm3m_olcopyi_EXCAVATOR,

  zhemm3m_iucopyb_EXCAVATOR,  zhemm3m_ilcopyb_EXCAVATOR,
  zhemm3m_iucopyr_EXCAVATOR,  zhemm3m_ilcopyr_EXCAVATOR,
  zhemm3m_iucopyi_EXCAVATOR,  zhemm3m_ilcopyi_EXCAVATOR,

  zhemm3m_oucopyb_EXCAVATOR,  zhemm3m_olcopyb_EXCAVATOR,
  zhemm3m_oucopyr_EXCAVATOR,  zhemm3m_olcopyr_EXCAVATOR,
  zhemm3m_oucopyi_EXCAVATOR,  zhemm3m_olcopyi_EXCAVATOR,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_EXCAVATOR, zlaswp_ncopy_EXCAVATOR,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_EXCAVATOR, xamin_k_EXCAVATOR, ixamax_k_EXCAVATOR, ixamin_k_EXCAVATOR,
  xnrm2_k_EXCAVATOR, xasum_k_EXCAVATOR, xsum_k_EXCAVATOR, xcopy_k_EXCAVATOR,
  xdotu_k_EXCAVATOR, xdotc_k_EXCAVATOR, xqrot_k_EXCAVATOR,
  xaxpy_k_EXCAVATOR, xaxpyc_k_EXCAVATOR, xscal_k_EXCAVATOR, xswap_k_EXCAVATOR,

  xgemv_n_EXCAVATOR, xgemv_t_EXCAVATOR, xgemv_r_EXCAVATOR, xgemv_c_EXCAVATOR,
  xgemv_o_EXCAVATOR, xgemv_u_EXCAVATOR, xgemv_s_EXCAVATOR, xgemv_d_EXCAVATOR,
  xgeru_k_EXCAVATOR, xgerc_k_EXCAVATOR, xgerv_k_EXCAVATOR, xgerd_k_EXCAVATOR,
  xsymv_L_EXCAVATOR, xsymv_U_EXCAVATOR,
  xhemv_L_EXCAVATOR, xhemv_U_EXCAVATOR, xhemv_M_EXCAVATOR, xhemv_V_EXCAVATOR,

  xgemm_kernel_n_EXCAVATOR, xgemm_kernel_l_EXCAVATOR, xgemm_kernel_r_EXCAVATOR, xgemm_kernel_b_EXCAVATOR,
  xgemm_beta_EXCAVATOR,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_EXCAVATOR, xgemm_itcopy_EXCAVATOR,
#else
  xgemm_oncopy_EXCAVATOR, xgemm_otcopy_EXCAVATOR,
#endif
  xgemm_oncopy_EXCAVATOR, xgemm_otcopy_EXCAVATOR,

  xtrsm_kernel_LN_EXCAVATOR, xtrsm_kernel_LT_EXCAVATOR, xtrsm_kernel_LR_EXCAVATOR, xtrsm_kernel_LC_EXCAVATOR,
  xtrsm_kernel_RN_EXCAVATOR, xtrsm_kernel_RT_EXCAVATOR, xtrsm_kernel_RR_EXCAVATOR, xtrsm_kernel_RC_EXCAVATOR,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_EXCAVATOR,  xtrsm_iunncopy_EXCAVATOR,  xtrsm_iutucopy_EXCAVATOR,  xtrsm_iutncopy_EXCAVATOR,
  xtrsm_ilnucopy_EXCAVATOR,  xtrsm_ilnncopy_EXCAVATOR,  xtrsm_iltucopy_EXCAVATOR,  xtrsm_iltncopy_EXCAVATOR,
#else
  xtrsm_ounucopy_EXCAVATOR,  xtrsm_ounncopy_EXCAVATOR,  xtrsm_outucopy_EXCAVATOR,  xtrsm_outncopy_EXCAVATOR,
  xtrsm_olnucopy_EXCAVATOR,  xtrsm_olnncopy_EXCAVATOR,  xtrsm_oltucopy_EXCAVATOR,  xtrsm_oltncopy_EXCAVATOR,
#endif
  xtrsm_ounucopy_EXCAVATOR,  xtrsm_ounncopy_EXCAVATOR,  xtrsm_outucopy_EXCAVATOR,  xtrsm_outncopy_EXCAVATOR,
  xtrsm_olnucopy_EXCAVATOR,  xtrsm_olnncopy_EXCAVATOR,  xtrsm_oltucopy_EXCAVATOR,  xtrsm_oltncopy_EXCAVATOR,

  xtrmm_kernel_RN_EXCAVATOR,  xtrmm_kernel_RT_EXCAVATOR,  xtrmm_kernel_RR_EXCAVATOR,  xtrmm_kernel_RC_EXCAVATOR,
  xtrmm_kernel_LN_EXCAVATOR,  xtrmm_kernel_LT_EXCAVATOR,  xtrmm_kernel_LR_EXCAVATOR,  xtrmm_kernel_LC_EXCAVATOR,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_EXCAVATOR,  xtrmm_iunncopy_EXCAVATOR,  xtrmm_iutucopy_EXCAVATOR,  xtrmm_iutncopy_EXCAVATOR,
  xtrmm_ilnucopy_EXCAVATOR,  xtrmm_ilnncopy_EXCAVATOR,  xtrmm_iltucopy_EXCAVATOR,  xtrmm_iltncopy_EXCAVATOR,
#else
  xtrmm_ounucopy_EXCAVATOR,  xtrmm_ounncopy_EXCAVATOR,  xtrmm_outucopy_EXCAVATOR,  xtrmm_outncopy_EXCAVATOR,
  xtrmm_olnucopy_EXCAVATOR,  xtrmm_olnncopy_EXCAVATOR,  xtrmm_oltucopy_EXCAVATOR,  xtrmm_oltncopy_EXCAVATOR,
#endif
  xtrmm_ounucopy_EXCAVATOR,  xtrmm_ounncopy_EXCAVATOR,  xtrmm_outucopy_EXCAVATOR,  xtrmm_outncopy_EXCAVATOR,
  xtrmm_olnucopy_EXCAVATOR,  xtrmm_olnncopy_EXCAVATOR,  xtrmm_oltucopy_EXCAVATOR,  xtrmm_oltncopy_EXCAVATOR,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_EXCAVATOR,  xsymm_iltcopy_EXCAVATOR,
#else
  xsymm_outcopy_EXCAVATOR,  xsymm_oltcopy_EXCAVATOR,
#endif
  xsymm_outcopy_EXCAVATOR,  xsymm_oltcopy_EXCAVATOR,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_EXCAVATOR,  xhemm_iltcopy_EXCAVATOR,
#else
  xhemm_outcopy_EXCAVATOR,  xhemm_oltcopy_EXCAVATOR,
#endif
  xhemm_outcopy_EXCAVATOR,  xhemm_oltcopy_EXCAVATOR,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_EXCAVATOR,

  xgemm3m_incopyb_EXCAVATOR,  xgemm3m_incopyr_EXCAVATOR,
  xgemm3m_incopyi_EXCAVATOR,  xgemm3m_itcopyb_EXCAVATOR,
  xgemm3m_itcopyr_EXCAVATOR,  xgemm3m_itcopyi_EXCAVATOR,
  xgemm3m_oncopyb_EXCAVATOR,  xgemm3m_oncopyr_EXCAVATOR,
  xgemm3m_oncopyi_EXCAVATOR,  xgemm3m_otcopyb_EXCAVATOR,
  xgemm3m_otcopyr_EXCAVATOR,  xgemm3m_otcopyi_EXCAVATOR,

  xsymm3m_iucopyb_EXCAVATOR,  xsymm3m_ilcopyb_EXCAVATOR,
  xsymm3m_iucopyr_EXCAVATOR,  xsymm3m_ilcopyr_EXCAVATOR,
  xsymm3m_iucopyi_EXCAVATOR,  xsymm3m_ilcopyi_EXCAVATOR,
  xsymm3m_oucopyb_EXCAVATOR,  xsymm3m_olcopyb_EXCAVATOR,
  xsymm3m_oucopyr_EXCAVATOR,  xsymm3m_olcopyr_EXCAVATOR,
  xsymm3m_oucopyi_EXCAVATOR,  xsymm3m_olcopyi_EXCAVATOR,

  xhemm3m_iucopyb_EXCAVATOR,  xhemm3m_ilcopyb_EXCAVATOR,
  xhemm3m_iucopyr_EXCAVATOR,  xhemm3m_ilcopyr_EXCAVATOR,
  xhemm3m_iucopyi_EXCAVATOR,  xhemm3m_ilcopyi_EXCAVATOR,

  xhemm3m_oucopyb_EXCAVATOR,  xhemm3m_olcopyb_EXCAVATOR,
  xhemm3m_oucopyr_EXCAVATOR,  xhemm3m_olcopyr_EXCAVATOR,
  xhemm3m_oucopyi_EXCAVATOR,  xhemm3m_olcopyi_EXCAVATOR,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_EXCAVATOR, xlaswp_ncopy_EXCAVATOR,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_EXCAVATOR,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_EXCAVATOR,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_EXCAVATOR,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_EXCAVATOR,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_EXCAVATOR, somatcopy_k_ct_EXCAVATOR, somatcopy_k_rn_EXCAVATOR, somatcopy_k_rt_EXCAVATOR,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_EXCAVATOR, domatcopy_k_ct_EXCAVATOR, domatcopy_k_rn_EXCAVATOR, domatcopy_k_rt_EXCAVATOR,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_EXCAVATOR, comatcopy_k_ct_EXCAVATOR, comatcopy_k_rn_EXCAVATOR, comatcopy_k_rt_EXCAVATOR,
  comatcopy_k_cnc_EXCAVATOR, comatcopy_k_ctc_EXCAVATOR, comatcopy_k_rnc_EXCAVATOR, comatcopy_k_rtc_EXCAVATOR,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_EXCAVATOR, zomatcopy_k_ct_EXCAVATOR, zomatcopy_k_rn_EXCAVATOR, zomatcopy_k_rt_EXCAVATOR,
  zomatcopy_k_cnc_EXCAVATOR, zomatcopy_k_ctc_EXCAVATOR, zomatcopy_k_rnc_EXCAVATOR, zomatcopy_k_rtc_EXCAVATOR,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_EXCAVATOR, simatcopy_k_ct_EXCAVATOR, simatcopy_k_rn_EXCAVATOR, simatcopy_k_rt_EXCAVATOR,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_EXCAVATOR, dimatcopy_k_ct_EXCAVATOR, dimatcopy_k_rn_EXCAVATOR, dimatcopy_k_rt_EXCAVATOR,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_EXCAVATOR, cimatcopy_k_ct_EXCAVATOR, cimatcopy_k_rn_EXCAVATOR, cimatcopy_k_rt_EXCAVATOR,
  cimatcopy_k_cnc_EXCAVATOR, cimatcopy_k_ctc_EXCAVATOR, cimatcopy_k_rnc_EXCAVATOR, cimatcopy_k_rtc_EXCAVATOR,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_EXCAVATOR, zimatcopy_k_ct_EXCAVATOR, zimatcopy_k_rn_EXCAVATOR, zimatcopy_k_rt_EXCAVATOR,
  zimatcopy_k_cnc_EXCAVATOR, zimatcopy_k_ctc_EXCAVATOR, zimatcopy_k_rnc_EXCAVATOR, zimatcopy_k_rtc_EXCAVATOR,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_EXCAVATOR,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_EXCAVATOR,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_EXCAVATOR,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_EXCAVATOR
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
