/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_COOPERLAKE;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_COOPERLAKE.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_COOPERLAKE, sbdtobf16_k_COOPERLAKE, sbf16tos_k_COOPERLAKE, dbf16tod_k_COOPERLAKE,

  samax_k_COOPERLAKE,  samin_k_COOPERLAKE,  smax_k_COOPERLAKE,  smin_k_COOPERLAKE,
  isamax_k_COOPERLAKE, isamin_k_COOPERLAKE, ismax_k_COOPERLAKE, ismin_k_COOPERLAKE,
  snrm2_k_COOPERLAKE,  sasum_k_COOPERLAKE, ssum_k_COOPERLAKE, scopy_k_COOPERLAKE, sbdot_k_COOPERLAKE,
  dsdot_k_COOPERLAKE,
  srot_k_COOPERLAKE,   saxpy_k_COOPERLAKE,  sscal_k_COOPERLAKE, sswap_k_COOPERLAKE,
  sbgemv_n_COOPERLAKE, sbgemv_t_COOPERLAKE, sger_k_COOPERLAKE,
  ssymv_L_COOPERLAKE, ssymv_U_COOPERLAKE,

  sbgemm_kernel_COOPERLAKE, sbgemm_beta_COOPERLAKE,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_COOPERLAKE, sbgemm_itcopy_COOPERLAKE,
#else
  sbgemm_oncopy_COOPERLAKE, sbgemm_otcopy_COOPERLAKE,
#endif
  sbgemm_oncopy_COOPERLAKE, sbgemm_otcopy_COOPERLAKE,

  strsm_kernel_LN_COOPERLAKE, strsm_kernel_LT_COOPERLAKE, strsm_kernel_RN_COOPERLAKE, strsm_kernel_RT_COOPERLAKE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_COOPERLAKE, strsm_iunncopy_COOPERLAKE, strsm_iutucopy_COOPERLAKE, strsm_iutncopy_COOPERLAKE,
  strsm_ilnucopy_COOPERLAKE, strsm_ilnncopy_COOPERLAKE, strsm_iltucopy_COOPERLAKE, strsm_iltncopy_COOPERLAKE,
#else
  strsm_ounucopy_COOPERLAKE, strsm_ounncopy_COOPERLAKE, strsm_outucopy_COOPERLAKE, strsm_outncopy_COOPERLAKE,
  strsm_olnucopy_COOPERLAKE, strsm_olnncopy_COOPERLAKE, strsm_oltucopy_COOPERLAKE, strsm_oltncopy_COOPERLAKE,
#endif
  strsm_ounucopy_COOPERLAKE, strsm_ounncopy_COOPERLAKE, strsm_outucopy_COOPERLAKE, strsm_outncopy_COOPERLAKE,
  strsm_olnucopy_COOPERLAKE, strsm_olnncopy_COOPERLAKE, strsm_oltucopy_COOPERLAKE, strsm_oltncopy_COOPERLAKE,
  strmm_kernel_RN_COOPERLAKE, strmm_kernel_RT_COOPERLAKE, strmm_kernel_LN_COOPERLAKE, strmm_kernel_LT_COOPERLAKE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_COOPERLAKE, strmm_iunncopy_COOPERLAKE, strmm_iutucopy_COOPERLAKE, strmm_iutncopy_COOPERLAKE,
  strmm_ilnucopy_COOPERLAKE, strmm_ilnncopy_COOPERLAKE, strmm_iltucopy_COOPERLAKE, strmm_iltncopy_COOPERLAKE,
#else
  strmm_ounucopy_COOPERLAKE, strmm_ounncopy_COOPERLAKE, strmm_outucopy_COOPERLAKE, strmm_outncopy_COOPERLAKE,
  strmm_olnucopy_COOPERLAKE, strmm_olnncopy_COOPERLAKE, strmm_oltucopy_COOPERLAKE, strmm_oltncopy_COOPERLAKE,
#endif
  strmm_ounucopy_COOPERLAKE, strmm_ounncopy_COOPERLAKE, strmm_outucopy_COOPERLAKE, strmm_outncopy_COOPERLAKE,
  strmm_olnucopy_COOPERLAKE, strmm_olnncopy_COOPERLAKE, strmm_oltucopy_COOPERLAKE, strmm_oltncopy_COOPERLAKE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_COOPERLAKE, ssymm_iltcopy_COOPERLAKE,
#else
  ssymm_outcopy_COOPERLAKE, ssymm_oltcopy_COOPERLAKE,
#endif
  ssymm_outcopy_COOPERLAKE, ssymm_oltcopy_COOPERLAKE,

#ifndef NO_LAPACK
  sneg_tcopy_COOPERLAKE, slaswp_ncopy_COOPERLAKE,
#else
  NULL,NULL,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_COOPERLAKE,  samin_k_COOPERLAKE,  smax_k_COOPERLAKE,  smin_k_COOPERLAKE,
  isamax_k_COOPERLAKE, isamin_k_COOPERLAKE, ismax_k_COOPERLAKE, ismin_k_COOPERLAKE,
  snrm2_k_COOPERLAKE,  sasum_k_COOPERLAKE,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_COOPERLAKE,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_COOPERLAKE, sdot_k_COOPERLAKE,
//  dsdot_k_COOPERLAKE,
  srot_k_COOPERLAKE,   saxpy_k_COOPERLAKE,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_COOPERLAKE,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_COOPERLAKE,
  sgemv_n_COOPERLAKE,  sgemv_t_COOPERLAKE,
#endif
#if BUILD_SINGLE == 1  
  sger_k_COOPERLAKE,
  ssymv_L_COOPERLAKE, ssymv_U_COOPERLAKE,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_COOPERLAKE,
  sgemm_direct_performant_COOPERLAKE,	
#endif

  sgemm_kernel_COOPERLAKE, sgemm_beta_COOPERLAKE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_COOPERLAKE, sgemm_itcopy_COOPERLAKE,
#else
  sgemm_oncopy_COOPERLAKE, sgemm_otcopy_COOPERLAKE,
#endif
  sgemm_oncopy_COOPERLAKE, sgemm_otcopy_COOPERLAKE,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_COOPERLAKE, strsm_kernel_LT_COOPERLAKE, strsm_kernel_RN_COOPERLAKE, strsm_kernel_RT_COOPERLAKE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_COOPERLAKE, strsm_iunncopy_COOPERLAKE, strsm_iutucopy_COOPERLAKE, strsm_iutncopy_COOPERLAKE,
  strsm_ilnucopy_COOPERLAKE, strsm_ilnncopy_COOPERLAKE, strsm_iltucopy_COOPERLAKE, strsm_iltncopy_COOPERLAKE,
#else
  strsm_ounucopy_COOPERLAKE, strsm_ounncopy_COOPERLAKE, strsm_outucopy_COOPERLAKE, strsm_outncopy_COOPERLAKE,
  strsm_olnucopy_COOPERLAKE, strsm_olnncopy_COOPERLAKE, strsm_oltucopy_COOPERLAKE, strsm_oltncopy_COOPERLAKE,
#endif
  strsm_ounucopy_COOPERLAKE, strsm_ounncopy_COOPERLAKE, strsm_outucopy_COOPERLAKE, strsm_outncopy_COOPERLAKE,
  strsm_olnucopy_COOPERLAKE, strsm_olnncopy_COOPERLAKE, strsm_oltucopy_COOPERLAKE, strsm_oltncopy_COOPERLAKE,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_COOPERLAKE, strmm_kernel_RT_COOPERLAKE, strmm_kernel_LN_COOPERLAKE, strmm_kernel_LT_COOPERLAKE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_COOPERLAKE, strmm_iunncopy_COOPERLAKE, strmm_iutucopy_COOPERLAKE, strmm_iutncopy_COOPERLAKE,
  strmm_ilnucopy_COOPERLAKE, strmm_ilnncopy_COOPERLAKE, strmm_iltucopy_COOPERLAKE, strmm_iltncopy_COOPERLAKE,
#else
  strmm_ounucopy_COOPERLAKE, strmm_ounncopy_COOPERLAKE, strmm_outucopy_COOPERLAKE, strmm_outncopy_COOPERLAKE,
  strmm_olnucopy_COOPERLAKE, strmm_olnncopy_COOPERLAKE, strmm_oltucopy_COOPERLAKE, strmm_oltncopy_COOPERLAKE,
#endif
  strmm_ounucopy_COOPERLAKE, strmm_ounncopy_COOPERLAKE, strmm_outucopy_COOPERLAKE, strmm_outncopy_COOPERLAKE,
  strmm_olnucopy_COOPERLAKE, strmm_olnncopy_COOPERLAKE, strmm_oltucopy_COOPERLAKE, strmm_oltncopy_COOPERLAKE,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_COOPERLAKE, ssymm_iltcopy_COOPERLAKE,
#else
  ssymm_outcopy_COOPERLAKE, ssymm_oltcopy_COOPERLAKE,
#endif
  ssymm_outcopy_COOPERLAKE, ssymm_oltcopy_COOPERLAKE,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_COOPERLAKE, slaswp_ncopy_COOPERLAKE,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_COOPERLAKE,  damin_k_COOPERLAKE,  dmax_k_COOPERLAKE,  dmin_k_COOPERLAKE,
  idamax_k_COOPERLAKE, idamin_k_COOPERLAKE, idmax_k_COOPERLAKE, idmin_k_COOPERLAKE,
  dnrm2_k_COOPERLAKE, dasum_k_COOPERLAKE,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_COOPERLAKE,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_COOPERLAKE, ddot_k_COOPERLAKE,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_COOPERLAKE,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_COOPERLAKE,
  daxpy_k_COOPERLAKE,
  dscal_k_COOPERLAKE, 
  dswap_k_COOPERLAKE,
  dgemv_n_COOPERLAKE,  dgemv_t_COOPERLAKE,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_COOPERLAKE,
  dsymv_L_COOPERLAKE,  dsymv_U_COOPERLAKE,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_COOPERLAKE, dgemm_beta_COOPERLAKE,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_COOPERLAKE, dgemm_itcopy_COOPERLAKE,
#else
  dgemm_oncopy_COOPERLAKE, dgemm_otcopy_COOPERLAKE,
#endif
  dgemm_oncopy_COOPERLAKE, dgemm_otcopy_COOPERLAKE,
#endif

#if  (BUILD_DOUBLE==1)  
  dtrsm_kernel_LN_COOPERLAKE, dtrsm_kernel_LT_COOPERLAKE, dtrsm_kernel_RN_COOPERLAKE, dtrsm_kernel_RT_COOPERLAKE,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_COOPERLAKE, dtrsm_iunncopy_COOPERLAKE, dtrsm_iutucopy_COOPERLAKE, dtrsm_iutncopy_COOPERLAKE,
  dtrsm_ilnucopy_COOPERLAKE, dtrsm_ilnncopy_COOPERLAKE, dtrsm_iltucopy_COOPERLAKE, dtrsm_iltncopy_COOPERLAKE,
#else
  dtrsm_ounucopy_COOPERLAKE, dtrsm_ounncopy_COOPERLAKE, dtrsm_outucopy_COOPERLAKE, dtrsm_outncopy_COOPERLAKE,
  dtrsm_olnucopy_COOPERLAKE, dtrsm_olnncopy_COOPERLAKE, dtrsm_oltucopy_COOPERLAKE, dtrsm_oltncopy_COOPERLAKE,
#endif
  dtrsm_ounucopy_COOPERLAKE, dtrsm_ounncopy_COOPERLAKE, dtrsm_outucopy_COOPERLAKE, dtrsm_outncopy_COOPERLAKE,
  dtrsm_olnucopy_COOPERLAKE, dtrsm_olnncopy_COOPERLAKE, dtrsm_oltucopy_COOPERLAKE, dtrsm_oltncopy_COOPERLAKE,
  dtrmm_kernel_RN_COOPERLAKE, dtrmm_kernel_RT_COOPERLAKE, dtrmm_kernel_LN_COOPERLAKE, dtrmm_kernel_LT_COOPERLAKE,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_COOPERLAKE, dtrmm_iunncopy_COOPERLAKE, dtrmm_iutucopy_COOPERLAKE, dtrmm_iutncopy_COOPERLAKE,
  dtrmm_ilnucopy_COOPERLAKE, dtrmm_ilnncopy_COOPERLAKE, dtrmm_iltucopy_COOPERLAKE, dtrmm_iltncopy_COOPERLAKE,
#else
  dtrmm_ounucopy_COOPERLAKE, dtrmm_ounncopy_COOPERLAKE, dtrmm_outucopy_COOPERLAKE, dtrmm_outncopy_COOPERLAKE,
  dtrmm_olnucopy_COOPERLAKE, dtrmm_olnncopy_COOPERLAKE, dtrmm_oltucopy_COOPERLAKE, dtrmm_oltncopy_COOPERLAKE,
#endif
  dtrmm_ounucopy_COOPERLAKE, dtrmm_ounncopy_COOPERLAKE, dtrmm_outucopy_COOPERLAKE, dtrmm_outncopy_COOPERLAKE,
  dtrmm_olnucopy_COOPERLAKE, dtrmm_olnncopy_COOPERLAKE, dtrmm_oltucopy_COOPERLAKE, dtrmm_oltncopy_COOPERLAKE,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_COOPERLAKE, dsymm_iltcopy_COOPERLAKE,
#else
  dsymm_outcopy_COOPERLAKE, dsymm_oltcopy_COOPERLAKE,
#endif
  dsymm_outcopy_COOPERLAKE, dsymm_oltcopy_COOPERLAKE,

#ifndef NO_LAPACK
  dneg_tcopy_COOPERLAKE, dlaswp_ncopy_COOPERLAKE,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_COOPERLAKE,  qamin_k_COOPERLAKE,  qmax_k_COOPERLAKE,  qmin_k_COOPERLAKE,
  iqamax_k_COOPERLAKE, iqamin_k_COOPERLAKE, iqmax_k_COOPERLAKE, iqmin_k_COOPERLAKE,
  qnrm2_k_COOPERLAKE,  qasum_k_COOPERLAKE,  qsum_k_COOPERLAKE, qcopy_k_COOPERLAKE, qdot_k_COOPERLAKE,
  qrot_k_COOPERLAKE,   qaxpy_k_COOPERLAKE,  qscal_k_COOPERLAKE, qswap_k_COOPERLAKE,
  qgemv_n_COOPERLAKE,  qgemv_t_COOPERLAKE,  qger_k_COOPERLAKE,
  qsymv_L_COOPERLAKE,  qsymv_U_COOPERLAKE,

  qgemm_kernel_COOPERLAKE, qgemm_beta_COOPERLAKE,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_COOPERLAKE, qgemm_itcopy_COOPERLAKE,
#else
  qgemm_oncopy_COOPERLAKE, qgemm_otcopy_COOPERLAKE,
#endif
  qgemm_oncopy_COOPERLAKE, qgemm_otcopy_COOPERLAKE,
  qtrsm_kernel_LN_COOPERLAKE, qtrsm_kernel_LT_COOPERLAKE, qtrsm_kernel_RN_COOPERLAKE, qtrsm_kernel_RT_COOPERLAKE,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_COOPERLAKE, qtrsm_iunncopy_COOPERLAKE, qtrsm_iutucopy_COOPERLAKE, qtrsm_iutncopy_COOPERLAKE,
  qtrsm_ilnucopy_COOPERLAKE, qtrsm_ilnncopy_COOPERLAKE, qtrsm_iltucopy_COOPERLAKE, qtrsm_iltncopy_COOPERLAKE,
#else
  qtrsm_ounucopy_COOPERLAKE, qtrsm_ounncopy_COOPERLAKE, qtrsm_outucopy_COOPERLAKE, qtrsm_outncopy_COOPERLAKE,
  qtrsm_olnucopy_COOPERLAKE, qtrsm_olnncopy_COOPERLAKE, qtrsm_oltucopy_COOPERLAKE, qtrsm_oltncopy_COOPERLAKE,
#endif
  qtrsm_ounucopy_COOPERLAKE, qtrsm_ounncopy_COOPERLAKE, qtrsm_outucopy_COOPERLAKE, qtrsm_outncopy_COOPERLAKE,
  qtrsm_olnucopy_COOPERLAKE, qtrsm_olnncopy_COOPERLAKE, qtrsm_oltucopy_COOPERLAKE, qtrsm_oltncopy_COOPERLAKE,
  qtrmm_kernel_RN_COOPERLAKE, qtrmm_kernel_RT_COOPERLAKE, qtrmm_kernel_LN_COOPERLAKE, qtrmm_kernel_LT_COOPERLAKE,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_COOPERLAKE, qtrmm_iunncopy_COOPERLAKE, qtrmm_iutucopy_COOPERLAKE, qtrmm_iutncopy_COOPERLAKE,
  qtrmm_ilnucopy_COOPERLAKE, qtrmm_ilnncopy_COOPERLAKE, qtrmm_iltucopy_COOPERLAKE, qtrmm_iltncopy_COOPERLAKE,
#else
  qtrmm_ounucopy_COOPERLAKE, qtrmm_ounncopy_COOPERLAKE, qtrmm_outucopy_COOPERLAKE, qtrmm_outncopy_COOPERLAKE,
  qtrmm_olnucopy_COOPERLAKE, qtrmm_olnncopy_COOPERLAKE, qtrmm_oltucopy_COOPERLAKE, qtrmm_oltncopy_COOPERLAKE,
#endif
  qtrmm_ounucopy_COOPERLAKE, qtrmm_ounncopy_COOPERLAKE, qtrmm_outucopy_COOPERLAKE, qtrmm_outncopy_COOPERLAKE,
  qtrmm_olnucopy_COOPERLAKE, qtrmm_olnncopy_COOPERLAKE, qtrmm_oltucopy_COOPERLAKE, qtrmm_oltncopy_COOPERLAKE,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_COOPERLAKE, qsymm_iltcopy_COOPERLAKE,
#else
  qsymm_outcopy_COOPERLAKE, qsymm_oltcopy_COOPERLAKE,
#endif
  qsymm_outcopy_COOPERLAKE, qsymm_oltcopy_COOPERLAKE,

#ifndef NO_LAPACK
  qneg_tcopy_COOPERLAKE, qlaswp_ncopy_COOPERLAKE,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_COOPERLAKE, camin_k_COOPERLAKE, icamax_k_COOPERLAKE, icamin_k_COOPERLAKE,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_COOPERLAKE, casum_k_COOPERLAKE, csum_k_COOPERLAKE,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_COOPERLAKE,  cdotu_k_COOPERLAKE, cdotc_k_COOPERLAKE,
#endif
#if (BUILD_COMPLEX)
 csrot_k_COOPERLAKE,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_COOPERLAKE,
  caxpyc_k_COOPERLAKE, 
  cscal_k_COOPERLAKE, 
  cswap_k_COOPERLAKE,

  cgemv_n_COOPERLAKE, cgemv_t_COOPERLAKE, cgemv_r_COOPERLAKE, cgemv_c_COOPERLAKE,
  cgemv_o_COOPERLAKE, cgemv_u_COOPERLAKE, cgemv_s_COOPERLAKE, cgemv_d_COOPERLAKE,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_COOPERLAKE, cgerc_k_COOPERLAKE, cgerv_k_COOPERLAKE, cgerd_k_COOPERLAKE,
  csymv_L_COOPERLAKE, csymv_U_COOPERLAKE,
  chemv_L_COOPERLAKE, chemv_U_COOPERLAKE, chemv_M_COOPERLAKE, chemv_V_COOPERLAKE,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_COOPERLAKE, cgemm_kernel_l_COOPERLAKE, cgemm_kernel_r_COOPERLAKE, cgemm_kernel_b_COOPERLAKE,
  cgemm_beta_COOPERLAKE,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_COOPERLAKE, cgemm_itcopy_COOPERLAKE,
#else
  cgemm_oncopy_COOPERLAKE, cgemm_otcopy_COOPERLAKE,
#endif
  cgemm_oncopy_COOPERLAKE, cgemm_otcopy_COOPERLAKE,

  ctrsm_kernel_LN_COOPERLAKE, ctrsm_kernel_LT_COOPERLAKE, ctrsm_kernel_LR_COOPERLAKE, ctrsm_kernel_LC_COOPERLAKE,
  ctrsm_kernel_RN_COOPERLAKE, ctrsm_kernel_RT_COOPERLAKE, ctrsm_kernel_RR_COOPERLAKE, ctrsm_kernel_RC_COOPERLAKE,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_COOPERLAKE,  ctrsm_iunncopy_COOPERLAKE,  ctrsm_iutucopy_COOPERLAKE,  ctrsm_iutncopy_COOPERLAKE,
  ctrsm_ilnucopy_COOPERLAKE,  ctrsm_ilnncopy_COOPERLAKE,  ctrsm_iltucopy_COOPERLAKE,  ctrsm_iltncopy_COOPERLAKE,
#else
  ctrsm_ounucopy_COOPERLAKE,  ctrsm_ounncopy_COOPERLAKE,  ctrsm_outucopy_COOPERLAKE,  ctrsm_outncopy_COOPERLAKE,
  ctrsm_olnucopy_COOPERLAKE,  ctrsm_olnncopy_COOPERLAKE,  ctrsm_oltucopy_COOPERLAKE,  ctrsm_oltncopy_COOPERLAKE,
#endif
  ctrsm_ounucopy_COOPERLAKE,  ctrsm_ounncopy_COOPERLAKE,  ctrsm_outucopy_COOPERLAKE,  ctrsm_outncopy_COOPERLAKE,
  ctrsm_olnucopy_COOPERLAKE,  ctrsm_olnncopy_COOPERLAKE,  ctrsm_oltucopy_COOPERLAKE,  ctrsm_oltncopy_COOPERLAKE,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_COOPERLAKE,  ctrmm_kernel_RT_COOPERLAKE,  ctrmm_kernel_RR_COOPERLAKE,  ctrmm_kernel_RC_COOPERLAKE,
  ctrmm_kernel_LN_COOPERLAKE,  ctrmm_kernel_LT_COOPERLAKE,  ctrmm_kernel_LR_COOPERLAKE,  ctrmm_kernel_LC_COOPERLAKE,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_COOPERLAKE,  ctrmm_iunncopy_COOPERLAKE,  ctrmm_iutucopy_COOPERLAKE,  ctrmm_iutncopy_COOPERLAKE,
  ctrmm_ilnucopy_COOPERLAKE,  ctrmm_ilnncopy_COOPERLAKE,  ctrmm_iltucopy_COOPERLAKE,  ctrmm_iltncopy_COOPERLAKE,
#else
  ctrmm_ounucopy_COOPERLAKE,  ctrmm_ounncopy_COOPERLAKE,  ctrmm_outucopy_COOPERLAKE,  ctrmm_outncopy_COOPERLAKE,
  ctrmm_olnucopy_COOPERLAKE,  ctrmm_olnncopy_COOPERLAKE,  ctrmm_oltucopy_COOPERLAKE,  ctrmm_oltncopy_COOPERLAKE,
#endif
  ctrmm_ounucopy_COOPERLAKE,  ctrmm_ounncopy_COOPERLAKE,  ctrmm_outucopy_COOPERLAKE,  ctrmm_outncopy_COOPERLAKE,
  ctrmm_olnucopy_COOPERLAKE,  ctrmm_olnncopy_COOPERLAKE,  ctrmm_oltucopy_COOPERLAKE,  ctrmm_oltncopy_COOPERLAKE,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_COOPERLAKE,  csymm_iltcopy_COOPERLAKE,
#else
  csymm_outcopy_COOPERLAKE,  csymm_oltcopy_COOPERLAKE,
#endif
  csymm_outcopy_COOPERLAKE,  csymm_oltcopy_COOPERLAKE,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_COOPERLAKE,  chemm_iltcopy_COOPERLAKE,
#else
  chemm_outcopy_COOPERLAKE,  chemm_oltcopy_COOPERLAKE,
#endif
  chemm_outcopy_COOPERLAKE,  chemm_oltcopy_COOPERLAKE,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_COOPERLAKE,

  cgemm3m_incopyb_COOPERLAKE,  cgemm3m_incopyr_COOPERLAKE,
  cgemm3m_incopyi_COOPERLAKE,  cgemm3m_itcopyb_COOPERLAKE,
  cgemm3m_itcopyr_COOPERLAKE,  cgemm3m_itcopyi_COOPERLAKE,
  cgemm3m_oncopyb_COOPERLAKE,  cgemm3m_oncopyr_COOPERLAKE,
  cgemm3m_oncopyi_COOPERLAKE,  cgemm3m_otcopyb_COOPERLAKE,
  cgemm3m_otcopyr_COOPERLAKE,  cgemm3m_otcopyi_COOPERLAKE,

  csymm3m_iucopyb_COOPERLAKE,  csymm3m_ilcopyb_COOPERLAKE,
  csymm3m_iucopyr_COOPERLAKE,  csymm3m_ilcopyr_COOPERLAKE,
  csymm3m_iucopyi_COOPERLAKE,  csymm3m_ilcopyi_COOPERLAKE,
  csymm3m_oucopyb_COOPERLAKE,  csymm3m_olcopyb_COOPERLAKE,
  csymm3m_oucopyr_COOPERLAKE,  csymm3m_olcopyr_COOPERLAKE,
  csymm3m_oucopyi_COOPERLAKE,  csymm3m_olcopyi_COOPERLAKE,

  chemm3m_iucopyb_COOPERLAKE,  chemm3m_ilcopyb_COOPERLAKE,
  chemm3m_iucopyr_COOPERLAKE,  chemm3m_ilcopyr_COOPERLAKE,
  chemm3m_iucopyi_COOPERLAKE,  chemm3m_ilcopyi_COOPERLAKE,

  chemm3m_oucopyb_COOPERLAKE,  chemm3m_olcopyb_COOPERLAKE,
  chemm3m_oucopyr_COOPERLAKE,  chemm3m_olcopyr_COOPERLAKE,
  chemm3m_oucopyi_COOPERLAKE,  chemm3m_olcopyi_COOPERLAKE,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_COOPERLAKE,
  
   claswp_ncopy_COOPERLAKE,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_COOPERLAKE, zamin_k_COOPERLAKE, izamax_k_COOPERLAKE, izamin_k_COOPERLAKE,
  znrm2_k_COOPERLAKE, zasum_k_COOPERLAKE, zsum_k_COOPERLAKE, zcopy_k_COOPERLAKE,
  zdotu_k_COOPERLAKE, zdotc_k_COOPERLAKE, zdrot_k_COOPERLAKE,
  zaxpy_k_COOPERLAKE, zaxpyc_k_COOPERLAKE, zscal_k_COOPERLAKE, zswap_k_COOPERLAKE,

  zgemv_n_COOPERLAKE, zgemv_t_COOPERLAKE, zgemv_r_COOPERLAKE, zgemv_c_COOPERLAKE,
  zgemv_o_COOPERLAKE, zgemv_u_COOPERLAKE, zgemv_s_COOPERLAKE, zgemv_d_COOPERLAKE,
  zgeru_k_COOPERLAKE, zgerc_k_COOPERLAKE, zgerv_k_COOPERLAKE, zgerd_k_COOPERLAKE,
  zsymv_L_COOPERLAKE, zsymv_U_COOPERLAKE,
  zhemv_L_COOPERLAKE, zhemv_U_COOPERLAKE, zhemv_M_COOPERLAKE, zhemv_V_COOPERLAKE,

  zgemm_kernel_n_COOPERLAKE, zgemm_kernel_l_COOPERLAKE, zgemm_kernel_r_COOPERLAKE, zgemm_kernel_b_COOPERLAKE,
  zgemm_beta_COOPERLAKE,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_COOPERLAKE, zgemm_itcopy_COOPERLAKE,
#else
  zgemm_oncopy_COOPERLAKE, zgemm_otcopy_COOPERLAKE,
#endif
  zgemm_oncopy_COOPERLAKE, zgemm_otcopy_COOPERLAKE,

  ztrsm_kernel_LN_COOPERLAKE, ztrsm_kernel_LT_COOPERLAKE, ztrsm_kernel_LR_COOPERLAKE, ztrsm_kernel_LC_COOPERLAKE,
  ztrsm_kernel_RN_COOPERLAKE, ztrsm_kernel_RT_COOPERLAKE, ztrsm_kernel_RR_COOPERLAKE, ztrsm_kernel_RC_COOPERLAKE,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_COOPERLAKE,  ztrsm_iunncopy_COOPERLAKE,  ztrsm_iutucopy_COOPERLAKE,  ztrsm_iutncopy_COOPERLAKE,
  ztrsm_ilnucopy_COOPERLAKE,  ztrsm_ilnncopy_COOPERLAKE,  ztrsm_iltucopy_COOPERLAKE,  ztrsm_iltncopy_COOPERLAKE,
#else
  ztrsm_ounucopy_COOPERLAKE,  ztrsm_ounncopy_COOPERLAKE,  ztrsm_outucopy_COOPERLAKE,  ztrsm_outncopy_COOPERLAKE,
  ztrsm_olnucopy_COOPERLAKE,  ztrsm_olnncopy_COOPERLAKE,  ztrsm_oltucopy_COOPERLAKE,  ztrsm_oltncopy_COOPERLAKE,
#endif
  ztrsm_ounucopy_COOPERLAKE,  ztrsm_ounncopy_COOPERLAKE,  ztrsm_outucopy_COOPERLAKE,  ztrsm_outncopy_COOPERLAKE,
  ztrsm_olnucopy_COOPERLAKE,  ztrsm_olnncopy_COOPERLAKE,  ztrsm_oltucopy_COOPERLAKE,  ztrsm_oltncopy_COOPERLAKE,

  ztrmm_kernel_RN_COOPERLAKE,  ztrmm_kernel_RT_COOPERLAKE,  ztrmm_kernel_RR_COOPERLAKE,  ztrmm_kernel_RC_COOPERLAKE,
  ztrmm_kernel_LN_COOPERLAKE,  ztrmm_kernel_LT_COOPERLAKE,  ztrmm_kernel_LR_COOPERLAKE,  ztrmm_kernel_LC_COOPERLAKE,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_COOPERLAKE,  ztrmm_iunncopy_COOPERLAKE,  ztrmm_iutucopy_COOPERLAKE,  ztrmm_iutncopy_COOPERLAKE,
  ztrmm_ilnucopy_COOPERLAKE,  ztrmm_ilnncopy_COOPERLAKE,  ztrmm_iltucopy_COOPERLAKE,  ztrmm_iltncopy_COOPERLAKE,
#else
  ztrmm_ounucopy_COOPERLAKE,  ztrmm_ounncopy_COOPERLAKE,  ztrmm_outucopy_COOPERLAKE,  ztrmm_outncopy_COOPERLAKE,
  ztrmm_olnucopy_COOPERLAKE,  ztrmm_olnncopy_COOPERLAKE,  ztrmm_oltucopy_COOPERLAKE,  ztrmm_oltncopy_COOPERLAKE,
#endif
  ztrmm_ounucopy_COOPERLAKE,  ztrmm_ounncopy_COOPERLAKE,  ztrmm_outucopy_COOPERLAKE,  ztrmm_outncopy_COOPERLAKE,
  ztrmm_olnucopy_COOPERLAKE,  ztrmm_olnncopy_COOPERLAKE,  ztrmm_oltucopy_COOPERLAKE,  ztrmm_oltncopy_COOPERLAKE,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_COOPERLAKE,  zsymm_iltcopy_COOPERLAKE,
#else
  zsymm_outcopy_COOPERLAKE,  zsymm_oltcopy_COOPERLAKE,
#endif
  zsymm_outcopy_COOPERLAKE,  zsymm_oltcopy_COOPERLAKE,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_COOPERLAKE,  zhemm_iltcopy_COOPERLAKE,
#else
  zhemm_outcopy_COOPERLAKE,  zhemm_oltcopy_COOPERLAKE,
#endif
  zhemm_outcopy_COOPERLAKE,  zhemm_oltcopy_COOPERLAKE,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_COOPERLAKE,

  zgemm3m_incopyb_COOPERLAKE,  zgemm3m_incopyr_COOPERLAKE,
  zgemm3m_incopyi_COOPERLAKE,  zgemm3m_itcopyb_COOPERLAKE,
  zgemm3m_itcopyr_COOPERLAKE,  zgemm3m_itcopyi_COOPERLAKE,
  zgemm3m_oncopyb_COOPERLAKE,  zgemm3m_oncopyr_COOPERLAKE,
  zgemm3m_oncopyi_COOPERLAKE,  zgemm3m_otcopyb_COOPERLAKE,
  zgemm3m_otcopyr_COOPERLAKE,  zgemm3m_otcopyi_COOPERLAKE,

  zsymm3m_iucopyb_COOPERLAKE,  zsymm3m_ilcopyb_COOPERLAKE,
  zsymm3m_iucopyr_COOPERLAKE,  zsymm3m_ilcopyr_COOPERLAKE,
  zsymm3m_iucopyi_COOPERLAKE,  zsymm3m_ilcopyi_COOPERLAKE,
  zsymm3m_oucopyb_COOPERLAKE,  zsymm3m_olcopyb_COOPERLAKE,
  zsymm3m_oucopyr_COOPERLAKE,  zsymm3m_olcopyr_COOPERLAKE,
  zsymm3m_oucopyi_COOPERLAKE,  zsymm3m_olcopyi_COOPERLAKE,

  zhemm3m_iucopyb_COOPERLAKE,  zhemm3m_ilcopyb_COOPERLAKE,
  zhemm3m_iucopyr_COOPERLAKE,  zhemm3m_ilcopyr_COOPERLAKE,
  zhemm3m_iucopyi_COOPERLAKE,  zhemm3m_ilcopyi_COOPERLAKE,

  zhemm3m_oucopyb_COOPERLAKE,  zhemm3m_olcopyb_COOPERLAKE,
  zhemm3m_oucopyr_COOPERLAKE,  zhemm3m_olcopyr_COOPERLAKE,
  zhemm3m_oucopyi_COOPERLAKE,  zhemm3m_olcopyi_COOPERLAKE,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_COOPERLAKE, zlaswp_ncopy_COOPERLAKE,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_COOPERLAKE, xamin_k_COOPERLAKE, ixamax_k_COOPERLAKE, ixamin_k_COOPERLAKE,
  xnrm2_k_COOPERLAKE, xasum_k_COOPERLAKE, xsum_k_COOPERLAKE, xcopy_k_COOPERLAKE,
  xdotu_k_COOPERLAKE, xdotc_k_COOPERLAKE, xqrot_k_COOPERLAKE,
  xaxpy_k_COOPERLAKE, xaxpyc_k_COOPERLAKE, xscal_k_COOPERLAKE, xswap_k_COOPERLAKE,

  xgemv_n_COOPERLAKE, xgemv_t_COOPERLAKE, xgemv_r_COOPERLAKE, xgemv_c_COOPERLAKE,
  xgemv_o_COOPERLAKE, xgemv_u_COOPERLAKE, xgemv_s_COOPERLAKE, xgemv_d_COOPERLAKE,
  xgeru_k_COOPERLAKE, xgerc_k_COOPERLAKE, xgerv_k_COOPERLAKE, xgerd_k_COOPERLAKE,
  xsymv_L_COOPERLAKE, xsymv_U_COOPERLAKE,
  xhemv_L_COOPERLAKE, xhemv_U_COOPERLAKE, xhemv_M_COOPERLAKE, xhemv_V_COOPERLAKE,

  xgemm_kernel_n_COOPERLAKE, xgemm_kernel_l_COOPERLAKE, xgemm_kernel_r_COOPERLAKE, xgemm_kernel_b_COOPERLAKE,
  xgemm_beta_COOPERLAKE,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_COOPERLAKE, xgemm_itcopy_COOPERLAKE,
#else
  xgemm_oncopy_COOPERLAKE, xgemm_otcopy_COOPERLAKE,
#endif
  xgemm_oncopy_COOPERLAKE, xgemm_otcopy_COOPERLAKE,

  xtrsm_kernel_LN_COOPERLAKE, xtrsm_kernel_LT_COOPERLAKE, xtrsm_kernel_LR_COOPERLAKE, xtrsm_kernel_LC_COOPERLAKE,
  xtrsm_kernel_RN_COOPERLAKE, xtrsm_kernel_RT_COOPERLAKE, xtrsm_kernel_RR_COOPERLAKE, xtrsm_kernel_RC_COOPERLAKE,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_COOPERLAKE,  xtrsm_iunncopy_COOPERLAKE,  xtrsm_iutucopy_COOPERLAKE,  xtrsm_iutncopy_COOPERLAKE,
  xtrsm_ilnucopy_COOPERLAKE,  xtrsm_ilnncopy_COOPERLAKE,  xtrsm_iltucopy_COOPERLAKE,  xtrsm_iltncopy_COOPERLAKE,
#else
  xtrsm_ounucopy_COOPERLAKE,  xtrsm_ounncopy_COOPERLAKE,  xtrsm_outucopy_COOPERLAKE,  xtrsm_outncopy_COOPERLAKE,
  xtrsm_olnucopy_COOPERLAKE,  xtrsm_olnncopy_COOPERLAKE,  xtrsm_oltucopy_COOPERLAKE,  xtrsm_oltncopy_COOPERLAKE,
#endif
  xtrsm_ounucopy_COOPERLAKE,  xtrsm_ounncopy_COOPERLAKE,  xtrsm_outucopy_COOPERLAKE,  xtrsm_outncopy_COOPERLAKE,
  xtrsm_olnucopy_COOPERLAKE,  xtrsm_olnncopy_COOPERLAKE,  xtrsm_oltucopy_COOPERLAKE,  xtrsm_oltncopy_COOPERLAKE,

  xtrmm_kernel_RN_COOPERLAKE,  xtrmm_kernel_RT_COOPERLAKE,  xtrmm_kernel_RR_COOPERLAKE,  xtrmm_kernel_RC_COOPERLAKE,
  xtrmm_kernel_LN_COOPERLAKE,  xtrmm_kernel_LT_COOPERLAKE,  xtrmm_kernel_LR_COOPERLAKE,  xtrmm_kernel_LC_COOPERLAKE,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_COOPERLAKE,  xtrmm_iunncopy_COOPERLAKE,  xtrmm_iutucopy_COOPERLAKE,  xtrmm_iutncopy_COOPERLAKE,
  xtrmm_ilnucopy_COOPERLAKE,  xtrmm_ilnncopy_COOPERLAKE,  xtrmm_iltucopy_COOPERLAKE,  xtrmm_iltncopy_COOPERLAKE,
#else
  xtrmm_ounucopy_COOPERLAKE,  xtrmm_ounncopy_COOPERLAKE,  xtrmm_outucopy_COOPERLAKE,  xtrmm_outncopy_COOPERLAKE,
  xtrmm_olnucopy_COOPERLAKE,  xtrmm_olnncopy_COOPERLAKE,  xtrmm_oltucopy_COOPERLAKE,  xtrmm_oltncopy_COOPERLAKE,
#endif
  xtrmm_ounucopy_COOPERLAKE,  xtrmm_ounncopy_COOPERLAKE,  xtrmm_outucopy_COOPERLAKE,  xtrmm_outncopy_COOPERLAKE,
  xtrmm_olnucopy_COOPERLAKE,  xtrmm_olnncopy_COOPERLAKE,  xtrmm_oltucopy_COOPERLAKE,  xtrmm_oltncopy_COOPERLAKE,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_COOPERLAKE,  xsymm_iltcopy_COOPERLAKE,
#else
  xsymm_outcopy_COOPERLAKE,  xsymm_oltcopy_COOPERLAKE,
#endif
  xsymm_outcopy_COOPERLAKE,  xsymm_oltcopy_COOPERLAKE,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_COOPERLAKE,  xhemm_iltcopy_COOPERLAKE,
#else
  xhemm_outcopy_COOPERLAKE,  xhemm_oltcopy_COOPERLAKE,
#endif
  xhemm_outcopy_COOPERLAKE,  xhemm_oltcopy_COOPERLAKE,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_COOPERLAKE,

  xgemm3m_incopyb_COOPERLAKE,  xgemm3m_incopyr_COOPERLAKE,
  xgemm3m_incopyi_COOPERLAKE,  xgemm3m_itcopyb_COOPERLAKE,
  xgemm3m_itcopyr_COOPERLAKE,  xgemm3m_itcopyi_COOPERLAKE,
  xgemm3m_oncopyb_COOPERLAKE,  xgemm3m_oncopyr_COOPERLAKE,
  xgemm3m_oncopyi_COOPERLAKE,  xgemm3m_otcopyb_COOPERLAKE,
  xgemm3m_otcopyr_COOPERLAKE,  xgemm3m_otcopyi_COOPERLAKE,

  xsymm3m_iucopyb_COOPERLAKE,  xsymm3m_ilcopyb_COOPERLAKE,
  xsymm3m_iucopyr_COOPERLAKE,  xsymm3m_ilcopyr_COOPERLAKE,
  xsymm3m_iucopyi_COOPERLAKE,  xsymm3m_ilcopyi_COOPERLAKE,
  xsymm3m_oucopyb_COOPERLAKE,  xsymm3m_olcopyb_COOPERLAKE,
  xsymm3m_oucopyr_COOPERLAKE,  xsymm3m_olcopyr_COOPERLAKE,
  xsymm3m_oucopyi_COOPERLAKE,  xsymm3m_olcopyi_COOPERLAKE,

  xhemm3m_iucopyb_COOPERLAKE,  xhemm3m_ilcopyb_COOPERLAKE,
  xhemm3m_iucopyr_COOPERLAKE,  xhemm3m_ilcopyr_COOPERLAKE,
  xhemm3m_iucopyi_COOPERLAKE,  xhemm3m_ilcopyi_COOPERLAKE,

  xhemm3m_oucopyb_COOPERLAKE,  xhemm3m_olcopyb_COOPERLAKE,
  xhemm3m_oucopyr_COOPERLAKE,  xhemm3m_olcopyr_COOPERLAKE,
  xhemm3m_oucopyi_COOPERLAKE,  xhemm3m_olcopyi_COOPERLAKE,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_COOPERLAKE, xlaswp_ncopy_COOPERLAKE,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_COOPERLAKE,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_COOPERLAKE,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_COOPERLAKE,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_COOPERLAKE,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_COOPERLAKE, somatcopy_k_ct_COOPERLAKE, somatcopy_k_rn_COOPERLAKE, somatcopy_k_rt_COOPERLAKE,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_COOPERLAKE, domatcopy_k_ct_COOPERLAKE, domatcopy_k_rn_COOPERLAKE, domatcopy_k_rt_COOPERLAKE,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_COOPERLAKE, comatcopy_k_ct_COOPERLAKE, comatcopy_k_rn_COOPERLAKE, comatcopy_k_rt_COOPERLAKE,
  comatcopy_k_cnc_COOPERLAKE, comatcopy_k_ctc_COOPERLAKE, comatcopy_k_rnc_COOPERLAKE, comatcopy_k_rtc_COOPERLAKE,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_COOPERLAKE, zomatcopy_k_ct_COOPERLAKE, zomatcopy_k_rn_COOPERLAKE, zomatcopy_k_rt_COOPERLAKE,
  zomatcopy_k_cnc_COOPERLAKE, zomatcopy_k_ctc_COOPERLAKE, zomatcopy_k_rnc_COOPERLAKE, zomatcopy_k_rtc_COOPERLAKE,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_COOPERLAKE, simatcopy_k_ct_COOPERLAKE, simatcopy_k_rn_COOPERLAKE, simatcopy_k_rt_COOPERLAKE,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_COOPERLAKE, dimatcopy_k_ct_COOPERLAKE, dimatcopy_k_rn_COOPERLAKE, dimatcopy_k_rt_COOPERLAKE,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_COOPERLAKE, cimatcopy_k_ct_COOPERLAKE, cimatcopy_k_rn_COOPERLAKE, cimatcopy_k_rt_COOPERLAKE,
  cimatcopy_k_cnc_COOPERLAKE, cimatcopy_k_ctc_COOPERLAKE, cimatcopy_k_rnc_COOPERLAKE, cimatcopy_k_rtc_COOPERLAKE,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_COOPERLAKE, zimatcopy_k_ct_COOPERLAKE, zimatcopy_k_rn_COOPERLAKE, zimatcopy_k_rt_COOPERLAKE,
  zimatcopy_k_cnc_COOPERLAKE, zimatcopy_k_ctc_COOPERLAKE, zimatcopy_k_rnc_COOPERLAKE, zimatcopy_k_rtc_COOPERLAKE,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_COOPERLAKE,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_COOPERLAKE,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_COOPERLAKE,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_COOPERLAKE
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
