; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=sparcv9 | FileCheck %s -check-prefix=V9
; RUN: llc < %s -mtriple=sparcv9 -mattr=+vis3 | FileCheck %s -check-prefix=VIS3

define i128 @signed_multiply_extend(i64 %0, i64 %1) nounwind {
; V9-LABEL: signed_multiply_extend:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -176, %sp
; V9-NEXT:    mov %i1, %o1
; V9-NEXT:    mov %i0, %o3
; V9-NEXT:    srax %i0, 63, %o2
; V9-NEXT:    call __multi3
; V9-NEXT:    srax %i1, 63, %o0
; V9-NEXT:    mov %o0, %i0
; V9-NEXT:    ret
; V9-NEXT:    restore %g0, %o1, %o1
;
; VIS3-LABEL: signed_multiply_extend:
; VIS3:       ! %bb.0:
; VIS3-NEXT:    srax %o0, 63, %o2
; VIS3-NEXT:    and %o2, %o1, %o2
; VIS3-NEXT:    srax %o1, 63, %o3
; VIS3-NEXT:    and %o3, %o0, %o3
; VIS3-NEXT:    add %o3, %o2, %o2
; VIS3-NEXT:    umulxhi %o1, %o0, %o3
; VIS3-NEXT:    sub %o3, %o2, %o2
; VIS3-NEXT:    mulx %o1, %o0, %o1
; VIS3-NEXT:    retl
; VIS3-NEXT:    mov %o2, %o0
  %3 = sext i64 %0 to i128
  %4 = sext i64 %1 to i128
  %5 = mul nsw i128 %4, %3
  ret i128 %5
}

define i128 @unsigned_multiply_extend(i64 %0, i64 %1) nounwind {
; V9-LABEL: unsigned_multiply_extend:
; V9:       ! %bb.0:
; V9-NEXT:    save %sp, -176, %sp
; V9-NEXT:    mov %i1, %o1
; V9-NEXT:    mov %i0, %o3
; V9-NEXT:    mov %g0, %o0
; V9-NEXT:    call __multi3
; V9-NEXT:    mov %g0, %o2
; V9-NEXT:    mov %o0, %i0
; V9-NEXT:    ret
; V9-NEXT:    restore %g0, %o1, %o1
;
; VIS3-LABEL: unsigned_multiply_extend:
; VIS3:       ! %bb.0:
; VIS3-NEXT:    umulxhi %o1, %o0, %o2
; VIS3-NEXT:    mulx %o1, %o0, %o1
; VIS3-NEXT:    retl
; VIS3-NEXT:    mov %o2, %o0
  %3 = zext i64 %0 to i128
  %4 = zext i64 %1 to i128
  %5 = mul nuw i128 %4, %3
  ret i128 %5
}
