; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

;------------------------------------------------------------------------------;
; Scalar tests
;------------------------------------------------------------------------------;

define i1 @umin_scalar(i1 %0, i1 %1) {
; CHECK-LABEL: define i1 @umin_scalar
; CHECK-SAME: (i1 [[TMP0:%.*]], i1 [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[TMP3]]
;
  %3 = call i1 @llvm.umin.i1(i1 %0, i1 %1)
  ret i1 %3
}

define i1 @smin_scalar(i1 %0, i1 %1) {
; CHECK-LABEL: define i1 @smin_scalar
; CHECK-SAME: (i1 [[TMP0:%.*]], i1 [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP3:%.*]] = or i1 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[TMP3]]
;
  %3 = call i1 @llvm.smin.i1(i1 %0, i1 %1)
  ret i1 %3
}

define i1 @umax_scalar(i1 %0, i1 %1) {
; CHECK-LABEL: define i1 @umax_scalar
; CHECK-SAME: (i1 [[TMP0:%.*]], i1 [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP3:%.*]] = or i1 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[TMP3]]
;
  %3 = call i1 @llvm.umax.i1(i1 %0, i1 %1)
  ret i1 %3
}

define i1 @smax_scalar(i1 %0, i1 %1) {
; CHECK-LABEL: define i1 @smax_scalar
; CHECK-SAME: (i1 [[TMP0:%.*]], i1 [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP3:%.*]] = and i1 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[TMP3]]
;
  %3 = call i1 @llvm.smax.i1(i1 %0, i1 %1)
  ret i1 %3
}

;------------------------------------------------------------------------------;
; Vector tests
;------------------------------------------------------------------------------;

define <4 x i1> @umin_vector(<4 x i1> %0, <4 x i1> %1) {
; CHECK-LABEL: define <4 x i1> @umin_vector
; CHECK-SAME: (<4 x i1> [[TMP0:%.*]], <4 x i1> [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP3:%.*]] = and <4 x i1> [[TMP0]], [[TMP1]]
; CHECK-NEXT:    ret <4 x i1> [[TMP3]]
;
  %3 = call <4 x i1> @llvm.umin.v4i1(<4 x i1> %0, <4 x i1> %1)
  ret <4 x i1> %3
}

define <4 x i1> @smin_vector(<4 x i1> %0, <4 x i1> %1) {
; CHECK-LABEL: define <4 x i1> @smin_vector
; CHECK-SAME: (<4 x i1> [[TMP0:%.*]], <4 x i1> [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP3:%.*]] = or <4 x i1> [[TMP0]], [[TMP1]]
; CHECK-NEXT:    ret <4 x i1> [[TMP3]]
;
  %3 = call <4 x i1> @llvm.smin.v4i1(<4 x i1> %0, <4 x i1> %1)
  ret <4 x i1> %3
}

define <4 x i1> @umax_vector(<4 x i1> %0, <4 x i1> %1) {
; CHECK-LABEL: define <4 x i1> @umax_vector
; CHECK-SAME: (<4 x i1> [[TMP0:%.*]], <4 x i1> [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP3:%.*]] = or <4 x i1> [[TMP0]], [[TMP1]]
; CHECK-NEXT:    ret <4 x i1> [[TMP3]]
;
  %3 = call <4 x i1> @llvm.umax.v4i1(<4 x i1> %0, <4 x i1> %1)
  ret <4 x i1> %3
}

define <4 x i1> @smax_vector(<4 x i1> %0, <4 x i1> %1) {
; CHECK-LABEL: define <4 x i1> @smax_vector
; CHECK-SAME: (<4 x i1> [[TMP0:%.*]], <4 x i1> [[TMP1:%.*]]) {
; CHECK-NEXT:    [[TMP3:%.*]] = and <4 x i1> [[TMP0]], [[TMP1]]
; CHECK-NEXT:    ret <4 x i1> [[TMP3]]
;
  %3 = call <4 x i1> @llvm.smax.v4i1(<4 x i1> %0, <4 x i1> %1)
  ret <4 x i1> %3
}

declare i1 @llvm.umin.i1(i1, i1)
declare i1 @llvm.smin.i1(i1, i1)
declare i1 @llvm.umax.i1(i1, i1)
declare i1 @llvm.smax.i1(i1, i1)
declare <4 x i1> @llvm.umin.v4i1(<4 x i1>, <4 x i1>)
declare <4 x i1> @llvm.smin.v4i1(<4 x i1>, <4 x i1>)
declare <4 x i1> @llvm.umax.v4i1(<4 x i1>, <4 x i1>)
declare <4 x i1> @llvm.smax.v4i1(<4 x i1>, <4 x i1>)
