; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFH
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfhmin,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfhmin,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN

declare <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>)

define <vscale x 1 x float> @vfwmacc_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x half> %vb, <vscale x 1 x half> %vc) {
; ZVFH-LABEL: vfwmacc_vv_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwmacc.vv v8, v9, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmacc_vv_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v11, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmacc.vv v8, v11, v9
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 1 x half> %vb to <vscale x 1 x float>
  %ve = fpext <vscale x 1 x half> %vc to <vscale x 1 x float>
  %vf = call <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float> %vd, <vscale x 1 x float> %ve, <vscale x 1 x float> %va)
  ret <vscale x 1 x float> %vf
}

define <vscale x 1 x float> @vfwmacc_vf_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x half> %vb, half %c) {
; ZVFH-LABEL: vfwmacc_vf_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwmacc.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmacc_vf_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmacc.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x half> %vb to <vscale x 1 x float>
  %ve = fpext <vscale x 1 x half> %splat to <vscale x 1 x float>
  %vf = call <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float> %vd, <vscale x 1 x float> %ve, <vscale x 1 x float> %va)
  ret <vscale x 1 x float> %vf
}

define <vscale x 1 x float> @vfwnmacc_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x half> %vb, <vscale x 1 x half> %vc) {
; ZVFH-LABEL: vfwnmacc_vv_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwnmacc.vv v8, v9, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_vv_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v11, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vv v8, v11, v9
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 1 x half> %vb to <vscale x 1 x float>
  %ve = fpext <vscale x 1 x half> %vc to <vscale x 1 x float>
  %vf = fneg <vscale x 1 x float> %va
  %vg = fneg <vscale x 1 x float> %vd
  %vh = call <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float> %vg, <vscale x 1 x float> %ve, <vscale x 1 x float> %vf)
  ret <vscale x 1 x float> %vh
}

define <vscale x 1 x float> @vfwnmacc_vf_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmacc_vf_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwnmacc.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_vf_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x half> %vb to <vscale x 1 x float>
  %ve = fpext <vscale x 1 x half> %splat to <vscale x 1 x float>
  %vf = fneg <vscale x 1 x float> %va
  %vg = fneg <vscale x 1 x float> %vd
  %vh = call <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float> %vg, <vscale x 1 x float> %ve, <vscale x 1 x float> %vf)
  ret <vscale x 1 x float> %vh
}

define <vscale x 1 x float> @vfwnmacc_fv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmacc_fv_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwnmacc.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_fv_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x half> %vb to <vscale x 1 x float>
  %ve = fpext <vscale x 1 x half> %splat to <vscale x 1 x float>
  %vf = fneg <vscale x 1 x float> %va
  %vg = fneg <vscale x 1 x float> %ve
  %vh = call <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float> %vd, <vscale x 1 x float> %vg, <vscale x 1 x float> %vf)
  ret <vscale x 1 x float> %vh
}

define <vscale x 1 x float> @vfwmsac_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x half> %vb, <vscale x 1 x half> %vc) {
; ZVFH-LABEL: vfwmsac_vv_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwmsac.vv v8, v9, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmsac_vv_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v11, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmsac.vv v8, v11, v9
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 1 x half> %vb to <vscale x 1 x float>
  %ve = fpext <vscale x 1 x half> %vc to <vscale x 1 x float>
  %vf = fneg <vscale x 1 x float> %va
  %vg = call <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float> %vd, <vscale x 1 x float> %ve, <vscale x 1 x float> %vf)
  ret <vscale x 1 x float> %vg
}

define <vscale x 1 x float> @vfwmsac_vf_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x half> %vb, half %c) {
; ZVFH-LABEL: vfwmsac_vf_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwmsac.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmsac_vf_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfmsac.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x half> %vb to <vscale x 1 x float>
  %ve = fpext <vscale x 1 x half> %splat to <vscale x 1 x float>
  %vf = fneg <vscale x 1 x float> %va
  %vg = call <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float> %vd, <vscale x 1 x float> %ve, <vscale x 1 x float> %vf)
  ret <vscale x 1 x float> %vg
}

define <vscale x 1 x float> @vfwnmsac_vv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x half> %vb, <vscale x 1 x half> %vc) {
; ZVFH-LABEL: vfwnmsac_vv_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwnmsac.vv v8, v9, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_vv_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v11, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vv v8, v11, v9
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 1 x half> %vb to <vscale x 1 x float>
  %ve = fpext <vscale x 1 x half> %vc to <vscale x 1 x float>
  %vf = fneg <vscale x 1 x float> %vd
  %vg = call <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float> %vf, <vscale x 1 x float> %ve, <vscale x 1 x float> %va)
  ret <vscale x 1 x float> %vg
}

define <vscale x 1 x float> @vfwnmsac_vf_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmsac_vf_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwnmsac.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_vf_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x half> %vb to <vscale x 1 x float>
  %ve = fpext <vscale x 1 x half> %splat to <vscale x 1 x float>
  %vf = fneg <vscale x 1 x float> %vd
  %vg = call <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float> %vf, <vscale x 1 x float> %ve, <vscale x 1 x float> %va)
  ret <vscale x 1 x float> %vg
}

define <vscale x 1 x float> @vfwnmsac_fv_nxv1f32(<vscale x 1 x float> %va, <vscale x 1 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmsac_fv_nxv1f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFH-NEXT:    vfwnmsac.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_fv_nxv1f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 1 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 1 x half> %head, <vscale x 1 x half> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x half> %vb to <vscale x 1 x float>
  %ve = fpext <vscale x 1 x half> %splat to <vscale x 1 x float>
  %vf = fneg <vscale x 1 x float> %ve
  %vg = call <vscale x 1 x float> @llvm.fma.v1f32(<vscale x 1 x float> %vd, <vscale x 1 x float> %vf, <vscale x 1 x float> %va)
  ret <vscale x 1 x float> %vg
}

declare <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>)

define <vscale x 2 x float> @vfwmacc_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x half> %vb, <vscale x 2 x half> %vc) {
; ZVFH-LABEL: vfwmacc_vv_nxv2f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwmacc.vv v8, v9, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmacc_vv_nxv2f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v11, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfmacc.vv v8, v11, v9
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 2 x half> %vb to <vscale x 2 x float>
  %ve = fpext <vscale x 2 x half> %vc to <vscale x 2 x float>
  %vf = call <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float> %vd, <vscale x 2 x float> %ve, <vscale x 2 x float> %va)
  ret <vscale x 2 x float> %vf
}

define <vscale x 2 x float> @vfwmacc_vf_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x half> %vb, half %c) {
; ZVFH-LABEL: vfwmacc_vf_nxv2f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwmacc.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmacc_vf_nxv2f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfmacc.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x half> %vb to <vscale x 2 x float>
  %ve = fpext <vscale x 2 x half> %splat to <vscale x 2 x float>
  %vf = call <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float> %vd, <vscale x 2 x float> %ve, <vscale x 2 x float> %va)
  ret <vscale x 2 x float> %vf
}

define <vscale x 2 x float> @vfwnmacc_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x half> %vb, <vscale x 2 x half> %vc) {
; ZVFH-LABEL: vfwnmacc_vv_nxv2f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwnmacc.vv v8, v9, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_vv_nxv2f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v11, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vv v8, v11, v9
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 2 x half> %vb to <vscale x 2 x float>
  %ve = fpext <vscale x 2 x half> %vc to <vscale x 2 x float>
  %vf = fneg <vscale x 2 x float> %va
  %vg = fneg <vscale x 2 x float> %vd
  %vh = call <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float> %vg, <vscale x 2 x float> %ve, <vscale x 2 x float> %vf)
  ret <vscale x 2 x float> %vh
}

define <vscale x 2 x float> @vfwnmacc_vf_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmacc_vf_nxv2f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwnmacc.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_vf_nxv2f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x half> %vb to <vscale x 2 x float>
  %ve = fpext <vscale x 2 x half> %splat to <vscale x 2 x float>
  %vf = fneg <vscale x 2 x float> %va
  %vg = fneg <vscale x 2 x float> %vd
  %vh = call <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float> %vg, <vscale x 2 x float> %ve, <vscale x 2 x float> %vf)
  ret <vscale x 2 x float> %vh
}

define <vscale x 2 x float> @vfwnmacc_fv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmacc_fv_nxv2f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwnmacc.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_fv_nxv2f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x half> %vb to <vscale x 2 x float>
  %ve = fpext <vscale x 2 x half> %splat to <vscale x 2 x float>
  %vf = fneg <vscale x 2 x float> %va
  %vg = fneg <vscale x 2 x float> %ve
  %vh = call <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float> %vd, <vscale x 2 x float> %vg, <vscale x 2 x float> %vf)
  ret <vscale x 2 x float> %vh
}

define <vscale x 2 x float> @vfwmsac_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x half> %vb, <vscale x 2 x half> %vc) {
; ZVFH-LABEL: vfwmsac_vv_nxv2f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwmsac.vv v8, v9, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmsac_vv_nxv2f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v11, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfmsac.vv v8, v11, v9
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 2 x half> %vb to <vscale x 2 x float>
  %ve = fpext <vscale x 2 x half> %vc to <vscale x 2 x float>
  %vf = fneg <vscale x 2 x float> %va
  %vg = call <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float> %vd, <vscale x 2 x float> %ve, <vscale x 2 x float> %vf)
  ret <vscale x 2 x float> %vg
}

define <vscale x 2 x float> @vfwmsac_vf_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x half> %vb, half %c) {
; ZVFH-LABEL: vfwmsac_vf_nxv2f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwmsac.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmsac_vf_nxv2f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfmsac.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x half> %vb to <vscale x 2 x float>
  %ve = fpext <vscale x 2 x half> %splat to <vscale x 2 x float>
  %vf = fneg <vscale x 2 x float> %va
  %vg = call <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float> %vd, <vscale x 2 x float> %ve, <vscale x 2 x float> %vf)
  ret <vscale x 2 x float> %vg
}

define <vscale x 2 x float> @vfwnmsac_vv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x half> %vb, <vscale x 2 x half> %vc) {
; ZVFH-LABEL: vfwnmsac_vv_nxv2f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwnmsac.vv v8, v9, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_vv_nxv2f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v11, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v9, v10
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vv v8, v11, v9
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 2 x half> %vb to <vscale x 2 x float>
  %ve = fpext <vscale x 2 x half> %vc to <vscale x 2 x float>
  %vf = fneg <vscale x 2 x float> %vd
  %vg = call <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float> %vf, <vscale x 2 x float> %ve, <vscale x 2 x float> %va)
  ret <vscale x 2 x float> %vg
}

define <vscale x 2 x float> @vfwnmsac_vf_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmsac_vf_nxv2f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwnmsac.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_vf_nxv2f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x half> %vb to <vscale x 2 x float>
  %ve = fpext <vscale x 2 x half> %splat to <vscale x 2 x float>
  %vf = fneg <vscale x 2 x float> %vd
  %vg = call <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float> %vf, <vscale x 2 x float> %ve, <vscale x 2 x float> %va)
  ret <vscale x 2 x float> %vg
}

define <vscale x 2 x float> @vfwnmsac_fv_nxv2f32(<vscale x 2 x float> %va, <vscale x 2 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmsac_fv_nxv2f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFH-NEXT:    vfwnmsac.vf v8, fa0, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_fv_nxv2f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vf v8, fa5, v10
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 2 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 2 x half> %head, <vscale x 2 x half> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x half> %vb to <vscale x 2 x float>
  %ve = fpext <vscale x 2 x half> %splat to <vscale x 2 x float>
  %vf = fneg <vscale x 2 x float> %ve
  %vg = call <vscale x 2 x float> @llvm.fma.v2f32(<vscale x 2 x float> %vd, <vscale x 2 x float> %vf, <vscale x 2 x float> %va)
  ret <vscale x 2 x float> %vg
}


declare <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>)

define <vscale x 4 x float> @vfwmacc_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x half> %vb, <vscale x 4 x half> %vc) {
; ZVFH-LABEL: vfwmacc_vv_nxv4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfwmacc.vv v8, v10, v11
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmacc_vv_nxv4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v14, v11
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmacc.vv v8, v12, v14
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 4 x half> %vb to <vscale x 4 x float>
  %ve = fpext <vscale x 4 x half> %vc to <vscale x 4 x float>
  %vf = call <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float> %vd, <vscale x 4 x float> %ve, <vscale x 4 x float> %va)
  ret <vscale x 4 x float> %vf
}

define <vscale x 4 x float> @vfwmacc_vf_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x half> %vb, half %c) {
; ZVFH-LABEL: vfwmacc_vf_nxv4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfwmacc.vf v8, fa0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmacc_vf_nxv4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmacc.vf v8, fa5, v12
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x half> %vb to <vscale x 4 x float>
  %ve = fpext <vscale x 4 x half> %splat to <vscale x 4 x float>
  %vf = call <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float> %vd, <vscale x 4 x float> %ve, <vscale x 4 x float> %va)
  ret <vscale x 4 x float> %vf
}

define <vscale x 4 x float> @vfwnmacc_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x half> %vb, <vscale x 4 x half> %vc) {
; ZVFH-LABEL: vfwnmacc_vv_nxv4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfwnmacc.vv v8, v10, v11
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_vv_nxv4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v14, v11
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vv v8, v12, v14
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 4 x half> %vb to <vscale x 4 x float>
  %ve = fpext <vscale x 4 x half> %vc to <vscale x 4 x float>
  %vf = fneg <vscale x 4 x float> %va
  %vg = fneg <vscale x 4 x float> %vd
  %vh = call <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float> %vg, <vscale x 4 x float> %ve, <vscale x 4 x float> %vf)
  ret <vscale x 4 x float> %vh
}

define <vscale x 4 x float> @vfwnmacc_vf_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmacc_vf_nxv4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfwnmacc.vf v8, fa0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_vf_nxv4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vf v8, fa5, v12
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x half> %vb to <vscale x 4 x float>
  %ve = fpext <vscale x 4 x half> %splat to <vscale x 4 x float>
  %vf = fneg <vscale x 4 x float> %va
  %vg = fneg <vscale x 4 x float> %vd
  %vh = call <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float> %vg, <vscale x 4 x float> %ve, <vscale x 4 x float> %vf)
  ret <vscale x 4 x float> %vh
}

define <vscale x 4 x float> @vfwnmacc_fv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmacc_fv_nxv4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfwnmacc.vf v8, fa0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_fv_nxv4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vf v8, fa5, v12
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x half> %vb to <vscale x 4 x float>
  %ve = fpext <vscale x 4 x half> %splat to <vscale x 4 x float>
  %vf = fneg <vscale x 4 x float> %va
  %vg = fneg <vscale x 4 x float> %ve
  %vh = call <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float> %vd, <vscale x 4 x float> %vg, <vscale x 4 x float> %vf)
  ret <vscale x 4 x float> %vh
}

define <vscale x 4 x float> @vfwmsac_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x half> %vb, <vscale x 4 x half> %vc) {
; ZVFH-LABEL: vfwmsac_vv_nxv4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfwmsac.vv v8, v10, v11
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmsac_vv_nxv4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v14, v11
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmsac.vv v8, v12, v14
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 4 x half> %vb to <vscale x 4 x float>
  %ve = fpext <vscale x 4 x half> %vc to <vscale x 4 x float>
  %vf = fneg <vscale x 4 x float> %va
  %vg = call <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float> %vd, <vscale x 4 x float> %ve, <vscale x 4 x float> %vf)
  ret <vscale x 4 x float> %vg
}

define <vscale x 4 x float> @vfwmsac_vf_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x half> %vb, half %c) {
; ZVFH-LABEL: vfwmsac_vf_nxv4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfwmsac.vf v8, fa0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmsac_vf_nxv4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmsac.vf v8, fa5, v12
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x half> %vb to <vscale x 4 x float>
  %ve = fpext <vscale x 4 x half> %splat to <vscale x 4 x float>
  %vf = fneg <vscale x 4 x float> %va
  %vg = call <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float> %vd, <vscale x 4 x float> %ve, <vscale x 4 x float> %vf)
  ret <vscale x 4 x float> %vg
}

define <vscale x 4 x float> @vfwnmsac_vv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x half> %vb, <vscale x 4 x half> %vc) {
; ZVFH-LABEL: vfwnmsac_vv_nxv4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfwnmsac.vv v8, v10, v11
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_vv_nxv4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v14, v11
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vv v8, v12, v14
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 4 x half> %vb to <vscale x 4 x float>
  %ve = fpext <vscale x 4 x half> %vc to <vscale x 4 x float>
  %vf = fneg <vscale x 4 x float> %vd
  %vg = call <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float> %vf, <vscale x 4 x float> %ve, <vscale x 4 x float> %va)
  ret <vscale x 4 x float> %vg
}

define <vscale x 4 x float> @vfwnmsac_vf_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmsac_vf_nxv4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfwnmsac.vf v8, fa0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_vf_nxv4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vf v8, fa5, v12
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x half> %vb to <vscale x 4 x float>
  %ve = fpext <vscale x 4 x half> %splat to <vscale x 4 x float>
  %vf = fneg <vscale x 4 x float> %vd
  %vg = call <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float> %vf, <vscale x 4 x float> %ve, <vscale x 4 x float> %va)
  ret <vscale x 4 x float> %vg
}

define <vscale x 4 x float> @vfwnmsac_fv_nxv4f32(<vscale x 4 x float> %va, <vscale x 4 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmsac_fv_nxv4f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFH-NEXT:    vfwnmsac.vf v8, fa0, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_fv_nxv4f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v10
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vf v8, fa5, v12
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 4 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 4 x half> %head, <vscale x 4 x half> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x half> %vb to <vscale x 4 x float>
  %ve = fpext <vscale x 4 x half> %splat to <vscale x 4 x float>
  %vf = fneg <vscale x 4 x float> %ve
  %vg = call <vscale x 4 x float> @llvm.fma.v4f32(<vscale x 4 x float> %vd, <vscale x 4 x float> %vf, <vscale x 4 x float> %va)
  ret <vscale x 4 x float> %vg
}

declare <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float>, <vscale x 8 x float>, <vscale x 8 x float>)

define <vscale x 8 x float> @vfwmacc_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x half> %vb, <vscale x 8 x half> %vc) {
; ZVFH-LABEL: vfwmacc_vv_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfwmacc.vv v8, v12, v14
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmacc_vv_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v20, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmacc.vv v8, v16, v20
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 8 x half> %vb to <vscale x 8 x float>
  %ve = fpext <vscale x 8 x half> %vc to <vscale x 8 x float>
  %vf = call <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float> %vd, <vscale x 8 x float> %ve, <vscale x 8 x float> %va)
  ret <vscale x 8 x float> %vf
}

define <vscale x 8 x float> @vfwmacc_vf_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x half> %vb, half %c) {
; ZVFH-LABEL: vfwmacc_vf_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfwmacc.vf v8, fa0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmacc_vf_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmacc.vf v8, fa5, v16
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x half> %vb to <vscale x 8 x float>
  %ve = fpext <vscale x 8 x half> %splat to <vscale x 8 x float>
  %vf = call <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float> %vd, <vscale x 8 x float> %ve, <vscale x 8 x float> %va)
  ret <vscale x 8 x float> %vf
}

define <vscale x 8 x float> @vfwnmacc_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x half> %vb, <vscale x 8 x half> %vc) {
; ZVFH-LABEL: vfwnmacc_vv_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfwnmacc.vv v8, v12, v14
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_vv_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v20, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vv v8, v16, v20
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 8 x half> %vb to <vscale x 8 x float>
  %ve = fpext <vscale x 8 x half> %vc to <vscale x 8 x float>
  %vf = fneg <vscale x 8 x float> %va
  %vg = fneg <vscale x 8 x float> %vd
  %vh = call <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float> %vg, <vscale x 8 x float> %ve, <vscale x 8 x float> %vf)
  ret <vscale x 8 x float> %vh
}

define <vscale x 8 x float> @vfwnmacc_vf_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmacc_vf_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfwnmacc.vf v8, fa0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_vf_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vf v8, fa5, v16
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x half> %vb to <vscale x 8 x float>
  %ve = fpext <vscale x 8 x half> %splat to <vscale x 8 x float>
  %vf = fneg <vscale x 8 x float> %va
  %vg = fneg <vscale x 8 x float> %vd
  %vh = call <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float> %vg, <vscale x 8 x float> %ve, <vscale x 8 x float> %vf)
  ret <vscale x 8 x float> %vh
}

define <vscale x 8 x float> @vfwnmacc_fv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmacc_fv_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfwnmacc.vf v8, fa0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_fv_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vf v8, fa5, v16
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x half> %vb to <vscale x 8 x float>
  %ve = fpext <vscale x 8 x half> %splat to <vscale x 8 x float>
  %vf = fneg <vscale x 8 x float> %va
  %vg = fneg <vscale x 8 x float> %ve
  %vh = call <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float> %vd, <vscale x 8 x float> %vg, <vscale x 8 x float> %vf)
  ret <vscale x 8 x float> %vh
}

define <vscale x 8 x float> @vfwmsac_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x half> %vb, <vscale x 8 x half> %vc) {
; ZVFH-LABEL: vfwmsac_vv_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfwmsac.vv v8, v12, v14
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmsac_vv_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v20, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmsac.vv v8, v16, v20
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 8 x half> %vb to <vscale x 8 x float>
  %ve = fpext <vscale x 8 x half> %vc to <vscale x 8 x float>
  %vf = fneg <vscale x 8 x float> %va
  %vg = call <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float> %vd, <vscale x 8 x float> %ve, <vscale x 8 x float> %vf)
  ret <vscale x 8 x float> %vg
}

define <vscale x 8 x float> @vfwmsac_vf_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x half> %vb, half %c) {
; ZVFH-LABEL: vfwmsac_vf_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfwmsac.vf v8, fa0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmsac_vf_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfmsac.vf v8, fa5, v16
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x half> %vb to <vscale x 8 x float>
  %ve = fpext <vscale x 8 x half> %splat to <vscale x 8 x float>
  %vf = fneg <vscale x 8 x float> %va
  %vg = call <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float> %vd, <vscale x 8 x float> %ve, <vscale x 8 x float> %vf)
  ret <vscale x 8 x float> %vg
}

define <vscale x 8 x float> @vfwnmsac_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x half> %vb, <vscale x 8 x half> %vc) {
; ZVFH-LABEL: vfwnmsac_vv_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfwnmsac.vv v8, v12, v14
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_vv_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v20, v14
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vv v8, v16, v20
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 8 x half> %vb to <vscale x 8 x float>
  %ve = fpext <vscale x 8 x half> %vc to <vscale x 8 x float>
  %vf = fneg <vscale x 8 x float> %vd
  %vg = call <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float> %vf, <vscale x 8 x float> %ve, <vscale x 8 x float> %va)
  ret <vscale x 8 x float> %vg
}

define <vscale x 8 x float> @vfwnmsac_vf_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmsac_vf_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfwnmsac.vf v8, fa0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_vf_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vf v8, fa5, v16
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x half> %vb to <vscale x 8 x float>
  %ve = fpext <vscale x 8 x half> %splat to <vscale x 8 x float>
  %vf = fneg <vscale x 8 x float> %vd
  %vg = call <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float> %vf, <vscale x 8 x float> %ve, <vscale x 8 x float> %va)
  ret <vscale x 8 x float> %vg
}

define <vscale x 8 x float> @vfwnmsac_fv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmsac_fv_nxv8f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFH-NEXT:    vfwnmsac.vf v8, fa0, v12
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_fv_nxv8f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v16, v12
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vf v8, fa5, v16
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 8 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x half> %vb to <vscale x 8 x float>
  %ve = fpext <vscale x 8 x half> %splat to <vscale x 8 x float>
  %vf = fneg <vscale x 8 x float> %ve
  %vg = call <vscale x 8 x float> @llvm.fma.v8f32(<vscale x 8 x float> %vd, <vscale x 8 x float> %vf, <vscale x 8 x float> %va)
  ret <vscale x 8 x float> %vg
}

declare <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float>, <vscale x 16 x float>, <vscale x 16 x float>)

define <vscale x 16 x float> @vfwmacc_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x half> %vb, <vscale x 16 x half> %vc) {
; ZVFH-LABEL: vfwmacc_vv_nxv16f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwmacc.vv v8, v16, v20
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmacc_vv_nxv16f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v0, v20
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfmacc.vv v8, v24, v0
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 16 x half> %vb to <vscale x 16 x float>
  %ve = fpext <vscale x 16 x half> %vc to <vscale x 16 x float>
  %vf = call <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float> %vd, <vscale x 16 x float> %ve, <vscale x 16 x float> %va)
  ret <vscale x 16 x float> %vf
}

define <vscale x 16 x float> @vfwmacc_vf_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x half> %vb, half %c) {
; ZVFH-LABEL: vfwmacc_vf_nxv16f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwmacc.vf v8, fa0, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmacc_vf_nxv16f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfmacc.vf v8, fa5, v24
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %vd = fpext <vscale x 16 x half> %vb to <vscale x 16 x float>
  %ve = fpext <vscale x 16 x half> %splat to <vscale x 16 x float>
  %vf = call <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float> %vd, <vscale x 16 x float> %ve, <vscale x 16 x float> %va)
  ret <vscale x 16 x float> %vf
}

define <vscale x 16 x float> @vfwnmacc_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x half> %vb, <vscale x 16 x half> %vc) {
; ZVFH-LABEL: vfwnmacc_vv_nxv16f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwnmacc.vv v8, v16, v20
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_vv_nxv16f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v0, v20
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vv v8, v24, v0
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 16 x half> %vb to <vscale x 16 x float>
  %ve = fpext <vscale x 16 x half> %vc to <vscale x 16 x float>
  %vf = fneg <vscale x 16 x float> %va
  %vg = fneg <vscale x 16 x float> %vd
  %vh = call <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float> %vg, <vscale x 16 x float> %ve, <vscale x 16 x float> %vf)
  ret <vscale x 16 x float> %vh
}

define <vscale x 16 x float> @vfwnmacc_vf_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmacc_vf_nxv16f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwnmacc.vf v8, fa0, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_vf_nxv16f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vf v8, fa5, v24
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %vd = fpext <vscale x 16 x half> %vb to <vscale x 16 x float>
  %ve = fpext <vscale x 16 x half> %splat to <vscale x 16 x float>
  %vf = fneg <vscale x 16 x float> %va
  %vg = fneg <vscale x 16 x float> %vd
  %vh = call <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float> %vg, <vscale x 16 x float> %ve, <vscale x 16 x float> %vf)
  ret <vscale x 16 x float> %vh
}

define <vscale x 16 x float> @vfwnmacc_fv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmacc_fv_nxv16f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwnmacc.vf v8, fa0, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmacc_fv_nxv16f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfnmacc.vf v8, fa5, v24
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %vd = fpext <vscale x 16 x half> %vb to <vscale x 16 x float>
  %ve = fpext <vscale x 16 x half> %splat to <vscale x 16 x float>
  %vf = fneg <vscale x 16 x float> %va
  %vg = fneg <vscale x 16 x float> %ve
  %vh = call <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float> %vd, <vscale x 16 x float> %vg, <vscale x 16 x float> %vf)
  ret <vscale x 16 x float> %vh
}

define <vscale x 16 x float> @vfwmsac_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x half> %vb, <vscale x 16 x half> %vc) {
; ZVFH-LABEL: vfwmsac_vv_nxv16f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwmsac.vv v8, v16, v20
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmsac_vv_nxv16f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v0, v20
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfmsac.vv v8, v24, v0
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 16 x half> %vb to <vscale x 16 x float>
  %ve = fpext <vscale x 16 x half> %vc to <vscale x 16 x float>
  %vf = fneg <vscale x 16 x float> %va
  %vg = call <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float> %vd, <vscale x 16 x float> %ve, <vscale x 16 x float> %vf)
  ret <vscale x 16 x float> %vg
}

define <vscale x 16 x float> @vfwmsac_vf_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x half> %vb, half %c) {
; ZVFH-LABEL: vfwmsac_vf_nxv16f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwmsac.vf v8, fa0, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwmsac_vf_nxv16f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfmsac.vf v8, fa5, v24
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %vd = fpext <vscale x 16 x half> %vb to <vscale x 16 x float>
  %ve = fpext <vscale x 16 x half> %splat to <vscale x 16 x float>
  %vf = fneg <vscale x 16 x float> %va
  %vg = call <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float> %vd, <vscale x 16 x float> %ve, <vscale x 16 x float> %vf)
  ret <vscale x 16 x float> %vg
}

define <vscale x 16 x float> @vfwnmsac_vv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x half> %vb, <vscale x 16 x half> %vc) {
; ZVFH-LABEL: vfwnmsac_vv_nxv16f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwnmsac.vv v8, v16, v20
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_vv_nxv16f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v0, v20
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vv v8, v24, v0
; ZVFHMIN-NEXT:    ret
  %vd = fpext <vscale x 16 x half> %vb to <vscale x 16 x float>
  %ve = fpext <vscale x 16 x half> %vc to <vscale x 16 x float>
  %vf = fneg <vscale x 16 x float> %vd
  %vg = call <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float> %vf, <vscale x 16 x float> %ve, <vscale x 16 x float> %va)
  ret <vscale x 16 x float> %vg
}

define <vscale x 16 x float> @vfwnmsac_vf_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmsac_vf_nxv16f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwnmsac.vf v8, fa0, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_vf_nxv16f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vf v8, fa5, v24
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %vd = fpext <vscale x 16 x half> %vb to <vscale x 16 x float>
  %ve = fpext <vscale x 16 x half> %splat to <vscale x 16 x float>
  %vf = fneg <vscale x 16 x float> %vd
  %vg = call <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float> %vf, <vscale x 16 x float> %ve, <vscale x 16 x float> %va)
  ret <vscale x 16 x float> %vg
}

define <vscale x 16 x float> @vfwnmsac_fv_nxv16f32(<vscale x 16 x float> %va, <vscale x 16 x half> %vb, half %c) {
; ZVFH-LABEL: vfwnmsac_fv_nxv16f32:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFH-NEXT:    vfwnmsac.vf v8, fa0, v16
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: vfwnmsac_fv_nxv16f32:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v24, v16
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; ZVFHMIN-NEXT:    vfnmsac.vf v8, fa5, v24
; ZVFHMIN-NEXT:    ret
  %head = insertelement <vscale x 16 x half> poison, half %c, i32 0
  %splat = shufflevector <vscale x 16 x half> %head, <vscale x 16 x half> poison, <vscale x 16 x i32> zeroinitializer
  %vd = fpext <vscale x 16 x half> %vb to <vscale x 16 x float>
  %ve = fpext <vscale x 16 x half> %splat to <vscale x 16 x float>
  %vf = fneg <vscale x 16 x float> %ve
  %vg = call <vscale x 16 x float> @llvm.fma.v16f32(<vscale x 16 x float> %vd, <vscale x 16 x float> %vf, <vscale x 16 x float> %va)
  ret <vscale x 16 x float> %vg
}

declare <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>)

define <vscale x 1 x double> @vfwmacc_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb, <vscale x 1 x float> %vc) {
; CHECK-LABEL: vfwmacc_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fpext <vscale x 1 x float> %vc to <vscale x 1 x double>
  %vf = call <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double> %vd, <vscale x 1 x double> %ve, <vscale x 1 x double> %va)
  ret <vscale x 1 x double> %vf
}

define <vscale x 1 x double> @vfwmacc_vf_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb, float %c) {
; CHECK-LABEL: vfwmacc_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fpext <vscale x 1 x float> %splat to <vscale x 1 x double>
  %vf = call <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double> %vd, <vscale x 1 x double> %ve, <vscale x 1 x double> %va)
  ret <vscale x 1 x double> %vf
}

define <vscale x 1 x double> @vfwnmacc_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb, <vscale x 1 x float> %vc) {
; CHECK-LABEL: vfwnmacc_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fpext <vscale x 1 x float> %vc to <vscale x 1 x double>
  %vf = fneg <vscale x 1 x double> %va
  %vg = fneg <vscale x 1 x double> %vd
  %vh = call <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double> %vg, <vscale x 1 x double> %ve, <vscale x 1 x double> %vf)
  ret <vscale x 1 x double> %vh
}

define <vscale x 1 x double> @vfwnmacc_vf_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fpext <vscale x 1 x float> %splat to <vscale x 1 x double>
  %vf = fneg <vscale x 1 x double> %va
  %vg = fneg <vscale x 1 x double> %vd
  %vh = call <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double> %vg, <vscale x 1 x double> %ve, <vscale x 1 x double> %vf)
  ret <vscale x 1 x double> %vh
}

define <vscale x 1 x double> @vfwnmacc_fv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fpext <vscale x 1 x float> %splat to <vscale x 1 x double>
  %vf = fneg <vscale x 1 x double> %va
  %vg = fneg <vscale x 1 x double> %ve
  %vh = call <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double> %vd, <vscale x 1 x double> %vg, <vscale x 1 x double> %vf)
  ret <vscale x 1 x double> %vh
}

define <vscale x 1 x double> @vfwmsac_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb, <vscale x 1 x float> %vc) {
; CHECK-LABEL: vfwmsac_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fpext <vscale x 1 x float> %vc to <vscale x 1 x double>
  %vf = fneg <vscale x 1 x double> %va
  %vg = call <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double> %vd, <vscale x 1 x double> %ve, <vscale x 1 x double> %vf)
  ret <vscale x 1 x double> %vg
}

define <vscale x 1 x double> @vfwmsac_vf_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb, float %c) {
; CHECK-LABEL: vfwmsac_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fpext <vscale x 1 x float> %splat to <vscale x 1 x double>
  %vf = fneg <vscale x 1 x double> %va
  %vg = call <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double> %vd, <vscale x 1 x double> %ve, <vscale x 1 x double> %vf)
  ret <vscale x 1 x double> %vg
}

define <vscale x 1 x double> @vfwnmsac_vv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb, <vscale x 1 x float> %vc) {
; CHECK-LABEL: vfwnmsac_vv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v9, v10
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fpext <vscale x 1 x float> %vc to <vscale x 1 x double>
  %vf = fneg <vscale x 1 x double> %vd
  %vg = call <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double> %vf, <vscale x 1 x double> %ve, <vscale x 1 x double> %va)
  ret <vscale x 1 x double> %vg
}

define <vscale x 1 x double> @vfwnmsac_vf_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_vf_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fpext <vscale x 1 x float> %splat to <vscale x 1 x double>
  %vf = fneg <vscale x 1 x double> %vd
  %vg = call <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double> %vf, <vscale x 1 x double> %ve, <vscale x 1 x double> %va)
  ret <vscale x 1 x double> %vg
}

define <vscale x 1 x double> @vfwnmsac_fv_nxv1f64(<vscale x 1 x double> %va, <vscale x 1 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_fv_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 1 x float> %head, <vscale x 1 x float> poison, <vscale x 1 x i32> zeroinitializer
  %vd = fpext <vscale x 1 x float> %vb to <vscale x 1 x double>
  %ve = fpext <vscale x 1 x float> %splat to <vscale x 1 x double>
  %vf = fneg <vscale x 1 x double> %ve
  %vg = call <vscale x 1 x double> @llvm.fma.v1f64(<vscale x 1 x double> %vd, <vscale x 1 x double> %vf, <vscale x 1 x double> %va)
  ret <vscale x 1 x double> %vg
}

declare <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>)

define <vscale x 2 x double> @vfwmacc_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb, <vscale x 2 x float> %vc) {
; CHECK-LABEL: vfwmacc_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fpext <vscale x 2 x float> %vc to <vscale x 2 x double>
  %vf = call <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double> %vd, <vscale x 2 x double> %ve, <vscale x 2 x double> %va)
  ret <vscale x 2 x double> %vf
}

define <vscale x 2 x double> @vfwmacc_vf_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb, float %c) {
; CHECK-LABEL: vfwmacc_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fpext <vscale x 2 x float> %splat to <vscale x 2 x double>
  %vf = call <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double> %vd, <vscale x 2 x double> %ve, <vscale x 2 x double> %va)
  ret <vscale x 2 x double> %vf
}

define <vscale x 2 x double> @vfwnmacc_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb, <vscale x 2 x float> %vc) {
; CHECK-LABEL: vfwnmacc_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fpext <vscale x 2 x float> %vc to <vscale x 2 x double>
  %vf = fneg <vscale x 2 x double> %va
  %vg = fneg <vscale x 2 x double> %vd
  %vh = call <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double> %vg, <vscale x 2 x double> %ve, <vscale x 2 x double> %vf)
  ret <vscale x 2 x double> %vh
}

define <vscale x 2 x double> @vfwnmacc_vf_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fpext <vscale x 2 x float> %splat to <vscale x 2 x double>
  %vf = fneg <vscale x 2 x double> %va
  %vg = fneg <vscale x 2 x double> %vd
  %vh = call <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double> %vg, <vscale x 2 x double> %ve, <vscale x 2 x double> %vf)
  ret <vscale x 2 x double> %vh
}

define <vscale x 2 x double> @vfwnmacc_fv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fpext <vscale x 2 x float> %splat to <vscale x 2 x double>
  %vf = fneg <vscale x 2 x double> %va
  %vg = fneg <vscale x 2 x double> %ve
  %vh = call <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double> %vd, <vscale x 2 x double> %vg, <vscale x 2 x double> %vf)
  ret <vscale x 2 x double> %vh
}

define <vscale x 2 x double> @vfwmsac_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb, <vscale x 2 x float> %vc) {
; CHECK-LABEL: vfwmsac_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fpext <vscale x 2 x float> %vc to <vscale x 2 x double>
  %vf = fneg <vscale x 2 x double> %va
  %vg = call <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double> %vd, <vscale x 2 x double> %ve, <vscale x 2 x double> %vf)
  ret <vscale x 2 x double> %vg
}

define <vscale x 2 x double> @vfwmsac_vf_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb, float %c) {
; CHECK-LABEL: vfwmsac_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fpext <vscale x 2 x float> %splat to <vscale x 2 x double>
  %vf = fneg <vscale x 2 x double> %va
  %vg = call <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double> %vd, <vscale x 2 x double> %ve, <vscale x 2 x double> %vf)
  ret <vscale x 2 x double> %vg
}

define <vscale x 2 x double> @vfwnmsac_vv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb, <vscale x 2 x float> %vc) {
; CHECK-LABEL: vfwnmsac_vv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v10, v11
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fpext <vscale x 2 x float> %vc to <vscale x 2 x double>
  %vf = fneg <vscale x 2 x double> %vd
  %vg = call <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double> %vf, <vscale x 2 x double> %ve, <vscale x 2 x double> %va)
  ret <vscale x 2 x double> %vg
}

define <vscale x 2 x double> @vfwnmsac_vf_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_vf_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fpext <vscale x 2 x float> %splat to <vscale x 2 x double>
  %vf = fneg <vscale x 2 x double> %vd
  %vg = call <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double> %vf, <vscale x 2 x double> %ve, <vscale x 2 x double> %va)
  ret <vscale x 2 x double> %vg
}

define <vscale x 2 x double> @vfwnmsac_fv_nxv2f64(<vscale x 2 x double> %va, <vscale x 2 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_fv_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 2 x float> %head, <vscale x 2 x float> poison, <vscale x 2 x i32> zeroinitializer
  %vd = fpext <vscale x 2 x float> %vb to <vscale x 2 x double>
  %ve = fpext <vscale x 2 x float> %splat to <vscale x 2 x double>
  %vf = fneg <vscale x 2 x double> %ve
  %vg = call <vscale x 2 x double> @llvm.fma.v2f64(<vscale x 2 x double> %vd, <vscale x 2 x double> %vf, <vscale x 2 x double> %va)
  ret <vscale x 2 x double> %vg
}


declare <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double>, <vscale x 4 x double>, <vscale x 4 x double>)

define <vscale x 4 x double> @vfwmacc_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb, <vscale x 4 x float> %vc) {
; CHECK-LABEL: vfwmacc_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fpext <vscale x 4 x float> %vc to <vscale x 4 x double>
  %vf = call <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double> %vd, <vscale x 4 x double> %ve, <vscale x 4 x double> %va)
  ret <vscale x 4 x double> %vf
}

define <vscale x 4 x double> @vfwmacc_vf_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb, float %c) {
; CHECK-LABEL: vfwmacc_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fpext <vscale x 4 x float> %splat to <vscale x 4 x double>
  %vf = call <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double> %vd, <vscale x 4 x double> %ve, <vscale x 4 x double> %va)
  ret <vscale x 4 x double> %vf
}

define <vscale x 4 x double> @vfwnmacc_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb, <vscale x 4 x float> %vc) {
; CHECK-LABEL: vfwnmacc_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fpext <vscale x 4 x float> %vc to <vscale x 4 x double>
  %vf = fneg <vscale x 4 x double> %va
  %vg = fneg <vscale x 4 x double> %vd
  %vh = call <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double> %vg, <vscale x 4 x double> %ve, <vscale x 4 x double> %vf)
  ret <vscale x 4 x double> %vh
}

define <vscale x 4 x double> @vfwnmacc_vf_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fpext <vscale x 4 x float> %splat to <vscale x 4 x double>
  %vf = fneg <vscale x 4 x double> %va
  %vg = fneg <vscale x 4 x double> %vd
  %vh = call <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double> %vg, <vscale x 4 x double> %ve, <vscale x 4 x double> %vf)
  ret <vscale x 4 x double> %vh
}

define <vscale x 4 x double> @vfwnmacc_fv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fpext <vscale x 4 x float> %splat to <vscale x 4 x double>
  %vf = fneg <vscale x 4 x double> %va
  %vg = fneg <vscale x 4 x double> %ve
  %vh = call <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double> %vd, <vscale x 4 x double> %vg, <vscale x 4 x double> %vf)
  ret <vscale x 4 x double> %vh
}

define <vscale x 4 x double> @vfwmsac_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb, <vscale x 4 x float> %vc) {
; CHECK-LABEL: vfwmsac_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fpext <vscale x 4 x float> %vc to <vscale x 4 x double>
  %vf = fneg <vscale x 4 x double> %va
  %vg = call <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double> %vd, <vscale x 4 x double> %ve, <vscale x 4 x double> %vf)
  ret <vscale x 4 x double> %vg
}

define <vscale x 4 x double> @vfwmsac_vf_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb, float %c) {
; CHECK-LABEL: vfwmsac_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fpext <vscale x 4 x float> %splat to <vscale x 4 x double>
  %vf = fneg <vscale x 4 x double> %va
  %vg = call <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double> %vd, <vscale x 4 x double> %ve, <vscale x 4 x double> %vf)
  ret <vscale x 4 x double> %vg
}

define <vscale x 4 x double> @vfwnmsac_vv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb, <vscale x 4 x float> %vc) {
; CHECK-LABEL: vfwnmsac_vv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v12, v14
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fpext <vscale x 4 x float> %vc to <vscale x 4 x double>
  %vf = fneg <vscale x 4 x double> %vd
  %vg = call <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double> %vf, <vscale x 4 x double> %ve, <vscale x 4 x double> %va)
  ret <vscale x 4 x double> %vg
}

define <vscale x 4 x double> @vfwnmsac_vf_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_vf_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fpext <vscale x 4 x float> %splat to <vscale x 4 x double>
  %vf = fneg <vscale x 4 x double> %vd
  %vg = call <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double> %vf, <vscale x 4 x double> %ve, <vscale x 4 x double> %va)
  ret <vscale x 4 x double> %vg
}

define <vscale x 4 x double> @vfwnmsac_fv_nxv4f64(<vscale x 4 x double> %va, <vscale x 4 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_fv_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %vd = fpext <vscale x 4 x float> %vb to <vscale x 4 x double>
  %ve = fpext <vscale x 4 x float> %splat to <vscale x 4 x double>
  %vf = fneg <vscale x 4 x double> %ve
  %vg = call <vscale x 4 x double> @llvm.fma.v4f64(<vscale x 4 x double> %vd, <vscale x 4 x double> %vf, <vscale x 4 x double> %va)
  ret <vscale x 4 x double> %vg
}

declare <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double>, <vscale x 8 x double>, <vscale x 8 x double>)

define <vscale x 8 x double> @vfwmacc_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb, <vscale x 8 x float> %vc) {
; CHECK-LABEL: vfwmacc_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwmacc.vv v8, v16, v20
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fpext <vscale x 8 x float> %vc to <vscale x 8 x double>
  %vf = call <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double> %vd, <vscale x 8 x double> %ve, <vscale x 8 x double> %va)
  ret <vscale x 8 x double> %vf
}

define <vscale x 8 x double> @vfwmacc_vf_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb, float %c) {
; CHECK-LABEL: vfwmacc_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwmacc.vf v8, fa0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fpext <vscale x 8 x float> %splat to <vscale x 8 x double>
  %vf = call <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double> %vd, <vscale x 8 x double> %ve, <vscale x 8 x double> %va)
  ret <vscale x 8 x double> %vf
}

define <vscale x 8 x double> @vfwnmacc_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb, <vscale x 8 x float> %vc) {
; CHECK-LABEL: vfwnmacc_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwnmacc.vv v8, v16, v20
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fpext <vscale x 8 x float> %vc to <vscale x 8 x double>
  %vf = fneg <vscale x 8 x double> %va
  %vg = fneg <vscale x 8 x double> %vd
  %vh = call <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double> %vg, <vscale x 8 x double> %ve, <vscale x 8 x double> %vf)
  ret <vscale x 8 x double> %vh
}

define <vscale x 8 x double> @vfwnmacc_vf_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fpext <vscale x 8 x float> %splat to <vscale x 8 x double>
  %vf = fneg <vscale x 8 x double> %va
  %vg = fneg <vscale x 8 x double> %vd
  %vh = call <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double> %vg, <vscale x 8 x double> %ve, <vscale x 8 x double> %vf)
  ret <vscale x 8 x double> %vh
}

define <vscale x 8 x double> @vfwnmacc_fv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmacc_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwnmacc.vf v8, fa0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fpext <vscale x 8 x float> %splat to <vscale x 8 x double>
  %vf = fneg <vscale x 8 x double> %va
  %vg = fneg <vscale x 8 x double> %ve
  %vh = call <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double> %vd, <vscale x 8 x double> %vg, <vscale x 8 x double> %vf)
  ret <vscale x 8 x double> %vh
}

define <vscale x 8 x double> @vfwmsac_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb, <vscale x 8 x float> %vc) {
; CHECK-LABEL: vfwmsac_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwmsac.vv v8, v16, v20
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fpext <vscale x 8 x float> %vc to <vscale x 8 x double>
  %vf = fneg <vscale x 8 x double> %va
  %vg = call <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double> %vd, <vscale x 8 x double> %ve, <vscale x 8 x double> %vf)
  ret <vscale x 8 x double> %vg
}

define <vscale x 8 x double> @vfwmsac_vf_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb, float %c) {
; CHECK-LABEL: vfwmsac_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwmsac.vf v8, fa0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fpext <vscale x 8 x float> %splat to <vscale x 8 x double>
  %vf = fneg <vscale x 8 x double> %va
  %vg = call <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double> %vd, <vscale x 8 x double> %ve, <vscale x 8 x double> %vf)
  ret <vscale x 8 x double> %vg
}

define <vscale x 8 x double> @vfwnmsac_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb, <vscale x 8 x float> %vc) {
; CHECK-LABEL: vfwnmsac_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwnmsac.vv v8, v16, v20
; CHECK-NEXT:    ret
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fpext <vscale x 8 x float> %vc to <vscale x 8 x double>
  %vf = fneg <vscale x 8 x double> %vd
  %vg = call <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double> %vf, <vscale x 8 x double> %ve, <vscale x 8 x double> %va)
  ret <vscale x 8 x double> %vg
}

define <vscale x 8 x double> @vfwnmsac_vf_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fpext <vscale x 8 x float> %splat to <vscale x 8 x double>
  %vf = fneg <vscale x 8 x double> %vd
  %vg = call <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double> %vf, <vscale x 8 x double> %ve, <vscale x 8 x double> %va)
  ret <vscale x 8 x double> %vg
}

define <vscale x 8 x double> @vfwnmsac_fv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x float> %vb, float %c) {
; CHECK-LABEL: vfwnmsac_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwnmsac.vf v8, fa0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> poison, float %c, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> poison, <vscale x 8 x i32> zeroinitializer
  %vd = fpext <vscale x 8 x float> %vb to <vscale x 8 x double>
  %ve = fpext <vscale x 8 x float> %splat to <vscale x 8 x double>
  %vf = fneg <vscale x 8 x double> %ve
  %vg = call <vscale x 8 x double> @llvm.fma.v8f64(<vscale x 8 x double> %vd, <vscale x 8 x double> %vf, <vscale x 8 x double> %va)
  ret <vscale x 8 x double> %vg
}
