; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=arm-eabihf -mattr=+neon < %s | FileCheck -check-prefixes=CHECK-NO_NEON %s
; RUN: llc -mtriple=arm-eabihf -mattr=+neon,+neonfp < %s | FileCheck -check-prefixes=CHECK-NEON %s

define float @max_f32(float, float) {
; CHECK-NO_NEON-LABEL: max_f32:
; CHECK-NO_NEON:       @ %bb.0:
; CHECK-NO_NEON-NEXT:    vcmp.f32 s1, s0
; CHECK-NO_NEON-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-NO_NEON-NEXT:    vmovgt.f32 s0, s1
; CHECK-NO_NEON-NEXT:    mov pc, lr
;
; CHECK-NEON-LABEL: max_f32:
; CHECK-NEON:       @ %bb.0:
; CHECK-NEON-NEXT:    vcmp.f32 s1, s0
; CHECK-NEON-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-NEON-NEXT:    vmovgt.f32 s0, s1
; CHECK-NEON-NEXT:    mov pc, lr
  %3 = call nnan float @llvm.maxnum.f32(float %1, float %0)
  ret float %3
}

declare float @llvm.maxnum.f32(float, float) #1

define float @min_f32(float, float) {
; CHECK-NO_NEON-LABEL: min_f32:
; CHECK-NO_NEON:       @ %bb.0:
; CHECK-NO_NEON-NEXT:    vcmp.f32 s1, s0
; CHECK-NO_NEON-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-NO_NEON-NEXT:    vmovlt.f32 s0, s1
; CHECK-NO_NEON-NEXT:    mov pc, lr
;
; CHECK-NEON-LABEL: min_f32:
; CHECK-NEON:       @ %bb.0:
; CHECK-NEON-NEXT:    vcmp.f32 s1, s0
; CHECK-NEON-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-NEON-NEXT:    vmovlt.f32 s0, s1
; CHECK-NEON-NEXT:    mov pc, lr
  %3 = call nnan float @llvm.minnum.f32(float %1, float %0)
  ret float %3
}

declare float @llvm.minnum.f32(float, float) #1

