; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @llvm.assume(i1)
declare i8 @llvm.ctpop.i8(i8)

; https://alive2.llvm.org/ce/z/LV_8xy
define i8 @and_add_shl(i8 %x) {
; CHECK-LABEL: define i8 @and_add_shl
; CHECK-SAME: (i8 [[X:%.*]]) {
; CHECK-NEXT:    [[OP1_P2:%.*]] = icmp ult i8 [[X]], 6
; CHECK-NEXT:    call void @llvm.assume(i1 [[OP1_P2]])
; CHECK-NEXT:    [[NOTMASK:%.*]] = shl nsw i8 -1, [[X]]
; CHECK-NEXT:    [[SUB:%.*]] = and i8 [[NOTMASK]], 32
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[SUB]], 32
; CHECK-NEXT:    ret i8 [[R]]
;
  %op1_p2 = icmp ule i8 %x, 5
  call void @llvm.assume(i1 %op1_p2)
  %shift = shl i8 1, %x
  %sub = add i8 %shift, -1
  %r = and i8 %sub, 32
  ret i8 %r
}

; https://alive2.llvm.org/ce/z/YNYYdV
define i8 @and_not_shl(i8 %x) {
; CHECK-LABEL: define i8 @and_not_shl
; CHECK-SAME: (i8 [[X:%.*]]) {
; CHECK-NEXT:    [[OP1_P2:%.*]] = icmp ult i8 [[X]], 6
; CHECK-NEXT:    call void @llvm.assume(i1 [[OP1_P2]])
; CHECK-NEXT:    [[SHIFT:%.*]] = shl nsw i8 -1, [[X]]
; CHECK-NEXT:    [[NOT:%.*]] = and i8 [[SHIFT]], 32
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[NOT]], 32
; CHECK-NEXT:    ret i8 [[R]]
;
  %op1_p2 = icmp ule i8 %x, 5
  call void @llvm.assume(i1 %op1_p2)
  %shift = shl i8 -1, %x
  %not = xor i8 %shift, -1
  %r = and i8 %not, 32
  ret i8 %r
}

; Negative test: https://alive2.llvm.org/ce/z/uWzb4t
define i8 @and_add_shl_overlap(i8 %x) {
; CHECK-LABEL: define i8 @and_add_shl_overlap
; CHECK-SAME: (i8 [[X:%.*]]) {
; CHECK-NEXT:    [[OP1_P2:%.*]] = icmp ult i8 [[X]], 7
; CHECK-NEXT:    call void @llvm.assume(i1 [[OP1_P2]])
; CHECK-NEXT:    [[NOTMASK:%.*]] = shl nsw i8 -1, [[X]]
; CHECK-NEXT:    [[SUB:%.*]] = and i8 [[NOTMASK]], 32
; CHECK-NEXT:    [[R:%.*]] = xor i8 [[SUB]], 32
; CHECK-NEXT:    ret i8 [[R]]
;
  %op1_p2 = icmp ule i8 %x, 6
  call void @llvm.assume(i1 %op1_p2)
  %shift = shl i8 1, %x
  %sub = add i8 %shift, -1
  %r = and i8 %sub, 32
  ret i8 %r
}
