; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
target datalayout = "e-m:e-i64:64-n32:64"
target triple = "powerpc64le-unknown-linux-gnu"
; This file mainly tests the case that the two input registers of the ISEL instruction are the same register.
; The foldable ISEL in this test case is introduced at register coalescing stage.

; Before that stage we have:
; %vreg18<def> = ISEL8 %vreg5, %vreg2, %vreg15<undef>;

; At register coalescing stage, the register coalescer figures out it could remove the copy
; from %vreg2 to %vreg5, put the original value %X3 into %vreg5 directly
;  erased: 336r    %vreg5<def> = COPY %vreg2
;  updated: 288B   %vreg5<def> = COPY %X3;

; After that we have:
;   updated: 416B   %vreg18<def> = ISEL8 %vreg5, %vreg5, %vreg15<undef>;

; RUN: llc -verify-machineinstrs -O2 -ppc-asm-full-reg-names -mcpu=pwr7 -mattr=+isel < %s | FileCheck %s --check-prefix=CHECK-GEN-ISEL-TRUE
; RUN: llc -verify-machineinstrs -O2 -ppc-asm-full-reg-names -mcpu=pwr7 -mattr=-isel < %s | FileCheck %s --implicit-check-not isel
%"struct.pov::ot_block_struct" = type { ptr, [3 x double], [3 x double], float, float, float, float, float, float, float, float, float, [3 x float], float, float, [3 x double], i16 }
%"struct.pov::ot_node_struct" = type { %"struct.pov::ot_id_struct", ptr, [8 x ptr] }
%"struct.pov::ot_id_struct" = type { i32, i32, i32, i32 }

define void @_ZN3pov6ot_insEPPNS_14ot_node_structEPNS_15ot_block_structEPNS_12ot_id_structE(ptr %new_block) {
; CHECK-GEN-ISEL-TRUE-LABEL: _ZN3pov6ot_insEPPNS_14ot_node_structEPNS_15ot_block_structEPNS_12ot_id_structE:
; CHECK-GEN-ISEL-TRUE:       # %bb.0: # %entry
; CHECK-GEN-ISEL-TRUE-NEXT:    mflr r0
; CHECK-GEN-ISEL-TRUE-NEXT:    .cfi_def_cfa_offset 64
; CHECK-GEN-ISEL-TRUE-NEXT:    .cfi_offset lr, 16
; CHECK-GEN-ISEL-TRUE-NEXT:    .cfi_offset r29, -24
; CHECK-GEN-ISEL-TRUE-NEXT:    .cfi_offset r30, -16
; CHECK-GEN-ISEL-TRUE-NEXT:    std r29, -24(r1) # 8-byte Folded Spill
; CHECK-GEN-ISEL-TRUE-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; CHECK-GEN-ISEL-TRUE-NEXT:    stdu r1, -64(r1)
; CHECK-GEN-ISEL-TRUE-NEXT:    mr r30, r3
; CHECK-GEN-ISEL-TRUE-NEXT:    std r0, 80(r1)
; CHECK-GEN-ISEL-TRUE-NEXT:    # implicit-def: $x3
; CHECK-GEN-ISEL-TRUE-NEXT:    # implicit-def: $r29
; CHECK-GEN-ISEL-TRUE-NEXT:    b .LBB0_2
; CHECK-GEN-ISEL-TRUE-NEXT:    .p2align 4
; CHECK-GEN-ISEL-TRUE-NEXT:  .LBB0_1: # %cond.false21.i156
; CHECK-GEN-ISEL-TRUE-NEXT:    #
; CHECK-GEN-ISEL-TRUE-NEXT:    addi r4, r29, 1
; CHECK-GEN-ISEL-TRUE-NEXT:    srawi r4, r4, 1
; CHECK-GEN-ISEL-TRUE-NEXT:    addze r29, r4
; CHECK-GEN-ISEL-TRUE-NEXT:  .LBB0_2: # %while.cond11
; CHECK-GEN-ISEL-TRUE-NEXT:    #
; CHECK-GEN-ISEL-TRUE-NEXT:    lwz r4, 0(r3)
; CHECK-GEN-ISEL-TRUE-NEXT:    cmplwi r4, 0
; CHECK-GEN-ISEL-TRUE-NEXT:    beq cr0, .LBB0_5
; CHECK-GEN-ISEL-TRUE-NEXT:  # %bb.3: # %while.body21
; CHECK-GEN-ISEL-TRUE-NEXT:    #
; CHECK-GEN-ISEL-TRUE-NEXT:    bl ZN3pov10pov_callocEmmPKciS1_pov
; CHECK-GEN-ISEL-TRUE-NEXT:    nop
; CHECK-GEN-ISEL-TRUE-NEXT:    std r3, 0(r3)
; CHECK-GEN-ISEL-TRUE-NEXT:    bc 12, 4*cr5+lt, .LBB0_1
; CHECK-GEN-ISEL-TRUE-NEXT:  # %bb.4: # %cond.true18.i153
; CHECK-GEN-ISEL-TRUE-NEXT:    #
; CHECK-GEN-ISEL-TRUE-NEXT:    srwi r29, r29, 1
; CHECK-GEN-ISEL-TRUE-NEXT:    b .LBB0_2
; CHECK-GEN-ISEL-TRUE-NEXT:  .LBB0_5: # %lor.rhs
; CHECK-GEN-ISEL-TRUE-NEXT:    std r30, 16(r3)
; CHECK-GEN-ISEL-TRUE-NEXT:    addi r1, r1, 64
; CHECK-GEN-ISEL-TRUE-NEXT:    ld r0, 16(r1)
; CHECK-GEN-ISEL-TRUE-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; CHECK-GEN-ISEL-TRUE-NEXT:    ld r29, -24(r1) # 8-byte Folded Reload
; CHECK-GEN-ISEL-TRUE-NEXT:    mtlr r0
; CHECK-GEN-ISEL-TRUE-NEXT:    blr
;
; CHECK-LABEL: _ZN3pov6ot_insEPPNS_14ot_node_structEPNS_15ot_block_structEPNS_12ot_id_structE:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mflr r0
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    .cfi_offset lr, 16
; CHECK-NEXT:    .cfi_offset r29, -24
; CHECK-NEXT:    .cfi_offset r30, -16
; CHECK-NEXT:    std r29, -24(r1) # 8-byte Folded Spill
; CHECK-NEXT:    std r30, -16(r1) # 8-byte Folded Spill
; CHECK-NEXT:    stdu r1, -64(r1)
; CHECK-NEXT:    mr r30, r3
; CHECK-NEXT:    std r0, 80(r1)
; CHECK-NEXT:    # implicit-def: $x3
; CHECK-NEXT:    # implicit-def: $r29
; CHECK-NEXT:    b .LBB0_2
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  .LBB0_1: # %cond.false21.i156
; CHECK-NEXT:    #
; CHECK-NEXT:    addi r4, r29, 1
; CHECK-NEXT:    srawi r4, r4, 1
; CHECK-NEXT:    addze r29, r4
; CHECK-NEXT:  .LBB0_2: # %while.cond11
; CHECK-NEXT:    #
; CHECK-NEXT:    lwz r4, 0(r3)
; CHECK-NEXT:    cmplwi r4, 0
; CHECK-NEXT:    beq cr0, .LBB0_5
; CHECK-NEXT:  # %bb.3: # %while.body21
; CHECK-NEXT:    #
; CHECK-NEXT:    bl ZN3pov10pov_callocEmmPKciS1_pov
; CHECK-NEXT:    nop
; CHECK-NEXT:    std r3, 0(r3)
; CHECK-NEXT:    bc 12, 4*cr5+lt, .LBB0_1
; CHECK-NEXT:  # %bb.4: # %cond.true18.i153
; CHECK-NEXT:    #
; CHECK-NEXT:    srwi r29, r29, 1
; CHECK-NEXT:    b .LBB0_2
; CHECK-NEXT:  .LBB0_5: # %lor.rhs
; CHECK-NEXT:    std r30, 16(r3)
; CHECK-NEXT:    addi r1, r1, 64
; CHECK-NEXT:    ld r0, 16(r1)
; CHECK-NEXT:    ld r30, -16(r1) # 8-byte Folded Reload
; CHECK-NEXT:    ld r29, -24(r1) # 8-byte Folded Reload
; CHECK-NEXT:    mtlr r0
; CHECK-NEXT:    blr
entry:
  br label %while.cond11

while.cond11:
  %this_node.0250 = phi ptr [ undef, %entry ], [ %1, %cond.false21.i156 ], [ %1, %cond.true18.i153 ]
  %temp_id.sroa.21.1 = phi i32 [ undef, %entry ], [ %shr2039.i152, %cond.true18.i153 ], [ %div24.i155, %cond.false21.i156 ]
  %0 = load i32, ptr undef, align 4
  %cmp17 = icmp eq i32 0, %0
  br i1 %cmp17, label %lor.rhs, label %while.body21

lor.rhs:
  %Values = getelementptr inbounds %"struct.pov::ot_node_struct", ptr %this_node.0250, i64 0, i32 1
  store ptr %new_block, ptr %Values, align 8
  ret void

while.body21:
  %call.i84 = tail call ptr @ZN3pov10pov_callocEmmPKciS1_pov()
  store ptr %call.i84, ptr undef, align 8
  %1 = bitcast ptr %call.i84 to ptr
  br i1 undef, label %cond.true18.i153, label %cond.false21.i156

cond.true18.i153:
  %shr2039.i152 = lshr i32 %temp_id.sroa.21.1, 1
  br label %while.cond11

cond.false21.i156:
  %add23.i154 = add nsw i32 %temp_id.sroa.21.1, 1
  %div24.i155 = sdiv i32 %add23.i154, 2
  br label %while.cond11
}

declare ptr @ZN3pov10pov_callocEmmPKciS1_pov()
