#!/bin/sh
# /etc/postinstall/htmldoc-font-symlinks-ln.sh - symlink package fonts with PS font names

pkg=/usr/share/htmldoc/fonts
legacy=/usr/share/X11/fonts/urw-fonts

# https://adobe-type-tools.github.io/font-tech-notes/pdfs/5090.FontNameList.pdf
while read lfn psn; do
	for l in $legacy/$lfn.afm $legacy/$lfn.pfb; do
		sfx=${l#$legacy/$lfn.}
		/bin/ln -frs $l $pkg/$psn.$sfx && [ "$sfx" = "pfb" ] && \
		    [ -f $pkg/$psn.pfa ] && /bin/rm -f $pkg/$psn.pfa
	done
done < $pkg/URW-PS-FontNames

/bin/ln -frs /usr/share/fonts/dejavu/DejaVu*.ttf $pkg/

