/* do not edit automatically generated by mc from FpuIO.  */
/* FpuIO.mod implements a fixed format input/output for REAL/LONGREAL.

Copyright (C) 2001-2024 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#define _FpuIO_C

#include "GFpuIO.h"
#   include "GStrIO.h"
#   include "GStrLib.h"
#   include "GASCII.h"
#   include "GDynamicStrings.h"
#   include "GStringConvert.h"

#   define MaxLineLength 100
extern "C" void FpuIO_ReadReal (double *x);

/*
   WriteReal - converts a REAL number, x, which has a, TotalWidth, and
               FractionWidth into, string, a.
*/

extern "C" void FpuIO_WriteReal (double x, unsigned int TotalWidth, unsigned int FractionWidth);

/*
   WriteReal - converts a REAL number, x, which has a, TotalWidth, and
               FractionWidth into, string, a.
*/

extern "C" void FpuIO_StrToReal (const char *a_, unsigned int _a_high, double *x);

/*
   RealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
               FractionWidth into a string.
*/

extern "C" void FpuIO_RealToStr (double x, unsigned int TotalWidth, unsigned int FractionWidth, char *a, unsigned int _a_high);
extern "C" void FpuIO_ReadLongReal (long double *x);

/*
   WriteLongReal - converts a LONGREAL number, x, which has a, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_WriteLongReal (long double x, unsigned int TotalWidth, unsigned int FractionWidth);

/*
   WriteLongReal - converts a LONGREAL number, x, which has a, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_StrToLongReal (const char *a_, unsigned int _a_high, long double *x);

/*
   LongRealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_LongRealToStr (long double x, unsigned int TotalWidth, unsigned int FractionWidth, char *a, unsigned int _a_high);

/*
   LongRealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_ReadLongInt (long int *x);

/*
   LongRealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_WriteLongInt (long int x, unsigned int n);

/*
   LongRealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_StrToLongInt (const char *a_, unsigned int _a_high, long int *x);

/*
   LongRealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_LongIntToStr (long int x, unsigned int n, char *a, unsigned int _a_high);

extern "C" void FpuIO_ReadReal (double *x)
{
  typedef struct ReadReal__T1_a ReadReal__T1;

  struct ReadReal__T1_a { char array[MaxLineLength+1]; };
  ReadReal__T1 a;

  /*
#undef GM2_DEBUG_FPUIO
if defined(GM2_DEBUG_FPUIO)
#  define InitString(X) InitStringDB(X, __FILE__, __LINE__)
#  define InitStringCharStar(X) InitStringCharStarDB(X, __FILE__, __LINE__)
#  define InitStringChar(X) InitStringCharDB(X, __FILE__, __LINE__)
#  define Mult(X,Y) MultDB(X, Y, __FILE__, __LINE__)
#  define Dup(X) DupDB(X, __FILE__, __LINE__)
#  define Slice(X,Y,Z) SliceDB(X, Y, Z, __FILE__, __LINE__)
#endif
  */
  StrIO_ReadString ((char *) &a.array[0], MaxLineLength);
  FpuIO_StrToReal ((const char *) &a.array[0], MaxLineLength, x);
}


/*
   WriteReal - converts a REAL number, x, which has a, TotalWidth, and
               FractionWidth into, string, a.
*/

extern "C" void FpuIO_WriteReal (double x, unsigned int TotalWidth, unsigned int FractionWidth)
{
  typedef struct WriteReal__T2_a WriteReal__T2;

  struct WriteReal__T2_a { char array[MaxLineLength+1]; };
  WriteReal__T2 a;

  FpuIO_RealToStr (x, TotalWidth, FractionWidth, (char *) &a.array[0], MaxLineLength);
  StrIO_WriteString ((const char *) &a.array[0], MaxLineLength);
}


/*
   WriteReal - converts a REAL number, x, which has a, TotalWidth, and
               FractionWidth into, string, a.
*/

extern "C" void FpuIO_StrToReal (const char *a_, unsigned int _a_high, double *x)
{
  long double lr;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  FpuIO_StrToLongReal ((const char *) a, _a_high, &lr);  /* let StrToLongReal do the work and we convert the result back to REAL  */
  (*x) = (double ) (lr);  /* let StrToLongReal do the work and we convert the result back to REAL  */
}


/*
   RealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
               FractionWidth into a string.
*/

extern "C" void FpuIO_RealToStr (double x, unsigned int TotalWidth, unsigned int FractionWidth, char *a, unsigned int _a_high)
{
  long double lr;

  lr = (long double ) (x);
  FpuIO_LongRealToStr (lr, TotalWidth, FractionWidth, (char *) a, _a_high);
}

extern "C" void FpuIO_ReadLongReal (long double *x)
{
  typedef struct ReadLongReal__T3_a ReadLongReal__T3;

  struct ReadLongReal__T3_a { char array[MaxLineLength+1]; };
  ReadLongReal__T3 a;

  StrIO_ReadString ((char *) &a.array[0], MaxLineLength);
  FpuIO_StrToLongReal ((const char *) &a.array[0], MaxLineLength, x);
}


/*
   WriteLongReal - converts a LONGREAL number, x, which has a, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_WriteLongReal (long double x, unsigned int TotalWidth, unsigned int FractionWidth)
{
  typedef struct WriteLongReal__T4_a WriteLongReal__T4;

  struct WriteLongReal__T4_a { char array[MaxLineLength+1]; };
  WriteLongReal__T4 a;

  FpuIO_LongRealToStr (x, TotalWidth, FractionWidth, (char *) &a.array[0], MaxLineLength);
  StrIO_WriteString ((const char *) &a.array[0], MaxLineLength);
}


/*
   WriteLongReal - converts a LONGREAL number, x, which has a, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_StrToLongReal (const char *a_, unsigned int _a_high, long double *x)
{
  bool found;
  DynamicStrings_String s;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  s = DynamicStrings_InitString ((const char *) a, _a_high);
  (*x) = StringConvert_StringToLongreal (s, &found);
  s = DynamicStrings_KillString (s);
}


/*
   LongRealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_LongRealToStr (long double x, unsigned int TotalWidth, unsigned int FractionWidth, char *a, unsigned int _a_high)
{
  DynamicStrings_String s;

  s = StringConvert_LongrealToString (x, TotalWidth, FractionWidth);
  DynamicStrings_CopyOut ((char *) a, _a_high, s);
  s = DynamicStrings_KillString (s);
}


/*
   LongRealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_ReadLongInt (long int *x)
{
  typedef struct ReadLongInt__T5_a ReadLongInt__T5;

  struct ReadLongInt__T5_a { char array[MaxLineLength+1]; };
  ReadLongInt__T5 a;

  StrIO_ReadString ((char *) &a.array[0], MaxLineLength);
  FpuIO_StrToLongInt ((const char *) &a.array[0], MaxLineLength, x);
}


/*
   LongRealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_WriteLongInt (long int x, unsigned int n)
{
  typedef struct WriteLongInt__T6_a WriteLongInt__T6;

  struct WriteLongInt__T6_a { char array[MaxLineLength+1]; };
  WriteLongInt__T6 a;

  FpuIO_LongIntToStr (x, n, (char *) &a.array[0], MaxLineLength);
  StrIO_WriteString ((const char *) &a.array[0], MaxLineLength);
}


/*
   LongRealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_StrToLongInt (const char *a_, unsigned int _a_high, long int *x)
{
  DynamicStrings_String s;
  bool found;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  s = DynamicStrings_InitString ((const char *) a, _a_high);
  (*x) = StringConvert_StringToLongInteger (s, 10, &found);
  s = DynamicStrings_KillString (s);
}


/*
   LongRealToStr - converts a LONGREAL number, Real, which has, TotalWidth, and
                   FractionWidth into a string.
*/

extern "C" void FpuIO_LongIntToStr (long int x, unsigned int n, char *a, unsigned int _a_high)
{
  DynamicStrings_String s;

  s = StringConvert_LongIntegerToString (x, n, ' ', false, 10, true);
  DynamicStrings_CopyOut ((char *) a, _a_high, s);
  s = DynamicStrings_KillString (s);
}

extern "C" void _M2_FpuIO_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_FpuIO_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
