#! /bin/sh

dirs=
dry_run=no

usage() {
    echo "Usage: emacs_ephemeral_rebase.sh [--dry-run] [dir] [dir] ..."
}

while [ $# -gt 0 ]
do
    case "$1" in
	--dry-run)
	    dry_run=yes
	    ;;
	-h|--help)
	    usage
	    exit 127
	    ;;
	*)
	    dirs+=" $1"
	    ;;
    esac
    shift
done

if [ -z "${dirs}" ]
then
    dirs="${HOME}/.emacs.d/eln-cache"
fi

if [ ${dry_run} = "yes" ]
then
    echo "The following files would be rebased:"
    find ${dirs} -name '*.eln'
else
    find ${dirs} -name '*.eln' | rebase -O -T -
fi
