#include <string.h>
#include <version.h>

/* - On some systems git is not installed or
 *   installed on a place where FindGit.cmake cannot find it
 * - No git information is present (no .git directory)
 * in those cases clear the gitVersionString (would have string GIT-NOTFOUND).
 */
std::string getGitVersion()
{
  static std::string gitVersion;
  static bool init = false;
  if (!init)
  {
    gitVersion = "28ba8143ecb6fc4ce0f0218e36bf33b51b57c2c2";
    if (std::string("false")=="true")
    {
      gitVersion+="*";
    }
    if (gitVersion=="GIT_NOTFOUND")
    {
      gitVersion="";
    }
    init = true;
  }
  return gitVersion;
}
