/* monitor.c generated by valac 0.30.2, the Vala compiler
 * generated from monitor.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include "deja.h"
#include <libnotify/notify.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;
typedef struct _MonitorPrivate MonitorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MonitorIsReadyData MonitorIsReadyData;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MonitorKickoffData MonitorKickoffData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Monitor {
	GObject parent_instance;
	MonitorPrivate * priv;
};

struct _MonitorClass {
	GObjectClass parent_class;
};

struct _MonitorIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* when;
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp3_;
	DejaDupBackend* _tmp4_;
	DejaDupBackend* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
};

struct _MonitorKickoffData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GTimeSpan wait_time;
	GTimeSpan _tmp0_;
	gboolean _tmp1_;
	GTimeSpan _tmp2_;
	gboolean was_reactive;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gchar* when;
	gboolean ready;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	NotifyNotification* _tmp13_;
	NotifyNotification* _tmp14_;
	GError* e2;
	GError* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	GPid _tmp18_;
	gboolean _tmp19_;
	gchar* command;
	gchar* _tmp20_;
	gchar** argv;
	const gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint argv_length1;
	gint _argv_size_;
	gboolean _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	GPid _tmp26_;
	GPid _tmp27_;
	GError* e;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
};


static gpointer monitor_parent_class = NULL;
static guint monitor_timeout_id;
static guint monitor_timeout_id = 0U;
static guint monitor_netcheck_id;
static guint monitor_netcheck_id = 0U;
static GPid monitor_pid;
static GPid monitor_pid = 0;
static gboolean monitor_op_active;
static gboolean monitor_op_active = FALSE;
static gboolean monitor_reactive_check;
static gboolean monitor_reactive_check = FALSE;
static gboolean monitor_first_check;
static gboolean monitor_first_check = FALSE;
static DejaDupFilteredSettings* monitor_settings;
static DejaDupFilteredSettings* monitor_settings = NULL;
static gboolean monitor_testing_delay;
static gboolean monitor_testing_delay = TRUE;
static gboolean monitor_show_version;
static gboolean monitor_show_version = FALSE;
static NotifyNotification* monitor_note;
static NotifyNotification* monitor_note = NULL;

GType monitor_get_type (void) G_GNUC_CONST;
enum  {
	MONITOR_DUMMY_PROPERTY
};
static void monitor_op_started (GDBusConnection* conn, const gchar* name, const gchar* name_owner);
static void monitor_op_ended (GDBusConnection* conn, const gchar* name);
static gboolean monitor_network_check (void);
static void monitor_prepare_next_run (void);
static void monitor_network_changed (void);
static gboolean _monitor_network_check_gsource_func (gpointer self);
static void monitor_volume_added (GVolumeMonitor* vm, GVolume* vol);
static void monitor_is_ready_data_free (gpointer _data);
static void monitor_is_ready (GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean monitor_is_ready_finish (GAsyncResult* _res_, gchar** when);
static gboolean monitor_is_ready_co (MonitorIsReadyData* _data_);
static void monitor_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean monitor_handle_options (gint* status);
static GTimeSpan monitor_time_until (GDateTime* date);
static void monitor_close_pid (GPid child_pid, gint status);
static void monitor_notify_delay (const gchar* header, const gchar* reason);
static void ___lambda5_ (NotifyNotification* n);
static void ____lambda5__notify_notification_closed (NotifyNotification* _sender, gpointer self);
static void monitor_kickoff_data_free (gpointer _data);
static void monitor_kickoff (GAsyncReadyCallback _callback_, gpointer _user_data_);
static void monitor_kickoff_finish (GAsyncResult* _res_);
static gboolean monitor_kickoff_co (MonitorKickoffData* _data_);
static gboolean monitor_time_until_next_run (GTimeSpan* time);
static void monitor_prepare_tomorrow (void);
static void monitor_kickoff_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self);
static void monitor_prepare_run (GTimeSpan wait_time);
static gboolean ___lambda4_ (void);
static gboolean ____lambda4__gsource_func (gpointer self);
static void monitor_prepare_if_necessary (const gchar* key);
static void monitor_make_first_check (void);
static gboolean __lambda6_ (void);
static gboolean ___lambda6__gsource_func (gpointer self);
static void monitor_watch_settings (void);
static void _monitor_prepare_if_necessary_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void monitor_begin_monitoring (void);
static void _monitor_network_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _monitor_op_started_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void _monitor_op_ended_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _monitor_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static gboolean ___lambda7_ (void);
static gboolean ____lambda7__gsource_func (gpointer self);
static gint monitor_main (gchar** args, int args_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block1Data* _data1_);
static void __lambda9_ (void);
static void ___lambda9__gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda10_ (void);
static void ___lambda10__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda11_ (Block1Data* _data1_);
static void ___lambda11__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static gboolean ___lambda8__gsource_func (gpointer self);
Monitor* monitor_new (void);
Monitor* monitor_construct (GType object_type);
static void monitor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry MONITOR_options[2] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &monitor_show_version, "Show version", NULL}, {NULL}};

static void monitor_op_started (GDBusConnection* conn, const gchar* name, const gchar* name_owner) {
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	monitor_op_active = TRUE;
}


static void monitor_op_ended (GDBusConnection* conn, const gchar* name) {
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	monitor_op_active = FALSE;
}


static gboolean monitor_network_check (void) {
	gboolean result = FALSE;
	DejaDupNetwork* _tmp0_ = NULL;
	DejaDupNetwork* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	monitor_reactive_check = TRUE;
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_network_get_connected (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		monitor_prepare_next_run ();
	}
	monitor_reactive_check = FALSE;
	result = FALSE;
	return result;
}


static gboolean _monitor_network_check_gsource_func (gpointer self) {
	gboolean result;
	result = monitor_network_check ();
	return result;
}


static void monitor_network_changed (void) {
	guint _tmp0_ = 0U;
	DejaDupNetwork* _tmp2_ = NULL;
	DejaDupNetwork* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	_tmp0_ = monitor_netcheck_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = monitor_netcheck_id;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = deja_dup_network_get ();
	_tmp3_ = _tmp2_;
	_tmp4_ = deja_dup_network_get_connected (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	if (_tmp6_) {
		guint _tmp7_ = 0U;
		_tmp7_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 120, _monitor_network_check_gsource_func, NULL, NULL);
		monitor_netcheck_id = _tmp7_;
	}
}


static void monitor_volume_added (GVolumeMonitor* vm, GVolume* vol) {
	g_return_if_fail (vm != NULL);
	g_return_if_fail (vol != NULL);
	monitor_reactive_check = TRUE;
	monitor_prepare_next_run ();
	monitor_reactive_check = FALSE;
}


static void monitor_is_ready_data_free (gpointer _data) {
	MonitorIsReadyData* _data_;
	_data_ = _data;
	g_slice_free (MonitorIsReadyData, _data_);
}


static void monitor_is_ready (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MonitorIsReadyData* _data_;
	_data_ = g_slice_new0 (MonitorIsReadyData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, monitor_is_ready);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, monitor_is_ready_data_free);
	monitor_is_ready_co (_data_);
}


static gboolean monitor_is_ready_finish (GAsyncResult* _res_, gchar** when) {
	gboolean result;
	MonitorIsReadyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (when) {
		*when = _data_->when;
	} else {
		_g_free0 (_data_->when);
	}
	_data_->when = NULL;
	result = _data_->result;
	return result;
}


static void monitor_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MonitorIsReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	monitor_is_ready_co (_data_);
}


static gboolean monitor_is_ready_co (MonitorIsReadyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = deja_dup_in_testing_mode ();
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = monitor_testing_delay;
		_data_->_tmp0_ = _data_->_tmp2_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		monitor_testing_delay = FALSE;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_strdup ("Testing");
		_g_free0 (_data_->when);
		_data_->when = _data_->_tmp3_;
		_data_->result = FALSE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = deja_dup_backend_get_default ();
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_state_ = 1;
	deja_dup_backend_is_ready (_data_->_tmp5_, monitor_is_ready_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = deja_dup_backend_is_ready_finish (_data_->_tmp5_, _data_->_res_, &_data_->_tmp6_);
	_g_free0 (_data_->when);
	_data_->when = _data_->_tmp6_;
	_data_->_tmp8_ = FALSE;
	_data_->_tmp8_ = _data_->_tmp7_;
	_g_object_unref0 (_data_->_tmp5_);
	_data_->result = _data_->_tmp8_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean monitor_handle_options (gint* status) {
	gint _vala_status = 0;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	_vala_status = 0;
	_tmp0_ = monitor_show_version;
	if (_tmp0_) {
		g_print ("%s %s\n", "deja-dup-monitor", VERSION);
		result = FALSE;
		if (status) {
			*status = _vala_status;
		}
		return result;
	}
	result = TRUE;
	if (status) {
		*status = _vala_status;
	}
	return result;
}


static GTimeSpan monitor_time_until (GDateTime* date) {
	GTimeSpan result = 0LL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GTimeSpan _tmp3_ = 0LL;
	GTimeSpan _tmp4_ = 0LL;
	g_return_val_if_fail (date != NULL, 0LL);
	_tmp0_ = date;
	_tmp1_ = g_date_time_new_now_local ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_date_time_difference (_tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_date_time_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static void monitor_close_pid (GPid child_pid, gint status) {
	GPid _tmp0_ = 0;
	_tmp0_ = child_pid;
	g_spawn_close_pid (_tmp0_);
	monitor_pid = (GPid) 0;
}


static void ___lambda5_ (NotifyNotification* n) {
	g_return_if_fail (n != NULL);
	_g_object_unref0 (monitor_note);
	monitor_note = NULL;
}


static void ____lambda5__notify_notification_closed (NotifyNotification* _sender, gpointer self) {
	___lambda5_ (_sender);
}


static void monitor_notify_delay (const gchar* header, const gchar* reason) {
	NotifyNotification* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (header != NULL);
	g_return_if_fail (reason != NULL);
	_tmp0_ = monitor_note;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		NotifyNotification* _tmp4_ = NULL;
		NotifyNotification* _tmp5_ = NULL;
		NotifyNotification* _tmp6_ = NULL;
		_tmp1_ = _ ("Backups");
		notify_init (_tmp1_);
		_tmp2_ = header;
		_tmp3_ = reason;
		_tmp4_ = notify_notification_new (_tmp2_, _tmp3_, "deja-dup");
		_g_object_unref0 (monitor_note);
		monitor_note = _tmp4_;
		_tmp5_ = monitor_note;
		notify_notification_set_hint_string (_tmp5_, "desktop-entry", "deja-dup");
		_tmp6_ = monitor_note;
		g_signal_connect (_tmp6_, "closed", (GCallback) ____lambda5__notify_notification_closed, NULL);
	} else {
		NotifyNotification* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp7_ = monitor_note;
		_tmp8_ = header;
		_tmp9_ = reason;
		notify_notification_update (_tmp7_, _tmp8_, _tmp9_, "deja-dup");
	}
	{
		NotifyNotification* _tmp10_ = NULL;
		_tmp10_ = monitor_note;
		notify_notification_show (_tmp10_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("monitor.vala:130: %s\n", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void monitor_kickoff_data_free (gpointer _data) {
	MonitorKickoffData* _data_;
	_data_ = _data;
	g_slice_free (MonitorKickoffData, _data_);
}


static void monitor_kickoff (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MonitorKickoffData* _data_;
	_data_ = g_slice_new0 (MonitorKickoffData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, monitor_kickoff);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, monitor_kickoff_data_free);
	monitor_kickoff_co (_data_);
}


static void monitor_kickoff_finish (GAsyncResult* _res_) {
	MonitorKickoffData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void monitor_kickoff_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MonitorKickoffData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	monitor_kickoff_co (_data_);
}


static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self) {
	monitor_close_pid (pid, status);
}


static gboolean monitor_kickoff_co (MonitorKickoffData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0LL;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = monitor_time_until_next_run (&_data_->_tmp0_);
	_data_->wait_time = _data_->_tmp0_;
	if (!_data_->_tmp1_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = 0LL;
	_data_->_tmp2_ = _data_->wait_time;
	if (_data_->_tmp2_ > ((GTimeSpan) 0)) {
		monitor_prepare_next_run ();
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = monitor_reactive_check;
	_data_->was_reactive = _data_->_tmp3_;
	_data_->_tmp4_ = FALSE;
	_data_->_tmp4_ = _data_->was_reactive;
	if (!_data_->_tmp4_) {
		monitor_prepare_tomorrow ();
	}
	_data_->_tmp5_ = NULL;
	_data_->_state_ = 1;
	monitor_is_ready (monitor_kickoff_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = monitor_is_ready_finish (_data_->_res_, &_data_->_tmp5_);
	_g_free0 (_data_->when);
	_data_->when = _data_->_tmp5_;
	_data_->ready = _data_->_tmp6_;
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = _data_->ready;
	if (!_data_->_tmp7_) {
		g_debug ("monitor.vala:159: Postponing the backup.");
		_data_->_tmp9_ = FALSE;
		_data_->_tmp9_ = _data_->was_reactive;
		if (!_data_->_tmp9_) {
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->when;
			_data_->_tmp8_ = _data_->_tmp10_ != NULL;
		} else {
			_data_->_tmp8_ = FALSE;
		}
		if (_data_->_tmp8_) {
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _ ("Scheduled backup delayed");
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->when;
			monitor_notify_delay (_data_->_tmp11_, _data_->_tmp12_);
		}
		_g_free0 (_data_->when);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = monitor_note;
	if (_data_->_tmp13_ != NULL) {
		{
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = monitor_note;
			notify_notification_close (_data_->_tmp14_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->e2;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			g_warning ("monitor.vala:170: %s\n", _data_->_tmp16_);
			_g_error_free0 (_data_->e2);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->when);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (monitor_note);
		monitor_note = NULL;
	}
	_data_->_tmp18_ = 0;
	_data_->_tmp18_ = monitor_pid;
	if (_data_->_tmp18_ == ((GPid) 0)) {
		_data_->_tmp19_ = FALSE;
		_data_->_tmp19_ = monitor_op_active;
		_data_->_tmp17_ = !_data_->_tmp19_;
	} else {
		_data_->_tmp17_ = FALSE;
	}
	if (_data_->_tmp17_) {
		{
			g_debug ("monitor.vala:178: Running automatic backup.");
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = deja_dup_nice_prefix ("deja-dup --backup --auto");
			_data_->command = _data_->_tmp20_;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->command;
			_data_->_tmp22_ = NULL;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->_tmp22_ = g_strsplit (_data_->_tmp21_, " ", 0);
			_data_->argv_length1 = 0;
			_data_->_argv_size_ = 0;
			_data_->argv = _data_->_tmp23_;
			_data_->argv_length1 = _vala_array_length (_data_->_tmp22_);
			_data_->_argv_size_ = _data_->argv_length1;
			_data_->_tmp24_ = FALSE;
			_data_->_tmp24_ = deja_dup_in_testing_mode ();
			if (_data_->_tmp24_) {
				deja_dup_update_last_run_timestamp (DEJA_DUP_TIMESTAMP_TYPE_BACKUP);
			} else {
				_data_->_tmp25_ = NULL;
				_data_->_tmp25__length1 = 0;
				_data_->_tmp25_ = _data_->argv;
				_data_->_tmp25__length1 = _data_->argv_length1;
				_data_->_tmp26_ = 0;
				g_spawn_async (NULL, _data_->_tmp25_, NULL, ((G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_STDOUT_TO_DEV_NULL) | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_data_->_tmp26_, &_data_->_inner_error_);
				monitor_pid = _data_->_tmp26_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->command);
					goto __catch2_g_error;
				}
				_data_->_tmp27_ = 0;
				_data_->_tmp27_ = monitor_pid;
				g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _data_->_tmp27_, _monitor_close_pid_gchild_watch_func, NULL, NULL);
			}
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->command);
		}
		goto __finally2;
		__catch2_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _data_->e;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->_tmp28_->message;
			g_warning ("monitor.vala:197: %s\n", _data_->_tmp29_);
			_g_error_free0 (_data_->e);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->when);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	} else {
		g_debug ("monitor.vala:201: Not rerunning deja-dup, already doing so.");
	}
	_g_free0 (_data_->when);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean monitor_time_until_next_run (GTimeSpan* time) {
	GTimeSpan _vala_time = 0LL;
	gboolean result = FALSE;
	GDateTime* next_date = NULL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	GTimeSpan _tmp3_ = 0LL;
	_vala_time = (GTimeSpan) 0;
	_tmp0_ = deja_dup_next_run_date ();
	next_date = _tmp0_;
	_tmp1_ = next_date;
	if (_tmp1_ == NULL) {
		g_debug ("monitor.vala:210: Automatic backups disabled.  Not scheduling a backup" \
".");
		result = FALSE;
		_g_date_time_unref0 (next_date);
		if (time) {
			*time = _vala_time;
		}
		return result;
	}
	_tmp2_ = next_date;
	_tmp3_ = monitor_time_until (_tmp2_);
	_vala_time = _tmp3_;
	result = TRUE;
	_g_date_time_unref0 (next_date);
	if (time) {
		*time = _vala_time;
	}
	return result;
}


static gboolean ___lambda4_ (void) {
	gboolean result = FALSE;
	monitor_kickoff (NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ();
	return result;
}


static void monitor_prepare_run (GTimeSpan wait_time) {
	guint _tmp0_ = 0U;
	GTimeSpan secs = 0LL;
	GTimeSpan _tmp2_ = 0LL;
	gboolean _tmp3_ = FALSE;
	GTimeSpan _tmp4_ = 0LL;
	_tmp0_ = monitor_timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = monitor_timeout_id;
		g_source_remove (_tmp1_);
		monitor_timeout_id = (guint) 0;
	}
	_tmp2_ = wait_time;
	secs = (_tmp2_ / G_TIME_SPAN_SECOND) + 1;
	_tmp4_ = wait_time;
	if (_tmp4_ > ((GTimeSpan) 0)) {
		GTimeSpan _tmp5_ = 0LL;
		_tmp5_ = secs;
		_tmp3_ = _tmp5_ > ((GTimeSpan) 0);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GTimeSpan _tmp6_ = 0LL;
		GTimeSpan _tmp7_ = 0LL;
		guint _tmp8_ = 0U;
		_tmp6_ = secs;
		g_debug ("monitor.vala:228: Waiting %ld seconds until next backup.", (glong) _tmp6_);
		_tmp7_ = secs;
		_tmp8_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp7_, ____lambda4__gsource_func, NULL, NULL);
		monitor_timeout_id = _tmp8_;
	} else {
		GTimeSpan _tmp9_ = 0LL;
		_tmp9_ = secs;
		g_debug ("monitor.vala:235: Late by %ld seconds.  Backing up now.", (glong) (_tmp9_ * -1));
		monitor_kickoff (NULL, NULL);
	}
}


static void monitor_prepare_tomorrow (void) {
	GDateTime* now = NULL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* tomorrow = NULL;
	GTimeSpan _tmp1_ = 0LL;
	GDateTime* _tmp2_ = NULL;
	GTimeSpan time = 0LL;
	GTimeSpan _tmp3_ = 0LL;
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = deja_dup_get_day ();
	_tmp2_ = g_date_time_add (now, _tmp1_);
	tomorrow = _tmp2_;
	_tmp3_ = monitor_time_until (tomorrow);
	time = _tmp3_;
	monitor_prepare_run (time);
	_g_date_time_unref0 (tomorrow);
	_g_date_time_unref0 (now);
}


static void monitor_prepare_next_run (void) {
	gboolean _tmp0_ = FALSE;
	GTimeSpan wait_time = 0LL;
	GTimeSpan _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	GTimeSpan _tmp3_ = 0LL;
	_tmp0_ = monitor_first_check;
	if (!_tmp0_) {
		return;
	}
	_tmp2_ = monitor_time_until_next_run (&_tmp1_);
	wait_time = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = wait_time;
	monitor_prepare_run (_tmp3_);
}


static void monitor_prepare_if_necessary (const gchar* key) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (key != NULL);
	_tmp2_ = key;
	if (g_strcmp0 (_tmp2_, DEJA_DUP_LAST_BACKUP_KEY) == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = key;
		_tmp1_ = g_strcmp0 (_tmp3_, DEJA_DUP_PERIODIC_KEY) == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = key;
		_tmp0_ = g_strcmp0 (_tmp4_, DEJA_DUP_PERIODIC_PERIOD_KEY) == 0;
	}
	if (_tmp0_) {
		monitor_prepare_next_run ();
	}
}


static gboolean __lambda6_ (void) {
	gboolean result = FALSE;
	deja_dup_make_prompt_check ();
	result = TRUE;
	return result;
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ ();
	return result;
}


static void monitor_make_first_check (void) {
	gint _tmp0_ = 0;
	monitor_first_check = TRUE;
	deja_dup_make_prompt_check ();
	_tmp0_ = deja_dup_get_prompt_delay ();
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp0_, ___lambda6__gsource_func, NULL, NULL);
	monitor_prepare_next_run ();
}


static void _monitor_prepare_if_necessary_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	monitor_prepare_if_necessary (key);
}


static void monitor_watch_settings (void) {
	DejaDupFilteredSettings* _tmp0_ = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	_tmp0_ = deja_dup_get_settings (NULL);
	_g_object_unref0 (monitor_settings);
	monitor_settings = _tmp0_;
	_tmp1_ = monitor_settings;
	g_signal_connect ((GSettings*) _tmp1_, "changed", (GCallback) _monitor_prepare_if_necessary_g_settings_changed, NULL);
}


static void _monitor_network_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	monitor_network_changed ();
}


static void _monitor_op_started_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	monitor_op_started (connection, name, name_owner);
}


static void _monitor_op_ended_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	monitor_op_ended (connection, name);
}


static void _monitor_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	monitor_volume_added (_sender, volume);
}


static gboolean ___lambda7_ (void) {
	gboolean result = FALSE;
	monitor_make_first_check ();
	result = FALSE;
	return result;
}


static gboolean ____lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda7_ ();
	return result;
}


static void monitor_begin_monitoring (void) {
	DejaDupNetwork* _tmp0_ = NULL;
	DejaDupNetwork* _tmp1_ = NULL;
	GVolumeMonitor* mon = NULL;
	GVolumeMonitor* _tmp2_ = NULL;
	GVolumeMonitor* _tmp3_ = NULL;
	GVolumeMonitor* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	deja_dup_network_ensure_status (NULL, NULL);
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	g_signal_connect ((GObject*) _tmp1_, "notify::connected", (GCallback) _monitor_network_changed_g_object_notify, NULL);
	_g_object_unref0 (_tmp1_);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.DejaDup.Operation", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_monitor_op_started_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _monitor_op_started_gbus_name_appeared_callback, NULL, NULL)), (GClosure*) ((_monitor_op_ended_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _monitor_op_ended_gbus_name_vanished_callback, NULL, NULL)));
	_tmp2_ = g_volume_monitor_get ();
	mon = _tmp2_;
	_tmp3_ = mon;
	g_object_ref ((GObject*) _tmp3_);
	_tmp4_ = mon;
	g_signal_connect (_tmp4_, "volume-added", (GCallback) _monitor_volume_added_g_volume_monitor_volume_added, NULL);
	monitor_watch_settings ();
	_tmp5_ = deja_dup_in_testing_mode ();
	if (_tmp5_) {
		monitor_make_first_check ();
	} else {
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 120, ____lambda7__gsource_func, NULL, NULL);
	}
	_g_object_unref0 (mon);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda9_ (void) {
}


static void ___lambda9__gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda9_ ();
}


static void __lambda10_ (void) {
	monitor_begin_monitoring ();
}


static void ___lambda10__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda10_ ();
}


static void __lambda11_ (Block1Data* _data1_) {
	GMainLoop* _tmp0_ = NULL;
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}


static void ___lambda11__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda11_ (self);
}


static gboolean __lambda8_ (Block1Data* _data1_) {
	gboolean result = FALSE;
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.DejaDup.Monitor", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((___lambda9__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda9__gbus_acquired_callback, NULL, NULL)), (GClosure*) ((___lambda10__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda10__gbus_name_acquired_callback, NULL, NULL)), (GClosure*) ((___lambda11__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda11__gbus_name_lost_callback, block1_data_ref (_data1_), block1_data_unref)));
	result = FALSE;
	return result;
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ (self);
	return result;
}


static gint monitor_main (gchar** args, int args_length1) {
	gint result = 0;
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	GOptionContext* context = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	gint status = 0;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GMainLoop* _tmp12_ = NULL;
	GMainLoop* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	deja_dup_i18n_setup ();
	_tmp0_ = _ ("Backup Monitor");
	g_set_application_name (_tmp0_);
	_tmp1_ = g_option_context_new ("");
	context = _tmp1_;
	_tmp2_ = context;
	g_option_context_add_main_entries (_tmp2_, MONITOR_options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp3_ = NULL;
		_tmp3_ = context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GOptionContext* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = context;
		_tmp7_ = g_option_context_get_help (_tmp6_, TRUE, NULL);
		_tmp8_ = _tmp7_;
		g_printerr ("%s\n\n%s", _tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp10_ = monitor_handle_options (&_tmp9_);
	status = _tmp9_;
	if (!_tmp10_) {
		result = status;
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp11_ = deja_dup_initialize (NULL, NULL);
	if (!_tmp11_) {
		result = 1;
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp12_ = g_main_loop_new (NULL, FALSE);
	_data1_->loop = _tmp12_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	_tmp13_ = _data1_->loop;
	g_main_loop_run (_tmp13_);
	result = 0;
	_g_option_context_free0 (context);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return monitor_main (argv, argc);
}


Monitor* monitor_construct (GType object_type) {
	Monitor * self = NULL;
	self = (Monitor*) g_object_new (object_type, NULL);
	return self;
}


Monitor* monitor_new (void) {
	return monitor_construct (TYPE_MONITOR);
}


static void monitor_class_init (MonitorClass * klass) {
	monitor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = monitor_finalize;
}


static void monitor_instance_init (Monitor * self) {
}


static void monitor_finalize (GObject* obj) {
	Monitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MONITOR, Monitor);
	G_OBJECT_CLASS (monitor_parent_class)->finalize (obj);
}


GType monitor_get_type (void) {
	static volatile gsize monitor_type_id__volatile = 0;
	if (g_once_init_enter (&monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Monitor), 0, (GInstanceInitFunc) monitor_instance_init, NULL };
		GType monitor_type_id;
		monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "Monitor", &g_define_type_info, 0);
		g_once_init_leave (&monitor_type_id__volatile, monitor_type_id);
	}
	return monitor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



