/* Prompt.c generated by valac 0.30.2, the Vala compiler
 * generated from Prompt.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "deja.h"
#include "widgets.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <libnotify/notify.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Block4Data {
	int _ref_count_;
	NotifyNotification* note;
};



GtkWindow* prompt (void);
void show_prompt_notification (void);
GtkWindow* show_prompt_dialog (void);
gchar* get_header (void);
gchar* get_body (void);
gchar* get_cancel_button (gboolean mnemonics);
gchar* get_ok_button (gboolean mnemonics);
void cancel (void);
void ok (void);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda40_ (Block4Data* _data4_);
static void ___lambda40__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void __lambda41_ (Block4Data* _data4_);
static void ___lambda41__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void __lambda42_ (GtkDialog* dlg, gint resp);
static void ___lambda42__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);


GtkWindow* prompt (void) {
	GtkWindow* result = NULL;
	DejaDupShellEnv _tmp0_ = 0;
	deja_dup_update_prompt_time (FALSE);
	_tmp0_ = deja_dup_get_shell ();
	if (_tmp0_ == DEJA_DUP_SHELL_ENV_GNOME) {
		show_prompt_notification ();
		result = NULL;
		return result;
	} else {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = show_prompt_dialog ();
		result = _tmp1_;
		return result;
	}
}


gchar* get_header (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = _ ("Keep your files safe by backing up regularly");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* get_body (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = _ ("Important documents, data, and settings can be protected by storing th" \
"em in a backup. In the case of a disaster, you would be able to recove" \
"r them from that backup.");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* get_cancel_button (gboolean mnemonics) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	_tmp0_ = mnemonics;
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = _ ("_Don't Show Again");
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = _ ("Don't Show Again");
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
}


gchar* get_ok_button (gboolean mnemonics) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	_tmp0_ = mnemonics;
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = _ ("_Open Backup Settings");
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = _ ("Open Backup Settings");
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
}


void cancel (void) {
	deja_dup_update_prompt_time (TRUE);
}


void ok (void) {
	GDesktopAppInfo* app = NULL;
	GDesktopAppInfo* _tmp0_ = NULL;
	GDesktopAppInfo* _tmp1_ = NULL;
	GDesktopAppInfo* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	deja_dup_update_prompt_time (TRUE);
	_tmp0_ = g_desktop_app_info_new ("unity-deja-dup-panel.desktop");
	app = _tmp0_;
	_tmp1_ = app;
	if (_tmp1_ != NULL) {
		{
			GDesktopAppInfo* _tmp2_ = NULL;
			GdkScreen* _tmp3_ = NULL;
			GdkDisplay* _tmp4_ = NULL;
			GdkAppLaunchContext* _tmp5_ = NULL;
			GdkAppLaunchContext* _tmp6_ = NULL;
			_tmp2_ = app;
			_tmp3_ = gdk_screen_get_default ();
			_tmp4_ = gdk_screen_get_display (_tmp3_);
			_tmp5_ = gdk_display_get_app_launch_context (_tmp4_);
			_tmp6_ = _tmp5_;
			g_app_info_launch ((GAppInfo*) _tmp2_, NULL, (GAppLaunchContext*) _tmp6_, &_inner_error_);
			_g_object_unref0 (_tmp6_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch6_g_error;
			}
			_g_object_unref0 (app);
			return;
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally6:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (app);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp7_ = g_desktop_app_info_new ("deja-dup-preferences.desktop");
	_g_object_unref0 (app);
	app = _tmp7_;
	{
		GDesktopAppInfo* _tmp8_ = NULL;
		GdkScreen* _tmp9_ = NULL;
		GdkDisplay* _tmp10_ = NULL;
		GdkAppLaunchContext* _tmp11_ = NULL;
		GdkAppLaunchContext* _tmp12_ = NULL;
		_tmp8_ = app;
		_tmp9_ = gdk_screen_get_default ();
		_tmp10_ = gdk_screen_get_display (_tmp9_);
		_tmp11_ = gdk_display_get_app_launch_context (_tmp10_);
		_tmp12_ = _tmp11_;
		g_app_info_launch ((GAppInfo*) _tmp8_, NULL, (GAppLaunchContext*) _tmp12_, &_inner_error_);
		_g_object_unref0 (_tmp12_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("Prompt.vala:87: %s\n", _tmp14_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (app);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->note);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda40_ (Block4Data* _data4_) {
	GError * _inner_error_ = NULL;
	cancel ();
	{
		notify_notification_close (_data4_->note, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("Prompt.vala:102: %s\n", _tmp1_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda40__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	__lambda40_ (self);
}


static void __lambda41_ (Block4Data* _data4_) {
	GError * _inner_error_ = NULL;
	ok ();
	{
		notify_notification_close (_data4_->note, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("Prompt.vala:111: %s\n", _tmp1_);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda41__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	__lambda41_ (self);
}


void show_prompt_notification (void) {
	Block4Data* _data4_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	NotifyNotification* _tmp5_ = NULL;
	NotifyNotification* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = _ ("Backups");
	notify_init (_tmp0_);
	_tmp1_ = get_header ();
	_tmp2_ = _tmp1_;
	_tmp3_ = get_body ();
	_tmp4_ = _tmp3_;
	_tmp5_ = notify_notification_new (_tmp2_, _tmp4_, "deja-dup");
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_data4_->note = _tmp6_;
	notify_notification_set_hint_string (_data4_->note, "desktop-entry", "deja-dup");
	_tmp7_ = get_cancel_button (FALSE);
	_tmp8_ = _tmp7_;
	notify_notification_add_action (_data4_->note, "cancel", _tmp8_, ___lambda40__notify_action_callback, block4_data_ref (_data4_), block4_data_unref);
	_g_free0 (_tmp8_);
	_tmp9_ = get_ok_button (FALSE);
	_tmp10_ = _tmp9_;
	notify_notification_add_action (_data4_->note, "ok", _tmp10_, ___lambda41__notify_action_callback, block4_data_ref (_data4_), block4_data_unref);
	_g_free0 (_tmp10_);
	{
		notify_notification_show (_data4_->note, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("Prompt.vala:118: %s\n", _tmp12_);
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static void __lambda42_ (GtkDialog* dlg, gint resp) {
	gint _tmp0_ = 0;
	GtkDialog* _tmp2_ = NULL;
	g_return_if_fail (dlg != NULL);
	_tmp0_ = resp;
	if (_tmp0_ == ((gint) GTK_RESPONSE_REJECT)) {
		cancel ();
	} else {
		gint _tmp1_ = 0;
		_tmp1_ = resp;
		if (_tmp1_ == ((gint) GTK_RESPONSE_ACCEPT)) {
			ok ();
		}
	}
	_tmp2_ = dlg;
	deja_dup_destroy_widget ((GtkWidget*) _tmp2_);
}


static void ___lambda42__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda42_ (_sender, response_id);
}


GtkWindow* show_prompt_dialog (void) {
	GtkWindow* result = NULL;
	GtkMessageDialog* dlg = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GtkImage* img = NULL;
	GtkImage* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	_tmp0_ = get_header ();
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "%s", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	dlg = _tmp3_;
	_tmp4_ = get_body ();
	_tmp5_ = _tmp4_;
	gtk_message_dialog_format_secondary_text (dlg, "%s", _tmp5_);
	_g_free0 (_tmp5_);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) dlg, FALSE);
	_tmp6_ = _ ("Backups");
	gtk_window_set_title ((GtkWindow*) dlg, _tmp6_);
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("deja-dup", GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp7_);
	img = _tmp7_;
	g_object_set ((GtkMisc*) img, "yalign", 0.0f, NULL);
	gtk_widget_show ((GtkWidget*) img);
	gtk_message_dialog_set_image (dlg, (GtkWidget*) img);
	_tmp8_ = get_cancel_button (TRUE);
	_tmp9_ = _tmp8_;
	_tmp10_ = get_ok_button (TRUE);
	_tmp11_ = _tmp10_;
	gtk_dialog_add_buttons ((GtkDialog*) dlg, _tmp9_, GTK_RESPONSE_REJECT, _tmp11_, GTK_RESPONSE_ACCEPT, NULL);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	g_signal_connect ((GtkDialog*) dlg, "response", (GCallback) ___lambda42__gtk_dialog_response, NULL);
	deja_dup_show_background_window_for_shell ((GtkWindow*) dlg);
	result = (GtkWindow*) dlg;
	_g_object_unref0 (img);
	return result;
}



