/* UserEventReceiver.c generated by valac 0.38.7, the Vala compiler
 * generated from UserEventReceiver.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "CbMessageReceiver.h"
#include "CbUserStream.h"
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include "rest/oauth-proxy.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <cairo.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_USER_EVENT_RECEIVER (user_event_receiver_get_type ())
#define USER_EVENT_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_EVENT_RECEIVER, UserEventReceiver))
#define USER_EVENT_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_EVENT_RECEIVER, UserEventReceiverClass))
#define IS_USER_EVENT_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_EVENT_RECEIVER))
#define IS_USER_EVENT_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_EVENT_RECEIVER))
#define USER_EVENT_RECEIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_EVENT_RECEIVER, UserEventReceiverClass))

typedef struct _UserEventReceiver UserEventReceiver;
typedef struct _UserEventReceiverClass UserEventReceiverClass;
typedef struct _UserEventReceiverPrivate UserEventReceiverPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
enum  {
	USER_EVENT_RECEIVER_0_PROPERTY,
	USER_EVENT_RECEIVER_NUM_PROPERTIES
};
static GParamSpec* user_event_receiver_properties[USER_EVENT_RECEIVER_NUM_PROPERTIES];
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _UserEventReceiver {
	GObject parent_instance;
	UserEventReceiverPrivate * priv;
};

struct _UserEventReceiverClass {
	GObjectClass parent_class;
};

struct _UserEventReceiverPrivate {
	Account* account;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer user_event_receiver_parent_class = NULL;
static CbMessageReceiverInterface * user_event_receiver_cb_message_receiver_parent_iface = NULL;

GType user_event_receiver_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define USER_EVENT_RECEIVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_EVENT_RECEIVER, UserEventReceiverPrivate))
UserEventReceiver* user_event_receiver_new (Account* account);
UserEventReceiver* user_event_receiver_construct (GType object_type, Account* account);
static void user_event_receiver_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root_node);
void account_set_friends (Account* self, JsonArray* friends_array);
void account_follow_id (Account* self, gint64 user_id);
void account_unfollow_id (Account* self, gint64 user_id);
void account_mute_id (Account* self, gint64 id);
void account_unmute_id (Account* self, gint64 id);
void account_block_id (Account* self, gint64 id);
void account_unblock_id (Account* self, gint64 id);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
cairo_surface_t* account_get_avatar_small (Account* self);
cairo_surface_t* account_get_avatar (Account* self);
void account_save_info (Account* self);
void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name);
GType corebird_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow* * window);
gboolean settings_notify_new_dms (void);
gchar* notification_manager_send_dm (NotificationManager* self, gint64 sender_id, const gchar* existing_id, const gchar* summary, const gchar* text);
gchar* utils_unescape_html (const gchar* input);
gboolean settings_notify_new_mentions (void);
gchar* notification_manager_send (NotificationManager* self, const gchar* summary, const gchar* body, const gchar* id_suffix);
static void user_event_receiver_finalize (GObject * obj);


UserEventReceiver* user_event_receiver_construct (GType object_type, Account* account) {
	UserEventReceiver * self = NULL;
	Account* _tmp0_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (UserEventReceiver*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	return self;
}


UserEventReceiver* user_event_receiver_new (Account* account) {
	return user_event_receiver_construct (TYPE_USER_EVENT_RECEIVER, account);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void user_event_receiver_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root_node) {
	UserEventReceiver * self;
	CbStreamMessageType _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_EVENT_RECEIVER, UserEventReceiver);
	g_return_if_fail (root_node != NULL);
	_tmp0_ = type;
	switch (_tmp0_) {
		case CB_STREAM_MESSAGE_FRIENDS:
		{
			Account* _tmp1_;
			JsonNode* _tmp2_;
			JsonObject* _tmp3_;
			JsonArray* _tmp4_;
			_tmp1_ = self->priv->account;
			_tmp2_ = root_node;
			_tmp3_ = json_node_get_object (_tmp2_);
			_tmp4_ = json_object_get_array_member (_tmp3_, "friends");
			account_set_friends (_tmp1_, _tmp4_);
			break;
		}
		case CB_STREAM_MESSAGE_EVENT_FOLLOW:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp5_;
			JsonObject* _tmp6_;
			JsonObject* _tmp7_;
			gint64 _tmp8_;
			Account* _tmp9_;
			gint64 _tmp10_;
			_tmp5_ = root_node;
			_tmp6_ = json_node_get_object (_tmp5_);
			_tmp7_ = json_object_get_object_member (_tmp6_, "target");
			_tmp8_ = json_object_get_int_member (_tmp7_, "id");
			user_id = _tmp8_;
			_tmp9_ = self->priv->account;
			_tmp10_ = user_id;
			account_follow_id (_tmp9_, _tmp10_);
			break;
		}
		case CB_STREAM_MESSAGE_EVENT_UNFOLLOW:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp11_;
			JsonObject* _tmp12_;
			JsonObject* _tmp13_;
			gint64 _tmp14_;
			Account* _tmp15_;
			gint64 _tmp16_;
			_tmp11_ = root_node;
			_tmp12_ = json_node_get_object (_tmp11_);
			_tmp13_ = json_object_get_object_member (_tmp12_, "target");
			_tmp14_ = json_object_get_int_member (_tmp13_, "id");
			user_id = _tmp14_;
			_tmp15_ = self->priv->account;
			_tmp16_ = user_id;
			account_unfollow_id (_tmp15_, _tmp16_);
			break;
		}
		case CB_STREAM_MESSAGE_EVENT_MUTE:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp17_;
			JsonObject* _tmp18_;
			JsonObject* _tmp19_;
			gint64 _tmp20_;
			Account* _tmp21_;
			gint64 _tmp22_;
			_tmp17_ = root_node;
			_tmp18_ = json_node_get_object (_tmp17_);
			_tmp19_ = json_object_get_object_member (_tmp18_, "target");
			_tmp20_ = json_object_get_int_member (_tmp19_, "id");
			user_id = _tmp20_;
			_tmp21_ = self->priv->account;
			_tmp22_ = user_id;
			account_mute_id (_tmp21_, _tmp22_);
			break;
		}
		case CB_STREAM_MESSAGE_EVENT_UNMUTE:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp23_;
			JsonObject* _tmp24_;
			JsonObject* _tmp25_;
			gint64 _tmp26_;
			Account* _tmp27_;
			gint64 _tmp28_;
			_tmp23_ = root_node;
			_tmp24_ = json_node_get_object (_tmp23_);
			_tmp25_ = json_object_get_object_member (_tmp24_, "target");
			_tmp26_ = json_object_get_int_member (_tmp25_, "id");
			user_id = _tmp26_;
			_tmp27_ = self->priv->account;
			_tmp28_ = user_id;
			account_unmute_id (_tmp27_, _tmp28_);
			break;
		}
		case CB_STREAM_MESSAGE_EVENT_BLOCK:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp29_;
			JsonObject* _tmp30_;
			JsonObject* _tmp31_;
			gint64 _tmp32_;
			Account* _tmp33_;
			gint64 _tmp34_;
			_tmp29_ = root_node;
			_tmp30_ = json_node_get_object (_tmp29_);
			_tmp31_ = json_object_get_object_member (_tmp30_, "target");
			_tmp32_ = json_object_get_int_member (_tmp31_, "id");
			user_id = _tmp32_;
			_tmp33_ = self->priv->account;
			_tmp34_ = user_id;
			account_block_id (_tmp33_, _tmp34_);
			break;
		}
		case CB_STREAM_MESSAGE_EVENT_UNBLOCK:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp35_;
			JsonObject* _tmp36_;
			JsonObject* _tmp37_;
			gint64 _tmp38_;
			Account* _tmp39_;
			gint64 _tmp40_;
			_tmp35_ = root_node;
			_tmp36_ = json_node_get_object (_tmp35_);
			_tmp37_ = json_object_get_object_member (_tmp36_, "target");
			_tmp38_ = json_object_get_int_member (_tmp37_, "id");
			user_id = _tmp38_;
			_tmp39_ = self->priv->account;
			_tmp40_ = user_id;
			account_unblock_id (_tmp39_, _tmp40_);
			break;
		}
		case CB_STREAM_MESSAGE_EVENT_USER_UPDATE:
		{
			JsonObject* user_obj = NULL;
			JsonNode* _tmp41_;
			JsonObject* _tmp42_;
			JsonObject* _tmp43_;
			JsonObject* _tmp44_;
			JsonObject* _tmp45_;
			gint64 _tmp46_;
			Account* _tmp47_;
			gint64 _tmp48_;
			_tmp41_ = root_node;
			_tmp42_ = json_node_get_object (_tmp41_);
			_tmp43_ = json_object_get_object_member (_tmp42_, "target");
			_tmp44_ = _json_object_ref0 (_tmp43_);
			user_obj = _tmp44_;
			_tmp45_ = user_obj;
			_tmp46_ = json_object_get_int_member (_tmp45_, "id");
			_tmp47_ = self->priv->account;
			_tmp48_ = _tmp47_->id;
			if (_tmp46_ == _tmp48_) {
				gchar* old_screen_name = NULL;
				Account* _tmp49_;
				const gchar* _tmp50_;
				gchar* _tmp51_;
				Account* _tmp52_;
				JsonObject* _tmp53_;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				Account* _tmp56_;
				JsonObject* _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				Account* _tmp60_;
				JsonObject* _tmp61_;
				const gchar* _tmp62_;
				gchar* _tmp63_;
				Account* _tmp64_;
				Account* _tmp65_;
				const gchar* _tmp66_;
				Account* _tmp67_;
				const gchar* _tmp68_;
				Account* _tmp69_;
				cairo_surface_t* _tmp70_;
				cairo_surface_t* _tmp71_;
				Account* _tmp72_;
				cairo_surface_t* _tmp73_;
				cairo_surface_t* _tmp74_;
				Account* _tmp75_;
				const gchar* _tmp76_;
				Account* _tmp77_;
				const gchar* _tmp78_;
				_tmp49_ = self->priv->account;
				_tmp50_ = _tmp49_->screen_name;
				_tmp51_ = g_strdup (_tmp50_);
				old_screen_name = _tmp51_;
				_tmp52_ = self->priv->account;
				_tmp53_ = user_obj;
				_tmp54_ = json_object_get_string_member (_tmp53_, "name");
				_tmp55_ = g_strdup (_tmp54_);
				_g_free0 (_tmp52_->name);
				_tmp52_->name = _tmp55_;
				_tmp56_ = self->priv->account;
				_tmp57_ = user_obj;
				_tmp58_ = json_object_get_string_member (_tmp57_, "description");
				_tmp59_ = g_strdup (_tmp58_);
				_g_free0 (_tmp56_->description);
				_tmp56_->description = _tmp59_;
				_tmp60_ = self->priv->account;
				_tmp61_ = user_obj;
				_tmp62_ = json_object_get_string_member (_tmp61_, "screen_name");
				_tmp63_ = g_strdup (_tmp62_);
				_g_free0 (_tmp60_->screen_name);
				_tmp60_->screen_name = _tmp63_;
				_tmp64_ = self->priv->account;
				_tmp65_ = self->priv->account;
				_tmp66_ = _tmp65_->screen_name;
				_tmp67_ = self->priv->account;
				_tmp68_ = _tmp67_->name;
				_tmp69_ = self->priv->account;
				_tmp70_ = account_get_avatar_small (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = self->priv->account;
				_tmp73_ = account_get_avatar (_tmp72_);
				_tmp74_ = _tmp73_;
				g_signal_emit_by_name (_tmp64_, "info-changed", _tmp66_, _tmp68_, _tmp71_, _tmp74_);
				_tmp75_ = self->priv->account;
				account_save_info (_tmp75_);
				_tmp76_ = old_screen_name;
				_tmp77_ = self->priv->account;
				_tmp78_ = _tmp77_->screen_name;
				utils_update_startup_account (_tmp76_, _tmp78_);
				_g_free0 (old_screen_name);
			} else {
				g_warning ("UserEventReceiver.vala:82: USER_UPDATE: ids don't match");
			}
			_json_object_unref0 (user_obj);
			break;
		}
		case CB_STREAM_MESSAGE_DIRECT_MESSAGE:
		{
			Corebird* cb = NULL;
			GApplication* _tmp79_;
			Corebird* _tmp80_;
			gboolean _tmp81_ = FALSE;
			Corebird* _tmp82_;
			Account* _tmp83_;
			gint64 _tmp84_;
			gboolean _tmp85_;
			_tmp79_ = g_application_get_default ();
			_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, TYPE_COREBIRD, Corebird));
			cb = _tmp80_;
			_tmp82_ = cb;
			_tmp83_ = self->priv->account;
			_tmp84_ = _tmp83_->id;
			_tmp85_ = corebird_is_window_open_for_user_id (_tmp82_, _tmp84_, NULL);
			if (!_tmp85_) {
				gboolean _tmp86_;
				_tmp86_ = settings_notify_new_dms ();
				_tmp81_ = _tmp86_;
			} else {
				_tmp81_ = FALSE;
			}
			if (_tmp81_) {
				JsonObject* dm_obj = NULL;
				JsonNode* _tmp87_;
				JsonObject* _tmp88_;
				JsonObject* _tmp89_;
				JsonObject* _tmp90_;
				JsonObject* sender_obj = NULL;
				JsonObject* _tmp91_;
				JsonObject* _tmp92_;
				JsonObject* _tmp93_;
				gint64 sender_id = 0LL;
				JsonObject* _tmp94_;
				gint64 _tmp95_;
				gchar* sender_name = NULL;
				JsonObject* _tmp96_;
				const gchar* _tmp97_;
				gchar* _tmp98_;
				gchar* dm_text = NULL;
				JsonObject* _tmp99_;
				const gchar* _tmp100_;
				gchar* _tmp101_;
				Account* _tmp102_;
				NotificationManager* _tmp103_;
				gint64 _tmp104_;
				const gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				const gchar* _tmp108_;
				gchar* _tmp109_;
				gchar* _tmp110_;
				gchar* _tmp111_;
				gchar* _tmp112_;
				_tmp87_ = root_node;
				_tmp88_ = json_node_get_object (_tmp87_);
				_tmp89_ = json_object_get_object_member (_tmp88_, "direct_message");
				_tmp90_ = _json_object_ref0 (_tmp89_);
				dm_obj = _tmp90_;
				_tmp91_ = dm_obj;
				_tmp92_ = json_object_get_object_member (_tmp91_, "sender");
				_tmp93_ = _json_object_ref0 (_tmp92_);
				sender_obj = _tmp93_;
				_tmp94_ = sender_obj;
				_tmp95_ = json_object_get_int_member (_tmp94_, "id");
				sender_id = _tmp95_;
				_tmp96_ = sender_obj;
				_tmp97_ = json_object_get_string_member (_tmp96_, "name");
				_tmp98_ = g_strdup (_tmp97_);
				sender_name = _tmp98_;
				_tmp99_ = dm_obj;
				_tmp100_ = json_object_get_string_member (_tmp99_, "text");
				_tmp101_ = g_strdup (_tmp100_);
				dm_text = _tmp101_;
				_tmp102_ = self->priv->account;
				_tmp103_ = _tmp102_->notifications;
				_tmp104_ = sender_id;
				_tmp105_ = sender_name;
				_tmp106_ = g_strdup_printf (_ ("New direct message from %s"), _tmp105_);
				_tmp107_ = _tmp106_;
				_tmp108_ = dm_text;
				_tmp109_ = utils_unescape_html (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = notification_manager_send_dm (_tmp103_, _tmp104_, NULL, _tmp107_, _tmp110_);
				_tmp112_ = _tmp111_;
				_g_free0 (_tmp112_);
				_g_free0 (_tmp110_);
				_g_free0 (_tmp107_);
				_g_free0 (dm_text);
				_g_free0 (sender_name);
				_json_object_unref0 (sender_obj);
				_json_object_unref0 (dm_obj);
			}
			_g_object_unref0 (cb);
			break;
		}
		case CB_STREAM_MESSAGE_TWEET:
		{
			Corebird* cb = NULL;
			GApplication* _tmp113_;
			Corebird* _tmp114_;
			gboolean _tmp115_ = FALSE;
			Corebird* _tmp116_;
			Account* _tmp117_;
			gint64 _tmp118_;
			gboolean _tmp119_;
			_tmp113_ = g_application_get_default ();
			_tmp114_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp113_, TYPE_COREBIRD, Corebird));
			cb = _tmp114_;
			_tmp116_ = cb;
			_tmp117_ = self->priv->account;
			_tmp118_ = _tmp117_->id;
			_tmp119_ = corebird_is_window_open_for_user_id (_tmp116_, _tmp118_, NULL);
			if (!_tmp119_) {
				gboolean _tmp120_;
				_tmp120_ = settings_notify_new_mentions ();
				_tmp115_ = _tmp120_;
			} else {
				_tmp115_ = FALSE;
			}
			if (_tmp115_) {
				JsonObject* tweet_obj = NULL;
				JsonNode* _tmp121_;
				JsonObject* _tmp122_;
				JsonObject* _tmp123_;
				gchar* text = NULL;
				JsonObject* _tmp124_;
				const gchar* _tmp125_;
				gchar* _tmp126_;
				const gchar* _tmp127_;
				Account* _tmp128_;
				const gchar* _tmp129_;
				gchar* _tmp130_;
				gchar* _tmp131_;
				gboolean _tmp132_;
				gboolean _tmp133_;
				_tmp121_ = root_node;
				_tmp122_ = json_node_get_object (_tmp121_);
				_tmp123_ = _json_object_ref0 (_tmp122_);
				tweet_obj = _tmp123_;
				_tmp124_ = tweet_obj;
				_tmp125_ = json_object_get_string_member (_tmp124_, "text");
				_tmp126_ = g_strdup (_tmp125_);
				text = _tmp126_;
				_tmp127_ = text;
				_tmp128_ = self->priv->account;
				_tmp129_ = _tmp128_->screen_name;
				_tmp130_ = g_strconcat ("@", _tmp129_, NULL);
				_tmp131_ = _tmp130_;
				_tmp132_ = string_contains (_tmp127_, _tmp131_);
				_tmp133_ = _tmp132_;
				_g_free0 (_tmp131_);
				if (_tmp133_) {
					JsonObject* author_obj = NULL;
					JsonObject* _tmp134_;
					JsonObject* _tmp135_;
					JsonObject* _tmp136_;
					gchar* author_name = NULL;
					JsonObject* _tmp137_;
					const gchar* _tmp138_;
					gchar* _tmp139_;
					gchar* summary = NULL;
					const gchar* _tmp140_;
					Account* _tmp141_;
					const gchar* _tmp142_;
					gchar* _tmp143_;
					Account* _tmp144_;
					NotificationManager* _tmp145_;
					const gchar* _tmp146_;
					const gchar* _tmp147_;
					gchar* _tmp148_;
					gchar* _tmp149_;
					_tmp134_ = tweet_obj;
					_tmp135_ = json_object_get_object_member (_tmp134_, "user");
					_tmp136_ = _json_object_ref0 (_tmp135_);
					author_obj = _tmp136_;
					_tmp137_ = author_obj;
					_tmp138_ = json_object_get_string_member (_tmp137_, "name");
					_tmp139_ = g_strdup (_tmp138_);
					author_name = _tmp139_;
					_tmp140_ = author_name;
					_tmp141_ = self->priv->account;
					_tmp142_ = _tmp141_->name;
					_tmp143_ = g_strdup_printf (_ ("%s mentioned %s"), _tmp140_, _tmp142_);
					summary = _tmp143_;
					_tmp144_ = self->priv->account;
					_tmp145_ = _tmp144_->notifications;
					_tmp146_ = summary;
					_tmp147_ = text;
					_tmp148_ = notification_manager_send (_tmp145_, _tmp146_, _tmp147_, NULL);
					_tmp149_ = _tmp148_;
					_g_free0 (_tmp149_);
					_g_free0 (summary);
					_g_free0 (author_name);
					_json_object_unref0 (author_obj);
				}
				_g_free0 (text);
				_json_object_unref0 (tweet_obj);
			}
			_g_object_unref0 (cb);
			break;
		}
		default:
		break;
	}
}


static void user_event_receiver_class_init (UserEventReceiverClass * klass) {
	user_event_receiver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserEventReceiverPrivate));
	G_OBJECT_CLASS (klass)->finalize = user_event_receiver_finalize;
}


static void user_event_receiver_cb_message_receiver_interface_init (CbMessageReceiverInterface * iface) {
	user_event_receiver_cb_message_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*) (CbMessageReceiver *, CbStreamMessageType, JsonNode*)) user_event_receiver_real_stream_message_received;
}


static void user_event_receiver_instance_init (UserEventReceiver * self) {
	self->priv = USER_EVENT_RECEIVER_GET_PRIVATE (self);
}


static void user_event_receiver_finalize (GObject * obj) {
	UserEventReceiver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_EVENT_RECEIVER, UserEventReceiver);
	G_OBJECT_CLASS (user_event_receiver_parent_class)->finalize (obj);
}


GType user_event_receiver_get_type (void) {
	static volatile gsize user_event_receiver_type_id__volatile = 0;
	if (g_once_init_enter (&user_event_receiver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserEventReceiverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_event_receiver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserEventReceiver), 0, (GInstanceInitFunc) user_event_receiver_instance_init, NULL };
		static const GInterfaceInfo cb_message_receiver_info = { (GInterfaceInitFunc) user_event_receiver_cb_message_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType user_event_receiver_type_id;
		user_event_receiver_type_id = g_type_register_static (G_TYPE_OBJECT, "UserEventReceiver", &g_define_type_info, 0);
		g_type_add_interface_static (user_event_receiver_type_id, CB_TYPE_MESSAGE_RECEIVER, &cb_message_receiver_info);
		g_once_init_leave (&user_event_receiver_type_id__volatile, user_event_receiver_type_id);
	}
	return user_event_receiver_type_id__volatile;
}



