; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=riscv32 -global-isel -stop-after=irtranslator \
; RUN:   -verify-machineinstrs < %s | FileCheck -check-prefix=RV32I %s

; Any tests that would have identical output for some combination of the ilp32*
; ABIs belong in calling-conv-*-common.ll. This file contains tests that will
; have different output across those ABIs. i.e. where some arguments would be
; passed according to the floating point ABI.

define i32 @callee_float_in_regs(i32 %a, float %b) nounwind {
  ; RV32I-LABEL: name: callee_float_in_regs
  ; RV32I: bb.1 (%ir-block.0):
  ; RV32I-NEXT:   liveins: $x10, $x11
  ; RV32I-NEXT: {{  $}}
  ; RV32I-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32I-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x11
  ; RV32I-NEXT:   [[FPTOSI:%[0-9]+]]:_(s32) = G_FPTOSI [[COPY1]](s32)
  ; RV32I-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[COPY]], [[FPTOSI]]
  ; RV32I-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  %b_fptosi = fptosi float %b to i32
  %1 = add i32 %a, %b_fptosi
  ret i32 %1
}

define i32 @caller_float_in_regs() nounwind {
  ; RV32I-LABEL: name: caller_float_in_regs
  ; RV32I: bb.1 (%ir-block.0):
  ; RV32I-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; RV32I-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_FCONSTANT float 2.000000e+00
  ; RV32I-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32I-NEXT:   $x10 = COPY [[C]](s32)
  ; RV32I-NEXT:   $x11 = COPY [[C1]](s32)
  ; RV32I-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_in_regs, csr_ilp32_lp64, implicit-def $x1, implicit $x10, implicit $x11, implicit-def $x10
  ; RV32I-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32I-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32I-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_float_in_regs(i32 1, float 2.0)
  ret i32 %1
}

define i32 @callee_float_on_stack(i64 %a, i64 %b, i64 %c, i64 %d, float %e) nounwind {
  ; RV32I-LABEL: name: callee_float_on_stack
  ; RV32I: bb.1 (%ir-block.0):
  ; RV32I-NEXT:   liveins: $x10, $x11, $x12, $x13, $x14, $x15, $x16, $x17
  ; RV32I-NEXT: {{  $}}
  ; RV32I-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32I-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x11
  ; RV32I-NEXT:   [[MV:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY]](s32), [[COPY1]](s32)
  ; RV32I-NEXT:   [[COPY2:%[0-9]+]]:_(s32) = COPY $x12
  ; RV32I-NEXT:   [[COPY3:%[0-9]+]]:_(s32) = COPY $x13
  ; RV32I-NEXT:   [[MV1:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY2]](s32), [[COPY3]](s32)
  ; RV32I-NEXT:   [[COPY4:%[0-9]+]]:_(s32) = COPY $x14
  ; RV32I-NEXT:   [[COPY5:%[0-9]+]]:_(s32) = COPY $x15
  ; RV32I-NEXT:   [[MV2:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY4]](s32), [[COPY5]](s32)
  ; RV32I-NEXT:   [[COPY6:%[0-9]+]]:_(s32) = COPY $x16
  ; RV32I-NEXT:   [[COPY7:%[0-9]+]]:_(s32) = COPY $x17
  ; RV32I-NEXT:   [[MV3:%[0-9]+]]:_(s64) = G_MERGE_VALUES [[COPY6]](s32), [[COPY7]](s32)
  ; RV32I-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %fixed-stack.0
  ; RV32I-NEXT:   [[LOAD:%[0-9]+]]:_(s32) = G_LOAD [[FRAME_INDEX]](p0) :: (load (s32) from %fixed-stack.0, align 16)
  ; RV32I-NEXT:   [[TRUNC:%[0-9]+]]:_(s32) = G_TRUNC [[MV3]](s64)
  ; RV32I-NEXT:   [[ADD:%[0-9]+]]:_(s32) = G_ADD [[TRUNC]], [[LOAD]]
  ; RV32I-NEXT:   $x10 = COPY [[ADD]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  %1 = trunc i64 %d to i32
  %2 = bitcast float %e to i32
  %3 = add i32 %1, %2
  ret i32 %3
}

define i32 @caller_float_on_stack() nounwind {
  ; RV32I-LABEL: name: caller_float_on_stack
  ; RV32I: bb.1 (%ir-block.0):
  ; RV32I-NEXT:   [[C:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; RV32I-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; RV32I-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; RV32I-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 4
  ; RV32I-NEXT:   [[C4:%[0-9]+]]:_(s32) = G_FCONSTANT float 5.000000e+00
  ; RV32I-NEXT:   ADJCALLSTACKDOWN 4, 0, implicit-def $x2, implicit $x2
  ; RV32I-NEXT:   [[UV:%[0-9]+]]:_(s32), [[UV1:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C]](s64)
  ; RV32I-NEXT:   [[UV2:%[0-9]+]]:_(s32), [[UV3:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C1]](s64)
  ; RV32I-NEXT:   [[UV4:%[0-9]+]]:_(s32), [[UV5:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C2]](s64)
  ; RV32I-NEXT:   [[UV6:%[0-9]+]]:_(s32), [[UV7:%[0-9]+]]:_(s32) = G_UNMERGE_VALUES [[C3]](s64)
  ; RV32I-NEXT:   [[COPY:%[0-9]+]]:_(p0) = COPY $x2
  ; RV32I-NEXT:   [[C5:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; RV32I-NEXT:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[C5]](s32)
  ; RV32I-NEXT:   G_STORE [[C4]](s32), [[PTR_ADD]](p0) :: (store (s32) into stack, align 16)
  ; RV32I-NEXT:   $x10 = COPY [[UV]](s32)
  ; RV32I-NEXT:   $x11 = COPY [[UV1]](s32)
  ; RV32I-NEXT:   $x12 = COPY [[UV2]](s32)
  ; RV32I-NEXT:   $x13 = COPY [[UV3]](s32)
  ; RV32I-NEXT:   $x14 = COPY [[UV4]](s32)
  ; RV32I-NEXT:   $x15 = COPY [[UV5]](s32)
  ; RV32I-NEXT:   $x16 = COPY [[UV6]](s32)
  ; RV32I-NEXT:   $x17 = COPY [[UV7]](s32)
  ; RV32I-NEXT:   PseudoCALL target-flags(riscv-call) @callee_float_on_stack, csr_ilp32_lp64, implicit-def $x1, implicit $x10, implicit $x11, implicit $x12, implicit $x13, implicit $x14, implicit $x15, implicit $x16, implicit $x17, implicit-def $x10
  ; RV32I-NEXT:   ADJCALLSTACKUP 4, 0, implicit-def $x2, implicit $x2
  ; RV32I-NEXT:   [[COPY1:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32I-NEXT:   $x10 = COPY [[COPY1]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  %1 = call i32 @callee_float_on_stack(i64 1, i64 2, i64 3, i64 4, float 5.0)
  ret i32 %1
}

define float @callee_tiny_scalar_ret() nounwind {
  ; RV32I-LABEL: name: callee_tiny_scalar_ret
  ; RV32I: bb.1 (%ir-block.0):
  ; RV32I-NEXT:   [[C:%[0-9]+]]:_(s32) = G_FCONSTANT float 1.000000e+00
  ; RV32I-NEXT:   $x10 = COPY [[C]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  ret float 1.0
}

define i32 @caller_tiny_scalar_ret() nounwind {
  ; RV32I-LABEL: name: caller_tiny_scalar_ret
  ; RV32I: bb.1 (%ir-block.0):
  ; RV32I-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32I-NEXT:   PseudoCALL target-flags(riscv-call) @callee_tiny_scalar_ret, csr_ilp32_lp64, implicit-def $x1, implicit-def $x10
  ; RV32I-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32I-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32I-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  %1 = call float @callee_tiny_scalar_ret()
  %2 = bitcast float %1 to i32
  ret i32 %2
}
