; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel -relocation-model=pic -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32_PIC

declare i32 @f(i32 %a, i32 %b);

define internal i32 @f_with_local_linkage(i32 %x, i32 %y) {
; MIPS32_PIC-LABEL: f_with_local_linkage:
; MIPS32_PIC:       # %bb.0: # %entry
; MIPS32_PIC-NEXT:    addu $2, $5, $4
; MIPS32_PIC-NEXT:    jr $ra
; MIPS32_PIC-NEXT:    nop
entry:
  %add = add i32 %y, %x
  ret i32 %add
}

define i32 @call_global(i32 %a, i32 %b) {
; MIPS32_PIC-LABEL: call_global:
; MIPS32_PIC:       # %bb.0: # %entry
; MIPS32_PIC-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32_PIC-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32_PIC-NEXT:    addiu $sp, $sp, -24
; MIPS32_PIC-NEXT:    .cfi_def_cfa_offset 24
; MIPS32_PIC-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32_PIC-NEXT:    .cfi_offset 31, -4
; MIPS32_PIC-NEXT:    addu $gp, $2, $25
; MIPS32_PIC-NEXT:    lw $25, %call16(f)($gp)
; MIPS32_PIC-NEXT:    jalr $25
; MIPS32_PIC-NEXT:    nop
; MIPS32_PIC-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32_PIC-NEXT:    addiu $sp, $sp, 24
; MIPS32_PIC-NEXT:    jr $ra
; MIPS32_PIC-NEXT:    nop
entry:
  %call = call i32 @f(i32 %a, i32 %b)
  ret i32 %call
}

define i32 @call_global_with_local_linkage(i32 %a, i32 %b) {
; MIPS32_PIC-LABEL: call_global_with_local_linkage:
; MIPS32_PIC:       # %bb.0: # %entry
; MIPS32_PIC-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32_PIC-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32_PIC-NEXT:    addiu $sp, $sp, -24
; MIPS32_PIC-NEXT:    .cfi_def_cfa_offset 24
; MIPS32_PIC-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32_PIC-NEXT:    .cfi_offset 31, -4
; MIPS32_PIC-NEXT:    addu $gp, $2, $25
; MIPS32_PIC-NEXT:    lw $1, %got(f_with_local_linkage)($gp)
; MIPS32_PIC-NEXT:    addiu $25, $1, %lo(f_with_local_linkage)
; MIPS32_PIC-NEXT:    jalr $25
; MIPS32_PIC-NEXT:    nop
; MIPS32_PIC-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32_PIC-NEXT:    addiu $sp, $sp, 24
; MIPS32_PIC-NEXT:    jr $ra
; MIPS32_PIC-NEXT:    nop
entry:
  %call = call i32 @f_with_local_linkage(i32 %a, i32 %b)
  ret i32 %call
}


@val = global i32 0
@val_with_local_linkage = internal global i32 1

define i32 @ret_global_int() {
; MIPS32_PIC-LABEL: ret_global_int:
; MIPS32_PIC:       # %bb.0: # %entry
; MIPS32_PIC-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32_PIC-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32_PIC-NEXT:    addu $1, $2, $25
; MIPS32_PIC-NEXT:    lw $1, %got(val)($1)
; MIPS32_PIC-NEXT:    lw $2, 0($1)
; MIPS32_PIC-NEXT:    jr $ra
; MIPS32_PIC-NEXT:    nop
entry:
  %0 = load i32, ptr @val
  ret i32 %0
}

define i32 @ret_global_int_with_local_linkage() {
; MIPS32_PIC-LABEL: ret_global_int_with_local_linkage:
; MIPS32_PIC:       # %bb.0: # %entry
; MIPS32_PIC-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32_PIC-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32_PIC-NEXT:    addu $1, $2, $25
; MIPS32_PIC-NEXT:    lw $1, %got(val_with_local_linkage)($1)
; MIPS32_PIC-NEXT:    addiu $1, $1, %lo(val_with_local_linkage)
; MIPS32_PIC-NEXT:    lw $2, 0($1)
; MIPS32_PIC-NEXT:    jr $ra
; MIPS32_PIC-NEXT:    nop
entry:
  %0 = load i32, ptr @val_with_local_linkage
  ret i32 %0
}
