// This code was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <options-parser.hxx>
//
// End prologue.

#include <cxx/tree/options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <ostream>
#include <sstream>

namespace cli
{
  template <typename X>
  struct parser
  {
    static void
    parse (X& x, bool& xs, scanner& s)
    {
      std::string o (s.next ());

      if (s.more ())
      {
        std::string v (s.next ());
        std::istringstream is (v);
        if (!(is >> x && is.eof ()))
          throw invalid_value (o, v);
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <>
  struct parser<bool>
  {
    static void
    parse (bool& x, scanner& s)
    {
      s.next ();
      x = true;
    }
  };

  template <>
  struct parser<std::string>
  {
    static void
    parse (std::string& x, bool& xs, scanner& s)
    {
      const char* o (s.next ());

      if (s.more ())
        x = s.next ();
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <typename X>
  struct parser<std::vector<X> >
  {
    static void
    parse (std::vector<X>& c, bool& xs, scanner& s)
    {
      X x;
      bool dummy;
      parser<X>::parse (x, dummy, s);
      c.push_back (x);
      xs = true;
    }
  };

  template <typename X>
  struct parser<std::set<X> >
  {
    static void
    parse (std::set<X>& c, bool& xs, scanner& s)
    {
      X x;
      bool dummy;
      parser<X>::parse (x, dummy, s);
      c.insert (x);
      xs = true;
    }
  };

  template <typename K, typename V>
  struct parser<std::map<K, V> >
  {
    static void
    parse (std::map<K, V>& m, bool& xs, scanner& s)
    {
      std::string o (s.next ());

      if (s.more ())
      {
        std::string ov (s.next ());
        std::string::size_type p = ov.find ('=');

        if (p == std::string::npos)
        {
          K k = K ();

          if (!ov.empty ())
          {
            std::istringstream ks (ov);

            if (!(ks >> k && ks.eof ()))
              throw invalid_value (o, ov);
          }

          m[k] = V ();
        }
        else
        {
          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, p + 1);

          if (!kstr.empty ())
          {
            std::istringstream ks (kstr);

            if (!(ks >> k && ks.eof ()))
              throw invalid_value (o, ov);
          }

          if (!vstr.empty ())
          {
            std::istringstream vs (vstr);

            if (!(vs >> v && vs.eof ()))
              throw invalid_value (o, ov);
          }

          m[k] = v;
        }
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <typename X, typename T, T X::*M>
  void
  thunk (X& x, scanner& s)
  {
    parser<T>::parse (x.*M, s);
  }

  template <typename X, typename T, T X::*M, bool X::*S>
  void
  thunk (X& x, scanner& s)
  {
    parser<T>::parse (x.*M, x.*S, s);
  }
}

#include <map>
#include <cstring>

namespace CXX
{
  namespace Tree
  {
    // options
    //

    options::
    options ()
    : generate_polymorphic_ (),
      polymorphic_type_ (),
      polymorphic_type_specified_ (false),
      polymorphic_type_all_ (),
      polymorphic_plate_ (0),
      polymorphic_plate_specified_ (false),
      ordered_type_ (),
      ordered_type_specified_ (false),
      ordered_type_derived_ (),
      ordered_type_mixed_ (),
      ordered_type_all_ (),
      order_container_ (),
      order_container_specified_ (false),
      generate_serialization_ (),
      generate_ostream_ (),
      generate_doxygen_ (),
      generate_comparison_ (),
      generate_default_ctor_ (),
      generate_from_base_ctor_ (),
      suppress_assignment_ (),
      generate_detach_ (),
      generate_wildcard_ (),
      generate_any_type_ (),
      generate_insertion_ (),
      generate_insertion_specified_ (false),
      generate_extraction_ (),
      generate_extraction_specified_ (false),
      generate_forward_ (),
      suppress_parsing_ (),
      generate_element_type_ (),
      generate_element_map_ (),
      generate_intellisense_ (),
      omit_default_attributes_ (),
      type_naming_ ("knr"),
      type_naming_specified_ (false),
      function_naming_ ("knr"),
      function_naming_specified_ (false),
      type_regex_ (),
      type_regex_specified_ (false),
      accessor_regex_ (),
      accessor_regex_specified_ (false),
      one_accessor_regex_ (),
      one_accessor_regex_specified_ (false),
      opt_accessor_regex_ (),
      opt_accessor_regex_specified_ (false),
      seq_accessor_regex_ (),
      seq_accessor_regex_specified_ (false),
      modifier_regex_ (),
      modifier_regex_specified_ (false),
      one_modifier_regex_ (),
      one_modifier_regex_specified_ (false),
      opt_modifier_regex_ (),
      opt_modifier_regex_specified_ (false),
      seq_modifier_regex_ (),
      seq_modifier_regex_specified_ (false),
      parser_regex_ (),
      parser_regex_specified_ (false),
      serializer_regex_ (),
      serializer_regex_specified_ (false),
      const_regex_ (),
      const_regex_specified_ (false),
      enumerator_regex_ (),
      enumerator_regex_specified_ (false),
      element_type_regex_ (),
      element_type_regex_specified_ (false),
      name_regex_trace_ (),
      root_element_first_ (),
      root_element_last_ (),
      root_element_all_ (),
      root_element_none_ (),
      root_element_ (),
      root_element_specified_ (false),
      custom_type_ (),
      custom_type_specified_ (false),
      custom_type_regex_ (),
      custom_type_regex_specified_ (false),
      parts_ (1),
      parts_specified_ (false),
      parts_suffix_ ("-"),
      parts_suffix_specified_ (false)
    {
    }

    options::
    options (int& argc,
             char** argv,
             bool erase,
             ::cli::unknown_mode opt,
             ::cli::unknown_mode arg)
    : generate_polymorphic_ (),
      polymorphic_type_ (),
      polymorphic_type_specified_ (false),
      polymorphic_type_all_ (),
      polymorphic_plate_ (0),
      polymorphic_plate_specified_ (false),
      ordered_type_ (),
      ordered_type_specified_ (false),
      ordered_type_derived_ (),
      ordered_type_mixed_ (),
      ordered_type_all_ (),
      order_container_ (),
      order_container_specified_ (false),
      generate_serialization_ (),
      generate_ostream_ (),
      generate_doxygen_ (),
      generate_comparison_ (),
      generate_default_ctor_ (),
      generate_from_base_ctor_ (),
      suppress_assignment_ (),
      generate_detach_ (),
      generate_wildcard_ (),
      generate_any_type_ (),
      generate_insertion_ (),
      generate_insertion_specified_ (false),
      generate_extraction_ (),
      generate_extraction_specified_ (false),
      generate_forward_ (),
      suppress_parsing_ (),
      generate_element_type_ (),
      generate_element_map_ (),
      generate_intellisense_ (),
      omit_default_attributes_ (),
      type_naming_ ("knr"),
      type_naming_specified_ (false),
      function_naming_ ("knr"),
      function_naming_specified_ (false),
      type_regex_ (),
      type_regex_specified_ (false),
      accessor_regex_ (),
      accessor_regex_specified_ (false),
      one_accessor_regex_ (),
      one_accessor_regex_specified_ (false),
      opt_accessor_regex_ (),
      opt_accessor_regex_specified_ (false),
      seq_accessor_regex_ (),
      seq_accessor_regex_specified_ (false),
      modifier_regex_ (),
      modifier_regex_specified_ (false),
      one_modifier_regex_ (),
      one_modifier_regex_specified_ (false),
      opt_modifier_regex_ (),
      opt_modifier_regex_specified_ (false),
      seq_modifier_regex_ (),
      seq_modifier_regex_specified_ (false),
      parser_regex_ (),
      parser_regex_specified_ (false),
      serializer_regex_ (),
      serializer_regex_specified_ (false),
      const_regex_ (),
      const_regex_specified_ (false),
      enumerator_regex_ (),
      enumerator_regex_specified_ (false),
      element_type_regex_ (),
      element_type_regex_specified_ (false),
      name_regex_trace_ (),
      root_element_first_ (),
      root_element_last_ (),
      root_element_all_ (),
      root_element_none_ (),
      root_element_ (),
      root_element_specified_ (false),
      custom_type_ (),
      custom_type_specified_ (false),
      custom_type_regex_ (),
      custom_type_regex_specified_ (false),
      parts_ (1),
      parts_specified_ (false),
      parts_suffix_ ("-"),
      parts_suffix_specified_ (false)
    {
      ::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    options::
    options (int start,
             int& argc,
             char** argv,
             bool erase,
             ::cli::unknown_mode opt,
             ::cli::unknown_mode arg)
    : generate_polymorphic_ (),
      polymorphic_type_ (),
      polymorphic_type_specified_ (false),
      polymorphic_type_all_ (),
      polymorphic_plate_ (0),
      polymorphic_plate_specified_ (false),
      ordered_type_ (),
      ordered_type_specified_ (false),
      ordered_type_derived_ (),
      ordered_type_mixed_ (),
      ordered_type_all_ (),
      order_container_ (),
      order_container_specified_ (false),
      generate_serialization_ (),
      generate_ostream_ (),
      generate_doxygen_ (),
      generate_comparison_ (),
      generate_default_ctor_ (),
      generate_from_base_ctor_ (),
      suppress_assignment_ (),
      generate_detach_ (),
      generate_wildcard_ (),
      generate_any_type_ (),
      generate_insertion_ (),
      generate_insertion_specified_ (false),
      generate_extraction_ (),
      generate_extraction_specified_ (false),
      generate_forward_ (),
      suppress_parsing_ (),
      generate_element_type_ (),
      generate_element_map_ (),
      generate_intellisense_ (),
      omit_default_attributes_ (),
      type_naming_ ("knr"),
      type_naming_specified_ (false),
      function_naming_ ("knr"),
      function_naming_specified_ (false),
      type_regex_ (),
      type_regex_specified_ (false),
      accessor_regex_ (),
      accessor_regex_specified_ (false),
      one_accessor_regex_ (),
      one_accessor_regex_specified_ (false),
      opt_accessor_regex_ (),
      opt_accessor_regex_specified_ (false),
      seq_accessor_regex_ (),
      seq_accessor_regex_specified_ (false),
      modifier_regex_ (),
      modifier_regex_specified_ (false),
      one_modifier_regex_ (),
      one_modifier_regex_specified_ (false),
      opt_modifier_regex_ (),
      opt_modifier_regex_specified_ (false),
      seq_modifier_regex_ (),
      seq_modifier_regex_specified_ (false),
      parser_regex_ (),
      parser_regex_specified_ (false),
      serializer_regex_ (),
      serializer_regex_specified_ (false),
      const_regex_ (),
      const_regex_specified_ (false),
      enumerator_regex_ (),
      enumerator_regex_specified_ (false),
      element_type_regex_ (),
      element_type_regex_specified_ (false),
      name_regex_trace_ (),
      root_element_first_ (),
      root_element_last_ (),
      root_element_all_ (),
      root_element_none_ (),
      root_element_ (),
      root_element_specified_ (false),
      custom_type_ (),
      custom_type_specified_ (false),
      custom_type_regex_ (),
      custom_type_regex_specified_ (false),
      parts_ (1),
      parts_specified_ (false),
      parts_suffix_ ("-"),
      parts_suffix_specified_ (false)
    {
      ::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    options::
    options (int& argc,
             char** argv,
             int& end,
             bool erase,
             ::cli::unknown_mode opt,
             ::cli::unknown_mode arg)
    : generate_polymorphic_ (),
      polymorphic_type_ (),
      polymorphic_type_specified_ (false),
      polymorphic_type_all_ (),
      polymorphic_plate_ (0),
      polymorphic_plate_specified_ (false),
      ordered_type_ (),
      ordered_type_specified_ (false),
      ordered_type_derived_ (),
      ordered_type_mixed_ (),
      ordered_type_all_ (),
      order_container_ (),
      order_container_specified_ (false),
      generate_serialization_ (),
      generate_ostream_ (),
      generate_doxygen_ (),
      generate_comparison_ (),
      generate_default_ctor_ (),
      generate_from_base_ctor_ (),
      suppress_assignment_ (),
      generate_detach_ (),
      generate_wildcard_ (),
      generate_any_type_ (),
      generate_insertion_ (),
      generate_insertion_specified_ (false),
      generate_extraction_ (),
      generate_extraction_specified_ (false),
      generate_forward_ (),
      suppress_parsing_ (),
      generate_element_type_ (),
      generate_element_map_ (),
      generate_intellisense_ (),
      omit_default_attributes_ (),
      type_naming_ ("knr"),
      type_naming_specified_ (false),
      function_naming_ ("knr"),
      function_naming_specified_ (false),
      type_regex_ (),
      type_regex_specified_ (false),
      accessor_regex_ (),
      accessor_regex_specified_ (false),
      one_accessor_regex_ (),
      one_accessor_regex_specified_ (false),
      opt_accessor_regex_ (),
      opt_accessor_regex_specified_ (false),
      seq_accessor_regex_ (),
      seq_accessor_regex_specified_ (false),
      modifier_regex_ (),
      modifier_regex_specified_ (false),
      one_modifier_regex_ (),
      one_modifier_regex_specified_ (false),
      opt_modifier_regex_ (),
      opt_modifier_regex_specified_ (false),
      seq_modifier_regex_ (),
      seq_modifier_regex_specified_ (false),
      parser_regex_ (),
      parser_regex_specified_ (false),
      serializer_regex_ (),
      serializer_regex_specified_ (false),
      const_regex_ (),
      const_regex_specified_ (false),
      enumerator_regex_ (),
      enumerator_regex_specified_ (false),
      element_type_regex_ (),
      element_type_regex_specified_ (false),
      name_regex_trace_ (),
      root_element_first_ (),
      root_element_last_ (),
      root_element_all_ (),
      root_element_none_ (),
      root_element_ (),
      root_element_specified_ (false),
      custom_type_ (),
      custom_type_specified_ (false),
      custom_type_regex_ (),
      custom_type_regex_specified_ (false),
      parts_ (1),
      parts_specified_ (false),
      parts_suffix_ ("-"),
      parts_suffix_specified_ (false)
    {
      ::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    options::
    options (int start,
             int& argc,
             char** argv,
             int& end,
             bool erase,
             ::cli::unknown_mode opt,
             ::cli::unknown_mode arg)
    : generate_polymorphic_ (),
      polymorphic_type_ (),
      polymorphic_type_specified_ (false),
      polymorphic_type_all_ (),
      polymorphic_plate_ (0),
      polymorphic_plate_specified_ (false),
      ordered_type_ (),
      ordered_type_specified_ (false),
      ordered_type_derived_ (),
      ordered_type_mixed_ (),
      ordered_type_all_ (),
      order_container_ (),
      order_container_specified_ (false),
      generate_serialization_ (),
      generate_ostream_ (),
      generate_doxygen_ (),
      generate_comparison_ (),
      generate_default_ctor_ (),
      generate_from_base_ctor_ (),
      suppress_assignment_ (),
      generate_detach_ (),
      generate_wildcard_ (),
      generate_any_type_ (),
      generate_insertion_ (),
      generate_insertion_specified_ (false),
      generate_extraction_ (),
      generate_extraction_specified_ (false),
      generate_forward_ (),
      suppress_parsing_ (),
      generate_element_type_ (),
      generate_element_map_ (),
      generate_intellisense_ (),
      omit_default_attributes_ (),
      type_naming_ ("knr"),
      type_naming_specified_ (false),
      function_naming_ ("knr"),
      function_naming_specified_ (false),
      type_regex_ (),
      type_regex_specified_ (false),
      accessor_regex_ (),
      accessor_regex_specified_ (false),
      one_accessor_regex_ (),
      one_accessor_regex_specified_ (false),
      opt_accessor_regex_ (),
      opt_accessor_regex_specified_ (false),
      seq_accessor_regex_ (),
      seq_accessor_regex_specified_ (false),
      modifier_regex_ (),
      modifier_regex_specified_ (false),
      one_modifier_regex_ (),
      one_modifier_regex_specified_ (false),
      opt_modifier_regex_ (),
      opt_modifier_regex_specified_ (false),
      seq_modifier_regex_ (),
      seq_modifier_regex_specified_ (false),
      parser_regex_ (),
      parser_regex_specified_ (false),
      serializer_regex_ (),
      serializer_regex_specified_ (false),
      const_regex_ (),
      const_regex_specified_ (false),
      enumerator_regex_ (),
      enumerator_regex_specified_ (false),
      element_type_regex_ (),
      element_type_regex_specified_ (false),
      name_regex_trace_ (),
      root_element_first_ (),
      root_element_last_ (),
      root_element_all_ (),
      root_element_none_ (),
      root_element_ (),
      root_element_specified_ (false),
      custom_type_ (),
      custom_type_specified_ (false),
      custom_type_regex_ (),
      custom_type_regex_specified_ (false),
      parts_ (1),
      parts_specified_ (false),
      parts_suffix_ ("-"),
      parts_suffix_specified_ (false)
    {
      ::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    options::
    options (::cli::scanner& s,
             ::cli::unknown_mode opt,
             ::cli::unknown_mode arg)
    : generate_polymorphic_ (),
      polymorphic_type_ (),
      polymorphic_type_specified_ (false),
      polymorphic_type_all_ (),
      polymorphic_plate_ (0),
      polymorphic_plate_specified_ (false),
      ordered_type_ (),
      ordered_type_specified_ (false),
      ordered_type_derived_ (),
      ordered_type_mixed_ (),
      ordered_type_all_ (),
      order_container_ (),
      order_container_specified_ (false),
      generate_serialization_ (),
      generate_ostream_ (),
      generate_doxygen_ (),
      generate_comparison_ (),
      generate_default_ctor_ (),
      generate_from_base_ctor_ (),
      suppress_assignment_ (),
      generate_detach_ (),
      generate_wildcard_ (),
      generate_any_type_ (),
      generate_insertion_ (),
      generate_insertion_specified_ (false),
      generate_extraction_ (),
      generate_extraction_specified_ (false),
      generate_forward_ (),
      suppress_parsing_ (),
      generate_element_type_ (),
      generate_element_map_ (),
      generate_intellisense_ (),
      omit_default_attributes_ (),
      type_naming_ ("knr"),
      type_naming_specified_ (false),
      function_naming_ ("knr"),
      function_naming_specified_ (false),
      type_regex_ (),
      type_regex_specified_ (false),
      accessor_regex_ (),
      accessor_regex_specified_ (false),
      one_accessor_regex_ (),
      one_accessor_regex_specified_ (false),
      opt_accessor_regex_ (),
      opt_accessor_regex_specified_ (false),
      seq_accessor_regex_ (),
      seq_accessor_regex_specified_ (false),
      modifier_regex_ (),
      modifier_regex_specified_ (false),
      one_modifier_regex_ (),
      one_modifier_regex_specified_ (false),
      opt_modifier_regex_ (),
      opt_modifier_regex_specified_ (false),
      seq_modifier_regex_ (),
      seq_modifier_regex_specified_ (false),
      parser_regex_ (),
      parser_regex_specified_ (false),
      serializer_regex_ (),
      serializer_regex_specified_ (false),
      const_regex_ (),
      const_regex_specified_ (false),
      enumerator_regex_ (),
      enumerator_regex_specified_ (false),
      element_type_regex_ (),
      element_type_regex_specified_ (false),
      name_regex_trace_ (),
      root_element_first_ (),
      root_element_last_ (),
      root_element_all_ (),
      root_element_none_ (),
      root_element_ (),
      root_element_specified_ (false),
      custom_type_ (),
      custom_type_specified_ (false),
      custom_type_regex_ (),
      custom_type_regex_specified_ (false),
      parts_ (1),
      parts_specified_ (false),
      parts_suffix_ ("-"),
      parts_suffix_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    void options::
    print_usage (::std::wostream& os)
    {
      os << "--generate-polymorphic       Generate polymorphism-aware code." << ::std::endl;

      os << "--polymorphic-type <type>    Indicate that <type> is a root of a polymorphic" << ::std::endl
         << "                             type hierarchy." << ::std::endl;

      os << "--polymorphic-type-all       Indicate that all types should be treated as" << ::std::endl
         << "                             polymorphic." << ::std::endl;

      os << "--polymorphic-plate <num>    Specify the polymorphic map plate the generated" << ::std::endl
         << "                             code should register on." << ::std::endl;

      os << "--ordered-type <type>        Indicate that element order in <type> is" << ::std::endl
         << "                             significant." << ::std::endl;

      os << "--ordered-type-derived       Automatically treat types derived from ordered" << ::std::endl
         << "                             bases as also ordered." << ::std::endl;

      os << "--ordered-type-mixed         Automatically treat complex types with mixed" << ::std::endl
         << "                             content as ordered." << ::std::endl;

      os << "--ordered-type-all           Indicate that element order in all types is" << ::std::endl
         << "                             significant." << ::std::endl;

      os << "--order-container <type>     Specify a custom class template that should be" << ::std::endl
         << "                             used as a container for the content order in" << ::std::endl
         << "                             ordered types instead of the default" << ::std::endl
         << "                             'std::vector'." << ::std::endl;

      os << "--generate-serialization     Generate serialization functions." << ::std::endl;

      os << "--generate-ostream           Generate ostream insertion operators" << ::std::endl
         << "                             ('operator<<') for generated types." << ::std::endl;

      os << "--generate-doxygen           Generate documentation comments suitable for" << ::std::endl
         << "                             extraction by the Doxygen documentation system." << ::std::endl;

      os << "--generate-comparison        Generate comparison operators ('operator==' and" << ::std::endl
         << "                             'operator!=') for complex types." << ::std::endl;

      os << "--generate-default-ctor      Generate default constructors even for types that" << ::std::endl
         << "                             have required members." << ::std::endl;

      os << "--generate-from-base-ctor    Generate constructors that expect an instance of a" << ::std::endl
         << "                             base type followed by all required members." << ::std::endl;

      os << "--suppress-assignment        Suppress the generation of copy assignment" << ::std::endl
         << "                             operators for complex types." << ::std::endl;

      os << "--generate-detach            Generate detach functions for required elements" << ::std::endl
         << "                             and attributes." << ::std::endl;

      os << "--generate-wildcard          Generate accessors and modifiers as well as" << ::std::endl
         << "                             parsing and serialization code for XML Schema" << ::std::endl
         << "                             wildcards ('any' and 'anyAttribute')." << ::std::endl;

      os << "--generate-any-type          Extract and store content of the XML Schema" << ::std::endl
         << "                             'anyType' type as a DOM fragment." << ::std::endl;

      os << "--generate-insertion <os>    Generate data representation stream insertion" << ::std::endl
         << "                             operators for the <os> output stream type." << ::std::endl;

      os << "--generate-extraction <is>   Generate data representation stream extraction" << ::std::endl
         << "                             constructors for the <is> input stream type." << ::std::endl;

      os << "--generate-forward           Generate a separate header file with forward" << ::std::endl
         << "                             declarations for the types being generated." << ::std::endl;

      os << "--suppress-parsing           Suppress the generation of the parsing functions" << ::std::endl
         << "                             and constructors." << ::std::endl;

      os << "--generate-element-type      Generate types instead of parsing and" << ::std::endl
         << "                             serialization functions for root elements." << ::std::endl;

      os << "--generate-element-map       Generate a root element map that allows uniform" << ::std::endl
         << "                             parsing and serialization of multiple root" << ::std::endl
         << "                             elements." << ::std::endl;

      os << "--generate-intellisense      Generate workarounds for IntelliSense bugs in" << ::std::endl
         << "                             Visual Studio 2005 (8.0)." << ::std::endl;

      os << "--omit-default-attributes    Omit attributes with default and fixed values from" << ::std::endl
         << "                             serialized XML documents." << ::std::endl;

      os << "--type-naming <style>        Specify the type naming convention that should be" << ::std::endl
         << "                             used in the generated code." << ::std::endl;

      os << "--function-naming <style>    Specify the function naming convention that should" << ::std::endl
         << "                             be used in the generated code." << ::std::endl;

      os << "--type-regex <regex>         Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema type names to C++" << ::std::endl
         << "                             type names." << ::std::endl;

      os << "--accessor-regex <regex>     Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema names of" << ::std::endl
         << "                             elements/attributes to C++ accessor function" << ::std::endl
         << "                             names." << ::std::endl;

      os << "--one-accessor-regex <regex> Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema names of" << ::std::endl
         << "                             elements/attributes with cardinality one to C++" << ::std::endl
         << "                             accessor function names." << ::std::endl;

      os << "--opt-accessor-regex <regex> Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema names of" << ::std::endl
         << "                             elements/attributes with cardinality optional to" << ::std::endl
         << "                             C++ accessor function names." << ::std::endl;

      os << "--seq-accessor-regex <regex> Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema names of" << ::std::endl
         << "                             elements/attributes with cardinality sequence to" << ::std::endl
         << "                             C++ accessor function names." << ::std::endl;

      os << "--modifier-regex <regex>     Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema names of" << ::std::endl
         << "                             elements/attributes to C++ modifier function" << ::std::endl
         << "                             names." << ::std::endl;

      os << "--one-modifier-regex <regex> Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema names of" << ::std::endl
         << "                             elements/attributes with cardinality one to C++" << ::std::endl
         << "                             modifier function names." << ::std::endl;

      os << "--opt-modifier-regex <regex> Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema names of" << ::std::endl
         << "                             elements/attributes with cardinality optional to" << ::std::endl
         << "                             C++ modifier function names." << ::std::endl;

      os << "--seq-modifier-regex <regex> Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema names of" << ::std::endl
         << "                             elements/attributes with cardinality sequence to" << ::std::endl
         << "                             C++ modifier function names." << ::std::endl;

      os << "--parser-regex <regex>       Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema element names to C++" << ::std::endl
         << "                             parsing function names." << ::std::endl;

      os << "--serializer-regex <regex>   Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema element names to C++" << ::std::endl
         << "                             serialization function names." << ::std::endl;

      os << "--const-regex <regex>        Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema-derived names to C++" << ::std::endl
         << "                             constant names." << ::std::endl;

      os << "--enumerator-regex <regex>   Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema enumeration values to" << ::std::endl
         << "                             C++ enumerator names." << ::std::endl;

      os << "--element-type-regex <regex> Add <regex> to the list of regular expressions" << ::std::endl
         << "                             used to translate XML Schema element names to C++" << ::std::endl
         << "                             element type names." << ::std::endl;

      os << "--name-regex-trace           Trace the process of applying regular expressions" << ::std::endl
         << "                             specified with the name transformation options." << ::std::endl;

      os << "--root-element-first         Treat only the first global element as a document" << ::std::endl
         << "                             root." << ::std::endl;

      os << "--root-element-last          Treat only the last global element as a document" << ::std::endl
         << "                             root." << ::std::endl;

      os << "--root-element-all           Treat all global elements as document roots." << ::std::endl;

      os << "--root-element-none          Do not treat any global elements as document" << ::std::endl
         << "                             roots." << ::std::endl;

      os << "--root-element <element>     Treat only <element> as a document root." << ::std::endl;

      os << "--custom-type <map>          Use a custom C++ type instead of the generated" << ::std::endl
         << "                             class." << ::std::endl;

      os << "--custom-type-regex <regex>  Use custom C++ types instead of the generated" << ::std::endl
         << "                             classes." << ::std::endl;

      os << "--parts <num>                Split generated source code into <num> parts." << ::std::endl;

      os << "--parts-suffix <suffix>      Use <suffix> instead of the default ''-'' to" << ::std::endl
         << "                             separate the file name from the part number." << ::std::endl;
    }

    typedef
    std::map<std::string, void (*) (options&, ::cli::scanner&)>
    _cli_options_map;

    static _cli_options_map _cli_options_map_;

    struct _cli_options_map_init
    {
      _cli_options_map_init ()
      {
        _cli_options_map_["--generate-polymorphic"] = 
        &::cli::thunk< options, bool, &options::generate_polymorphic_ >;
        _cli_options_map_["--polymorphic-type"] = 
        &::cli::thunk< options, NarrowStrings, &options::polymorphic_type_,
          &options::polymorphic_type_specified_ >;
        _cli_options_map_["--polymorphic-type-all"] = 
        &::cli::thunk< options, bool, &options::polymorphic_type_all_ >;
        _cli_options_map_["--polymorphic-plate"] = 
        &::cli::thunk< options, unsigned long, &options::polymorphic_plate_,
          &options::polymorphic_plate_specified_ >;
        _cli_options_map_["--ordered-type"] = 
        &::cli::thunk< options, NarrowStrings, &options::ordered_type_,
          &options::ordered_type_specified_ >;
        _cli_options_map_["--ordered-type-derived"] = 
        &::cli::thunk< options, bool, &options::ordered_type_derived_ >;
        _cli_options_map_["--ordered-type-mixed"] = 
        &::cli::thunk< options, bool, &options::ordered_type_mixed_ >;
        _cli_options_map_["--ordered-type-all"] = 
        &::cli::thunk< options, bool, &options::ordered_type_all_ >;
        _cli_options_map_["--order-container"] = 
        &::cli::thunk< options, NarrowString, &options::order_container_,
          &options::order_container_specified_ >;
        _cli_options_map_["--generate-serialization"] = 
        &::cli::thunk< options, bool, &options::generate_serialization_ >;
        _cli_options_map_["--generate-ostream"] = 
        &::cli::thunk< options, bool, &options::generate_ostream_ >;
        _cli_options_map_["--generate-doxygen"] = 
        &::cli::thunk< options, bool, &options::generate_doxygen_ >;
        _cli_options_map_["--generate-comparison"] = 
        &::cli::thunk< options, bool, &options::generate_comparison_ >;
        _cli_options_map_["--generate-default-ctor"] = 
        &::cli::thunk< options, bool, &options::generate_default_ctor_ >;
        _cli_options_map_["--generate-from-base-ctor"] = 
        &::cli::thunk< options, bool, &options::generate_from_base_ctor_ >;
        _cli_options_map_["--suppress-assignment"] = 
        &::cli::thunk< options, bool, &options::suppress_assignment_ >;
        _cli_options_map_["--generate-detach"] = 
        &::cli::thunk< options, bool, &options::generate_detach_ >;
        _cli_options_map_["--generate-wildcard"] = 
        &::cli::thunk< options, bool, &options::generate_wildcard_ >;
        _cli_options_map_["--generate-any-type"] = 
        &::cli::thunk< options, bool, &options::generate_any_type_ >;
        _cli_options_map_["--generate-insertion"] = 
        &::cli::thunk< options, NarrowStrings, &options::generate_insertion_,
          &options::generate_insertion_specified_ >;
        _cli_options_map_["--generate-extraction"] = 
        &::cli::thunk< options, NarrowStrings, &options::generate_extraction_,
          &options::generate_extraction_specified_ >;
        _cli_options_map_["--generate-forward"] = 
        &::cli::thunk< options, bool, &options::generate_forward_ >;
        _cli_options_map_["--suppress-parsing"] = 
        &::cli::thunk< options, bool, &options::suppress_parsing_ >;
        _cli_options_map_["--generate-element-type"] = 
        &::cli::thunk< options, bool, &options::generate_element_type_ >;
        _cli_options_map_["--generate-element-map"] = 
        &::cli::thunk< options, bool, &options::generate_element_map_ >;
        _cli_options_map_["--generate-intellisense"] = 
        &::cli::thunk< options, bool, &options::generate_intellisense_ >;
        _cli_options_map_["--omit-default-attributes"] = 
        &::cli::thunk< options, bool, &options::omit_default_attributes_ >;
        _cli_options_map_["--type-naming"] = 
        &::cli::thunk< options, NarrowString, &options::type_naming_,
          &options::type_naming_specified_ >;
        _cli_options_map_["--function-naming"] = 
        &::cli::thunk< options, NarrowString, &options::function_naming_,
          &options::function_naming_specified_ >;
        _cli_options_map_["--type-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::type_regex_,
          &options::type_regex_specified_ >;
        _cli_options_map_["--accessor-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::accessor_regex_,
          &options::accessor_regex_specified_ >;
        _cli_options_map_["--one-accessor-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::one_accessor_regex_,
          &options::one_accessor_regex_specified_ >;
        _cli_options_map_["--opt-accessor-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::opt_accessor_regex_,
          &options::opt_accessor_regex_specified_ >;
        _cli_options_map_["--seq-accessor-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::seq_accessor_regex_,
          &options::seq_accessor_regex_specified_ >;
        _cli_options_map_["--modifier-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::modifier_regex_,
          &options::modifier_regex_specified_ >;
        _cli_options_map_["--one-modifier-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::one_modifier_regex_,
          &options::one_modifier_regex_specified_ >;
        _cli_options_map_["--opt-modifier-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::opt_modifier_regex_,
          &options::opt_modifier_regex_specified_ >;
        _cli_options_map_["--seq-modifier-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::seq_modifier_regex_,
          &options::seq_modifier_regex_specified_ >;
        _cli_options_map_["--parser-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::parser_regex_,
          &options::parser_regex_specified_ >;
        _cli_options_map_["--serializer-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::serializer_regex_,
          &options::serializer_regex_specified_ >;
        _cli_options_map_["--const-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::const_regex_,
          &options::const_regex_specified_ >;
        _cli_options_map_["--enumerator-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::enumerator_regex_,
          &options::enumerator_regex_specified_ >;
        _cli_options_map_["--element-type-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::element_type_regex_,
          &options::element_type_regex_specified_ >;
        _cli_options_map_["--name-regex-trace"] = 
        &::cli::thunk< options, bool, &options::name_regex_trace_ >;
        _cli_options_map_["--root-element-first"] = 
        &::cli::thunk< options, bool, &options::root_element_first_ >;
        _cli_options_map_["--root-element-last"] = 
        &::cli::thunk< options, bool, &options::root_element_last_ >;
        _cli_options_map_["--root-element-all"] = 
        &::cli::thunk< options, bool, &options::root_element_all_ >;
        _cli_options_map_["--root-element-none"] = 
        &::cli::thunk< options, bool, &options::root_element_none_ >;
        _cli_options_map_["--root-element"] = 
        &::cli::thunk< options, NarrowStrings, &options::root_element_,
          &options::root_element_specified_ >;
        _cli_options_map_["--custom-type"] = 
        &::cli::thunk< options, NarrowStrings, &options::custom_type_,
          &options::custom_type_specified_ >;
        _cli_options_map_["--custom-type-regex"] = 
        &::cli::thunk< options, NarrowStrings, &options::custom_type_regex_,
          &options::custom_type_regex_specified_ >;
        _cli_options_map_["--parts"] = 
        &::cli::thunk< options, std::size_t, &options::parts_,
          &options::parts_specified_ >;
        _cli_options_map_["--parts-suffix"] = 
        &::cli::thunk< options, NarrowString, &options::parts_suffix_,
          &options::parts_suffix_specified_ >;
      }
    };

    static _cli_options_map_init _cli_options_map_init_;

    bool options::
    _parse (const char* o, ::cli::scanner& s)
    {
      _cli_options_map::const_iterator i (_cli_options_map_.find (o));

      if (i != _cli_options_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // options base
      //
      if (::CXX::options::_parse (o, s))
        return true;

      return false;
    }

    void options::
    _parse (::cli::scanner& s,
            ::cli::unknown_mode opt_mode,
            ::cli::unknown_mode arg_mode)
    {
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          s.skip ();
          opt = false;
          continue;
        }

        if (opt && _parse (o, s));
        else if (opt && std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          switch (opt_mode)
          {
            case ::cli::unknown_mode::skip:
            {
              s.skip ();
              continue;
            }
            case ::cli::unknown_mode::stop:
            {
              break;
            }
            case ::cli::unknown_mode::fail:
            {
              throw ::cli::unknown_option (o);
            }
          }

          break;
        }
        else
        {
          switch (arg_mode)
          {
            case ::cli::unknown_mode::skip:
            {
              s.skip ();
              continue;
            }
            case ::cli::unknown_mode::stop:
            {
              break;
            }
            case ::cli::unknown_mode::fail:
            {
              throw ::cli::unknown_argument (o);
            }
          }

          break;
        }
      }
    }
  }
}

// Begin epilogue.
//
//
// End epilogue.

