/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMTokenList.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMTokenListPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_TOKEN_LIST_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_TOKEN_LIST, WebKitDOMDOMTokenListPrivate)

typedef struct _WebKitDOMDOMTokenListPrivate {
    RefPtr<WebCore::DOMTokenList> coreObject;
} WebKitDOMDOMTokenListPrivate;

namespace WebKit {

WebKitDOMDOMTokenList* kit(WebCore::DOMTokenList* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_TOKEN_LIST(ret);

    return wrapDOMTokenList(obj);
}

WebCore::DOMTokenList* core(WebKitDOMDOMTokenList* request)
{
    return request ? static_cast<WebCore::DOMTokenList*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMTokenList* wrapDOMTokenList(WebCore::DOMTokenList* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_TOKEN_LIST(g_object_new(WEBKIT_TYPE_DOM_DOM_TOKEN_LIST, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMDOMTokenList, webkit_dom_dom_token_list, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_dom_token_list_finalize(GObject* object)
{
    WebKitDOMDOMTokenListPrivate* priv = WEBKIT_DOM_DOM_TOKEN_LIST_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMDOMTokenListPrivate();
    G_OBJECT_CLASS(webkit_dom_dom_token_list_parent_class)->finalize(object);
}

static void webkit_dom_dom_token_list_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDOMTokenList* self = WEBKIT_DOM_DOM_TOKEN_LIST(object);
    WebCore::DOMTokenList* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_LENGTH: {
        g_value_set_ulong(value, coreSelf->length());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_dom_token_list_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_token_list_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMDOMTokenListPrivate* priv = WEBKIT_DOM_DOM_TOKEN_LIST_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMTokenList*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_dom_token_list_class_init(WebKitDOMDOMTokenListClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMTokenListPrivate));
    gobjectClass->constructor = webkit_dom_dom_token_list_constructor;
    gobjectClass->finalize = webkit_dom_dom_token_list_finalize;
    gobjectClass->get_property = webkit_dom_dom_token_list_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "dom_token_list_length", /* short description */
                                                           "read-only  gulong DOMTokenList.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_dom_token_list_init(WebKitDOMDOMTokenList* request)
{
    WebKitDOMDOMTokenListPrivate* priv = WEBKIT_DOM_DOM_TOKEN_LIST_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMTokenListPrivate();
}

gchar*
webkit_dom_dom_token_list_item(WebKitDOMDOMTokenList* self, gulong index)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_TOKEN_LIST(self), 0);
    WebCore::DOMTokenList* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->item(index));
    return result;
}

gboolean
webkit_dom_dom_token_list_contains(WebKitDOMDOMTokenList* self, const gchar* token, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_TOKEN_LIST(self), FALSE);
    g_return_val_if_fail(token, FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::DOMTokenList* item = WebKit::core(self);
    WTF::String convertedToken = WTF::String::fromUTF8(token);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->contains(convertedToken, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

void
webkit_dom_dom_token_list_add(WebKitDOMDOMTokenList* self, const gchar* tokens, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_TOKEN_LIST(self));
    g_return_if_fail(tokens);
    g_return_if_fail(!error || !*error);
    WebCore::DOMTokenList* item = WebKit::core(self);
    WTF::String convertedTokens = WTF::String::fromUTF8(tokens);
    WebCore::ExceptionCode ec = 0;
    item->add(convertedTokens, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_dom_token_list_remove(WebKitDOMDOMTokenList* self, const gchar* tokens, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_TOKEN_LIST(self));
    g_return_if_fail(tokens);
    g_return_if_fail(!error || !*error);
    WebCore::DOMTokenList* item = WebKit::core(self);
    WTF::String convertedTokens = WTF::String::fromUTF8(tokens);
    WebCore::ExceptionCode ec = 0;
    item->remove(convertedTokens, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gboolean
webkit_dom_dom_token_list_toggle(WebKitDOMDOMTokenList* self, const gchar* token, gboolean force, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_TOKEN_LIST(self), FALSE);
    g_return_val_if_fail(token, FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::DOMTokenList* item = WebKit::core(self);
    WTF::String convertedToken = WTF::String::fromUTF8(token);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->toggle(convertedToken, force, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

gulong
webkit_dom_dom_token_list_get_length(WebKitDOMDOMTokenList* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_TOKEN_LIST(self), 0);
    WebCore::DOMTokenList* item = WebKit::core(self);
    gulong result = item->length();
    return result;
}

