/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGMaskElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGMaskElement.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGMaskElementTableValues[] =
{
    { "maskUnits", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementMaskUnits), (intptr_t)0, NoIntrinsic },
    { "maskContentUnits", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementMaskContentUnits), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementHeight), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementXmllang), (intptr_t)setJSSVGMaskElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementXmlspace), (intptr_t)setJSSVGMaskElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMaskElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGMaskElementTable = { 36, 31, JSSVGMaskElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGMaskElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGMaskElementConstructorTable = { 1, 0, JSSVGMaskElementConstructorTableValues, 0 };
const ClassInfo JSSVGMaskElementConstructor::s_info = { "SVGMaskElementConstructor", &Base::s_info, &JSSVGMaskElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGMaskElementConstructor) };

JSSVGMaskElementConstructor::JSSVGMaskElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGMaskElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGMaskElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGMaskElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMaskElementConstructor, JSDOMWrapper>(exec, &JSSVGMaskElementConstructorTable, jsCast<JSSVGMaskElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGMaskElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGMaskElementConstructor, JSDOMWrapper>(exec, &JSSVGMaskElementConstructorTable, jsCast<JSSVGMaskElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGMaskElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMaskElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGMaskElementPrototypeTable = { 2, 1, JSSVGMaskElementPrototypeTableValues, 0 };
const ClassInfo JSSVGMaskElementPrototype::s_info = { "SVGMaskElementPrototype", &Base::s_info, &JSSVGMaskElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGMaskElementPrototype) };

JSObject* JSSVGMaskElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGMaskElement>(exec, globalObject);
}

bool JSSVGMaskElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGMaskElementPrototype* thisObject = jsCast<JSSVGMaskElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGMaskElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGMaskElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGMaskElementPrototype* thisObject = jsCast<JSSVGMaskElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGMaskElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGMaskElement::s_info = { "SVGMaskElement", &Base::s_info, &JSSVGMaskElementTable, 0 , CREATE_METHOD_TABLE(JSSVGMaskElement) };

JSSVGMaskElement::JSSVGMaskElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGMaskElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGMaskElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGMaskElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGMaskElementPrototype::create(exec->globalData(), globalObject, JSSVGMaskElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGMaskElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGMaskElement* thisObject = jsCast<JSSVGMaskElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGMaskElement, Base>(exec, &JSSVGMaskElementTable, thisObject, propertyName, slot);
}

bool JSSVGMaskElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGMaskElement* thisObject = jsCast<JSSVGMaskElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGMaskElement, Base>(exec, &JSSVGMaskElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGMaskElementMaskUnits(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->maskUnitsAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGMaskElementMaskContentUnits(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->maskContentUnitsAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGMaskElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGMaskElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGMaskElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGMaskElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGMaskElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGMaskElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGMaskElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGMaskElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGMaskElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGMaskElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGMaskElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMaskElement* domObject = jsCast<JSSVGMaskElement*>(asObject(slotBase));
    return JSSVGMaskElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGMaskElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGMaskElement* thisObject = jsCast<JSSVGMaskElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGMaskElement, Base>(exec, propertyName, value, &JSSVGMaskElementTable, thisObject, slot);
}

void setJSSVGMaskElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(thisObject);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGMaskElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(thisObject);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGMaskElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGMaskElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGMaskElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMaskElement::s_info))
        return throwVMTypeError(exec);
    JSSVGMaskElement* castedThis = jsCast<JSSVGMaskElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMaskElement::s_info);
    SVGMaskElement* impl = static_cast<SVGMaskElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
