/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLTableRowElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLElementPrivate.h"
#include "WebKitDOMHTMLTableRowElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLTableRowElement* kit(WebCore::HTMLTableRowElement* obj)
{
    return WEBKIT_DOM_HTML_TABLE_ROW_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLTableRowElement* core(WebKitDOMHTMLTableRowElement* request)
{
    return request ? static_cast<WebCore::HTMLTableRowElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLTableRowElement* wrapHTMLTableRowElement(WebCore::HTMLTableRowElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_TABLE_ROW_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_TABLE_ROW_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLTableRowElement, webkit_dom_html_table_row_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_ROW_INDEX,
    PROP_SECTION_ROW_INDEX,
    PROP_CELLS,
    PROP_ALIGN,
    PROP_BG_COLOR,
    PROP_CH,
    PROP_CH_OFF,
    PROP_V_ALIGN,
};

static void webkit_dom_html_table_row_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLTableRowElement* self = WEBKIT_DOM_HTML_TABLE_ROW_ELEMENT(object);
    WebCore::HTMLTableRowElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_BG_COLOR: {
        coreSelf->setAttribute(WebCore::HTMLNames::bgcolorAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CH: {
        coreSelf->setAttribute(WebCore::HTMLNames::charAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CH_OFF: {
        coreSelf->setAttribute(WebCore::HTMLNames::charoffAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_V_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::valignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_table_row_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLTableRowElement* self = WEBKIT_DOM_HTML_TABLE_ROW_ELEMENT(object);
    WebCore::HTMLTableRowElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ROW_INDEX: {
        g_value_set_long(value, coreSelf->rowIndex());
        break;
    }
    case PROP_SECTION_ROW_INDEX: {
        g_value_set_long(value, coreSelf->sectionRowIndex());
        break;
    }
    case PROP_CELLS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->cells();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_BG_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr)));
        break;
    }
    case PROP_CH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::charAttr)));
        break;
    }
    case PROP_CH_OFF: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::charoffAttr)));
        break;
    }
    case PROP_V_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::valignAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_table_row_element_class_init(WebKitDOMHTMLTableRowElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_table_row_element_set_property;
    gobjectClass->get_property = webkit_dom_html_table_row_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ROW_INDEX,
                                    g_param_spec_long("row-index", /* name */
                                                           "html_table_row_element_row-index", /* short description */
                                                           "read-only  glong HTMLTableRowElement.row-index", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SECTION_ROW_INDEX,
                                    g_param_spec_long("section-row-index", /* name */
                                                           "html_table_row_element_section-row-index", /* short description */
                                                           "read-only  glong HTMLTableRowElement.section-row-index", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CELLS,
                                    g_param_spec_object("cells", /* name */
                                                           "html_table_row_element_cells", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLTableRowElement.cells", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "html_table_row_element_align", /* short description */
                                                           "read-write  gchar* HTMLTableRowElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BG_COLOR,
                                    g_param_spec_string("bg-color", /* name */
                                                           "html_table_row_element_bg-color", /* short description */
                                                           "read-write  gchar* HTMLTableRowElement.bg-color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CH,
                                    g_param_spec_string("ch", /* name */
                                                           "html_table_row_element_ch", /* short description */
                                                           "read-write  gchar* HTMLTableRowElement.ch", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CH_OFF,
                                    g_param_spec_string("ch-off", /* name */
                                                           "html_table_row_element_ch-off", /* short description */
                                                           "read-write  gchar* HTMLTableRowElement.ch-off", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_V_ALIGN,
                                    g_param_spec_string("v-align", /* name */
                                                           "html_table_row_element_v-align", /* short description */
                                                           "read-write  gchar* HTMLTableRowElement.v-align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_table_row_element_init(WebKitDOMHTMLTableRowElement* request)
{
}

WebKitDOMHTMLElement*
webkit_dom_html_table_row_element_insert_cell(WebKitDOMHTMLTableRowElement* self, glong index, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::HTMLElement> gobjectResult = WTF::getPtr(item->insertCell(index, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_table_row_element_delete_cell(WebKitDOMHTMLTableRowElement* self, glong index, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->deleteCell(index, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

glong
webkit_dom_html_table_row_element_get_row_index(WebKitDOMHTMLTableRowElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self), 0);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    glong result = item->rowIndex();
    return result;
}

glong
webkit_dom_html_table_row_element_get_section_row_index(WebKitDOMHTMLTableRowElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self), 0);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    glong result = item->sectionRowIndex();
    return result;
}

WebKitDOMHTMLCollection*
webkit_dom_html_table_row_element_get_cells(WebKitDOMHTMLTableRowElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self), 0);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->cells());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_table_row_element_get_align(WebKitDOMHTMLTableRowElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self), 0);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_html_table_row_element_set_align(WebKitDOMHTMLTableRowElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

gchar*
webkit_dom_html_table_row_element_get_bg_color(WebKitDOMHTMLTableRowElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self), 0);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr));
    return result;
}

void
webkit_dom_html_table_row_element_set_bg_color(WebKitDOMHTMLTableRowElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::bgcolorAttr, convertedValue);
}

gchar*
webkit_dom_html_table_row_element_get_ch(WebKitDOMHTMLTableRowElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self), 0);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::charAttr));
    return result;
}

void
webkit_dom_html_table_row_element_set_ch(WebKitDOMHTMLTableRowElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::charAttr, convertedValue);
}

gchar*
webkit_dom_html_table_row_element_get_ch_off(WebKitDOMHTMLTableRowElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self), 0);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::charoffAttr));
    return result;
}

void
webkit_dom_html_table_row_element_set_ch_off(WebKitDOMHTMLTableRowElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::charoffAttr, convertedValue);
}

gchar*
webkit_dom_html_table_row_element_get_v_align(WebKitDOMHTMLTableRowElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self), 0);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::valignAttr));
    return result;
}

void
webkit_dom_html_table_row_element_set_v_align(WebKitDOMHTMLTableRowElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_ROW_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableRowElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::valignAttr, convertedValue);
}

