/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGLength.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include "SVGLength.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGLengthTableValues[] =
{
    { "unitType", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthUnitType), (intptr_t)0, NoIntrinsic },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthValue), (intptr_t)setJSSVGLengthValue, NoIntrinsic },
    { "valueInSpecifiedUnits", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthValueInSpecifiedUnits), (intptr_t)setJSSVGLengthValueInSpecifiedUnits, NoIntrinsic },
    { "valueAsString", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthValueAsString), (intptr_t)setJSSVGLengthValueAsString, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLengthTable = { 17, 15, JSSVGLengthTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGLengthConstructorTableValues[] =
{
    { "SVG_LENGTHTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_NUMBER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_NUMBER), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_PERCENTAGE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_PERCENTAGE), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_EMS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_EMS), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_EXS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_EXS), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_PX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_PX), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_CM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_CM), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_MM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_MM), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_IN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_IN), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_PT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_PT), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_PC", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_PC), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLengthConstructorTable = { 33, 31, JSSVGLengthConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGLength::SVG_LENGTHTYPE_UNKNOWN, SVGLengthEnumSVG_LENGTHTYPE_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGLength::SVG_LENGTHTYPE_NUMBER, SVGLengthEnumSVG_LENGTHTYPE_NUMBERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGLength::SVG_LENGTHTYPE_PERCENTAGE, SVGLengthEnumSVG_LENGTHTYPE_PERCENTAGEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == SVGLength::SVG_LENGTHTYPE_EMS, SVGLengthEnumSVG_LENGTHTYPE_EMSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == SVGLength::SVG_LENGTHTYPE_EXS, SVGLengthEnumSVG_LENGTHTYPE_EXSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == SVGLength::SVG_LENGTHTYPE_PX, SVGLengthEnumSVG_LENGTHTYPE_PXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == SVGLength::SVG_LENGTHTYPE_CM, SVGLengthEnumSVG_LENGTHTYPE_CMIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == SVGLength::SVG_LENGTHTYPE_MM, SVGLengthEnumSVG_LENGTHTYPE_MMIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == SVGLength::SVG_LENGTHTYPE_IN, SVGLengthEnumSVG_LENGTHTYPE_INIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(9 == SVGLength::SVG_LENGTHTYPE_PT, SVGLengthEnumSVG_LENGTHTYPE_PTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(10 == SVGLength::SVG_LENGTHTYPE_PC, SVGLengthEnumSVG_LENGTHTYPE_PCIsWrongUseDoNotCheckConstants);

const ClassInfo JSSVGLengthConstructor::s_info = { "SVGLengthConstructor", &Base::s_info, &JSSVGLengthConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGLengthConstructor) };

JSSVGLengthConstructor::JSSVGLengthConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGLengthConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGLengthPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGLengthConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLengthConstructor, JSDOMWrapper>(exec, &JSSVGLengthConstructorTable, jsCast<JSSVGLengthConstructor*>(cell), propertyName, slot);
}

bool JSSVGLengthConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGLengthConstructor, JSDOMWrapper>(exec, &JSSVGLengthConstructorTable, jsCast<JSSVGLengthConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGLengthPrototypeTableValues[] =
{
    { "SVG_LENGTHTYPE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_NUMBER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_NUMBER), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_PERCENTAGE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_PERCENTAGE), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_EMS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_EMS), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_EXS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_EXS), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_PX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_PX), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_CM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_CM), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_MM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_MM), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_IN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_IN), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_PT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_PT), (intptr_t)0, NoIntrinsic },
    { "SVG_LENGTHTYPE_PC", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLengthSVG_LENGTHTYPE_PC), (intptr_t)0, NoIntrinsic },
    { "newValueSpecifiedUnits", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLengthPrototypeFunctionNewValueSpecifiedUnits), (intptr_t)2, NoIntrinsic },
    { "convertToSpecifiedUnits", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGLengthPrototypeFunctionConvertToSpecifiedUnits), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLengthPrototypeTable = { 33, 31, JSSVGLengthPrototypeTableValues, 0 };
const ClassInfo JSSVGLengthPrototype::s_info = { "SVGLengthPrototype", &Base::s_info, &JSSVGLengthPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGLengthPrototype) };

JSObject* JSSVGLengthPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGLength>(exec, globalObject);
}

bool JSSVGLengthPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGLengthPrototype* thisObject = jsCast<JSSVGLengthPrototype*>(cell);
    return getStaticPropertySlot<JSSVGLengthPrototype, JSObject>(exec, &JSSVGLengthPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGLengthPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGLengthPrototype* thisObject = jsCast<JSSVGLengthPrototype*>(object);
    return getStaticPropertyDescriptor<JSSVGLengthPrototype, JSObject>(exec, &JSSVGLengthPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGLength::s_info = { "SVGLength", &Base::s_info, &JSSVGLengthTable, 0 , CREATE_METHOD_TABLE(JSSVGLength) };

JSSVGLength::JSSVGLength(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPropertyTearOff<SVGLength> > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGLength::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGLength::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGLengthPrototype::create(exec->globalData(), globalObject, JSSVGLengthPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGLength::destroy(JSC::JSCell* cell)
{
    JSSVGLength* thisObject = static_cast<JSSVGLength*>(cell);
    thisObject->JSSVGLength::~JSSVGLength();
}

JSSVGLength::~JSSVGLength()
{
    releaseImplIfNotNull();
}

bool JSSVGLength::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGLength* thisObject = jsCast<JSSVGLength*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGLength, Base>(exec, &JSSVGLengthTable, thisObject, propertyName, slot);
}

bool JSSVGLength::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGLength* thisObject = jsCast<JSSVGLength*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGLength, Base>(exec, &JSSVGLengthTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGLengthUnitType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLength* castedThis = jsCast<JSSVGLength*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLength& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.unitType());
    return result;
}


JSValue jsSVGLengthValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLength* castedThis = jsCast<JSSVGLength*>(asObject(slotBase));
    return castedThis->value(exec);
}


JSValue jsSVGLengthValueInSpecifiedUnits(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLength* castedThis = jsCast<JSSVGLength*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLength& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.valueInSpecifiedUnits());
    return result;
}


JSValue jsSVGLengthValueAsString(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLength* castedThis = jsCast<JSSVGLength*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLength& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsStringWithCache(exec, impl.valueAsString());
    return result;
}


JSValue jsSVGLengthConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLength* domObject = jsCast<JSSVGLength*>(asObject(slotBase));
    return JSSVGLength::getConstructor(exec, domObject->globalObject());
}

void JSSVGLength::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGLength* thisObject = jsCast<JSSVGLength*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGLength, Base>(exec, propertyName, value, &JSSVGLengthTable, thisObject, slot);
}

void setJSSVGLengthValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSSVGLength*>(thisObject)->setValue(exec, value);
}


void setJSSVGLengthValueInSpecifiedUnits(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGLength* castedThis = jsCast<JSSVGLength*>(thisObject);
    SVGPropertyTearOff<SVGLength> * impl = static_cast<SVGPropertyTearOff<SVGLength> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGLength& podImpl = impl->propertyReference();
    podImpl.setValueInSpecifiedUnits(value.toFloat(exec));
    impl->commitChange();
}


void setJSSVGLengthValueAsString(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGLength* castedThis = jsCast<JSSVGLength*>(thisObject);
    SVGPropertyTearOff<SVGLength> * impl = static_cast<SVGPropertyTearOff<SVGLength> *>(castedThis->impl());
    ExceptionCode ec = 0;
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGLength& podImpl = impl->propertyReference();
    podImpl.setValueAsString(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
    if (!ec)
        impl->commitChange();
}


JSValue JSSVGLength::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGLengthConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGLengthPrototypeFunctionNewValueSpecifiedUnits(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLength::s_info))
        return throwVMTypeError(exec);
    JSSVGLength* castedThis = jsCast<JSSVGLength*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLength::s_info);
    SVGPropertyTearOff<SVGLength> * impl = static_cast<SVGPropertyTearOff<SVGLength> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGLength& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned short unitType(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float valueInSpecifiedUnits(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    podImpl.newValueSpecifiedUnits(unitType, valueInSpecifiedUnits, ec);
    setDOMException(exec, ec);
    if (!ec)
        impl->commitChange();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGLengthPrototypeFunctionConvertToSpecifiedUnits(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGLength::s_info))
        return throwVMTypeError(exec);
    JSSVGLength* castedThis = jsCast<JSSVGLength*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGLength::s_info);
    return JSValue::encode(castedThis->convertToSpecifiedUnits(exec));
}

// Constant getters

JSValue jsSVGLengthSVG_LENGTHTYPE_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGLengthSVG_LENGTHTYPE_NUMBER(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGLengthSVG_LENGTHTYPE_PERCENTAGE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGLengthSVG_LENGTHTYPE_EMS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsSVGLengthSVG_LENGTHTYPE_EXS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsSVGLengthSVG_LENGTHTYPE_PX(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

JSValue jsSVGLengthSVG_LENGTHTYPE_CM(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(6));
}

JSValue jsSVGLengthSVG_LENGTHTYPE_MM(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(7));
}

JSValue jsSVGLengthSVG_LENGTHTYPE_IN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(8));
}

JSValue jsSVGLengthSVG_LENGTHTYPE_PT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(9));
}

JSValue jsSVGLengthSVG_LENGTHTYPE_PC(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(10));
}

static inline bool isObservable(JSSVGLength* jsSVGLength)
{
    if (jsSVGLength->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGLengthOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGLength* jsSVGLength = jsCast<JSSVGLength*>(handle.get().asCell());
    if (!isObservable(jsSVGLength))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGLengthOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGLength* jsSVGLength = jsCast<JSSVGLength*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGLength->impl(), jsSVGLength);
    jsSVGLength->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGLength> * impl)
{
    return wrap<JSSVGLength, SVGPropertyTearOff<SVGLength> >(exec, globalObject, impl);
}

SVGPropertyTearOff<SVGLength> * toSVGLength(JSC::JSValue value)
{
    return value.inherits(&JSSVGLength::s_info) ? jsCast<JSSVGLength*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
