/* Do not edit this file, make creates it */
/*
 * host.defs: Hosttype/Machtype etc.
 */
/*-
 * Copyright (c) 1980, 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "sh.h"



#if ((defined(mips64) || defined(__mips64__) || defined(__mips64)) && (defined(MIPSEL)))
# define M_mips64el
#endif


#if ((defined(mips64) || defined(__mips64__) || defined(__mips64)) && (defined(MIPSEB)))
# define M_mips64eb
#endif


#if (!(defined(M_mips64el)) && (defined(mips) || defined(__mips__) || defined(__mips)) && (defined(MIPSEL)))
# define M_mipsel
#endif


#if (!(defined(M_mips64eb)) && (defined(mips) || defined(__mips__) || defined(__mips)) && (defined(MIPSEB)))
# define M_mipseb
#endif


#if ((defined(amd64) || defined(__amd64__) || defined(__amd64)) || (defined(x86_64) || defined(__x86_64__) || defined(__x86_64)))
# define M_amd64
#endif


#if (defined(i386) || defined(__i386__) || defined(__i386))
# define M_i386
#endif


#if (defined(i486) || defined(__i486__) || defined(__i486))
# define M_i486
#endif


#if (defined(i586) || defined(__i586__) || defined(__i586))
# define M_i586
#endif


#if (defined(i686) || defined(__i686__) || defined(__i686))
# define M_i686
#endif


#if ((defined(M_i386)) || (defined(M_i486)) || (defined(M_i586)))
# define M_intel
#endif




#if ((defined(ns32000) || defined(__ns32000__) || defined(__ns32000)))
static char *
isamultimax(int flag)
{
    if (access("/Umax.image", F_OK) == 0)
	return "multimax";
    else 
	return flag ? "mach" : "ns32000";
}
#endif




#if ((defined(cray) || defined(__cray__) || defined(__cray)))
/*  
 * On crays, find the current machine type via the target() syscall
 * We need ctype.h to convert the name returned to lower case
 */
# include <sys/target.h> 
# include <ctype.h>
# include <string.h>

/* From: hpa@hook.eecs.nwu.edu (H. Peter Anvin) */
static char *
getcray(void)
{
# ifdef MC_GET_SYSTEM /* If we have target() */
    struct target data;

    if (target(MC_GET_SYSTEM, &data) != -1) {
	static char hosttype_buf[sizeof(data.mc_pmt)+1];
	unsigned char *p = (unsigned char *) &(data.mc_pmt);
	char *q = hosttype_buf;
	int n;

	/* 
	 * Copy to buffer and convert to lower case 
	 * String may not be null-terminated, so keep a counter
	 */
	for (n = 0; *p && n < sizeof(data.mc_pmt); n++)
	  *q++ = tolower(p[n]);

	*q = '\0';

	/* replace dashes with underscores if present */
	while ((q = strchr(hosttype_buf, '-')) != NULL)
	    *q = '_';
	return hosttype_buf;	/* Return in static buffer */
    }
    else
# endif /* MC_GET_SYSTEM */
	return "cray";		/* target() failed */
}
#endif




#if ((defined(convex) || defined(__convex__) || defined(__convex)))
/*  
 * On convex, find the current machine type via the getsysinfo() syscall
 */
#include <sys/sysinfo.h> 

/* From: fox@convex.com (David DeSimone) */
static char *
getconvex(void)
{
    struct system_information  sysinfo;
    static char	 result[8];

    if (getsysinfo(SYSINFO_SIZE, &sysinfo) == -1)
	return "convex";

    switch(sysinfo.cpu_type) {
#ifdef SI_CPUTYPE_C1
    case SI_CPUTYPE_C1:
	return "c1";
#endif

#ifdef SI_CPUTYPE_C2
    case SI_CPUTYPE_C2:
	return "c2";
#endif

#ifdef SI_CPUTYPE_C2MP
    case SI_CPUTYPE_C2MP:
	(void) strcpy(result, "c2X0");
	result[2] = sysinfo.cpu_count + '0';
	return result;
#endif

#ifdef SI_CPUTYPE_C34
    case SI_CPUTYPE_C34:
	(void) strcpy(result, "c34X0");
	result[3] = sysinfo.cpu_count + '0';
	return result;
#endif

#ifdef SI_CPUTYPE_C38
    case SI_CPUTYPE_C38:
	(void) strcpy(result, "c38X0");
	result[3] = sysinfo.cpu_count + '0';
	return result;
#endif

#ifdef SI_CPUTYPE_C46
    case SI_CPUTYPE_C46:
	(void) strcpy(result, "c46X0");
	result[3] = sysinfo.cpu_count + '0';
	return result;
#endif

    default:
	return "convex";
    }
}
#endif



#if ((defined(linux) || defined(__linux__) || defined(__linux)) || (defined(CYGWIN) || defined(__CYGWIN__) || defined(__CYGWIN)) || (defined(GNU) || defined(__GNU__) || defined(__GNU)) || (defined(GLIBC) || defined(__GLIBC__) || defined(__GLIBC)))
# include "tw.h"
#include <sys/utsname.h>
static char mach[256];
static char host[256];
static char ostype[32];
static void populate(void)
{
	struct utsname uts;
	int e = uname(&uts);
	const char *p = short2str(tgetenv(STROSTYPE));
	if (p == NULL) {
#if defined(__ANDROID__)
		p = "android";
#elif defined(__CYGWIN__)
		p = "cygwin";
#else
		p = "linux";
#endif
	}
	xsnprintf(ostype, sizeof(ostype), "%s", p);
	xsnprintf(mach, sizeof(mach), "%s", e != -1 ? uts.machine : "unknown");
	xsnprintf(host, sizeof(host), "%s-%s",
	    e != -1 ? uts.machine : "unknown", ostype);
}

static char *
getmach(void)
{
    if (!mach[0])
	populate();
    return mach;
}

static char *
gethost(void)
{
    if (!host[0])
	populate();
    return host;
}

static char *
getostype(void)
{
    if (!ostype[0])
	populate();
    return ostype;
}

#endif

void
getmachine(void)
{
     const char *hosttype;
     const char *ostype;
     const char *vendor;
     const char *machtype;





#if ((defined(HOSTTYPE) || defined(__HOSTTYPE__) || defined(__HOSTTYPE)))
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = HOSTTYPE;
# endif
#endif




#if ((defined(PARAGON) || defined(__PARAGON__) || defined(__PARAGON)))
    /* Intel Paragon running OSF/1 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "paragon";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "osf1";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(AMIX) || defined(__AMIX__) || defined(__AMIX)))
    /* Amiga running Amix 2.02 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "commodore";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "amiga";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "Amix";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
#endif




#if ((defined(accel) || defined(__accel__) || defined(__accel)))
    /* celerity Accel */
# if !defined(_vendor_)
# define _vendor_
    vendor = "celerity";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "celerityACCEL";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "unix";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "accel";
# endif
#endif




#if ((defined(_VMS_POSIX)))
    /* digital vax or alpha running vms posix */
# if !defined(_vendor_)
# define _vendor_
    vendor = "dec";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "VMS-POSIX";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "vms";
# endif
# if ((defined(alpha) || defined(__alpha__) || defined(__alpha))) && !defined(_machtype_)
# define _machtype_
    machtype = "alpha";
# endif
# if ((defined(vax) || defined(__vax__) || defined(__vax))) && !defined(_machtype_)
# define _machtype_
    machtype = "vax";
# endif
#endif




#if ((defined(hp_osf) || defined(__hp_osf__) || defined(__hp_osf)))
    /* Hewlett Packard running OSF/1 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "hp";
# endif
# if ((defined(pa_risc) || defined(__pa_risc__) || defined(__pa_risc))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp9000s700-osf1";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp-osf1";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "osf1";
# endif
# if ((defined(pa_risc) || defined(__pa_risc__) || defined(__pa_risc))) && !defined(_machtype_)
# define _machtype_
    machtype = "pa_risc";
# endif
#endif




#if ((defined(hp9000) || defined(__hp9000__) || defined(__hp9000)))
    /* Hewlett Packard running MORE/bsd */
# if !defined(_vendor_)
# define _vendor_
    vendor = "hp";
# endif
# if ((defined(hp300) || defined(__hp300__) || defined(__hp300))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp300";
# endif
# if ((defined(hp800) || defined(__hp800__) || defined(__hp800))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp800";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp9000";
# endif
# if ((defined(BSD4_4) || defined(__BSD4_4__) || defined(__BSD4_4))) && !defined(_ostype_)
# define _ostype_
    ostype = "bsd44";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "mtXinu";
# endif
# if ((defined(hp300) || defined(__hp300__) || defined(__hp300))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
# if ((defined(hp800) || defined(__hp800__) || defined(__hp800))) && !defined(_machtype_)
# define _machtype_
    machtype = "pa_risc";
# endif
#endif




#if ((defined(hpux) || defined(__hpux__) || defined(__hpux)))
    /* Hewlett Packard running HP/UX */
# if !defined(_vendor_)
# define _vendor_
    vendor = "hp";
# endif
# if ((defined(hp9000s800) || defined(__hp9000s800__) || defined(__hp9000s800))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp9000s800";
# endif
# if ((defined(hp9000s700) || defined(__hp9000s700__) || defined(__hp9000s700))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp9000s700";
# endif
# if ((defined(hp9000s500) || defined(__hp9000s500__) || defined(__hp9000s500))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp9000s500";
# endif
# if ((defined(hp9000s300) || defined(__hp9000s300__) || defined(__hp9000s300))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp9000s300";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "hpux";
# endif
# if ((defined(hp9000s800) || defined(__hp9000s800__) || defined(__hp9000s800))) && !defined(_machtype_)
# define _machtype_
    machtype = "pa_risc";
# endif
# if ((defined(hp9000s700) || defined(__hp9000s700__) || defined(__hp9000s700))) && !defined(_machtype_)
# define _machtype_
    machtype = "pa_risc";
# endif
# if ((defined(hp9000s500) || defined(__hp9000s500__) || defined(__hp9000s500))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
# if ((defined(hp9000s300) || defined(__hp9000s300__) || defined(__hp9000s300))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
#endif




#if ((defined(apollo) || defined(__apollo__) || defined(__apollo)))
    /* Hewlett Packard apollo running Domain/OS */
# if !defined(_vendor_)
# define _vendor_
    vendor = "hp";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "apollo";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "DomainOS";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
#endif




#if ((defined(sun) || defined(__sun__) || defined(__sun)))
    /* Sun Microsystems series 2 workstation (68010 based) */
    /* Sun Microsystems series 3 workstation (68020 based) */
    /* Sun Microsystems 386i workstation (386 based) */
    /* Sun Microsystems series 4 workstation (SPARC based) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "sun";
# endif
# if ((defined(M_i386)) && !(defined(SVR4) || defined(__SVR4__) || defined(__SVR4))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "sun386i";
# endif
# if ((defined(M_i386)) && (defined(SVR4) || defined(__SVR4__) || defined(__SVR4))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i86pc";
# endif
# if ((defined(M_amd64))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i86pc";
# endif
# if ((defined(mc68010) || defined(__mc68010__) || defined(__mc68010))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "sun2";
# endif
# if ((defined(mc68020) || defined(__mc68020__) || defined(__mc68020))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "sun3";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "sun4";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "sun";
# endif
# if ((defined(SUNOS3) || defined(__SUNOS3__) || defined(__SUNOS3))) && !defined(_ostype_)
# define _ostype_
    ostype = "sunos3";
# endif
# if ((defined(SUNOS4) || defined(__SUNOS4__) || defined(__SUNOS4))) && !defined(_ostype_)
# define _ostype_
    ostype = "sunos4";
# endif
# if ((defined(SOLARIS2) || defined(__SOLARIS2__) || defined(__SOLARIS2))) && !defined(_ostype_)
# define _ostype_
    ostype = "solaris";
# endif
# if ((defined(mc68010) || defined(__mc68010__) || defined(__mc68010))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
# if ((defined(mc68020) || defined(__mc68020__) || defined(__mc68020))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
# if ((defined(sparcv9) || defined(__sparcv9__) || defined(__sparcv9))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparcv9";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(M_amd64))) && !defined(_machtype_)
# define _machtype_
    machtype = "amd64";
# endif
#endif




#if ((defined(pyr) || defined(__pyr__) || defined(__pyr)))
    /* Pyramid Technology */
# if !defined(_vendor_)
# define _vendor_
    vendor = "pyramid";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "pyramid";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "pyramid";
# endif
#endif




#if ((defined(hcx) || defined(__hcx__) || defined(__hcx)) || (defined(_CX_UX)))
    /* Harris Tahoe running CX/UX */
# if !defined(_vendor_)
# define _vendor_
    vendor = "harris";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "hcx";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "hcx";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "tahoe";
# endif
#endif




#if ((defined(tahoe) || defined(__tahoe__) || defined(__tahoe)))
    /* Harris Tahoe */
# if !defined(_vendor_)
# define _vendor_
    vendor = "harris";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "tahoe";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "tahoe";
# endif
#endif




#if ((defined(ibm032) || defined(__ibm032__) || defined(__ibm032)))
    /* RT running IBM AOS4.3 or MACH */
# if !defined(_vendor_)
# define _vendor_
    vendor = "ibm";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "rt";
# endif
# if ((defined(MACH))) && !defined(_ostype_)
# define _ostype_
    ostype = "mach";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "aos";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "ibm032";
# endif
#endif




#if ((defined(aiws) || defined(__aiws__) || defined(__aiws)))
    /* RT running IBM aix2.x */
# if !defined(_vendor_)
# define _vendor_
    vendor = "ibm";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "rtpc";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "aix";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "ibm032";
# endif
#endif




#if ((defined(_AIX370)))
    /* IBM/370 running aix */
# if !defined(_vendor_)
# define _vendor_
    vendor = "ibm";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "aix370";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "aix";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "ibm370";
# endif
#endif




#if ((defined(_IBMESA)))
    /* IBM/ESA running aix */
# if !defined(_vendor_)
# define _vendor_
    vendor = "ibm";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "aixESA";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "aix";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "esa";
# endif
#endif




#if ((defined(_IBMR2)))
    /* IBM/RS6000 running aix */
# if !defined(_vendor_)
# define _vendor_
    vendor = "ibm";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "rs6000";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "aix";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "rs6000";
# endif
#endif




#if ((defined(_AIXPS2)))
    /* IBM/PS2 running aix */
# if !defined(_vendor_)
# define _vendor_
    vendor = "ibm";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "ps2";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "aix";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(OREO) || defined(__OREO__) || defined(__OREO)))
    /* Macintosh running AU/X */
# if !defined(_vendor_)
# define _vendor_
    vendor = "apple";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "mac2";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "aux";
# endif
# if ((defined(mc68020) || defined(__mc68020__) || defined(__mc68020))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
#endif




#if ((defined(u3b20d) || defined(__u3b20d__) || defined(__u3b20d)))
    /* AT&T 3B/20 series running SVR2/3 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "att";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "att3b20";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "u3b20";
# endif
#endif




#if ((defined(u3b15) || defined(__u3b15__) || defined(__u3b15)))
    /* AT&T 3B/15 series running SVR2/3 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "att";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "att3b15";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "u3b15";
# endif
#endif




#if ((defined(u3b5) || defined(__u3b5__) || defined(__u3b5)))
    /* AT&T 3B/5 series running SVR2/3 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "att";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "att3b5";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "u3b5";
# endif
#endif




#if ((defined(u3b2) || defined(__u3b2__) || defined(__u3b2)))
    /* AT&T 3B/2 series running SVR2/3 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "att";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "att3b2";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "u3b2";
# endif
#endif




#if ((defined(UNIXPC) || defined(__UNIXPC__) || defined(__UNIXPC)))
    /* AT&T UnixPC att3b1/att7300 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "att";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "unixpc";
# endif
# if ((defined(u3b1) || defined(__u3b1__) || defined(__u3b1))) && !defined(_machtype_)
# define _machtype_
    machtype = "u3b1";
# endif
# if ((defined(att7300) || defined(__att7300__) || defined(__att7300))) && !defined(_machtype_)
# define _machtype_
    machtype = "att7300";
# endif
#endif




#if ((defined(_MINIX)))
    /* Andy Tanenbaum's minix */
# if ((defined(M_i386))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if ((defined(M_i386))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "minix386";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "minix";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "minix";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(gnu_hurd) || defined(__gnu_hurd__) || defined(__gnu_hurd)))
    /* GNU/HURD */
# if ((defined(M_intel))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if ((defined(M_i686))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i686";
# endif
# if ((defined(M_i586))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i586";
# endif
# if ((defined(M_i486))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i486";
# endif
# if ((defined(M_i386))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i386";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "gnu";
# endif
# if ((defined(M_i686))) && !defined(_machtype_)
# define _machtype_
    machtype = "i686-pc-gnu";
# endif
# if ((defined(M_i586))) && !defined(_machtype_)
# define _machtype_
    machtype = "i586-pc-gnu";
# endif
# if ((defined(M_i486))) && !defined(_machtype_)
# define _machtype_
    machtype = "i486-pc-gnu";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386-pc-gnu";
# endif
#endif




#if ((defined(linux) || defined(__linux__) || defined(__linux)) || (defined(GNU) || defined(__GNU__) || defined(__GNU)) || (defined(GLIBC) || defined(__GLIBC__) || defined(__GLIBC)))
    /* Linus Torvalds's linux */
# if ((defined(M_intel))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = gethost();
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = getostype();
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = getmach();
# endif
# if ((defined(ANDROID) || defined(__ANDROID__) || defined(__ANDROID))) && !defined(_vendor_)
# define _vendor_
    vendor = "linux";
# endif
# if ((defined(alpha) || defined(__alpha__) || defined(__alpha))) && !defined(_vendor_)
# define _vendor_
    vendor = "dec";
# endif
# if ((defined(PPC) || defined(__PPC__) || defined(__PPC))) && !defined(_vendor_)
# define _vendor_
    vendor = "apple";
# endif
#endif




#if ((defined(EMX) || defined(__EMX__) || defined(__EMX)))
    /* OS/2 EMX [unix emulation under OS/2] */
# if ((defined(M_intel))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if ((defined(M_i386))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i386-emx";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "os2";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(NetBSD) || defined(__NetBSD__) || defined(__NetBSD)))
    /* NetBSD */
# if ((defined(algor) || defined(__algor__) || defined(__algor))) && !defined(_vendor_)
# define _vendor_
    vendor = "algoritmics";
# endif
# if ((defined(arm32) || defined(__arm32__) || defined(__arm32)) || (defined(arm) || defined(__arm__) || defined(__arm))) && !defined(_vendor_)
# define _vendor_
    vendor = "acorn";
# endif
# if ((defined(alpha) || defined(__alpha__) || defined(__alpha))) && !defined(_vendor_)
# define _vendor_
    vendor = "digital";
# endif
# if ((defined(amiga) || defined(__amiga__) || defined(__amiga))) && !defined(_vendor_)
# define _vendor_
    vendor = "commodore";
# endif
# if ((defined(atari) || defined(__atari__) || defined(__atari))) && !defined(_vendor_)
# define _vendor_
    vendor = "atari";
# endif
# if ((defined(hp300) || defined(__hp300__) || defined(__hp300))) && !defined(_vendor_)
# define _vendor_
    vendor = "hp";
# endif
# if ((defined(M_intel))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if ((defined(m68k) || defined(__m68k__) || defined(__m68k))) && !defined(_vendor_)
# define _vendor_
    vendor = "motorola";
# endif
# if ((defined(mac68k) || defined(__mac68k__) || defined(__mac68k))) && !defined(_vendor_)
# define _vendor_
    vendor = "apple";
# endif
# if ((defined(pc532) || defined(__pc532__) || defined(__pc532))) && !defined(_vendor_)
# define _vendor_
    vendor = "national-semi";
# endif
# if ((defined(pmax) || defined(__pmax__) || defined(__pmax))) && !defined(_vendor_)
# define _vendor_
    vendor = "dec";
# endif
# if ((defined(powerpc) || defined(__powerpc__) || defined(__powerpc))) && !defined(_vendor_)
# define _vendor_
    vendor = "motorola";
# endif
# if ((defined(mips) || defined(__mips__) || defined(__mips))) && !defined(_vendor_)
# define _vendor_
    vendor = "mips";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_vendor_)
# define _vendor_
    vendor = "sun";
# endif
# if ((defined(sparc64) || defined(__sparc64__) || defined(__sparc64))) && !defined(_vendor_)
# define _vendor_
    vendor = "sun";
# endif
# if ((defined(sun3) || defined(__sun3__) || defined(__sun3))) && !defined(_vendor_)
# define _vendor_
    vendor = "sun";
# endif
# if ((defined(vax) || defined(__vax__) || defined(__vax))) && !defined(_vendor_)
# define _vendor_
    vendor = "digital";
# endif
# if ((defined(M_amd64))) && !defined(_vendor_)
# define _vendor_
    vendor = "amd";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "NetBSD";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "NetBSD";
# endif
# if ((defined(alpha) || defined(__alpha__) || defined(__alpha))) && !defined(_machtype_)
# define _machtype_
    machtype = "alpha";
# endif
# if ((defined(algor) || defined(__algor__) || defined(__algor))) && !defined(_machtype_)
# define _machtype_
    machtype = "algor";
# endif
# if ((defined(arm32) || defined(__arm32__) || defined(__arm32)) || (defined(APCS_32) || defined(__APCS_32__) || defined(__APCS_32))) && !defined(_machtype_)
# define _machtype_
    machtype = "arm32";
# endif
# if ((defined(arm26) || defined(__arm26__) || defined(__arm26)) || (defined(APCS_26) || defined(__APCS_26__) || defined(__APCS_26))) && !defined(_machtype_)
# define _machtype_
    machtype = "arm26";
# endif
# if ((defined(arm) || defined(__arm__) || defined(__arm))) && !defined(_machtype_)
# define _machtype_
    machtype = "arm";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc";
# endif
# if ((defined(sparc64) || defined(__sparc64__) || defined(__sparc64))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc64";
# endif
# if ((defined(mc68020) || defined(__mc68020__) || defined(__mc68020))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(M_mipsel))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipsel";
# endif
# if ((defined(M_mipseb))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipseb";
# endif
# if ((defined(mips) || defined(__mips__) || defined(__mips))) && !defined(_machtype_)
# define _machtype_
    machtype = "mips";
# endif
# if ((defined(pc532) || defined(__pc532__) || defined(__pc532))) && !defined(_machtype_)
# define _machtype_
    machtype = "pc532";
# endif
# if ((defined(powerpc) || defined(__powerpc__) || defined(__powerpc))) && !defined(_machtype_)
# define _machtype_
    machtype = "powerpc";
# endif
# if ((defined(vax) || defined(__vax__) || defined(__vax))) && !defined(_machtype_)
# define _machtype_
    machtype = "vax";
# endif
# if ((defined(M_amd64))) && !defined(_machtype_)
# define _machtype_
    machtype = "x86_64";
# endif
#endif



#if ((defined(OpenBSD) || defined(__OpenBSD__) || defined(__OpenBSD)))
    /* OpenBSD */
# if ((defined(alpha) || defined(__alpha__) || defined(__alpha))) && !defined(_vendor_)
# define _vendor_
    vendor = "digital";
# endif
# if ((defined(M_amd64))) && !defined(_vendor_)
# define _vendor_
    vendor = "amd";
# endif
# if ((defined(arm) || defined(__arm__) || defined(__arm))) && !defined(_vendor_)
# define _vendor_
    vendor = "arm";
# endif
# if ((defined(hppa) || defined(__hppa__) || defined(__hppa)) || (defined(hppa64) || defined(__hppa64__) || defined(__hppa64))) && !defined(_vendor_)
# define _vendor_
    vendor = "hp";
# endif
# if ((defined(M_intel))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if ((defined(m68k) || defined(__m68k__) || defined(__m68k))) && !defined(_vendor_)
# define _vendor_
    vendor = "motorola";
# endif
# if ((defined(m88k) || defined(__m88k__) || defined(__m88k))) && !defined(_vendor_)
# define _vendor_
    vendor = "motorola";
# endif
# if ((defined(mips) || defined(__mips__) || defined(__mips)) && (defined(sgi) || defined(__sgi__) || defined(__sgi))) && !defined(_vendor_)
# define _vendor_
    vendor = "sgi";
# endif
# if ((defined(powerpc) || defined(__powerpc__) || defined(__powerpc))) && !defined(_vendor_)
# define _vendor_
    vendor = "motorola";
# endif
# if ((defined(sh) || defined(__sh__) || defined(__sh))) && !defined(_vendor_)
# define _vendor_
    vendor = "io-data";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc)) || (defined(sparc64) || defined(__sparc64__) || defined(__sparc64))) && !defined(_vendor_)
# define _vendor_
    vendor = "sun";
# endif
# if ((defined(vax) || defined(__vax__) || defined(__vax))) && !defined(_vendor_)
# define _vendor_
    vendor = "digital";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "OpenBSD";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "OpenBSD";
# endif
# if ((defined(alpha) || defined(__alpha__) || defined(__alpha))) && !defined(_machtype_)
# define _machtype_
    machtype = "alpha";
# endif
# if ((defined(M_amd64))) && !defined(_machtype_)
# define _machtype_
    machtype = "amd64";
# endif
# if ((defined(arm) || defined(__arm__) || defined(__arm))) && !defined(_machtype_)
# define _machtype_
    machtype = "arm";
# endif
# if ((defined(hppa) || defined(__hppa__) || defined(__hppa))) && !defined(_machtype_)
# define _machtype_
    machtype = "hppa";
# endif
# if ((defined(hppa64) || defined(__hppa64__) || defined(__hppa64))) && !defined(_machtype_)
# define _machtype_
    machtype = "hppa64";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(m68k) || defined(__m68k__) || defined(__m68k))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
# if ((defined(m88k) || defined(__m88k__) || defined(__m88k))) && !defined(_machtype_)
# define _machtype_
    machtype = "m88k";
# endif
# if ((defined(mips) || defined(__mips__) || defined(__mips))) && !defined(_machtype_)
# define _machtype_
    machtype = "mips";
# endif
# if ((defined(sh) || defined(__sh__) || defined(__sh))) && !defined(_machtype_)
# define _machtype_
    machtype = "sh";
# endif
# if ((defined(sparc64) || defined(__sparc64__) || defined(__sparc64))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc64";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc";
# endif
# if ((defined(powerpc) || defined(__powerpc__) || defined(__powerpc))) && !defined(_machtype_)
# define _machtype_
    machtype = "powerpc";
# endif
# if ((defined(vax) || defined(__vax__) || defined(__vax))) && !defined(_machtype_)
# define _machtype_
    machtype = "vax";
# endif
#endif




#if ((defined(FreeBSD) || defined(__FreeBSD__) || defined(__FreeBSD)))
    /* FreeBSD */
# if ((defined(alpha) || defined(__alpha__) || defined(__alpha))) && !defined(_vendor_)
# define _vendor_
    vendor = "digital";
# endif
# if ((defined(arm32) || defined(__arm32__) || defined(__arm32)) || (defined(arm) || defined(__arm__) || defined(__arm))) && !defined(_vendor_)
# define _vendor_
    vendor = "acorn";
# endif
# if ((defined(M_intel))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if ((defined(ia64) || defined(__ia64__) || defined(__ia64))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if ((defined(mips) || defined(__mips__) || defined(__mips))) && !defined(_vendor_)
# define _vendor_
    vendor = "mips";
# endif
# if ((defined(powerpc) || defined(__powerpc__) || defined(__powerpc))) && !defined(_vendor_)
# define _vendor_
    vendor = "motorola";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_vendor_)
# define _vendor_
    vendor = "sun";
# endif
# if ((defined(sparc64) || defined(__sparc64__) || defined(__sparc64))) && !defined(_vendor_)
# define _vendor_
    vendor = "sun";
# endif
# if ((defined(M_amd64))) && !defined(_vendor_)
# define _vendor_
    vendor = "amd";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "FreeBSD";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "FreeBSD";
# endif
# if ((defined(alpha) || defined(__alpha__) || defined(__alpha))) && !defined(_machtype_)
# define _machtype_
    machtype = "alpha";
# endif
# if ((defined(arm32) || defined(__arm32__) || defined(__arm32)) || (defined(APCS_32) || defined(__APCS_32__) || defined(__APCS_32))) && !defined(_machtype_)
# define _machtype_
    machtype = "arm32";
# endif
# if ((defined(arm) || defined(__arm__) || defined(__arm))) && !defined(_machtype_)
# define _machtype_
    machtype = "arm";
# endif
# if ((defined(ia64) || defined(__ia64__) || defined(__ia64))) && !defined(_machtype_)
# define _machtype_
    machtype = "ia64";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(mips) || defined(__mips__) || defined(__mips))) && !defined(_machtype_)
# define _machtype_
    machtype = "mips";
# endif
# if ((defined(powerpc) || defined(__powerpc__) || defined(__powerpc))) && !defined(_machtype_)
# define _machtype_
    machtype = "powerpc";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc";
# endif
# if ((defined(sparc64) || defined(__sparc64__) || defined(__sparc64))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc64";
# endif
# if ((defined(M_amd64))) && !defined(_machtype_)
# define _machtype_
    machtype = "x86_64";
# endif
#endif




#if ((defined(MidnightBSD)))
    /* MidnightBSD */
# if ((defined(M_intel))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "MidnightBSD";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "MidnightBSD";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(__386BSD__)))
    /* Bill Jolitz's 386BSD */
# if ((defined(M_intel))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "386BSD";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "386BSD";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(bsdi) || defined(__bsdi__) || defined(__bsdi)))
    /* BSDI's unix */
# if ((defined(M_intel))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_vendor_)
# define _vendor_
    vendor = "sun";
# endif
# if ((defined(powerpc) || defined(__powerpc__) || defined(__powerpc))) && !defined(_vendor_)
# define _vendor_
    vendor = "motorola";
# endif
# if ((defined(M_intel))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "bsd386";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "bsd-sparc";
# endif
# if ((defined(powerpc) || defined(__powerpc__) || defined(__powerpc))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "bsd-powerpc";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "bsdi";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc";
# endif
# if ((defined(powerpc) || defined(__powerpc__) || defined(__powerpc))) && !defined(_machtype_)
# define _machtype_
    machtype = "powerpc";
# endif
#endif




#if ((defined(COHERENT) || defined(__COHERENT__) || defined(__COHERENT)))
    /* COHERENT's unix */
# if ((defined(_I386))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "coh386";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "coherent";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "coherent";
# endif
# if ((defined(_I386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif



#if ((defined(concurrent) || defined(__concurrent__) || defined(__concurrent)))
    /* Concurrent PowerHawk */
# if !defined(_vendor_)
# define _vendor_
    vendor = "concurrent";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "powerhawk";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "powermax_os";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "powerhawk";
# endif
#endif



#if ((defined(SCO) || defined(__SCO__) || defined(__SCO)))
    /* SCO UNIX System V/386 Release 3.2 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "sco";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "sco386";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "sco_unix";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif



#if ((defined(M_XENIX)) && !(defined(M_UNIX)))
    /* SCO XENIX */
# if !defined(_vendor_)
# define _vendor_
    vendor = "sco";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "sco_xenix";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "sco_xenix";
# endif
# if ((defined(M_I386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(M_I286))) && !defined(_machtype_)
# define _machtype_
    machtype = "i286";
# endif
#endif




#if ((defined(ISC) || defined(__ISC__) || defined(__ISC)) || (defined(ISC202) || defined(__ISC202__) || defined(__ISC202)))
    /* Interactive Unix */
# if !defined(_vendor_)
# define _vendor_
    vendor = "isc";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "isc386";
# endif
# if ((defined(POSIX) || defined(__POSIX__) || defined(__POSIX))) && !defined(_ostype_)
# define _ostype_
    ostype = "POSIX";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "SVR3";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(INTEL) || defined(__INTEL__) || defined(__INTEL)))
    /* Intel Unix */
# if !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "intel386";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "intel_unix";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(MACH)))
    /* cmu's mach */
# if !defined(_vendor_)
# define _vendor_
    vendor = "cmu";
# endif
# if ((defined(M_i386))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i386-mach";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "mach";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(alliant) || defined(__alliant__) || defined(__alliant)))
    /* Alliants FSX */
# if !defined(_vendor_)
# define _vendor_
    vendor = "alliant";
# endif
# if ((defined(mc68000) || defined(__mc68000__) || defined(__mc68000))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "alliant-fx80";
# endif
# if ((defined(i860) || defined(__i860__) || defined(__i860))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "alliant-fx2800";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "alliant";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "fsx";
# endif
# if ((defined(mc68000) || defined(__mc68000__) || defined(__mc68000))) && !defined(_machtype_)
# define _machtype_
    machtype = "mc68000";
# endif
# if ((defined(i860) || defined(__i860__) || defined(__i860))) && !defined(_machtype_)
# define _machtype_
    machtype = "i860";
# endif
#endif




#if ((defined(_FTX)))
    /* Stratus Computer, Inc FTX2 (i860 based) */
    /* Stratus Computer, Inc FTX3 (HPPA based) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "stratus";
# endif
# if ((defined(i860) || defined(__i860__) || defined(__i860)) && (defined(_FTX))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "atlantic";
# endif
# if ((defined(hppa) || defined(__hppa__) || defined(__hppa)) && (defined(_FTX))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "continuum";
# endif
# if ((defined(i860) || defined(__i860__) || defined(__i860)) && (defined(_FTX))) && !defined(_ostype_)
# define _ostype_
    ostype = "ftx2";
# endif
# if ((defined(hppa) || defined(__hppa__) || defined(__hppa)) && (defined(_FTX))) && !defined(_ostype_)
# define _ostype_
    ostype = "ftx3";
# endif
# if ((defined(i860) || defined(__i860__) || defined(__i860))) && !defined(_machtype_)
# define _machtype_
    machtype = "i860";
# endif
# if ((defined(hppa) || defined(__hppa__) || defined(__hppa))) && !defined(_machtype_)
# define _machtype_
    machtype = "hppa";
# endif
#endif




#if ((defined(sequent) || defined(__sequent__) || defined(__sequent)) || (defined(_SEQUENT_)))
    /* Sequent Balance (32000 based) */
    /* Sequent Symmetry running DYNIX/ptx (386/486 based) */
    /* Sequent Symmetry running DYNIX 3 (386/486 based) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "sequent";
# endif
# if ((defined(M_i386)) && (defined(sequent) || defined(__sequent__) || defined(__sequent))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "symmetry";
# endif
# if ((defined(M_i386))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "ptx";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "balance";
# endif
# if ((defined(M_i386)) && !(defined(sequent) || defined(__sequent__) || defined(__sequent))) && !defined(_ostype_)
# define _ostype_
    ostype = "ptx";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "dynix3";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(ns32000) || defined(__ns32000__) || defined(__ns32000))) && !defined(_machtype_)
# define _machtype_
    machtype = "ns32000";
# endif
#endif




#if ((defined(ns32000) || defined(__ns32000__) || defined(__ns32000)))
    /* Encore Computer Corp. Multimax (32000 based) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "encore";
# endif
# if ((defined(CMUCS) || defined(__CMUCS__) || defined(__CMUCS))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "multimax";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = isamultimax(0);
# endif
# if ((defined(CMUCS) || defined(__CMUCS__) || defined(__CMUCS))) && !defined(_ostype_)
# define _ostype_
    ostype = "mach";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = isamultimax(1);
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "ns32000";
# endif
#endif




#if ((defined(iconuxv) || defined(__iconuxv__) || defined(__iconuxv)))
    /* Icon 88k running Unix */
# if !defined(_vendor_)
# define _vendor_
    vendor = "icon";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "icon";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "iconuxv";
# endif
# if ((defined(m88k) || defined(__m88k__) || defined(__m88k))) && !defined(_machtype_)
# define _machtype_
    machtype = "m88k";
# endif
#endif




#if ((defined(_CRAY)) && (defined(_CRAYCOM)))
    /* Cray Computer Corp. running CSOS */
# if !defined(_vendor_)
# define _vendor_
    vendor = "ccc";
# endif
# if ((defined(_CRAY2))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "cray";
# endif
# if ((defined(_CRAY3))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "cray";
# endif
# if ((defined(_CRAY4))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "cray";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "CSOS";
# endif
# if ((defined(_CRAY2))) && !defined(_machtype_)
# define _machtype_
    machtype = "cray2";
# endif
# if ((defined(_CRAY3))) && !defined(_machtype_)
# define _machtype_
    machtype = "cray3";
# endif
# if ((defined(_CRAY4))) && !defined(_machtype_)
# define _machtype_
    machtype = "cray4";
# endif
#endif




#if ((defined(cray) || defined(__cray__) || defined(__cray)) && !(defined(_CRAYMPP)))
    /* Cray Research Inc. PVP running UNICOS */
# if !defined(_vendor_)
# define _vendor_
    vendor = "cri";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = getcray();
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "unicos";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = getcray();
# endif
#endif




#if ((defined(cray) || defined(__cray__) || defined(__cray)) && (defined(_CRAYT3D)))
    /* Cray Research Inc. running UNICOS MAX */
# if !defined(_vendor_)
# define _vendor_
    vendor = "cri";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = getcray();
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "unicosmax";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = getcray();
# endif
#endif




#if ((defined(cray) || defined(__cray__) || defined(__cray)) && (defined(_CRAYT3E)))
    /* Cray Research Inc. running UNICOS/mk */
# if !defined(_vendor_)
# define _vendor_
    vendor = "cri";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = getcray();
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "unicosmk";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = getcray();
# endif
#endif




#if ((defined(convex) || defined(__convex__) || defined(__convex)))
    /* Convex */
# if !defined(_vendor_)
# define _vendor_
    vendor = "convex";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "convex";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "convexos";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = getconvex();
# endif
#endif




#if ((defined(butterfly) || defined(__butterfly__) || defined(__butterfly)))
    /* BBN Butterfly 1000 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "bbn";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "butterfly";
# endif
# if ((defined(mc68020) || defined(__mc68020__) || defined(__mc68020))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
#endif




#if ((defined(NeXT) || defined(__NeXT__) || defined(__NeXT)))
    /* NeXTStep */
# if !defined(_vendor_)
# define _vendor_
    vendor = "next";
# endif
# if ((defined(mc68020) || defined(__mc68020__) || defined(__mc68020))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "next";
# endif
# if ((defined(M_i386))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "intel-pc";
# endif
# if ((defined(hppa) || defined(__hppa__) || defined(__hppa))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "hp";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "sun";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "nextstep";
# endif
# if ((defined(mc68020) || defined(__mc68020__) || defined(__mc68020))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(hppa) || defined(__hppa__) || defined(__hppa))) && !defined(_machtype_)
# define _machtype_
    machtype = "hppa";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc";
# endif
#endif




#if ((defined(APPLE) || defined(__APPLE__) || defined(__APPLE)))
    /* OS X */
# if !defined(_vendor_)
# define _vendor_
    vendor = "apple";
# endif
# if ((defined(i386) || defined(__i386__) || defined(__i386))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "intel-mac";
# endif
# if ((defined(ppc) || defined(__ppc__) || defined(__ppc))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "powermac";
# endif
# if ((defined(M_amd64))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "intel-mac";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "darwin";
# endif
# if ((defined(i386) || defined(__i386__) || defined(__i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(M_amd64))) && !defined(_machtype_)
# define _machtype_
    machtype = "x86_64";
# endif
# if ((defined(ppc) || defined(__ppc__) || defined(__ppc))) && !defined(_machtype_)
# define _machtype_
    machtype = "powerpc";
# endif
#endif




#if ((defined(sony_news) || defined(__sony_news__) || defined(__sony_news)))
    /* Sony NEWS 800 or 1700 workstation */
# if !defined(_vendor_)
# define _vendor_
    vendor = "sony";
# endif
# if ((defined(mips) || defined(__mips__) || defined(__mips))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "news_mips";
# endif
# if ((defined(mc68020) || defined(__mc68020__) || defined(__mc68020))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "news_m68k";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "News";
# endif
# if ((defined(mc68020) || defined(__mc68020__) || defined(__mc68020))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
# if ((defined(M_mipsel))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipsel";
# endif
# if ((defined(M_mipseb))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipseb";
# endif
#endif




#if ((defined(sgi) || defined(__sgi__) || defined(__sgi)))
    /* Silicon Graphics */
# if !defined(_vendor_)
# define _vendor_
    vendor = "sgi";
# endif
# if ((defined(M_mipsel))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "iris4d";
# endif
# if ((defined(M_mipseb))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "iris4d";
# endif
# if ((defined(mc68000) || defined(__mc68000__) || defined(__mc68000))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "iris3d";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "irix";
# endif
# if ((defined(M_mipsel))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipsel";
# endif
# if ((defined(M_mipseb))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipseb";
# endif
# if ((defined(mc68000) || defined(__mc68000__) || defined(__mc68000))) && !defined(_machtype_)
# define _machtype_
    machtype = "mc68000";
# endif
#endif




#if ((defined(ultrix) || defined(__ultrix__) || defined(__ultrix)))
    /* Digital's Ultrix */
# if !defined(_vendor_)
# define _vendor_
    vendor = "dec";
# endif
# if ((defined(M_mipsel))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "decstation";
# endif
# if ((defined(M_mipseb))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "decmips";
# endif
# if ((defined(vax) || defined(__vax__) || defined(__vax))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "vax";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "ultrix";
# endif
# if ((defined(M_mipsel))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipsel";
# endif
# if ((defined(M_mipseb))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipseb";
# endif
# if ((defined(vax) || defined(__vax__) || defined(__vax))) && !defined(_machtype_)
# define _machtype_
    machtype = "vax";
# endif
#endif




#if ((defined(MIPS)))
    /* Mips OS */
# if !defined(_vendor_)
# define _vendor_
    vendor = "mips";
# endif
# if ((defined(M_mipsel))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "mips";
# endif
# if ((defined(M_mipseb))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "mips";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "mips";
# endif
# if ((defined(M_mipsel))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipsel";
# endif
# if ((defined(M_mipseb))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipseb";
# endif
#endif




#if ((defined(DECOSF1) || defined(__DECOSF1__) || defined(__DECOSF1)))
    /* Digital's alpha running osf1 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "dec";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "osf1";
# endif
# if ((defined(alpha) || defined(__alpha__) || defined(__alpha))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "alpha";
# endif
# if ((defined(alpha) || defined(__alpha__) || defined(__alpha))) && !defined(_machtype_)
# define _machtype_
    machtype = "alpha";
# endif
#endif




#if ((defined(Lynx) || defined(__Lynx__) || defined(__Lynx)))
    /* Lynx OS 2.1 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "Lynx";
# endif
# if ((defined(M_mipsel))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "lynxos-mips";
# endif
# if ((defined(M_mipseb))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "lynxos-mips";
# endif
# if ((defined(M_i386))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "lynxos-i386";
# endif
# if ((defined(i860) || defined(__i860__) || defined(__i860))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "lynxos-i860";
# endif
# if ((defined(m68k) || defined(__m68k__) || defined(__m68k))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "lynxos-m68k";
# endif
# if ((defined(m88k) || defined(__m88k__) || defined(__m88k))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "lynxos-m88k";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "lynxos-sparc";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "lynxos-unknown";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "LynxOS";
# endif
# if ((defined(M_mipsel))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipsel";
# endif
# if ((defined(M_mipseb))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipseb";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(i860) || defined(__i860__) || defined(__i860))) && !defined(_machtype_)
# define _machtype_
    machtype = "i860";
# endif
# if ((defined(m68k) || defined(__m68k__) || defined(__m68k))) && !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
# if ((defined(m88k) || defined(__m88k__) || defined(__m88k))) && !defined(_machtype_)
# define _machtype_
    machtype = "m88k";
# endif
# if ((defined(sparc) || defined(__sparc__) || defined(__sparc))) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc";
# endif
#endif




#if ((defined(masscomp) || defined(__masscomp__) || defined(__masscomp)))
    /* Masscomp */
# if !defined(_vendor_)
# define _vendor_
    vendor = "masscomp";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "masscomp";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "masscomp";
# endif
#endif



#if ((defined(MACHTEN)))
    /* Machintosh */
# if !defined(_vendor_)
# define _vendor_
    vendor = "Tenon";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "Macintosh";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "MachTen";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "Macintosh";
# endif
#endif





#if ((defined(GOULD_NP1) || defined(__GOULD_NP1__) || defined(__GOULD_NP1)))
    /* Gould */
# if !defined(_vendor_)
# define _vendor_
    vendor = "gould";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "gould_np1";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "gould";
# endif
#endif




#if ((defined(MULTIFLOW)))
    /* Multiflow running 4.3BSD */
# if !defined(_vendor_)
# define _vendor_
    vendor = "multiflow";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "multiflow";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "multiflow";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "bsd43";
# endif
#endif




#if ((defined(SXA) || defined(__SXA__) || defined(__SXA)))
    /* PFU/Fujitsu A-xx computer */
# if !defined(_vendor_)
# define _vendor_
    vendor = "sxa";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "pfa50";
# endif
# if ((defined(_BSDX_))) && !defined(_ostype_)
# define _ostype_
    ostype = "e60-bsdx";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "e60";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "pfa50";
# endif
#endif




#if ((defined(titan) || defined(__titan__) || defined(__titan)))
    /* (St)Ardent Titan */
# if !defined(_vendor_)
# define _vendor_
    vendor = "ardent";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "titan";
# endif
#endif




#if ((defined(stellar) || defined(__stellar__) || defined(__stellar)))
    /* Stellar */
# if !defined(_vendor_)
# define _vendor_
    vendor = "stellar";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "stellar";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "stellix";
# endif
#endif




#if ((defined(atari) || defined(__atari__) || defined(__atari)))
    /* Atari TT running SVR4. This machine was never */
    /* commercially available. */
# if !defined(_vendor_)
# define _vendor_
    vendor = "atari";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "atari";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "asv";
# endif
#endif




#if ((defined(OPUS) || defined(__OPUS__) || defined(__OPUS)))
    /* ??? */
# if !defined(_vendor_)
# define _vendor_
    vendor = "opus";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "opus";
# endif
#endif




#if ((defined(eta10) || defined(__eta10__) || defined(__eta10)))
    /* ETA running SVR3 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "eta";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "eta10";
# endif
#endif




#if ((defined(hk68) || defined(__hk68__) || defined(__hk68)))
    /* Heurikon HK68 running Uniplus+ 5.0 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "heurikon";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "hk68";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "uniplus";
# endif
#endif




#if ((defined(NDIX) || defined(__NDIX__) || defined(__NDIX)))
    /* Norsk Data ND 500/5000 running Ndix */
# if !defined(_vendor_)
# define _vendor_
    vendor = "norsk";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "nd500";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "ndix";
# endif
#endif




#if ((defined(AMIGA) || defined(__AMIGA__) || defined(__AMIGA)))
    /* Amiga running AmigaOS+GG */
# if !defined(_vendor_)
# define _vendor_
    vendor = "commodore";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "amiga";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "AmigaOS";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
#endif




#if ((defined(uts) || defined(__uts__) || defined(__uts)))
    /* Amdahl running uts 2.1 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "amdahl";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "amdahl";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "uts";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "amdahl";
# endif
#endif




#if ((defined(UTek) || defined(__UTek__) || defined(__UTek)))
    /* Tektronix 4300 running UTek (BSD 4.2 / 68020 based) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "tektronix";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "tek4300";
# endif
#endif




#if ((defined(UTekV) || defined(__UTekV__) || defined(__UTekV)))
    /* Tektronix XD88/10 running UTekV 3.2e (SVR3/88100 based) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "tektronix";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "tekXD88";
# endif
#endif




#if ((defined(DGUX) || defined(__DGUX__) || defined(__DGUX)))
    /* Data-General AViiON running DGUX */
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "aviion";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "dgux";
# endif
# if !defined(_vendor_)
# define _vendor_
    vendor = "dg";
# endif
# if ((defined(m88k) || defined(__m88k__) || defined(__m88k))) && !defined(_machtype_)
# define _machtype_
    machtype = "m88k";
# endif
# if ((defined(i386) || defined(__i386__) || defined(__i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "pentium";
# endif
#endif




#if ((defined(sysV68) || defined(__sysV68__) || defined(__sysV68)))
    /* Motorola MPC running System V/68 R32V2 (SVR3/68020 based) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "motorola";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "sysV68";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
#endif




#if ((defined(supermax) || defined(__supermax__) || defined(__supermax)))
    /* DDE Supermax running System V/68 R3 (SVR3/68020 based) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "supermax";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "supermax";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
#endif




#if ((defined(sysV88) || defined(__sysV88__) || defined(__sysV88)))
    /* Motorola MPC running System V/88 R32V2 (SVR3/88100 based) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "motorola";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "sysV88";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "m88k";
# endif
#endif




#if ((defined(clipper) || defined(__clipper__) || defined(__clipper)))
    /* Clipper Chipset (Intergraph) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "intergraph";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "clipper";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "clipper";
# endif
#endif



#if ((defined(QNX) || defined(__QNX__) || defined(__QNX)))
# if !defined(_ostype_)
# define _ostype_
    ostype = "qnx";
# endif
#endif



#if (((defined(SNI) || defined(__SNI__) || defined(__SNI)) || (defined(sinix) || defined(__sinix__) || defined(__sinix))) && !(defined(_OSD_POSIX)))
    /* Fujitsu Siemens Computers (former "Siemens Nixdorf Informationssysteme") */
# if !defined(_vendor_)
# define _vendor_
    vendor = "fsc";
# endif
# if ((defined(M_intel))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "wx200i";
# endif
# if ((defined(MIPSEB))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "rm400";
# endif
# if ((defined(sinix) || defined(__sinix__) || defined(__sinix))) && !defined(_ostype_)
# define _ostype_
    ostype = "sinix";
# endif
# if ((defined(M_i586))) && !defined(_machtype_)
# define _machtype_
    machtype = "i586";
# endif
# if ((defined(M_i486))) && !defined(_machtype_)
# define _machtype_
    machtype = "i486";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
# if ((defined(M_mipsel))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipsel";
# endif
# if ((defined(M_mipseb))) && !defined(_machtype_)
# define _machtype_
    machtype = "mipseb";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "mips";
# endif
#endif



#if ((defined(_OSD_POSIX)))
    /* Fujitsu Siemens Computers (former "Siemens Nixdorf Informationssysteme") */
# if !defined(_vendor_)
# define _vendor_
    vendor = "fsc";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "bs2000";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "osdposix";
# endif
# if (#machine(7500)) && !defined(_machtype_)
# define _machtype_
    machtype = "s390";
# endif
# if (#machine(mips)) && !defined(_machtype_)
# define _machtype_
    machtype = "mips";
# endif
# if (#machine(sparc)) && !defined(_machtype_)
# define _machtype_
    machtype = "sparc";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "bs2000";
# endif
#endif



#if ((defined(MVS)))
    /* ibm uss s/390 (mainframe, EBCDIC) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "ibm";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "s390";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "os390";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "s390";
# endif
#endif



#if ((defined(_SX)))
    /* NEC Corporation (SX-4) */
# if !defined(_vendor_)
# define _vendor_
    vendor = "nec";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "superux";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "sx4";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "sx4";
# endif
#endif



#if (!(defined(SOLARIS2) || defined(__SOLARIS2__) || defined(__SOLARIS2)) && (SYSVREL == 4))
    /* Unix System V Release 4.0 */
# if ((defined(DELL) || defined(__DELL__) || defined(__DELL))) && !defined(_vendor_)
# define _vendor_
    vendor = "dell";
# endif
# if ((defined(M_i386))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i386";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "svr4";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif



#if ((defined(uxp) || defined(__uxp__) || defined(__uxp)) || (defined(uxps) || defined(__uxps__) || defined(__uxps)))
    /* FUJITSU DS/90 7000 */
# if !defined(_vendor_)
# define _vendor_
    vendor = "fujitsu";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "ds90";
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = "sysv4";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "sparc";
# endif
#endif



#if ((defined(CYGWIN) || defined(__CYGWIN__) || defined(__CYGWIN)))
    /* Cygwin */
# if ((defined(M_intel))) && !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = gethost();
# endif
# if !defined(_ostype_)
# define _ostype_
    ostype = getostype();
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = getmach();
# endif
#endif



#if ((defined(_UWIN)))
    /* AT&T Research Unix for Windows */
# if !defined(_vendor_)
# define _vendor_
    vendor = "att";
# endif
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "win32.i386";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(mc68000) || defined(__mc68000__) || defined(__mc68000)) || (defined(mc68k32) || defined(__mc68k32__) || defined(__mc68k32)) || (defined(m68k) || defined(__m68k__) || defined(__m68k)) || (defined(mc68010) || defined(__mc68010__) || defined(__mc68010)) || (defined(mc68020) || defined(__mc68020__) || defined(__mc68020)))
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "m68k";
# endif
# if ((defined(m68k) || defined(__m68k__) || defined(__m68k))) && !defined(_vendor_)
# define _vendor_
    vendor = "motorola";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "m68k";
# endif
#endif




#if ((defined(m88k) || defined(__m88k__) || defined(__m88k)))
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "m88k";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "m88k";
# endif
#endif




#if ((defined(M_intel)))
# if ((defined(M_i586))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i586";
# endif
# if ((defined(M_i486))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i486";
# endif
# if ((defined(M_i386))) && !defined(_hosttype_)
# define _hosttype_
    hosttype = "i386";
# endif
# if !defined(_vendor_)
# define _vendor_
    vendor = "intel";
# endif
# if ((defined(M_i586))) && !defined(_machtype_)
# define _machtype_
    machtype = "i586";
# endif
# if ((defined(M_i486))) && !defined(_machtype_)
# define _machtype_
    machtype = "i486";
# endif
# if ((defined(M_i386))) && !defined(_machtype_)
# define _machtype_
    machtype = "i386";
# endif
#endif




#if ((defined(sparc) || defined(__sparc__) || defined(__sparc)))
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "sparc";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "sparc";
# endif
#endif




#if ((defined(i860) || defined(__i860__) || defined(__i860)))
# if !defined(_hosttype_)
# define _hosttype_
    hosttype = "i860";
# endif
# if !defined(_machtype_)
# define _machtype_
    machtype = "i860";
# endif
#endif




#if ((defined(osf1) || defined(__osf1__) || defined(__osf1)))
# if !defined(_ostype_)
# define _ostype_
    ostype = "osf1";
# endif
#endif




#if (SYSVREL == 0)
# if ((defined(BSD4_4) || defined(__BSD4_4__) || defined(__BSD4_4))) && !defined(_ostype_)
# define _ostype_
    ostype = "bsd44";
# endif
# if ((defined(BSD) || defined(__BSD__) || defined(__BSD))) && !defined(_ostype_)
# define _ostype_
    ostype = "bsd";
# endif
# if ((defined(POSIX) || defined(__POSIX__) || defined(__POSIX))) && !defined(_ostype_)
# define _ostype_
    ostype = "posix";
# endif
#endif




#if (SYSVREL == 1)
# if !defined(_ostype_)
# define _ostype_
    ostype = "svr1";
# endif
#endif




#if (SYSVREL == 2)
# if !defined(_ostype_)
# define _ostype_
    ostype = "svr2";
# endif
#endif




#if (SYSVREL == 3)
# if !defined(_ostype_)
# define _ostype_
    ostype = "svr3";
# endif
#endif




#if (SYSVREL == 4)
# if !defined(_ostype_)
# define _ostype_
    ostype = "svr4";
# endif
#endif


#ifndef _hosttype_
    hosttype = "unknown";
#endif
#ifndef _ostype_
    ostype = "unknown";
#endif
#ifndef _vendor_
    vendor = "unknown";
#endif
#ifndef _machtype_
    machtype = "unknown";
#endif
    tsetenv(STRHOSTTYPE, str2short(hosttype));
    tsetenv(STRVENDOR,	 str2short(vendor));
    tsetenv(STROSTYPE,	 str2short(ostype));
    tsetenv(STRMACHTYPE, str2short(machtype));
} /* end setmachine */
