/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGSVGElement.h"

#include "Element.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSElement.h"
#include "JSNodeList.h"
#include "JSSVGAngle.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGElement.h"
#include "JSSVGLength.h"
#include "JSSVGMatrix.h"
#include "JSSVGNumber.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGTransform.h"
#include "JSSVGViewSpec.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "SVGAngle.h"
#include "SVGLength.h"
#include "SVGMatrix.h"
#include "SVGPoint.h"
#include "SVGRect.h"
#include "SVGSVGElement.h"
#include "SVGStaticPropertyTearOff.h"
#include "SVGTransform.h"
#include "SVGViewSpec.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGSVGElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementHeight), (intptr_t)0, NoIntrinsic },
    { "contentScriptType", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementContentScriptType), (intptr_t)setJSSVGSVGElementContentScriptType, NoIntrinsic },
    { "contentStyleType", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementContentStyleType), (intptr_t)setJSSVGSVGElementContentStyleType, NoIntrinsic },
    { "viewport", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementViewport), (intptr_t)0, NoIntrinsic },
    { "pixelUnitToMillimeterX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementPixelUnitToMillimeterX), (intptr_t)0, NoIntrinsic },
    { "pixelUnitToMillimeterY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementPixelUnitToMillimeterY), (intptr_t)0, NoIntrinsic },
    { "screenPixelToMillimeterX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementScreenPixelToMillimeterX), (intptr_t)0, NoIntrinsic },
    { "screenPixelToMillimeterY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementScreenPixelToMillimeterY), (intptr_t)0, NoIntrinsic },
    { "useCurrentView", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementUseCurrentView), (intptr_t)0, NoIntrinsic },
    { "currentView", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementCurrentView), (intptr_t)0, NoIntrinsic },
    { "currentScale", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementCurrentScale), (intptr_t)setJSSVGSVGElementCurrentScale, NoIntrinsic },
    { "currentTranslate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementCurrentTranslate), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "viewBox", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementViewBox), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "preserveAspectRatio", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementPreserveAspectRatio), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "zoomAndPan", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementZoomAndPan), (intptr_t)setJSSVGSVGElementZoomAndPan, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSVGElementTable = { 66, 63, JSSVGSVGElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGSVGElementConstructorTableValues[] =
{
#if ENABLE(SVG)
    { "SVG_ZOOMANDPAN_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_UNKNOWN), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "SVG_ZOOMANDPAN_DISABLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_DISABLE), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "SVG_ZOOMANDPAN_MAGNIFY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_MAGNIFY), (intptr_t)0, NoIntrinsic },
#endif
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSVGElementConstructorTable = { 9, 7, JSSVGSVGElementConstructorTableValues, 0 };

#if ENABLE(SVG)
COMPILE_ASSERT(0 == SVGSVGElement::SVG_ZOOMANDPAN_UNKNOWN, SVGSVGElementEnumSVG_ZOOMANDPAN_UNKNOWNIsWrongUseDoNotCheckConstants);
#endif
#if ENABLE(SVG)
COMPILE_ASSERT(1 == SVGSVGElement::SVG_ZOOMANDPAN_DISABLE, SVGSVGElementEnumSVG_ZOOMANDPAN_DISABLEIsWrongUseDoNotCheckConstants);
#endif
#if ENABLE(SVG)
COMPILE_ASSERT(2 == SVGSVGElement::SVG_ZOOMANDPAN_MAGNIFY, SVGSVGElementEnumSVG_ZOOMANDPAN_MAGNIFYIsWrongUseDoNotCheckConstants);
#endif

const ClassInfo JSSVGSVGElementConstructor::s_info = { "SVGSVGElementConstructor", &Base::s_info, &JSSVGSVGElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGSVGElementConstructor) };

JSSVGSVGElementConstructor::JSSVGSVGElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGSVGElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGSVGElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGSVGElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSVGElementConstructor, JSDOMWrapper>(exec, &JSSVGSVGElementConstructorTable, jsCast<JSSVGSVGElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGSVGElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGSVGElementConstructor, JSDOMWrapper>(exec, &JSSVGSVGElementConstructorTable, jsCast<JSSVGSVGElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGSVGElementPrototypeTableValues[] =
{
#if ENABLE(SVG)
    { "SVG_ZOOMANDPAN_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_UNKNOWN), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "SVG_ZOOMANDPAN_DISABLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_DISABLE), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "SVG_ZOOMANDPAN_MAGNIFY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSVGElementSVG_ZOOMANDPAN_MAGNIFY), (intptr_t)0, NoIntrinsic },
#endif
    { "suspendRedraw", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionSuspendRedraw), (intptr_t)0, NoIntrinsic },
    { "unsuspendRedraw", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionUnsuspendRedraw), (intptr_t)0, NoIntrinsic },
    { "unsuspendRedrawAll", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionUnsuspendRedrawAll), (intptr_t)0, NoIntrinsic },
    { "forceRedraw", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionForceRedraw), (intptr_t)0, NoIntrinsic },
    { "pauseAnimations", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionPauseAnimations), (intptr_t)0, NoIntrinsic },
    { "unpauseAnimations", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionUnpauseAnimations), (intptr_t)0, NoIntrinsic },
    { "animationsPaused", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionAnimationsPaused), (intptr_t)0, NoIntrinsic },
    { "getCurrentTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetCurrentTime), (intptr_t)0, NoIntrinsic },
    { "setCurrentTime", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionSetCurrentTime), (intptr_t)0, NoIntrinsic },
    { "getIntersectionList", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetIntersectionList), (intptr_t)0, NoIntrinsic },
    { "getEnclosureList", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetEnclosureList), (intptr_t)0, NoIntrinsic },
    { "checkIntersection", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCheckIntersection), (intptr_t)0, NoIntrinsic },
    { "checkEnclosure", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCheckEnclosure), (intptr_t)0, NoIntrinsic },
    { "deselectAll", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionDeselectAll), (intptr_t)0, NoIntrinsic },
    { "createSVGNumber", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGNumber), (intptr_t)0, NoIntrinsic },
    { "createSVGLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGLength), (intptr_t)0, NoIntrinsic },
    { "createSVGAngle", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGAngle), (intptr_t)0, NoIntrinsic },
    { "createSVGPoint", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGPoint), (intptr_t)0, NoIntrinsic },
    { "createSVGMatrix", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGMatrix), (intptr_t)0, NoIntrinsic },
    { "createSVGRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGRect), (intptr_t)0, NoIntrinsic },
    { "createSVGTransform", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGTransform), (intptr_t)0, NoIntrinsic },
    { "createSVGTransformFromMatrix", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionCreateSVGTransformFromMatrix), (intptr_t)0, NoIntrinsic },
    { "getElementById", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSVGElementPrototypeFunctionGetElementById), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSVGElementPrototypeTable = { 69, 63, JSSVGSVGElementPrototypeTableValues, 0 };
const ClassInfo JSSVGSVGElementPrototype::s_info = { "SVGSVGElementPrototype", &Base::s_info, &JSSVGSVGElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGSVGElementPrototype) };

JSObject* JSSVGSVGElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGSVGElement>(exec, globalObject);
}

bool JSSVGSVGElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGSVGElementPrototype* thisObject = jsCast<JSSVGSVGElementPrototype*>(cell);
    return getStaticPropertySlot<JSSVGSVGElementPrototype, JSObject>(exec, &JSSVGSVGElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGSVGElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGSVGElementPrototype* thisObject = jsCast<JSSVGSVGElementPrototype*>(object);
    return getStaticPropertyDescriptor<JSSVGSVGElementPrototype, JSObject>(exec, &JSSVGSVGElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGSVGElement::s_info = { "SVGSVGElement", &Base::s_info, &JSSVGSVGElementTable, 0 , CREATE_METHOD_TABLE(JSSVGSVGElement) };

JSSVGSVGElement::JSSVGSVGElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGSVGElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGSVGElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGSVGElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGSVGElementPrototype::create(exec->vm(), globalObject, JSSVGSVGElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGSVGElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGSVGElement* thisObject = jsCast<JSSVGSVGElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGSVGElement, Base>(exec, &JSSVGSVGElementTable, thisObject, propertyName, slot);
}

bool JSSVGSVGElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGSVGElement* thisObject = jsCast<JSSVGSVGElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGSVGElement, Base>(exec, &JSSVGSVGElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGSVGElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSVGElementContentScriptType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->contentScriptType());
    return result;
}


JSValue jsSVGSVGElementContentStyleType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->contentStyleType());
    return result;
}


JSValue jsSVGSVGElementViewport(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->viewport())));
    return result;
}


JSValue jsSVGSVGElementPixelUnitToMillimeterX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->pixelUnitToMillimeterX());
    return result;
}


JSValue jsSVGSVGElementPixelUnitToMillimeterY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->pixelUnitToMillimeterY());
    return result;
}


JSValue jsSVGSVGElementScreenPixelToMillimeterX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->screenPixelToMillimeterX());
    return result;
}


JSValue jsSVGSVGElementScreenPixelToMillimeterY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->screenPixelToMillimeterY());
    return result;
}


JSValue jsSVGSVGElementUseCurrentView(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->useCurrentView());
    return result;
}


JSValue jsSVGSVGElementCurrentView(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->currentView()));
    return result;
}


JSValue jsSVGSVGElementCurrentScale(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->currentScale());
    return result;
}


JSValue jsSVGSVGElementCurrentTranslate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticPropertyTearOff<SVGSVGElement, SVGPoint>::create(impl, impl->currentTranslate(), &SVGSVGElement::updateCurrentTranslate)));
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGSVGElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGSVGElementViewBox(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedRect> obj = impl->viewBoxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGSVGElementPreserveAspectRatio(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = impl->preserveAspectRatioAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGSVGElementZoomAndPan(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->zoomAndPan());
    return result;
}

#endif

JSValue jsSVGSVGElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSVGElement* domObject = jsCast<JSSVGSVGElement*>(asObject(slotBase));
    return JSSVGSVGElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGSVGElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGSVGElement* thisObject = jsCast<JSSVGSVGElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGSVGElement, Base>(exec, propertyName, value, &JSSVGSVGElementTable, thisObject, slot);
}

void setJSSVGSVGElementContentScriptType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(thisObject);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setContentScriptType(nativeValue);
}


void setJSSVGSVGElementContentStyleType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(thisObject);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setContentStyleType(nativeValue);
}


void setJSSVGSVGElementCurrentScale(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(thisObject);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    impl->setCurrentScale(nativeValue);
}


#if ENABLE(SVG)
void setJSSVGSVGElementZoomAndPan(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(thisObject);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    unsigned short nativeValue(toUInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setZoomAndPan(nativeValue);
}

#endif

JSValue JSSVGSVGElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGSVGElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionSuspendRedraw(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    unsigned maxWaitMilliseconds(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->suspendRedraw(maxWaitMilliseconds));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionUnsuspendRedraw(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    unsigned suspendHandleId(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->unsuspendRedraw(suspendHandleId);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionUnsuspendRedrawAll(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    impl->unsuspendRedrawAll();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionForceRedraw(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    impl->forceRedraw();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionPauseAnimations(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    impl->pauseAnimations();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionUnpauseAnimations(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    impl->unpauseAnimations();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionAnimationsPaused(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->animationsPaused());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetCurrentTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->getCurrentTime());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionSetCurrentTime(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    float seconds(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCurrentTime(seconds);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetIntersectionList(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    SVGPropertyTearOff<FloatRect>* rect(toSVGRect(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!rect) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGElement* referenceElement(toSVGElement(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getIntersectionList(rect->propertyReference(), referenceElement)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetEnclosureList(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    SVGPropertyTearOff<FloatRect>* rect(toSVGRect(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!rect) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGElement* referenceElement(toSVGElement(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getEnclosureList(rect->propertyReference(), referenceElement)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCheckIntersection(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    SVGPropertyTearOff<FloatRect>* rect(toSVGRect(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!rect) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }

    JSC::JSValue result = jsBoolean(impl->checkIntersection(element, rect->propertyReference()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCheckEnclosure(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    SVGPropertyTearOff<FloatRect>* rect(toSVGRect(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!rect) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }

    JSC::JSValue result = jsBoolean(impl->checkEnclosure(element, rect->propertyReference()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionDeselectAll(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    impl->deselectAll();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGNumber(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<float>::create(impl->createSVGNumber())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGLength>::create(impl->createSVGLength())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGAngle(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGAngle>::create(impl->createSVGAngle())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGPoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGPoint>::create(impl->createSVGPoint())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGMatrix(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->createSVGMatrix())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->createSVGRect())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGTransform(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGTransform>::create(impl->createSVGTransform())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionCreateSVGTransformFromMatrix(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    SVGPropertyTearOff<SVGMatrix>* matrix(toSVGMatrix(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!matrix) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGTransform>::create(impl->createSVGTransformFromMatrix(matrix->propertyReference()))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGSVGElementPrototypeFunctionGetElementById(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSVGElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSVGElement* castedThis = jsCast<JSSVGSVGElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSVGElement::s_info);
    SVGSVGElement* impl = static_cast<SVGSVGElement*>(castedThis->impl());
    const String& elementId(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementById(elementId)));
    return JSValue::encode(result);
}

// Constant getters

#if ENABLE(SVG)
JSValue jsSVGSVGElementSVG_ZOOMANDPAN_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

#endif
#if ENABLE(SVG)
JSValue jsSVGSVGElementSVG_ZOOMANDPAN_DISABLE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

#endif
#if ENABLE(SVG)
JSValue jsSVGSVGElementSVG_ZOOMANDPAN_MAGNIFY(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

#endif

}

#endif // ENABLE(SVG)
