/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGRect.h"

#include "ExceptionCode.h"
#include "SVGRect.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGRectTableValues[] =
{
    { "x", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectX), (intptr_t)setJSSVGRectX, NoIntrinsic },
    { "y", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectY), (intptr_t)setJSSVGRectY, NoIntrinsic },
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectWidth), (intptr_t)setJSSVGRectWidth, NoIntrinsic },
    { "height", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectHeight), (intptr_t)setJSSVGRectHeight, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRectTable = { 17, 15, JSSVGRectTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGRectConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRectConstructorTable = { 1, 0, JSSVGRectConstructorTableValues, 0 };
const ClassInfo JSSVGRectConstructor::s_info = { "SVGRectConstructor", &Base::s_info, &JSSVGRectConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGRectConstructor) };

JSSVGRectConstructor::JSSVGRectConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGRectConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGRectPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGRectConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRectConstructor, JSDOMWrapper>(exec, &JSSVGRectConstructorTable, jsCast<JSSVGRectConstructor*>(cell), propertyName, slot);
}

bool JSSVGRectConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGRectConstructor, JSDOMWrapper>(exec, &JSSVGRectConstructorTable, jsCast<JSSVGRectConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGRectPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRectPrototypeTable = { 1, 0, JSSVGRectPrototypeTableValues, 0 };
const ClassInfo JSSVGRectPrototype::s_info = { "SVGRectPrototype", &Base::s_info, &JSSVGRectPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGRectPrototype) };

JSObject* JSSVGRectPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGRect>(exec, globalObject);
}

const ClassInfo JSSVGRect::s_info = { "SVGRect", &Base::s_info, &JSSVGRectTable, 0 , CREATE_METHOD_TABLE(JSSVGRect) };

JSSVGRect::JSSVGRect(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPropertyTearOff<FloatRect> > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGRect::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGRect::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGRectPrototype::create(exec->vm(), globalObject, JSSVGRectPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGRect::destroy(JSC::JSCell* cell)
{
    JSSVGRect* thisObject = static_cast<JSSVGRect*>(cell);
    thisObject->JSSVGRect::~JSSVGRect();
}

JSSVGRect::~JSSVGRect()
{
    releaseImplIfNotNull();
}

bool JSSVGRect::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGRect* thisObject = jsCast<JSSVGRect*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGRect, Base>(exec, &JSSVGRectTable, thisObject, propertyName, slot);
}

bool JSSVGRect::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGRect* thisObject = jsCast<JSSVGRect*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGRect, Base>(exec, &JSSVGRectTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGRectX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRect* castedThis = jsCast<JSSVGRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FloatRect& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.x());
    return result;
}


JSValue jsSVGRectY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRect* castedThis = jsCast<JSSVGRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FloatRect& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.y());
    return result;
}


JSValue jsSVGRectWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRect* castedThis = jsCast<JSSVGRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FloatRect& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.width());
    return result;
}


JSValue jsSVGRectHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRect* castedThis = jsCast<JSSVGRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FloatRect& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.height());
    return result;
}


JSValue jsSVGRectConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRect* domObject = jsCast<JSSVGRect*>(asObject(slotBase));
    return JSSVGRect::getConstructor(exec, domObject->globalObject());
}

void JSSVGRect::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGRect* thisObject = jsCast<JSSVGRect*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGRect, Base>(exec, propertyName, value, &JSSVGRectTable, thisObject, slot);
}

void setJSSVGRectX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGRect* castedThis = jsCast<JSSVGRect*>(thisObject);
    SVGPropertyTearOff<FloatRect> * impl = static_cast<SVGPropertyTearOff<FloatRect> *>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    FloatRect& podImpl = impl->propertyReference();
    podImpl.setX(nativeValue);
    impl->commitChange();
}


void setJSSVGRectY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGRect* castedThis = jsCast<JSSVGRect*>(thisObject);
    SVGPropertyTearOff<FloatRect> * impl = static_cast<SVGPropertyTearOff<FloatRect> *>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    FloatRect& podImpl = impl->propertyReference();
    podImpl.setY(nativeValue);
    impl->commitChange();
}


void setJSSVGRectWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGRect* castedThis = jsCast<JSSVGRect*>(thisObject);
    SVGPropertyTearOff<FloatRect> * impl = static_cast<SVGPropertyTearOff<FloatRect> *>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    FloatRect& podImpl = impl->propertyReference();
    podImpl.setWidth(nativeValue);
    impl->commitChange();
}


void setJSSVGRectHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGRect* castedThis = jsCast<JSSVGRect*>(thisObject);
    SVGPropertyTearOff<FloatRect> * impl = static_cast<SVGPropertyTearOff<FloatRect> *>(castedThis->impl());
    float nativeValue(value.toFloat(exec));
    if (exec->hadException())
        return;
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    FloatRect& podImpl = impl->propertyReference();
    podImpl.setHeight(nativeValue);
    impl->commitChange();
}


JSValue JSSVGRect::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGRectConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGRect* jsSVGRect)
{
    if (jsSVGRect->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGRectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGRect* jsSVGRect = jsCast<JSSVGRect*>(handle.get().asCell());
    if (!isObservable(jsSVGRect))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGRectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGRect* jsSVGRect = jsCast<JSSVGRect*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGRect->impl(), jsSVGRect);
    jsSVGRect->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<FloatRect> * impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGRect, SVGPropertyTearOff<FloatRect> >(exec, impl))
        return result;
    ReportMemoryCost<SVGPropertyTearOff<FloatRect> >::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGRect, SVGPropertyTearOff<FloatRect> >(exec, globalObject, impl);
}

SVGPropertyTearOff<FloatRect> * toSVGRect(JSC::JSValue value)
{
    return value.inherits(&JSSVGRect::s_info) ? jsCast<JSSVGRect*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
