/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(JAVASCRIPT_DEBUGGER)

#include "JSJavaScriptCallFrame.h"

#include "JSJavaScriptCallFrame.h"
#include "JavaScriptCallFrame.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSJavaScriptCallFrameTableValues[] =
{
    { "caller", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameCaller), (intptr_t)0, NoIntrinsic },
    { "sourceID", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameSourceID), (intptr_t)0, NoIntrinsic },
    { "line", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameLine), (intptr_t)0, NoIntrinsic },
    { "column", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameColumn), (intptr_t)0, NoIntrinsic },
    { "scopeChain", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameScopeChain), (intptr_t)0, NoIntrinsic },
    { "thisObject", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameThisObject), (intptr_t)0, NoIntrinsic },
    { "functionName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameFunctionName), (intptr_t)0, NoIntrinsic },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameType), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSJavaScriptCallFrameTable = { 17, 15, JSJavaScriptCallFrameTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSJavaScriptCallFramePrototypeTableValues[] =
{
    { "GLOBAL_SCOPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameGLOBAL_SCOPE), (intptr_t)0, NoIntrinsic },
    { "LOCAL_SCOPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameLOCAL_SCOPE), (intptr_t)0, NoIntrinsic },
    { "WITH_SCOPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameWITH_SCOPE), (intptr_t)0, NoIntrinsic },
    { "CLOSURE_SCOPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameCLOSURE_SCOPE), (intptr_t)0, NoIntrinsic },
    { "CATCH_SCOPE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsJavaScriptCallFrameCATCH_SCOPE), (intptr_t)0, NoIntrinsic },
    { "evaluate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsJavaScriptCallFramePrototypeFunctionEvaluate), (intptr_t)1, NoIntrinsic },
    { "restart", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsJavaScriptCallFramePrototypeFunctionRestart), (intptr_t)0, NoIntrinsic },
    { "setVariableValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsJavaScriptCallFramePrototypeFunctionSetVariableValue), (intptr_t)3, NoIntrinsic },
    { "scopeType", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsJavaScriptCallFramePrototypeFunctionScopeType), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSJavaScriptCallFramePrototypeTable = { 33, 31, JSJavaScriptCallFramePrototypeTableValues, 0 };
const ClassInfo JSJavaScriptCallFramePrototype::s_info = { "JavaScriptCallFramePrototype", &Base::s_info, &JSJavaScriptCallFramePrototypeTable, 0, CREATE_METHOD_TABLE(JSJavaScriptCallFramePrototype) };

JSObject* JSJavaScriptCallFramePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSJavaScriptCallFrame>(exec, globalObject);
}

bool JSJavaScriptCallFramePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSJavaScriptCallFramePrototype* thisObject = jsCast<JSJavaScriptCallFramePrototype*>(cell);
    return getStaticPropertySlot<JSJavaScriptCallFramePrototype, JSObject>(exec, &JSJavaScriptCallFramePrototypeTable, thisObject, propertyName, slot);
}

bool JSJavaScriptCallFramePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSJavaScriptCallFramePrototype* thisObject = jsCast<JSJavaScriptCallFramePrototype*>(object);
    return getStaticPropertyDescriptor<JSJavaScriptCallFramePrototype, JSObject>(exec, &JSJavaScriptCallFramePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSJavaScriptCallFrame::s_info = { "JavaScriptCallFrame", &Base::s_info, &JSJavaScriptCallFrameTable, 0 , CREATE_METHOD_TABLE(JSJavaScriptCallFrame) };

JSJavaScriptCallFrame::JSJavaScriptCallFrame(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<JavaScriptCallFrame> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSJavaScriptCallFrame::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSJavaScriptCallFrame::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSJavaScriptCallFramePrototype::create(exec->vm(), globalObject, JSJavaScriptCallFramePrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSJavaScriptCallFrame::destroy(JSC::JSCell* cell)
{
    JSJavaScriptCallFrame* thisObject = static_cast<JSJavaScriptCallFrame*>(cell);
    thisObject->JSJavaScriptCallFrame::~JSJavaScriptCallFrame();
}

JSJavaScriptCallFrame::~JSJavaScriptCallFrame()
{
    releaseImplIfNotNull();
}

bool JSJavaScriptCallFrame::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSJavaScriptCallFrame* thisObject = jsCast<JSJavaScriptCallFrame*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSJavaScriptCallFrame, Base>(exec, &JSJavaScriptCallFrameTable, thisObject, propertyName, slot);
}

bool JSJavaScriptCallFrame::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSJavaScriptCallFrame* thisObject = jsCast<JSJavaScriptCallFrame*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSJavaScriptCallFrame, Base>(exec, &JSJavaScriptCallFrameTable, thisObject, propertyName, descriptor);
}

JSValue jsJavaScriptCallFrameCaller(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JavaScriptCallFrame* impl = static_cast<JavaScriptCallFrame*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->caller()));
    return result;
}


JSValue jsJavaScriptCallFrameSourceID(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JavaScriptCallFrame* impl = static_cast<JavaScriptCallFrame*>(castedThis->impl());
    JSValue result = jsNumber(impl->sourceID());
    return result;
}


JSValue jsJavaScriptCallFrameLine(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JavaScriptCallFrame* impl = static_cast<JavaScriptCallFrame*>(castedThis->impl());
    JSValue result = jsNumber(impl->line());
    return result;
}


JSValue jsJavaScriptCallFrameColumn(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JavaScriptCallFrame* impl = static_cast<JavaScriptCallFrame*>(castedThis->impl());
    JSValue result = jsNumber(impl->column());
    return result;
}


JSValue jsJavaScriptCallFrameScopeChain(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(slotBase));
    return castedThis->scopeChain(exec);
}


JSValue jsJavaScriptCallFrameThisObject(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(slotBase));
    return castedThis->thisObject(exec);
}


JSValue jsJavaScriptCallFrameFunctionName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JavaScriptCallFrame* impl = static_cast<JavaScriptCallFrame*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->functionName());
    return result;
}


JSValue jsJavaScriptCallFrameType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(slotBase));
    return castedThis->type(exec);
}


EncodedJSValue JSC_HOST_CALL jsJavaScriptCallFramePrototypeFunctionEvaluate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSJavaScriptCallFrame::s_info))
        return throwVMTypeError(exec);
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSJavaScriptCallFrame::s_info);
    return JSValue::encode(castedThis->evaluate(exec));
}

EncodedJSValue JSC_HOST_CALL jsJavaScriptCallFramePrototypeFunctionRestart(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSJavaScriptCallFrame::s_info))
        return throwVMTypeError(exec);
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSJavaScriptCallFrame::s_info);
    return JSValue::encode(castedThis->restart(exec));
}

EncodedJSValue JSC_HOST_CALL jsJavaScriptCallFramePrototypeFunctionSetVariableValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSJavaScriptCallFrame::s_info))
        return throwVMTypeError(exec);
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSJavaScriptCallFrame::s_info);
    return JSValue::encode(castedThis->setVariableValue(exec));
}

EncodedJSValue JSC_HOST_CALL jsJavaScriptCallFramePrototypeFunctionScopeType(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSJavaScriptCallFrame::s_info))
        return throwVMTypeError(exec);
    JSJavaScriptCallFrame* castedThis = jsCast<JSJavaScriptCallFrame*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSJavaScriptCallFrame::s_info);
    return JSValue::encode(castedThis->scopeType(exec));
}

// Constant getters

JSValue jsJavaScriptCallFrameGLOBAL_SCOPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsJavaScriptCallFrameLOCAL_SCOPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsJavaScriptCallFrameWITH_SCOPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsJavaScriptCallFrameCLOSURE_SCOPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsJavaScriptCallFrameCATCH_SCOPE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

static inline bool isObservable(JSJavaScriptCallFrame* jsJavaScriptCallFrame)
{
    if (jsJavaScriptCallFrame->hasCustomProperties())
        return true;
    return false;
}

bool JSJavaScriptCallFrameOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSJavaScriptCallFrame* jsJavaScriptCallFrame = jsCast<JSJavaScriptCallFrame*>(handle.get().asCell());
    if (!isObservable(jsJavaScriptCallFrame))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSJavaScriptCallFrameOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSJavaScriptCallFrame* jsJavaScriptCallFrame = jsCast<JSJavaScriptCallFrame*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsJavaScriptCallFrame->impl(), jsJavaScriptCallFrame);
    jsJavaScriptCallFrame->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, JavaScriptCallFrame* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSJavaScriptCallFrame>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to JavaScriptCallFrame.
    COMPILE_ASSERT(!__is_polymorphic(JavaScriptCallFrame), JavaScriptCallFrame_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<JavaScriptCallFrame>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSJavaScriptCallFrame>(exec, globalObject, impl);
}

JavaScriptCallFrame* toJavaScriptCallFrame(JSC::JSValue value)
{
    return value.inherits(&JSJavaScriptCallFrame::s_info) ? jsCast<JSJavaScriptCallFrame*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
