/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTableCellElement.h"

#include "HTMLNames.h"
#include "HTMLTableCellElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLTableCellElementTableValues[] =
{
    { "cellIndex", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementCellIndex), (intptr_t)0, NoIntrinsic },
    { "abbr", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementAbbr), (intptr_t)setJSHTMLTableCellElementAbbr, NoIntrinsic },
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementAlign), (intptr_t)setJSHTMLTableCellElementAlign, NoIntrinsic },
    { "axis", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementAxis), (intptr_t)setJSHTMLTableCellElementAxis, NoIntrinsic },
    { "bgColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementBgColor), (intptr_t)setJSHTMLTableCellElementBgColor, NoIntrinsic },
    { "ch", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementCh), (intptr_t)setJSHTMLTableCellElementCh, NoIntrinsic },
    { "chOff", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementChOff), (intptr_t)setJSHTMLTableCellElementChOff, NoIntrinsic },
    { "colSpan", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementColSpan), (intptr_t)setJSHTMLTableCellElementColSpan, NoIntrinsic },
    { "headers", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementHeaders), (intptr_t)setJSHTMLTableCellElementHeaders, NoIntrinsic },
    { "height", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementHeight), (intptr_t)setJSHTMLTableCellElementHeight, NoIntrinsic },
    { "noWrap", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementNoWrap), (intptr_t)setJSHTMLTableCellElementNoWrap, NoIntrinsic },
    { "rowSpan", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementRowSpan), (intptr_t)setJSHTMLTableCellElementRowSpan, NoIntrinsic },
    { "scope", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementScope), (intptr_t)setJSHTMLTableCellElementScope, NoIntrinsic },
    { "vAlign", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementVAlign), (intptr_t)setJSHTMLTableCellElementVAlign, NoIntrinsic },
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementWidth), (intptr_t)setJSHTMLTableCellElementWidth, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableCellElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableCellElementTable = { 36, 31, JSHTMLTableCellElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLTableCellElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableCellElementConstructorTable = { 1, 0, JSHTMLTableCellElementConstructorTableValues, 0 };
const ClassInfo JSHTMLTableCellElementConstructor::s_info = { "HTMLTableCellElementConstructor", &Base::s_info, &JSHTMLTableCellElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLTableCellElementConstructor) };

JSHTMLTableCellElementConstructor::JSHTMLTableCellElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTableCellElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLTableCellElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLTableCellElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableCellElementConstructor, JSDOMWrapper>(exec, &JSHTMLTableCellElementConstructorTable, jsCast<JSHTMLTableCellElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLTableCellElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTableCellElementConstructor, JSDOMWrapper>(exec, &JSHTMLTableCellElementConstructorTable, jsCast<JSHTMLTableCellElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTableCellElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableCellElementPrototypeTable = { 1, 0, JSHTMLTableCellElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLTableCellElementPrototype::s_info = { "HTMLTableCellElementPrototype", &Base::s_info, &JSHTMLTableCellElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLTableCellElementPrototype) };

JSObject* JSHTMLTableCellElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTableCellElement>(exec, globalObject);
}

const ClassInfo JSHTMLTableCellElement::s_info = { "HTMLTableCellElement", &Base::s_info, &JSHTMLTableCellElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLTableCellElement) };

JSHTMLTableCellElement::JSHTMLTableCellElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTableCellElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLTableCellElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTableCellElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTableCellElementPrototype::create(exec->vm(), globalObject, JSHTMLTableCellElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTableCellElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTableCellElement* thisObject = jsCast<JSHTMLTableCellElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLTableCellElement, Base>(exec, &JSHTMLTableCellElementTable, thisObject, propertyName, slot);
}

bool JSHTMLTableCellElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTableCellElement* thisObject = jsCast<JSHTMLTableCellElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLTableCellElement, Base>(exec, &JSHTMLTableCellElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLTableCellElementCellIndex(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->cellIndex());
    return result;
}


JSValue jsHTMLTableCellElementAbbr(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::abbrAttr));
    return result;
}


JSValue jsHTMLTableCellElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLTableCellElementAxis(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::axisAttr));
    return result;
}


JSValue jsHTMLTableCellElementBgColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr));
    return result;
}


JSValue jsHTMLTableCellElementCh(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::charAttr));
    return result;
}


JSValue jsHTMLTableCellElementChOff(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::charoffAttr));
    return result;
}


JSValue jsHTMLTableCellElementColSpan(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->colSpan());
    return result;
}


JSValue jsHTMLTableCellElementHeaders(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::headersAttr));
    return result;
}


JSValue jsHTMLTableCellElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return result;
}


JSValue jsHTMLTableCellElementNoWrap(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::nowrapAttr));
    return result;
}


JSValue jsHTMLTableCellElementRowSpan(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->rowSpan());
    return result;
}


JSValue jsHTMLTableCellElementScope(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::scopeAttr));
    return result;
}


JSValue jsHTMLTableCellElementVAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::valignAttr));
    return result;
}


JSValue jsHTMLTableCellElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}


JSValue jsHTMLTableCellElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableCellElement* domObject = jsCast<JSHTMLTableCellElement*>(asObject(slotBase));
    return JSHTMLTableCellElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLTableCellElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLTableCellElement* thisObject = jsCast<JSHTMLTableCellElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLTableCellElement, Base>(exec, propertyName, value, &JSHTMLTableCellElementTable, thisObject, slot);
}

void setJSHTMLTableCellElementAbbr(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::abbrAttr, nativeValue);
}


void setJSHTMLTableCellElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::alignAttr, nativeValue);
}


void setJSHTMLTableCellElementAxis(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::axisAttr, nativeValue);
}


void setJSHTMLTableCellElementBgColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::bgcolorAttr, nativeValue);
}


void setJSHTMLTableCellElementCh(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::charAttr, nativeValue);
}


void setJSHTMLTableCellElementChOff(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::charoffAttr, nativeValue);
}


void setJSHTMLTableCellElementColSpan(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setColSpan(nativeValue);
}


void setJSHTMLTableCellElementHeaders(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::headersAttr, nativeValue);
}


void setJSHTMLTableCellElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::heightAttr, nativeValue);
}


void setJSHTMLTableCellElementNoWrap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    bool nativeValue(value.toBoolean(exec));
    if (exec->hadException())
        return;
    impl->setBooleanAttribute(WebCore::HTMLNames::nowrapAttr, nativeValue);
}


void setJSHTMLTableCellElementRowSpan(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setRowSpan(nativeValue);
}


void setJSHTMLTableCellElementScope(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::scopeAttr, nativeValue);
}


void setJSHTMLTableCellElementVAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::valignAttr, nativeValue);
}


void setJSHTMLTableCellElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableCellElement* castedThis = jsCast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* impl = static_cast<HTMLTableCellElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::widthAttr, nativeValue);
}


JSValue JSHTMLTableCellElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTableCellElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
