/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPointList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGPoint.h"
#include "SVGPoint.h"
#include "SVGPointList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPointListTableValues[] =
{
    { "numberOfItems", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPointListNumberOfItems), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPointListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPointListTable = { 4, 3, JSSVGPointListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPointListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPointListConstructorTable = { 1, 0, JSSVGPointListConstructorTableValues, 0 };
const ClassInfo JSSVGPointListConstructor::s_info = { "SVGPointListConstructor", &Base::s_info, &JSSVGPointListConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPointListConstructor) };

JSSVGPointListConstructor::JSSVGPointListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPointListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGPointListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGPointListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPointListConstructor, JSDOMWrapper>(exec, &JSSVGPointListConstructorTable, jsCast<JSSVGPointListConstructor*>(cell), propertyName, slot);
}

bool JSSVGPointListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPointListConstructor, JSDOMWrapper>(exec, &JSSVGPointListConstructorTable, jsCast<JSSVGPointListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPointListPrototypeTableValues[] =
{
    { "clear", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionClear), (intptr_t)0, NoIntrinsic },
    { "initialize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionInitialize), (intptr_t)1, NoIntrinsic },
    { "getItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionGetItem), (intptr_t)1, NoIntrinsic },
    { "insertItemBefore", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionInsertItemBefore), (intptr_t)2, NoIntrinsic },
    { "replaceItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionReplaceItem), (intptr_t)2, NoIntrinsic },
    { "removeItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionRemoveItem), (intptr_t)1, NoIntrinsic },
    { "appendItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPointListPrototypeFunctionAppendItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPointListPrototypeTable = { 18, 15, JSSVGPointListPrototypeTableValues, 0 };
const ClassInfo JSSVGPointListPrototype::s_info = { "SVGPointListPrototype", &Base::s_info, &JSSVGPointListPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPointListPrototype) };

JSObject* JSSVGPointListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPointList>(exec, globalObject);
}

bool JSSVGPointListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPointListPrototype* thisObject = jsCast<JSSVGPointListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPointListPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGPointListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPointListPrototype* thisObject = jsCast<JSSVGPointListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPointListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGPointList::s_info = { "SVGPointList", &Base::s_info, &JSSVGPointListTable, 0 , CREATE_METHOD_TABLE(JSSVGPointList) };

JSSVGPointList::JSSVGPointList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGListPropertyTearOff<SVGPointList> > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGPointList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPointList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPointListPrototype::create(exec->vm(), globalObject, JSSVGPointListPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGPointList::destroy(JSC::JSCell* cell)
{
    JSSVGPointList* thisObject = static_cast<JSSVGPointList*>(cell);
    thisObject->JSSVGPointList::~JSSVGPointList();
}

JSSVGPointList::~JSSVGPointList()
{
    releaseImplIfNotNull();
}

bool JSSVGPointList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPointList* thisObject = jsCast<JSSVGPointList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPointList, Base>(exec, &JSSVGPointListTable, thisObject, propertyName, slot);
}

bool JSSVGPointList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPointList* thisObject = jsCast<JSSVGPointList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPointList, Base>(exec, &JSSVGPointListTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPointListNumberOfItems(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPointList* castedThis = jsCast<JSSVGPointList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JSValue result =  jsNumber(castedThis->impl()->numberOfItems());
    return result;
}


JSValue jsSVGPointListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPointList* domObject = jsCast<JSSVGPointList*>(asObject(slotBase));
    return JSSVGPointList::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGPointList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPointListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionClear(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPointList::s_info))
        return throwVMTypeError(exec);
    JSSVGPointList* castedThis = jsCast<JSSVGPointList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPointList::s_info);
    SVGListPropertyTearOff<SVGPointList> * impl = static_cast<SVGListPropertyTearOff<SVGPointList> *>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->clear(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionInitialize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPointList::s_info))
        return throwVMTypeError(exec);
    JSSVGPointList* castedThis = jsCast<JSSVGPointList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPointList::s_info);
    SVGListPropertyTearOff<SVGPointList> * impl = static_cast<SVGListPropertyTearOff<SVGPointList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGPoint::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGPoint>* item(toSVGPoint(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->initialize(item, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionGetItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPointList::s_info))
        return throwVMTypeError(exec);
    JSSVGPointList* castedThis = jsCast<JSSVGPointList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPointList::s_info);
    SVGListPropertyTearOff<SVGPointList> * impl = static_cast<SVGListPropertyTearOff<SVGPointList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getItem(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionInsertItemBefore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPointList::s_info))
        return throwVMTypeError(exec);
    JSSVGPointList* castedThis = jsCast<JSSVGPointList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPointList::s_info);
    SVGListPropertyTearOff<SVGPointList> * impl = static_cast<SVGListPropertyTearOff<SVGPointList> *>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGPoint::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGPoint>* item(toSVGPoint(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(toUInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->insertItemBefore(item, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionReplaceItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPointList::s_info))
        return throwVMTypeError(exec);
    JSSVGPointList* castedThis = jsCast<JSSVGPointList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPointList::s_info);
    SVGListPropertyTearOff<SVGPointList> * impl = static_cast<SVGListPropertyTearOff<SVGPointList> *>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGPoint::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGPoint>* item(toSVGPoint(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(toUInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->replaceItem(item, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionRemoveItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPointList::s_info))
        return throwVMTypeError(exec);
    JSSVGPointList* castedThis = jsCast<JSSVGPointList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPointList::s_info);
    SVGListPropertyTearOff<SVGPointList> * impl = static_cast<SVGListPropertyTearOff<SVGPointList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->removeItem(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPointListPrototypeFunctionAppendItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPointList::s_info))
        return throwVMTypeError(exec);
    JSSVGPointList* castedThis = jsCast<JSSVGPointList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPointList::s_info);
    SVGListPropertyTearOff<SVGPointList> * impl = static_cast<SVGListPropertyTearOff<SVGPointList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGPoint::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGPoint>* item(toSVGPoint(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->appendItem(item, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSSVGPointList* jsSVGPointList)
{
    if (jsSVGPointList->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGPointListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGPointList* jsSVGPointList = jsCast<JSSVGPointList*>(handle.get().asCell());
    if (!isObservable(jsSVGPointList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGPointListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGPointList* jsSVGPointList = jsCast<JSSVGPointList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGPointList->impl(), jsSVGPointList);
    jsSVGPointList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGListPropertyTearOff<SVGPointList> * impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGPointList>(exec, impl))
        return result;
    ReportMemoryCost<SVGListPropertyTearOff<SVGPointList> >::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGPointList>(exec, globalObject, impl);
}

SVGListPropertyTearOff<SVGPointList> * toSVGPointList(JSC::JSValue value)
{
    return value.inherits(&JSSVGPointList::s_info) ? jsCast<JSSVGPointList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
