/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLAppletElement.h"

#include "HTMLAppletElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLAppletElementTableValues[] =
{
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementAlign), (intptr_t)setJSHTMLAppletElementAlign, NoIntrinsic },
    { "alt", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementAlt), (intptr_t)setJSHTMLAppletElementAlt, NoIntrinsic },
    { "archive", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementArchive), (intptr_t)setJSHTMLAppletElementArchive, NoIntrinsic },
    { "code", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementCode), (intptr_t)setJSHTMLAppletElementCode, NoIntrinsic },
    { "codeBase", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementCodeBase), (intptr_t)setJSHTMLAppletElementCodeBase, NoIntrinsic },
    { "height", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementHeight), (intptr_t)setJSHTMLAppletElementHeight, NoIntrinsic },
    { "hspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementHspace), (intptr_t)setJSHTMLAppletElementHspace, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementName), (intptr_t)setJSHTMLAppletElementName, NoIntrinsic },
    { "object", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementObject), (intptr_t)setJSHTMLAppletElementObject, NoIntrinsic },
    { "vspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementVspace), (intptr_t)setJSHTMLAppletElementVspace, NoIntrinsic },
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementWidth), (intptr_t)setJSHTMLAppletElementWidth, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLAppletElementTable = { 35, 31, JSHTMLAppletElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLAppletElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLAppletElementConstructorTable = { 1, 0, JSHTMLAppletElementConstructorTableValues, 0 };
const ClassInfo JSHTMLAppletElementConstructor::s_info = { "HTMLAppletElementConstructor", &Base::s_info, &JSHTMLAppletElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLAppletElementConstructor) };

JSHTMLAppletElementConstructor::JSHTMLAppletElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLAppletElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLAppletElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLAppletElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLAppletElementConstructor, JSDOMWrapper>(exec, &JSHTMLAppletElementConstructorTable, jsCast<JSHTMLAppletElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLAppletElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLAppletElementConstructor, JSDOMWrapper>(exec, &JSHTMLAppletElementConstructorTable, jsCast<JSHTMLAppletElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLAppletElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLAppletElementPrototypeTable = { 1, 0, JSHTMLAppletElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLAppletElementPrototype::s_info = { "HTMLAppletElementPrototype", &Base::s_info, &JSHTMLAppletElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLAppletElementPrototype) };

JSObject* JSHTMLAppletElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLAppletElement>(exec, globalObject);
}

const ClassInfo JSHTMLAppletElement::s_info = { "HTMLAppletElement", &Base::s_info, &JSHTMLAppletElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLAppletElement) };

JSHTMLAppletElement::JSHTMLAppletElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLAppletElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLAppletElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLAppletElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLAppletElementPrototype::create(exec->vm(), globalObject, JSHTMLAppletElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLAppletElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLAppletElement* thisObject = jsCast<JSHTMLAppletElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHTMLAppletElement, Base>(exec, &JSHTMLAppletElementTable, thisObject, propertyName, slot);
}

bool JSHTMLAppletElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLAppletElement* thisObject = jsCast<JSHTMLAppletElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->getOwnPropertyDescriptorDelegate(exec, propertyName, descriptor))
        return true;
    return getStaticValueDescriptor<JSHTMLAppletElement, Base>(exec, &JSHTMLAppletElementTable, thisObject, propertyName, descriptor);
}

bool JSHTMLAppletElement::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSHTMLAppletElement* thisObject = jsCast<JSHTMLAppletElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    if (thisObject->getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsHTMLAppletElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLAppletElementAlt(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::altAttr));
    return result;
}


JSValue jsHTMLAppletElementArchive(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::archiveAttr));
    return result;
}


JSValue jsHTMLAppletElementCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::codeAttr));
    return result;
}


JSValue jsHTMLAppletElementCodeBase(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::codebaseAttr));
    return result;
}


JSValue jsHTMLAppletElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return result;
}


JSValue jsHTMLAppletElementHspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::hspaceAttr));
    return result;
}


JSValue jsHTMLAppletElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getNameAttribute());
    return result;
}


JSValue jsHTMLAppletElementObject(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::objectAttr));
    return result;
}


JSValue jsHTMLAppletElementVspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::vspaceAttr));
    return result;
}


JSValue jsHTMLAppletElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}


JSValue jsHTMLAppletElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLAppletElement* domObject = jsCast<JSHTMLAppletElement*>(asObject(slotBase));
    return JSHTMLAppletElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLAppletElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLAppletElement* thisObject = jsCast<JSHTMLAppletElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (thisObject->putDelegate(exec, propertyName, value, slot))
        return;
    lookupPut<JSHTMLAppletElement, Base>(exec, propertyName, value, &JSHTMLAppletElementTable, thisObject, slot);
}

void JSHTMLAppletElement::putByIndex(JSCell* cell, ExecState* exec, unsigned index, JSValue value, bool shouldThrow)
{
    JSHTMLAppletElement* thisObject = jsCast<JSHTMLAppletElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    PutPropertySlot slot(shouldThrow);
    if (thisObject->putDelegate(exec, propertyName, value, slot))
        return;
    Base::putByIndex(cell, exec, index, value, shouldThrow);
}

void setJSHTMLAppletElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::alignAttr, nativeValue);
}


void setJSHTMLAppletElementAlt(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::altAttr, nativeValue);
}


void setJSHTMLAppletElementArchive(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::archiveAttr, nativeValue);
}


void setJSHTMLAppletElementCode(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::codeAttr, nativeValue);
}


void setJSHTMLAppletElementCodeBase(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::codebaseAttr, nativeValue);
}


void setJSHTMLAppletElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::heightAttr, nativeValue);
}


void setJSHTMLAppletElementHspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::hspaceAttr, nativeValue);
}


void setJSHTMLAppletElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::nameAttr, nativeValue);
}


void setJSHTMLAppletElementObject(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::objectAttr, nativeValue);
}


void setJSHTMLAppletElementVspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::vspaceAttr, nativeValue);
}


void setJSHTMLAppletElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLAppletElement* castedThis = jsCast<JSHTMLAppletElement*>(thisObject);
    HTMLAppletElement* impl = static_cast<HTMLAppletElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::widthAttr, nativeValue);
}


JSValue JSHTMLAppletElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLAppletElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
