/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitAnimation.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include "WebKitAnimation.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebKitAnimationTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationName), (intptr_t)0, NoIntrinsic },
    { "duration", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDuration), (intptr_t)0, NoIntrinsic },
    { "elapsedTime", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationElapsedTime), (intptr_t)setJSWebKitAnimationElapsedTime, NoIntrinsic },
    { "delay", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDelay), (intptr_t)0, NoIntrinsic },
    { "iterationCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationIterationCount), (intptr_t)0, NoIntrinsic },
    { "paused", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationPaused), (intptr_t)0, NoIntrinsic },
    { "ended", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationEnded), (intptr_t)0, NoIntrinsic },
    { "direction", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDirection), (intptr_t)0, NoIntrinsic },
    { "fillMode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFillMode), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitAnimationTable = { 33, 31, JSWebKitAnimationTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebKitAnimationConstructorTableValues[] =
{
    { "DIRECTION_NORMAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDIRECTION_NORMAL), (intptr_t)0, NoIntrinsic },
    { "DIRECTION_ALTERNATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDIRECTION_ALTERNATE), (intptr_t)0, NoIntrinsic },
    { "FILL_NONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_NONE), (intptr_t)0, NoIntrinsic },
    { "FILL_BACKWARDS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_BACKWARDS), (intptr_t)0, NoIntrinsic },
    { "FILL_FORWARDS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_FORWARDS), (intptr_t)0, NoIntrinsic },
    { "FILL_BOTH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_BOTH), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitAnimationConstructorTable = { 16, 15, JSWebKitAnimationConstructorTableValues, 0 };

COMPILE_ASSERT(0 == WebKitAnimation::DIRECTION_NORMAL, WebKitAnimationEnumDIRECTION_NORMALIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == WebKitAnimation::DIRECTION_ALTERNATE, WebKitAnimationEnumDIRECTION_ALTERNATEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0 == WebKitAnimation::FILL_NONE, WebKitAnimationEnumFILL_NONEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == WebKitAnimation::FILL_BACKWARDS, WebKitAnimationEnumFILL_BACKWARDSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == WebKitAnimation::FILL_FORWARDS, WebKitAnimationEnumFILL_FORWARDSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == WebKitAnimation::FILL_BOTH, WebKitAnimationEnumFILL_BOTHIsWrongUseDoNotCheckConstants);

const ClassInfo JSWebKitAnimationConstructor::s_info = { "WebKitAnimationConstructor", &Base::s_info, &JSWebKitAnimationConstructorTable, 0, CREATE_METHOD_TABLE(JSWebKitAnimationConstructor) };

JSWebKitAnimationConstructor::JSWebKitAnimationConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitAnimationConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitAnimationPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebKitAnimationConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationConstructorTable, jsCast<JSWebKitAnimationConstructor*>(cell), propertyName, slot);
}

bool JSWebKitAnimationConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitAnimationConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationConstructorTable, jsCast<JSWebKitAnimationConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitAnimationPrototypeTableValues[] =
{
    { "DIRECTION_NORMAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDIRECTION_NORMAL), (intptr_t)0, NoIntrinsic },
    { "DIRECTION_ALTERNATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDIRECTION_ALTERNATE), (intptr_t)0, NoIntrinsic },
    { "FILL_NONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_NONE), (intptr_t)0, NoIntrinsic },
    { "FILL_BACKWARDS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_BACKWARDS), (intptr_t)0, NoIntrinsic },
    { "FILL_FORWARDS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_FORWARDS), (intptr_t)0, NoIntrinsic },
    { "FILL_BOTH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_BOTH), (intptr_t)0, NoIntrinsic },
    { "play", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitAnimationPrototypeFunctionPlay), (intptr_t)0, NoIntrinsic },
    { "pause", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitAnimationPrototypeFunctionPause), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitAnimationPrototypeTable = { 17, 15, JSWebKitAnimationPrototypeTableValues, 0 };
const ClassInfo JSWebKitAnimationPrototype::s_info = { "WebKitAnimationPrototype", &Base::s_info, &JSWebKitAnimationPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebKitAnimationPrototype) };

JSObject* JSWebKitAnimationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitAnimation>(exec, globalObject);
}

bool JSWebKitAnimationPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitAnimationPrototype* thisObject = jsCast<JSWebKitAnimationPrototype*>(cell);
    return getStaticPropertySlot<JSWebKitAnimationPrototype, JSObject>(exec, &JSWebKitAnimationPrototypeTable, thisObject, propertyName, slot);
}

bool JSWebKitAnimationPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitAnimationPrototype* thisObject = jsCast<JSWebKitAnimationPrototype*>(object);
    return getStaticPropertyDescriptor<JSWebKitAnimationPrototype, JSObject>(exec, &JSWebKitAnimationPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSWebKitAnimation::s_info = { "WebKitAnimation", &Base::s_info, &JSWebKitAnimationTable, 0 , CREATE_METHOD_TABLE(JSWebKitAnimation) };

JSWebKitAnimation::JSWebKitAnimation(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitAnimation> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebKitAnimation::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitAnimation::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitAnimationPrototype::create(exec->globalData(), globalObject, JSWebKitAnimationPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSWebKitAnimation::destroy(JSC::JSCell* cell)
{
    JSWebKitAnimation* thisObject = static_cast<JSWebKitAnimation*>(cell);
    thisObject->JSWebKitAnimation::~JSWebKitAnimation();
}

JSWebKitAnimation::~JSWebKitAnimation()
{
    releaseImplIfNotNull();
}

bool JSWebKitAnimation::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitAnimation* thisObject = jsCast<JSWebKitAnimation*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebKitAnimation, Base>(exec, &JSWebKitAnimationTable, thisObject, propertyName, slot);
}

bool JSWebKitAnimation::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitAnimation* thisObject = jsCast<JSWebKitAnimation*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebKitAnimation, Base>(exec, &JSWebKitAnimationTable, thisObject, propertyName, descriptor);
}

JSValue jsWebKitAnimationName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsWebKitAnimationDuration(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsNumber(impl->duration());
    return result;
}


JSValue jsWebKitAnimationElapsedTime(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsNumber(impl->elapsedTime());
    return result;
}


JSValue jsWebKitAnimationDelay(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsNumber(impl->delay());
    return result;
}


JSValue jsWebKitAnimationIterationCount(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(slotBase));
    return castedThis->iterationCount(exec);
}


JSValue jsWebKitAnimationPaused(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsBoolean(impl->paused());
    return result;
}


JSValue jsWebKitAnimationEnded(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsBoolean(impl->ended());
    return result;
}


JSValue jsWebKitAnimationDirection(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsNumber(impl->direction());
    return result;
}


JSValue jsWebKitAnimationFillMode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsNumber(impl->fillMode());
    return result;
}


JSValue jsWebKitAnimationConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimation* domObject = jsCast<JSWebKitAnimation*>(asObject(slotBase));
    return JSWebKitAnimation::getConstructor(exec, domObject->globalObject());
}

void JSWebKitAnimation::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSWebKitAnimation* thisObject = jsCast<JSWebKitAnimation*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSWebKitAnimation, Base>(exec, propertyName, value, &JSWebKitAnimationTable, thisObject, slot);
}

void setJSWebKitAnimationElapsedTime(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(thisObject);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    impl->setElapsedTime(value.toNumber(exec));
}


JSValue JSWebKitAnimation::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitAnimationConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebKitAnimationPrototypeFunctionPlay(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitAnimation::s_info))
        return throwVMTypeError(exec);
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitAnimation::s_info);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    impl->play();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitAnimationPrototypeFunctionPause(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitAnimation::s_info))
        return throwVMTypeError(exec);
    JSWebKitAnimation* castedThis = jsCast<JSWebKitAnimation*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitAnimation::s_info);
    WebKitAnimation* impl = static_cast<WebKitAnimation*>(castedThis->impl());
    impl->pause();
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsWebKitAnimationDIRECTION_NORMAL(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsWebKitAnimationDIRECTION_ALTERNATE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsWebKitAnimationFILL_NONE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsWebKitAnimationFILL_BACKWARDS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsWebKitAnimationFILL_FORWARDS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsWebKitAnimationFILL_BOTH(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

static inline bool isObservable(JSWebKitAnimation* jsWebKitAnimation)
{
    if (jsWebKitAnimation->hasCustomProperties())
        return true;
    return false;
}

bool JSWebKitAnimationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebKitAnimation* jsWebKitAnimation = jsCast<JSWebKitAnimation*>(handle.get().asCell());
    if (!isObservable(jsWebKitAnimation))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebKitAnimationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebKitAnimation* jsWebKitAnimation = jsCast<JSWebKitAnimation*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebKitAnimation->impl(), jsWebKitAnimation);
    jsWebKitAnimation->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebKitAnimation* impl)
{
    return wrap<JSWebKitAnimation>(exec, globalObject, impl);
}

WebKitAnimation* toWebKitAnimation(JSC::JSValue value)
{
    return value.inherits(&JSWebKitAnimation::s_info) ? jsCast<JSWebKitAnimation*>(asObject(value))->impl() : 0;
}

}
