/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.35 from the
 * contents of GVariant.xs. Do not edit this file, edit GVariant.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "GVariant.xs"
/*
 * Copyright (C) 2014 by the gtk2-perl team (see the file AUTHORS for the full
 * list)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "gperl.h"

/* --- GVariant --------------------------------------------------------------*/

/* --- basic wrappers --- */

static SV *
variant_to_sv (GVariant * variant, gboolean own)
{
	SV * sv;
	SV * rv;
	HV * stash;

	if (!variant)
		return &PL_sv_undef;

	sv = newSV (0);
	_gperl_attach_mg (sv, variant);

	if (own) {
#if GLIB_CHECK_VERSION (2, 30, 0)
		g_variant_take_ref (variant);
#elif GLIB_CHECK_VERSION (2, 26, 0)
		if (g_variant_is_floating (variant)) {
			g_variant_ref_sink (variant);
		}
#else
		/* In this case, we have no way of finding out whether the
		 * variant has a floating ref, so we just always ref_sink even
		 * if this might cause a leak in some cases. */
		g_variant_ref_sink (variant);
#endif
	} else {
		g_variant_ref (variant);
	}

	rv = newRV_noinc (sv);
	stash = gv_stashpv ("Glib::Variant", TRUE);
	sv_bless (rv, stash);

	return rv;
}

static GVariant *
sv_to_variant (SV * sv)
{
	MAGIC * mg;
	if (!gperl_sv_is_ref (sv) || !(mg = _gperl_find_mg (SvRV (sv))))
		return NULL;
	return (GVariant *) mg->mg_ptr;
}

/* --- GValue wrappers --- */

static SV *
wrap_variant (const GValue * value)
{
	return variant_to_sv (g_value_get_variant (value), FALSE);
}

static void
unwrap_variant (GValue * value, SV * sv)
{
	g_value_set_variant (value, sv_to_variant (sv));
}

static GPerlValueWrapperClass variant_wrapper_class = { wrap_variant, unwrap_variant };

/* --- typemap glue --- */

SV *
newSVGVariant (GVariant * variant)
{
	return variant_to_sv (variant, FALSE);
}

SV *
newSVGVariant_noinc (GVariant * variant)
{
	return variant_to_sv (variant, TRUE);
}

GVariant *
SvGVariant (SV * sv)
{
	return sv_to_variant (sv);
}

/* --- GVariantType --------------------------------------------------------- */

/* --- boxed wrappers ---*/

static GPerlBoxedWrapperClass default_boxed_wrapper_class;
static GPerlBoxedWrapperClass variant_type_wrapper_class;

static gpointer
unwrap_variant_type (GType gtype, const char * package, SV * sv)
{
	if (!gperl_sv_is_ref (sv)) {
		GVariantType * vtype;
		vtype = g_variant_type_new (SvPV_nolen (sv));
		sv = default_boxed_wrapper_class.wrap (gtype, package, vtype, TRUE);
		/* fall through */
	}
	return default_boxed_wrapper_class.unwrap (gtype, package, sv);
}

/* --- typemap glue --- */

SV *
newSVGVariantType (const GVariantType * type)
{
	if (!type)
		return &PL_sv_undef;
	return gperl_new_boxed ((gpointer) type, G_TYPE_VARIANT_TYPE, FALSE);
}

SV *
newSVGVariantType_own (const GVariantType * type)
{
	return gperl_new_boxed ((gpointer) type, G_TYPE_VARIANT_TYPE, TRUE);
}

const GVariantType *
SvGVariantType (SV * sv)
{
	if (!gperl_sv_is_defined (sv))
		return NULL;
	return gperl_get_boxed_check (sv, G_TYPE_VARIANT_TYPE);
}

/* --- GVariantDict ----------------------------------------------------------*/

#if GLIB_CHECK_VERSION (2, 40, 0)

/* --- typemap glue --- */

SV *
newSVGVariantDict (GVariantDict * dict)
{
	return gperl_new_boxed (dict, G_TYPE_VARIANT_DICT, FALSE);
}

SV *
newSVGVariantDict_own (GVariantDict * dict)
{
	return gperl_new_boxed (dict, G_TYPE_VARIANT_DICT, TRUE);
}

GVariantDict *
SvGVariantDict (SV * sv)
{
	if (!gperl_sv_is_defined (sv))
		return NULL;
	return gperl_get_boxed_check (sv, G_TYPE_VARIANT_DICT);
}

#endif

/* -------------------------------------------------------------------------- */

/* --- helpers ---*/

static void
sv_to_variant_array (SV * sv, GVariant *** array_p, gsize * n_p)
{
	AV * av;
	gsize i;
	if (!gperl_sv_is_array_ref (sv))
		croak ("Expected an array reference for 'children'");
	av = (AV *) SvRV (sv);
	*n_p = av_len (av) + 1;
	*array_p = g_new0 (GVariant *, *n_p);
	for (i = 0; i < *n_p; i++) {
		SV ** svp = av_fetch (av, i, 0);
		if (svp)
			(*array_p)[i] = SvGVariant (*svp);
	}
}

static void
sv_to_variant_type_array (SV * sv, const GVariantType *** array_p, gint * n_p)
{
	AV * av;
	gint i;
	if (!gperl_sv_is_array_ref (sv))
		croak ("Expected an array reference for 'items'");
	av = (AV *) SvRV (sv);
	*n_p = av_len (av) + 1;
	*array_p = g_new0 (const GVariantType *, *n_p);
	for (i = 0; i < *n_p; i++) {
		SV ** svp = av_fetch (av, i, 0);
		if (svp)
			(*array_p)[i] = SvGVariantType (*svp);
	}
}

/* -------------------------------------------------------------------------- */

#line 230 "GVariant.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 374 "GVariant.c"

XS_EUPXS(XS_Glib__Variant_get_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	const GVariantType *	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_type(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_type_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_type_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	const gchar *	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_type_string(value);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    /* same as newSVGChar(), but not in a function */
	    sv_setpv ((SV*)RETVALSV, RETVAL);
	    SvUTF8_on (RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_is_of_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_is_of_type)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "value, type");
    {
	gboolean	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;
	const GVariantType *	type = SvGVariantType (ST(1))
;

	RETVAL = g_variant_is_of_type(value, type);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_is_container); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_is_container)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	gboolean	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_is_container(value);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_classify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_classify)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	char	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_classify(value);
	XSprePUSH; PUSHp((char *)&RETVAL, 1);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_boolean); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_boolean)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	gboolean	value = (bool)SvTRUE(ST(1))
;

	RETVAL = g_variant_new_boolean(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_byte); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_byte)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	guchar	value = (guchar)SvUV(ST(1))
;

	RETVAL = g_variant_new_byte(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_int16); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_int16)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	gint16	value = (gint16)SvIV(ST(1))
;

	RETVAL = g_variant_new_int16(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_uint16); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_uint16)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	guint16	value = (guint16)SvUV(ST(1))
;

	RETVAL = g_variant_new_uint16(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_int32); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_int32)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	gint32	value = (gint32)SvIV(ST(1))
;

	RETVAL = g_variant_new_int32(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_uint32); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_uint32)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	guint32	value = (guint32)SvUV(ST(1))
;

	RETVAL = g_variant_new_uint32(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_int64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_int64)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	gint64	value = SvGInt64 (ST(1))
;

	RETVAL = g_variant_new_int64(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_uint64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_uint64)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	guint64	value = SvGUInt64 (ST(1))
;

	RETVAL = g_variant_new_uint64(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_handle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_handle)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	gint32	value = (gint32)SvIV(ST(1))
;

	RETVAL = g_variant_new_handle(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_double)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	gdouble	value = (double)SvNV(ST(1))
;

	RETVAL = g_variant_new_double(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_string)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, string");
    {
	GVariant_noinc *	RETVAL;
	const gchar *	string;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	string = (const gchar *)SvPV_nolen (ST(1))
;

	RETVAL = g_variant_new_string(string);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_object_path); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_object_path)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, object_path");
    {
	GVariant_noinc *	RETVAL;
	const gchar *	object_path;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	object_path = (const gchar *)SvPV_nolen (ST(1))
;

	RETVAL = g_variant_new_object_path(object_path);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_is_object_path); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_is_object_path)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "string");
    {
	gboolean	RETVAL;
	const gchar *	string;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(0));
	string = (const gchar *)SvPV_nolen (ST(0))
;

	RETVAL = g_variant_is_object_path(string);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_signature); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_signature)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, signature");
    {
	GVariant_noinc *	RETVAL;
	const gchar *	signature;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	signature = (const gchar *)SvPV_nolen (ST(1))
;

	RETVAL = g_variant_new_signature(signature);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_is_signature); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_is_signature)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "string");
    {
	gboolean	RETVAL;
	const gchar *	string;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(0));
	string = (const gchar *)SvPV_nolen (ST(0))
;

	RETVAL = g_variant_is_signature(string);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_variant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_variant)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, value");
    {
	GVariant_noinc *	RETVAL;
	GVariant *	value = SvGVariant (ST(1))
;

	RETVAL = g_variant_new_variant(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if GLIB_CHECK_VERSION (2, 26, 0)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Glib__Variant_new_bytestring); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_bytestring)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, string");
    {
	GVariant_noinc *	RETVAL;
	const char_byte *	string = (const char_byte *)SvPVbyte_nolen (ST(1))
;

	RETVAL = g_variant_new_bytestring(string);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Glib__Variant_get_boolean); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_boolean)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	gboolean	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_boolean(value);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_byte); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_byte)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	guchar	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_byte(value);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_int16); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_int16)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	gint16	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_int16(value);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_uint16); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_uint16)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	guint16	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_uint16(value);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_int32); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_int32)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	gint32	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_int32(value);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_uint32); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_uint32)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	guint32	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_uint32(value);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_int64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_int64)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	gint64	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_int64(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGInt64 (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_uint64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_uint64)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	guint64	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_uint64(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGUInt64 (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_handle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_handle)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	gint32	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_handle(value);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_double); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_double)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	gdouble	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_double(value);
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_variant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_variant)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	GVariant_noinc *	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_variant(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	const gchar *	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_string(value, NULL);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    /* same as newSVGChar(), but not in a function */
	    sv_setpv ((SV*)RETVALSV, RETVAL);
	    SvUTF8_on (RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if GLIB_CHECK_VERSION (2, 26, 0)
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Glib__Variant_get_bytestring); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_bytestring)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	const char *	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_bytestring(value);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Glib__Variant_new_maybe); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_maybe)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "class, child_type, child");
    {
	GVariant_noinc *	RETVAL;
	const GVariantType *	child_type = SvGVariantType (ST(1))
;
	GVariant *	child = SvGVariant (ST(2))
;

	RETVAL = g_variant_new_maybe(child_type, child);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_array); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_array)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "class, child_type, children");
    {
#line 468 "GVariant.xs"
	GVariant ** children_c;
	gsize n_children;
#line 1189 "GVariant.c"
	GVariant *	RETVAL;
	const GVariantType *	child_type = SvGVariantType (ST(1))
;
	SV *	children = ST(2)
;
#line 471 "GVariant.xs"
	sv_to_variant_array (children, &children_c, &n_children);
	RETVAL = g_variant_new_array (child_type, children_c, n_children);
	g_free (children_c);
#line 1199 "GVariant.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_tuple); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_tuple)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, children");
    {
#line 479 "GVariant.xs"
	GVariant ** children_c;
	gsize n_children;
#line 1221 "GVariant.c"
	GVariant *	RETVAL;
	SV *	children = ST(1)
;
#line 482 "GVariant.xs"
	sv_to_variant_array (children, &children_c, &n_children);
	RETVAL = g_variant_new_tuple (children_c, n_children);
	g_free (children_c);
#line 1229 "GVariant.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_new_dict_entry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_new_dict_entry)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "class, key, value");
    {
	GVariant_noinc *	RETVAL;
	GVariant *	key = SvGVariant (ST(1))
;
	GVariant *	value = SvGVariant (ST(2))
;

	RETVAL = g_variant_new_dict_entry(key, value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_maybe); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_maybe)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	GVariant_noinc *	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_maybe(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_n_children); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_n_children)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	gsize	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_n_children(value);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_get_child_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_child_value)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "value, index_");
    {
	GVariant_noinc *	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;
	gsize	index_ = (gsize)SvUV(ST(1))
;

	RETVAL = g_variant_get_child_value(value, index_);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if GLIB_CHECK_VERSION (2, 28, 0)
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Glib__Variant_lookup_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_lookup_value)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "dictionary, key, expected_type");
    {
	GVariant_noinc *	RETVAL;
	GVariant *	dictionary = SvGVariant (ST(0))
;
	const gchar *	key;
	const GVariantType *	expected_type = SvGVariantType (ST(2))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	RETVAL = g_variant_lookup_value(dictionary, key, expected_type);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Glib__Variant_get_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	gsize	RETVAL;
	dXSTARG;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_size(value);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_print); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_print)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "value, type_annotate");
    {
	gchar_own *	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;
	gboolean	type_annotate = (bool)SvTRUE(ST(1))
;

	RETVAL = g_variant_print(value, type_annotate);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    /* used when we can directly own the returned string. */
	    /* we have to copy in the case when perl's malloc != gtk's malloc,
	     * so best copy all the time. */
	    sv_setpv ((SV*)RETVALSV, RETVAL);
	    SvUTF8_on (RETVALSV);
	    g_free (RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	guint	RETVAL;
	dXSTARG;
	const GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_hash(value);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_equal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_equal)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "one, two");
    {
	gboolean	RETVAL;
	const GVariant *	one = SvGVariant (ST(0))
;
	const GVariant *	two = SvGVariant (ST(1))
;

	RETVAL = g_variant_equal(one, two);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#if GLIB_CHECK_VERSION (2, 26, 0)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Glib__Variant_compare); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_compare)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "one, two");
    {
	gint	RETVAL;
	dXSTARG;
	const GVariant *	one = SvGVariant (ST(0))
;
	const GVariant *	two = SvGVariant (ST(1))
;

	RETVAL = g_variant_compare(one, two);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Glib__Variant_get_normal_form); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_get_normal_form)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	GVariant_noinc *	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_get_normal_form(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_is_normal_form); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_is_normal_form)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	gboolean	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_is_normal_form(value);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_byteswap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_byteswap)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "value");
    {
	GVariant_noinc *	RETVAL;
	GVariant *	value = SvGVariant (ST(0))
;

	RETVAL = g_variant_byteswap(value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Variant_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "variant");
    {
	GVariant *	variant = SvGVariant (ST(0))
;
#line 547 "GVariant.xs"
	g_variant_unref (variant);
#line 1556 "GVariant.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__Variant_parse); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Variant_parse)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "type, text");
    {
#line 591 "GVariant.xs"
	GError *error = NULL;
#line 1571 "GVariant.c"
	GVariant_noinc *	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;
	const gchar *	text;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	text = (const gchar *)SvPV_nolen (ST(1))
;
#line 593 "GVariant.xs"
	RETVAL = g_variant_parse (type, text, NULL, NULL, &error);
	if (error)
		gperl_croak_gerror (NULL, error);
#line 1585 "GVariant.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_string_is_valid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_string_is_valid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type_string");
    {
	gboolean	RETVAL;
	const gchar *	type_string;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(0));
	type_string = (const gchar *)SvPV_nolen (ST(0))
;

	RETVAL = g_variant_type_string_is_valid(type_string);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_string_scan); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_string_scan)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "string");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 627 "GVariant.xs"
	const char *limit = NULL;
	const char *endptr = NULL;
#line 1631 "GVariant.c"
	const char *	string = (const char *)SvPV_nolen(ST(0))
;
#line 630 "GVariant.xs"
	if (!g_variant_type_string_scan (string, limit, &endptr))
		croak ("Could not find type string at the start of '%s'",
		       string);
	PUSHs (sv_2mortal (newSVpvn (string, endptr-string)));
        if (endptr && *endptr)
        	XPUSHs (sv_2mortal (newSVpv (endptr, 0)));
#line 1641 "GVariant.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Glib__VariantType_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, type_string");
    {
	GVariantType_own *	RETVAL;
	const gchar *	type_string;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	type_string = (const gchar *)SvPV_nolen (ST(1))
;

	RETVAL = g_variant_type_new(type_string);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType_own (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_get_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_get_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
#line 645 "GVariant.xs"
	const char * string;
#line 1684 "GVariant.c"
	SV *	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;
#line 647 "GVariant.xs"
	string = g_variant_type_peek_string (type);
	RETVAL = newSVpv (string, g_variant_type_get_string_length (type));
#line 1691 "GVariant.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_is_definite); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_is_definite)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	gboolean	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_is_definite(type);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_is_container); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_is_container)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	gboolean	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_is_container(type);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_is_basic); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_is_basic)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	gboolean	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_is_basic(type);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_is_maybe); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_is_maybe)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	gboolean	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_is_maybe(type);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_is_array); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_is_array)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	gboolean	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_is_array(type);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_is_tuple); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_is_tuple)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	gboolean	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_is_tuple(type);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_is_dict_entry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_is_dict_entry)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	gboolean	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_is_dict_entry(type);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_is_variant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_is_variant)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	gboolean	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_is_variant(type);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_hash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_hash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	guint	RETVAL;
	dXSTARG;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_hash(type);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_equal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_equal)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "type1, type2");
    {
	gboolean	RETVAL;
	const GVariantType *	type1 = SvGVariantType (ST(0))
;
	const GVariantType *	type2 = SvGVariantType (ST(1))
;

	RETVAL = g_variant_type_equal(type1, type2);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_is_subtype_of); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_is_subtype_of)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "type, supertype");
    {
	gboolean	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;
	const GVariantType *	supertype = SvGVariantType (ST(1))
;

	RETVAL = g_variant_type_is_subtype_of(type, supertype);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_element); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_element)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	const GVariantType *	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_element(type);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_first); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_first)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	const GVariantType *	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_first(type);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_next); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_next)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	const GVariantType *	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_next(type);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_n_items); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_n_items)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	gsize	RETVAL;
	dXSTARG;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_n_items(type);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	const GVariantType *	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_key(type);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_value)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "type");
    {
	const GVariantType *	RETVAL;
	const GVariantType *	type = SvGVariantType (ST(0))
;

	RETVAL = g_variant_type_value(type);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_new_array); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_new_array)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, element");
    {
	GVariantType_own *	RETVAL;
	const GVariantType *	element = SvGVariantType (ST(1))
;

	RETVAL = g_variant_type_new_array(element);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType_own (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_new_maybe); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_new_maybe)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, element");
    {
	GVariantType_own *	RETVAL;
	const GVariantType *	element = SvGVariantType (ST(1))
;

	RETVAL = g_variant_type_new_maybe(element);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType_own (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_new_tuple); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_new_tuple)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, items");
    {
#line 696 "GVariant.xs"
	const GVariantType ** items_c;
	gint n_items;
#line 2092 "GVariant.c"
	GVariantType_own *	RETVAL;
	SV *	items = ST(1)
;
#line 699 "GVariant.xs"
	sv_to_variant_type_array (items, &items_c, &n_items);
	RETVAL = g_variant_type_new_tuple (items_c, n_items);
	g_free (items_c);
#line 2100 "GVariant.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType_own (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantType_new_dict_entry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantType_new_dict_entry)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "class, key, value");
    {
	GVariantType_own *	RETVAL;
	const GVariantType *	key = SvGVariantType (ST(1))
;
	const GVariantType *	value = SvGVariantType (ST(2))
;

	RETVAL = g_variant_type_new_dict_entry(key, value);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantType_own (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if GLIB_CHECK_VERSION (2, 40, 0)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Glib__VariantDict_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantDict_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, from_asv");
    {
	GVariantDict_own *	RETVAL;
	GVariant *	from_asv = SvGVariant (ST(1))
;

	RETVAL = g_variant_dict_new(from_asv);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariantDict_own (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantDict_lookup_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantDict_lookup_value)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "dict, key, expected_type");
    {
	GVariant_noinc *	RETVAL;
	GVariantDict *	dict = SvGVariantDict (ST(0))
;
	const gchar *	key;
	const GVariantType *	expected_type = SvGVariantType (ST(2))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	RETVAL = g_variant_dict_lookup_value(dict, key, expected_type);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantDict_contains); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantDict_contains)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dict, key");
    {
	gboolean	RETVAL;
	GVariantDict *	dict = SvGVariantDict (ST(0))
;
	const gchar *	key;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	RETVAL = g_variant_dict_contains(dict, key);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantDict_insert_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantDict_insert_value)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "dict, key, value");
    {
	GVariantDict *	dict = SvGVariantDict (ST(0))
;
	const gchar *	key;
	GVariant *	value = SvGVariant (ST(2))
;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	g_variant_dict_insert_value(dict, key, value);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__VariantDict_remove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantDict_remove)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dict, key");
    {
	gboolean	RETVAL;
	GVariantDict *	dict = SvGVariantDict (ST(0))
;
	const gchar *	key;

	/* same as SvGChar(), but not in a function */
	sv_utf8_upgrade (ST(1));
	key = (const gchar *)SvPV_nolen (ST(1))
;

	RETVAL = g_variant_dict_remove(dict, key);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__VariantDict_end); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__VariantDict_end)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dict");
    {
	GVariant_noinc *	RETVAL;
	GVariantDict *	dict = SvGVariantDict (ST(0))
;

	RETVAL = g_variant_dict_end(dict);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGVariant_noinc (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Glib__Variant); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Glib__Variant)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Glib::Variant::get_type", XS_Glib__Variant_get_type);
        newXS_deffile("Glib::Variant::get_type_string", XS_Glib__Variant_get_type_string);
        newXS_deffile("Glib::Variant::is_of_type", XS_Glib__Variant_is_of_type);
        newXS_deffile("Glib::Variant::is_container", XS_Glib__Variant_is_container);
        newXS_deffile("Glib::Variant::classify", XS_Glib__Variant_classify);
        newXS_deffile("Glib::Variant::new_boolean", XS_Glib__Variant_new_boolean);
        newXS_deffile("Glib::Variant::new_byte", XS_Glib__Variant_new_byte);
        newXS_deffile("Glib::Variant::new_int16", XS_Glib__Variant_new_int16);
        newXS_deffile("Glib::Variant::new_uint16", XS_Glib__Variant_new_uint16);
        newXS_deffile("Glib::Variant::new_int32", XS_Glib__Variant_new_int32);
        newXS_deffile("Glib::Variant::new_uint32", XS_Glib__Variant_new_uint32);
        newXS_deffile("Glib::Variant::new_int64", XS_Glib__Variant_new_int64);
        newXS_deffile("Glib::Variant::new_uint64", XS_Glib__Variant_new_uint64);
        newXS_deffile("Glib::Variant::new_handle", XS_Glib__Variant_new_handle);
        newXS_deffile("Glib::Variant::new_double", XS_Glib__Variant_new_double);
        newXS_deffile("Glib::Variant::new_string", XS_Glib__Variant_new_string);
        newXS_deffile("Glib::Variant::new_object_path", XS_Glib__Variant_new_object_path);
        newXS_deffile("Glib::Variant::is_object_path", XS_Glib__Variant_is_object_path);
        newXS_deffile("Glib::Variant::new_signature", XS_Glib__Variant_new_signature);
        newXS_deffile("Glib::Variant::is_signature", XS_Glib__Variant_is_signature);
        newXS_deffile("Glib::Variant::new_variant", XS_Glib__Variant_new_variant);
#if XSubPPtmpAAAA
        newXS_deffile("Glib::Variant::new_bytestring", XS_Glib__Variant_new_bytestring);
#endif
        newXS_deffile("Glib::Variant::get_boolean", XS_Glib__Variant_get_boolean);
        newXS_deffile("Glib::Variant::get_byte", XS_Glib__Variant_get_byte);
        newXS_deffile("Glib::Variant::get_int16", XS_Glib__Variant_get_int16);
        newXS_deffile("Glib::Variant::get_uint16", XS_Glib__Variant_get_uint16);
        newXS_deffile("Glib::Variant::get_int32", XS_Glib__Variant_get_int32);
        newXS_deffile("Glib::Variant::get_uint32", XS_Glib__Variant_get_uint32);
        newXS_deffile("Glib::Variant::get_int64", XS_Glib__Variant_get_int64);
        newXS_deffile("Glib::Variant::get_uint64", XS_Glib__Variant_get_uint64);
        newXS_deffile("Glib::Variant::get_handle", XS_Glib__Variant_get_handle);
        newXS_deffile("Glib::Variant::get_double", XS_Glib__Variant_get_double);
        newXS_deffile("Glib::Variant::get_variant", XS_Glib__Variant_get_variant);
        newXS_deffile("Glib::Variant::get_string", XS_Glib__Variant_get_string);
#if XSubPPtmpAAAB
        newXS_deffile("Glib::Variant::get_bytestring", XS_Glib__Variant_get_bytestring);
#endif
        newXS_deffile("Glib::Variant::new_maybe", XS_Glib__Variant_new_maybe);
        newXS_deffile("Glib::Variant::new_array", XS_Glib__Variant_new_array);
        newXS_deffile("Glib::Variant::new_tuple", XS_Glib__Variant_new_tuple);
        newXS_deffile("Glib::Variant::new_dict_entry", XS_Glib__Variant_new_dict_entry);
        newXS_deffile("Glib::Variant::get_maybe", XS_Glib__Variant_get_maybe);
        newXS_deffile("Glib::Variant::n_children", XS_Glib__Variant_n_children);
        newXS_deffile("Glib::Variant::get_child_value", XS_Glib__Variant_get_child_value);
#if XSubPPtmpAAAC
        newXS_deffile("Glib::Variant::lookup_value", XS_Glib__Variant_lookup_value);
#endif
        newXS_deffile("Glib::Variant::get_size", XS_Glib__Variant_get_size);
        newXS_deffile("Glib::Variant::print", XS_Glib__Variant_print);
        newXS_deffile("Glib::Variant::hash", XS_Glib__Variant_hash);
        newXS_deffile("Glib::Variant::equal", XS_Glib__Variant_equal);
#if XSubPPtmpAAAD
        newXS_deffile("Glib::Variant::compare", XS_Glib__Variant_compare);
#endif
        newXS_deffile("Glib::Variant::get_normal_form", XS_Glib__Variant_get_normal_form);
        newXS_deffile("Glib::Variant::is_normal_form", XS_Glib__Variant_is_normal_form);
        newXS_deffile("Glib::Variant::byteswap", XS_Glib__Variant_byteswap);
        newXS_deffile("Glib::Variant::DESTROY", XS_Glib__Variant_DESTROY);
        newXS_deffile("Glib::Variant::parse", XS_Glib__Variant_parse);
        newXS_deffile("Glib::VariantType::string_is_valid", XS_Glib__VariantType_string_is_valid);
        newXS_deffile("Glib::VariantType::string_scan", XS_Glib__VariantType_string_scan);
        newXS_deffile("Glib::VariantType::new", XS_Glib__VariantType_new);
        newXS_deffile("Glib::VariantType::get_string", XS_Glib__VariantType_get_string);
        newXS_deffile("Glib::VariantType::is_definite", XS_Glib__VariantType_is_definite);
        newXS_deffile("Glib::VariantType::is_container", XS_Glib__VariantType_is_container);
        newXS_deffile("Glib::VariantType::is_basic", XS_Glib__VariantType_is_basic);
        newXS_deffile("Glib::VariantType::is_maybe", XS_Glib__VariantType_is_maybe);
        newXS_deffile("Glib::VariantType::is_array", XS_Glib__VariantType_is_array);
        newXS_deffile("Glib::VariantType::is_tuple", XS_Glib__VariantType_is_tuple);
        newXS_deffile("Glib::VariantType::is_dict_entry", XS_Glib__VariantType_is_dict_entry);
        newXS_deffile("Glib::VariantType::is_variant", XS_Glib__VariantType_is_variant);
        newXS_deffile("Glib::VariantType::hash", XS_Glib__VariantType_hash);
        newXS_deffile("Glib::VariantType::equal", XS_Glib__VariantType_equal);
        newXS_deffile("Glib::VariantType::is_subtype_of", XS_Glib__VariantType_is_subtype_of);
        newXS_deffile("Glib::VariantType::element", XS_Glib__VariantType_element);
        newXS_deffile("Glib::VariantType::first", XS_Glib__VariantType_first);
        newXS_deffile("Glib::VariantType::next", XS_Glib__VariantType_next);
        newXS_deffile("Glib::VariantType::n_items", XS_Glib__VariantType_n_items);
        newXS_deffile("Glib::VariantType::key", XS_Glib__VariantType_key);
        newXS_deffile("Glib::VariantType::value", XS_Glib__VariantType_value);
        newXS_deffile("Glib::VariantType::new_array", XS_Glib__VariantType_new_array);
        newXS_deffile("Glib::VariantType::new_maybe", XS_Glib__VariantType_new_maybe);
        newXS_deffile("Glib::VariantType::new_tuple", XS_Glib__VariantType_new_tuple);
        newXS_deffile("Glib::VariantType::new_dict_entry", XS_Glib__VariantType_new_dict_entry);
#if XSubPPtmpAAAE
        newXS_deffile("Glib::VariantDict::new", XS_Glib__VariantDict_new);
        newXS_deffile("Glib::VariantDict::lookup_value", XS_Glib__VariantDict_lookup_value);
        newXS_deffile("Glib::VariantDict::contains", XS_Glib__VariantDict_contains);
        newXS_deffile("Glib::VariantDict::insert_value", XS_Glib__VariantDict_insert_value);
        newXS_deffile("Glib::VariantDict::remove", XS_Glib__VariantDict_remove);
        newXS_deffile("Glib::VariantDict::end", XS_Glib__VariantDict_end);
#endif

    /* Initialisation Section */

#line 300 "GVariant.xs"
	gperl_register_fundamental_full (G_TYPE_VARIANT, "Glib::Variant",
	                                 &variant_wrapper_class);
	default_boxed_wrapper_class = variant_type_wrapper_class =
		* gperl_default_boxed_wrapper_class ();
	variant_type_wrapper_class.unwrap = unwrap_variant_type;
	gperl_register_boxed (G_TYPE_VARIANT_TYPE, "Glib::VariantType",
	                      &variant_type_wrapper_class);
#if GLIB_CHECK_VERSION (2, 40, 0)
	gperl_register_boxed (G_TYPE_VARIANT_DICT, "Glib::VariantDict", NULL);
#endif

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#line 2436 "GVariant.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

