// This file is generated by kconfig_compiler_kf5 from palapeli.kcfg.
// All changes you do to this file will be lost.
#ifndef SETTINGS_H
#define SETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class Settings : public KConfigSkeleton
{
  public:

    static Settings *self();
    ~Settings();

    /**
      Set Precision of snapping (as a percentage of piece size).
    */
    static
    void setSnappingPrecision( int v )
    {
      if (!self()->isImmutable( QStringLiteral( "SnappingPrecision" ) ))
        self()->mSnappingPrecision = v;
    }

    /**
      Get Precision of snapping (as a percentage of piece size).
    */
    static
    int snappingPrecision()
    {
      return self()->mSnappingPrecision;
    }

    /**
      Set The filename of the background image to use for the View, or "__color__" if a solid color should be used (see key "ViewBackgroundColor").
    */
    static
    void setViewBackground( const QString & v )
    {
      if (!self()->isImmutable( QStringLiteral( "ViewBackground" ) ))
        self()->mViewBackground = v;
    }

    /**
      Get The filename of the background image to use for the View, or "__color__" if a solid color should be used (see key "ViewBackgroundColor").
    */
    static
    QString viewBackground()
    {
      return self()->mViewBackground;
    }

    /**
      Set The background color to use for the View (if the key "ViewBackground" is set to "__color__").
    */
    static
    void setViewBackgroundColor( const QColor & v )
    {
      if (!self()->isImmutable( QStringLiteral( "ViewBackgroundColor" ) ))
        self()->mViewBackgroundColor = v;
    }

    /**
      Get The background color to use for the View (if the key "ViewBackground" is set to "__color__").
    */
    static
    QColor viewBackgroundColor()
    {
      return self()->mViewBackgroundColor;
    }

    /**
      Set The highlighting color to use for selecting pieces in the View.
    */
    static
    void setViewHighlightColor( const QColor & v )
    {
      if (!self()->isImmutable( QStringLiteral( "ViewHighlightColor" ) ))
        self()->mViewHighlightColor = v;
    }

    /**
      Get The highlighting color to use for selecting pieces in the View.
    */
    static
    QColor viewHighlightColor()
    {
      return self()->mViewHighlightColor;
    }

    /**
      Set Where to reserve space on the puzzle table for the solution, when shuffling or re-shuffling the pieces.
    */
    static
    void setSolutionArea( int v )
    {
      if (!self()->isImmutable( QStringLiteral( "SolutionArea" ) ))
        self()->mSolutionArea = v;
    }

    /**
      Get Where to reserve space on the puzzle table for the solution, when shuffling or re-shuffling the pieces.
    */
    static
    int solutionArea()
    {
      return self()->mSolutionArea;
    }

    /**
      Set Spacing of pieces in puzzle grids relative to the size of the largest piece (spacing factor is 1.0 + 0.05 * value).
    */
    static
    void setPieceSpacing( int v )
    {
      if (!self()->isImmutable( QStringLiteral( "PieceSpacing" ) ))
        self()->mPieceSpacing = v;
    }

    /**
      Get Spacing of pieces in puzzle grids relative to the size of the largest piece (spacing factor is 1.0 + 0.05 * value).
    */
    static
    int pieceSpacing()
    {
      return self()->mPieceSpacing;
    }

    /**
      Set Whether to show the status bar on the puzzle table. (It is not a real status bar, but the position and provided functionality is similar.)
    */
    static
    void setShowStatusBar( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "ShowStatusBar" ) ))
        self()->mShowStatusBar = v;
    }

    /**
      Get Whether to show the status bar on the puzzle table. (It is not a real status bar, but the position and provided functionality is similar.)
    */
    static
    bool showStatusBar()
    {
      return self()->mShowStatusBar;
    }

    /**
      Set Whether to render shadows below the puzzle pieces. Turning this off might improve rendering performance.
    */
    static
    void setPieceShadowsEnabled( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "PieceShadowsEnabled" ) ))
        self()->mPieceShadowsEnabled = v;
    }

    /**
      Get Whether to render shadows below the puzzle pieces. Turning this off might improve rendering performance.
    */
    static
    bool pieceShadowsEnabled()
    {
      return self()->mPieceShadowsEnabled;
    }

    /**
      Set Whether to render bevels on the puzzle pieces. Turning this off might improve puzzle loading performance.
    */
    static
    void setPieceBevelsEnabled( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "PieceBevelsEnabled" ) ))
        self()->mPieceBevelsEnabled = v;
    }

    /**
      Get Whether to render bevels on the puzzle pieces. Turning this off might improve puzzle loading performance.
    */
    static
    bool pieceBevelsEnabled()
    {
      return self()->mPieceBevelsEnabled;
    }

    /**
      Set Whether the preview window was switched on last time Palapeli was run.
    */
    static
    void setPuzzlePreviewVisible( bool v )
    {
      if (!self()->isImmutable( QStringLiteral( "PuzzlePreviewVisible" ) ))
        self()->mPuzzlePreviewVisible = v;
    }

    /**
      Get Whether the preview window was switched on last time Palapeli was run.
    */
    static
    bool puzzlePreviewVisible()
    {
      return self()->mPuzzlePreviewVisible;
    }

    /**
      Set Last position and size of puzzle preview.
    */
    static
    void setPuzzlePreviewGeometry( const QRect & v )
    {
      if (!self()->isImmutable( QStringLiteral( "PuzzlePreviewGeometry" ) ))
        self()->mPuzzlePreviewGeometry = v;
    }

    /**
      Get Last position and size of puzzle preview.
    */
    static
    QRect puzzlePreviewGeometry()
    {
      return self()->mPuzzlePreviewGeometry;
    }

  protected:
    Settings();
    friend class SettingsHelper;


    // Puzzling
    int mSnappingPrecision;

    // Appearance
    QString mViewBackground;
    QColor mViewBackgroundColor;
    QColor mViewHighlightColor;
    int mSolutionArea;
    int mPieceSpacing;
    bool mShowStatusBar;
    bool mPieceShadowsEnabled;
    bool mPieceBevelsEnabled;

    // PuzzlePreview
    bool mPuzzlePreviewVisible;
    QRect mPuzzlePreviewGeometry;

  private:
};

#endif

