/* fep.c generated by valac 0.20.0.2-fd7ed, the Vala compiler
 * generated from fep.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <libskk/libskk.h>
#include <gee.h>
#include <libfep-glib/libfep-glib.h>
#include <gio/gio.h>


#define TYPE_PREEDIT_STYLE (preedit_style_get_type ())
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_OPTIONS (options_get_type ())
typedef struct _Options Options;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_CLIENT (client_get_type ())
#define CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLIENT, Client))
#define CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLIENT, ClientClass))
#define IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLIENT))
#define IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLIENT))
#define CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLIENT, ClientClass))

typedef struct _Client Client;
typedef struct _ClientClass ClientClass;
typedef struct _ClientPrivate ClientPrivate;

#define CLIENT_TYPE_ENTRY (client_entry_get_type ())
typedef struct _ClientEntry ClientEntry;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

typedef enum  {
	PREEDIT_STYLE_OVER_THE_SPOT,
	PREEDIT_STYLE_ROOT,
	PREEDIT_STYLE_DEFAULT = PREEDIT_STYLE_OVER_THE_SPOT
} PreeditStyle;

struct _Options {
	PreeditStyle preedit_style;
};

struct _Block1Data {
	int _ref_count_;
	GPid pid;
};

struct _Client {
	FepGClient parent_instance;
	ClientPrivate * priv;
};

struct _ClientClass {
	FepGClientClass parent_class;
};

struct _ClientPrivate {
	SkkContext* context;
	Options opts;
	gchar** LOOKUP_TABLE_LABELS;
	gint LOOKUP_TABLE_LABELS_length1;
	gint _LOOKUP_TABLE_LABELS_size_;
	gboolean lookup_table_visible;
	gchar* preedit;
	gchar* status;
	FepGAttribute* status_attr;
	SkkInputMode input_mode;
};

struct _ClientEntry {
	gpointer key;
	gpointer value;
};


extern gchar* opt_file_dict;
gchar* opt_file_dict = NULL;
extern gchar* opt_user_dict;
gchar* opt_user_dict = NULL;
extern gchar* opt_skkserv;
gchar* opt_skkserv = NULL;
extern gchar* opt_typing_rule;
gchar* opt_typing_rule = NULL;
extern gboolean opt_list_typing_rules;
gboolean opt_list_typing_rules = FALSE;
extern gchar* opt_preedit_style;
gchar* opt_preedit_style = NULL;
static gpointer client_parent_class = NULL;

GType preedit_style_get_type (void) G_GNUC_CONST;
gint _vala_main (gchar** args, int args_length1);
static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata* array, gint array_length);
GType options_get_type (void) G_GNUC_CONST;
Options* options_dup (const Options* self);
void options_free (Options* self);
static GEnumValue* _g_enum_value_dup (GEnumValue* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda2_ (Block1Data* _data1_, GPid p, gint s);
static void _____lambda2__gchild_watch_func (GPid pid, gint status, gpointer self);
GType client_get_type (void) G_GNUC_CONST;
Client* client_new (SkkContext* context, Options* opts, GError** error);
Client* client_construct (GType object_type, SkkContext* context, Options* opts, GError** error);
gboolean client_run (Client* self);
#define CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CLIENT, ClientPrivate))
enum  {
	CLIENT_DUMMY_PROPERTY
};
static GType client_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ClientEntry* client_entry_dup (const ClientEntry* self);
static void client_entry_free (ClientEntry* self);
static void client_entry_copy (const ClientEntry* self, ClientEntry* dest);
static void client_entry_destroy (ClientEntry* self);
static gboolean client_process_lookup_table_key_event (Client* self, guint keyval, guint state);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void client_set_lookup_table_cursor_pos (Client* self);
static void client_update_preedit (Client* self);
static gboolean client_real_filter_key_event (FepGClient* base, guint keyval, guint modifiers);
static void client_update_status (Client* self);
static FepGAttribute* _fep_gattribute_dup (FepGAttribute* self);
static gboolean _fep_gattribute_equal (const FepGAttribute* s1, const FepGAttribute* s2);
static void client_populate_lookup_table (Client* self);
static gboolean client_watch_func (Client* self, GIOChannel* source, GIOCondition condition);
static void __lambda3_ (Client* self);
static void ___lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda4_ (Client* self);
static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda5_ (Client* self);
static void ___lambda5__skk_candidate_list_populated (SkkCandidateList* _sender, gpointer self);
static void __lambda6_ (Client* self);
static void ___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda7_ (Client* self);
static void ___lambda7__skk_candidate_list_selected (SkkCandidateList* _sender, SkkCandidate* candidate, gpointer self);
static gboolean _client_watch_func_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void client_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GOptionEntry options[7] = {{"file-dict", 'f', 0, G_OPTION_ARG_STRING, &opt_file_dict, "Path to a file dictionary", NULL}, {"user-dict", 'u', 0, G_OPTION_ARG_STRING, &opt_user_dict, "Path to a user dictionary", NULL}, {"skkserv", 's', 0, G_OPTION_ARG_STRING, &opt_skkserv, "Host and port running skkserv (HOST:PORT)", NULL}, {"rule", 'r', 0, G_OPTION_ARG_STRING, &opt_typing_rule, "Typing rule (default: \"default\")", NULL}, {"list-rules", 'l', 0, G_OPTION_ARG_NONE, &opt_list_typing_rules, "List typing rules", NULL}, {"preedit-style", 'p', 0, G_OPTION_ARG_STRING, &opt_preedit_style, "Preedit style", NULL}, {NULL}};
static const ClientEntry CLIENT_input_mode_labels[5] = {{SKK_INPUT_MODE_HIRAGANA, "あ"}, {SKK_INPUT_MODE_KATAKANA, "ア"}, {SKK_INPUT_MODE_HANKAKU_KATAKANA, "_ｱ"}, {SKK_INPUT_MODE_LATIN, "_A"}, {SKK_INPUT_MODE_WIDE_LATIN, "Ａ"}};

GType preedit_style_get_type (void) {
	static volatile gsize preedit_style_type_id__volatile = 0;
	if (g_once_init_enter (&preedit_style_type_id__volatile)) {
		static const GEnumValue values[] = {{PREEDIT_STYLE_OVER_THE_SPOT, "PREEDIT_STYLE_OVER_THE_SPOT", "over-the-spot"}, {PREEDIT_STYLE_ROOT, "PREEDIT_STYLE_ROOT", "root"}, {PREEDIT_STYLE_DEFAULT, "PREEDIT_STYLE_DEFAULT", "default"}, {0, NULL, NULL}};
		GType preedit_style_type_id;
		preedit_style_type_id = g_enum_register_static ("PreeditStyle", values);
		g_once_init_leave (&preedit_style_type_id__volatile, preedit_style_type_id);
	}
	return preedit_style_type_id__volatile;
}


static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			skk_rule_metadata_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static GEnumValue* _g_enum_value_dup (GEnumValue* self) {
	GEnumValue* dup;
	dup = g_new0 (GEnumValue, 1);
	memcpy (dup, self, sizeof (GEnumValue));
	return dup;
}


static gpointer __g_enum_value_dup0 (gpointer self) {
	return self ? _g_enum_value_dup (self) : NULL;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		g_slice_free (Block1Data, _data1_);
	}
}


static void ____lambda2_ (Block1Data* _data1_, GPid p, gint s) {
	GPid _tmp0_;
	gint _tmp1_;
	_tmp0_ = _data1_->pid;
	g_spawn_close_pid (_tmp0_);
	_tmp1_ = s;
	exit (_tmp1_);
}


static void _____lambda2__gchild_watch_func (GPid pid, gint status, gpointer self) {
	____lambda2_ (self, pid, status);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_;
	GOptionContext* option_context;
	GOptionContext* _tmp2_;
	gboolean _tmp7_;
	GeeArrayList* _tmp19_;
	GeeArrayList* dictionaries;
	const gchar* _tmp20_;
	const gchar* _tmp30_;
	const gchar* _tmp32_;
	gboolean _tmp33_ = FALSE;
	const gchar* _tmp52_;
	GeeArrayList* _tmp80_;
	gint _tmp81_ = 0;
	gpointer* _tmp82_ = NULL;
	SkkDict** _tmp83_;
	gint _tmp83__length1;
	SkkContext* _tmp84_;
	SkkContext* _tmp85_;
	SkkContext* context;
	const gchar* _tmp86_;
	Options _tmp96_ = {0};
	Options opts;
	const gchar* _tmp97_;
	gchar** argv = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gchar** _tmp109_;
	gint _tmp109__length1;
	Client* client = NULL;
	Client* _tmp131_;
	gboolean _tmp132_ = FALSE;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = _ ("- emulate SKK input method on the command line");
	_tmp1_ = g_option_context_new (_tmp0_);
	option_context = _tmp1_;
	_tmp2_ = option_context;
	g_option_context_add_main_entries (_tmp2_, options, "libskk");
	{
		GOptionContext* _tmp3_;
		_tmp3_ = option_context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	skk_init ();
	_tmp7_ = opt_list_typing_rules;
	if (_tmp7_) {
		gint _tmp8_ = 0;
		SkkRuleMetadata* _tmp9_ = NULL;
		SkkRuleMetadata* rules;
		gint rules_length1;
		gint _rules_size_;
		SkkRuleMetadata* _tmp10_;
		gint _tmp10__length1;
		_tmp9_ = skk_rule_list (&_tmp8_);
		rules = _tmp9_;
		rules_length1 = _tmp8_;
		_rules_size_ = rules_length1;
		_tmp10_ = rules;
		_tmp10__length1 = rules_length1;
		{
			SkkRuleMetadata* rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp10_;
			rule_collection_length1 = _tmp10__length1;
			for (rule_it = 0; rule_it < _tmp10__length1; rule_it = rule_it + 1) {
				SkkRuleMetadata _tmp11_ = {0};
				SkkRuleMetadata rule = {0};
				skk_rule_metadata_copy (&rule_collection[rule_it], &_tmp11_);
				rule = _tmp11_;
				{
					FILE* _tmp12_;
					SkkRuleMetadata _tmp13_;
					const gchar* _tmp14_;
					SkkRuleMetadata _tmp15_;
					const gchar* _tmp16_;
					SkkRuleMetadata _tmp17_;
					const gchar* _tmp18_;
					_tmp12_ = stdout;
					_tmp13_ = rule;
					_tmp14_ = _tmp13_.name;
					_tmp15_ = rule;
					_tmp16_ = _tmp15_.label;
					_tmp17_ = rule;
					_tmp18_ = _tmp17_.description;
					fprintf (_tmp12_, "%s - %s: %s\n", _tmp14_, _tmp16_, _tmp18_);
					skk_rule_metadata_destroy (&rule);
				}
			}
		}
		result = 0;
		rules = (_vala_SkkRuleMetadata_array_free (rules, rules_length1), NULL);
		_g_option_context_free0 (option_context);
		return result;
	}
	_tmp19_ = gee_array_list_new (SKK_TYPE_DICT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	dictionaries = _tmp19_;
	_tmp20_ = opt_user_dict;
	if (_tmp20_ != NULL) {
		{
			const gchar* _tmp21_;
			SkkUserDict* _tmp22_;
			SkkUserDict* _tmp23_;
			GeeArrayList* _tmp24_;
			SkkUserDict* _tmp25_;
			_tmp21_ = opt_user_dict;
			_tmp22_ = skk_user_dict_new (_tmp21_, "UTF-8", &_inner_error_);
			_tmp23_ = _tmp22_;
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
			_tmp24_ = dictionaries;
			_tmp25_ = _tmp23_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (SkkDict*) _tmp25_);
			_g_object_unref0 (_tmp25_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_;
			const gchar* _tmp27_;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = stderr;
			_tmp27_ = opt_user_dict;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			fprintf (_tmp26_, "can't open user dict %s: %s", _tmp27_, _tmp29_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp30_ = opt_file_dict;
	if (_tmp30_ == NULL) {
		gchar* _tmp31_ = NULL;
		_tmp31_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_g_free0 (opt_file_dict);
		opt_file_dict = _tmp31_;
	}
	_tmp32_ = opt_file_dict;
	_tmp33_ = g_str_has_suffix (_tmp32_, ".cdb");
	if (_tmp33_) {
		{
			const gchar* _tmp34_;
			SkkCdbDict* _tmp35_;
			SkkCdbDict* _tmp36_;
			GeeArrayList* _tmp37_;
			SkkCdbDict* _tmp38_;
			_tmp34_ = opt_file_dict;
			_tmp35_ = skk_cdb_dict_new (_tmp34_, "EUC-JP", &_inner_error_);
			_tmp36_ = _tmp35_;
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			_tmp37_ = dictionaries;
			_tmp38_ = _tmp36_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, (SkkDict*) _tmp38_);
			_g_object_unref0 (_tmp38_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp39_;
			const gchar* _tmp40_;
			GError* _tmp41_;
			const gchar* _tmp42_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp39_ = stderr;
			_tmp40_ = opt_file_dict;
			_tmp41_ = e;
			_tmp42_ = _tmp41_->message;
			fprintf (_tmp39_, "can't open CDB dict %s: %s", _tmp40_, _tmp42_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	} else {
		{
			const gchar* _tmp43_;
			SkkFileDict* _tmp44_;
			SkkFileDict* _tmp45_;
			GeeArrayList* _tmp46_;
			SkkFileDict* _tmp47_;
			_tmp43_ = opt_file_dict;
			_tmp44_ = skk_file_dict_new (_tmp43_, "EUC-JP", &_inner_error_);
			_tmp45_ = _tmp44_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_tmp46_ = dictionaries;
			_tmp47_ = _tmp45_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, (SkkDict*) _tmp47_);
			_g_object_unref0 (_tmp47_);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			FILE* _tmp48_;
			const gchar* _tmp49_;
			GError* _tmp50_;
			const gchar* _tmp51_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp48_ = stderr;
			_tmp49_ = opt_file_dict;
			_tmp50_ = e;
			_tmp51_ = _tmp50_->message;
			fprintf (_tmp48_, "can't open file dict %s: %s", _tmp49_, _tmp51_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp52_ = opt_skkserv;
	if (_tmp52_ != NULL) {
		const gchar* _tmp53_;
		gint _tmp54_ = 0;
		gint index;
		gchar* host = NULL;
		guint16 port = 0U;
		gint _tmp55_;
		_tmp53_ = opt_skkserv;
		_tmp54_ = string_last_index_of (_tmp53_, ":", 0);
		index = _tmp54_;
		_tmp55_ = index;
		if (_tmp55_ < 0) {
			const gchar* _tmp56_;
			gchar* _tmp57_;
			_tmp56_ = opt_skkserv;
			_tmp57_ = g_strdup (_tmp56_);
			_g_free0 (host);
			host = _tmp57_;
			port = (guint16) 1178;
		} else {
			const gchar* _tmp58_;
			gint _tmp59_;
			gchar* _tmp60_ = NULL;
			const gchar* _tmp61_;
			gint _tmp62_;
			const gchar* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			gchar* _tmp66_ = NULL;
			gchar* _tmp67_;
			gint _tmp68_ = 0;
			_tmp58_ = opt_skkserv;
			_tmp59_ = index;
			_tmp60_ = string_slice (_tmp58_, (glong) 0, (glong) _tmp59_);
			_g_free0 (host);
			host = _tmp60_;
			_tmp61_ = opt_skkserv;
			_tmp62_ = index;
			_tmp63_ = opt_skkserv;
			_tmp64_ = strlen (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = string_slice (_tmp61_, (glong) (_tmp62_ + 1), (glong) _tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = atoi (_tmp67_);
			port = (guint16) _tmp68_;
			_g_free0 (_tmp67_);
		}
		{
			const gchar* _tmp69_;
			guint16 _tmp70_;
			SkkSkkServ* _tmp71_;
			SkkSkkServ* _tmp72_;
			GeeArrayList* _tmp73_;
			SkkSkkServ* _tmp74_;
			_tmp69_ = host;
			_tmp70_ = port;
			_tmp71_ = skk_skk_serv_new (_tmp69_, _tmp70_, "EUC-JP", &_inner_error_);
			_tmp72_ = _tmp71_;
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			_tmp73_ = dictionaries;
			_tmp74_ = _tmp72_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp73_, (SkkDict*) _tmp74_);
			_g_object_unref0 (_tmp74_);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			FILE* _tmp75_;
			const gchar* _tmp76_;
			guint16 _tmp77_;
			GError* _tmp78_;
			const gchar* _tmp79_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp75_ = stderr;
			_tmp76_ = host;
			_tmp77_ = port;
			_tmp78_ = e;
			_tmp79_ = _tmp78_->message;
			fprintf (_tmp75_, "can't connect to skkserv at %s:%d: %s", _tmp76_, (gint) _tmp77_, _tmp79_);
			result = 1;
			_g_error_free0 (e);
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_free0 (host);
	}
	_tmp80_ = dictionaries;
	_tmp82_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp80_, &_tmp81_);
	_tmp83_ = _tmp82_;
	_tmp83__length1 = _tmp81_;
	_tmp84_ = skk_context_new (_tmp83_, _tmp81_);
	_tmp85_ = _tmp84_;
	_tmp83_ = (_vala_array_free (_tmp83_, _tmp83__length1, (GDestroyNotify) g_object_unref), NULL);
	context = _tmp85_;
	_tmp86_ = opt_typing_rule;
	if (_tmp86_ != NULL) {
		{
			const gchar* _tmp87_;
			SkkRule* _tmp88_;
			SkkRule* _tmp89_;
			SkkContext* _tmp90_;
			SkkRule* _tmp91_;
			_tmp87_ = opt_typing_rule;
			_tmp88_ = skk_rule_new (_tmp87_, &_inner_error_);
			_tmp89_ = _tmp88_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
					goto __catch5_skk_rule_parse_error;
				}
				_g_object_unref0 (context);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp90_ = context;
			_tmp91_ = _tmp89_;
			skk_context_set_typing_rule (_tmp90_, _tmp91_);
			_g_object_unref0 (_tmp91_);
		}
		goto __finally5;
		__catch5_skk_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp92_;
			const gchar* _tmp93_;
			GError* _tmp94_;
			const gchar* _tmp95_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp92_ = stderr;
			_tmp93_ = opt_typing_rule;
			_tmp94_ = e;
			_tmp95_ = _tmp94_->message;
			fprintf (_tmp92_, "can't load rule \"%s\": %s\n", _tmp93_, _tmp95_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally5:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	memset (&_tmp96_, 0, sizeof (Options));
	_tmp96_.preedit_style = PREEDIT_STYLE_DEFAULT;
	opts = _tmp96_;
	_tmp97_ = opt_preedit_style;
	if (_tmp97_ != NULL) {
		GTypeClass* _tmp98_ = NULL;
		GEnumClass* eclass;
		GEnumClass* _tmp99_;
		const gchar* _tmp100_;
		GEnumValue* _tmp101_ = NULL;
		GEnumValue* _tmp102_;
		GEnumValue* evalue;
		GEnumValue* _tmp103_;
		GEnumValue* _tmp107_;
		gint _tmp108_;
		_tmp98_ = g_type_class_ref (TYPE_PREEDIT_STYLE);
		eclass = (GEnumClass*) _tmp98_;
		_tmp99_ = eclass;
		_tmp100_ = opt_preedit_style;
		_tmp101_ = g_enum_get_value_by_nick (_tmp99_, _tmp100_);
		_tmp102_ = __g_enum_value_dup0 (_tmp101_);
		evalue = _tmp102_;
		_tmp103_ = evalue;
		if (_tmp103_ == NULL) {
			FILE* _tmp104_;
			const gchar* _tmp105_ = NULL;
			const gchar* _tmp106_;
			_tmp104_ = stderr;
			_tmp105_ = _ ("unknown preedit style %s");
			_tmp106_ = opt_preedit_style;
			fprintf (_tmp104_, _tmp105_, _tmp106_);
			result = 1;
			_g_free0 (evalue);
			_g_type_class_unref0 (eclass);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		_tmp107_ = evalue;
		_tmp108_ = (*_tmp107_).value;
		opts.preedit_style = (PreeditStyle) _tmp108_;
		_g_free0 (evalue);
		_g_type_class_unref0 (eclass);
	}
	_tmp109_ = args;
	_tmp109__length1 = args_length1;
	if (_tmp109__length1 > 1) {
		gchar** _tmp110_;
		gint _tmp110__length1;
		gchar** _tmp111_;
		gint _tmp111__length1;
		gchar** _tmp112_;
		gint _tmp112__length1;
		_tmp110_ = args;
		_tmp110__length1 = args_length1;
		_tmp111_ = args;
		_tmp111__length1 = args_length1;
		_tmp112_ = ((_tmp110_ + 1) != NULL) ? _vala_array_dup1 (_tmp110_ + 1, _tmp111__length1 - 1) : ((gpointer) (_tmp110_ + 1));
		_tmp112__length1 = _tmp111__length1 - 1;
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		argv = _tmp112_;
		argv_length1 = _tmp112__length1;
		_argv_size_ = argv_length1;
	} else {
		const gchar* _tmp113_ = NULL;
		gchar* _tmp114_;
		gchar** _tmp115_ = NULL;
		_tmp113_ = g_getenv ("SHELL");
		_tmp114_ = g_strdup (_tmp113_);
		_tmp115_ = g_new0 (gchar*, 1 + 1);
		_tmp115_[0] = _tmp114_;
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		argv = _tmp115_;
		argv_length1 = 1;
		_argv_size_ = argv_length1;
	}
	{
		Block1Data* _data1_;
		gchar** _tmp116_;
		gint _tmp116__length1;
		GPid _tmp117_ = 0;
		gboolean _tmp118_ = FALSE;
		gboolean _tmp119_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp116_ = argv;
		_tmp116__length1 = argv_length1;
		_tmp118_ = g_spawn_async (NULL, _tmp116_, NULL, (G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_CHILD_INHERITS_STDIN) | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp117_, &_inner_error_);
		_data1_->pid = _tmp117_;
		_tmp119_ = _tmp118_;
		if (_inner_error_ != NULL) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch6_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		if (_tmp119_) {
			GPid _tmp120_;
			_tmp120_ = _data1_->pid;
			g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp120_, _____lambda2__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		}
		block1_data_unref (_data1_);
		_data1_ = NULL;
	}
	goto __finally6;
	__catch6_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp121_;
		GError* _tmp122_;
		const gchar* _tmp123_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp121_ = stderr;
		_tmp122_ = e;
		_tmp123_ = _tmp122_->message;
		fprintf (_tmp121_, "%s\n", _tmp123_);
		result = 1;
		_g_error_free0 (e);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		SkkContext* _tmp124_;
		Options _tmp125_;
		Client* _tmp126_;
		Client* _tmp127_;
		_tmp124_ = context;
		_tmp125_ = opts;
		_tmp126_ = client_new (_tmp124_, &_tmp125_, &_inner_error_);
		_tmp127_ = _tmp126_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_g_object_unref0 (client);
		client = _tmp127_;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp128_;
		GError* _tmp129_;
		const gchar* _tmp130_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp128_ = stderr;
		_tmp129_ = e;
		_tmp130_ = _tmp129_->message;
		fprintf (_tmp128_, "can't create client: %s", _tmp130_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (client);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp131_ = client;
	_tmp132_ = client_run (_tmp131_);
	if (!_tmp132_) {
		result = 1;
		_g_object_unref0 (client);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		return result;
	}
	result = 0;
	_g_object_unref0 (client);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (context);
	_g_object_unref0 (dictionaries);
	_g_option_context_free0 (option_context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


Options* options_dup (const Options* self) {
	Options* dup;
	dup = g_new0 (Options, 1);
	memcpy (dup, self, sizeof (Options));
	return dup;
}


void options_free (Options* self) {
	g_free (self);
}


GType options_get_type (void) {
	static volatile gsize options_type_id__volatile = 0;
	if (g_once_init_enter (&options_type_id__volatile)) {
		GType options_type_id;
		options_type_id = g_boxed_type_register_static ("Options", (GBoxedCopyFunc) options_dup, (GBoxedFreeFunc) options_free);
		g_once_init_leave (&options_type_id__volatile, options_type_id);
	}
	return options_type_id__volatile;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean client_process_lookup_table_key_event (Client* self, guint keyval, guint state) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gboolean _tmp6_;
	guint _tmp31_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = state;
	if (_tmp1_ == ((guint) 0)) {
		guint _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp2_ = keyval;
		_tmp3_ = g_unichar_to_string ((gunichar) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp5__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		_tmp0_ = _vala_string_array_contains (_tmp5_, _tmp5__length1, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		guint _tmp7_;
		gunichar _tmp8_ = 0U;
		gchar* _tmp9_ = NULL;
		gchar* label;
		SkkContext* _tmp10_;
		SkkCandidateList* _tmp11_;
		SkkCandidateList* _tmp12_;
		guint _tmp13_;
		guint _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_ = 0;
		gint end;
		_tmp7_ = keyval;
		_tmp8_ = g_unichar_tolower ((gunichar) _tmp7_);
		_tmp9_ = g_unichar_to_string (_tmp8_);
		label = _tmp9_;
		_tmp10_ = self->priv->context;
		_tmp11_ = skk_context_get_candidates (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = skk_candidate_list_get_page_size (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp15__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		_tmp16_ = MIN ((gint) _tmp14_, _tmp15__length1);
		end = _tmp16_;
		{
			gint index;
			index = 0;
			{
				gboolean _tmp17_;
				_tmp17_ = TRUE;
				while (TRUE) {
					gboolean _tmp18_;
					gint _tmp20_;
					gint _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp18_ = _tmp17_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = index;
						index = _tmp19_ + 1;
					}
					_tmp17_ = FALSE;
					_tmp20_ = index;
					_tmp21_ = end;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp22__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp23_ = index;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp25_ = label;
					if (g_strcmp0 (_tmp24_, _tmp25_) == 0) {
						SkkContext* _tmp26_;
						SkkCandidateList* _tmp27_;
						SkkCandidateList* _tmp28_;
						gint _tmp29_;
						gboolean _tmp30_ = FALSE;
						_tmp26_ = self->priv->context;
						_tmp27_ = skk_context_get_candidates (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = index;
						_tmp30_ = skk_candidate_list_select_at (_tmp28_, (guint) _tmp29_);
						result = _tmp30_;
						_g_free0 (label);
						return result;
					}
				}
			}
		}
		result = FALSE;
		_g_free0 (label);
		return result;
	}
	_tmp31_ = state;
	if (_tmp31_ == ((guint) 0)) {
		gboolean retval;
		guint _tmp32_;
		gboolean _tmp49_;
		retval = FALSE;
		_tmp32_ = keyval;
		switch (_tmp32_) {
			case SKK_KEYSYMS_Page_Up:
			case SKK_KEYSYMS_KP_Page_Up:
			{
				SkkContext* _tmp33_;
				SkkCandidateList* _tmp34_;
				SkkCandidateList* _tmp35_;
				gboolean _tmp36_ = FALSE;
				_tmp33_ = self->priv->context;
				_tmp34_ = skk_context_get_candidates (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = skk_candidate_list_page_up (_tmp35_);
				retval = _tmp36_;
				break;
			}
			case SKK_KEYSYMS_Page_Down:
			case SKK_KEYSYMS_KP_Page_Down:
			{
				SkkContext* _tmp37_;
				SkkCandidateList* _tmp38_;
				SkkCandidateList* _tmp39_;
				gboolean _tmp40_ = FALSE;
				_tmp37_ = self->priv->context;
				_tmp38_ = skk_context_get_candidates (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = skk_candidate_list_page_down (_tmp39_);
				retval = _tmp40_;
				break;
			}
			case SKK_KEYSYMS_Up:
			case SKK_KEYSYMS_Left:
			{
				SkkContext* _tmp41_;
				SkkCandidateList* _tmp42_;
				SkkCandidateList* _tmp43_;
				gboolean _tmp44_ = FALSE;
				_tmp41_ = self->priv->context;
				_tmp42_ = skk_context_get_candidates (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = skk_candidate_list_cursor_up (_tmp43_);
				retval = _tmp44_;
				break;
			}
			case SKK_KEYSYMS_Down:
			case SKK_KEYSYMS_Right:
			{
				SkkContext* _tmp45_;
				SkkCandidateList* _tmp46_;
				SkkCandidateList* _tmp47_;
				gboolean _tmp48_ = FALSE;
				_tmp45_ = self->priv->context;
				_tmp46_ = skk_context_get_candidates (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = skk_candidate_list_cursor_down (_tmp47_);
				retval = _tmp48_;
				break;
			}
			default:
			{
				break;
			}
		}
		_tmp49_ = retval;
		if (_tmp49_) {
			client_set_lookup_table_cursor_pos (self);
			client_update_preedit (self);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean client_real_filter_key_event (FepGClient* base, guint keyval, guint modifiers) {
	Client * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp5_;
	SkkKeyEvent* key = NULL;
	SkkContext* _tmp10_;
	SkkKeyEvent* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean retval;
	SkkContext* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* output;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GError * _inner_error_ = NULL;
	self = (Client*) base;
	_tmp1_ = self->priv->lookup_table_visible;
	if (_tmp1_) {
		guint _tmp2_;
		guint _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = keyval;
		_tmp3_ = modifiers;
		_tmp4_ = client_process_lookup_table_key_event (self, _tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	{
		guint _tmp6_;
		guint _tmp7_;
		SkkKeyEvent* _tmp8_;
		SkkKeyEvent* _tmp9_;
		_tmp6_ = keyval;
		_tmp7_ = modifiers;
		_tmp8_ = skk_key_event_new_from_x_keysym (_tmp6_, (SkkModifierType) _tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
				goto __catch8_skk_key_event_format_error;
			}
			_g_object_unref0 (key);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (key);
		key = _tmp9_;
	}
	goto __finally8;
	__catch8_skk_key_event_format_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (key);
		return result;
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = key;
	_tmp12_ = skk_context_process_key_event (_tmp10_, _tmp11_);
	retval = _tmp12_;
	_tmp13_ = self->priv->context;
	_tmp14_ = skk_context_poll_output (_tmp13_);
	output = _tmp14_;
	_tmp15_ = output;
	_tmp16_ = strlen (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ > 0) {
		const gchar* _tmp18_;
		_tmp18_ = output;
		fep_g_client_send_text ((FepGClient*) self, _tmp18_);
	}
	result = retval;
	_g_free0 (output);
	_g_object_unref0 (key);
	return result;
}


static void client_update_preedit (Client* self) {
	SkkContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	Options _tmp4_;
	PreeditStyle _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_preedit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->preedit);
	self->priv->preedit = _tmp3_;
	_tmp4_ = self->priv->opts;
	_tmp5_ = _tmp4_.preedit_style;
	if (_tmp5_ == PREEDIT_STYLE_ROOT) {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->preedit;
		if (g_strcmp0 (_tmp6_, "") == 0) {
			client_update_status (self);
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = self->priv->preedit;
			fep_g_client_set_status_text ((FepGClient*) self, _tmp7_, NULL);
			_tmp8_ = self->priv->preedit;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (self->priv->status);
			self->priv->status = _tmp9_;
			_g_free0 (self->priv->status_attr);
			self->priv->status_attr = NULL;
		}
	} else {
		const gchar* _tmp10_;
		_tmp10_ = self->priv->preedit;
		fep_g_client_set_cursor_text ((FepGClient*) self, _tmp10_, NULL);
	}
}


static FepGAttribute* _fep_gattribute_dup (FepGAttribute* self) {
	FepGAttribute* dup;
	dup = g_new0 (FepGAttribute, 1);
	memcpy (dup, self, sizeof (FepGAttribute));
	return dup;
}


static gpointer __fep_gattribute_dup0 (gpointer self) {
	return self ? _fep_gattribute_dup (self) : NULL;
}


static gboolean _fep_gattribute_equal (const FepGAttribute* s1, const FepGAttribute* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->type != s2->type) {
		return FALSE;
	}
	if (s1->value != s2->value) {
		return FALSE;
	}
	if (s1->start_index != s2->start_index) {
		return FALSE;
	}
	if (s1->end_index != s2->end_index) {
		return FALSE;
	}
	return TRUE;
}


static void client_update_status (Client* self) {
	GString* _tmp0_;
	GString* builder;
	FepGAttribute* attr;
	SkkContext* _tmp1_;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	gboolean _tmp14_;
	gboolean _tmp92_ = FALSE;
	const gchar* _tmp93_;
	GString* _tmp94_;
	const gchar* _tmp95_;
	gboolean _tmp98_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	attr = NULL;
	_tmp1_ = self->priv->context;
	_tmp2_ = skk_context_get_input_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->input_mode = _tmp3_;
	{
		ClientEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = CLIENT_input_mode_labels;
		entry_collection_length1 = G_N_ELEMENTS (CLIENT_input_mode_labels);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (CLIENT_input_mode_labels); entry_it = entry_it + 1) {
			ClientEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				ClientEntry _tmp4_;
				gconstpointer _tmp5_;
				SkkInputMode _tmp6_;
				_tmp4_ = entry;
				_tmp5_ = _tmp4_.key;
				_tmp6_ = self->priv->input_mode;
				if (((SkkInputMode) ((gintptr) _tmp5_)) == _tmp6_) {
					GString* _tmp7_;
					ClientEntry _tmp8_;
					gconstpointer _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp7_ = builder;
					_tmp8_ = entry;
					_tmp9_ = _tmp8_.value;
					_tmp10_ = g_strconcat ("[", (const gchar*) _tmp9_, NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat (_tmp11_, "] ", NULL);
					_tmp13_ = _tmp12_;
					g_string_append (_tmp7_, _tmp13_);
					_g_free0 (_tmp13_);
					_g_free0 (_tmp11_);
					break;
				}
			}
		}
	}
	_tmp14_ = self->priv->lookup_table_visible;
	if (_tmp14_) {
		SkkContext* _tmp15_;
		SkkCandidateList* _tmp16_;
		SkkCandidateList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		SkkContext* _tmp20_;
		SkkCandidateList* _tmp21_;
		SkkCandidateList* _tmp22_;
		guint _tmp23_;
		guint _tmp24_;
		SkkContext* _tmp25_;
		SkkCandidateList* _tmp26_;
		SkkCandidateList* _tmp27_;
		guint _tmp28_;
		guint _tmp29_;
		guint pages;
		guint _tmp30_;
		SkkContext* _tmp31_;
		SkkCandidateList* _tmp32_;
		SkkCandidateList* _tmp33_;
		guint _tmp34_;
		guint _tmp35_;
		SkkContext* _tmp36_;
		SkkCandidateList* _tmp37_;
		SkkCandidateList* _tmp38_;
		guint _tmp39_;
		guint _tmp40_;
		guint start;
		guint _tmp41_;
		SkkContext* _tmp42_;
		SkkCandidateList* _tmp43_;
		SkkCandidateList* _tmp44_;
		guint _tmp45_;
		guint _tmp46_;
		SkkContext* _tmp47_;
		SkkCandidateList* _tmp48_;
		SkkCandidateList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		guint _tmp52_ = 0U;
		guint end;
		_tmp15_ = self->priv->context;
		_tmp16_ = skk_context_get_candidates (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = skk_candidate_list_get_cursor_pos (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->context;
		_tmp21_ = skk_context_get_candidates (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = skk_candidate_list_get_page_start (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->context;
		_tmp26_ = skk_context_get_candidates (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = skk_candidate_list_get_page_size (_tmp27_);
		_tmp29_ = _tmp28_;
		pages = (_tmp19_ - _tmp24_) / _tmp29_;
		_tmp30_ = pages;
		_tmp31_ = self->priv->context;
		_tmp32_ = skk_context_get_candidates (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = skk_candidate_list_get_page_size (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = self->priv->context;
		_tmp37_ = skk_context_get_candidates (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = skk_candidate_list_get_page_start (_tmp38_);
		_tmp40_ = _tmp39_;
		start = (_tmp30_ * _tmp35_) + _tmp40_;
		_tmp41_ = start;
		_tmp42_ = self->priv->context;
		_tmp43_ = skk_context_get_candidates (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = skk_candidate_list_get_page_size (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = self->priv->context;
		_tmp48_ = skk_context_get_candidates (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = skk_candidate_list_get_size (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = MIN (_tmp41_ + _tmp46_, (guint) _tmp51_);
		end = _tmp52_;
		{
			guint _tmp53_;
			guint index;
			_tmp53_ = start;
			index = _tmp53_;
			{
				gboolean _tmp54_;
				_tmp54_ = TRUE;
				while (TRUE) {
					gboolean _tmp55_;
					guint _tmp57_;
					guint _tmp58_;
					SkkContext* _tmp59_;
					SkkCandidateList* _tmp60_;
					SkkCandidateList* _tmp61_;
					guint _tmp62_;
					SkkCandidate* _tmp63_ = NULL;
					SkkCandidate* candidate;
					gchar** _tmp64_;
					gint _tmp64__length1;
					guint _tmp65_;
					guint _tmp66_;
					const gchar* _tmp67_;
					SkkCandidate* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp70_;
					gchar* _tmp71_ = NULL;
					gchar* text;
					guint _tmp72_;
					SkkContext* _tmp73_;
					SkkCandidateList* _tmp74_;
					SkkCandidateList* _tmp75_;
					gint _tmp76_;
					gint _tmp77_;
					GString* _tmp87_;
					const gchar* _tmp88_;
					guint _tmp89_;
					guint _tmp90_;
					_tmp55_ = _tmp54_;
					if (!_tmp55_) {
						guint _tmp56_;
						_tmp56_ = index;
						index = _tmp56_ + 1;
					}
					_tmp54_ = FALSE;
					_tmp57_ = index;
					_tmp58_ = end;
					if (!(_tmp57_ < _tmp58_)) {
						break;
					}
					_tmp59_ = self->priv->context;
					_tmp60_ = skk_context_get_candidates (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = index;
					_tmp63_ = skk_candidate_list_get (_tmp61_, (gint) _tmp62_);
					candidate = _tmp63_;
					_tmp64_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp64__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp65_ = index;
					_tmp66_ = start;
					_tmp67_ = _tmp64_[_tmp65_ - _tmp66_];
					_tmp68_ = candidate;
					_tmp69_ = skk_candidate_get_text (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = g_strdup_printf ("%s: %s", _tmp67_, _tmp70_);
					text = _tmp71_;
					_tmp72_ = index;
					_tmp73_ = self->priv->context;
					_tmp74_ = skk_context_get_candidates (_tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = skk_candidate_list_get_cursor_pos (_tmp75_);
					_tmp77_ = _tmp76_;
					if (_tmp72_ == ((guint) _tmp77_)) {
						GString* _tmp78_;
						const gchar* _tmp79_;
						gint _tmp80_ = 0;
						gint start_index;
						gint _tmp81_;
						gint _tmp82_;
						const gchar* _tmp83_;
						gint _tmp84_ = 0;
						FepGAttribute _tmp85_ = {0};
						FepGAttribute* _tmp86_;
						_tmp78_ = builder;
						_tmp79_ = _tmp78_->str;
						_tmp80_ = g_utf8_strlen (_tmp79_, (gssize) (-1));
						start_index = _tmp80_;
						_tmp81_ = start_index;
						_tmp82_ = start_index;
						_tmp83_ = text;
						_tmp84_ = g_utf8_strlen (_tmp83_, (gssize) (-1));
						memset (&_tmp85_, 0, sizeof (FepGAttribute));
						_tmp85_.type = FEP_G_ATTR_TYPE_STANDOUT;
						_tmp85_.value = (guint) 1;
						_tmp85_.start_index = (guint) _tmp81_;
						_tmp85_.end_index = (guint) (_tmp82_ + _tmp84_);
						_tmp86_ = __fep_gattribute_dup0 (&_tmp85_);
						_g_free0 (attr);
						attr = _tmp86_;
					}
					_tmp87_ = builder;
					_tmp88_ = text;
					g_string_append (_tmp87_, _tmp88_);
					_tmp89_ = index;
					_tmp90_ = end;
					if (_tmp89_ < (_tmp90_ - 1)) {
						GString* _tmp91_;
						_tmp91_ = builder;
						g_string_append_c (_tmp91_, ' ');
					}
					_g_free0 (text);
					_g_object_unref0 (candidate);
				}
			}
		}
	}
	_tmp93_ = self->priv->status;
	_tmp94_ = builder;
	_tmp95_ = _tmp94_->str;
	if (g_strcmp0 (_tmp93_, _tmp95_) != 0) {
		_tmp92_ = TRUE;
	} else {
		FepGAttribute* _tmp96_;
		FepGAttribute* _tmp97_;
		_tmp96_ = self->priv->status_attr;
		_tmp97_ = attr;
		_tmp92_ = _fep_gattribute_equal (_tmp96_, _tmp97_) != TRUE;
	}
	_tmp98_ = _tmp92_;
	if (_tmp98_) {
		GString* _tmp99_;
		const gchar* _tmp100_;
		FepGAttribute* _tmp101_;
		GString* _tmp102_;
		const gchar* _tmp103_;
		gchar* _tmp104_;
		FepGAttribute* _tmp105_;
		FepGAttribute* _tmp106_;
		_tmp99_ = builder;
		_tmp100_ = _tmp99_->str;
		_tmp101_ = attr;
		fep_g_client_set_status_text ((FepGClient*) self, _tmp100_, _tmp101_);
		_tmp102_ = builder;
		_tmp103_ = _tmp102_->str;
		_tmp104_ = g_strdup (_tmp103_);
		_g_free0 (self->priv->status);
		self->priv->status = _tmp104_;
		_tmp105_ = attr;
		_tmp106_ = __fep_gattribute_dup0 (_tmp105_);
		_g_free0 (self->priv->status_attr);
		self->priv->status_attr = _tmp106_;
	}
	_g_free0 (attr);
	_g_string_free0 (builder);
}


static void client_populate_lookup_table (Client* self) {
	g_return_if_fail (self != NULL);
}


static void client_set_lookup_table_cursor_pos (Client* self) {
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = skk_candidate_list_get_page_visible (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		self->priv->lookup_table_visible = TRUE;
	} else {
		gboolean _tmp5_;
		_tmp5_ = self->priv->lookup_table_visible;
		if (_tmp5_) {
			self->priv->lookup_table_visible = FALSE;
		}
	}
	client_update_status (self);
	_tmp7_ = self->priv->lookup_table_visible;
	if (!_tmp7_) {
		Options _tmp8_;
		PreeditStyle _tmp9_;
		_tmp8_ = self->priv->opts;
		_tmp9_ = _tmp8_.preedit_style;
		_tmp6_ = _tmp9_ == PREEDIT_STYLE_ROOT;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp10_ = _tmp6_;
	if (_tmp10_) {
		client_update_preedit (self);
	}
}


static gboolean client_watch_func (Client* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	fep_g_client_dispatch ((FepGClient*) self);
	result = TRUE;
	return result;
}


static void __lambda3_ (Client* self) {
	SkkContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_preedit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->preedit;
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
		client_update_preedit (self);
	}
}


static void ___lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda3_ (self);
}


static void __lambda4_ (Client* self) {
	SkkContext* _tmp0_;
	SkkInputMode _tmp1_;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_input_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->input_mode;
	if (_tmp2_ != _tmp3_) {
		client_update_status (self);
	}
}


static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda4_ (self);
}


static void __lambda5_ (Client* self) {
	client_populate_lookup_table (self);
}


static void ___lambda5__skk_candidate_list_populated (SkkCandidateList* _sender, gpointer self) {
	__lambda5_ (self);
}


static void __lambda6_ (Client* self) {
	client_set_lookup_table_cursor_pos (self);
}


static void ___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda6_ (self);
}


static void __lambda7_ (Client* self) {
	SkkContext* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* output;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Options _tmp6_;
	PreeditStyle _tmp7_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_poll_output (_tmp0_);
	output = _tmp1_;
	_tmp2_ = output;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		const gchar* _tmp5_;
		_tmp5_ = output;
		fep_g_client_send_text ((FepGClient*) self, _tmp5_);
	}
	self->priv->lookup_table_visible = FALSE;
	client_update_status (self);
	_tmp6_ = self->priv->opts;
	_tmp7_ = _tmp6_.preedit_style;
	if (_tmp7_ == PREEDIT_STYLE_ROOT) {
		client_update_preedit (self);
	}
	_g_free0 (output);
}


static void ___lambda7__skk_candidate_list_selected (SkkCandidateList* _sender, SkkCandidate* candidate, gpointer self) {
	__lambda7_ (self);
}


static gboolean _client_watch_func_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = client_watch_func (self, source, condition);
	return result;
}


gboolean client_run (Client* self) {
	gboolean result = FALSE;
	SkkContext* _tmp0_;
	SkkContext* _tmp1_;
	SkkContext* _tmp2_;
	SkkCandidateList* _tmp3_;
	SkkCandidateList* _tmp4_;
	SkkContext* _tmp5_;
	SkkCandidateList* _tmp6_;
	SkkCandidateList* _tmp7_;
	SkkContext* _tmp8_;
	SkkCandidateList* _tmp9_;
	SkkCandidateList* _tmp10_;
	gint _tmp11_ = 0;
	GIOChannel* _tmp12_;
	GIOChannel* channel;
	GMainLoop* _tmp13_;
	GMainLoop* loop;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::preedit", (GCallback) ___lambda3__g_object_notify, self, 0);
	_tmp1_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::input-mode", (GCallback) ___lambda4__g_object_notify, self, 0);
	_tmp2_ = self->priv->context;
	_tmp3_ = skk_context_get_candidates (_tmp2_);
	_tmp4_ = _tmp3_;
	g_signal_connect_object (_tmp4_, "populated", (GCallback) ___lambda5__skk_candidate_list_populated, self, 0);
	_tmp5_ = self->priv->context;
	_tmp6_ = skk_context_get_candidates (_tmp5_);
	_tmp7_ = _tmp6_;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::cursor-pos", (GCallback) ___lambda6__g_object_notify, self, 0);
	_tmp8_ = self->priv->context;
	_tmp9_ = skk_context_get_candidates (_tmp8_);
	_tmp10_ = _tmp9_;
	g_signal_connect_object (_tmp10_, "selected", (GCallback) ___lambda7__skk_candidate_list_selected, self, 0);
	client_update_preedit (self);
	client_update_status (self);
	_tmp11_ = fep_g_client_get_poll_fd ((FepGClient*) self);
	_tmp12_ = g_io_channel_unix_new (_tmp11_);
	channel = _tmp12_;
	g_io_add_watch (channel, G_IO_IN, _client_watch_func_gio_func, self);
	_tmp13_ = g_main_loop_new (NULL, TRUE);
	loop = _tmp13_;
	g_main_loop_run (loop);
	result = TRUE;
	_g_main_loop_unref0 (loop);
	_g_io_channel_unref0 (channel);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Client* client_construct (GType object_type, SkkContext* context, Options* opts, GError** error) {
	Client * self = NULL;
	SkkContext* _tmp0_;
	SkkContext* _tmp1_;
	Options _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (opts != NULL, NULL);
	self = (Client*) g_object_new (object_type, "address", NULL, NULL);
	g_initable_init ((GInitable*) self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp0_ = context;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = *opts;
	self->priv->opts = _tmp2_;
	return self;
}


Client* client_new (SkkContext* context, Options* opts, GError** error) {
	return client_construct (TYPE_CLIENT, context, opts, error);
}


static void client_entry_copy (const ClientEntry* self, ClientEntry* dest) {
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	_tmp0_ = (*self).key;
	(*dest).key = _tmp0_;
	_tmp1_ = (*self).value;
	(*dest).value = _tmp1_;
}


static void client_entry_destroy (ClientEntry* self) {
}


static ClientEntry* client_entry_dup (const ClientEntry* self) {
	ClientEntry* dup;
	dup = g_new0 (ClientEntry, 1);
	client_entry_copy (self, dup);
	return dup;
}


static void client_entry_free (ClientEntry* self) {
	client_entry_destroy (self);
	g_free (self);
}


static GType client_entry_get_type (void) {
	static volatile gsize client_entry_type_id__volatile = 0;
	if (g_once_init_enter (&client_entry_type_id__volatile)) {
		GType client_entry_type_id;
		client_entry_type_id = g_boxed_type_register_static ("ClientEntry", (GBoxedCopyFunc) client_entry_dup, (GBoxedFreeFunc) client_entry_free);
		g_once_init_leave (&client_entry_type_id__volatile, client_entry_type_id);
	}
	return client_entry_type_id__volatile;
}


static void client_class_init (ClientClass * klass) {
	client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClientPrivate));
	FEP_G_CLIENT_CLASS (klass)->filter_key_event = client_real_filter_key_event;
	G_OBJECT_CLASS (klass)->finalize = client_finalize;
}


static void client_instance_init (Client * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	self->priv = CLIENT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("a");
	_tmp1_ = g_strdup ("s");
	_tmp2_ = g_strdup ("d");
	_tmp3_ = g_strdup ("f");
	_tmp4_ = g_strdup ("j");
	_tmp5_ = g_strdup ("k");
	_tmp6_ = g_strdup ("l");
	_tmp7_ = g_strdup ("q");
	_tmp8_ = g_strdup ("w");
	_tmp9_ = g_strdup ("e");
	_tmp10_ = g_strdup ("r");
	_tmp11_ = g_strdup ("u");
	_tmp12_ = g_strdup ("i");
	_tmp13_ = g_strdup ("o");
	_tmp14_ = g_new0 (gchar*, 14 + 1);
	_tmp14_[0] = _tmp0_;
	_tmp14_[1] = _tmp1_;
	_tmp14_[2] = _tmp2_;
	_tmp14_[3] = _tmp3_;
	_tmp14_[4] = _tmp4_;
	_tmp14_[5] = _tmp5_;
	_tmp14_[6] = _tmp6_;
	_tmp14_[7] = _tmp7_;
	_tmp14_[8] = _tmp8_;
	_tmp14_[9] = _tmp9_;
	_tmp14_[10] = _tmp10_;
	_tmp14_[11] = _tmp11_;
	_tmp14_[12] = _tmp12_;
	_tmp14_[13] = _tmp13_;
	self->priv->LOOKUP_TABLE_LABELS = _tmp14_;
	self->priv->LOOKUP_TABLE_LABELS_length1 = 14;
	self->priv->_LOOKUP_TABLE_LABELS_size_ = self->priv->LOOKUP_TABLE_LABELS_length1;
	self->priv->lookup_table_visible = FALSE;
	_tmp15_ = g_strdup ("");
	self->priv->preedit = _tmp15_;
	_tmp16_ = g_strdup ("");
	self->priv->status = _tmp16_;
	self->priv->status_attr = NULL;
	self->priv->input_mode = SKK_INPUT_MODE_HIRAGANA;
}


static void client_finalize (GObject* obj) {
	Client * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLIENT, Client);
	_g_object_unref0 (self->priv->context);
	self->priv->LOOKUP_TABLE_LABELS = (_vala_array_free (self->priv->LOOKUP_TABLE_LABELS, self->priv->LOOKUP_TABLE_LABELS_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->preedit);
	_g_free0 (self->priv->status);
	_g_free0 (self->priv->status_attr);
	G_OBJECT_CLASS (client_parent_class)->finalize (obj);
}


GType client_get_type (void) {
	static volatile gsize client_type_id__volatile = 0;
	if (g_once_init_enter (&client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Client), 0, (GInstanceInitFunc) client_instance_init, NULL };
		GType client_type_id;
		client_type_id = g_type_register_static (fep_g_client_get_type (), "Client", &g_define_type_info, 0);
		g_once_init_leave (&client_type_id__volatile, client_type_id);
	}
	return client_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



