# Try to find Jansson
# Once done this will define
#  JANSSON_FOUND
#  JANSSON_INCLUDE_DIRS
#  JANSSON_LIBRARIES
#  JANSSON_DEFINITIONS


find_package(PkgConfig)
pkg_check_modules(PC_JANSSON QUIET libjansson)
set(JANSSON_DEFINITIONS ${PC_JANSSON_CFLAGS_OTHER})

find_path(JANSSON_INCLUDE_DIR jansson.h HINTS ${PC_JANSSON_INCLUDEDIR} ${PC_JANSSON_INCLUDE_DIRS} PATH_SUFFIXES jansson)

if (CMAKE_BUILD_TYPE STREQUAL "Debug" AND DEFINED CMAKE_DEBUG_POSTFIX)
	find_library(JANSSON_LIBRARY NAMES jansson${CMAKE_DEBUG_POSTFIX} libjansson${CMAKE_DEBUG_POSTFIX} jansson libjansson HINTS ${PC_JANSSON_LIBDIR} ${PC_JANSSON_LIBRARY_DIRS})
else ()
	find_library(JANSSON_LIBRARY NAMES jansson libjansson HINTS ${PC_JANSSON_LIBDIR} ${PC_JANSSON_LIBRARY_DIRS})
endif ()

set(JANSSON_LIBRARIES ${JANSSON_LIBRARY})
set(JANSSON_INCLUDE_DIRS ${JANSSON_INCLUDE_DIR})

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(LibJansson DEFAULT_MSG JANSSON_LIBRARY JANSSON_INCLUDE_DIR)

mark_as_advanced(JANSSON_INCLUDE_DIR JANSSON_LIBRARY)
