/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYPATCH 20170430

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#define YYPREFIX "yy"

#define YYPURE 0

#line 74 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"

#include <config.h>

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/stat.h>

#include <netinet/in.h>
#include <netdb.h>
#include <arpa/ftp.h>

#include <ctype.h>
#include <errno.h>
#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#ifdef HAVE_INTTYPES_H
# include <inttypes.h>	/* strtoimax */
#elif defined HAVE_STDINT_H
# include <stdint.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>
#include <limits.h>
#include <sys/utsname.h>
/* Include glob.h last, because it may define "const" which breaks
   system headers on some platforms. */
#include <glob.h>

#include "extern.h"

#if !defined NBBY && defined CHAR_BIT
#define NBBY CHAR_BIT
#endif

off_t restart_point;

static char cbuf[512];           /* Command Buffer.  */
static char *fromname;
static int cmd_type;
static int cmd_form;
static int cmd_bytesz;

struct tab
{
  const char	*name;
  short	token;
  short	state;
  short	implemented;	/* 1 if command is implemented */
  const char	*help;
};

static struct tab cmdtab[];
static struct tab sitetab[];
static char *extlist[];
static char *copy         (char *);
static void help          (struct tab *, char *);
static struct tab *lookup (struct tab *, char *);
static void sizecmd       (char *);
static int yylex          (void);
static void yyerror       (const char *s);

#ifdef YYSTYPE
#undef  YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#endif
#ifndef YYSTYPE_IS_DECLARED
#define YYSTYPE_IS_DECLARED 1
#line 144 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
typedef union {
	intmax_t i;
	char   *s;
} YYSTYPE;
#endif /* !YYSTYPE_IS_DECLARED */
#line 102 "ftpcmd.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define A 257
#define B 258
#define C 259
#define E 260
#define F 261
#define I 262
#define L 263
#define N 264
#define P 265
#define R 266
#define S 267
#define T 268
#define SP 269
#define CRLF 270
#define COMMA 271
#define USER 272
#define PASS 273
#define ACCT 274
#define REIN 275
#define QUIT 276
#define PORT 277
#define PASV 278
#define TYPE 279
#define STRU 280
#define MODE 281
#define RETR 282
#define STOR 283
#define APPE 284
#define MLFL 285
#define MAIL 286
#define MSND 287
#define MSOM 288
#define MSAM 289
#define MRSQ 290
#define MRCP 291
#define ALLO 292
#define REST 293
#define RNFR 294
#define RNTO 295
#define ABOR 296
#define DELE 297
#define CWD 298
#define LIST 299
#define NLST 300
#define SITE 301
#define STAT 302
#define HELP 303
#define NOOP 304
#define MKD 305
#define RMD 306
#define PWD 307
#define CDUP 308
#define STOU 309
#define SMNT 310
#define SYST 311
#define SIZE 312
#define MDTM 313
#define FEAT 314
#define OPTS 315
#define EPRT 316
#define EPSV 317
#define LPRT 318
#define LPSV 319
#define ADAT 320
#define AUTH 321
#define CCC 322
#define CONF 323
#define ENC 324
#define MIC 325
#define PBSZ 326
#define PROT 327
#define UMASK 328
#define IDLE 329
#define CHMOD 330
#define LEXERR 331
#define STRING 332
#define NUMBER 333
#define CHAR 334
#define YYERRCODE 256
typedef short YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    0,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   18,   18,   11,   10,   10,
    3,   13,   14,   16,   12,   15,   15,    7,    7,    7,
    6,    6,    6,    6,    6,    6,    6,    6,    4,    4,
    4,    5,    5,    5,    9,    8,    2,    1,
};
static const YYINT yylen[] = {                            2,
    0,    2,    2,    4,    4,    5,    3,    4,    4,    4,
    4,    8,    5,    5,    5,    3,    5,    3,    5,    5,
    2,    5,    5,    2,    3,    5,    2,    4,    2,    5,
    5,    3,    3,    3,    5,    3,    5,    4,    6,    5,
    7,    9,    4,    7,    5,    2,    5,    5,   11,    3,
    5,    5,    3,    2,    2,    5,    4,    1,    0,    1,
    1,    1,    1,    1,   11,   17,   41,    1,    1,    1,
    1,    3,    1,    3,    1,    1,    3,    2,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    0,
};
static const YYINT yydefred[] = {                         1,
    0,    0,    0,    0,    0,   88,   88,    0,    0,    0,
   88,   88,   88,    0,    0,   88,   88,    0,   88,   88,
   88,   88,    0,    0,    0,    0,   88,   88,   88,   88,
   88,    0,   88,   88,   88,   88,   88,   88,   88,   88,
    2,    3,   55,    0,    0,   54,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   24,    0,
    0,    0,    0,    0,   21,    0,    0,   27,   29,    0,
    0,    0,    0,    0,   46,    0,    0,    0,    0,    0,
    0,    0,    0,   58,    0,   60,    0,    0,    7,    0,
    0,   75,    0,    0,   79,   81,   80,    0,   83,   84,
   82,    0,    0,    0,    0,    0,   61,    0,    0,    0,
    0,    0,   25,    0,   18,    0,   16,    0,   88,    0,
   88,    0,    0,    0,    0,   32,   33,    0,    0,    0,
    0,   34,    0,   36,    0,    0,   50,    0,   53,    4,
    5,    0,    0,    0,    0,    0,   78,    8,    9,   10,
   86,   85,    0,    0,    0,    0,   11,   57,    0,    0,
    0,    0,    0,    0,    0,   38,    0,   43,    0,    0,
    0,   28,    0,    0,    0,    0,    0,    0,    0,    0,
   62,    0,    0,    0,    0,    6,   70,   68,   69,   72,
   74,   77,   13,   14,   15,    0,   56,   23,   22,   26,
   19,   17,    0,    0,   40,    0,    0,   20,   30,   31,
   45,   47,   48,   35,   37,    0,   51,    0,   52,    0,
    0,   39,   87,    0,    0,    0,    0,    0,    0,    0,
   41,   44,    0,   64,    0,    0,    0,   12,    0,    0,
    0,    0,   42,   63,    0,    0,    0,    0,    0,    0,
   49,    0,    0,    0,    0,    0,   65,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   67,
};
static const YYINT yydgoto[] = {                          1,
   47,  224,  108,   98,  102,   94,  190,  152,  153,   87,
   85,  143,  182,  245,  184,  235,   41,   42,
};
static const YYINT yysindex[] = {                         0,
 -208, -261, -266, -257, -253,    0,    0, -230, -207, -188,
    0,    0,    0, -167, -143,    0,    0, -251,    0,    0,
    0,    0, -142, -140, -239, -139,    0,    0,    0,    0,
    0, -138,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -204, -199,    0, -135, -132, -180, -250,
 -245, -130, -129, -128, -190, -189, -127, -124,    0, -123,
 -228, -191, -157, -269,    0, -122, -184,    0,    0, -120,
 -119, -118, -117, -115,    0, -114, -113, -155, -153, -112,
 -151, -111, -110,    0, -109,    0, -108, -182,    0, -106,
 -105,    0, -267, -103,    0,    0,    0, -102,    0,    0,
    0, -101, -173, -173, -173, -149,    0, -100, -173, -173,
 -173, -173,    0, -173,    0, -166,    0, -147,    0,  -99,
    0, -173,  -98, -173, -173,    0,    0, -173, -173, -173,
 -159,    0, -158,    0, -169, -156,    0, -154,    0,    0,
    0,  -96,  -94, -201, -201, -189,    0,    0,    0,    0,
    0,    0,  -92,  -90,  -88,  -85,    0,    0,  -87,  -86,
  -84,  -83,  -82,  -81, -141,    0, -145,    0,  -79,  -77,
  -76,    0,  -75,  -74,  -73,  -72,  -71,  -70,  -69, -156,
    0,  -68,  -78,  -67, -148,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  -65,    0,    0,    0,    0,
    0,    0,  -64, -126,    0, -125, -126,    0,    0,    0,
    0,    0,    0,    0,    0, -121,    0, -116,    0,  -66,
 -107,    0,    0,  -61,  -60,  -58,  -97,  -59,  -95,  -56,
    0,    0, -173,    0,  -93,  -91,  -55,    0,  -52,  -80,
  -51,  -63,    0,    0,  -62,  -57,  -50,  -48,  -47,  -54,
    0,  -53,  -46,  -44,  -49,  -45,    0,  -43,  -42,  -41,
  -40,  -39,  -38,  -37,  -36,  -35,  -34,  -32,  -33,  -31,
  -30,  -28,  -29,  -27,  -26,  -25,  -24,  -23,  -22,  -21,
  -20,  -19,  -18,  -17,  -16,  -15,  -14,    0,
};
static const YYINT yyrindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -135,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -251,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  -13,
  -12,    0,  -11,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -135,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  -10,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
};
static const YYINT yygindex[] = {                         0,
   16,    8,  -89,    0,    0,    0,   74,    0, -104,    0,
    0,    0,   43,    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 319
static const YYINT yytable[] = {                        154,
  155,  146,   44,  147,  159,  160,  161,  162,   43,  163,
   95,   45,   99,  100,   96,   97,   46,  171,   59,  173,
  174,  101,   48,  175,  176,  177,   52,   53,   54,   67,
   68,   57,   58,  118,   60,   61,   62,   63,   49,   66,
  112,  113,   70,   71,   72,   73,   74,    2,   76,   77,
   78,   79,   80,   81,   82,   83,  192,  187,  119,  120,
  121,   50,  188,    3,    4,  107,  189,    5,    6,    7,
    8,    9,   10,   11,   12,   13,   90,  114,  115,   91,
   51,   92,   93,   14,   15,   16,   17,   18,   19,   20,
   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
   31,   55,   32,   33,   34,   35,   36,   37,   38,   39,
   40,  116,  117,  131,  132,  133,  134,  136,  137,  156,
  157,  165,  166,  204,  205,   56,   64,   84,  239,   65,
   69,   75,   86,   88,  167,  169,  170,   89,  103,  104,
  105,  109,  106,  107,  110,  111,  122,  123,  124,  125,
  142,  126,  127,  128,  129,  130,  135,  138,  151,  139,
  140,  141,  144,  145,  180,  164,  148,  149,  150,  158,
  168,  172,  178,  179,  185,  186,  181,  193,  183,  194,
  196,  195,  197,  198,  220,  199,  200,  201,  202,  206,
  203,  207,  218,  208,  209,  210,  211,  212,  213,  214,
  215,  217,  219,  221,  229,  222,  223,  225,  231,  232,
  233,  236,  227,  238,  226,  242,  228,  243,  191,  246,
  250,  251,  216,  252,  255,  230,  256,  259,    0,  261,
    0,  263,    0,  265,  234,  267,    0,  237,  269,  271,
  240,  241,  273,  275,    0,  277,    0,  279,    0,  281,
    0,  283,  244,  285,    0,  287,   71,   73,   76,   66,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  247,
    0,  248,    0,    0,    0,  249,    0,    0,  253,  254,
    0,    0,    0,  257,    0,    0,    0,  258,    0,    0,
  260,    0,  262,    0,  264,    0,  266,    0,  268,  270,
    0,    0,  272,  274,    0,    0,  276,    0,  278,    0,
  280,    0,  282,    0,  284,    0,  286,    0,  288,
};
static const YYINT yycheck[] = {                        104,
  105,  269,  269,   93,  109,  110,  111,  112,  270,  114,
  261,  269,  258,  259,  265,  266,  270,  122,  270,  124,
  125,  267,    7,  128,  129,  130,   11,   12,   13,  269,
  270,   16,   17,  303,   19,   20,   21,   22,  269,   24,
  269,  270,   27,   28,   29,   30,   31,  256,   33,   34,
   35,   36,   37,   38,   39,   40,  146,  259,  328,  329,
  330,  269,  264,  272,  273,  333,  268,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  257,  269,  270,  260,
  269,  262,  263,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,  307,  308,
  309,  269,  311,  312,  313,  314,  315,  316,  317,  318,
  319,  269,  270,  269,  270,  269,  270,  269,  270,  269,
  270,  269,  270,  269,  270,  269,  269,  332,  233,  270,
  270,  270,  332,  269,  119,  120,  121,  270,  269,  269,
  269,  269,  333,  333,  269,  269,  269,  332,  269,  269,
  333,  270,  270,  269,  269,  269,  269,  269,  332,  270,
  270,  270,  269,  269,  334,  332,  270,  270,  270,  270,
  270,  270,  332,  332,  271,  270,  333,  270,  333,  270,
  266,  270,  270,  270,  333,  270,  270,  270,  270,  269,
  332,  269,  271,  270,  270,  270,  270,  270,  270,  270,
  270,  270,  270,  269,  271,  270,  333,  333,  270,  270,
  269,  271,  334,  270,  207,  271,  333,  270,  145,  271,
  271,  270,  180,  271,  271,  333,  271,  271,   -1,  271,
   -1,  271,   -1,  271,  332,  271,   -1,  333,  271,  271,
  334,  333,  271,  271,   -1,  271,   -1,  271,   -1,  271,
   -1,  271,  333,  271,   -1,  271,  270,  270,  270,  270,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,
   -1,  334,   -1,   -1,   -1,  333,   -1,   -1,  333,  333,
   -1,   -1,   -1,  333,   -1,   -1,   -1,  333,   -1,   -1,
  333,   -1,  333,   -1,  333,   -1,  333,   -1,  333,  333,
   -1,   -1,  333,  333,   -1,   -1,  333,   -1,  333,   -1,
  333,   -1,  333,   -1,  333,   -1,  333,   -1,  333,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 334
#define YYUNDFTOKEN 355
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"A","B","C","E","F","I","L","N",
"P","R","S","T","SP","CRLF","COMMA","USER","PASS","ACCT","REIN","QUIT","PORT",
"PASV","TYPE","STRU","MODE","RETR","STOR","APPE","MLFL","MAIL","MSND","MSOM",
"MSAM","MRSQ","MRCP","ALLO","REST","RNFR","RNTO","ABOR","DELE","CWD","LIST",
"NLST","SITE","STAT","HELP","NOOP","MKD","RMD","PWD","CDUP","STOU","SMNT",
"SYST","SIZE","MDTM","FEAT","OPTS","EPRT","EPSV","LPRT","LPSV","ADAT","AUTH",
"CCC","CONF","ENC","MIC","PBSZ","PROT","UMASK","IDLE","CHMOD","LEXERR","STRING",
"NUMBER","CHAR",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : cmd_list",
"cmd_list :",
"cmd_list : cmd_list cmd",
"cmd_list : cmd_list rcmd",
"cmd : USER SP username CRLF",
"cmd : PASS SP password CRLF",
"cmd : PORT check_login SP host_port CRLF",
"cmd : PASV check_login CRLF",
"cmd : TYPE SP type_code CRLF",
"cmd : STRU SP struct_code CRLF",
"cmd : MODE SP mode_code CRLF",
"cmd : ALLO SP NUMBER CRLF",
"cmd : ALLO SP NUMBER SP R SP NUMBER CRLF",
"cmd : RETR check_login SP pathname CRLF",
"cmd : STOR check_login SP pathname CRLF",
"cmd : APPE check_login SP pathname CRLF",
"cmd : NLST check_login CRLF",
"cmd : NLST check_login SP STRING CRLF",
"cmd : LIST check_login CRLF",
"cmd : LIST check_login SP pathname CRLF",
"cmd : STAT check_login SP pathname CRLF",
"cmd : STAT CRLF",
"cmd : DELE check_login SP pathname CRLF",
"cmd : RNTO check_login SP pathname CRLF",
"cmd : ABOR CRLF",
"cmd : CWD check_login CRLF",
"cmd : CWD check_login SP pathname CRLF",
"cmd : HELP CRLF",
"cmd : HELP SP STRING CRLF",
"cmd : NOOP CRLF",
"cmd : MKD check_login SP pathname CRLF",
"cmd : RMD check_login SP pathname CRLF",
"cmd : PWD check_login CRLF",
"cmd : CDUP check_login CRLF",
"cmd : FEAT check_login CRLF",
"cmd : FEAT check_login SP STRING CRLF",
"cmd : OPTS check_login CRLF",
"cmd : OPTS check_login SP STRING CRLF",
"cmd : SITE SP HELP CRLF",
"cmd : SITE SP HELP SP STRING CRLF",
"cmd : SITE SP UMASK check_login CRLF",
"cmd : SITE SP UMASK check_login SP octal_number CRLF",
"cmd : SITE SP CHMOD check_login SP octal_number SP pathname CRLF",
"cmd : SITE SP IDLE CRLF",
"cmd : SITE SP IDLE check_login SP NUMBER CRLF",
"cmd : STOU check_login SP pathname CRLF",
"cmd : SYST CRLF",
"cmd : SIZE check_login SP pathname CRLF",
"cmd : MDTM check_login SP pathname CRLF",
"cmd : EPRT check_login SP CHAR net_proto CHAR net_addr CHAR tcp_port CHAR CRLF",
"cmd : EPSV check_login CRLF",
"cmd : EPSV check_login SP net_proto CRLF",
"cmd : LPRT check_login SP long_host_port CRLF",
"cmd : LPSV check_login CRLF",
"cmd : QUIT CRLF",
"cmd : error CRLF",
"rcmd : RNFR check_login SP pathname CRLF",
"rcmd : REST SP byte_size CRLF",
"username : STRING",
"password :",
"password : STRING",
"byte_size : NUMBER",
"net_proto : NUMBER",
"tcp_port : NUMBER",
"net_addr : STRING",
"host_port : NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER",
"long_host_port : NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER",
"long_host_port : NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER",
"form_code : N",
"form_code : T",
"form_code : C",
"type_code : A",
"type_code : A SP form_code",
"type_code : E",
"type_code : E SP form_code",
"type_code : I",
"type_code : L",
"type_code : L SP byte_size",
"type_code : L byte_size",
"struct_code : F",
"struct_code : R",
"struct_code : P",
"mode_code : S",
"mode_code : B",
"mode_code : C",
"pathname : pathstring",
"pathstring : STRING",
"octal_number : NUMBER",
"check_login :",

};
#endif

int      yydebug;
int      yynerrs;

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#define YYINITSTACKSIZE 200

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 1312 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"

#define	CMD	0	/* beginning of command */
#define	ARGS	1	/* expect miscellaneous arguments */
#define	STR1	2	/* expect SP followed by STRING */
#define	STR2	3	/* expect STRING (must be STR2 + 1)*/
#define	OSTR	4	/* optional SP then STRING */
#define	ZSTR1	5	/* SP then optional STRING */
#define	ZSTR2	6	/* optional STRING after SP (must be ZSTR1 + 1) */
#define	SITECMD	7	/* SITE command */
#define	NSTR	8	/* Number followed by a string */
#define	DLIST	9	/* SP and delimited list for EPRT/EPSV */

static struct tab cmdtab[] = {
  /* In the order defined by RFC 959.  See also RFC 1123.  */
  /* Access control commands.  */
  { "USER", USER, STR1, 1,	"<sp> username" },
  { "PASS", PASS, ZSTR1, 1,	"<sp> password" },
  { "ACCT", ACCT, STR1, 0,	"(specify account)" },
  { "CWD",  CWD,  OSTR, 1,	"[ <sp> directory-name ]" },
  { "CDUP", CDUP, ARGS, 1,	"(change to parent directory)" },
  { "SMNT", SMNT, ARGS, 0,	"(structure mount)" },
  { "REIN", REIN, ARGS, 0,	"(reinitialize server state)" },
  { "QUIT", QUIT, ARGS, 1,	"(terminate service)", },
  /* Transfer parameter commands.  */
  { "PORT", PORT, ARGS, 1,	"<sp> b0, b1, b2, b3, b4" },
  { "PASV", PASV, ARGS, 1,	"(set server in passive mode)" },
  { "TYPE", TYPE, ARGS, 1,	"<sp> [ A | E | I | L ]" },
  { "STRU", STRU, ARGS, 1,	"(specify file structure)" },
  { "MODE", MODE, ARGS, 1,	"(specify transfer mode)" },
  /* FTP service commands.  */
  { "RETR", RETR, STR1, 1,	"<sp> file-name" },
  { "STOR", STOR, STR1, 1,	"<sp> file-name" },
  { "STOU", STOU, STR1, 1,	"<sp> file-name" },
  { "APPE", APPE, STR1, 1,	"<sp> file-name" },
  { "ALLO", ALLO, ARGS, 1,	"allocate storage (vacuously)" },
  { "REST", REST, ARGS, 1,	"<sp> offset (restart command)" },
  { "RNFR", RNFR, STR1, 1,	"<sp> file-name" },
  { "RNTO", RNTO, STR1, 1,	"<sp> file-name" },
  { "ABOR", ABOR, ARGS, 1,	"(abort operation)" },
  { "DELE", DELE, STR1, 1,	"<sp> file-name" },
  { "RMD",  RMD,  STR1, 1,	"<sp> path-name" },
  { "MKD",  MKD,  STR1, 1,	"<sp> path-name" },
  { "PWD",  PWD,  ARGS, 1,	"(return current directory)" },
  { "LIST", LIST, OSTR, 1,	"[ <sp> path-name ]" },
  { "NLST", NLST, OSTR, 1,	"[ <sp> path-name ]" },
  { "SITE", SITE, SITECMD, 1,	"site-cmd [ <sp> arguments ]" },
  { "SYST", SYST, ARGS, 1,	"(get type of operating system)" },
  { "STAT", STAT, OSTR, 1,	"[ <sp> path-name ]" },
  { "HELP", HELP, OSTR, 1,	"[ <sp> <string> ]" },
  { "NOOP", NOOP, ARGS, 1,	"" },
  /* Experimental commands, as mentioned in RFC 1123.  Now obsolete.  */
  { "XMKD", MKD,  STR1, 1,	"<sp> path-name" },
  { "XRMD", RMD,  STR1, 1,	"<sp> path-name" },
  { "XPWD", PWD,  ARGS, 1,	"(return current directory)" },
  { "XCUP", CDUP, ARGS, 1,	"(change to parent directory)" },
  { "XCWD", CWD,  OSTR, 1,	"[ <sp> directory-name ]" },
  /* Commands in RFC 2389.  */
  { "FEAT", FEAT, OSTR, 1,	"(display command extensions)" },
  /* XXX: Replace OSTR once some functionality exists.  */
  { "OPTS", OPTS, OSTR, 1,	"<sp> cmd-name [ <sp> options ]" },
  /* Commands in RFC 3659.  */
  { "SIZE", SIZE, OSTR, 1,	"<sp> path-name" },
  { "MDTM", MDTM, OSTR, 1,	"<sp> path-name" },
  /* Unimplemented, but reserved in RFC ???.  */
  { "MLFL", MLFL, OSTR, 0,	"(mail file)" },
  { "MAIL", MAIL, OSTR, 0,	"(mail to user)" },
  { "MSND", MSND, OSTR, 0,	"(mail send to terminal)" },
  { "MSOM", MSOM, OSTR, 0,	"(mail send to terminal or mailbox)" },
  { "MSAM", MSAM, OSTR, 0,	"(mail send to terminal and mailbox)" },
  { "MRSQ", MRSQ, OSTR, 0,	"(mail recipient scheme question)" },
  { "MRCP", MRCP, STR1, 0,	"(mail recipient)" },
  /* Extended addressing in RFC 2428.  */
  { "EPRT", EPRT, DLIST, 1,	"<sp> <d> proto <d> addr <d> port <d>" },
  { "EPSV", EPSV, ARGS, 1,	"[ <sp> af ]" },
  /* Long addressing in RFC 1639.  Obsoleted in RFC 5797.  */
  { "LPRT", LPRT, ARGS, 1,	"<sp> af,hal,h0..hn,2,p0,p1" },
  { "LPSV", LPSV, ARGS, 1,	"(set server in long passive mode)" },
  /* Security extensions in RFC 2228.  */
  { "ADAT", ADAT, OSTR, 0,	"<sp> security-data" },
  { "AUTH", AUTH, OSTR, 0,	"<sp> mechanism" },
  { "CCC", CCC, ARGS, 0,	"(clear command channel)" },
  { "CONF", CONF, OSTR, 0,	"<sp> confidential-msg" },
  { "ENC", ENC, OSTR, 0,	"<sp> private-message" },
  { "MIC", MIC, OSTR, 0,	"<sp> safe-message" },
  { "PBSZ", PBSZ, OSTR, 0,	"<sp> buf-size" },
  { "PROT", PROT, OSTR, 0,	"<sp> char" },
  /* End of list.  */
  { NULL,   0,    0,    0,	NULL }
};

static struct tab sitetab[] = {
  { "CHMOD", CHMOD, NSTR, 1,	"<sp> mode <sp> file-name" },
  { "HELP", HELP, OSTR, 1,	"[ <sp> <string> ]" },
  { "IDLE", IDLE, ARGS, 1,	"[ <sp> maximum-idle-time ]" },
  { "UMASK", UMASK, ARGS, 1,	"[ <sp> umask ]" },
  { NULL,   0,    0,    0,	NULL }
};

/* Extensions beyond RFC 959 and RFC 2389.  Ordered as implemented.  */
static char *extlist[] = {
  "MDTM", "SIZE", "REST STREAM",
  "EPRT", "EPSV", "LPRT", "LPSV",
  NULL };

static struct tab *
lookup (struct tab *p, char *cmd)
{
  for (; p->name != NULL; p++)
    if (strcmp (cmd, p->name) == 0)
      return (p);
  return (0);
}

#include <arpa/telnet.h>

/*
 * getline - a hacked up version of fgets to ignore TELNET escape codes.
 */
char *
telnet_fgets (char *s, int n, FILE *iop)
{
  int c;
  register char *cs;

  cs = s;
/* tmpline may contain saved command from urgent mode interruption */
  for (c = 0; tmpline[c] != '\0' && --n > 0; ++c)
    {
      *cs++ = tmpline[c];
      if (tmpline[c] == '\n')
	{
	  *cs++ = '\0';
	  if (debug)
	    syslog (LOG_DEBUG, "command: %s", s);
	  tmpline[0] = '\0';
	  return (s);
	}

      if (c == 0)
	tmpline[0] = '\0';
    }

  while ((c = getc (iop)) != EOF)
    {
      c &= 0377;
      if (c == IAC)
	{
	  c = getc (iop);
	  if (c != EOF)
	    {
	      c &= 0377;
	      switch (c)
		{
		case WILL:
		case WONT:
		  c = getc (iop);
		  printf ("%c%c%c", IAC, DONT, 0377 & c);
		  fflush (stdout);
		  continue;

		case DO:
		case DONT:
		  c = getc (iop);
		  printf ("%c%c%c", IAC, WONT, 0377 & c);
		  fflush (stdout);
		  continue;

		case IAC:
		  break;

		default:
		  continue;	/* ignore command */
		}
	    }
	}

      *cs++ = c;
      if (--n <= 0 || c == '\n')
	break;
    }

  if (c == EOF && cs == s)
    return (NULL);

  *cs++ = '\0';

  if (debug)
    {
      if (!cred.guest && strncasecmp ("pass ", s, 5) == 0)
	{
	  /* Don't syslog passwords.  */
	  syslog (LOG_DEBUG, "command: %.5s ???", s);
	}
      else
	{
	  register char *cp;
	  register int len;

	  /* Don't syslog trailing CR-LF.  */
	  len = strlen (s);
	  cp = s + len - 1;

	  while (cp >= s && (*cp == '\n' || *cp == '\r'))
	    {
	      --cp;
	      --len;
	    }

	  syslog (LOG_DEBUG, "command: %.*s", len, s);
	}
    }
  return (s);
}

void
toolong (int signo)
{
  (void) signo;
  reply (421, "Timeout (%d seconds): closing control connection.",
	 timeout);
  if (logging)
    syslog (LOG_INFO, "User %s timed out after %d seconds",
	    (cred.name ? cred.name : "unknown"), timeout);
  dologout (1);
}

static int
yylex (void)
{
  static int cpos, state;
  char *cp, *cp2;
  struct tab *p;
  int n;
  char c;

  for (;;)
    {
      switch (state)
	{
	case CMD:
	  signal (SIGALRM, toolong);
	  alarm ((unsigned) timeout);
	  if (telnet_fgets (cbuf, sizeof (cbuf)-1, stdin) == NULL)
	    {
	      reply (221, "You could at least say goodbye.");
	      dologout (0);
	    }
	  alarm (0);

#ifdef HAVE_SETPROCTITLE
	  if (strncasecmp (cbuf, "PASS", 4) != 0)
	    setproctitle ("%s: %s", proctitle, cbuf);
#endif /* HAVE_SETPROCTITLE */

	  cp = strchr (cbuf, '\r');
	  if (cp)
	    {
	      *cp++ = '\n';
	      *cp = '\0';
	    }

	  cp = strpbrk (cbuf, " \n");
	  if (cp)
	    cpos = cp - cbuf;

	  if (cpos == 0)
	    cpos = 4;

	  c = cbuf[cpos];
	  cbuf[cpos] = '\0';
	  upper (cbuf);
	  p = lookup (cmdtab, cbuf);
	  cbuf[cpos] = c;

	  if (p != 0)
	    {
	      if (p->implemented == 0)
		{
		  nack (p->name);
		  longjmp (errcatch, 0);
		  /* NOTREACHED */
		}
	      state = p->state;
	      yylval.s = (char*) p->name;
	      return (p->token);
	    }
	  break;	/* Command not known.  */

	case SITECMD:
	  if (cbuf[cpos] == ' ')
	    {
	      cpos++;
	      return (SP);
	    }
	  cp = &cbuf[cpos];

	  cp2 = strpbrk (cp, " \n");
	  if (cp2)
	    cpos = cp2 - cbuf;

	  c = cbuf[cpos];
	  cbuf[cpos] = '\0';
	  upper (cp);
	  p = lookup (sitetab, cp);
	  cbuf[cpos] = c;

	  if (p != 0)
	    {
	      if (p->implemented == 0)
		{
		  state = CMD;
		  nack (p->name);
		  longjmp (errcatch, 0);
		  /* NOTREACHED */
		}

	      state = p->state;
	      yylval.s = (char*) p->name;
	      return (p->token);
	    }
	  state = CMD;
	  break;	/* Command not known.  */

	case OSTR:
	  if (cbuf[cpos] == '\n')
	    {
	      state = CMD;
	      return (CRLF);
	    }

	case STR1:
	case ZSTR1:
	dostr1:
	  if (cbuf[cpos] == ' ')
	    {
	      cpos++;
	      if (state == OSTR)
		state = STR2;
	      else
		++state;

	      return (SP);
	    }
	  /* Intentional continuation.  */

	case ZSTR2:
	  if (cbuf[cpos] == '\n')
	    {
	      state = CMD;
	      return (CRLF);
	    }

	case STR2:
	  cp = &cbuf[cpos];
	  n = strlen (cp);
	  cpos += n - 1;
	  /*
	   * Make sure the string is nonempty and newline terminated.
	   */
	  if (n > 1 && cbuf[cpos] == '\n')
	    {
	      cbuf[cpos] = '\0';
	      yylval.s = copy (cp);
	      cbuf[cpos] = '\n';
	      state = ARGS;
	      return (STRING);
	    }
	  break;	/* Empty string, missing NL.  */

	case NSTR:
	  if (cbuf[cpos] == ' ')
	    {
	      cpos++;
	      return (SP);
	    }
	  if (isdigit (cbuf[cpos]))
	    {
	      cp = &cbuf[cpos];
	      while (isdigit (cbuf[++cpos]))
		;

	      c = cbuf[cpos];
	      cbuf[cpos] = '\0';
	      yylval.i = atoi (cp);
	      cbuf[cpos] = c;
	      state = STR1;
	      return (NUMBER);
	    }
	  state = STR1;
	  goto dostr1;

	case DLIST:
	  /* Either numerical strings or
	   * address strings for IPv4 and IPv6.
	   * The consist of hexadecimal chars,
	   * colon and periods.  A period can
	   * not begin a valid address.  */
	  if (isxdigit (cbuf[cpos]) || cbuf[cpos] == ':')
	    {
	      int is_num = 1;	/* Only to turn off.  */

	      cp = &cbuf[cpos];
	      while (isxdigit (cbuf[cpos])
		     || cbuf[cpos] == ':'
		     || cbuf[cpos] == '.')
		{
		  if (!isdigit (cbuf[cpos]))
		    is_num = 0;
		  cpos++;
		}

	      c = cbuf[cpos];
	      cbuf[cpos] = '\0';
	      if (is_num)
		{
		  yylval.i = atoi (cp);
		  cbuf[cpos] = c;
		  return (NUMBER);
		}
	      else
		{
		  yylval.s = copy (cp);
		  cbuf[cpos] = c;
		  return (STRING);
		}
	    }

	  c = cbuf[cpos++];
	  switch (c)
	    {
	    case ' ':
	      return (SP);

	    case '\n':
	      state = CMD;
	      return (CRLF);

	    default:
	      yylval.i = c;
	      return (CHAR);
	    }
	  break;	/* Not reachable.  */

	case ARGS:
	  if (isdigit (cbuf[cpos]))
	    {
	      cp = &cbuf[cpos];
	      while (isdigit (cbuf[++cpos]))
		;

	      c = cbuf[cpos];
	      cbuf[cpos] = '\0';
	      yylval.i = strtoimax (cp, NULL, 10);	/* off_t */
	      cbuf[cpos] = c;
	      return (NUMBER);
	    }

	  switch (cbuf[cpos++])
	    {
	    case '\n':
	      state = CMD;
	      return (CRLF);

	    case ' ':
	      return (SP);

	    case ',':
	      return (COMMA);

	    case 'A':
	    case 'a':
	      return (A);

	    case 'B':
	    case 'b':
	      return (B);

	    case 'C':
	    case 'c':
	      return (C);

	    case 'E':
	    case 'e':
	      return (E);

	    case 'F':
	    case 'f':
	      return (F);

	    case 'I':
	    case 'i':
	      return (I);

	    case 'L':
	    case 'l':
	      return (L);

	    case 'N':
	    case 'n':
	      return (N);

	    case 'P':
	    case 'p':
	      return (P);

	    case 'R':
	    case 'r':
	      return (R);

	    case 'S':
	    case 's':
	      return (S);

	    case 'T':
	    case 't':
	      return (T);
	    }
	  break;	/* No number, not in [\n ,aAbBcCeEfFiIlLnNpPrRsSttT] */

	default:
	  fatal ("Unknown state in scanner.");
	}

      /*
       * Analysis: Cases when this point is reached.
       *
       *  CMD:      command not known
       *  SITECMD:  site command not known (state changed to CMD)
       *
       *  OSTR, STR1, ZSTR1, STR2, ZSTR2, NSTR:
       *            empty string or string without NL
       *
       *  ARGS:     not a number, not a special character
       */

      /*
       * Issue a new error message only if the parser has not
       * yet reported a complaint.  Without this precaution
       * two messages would be directed to the client, thus
       * upsetting all following exchange.
       */
      if (!yynerrs)
	yyerror ("command not recognized");

      state = CMD;
      longjmp (errcatch, 0);
    } /* for (;;) */
}

void
upper (char *s)
{
  while (*s != '\0')
    {
      if (islower (*s))
	*s = toupper (*s);
      s++;
    }
}

static char *
copy (char *s)
{
  char *p;

  p = malloc (strlen (s) + 1);
  if (p == NULL)
    fatal ("Ran out of memory.");

  strcpy (p, s);
  return (p);
}

static void
help (struct tab *ctab, char *s)
{
  struct tab *c;
  int width, NCMDS;
  const char *help_type;

  if (ctab == sitetab)
    help_type = "SITE ";
  else
    help_type = "";

  width = 0, NCMDS = 0;
  for (c = ctab; c->name != NULL; c++)
    {
      int len = strlen (c->name);

      if (len > width)
	width = len;

      NCMDS++;
    }

  width = (width + 8) &~ 7;

  if (s == 0)
    {
      int i, j, w;
      int columns, lines;

      lreply (214, "The following %scommands are recognized %s.",
	      help_type, "(* =>'s unimplemented)");

      columns = 76 / width;
      if (columns == 0)
	columns = 1;

      lines = (NCMDS + columns - 1) / columns;

      for (i = 0; i < lines; i++)
	{
	  printf ("   ");
	  for (j = 0; j < columns; j++)
	    {
	      c = ctab + j * lines + i;
	      printf ("%s%c", c->name, c->implemented ? ' ' : '*');

	      if (c + lines >= &ctab[NCMDS])
		break;

	      w = strlen (c->name) + 1;
	      while (w < width)
		{
		  putchar (' ');
		  w++;
		}
	    }
	  printf ("\r\n");
	}
      fflush (stdout);
      reply (214, "Direct comments to ftp-bugs@%s.", hostname);
      return;
    }

  upper (s);

  c = lookup (ctab, s);
  if (c == (struct tab *) 0)
    {
      reply (502, "Unknown command %s.", s);
      return;
    }

  if (c->implemented)
    reply (214, "Syntax: %s%s %s", help_type, c->name, c->help);
  else
    reply (214, "%s%-*s\t%s; unimplemented.", help_type,
	   width, c->name, c->help);
}

static void
sizecmd (char *filename)
{
  switch (type)
    {
    case TYPE_L:
    case TYPE_I:
      {
	struct stat stbuf;

	if (stat (filename, &stbuf) < 0 || !S_ISREG (stbuf.st_mode))
	  reply (550, "%s: not a plain file.", filename);
	else
	  reply (213, "%ju", (uintmax_t) stbuf.st_size);
	break;
      }

    case TYPE_A:
      {
	FILE *fin;
	int c;
	off_t count;
	struct stat stbuf;

	fin = fopen (filename, "r");
	if (fin == NULL)
	  {
	    perror_reply (550, filename);
	    return;
	  }

	if (fstat (fileno (fin), &stbuf) < 0 || !S_ISREG (stbuf.st_mode))
	  {
	    reply (550, "%s: not a plain file.", filename);
	    fclose (fin);
	    return;
	  }

	count = 0;
	while ((c = getc (fin)) != EOF)
	  {
	    if (c == '\n')	/* will get expanded to \r\n */
	      count++;
	    count++;
	  }
	fclose (fin);

	reply (213, "%jd", (intmax_t) count);
	break;
      }

    default:
      reply (504, "SIZE not implemented for Type %c.", "?AEIL"[type]);
    }
}

static void
yyerror (const char *s)
{
  char *cp;

  cp = strchr (cbuf, '\n');
  if (cp != NULL)
    *cp = '\0';

  reply (500, "'%s': %s", cbuf, (s ? s : "command not understood."));
}
#line 1280 "ftpcmd.c"

#if YYDEBUG
#include <stdio.h>	/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == 0)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == 0)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yym = 0;
    yyn = 0;
    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        yychar = YYLEX;
        if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if (((yyn = yysindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if (((yyn = yyrindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag != 0) goto yyinrecovery;

    YYERROR_CALL("syntax error");

    goto yyerrlab; /* redundant goto avoids 'unused label' warning */
yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if (((yyn = yysindex[*yystack.s_mark]) != 0) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym > 0)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);

    switch (yyn)
    {
case 2:
#line 190 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			free (fromname);
			fromname = (char *) 0;
			restart_point = (off_t) 0;
		}
break;
case 4:
#line 200 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			user (yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 5:
#line 205 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			pass (yystack.l_mark[-1].s);
			memset (yystack.l_mark[-1].s, 0, strlen (yystack.l_mark[-1].s));
			free (yystack.l_mark[-1].s);
		}
break;
case 6:
#line 211 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i)
			  {
			    if (yystack.l_mark[-1].i
				&& ((his_addr.ss_family == AF_INET
				     && memcmp (&((struct sockaddr_in *) &his_addr)->sin_addr,
						&((struct sockaddr_in *) &data_dest)->sin_addr,
						sizeof (struct in_addr))
					== 0
				     && ntohs (((struct sockaddr_in *) &data_dest)->sin_port)
					> IPPORT_RESERVED)
				    ||
				    (his_addr.ss_family == AF_INET6
				     && memcmp (&((struct sockaddr_in6 *) &his_addr)->sin6_addr,
						&((struct sockaddr_in6 *) &data_dest)->sin6_addr,
						sizeof (struct in6_addr))
					== 0
				     && ntohs (((struct sockaddr_in6 *) &data_dest)->sin6_port)
					> IPPORT_RESERVED)
				   )
			       )
			      {
				usedefault = 0;
				if (pdata >= 0)
				  {
				    close (pdata);
				    pdata = -1;
				  }
				reply (200, "PORT command successful.");
			      }
			    else
			      {
				usedefault = 1;
				memset (&data_dest, 0, sizeof (data_dest));
				reply (500, "Illegal PORT Command");
			      }
			  }
		}
break;
case 7:
#line 250 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-1].i)
			  passive (PASSIVE_PASV, AF_INET);
		}
break;
case 8:
#line 255 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			switch (cmd_type)
			  {
			  case TYPE_A:
			    if (cmd_form == FORM_N)
			      {
				reply (200, "Type set to A.");
				type = cmd_type;
				form = cmd_form;
			      }
			    else
			      reply (504, "Form must be N.");
			    break;

			  case TYPE_E:
			    reply (504, "Type E not implemented.");
			    break;

			  case TYPE_I:
			    reply (200, "Type set to I.");
			    type = cmd_type;
			    break;

			  case TYPE_L:
#if defined NBBY && NBBY == 8
			    if (cmd_bytesz == 8)
			      {
				reply (200, "Type set to L (byte size 8).");
				type = cmd_type;
			      }
			    else
			      reply (504, "Byte size must be 8.");
#else /* NBBY == 8 */
			  UNIMPLEMENTED for NBBY != 8
#endif /* NBBY == 8 */
			  }
		}
break;
case 9:
#line 293 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			switch (yystack.l_mark[-1].i)
			  {
			  case STRU_F:
			    reply (200, "STRU F ok.");
			    break;

			  default:
			    reply (504, "Unimplemented STRU type.");
			  }
		}
break;
case 10:
#line 305 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			switch (yystack.l_mark[-1].i)
			  {
			  case MODE_S:
			    reply (200, "MODE S ok.");
			    break;

			  default:
			    reply (502, "Unimplemented MODE type.");
			  }
		}
break;
case 11:
#line 317 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			reply (202, "ALLO command ignored.");
		}
break;
case 12:
#line 321 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			reply (202, "ALLO command ignored.");
		}
break;
case 13:
#line 325 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  retrieve ((char *) 0, yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 14:
#line 331 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  store (yystack.l_mark[-1].s, "w", 0);
			free (yystack.l_mark[-1].s);
		}
break;
case 15:
#line 337 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  store (yystack.l_mark[-1].s, "a", 0);
			free (yystack.l_mark[-1].s);
		}
break;
case 16:
#line 343 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-1].i)
			  send_file_list (".");
		}
break;
case 17:
#line 348 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  send_file_list (yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 18:
#line 354 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-1].i)
			  retrieve ("/bin/ls -lgA", "");
		}
break;
case 19:
#line 359 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  retrieve ("/bin/ls -lgA %s", yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 20:
#line 365 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  statfilecmd (yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 21:
#line 371 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			statcmd ();
		}
break;
case 22:
#line 375 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  delete (yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 23:
#line 381 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i)
			  {
			    if (fromname)
			      {
				renamecmd (fromname, yystack.l_mark[-1].s);
				free (fromname);
				fromname = (char *) 0;
			      }
			    else
			      reply (503, "Bad sequence of commands.");
			  }
			free (yystack.l_mark[-1].s);
		}
break;
case 24:
#line 396 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			reply (225, "ABOR command successful.");
		}
break;
case 25:
#line 400 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-1].i)
			  cwd (cred.homedir);
		}
break;
case 26:
#line 405 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  cwd (yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 27:
#line 411 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			help (cmdtab, (char *) 0);
		}
break;
case 28:
#line 415 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			char *cp = yystack.l_mark[-1].s;

			if (strncasecmp (cp, "SITE", 4) == 0)
			  {
			    cp = yystack.l_mark[-1].s + 4;
			    if (*cp == ' ')
			      cp++;
			    if (*cp)
			      help (sitetab, cp);
			    else
			      help (sitetab, (char *) 0);
			  }
			else
			  help (cmdtab, yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 29:
#line 433 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			reply (200, "NOOP command successful.");
		}
break;
case 30:
#line 437 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  makedir (yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 31:
#line 443 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  removedir (yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 32:
#line 449 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-1].i)
			  pwd ();
		}
break;
case 33:
#line 454 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-1].i)
			  cwd ("..");
		}
break;
case 34:
#line 459 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-1].i)
			  {
			    char **name;

			    lreply (211, "Supported extensions:");
			    for (name = extlist; *name; name++)
			      printf (" %s\r\n", *name);
			    reply (211, "End");
			  }
		}
break;
case 35:
#line 472 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i)
			  {
			    reply (501, "Not accepting arguments.");
			    free (yystack.l_mark[-1].s);
			  }
		}
break;
case 36:
#line 484 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-1].i)
			  {
			    reply (501, "Must have an argument.");
			  }
		}
break;
case 37:
#line 491 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i)
			  {
			    reply (501, "No options are available.");
			    free (yystack.l_mark[-1].s);
			  }
		}
break;
case 38:
#line 499 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			help (sitetab, (char *) 0);
		}
break;
case 39:
#line 503 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			help (sitetab, yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 40:
#line 508 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			int oldmask;

			if (yystack.l_mark[-1].i)
			  {
			    oldmask = umask (0);
			    umask (oldmask);
			    reply (200, "Current UMASK is %03o", oldmask);
			  }
		}
break;
case 41:
#line 519 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			int oldmask;

			if (yystack.l_mark[-3].i)
			  {
			    if ((yystack.l_mark[-1].i == -1) || (yystack.l_mark[-1].i > 0777))
			      reply (501, "Bad UMASK value");
			    else
			      {
				oldmask = umask (yystack.l_mark[-1].i);
				reply (200, "UMASK set to %03o (was %03o)",
				      yystack.l_mark[-1].i, oldmask);
			      }
			  }
		}
break;
case 42:
#line 535 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-5].i && (yystack.l_mark[-1].s != NULL))
			  {
			    if (yystack.l_mark[-3].i > 0777)
			      reply (501,
				     "CHMOD: Mode value must be between 0 and 0777");
			    else if (chmod (yystack.l_mark[-1].s, yystack.l_mark[-3].i) < 0)
			      perror_reply (550, yystack.l_mark[-1].s);
			    else
			      reply (200, "CHMOD command successful.");
			  }
			free (yystack.l_mark[-1].s);
		}
break;
case 43:
#line 549 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			reply (200,
			       "Current IDLE time limit is %d seconds; max %d",
			       timeout, maxtimeout);
		}
break;
case 44:
#line 555 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i)
			  {
			    if (yystack.l_mark[-1].i < 30 || yystack.l_mark[-1].i > maxtimeout)
			      reply (501,
				     "Maximum IDLE time must be between 30 and %d seconds",
				     maxtimeout);
			    else
			      {
				timeout = yystack.l_mark[-1].i;
				alarm ((unsigned) timeout);
				reply (200,
				       "Maximum IDLE time set to %d seconds",
				       timeout);
			      }
			  }
		}
break;
case 45:
#line 573 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  store (yystack.l_mark[-1].s, "w", 1);
			free (yystack.l_mark[-1].s);
		}
break;
case 46:
#line 579 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
		        const char *sys_type; /* Official rfc-defined os type.  */
			char *version = 0; /* A more specific type. */

#ifdef HAVE_UNAME
			struct utsname u;

			if (uname (&u) >= 0)
			  {
			    version = malloc (strlen (u.sysname) + 1
					      + strlen (u.release) + 1);
			    if (version)
			      sprintf (version, "%s %s", u.sysname, u.release);
			  }
#else /* !HAVE_UNAME */
# ifdef BSD
			version = "BSD";
# endif /* BSD */
#endif /* !HAVE_UNAME */

#if defined unix || defined __unix || defined __unix__ || defined __CYGWIN__
			sys_type = "UNIX";
#else
			sys_type = "UNKNOWN";
#endif

			if (!no_version && version)
			  reply (215, "%s Type: L%d Version: %s",
				 sys_type, NBBY, version);
			else
			  reply (215, "%s Type: L%d", sys_type, NBBY);

#ifdef HAVE_UNAME
			free (version);
#endif
		}
break;
case 47:
#line 623 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  sizecmd (yystack.l_mark[-1].s);
			free (yystack.l_mark[-1].s);
		}
break;
case 48:
#line 638 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s != NULL)
			  {
			    struct stat stbuf;

			    if (stat (yystack.l_mark[-1].s, &stbuf) < 0)
			      reply (550, "%s: %s", yystack.l_mark[-1].s, strerror (errno));
			    else if (!S_ISREG (stbuf.st_mode))
			      reply (550, "%s: not a plain file.", yystack.l_mark[-1].s);
			    else
			      {
				struct tm *t;

				t = gmtime (&stbuf.st_mtime);
				reply (213,
				       "%04d%02d%02d%02d%02d%02d",
				       1900 + t->tm_year, t->tm_mon+1,
				       t->tm_mday, t->tm_hour,
				       t->tm_min, t->tm_sec);
			      }
			  }
			free (yystack.l_mark[-1].s);
		}
break;
case 49:
#line 666 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			usedefault = 0;
			if (pdata >= 0)
			  {
			    close (pdata);
			    pdata = -1;
			  }
			/* A first sanity check.  */
			if (yystack.l_mark[-9].i				/* valid login */
			    && (yystack.l_mark[-6].i > 0)			/* valid protocols */
			    && (yystack.l_mark[-7].i > 32 && yystack.l_mark[-7].i < 127)	/* legal first delimiter */
							/* identical delimiters */
			    && (yystack.l_mark[-7].i == yystack.l_mark[-5].i && yystack.l_mark[-7].i == yystack.l_mark[-3].i && yystack.l_mark[-7].i == yystack.l_mark[-1].i))
			  {
			    /* We only accept connections using
			     * the same address family as is
			     * currently in use, unless we
			     * detect IPv4-mapped-to-IPv6.
			     */
			    if (his_addr.ss_family == yystack.l_mark[-6].i
				|| (yystack.l_mark[-6].i == AF_INET6
				    && his_addr.ss_family == AF_INET)
				|| (yystack.l_mark[-6].i == AF_INET
				    && his_addr.ss_family == AF_INET6))
			      {
				int err;
				char p[8];
				struct addrinfo hints, *res;

				memset (&hints, 0, sizeof (hints));
				snprintf (p, sizeof (p), "%jd", yystack.l_mark[-2].i & 0xffff);
				hints.ai_family = yystack.l_mark[-6].i;
				hints.ai_socktype = SOCK_STREAM;
				hints.ai_flags = AI_NUMERICHOST | AI_NUMERICSERV;

				err = getaddrinfo (yystack.l_mark[-4].s, p, &hints, &res);
				if (err)
				  reply (500, "Illegal EPRT Command");
				else if (/* sanity check */
					 (his_addr.ss_family == AF_INET
					  && memcmp (&((struct sockaddr_in *) &his_addr)->sin_addr,
						     &((struct sockaddr_in *) res->ai_addr)->sin_addr,
						     sizeof (struct in_addr))
					     == 0
					  && ntohs (((struct sockaddr_in *) res->ai_addr)->sin_port)
					     > IPPORT_RESERVED
					 )
					 ||
					 (his_addr.ss_family == AF_INET6
					  && memcmp (&((struct sockaddr_in6 *) &his_addr)->sin6_addr,
						     &((struct sockaddr_in6 *) res->ai_addr)->sin6_addr,
						     sizeof (struct in6_addr))
					     == 0
					  && ntohs (((struct sockaddr_in6 *) res->ai_addr)->sin6_port)
					     > IPPORT_RESERVED
					 )
					 ||
					 (his_addr.ss_family == AF_INET
					  && res->ai_family == AF_INET6
					  && IN6_IS_ADDR_V4MAPPED (&((struct sockaddr_in6 *) res->ai_addr)->sin6_addr)
					  && memcmp (&((struct sockaddr_in *) &his_addr)->sin_addr,
						     &((struct in_addr *) &((struct sockaddr_in6 *) res->ai_addr)->sin6_addr)[3],
						     sizeof (struct in_addr))
					     == 0
					  && ntohs (((struct sockaddr_in6 *) res->ai_addr)->sin6_port)
					     > IPPORT_RESERVED
					 )
					 ||
					 (his_addr.ss_family == AF_INET6
					  && res->ai_family == AF_INET
					  && IN6_IS_ADDR_V4MAPPED (&((struct sockaddr_in6 *) &his_addr)->sin6_addr)
					  && memcmp (&((struct in_addr *) &((struct sockaddr_in6 *) &his_addr)->sin6_addr)[3],
						     &((struct sockaddr_in *) res->ai_addr)->sin_addr,
						     sizeof (struct in_addr))
					     == 0
					  && ntohs (((struct sockaddr_in *) res->ai_addr)->sin_port)
					     > IPPORT_RESERVED
					 )
					)
				  {
				    /* In the case of IPv4 mapped as IPv6,
				     * the addresses were proven to coincide,
				     * only the extraction remains.
				     * Since non-mapped is the standard,
				     * test that situation first.
				     */
				    if (his_addr.ss_family == res->ai_family)
				      {
					memcpy (&data_dest, res->ai_addr,
						res->ai_addrlen);
					data_dest_len = res->ai_addrlen;
				      }
				    else if (his_addr.ss_family == AF_INET
					     && res->ai_family == AF_INET6)
				      {
					/* `his_addr' contains the reduced
					 * IPv4 address.
					 */
					memcpy (&data_dest, &his_addr,
						sizeof (struct sockaddr_in));
					data_dest_len =
					  sizeof (struct sockaddr_in);
					((struct sockaddr_in *) &data_dest)->sin_port =
					  ((struct sockaddr_in6 *) res->ai_addr)->sin6_port;
				      }
				    else
				      {
					/* `res->ai_addr' contains the reduced
					 * IPv4 address, but the connection
					 * stands on `his_addr', which is
					 * an IPv4-to-IPv6-mapped address.
					 */
					memcpy (&data_dest, &his_addr,
						sizeof (struct sockaddr_in6));
					data_dest_len =
					  sizeof (struct sockaddr_in6);
					((struct sockaddr_in6 *) &data_dest)->sin6_port =
					  ((struct sockaddr_in *) res->ai_addr)->sin_port;
				      }

				    freeaddrinfo (res);
				    reply (200, "EPRT command successful.");
				  }
				else
				  {
				    /* failed identity check */
				    if (res)
				      freeaddrinfo (res);
				    reply (500, "Illegal EPRT Command");
				  }
			      }
			    else
			      /* Not fit for established connection.  */
			      reply (522,
				     "Network protocol not supported, use (%d)",
				     (yystack.l_mark[-6].i == 1) ? 2 : 1);
			  }
			else if (yystack.l_mark[-9].i && (yystack.l_mark[-6].i <= 0))
			    reply (522,
				   "Network protocol not supported, use (1,2)");
			else if (yystack.l_mark[-9].i)
			  /* Incorrect delimiters detected,
			   * the other conditions are met.
			   */
			  reply (500, "Illegal EPRT Command");
		}
break;
case 50:
#line 817 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-1].i)
			  passive (PASSIVE_EPSV, AF_UNSPEC);
		}
break;
case 51:
#line 822 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i)
			  {
			    if (yystack.l_mark[-1].i > 0)
			      passive (PASSIVE_EPSV, yystack.l_mark[-1].i);
			    else
			      reply (522,
				     "Network protocol not supported, use (1,2)");
			  }
		}
break;
case 52:
#line 837 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-3].i)
			  {
			    if (yystack.l_mark[-1].i &&
				((his_addr.ss_family == AF_INET
				  && memcmp (&((struct sockaddr_in *) &his_addr)->sin_addr,
					     &((struct sockaddr_in *) &data_dest)->sin_addr,
					     sizeof (struct in_addr)) == 0
				  && ntohs (((struct sockaddr_in *) &data_dest)->sin_port)
					> IPPORT_RESERVED)
				 ||
				 (his_addr.ss_family == AF_INET6
				  && memcmp (&((struct sockaddr_in6 *) &his_addr)->sin6_addr,
					     &((struct sockaddr_in6 *) &data_dest)->sin6_addr,
					     sizeof (struct in6_addr)) == 0
				  && ntohs (((struct sockaddr_in6 *) &data_dest)->sin6_port)
					> IPPORT_RESERVED)
				)
			       )
			      {
				usedefault = 0;
				if (pdata >= 0)
				  {
				    close (pdata);
				    pdata = -1;
				  }
				  reply (200, "LPRT command successful.");
			      }
			    else
			      {
				usedefault = 1;
				memset (&data_dest, 0, sizeof (data_dest));
				reply (500, "Illegal LPRT Command");
			      }
			  } /* check_login */
		}
break;
case 53:
#line 878 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (yystack.l_mark[-1].i)
			  passive (PASSIVE_LPSV, 0 /* not used */);
		}
break;
case 54:
#line 884 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			reply (221, "Goodbye.");
			dologout (0);
		}
break;
case 55:
#line 889 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyerrok;
		}
break;
case 56:
#line 895 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			restart_point = (off_t) 0;
			if (yystack.l_mark[-3].i && yystack.l_mark[-1].s)
			  {
			    free (fromname);
			    fromname = renamefrom (yystack.l_mark[-1].s);
			  }
			if (fromname == (char *) 0 && yystack.l_mark[-1].s)
			  free (yystack.l_mark[-1].s);
		}
break;
case 57:
#line 910 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
		        free (fromname);
			fromname = (char *) 0;
			restart_point = yystack.l_mark[-1].i;
			reply (350, "Restarting at %jd. %s",
			       (intmax_t) restart_point,
			       "Send STORE or RETRIEVE to initiate transfer.");
		}
break;
case 59:
#line 926 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyval.s = (char *) calloc (1, sizeof (char));
		}
break;
case 62:
#line 938 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			/* Rewrite as valid address family.  */
			if (yystack.l_mark[0].i == 1)
			  yyval.i = AF_INET;
			else if (yystack.l_mark[0].i == 2)
			  yyval.i = AF_INET6;
			else
			  yyval.i = -1;	/* Invalid protocol.  */
		}
break;
case 65:
#line 960 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			int err;
			char a[INET6_ADDRSTRLEN], p[8];
			struct addrinfo hints, *res;

			snprintf (a, sizeof (a), "%jd.%jd.%jd.%jd",
				  yystack.l_mark[-10].i & 0xff, yystack.l_mark[-8].i & 0xff,
				  yystack.l_mark[-6].i & 0xff, yystack.l_mark[-4].i & 0xff);
			snprintf (p, sizeof (p), "%jd",
				  ((yystack.l_mark[-2].i & 0xff) << 8) + (yystack.l_mark[0].i & 0xff));
			memset (&hints, 0, sizeof (hints));
			hints.ai_family = his_addr.ss_family;
			hints.ai_socktype = SOCK_STREAM;
			hints.ai_flags = AI_NUMERICHOST | AI_NUMERICSERV;

			if (his_addr.ss_family == AF_INET6)
			  {
			    /* IPv4 mapped to IPv6.  */
			    hints.ai_family = AF_INET6;
#ifdef AI_V4MAPPED
			    hints.ai_flags |= AI_V4MAPPED;
#endif
			    snprintf (a, sizeof (a),
				      "::ffff:%jd.%jd.%jd.%jd",
				      yystack.l_mark[-10].i & 0xff, yystack.l_mark[-8].i & 0xff,
				      yystack.l_mark[-6].i & 0xff, yystack.l_mark[-4].i & 0xff);
			  }

			err = getaddrinfo (a, p, &hints, &res);
			if (err)
			  {
			    reply (550, "Address failure: %s,%s", a, p);
			    memset (&data_dest, 0, sizeof (data_dest));
			    data_dest_len = 0;
			    yyval.i = 0;
			  }
			else
			  {
			    memcpy (&data_dest, res->ai_addr, res->ai_addrlen);
			    data_dest_len = res->ai_addrlen;
			    freeaddrinfo (res);
			    yyval.i = 1;
			  }
		}
break;
case 66:
#line 1010 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			int err;
			char a[INET6_ADDRSTRLEN], p[8];
			struct addrinfo hints, *res;

			/* Well formed input for IPv4?  */
			if (yystack.l_mark[-16].i != 4 || yystack.l_mark[-14].i != 4 || yystack.l_mark[-4].i != 2
			    || yystack.l_mark[-12].i < 0 || yystack.l_mark[-12].i > 255 || yystack.l_mark[-10].i < 0 || yystack.l_mark[-10].i > 255
			    || yystack.l_mark[-8].i < 0 || yystack.l_mark[-8].i > 255 || yystack.l_mark[-6].i < 0 || yystack.l_mark[-6].i > 255
			    || yystack.l_mark[-2].i < 0 || yystack.l_mark[-2].i > 255
			    || yystack.l_mark[0].i < 0 || yystack.l_mark[0].i > 255)
			  {
			    reply (500, "Invalid address.");
			    memset (&data_dest, 0, sizeof (data_dest));
			    data_dest_len = 0;
			    yyval.i = 0;
			  }
			else
			  {
			    snprintf (a, sizeof (a), "%jd.%jd.%jd.%jd",
				      yystack.l_mark[-12].i, yystack.l_mark[-10].i, yystack.l_mark[-8].i, yystack.l_mark[-6].i);
			    snprintf (p, sizeof (p), "%jd", (yystack.l_mark[-2].i << 8) + yystack.l_mark[0].i);

			    memset (&hints, 0, sizeof (hints));
			    hints.ai_family = his_addr.ss_family;
			    hints.ai_socktype = SOCK_STREAM;
			    hints.ai_flags = AI_NUMERICHOST | AI_NUMERICSERV;

			    if (his_addr.ss_family == AF_INET6)
			      {
				/* IPv4 mapped to IPv6.  */
				hints.ai_family = AF_INET6;
#ifdef AI_V4MAPPED
				hints.ai_flags |= AI_V4MAPPED;
#endif
				snprintf (a, sizeof (a),
					  "::ffff:%jd.%jd.%jd.%jd",
					  yystack.l_mark[-12].i, yystack.l_mark[-10].i, yystack.l_mark[-8].i, yystack.l_mark[-6].i);
			      }

			    err = getaddrinfo (a, p, &hints, &res);
			    if (err)
			      {
				reply (550, "LPRT address failure: %s,%s",
				       a, p);
				memset (&data_dest, 0, sizeof (data_dest));
				data_dest_len = 0;
				yyval.i = 0;
			      }
			    else
			      {
				memcpy (&data_dest, res->ai_addr,
					res->ai_addrlen);
				data_dest_len = res->ai_addrlen;
				freeaddrinfo (res);
				yyval.i = 1;
			      }
			  }
		}
break;
case 67:
#line 1075 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			int err;
			char a[INET6_ADDRSTRLEN], p[8];
			struct addrinfo hints, *res;

			/* Well formed input for IPv6?  */
			if (yystack.l_mark[-40].i != 6 || yystack.l_mark[-38].i != 16 || yystack.l_mark[-4].i != 2
			    || yystack.l_mark[-36].i < 0 || yystack.l_mark[-36].i > 255 || yystack.l_mark[-34].i < 0 || yystack.l_mark[-34].i > 255
			    || yystack.l_mark[-32].i < 0 || yystack.l_mark[-32].i > 255 || yystack.l_mark[-30].i < 0 || yystack.l_mark[-30].i > 255
			    || yystack.l_mark[-28].i < 0 || yystack.l_mark[-28].i > 255 || yystack.l_mark[-26].i < 0 || yystack.l_mark[-26].i > 255
			    || yystack.l_mark[-24].i < 0 || yystack.l_mark[-24].i > 255 || yystack.l_mark[-22].i < 0 || yystack.l_mark[-22].i > 255
			    || yystack.l_mark[-20].i < 0 || yystack.l_mark[-20].i > 255 || yystack.l_mark[-18].i < 0 || yystack.l_mark[-18].i > 255
			    || yystack.l_mark[-16].i < 0 || yystack.l_mark[-16].i > 255 || yystack.l_mark[-14].i < 0 || yystack.l_mark[-14].i > 255
			    || yystack.l_mark[-12].i < 0 || yystack.l_mark[-12].i > 255 || yystack.l_mark[-10].i < 0 || yystack.l_mark[-10].i > 255
			    || yystack.l_mark[-8].i < 0 || yystack.l_mark[-8].i > 255 || yystack.l_mark[-6].i < 0 || yystack.l_mark[-6].i > 255
			    || yystack.l_mark[-2].i < 0 || yystack.l_mark[-2].i > 255 || yystack.l_mark[0].i < 0 || yystack.l_mark[0].i > 255)
			  {
			    reply (500, "Invalid address.");
			    memset (&data_dest, 0, sizeof (data_dest));
			    data_dest_len = 0;
			    yyval.i = 0;
			  }
			else
			  {
			    snprintf (a, sizeof (a),
				     "%02jx%02jx:%02jx%02jx:"
				     "%02jx%02jx:%02jx%02jx:"
				     "%02jx%02jx:%02jx%02jx:"
				     "%02jx%02jx:%02jx%02jx",
				      yystack.l_mark[-36].i, yystack.l_mark[-34].i, yystack.l_mark[-32].i, yystack.l_mark[-30].i,
				      yystack.l_mark[-28].i, yystack.l_mark[-26].i, yystack.l_mark[-24].i, yystack.l_mark[-22].i,
				      yystack.l_mark[-20].i, yystack.l_mark[-18].i, yystack.l_mark[-16].i, yystack.l_mark[-14].i,
				      yystack.l_mark[-12].i, yystack.l_mark[-10].i, yystack.l_mark[-8].i, yystack.l_mark[-6].i);
			    snprintf (p, sizeof (p), "%jd",
				      (yystack.l_mark[-2].i << 8) + yystack.l_mark[0].i);

			    memset (&hints, 0, sizeof (hints));
			    hints.ai_family = his_addr.ss_family;
			    hints.ai_socktype = SOCK_STREAM;
			    hints.ai_flags = AI_NUMERICHOST | AI_NUMERICSERV;

			    err = getaddrinfo (a, p, &hints, &res);
			    if (err)
			      {
				reply (550, "LPRT address failure: %s,%s",
				       a, p);
				memset (&data_dest, 0, sizeof (data_dest));
				data_dest_len = 0;
				yyval.i = 0;
			      }
			    else
			      {
				memcpy (&data_dest, res->ai_addr,
					res->ai_addrlen);
				data_dest_len = res->ai_addrlen;
				freeaddrinfo (res);
				yyval.i = 1;
			      }
			  }
		}
break;
case 68:
#line 1139 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyval.i = FORM_N;
		}
break;
case 69:
#line 1143 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyval.i = FORM_T;
		}
break;
case 70:
#line 1147 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyval.i = FORM_C;
		}
break;
case 71:
#line 1154 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			cmd_type = TYPE_A;
			cmd_form = FORM_N;
		}
break;
case 72:
#line 1159 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			cmd_type = TYPE_A;
			cmd_form = yystack.l_mark[0].i;
		}
break;
case 73:
#line 1164 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			cmd_type = TYPE_E;
			cmd_form = FORM_N;
		}
break;
case 74:
#line 1169 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			cmd_type = TYPE_E;
			cmd_form = yystack.l_mark[0].i;
		}
break;
case 75:
#line 1174 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			cmd_type = TYPE_I;
		}
break;
case 76:
#line 1178 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			cmd_type = TYPE_L;
			cmd_bytesz = NBBY;
		}
break;
case 77:
#line 1183 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			cmd_type = TYPE_L;
			cmd_bytesz = yystack.l_mark[0].i;
		}
break;
case 78:
#line 1189 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			cmd_type = TYPE_L;
			cmd_bytesz = yystack.l_mark[0].i;
		}
break;
case 79:
#line 1197 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyval.i = STRU_F;
		}
break;
case 80:
#line 1201 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyval.i = STRU_R;
		}
break;
case 81:
#line 1205 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyval.i = STRU_P;
		}
break;
case 82:
#line 1212 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyval.i = MODE_S;
		}
break;
case 83:
#line 1216 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyval.i = MODE_B;
		}
break;
case 84:
#line 1220 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			yyval.i = MODE_C;
		}
break;
case 85:
#line 1227 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			/*
			 * Problem: this production is used for all pathname
			 * processing, but only gives a 550 error reply.
			 * This is a valid reply in some cases but not in others.
			 */
			if (cred.logged_in && yystack.l_mark[0].s && *yystack.l_mark[0].s == '~')
			  {
			    glob_t gl;
			    int flags = GLOB_NOCHECK;

#ifdef GLOB_BRACE
			    flags |= GLOB_BRACE;
#endif
#ifdef GLOB_QUOTE
			    flags |= GLOB_QUOTE;
#endif
#ifdef GLOB_TILDE
			    flags |= GLOB_TILDE;
#endif

			    memset (&gl, 0, sizeof (gl));
			    if (glob (yystack.l_mark[0].s, flags, NULL, &gl)
				|| gl.gl_pathc == 0)
			      {
				reply (550, "not found");
				yyval.s = NULL;
			      }
			    else
			      yyval.s = strdup (gl.gl_pathv[0]);

			    globfree (&gl);
			    free (yystack.l_mark[0].s);
			  }
			else
			  yyval.s = yystack.l_mark[0].s;
		}
break;
case 87:
#line 1272 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			int ret, dec, multby, digit;

			/*
			 * Convert a number that was read as decimal number
			 * to what it would be if it had been read as octal.
			 */
			dec = yystack.l_mark[0].i;
			multby = 1;
			ret = 0;
			while (dec)
			  {
			    digit = dec % 10;
			    if (digit > 7)
			      {
				ret = -1;
				break;
			      }
			    ret += digit * multby;
			    multby *= 8;
			    dec /= 10;
			  }
			yyval.i = ret;
		}
break;
case 88:
#line 1300 "/home/yano/inetutils-release/inetutils-2.0-1.src/inetutils-2.0-1.i686/src/inetutils-2.0/ftpd/ftpcmd.y"
	{
			if (cred.logged_in)
			  yyval.i = 1;
			else
			  {
			    reply (530, "Please login with USER and PASS.");
			    yyval.i = 0;
			  }
		}
break;
#line 2648 "ftpcmd.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            yychar = YYLEX;
            if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if (((yyn = yygindex[yym]) != 0) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    YYERROR_CALL("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
