/* Copyright (C) 2021-2021 Artifex Software, Inc.
   All Rights Reserved.

   This software is provided AS-IS with no warranty, either express or
   implied.

   This software is distributed under license and may not be copied,
   modified or distributed except as expressly authorized under the terms
   of the license contained in the file LICENSE in this distribution.

   Refer to licensing information at http://www.artifex.com or contact
   Artifex Software, Inc.,  1305 Grant Avenue - Suite 200, Novato,
   CA 94945, U.S.A., +1(415)492-9861, for further information.
*/
#include "pdf_font0.h"

/* Each "value" is actually multiple values (calculated by the Postscript that
   created this table. *Most* are one "real" value and multiple "-1" entries.
   "-1" indicates an empty code. This is to cope with the relatively few cases
   where a CID maps to more than one candidate code point. Handling that gives
   us a better chance of finding a codepoint supported by the TTF cmap table
 */
static const pdfi_cid_decoding_t cns1_unicode = {
  "CNS1", "Unicode",
  74,
  4,
 {
    {{-1, -1, -1, -1}, {32, -1, -1, -1}, {33, -1, -1, -1}, {34, -1, -1, -1}, {35, -1, -1, -1}, {36, -1, -1, -1}, {37, -1, -1, -1}, {38, -1, -1, -1}, {39, -1, -1, -1}, {40, -1, -1, -1}, {41, -1, -1, -1}, {42, -1, -1, -1}, {43, -1, -1, -1}, {44, -1, -1, -1}, {45, -1, -1, -1}, {46, -1, -1, -1}, {47, -1, -1, -1}, {48, -1, -1, -1}, {49, -1, -1, -1}, {50, -1, -1, -1}, {51, -1, -1, -1}, {52, -1, -1, -1}, {53, -1, -1, -1}, {54, -1, -1, -1}, {55, -1, -1, -1}, {56, -1, -1, -1}, {57, -1, -1, -1}, {58, -1, -1, -1}, {59, -1, -1, -1}, {60, -1, -1, -1}, {61, -1, -1, -1}, {62, -1, -1, -1}, {63, -1, -1, -1}, {64, -1, -1, -1}, {65, -1, -1, -1}, {66, -1, -1, -1}, {67, -1, -1, -1}, {68, -1, -1, -1}, {69, -1, -1, -1}, {70, -1, -1, -1}, {71, -1, -1, -1}, {72, -1, -1, -1}, {73, -1, -1, -1}, {74, -1, -1, -1}, {75, -1, -1, -1}, {76, -1, -1, -1}, {77, -1, -1, -1}, {78, -1, -1, -1}, {79, -1, -1, -1}, {80, -1, -1, -1}, {81, -1, -1, -1}, {82, -1, -1, -1}, {83, -1, -1, -1}, {84, -1, -1, -1}, {85, -1, -1, -1}, {86, -1, -1, -1}, {87, -1, -1, -1}, {88, -1, -1, -1}, {89, -1, -1, -1}, {90, -1, -1, -1}, {91, -1, -1, -1}, {92, -1, -1, -1}, {93, -1, -1, -1}, {94, -1, -1, -1}, {95, -1, -1, -1}, {96, -1, -1, -1}, {97, -1, -1, -1}, {98, -1, -1, -1}, {99, -1, -1, -1}, {100, -1, -1, -1}, {101, -1, -1, -1}, {102, -1, -1, -1}, {103, -1, -1, -1}, {104, -1, -1, -1}, {105, -1, -1, -1}, {106, -1, -1, -1}, {107, -1, -1, -1}, {108, -1, -1, -1}, {109, -1, -1, -1}, {110, -1, -1, -1}, {111, -1, -1, -1}, {112, -1, -1, -1}, {113, -1, -1, -1}, {114, -1, -1, -1}, {115, -1, -1, -1}, {116, -1, -1, -1}, {117, -1, -1, -1}, {118, -1, -1, -1}, {119, -1, -1, -1}, {120, -1, -1, -1}, {121, -1, -1, -1}, {122, -1, -1, -1}, {123, -1, -1, -1}, {124, -1, -1, -1}, {125, -1, -1, -1}, {126, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {12288, -1, -1, -1}, {65292, -1, -1, -1}, {12289, -1, -1, -1}, {12290, -1, -1, -1}, {65294, -1, -1, -1}, {8226, -1, -1, -1}, {65307, -1, -1, -1}, {65306, -1, -1, -1}, {65311, -1, -1, -1}, {65281, -1, -1, -1}, {65072, 8229, -1, -1}, {8230, -1, -1, -1}, {8229, -1, -1, -1}, {65104, -1, -1, -1}, {65380, -1, -1, -1}, {65106, -1, -1, -1}, {183, -1, -1, -1}, {65108, -1, -1, -1}, {65109, -1, -1, -1}, {65110, -1, -1, -1}, {65111, -1, -1, -1}, {65372, 8211, -1, -1}, {8211, -1, -1, -1}, {65073, 8212, -1, -1}, {8212, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {65288, -1, -1, -1}, {65289, -1, -1, -1}, {65077, 65288, -1, -1}, {65078, 65289, -1, -1}, {65371, -1, -1, -1}, {65373, -1, -1, -1}, {65079, 65371, -1, -1}, {65080, 65373, -1, -1}, {12308, -1, -1, -1}, {12309, -1, -1, -1}, {65081, 12308, -1, -1}, {65082, 12309, -1, -1}, {12304, -1, -1, -1}, {12305, -1, -1, -1}, {65083, 12304, -1, -1}, {65084, 12305, -1, -1}, {12298, -1, -1, -1}, {12299, -1, -1, -1}, {65085, 12298, -1, -1}, {65086, 12299, -1, -1}, {12296, -1, -1, -1}, {12297, -1, -1, -1}, {65087, 12296, -1, -1}, {65088, 12297, -1, -1}, {12300, -1, -1, -1}, {12301, -1, -1, -1}, {65089, 12300, -1, -1}, {65090, 12301, -1, -1}, {12302, -1, -1, -1}, {12303, -1, -1, -1}, {65091, 12302, -1, -1}, {65092, 12303, -1, -1}, {65113, -1, -1, -1}, {65114, -1, -1, -1}, {65115, -1, -1, -1}, {65116, -1, -1, -1}, {65117, -1, -1, -1}, {65118, -1, -1, -1}, {8216, -1, -1, -1}, {8217, -1, -1, -1}, {8220, -1, -1, -1}, {8221, -1, -1, -1}, {12317, -1, -1, -1}, {12318, -1, -1, -1}, {8245, -1, -1, -1}, {8242, -1, -1, -1}, {65283, -1, -1, -1}, {65286, -1, -1, -1}, {65290, -1, -1, -1}, {8251, -1, -1, -1}, {167, -1, -1, -1}, {12291, -1, -1, -1}, {9675, -1, -1, -1}, {9679, -1, -1, -1}, {9651, -1, -1, -1}, {9650, -1, -1, -1}, {9678, -1, -1, -1}, {9734, -1, -1, -1}, {9733, -1, -1, -1}, {9671, -1, -1, -1}, {9670, -1, -1, -1}, {9633, -1, -1, -1}, {9632, -1, -1, -1}, {9661, -1, -1, -1}, {9660, -1, -1, -1}, {12963, -1, -1, -1}, {8453, -1, -1, -1}, {8254, -1, -1, -1}, {-1, -1, -1, -1}, {65343, -1, -1, -1}, {-1, -1, -1, -1}, {65097, -1, -1, -1}, {65098, -1, -1, -1}, {65101, -1, -1, -1}, {65102, -1, -1, -1}, {65099, -1, -1, -1}, {65100, -1, -1, -1}, {65119, -1, -1, -1}, {65120, -1, -1, -1}, {65121, -1, -1, -1}, {65291, -1, -1, -1}, {65293, -1, -1, -1}, {215, -1, -1, -1}, {247, -1, -1, -1}, {177, -1, -1, -1}, {8730, -1, -1, -1}, {65308, -1, -1, -1}, {65310, -1, -1, -1}, {65309, -1, -1, -1}, {8806, -1, -1, -1}, {8807, -1, -1, -1}, {8800, -1, -1, -1}, {8734, -1, -1, -1}, {8786, -1, -1, -1}, {8801, -1, -1, -1}, {65122, -1, -1, -1}, {65123, -1, -1, -1}, {65124, -1, -1, -1}, {65125, -1, -1, -1}, {65126, -1, -1, -1}, {8764, -1, -1, -1}, {8745, -1, -1, -1}, {8746, -1, -1, -1}, {8869, -1, -1, -1}, {8736, -1, -1, -1}, {8735, -1, -1, -1}, {8895, -1, -1, -1}, {13266, -1, -1, -1}, {13265, -1, -1, -1}, {8747, -1, -1, -1}, {8750, -1, -1, -1}, {8757, -1, -1, -1}, {8756, -1, -1, -1}, {9792, -1, -1, -1}, {9794, -1, -1, -1}, {9793, -1, -1, -1}, {9737, -1, -1, -1}, {8593, -1, -1, -1}, {8595, -1, -1, -1}, {8594, -1, -1, -1}, {8592, -1, -1, -1}, {8598, -1, -1, -1}, {8599, -1, -1, -1}, {8601, -1, -1, -1}, {8600, -1, -1, -1}, {8741, -1, -1, -1}, {8739, -1, -1, -1}, {-1, -1, -1, -1} },
    {{-1, -1, -1, -1}, {65295, -1, -1, -1}, {65340, -1, -1, -1}, {65284, -1, -1, -1}, {165, -1, -1, -1}, {12306, -1, -1, -1}, {162, -1, -1, -1}, {163, -1, -1, -1}, {65285, -1, -1, -1}, {65312, -1, -1, -1}, {8451, -1, -1, -1}, {8457, -1, -1, -1}, {65129, -1, -1, -1}, {65130, -1, -1, -1}, {65131, -1, -1, -1}, {13269, -1, -1, -1}, {13212, -1, -1, -1}, {13213, -1, -1, -1}, {13214, -1, -1, -1}, {13262, -1, -1, -1}, {13217, -1, -1, -1}, {13198, -1, -1, -1}, {13199, -1, -1, -1}, {13252, -1, -1, -1}, {176, -1, -1, -1}, {20825, -1, -1, -1}, {20827, -1, -1, -1}, {20830, -1, -1, -1}, {20829, -1, -1, -1}, {20833, -1, -1, -1}, {20835, -1, -1, -1}, {21991, -1, -1, -1}, {29929, -1, -1, -1}, {31950, -1, -1, -1}, {9601, -1, -1, -1}, {9602, -1, -1, -1}, {9603, -1, -1, -1}, {9604, -1, -1, -1}, {9605, -1, -1, -1}, {9606, -1, -1, -1}, {9607, -1, -1, -1}, {9608, -1, -1, -1}, {9615, -1, -1, -1}, {9614, -1, -1, -1}, {9613, -1, -1, -1}, {9612, -1, -1, -1}, {9611, -1, -1, -1}, {9610, -1, -1, -1}, {9609, -1, -1, -1}, {9532, -1, -1, -1}, {9524, -1, -1, -1}, {9516, -1, -1, -1}, {9508, -1, -1, -1}, {9500, -1, -1, -1}, {9620, -1, -1, -1}, {9472, -1, -1, -1}, {9474, -1, -1, -1}, {9621, -1, -1, -1}, {9484, -1, -1, -1}, {9488, -1, -1, -1}, {9492, -1, -1, -1}, {9496, -1, -1, -1}, {9581, -1, -1, -1}, {9582, -1, -1, -1}, {9584, -1, -1, -1}, {9583, -1, -1, -1}, {9552, -1, -1, -1}, {9566, -1, -1, -1}, {9578, -1, -1, -1}, {9569, -1, -1, -1}, {9698, -1, -1, -1}, {9699, -1, -1, -1}, {9701, -1, -1, -1}, {9700, -1, -1, -1}, {9585, -1, -1, -1}, {9586, -1, -1, -1}, {9587, -1, -1, -1}, {65296, -1, -1, -1}, {65297, -1, -1, -1}, {65298, -1, -1, -1}, {65299, -1, -1, -1}, {65300, -1, -1, -1}, {65301, -1, -1, -1}, {65302, -1, -1, -1}, {65303, -1, -1, -1}, {65304, -1, -1, -1}, {65305, -1, -1, -1}, {8544, -1, -1, -1}, {8545, -1, -1, -1}, {8546, -1, -1, -1}, {8547, -1, -1, -1}, {8548, -1, -1, -1}, {8549, -1, -1, -1}, {8550, -1, -1, -1}, {8551, -1, -1, -1}, {8552, -1, -1, -1}, {8553, -1, -1, -1}, {12321, -1, -1, -1}, {12322, -1, -1, -1}, {12323, -1, -1, -1}, {12324, -1, -1, -1}, {12325, -1, -1, -1}, {12326, -1, -1, -1}, {12327, -1, -1, -1}, {12328, -1, -1, -1}, {12329, -1, -1, -1}, {-1, -1, -1, -1}, {21316, -1, -1, -1}, {-1, -1, -1, -1}, {65313, -1, -1, -1}, {65314, -1, -1, -1}, {65315, -1, -1, -1}, {65316, -1, -1, -1}, {65317, -1, -1, -1}, {65318, -1, -1, -1}, {65319, -1, -1, -1}, {65320, -1, -1, -1}, {65321, -1, -1, -1}, {65322, -1, -1, -1}, {65323, -1, -1, -1}, {65324, -1, -1, -1}, {65325, -1, -1, -1}, {65326, -1, -1, -1}, {65327, -1, -1, -1}, {65328, -1, -1, -1}, {65329, -1, -1, -1}, {65330, -1, -1, -1}, {65331, -1, -1, -1}, {65332, -1, -1, -1}, {65333, -1, -1, -1}, {65334, -1, -1, -1}, {65335, -1, -1, -1}, {65336, -1, -1, -1}, {65337, -1, -1, -1}, {65338, -1, -1, -1}, {65345, -1, -1, -1}, {65346, -1, -1, -1}, {65347, -1, -1, -1}, {65348, -1, -1, -1}, {65349, -1, -1, -1}, {65350, -1, -1, -1}, {65351, -1, -1, -1}, {65352, -1, -1, -1}, {65353, -1, -1, -1}, {65354, -1, -1, -1}, {65355, -1, -1, -1}, {65356, -1, -1, -1}, {65357, -1, -1, -1}, {65358, -1, -1, -1}, {65359, -1, -1, -1}, {65360, -1, -1, -1}, {65361, -1, -1, -1}, {65362, -1, -1, -1}, {65363, -1, -1, -1}, {65364, -1, -1, -1}, {65365, -1, -1, -1}, {65366, -1, -1, -1}, {65367, -1, -1, -1}, {65368, -1, -1, -1}, {65369, -1, -1, -1}, {65370, -1, -1, -1}, {913, -1, -1, -1}, {914, -1, -1, -1}, {915, -1, -1, -1}, {916, -1, -1, -1}, {917, -1, -1, -1}, {918, -1, -1, -1}, {919, -1, -1, -1}, {920, -1, -1, -1}, {921, -1, -1, -1}, {922, -1, -1, -1}, {923, -1, -1, -1}, {924, -1, -1, -1}, {925, -1, -1, -1}, {926, -1, -1, -1}, {927, -1, -1, -1}, {928, -1, -1, -1}, {929, -1, -1, -1}, {931, -1, -1, -1}, {932, -1, -1, -1}, {933, -1, -1, -1}, {934, -1, -1, -1}, {935, -1, -1, -1}, {936, -1, -1, -1}, {937, -1, -1, -1}, {945, -1, -1, -1}, {946, -1, -1, -1}, {947, -1, -1, -1}, {948, -1, -1, -1}, {949, -1, -1, -1}, {950, -1, -1, -1}, {951, -1, -1, -1}, {952, -1, -1, -1}, {953, -1, -1, -1}, {954, -1, -1, -1}, {955, -1, -1, -1}, {956, -1, -1, -1}, {957, -1, -1, -1}, {958, -1, -1, -1}, {959, -1, -1, -1}, {960, -1, -1, -1}, {961, -1, -1, -1}, {963, -1, -1, -1}, {964, -1, -1, -1}, {965, -1, -1, -1}, {966, -1, -1, -1}, {967, -1, -1, -1}, {968, -1, -1, -1}, {969, -1, -1, -1}, {12549, -1, -1, -1}, {12550, -1, -1, -1}, {12551, -1, -1, -1}, {12552, -1, -1, -1}, {12553, -1, -1, -1}, {12554, -1, -1, -1}, {12555, -1, -1, -1}, {12556, -1, -1, -1}, {12557, -1, -1, -1}, {12558, -1, -1, -1}, {12559, -1, -1, -1}, {12560, -1, -1, -1}, {12561, -1, -1, -1}, {12562, -1, -1, -1}, {12563, -1, -1, -1}, {12564, -1, -1, -1}, {12565, -1, -1, -1}, {12566, -1, -1, -1}, {12567, -1, -1, -1}, {12568, -1, -1, -1}, {12569, -1, -1, -1}, {12570, -1, -1, -1}, {12571, -1, -1, -1}, {12572, -1, -1, -1}, {12573, -1, -1, -1}, {12574, -1, -1, -1}, {12575, -1, -1, -1}, {12576, -1, -1, -1}, {12577, -1, -1, -1}, {12578, -1, -1, -1}, {12579, -1, -1, -1}, {12580, -1, -1, -1}, {12581, -1, -1, -1}, {12582, -1, -1, -1}, {12583, -1, -1, -1}, {12584, -1, -1, -1}, {12585, -1, -1, -1}, {729, -1, -1, -1}, {714, -1, -1, -1}, {711, -1, -1, -1}, {715, -1, -1, -1}, {9312, -1, -1, -1}, {9313, -1, -1, -1}, {9314, -1, -1, -1}, {9315, -1, -1, -1}, {9316, -1, -1, -1}, {9317, -1, -1, -1} },
    {{9318, -1, -1, -1}, {9319, -1, -1, -1}, {9320, -1, -1, -1}, {9321, -1, -1, -1}, {9332, -1, -1, -1}, {9333, -1, -1, -1}, {9334, -1, -1, -1}, {9335, -1, -1, -1}, {9336, -1, -1, -1}, {9337, -1, -1, -1}, {9338, -1, -1, -1}, {9339, -1, -1, -1}, {9340, -1, -1, -1}, {9341, -1, -1, -1}, {8560, -1, -1, -1}, {8561, -1, -1, -1}, {8562, -1, -1, -1}, {8563, -1, -1, -1}, {8564, -1, -1, -1}, {8565, -1, -1, -1}, {8566, -1, -1, -1}, {8567, -1, -1, -1}, {8568, -1, -1, -1}, {8569, -1, -1, -1}, {20008, -1, -1, -1}, {20022, -1, -1, -1}, {20031, -1, -1, -1}, {20101, -1, -1, -1}, {20128, -1, -1, -1}, {20866, -1, -1, -1}, {20886, -1, -1, -1}, {20907, -1, -1, -1}, {21241, -1, -1, -1}, {21304, -1, -1, -1}, {21353, -1, -1, -1}, {21430, -1, -1, -1}, {22794, 22786, -1, -1}, {23424, -1, -1, -1}, {24027, -1, -1, -1}, {12083, 24186, -1, -1}, {24191, -1, -1, -1}, {24308, -1, -1, -1}, {24400, -1, -1, -1}, {24417, -1, -1, -1}, {25908, -1, -1, -1}, {26080, -1, -1, -1}, {30098, -1, -1, -1}, {30326, -1, -1, -1}, {36789, -1, -1, -1}, {38582, -1, -1, -1}, {9216, -1, -1, -1}, {9217, -1, -1, -1}, {9218, -1, -1, -1}, {9219, -1, -1, -1}, {9220, -1, -1, -1}, {9221, -1, -1, -1}, {9222, -1, -1, -1}, {9223, -1, -1, -1}, {9224, -1, -1, -1}, {9225, -1, -1, -1}, {9226, -1, -1, -1}, {9227, -1, -1, -1}, {9228, -1, -1, -1}, {9229, -1, -1, -1}, {9230, -1, -1, -1}, {9231, -1, -1, -1}, {9232, -1, -1, -1}, {9233, -1, -1, -1}, {9234, -1, -1, -1}, {9235, -1, -1, -1}, {9236, -1, -1, -1}, {9237, -1, -1, -1}, {9238, -1, -1, -1}, {9239, -1, -1, -1}, {9240, -1, -1, -1}, {9241, -1, -1, -1}, {9242, -1, -1, -1}, {9243, -1, -1, -1}, {9244, -1, -1, -1}, {9245, -1, -1, -1}, {9246, -1, -1, -1}, {9247, -1, -1, -1}, {9249, -1, -1, -1}, {19968, -1, -1, -1}, {20057, -1, -1, -1}, {19969, -1, -1, -1}, {19971, -1, -1, -1}, {20035, -1, -1, -1}, {20061, -1, -1, -1}, {20102, -1, -1, -1}, {20108, -1, -1, -1}, {20154, -1, -1, -1}, {20799, -1, -1, -1}, {20837, -1, -1, -1}, {20843, -1, -1, -1}, {20960, -1, -1, -1}, {20992, -1, -1, -1}, {20993, -1, -1, -1}, {21147, -1, -1, -1}, {21269, -1, -1, -1}, {21313, -1, -1, -1}, {21340, -1, -1, -1}, {21448, -1, -1, -1}, {19977, -1, -1, -1}, {19979, -1, -1, -1}, {19976, -1, -1, -1}, {19978, -1, -1, -1}, {20011, -1, -1, -1}, {20024, -1, -1, -1}, {20961, -1, -1, -1}, {20037, -1, -1, -1}, {20040, -1, -1, -1}, {20063, -1, -1, -1}, {20062, -1, -1, -1}, {20110, -1, -1, -1}, {20129, -1, -1, -1}, {20800, 64012, -1, -1}, {20995, -1, -1, -1}, {21242, -1, -1, -1}, {21315, -1, -1, -1}, {21449, -1, -1, -1}, {21475, -1, -1, -1}, {22303, -1, -1, -1}, {22763, -1, -1, -1}, {22805, -1, -1, -1}, {22823, -1, -1, -1}, {22899, -1, -1, -1}, {23376, -1, -1, -1}, {23377, -1, -1, -1}, {23379, -1, -1, -1}, {23544, -1, -1, -1}, {23567, -1, -1, -1}, {23586, -1, -1, -1}, {23608, -1, -1, -1}, {23665, -1, -1, -1}, {24029, -1, -1, -1}, {24037, -1, -1, -1}, {24049, -1, -1, -1}, {24050, -1, -1, -1}, {24051, -1, -1, -1}, {24062, -1, -1, -1}, {24178, -1, -1, -1}, {24318, -1, -1, -1}, {24331, -1, -1, -1}, {24339, -1, -1, -1}, {25165, -1, -1, -1}, {19985, -1, -1, -1}, {19984, -1, -1, -1}, {19981, -1, -1, -1}, {20013, -1, -1, -1}, {20016, -1, -1, -1}, {20025, -1, -1, -1}, {20043, -1, -1, -1}, {23609, -1, -1, -1}, {20104, -1, -1, -1}, {20113, -1, -1, -1}, {20117, -1, -1, -1}, {20114, -1, -1, -1}, {20116, -1, -1, -1}, {20130, -1, -1, -1}, {20161, -1, -1, -1}, {20160, -1, -1, -1}, {20163, -1, -1, -1}, {20166, -1, -1, -1}, {20167, -1, -1, -1}, {20173, -1, -1, -1}, {20170, -1, -1, -1}, {20171, -1, -1, -1}, {20164, -1, -1, -1}, {20803, -1, -1, -1}, {20801, -1, -1, -1}, {20839, -1, -1, -1}, {20845, -1, -1, -1}, {20846, -1, -1, -1}, {20844, -1, -1, -1}, {20887, -1, -1, -1}, {20982, -1, -1, -1}, {20998, -1, -1, -1}, {20999, -1, -1, -1}, {21000, -1, -1, -1}, {21243, -1, -1, -1}, {21246, -1, -1, -1}, {21247, -1, -1, -1}, {21270, -1, -1, -1}, {21305, -1, -1, -1}, {21320, -1, -1, -1}, {21319, -1, -1, -1}, {21317, -1, -1, -1}, {21342, -1, -1, -1}, {21380, -1, -1, -1}, {21451, -1, -1, -1}, {21450, -1, -1, -1}, {21453, -1, -1, -1}, {22764, -1, -1, -1}, {22825, -1, -1, -1}, {22827, -1, -1, -1}, {22826, -1, -1, -1}, {22829, -1, -1, -1}, {23380, -1, -1, -1}, {23569, -1, -1, -1}, {23588, -1, -1, -1}, {23610, -1, -1, -1}, {23663, -1, -1, -1}, {24052, -1, -1, -1}, {24187, -1, -1, -1}, {24319, -1, -1, -1}, {24340, -1, -1, -1}, {24341, -1, -1, -1}, {24515, -1, -1, -1}, {25096, -1, -1, -1}, {25142, -1, -1, -1}, {25163, -1, -1, -1}, {25166, -1, -1, -1}, {25903, -1, -1, -1}, {25991, -1, -1, -1}, {26007, -1, -1, -1}, {26020, -1, -1, -1}, {26041, -1, -1, -1}, {26085, -1, -1, -1}, {26352, -1, -1, -1}, {11933, 26376, -1, -1}, {26408, -1, -1, -1}, {27424, -1, -1, -1}, {27490, -1, -1, -1}, {27513, -1, -1, -1}, {27595, -1, -1, -1}, {27604, -1, -1, -1}, {27611, -1, -1, -1}, {27663, -1, -1, -1}, {27700, -1, -1, -1}, {28779, -1, -1, -1}, {29226, -1, -1, -1}, {29238, -1, -1, -1}, {29243, -1, -1, -1}, {29255, -1, -1, -1}, {29273, -1, -1, -1}, {29275, -1, -1, -1}, {29356, -1, -1, -1}, {29579, -1, -1, -1}, {19993, -1, -1, -1}, {19990, -1, -1, -1}, {19989, -1, -1, -1}, {19988, -1, -1, -1}, {19992, -1, -1, -1}, {20027, -1, -1, -1}, {20045, -1, -1, -1}, {20047, -1, -1, -1}, {20046, -1, -1, -1}, {20197, -1, -1, -1}, {20184, -1, -1, -1}, {20180, -1, -1, -1}, {20181, -1, -1, -1}, {20182, -1, -1, -1}, {20183, -1, -1, -1}, {20195, -1, -1, -1}, {20196, -1, -1, -1} },
    {{20185, -1, -1, -1}, {20190, -1, -1, -1}, {20805, -1, -1, -1}, {20804, -1, -1, -1}, {20873, -1, -1, -1}, {20874, -1, -1, -1}, {20908, -1, -1, -1}, {20985, -1, -1, -1}, {20986, -1, -1, -1}, {20984, -1, -1, -1}, {21002, -1, -1, -1}, {21152, -1, -1, -1}, {21151, -1, -1, -1}, {21253, -1, -1, -1}, {21254, -1, -1, -1}, {21271, -1, -1, -1}, {21277, -1, -1, -1}, {20191, -1, -1, -1}, {21322, -1, -1, -1}, {21321, -1, -1, -1}, {21345, -1, -1, -1}, {21344, -1, -1, -1}, {21359, -1, -1, -1}, {21358, -1, -1, -1}, {21435, -1, -1, -1}, {21487, -1, -1, -1}, {21476, -1, -1, -1}, {21491, -1, -1, -1}, {21484, -1, -1, -1}, {21486, -1, -1, -1}, {21481, -1, -1, -1}, {21480, -1, -1, -1}, {21500, -1, -1, -1}, {21496, -1, -1, -1}, {21493, -1, -1, -1}, {21483, -1, -1, -1}, {21478, -1, -1, -1}, {21482, -1, -1, -1}, {21490, -1, -1, -1}, {21489, -1, -1, -1}, {21488, -1, -1, -1}, {21477, -1, -1, -1}, {21485, -1, -1, -1}, {21499, -1, -1, -1}, {22235, -1, -1, -1}, {22234, -1, -1, -1}, {22806, -1, -1, -1}, {22830, -1, -1, -1}, {22833, -1, -1, -1}, {22900, -1, -1, -1}, {22902, -1, -1, -1}, {23381, -1, -1, -1}, {23427, -1, -1, -1}, {23612, -1, -1, -1}, {24040, -1, -1, -1}, {24039, -1, -1, -1}, {24038, -1, -1, -1}, {24066, -1, -1, -1}, {24067, -1, -1, -1}, {24179, -1, -1, -1}, {24188, -1, -1, -1}, {24321, -1, -1, -1}, {24344, -1, -1, -1}, {24343, -1, -1, -1}, {24517, -1, -1, -1}, {25098, -1, -1, -1}, {25171, -1, -1, -1}, {25172, -1, -1, -1}, {25170, -1, -1, -1}, {25169, -1, -1, -1}, {26021, -1, -1, -1}, {26086, -1, -1, -1}, {26414, -1, -1, -1}, {26412, -1, -1, -1}, {26410, -1, -1, -1}, {26411, -1, -1, -1}, {26413, -1, -1, -1}, {27491, -1, -1, -1}, {27597, -1, -1, -1}, {27665, -1, -1, -1}, {27664, -1, -1, -1}, {27704, -1, -1, -1}, {27713, -1, -1, -1}, {27712, -1, -1, -1}, {27710, -1, -1, -1}, {29359, -1, -1, -1}, {29572, -1, -1, -1}, {29577, -1, -1, -1}, {29916, -1, -1, -1}, {29926, -1, -1, -1}, {29976, -1, -1, -1}, {29983, -1, -1, -1}, {29992, -1, -1, -1}, {29993, -1, -1, -1}, {30000, -1, -1, -1}, {30001, -1, -1, -1}, {30002, -1, -1, -1}, {30003, -1, -1, -1}, {30091, -1, -1, -1}, {30333, -1, -1, -1}, {30382, -1, -1, -1}, {30399, -1, -1, -1}, {30446, -1, -1, -1}, {30683, -1, -1, -1}, {30690, -1, -1, -1}, {30707, -1, -1, -1}, {31034, -1, -1, -1}, {31166, -1, -1, -1}, {31348, -1, -1, -1}, {31435, -1, -1, -1}, {19998, -1, -1, -1}, {19999, -1, -1, -1}, {20050, -1, -1, -1}, {20051, -1, -1, -1}, {20073, -1, -1, -1}, {20121, -1, -1, -1}, {20132, -1, -1, -1}, {20134, -1, -1, -1}, {20133, -1, -1, -1}, {20223, -1, -1, -1}, {20233, -1, -1, -1}, {20249, -1, -1, -1}, {20234, -1, -1, -1}, {20245, -1, -1, -1}, {20237, -1, -1, -1}, {20240, -1, -1, -1}, {20241, -1, -1, -1}, {20239, -1, -1, -1}, {20210, -1, -1, -1}, {20214, -1, -1, -1}, {20219, -1, -1, -1}, {20208, -1, -1, -1}, {20211, -1, -1, -1}, {20221, -1, -1, -1}, {20225, -1, -1, -1}, {20235, -1, -1, -1}, {20809, -1, -1, -1}, {20807, -1, -1, -1}, {20806, -1, -1, -1}, {20808, -1, -1, -1}, {20840, -1, -1, -1}, {20849, -1, -1, -1}, {20877, -1, -1, -1}, {20912, -1, -1, -1}, {21015, -1, -1, -1}, {21009, -1, -1, -1}, {21010, -1, -1, -1}, {21006, -1, -1, -1}, {21014, -1, -1, -1}, {21155, -1, -1, -1}, {21256, -1, -1, -1}, {21281, -1, -1, -1}, {21280, -1, -1, -1}, {21360, -1, -1, -1}, {21361, -1, -1, -1}, {21513, -1, -1, -1}, {21519, -1, -1, -1}, {21516, -1, -1, -1}, {21514, -1, -1, -1}, {21520, -1, -1, -1}, {21505, -1, -1, -1}, {21515, -1, -1, -1}, {21508, -1, -1, -1}, {21521, -1, -1, -1}, {21517, -1, -1, -1}, {21512, -1, -1, -1}, {21507, -1, -1, -1}, {21518, -1, -1, -1}, {21510, -1, -1, -1}, {21522, -1, -1, -1}, {22240, -1, -1, -1}, {22238, -1, -1, -1}, {22237, -1, -1, -1}, {22323, -1, -1, -1}, {22320, -1, -1, -1}, {22312, -1, -1, -1}, {22317, -1, -1, -1}, {22316, -1, -1, -1}, {22319, -1, -1, -1}, {22313, -1, -1, -1}, {22809, -1, -1, -1}, {22810, -1, -1, -1}, {22839, -1, -1, -1}, {22840, -1, -1, -1}, {22916, -1, -1, -1}, {22904, -1, -1, -1}, {22915, -1, -1, -1}, {22909, -1, -1, -1}, {22905, -1, -1, -1}, {22914, -1, -1, -1}, {22913, -1, -1, -1}, {23383, -1, -1, -1}, {23384, -1, -1, -1}, {23431, -1, -1, -1}, {23432, -1, -1, -1}, {23429, -1, -1, -1}, {23433, -1, -1, -1}, {23546, -1, -1, -1}, {23574, -1, -1, -1}, {23673, -1, -1, -1}, {24030, -1, -1, -1}, {24070, -1, -1, -1}, {24182, -1, -1, -1}, {24180, -1, -1, -1}, {24335, -1, -1, -1}, {24347, -1, -1, -1}, {24537, -1, -1, -1}, {24534, -1, -1, -1}, {25102, -1, -1, -1}, {25100, -1, -1, -1}, {25101, -1, -1, -1}, {25104, -1, -1, -1}, {25187, -1, -1, -1}, {25179, -1, -1, -1}, {25176, -1, -1, -1}, {25910, -1, -1, -1}, {26089, -1, -1, -1}, {26088, -1, -1, -1}, {26092, -1, -1, -1}, {26093, -1, -1, -1}, {26354, -1, -1, -1}, {26355, -1, -1, -1}, {26377, -1, -1, -1}, {26429, -1, -1, -1}, {26420, -1, -1, -1}, {26417, -1, -1, -1}, {26421, -1, -1, -1}, {27425, -1, -1, -1}, {27492, -1, -1, -1}, {27515, -1, -1, -1}, {27670, -1, -1, -1}, {27741, -1, -1, -1}, {27735, -1, -1, -1}, {27737, -1, -1, -1}, {27743, -1, -1, -1}, {27744, -1, -1, -1}, {27728, -1, -1, -1}, {27733, -1, -1, -1}, {27745, -1, -1, -1}, {27739, -1, -1, -1}, {27725, -1, -1, -1}, {27726, -1, -1, -1}, {28784, -1, -1, -1}, {29279, -1, -1, -1}, {29277, -1, -1, -1}, {30334, -1, -1, -1}, {31481, -1, -1, -1}, {31859, -1, -1, -1}, {31992, -1, -1, -1}, {32566, -1, -1, -1}, {32650, -1, -1, -1}, {32701, -1, -1, -1}, {32769, -1, -1, -1}, {32771, -1, -1, -1}, {32780, -1, -1, -1}, {32786, -1, -1, -1} },
    {{32819, -1, -1, -1}, {32895, -1, -1, -1}, {32905, -1, -1, -1}, {32907, -1, -1, -1}, {32908, -1, -1, -1}, {33251, -1, -1, -1}, {33258, -1, -1, -1}, {33267, -1, -1, -1}, {33276, -1, -1, -1}, {33292, -1, -1, -1}, {33307, -1, -1, -1}, {33311, -1, -1, -1}, {33390, -1, -1, -1}, {33394, -1, -1, -1}, {33406, -1, -1, -1}, {34411, -1, -1, -1}, {34880, -1, -1, -1}, {34892, -1, -1, -1}, {34915, -1, -1, -1}, {35199, -1, -1, -1}, {38433, -1, -1, -1}, {20018, -1, -1, -1}, {20136, -1, -1, -1}, {20301, -1, -1, -1}, {20303, -1, -1, -1}, {20295, -1, -1, -1}, {20311, -1, -1, -1}, {20318, -1, -1, -1}, {20276, -1, -1, -1}, {20315, -1, -1, -1}, {20309, -1, -1, -1}, {20272, -1, -1, -1}, {20304, -1, -1, -1}, {20305, -1, -1, -1}, {20285, -1, -1, -1}, {20282, -1, -1, -1}, {20280, -1, -1, -1}, {20291, -1, -1, -1}, {20308, -1, -1, -1}, {20284, -1, -1, -1}, {20294, -1, -1, -1}, {20323, -1, -1, -1}, {20316, -1, -1, -1}, {20320, -1, -1, -1}, {20271, -1, -1, -1}, {20302, -1, -1, -1}, {20278, -1, -1, -1}, {20313, -1, -1, -1}, {20317, -1, -1, -1}, {20296, -1, -1, -1}, {20314, -1, -1, -1}, {20812, -1, -1, -1}, {20811, -1, -1, -1}, {20813, -1, -1, -1}, {20853, -1, -1, -1}, {20918, -1, -1, -1}, {20919, -1, -1, -1}, {21029, -1, -1, -1}, {21028, -1, -1, -1}, {21033, -1, -1, -1}, {21034, -1, -1, -1}, {21032, -1, -1, -1}, {21163, -1, -1, -1}, {21161, -1, -1, -1}, {21162, -1, -1, -1}, {21164, -1, -1, -1}, {21283, -1, -1, -1}, {21363, -1, -1, -1}, {21365, -1, -1, -1}, {21533, -1, -1, -1}, {21549, -1, -1, -1}, {21534, -1, -1, -1}, {21566, -1, -1, -1}, {21542, -1, -1, -1}, {21582, -1, -1, -1}, {21543, -1, -1, -1}, {21574, -1, -1, -1}, {21571, -1, -1, -1}, {21555, -1, -1, -1}, {21576, -1, -1, -1}, {21570, -1, -1, -1}, {21531, -1, -1, -1}, {21545, -1, -1, -1}, {21578, -1, -1, -1}, {21561, -1, -1, -1}, {21563, -1, -1, -1}, {21560, -1, -1, -1}, {21550, -1, -1, -1}, {21557, -1, -1, -1}, {21558, -1, -1, -1}, {21536, -1, -1, -1}, {21564, -1, -1, -1}, {21568, -1, -1, -1}, {21553, -1, -1, -1}, {21547, -1, -1, -1}, {21535, -1, -1, -1}, {21548, -1, -1, -1}, {22250, -1, -1, -1}, {22256, -1, -1, -1}, {22244, -1, -1, -1}, {22251, -1, -1, -1}, {22346, -1, -1, -1}, {22353, -1, -1, -1}, {22336, -1, -1, -1}, {22349, -1, -1, -1}, {22343, -1, -1, -1}, {22350, -1, -1, -1}, {22334, -1, -1, -1}, {22352, -1, -1, -1}, {22351, -1, -1, -1}, {22331, -1, -1, -1}, {22767, -1, -1, -1}, {22846, -1, -1, -1}, {22941, -1, -1, -1}, {22930, -1, -1, -1}, {22952, -1, -1, -1}, {22942, -1, -1, -1}, {22947, -1, -1, -1}, {22937, -1, -1, -1}, {22934, -1, -1, -1}, {22925, -1, -1, -1}, {22948, -1, -1, -1}, {22931, -1, -1, -1}, {22922, -1, -1, -1}, {22949, -1, -1, -1}, {23389, -1, -1, -1}, {23388, -1, -1, -1}, {23386, -1, -1, -1}, {23387, -1, -1, -1}, {23436, -1, -1, -1}, {23435, -1, -1, -1}, {23439, -1, -1, -1}, {23596, -1, -1, -1}, {23616, -1, -1, -1}, {23617, -1, -1, -1}, {23615, -1, -1, -1}, {23614, -1, -1, -1}, {23696, -1, -1, -1}, {23697, -1, -1, -1}, {23700, -1, -1, -1}, {23692, -1, -1, -1}, {24043, -1, -1, -1}, {24076, -1, -1, -1}, {24207, -1, -1, -1}, {24199, -1, -1, -1}, {24202, -1, -1, -1}, {24311, -1, -1, -1}, {24324, -1, -1, -1}, {24351, -1, -1, -1}, {24420, -1, -1, -1}, {24418, -1, -1, -1}, {24439, -1, -1, -1}, {24441, -1, -1, -1}, {24536, -1, -1, -1}, {24524, -1, -1, -1}, {24535, -1, -1, -1}, {24525, -1, -1, -1}, {24561, -1, -1, -1}, {24555, -1, -1, -1}, {24568, -1, -1, -1}, {24554, -1, -1, -1}, {25106, -1, -1, -1}, {25105, -1, -1, -1}, {25220, -1, -1, -1}, {25239, -1, -1, -1}, {25238, -1, -1, -1}, {25216, -1, -1, -1}, {25206, -1, -1, -1}, {25225, -1, -1, -1}, {25197, -1, -1, -1}, {25226, -1, -1, -1}, {25212, -1, -1, -1}, {25214, -1, -1, -1}, {25209, -1, -1, -1}, {25203, -1, -1, -1}, {25234, -1, -1, -1}, {25199, -1, -1, -1}, {25240, -1, -1, -1}, {25198, -1, -1, -1}, {25237, -1, -1, -1}, {25235, -1, -1, -1}, {25233, -1, -1, -1}, {25222, -1, -1, -1}, {25913, -1, -1, -1}, {25915, -1, -1, -1}, {25912, -1, -1, -1}, {26097, -1, -1, -1}, {26356, -1, -1, -1}, {26463, -1, -1, -1}, {26446, -1, -1, -1}, {26447, -1, -1, -1}, {26448, -1, -1, -1}, {26449, -1, -1, -1}, {26460, -1, -1, -1}, {26454, -1, -1, -1}, {26462, -1, -1, -1}, {26441, -1, -1, -1}, {26438, -1, -1, -1}, {26464, -1, -1, -1}, {26451, -1, -1, -1}, {26455, -1, -1, -1}, {27493, -1, -1, -1}, {27599, -1, -1, -1}, {27714, -1, -1, -1}, {27742, -1, -1, -1}, {27801, -1, -1, -1}, {27777, -1, -1, -1}, {27784, -1, -1, -1}, {27785, -1, -1, -1}, {27781, -1, -1, -1}, {27803, -1, -1, -1}, {27754, -1, -1, -1}, {27770, -1, -1, -1}, {27792, -1, -1, -1}, {27760, -1, -1, -1}, {27788, -1, -1, -1}, {27752, -1, -1, -1}, {27798, -1, -1, -1}, {27794, -1, -1, -1}, {27773, -1, -1, -1}, {27779, -1, -1, -1}, {27762, -1, -1, -1}, {27774, -1, -1, -1}, {27764, -1, -1, -1}, {27782, -1, -1, -1}, {27766, -1, -1, -1}, {27789, -1, -1, -1}, {27796, -1, -1, -1}, {27800, -1, -1, -1}, {27778, -1, -1, -1}, {28790, -1, -1, -1}, {28796, -1, -1, -1}, {28797, -1, -1, -1}, {28792, -1, -1, -1}, {29282, -1, -1, -1}, {29281, -1, -1, -1}, {29280, -1, -1, -1}, {29380, -1, -1, -1}, {29378, -1, -1, -1}, {29590, -1, -1, -1}, {29996, -1, -1, -1}, {29995, -1, -1, -1}, {30007, -1, -1, -1}, {30008, -1, -1, -1}, {30338, -1, -1, -1}, {30447, -1, -1, -1}, {30691, -1, -1, -1}, {31169, -1, -1, -1}, {31168, -1, -1, -1}, {31167, -1, -1, -1}, {31350, -1, -1, -1}, {31995, -1, -1, -1}, {32597, -1, -1, -1}, {32918, -1, -1, -1}, {32915, -1, -1, -1}, {32925, -1, -1, -1} },
    {{32920, -1, -1, -1}, {32923, -1, -1, -1}, {32922, -1, -1, -1}, {32946, -1, -1, -1}, {33391, -1, -1, -1}, {33426, -1, -1, -1}, {33419, -1, -1, -1}, {33421, -1, -1, -1}, {35211, -1, -1, -1}, {11974, 35282, -1, -1}, {35328, -1, -1, -1}, {35895, -1, -1, -1}, {35910, -1, -1, -1}, {35925, -1, -1, -1}, {35997, -1, -1, -1}, {36196, -1, -1, -1}, {36208, -1, -1, -1}, {36275, -1, -1, -1}, {36523, -1, -1, -1}, {36554, -1, -1, -1}, {36763, -1, -1, -1}, {36784, -1, -1, -1}, {36802, -1, -1, -1}, {36806, -1, -1, -1}, {36805, -1, -1, -1}, {36804, -1, -1, -1}, {24033, -1, -1, -1}, {37009, -1, -1, -1}, {37026, -1, -1, -1}, {37034, -1, -1, -1}, {37030, -1, -1, -1}, {37027, -1, -1, -1}, {37193, -1, -1, -1}, {37318, -1, -1, -1}, {37324, -1, -1, -1}, {38450, -1, -1, -1}, {38446, -1, -1, -1}, {38449, -1, -1, -1}, {38442, -1, -1, -1}, {38444, -1, -1, -1}, {20006, -1, -1, -1}, {20054, -1, -1, -1}, {20083, -1, -1, -1}, {20107, -1, -1, -1}, {20123, -1, -1, -1}, {20126, -1, -1, -1}, {20139, -1, -1, -1}, {20140, -1, -1, -1}, {20335, -1, -1, -1}, {20381, -1, -1, -1}, {20365, -1, -1, -1}, {20339, -1, -1, -1}, {20351, -1, -1, -1}, {20332, -1, -1, -1}, {20379, -1, -1, -1}, {20363, -1, -1, -1}, {20358, -1, -1, -1}, {20355, -1, -1, -1}, {20336, -1, -1, -1}, {20341, -1, -1, -1}, {20360, -1, -1, -1}, {20329, -1, -1, -1}, {20347, -1, -1, -1}, {20374, -1, -1, -1}, {20350, -1, -1, -1}, {20367, -1, -1, -1}, {20369, -1, -1, -1}, {20346, -1, -1, -1}, {20820, -1, -1, -1}, {20818, -1, -1, -1}, {20821, -1, -1, -1}, {20841, -1, -1, -1}, {20855, -1, -1, -1}, {20854, -1, -1, -1}, {20856, -1, -1, -1}, {20925, -1, -1, -1}, {20989, -1, -1, -1}, {21051, -1, -1, -1}, {21048, -1, -1, -1}, {21047, -1, -1, -1}, {21050, -1, -1, -1}, {21040, -1, -1, -1}, {21038, -1, -1, -1}, {21046, -1, -1, -1}, {21057, -1, -1, -1}, {21182, -1, -1, -1}, {21179, -1, -1, -1}, {21330, -1, -1, -1}, {21332, -1, -1, -1}, {21331, -1, -1, -1}, {21329, -1, -1, -1}, {21350, -1, -1, -1}, {21367, -1, -1, -1}, {21368, -1, -1, -1}, {21369, -1, -1, -1}, {21462, -1, -1, -1}, {21460, -1, -1, -1}, {21463, -1, -1, -1}, {21619, -1, -1, -1}, {21621, -1, -1, -1}, {21654, -1, -1, -1}, {21624, -1, -1, -1}, {21653, -1, -1, -1}, {21632, -1, -1, -1}, {21627, -1, -1, -1}, {21623, -1, -1, -1}, {21636, -1, -1, -1}, {21650, -1, -1, -1}, {21638, -1, -1, -1}, {21628, -1, -1, -1}, {21648, -1, -1, -1}, {21617, -1, -1, -1}, {21622, -1, -1, -1}, {21644, -1, -1, -1}, {21658, -1, -1, -1}, {21602, -1, -1, -1}, {21608, -1, -1, -1}, {21643, -1, -1, -1}, {21629, -1, -1, -1}, {21646, -1, -1, -1}, {22266, -1, -1, -1}, {22403, -1, -1, -1}, {22391, -1, -1, -1}, {22378, -1, -1, -1}, {22377, -1, -1, -1}, {22369, -1, -1, -1}, {22374, -1, -1, -1}, {22372, -1, -1, -1}, {22396, -1, -1, -1}, {22812, -1, -1, -1}, {22857, -1, -1, -1}, {22855, -1, -1, -1}, {22856, -1, -1, -1}, {22852, -1, -1, -1}, {22868, -1, -1, -1}, {22974, -1, -1, -1}, {22971, -1, -1, -1}, {22996, -1, -1, -1}, {22969, -1, -1, -1}, {22958, -1, -1, -1}, {22993, -1, -1, -1}, {22982, -1, -1, -1}, {22992, -1, -1, -1}, {22989, -1, -1, -1}, {22987, -1, -1, -1}, {22995, -1, -1, -1}, {22986, -1, -1, -1}, {22959, -1, -1, -1}, {22963, -1, -1, -1}, {22994, -1, -1, -1}, {22981, -1, -1, -1}, {23391, -1, -1, -1}, {23396, -1, -1, -1}, {23395, -1, -1, -1}, {23447, -1, -1, -1}, {23450, -1, -1, -1}, {23448, -1, -1, -1}, {23452, -1, -1, -1}, {23449, -1, -1, -1}, {23451, -1, -1, -1}, {23578, -1, -1, -1}, {23624, -1, -1, -1}, {23621, -1, -1, -1}, {23622, -1, -1, -1}, {23735, -1, -1, -1}, {23713, -1, -1, -1}, {23736, -1, -1, -1}, {23721, -1, -1, -1}, {23723, -1, -1, -1}, {23729, -1, -1, -1}, {23731, -1, -1, -1}, {24088, -1, -1, -1}, {24090, -1, -1, -1}, {24086, -1, -1, -1}, {24085, -1, -1, -1}, {24091, -1, -1, -1}, {24081, -1, -1, -1}, {24184, -1, -1, -1}, {24218, -1, -1, -1}, {24215, -1, -1, -1}, {24220, -1, -1, -1}, {24213, -1, -1, -1}, {24214, -1, -1, -1}, {24310, -1, -1, -1}, {24358, -1, -1, -1}, {24359, -1, -1, -1}, {24361, -1, -1, -1}, {24448, -1, -1, -1}, {24449, -1, -1, -1}, {24447, -1, -1, -1}, {24444, -1, -1, -1}, {24541, -1, -1, -1}, {24544, -1, -1, -1}, {24573, -1, -1, -1}, {24565, -1, -1, -1}, {24575, -1, -1, -1}, {24591, -1, -1, -1}, {24596, -1, -1, -1}, {24623, -1, -1, -1}, {24629, -1, -1, -1}, {24598, -1, -1, -1}, {24618, -1, -1, -1}, {24597, -1, -1, -1}, {24609, -1, -1, -1}, {24615, -1, -1, -1}, {24617, -1, -1, -1}, {24619, -1, -1, -1}, {24603, -1, -1, -1}, {25110, -1, -1, -1}, {25109, -1, -1, -1}, {25151, -1, -1, -1}, {25150, -1, -1, -1}, {25152, -1, -1, -1}, {25215, -1, -1, -1}, {25289, -1, -1, -1}, {25292, -1, -1, -1}, {25284, -1, -1, -1}, {25279, -1, -1, -1}, {25282, -1, -1, -1}, {25273, -1, -1, -1}, {25298, -1, -1, -1}, {25307, -1, -1, -1}, {25259, -1, -1, -1}, {25299, -1, -1, -1}, {25300, -1, -1, -1}, {25291, -1, -1, -1}, {25288, -1, -1, -1}, {25256, -1, -1, -1}, {25277, -1, -1, -1}, {25276, -1, -1, -1}, {25296, -1, -1, -1}, {25305, -1, -1, -1}, {25287, -1, -1, -1}, {25293, -1, -1, -1}, {25269, -1, -1, -1}, {25306, -1, -1, -1}, {25265, -1, -1, -1}, {25304, -1, -1, -1}, {25302, -1, -1, -1}, {25303, -1, -1, -1}, {25286, -1, -1, -1}, {25260, -1, -1, -1}, {25294, -1, -1, -1}, {25918, -1, -1, -1}, {26023, -1, -1, -1}, {26044, -1, -1, -1}, {26106, -1, -1, -1}, {26132, -1, -1, -1}, {26131, -1, -1, -1}, {26124, -1, -1, -1}, {26118, -1, -1, -1}, {26114, -1, -1, -1}, {26126, -1, -1, -1}, {26112, -1, -1, -1}, {26127, -1, -1, -1}, {26133, -1, -1, -1} },
    {{26122, -1, -1, -1}, {26119, -1, -1, -1}, {26381, -1, -1, -1}, {26379, -1, -1, -1}, {26477, -1, -1, -1}, {26507, -1, -1, -1}, {26517, -1, -1, -1}, {26481, -1, -1, -1}, {26524, -1, -1, -1}, {26483, -1, -1, -1}, {26487, -1, -1, -1}, {26503, -1, -1, -1}, {26525, -1, -1, -1}, {26519, -1, -1, -1}, {26479, -1, -1, -1}, {26480, -1, -1, -1}, {26495, -1, -1, -1}, {26505, -1, -1, -1}, {26494, -1, -1, -1}, {26512, -1, -1, -1}, {26485, -1, -1, -1}, {26522, -1, -1, -1}, {26515, -1, -1, -1}, {26492, -1, -1, -1}, {26474, -1, -1, -1}, {26482, -1, -1, -1}, {27427, -1, -1, -1}, {27494, -1, -1, -1}, {27495, -1, -1, -1}, {27519, -1, -1, -1}, {27667, -1, -1, -1}, {27675, -1, -1, -1}, {27875, -1, -1, -1}, {27880, -1, -1, -1}, {27891, -1, -1, -1}, {27825, -1, -1, -1}, {27852, -1, -1, -1}, {27877, -1, -1, -1}, {27827, -1, -1, -1}, {27837, -1, -1, -1}, {27838, -1, -1, -1}, {27836, -1, -1, -1}, {27874, -1, -1, -1}, {27819, -1, -1, -1}, {27861, -1, -1, -1}, {27859, -1, -1, -1}, {27832, -1, -1, -1}, {27844, -1, -1, -1}, {27833, -1, -1, -1}, {27841, -1, -1, -1}, {27822, -1, -1, -1}, {27863, -1, -1, -1}, {27845, -1, -1, -1}, {27889, -1, -1, -1}, {27839, -1, -1, -1}, {27835, -1, -1, -1}, {27873, -1, -1, -1}, {27867, -1, -1, -1}, {27850, -1, -1, -1}, {27820, -1, -1, -1}, {27887, -1, -1, -1}, {27868, -1, -1, -1}, {27862, -1, -1, -1}, {27872, -1, -1, -1}, {28821, -1, -1, -1}, {28814, -1, -1, -1}, {28818, -1, -1, -1}, {28810, -1, -1, -1}, {28825, -1, -1, -1}, {29228, -1, -1, -1}, {29229, -1, -1, -1}, {29240, -1, -1, -1}, {29256, -1, -1, -1}, {29287, -1, -1, -1}, {29289, -1, -1, -1}, {29376, -1, -1, -1}, {29390, -1, -1, -1}, {29401, -1, -1, -1}, {29399, -1, -1, -1}, {29392, -1, -1, -1}, {29609, -1, -1, -1}, {29608, -1, -1, -1}, {29599, -1, -1, -1}, {29611, -1, -1, -1}, {29605, -1, -1, -1}, {30013, -1, -1, -1}, {30109, -1, -1, -1}, {30105, -1, -1, -1}, {30106, -1, -1, -1}, {30340, -1, -1, -1}, {30402, -1, -1, -1}, {30450, -1, -1, -1}, {30452, -1, -1, -1}, {30693, -1, -1, -1}, {30717, -1, -1, -1}, {31038, -1, -1, -1}, {31040, -1, -1, -1}, {31041, -1, -1, -1}, {31177, -1, -1, -1}, {31176, -1, -1, -1}, {31354, -1, -1, -1}, {31353, -1, -1, -1}, {31482, -1, -1, -1}, {31998, -1, -1, -1}, {32596, -1, -1, -1}, {32652, -1, -1, -1}, {32651, -1, -1, -1}, {32773, -1, -1, -1}, {32954, -1, -1, -1}, {32933, -1, -1, -1}, {32930, -1, -1, -1}, {32945, -1, -1, -1}, {32929, -1, -1, -1}, {32939, -1, -1, -1}, {32937, -1, -1, -1}, {32948, -1, -1, -1}, {32938, -1, -1, -1}, {32943, -1, -1, -1}, {33253, -1, -1, -1}, {33278, -1, -1, -1}, {33293, -1, -1, -1}, {33459, -1, -1, -1}, {33437, -1, -1, -1}, {33433, -1, -1, -1}, {33453, -1, -1, -1}, {33469, -1, -1, -1}, {33439, -1, -1, -1}, {33465, -1, -1, -1}, {33457, -1, -1, -1}, {33452, -1, -1, -1}, {33445, -1, -1, -1}, {33455, -1, -1, -1}, {33464, -1, -1, -1}, {33443, -1, -1, -1}, {33456, -1, -1, -1}, {33470, -1, -1, -1}, {33463, -1, -1, -1}, {34382, -1, -1, -1}, {34417, -1, -1, -1}, {21021, -1, -1, -1}, {34920, -1, -1, -1}, {36555, -1, -1, -1}, {36814, -1, -1, -1}, {36820, -1, -1, -1}, {36817, -1, -1, -1}, {37045, -1, -1, -1}, {37048, -1, -1, -1}, {37041, -1, -1, -1}, {37046, -1, -1, -1}, {37319, -1, -1, -1}, {37329, -1, -1, -1}, {38263, -1, -1, -1}, {38272, -1, -1, -1}, {38428, -1, -1, -1}, {38464, -1, -1, -1}, {38463, -1, -1, -1}, {38459, -1, -1, -1}, {38468, -1, -1, -1}, {38466, -1, -1, -1}, {38585, -1, -1, -1}, {38632, -1, -1, -1}, {38738, -1, -1, -1}, {38750, -1, -1, -1}, {20127, -1, -1, -1}, {20141, -1, -1, -1}, {20142, -1, -1, -1}, {20449, -1, -1, -1}, {20405, -1, -1, -1}, {20399, -1, -1, -1}, {20415, -1, -1, -1}, {20448, -1, -1, -1}, {20433, -1, -1, -1}, {20431, -1, -1, -1}, {20445, -1, -1, -1}, {20419, -1, -1, -1}, {20406, -1, -1, -1}, {20440, -1, -1, -1}, {20447, -1, -1, -1}, {20426, -1, -1, -1}, {20439, -1, -1, -1}, {20398, -1, -1, -1}, {20432, -1, -1, -1}, {20420, -1, -1, -1}, {20418, -1, -1, -1}, {20442, -1, -1, -1}, {20430, -1, -1, -1}, {20446, -1, -1, -1}, {20407, -1, -1, -1}, {20823, -1, -1, -1}, {20882, -1, -1, -1}, {20881, -1, -1, -1}, {20896, -1, -1, -1}, {21070, -1, -1, -1}, {21059, -1, -1, -1}, {21066, -1, -1, -1}, {21069, -1, -1, -1}, {21068, -1, -1, -1}, {21067, -1, -1, -1}, {21063, -1, -1, -1}, {21191, -1, -1, -1}, {21193, -1, -1, -1}, {21187, -1, -1, -1}, {21185, -1, -1, -1}, {21261, -1, -1, -1}, {21335, -1, -1, -1}, {21371, -1, -1, -1}, {21402, -1, -1, -1}, {21467, -1, -1, -1}, {21676, -1, -1, -1}, {21696, -1, -1, -1}, {21672, -1, -1, -1}, {21710, -1, -1, -1}, {21705, -1, -1, -1}, {21688, -1, -1, -1}, {21670, -1, -1, -1}, {21683, -1, -1, -1}, {21703, -1, -1, -1}, {21698, -1, -1, -1}, {21693, -1, -1, -1}, {21674, -1, -1, -1}, {21697, -1, -1, -1}, {21700, -1, -1, -1}, {21704, -1, -1, -1}, {21679, -1, -1, -1}, {21675, -1, -1, -1}, {21681, -1, -1, -1}, {21691, -1, -1, -1}, {21673, -1, -1, -1}, {21671, -1, -1, -1}, {21695, -1, -1, -1}, {22271, -1, -1, -1}, {22402, -1, -1, -1}, {22411, -1, -1, -1}, {22432, -1, -1, -1}, {22435, -1, -1, -1}, {22434, -1, -1, -1}, {22478, -1, -1, -1}, {22446, -1, -1, -1}, {22419, -1, -1, -1}, {22869, -1, -1, -1}, {22865, -1, -1, -1}, {22863, -1, -1, -1}, {22862, -1, -1, -1}, {22864, -1, -1, -1}, {23004, -1, -1, -1}, {23000, -1, -1, -1}, {23039, -1, -1, -1}, {23011, -1, -1, -1}, {23016, -1, -1, -1}, {23043, -1, -1, -1}, {23013, -1, -1, -1}, {23018, -1, -1, -1}, {23002, -1, -1, -1}, {23014, -1, -1, -1}, {23041, -1, -1, -1}, {23035, -1, -1, -1} },
    {{23401, -1, -1, -1}, {23459, -1, -1, -1}, {23462, -1, -1, -1}, {23460, -1, -1, -1}, {23458, -1, -1, -1}, {23461, -1, -1, -1}, {23553, -1, -1, -1}, {23630, -1, -1, -1}, {23631, -1, -1, -1}, {23629, -1, -1, -1}, {23627, -1, -1, -1}, {23769, -1, -1, -1}, {23762, -1, -1, -1}, {24055, -1, -1, -1}, {24093, -1, -1, -1}, {24101, -1, -1, -1}, {24095, -1, -1, -1}, {24189, -1, -1, -1}, {24224, -1, -1, -1}, {24230, -1, -1, -1}, {24314, -1, -1, -1}, {24328, -1, -1, -1}, {24365, -1, -1, -1}, {24421, -1, -1, -1}, {24456, -1, -1, -1}, {24453, -1, -1, -1}, {24458, -1, -1, -1}, {24459, -1, -1, -1}, {24455, -1, -1, -1}, {24460, -1, -1, -1}, {24457, -1, -1, -1}, {24594, -1, -1, -1}, {24605, -1, -1, -1}, {24608, -1, -1, -1}, {24613, -1, -1, -1}, {24590, -1, -1, -1}, {24616, -1, -1, -1}, {24653, -1, -1, -1}, {24688, -1, -1, -1}, {24680, -1, -1, -1}, {24674, -1, -1, -1}, {24646, -1, -1, -1}, {24643, -1, -1, -1}, {24684, -1, -1, -1}, {24683, -1, -1, -1}, {24682, -1, -1, -1}, {24676, -1, -1, -1}, {25153, -1, -1, -1}, {25308, -1, -1, -1}, {25366, -1, -1, -1}, {25353, -1, -1, -1}, {25340, -1, -1, -1}, {25325, -1, -1, -1}, {25345, -1, -1, -1}, {25326, -1, -1, -1}, {25341, -1, -1, -1}, {25351, -1, -1, -1}, {25329, -1, -1, -1}, {25335, -1, -1, -1}, {25327, -1, -1, -1}, {25324, -1, -1, -1}, {25342, -1, -1, -1}, {25332, -1, -1, -1}, {25361, -1, -1, -1}, {25346, -1, -1, -1}, {25919, -1, -1, -1}, {25925, -1, -1, -1}, {26027, -1, -1, -1}, {26045, -1, -1, -1}, {26082, -1, -1, -1}, {26149, -1, -1, -1}, {26157, -1, -1, -1}, {26144, -1, -1, -1}, {26151, -1, -1, -1}, {26159, -1, -1, -1}, {26143, -1, -1, -1}, {26152, -1, -1, -1}, {26161, -1, -1, -1}, {26148, -1, -1, -1}, {26359, -1, -1, -1}, {26623, -1, -1, -1}, {26579, -1, -1, -1}, {26609, -1, -1, -1}, {26580, -1, -1, -1}, {26576, -1, -1, -1}, {26604, -1, -1, -1}, {26550, -1, -1, -1}, {26543, -1, -1, -1}, {26613, -1, -1, -1}, {26601, -1, -1, -1}, {26607, -1, -1, -1}, {26564, -1, -1, -1}, {26577, -1, -1, -1}, {26548, -1, -1, -1}, {26586, -1, -1, -1}, {26597, -1, -1, -1}, {26552, -1, -1, -1}, {26575, -1, -1, -1}, {26590, -1, -1, -1}, {26611, -1, -1, -1}, {26544, -1, -1, -1}, {26585, -1, -1, -1}, {26594, -1, -1, -1}, {26589, -1, -1, -1}, {26578, -1, -1, -1}, {27498, -1, -1, -1}, {27523, -1, -1, -1}, {27526, -1, -1, -1}, {27573, -1, -1, -1}, {27602, -1, -1, -1}, {27607, -1, -1, -1}, {27679, -1, -1, -1}, {27849, -1, -1, -1}, {27915, -1, -1, -1}, {27954, -1, -1, -1}, {27946, -1, -1, -1}, {27969, -1, -1, -1}, {27941, -1, -1, -1}, {27916, -1, -1, -1}, {27953, -1, -1, -1}, {27934, -1, -1, -1}, {27927, -1, -1, -1}, {27963, -1, -1, -1}, {27965, -1, -1, -1}, {27966, -1, -1, -1}, {27958, -1, -1, -1}, {27931, -1, -1, -1}, {27893, -1, -1, -1}, {27961, -1, -1, -1}, {27943, -1, -1, -1}, {27960, -1, -1, -1}, {27945, -1, -1, -1}, {27950, -1, -1, -1}, {27957, -1, -1, -1}, {27918, -1, -1, -1}, {27947, -1, -1, -1}, {28843, -1, -1, -1}, {28858, -1, -1, -1}, {28851, -1, -1, -1}, {28844, -1, -1, -1}, {28847, -1, -1, -1}, {28845, -1, -1, -1}, {28856, -1, -1, -1}, {28846, -1, -1, -1}, {28836, -1, -1, -1}, {29232, -1, -1, -1}, {29298, -1, -1, -1}, {29295, -1, -1, -1}, {29300, -1, -1, -1}, {29417, -1, -1, -1}, {29408, -1, -1, -1}, {29409, -1, -1, -1}, {29623, -1, -1, -1}, {29642, -1, -1, -1}, {29627, -1, -1, -1}, {29618, -1, -1, -1}, {29645, -1, -1, -1}, {29632, -1, -1, -1}, {29619, -1, -1, -1}, {29978, -1, -1, -1}, {29997, -1, -1, -1}, {30031, -1, -1, -1}, {30028, -1, -1, -1}, {30030, -1, -1, -1}, {30027, -1, -1, -1}, {30123, -1, -1, -1}, {30116, -1, -1, -1}, {30117, -1, -1, -1}, {30114, -1, -1, -1}, {30115, -1, -1, -1}, {30328, -1, -1, -1}, {30342, -1, -1, -1}, {30343, -1, -1, -1}, {30344, -1, -1, -1}, {30408, -1, -1, -1}, {30406, -1, -1, -1}, {30403, -1, -1, -1}, {30405, -1, -1, -1}, {30465, -1, -1, -1}, {30457, -1, -1, -1}, {30456, -1, -1, -1}, {30473, -1, -1, -1}, {30475, -1, -1, -1}, {30462, -1, -1, -1}, {30460, -1, -1, -1}, {30471, -1, -1, -1}, {30684, -1, -1, -1}, {30722, -1, -1, -1}, {30740, -1, -1, -1}, {30732, -1, -1, -1}, {30733, -1, -1, -1}, {31046, -1, -1, -1}, {31049, -1, -1, -1}, {31048, -1, -1, -1}, {31047, -1, -1, -1}, {31161, -1, -1, -1}, {31162, -1, -1, -1}, {31185, -1, -1, -1}, {31186, -1, -1, -1}, {31179, -1, -1, -1}, {31359, -1, -1, -1}, {31361, -1, -1, -1}, {31487, -1, -1, -1}, {31485, -1, -1, -1}, {31869, -1, -1, -1}, {32002, -1, -1, -1}, {32005, -1, -1, -1}, {32000, -1, -1, -1}, {32009, -1, -1, -1}, {32007, -1, -1, -1}, {32004, -1, -1, -1}, {32006, -1, -1, -1}, {32568, -1, -1, -1}, {32654, -1, -1, -1}, {32703, -1, -1, -1}, {32784, -1, -1, -1}, {32781, -1, -1, -1}, {32785, -1, -1, -1}, {32822, -1, -1, -1}, {32982, -1, -1, -1}, {32997, -1, -1, -1}, {32986, -1, -1, -1}, {32963, -1, -1, -1}, {32964, -1, -1, -1}, {32972, -1, -1, -1}, {32993, -1, -1, -1}, {32987, -1, -1, -1}, {32974, -1, -1, -1}, {32990, -1, -1, -1}, {32996, -1, -1, -1}, {32989, -1, -1, -1}, {33268, -1, -1, -1}, {33314, -1, -1, -1}, {33511, -1, -1, -1}, {33539, -1, -1, -1}, {33541, -1, -1, -1}, {33507, -1, -1, -1}, {33499, -1, -1, -1}, {33510, -1, -1, -1}, {33540, -1, -1, -1}, {33509, -1, -1, -1}, {33538, -1, -1, -1}, {33545, -1, -1, -1}, {33490, -1, -1, -1}, {33495, -1, -1, -1}, {33521, -1, -1, -1}, {33537, -1, -1, -1}, {33500, -1, -1, -1}, {33492, -1, -1, -1}, {33489, -1, -1, -1}, {33502, -1, -1, -1}, {33491, -1, -1, -1}, {33503, -1, -1, -1}, {33519, -1, -1, -1}, {33542, -1, -1, -1}, {34384, -1, -1, -1} },
    {{34425, -1, -1, -1}, {34427, -1, -1, -1}, {34426, -1, -1, -1}, {34893, -1, -1, -1}, {34923, -1, -1, -1}, {35201, -1, -1, -1}, {35284, -1, -1, -1}, {35336, -1, -1, -1}, {35330, -1, -1, -1}, {35331, -1, -1, -1}, {35998, -1, -1, -1}, {36000, -1, -1, -1}, {36212, -1, -1, -1}, {36211, -1, -1, -1}, {36276, -1, -1, -1}, {36557, -1, -1, -1}, {36556, -1, -1, -1}, {36848, -1, -1, -1}, {36838, -1, -1, -1}, {36834, -1, -1, -1}, {36842, -1, -1, -1}, {36837, -1, -1, -1}, {36845, -1, -1, -1}, {36843, -1, -1, -1}, {36836, -1, -1, -1}, {36840, -1, -1, -1}, {37066, -1, -1, -1}, {37070, -1, -1, -1}, {37057, -1, -1, -1}, {37059, -1, -1, -1}, {37195, -1, -1, -1}, {37194, -1, -1, -1}, {37325, -1, -1, -1}, {38274, -1, -1, -1}, {38480, -1, -1, -1}, {38475, -1, -1, -1}, {38476, -1, -1, -1}, {38477, -1, -1, -1}, {38754, -1, -1, -1}, {38761, -1, -1, -1}, {38859, -1, -1, -1}, {38893, -1, -1, -1}, {38899, -1, -1, -1}, {38913, -1, -1, -1}, {39080, -1, -1, -1}, {39131, -1, -1, -1}, {39135, -1, -1, -1}, {39318, -1, -1, -1}, {39321, -1, -1, -1}, {20056, -1, -1, -1}, {20147, -1, -1, -1}, {20492, -1, -1, -1}, {20493, -1, -1, -1}, {20515, -1, -1, -1}, {20463, -1, -1, -1}, {20518, -1, -1, -1}, {20517, -1, -1, -1}, {20472, -1, -1, -1}, {20521, -1, -1, -1}, {20502, -1, -1, -1}, {20486, -1, -1, -1}, {20540, -1, -1, -1}, {20511, -1, -1, -1}, {20506, -1, -1, -1}, {20498, -1, -1, -1}, {20497, -1, -1, -1}, {20474, -1, -1, -1}, {20480, -1, -1, -1}, {20500, -1, -1, -1}, {20520, -1, -1, -1}, {20465, -1, -1, -1}, {20513, -1, -1, -1}, {20491, -1, -1, -1}, {20505, -1, -1, -1}, {20504, -1, -1, -1}, {20467, -1, -1, -1}, {20462, -1, -1, -1}, {20525, -1, -1, -1}, {20522, -1, -1, -1}, {20478, -1, -1, -1}, {20523, -1, -1, -1}, {20489, -1, -1, -1}, {20860, -1, -1, -1}, {20900, -1, -1, -1}, {20901, -1, -1, -1}, {20898, -1, -1, -1}, {20941, -1, -1, -1}, {20940, -1, -1, -1}, {20934, -1, -1, -1}, {20939, -1, -1, -1}, {21078, -1, -1, -1}, {21084, -1, -1, -1}, {21076, -1, -1, -1}, {21083, -1, -1, -1}, {21085, -1, -1, -1}, {21290, -1, -1, -1}, {21375, -1, -1, -1}, {21407, -1, -1, -1}, {21405, -1, -1, -1}, {21471, -1, -1, -1}, {21736, -1, -1, -1}, {21776, -1, -1, -1}, {21761, -1, -1, -1}, {21815, -1, -1, -1}, {21756, -1, -1, -1}, {21733, -1, -1, -1}, {21746, -1, -1, -1}, {21766, -1, -1, -1}, {21754, -1, -1, -1}, {21780, -1, -1, -1}, {21737, -1, -1, -1}, {21741, -1, -1, -1}, {21729, -1, -1, -1}, {21769, -1, -1, -1}, {21742, -1, -1, -1}, {21738, -1, -1, -1}, {21734, -1, -1, -1}, {21799, -1, -1, -1}, {21767, -1, -1, -1}, {21757, -1, -1, -1}, {21775, -1, -1, -1}, {22275, -1, -1, -1}, {22276, -1, -1, -1}, {22466, -1, -1, -1}, {22484, -1, -1, -1}, {22475, -1, -1, -1}, {22467, -1, -1, -1}, {22537, -1, -1, -1}, {22799, -1, -1, -1}, {22871, -1, -1, -1}, {22872, -1, -1, -1}, {22874, -1, -1, -1}, {23057, -1, -1, -1}, {23064, -1, -1, -1}, {23068, -1, -1, -1}, {23071, -1, -1, -1}, {23067, -1, -1, -1}, {23059, -1, -1, -1}, {23020, -1, -1, -1}, {23072, -1, -1, -1}, {23075, -1, -1, -1}, {23081, -1, -1, -1}, {23077, -1, -1, -1}, {23052, -1, -1, -1}, {23049, -1, -1, -1}, {23403, -1, -1, -1}, {23640, -1, -1, -1}, {23472, -1, -1, -1}, {23475, -1, -1, -1}, {23478, -1, -1, -1}, {23476, -1, -1, -1}, {23470, -1, -1, -1}, {23477, -1, -1, -1}, {23481, -1, -1, -1}, {23480, -1, -1, -1}, {23556, -1, -1, -1}, {23633, -1, -1, -1}, {23637, -1, -1, -1}, {23632, -1, -1, -1}, {23789, -1, -1, -1}, {23805, -1, -1, -1}, {23803, -1, -1, -1}, {23786, -1, -1, -1}, {23784, -1, -1, -1}, {23792, -1, -1, -1}, {23798, -1, -1, -1}, {23809, -1, -1, -1}, {23796, -1, -1, -1}, {24046, -1, -1, -1}, {24109, -1, -1, -1}, {24107, -1, -1, -1}, {24235, -1, -1, -1}, {24237, -1, -1, -1}, {24231, -1, -1, -1}, {24369, -1, -1, -1}, {24466, -1, -1, -1}, {24465, -1, -1, -1}, {24464, -1, -1, -1}, {24665, -1, -1, -1}, {24675, -1, -1, -1}, {24677, -1, -1, -1}, {24656, -1, -1, -1}, {24661, -1, -1, -1}, {24685, -1, -1, -1}, {24681, -1, -1, -1}, {24687, -1, -1, -1}, {24708, -1, -1, -1}, {24735, -1, -1, -1}, {24730, -1, -1, -1}, {24717, -1, -1, -1}, {24724, -1, -1, -1}, {24716, -1, -1, -1}, {24709, -1, -1, -1}, {24726, -1, -1, -1}, {25159, -1, -1, -1}, {25331, -1, -1, -1}, {25352, -1, -1, -1}, {25343, -1, -1, -1}, {25422, -1, -1, -1}, {25406, -1, -1, -1}, {25391, -1, -1, -1}, {25429, -1, -1, -1}, {25410, -1, -1, -1}, {25414, -1, -1, -1}, {25423, -1, -1, -1}, {25417, -1, -1, -1}, {25402, -1, -1, -1}, {25424, -1, -1, -1}, {25405, -1, -1, -1}, {25386, -1, -1, -1}, {25387, -1, -1, -1}, {25384, -1, -1, -1}, {25421, -1, -1, -1}, {25420, -1, -1, -1}, {25928, -1, -1, -1}, {25929, -1, -1, -1}, {26009, -1, -1, -1}, {26049, -1, -1, -1}, {26053, -1, -1, -1}, {26178, -1, -1, -1}, {26185, -1, -1, -1}, {26191, -1, -1, -1}, {26179, -1, -1, -1}, {26194, -1, -1, -1}, {26188, -1, -1, -1}, {26181, -1, -1, -1}, {26177, -1, -1, -1}, {26360, -1, -1, -1}, {26388, -1, -1, -1}, {26389, -1, -1, -1}, {26391, -1, -1, -1}, {26657, -1, -1, -1}, {26680, -1, -1, -1}, {26696, -1, -1, -1}, {26694, -1, -1, -1}, {26707, -1, -1, -1}, {26681, -1, -1, -1}, {26690, -1, -1, -1}, {26708, -1, -1, -1}, {26665, -1, -1, -1}, {26803, -1, -1, -1}, {26647, -1, -1, -1}, {26700, -1, -1, -1}, {26705, -1, -1, -1}, {26685, -1, -1, -1}, {26612, -1, -1, -1}, {26704, -1, -1, -1}, {26688, -1, -1, -1}, {26684, -1, -1, -1}, {26691, -1, -1, -1}, {26666, -1, -1, -1}, {26693, -1, -1, -1}, {26643, -1, -1, -1}, {26648, -1, -1, -1}, {26689, -1, -1, -1}, {27530, -1, -1, -1} },
    {{27529, -1, -1, -1}, {27575, -1, -1, -1}, {27683, -1, -1, -1}, {27687, -1, -1, -1}, {27688, -1, -1, -1}, {27686, -1, -1, -1}, {27684, -1, -1, -1}, {27888, -1, -1, -1}, {28010, -1, -1, -1}, {28053, -1, -1, -1}, {28040, -1, -1, -1}, {28039, -1, -1, -1}, {28006, -1, -1, -1}, {28024, -1, -1, -1}, {28023, -1, -1, -1}, {27993, -1, -1, -1}, {28051, -1, -1, -1}, {28012, -1, -1, -1}, {28041, -1, -1, -1}, {28014, -1, -1, -1}, {27994, -1, -1, -1}, {28020, -1, -1, -1}, {28009, -1, -1, -1}, {28044, -1, -1, -1}, {28042, -1, -1, -1}, {28025, -1, -1, -1}, {28037, -1, -1, -1}, {28005, -1, -1, -1}, {28052, -1, -1, -1}, {28874, -1, -1, -1}, {28888, -1, -1, -1}, {28900, -1, -1, -1}, {28889, -1, -1, -1}, {28872, -1, -1, -1}, {28879, -1, -1, -1}, {29241, -1, -1, -1}, {29305, -1, -1, -1}, {29436, -1, -1, -1}, {29433, -1, -1, -1}, {29437, -1, -1, -1}, {29432, -1, -1, -1}, {29431, -1, -1, -1}, {29574, -1, -1, -1}, {29677, -1, -1, -1}, {29705, -1, -1, -1}, {29678, -1, -1, -1}, {29664, -1, -1, -1}, {29674, -1, -1, -1}, {29662, -1, -1, -1}, {30036, -1, -1, -1}, {30045, -1, -1, -1}, {30044, -1, -1, -1}, {30042, -1, -1, -1}, {30041, -1, -1, -1}, {30142, -1, -1, -1}, {30149, -1, -1, -1}, {30151, -1, -1, -1}, {30130, -1, -1, -1}, {30131, -1, -1, -1}, {30141, -1, -1, -1}, {30140, -1, -1, -1}, {30137, -1, -1, -1}, {30146, -1, -1, -1}, {30136, -1, -1, -1}, {30347, -1, -1, -1}, {30384, -1, -1, -1}, {30410, -1, -1, -1}, {30413, -1, -1, -1}, {30414, -1, -1, -1}, {30505, -1, -1, -1}, {30495, -1, -1, -1}, {30496, -1, -1, -1}, {30504, -1, -1, -1}, {30697, -1, -1, -1}, {30768, -1, -1, -1}, {30759, -1, -1, -1}, {30776, -1, -1, -1}, {30749, -1, -1, -1}, {30772, -1, -1, -1}, {30775, -1, -1, -1}, {30757, -1, -1, -1}, {30765, -1, -1, -1}, {30752, -1, -1, -1}, {30751, -1, -1, -1}, {30770, -1, -1, -1}, {31061, -1, -1, -1}, {31056, -1, -1, -1}, {31072, -1, -1, -1}, {31071, -1, -1, -1}, {31062, -1, -1, -1}, {31070, -1, -1, -1}, {31069, -1, -1, -1}, {31063, -1, -1, -1}, {31066, -1, -1, -1}, {31204, -1, -1, -1}, {31203, -1, -1, -1}, {31207, -1, -1, -1}, {31199, -1, -1, -1}, {31206, -1, -1, -1}, {31209, -1, -1, -1}, {31192, -1, -1, -1}, {31364, -1, -1, -1}, {31368, -1, -1, -1}, {31449, -1, -1, -1}, {31494, -1, -1, -1}, {31505, -1, -1, -1}, {31881, -1, -1, -1}, {32033, -1, -1, -1}, {32023, -1, -1, -1}, {32011, -1, -1, -1}, {32010, -1, -1, -1}, {32032, -1, -1, -1}, {32034, -1, -1, -1}, {32020, -1, -1, -1}, {32016, -1, -1, -1}, {32021, -1, -1, -1}, {32026, -1, -1, -1}, {32028, -1, -1, -1}, {32013, -1, -1, -1}, {32025, -1, -1, -1}, {32027, -1, -1, -1}, {32570, -1, -1, -1}, {32607, -1, -1, -1}, {32660, -1, -1, -1}, {32709, -1, -1, -1}, {32705, -1, -1, -1}, {32774, -1, -1, -1}, {32772, -1, -1, -1}, {32792, -1, -1, -1}, {32789, -1, -1, -1}, {32793, -1, -1, -1}, {32791, -1, -1, -1}, {32829, -1, -1, -1}, {32831, -1, -1, -1}, {33009, -1, -1, -1}, {33026, -1, -1, -1}, {33008, -1, -1, -1}, {33029, -1, -1, -1}, {33005, -1, -1, -1}, {33012, -1, -1, -1}, {33030, -1, -1, -1}, {33016, -1, -1, -1}, {33011, -1, -1, -1}, {33032, -1, -1, -1}, {33021, -1, -1, -1}, {33034, -1, -1, -1}, {33020, -1, -1, -1}, {33007, -1, -1, -1}, {33261, -1, -1, -1}, {33260, -1, -1, -1}, {33280, -1, -1, -1}, {33296, -1, -1, -1}, {33322, -1, -1, -1}, {33323, -1, -1, -1}, {33320, -1, -1, -1}, {33324, -1, -1, -1}, {33467, -1, -1, -1}, {33579, -1, -1, -1}, {33618, -1, -1, -1}, {33620, -1, -1, -1}, {33610, -1, -1, -1}, {33592, -1, -1, -1}, {33616, -1, -1, -1}, {33609, -1, -1, -1}, {33589, -1, -1, -1}, {33588, -1, -1, -1}, {33615, -1, -1, -1}, {33586, -1, -1, -1}, {33593, -1, -1, -1}, {33590, -1, -1, -1}, {33559, -1, -1, -1}, {33600, -1, -1, -1}, {33585, -1, -1, -1}, {33576, -1, -1, -1}, {33603, -1, -1, -1}, {34388, -1, -1, -1}, {34442, -1, -1, -1}, {34474, -1, -1, -1}, {34451, -1, -1, -1}, {34468, -1, -1, -1}, {34473, -1, -1, -1}, {34444, -1, -1, -1}, {34467, -1, -1, -1}, {34460, -1, -1, -1}, {34928, -1, -1, -1}, {34935, -1, -1, -1}, {34945, -1, -1, -1}, {34946, -1, -1, -1}, {34941, -1, -1, -1}, {34937, -1, -1, -1}, {35352, -1, -1, -1}, {35344, -1, -1, -1}, {35342, -1, -1, -1}, {35340, -1, -1, -1}, {35349, -1, -1, -1}, {35338, -1, -1, -1}, {35351, -1, -1, -1}, {35347, -1, -1, -1}, {35350, -1, -1, -1}, {35343, -1, -1, -1}, {35345, -1, -1, -1}, {35912, -1, -1, -1}, {35962, -1, -1, -1}, {35961, -1, -1, -1}, {36001, -1, -1, -1}, {36002, -1, -1, -1}, {36215, -1, -1, -1}, {36524, -1, -1, -1}, {36562, -1, -1, -1}, {36564, -1, -1, -1}, {36559, -1, -1, -1}, {36785, -1, -1, -1}, {36865, -1, -1, -1}, {36870, -1, -1, -1}, {36855, -1, -1, -1}, {36864, -1, -1, -1}, {36858, -1, -1, -1}, {36852, -1, -1, -1}, {36867, -1, -1, -1}, {36861, -1, -1, -1}, {36869, -1, -1, -1}, {36856, -1, -1, -1}, {37013, -1, -1, -1}, {37089, -1, -1, -1}, {37085, -1, -1, -1}, {37090, -1, -1, -1}, {37202, -1, -1, -1}, {37197, -1, -1, -1}, {37196, -1, -1, -1}, {37336, -1, -1, -1}, {37341, -1, -1, -1}, {37335, -1, -1, -1}, {37340, -1, -1, -1}, {37337, -1, -1, -1}, {38275, -1, -1, -1}, {38498, -1, -1, -1}, {38499, -1, -1, -1}, {38497, -1, -1, -1}, {38491, -1, -1, -1}, {38493, -1, -1, -1}, {38500, -1, -1, -1}, {38488, -1, -1, -1}, {38494, -1, -1, -1}, {38587, -1, -1, -1}, {39138, -1, -1, -1}, {39340, -1, -1, -1}, {12003, 39592, -1, -1}, {39640, -1, -1, -1}, {39717, -1, -1, -1}, {39730, -1, -1, -1}, {39740, -1, -1, -1}, {20094, -1, -1, -1}, {20602, -1, -1, -1}, {20605, -1, -1, -1}, {20572, -1, -1, -1}, {20551, -1, -1, -1} },
    {{20547, -1, -1, -1}, {20556, -1, -1, -1}, {20570, -1, -1, -1}, {20553, -1, -1, -1}, {20581, -1, -1, -1}, {20598, -1, -1, -1}, {20558, -1, -1, -1}, {20565, -1, -1, -1}, {20597, -1, -1, -1}, {20596, -1, -1, -1}, {20599, -1, -1, -1}, {20559, -1, -1, -1}, {20495, -1, -1, -1}, {20591, -1, -1, -1}, {20589, -1, -1, -1}, {20828, -1, -1, -1}, {20885, -1, -1, -1}, {20976, -1, -1, -1}, {21098, -1, -1, -1}, {21103, -1, -1, -1}, {21202, -1, -1, -1}, {21209, -1, -1, -1}, {21208, -1, -1, -1}, {21205, -1, -1, -1}, {21264, -1, -1, -1}, {21263, -1, -1, -1}, {21273, -1, -1, -1}, {21311, -1, -1, -1}, {21312, -1, -1, -1}, {21310, -1, -1, -1}, {21443, -1, -1, -1}, {26364, -1, -1, -1}, {21830, -1, -1, -1}, {21866, -1, -1, -1}, {21862, -1, -1, -1}, {21828, -1, -1, -1}, {21854, -1, -1, -1}, {21857, -1, -1, -1}, {21827, -1, -1, -1}, {21834, -1, -1, -1}, {21809, -1, -1, -1}, {21846, -1, -1, -1}, {21839, -1, -1, -1}, {21845, -1, -1, -1}, {21807, -1, -1, -1}, {21860, -1, -1, -1}, {21816, -1, -1, -1}, {21806, -1, -1, -1}, {21852, -1, -1, -1}, {21804, -1, -1, -1}, {21859, -1, -1, -1}, {21811, -1, -1, -1}, {21825, -1, -1, -1}, {21847, -1, -1, -1}, {22280, -1, -1, -1}, {22283, -1, -1, -1}, {22281, -1, -1, -1}, {22495, -1, -1, -1}, {22533, -1, -1, -1}, {22538, -1, -1, -1}, {22534, -1, -1, -1}, {22496, -1, -1, -1}, {22500, -1, -1, -1}, {22522, -1, -1, -1}, {22530, -1, -1, -1}, {22581, -1, -1, -1}, {22519, -1, -1, -1}, {22521, -1, -1, -1}, {22816, -1, -1, -1}, {22882, -1, -1, -1}, {23094, -1, -1, -1}, {23105, -1, -1, -1}, {23113, -1, -1, -1}, {23142, -1, -1, -1}, {23146, -1, -1, -1}, {23104, -1, -1, -1}, {23100, -1, -1, -1}, {23138, -1, -1, -1}, {23130, -1, -1, -1}, {23110, -1, -1, -1}, {23114, -1, -1, -1}, {23408, -1, -1, -1}, {23495, -1, -1, -1}, {23493, -1, -1, -1}, {23492, -1, -1, -1}, {23490, -1, -1, -1}, {23487, -1, -1, -1}, {23494, -1, -1, -1}, {23561, -1, -1, -1}, {23560, -1, -1, -1}, {23559, -1, -1, -1}, {23648, -1, -1, -1}, {23644, -1, -1, -1}, {23645, -1, -1, -1}, {23815, -1, -1, -1}, {23814, -1, -1, -1}, {23822, -1, -1, -1}, {23835, -1, -1, -1}, {23830, -1, -1, -1}, {23842, -1, -1, -1}, {23825, -1, -1, -1}, {23849, -1, -1, -1}, {23828, -1, -1, -1}, {23833, -1, -1, -1}, {23844, -1, -1, -1}, {23847, -1, -1, -1}, {23831, -1, -1, -1}, {24034, -1, -1, -1}, {24120, -1, -1, -1}, {24118, -1, -1, -1}, {24115, -1, -1, -1}, {24119, -1, -1, -1}, {24247, -1, -1, -1}, {24248, -1, -1, -1}, {24246, -1, -1, -1}, {24245, -1, -1, -1}, {24254, -1, -1, -1}, {24373, -1, -1, -1}, {24375, -1, -1, -1}, {24407, -1, -1, -1}, {24428, -1, -1, -1}, {24425, -1, -1, -1}, {24427, -1, -1, -1}, {24471, -1, -1, -1}, {24473, -1, -1, -1}, {24478, -1, -1, -1}, {24472, -1, -1, -1}, {24481, -1, -1, -1}, {24480, -1, -1, -1}, {24476, -1, -1, -1}, {24703, -1, -1, -1}, {24739, -1, -1, -1}, {24713, -1, -1, -1}, {24736, -1, -1, -1}, {24744, -1, -1, -1}, {24779, -1, -1, -1}, {24756, -1, -1, -1}, {24806, -1, -1, -1}, {24765, -1, -1, -1}, {24773, -1, -1, -1}, {24763, -1, -1, -1}, {24757, -1, -1, -1}, {24796, -1, -1, -1}, {24764, -1, -1, -1}, {24792, -1, -1, -1}, {24789, -1, -1, -1}, {24774, -1, -1, -1}, {24799, -1, -1, -1}, {24760, -1, -1, -1}, {24794, -1, -1, -1}, {24775, -1, -1, -1}, {25114, -1, -1, -1}, {25115, -1, -1, -1}, {25160, -1, -1, -1}, {25504, -1, -1, -1}, {25511, -1, -1, -1}, {25458, -1, -1, -1}, {25494, -1, -1, -1}, {25506, -1, -1, -1}, {25509, -1, -1, -1}, {25463, -1, -1, -1}, {25447, -1, -1, -1}, {25496, -1, -1, -1}, {25514, -1, -1, -1}, {25457, -1, -1, -1}, {25513, -1, -1, -1}, {25481, -1, -1, -1}, {25475, -1, -1, -1}, {25499, -1, -1, -1}, {25451, -1, -1, -1}, {25512, -1, -1, -1}, {25476, -1, -1, -1}, {25480, -1, -1, -1}, {25497, -1, -1, -1}, {25505, -1, -1, -1}, {25516, -1, -1, -1}, {25490, -1, -1, -1}, {25487, -1, -1, -1}, {25472, -1, -1, -1}, {25467, -1, -1, -1}, {25449, -1, -1, -1}, {25448, -1, -1, -1}, {25466, -1, -1, -1}, {25949, -1, -1, -1}, {25942, -1, -1, -1}, {25937, -1, -1, -1}, {25945, -1, -1, -1}, {25943, -1, -1, -1}, {21855, -1, -1, -1}, {25935, -1, -1, -1}, {25944, -1, -1, -1}, {25941, -1, -1, -1}, {25940, -1, -1, -1}, {26012, -1, -1, -1}, {26011, -1, -1, -1}, {26028, -1, -1, -1}, {26063, -1, -1, -1}, {26059, -1, -1, -1}, {26060, -1, -1, -1}, {26062, -1, -1, -1}, {26205, -1, -1, -1}, {26202, -1, -1, -1}, {26212, -1, -1, -1}, {26216, -1, -1, -1}, {26214, -1, -1, -1}, {26206, -1, -1, -1}, {26361, -1, -1, -1}, {21207, -1, -1, -1}, {26395, -1, -1, -1}, {26753, -1, -1, -1}, {26799, -1, -1, -1}, {26786, -1, -1, -1}, {26771, -1, -1, -1}, {26805, -1, -1, -1}, {26751, -1, -1, -1}, {26742, -1, -1, -1}, {26801, -1, -1, -1}, {26791, -1, -1, -1}, {26775, -1, -1, -1}, {26800, -1, -1, -1}, {26755, -1, -1, -1}, {26820, -1, -1, -1}, {26797, -1, -1, -1}, {26758, -1, -1, -1}, {26757, -1, -1, -1}, {26772, -1, -1, -1}, {26781, -1, -1, -1}, {26792, -1, -1, -1}, {26783, -1, -1, -1}, {26785, -1, -1, -1}, {26754, -1, -1, -1}, {27442, -1, -1, -1}, {27578, -1, -1, -1}, {27627, -1, -1, -1}, {27628, -1, -1, -1}, {27691, -1, -1, -1}, {28046, -1, -1, -1}, {28092, -1, -1, -1}, {28147, -1, -1, -1}, {28121, -1, -1, -1}, {28082, -1, -1, -1}, {28129, -1, -1, -1}, {28108, -1, -1, -1}, {28132, -1, -1, -1}, {28155, -1, -1, -1}, {28154, -1, -1, -1}, {28165, -1, -1, -1}, {28103, -1, -1, -1}, {28107, -1, -1, -1}, {28079, -1, -1, -1}, {28113, -1, -1, -1}, {28078, -1, -1, -1}, {28126, -1, -1, -1}, {28153, -1, -1, -1}, {28088, -1, -1, -1}, {28151, -1, -1, -1} },
    {{28149, -1, -1, -1}, {28101, -1, -1, -1}, {28114, -1, -1, -1}, {28186, -1, -1, -1}, {28085, -1, -1, -1}, {28122, -1, -1, -1}, {28139, -1, -1, -1}, {28120, -1, -1, -1}, {28138, -1, -1, -1}, {28145, -1, -1, -1}, {28142, -1, -1, -1}, {28136, -1, -1, -1}, {28102, -1, -1, -1}, {28100, -1, -1, -1}, {28074, -1, -1, -1}, {28140, -1, -1, -1}, {28095, -1, -1, -1}, {28134, -1, -1, -1}, {28921, -1, -1, -1}, {28937, -1, -1, -1}, {28938, -1, -1, -1}, {28925, -1, -1, -1}, {28911, -1, -1, -1}, {29245, -1, -1, -1}, {29309, -1, -1, -1}, {29313, -1, -1, -1}, {29468, -1, -1, -1}, {29467, -1, -1, -1}, {29462, -1, -1, -1}, {29459, -1, -1, -1}, {29465, -1, -1, -1}, {29575, -1, -1, -1}, {29701, -1, -1, -1}, {29706, -1, -1, -1}, {29699, -1, -1, -1}, {29702, -1, -1, -1}, {29694, -1, -1, -1}, {29709, -1, -1, -1}, {29920, -1, -1, -1}, {29942, -1, -1, -1}, {29943, -1, -1, -1}, {29980, -1, -1, -1}, {29986, -1, -1, -1}, {30053, -1, -1, -1}, {30054, -1, -1, -1}, {30050, -1, -1, -1}, {30064, -1, -1, -1}, {30095, -1, -1, -1}, {30164, -1, -1, -1}, {30165, -1, -1, -1}, {30133, -1, -1, -1}, {30154, -1, -1, -1}, {30157, -1, -1, -1}, {30350, -1, -1, -1}, {30420, -1, -1, -1}, {30418, -1, -1, -1}, {30427, -1, -1, -1}, {30519, -1, -1, -1}, {30526, -1, -1, -1}, {30524, -1, -1, -1}, {30518, -1, -1, -1}, {30520, -1, -1, -1}, {30522, -1, -1, -1}, {30827, -1, -1, -1}, {30787, -1, -1, -1}, {30798, -1, -1, -1}, {31077, -1, -1, -1}, {31080, -1, -1, -1}, {31085, -1, -1, -1}, {31227, -1, -1, -1}, {31378, -1, -1, -1}, {31381, -1, -1, -1}, {31520, -1, -1, -1}, {31528, -1, -1, -1}, {31515, -1, -1, -1}, {31532, -1, -1, -1}, {31526, -1, -1, -1}, {31513, -1, -1, -1}, {31518, -1, -1, -1}, {31534, -1, -1, -1}, {31890, -1, -1, -1}, {31895, -1, -1, -1}, {31893, -1, -1, -1}, {32070, -1, -1, -1}, {32067, -1, -1, -1}, {32113, -1, -1, -1}, {32046, -1, -1, -1}, {32057, -1, -1, -1}, {32060, -1, -1, -1}, {32064, -1, -1, -1}, {32048, -1, -1, -1}, {32051, -1, -1, -1}, {32068, -1, -1, -1}, {32047, -1, -1, -1}, {32066, -1, -1, -1}, {32050, -1, -1, -1}, {32049, -1, -1, -1}, {32573, -1, -1, -1}, {32670, -1, -1, -1}, {32666, -1, -1, -1}, {32716, -1, -1, -1}, {32718, -1, -1, -1}, {32722, -1, -1, -1}, {32796, -1, -1, -1}, {32842, -1, -1, -1}, {32838, -1, -1, -1}, {33071, -1, -1, -1}, {33046, -1, -1, -1}, {33059, -1, -1, -1}, {33067, -1, -1, -1}, {33065, -1, -1, -1}, {33072, -1, -1, -1}, {33060, -1, -1, -1}, {33282, -1, -1, -1}, {33333, -1, -1, -1}, {33335, -1, -1, -1}, {33334, -1, -1, -1}, {33337, -1, -1, -1}, {33678, -1, -1, -1}, {33694, -1, -1, -1}, {33688, -1, -1, -1}, {33656, -1, -1, -1}, {33698, -1, -1, -1}, {33686, -1, -1, -1}, {33725, -1, -1, -1}, {33707, -1, -1, -1}, {33682, -1, -1, -1}, {33674, -1, -1, -1}, {33683, -1, -1, -1}, {33673, -1, -1, -1}, {33696, -1, -1, -1}, {33655, -1, -1, -1}, {33659, -1, -1, -1}, {33660, -1, -1, -1}, {33670, -1, -1, -1}, {33703, -1, -1, -1}, {34389, -1, -1, -1}, {24426, -1, -1, -1}, {34503, -1, -1, -1}, {34496, -1, -1, -1}, {34486, -1, -1, -1}, {34500, -1, -1, -1}, {34485, -1, -1, -1}, {34502, -1, -1, -1}, {34507, -1, -1, -1}, {34481, -1, -1, -1}, {34479, -1, -1, -1}, {34505, -1, -1, -1}, {34899, -1, -1, -1}, {34974, -1, -1, -1}, {34952, -1, -1, -1}, {34987, -1, -1, -1}, {34962, -1, -1, -1}, {34966, -1, -1, -1}, {34957, -1, -1, -1}, {34955, -1, -1, -1}, {35219, -1, -1, -1}, {35215, -1, -1, -1}, {35370, -1, -1, -1}, {35357, -1, -1, -1}, {35363, -1, -1, -1}, {35365, -1, -1, -1}, {35377, -1, -1, -1}, {35373, -1, -1, -1}, {35359, -1, -1, -1}, {35355, -1, -1, -1}, {35362, -1, -1, -1}, {35913, -1, -1, -1}, {35930, -1, -1, -1}, {36009, -1, -1, -1}, {36012, -1, -1, -1}, {36011, -1, -1, -1}, {36008, -1, -1, -1}, {36010, -1, -1, -1}, {36007, -1, -1, -1}, {36199, -1, -1, -1}, {36198, -1, -1, -1}, {36286, -1, -1, -1}, {36282, -1, -1, -1}, {36571, -1, -1, -1}, {36575, -1, -1, -1}, {36889, -1, -1, -1}, {36877, -1, -1, -1}, {36890, -1, -1, -1}, {36887, -1, -1, -1}, {36899, -1, -1, -1}, {36895, -1, -1, -1}, {36893, -1, -1, -1}, {36880, -1, -1, -1}, {36885, -1, -1, -1}, {36894, -1, -1, -1}, {36896, -1, -1, -1}, {36879, -1, -1, -1}, {36898, -1, -1, -1}, {36886, -1, -1, -1}, {36891, -1, -1, -1}, {36884, -1, -1, -1}, {37096, -1, -1, -1}, {37101, -1, -1, -1}, {37117, -1, -1, -1}, {37207, -1, -1, -1}, {37326, -1, -1, -1}, {37365, -1, -1, -1}, {37350, -1, -1, -1}, {37347, -1, -1, -1}, {37351, -1, -1, -1}, {37357, -1, -1, -1}, {37353, -1, -1, -1}, {38281, -1, -1, -1}, {38506, -1, -1, -1}, {38517, -1, -1, -1}, {38515, -1, -1, -1}, {38520, -1, -1, -1}, {38512, -1, -1, -1}, {38516, -1, -1, -1}, {38518, -1, -1, -1}, {38519, -1, -1, -1}, {38508, -1, -1, -1}, {38592, -1, -1, -1}, {38634, -1, -1, -1}, {38633, -1, -1, -1}, {31456, -1, -1, -1}, {31455, -1, -1, -1}, {38914, -1, -1, -1}, {38915, -1, -1, -1}, {39770, -1, -1, -1}, {40165, -1, -1, -1}, {40565, -1, -1, -1}, {40575, -1, -1, -1}, {40613, -1, -1, -1}, {40635, -1, -1, -1}, {20642, -1, -1, -1}, {20621, -1, -1, -1}, {20613, -1, -1, -1}, {20633, -1, -1, -1}, {20625, -1, -1, -1}, {20608, -1, -1, -1}, {20630, -1, -1, -1}, {20632, -1, -1, -1}, {20634, -1, -1, -1}, {26368, -1, -1, -1}, {20977, -1, -1, -1}, {21106, -1, -1, -1}, {21108, -1, -1, -1}, {21109, -1, -1, -1}, {21097, -1, -1, -1}, {21214, -1, -1, -1}, {21213, -1, -1, -1}, {21211, -1, -1, -1}, {21338, -1, -1, -1}, {21413, -1, -1, -1}, {21883, -1, -1, -1}, {21888, -1, -1, -1}, {21927, -1, -1, -1}, {21884, -1, -1, -1}, {21898, -1, -1, -1} },
    {{21917, -1, -1, -1}, {21912, -1, -1, -1}, {21890, -1, -1, -1}, {21916, -1, -1, -1}, {21930, -1, -1, -1}, {21908, -1, -1, -1}, {21895, -1, -1, -1}, {21899, -1, -1, -1}, {21891, -1, -1, -1}, {21939, -1, -1, -1}, {21934, -1, -1, -1}, {21919, -1, -1, -1}, {21822, -1, -1, -1}, {21938, -1, -1, -1}, {21914, -1, -1, -1}, {21947, -1, -1, -1}, {21932, -1, -1, -1}, {21937, -1, -1, -1}, {21886, -1, -1, -1}, {21897, -1, -1, -1}, {21931, -1, -1, -1}, {21913, -1, -1, -1}, {22285, -1, -1, -1}, {22575, -1, -1, -1}, {22570, -1, -1, -1}, {22580, -1, -1, -1}, {22564, -1, -1, -1}, {22576, -1, -1, -1}, {22577, -1, -1, -1}, {22561, -1, -1, -1}, {22557, -1, -1, -1}, {22560, -1, -1, -1}, {22777, -1, -1, -1}, {22778, -1, -1, -1}, {22880, -1, -1, -1}, {23159, -1, -1, -1}, {23194, -1, -1, -1}, {23167, -1, -1, -1}, {23186, -1, -1, -1}, {23195, -1, -1, -1}, {23207, -1, -1, -1}, {23411, -1, -1, -1}, {23409, -1, -1, -1}, {23506, -1, -1, -1}, {23500, -1, -1, -1}, {23507, -1, -1, -1}, {23504, -1, -1, -1}, {23562, -1, -1, -1}, {23563, -1, -1, -1}, {23601, -1, -1, -1}, {23884, -1, -1, -1}, {23888, -1, -1, -1}, {23860, -1, -1, -1}, {23879, -1, -1, -1}, {24061, -1, -1, -1}, {24133, -1, -1, -1}, {24125, -1, -1, -1}, {24128, -1, -1, -1}, {24131, -1, -1, -1}, {24190, -1, -1, -1}, {24266, -1, -1, -1}, {24257, -1, -1, -1}, {24258, -1, -1, -1}, {24260, -1, -1, -1}, {24380, -1, -1, -1}, {24429, -1, -1, -1}, {24489, -1, -1, -1}, {24490, -1, -1, -1}, {24488, -1, -1, -1}, {24785, -1, -1, -1}, {24801, -1, -1, -1}, {24754, -1, -1, -1}, {24758, -1, -1, -1}, {24800, -1, -1, -1}, {24860, -1, -1, -1}, {24867, -1, -1, -1}, {24826, -1, -1, -1}, {24853, -1, -1, -1}, {24816, -1, -1, -1}, {24827, -1, -1, -1}, {24820, -1, -1, -1}, {24936, -1, -1, -1}, {24817, -1, -1, -1}, {24846, -1, -1, -1}, {24822, -1, -1, -1}, {24841, -1, -1, -1}, {24832, -1, -1, -1}, {24850, -1, -1, -1}, {25119, -1, -1, -1}, {25161, -1, -1, -1}, {25507, -1, -1, -1}, {25484, -1, -1, -1}, {25551, -1, -1, -1}, {25536, -1, -1, -1}, {25577, -1, -1, -1}, {25545, -1, -1, -1}, {25542, -1, -1, -1}, {25549, -1, -1, -1}, {25554, -1, -1, -1}, {25571, -1, -1, -1}, {25552, -1, -1, -1}, {25569, -1, -1, -1}, {25558, -1, -1, -1}, {25581, -1, -1, -1}, {25582, -1, -1, -1}, {25462, -1, -1, -1}, {25588, -1, -1, -1}, {25578, -1, -1, -1}, {25563, -1, -1, -1}, {25682, -1, -1, -1}, {25562, -1, -1, -1}, {25593, -1, -1, -1}, {25950, -1, -1, -1}, {25958, -1, -1, -1}, {25954, -1, -1, -1}, {25955, -1, -1, -1}, {26001, -1, -1, -1}, {26000, -1, -1, -1}, {26031, -1, -1, -1}, {26222, -1, -1, -1}, {26224, -1, -1, -1}, {26228, -1, -1, -1}, {26230, -1, -1, -1}, {26223, -1, -1, -1}, {26257, -1, -1, -1}, {26234, -1, -1, -1}, {26238, -1, -1, -1}, {26231, -1, -1, -1}, {26366, -1, -1, -1}, {26367, -1, -1, -1}, {26399, -1, -1, -1}, {26397, -1, -1, -1}, {26874, -1, -1, -1}, {26837, -1, -1, -1}, {26848, -1, -1, -1}, {26840, -1, -1, -1}, {26839, -1, -1, -1}, {26885, -1, -1, -1}, {26847, -1, -1, -1}, {26869, -1, -1, -1}, {26862, -1, -1, -1}, {26855, -1, -1, -1}, {26873, -1, -1, -1}, {26834, -1, -1, -1}, {26866, -1, -1, -1}, {26851, -1, -1, -1}, {26827, -1, -1, -1}, {26829, -1, -1, -1}, {26893, -1, -1, -1}, {26898, -1, -1, -1}, {26894, -1, -1, -1}, {26825, -1, -1, -1}, {26842, -1, -1, -1}, {26990, -1, -1, -1}, {26875, -1, -1, -1}, {27454, -1, -1, -1}, {27450, -1, -1, -1}, {27453, -1, -1, -1}, {27544, -1, -1, -1}, {27542, -1, -1, -1}, {27580, -1, -1, -1}, {27631, -1, -1, -1}, {27694, -1, -1, -1}, {27695, -1, -1, -1}, {27692, -1, -1, -1}, {28207, -1, -1, -1}, {28216, -1, -1, -1}, {28244, -1, -1, -1}, {28193, -1, -1, -1}, {28210, -1, -1, -1}, {28263, -1, -1, -1}, {28234, -1, -1, -1}, {28192, -1, -1, -1}, {28197, -1, -1, -1}, {28195, -1, -1, -1}, {28187, -1, -1, -1}, {28251, -1, -1, -1}, {28248, -1, -1, -1}, {28196, -1, -1, -1}, {28246, -1, -1, -1}, {28270, -1, -1, -1}, {28205, -1, -1, -1}, {28198, -1, -1, -1}, {28271, -1, -1, -1}, {28212, -1, -1, -1}, {28237, -1, -1, -1}, {28218, -1, -1, -1}, {28204, -1, -1, -1}, {28227, -1, -1, -1}, {28189, -1, -1, -1}, {28222, -1, -1, -1}, {28363, -1, -1, -1}, {28297, -1, -1, -1}, {28185, -1, -1, -1}, {28238, -1, -1, -1}, {28259, -1, -1, -1}, {28228, -1, -1, -1}, {28274, -1, -1, -1}, {28265, -1, -1, -1}, {28255, -1, -1, -1}, {28953, -1, -1, -1}, {28954, -1, -1, -1}, {28966, -1, -1, -1}, {28976, -1, -1, -1}, {28961, -1, -1, -1}, {28982, -1, -1, -1}, {29038, -1, -1, -1}, {28956, -1, -1, -1}, {29260, -1, -1, -1}, {29316, -1, -1, -1}, {29312, -1, -1, -1}, {29494, -1, -1, -1}, {29477, -1, -1, -1}, {29492, -1, -1, -1}, {29481, -1, -1, -1}, {29754, -1, -1, -1}, {29738, -1, -1, -1}, {29747, -1, -1, -1}, {29730, -1, -1, -1}, {29733, -1, -1, -1}, {29749, -1, -1, -1}, {29750, -1, -1, -1}, {29748, -1, -1, -1}, {29743, -1, -1, -1}, {29723, -1, -1, -1}, {29734, -1, -1, -1}, {29736, -1, -1, -1}, {29989, -1, -1, -1}, {29990, -1, -1, -1}, {30059, -1, -1, -1}, {30058, -1, -1, -1}, {30178, -1, -1, -1}, {30171, -1, -1, -1}, {30179, -1, -1, -1}, {30169, -1, -1, -1}, {30168, -1, -1, -1}, {30174, -1, -1, -1}, {30176, -1, -1, -1}, {30331, -1, -1, -1}, {30332, -1, -1, -1}, {30358, -1, -1, -1}, {30355, -1, -1, -1}, {30388, -1, -1, -1}, {30428, -1, -1, -1}, {30543, -1, -1, -1}, {30701, -1, -1, -1}, {30813, -1, -1, -1}, {30828, -1, -1, -1}, {30831, -1, -1, -1}, {31245, -1, -1, -1}, {31240, -1, -1, -1}, {31243, -1, -1, -1}, {31237, -1, -1, -1}, {31232, -1, -1, -1}, {31384, -1, -1, -1}, {31383, -1, -1, -1} },
    {{31382, -1, -1, -1}, {31461, -1, -1, -1}, {31459, -1, -1, -1}, {31561, -1, -1, -1}, {31574, -1, -1, -1}, {31558, -1, -1, -1}, {31568, -1, -1, -1}, {31570, -1, -1, -1}, {31572, -1, -1, -1}, {31565, -1, -1, -1}, {31563, -1, -1, -1}, {31567, -1, -1, -1}, {31569, -1, -1, -1}, {31903, -1, -1, -1}, {31909, -1, -1, -1}, {32094, -1, -1, -1}, {32080, -1, -1, -1}, {32104, -1, -1, -1}, {32085, -1, -1, -1}, {32043, -1, -1, -1}, {32110, -1, -1, -1}, {32114, -1, -1, -1}, {32097, -1, -1, -1}, {32102, -1, -1, -1}, {32098, -1, -1, -1}, {32112, -1, -1, -1}, {32115, -1, -1, -1}, {21892, -1, -1, -1}, {32724, -1, -1, -1}, {32725, -1, -1, -1}, {32779, -1, -1, -1}, {32850, -1, -1, -1}, {32901, -1, -1, -1}, {33109, -1, -1, -1}, {33108, -1, -1, -1}, {33099, -1, -1, -1}, {33105, -1, -1, -1}, {33102, -1, -1, -1}, {33081, -1, -1, -1}, {33094, -1, -1, -1}, {33086, -1, -1, -1}, {33100, -1, -1, -1}, {33107, -1, -1, -1}, {33140, -1, -1, -1}, {33298, -1, -1, -1}, {33308, -1, -1, -1}, {33769, -1, -1, -1}, {33795, -1, -1, -1}, {33784, -1, -1, -1}, {33805, -1, -1, -1}, {33760, -1, -1, -1}, {33733, -1, -1, -1}, {33803, -1, -1, -1}, {33729, -1, -1, -1}, {33775, -1, -1, -1}, {33777, -1, -1, -1}, {33780, -1, -1, -1}, {33879, -1, -1, -1}, {33802, -1, -1, -1}, {33776, -1, -1, -1}, {33804, -1, -1, -1}, {33740, -1, -1, -1}, {33789, -1, -1, -1}, {33778, -1, -1, -1}, {33738, -1, -1, -1}, {33848, -1, -1, -1}, {33806, -1, -1, -1}, {33796, -1, -1, -1}, {33756, -1, -1, -1}, {33799, -1, -1, -1}, {33748, -1, -1, -1}, {33759, -1, -1, -1}, {34395, -1, -1, -1}, {34527, -1, -1, -1}, {34521, -1, -1, -1}, {34541, -1, -1, -1}, {34516, -1, -1, -1}, {34523, -1, -1, -1}, {34532, -1, -1, -1}, {34512, -1, -1, -1}, {34526, -1, -1, -1}, {34903, -1, -1, -1}, {35009, -1, -1, -1}, {35010, -1, -1, -1}, {34993, -1, -1, -1}, {35203, -1, -1, -1}, {35222, -1, -1, -1}, {35387, -1, -1, -1}, {35424, -1, -1, -1}, {35413, -1, -1, -1}, {35422, -1, -1, -1}, {35388, -1, -1, -1}, {35393, -1, -1, -1}, {35412, -1, -1, -1}, {35419, -1, -1, -1}, {35408, -1, -1, -1}, {35398, -1, -1, -1}, {35380, -1, -1, -1}, {35386, -1, -1, -1}, {35382, -1, -1, -1}, {35414, -1, -1, -1}, {35937, -1, -1, -1}, {35970, -1, -1, -1}, {36015, -1, -1, -1}, {36028, -1, -1, -1}, {36019, -1, -1, -1}, {36029, -1, -1, -1}, {36033, -1, -1, -1}, {36027, -1, -1, -1}, {36032, -1, -1, -1}, {36020, -1, -1, -1}, {36023, -1, -1, -1}, {36022, -1, -1, -1}, {36031, -1, -1, -1}, {36024, -1, -1, -1}, {36234, -1, -1, -1}, {36229, -1, -1, -1}, {36225, -1, -1, -1}, {36302, -1, -1, -1}, {36317, -1, -1, -1}, {36299, -1, -1, -1}, {36314, -1, -1, -1}, {36305, -1, -1, -1}, {36300, -1, -1, -1}, {36315, -1, -1, -1}, {36294, -1, -1, -1}, {36603, -1, -1, -1}, {36600, -1, -1, -1}, {36604, -1, -1, -1}, {36764, -1, -1, -1}, {36910, -1, -1, -1}, {36917, -1, -1, -1}, {36913, -1, -1, -1}, {36920, -1, -1, -1}, {36914, -1, -1, -1}, {36918, -1, -1, -1}, {37122, -1, -1, -1}, {37109, -1, -1, -1}, {37129, -1, -1, -1}, {37118, -1, -1, -1}, {37219, -1, -1, -1}, {37221, -1, -1, -1}, {37327, -1, -1, -1}, {37396, -1, -1, -1}, {37397, -1, -1, -1}, {37411, -1, -1, -1}, {37385, -1, -1, -1}, {37406, -1, -1, -1}, {37389, -1, -1, -1}, {37392, -1, -1, -1}, {37383, -1, -1, -1}, {37393, -1, -1, -1}, {38292, -1, -1, -1}, {38287, -1, -1, -1}, {38283, -1, -1, -1}, {38289, -1, -1, -1}, {38291, -1, -1, -1}, {38290, -1, -1, -1}, {38286, -1, -1, -1}, {38538, -1, -1, -1}, {38542, -1, -1, -1}, {38539, -1, -1, -1}, {38525, -1, -1, -1}, {38533, -1, -1, -1}, {38534, -1, -1, -1}, {38541, -1, -1, -1}, {38514, -1, -1, -1}, {38532, -1, -1, -1}, {38593, -1, -1, -1}, {38597, -1, -1, -1}, {38596, -1, -1, -1}, {38598, -1, -1, -1}, {38599, -1, -1, -1}, {38639, -1, -1, -1}, {38642, -1, -1, -1}, {38860, -1, -1, -1}, {38917, -1, -1, -1}, {38918, -1, -1, -1}, {38920, -1, -1, -1}, {39143, -1, -1, -1}, {39146, -1, -1, -1}, {39151, -1, -1, -1}, {39145, -1, -1, -1}, {39154, -1, -1, -1}, {39149, -1, -1, -1}, {39342, -1, -1, -1}, {39341, -1, -1, -1}, {40643, -1, -1, -1}, {40653, -1, -1, -1}, {40657, -1, -1, -1}, {20098, -1, -1, -1}, {20653, -1, -1, -1}, {20661, -1, -1, -1}, {20658, -1, -1, -1}, {20659, -1, -1, -1}, {20677, -1, -1, -1}, {20670, -1, -1, -1}, {20652, -1, -1, -1}, {20663, -1, -1, -1}, {20667, -1, -1, -1}, {20655, -1, -1, -1}, {20679, -1, -1, -1}, {21119, -1, -1, -1}, {21111, -1, -1, -1}, {21117, -1, -1, -1}, {21215, -1, -1, -1}, {21222, -1, -1, -1}, {21220, -1, -1, -1}, {21218, -1, -1, -1}, {21219, -1, -1, -1}, {21295, -1, -1, -1}, {21983, -1, -1, -1}, {21992, -1, -1, -1}, {21971, -1, -1, -1}, {21990, -1, -1, -1}, {21966, -1, -1, -1}, {21980, -1, -1, -1}, {21959, -1, -1, -1}, {21969, -1, -1, -1}, {21987, -1, -1, -1}, {21988, -1, -1, -1}, {21999, -1, -1, -1}, {21978, -1, -1, -1}, {21985, -1, -1, -1}, {21957, -1, -1, -1}, {21958, -1, -1, -1}, {21989, -1, -1, -1}, {21961, -1, -1, -1}, {22290, -1, -1, -1}, {22291, -1, -1, -1}, {22622, -1, -1, -1}, {22609, -1, -1, -1}, {22616, -1, -1, -1}, {22615, -1, -1, -1}, {22618, -1, -1, -1}, {22612, -1, -1, -1}, {22635, -1, -1, -1}, {22604, -1, -1, -1}, {22637, -1, -1, -1}, {22602, -1, -1, -1}, {22626, -1, -1, -1}, {22610, -1, -1, -1}, {22603, -1, -1, -1}, {22887, -1, -1, -1}, {23233, -1, -1, -1}, {23241, -1, -1, -1}, {23244, -1, -1, -1}, {23230, -1, -1, -1}, {23229, -1, -1, -1}, {23228, -1, -1, -1}, {23219, -1, -1, -1}, {23234, -1, -1, -1}, {23218, -1, -1, -1}, {23913, -1, -1, -1}, {23919, -1, -1, -1}, {24140, -1, -1, -1} },
    {{24185, -1, -1, -1}, {24265, -1, -1, -1}, {24264, -1, -1, -1}, {24338, -1, -1, -1}, {24409, -1, -1, -1}, {24492, -1, -1, -1}, {24494, -1, -1, -1}, {24858, -1, -1, -1}, {24847, -1, -1, -1}, {24904, -1, -1, -1}, {24863, -1, -1, -1}, {24819, -1, -1, -1}, {24859, -1, -1, -1}, {24825, -1, -1, -1}, {24833, -1, -1, -1}, {24840, -1, -1, -1}, {24910, -1, -1, -1}, {24908, -1, -1, -1}, {24900, -1, -1, -1}, {24909, -1, -1, -1}, {24894, -1, -1, -1}, {24884, -1, -1, -1}, {24871, -1, -1, -1}, {24845, -1, -1, -1}, {24838, -1, -1, -1}, {24887, -1, -1, -1}, {25121, -1, -1, -1}, {25122, -1, -1, -1}, {25619, -1, -1, -1}, {25662, -1, -1, -1}, {25630, -1, -1, -1}, {25642, -1, -1, -1}, {25645, -1, -1, -1}, {25661, -1, -1, -1}, {25644, -1, -1, -1}, {25615, -1, -1, -1}, {25628, -1, -1, -1}, {25620, -1, -1, -1}, {25613, -1, -1, -1}, {25654, -1, -1, -1}, {25622, -1, -1, -1}, {25623, -1, -1, -1}, {25606, -1, -1, -1}, {25964, -1, -1, -1}, {26015, -1, -1, -1}, {26032, -1, -1, -1}, {26263, -1, -1, -1}, {26249, -1, -1, -1}, {26247, -1, -1, -1}, {26248, -1, -1, -1}, {26262, -1, -1, -1}, {26244, -1, -1, -1}, {26264, -1, -1, -1}, {26253, -1, -1, -1}, {26371, -1, -1, -1}, {27028, -1, -1, -1}, {26989, -1, -1, -1}, {26970, -1, -1, -1}, {26999, -1, -1, -1}, {26976, -1, -1, -1}, {26964, -1, -1, -1}, {26997, -1, -1, -1}, {26928, -1, -1, -1}, {27010, -1, -1, -1}, {26954, -1, -1, -1}, {26984, -1, -1, -1}, {26987, -1, -1, -1}, {26974, -1, -1, -1}, {26963, -1, -1, -1}, {27001, -1, -1, -1}, {27014, -1, -1, -1}, {26973, -1, -1, -1}, {26979, -1, -1, -1}, {26971, -1, -1, -1}, {27463, -1, -1, -1}, {27506, -1, -1, -1}, {27584, -1, -1, -1}, {27583, -1, -1, -1}, {27603, -1, -1, -1}, {27645, -1, -1, -1}, {28322, -1, -1, -1}, {28335, -1, -1, -1}, {28371, -1, -1, -1}, {28342, -1, -1, -1}, {28354, -1, -1, -1}, {28304, -1, -1, -1}, {28317, -1, -1, -1}, {28359, -1, -1, -1}, {28357, -1, -1, -1}, {28325, -1, -1, -1}, {28312, -1, -1, -1}, {28348, -1, -1, -1}, {28346, -1, -1, -1}, {28331, -1, -1, -1}, {28369, -1, -1, -1}, {28310, -1, -1, -1}, {28316, -1, -1, -1}, {28356, -1, -1, -1}, {28372, -1, -1, -1}, {28330, -1, -1, -1}, {28327, -1, -1, -1}, {28340, -1, -1, -1}, {29006, -1, -1, -1}, {29017, -1, -1, -1}, {29033, -1, -1, -1}, {29028, -1, -1, -1}, {29001, -1, -1, -1}, {29031, -1, -1, -1}, {29020, -1, -1, -1}, {29036, -1, -1, -1}, {29030, -1, -1, -1}, {29004, -1, -1, -1}, {29029, -1, -1, -1}, {29022, -1, -1, -1}, {28998, -1, -1, -1}, {29032, -1, -1, -1}, {29014, -1, -1, -1}, {29242, -1, -1, -1}, {29266, -1, -1, -1}, {29495, -1, -1, -1}, {29509, -1, -1, -1}, {29503, -1, -1, -1}, {29502, -1, -1, -1}, {29807, -1, -1, -1}, {29786, -1, -1, -1}, {29781, -1, -1, -1}, {29791, -1, -1, -1}, {29790, -1, -1, -1}, {29761, -1, -1, -1}, {29759, -1, -1, -1}, {29785, -1, -1, -1}, {29787, -1, -1, -1}, {29788, -1, -1, -1}, {30070, -1, -1, -1}, {30072, -1, -1, -1}, {30208, -1, -1, -1}, {30192, -1, -1, -1}, {30209, -1, -1, -1}, {30194, -1, -1, -1}, {30193, -1, -1, -1}, {30202, -1, -1, -1}, {30207, -1, -1, -1}, {30196, -1, -1, -1}, {30195, -1, -1, -1}, {30430, -1, -1, -1}, {30431, -1, -1, -1}, {30555, -1, -1, -1}, {30571, -1, -1, -1}, {30566, -1, -1, -1}, {30558, -1, -1, -1}, {30563, -1, -1, -1}, {30585, -1, -1, -1}, {30570, -1, -1, -1}, {30572, -1, -1, -1}, {30556, -1, -1, -1}, {30565, -1, -1, -1}, {30568, -1, -1, -1}, {30562, -1, -1, -1}, {30702, -1, -1, -1}, {30862, -1, -1, -1}, {30896, -1, -1, -1}, {30871, -1, -1, -1}, {30872, -1, -1, -1}, {30860, -1, -1, -1}, {30857, -1, -1, -1}, {30844, -1, -1, -1}, {30865, -1, -1, -1}, {30867, -1, -1, -1}, {30847, -1, -1, -1}, {31098, -1, -1, -1}, {31103, -1, -1, -1}, {31105, -1, -1, -1}, {33836, -1, -1, -1}, {31165, -1, -1, -1}, {31260, -1, -1, -1}, {31258, -1, -1, -1}, {31264, -1, -1, -1}, {31252, -1, -1, -1}, {31263, -1, -1, -1}, {31262, -1, -1, -1}, {31391, -1, -1, -1}, {31392, -1, -1, -1}, {31607, -1, -1, -1}, {31680, -1, -1, -1}, {31584, -1, -1, -1}, {31598, -1, -1, -1}, {31591, -1, -1, -1}, {31921, -1, -1, -1}, {31923, -1, -1, -1}, {31925, -1, -1, -1}, {32147, -1, -1, -1}, {32121, -1, -1, -1}, {32145, -1, -1, -1}, {32129, -1, -1, -1}, {32143, -1, -1, -1}, {32091, -1, -1, -1}, {32622, -1, -1, -1}, {32617, -1, -1, -1}, {32618, -1, -1, -1}, {32626, -1, -1, -1}, {32681, -1, -1, -1}, {32680, -1, -1, -1}, {32676, -1, -1, -1}, {32854, -1, -1, -1}, {32856, -1, -1, -1}, {32902, -1, -1, -1}, {32900, -1, -1, -1}, {33137, -1, -1, -1}, {33136, -1, -1, -1}, {33144, -1, -1, -1}, {33125, -1, -1, -1}, {33134, -1, -1, -1}, {33139, -1, -1, -1}, {33131, -1, -1, -1}, {33145, -1, -1, -1}, {33146, -1, -1, -1}, {33126, -1, -1, -1}, {33285, -1, -1, -1}, {33351, -1, -1, -1}, {33922, -1, -1, -1}, {33911, -1, -1, -1}, {33853, -1, -1, -1}, {33841, -1, -1, -1}, {33909, -1, -1, -1}, {33894, -1, -1, -1}, {33899, -1, -1, -1}, {33865, -1, -1, -1}, {33900, -1, -1, -1}, {33883, -1, -1, -1}, {33852, -1, -1, -1}, {33845, -1, -1, -1}, {33889, -1, -1, -1}, {33891, -1, -1, -1}, {33897, -1, -1, -1}, {33901, -1, -1, -1}, {33862, -1, -1, -1}, {34398, -1, -1, -1}, {34396, -1, -1, -1}, {34399, -1, -1, -1}, {34553, -1, -1, -1}, {34579, -1, -1, -1}, {34568, -1, -1, -1}, {34567, -1, -1, -1}, {34560, -1, -1, -1}, {34558, -1, -1, -1}, {34555, -1, -1, -1}, {34562, -1, -1, -1}, {34563, -1, -1, -1}, {34566, -1, -1, -1}, {34570, -1, -1, -1}, {34905, -1, -1, -1}, {35039, -1, -1, -1}, {35028, -1, -1, -1}, {35033, -1, -1, -1}, {35036, -1, -1, -1}, {35032, -1, -1, -1} },
    {{35037, -1, -1, -1}, {35041, -1, -1, -1}, {35018, -1, -1, -1}, {35029, -1, -1, -1}, {35026, -1, -1, -1}, {35228, -1, -1, -1}, {35299, -1, -1, -1}, {35435, -1, -1, -1}, {35442, -1, -1, -1}, {35443, -1, -1, -1}, {35430, -1, -1, -1}, {35433, -1, -1, -1}, {35440, -1, -1, -1}, {35463, -1, -1, -1}, {35452, -1, -1, -1}, {35427, -1, -1, -1}, {35488, -1, -1, -1}, {35441, -1, -1, -1}, {35461, -1, -1, -1}, {35437, -1, -1, -1}, {35426, -1, -1, -1}, {35438, -1, -1, -1}, {35436, -1, -1, -1}, {35449, -1, -1, -1}, {35451, -1, -1, -1}, {35390, -1, -1, -1}, {35432, -1, -1, -1}, {35938, -1, -1, -1}, {35978, -1, -1, -1}, {35977, -1, -1, -1}, {36042, -1, -1, -1}, {36039, -1, -1, -1}, {36040, -1, -1, -1}, {36036, -1, -1, -1}, {36018, -1, -1, -1}, {36035, -1, -1, -1}, {36034, -1, -1, -1}, {36037, -1, -1, -1}, {36321, -1, -1, -1}, {36319, -1, -1, -1}, {36328, -1, -1, -1}, {36335, -1, -1, -1}, {36339, -1, -1, -1}, {36346, -1, -1, -1}, {36330, -1, -1, -1}, {36324, -1, -1, -1}, {36326, -1, -1, -1}, {36530, -1, -1, -1}, {36611, -1, -1, -1}, {36617, -1, -1, -1}, {36606, -1, -1, -1}, {36618, -1, -1, -1}, {36767, -1, -1, -1}, {36786, -1, -1, -1}, {36939, -1, -1, -1}, {36938, -1, -1, -1}, {36947, -1, -1, -1}, {36930, -1, -1, -1}, {36948, -1, -1, -1}, {36924, -1, -1, -1}, {36949, -1, -1, -1}, {36944, -1, -1, -1}, {36935, -1, -1, -1}, {36943, -1, -1, -1}, {36942, -1, -1, -1}, {36941, -1, -1, -1}, {36945, -1, -1, -1}, {36926, -1, -1, -1}, {36929, -1, -1, -1}, {37138, -1, -1, -1}, {37143, -1, -1, -1}, {37228, -1, -1, -1}, {37226, -1, -1, -1}, {37225, -1, -1, -1}, {37321, -1, -1, -1}, {37431, -1, -1, -1}, {37463, -1, -1, -1}, {37432, -1, -1, -1}, {37437, -1, -1, -1}, {37440, -1, -1, -1}, {37438, -1, -1, -1}, {37467, -1, -1, -1}, {37451, -1, -1, -1}, {37476, -1, -1, -1}, {37457, -1, -1, -1}, {37428, -1, -1, -1}, {37449, -1, -1, -1}, {37453, -1, -1, -1}, {37445, -1, -1, -1}, {37433, -1, -1, -1}, {37439, -1, -1, -1}, {37466, -1, -1, -1}, {38296, -1, -1, -1}, {38552, -1, -1, -1}, {38548, -1, -1, -1}, {38549, -1, -1, -1}, {38605, -1, -1, -1}, {38603, -1, -1, -1}, {38601, -1, -1, -1}, {38602, -1, -1, -1}, {38647, -1, -1, -1}, {38651, -1, -1, -1}, {38649, -1, -1, -1}, {38646, -1, -1, -1}, {38742, -1, -1, -1}, {38772, -1, -1, -1}, {38774, -1, -1, -1}, {38928, -1, -1, -1}, {38929, -1, -1, -1}, {38931, -1, -1, -1}, {38922, -1, -1, -1}, {38930, -1, -1, -1}, {38924, -1, -1, -1}, {39164, -1, -1, -1}, {39156, -1, -1, -1}, {39165, -1, -1, -1}, {39166, -1, -1, -1}, {39347, -1, -1, -1}, {39345, -1, -1, -1}, {39348, -1, -1, -1}, {39649, -1, -1, -1}, {40169, -1, -1, -1}, {40578, -1, -1, -1}, {40718, -1, -1, -1}, {40723, -1, -1, -1}, {40736, -1, -1, -1}, {20711, -1, -1, -1}, {20718, -1, -1, -1}, {20709, -1, -1, -1}, {20694, -1, -1, -1}, {20717, -1, -1, -1}, {20698, -1, -1, -1}, {20693, -1, -1, -1}, {20687, -1, -1, -1}, {20689, -1, -1, -1}, {20721, -1, -1, -1}, {20686, -1, -1, -1}, {20713, -1, -1, -1}, {20834, -1, -1, -1}, {20979, -1, -1, -1}, {21123, -1, -1, -1}, {21122, -1, -1, -1}, {21297, -1, -1, -1}, {21421, -1, -1, -1}, {22014, -1, -1, -1}, {22016, -1, -1, -1}, {22043, -1, -1, -1}, {22039, -1, -1, -1}, {22013, -1, -1, -1}, {22036, -1, -1, -1}, {22022, -1, -1, -1}, {22025, -1, -1, -1}, {22029, -1, -1, -1}, {22030, -1, -1, -1}, {22007, -1, -1, -1}, {22038, -1, -1, -1}, {22047, -1, -1, -1}, {22024, -1, -1, -1}, {22032, -1, -1, -1}, {22006, -1, -1, -1}, {22296, -1, -1, -1}, {22294, -1, -1, -1}, {22645, -1, -1, -1}, {22654, -1, -1, -1}, {22659, -1, -1, -1}, {22675, -1, -1, -1}, {22666, -1, -1, -1}, {22649, -1, -1, -1}, {22661, -1, -1, -1}, {22653, -1, -1, -1}, {22781, -1, -1, -1}, {22821, -1, -1, -1}, {22818, -1, -1, -1}, {22820, -1, -1, -1}, {22890, -1, -1, -1}, {22889, -1, -1, -1}, {23265, -1, -1, -1}, {23270, -1, -1, -1}, {23273, -1, -1, -1}, {23255, -1, -1, -1}, {23254, -1, -1, -1}, {23256, -1, -1, -1}, {23267, -1, -1, -1}, {23413, -1, -1, -1}, {23518, -1, -1, -1}, {23527, -1, -1, -1}, {23521, -1, -1, -1}, {23525, -1, -1, -1}, {23526, -1, -1, -1}, {23528, -1, -1, -1}, {23522, -1, -1, -1}, {23524, -1, -1, -1}, {23519, -1, -1, -1}, {23565, -1, -1, -1}, {23650, -1, -1, -1}, {23940, -1, -1, -1}, {23943, -1, -1, -1}, {24155, -1, -1, -1}, {24163, -1, -1, -1}, {24149, -1, -1, -1}, {24151, -1, -1, -1}, {24148, -1, -1, -1}, {24275, -1, -1, -1}, {24278, -1, -1, -1}, {24330, -1, -1, -1}, {24390, -1, -1, -1}, {24432, -1, -1, -1}, {24505, -1, -1, -1}, {24903, -1, -1, -1}, {24895, -1, -1, -1}, {24907, -1, -1, -1}, {24951, -1, -1, -1}, {24930, -1, -1, -1}, {24931, -1, -1, -1}, {24927, -1, -1, -1}, {24922, -1, -1, -1}, {24920, -1, -1, -1}, {24949, -1, -1, -1}, {25130, -1, -1, -1}, {25735, -1, -1, -1}, {25688, -1, -1, -1}, {25684, -1, -1, -1}, {25764, -1, -1, -1}, {25720, -1, -1, -1}, {25695, -1, -1, -1}, {25722, -1, -1, -1}, {25681, -1, -1, -1}, {25703, -1, -1, -1}, {25652, -1, -1, -1}, {25709, -1, -1, -1}, {25723, -1, -1, -1}, {25970, -1, -1, -1}, {26017, -1, -1, -1}, {26071, -1, -1, -1}, {26070, -1, -1, -1}, {26274, -1, -1, -1}, {26280, -1, -1, -1}, {26269, -1, -1, -1}, {27036, -1, -1, -1}, {27048, -1, -1, -1}, {27029, -1, -1, -1}, {27073, -1, -1, -1}, {27054, -1, -1, -1}, {27091, -1, -1, -1}, {27083, -1, -1, -1}, {27035, -1, -1, -1}, {27063, -1, -1, -1}, {27067, -1, -1, -1}, {27051, -1, -1, -1}, {27060, -1, -1, -1}, {27088, -1, -1, -1}, {27085, -1, -1, -1}, {27053, -1, -1, -1}, {27084, -1, -1, -1}, {27046, -1, -1, -1}, {27075, -1, -1, -1} },
    {{27043, -1, -1, -1}, {27465, -1, -1, -1}, {27468, -1, -1, -1}, {27699, -1, -1, -1}, {28467, -1, -1, -1}, {28436, -1, -1, -1}, {28414, -1, -1, -1}, {28435, -1, -1, -1}, {28404, -1, -1, -1}, {28457, -1, -1, -1}, {28478, -1, -1, -1}, {28448, -1, -1, -1}, {28460, -1, -1, -1}, {28431, -1, -1, -1}, {28418, -1, -1, -1}, {28450, -1, -1, -1}, {28415, -1, -1, -1}, {28399, -1, -1, -1}, {28422, -1, -1, -1}, {28465, -1, -1, -1}, {28472, -1, -1, -1}, {28466, -1, -1, -1}, {28451, -1, -1, -1}, {28437, -1, -1, -1}, {28459, -1, -1, -1}, {28463, -1, -1, -1}, {28552, -1, -1, -1}, {28458, -1, -1, -1}, {28396, -1, -1, -1}, {28417, -1, -1, -1}, {28402, -1, -1, -1}, {28364, -1, -1, -1}, {28407, -1, -1, -1}, {29076, -1, -1, -1}, {29081, -1, -1, -1}, {29053, -1, -1, -1}, {29066, -1, -1, -1}, {29060, -1, -1, -1}, {29074, -1, -1, -1}, {29246, -1, -1, -1}, {29330, -1, -1, -1}, {29334, -1, -1, -1}, {29508, -1, -1, -1}, {29520, -1, -1, -1}, {29796, -1, -1, -1}, {29795, -1, -1, -1}, {29802, -1, -1, -1}, {29808, -1, -1, -1}, {29805, -1, -1, -1}, {29956, -1, -1, -1}, {30097, -1, -1, -1}, {30247, -1, -1, -1}, {30221, -1, -1, -1}, {30219, -1, -1, -1}, {30217, -1, -1, -1}, {30227, -1, -1, -1}, {30433, -1, -1, -1}, {30435, -1, -1, -1}, {30596, -1, -1, -1}, {30589, -1, -1, -1}, {30591, -1, -1, -1}, {30561, -1, -1, -1}, {30913, -1, -1, -1}, {30879, -1, -1, -1}, {30887, -1, -1, -1}, {30899, -1, -1, -1}, {30889, -1, -1, -1}, {30883, -1, -1, -1}, {31118, -1, -1, -1}, {31119, -1, -1, -1}, {31117, -1, -1, -1}, {31278, -1, -1, -1}, {31281, -1, -1, -1}, {31402, -1, -1, -1}, {31401, -1, -1, -1}, {31469, -1, -1, -1}, {31471, -1, -1, -1}, {31649, -1, -1, -1}, {31637, -1, -1, -1}, {31627, -1, -1, -1}, {31605, -1, -1, -1}, {31639, -1, -1, -1}, {31645, -1, -1, -1}, {31636, -1, -1, -1}, {31631, -1, -1, -1}, {31672, -1, -1, -1}, {31623, -1, -1, -1}, {31620, -1, -1, -1}, {31929, -1, -1, -1}, {31933, -1, -1, -1}, {31934, -1, -1, -1}, {32187, -1, -1, -1}, {32176, -1, -1, -1}, {32156, -1, -1, -1}, {32189, -1, -1, -1}, {32190, -1, -1, -1}, {32160, -1, -1, -1}, {32202, -1, -1, -1}, {32180, -1, -1, -1}, {32178, -1, -1, -1}, {32177, -1, -1, -1}, {32186, -1, -1, -1}, {32162, -1, -1, -1}, {32191, -1, -1, -1}, {32181, -1, -1, -1}, {32184, -1, -1, -1}, {32173, -1, -1, -1}, {32210, -1, -1, -1}, {32199, -1, -1, -1}, {32172, -1, -1, -1}, {32624, -1, -1, -1}, {32736, -1, -1, -1}, {32737, -1, -1, -1}, {32735, -1, -1, -1}, {32862, -1, -1, -1}, {32858, -1, -1, -1}, {32903, -1, -1, -1}, {33104, -1, -1, -1}, {33152, -1, -1, -1}, {33167, -1, -1, -1}, {33160, -1, -1, -1}, {33162, -1, -1, -1}, {33151, -1, -1, -1}, {33154, -1, -1, -1}, {33255, -1, -1, -1}, {33274, -1, -1, -1}, {33287, -1, -1, -1}, {33300, -1, -1, -1}, {33310, -1, -1, -1}, {33355, -1, -1, -1}, {33993, -1, -1, -1}, {33983, -1, -1, -1}, {33990, -1, -1, -1}, {33988, -1, -1, -1}, {33945, -1, -1, -1}, {33950, -1, -1, -1}, {33970, -1, -1, -1}, {33948, -1, -1, -1}, {33995, -1, -1, -1}, {33976, -1, -1, -1}, {33984, -1, -1, -1}, {34003, -1, -1, -1}, {33936, -1, -1, -1}, {33980, -1, -1, -1}, {34001, -1, -1, -1}, {33994, -1, -1, -1}, {34623, -1, -1, -1}, {34588, -1, -1, -1}, {34619, -1, -1, -1}, {34594, -1, -1, -1}, {34597, -1, -1, -1}, {34612, -1, -1, -1}, {34584, -1, -1, -1}, {34645, -1, -1, -1}, {34615, -1, -1, -1}, {34601, -1, -1, -1}, {35059, -1, -1, -1}, {35074, -1, -1, -1}, {35060, -1, -1, -1}, {35065, -1, -1, -1}, {35064, -1, -1, -1}, {35069, -1, -1, -1}, {35048, -1, -1, -1}, {35098, -1, -1, -1}, {35055, -1, -1, -1}, {35494, -1, -1, -1}, {35468, -1, -1, -1}, {35486, -1, -1, -1}, {35491, -1, -1, -1}, {35469, -1, -1, -1}, {35489, -1, -1, -1}, {35475, -1, -1, -1}, {35492, -1, -1, -1}, {35498, -1, -1, -1}, {35493, -1, -1, -1}, {35496, -1, -1, -1}, {35480, -1, -1, -1}, {35473, -1, -1, -1}, {35482, -1, -1, -1}, {35495, -1, -1, -1}, {35946, -1, -1, -1}, {35981, -1, -1, -1}, {35980, -1, -1, -1}, {36051, -1, -1, -1}, {36049, -1, -1, -1}, {36050, -1, -1, -1}, {36203, -1, -1, -1}, {36249, -1, -1, -1}, {36245, -1, -1, -1}, {36348, -1, -1, -1}, {36628, -1, -1, -1}, {36626, -1, -1, -1}, {36629, -1, -1, -1}, {36627, -1, -1, -1}, {36771, -1, -1, -1}, {36960, -1, -1, -1}, {36952, -1, -1, -1}, {36956, -1, -1, -1}, {36963, -1, -1, -1}, {36953, -1, -1, -1}, {36958, -1, -1, -1}, {36962, -1, -1, -1}, {36957, -1, -1, -1}, {36955, -1, -1, -1}, {37145, -1, -1, -1}, {37144, -1, -1, -1}, {37150, -1, -1, -1}, {37237, -1, -1, -1}, {37240, -1, -1, -1}, {37239, -1, -1, -1}, {37236, -1, -1, -1}, {37496, -1, -1, -1}, {37548, -1, -1, -1}, {37504, -1, -1, -1}, {37509, -1, -1, -1}, {37528, -1, -1, -1}, {37526, -1, -1, -1}, {37499, -1, -1, -1}, {37523, -1, -1, -1}, {37532, -1, -1, -1}, {37544, -1, -1, -1}, {37500, -1, -1, -1}, {37521, -1, -1, -1}, {38305, -1, -1, -1}, {38312, -1, -1, -1}, {38313, -1, -1, -1}, {38307, -1, -1, -1}, {38309, -1, -1, -1}, {38308, -1, -1, -1}, {38553, -1, -1, -1}, {38556, -1, -1, -1}, {38555, -1, -1, -1}, {38604, -1, -1, -1}, {38610, -1, -1, -1}, {38656, -1, -1, -1}, {38780, -1, -1, -1}, {38789, -1, -1, -1}, {38902, -1, -1, -1}, {38935, -1, -1, -1}, {38936, -1, -1, -1}, {39087, -1, -1, -1}, {39089, -1, -1, -1}, {39171, -1, -1, -1}, {39173, -1, -1, -1}, {39180, -1, -1, -1}, {39177, -1, -1, -1}, {39361, -1, -1, -1}, {39599, -1, -1, -1}, {39600, -1, -1, -1}, {39654, -1, -1, -1}, {39745, -1, -1, -1}, {39746, -1, -1, -1}, {40180, -1, -1, -1}, {40182, -1, -1, -1}, {40179, -1, -1, -1}, {40636, -1, -1, -1} },
    {{40763, -1, -1, -1}, {40778, -1, -1, -1}, {20740, -1, -1, -1}, {20736, -1, -1, -1}, {20731, -1, -1, -1}, {20725, -1, -1, -1}, {20729, -1, -1, -1}, {20738, -1, -1, -1}, {20744, -1, -1, -1}, {20745, -1, -1, -1}, {20741, -1, -1, -1}, {20956, -1, -1, -1}, {21127, -1, -1, -1}, {21128, -1, -1, -1}, {21129, -1, -1, -1}, {21133, -1, -1, -1}, {21130, -1, -1, -1}, {21232, -1, -1, -1}, {21426, -1, -1, -1}, {22062, -1, -1, -1}, {22075, -1, -1, -1}, {22073, -1, -1, -1}, {22066, -1, -1, -1}, {22079, -1, -1, -1}, {22068, -1, -1, -1}, {22057, -1, -1, -1}, {22099, -1, -1, -1}, {22094, -1, -1, -1}, {22103, -1, -1, -1}, {22132, -1, -1, -1}, {22070, -1, -1, -1}, {22063, -1, -1, -1}, {22064, -1, -1, -1}, {22656, -1, -1, -1}, {22687, -1, -1, -1}, {22686, -1, -1, -1}, {22707, -1, -1, -1}, {22684, -1, -1, -1}, {22702, -1, -1, -1}, {22697, -1, -1, -1}, {22694, -1, -1, -1}, {22893, -1, -1, -1}, {23305, -1, -1, -1}, {23291, -1, -1, -1}, {23307, -1, -1, -1}, {23285, -1, -1, -1}, {23308, -1, -1, -1}, {23304, -1, -1, -1}, {23534, -1, -1, -1}, {23532, -1, -1, -1}, {23529, -1, -1, -1}, {23531, -1, -1, -1}, {23652, -1, -1, -1}, {23653, -1, -1, -1}, {23965, -1, -1, -1}, {23956, -1, -1, -1}, {24162, -1, -1, -1}, {24159, -1, -1, -1}, {24161, -1, -1, -1}, {24290, -1, -1, -1}, {24282, -1, -1, -1}, {24287, -1, -1, -1}, {24285, -1, -1, -1}, {24291, -1, -1, -1}, {24288, -1, -1, -1}, {24392, -1, -1, -1}, {24433, -1, -1, -1}, {24503, -1, -1, -1}, {24501, -1, -1, -1}, {24950, -1, -1, -1}, {24935, -1, -1, -1}, {24942, -1, -1, -1}, {24925, -1, -1, -1}, {24917, -1, -1, -1}, {24962, -1, -1, -1}, {24956, -1, -1, -1}, {24944, -1, -1, -1}, {24939, -1, -1, -1}, {24958, -1, -1, -1}, {24999, -1, -1, -1}, {24976, -1, -1, -1}, {25003, -1, -1, -1}, {24974, -1, -1, -1}, {25004, -1, -1, -1}, {24986, -1, -1, -1}, {24996, -1, -1, -1}, {24980, -1, -1, -1}, {25006, -1, -1, -1}, {25134, -1, -1, -1}, {25705, -1, -1, -1}, {25711, -1, -1, -1}, {25721, -1, -1, -1}, {25758, -1, -1, -1}, {25778, -1, -1, -1}, {25736, -1, -1, -1}, {25744, -1, -1, -1}, {25776, -1, -1, -1}, {25765, -1, -1, -1}, {25747, -1, -1, -1}, {25749, -1, -1, -1}, {25769, -1, -1, -1}, {25746, -1, -1, -1}, {25774, -1, -1, -1}, {25773, -1, -1, -1}, {25771, -1, -1, -1}, {25754, -1, -1, -1}, {25772, -1, -1, -1}, {25753, -1, -1, -1}, {25762, -1, -1, -1}, {25779, -1, -1, -1}, {25973, -1, -1, -1}, {25975, -1, -1, -1}, {25976, -1, -1, -1}, {26286, -1, -1, -1}, {26283, -1, -1, -1}, {26292, -1, -1, -1}, {26289, -1, -1, -1}, {27171, -1, -1, -1}, {27167, -1, -1, -1}, {27112, -1, -1, -1}, {27137, -1, -1, -1}, {27166, -1, -1, -1}, {27161, -1, -1, -1}, {27133, -1, -1, -1}, {27169, -1, -1, -1}, {27155, -1, -1, -1}, {27146, -1, -1, -1}, {27123, -1, -1, -1}, {27138, -1, -1, -1}, {27141, -1, -1, -1}, {27117, -1, -1, -1}, {27153, -1, -1, -1}, {27472, -1, -1, -1}, {27470, -1, -1, -1}, {27556, -1, -1, -1}, {27589, -1, -1, -1}, {27590, -1, -1, -1}, {28479, -1, -1, -1}, {28540, -1, -1, -1}, {28548, -1, -1, -1}, {28497, -1, -1, -1}, {28518, -1, -1, -1}, {28500, -1, -1, -1}, {28550, -1, -1, -1}, {28525, -1, -1, -1}, {28507, -1, -1, -1}, {28536, -1, -1, -1}, {28526, -1, -1, -1}, {28558, -1, -1, -1}, {28538, -1, -1, -1}, {28528, -1, -1, -1}, {28516, -1, -1, -1}, {28567, -1, -1, -1}, {28504, -1, -1, -1}, {28373, -1, -1, -1}, {28527, -1, -1, -1}, {28512, -1, -1, -1}, {28511, -1, -1, -1}, {29087, -1, -1, -1}, {29100, -1, -1, -1}, {29105, -1, -1, -1}, {29096, -1, -1, -1}, {29270, -1, -1, -1}, {29339, -1, -1, -1}, {29518, -1, -1, -1}, {29527, -1, -1, -1}, {29801, -1, -1, -1}, {29835, -1, -1, -1}, {29827, -1, -1, -1}, {29822, -1, -1, -1}, {29824, -1, -1, -1}, {30079, -1, -1, -1}, {30240, -1, -1, -1}, {30249, -1, -1, -1}, {30239, -1, -1, -1}, {30244, -1, -1, -1}, {30246, -1, -1, -1}, {30241, -1, -1, -1}, {30242, -1, -1, -1}, {30362, -1, -1, -1}, {30394, -1, -1, -1}, {30436, -1, -1, -1}, {30606, -1, -1, -1}, {30599, -1, -1, -1}, {30604, -1, -1, -1}, {30609, -1, -1, -1}, {30603, -1, -1, -1}, {30923, -1, -1, -1}, {30917, -1, -1, -1}, {30906, -1, -1, -1}, {30922, -1, -1, -1}, {30910, -1, -1, -1}, {30933, -1, -1, -1}, {30908, -1, -1, -1}, {30928, -1, -1, -1}, {31295, -1, -1, -1}, {31292, -1, -1, -1}, {31296, -1, -1, -1}, {31293, -1, -1, -1}, {31287, -1, -1, -1}, {31291, -1, -1, -1}, {31407, -1, -1, -1}, {31406, -1, -1, -1}, {31661, -1, -1, -1}, {31665, -1, -1, -1}, {31684, -1, -1, -1}, {31668, -1, -1, -1}, {31686, -1, -1, -1}, {31687, -1, -1, -1}, {31681, -1, -1, -1}, {31648, -1, -1, -1}, {31692, -1, -1, -1}, {31946, -1, -1, -1}, {32224, -1, -1, -1}, {32244, -1, -1, -1}, {32239, -1, -1, -1}, {32251, -1, -1, -1}, {32216, -1, -1, -1}, {32236, -1, -1, -1}, {32221, -1, -1, -1}, {32232, -1, -1, -1}, {32227, -1, -1, -1}, {32218, -1, -1, -1}, {32222, -1, -1, -1}, {32233, -1, -1, -1}, {32158, -1, -1, -1}, {32217, -1, -1, -1}, {32242, -1, -1, -1}, {32249, -1, -1, -1}, {32629, -1, -1, -1}, {32631, -1, -1, -1}, {32687, -1, -1, -1}, {32745, -1, -1, -1}, {32806, -1, -1, -1}, {33179, -1, -1, -1}, {33180, -1, -1, -1}, {33181, -1, -1, -1}, {33184, -1, -1, -1}, {33178, -1, -1, -1}, {33176, -1, -1, -1}, {34071, -1, -1, -1}, {34109, -1, -1, -1}, {34074, -1, -1, -1}, {34030, -1, -1, -1}, {34092, -1, -1, -1}, {34093, -1, -1, -1}, {34067, -1, -1, -1}, {34065, -1, -1, -1}, {34083, -1, -1, -1}, {34081, -1, -1, -1}, {34068, -1, -1, -1}, {34028, -1, -1, -1}, {34085, -1, -1, -1}, {34047, -1, -1, -1}, {34054, -1, -1, -1}, {34690, -1, -1, -1} },
    {{34676, -1, -1, -1}, {34678, -1, -1, -1}, {34656, -1, -1, -1}, {34662, -1, -1, -1}, {34680, -1, -1, -1}, {34664, -1, -1, -1}, {34649, -1, -1, -1}, {34647, -1, -1, -1}, {34636, -1, -1, -1}, {34643, -1, -1, -1}, {34907, -1, -1, -1}, {34909, -1, -1, -1}, {35088, -1, -1, -1}, {35079, -1, -1, -1}, {35090, -1, -1, -1}, {35091, -1, -1, -1}, {35093, -1, -1, -1}, {35082, -1, -1, -1}, {35516, -1, -1, -1}, {35538, -1, -1, -1}, {35527, -1, -1, -1}, {35524, -1, -1, -1}, {35477, -1, -1, -1}, {35531, -1, -1, -1}, {35576, -1, -1, -1}, {35506, -1, -1, -1}, {35529, -1, -1, -1}, {35522, -1, -1, -1}, {35519, -1, -1, -1}, {35504, -1, -1, -1}, {35542, -1, -1, -1}, {35533, -1, -1, -1}, {35510, -1, -1, -1}, {35513, -1, -1, -1}, {35547, -1, -1, -1}, {35916, -1, -1, -1}, {35918, -1, -1, -1}, {35948, -1, -1, -1}, {36064, -1, -1, -1}, {36062, -1, -1, -1}, {36070, -1, -1, -1}, {36068, -1, -1, -1}, {36076, -1, -1, -1}, {36077, -1, -1, -1}, {36066, -1, -1, -1}, {36067, -1, -1, -1}, {36060, -1, -1, -1}, {36074, -1, -1, -1}, {36065, -1, -1, -1}, {36205, -1, -1, -1}, {36255, -1, -1, -1}, {36259, -1, -1, -1}, {36395, -1, -1, -1}, {36368, -1, -1, -1}, {36381, -1, -1, -1}, {36386, -1, -1, -1}, {36367, -1, -1, -1}, {36393, -1, -1, -1}, {36383, -1, -1, -1}, {36385, -1, -1, -1}, {36382, -1, -1, -1}, {36538, -1, -1, -1}, {36637, -1, -1, -1}, {36635, -1, -1, -1}, {36639, -1, -1, -1}, {36649, -1, -1, -1}, {36646, -1, -1, -1}, {36650, -1, -1, -1}, {36636, -1, -1, -1}, {36638, -1, -1, -1}, {36645, -1, -1, -1}, {36969, -1, -1, -1}, {36974, -1, -1, -1}, {36968, -1, -1, -1}, {36973, -1, -1, -1}, {36983, -1, -1, -1}, {37168, -1, -1, -1}, {37165, -1, -1, -1}, {37159, -1, -1, -1}, {37169, -1, -1, -1}, {37255, -1, -1, -1}, {37257, -1, -1, -1}, {37259, -1, -1, -1}, {37251, -1, -1, -1}, {37573, -1, -1, -1}, {37563, -1, -1, -1}, {37559, -1, -1, -1}, {37610, -1, -1, -1}, {37604, -1, -1, -1}, {37569, -1, -1, -1}, {37555, -1, -1, -1}, {37564, -1, -1, -1}, {37586, -1, -1, -1}, {37575, -1, -1, -1}, {37616, -1, -1, -1}, {37554, -1, -1, -1}, {38317, -1, -1, -1}, {38321, -1, -1, -1}, {38660, -1, -1, -1}, {38662, -1, -1, -1}, {38663, -1, -1, -1}, {38665, -1, -1, -1}, {38752, -1, -1, -1}, {38797, -1, -1, -1}, {38795, -1, -1, -1}, {38799, -1, -1, -1}, {38945, -1, -1, -1}, {38955, -1, -1, -1}, {38940, -1, -1, -1}, {39091, -1, -1, -1}, {39178, -1, -1, -1}, {39187, -1, -1, -1}, {39186, -1, -1, -1}, {39192, -1, -1, -1}, {39389, -1, -1, -1}, {39376, -1, -1, -1}, {39391, -1, -1, -1}, {39387, -1, -1, -1}, {39377, -1, -1, -1}, {39381, -1, -1, -1}, {39378, -1, -1, -1}, {39385, -1, -1, -1}, {39607, -1, -1, -1}, {39662, -1, -1, -1}, {39663, -1, -1, -1}, {39719, -1, -1, -1}, {39749, -1, -1, -1}, {39748, -1, -1, -1}, {39799, -1, -1, -1}, {39791, -1, -1, -1}, {40198, -1, -1, -1}, {40201, -1, -1, -1}, {40195, -1, -1, -1}, {40617, -1, -1, -1}, {40638, -1, -1, -1}, {40654, -1, -1, -1}, {22696, -1, -1, -1}, {40786, -1, -1, -1}, {20754, -1, -1, -1}, {20760, -1, -1, -1}, {20756, -1, -1, -1}, {20752, -1, -1, -1}, {20757, -1, -1, -1}, {20864, -1, -1, -1}, {20906, -1, -1, -1}, {20957, -1, -1, -1}, {21137, -1, -1, -1}, {21139, -1, -1, -1}, {21235, -1, -1, -1}, {22105, -1, -1, -1}, {22123, -1, -1, -1}, {22137, -1, -1, -1}, {22121, -1, -1, -1}, {22116, -1, -1, -1}, {22136, -1, -1, -1}, {22122, -1, -1, -1}, {22120, -1, -1, -1}, {22117, -1, -1, -1}, {22129, -1, -1, -1}, {22127, -1, -1, -1}, {22124, -1, -1, -1}, {22114, -1, -1, -1}, {22134, -1, -1, -1}, {22721, -1, -1, -1}, {22718, -1, -1, -1}, {22727, -1, -1, -1}, {22725, -1, -1, -1}, {22894, -1, -1, -1}, {23325, -1, -1, -1}, {23348, -1, -1, -1}, {23416, -1, -1, -1}, {23536, -1, -1, -1}, {23566, -1, -1, -1}, {24394, -1, -1, -1}, {25010, -1, -1, -1}, {24977, -1, -1, -1}, {25001, -1, -1, -1}, {24970, -1, -1, -1}, {25037, -1, -1, -1}, {25014, -1, -1, -1}, {25022, -1, -1, -1}, {25034, -1, -1, -1}, {25032, -1, -1, -1}, {25136, -1, -1, -1}, {25797, -1, -1, -1}, {25793, -1, -1, -1}, {25803, -1, -1, -1}, {25787, -1, -1, -1}, {25788, -1, -1, -1}, {25818, -1, -1, -1}, {25796, -1, -1, -1}, {25799, -1, -1, -1}, {25794, -1, -1, -1}, {25805, -1, -1, -1}, {25791, -1, -1, -1}, {25810, -1, -1, -1}, {25812, -1, -1, -1}, {25790, -1, -1, -1}, {25972, -1, -1, -1}, {26310, -1, -1, -1}, {26313, -1, -1, -1}, {26297, -1, -1, -1}, {26308, -1, -1, -1}, {26311, -1, -1, -1}, {26296, -1, -1, -1}, {27197, -1, -1, -1}, {27192, -1, -1, -1}, {27194, -1, -1, -1}, {27225, -1, -1, -1}, {27243, -1, -1, -1}, {27224, -1, -1, -1}, {27193, -1, -1, -1}, {27204, -1, -1, -1}, {27234, -1, -1, -1}, {27233, -1, -1, -1}, {27211, -1, -1, -1}, {27207, -1, -1, -1}, {27189, -1, -1, -1}, {27231, -1, -1, -1}, {27208, -1, -1, -1}, {27481, -1, -1, -1}, {27511, -1, -1, -1}, {27653, -1, -1, -1}, {28610, -1, -1, -1}, {28593, -1, -1, -1}, {28577, -1, -1, -1}, {28611, -1, -1, -1}, {28580, -1, -1, -1}, {28609, -1, -1, -1}, {28583, -1, -1, -1}, {28595, -1, -1, -1}, {28608, -1, -1, -1}, {28601, -1, -1, -1}, {28598, -1, -1, -1}, {28582, -1, -1, -1}, {28576, -1, -1, -1}, {28596, -1, -1, -1}, {29118, -1, -1, -1}, {29129, -1, -1, -1}, {29136, -1, -1, -1}, {29138, -1, -1, -1}, {29128, -1, -1, -1}, {29141, -1, -1, -1}, {29113, -1, -1, -1}, {29134, -1, -1, -1}, {29145, -1, -1, -1}, {29148, -1, -1, -1}, {29123, -1, -1, -1}, {29124, -1, -1, -1}, {29544, -1, -1, -1}, {29852, -1, -1, -1}, {29859, -1, -1, -1}, {29848, -1, -1, -1}, {29855, -1, -1, -1}, {29854, -1, -1, -1}, {29922, -1, -1, -1} },
    {{29964, -1, -1, -1}, {29965, -1, -1, -1}, {30260, -1, -1, -1}, {30264, -1, -1, -1}, {30266, -1, -1, -1}, {30439, -1, -1, -1}, {30437, -1, -1, -1}, {30624, -1, -1, -1}, {30622, -1, -1, -1}, {30623, -1, -1, -1}, {30629, -1, -1, -1}, {30952, -1, -1, -1}, {30938, -1, -1, -1}, {30956, -1, -1, -1}, {30951, -1, -1, -1}, {31142, -1, -1, -1}, {31309, -1, -1, -1}, {31310, -1, -1, -1}, {31302, -1, -1, -1}, {31308, -1, -1, -1}, {31307, -1, -1, -1}, {31418, -1, -1, -1}, {31705, -1, -1, -1}, {31761, -1, -1, -1}, {31689, -1, -1, -1}, {31716, -1, -1, -1}, {31707, -1, -1, -1}, {31713, -1, -1, -1}, {31721, -1, -1, -1}, {31718, -1, -1, -1}, {31957, -1, -1, -1}, {31958, -1, -1, -1}, {32266, -1, -1, -1}, {32273, -1, -1, -1}, {32264, -1, -1, -1}, {32283, -1, -1, -1}, {32291, -1, -1, -1}, {32286, -1, -1, -1}, {32285, -1, -1, -1}, {32265, -1, -1, -1}, {32272, -1, -1, -1}, {32633, -1, -1, -1}, {32690, -1, -1, -1}, {32752, -1, -1, -1}, {32753, -1, -1, -1}, {32750, -1, -1, -1}, {32808, -1, -1, -1}, {33203, -1, -1, -1}, {33193, -1, -1, -1}, {33192, -1, -1, -1}, {33275, -1, -1, -1}, {33288, -1, -1, -1}, {33368, -1, -1, -1}, {33369, -1, -1, -1}, {34122, -1, -1, -1}, {34137, -1, -1, -1}, {34120, -1, -1, -1}, {34152, -1, -1, -1}, {34153, -1, -1, -1}, {34115, -1, -1, -1}, {34121, -1, -1, -1}, {34157, -1, -1, -1}, {34154, -1, -1, -1}, {34142, -1, -1, -1}, {34691, -1, -1, -1}, {34719, -1, -1, -1}, {34718, -1, -1, -1}, {34722, -1, -1, -1}, {34701, -1, -1, -1}, {34913, -1, -1, -1}, {35114, -1, -1, -1}, {35122, -1, -1, -1}, {35109, -1, -1, -1}, {35115, -1, -1, -1}, {35105, -1, -1, -1}, {35242, -1, -1, -1}, {35238, -1, -1, -1}, {35558, -1, -1, -1}, {35578, -1, -1, -1}, {35563, -1, -1, -1}, {35569, -1, -1, -1}, {35584, -1, -1, -1}, {35548, -1, -1, -1}, {35559, -1, -1, -1}, {35566, -1, -1, -1}, {35582, -1, -1, -1}, {35585, -1, -1, -1}, {35586, -1, -1, -1}, {35575, -1, -1, -1}, {35565, -1, -1, -1}, {35571, -1, -1, -1}, {35574, -1, -1, -1}, {35580, -1, -1, -1}, {35947, -1, -1, -1}, {35949, -1, -1, -1}, {35987, -1, -1, -1}, {36084, -1, -1, -1}, {36420, -1, -1, -1}, {36401, -1, -1, -1}, {36404, -1, -1, -1}, {36418, -1, -1, -1}, {36409, -1, -1, -1}, {36405, -1, -1, -1}, {36667, -1, -1, -1}, {36655, -1, -1, -1}, {36664, -1, -1, -1}, {36659, -1, -1, -1}, {36776, -1, -1, -1}, {36774, -1, -1, -1}, {36981, -1, -1, -1}, {36980, -1, -1, -1}, {36984, -1, -1, -1}, {36978, -1, -1, -1}, {36988, -1, -1, -1}, {36986, -1, -1, -1}, {37172, -1, -1, -1}, {37266, -1, -1, -1}, {37664, -1, -1, -1}, {37686, -1, -1, -1}, {37624, -1, -1, -1}, {37683, -1, -1, -1}, {37679, -1, -1, -1}, {37666, -1, -1, -1}, {37628, -1, -1, -1}, {37675, -1, -1, -1}, {37636, -1, -1, -1}, {37658, -1, -1, -1}, {37648, -1, -1, -1}, {37670, -1, -1, -1}, {37665, -1, -1, -1}, {37653, -1, -1, -1}, {37678, -1, -1, -1}, {37657, -1, -1, -1}, {38331, -1, -1, -1}, {38567, -1, -1, -1}, {38568, -1, -1, -1}, {38570, -1, -1, -1}, {38613, -1, -1, -1}, {38670, -1, -1, -1}, {38673, -1, -1, -1}, {38678, -1, -1, -1}, {38669, -1, -1, -1}, {38675, -1, -1, -1}, {38671, -1, -1, -1}, {38747, -1, -1, -1}, {38748, -1, -1, -1}, {38758, -1, -1, -1}, {38808, -1, -1, -1}, {38960, -1, -1, -1}, {38968, -1, -1, -1}, {38971, -1, -1, -1}, {38967, -1, -1, -1}, {38957, -1, -1, -1}, {38969, -1, -1, -1}, {38948, -1, -1, -1}, {39184, -1, -1, -1}, {39208, -1, -1, -1}, {39198, -1, -1, -1}, {39195, -1, -1, -1}, {39201, -1, -1, -1}, {39194, -1, -1, -1}, {39405, -1, -1, -1}, {39394, -1, -1, -1}, {39409, -1, -1, -1}, {39608, -1, -1, -1}, {39612, -1, -1, -1}, {39675, -1, -1, -1}, {39661, -1, -1, -1}, {39720, -1, -1, -1}, {39825, -1, -1, -1}, {40213, -1, -1, -1}, {40227, -1, -1, -1}, {40230, -1, -1, -1}, {40232, -1, -1, -1}, {40210, -1, -1, -1}, {40219, -1, -1, -1}, {40664, -1, -1, -1}, {40660, -1, -1, -1}, {40845, -1, -1, -1}, {40860, -1, -1, -1}, {20778, -1, -1, -1}, {20767, -1, -1, -1}, {20769, -1, -1, -1}, {20786, -1, -1, -1}, {21237, -1, -1, -1}, {22158, -1, -1, -1}, {22144, -1, -1, -1}, {22160, -1, -1, -1}, {22149, -1, -1, -1}, {22151, -1, -1, -1}, {22159, -1, -1, -1}, {22741, -1, -1, -1}, {22739, -1, -1, -1}, {22737, -1, -1, -1}, {22734, -1, -1, -1}, {23344, -1, -1, -1}, {23338, -1, -1, -1}, {23332, -1, -1, -1}, {23418, -1, -1, -1}, {23607, -1, -1, -1}, {23656, -1, -1, -1}, {23996, -1, -1, -1}, {23994, -1, -1, -1}, {23997, -1, -1, -1}, {23992, -1, -1, -1}, {24171, -1, -1, -1}, {24396, -1, -1, -1}, {24509, -1, -1, -1}, {25033, -1, -1, -1}, {25026, -1, -1, -1}, {25031, -1, -1, -1}, {25062, -1, -1, -1}, {25035, -1, -1, -1}, {25138, -1, -1, -1}, {25140, -1, -1, -1}, {25806, -1, -1, -1}, {25802, -1, -1, -1}, {25816, -1, -1, -1}, {25824, -1, -1, -1}, {25840, -1, -1, -1}, {25830, -1, -1, -1}, {25836, -1, -1, -1}, {25841, -1, -1, -1}, {25826, -1, -1, -1}, {25837, -1, -1, -1}, {25986, -1, -1, -1}, {25987, -1, -1, -1}, {26329, -1, -1, -1}, {26326, -1, -1, -1}, {27264, -1, -1, -1}, {27284, -1, -1, -1}, {27268, -1, -1, -1}, {27298, -1, -1, -1}, {27292, -1, -1, -1}, {27355, -1, -1, -1}, {27299, -1, -1, -1}, {27262, -1, -1, -1}, {27287, -1, -1, -1}, {27280, -1, -1, -1}, {27296, -1, -1, -1}, {27484, -1, -1, -1}, {27566, -1, -1, -1}, {27610, -1, -1, -1}, {27656, -1, -1, -1}, {28632, -1, -1, -1}, {28657, -1, -1, -1}, {28639, -1, -1, -1}, {28640, -1, -1, -1}, {28635, -1, -1, -1}, {28644, -1, -1, -1}, {28651, -1, -1, -1}, {28655, -1, -1, -1}, {28544, -1, -1, -1}, {28652, -1, -1, -1}, {28641, -1, -1, -1}, {28649, -1, -1, -1} },
    {{28629, -1, -1, -1}, {28654, -1, -1, -1}, {28656, -1, -1, -1}, {29159, -1, -1, -1}, {29151, -1, -1, -1}, {29166, -1, -1, -1}, {29158, -1, -1, -1}, {29157, -1, -1, -1}, {29165, -1, -1, -1}, {29164, -1, -1, -1}, {29172, -1, -1, -1}, {29152, -1, -1, -1}, {29237, -1, -1, -1}, {29254, -1, -1, -1}, {29552, -1, -1, -1}, {29554, -1, -1, -1}, {29865, -1, -1, -1}, {29872, -1, -1, -1}, {29862, -1, -1, -1}, {29864, -1, -1, -1}, {30278, -1, -1, -1}, {30274, -1, -1, -1}, {30284, -1, -1, -1}, {30442, -1, -1, -1}, {30643, -1, -1, -1}, {30634, -1, -1, -1}, {30640, -1, -1, -1}, {30636, -1, -1, -1}, {30631, -1, -1, -1}, {30637, -1, -1, -1}, {30703, -1, -1, -1}, {30967, -1, -1, -1}, {30970, -1, -1, -1}, {30964, -1, -1, -1}, {30959, -1, -1, -1}, {30977, -1, -1, -1}, {31143, -1, -1, -1}, {31146, -1, -1, -1}, {31319, -1, -1, -1}, {31423, -1, -1, -1}, {31751, -1, -1, -1}, {31757, -1, -1, -1}, {31742, -1, -1, -1}, {31735, -1, -1, -1}, {31756, -1, -1, -1}, {31712, -1, -1, -1}, {31968, -1, -1, -1}, {31964, -1, -1, -1}, {31966, -1, -1, -1}, {31970, -1, -1, -1}, {31967, -1, -1, -1}, {31961, -1, -1, -1}, {31965, -1, -1, -1}, {32302, -1, -1, -1}, {32318, -1, -1, -1}, {32326, -1, -1, -1}, {32311, -1, -1, -1}, {32306, -1, -1, -1}, {32323, -1, -1, -1}, {32299, -1, -1, -1}, {32317, -1, -1, -1}, {32305, -1, -1, -1}, {32325, -1, -1, -1}, {32321, -1, -1, -1}, {32308, -1, -1, -1}, {32313, -1, -1, -1}, {32328, -1, -1, -1}, {32309, -1, -1, -1}, {32319, -1, -1, -1}, {32303, -1, -1, -1}, {32580, -1, -1, -1}, {32755, -1, -1, -1}, {32764, -1, -1, -1}, {32881, -1, -1, -1}, {32882, -1, -1, -1}, {32880, -1, -1, -1}, {32879, -1, -1, -1}, {32883, -1, -1, -1}, {33222, -1, -1, -1}, {33219, -1, -1, -1}, {33210, -1, -1, -1}, {33218, -1, -1, -1}, {33216, -1, -1, -1}, {33215, -1, -1, -1}, {33213, -1, -1, -1}, {33225, -1, -1, -1}, {33214, -1, -1, -1}, {33256, -1, -1, -1}, {33289, -1, -1, -1}, {33393, -1, -1, -1}, {34218, -1, -1, -1}, {34180, -1, -1, -1}, {34174, -1, -1, -1}, {34204, -1, -1, -1}, {34193, -1, -1, -1}, {34196, -1, -1, -1}, {34223, -1, -1, -1}, {34203, -1, -1, -1}, {34183, -1, -1, -1}, {34216, -1, -1, -1}, {34186, -1, -1, -1}, {34214, -1, -1, -1}, {34407, -1, -1, -1}, {34752, -1, -1, -1}, {34769, -1, -1, -1}, {34739, -1, -1, -1}, {34770, -1, -1, -1}, {34758, -1, -1, -1}, {34731, -1, -1, -1}, {34747, -1, -1, -1}, {34746, -1, -1, -1}, {34760, -1, -1, -1}, {34763, -1, -1, -1}, {35131, -1, -1, -1}, {35126, -1, -1, -1}, {35140, -1, -1, -1}, {35128, -1, -1, -1}, {35133, -1, -1, -1}, {35244, -1, -1, -1}, {35598, -1, -1, -1}, {35607, -1, -1, -1}, {35609, -1, -1, -1}, {35611, -1, -1, -1}, {35594, -1, -1, -1}, {35616, -1, -1, -1}, {35613, -1, -1, -1}, {35588, -1, -1, -1}, {35600, -1, -1, -1}, {35905, -1, -1, -1}, {35903, -1, -1, -1}, {35955, -1, -1, -1}, {36090, -1, -1, -1}, {36093, -1, -1, -1}, {36092, -1, -1, -1}, {36088, -1, -1, -1}, {36091, -1, -1, -1}, {36264, -1, -1, -1}, {36425, -1, -1, -1}, {36427, -1, -1, -1}, {36424, -1, -1, -1}, {36426, -1, -1, -1}, {36676, -1, -1, -1}, {36670, -1, -1, -1}, {36674, -1, -1, -1}, {36677, -1, -1, -1}, {36671, -1, -1, -1}, {36991, -1, -1, -1}, {36989, -1, -1, -1}, {36996, -1, -1, -1}, {36993, -1, -1, -1}, {36994, -1, -1, -1}, {36992, -1, -1, -1}, {37177, -1, -1, -1}, {37283, -1, -1, -1}, {37278, -1, -1, -1}, {37276, -1, -1, -1}, {37709, -1, -1, -1}, {37762, -1, -1, -1}, {37672, -1, -1, -1}, {37749, -1, -1, -1}, {37706, -1, -1, -1}, {37733, -1, -1, -1}, {37707, -1, -1, -1}, {37656, -1, -1, -1}, {37758, -1, -1, -1}, {37740, -1, -1, -1}, {37723, -1, -1, -1}, {37744, -1, -1, -1}, {37722, -1, -1, -1}, {37716, -1, -1, -1}, {38346, -1, -1, -1}, {38347, -1, -1, -1}, {38348, -1, -1, -1}, {38344, -1, -1, -1}, {38342, -1, -1, -1}, {38577, -1, -1, -1}, {38584, -1, -1, -1}, {38614, -1, -1, -1}, {38684, -1, -1, -1}, {38686, -1, -1, -1}, {38816, -1, -1, -1}, {38867, -1, -1, -1}, {38982, -1, -1, -1}, {39094, -1, -1, -1}, {39221, -1, -1, -1}, {39425, -1, -1, -1}, {39423, -1, -1, -1}, {39854, -1, -1, -1}, {39851, -1, -1, -1}, {39850, -1, -1, -1}, {39853, -1, -1, -1}, {40251, -1, -1, -1}, {40255, -1, -1, -1}, {40587, -1, -1, -1}, {40655, -1, -1, -1}, {40670, -1, -1, -1}, {40668, -1, -1, -1}, {40669, -1, -1, -1}, {40667, -1, -1, -1}, {40766, -1, -1, -1}, {40779, -1, -1, -1}, {21474, -1, -1, -1}, {22165, -1, -1, -1}, {22190, -1, -1, -1}, {22745, -1, -1, -1}, {22744, -1, -1, -1}, {23352, -1, -1, -1}, {24413, -1, -1, -1}, {25059, -1, -1, -1}, {25139, -1, -1, -1}, {25844, -1, -1, -1}, {25842, -1, -1, -1}, {25854, -1, -1, -1}, {25862, -1, -1, -1}, {25850, -1, -1, -1}, {25851, -1, -1, -1}, {25847, -1, -1, -1}, {26039, -1, -1, -1}, {26332, -1, -1, -1}, {26406, -1, -1, -1}, {27315, -1, -1, -1}, {27308, -1, -1, -1}, {27331, -1, -1, -1}, {27323, -1, -1, -1}, {27320, -1, -1, -1}, {27330, -1, -1, -1}, {27310, -1, -1, -1}, {27311, -1, -1, -1}, {27487, -1, -1, -1}, {27512, -1, -1, -1}, {27567, -1, -1, -1}, {28681, -1, -1, -1}, {28683, -1, -1, -1}, {28670, -1, -1, -1}, {28678, -1, -1, -1}, {28666, -1, -1, -1}, {28689, -1, -1, -1}, {28687, -1, -1, -1}, {29179, -1, -1, -1}, {29180, -1, -1, -1}, {29182, -1, -1, -1}, {29176, -1, -1, -1}, {29559, -1, -1, -1}, {29557, -1, -1, -1}, {29863, -1, -1, -1}, {29887, -1, -1, -1}, {29973, -1, -1, -1}, {30294, -1, -1, -1}, {30296, -1, -1, -1}, {30290, -1, -1, -1}, {30653, -1, -1, -1}, {30655, -1, -1, -1}, {30651, -1, -1, -1}, {30652, -1, -1, -1}, {30990, -1, -1, -1}, {31150, -1, -1, -1} },
    {{31329, -1, -1, -1}, {31330, -1, -1, -1}, {31328, -1, -1, -1}, {31428, -1, -1, -1}, {31429, -1, -1, -1}, {31787, -1, -1, -1}, {31783, -1, -1, -1}, {31786, -1, -1, -1}, {31774, -1, -1, -1}, {31779, -1, -1, -1}, {31777, -1, -1, -1}, {31975, -1, -1, -1}, {32340, -1, -1, -1}, {32341, -1, -1, -1}, {32350, -1, -1, -1}, {32346, -1, -1, -1}, {32353, -1, -1, -1}, {32338, -1, -1, -1}, {32345, -1, -1, -1}, {32584, -1, -1, -1}, {32761, -1, -1, -1}, {32763, -1, -1, -1}, {32887, -1, -1, -1}, {32886, -1, -1, -1}, {33229, -1, -1, -1}, {33231, -1, -1, -1}, {33290, -1, -1, -1}, {34255, -1, -1, -1}, {34217, -1, -1, -1}, {34253, -1, -1, -1}, {34256, -1, -1, -1}, {34249, -1, -1, -1}, {34224, -1, -1, -1}, {34234, -1, -1, -1}, {34233, -1, -1, -1}, {34799, -1, -1, -1}, {34796, -1, -1, -1}, {34802, -1, -1, -1}, {34784, -1, -1, -1}, {35206, -1, -1, -1}, {35250, -1, -1, -1}, {35316, -1, -1, -1}, {35624, -1, -1, -1}, {35641, -1, -1, -1}, {35628, -1, -1, -1}, {35627, -1, -1, -1}, {35920, -1, -1, -1}, {36101, -1, -1, -1}, {36441, -1, -1, -1}, {36451, -1, -1, -1}, {36454, -1, -1, -1}, {36452, -1, -1, -1}, {36447, -1, -1, -1}, {36437, -1, -1, -1}, {36544, -1, -1, -1}, {36681, -1, -1, -1}, {36685, -1, -1, -1}, {36999, -1, -1, -1}, {36995, -1, -1, -1}, {37000, -1, -1, -1}, {37291, -1, -1, -1}, {37292, -1, -1, -1}, {37328, -1, -1, -1}, {37780, -1, -1, -1}, {37770, -1, -1, -1}, {37782, -1, -1, -1}, {37794, -1, -1, -1}, {37811, -1, -1, -1}, {37806, -1, -1, -1}, {37804, -1, -1, -1}, {37808, -1, -1, -1}, {37784, -1, -1, -1}, {37786, -1, -1, -1}, {37783, -1, -1, -1}, {38356, -1, -1, -1}, {38358, -1, -1, -1}, {38352, -1, -1, -1}, {38357, -1, -1, -1}, {38626, -1, -1, -1}, {38620, -1, -1, -1}, {38617, -1, -1, -1}, {38619, -1, -1, -1}, {38622, -1, -1, -1}, {38692, -1, -1, -1}, {38819, -1, -1, -1}, {38822, -1, -1, -1}, {38829, -1, -1, -1}, {38905, -1, -1, -1}, {38989, -1, -1, -1}, {38991, -1, -1, -1}, {38988, -1, -1, -1}, {38990, -1, -1, -1}, {38995, -1, -1, -1}, {39098, -1, -1, -1}, {39230, -1, -1, -1}, {39231, -1, -1, -1}, {39229, -1, -1, -1}, {39214, -1, -1, -1}, {39333, -1, -1, -1}, {39438, -1, -1, -1}, {39617, -1, -1, -1}, {39683, -1, -1, -1}, {39686, -1, -1, -1}, {39759, -1, -1, -1}, {39758, -1, -1, -1}, {39757, -1, -1, -1}, {39882, -1, -1, -1}, {39881, -1, -1, -1}, {39933, -1, -1, -1}, {39880, -1, -1, -1}, {39872, -1, -1, -1}, {40273, -1, -1, -1}, {40285, -1, -1, -1}, {40288, -1, -1, -1}, {40672, -1, -1, -1}, {40725, -1, -1, -1}, {40748, -1, -1, -1}, {20787, -1, -1, -1}, {22181, -1, -1, -1}, {22184, -1, -1, -1}, {22750, -1, -1, -1}, {22751, -1, -1, -1}, {22754, -1, -1, -1}, {23541, -1, -1, -1}, {40848, -1, -1, -1}, {24300, -1, -1, -1}, {25074, -1, -1, -1}, {25079, -1, -1, -1}, {25078, -1, -1, -1}, {25077, -1, -1, -1}, {25856, -1, -1, -1}, {25871, -1, -1, -1}, {26336, -1, -1, -1}, {26333, -1, -1, -1}, {27365, -1, -1, -1}, {27357, -1, -1, -1}, {27354, -1, -1, -1}, {27347, -1, -1, -1}, {28699, -1, -1, -1}, {28703, -1, -1, -1}, {28712, -1, -1, -1}, {28698, -1, -1, -1}, {28701, -1, -1, -1}, {28693, -1, -1, -1}, {28696, -1, -1, -1}, {29190, -1, -1, -1}, {29197, -1, -1, -1}, {29272, -1, -1, -1}, {29346, -1, -1, -1}, {29560, -1, -1, -1}, {29562, -1, -1, -1}, {29885, -1, -1, -1}, {29898, -1, -1, -1}, {29923, -1, -1, -1}, {30087, -1, -1, -1}, {30086, -1, -1, -1}, {30303, -1, -1, -1}, {30305, -1, -1, -1}, {30663, -1, -1, -1}, {31001, -1, -1, -1}, {31153, -1, -1, -1}, {31339, -1, -1, -1}, {31337, -1, -1, -1}, {31806, -1, -1, -1}, {31807, -1, -1, -1}, {31800, -1, -1, -1}, {31805, -1, -1, -1}, {31799, -1, -1, -1}, {31808, -1, -1, -1}, {32363, -1, -1, -1}, {32365, -1, -1, -1}, {32377, -1, -1, -1}, {32361, -1, -1, -1}, {32362, -1, -1, -1}, {32371, -1, -1, -1}, {32645, -1, -1, -1}, {32694, -1, -1, -1}, {32697, -1, -1, -1}, {32696, -1, -1, -1}, {33240, -1, -1, -1}, {34281, -1, -1, -1}, {34269, -1, -1, -1}, {34282, -1, -1, -1}, {34261, -1, -1, -1}, {34276, -1, -1, -1}, {34277, -1, -1, -1}, {34295, -1, -1, -1}, {34811, -1, -1, -1}, {34821, -1, -1, -1}, {34829, -1, -1, -1}, {34809, -1, -1, -1}, {34814, -1, -1, -1}, {35168, -1, -1, -1}, {35167, -1, -1, -1}, {35158, -1, -1, -1}, {35166, -1, -1, -1}, {35649, -1, -1, -1}, {35676, -1, -1, -1}, {35672, -1, -1, -1}, {35657, -1, -1, -1}, {35674, -1, -1, -1}, {35662, -1, -1, -1}, {35663, -1, -1, -1}, {35654, -1, -1, -1}, {35673, -1, -1, -1}, {36104, -1, -1, -1}, {36106, -1, -1, -1}, {36476, -1, -1, -1}, {36466, -1, -1, -1}, {36487, -1, -1, -1}, {36470, -1, -1, -1}, {36460, -1, -1, -1}, {36474, -1, -1, -1}, {36468, -1, -1, -1}, {36692, -1, -1, -1}, {36686, -1, -1, -1}, {36781, -1, -1, -1}, {37002, -1, -1, -1}, {37003, -1, -1, -1}, {37297, -1, -1, -1}, {37294, -1, -1, -1}, {37857, -1, -1, -1}, {37841, -1, -1, -1}, {37855, -1, -1, -1}, {37827, -1, -1, -1}, {37832, -1, -1, -1}, {37852, -1, -1, -1}, {37853, -1, -1, -1}, {37846, -1, -1, -1}, {37858, -1, -1, -1}, {37837, -1, -1, -1}, {37848, -1, -1, -1}, {37860, -1, -1, -1}, {37847, -1, -1, -1}, {37864, -1, -1, -1}, {38364, -1, -1, -1}, {38580, -1, -1, -1}, {38627, -1, -1, -1}, {38698, -1, -1, -1}, {38695, -1, -1, -1}, {38753, -1, -1, -1}, {38876, -1, -1, -1}, {38907, -1, -1, -1}, {39006, -1, -1, -1}, {39000, -1, -1, -1}, {39003, -1, -1, -1}, {39100, -1, -1, -1}, {39237, -1, -1, -1}, {39241, -1, -1, -1}, {39446, -1, -1, -1}, {39449, -1, -1, -1}, {39693, -1, -1, -1}, {39912, -1, -1, -1}, {39911, -1, -1, -1}, {39894, -1, -1, -1}, {39899, -1, -1, -1} },
    {{40329, -1, -1, -1}, {40289, -1, -1, -1}, {40306, -1, -1, -1}, {40298, -1, -1, -1}, {40300, -1, -1, -1}, {40594, -1, -1, -1}, {40599, -1, -1, -1}, {40595, -1, -1, -1}, {40628, -1, -1, -1}, {21240, -1, -1, -1}, {22199, -1, -1, -1}, {22198, -1, -1, -1}, {22196, -1, -1, -1}, {22204, -1, -1, -1}, {22756, -1, -1, -1}, {23360, -1, -1, -1}, {23363, -1, -1, -1}, {23421, -1, -1, -1}, {23542, -1, -1, -1}, {24009, -1, -1, -1}, {25080, -1, -1, -1}, {25082, -1, -1, -1}, {25880, -1, -1, -1}, {25876, -1, -1, -1}, {25881, -1, -1, -1}, {26342, -1, -1, -1}, {26407, -1, -1, -1}, {27372, -1, -1, -1}, {28734, -1, -1, -1}, {28720, -1, -1, -1}, {28722, -1, -1, -1}, {29200, -1, -1, -1}, {29563, -1, -1, -1}, {29903, -1, -1, -1}, {30306, -1, -1, -1}, {30309, -1, -1, -1}, {31014, -1, -1, -1}, {31018, -1, -1, -1}, {31020, -1, -1, -1}, {31019, -1, -1, -1}, {31431, -1, -1, -1}, {31478, -1, -1, -1}, {31820, -1, -1, -1}, {31811, -1, -1, -1}, {31821, -1, -1, -1}, {31983, -1, -1, -1}, {31984, -1, -1, -1}, {36782, -1, -1, -1}, {32381, -1, -1, -1}, {32380, -1, -1, -1}, {32386, -1, -1, -1}, {32588, -1, -1, -1}, {32768, -1, -1, -1}, {33242, -1, -1, -1}, {33382, -1, -1, -1}, {34299, -1, -1, -1}, {34297, -1, -1, -1}, {34321, -1, -1, -1}, {34298, -1, -1, -1}, {34310, -1, -1, -1}, {34315, -1, -1, -1}, {34311, -1, -1, -1}, {34314, -1, -1, -1}, {34836, -1, -1, -1}, {34837, -1, -1, -1}, {35172, -1, -1, -1}, {35258, -1, -1, -1}, {35320, -1, -1, -1}, {35696, -1, -1, -1}, {35692, -1, -1, -1}, {35686, -1, -1, -1}, {35695, -1, -1, -1}, {35679, -1, -1, -1}, {35691, -1, -1, -1}, {36111, -1, -1, -1}, {36109, -1, -1, -1}, {36489, -1, -1, -1}, {36481, -1, -1, -1}, {36485, -1, -1, -1}, {36482, -1, -1, -1}, {37300, -1, -1, -1}, {37323, -1, -1, -1}, {37912, -1, -1, -1}, {37891, -1, -1, -1}, {37885, -1, -1, -1}, {38369, -1, -1, -1}, {38704, -1, -1, -1}, {39108, -1, -1, -1}, {39250, -1, -1, -1}, {39249, -1, -1, -1}, {39336, -1, -1, -1}, {39467, -1, -1, -1}, {39472, -1, -1, -1}, {39479, -1, -1, -1}, {39477, -1, -1, -1}, {39955, -1, -1, -1}, {39949, -1, -1, -1}, {40569, -1, -1, -1}, {40629, -1, -1, -1}, {40680, -1, -1, -1}, {40751, -1, -1, -1}, {40799, -1, -1, -1}, {40803, -1, -1, -1}, {40801, -1, -1, -1}, {20791, -1, -1, -1}, {20792, -1, -1, -1}, {22209, -1, -1, -1}, {22208, -1, -1, -1}, {22210, -1, -1, -1}, {22804, -1, -1, -1}, {23660, -1, -1, -1}, {24013, -1, -1, -1}, {25084, -1, -1, -1}, {25086, -1, -1, -1}, {25885, -1, -1, -1}, {25884, -1, -1, -1}, {26005, -1, -1, -1}, {26345, -1, -1, -1}, {27387, -1, -1, -1}, {27396, -1, -1, -1}, {27386, -1, -1, -1}, {27570, -1, -1, -1}, {28748, -1, -1, -1}, {29211, -1, -1, -1}, {29351, -1, -1, -1}, {29910, -1, -1, -1}, {29908, -1, -1, -1}, {30313, -1, -1, -1}, {30675, -1, -1, -1}, {31824, -1, -1, -1}, {32399, -1, -1, -1}, {32396, -1, -1, -1}, {32700, -1, -1, -1}, {34327, -1, -1, -1}, {34349, -1, -1, -1}, {34330, -1, -1, -1}, {34851, -1, -1, -1}, {34850, -1, -1, -1}, {34849, -1, -1, -1}, {34847, -1, -1, -1}, {35178, -1, -1, -1}, {35180, -1, -1, -1}, {35261, -1, -1, -1}, {35700, -1, -1, -1}, {35703, -1, -1, -1}, {35709, -1, -1, -1}, {36115, -1, -1, -1}, {36490, -1, -1, -1}, {36493, -1, -1, -1}, {36491, -1, -1, -1}, {36703, -1, -1, -1}, {36783, -1, -1, -1}, {37306, -1, -1, -1}, {37934, -1, -1, -1}, {37939, -1, -1, -1}, {37941, -1, -1, -1}, {37946, -1, -1, -1}, {37944, -1, -1, -1}, {37938, -1, -1, -1}, {37931, -1, -1, -1}, {38370, -1, -1, -1}, {38712, -1, -1, -1}, {38713, -1, -1, -1}, {38706, -1, -1, -1}, {38911, -1, -1, -1}, {39015, -1, -1, -1}, {39013, -1, -1, -1}, {39255, -1, -1, -1}, {39493, -1, -1, -1}, {39491, -1, -1, -1}, {39488, -1, -1, -1}, {39486, -1, -1, -1}, {39631, -1, -1, -1}, {39764, -1, -1, -1}, {39761, -1, -1, -1}, {39981, -1, -1, -1}, {39973, -1, -1, -1}, {40367, -1, -1, -1}, {40372, -1, -1, -1}, {40386, -1, -1, -1}, {40376, -1, -1, -1}, {40605, -1, -1, -1}, {40687, -1, -1, -1}, {40729, -1, -1, -1}, {40796, -1, -1, -1}, {40806, -1, -1, -1}, {40807, -1, -1, -1}, {20796, -1, -1, -1}, {20795, -1, -1, -1}, {22216, -1, -1, -1}, {22218, -1, -1, -1}, {22217, -1, -1, -1}, {23423, -1, -1, -1}, {24020, -1, -1, -1}, {24018, -1, -1, -1}, {24398, -1, -1, -1}, {25087, -1, -1, -1}, {25892, -1, -1, -1}, {27402, -1, -1, -1}, {27489, -1, -1, -1}, {28753, -1, -1, -1}, {28760, -1, -1, -1}, {29568, -1, -1, -1}, {29924, -1, -1, -1}, {30090, -1, -1, -1}, {30318, -1, -1, -1}, {30316, -1, -1, -1}, {31155, -1, -1, -1}, {31840, -1, -1, -1}, {31839, -1, -1, -1}, {32894, -1, -1, -1}, {32893, -1, -1, -1}, {33247, -1, -1, -1}, {35186, -1, -1, -1}, {35183, -1, -1, -1}, {35324, -1, -1, -1}, {35712, -1, -1, -1}, {36118, -1, -1, -1}, {36119, -1, -1, -1}, {36497, -1, -1, -1}, {36499, -1, -1, -1}, {36705, -1, -1, -1}, {37192, -1, -1, -1}, {37956, -1, -1, -1}, {37969, -1, -1, -1}, {37970, -1, -1, -1}, {38717, -1, -1, -1}, {38718, -1, -1, -1}, {38851, -1, -1, -1}, {38849, -1, -1, -1}, {39019, -1, -1, -1}, {39253, -1, -1, -1}, {39509, -1, -1, -1}, {39501, -1, -1, -1}, {39634, -1, -1, -1}, {39706, -1, -1, -1}, {40009, -1, -1, -1}, {39985, -1, -1, -1}, {39998, -1, -1, -1}, {39995, -1, -1, -1}, {40403, -1, -1, -1}, {40407, -1, -1, -1}, {40756, -1, -1, -1}, {40812, -1, -1, -1}, {40810, -1, -1, -1}, {40852, -1, -1, -1}, {22220, -1, -1, -1}, {24022, -1, -1, -1}, {25088, -1, -1, -1}, {25891, -1, -1, -1}, {25899, -1, -1, -1}, {25898, -1, -1, -1}, {26348, -1, -1, -1}, {27408, -1, -1, -1}, {29914, -1, -1, -1}, {31434, -1, -1, -1} },
    {{31844, -1, -1, -1}, {31843, -1, -1, -1}, {31845, -1, -1, -1}, {32403, -1, -1, -1}, {32406, -1, -1, -1}, {32404, -1, -1, -1}, {33250, -1, -1, -1}, {34360, -1, -1, -1}, {34367, -1, -1, -1}, {34865, -1, -1, -1}, {35722, -1, -1, -1}, {37008, -1, -1, -1}, {37007, -1, -1, -1}, {37987, -1, -1, -1}, {37984, -1, -1, -1}, {37988, -1, -1, -1}, {38760, -1, -1, -1}, {39023, -1, -1, -1}, {39260, -1, -1, -1}, {39514, -1, -1, -1}, {39515, -1, -1, -1}, {39511, -1, -1, -1}, {39635, -1, -1, -1}, {39636, -1, -1, -1}, {39633, -1, -1, -1}, {40020, -1, -1, -1}, {40023, -1, -1, -1}, {40022, -1, -1, -1}, {40421, -1, -1, -1}, {40607, -1, -1, -1}, {40692, -1, -1, -1}, {22225, -1, -1, -1}, {22761, -1, -1, -1}, {25900, -1, -1, -1}, {28766, -1, -1, -1}, {30321, -1, -1, -1}, {30322, -1, -1, -1}, {30679, -1, -1, -1}, {32592, -1, -1, -1}, {32648, -1, -1, -1}, {34870, -1, -1, -1}, {34873, -1, -1, -1}, {34914, -1, -1, -1}, {35731, -1, -1, -1}, {35730, -1, -1, -1}, {35734, -1, -1, -1}, {33399, -1, -1, -1}, {36123, -1, -1, -1}, {37312, -1, -1, -1}, {37994, -1, -1, -1}, {38722, -1, -1, -1}, {38728, -1, -1, -1}, {38724, -1, -1, -1}, {38854, -1, -1, -1}, {39024, -1, -1, -1}, {39519, -1, -1, -1}, {39714, -1, -1, -1}, {39768, -1, -1, -1}, {40031, -1, -1, -1}, {40441, -1, -1, -1}, {40442, -1, -1, -1}, {40572, -1, -1, -1}, {40573, -1, -1, -1}, {40711, -1, -1, -1}, {40823, -1, -1, -1}, {40818, -1, -1, -1}, {24307, -1, -1, -1}, {27414, -1, -1, -1}, {28771, -1, -1, -1}, {31852, -1, -1, -1}, {31854, -1, -1, -1}, {34875, -1, -1, -1}, {35264, -1, -1, -1}, {36513, -1, -1, -1}, {37313, -1, -1, -1}, {38002, -1, -1, -1}, {38000, -1, -1, -1}, {39025, -1, -1, -1}, {39262, -1, -1, -1}, {39638, -1, -1, -1}, {39715, -1, -1, -1}, {40652, -1, -1, -1}, {28772, -1, -1, -1}, {30682, -1, -1, -1}, {35738, -1, -1, -1}, {38007, -1, -1, -1}, {38857, -1, -1, -1}, {39522, -1, -1, -1}, {39525, -1, -1, -1}, {32412, -1, -1, -1}, {35740, -1, -1, -1}, {36522, -1, -1, -1}, {37317, -1, -1, -1}, {38013, -1, -1, -1}, {38014, -1, -1, -1}, {38012, -1, -1, -1}, {40055, -1, -1, -1}, {40056, -1, -1, -1}, {40695, -1, -1, -1}, {35924, -1, -1, -1}, {38015, -1, -1, -1}, {40474, -1, -1, -1}, {29224, -1, -1, -1}, {39530, -1, -1, -1}, {39729, -1, -1, -1}, {40475, -1, -1, -1}, {40478, -1, -1, -1}, {31858, -1, -1, -1}, {20034, -1, -1, -1}, {20060, -1, -1, -1}, {20981, -1, -1, -1}, {21274, -1, -1, -1}, {21378, -1, -1, -1}, {19975, -1, -1, -1}, {19980, -1, -1, -1}, {20039, -1, -1, -1}, {20109, -1, -1, -1}, {22231, -1, -1, -1}, {23662, -1, -1, -1}, {24435, -1, -1, -1}, {19983, -1, -1, -1}, {20871, -1, -1, -1}, {19982, -1, -1, -1}, {20014, -1, -1, -1}, {20115, -1, -1, -1}, {20162, -1, -1, -1}, {20169, -1, -1, -1}, {20168, -1, -1, -1}, {20888, -1, -1, -1}, {21244, -1, -1, -1}, {21356, -1, -1, -1}, {21433, -1, -1, -1}, {22304, -1, -1, -1}, {22787, -1, -1, -1}, {22828, -1, -1, -1}, {23568, -1, -1, -1}, {24063, -1, -1, -1}, {26081, -1, -1, -1}, {27571, -1, -1, -1}, {27596, -1, -1, -1}, {27668, -1, -1, -1}, {29247, -1, -1, -1}, {20017, -1, -1, -1}, {20028, -1, -1, -1}, {20200, -1, -1, -1}, {20188, -1, -1, -1}, {20201, -1, -1, -1}, {20193, -1, -1, -1}, {20189, -1, -1, -1}, {20186, -1, -1, -1}, {21004, -1, -1, -1}, {21001, -1, -1, -1}, {21276, -1, -1, -1}, {21324, -1, -1, -1}, {22306, -1, -1, -1}, {22307, -1, -1, -1}, {22807, -1, -1, -1}, {22831, -1, -1, -1}, {23425, -1, -1, -1}, {23428, -1, -1, -1}, {23570, -1, -1, -1}, {23611, -1, -1, -1}, {23668, -1, -1, -1}, {23667, -1, -1, -1}, {24068, -1, -1, -1}, {24192, -1, -1, -1}, {24194, -1, -1, -1}, {24521, -1, -1, -1}, {25097, -1, -1, -1}, {25168, -1, -1, -1}, {27669, -1, -1, -1}, {27702, -1, -1, -1}, {27715, -1, -1, -1}, {27711, -1, -1, -1}, {27707, -1, -1, -1}, {29358, -1, -1, -1}, {29360, -1, -1, -1}, {29578, -1, -1, -1}, {31160, -1, -1, -1}, {32906, -1, -1, -1}, {38430, -1, -1, -1}, {20238, -1, -1, -1}, {20248, -1, -1, -1}, {20268, -1, -1, -1}, {20213, -1, -1, -1}, {20244, -1, -1, -1}, {20209, -1, -1, -1}, {20224, -1, -1, -1}, {20215, -1, -1, -1}, {20232, -1, -1, -1}, {20253, -1, -1, -1}, {20226, -1, -1, -1}, {20229, -1, -1, -1}, {20258, -1, -1, -1}, {20243, -1, -1, -1}, {20228, -1, -1, -1}, {20212, -1, -1, -1}, {20242, -1, -1, -1}, {20913, -1, -1, -1}, {21011, -1, -1, -1}, {21008, -1, -1, -1}, {21158, -1, -1, -1}, {21282, -1, -1, -1}, {21279, -1, -1, -1}, {21325, -1, -1, -1}, {21386, -1, -1, -1}, {21511, -1, -1, -1}, {22241, -1, -1, -1}, {22239, -1, -1, -1}, {22318, -1, -1, -1}, {22314, -1, -1, -1}, {22324, -1, -1, -1}, {22844, -1, -1, -1}, {22912, -1, -1, -1}, {22908, -1, -1, -1}, {22917, -1, -1, -1}, {22907, -1, -1, -1}, {22910, -1, -1, -1}, {22903, -1, -1, -1}, {22911, -1, -1, -1}, {23382, -1, -1, -1}, {23573, -1, -1, -1}, {23589, -1, -1, -1}, {23676, -1, -1, -1}, {23674, -1, -1, -1}, {23675, -1, -1, -1}, {23678, -1, -1, -1}, {24031, -1, -1, -1}, {24181, -1, -1, -1}, {24196, -1, -1, -1}, {24322, -1, -1, -1}, {24346, -1, -1, -1}, {24436, -1, -1, -1}, {24533, -1, -1, -1}, {24532, -1, -1, -1}, {24527, -1, -1, -1}, {25180, -1, -1, -1}, {25182, -1, -1, -1}, {25188, -1, -1, -1}, {25185, -1, -1, -1}, {25190, -1, -1, -1}, {25186, -1, -1, -1}, {25177, -1, -1, -1}, {25184, -1, -1, -1}, {25178, -1, -1, -1}, {25189, -1, -1, -1}, {25911, -1, -1, -1}, {26095, -1, -1, -1}, {26094, -1, -1, -1}, {26430, -1, -1, -1}, {26425, -1, -1, -1}, {26424, -1, -1, -1}, {26427, -1, -1, -1}, {26426, -1, -1, -1}, {26431, -1, -1, -1}, {26428, -1, -1, -1} },
    {{26419, -1, -1, -1}, {27672, -1, -1, -1}, {27718, -1, -1, -1}, {27730, -1, -1, -1}, {27740, -1, -1, -1}, {27727, -1, -1, -1}, {27722, -1, -1, -1}, {27732, -1, -1, -1}, {27723, -1, -1, -1}, {27724, -1, -1, -1}, {28785, -1, -1, -1}, {29278, -1, -1, -1}, {29364, -1, -1, -1}, {29365, -1, -1, -1}, {29582, -1, -1, -1}, {29994, -1, -1, -1}, {30335, -1, -1, -1}, {31349, -1, -1, -1}, {32593, -1, -1, -1}, {33400, -1, -1, -1}, {33404, -1, -1, -1}, {33408, -1, -1, -1}, {33405, -1, -1, -1}, {33407, -1, -1, -1}, {34381, -1, -1, -1}, {35198, -1, -1, -1}, {37017, -1, -1, -1}, {37015, -1, -1, -1}, {37016, -1, -1, -1}, {37019, -1, -1, -1}, {37012, -1, -1, -1}, {38434, -1, -1, -1}, {38436, -1, -1, -1}, {38432, -1, -1, -1}, {38435, -1, -1, -1}, {20310, -1, -1, -1}, {20283, -1, -1, -1}, {20322, -1, -1, -1}, {20297, -1, -1, -1}, {20307, -1, -1, -1}, {20324, -1, -1, -1}, {20286, -1, -1, -1}, {20327, -1, -1, -1}, {20306, -1, -1, -1}, {20319, -1, -1, -1}, {20289, -1, -1, -1}, {20312, -1, -1, -1}, {20269, -1, -1, -1}, {20275, -1, -1, -1}, {20287, -1, -1, -1}, {20321, -1, -1, -1}, {20879, -1, -1, -1}, {20921, -1, -1, -1}, {21020, -1, -1, -1}, {21022, -1, -1, -1}, {21025, -1, -1, -1}, {21165, -1, -1, -1}, {21166, -1, -1, -1}, {21257, -1, -1, -1}, {21347, -1, -1, -1}, {21362, -1, -1, -1}, {21390, -1, -1, -1}, {21391, -1, -1, -1}, {21552, -1, -1, -1}, {21559, -1, -1, -1}, {21546, -1, -1, -1}, {21588, -1, -1, -1}, {21573, -1, -1, -1}, {21529, -1, -1, -1}, {21532, -1, -1, -1}, {21541, -1, -1, -1}, {21528, -1, -1, -1}, {21565, -1, -1, -1}, {21583, -1, -1, -1}, {21569, -1, -1, -1}, {21544, -1, -1, -1}, {21540, -1, -1, -1}, {21575, -1, -1, -1}, {22254, -1, -1, -1}, {22247, -1, -1, -1}, {22245, -1, -1, -1}, {22337, -1, -1, -1}, {22341, -1, -1, -1}, {22348, -1, -1, -1}, {22345, -1, -1, -1}, {22347, -1, -1, -1}, {22354, -1, -1, -1}, {22790, -1, -1, -1}, {22848, -1, -1, -1}, {22950, -1, -1, -1}, {22936, -1, -1, -1}, {22944, -1, -1, -1}, {22935, -1, -1, -1}, {22926, -1, -1, -1}, {22946, -1, -1, -1}, {22928, -1, -1, -1}, {22927, -1, -1, -1}, {22951, -1, -1, -1}, {22945, -1, -1, -1}, {23438, -1, -1, -1}, {23442, -1, -1, -1}, {23592, -1, -1, -1}, {23594, -1, -1, -1}, {23693, -1, -1, -1}, {23695, -1, -1, -1}, {23688, -1, -1, -1}, {23691, -1, -1, -1}, {23689, -1, -1, -1}, {23698, -1, -1, -1}, {23690, -1, -1, -1}, {23686, -1, -1, -1}, {23699, -1, -1, -1}, {23701, -1, -1, -1}, {24032, -1, -1, -1}, {24074, -1, -1, -1}, {24078, -1, -1, -1}, {24203, -1, -1, -1}, {24201, -1, -1, -1}, {24204, -1, -1, -1}, {24200, -1, -1, -1}, {24205, -1, -1, -1}, {24325, -1, -1, -1}, {24349, -1, -1, -1}, {24440, -1, -1, -1}, {24438, -1, -1, -1}, {24530, -1, -1, -1}, {24529, -1, -1, -1}, {24528, -1, -1, -1}, {24557, -1, -1, -1}, {24552, -1, -1, -1}, {24558, -1, -1, -1}, {24563, -1, -1, -1}, {24545, -1, -1, -1}, {24548, -1, -1, -1}, {24547, -1, -1, -1}, {24570, -1, -1, -1}, {24559, -1, -1, -1}, {24567, -1, -1, -1}, {24571, -1, -1, -1}, {24576, -1, -1, -1}, {24564, -1, -1, -1}, {25146, -1, -1, -1}, {25219, -1, -1, -1}, {25228, -1, -1, -1}, {25230, -1, -1, -1}, {25231, -1, -1, -1}, {25236, -1, -1, -1}, {25223, -1, -1, -1}, {25201, -1, -1, -1}, {25211, -1, -1, -1}, {25210, -1, -1, -1}, {25200, -1, -1, -1}, {25217, -1, -1, -1}, {25224, -1, -1, -1}, {25207, -1, -1, -1}, {25213, -1, -1, -1}, {25202, -1, -1, -1}, {25204, -1, -1, -1}, {26096, -1, -1, -1}, {26100, -1, -1, -1}, {26099, -1, -1, -1}, {26098, -1, -1, -1}, {26101, -1, -1, -1}, {26437, -1, -1, -1}, {26439, -1, -1, -1}, {26457, -1, -1, -1}, {26453, -1, -1, -1}, {26444, -1, -1, -1}, {26440, -1, -1, -1}, {26461, -1, -1, -1}, {26445, -1, -1, -1}, {26458, -1, -1, -1}, {26443, -1, -1, -1}, {27600, -1, -1, -1}, {27673, -1, -1, -1}, {27674, -1, -1, -1}, {27768, -1, -1, -1}, {27751, -1, -1, -1}, {27755, -1, -1, -1}, {27780, -1, -1, -1}, {27787, -1, -1, -1}, {27791, -1, -1, -1}, {27761, -1, -1, -1}, {27759, -1, -1, -1}, {27753, -1, -1, -1}, {27802, -1, -1, -1}, {27757, -1, -1, -1}, {27783, -1, -1, -1}, {27797, -1, -1, -1}, {27804, -1, -1, -1}, {27750, -1, -1, -1}, {27763, -1, -1, -1}, {27749, -1, -1, -1}, {27771, -1, -1, -1}, {27790, -1, -1, -1}, {28788, -1, -1, -1}, {28794, -1, -1, -1}, {29283, -1, -1, -1}, {29375, -1, -1, -1}, {29373, -1, -1, -1}, {29379, -1, -1, -1}, {29382, -1, -1, -1}, {29377, -1, -1, -1}, {29370, -1, -1, -1}, {29381, -1, -1, -1}, {29589, -1, -1, -1}, {29591, -1, -1, -1}, {29587, -1, -1, -1}, {29588, -1, -1, -1}, {29586, -1, -1, -1}, {30010, -1, -1, -1}, {30009, -1, -1, -1}, {30100, -1, -1, -1}, {30101, -1, -1, -1}, {30337, -1, -1, -1}, {31037, -1, -1, -1}, {32820, -1, -1, -1}, {32917, -1, -1, -1}, {32921, -1, -1, -1}, {32912, -1, -1, -1}, {32914, -1, -1, -1}, {32924, -1, -1, -1}, {33424, -1, -1, -1}, {33423, -1, -1, -1}, {33413, -1, -1, -1}, {33422, -1, -1, -1}, {33425, -1, -1, -1}, {33427, -1, -1, -1}, {33418, -1, -1, -1}, {33411, -1, -1, -1}, {33412, -1, -1, -1}, {35960, -1, -1, -1}, {36809, -1, -1, -1}, {36799, -1, -1, -1}, {37023, -1, -1, -1}, {37025, -1, -1, -1}, {37029, -1, -1, -1}, {37022, -1, -1, -1}, {37031, -1, -1, -1}, {37024, -1, -1, -1}, {38448, -1, -1, -1}, {38440, -1, -1, -1}, {38447, -1, -1, -1}, {38445, -1, -1, -1}, {20019, -1, -1, -1}, {20376, -1, -1, -1}, {20348, -1, -1, -1}, {20357, -1, -1, -1}, {20349, -1, -1, -1}, {20352, -1, -1, -1}, {20359, -1, -1, -1}, {20342, -1, -1, -1}, {20340, -1, -1, -1}, {20361, -1, -1, -1}, {20356, -1, -1, -1}, {20343, -1, -1, -1} },
    {{20300, -1, -1, -1}, {20375, -1, -1, -1}, {20330, -1, -1, -1}, {20378, -1, -1, -1}, {20345, -1, -1, -1}, {20353, -1, -1, -1}, {20344, -1, -1, -1}, {20368, -1, -1, -1}, {20380, -1, -1, -1}, {20372, -1, -1, -1}, {20382, -1, -1, -1}, {20370, -1, -1, -1}, {20354, -1, -1, -1}, {20373, -1, -1, -1}, {20331, -1, -1, -1}, {20334, -1, -1, -1}, {20894, -1, -1, -1}, {20924, -1, -1, -1}, {20926, -1, -1, -1}, {21045, -1, -1, -1}, {21042, -1, -1, -1}, {21043, -1, -1, -1}, {21062, -1, -1, -1}, {21041, -1, -1, -1}, {21180, -1, -1, -1}, {21258, -1, -1, -1}, {21259, -1, -1, -1}, {21308, -1, -1, -1}, {21394, -1, -1, -1}, {21396, -1, -1, -1}, {21639, -1, -1, -1}, {21631, -1, -1, -1}, {21633, -1, -1, -1}, {21649, -1, -1, -1}, {21634, -1, -1, -1}, {21640, -1, -1, -1}, {21611, -1, -1, -1}, {21626, -1, -1, -1}, {21630, -1, -1, -1}, {21605, -1, -1, -1}, {21612, -1, -1, -1}, {21620, -1, -1, -1}, {21606, -1, -1, -1}, {21645, -1, -1, -1}, {21615, -1, -1, -1}, {21601, -1, -1, -1}, {21600, -1, -1, -1}, {21656, -1, -1, -1}, {21603, -1, -1, -1}, {21607, -1, -1, -1}, {21604, -1, -1, -1}, {22263, -1, -1, -1}, {22265, -1, -1, -1}, {22383, -1, -1, -1}, {22386, -1, -1, -1}, {22381, -1, -1, -1}, {22379, -1, -1, -1}, {22385, -1, -1, -1}, {22384, -1, -1, -1}, {22390, -1, -1, -1}, {22400, -1, -1, -1}, {22389, -1, -1, -1}, {22395, -1, -1, -1}, {22387, -1, -1, -1}, {22388, -1, -1, -1}, {22370, -1, -1, -1}, {22376, -1, -1, -1}, {22397, -1, -1, -1}, {22796, -1, -1, -1}, {22853, -1, -1, -1}, {22965, -1, -1, -1}, {22970, -1, -1, -1}, {22991, -1, -1, -1}, {22990, -1, -1, -1}, {22962, -1, -1, -1}, {22988, -1, -1, -1}, {22977, -1, -1, -1}, {22966, -1, -1, -1}, {22972, -1, -1, -1}, {22979, -1, -1, -1}, {22998, -1, -1, -1}, {22961, -1, -1, -1}, {22973, -1, -1, -1}, {22976, -1, -1, -1}, {22984, -1, -1, -1}, {22964, -1, -1, -1}, {22983, -1, -1, -1}, {23394, -1, -1, -1}, {23397, -1, -1, -1}, {23443, -1, -1, -1}, {23445, -1, -1, -1}, {23620, -1, -1, -1}, {23623, -1, -1, -1}, {23726, -1, -1, -1}, {23716, -1, -1, -1}, {23712, -1, -1, -1}, {23733, -1, -1, -1}, {23727, -1, -1, -1}, {23720, -1, -1, -1}, {23724, -1, -1, -1}, {23711, -1, -1, -1}, {23715, -1, -1, -1}, {23725, -1, -1, -1}, {23714, -1, -1, -1}, {23722, -1, -1, -1}, {23719, -1, -1, -1}, {23709, -1, -1, -1}, {23717, -1, -1, -1}, {23734, -1, -1, -1}, {23728, -1, -1, -1}, {23718, -1, -1, -1}, {24087, -1, -1, -1}, {24084, -1, -1, -1}, {24089, -1, -1, -1}, {24360, -1, -1, -1}, {24354, -1, -1, -1}, {24355, -1, -1, -1}, {24356, -1, -1, -1}, {24404, -1, -1, -1}, {24450, -1, -1, -1}, {24446, -1, -1, -1}, {24445, -1, -1, -1}, {24542, -1, -1, -1}, {24549, -1, -1, -1}, {24621, -1, -1, -1}, {24614, -1, -1, -1}, {24601, -1, -1, -1}, {24626, -1, -1, -1}, {24587, -1, -1, -1}, {24628, -1, -1, -1}, {24586, -1, -1, -1}, {24599, -1, -1, -1}, {24627, -1, -1, -1}, {24602, -1, -1, -1}, {24606, -1, -1, -1}, {24620, -1, -1, -1}, {24610, -1, -1, -1}, {24589, -1, -1, -1}, {24592, -1, -1, -1}, {24622, -1, -1, -1}, {24595, -1, -1, -1}, {24593, -1, -1, -1}, {24588, -1, -1, -1}, {24585, -1, -1, -1}, {24604, -1, -1, -1}, {25108, -1, -1, -1}, {25149, -1, -1, -1}, {25261, -1, -1, -1}, {25268, -1, -1, -1}, {25297, -1, -1, -1}, {25278, -1, -1, -1}, {25258, -1, -1, -1}, {25270, -1, -1, -1}, {25290, -1, -1, -1}, {25262, -1, -1, -1}, {25267, -1, -1, -1}, {25263, -1, -1, -1}, {25275, -1, -1, -1}, {25257, -1, -1, -1}, {25264, -1, -1, -1}, {25272, -1, -1, -1}, {25917, -1, -1, -1}, {26024, -1, -1, -1}, {26043, -1, -1, -1}, {26121, -1, -1, -1}, {26108, -1, -1, -1}, {26116, -1, -1, -1}, {26130, -1, -1, -1}, {26120, -1, -1, -1}, {26107, -1, -1, -1}, {26115, -1, -1, -1}, {26123, -1, -1, -1}, {26125, -1, -1, -1}, {26117, -1, -1, -1}, {26109, -1, -1, -1}, {26129, -1, -1, -1}, {26128, -1, -1, -1}, {26358, -1, -1, -1}, {26378, -1, -1, -1}, {26501, -1, -1, -1}, {26476, -1, -1, -1}, {26510, -1, -1, -1}, {26514, -1, -1, -1}, {26486, -1, -1, -1}, {26491, -1, -1, -1}, {26520, -1, -1, -1}, {26502, -1, -1, -1}, {26500, -1, -1, -1}, {26484, -1, -1, -1}, {26509, -1, -1, -1}, {26508, -1, -1, -1}, {26490, -1, -1, -1}, {26527, -1, -1, -1}, {26513, -1, -1, -1}, {26521, -1, -1, -1}, {26499, -1, -1, -1}, {26493, -1, -1, -1}, {26497, -1, -1, -1}, {26488, -1, -1, -1}, {26489, -1, -1, -1}, {26516, -1, -1, -1}, {27429, -1, -1, -1}, {27520, -1, -1, -1}, {27518, -1, -1, -1}, {27614, -1, -1, -1}, {27677, -1, -1, -1}, {27795, -1, -1, -1}, {27884, -1, -1, -1}, {27883, -1, -1, -1}, {27886, -1, -1, -1}, {27865, -1, -1, -1}, {27830, -1, -1, -1}, {27860, -1, -1, -1}, {27821, -1, -1, -1}, {27879, -1, -1, -1}, {27831, -1, -1, -1}, {27856, -1, -1, -1}, {27842, -1, -1, -1}, {27834, -1, -1, -1}, {27843, -1, -1, -1}, {27846, -1, -1, -1}, {27885, -1, -1, -1}, {27890, -1, -1, -1}, {27858, -1, -1, -1}, {27869, -1, -1, -1}, {27828, -1, -1, -1}, {27786, -1, -1, -1}, {27805, -1, -1, -1}, {27776, -1, -1, -1}, {27870, -1, -1, -1}, {27840, -1, -1, -1}, {27952, -1, -1, -1}, {27853, -1, -1, -1}, {27847, -1, -1, -1}, {27824, -1, -1, -1}, {27897, -1, -1, -1}, {27855, -1, -1, -1}, {27881, -1, -1, -1}, {27857, -1, -1, -1}, {28820, -1, -1, -1}, {28824, -1, -1, -1}, {28805, -1, -1, -1}, {28819, -1, -1, -1}, {28806, -1, -1, -1}, {28804, -1, -1, -1}, {28817, -1, -1, -1}, {28822, -1, -1, -1}, {28802, -1, -1, -1}, {28826, -1, -1, -1}, {28803, -1, -1, -1}, {29290, -1, -1, -1}, {29398, -1, -1, -1}, {29387, -1, -1, -1}, {29400, -1, -1, -1}, {29385, -1, -1, -1}, {29404, -1, -1, -1} },
    {{29394, -1, -1, -1}, {29396, -1, -1, -1}, {29402, -1, -1, -1}, {29388, -1, -1, -1}, {29393, -1, -1, -1}, {29604, -1, -1, -1}, {29601, -1, -1, -1}, {29613, -1, -1, -1}, {29606, -1, -1, -1}, {29602, -1, -1, -1}, {29600, -1, -1, -1}, {29612, -1, -1, -1}, {29597, -1, -1, -1}, {29917, -1, -1, -1}, {29928, -1, -1, -1}, {30015, -1, -1, -1}, {30016, -1, -1, -1}, {30014, -1, -1, -1}, {30092, -1, -1, -1}, {30104, -1, -1, -1}, {30383, -1, -1, -1}, {30451, -1, -1, -1}, {30449, -1, -1, -1}, {30448, -1, -1, -1}, {30453, -1, -1, -1}, {30712, -1, -1, -1}, {30716, -1, -1, -1}, {30713, -1, -1, -1}, {30715, -1, -1, -1}, {30714, -1, -1, -1}, {30711, -1, -1, -1}, {31042, -1, -1, -1}, {31039, -1, -1, -1}, {31173, -1, -1, -1}, {31352, -1, -1, -1}, {31355, -1, -1, -1}, {31483, -1, -1, -1}, {31861, -1, -1, -1}, {31997, -1, -1, -1}, {32821, -1, -1, -1}, {32911, -1, -1, -1}, {32942, -1, -1, -1}, {32931, -1, -1, -1}, {32952, -1, -1, -1}, {32949, -1, -1, -1}, {32941, -1, -1, -1}, {33312, -1, -1, -1}, {33440, -1, -1, -1}, {33472, -1, -1, -1}, {33451, -1, -1, -1}, {33434, -1, -1, -1}, {33432, -1, -1, -1}, {33435, -1, -1, -1}, {33461, -1, -1, -1}, {33447, -1, -1, -1}, {33454, -1, -1, -1}, {33468, -1, -1, -1}, {33438, -1, -1, -1}, {33466, -1, -1, -1}, {33460, -1, -1, -1}, {33448, -1, -1, -1}, {33441, -1, -1, -1}, {33449, -1, -1, -1}, {33474, -1, -1, -1}, {33444, -1, -1, -1}, {33475, -1, -1, -1}, {33462, -1, -1, -1}, {33442, -1, -1, -1}, {34416, -1, -1, -1}, {34415, -1, -1, -1}, {34413, -1, -1, -1}, {34414, -1, -1, -1}, {35926, -1, -1, -1}, {36818, -1, -1, -1}, {36811, -1, -1, -1}, {36819, -1, -1, -1}, {36813, -1, -1, -1}, {36822, -1, -1, -1}, {36821, -1, -1, -1}, {36823, -1, -1, -1}, {37042, -1, -1, -1}, {37044, -1, -1, -1}, {37039, -1, -1, -1}, {37043, -1, -1, -1}, {37040, -1, -1, -1}, {38457, -1, -1, -1}, {38461, -1, -1, -1}, {38460, -1, -1, -1}, {38458, -1, -1, -1}, {38467, -1, -1, -1}, {20429, -1, -1, -1}, {20421, -1, -1, -1}, {20435, -1, -1, -1}, {20402, -1, -1, -1}, {20425, -1, -1, -1}, {20427, -1, -1, -1}, {20417, -1, -1, -1}, {20436, -1, -1, -1}, {20444, -1, -1, -1}, {20441, -1, -1, -1}, {20411, -1, -1, -1}, {20403, -1, -1, -1}, {20443, -1, -1, -1}, {20423, -1, -1, -1}, {20438, -1, -1, -1}, {20410, -1, -1, -1}, {20416, -1, -1, -1}, {20409, -1, -1, -1}, {20460, -1, -1, -1}, {21060, -1, -1, -1}, {21065, -1, -1, -1}, {21184, -1, -1, -1}, {21186, -1, -1, -1}, {21309, -1, -1, -1}, {21372, -1, -1, -1}, {21399, -1, -1, -1}, {21398, -1, -1, -1}, {21401, -1, -1, -1}, {21400, -1, -1, -1}, {21690, -1, -1, -1}, {21665, -1, -1, -1}, {21677, -1, -1, -1}, {21669, -1, -1, -1}, {21711, -1, -1, -1}, {21699, -1, -1, -1}, {33549, -1, -1, -1}, {21687, -1, -1, -1}, {21678, -1, -1, -1}, {21718, -1, -1, -1}, {21686, -1, -1, -1}, {21701, -1, -1, -1}, {21702, -1, -1, -1}, {21664, -1, -1, -1}, {21616, -1, -1, -1}, {21692, -1, -1, -1}, {21666, -1, -1, -1}, {21694, -1, -1, -1}, {21618, -1, -1, -1}, {21726, -1, -1, -1}, {21680, -1, -1, -1}, {22453, -1, -1, -1}, {22430, -1, -1, -1}, {22431, -1, -1, -1}, {22436, -1, -1, -1}, {22412, -1, -1, -1}, {22423, -1, -1, -1}, {22429, -1, -1, -1}, {22427, -1, -1, -1}, {22420, -1, -1, -1}, {22424, -1, -1, -1}, {22415, -1, -1, -1}, {22425, -1, -1, -1}, {22437, -1, -1, -1}, {22426, -1, -1, -1}, {22421, -1, -1, -1}, {22772, -1, -1, -1}, {22797, -1, -1, -1}, {22867, -1, -1, -1}, {23009, -1, -1, -1}, {23006, -1, -1, -1}, {23022, -1, -1, -1}, {23040, -1, -1, -1}, {23025, -1, -1, -1}, {23005, -1, -1, -1}, {23034, -1, -1, -1}, {23037, -1, -1, -1}, {23036, -1, -1, -1}, {23030, -1, -1, -1}, {23012, -1, -1, -1}, {23026, -1, -1, -1}, {23031, -1, -1, -1}, {23003, -1, -1, -1}, {23017, -1, -1, -1}, {23027, -1, -1, -1}, {23029, -1, -1, -1}, {23008, -1, -1, -1}, {23038, -1, -1, -1}, {23028, -1, -1, -1}, {23021, -1, -1, -1}, {23464, -1, -1, -1}, {23628, -1, -1, -1}, {23760, -1, -1, -1}, {23768, -1, -1, -1}, {23756, -1, -1, -1}, {23767, -1, -1, -1}, {23755, -1, -1, -1}, {23771, -1, -1, -1}, {23774, -1, -1, -1}, {23770, -1, -1, -1}, {23753, -1, -1, -1}, {23751, -1, -1, -1}, {23754, -1, -1, -1}, {23766, -1, -1, -1}, {23763, -1, -1, -1}, {23764, -1, -1, -1}, {23759, -1, -1, -1}, {23752, -1, -1, -1}, {23750, -1, -1, -1}, {23758, -1, -1, -1}, {23775, -1, -1, -1}, {23800, -1, -1, -1}, {24057, -1, -1, -1}, {24097, -1, -1, -1}, {24098, -1, -1, -1}, {24099, -1, -1, -1}, {24096, -1, -1, -1}, {24100, -1, -1, -1}, {24240, -1, -1, -1}, {24228, -1, -1, -1}, {24226, -1, -1, -1}, {24219, -1, -1, -1}, {24227, -1, -1, -1}, {24229, -1, -1, -1}, {24327, -1, -1, -1}, {24366, -1, -1, -1}, {24406, -1, -1, -1}, {24454, -1, -1, -1}, {24631, -1, -1, -1}, {24633, -1, -1, -1}, {24660, -1, -1, -1}, {24690, -1, -1, -1}, {24670, -1, -1, -1}, {24645, -1, -1, -1}, {24659, -1, -1, -1}, {24647, -1, -1, -1}, {24649, -1, -1, -1}, {24667, -1, -1, -1}, {24652, -1, -1, -1}, {24640, -1, -1, -1}, {24642, -1, -1, -1}, {24671, -1, -1, -1}, {24612, -1, -1, -1}, {24644, -1, -1, -1}, {24664, -1, -1, -1}, {24678, -1, -1, -1}, {24686, -1, -1, -1}, {25154, -1, -1, -1}, {25155, -1, -1, -1}, {25295, -1, -1, -1}, {25357, -1, -1, -1}, {25355, -1, -1, -1}, {25333, -1, -1, -1}, {25358, -1, -1, -1}, {25347, -1, -1, -1}, {25323, -1, -1, -1}, {25337, -1, -1, -1}, {25359, -1, -1, -1}, {25356, -1, -1, -1}, {25336, -1, -1, -1}, {25334, -1, -1, -1}, {25344, -1, -1, -1}, {25363, -1, -1, -1}, {25364, -1, -1, -1}, {25338, -1, -1, -1}, {25365, -1, -1, -1}, {25339, -1, -1, -1} },
    {{25328, -1, -1, -1}, {25921, -1, -1, -1}, {25923, -1, -1, -1}, {26026, -1, -1, -1}, {26047, -1, -1, -1}, {26166, -1, -1, -1}, {26145, -1, -1, -1}, {26162, -1, -1, -1}, {26165, -1, -1, -1}, {26140, -1, -1, -1}, {26150, -1, -1, -1}, {26146, -1, -1, -1}, {26163, -1, -1, -1}, {26155, -1, -1, -1}, {26170, -1, -1, -1}, {26141, -1, -1, -1}, {26164, -1, -1, -1}, {26169, -1, -1, -1}, {26158, -1, -1, -1}, {26383, -1, -1, -1}, {26384, -1, -1, -1}, {26561, -1, -1, -1}, {26610, -1, -1, -1}, {26568, -1, -1, -1}, {26554, -1, -1, -1}, {26588, -1, -1, -1}, {26555, -1, -1, -1}, {26616, -1, -1, -1}, {26584, -1, -1, -1}, {26560, -1, -1, -1}, {26551, -1, -1, -1}, {26565, -1, -1, -1}, {26603, -1, -1, -1}, {26596, -1, -1, -1}, {26591, -1, -1, -1}, {26549, -1, -1, -1}, {26573, -1, -1, -1}, {26547, -1, -1, -1}, {26615, -1, -1, -1}, {26614, -1, -1, -1}, {26606, -1, -1, -1}, {26595, -1, -1, -1}, {26562, -1, -1, -1}, {26553, -1, -1, -1}, {26574, -1, -1, -1}, {26599, -1, -1, -1}, {26608, -1, -1, -1}, {26546, -1, -1, -1}, {26620, -1, -1, -1}, {26566, -1, -1, -1}, {26605, -1, -1, -1}, {26572, -1, -1, -1}, {26542, -1, -1, -1}, {26598, -1, -1, -1}, {26587, -1, -1, -1}, {26618, -1, -1, -1}, {26569, -1, -1, -1}, {26570, -1, -1, -1}, {26563, -1, -1, -1}, {26602, -1, -1, -1}, {26571, -1, -1, -1}, {27432, -1, -1, -1}, {27522, -1, -1, -1}, {27524, -1, -1, -1}, {27574, -1, -1, -1}, {27606, -1, -1, -1}, {27608, -1, -1, -1}, {27616, -1, -1, -1}, {27680, -1, -1, -1}, {27681, -1, -1, -1}, {27944, -1, -1, -1}, {27956, -1, -1, -1}, {27949, -1, -1, -1}, {27935, -1, -1, -1}, {27964, -1, -1, -1}, {27967, -1, -1, -1}, {27922, -1, -1, -1}, {27914, -1, -1, -1}, {27866, -1, -1, -1}, {27955, -1, -1, -1}, {27908, -1, -1, -1}, {27929, -1, -1, -1}, {27962, -1, -1, -1}, {27930, -1, -1, -1}, {27921, -1, -1, -1}, {27904, -1, -1, -1}, {27933, -1, -1, -1}, {27970, -1, -1, -1}, {27905, -1, -1, -1}, {27928, -1, -1, -1}, {27959, -1, -1, -1}, {27907, -1, -1, -1}, {27919, -1, -1, -1}, {27968, -1, -1, -1}, {27911, -1, -1, -1}, {27936, -1, -1, -1}, {27948, -1, -1, -1}, {27912, -1, -1, -1}, {27938, -1, -1, -1}, {27913, -1, -1, -1}, {27920, -1, -1, -1}, {28855, -1, -1, -1}, {28831, -1, -1, -1}, {28862, -1, -1, -1}, {28849, -1, -1, -1}, {28848, -1, -1, -1}, {28833, -1, -1, -1}, {28852, -1, -1, -1}, {28853, -1, -1, -1}, {28841, -1, -1, -1}, {29249, -1, -1, -1}, {29257, -1, -1, -1}, {29258, -1, -1, -1}, {29292, -1, -1, -1}, {29296, -1, -1, -1}, {29299, -1, -1, -1}, {29294, -1, -1, -1}, {29386, -1, -1, -1}, {29412, -1, -1, -1}, {29416, -1, -1, -1}, {29419, -1, -1, -1}, {29407, -1, -1, -1}, {29418, -1, -1, -1}, {29414, -1, -1, -1}, {29411, -1, -1, -1}, {29573, -1, -1, -1}, {29644, -1, -1, -1}, {29634, -1, -1, -1}, {29640, -1, -1, -1}, {29637, -1, -1, -1}, {29625, -1, -1, -1}, {29622, -1, -1, -1}, {29621, -1, -1, -1}, {29620, -1, -1, -1}, {29675, -1, -1, -1}, {29631, -1, -1, -1}, {29639, -1, -1, -1}, {29630, -1, -1, -1}, {29635, -1, -1, -1}, {29638, -1, -1, -1}, {29624, -1, -1, -1}, {29643, -1, -1, -1}, {29932, -1, -1, -1}, {29934, -1, -1, -1}, {29998, -1, -1, -1}, {30023, -1, -1, -1}, {30024, -1, -1, -1}, {30119, -1, -1, -1}, {30122, -1, -1, -1}, {30329, -1, -1, -1}, {30404, -1, -1, -1}, {30472, -1, -1, -1}, {30467, -1, -1, -1}, {30468, -1, -1, -1}, {30469, -1, -1, -1}, {30474, -1, -1, -1}, {30455, -1, -1, -1}, {30459, -1, -1, -1}, {30458, -1, -1, -1}, {30695, -1, -1, -1}, {30696, -1, -1, -1}, {30726, -1, -1, -1}, {30737, -1, -1, -1}, {30738, -1, -1, -1}, {30725, -1, -1, -1}, {30736, -1, -1, -1}, {30735, -1, -1, -1}, {30734, -1, -1, -1}, {30729, -1, -1, -1}, {30723, -1, -1, -1}, {30739, -1, -1, -1}, {31050, -1, -1, -1}, {31052, -1, -1, -1}, {31051, -1, -1, -1}, {31045, -1, -1, -1}, {31044, -1, -1, -1}, {31189, -1, -1, -1}, {31181, -1, -1, -1}, {31183, -1, -1, -1}, {31190, -1, -1, -1}, {31182, -1, -1, -1}, {31360, -1, -1, -1}, {31358, -1, -1, -1}, {31441, -1, -1, -1}, {31488, -1, -1, -1}, {31489, -1, -1, -1}, {31866, -1, -1, -1}, {31864, -1, -1, -1}, {31865, -1, -1, -1}, {31871, -1, -1, -1}, {31872, -1, -1, -1}, {31873, -1, -1, -1}, {32003, -1, -1, -1}, {32008, -1, -1, -1}, {32001, -1, -1, -1}, {32600, -1, -1, -1}, {32657, -1, -1, -1}, {32653, -1, -1, -1}, {32702, -1, -1, -1}, {32775, -1, -1, -1}, {32782, -1, -1, -1}, {32783, -1, -1, -1}, {32788, -1, -1, -1}, {32823, -1, -1, -1}, {32984, -1, -1, -1}, {32967, -1, -1, -1}, {32992, -1, -1, -1}, {32977, -1, -1, -1}, {32968, -1, -1, -1}, {32962, -1, -1, -1}, {32976, -1, -1, -1}, {32965, -1, -1, -1}, {32995, -1, -1, -1}, {32985, -1, -1, -1}, {32988, -1, -1, -1}, {32970, -1, -1, -1}, {32981, -1, -1, -1}, {32969, -1, -1, -1}, {32975, -1, -1, -1}, {32983, -1, -1, -1}, {32998, -1, -1, -1}, {32973, -1, -1, -1}, {33279, -1, -1, -1}, {33313, -1, -1, -1}, {33428, -1, -1, -1}, {33497, -1, -1, -1}, {33534, -1, -1, -1}, {33529, -1, -1, -1}, {33543, -1, -1, -1}, {33512, -1, -1, -1}, {33536, -1, -1, -1}, {33493, -1, -1, -1}, {33594, -1, -1, -1}, {33515, -1, -1, -1}, {33494, -1, -1, -1}, {33524, -1, -1, -1}, {33516, -1, -1, -1}, {33505, -1, -1, -1}, {33522, -1, -1, -1}, {33525, -1, -1, -1}, {33548, -1, -1, -1}, {33531, -1, -1, -1}, {33526, -1, -1, -1}, {33520, -1, -1, -1}, {33514, -1, -1, -1}, {33508, -1, -1, -1}, {33504, -1, -1, -1}, {33530, -1, -1, -1}, {33523, -1, -1, -1}, {33517, -1, -1, -1}, {34423, -1, -1, -1}, {34420, -1, -1, -1}, {34428, -1, -1, -1}, {34419, -1, -1, -1}, {34881, -1, -1, -1}, {34894, -1, -1, -1} },
    {{34919, -1, -1, -1}, {34922, -1, -1, -1}, {34921, -1, -1, -1}, {35283, -1, -1, -1}, {35332, -1, -1, -1}, {35335, -1, -1, -1}, {36210, -1, -1, -1}, {36835, -1, -1, -1}, {36833, -1, -1, -1}, {36846, -1, -1, -1}, {36832, -1, -1, -1}, {37105, -1, -1, -1}, {37053, -1, -1, -1}, {37055, -1, -1, -1}, {37077, -1, -1, -1}, {37061, -1, -1, -1}, {37054, -1, -1, -1}, {37063, -1, -1, -1}, {37067, -1, -1, -1}, {37064, -1, -1, -1}, {37332, -1, -1, -1}, {37331, -1, -1, -1}, {38484, -1, -1, -1}, {38479, -1, -1, -1}, {38481, -1, -1, -1}, {38483, -1, -1, -1}, {38474, -1, -1, -1}, {38478, -1, -1, -1}, {20510, -1, -1, -1}, {20485, -1, -1, -1}, {20487, -1, -1, -1}, {20499, -1, -1, -1}, {20514, -1, -1, -1}, {20528, -1, -1, -1}, {20507, -1, -1, -1}, {20469, -1, -1, -1}, {20468, -1, -1, -1}, {20531, -1, -1, -1}, {20535, -1, -1, -1}, {20524, -1, -1, -1}, {20470, -1, -1, -1}, {20471, -1, -1, -1}, {20503, -1, -1, -1}, {20508, -1, -1, -1}, {20512, -1, -1, -1}, {20519, -1, -1, -1}, {20533, -1, -1, -1}, {20527, -1, -1, -1}, {20529, -1, -1, -1}, {20494, -1, -1, -1}, {20826, -1, -1, -1}, {20884, -1, -1, -1}, {20883, -1, -1, -1}, {20938, -1, -1, -1}, {20932, -1, -1, -1}, {20933, -1, -1, -1}, {20936, -1, -1, -1}, {20942, -1, -1, -1}, {21089, -1, -1, -1}, {21082, -1, -1, -1}, {21074, -1, -1, -1}, {21086, -1, -1, -1}, {21087, -1, -1, -1}, {21077, -1, -1, -1}, {21090, -1, -1, -1}, {21197, -1, -1, -1}, {21262, -1, -1, -1}, {21406, -1, -1, -1}, {21798, -1, -1, -1}, {21730, -1, -1, -1}, {21783, -1, -1, -1}, {21778, -1, -1, -1}, {21735, -1, -1, -1}, {21747, -1, -1, -1}, {21732, -1, -1, -1}, {21786, -1, -1, -1}, {21759, -1, -1, -1}, {21764, -1, -1, -1}, {21768, -1, -1, -1}, {21739, -1, -1, -1}, {21777, -1, -1, -1}, {21765, -1, -1, -1}, {21745, -1, -1, -1}, {21770, -1, -1, -1}, {21755, -1, -1, -1}, {21751, -1, -1, -1}, {21752, -1, -1, -1}, {21728, -1, -1, -1}, {21774, -1, -1, -1}, {21763, -1, -1, -1}, {21771, -1, -1, -1}, {22273, -1, -1, -1}, {22274, -1, -1, -1}, {22476, -1, -1, -1}, {22578, -1, -1, -1}, {22485, -1, -1, -1}, {22482, -1, -1, -1}, {22458, -1, -1, -1}, {22470, -1, -1, -1}, {22461, -1, -1, -1}, {22460, -1, -1, -1}, {22456, -1, -1, -1}, {22454, -1, -1, -1}, {22463, -1, -1, -1}, {22471, -1, -1, -1}, {22480, -1, -1, -1}, {22457, -1, -1, -1}, {22465, -1, -1, -1}, {22798, -1, -1, -1}, {22858, -1, -1, -1}, {23065, -1, -1, -1}, {23062, -1, -1, -1}, {23085, -1, -1, -1}, {23086, -1, -1, -1}, {23061, -1, -1, -1}, {23055, -1, -1, -1}, {23063, -1, -1, -1}, {23050, -1, -1, -1}, {23070, -1, -1, -1}, {23091, -1, -1, -1}, {23404, -1, -1, -1}, {23463, -1, -1, -1}, {23469, -1, -1, -1}, {23468, -1, -1, -1}, {23555, -1, -1, -1}, {23638, -1, -1, -1}, {23636, -1, -1, -1}, {23788, -1, -1, -1}, {23807, -1, -1, -1}, {23790, -1, -1, -1}, {23793, -1, -1, -1}, {23799, -1, -1, -1}, {23808, -1, -1, -1}, {23801, -1, -1, -1}, {24105, -1, -1, -1}, {24104, -1, -1, -1}, {24232, -1, -1, -1}, {24238, -1, -1, -1}, {24234, -1, -1, -1}, {24236, -1, -1, -1}, {24371, -1, -1, -1}, {24368, -1, -1, -1}, {24423, -1, -1, -1}, {24669, -1, -1, -1}, {24666, -1, -1, -1}, {24679, -1, -1, -1}, {24641, -1, -1, -1}, {24738, -1, -1, -1}, {24712, -1, -1, -1}, {24704, -1, -1, -1}, {24722, -1, -1, -1}, {24705, -1, -1, -1}, {24733, -1, -1, -1}, {24707, -1, -1, -1}, {24725, -1, -1, -1}, {24731, -1, -1, -1}, {24727, -1, -1, -1}, {24711, -1, -1, -1}, {24732, -1, -1, -1}, {24718, -1, -1, -1}, {25113, -1, -1, -1}, {25158, -1, -1, -1}, {25330, -1, -1, -1}, {25360, -1, -1, -1}, {25430, -1, -1, -1}, {25388, -1, -1, -1}, {25412, -1, -1, -1}, {25413, -1, -1, -1}, {25398, -1, -1, -1}, {25411, -1, -1, -1}, {25572, -1, -1, -1}, {25401, -1, -1, -1}, {25419, -1, -1, -1}, {25418, -1, -1, -1}, {25404, -1, -1, -1}, {25385, -1, -1, -1}, {25409, -1, -1, -1}, {25396, -1, -1, -1}, {25432, -1, -1, -1}, {25428, -1, -1, -1}, {25433, -1, -1, -1}, {25389, -1, -1, -1}, {25415, -1, -1, -1}, {25395, -1, -1, -1}, {25434, -1, -1, -1}, {25425, -1, -1, -1}, {25400, -1, -1, -1}, {25431, -1, -1, -1}, {25408, -1, -1, -1}, {25416, -1, -1, -1}, {25930, -1, -1, -1}, {25926, -1, -1, -1}, {26054, -1, -1, -1}, {26051, -1, -1, -1}, {26052, -1, -1, -1}, {26050, -1, -1, -1}, {26186, -1, -1, -1}, {26207, -1, -1, -1}, {26183, -1, -1, -1}, {26193, -1, -1, -1}, {26386, -1, -1, -1}, {26387, -1, -1, -1}, {26655, -1, -1, -1}, {26650, -1, -1, -1}, {26697, -1, -1, -1}, {26674, -1, -1, -1}, {26675, -1, -1, -1}, {26683, -1, -1, -1}, {26699, -1, -1, -1}, {26703, -1, -1, -1}, {26646, -1, -1, -1}, {26673, -1, -1, -1}, {26652, -1, -1, -1}, {26677, -1, -1, -1}, {26667, -1, -1, -1}, {26669, -1, -1, -1}, {26671, -1, -1, -1}, {26702, -1, -1, -1}, {26692, -1, -1, -1}, {26676, -1, -1, -1}, {26653, -1, -1, -1}, {26642, -1, -1, -1}, {26644, -1, -1, -1}, {26662, -1, -1, -1}, {26664, -1, -1, -1}, {26670, -1, -1, -1}, {26701, -1, -1, -1}, {26682, -1, -1, -1}, {26661, -1, -1, -1}, {26656, -1, -1, -1}, {27436, -1, -1, -1}, {27439, -1, -1, -1}, {27437, -1, -1, -1}, {27441, -1, -1, -1}, {27444, -1, -1, -1}, {27501, -1, -1, -1}, {32898, -1, -1, -1}, {27528, -1, -1, -1}, {27622, -1, -1, -1}, {27620, -1, -1, -1}, {27624, -1, -1, -1}, {27619, -1, -1, -1}, {27618, -1, -1, -1}, {27623, -1, -1, -1}, {27685, -1, -1, -1}, {28026, -1, -1, -1}, {28003, -1, -1, -1}, {28004, -1, -1, -1}, {28022, -1, -1, -1}, {27917, -1, -1, -1}, {28001, -1, -1, -1}, {28050, -1, -1, -1}, {27992, -1, -1, -1}, {28002, -1, -1, -1}, {28013, -1, -1, -1}, {28015, -1, -1, -1} },
    {{28049, -1, -1, -1}, {28045, -1, -1, -1}, {28143, -1, -1, -1}, {28031, -1, -1, -1}, {28038, -1, -1, -1}, {27998, -1, -1, -1}, {28007, -1, -1, -1}, {28000, -1, -1, -1}, {28055, -1, -1, -1}, {28016, -1, -1, -1}, {28028, -1, -1, -1}, {27999, -1, -1, -1}, {28034, -1, -1, -1}, {28056, -1, -1, -1}, {27951, -1, -1, -1}, {28008, -1, -1, -1}, {28043, -1, -1, -1}, {28030, -1, -1, -1}, {28032, -1, -1, -1}, {28036, -1, -1, -1}, {27926, -1, -1, -1}, {28035, -1, -1, -1}, {28027, -1, -1, -1}, {28029, -1, -1, -1}, {28021, -1, -1, -1}, {28048, -1, -1, -1}, {28892, -1, -1, -1}, {28883, -1, -1, -1}, {28881, -1, -1, -1}, {28893, -1, -1, -1}, {28875, -1, -1, -1}, {32569, -1, -1, -1}, {28898, -1, -1, -1}, {28887, -1, -1, -1}, {28882, -1, -1, -1}, {28894, -1, -1, -1}, {28896, -1, -1, -1}, {28884, -1, -1, -1}, {28877, -1, -1, -1}, {28869, -1, -1, -1}, {28870, -1, -1, -1}, {28871, -1, -1, -1}, {28890, -1, -1, -1}, {28878, -1, -1, -1}, {28897, -1, -1, -1}, {29250, -1, -1, -1}, {29304, -1, -1, -1}, {29303, -1, -1, -1}, {29302, -1, -1, -1}, {29440, -1, -1, -1}, {29434, -1, -1, -1}, {29428, -1, -1, -1}, {29438, -1, -1, -1}, {29430, -1, -1, -1}, {29427, -1, -1, -1}, {29435, -1, -1, -1}, {29441, -1, -1, -1}, {29651, -1, -1, -1}, {29657, -1, -1, -1}, {29669, -1, -1, -1}, {29654, -1, -1, -1}, {29628, -1, -1, -1}, {29671, -1, -1, -1}, {29667, -1, -1, -1}, {29673, -1, -1, -1}, {29660, -1, -1, -1}, {29650, -1, -1, -1}, {29659, -1, -1, -1}, {29652, -1, -1, -1}, {29661, -1, -1, -1}, {29658, -1, -1, -1}, {29655, -1, -1, -1}, {29656, -1, -1, -1}, {29672, -1, -1, -1}, {29918, -1, -1, -1}, {29919, -1, -1, -1}, {29940, -1, -1, -1}, {29941, -1, -1, -1}, {29985, -1, -1, -1}, {30043, -1, -1, -1}, {30047, -1, -1, -1}, {30128, -1, -1, -1}, {30145, -1, -1, -1}, {30139, -1, -1, -1}, {30148, -1, -1, -1}, {30144, -1, -1, -1}, {30143, -1, -1, -1}, {30134, -1, -1, -1}, {30138, -1, -1, -1}, {30346, -1, -1, -1}, {30409, -1, -1, -1}, {30493, -1, -1, -1}, {30491, -1, -1, -1}, {30480, -1, -1, -1}, {30483, -1, -1, -1}, {30482, -1, -1, -1}, {30499, -1, -1, -1}, {30481, -1, -1, -1}, {30485, -1, -1, -1}, {30489, -1, -1, -1}, {30490, -1, -1, -1}, {30498, -1, -1, -1}, {30503, -1, -1, -1}, {30755, -1, -1, -1}, {30764, -1, -1, -1}, {30754, -1, -1, -1}, {30773, -1, -1, -1}, {30767, -1, -1, -1}, {30760, -1, -1, -1}, {30766, -1, -1, -1}, {30763, -1, -1, -1}, {30753, -1, -1, -1}, {30761, -1, -1, -1}, {30771, -1, -1, -1}, {30762, -1, -1, -1}, {30769, -1, -1, -1}, {31060, -1, -1, -1}, {31067, -1, -1, -1}, {31055, -1, -1, -1}, {31068, -1, -1, -1}, {31059, -1, -1, -1}, {31058, -1, -1, -1}, {31057, -1, -1, -1}, {31211, -1, -1, -1}, {31212, -1, -1, -1}, {31200, -1, -1, -1}, {31214, -1, -1, -1}, {31213, -1, -1, -1}, {31210, -1, -1, -1}, {31196, -1, -1, -1}, {31198, -1, -1, -1}, {31197, -1, -1, -1}, {31366, -1, -1, -1}, {31369, -1, -1, -1}, {31365, -1, -1, -1}, {31371, -1, -1, -1}, {31372, -1, -1, -1}, {31370, -1, -1, -1}, {31367, -1, -1, -1}, {31448, -1, -1, -1}, {31504, -1, -1, -1}, {31492, -1, -1, -1}, {31507, -1, -1, -1}, {31493, -1, -1, -1}, {31503, -1, -1, -1}, {31496, -1, -1, -1}, {31498, -1, -1, -1}, {31502, -1, -1, -1}, {31497, -1, -1, -1}, {31506, -1, -1, -1}, {31876, -1, -1, -1}, {31889, -1, -1, -1}, {31882, -1, -1, -1}, {31884, -1, -1, -1}, {31880, -1, -1, -1}, {31885, -1, -1, -1}, {31877, -1, -1, -1}, {32030, -1, -1, -1}, {32029, -1, -1, -1}, {32017, -1, -1, -1}, {32014, -1, -1, -1}, {32024, -1, -1, -1}, {32022, -1, -1, -1}, {32019, -1, -1, -1}, {32031, -1, -1, -1}, {32018, -1, -1, -1}, {32015, -1, -1, -1}, {32012, -1, -1, -1}, {32604, -1, -1, -1}, {32609, -1, -1, -1}, {32606, -1, -1, -1}, {32608, -1, -1, -1}, {32605, -1, -1, -1}, {32603, -1, -1, -1}, {32662, -1, -1, -1}, {32658, -1, -1, -1}, {32707, -1, -1, -1}, {32706, -1, -1, -1}, {32704, -1, -1, -1}, {32790, -1, -1, -1}, {32830, -1, -1, -1}, {32825, -1, -1, -1}, {33018, -1, -1, -1}, {33010, -1, -1, -1}, {33017, -1, -1, -1}, {33013, -1, -1, -1}, {33025, -1, -1, -1}, {33019, -1, -1, -1}, {33024, -1, -1, -1}, {33281, -1, -1, -1}, {33327, -1, -1, -1}, {33317, -1, -1, -1}, {33587, -1, -1, -1}, {33581, -1, -1, -1}, {33604, -1, -1, -1}, {33561, -1, -1, -1}, {33617, -1, -1, -1}, {33573, -1, -1, -1}, {33622, -1, -1, -1}, {33599, -1, -1, -1}, {33601, -1, -1, -1}, {33574, -1, -1, -1}, {33564, -1, -1, -1}, {33570, -1, -1, -1}, {33602, -1, -1, -1}, {33614, -1, -1, -1}, {33563, -1, -1, -1}, {33578, -1, -1, -1}, {33544, -1, -1, -1}, {33596, -1, -1, -1}, {33613, -1, -1, -1}, {33558, -1, -1, -1}, {33572, -1, -1, -1}, {33568, -1, -1, -1}, {33591, -1, -1, -1}, {33583, -1, -1, -1}, {33577, -1, -1, -1}, {33607, -1, -1, -1}, {33605, -1, -1, -1}, {33612, -1, -1, -1}, {33619, -1, -1, -1}, {33566, -1, -1, -1}, {33580, -1, -1, -1}, {33611, -1, -1, -1}, {33575, -1, -1, -1}, {33608, -1, -1, -1}, {34387, -1, -1, -1}, {34386, -1, -1, -1}, {34466, -1, -1, -1}, {34472, -1, -1, -1}, {34454, -1, -1, -1}, {34445, -1, -1, -1}, {34449, -1, -1, -1}, {34462, -1, -1, -1}, {34439, -1, -1, -1}, {34455, -1, -1, -1}, {34438, -1, -1, -1}, {34443, -1, -1, -1}, {34458, -1, -1, -1}, {34437, -1, -1, -1}, {34469, -1, -1, -1}, {34457, -1, -1, -1}, {34465, -1, -1, -1}, {34471, -1, -1, -1}, {34453, -1, -1, -1}, {34456, -1, -1, -1}, {34446, -1, -1, -1}, {34461, -1, -1, -1}, {34448, -1, -1, -1}, {34452, -1, -1, -1}, {34883, -1, -1, -1}, {34884, -1, -1, -1}, {34925, -1, -1, -1}, {34933, -1, -1, -1}, {34934, -1, -1, -1}, {34930, -1, -1, -1} },
    {{34944, -1, -1, -1}, {34929, -1, -1, -1}, {34943, -1, -1, -1}, {34927, -1, -1, -1}, {34947, -1, -1, -1}, {34942, -1, -1, -1}, {34932, -1, -1, -1}, {34940, -1, -1, -1}, {35346, -1, -1, -1}, {35911, -1, -1, -1}, {35927, -1, -1, -1}, {35963, -1, -1, -1}, {36004, -1, -1, -1}, {36003, -1, -1, -1}, {36214, -1, -1, -1}, {36216, -1, -1, -1}, {36277, -1, -1, -1}, {36279, -1, -1, -1}, {36278, -1, -1, -1}, {36561, -1, -1, -1}, {36563, -1, -1, -1}, {36862, -1, -1, -1}, {36853, -1, -1, -1}, {36866, -1, -1, -1}, {36863, -1, -1, -1}, {36859, -1, -1, -1}, {36868, -1, -1, -1}, {36860, -1, -1, -1}, {36854, -1, -1, -1}, {37078, -1, -1, -1}, {37088, -1, -1, -1}, {37081, -1, -1, -1}, {37082, -1, -1, -1}, {37091, -1, -1, -1}, {37087, -1, -1, -1}, {37093, -1, -1, -1}, {37080, -1, -1, -1}, {37083, -1, -1, -1}, {37079, -1, -1, -1}, {37084, -1, -1, -1}, {37092, -1, -1, -1}, {37200, -1, -1, -1}, {37198, -1, -1, -1}, {37199, -1, -1, -1}, {37333, -1, -1, -1}, {37346, -1, -1, -1}, {37338, -1, -1, -1}, {38492, -1, -1, -1}, {38495, -1, -1, -1}, {38588, -1, -1, -1}, {39139, -1, -1, -1}, {39647, -1, -1, -1}, {39727, -1, -1, -1}, {20095, -1, -1, -1}, {20592, -1, -1, -1}, {20586, -1, -1, -1}, {20577, -1, -1, -1}, {20574, -1, -1, -1}, {20576, -1, -1, -1}, {20563, -1, -1, -1}, {20555, -1, -1, -1}, {20573, -1, -1, -1}, {20594, -1, -1, -1}, {20552, -1, -1, -1}, {20557, -1, -1, -1}, {20545, -1, -1, -1}, {20571, -1, -1, -1}, {20554, -1, -1, -1}, {20578, -1, -1, -1}, {20501, -1, -1, -1}, {20549, -1, -1, -1}, {20575, -1, -1, -1}, {20585, -1, -1, -1}, {20587, -1, -1, -1}, {20579, -1, -1, -1}, {20580, -1, -1, -1}, {20550, -1, -1, -1}, {20544, -1, -1, -1}, {20590, -1, -1, -1}, {20595, -1, -1, -1}, {20567, -1, -1, -1}, {20561, -1, -1, -1}, {20944, -1, -1, -1}, {21099, -1, -1, -1}, {21101, -1, -1, -1}, {21100, -1, -1, -1}, {21102, -1, -1, -1}, {21206, -1, -1, -1}, {21203, -1, -1, -1}, {21293, -1, -1, -1}, {21404, -1, -1, -1}, {21877, -1, -1, -1}, {21878, -1, -1, -1}, {21820, -1, -1, -1}, {21837, -1, -1, -1}, {21840, -1, -1, -1}, {21812, -1, -1, -1}, {21802, -1, -1, -1}, {21841, -1, -1, -1}, {21858, -1, -1, -1}, {21814, -1, -1, -1}, {21813, -1, -1, -1}, {21808, -1, -1, -1}, {21842, -1, -1, -1}, {21829, -1, -1, -1}, {21772, -1, -1, -1}, {21810, -1, -1, -1}, {21861, -1, -1, -1}, {21838, -1, -1, -1}, {21817, -1, -1, -1}, {21832, -1, -1, -1}, {21805, -1, -1, -1}, {21819, -1, -1, -1}, {21824, -1, -1, -1}, {21835, -1, -1, -1}, {22282, -1, -1, -1}, {22279, -1, -1, -1}, {22523, -1, -1, -1}, {22548, -1, -1, -1}, {22498, -1, -1, -1}, {22518, -1, -1, -1}, {22492, -1, -1, -1}, {22516, -1, -1, -1}, {22528, -1, -1, -1}, {22509, -1, -1, -1}, {22525, -1, -1, -1}, {22536, -1, -1, -1}, {22520, -1, -1, -1}, {22539, -1, -1, -1}, {22515, -1, -1, -1}, {22479, -1, -1, -1}, {22535, -1, -1, -1}, {22510, -1, -1, -1}, {22499, -1, -1, -1}, {22514, -1, -1, -1}, {22501, -1, -1, -1}, {22508, -1, -1, -1}, {22497, -1, -1, -1}, {22542, -1, -1, -1}, {22524, -1, -1, -1}, {22544, -1, -1, -1}, {22503, -1, -1, -1}, {22529, -1, -1, -1}, {22540, -1, -1, -1}, {22513, -1, -1, -1}, {22505, -1, -1, -1}, {22512, -1, -1, -1}, {22541, -1, -1, -1}, {22532, -1, -1, -1}, {22876, -1, -1, -1}, {23136, -1, -1, -1}, {23128, -1, -1, -1}, {23125, -1, -1, -1}, {23143, -1, -1, -1}, {23134, -1, -1, -1}, {23096, -1, -1, -1}, {23093, -1, -1, -1}, {23149, -1, -1, -1}, {23120, -1, -1, -1}, {23135, -1, -1, -1}, {23141, -1, -1, -1}, {23148, -1, -1, -1}, {23123, -1, -1, -1}, {23140, -1, -1, -1}, {23127, -1, -1, -1}, {23107, -1, -1, -1}, {23133, -1, -1, -1}, {23122, -1, -1, -1}, {23108, -1, -1, -1}, {23131, -1, -1, -1}, {23112, -1, -1, -1}, {23182, -1, -1, -1}, {23102, -1, -1, -1}, {23117, -1, -1, -1}, {23097, -1, -1, -1}, {23116, -1, -1, -1}, {23152, -1, -1, -1}, {23145, -1, -1, -1}, {23111, -1, -1, -1}, {23121, -1, -1, -1}, {23126, -1, -1, -1}, {23106, -1, -1, -1}, {23132, -1, -1, -1}, {23410, -1, -1, -1}, {23406, -1, -1, -1}, {23489, -1, -1, -1}, {23488, -1, -1, -1}, {23641, -1, -1, -1}, {23838, -1, -1, -1}, {23819, -1, -1, -1}, {23837, -1, -1, -1}, {23834, -1, -1, -1}, {23840, -1, -1, -1}, {23820, -1, -1, -1}, {23848, -1, -1, -1}, {23821, -1, -1, -1}, {23846, -1, -1, -1}, {23845, -1, -1, -1}, {23823, -1, -1, -1}, {23856, -1, -1, -1}, {23826, -1, -1, -1}, {23843, -1, -1, -1}, {23839, -1, -1, -1}, {23854, -1, -1, -1}, {24126, -1, -1, -1}, {24116, -1, -1, -1}, {24241, -1, -1, -1}, {24244, -1, -1, -1}, {24249, -1, -1, -1}, {24242, -1, -1, -1}, {24243, -1, -1, -1}, {24374, -1, -1, -1}, {24376, -1, -1, -1}, {24475, -1, -1, -1}, {24470, -1, -1, -1}, {24479, -1, -1, -1}, {24714, -1, -1, -1}, {24720, -1, -1, -1}, {24710, -1, -1, -1}, {24766, -1, -1, -1}, {24752, -1, -1, -1}, {24762, -1, -1, -1}, {24787, -1, -1, -1}, {24788, -1, -1, -1}, {24783, -1, -1, -1}, {24804, -1, -1, -1}, {24793, -1, -1, -1}, {24797, -1, -1, -1}, {24776, -1, -1, -1}, {24753, -1, -1, -1}, {24795, -1, -1, -1}, {24759, -1, -1, -1}, {24778, -1, -1, -1}, {24767, -1, -1, -1}, {24771, -1, -1, -1}, {24781, -1, -1, -1}, {24768, -1, -1, -1}, {25394, -1, -1, -1}, {25445, -1, -1, -1}, {25482, -1, -1, -1}, {25474, -1, -1, -1}, {25469, -1, -1, -1}, {25533, -1, -1, -1}, {25502, -1, -1, -1}, {25517, -1, -1, -1}, {25501, -1, -1, -1}, {25495, -1, -1, -1}, {25515, -1, -1, -1}, {25486, -1, -1, -1}, {25455, -1, -1, -1}, {25479, -1, -1, -1}, {25488, -1, -1, -1}, {25454, -1, -1, -1}, {25519, -1, -1, -1}, {25461, -1, -1, -1}, {25500, -1, -1, -1} },
    {{25453, -1, -1, -1}, {25518, -1, -1, -1}, {25468, -1, -1, -1}, {25508, -1, -1, -1}, {25403, -1, -1, -1}, {25503, -1, -1, -1}, {25464, -1, -1, -1}, {25477, -1, -1, -1}, {25473, -1, -1, -1}, {25489, -1, -1, -1}, {25485, -1, -1, -1}, {25456, -1, -1, -1}, {25939, -1, -1, -1}, {26061, -1, -1, -1}, {26213, -1, -1, -1}, {26209, -1, -1, -1}, {26203, -1, -1, -1}, {26201, -1, -1, -1}, {26204, -1, -1, -1}, {26210, -1, -1, -1}, {26392, -1, -1, -1}, {26745, -1, -1, -1}, {26759, -1, -1, -1}, {26768, -1, -1, -1}, {26780, -1, -1, -1}, {26733, -1, -1, -1}, {26734, -1, -1, -1}, {26798, -1, -1, -1}, {26795, -1, -1, -1}, {26966, -1, -1, -1}, {26735, -1, -1, -1}, {26787, -1, -1, -1}, {26796, -1, -1, -1}, {26793, -1, -1, -1}, {26741, -1, -1, -1}, {26740, -1, -1, -1}, {26802, -1, -1, -1}, {26767, -1, -1, -1}, {26743, -1, -1, -1}, {26770, -1, -1, -1}, {26748, -1, -1, -1}, {26731, -1, -1, -1}, {26738, -1, -1, -1}, {26794, -1, -1, -1}, {26752, -1, -1, -1}, {26737, -1, -1, -1}, {26750, -1, -1, -1}, {26779, -1, -1, -1}, {26774, -1, -1, -1}, {26763, -1, -1, -1}, {26784, -1, -1, -1}, {26761, -1, -1, -1}, {26788, -1, -1, -1}, {26744, -1, -1, -1}, {26747, -1, -1, -1}, {26769, -1, -1, -1}, {26764, -1, -1, -1}, {26762, -1, -1, -1}, {26749, -1, -1, -1}, {27446, -1, -1, -1}, {27443, -1, -1, -1}, {27447, -1, -1, -1}, {27448, -1, -1, -1}, {27537, -1, -1, -1}, {27535, -1, -1, -1}, {27533, -1, -1, -1}, {27534, -1, -1, -1}, {27532, -1, -1, -1}, {27690, -1, -1, -1}, {28096, -1, -1, -1}, {28075, -1, -1, -1}, {28084, -1, -1, -1}, {28083, -1, -1, -1}, {28276, -1, -1, -1}, {28076, -1, -1, -1}, {28137, -1, -1, -1}, {28130, -1, -1, -1}, {28087, -1, -1, -1}, {28150, -1, -1, -1}, {28116, -1, -1, -1}, {28160, -1, -1, -1}, {28104, -1, -1, -1}, {28128, -1, -1, -1}, {28127, -1, -1, -1}, {28118, -1, -1, -1}, {28094, -1, -1, -1}, {28133, -1, -1, -1}, {28124, -1, -1, -1}, {28125, -1, -1, -1}, {28123, -1, -1, -1}, {28148, -1, -1, -1}, {28106, -1, -1, -1}, {28093, -1, -1, -1}, {28141, -1, -1, -1}, {28144, -1, -1, -1}, {28090, -1, -1, -1}, {28117, -1, -1, -1}, {28098, -1, -1, -1}, {28111, -1, -1, -1}, {28105, -1, -1, -1}, {28112, -1, -1, -1}, {28146, -1, -1, -1}, {28115, -1, -1, -1}, {28157, -1, -1, -1}, {28119, -1, -1, -1}, {28109, -1, -1, -1}, {28131, -1, -1, -1}, {28091, -1, -1, -1}, {28922, -1, -1, -1}, {28941, -1, -1, -1}, {28919, -1, -1, -1}, {28951, -1, -1, -1}, {28916, -1, -1, -1}, {28940, -1, -1, -1}, {28912, -1, -1, -1}, {28932, -1, -1, -1}, {28915, -1, -1, -1}, {28944, -1, -1, -1}, {28924, -1, -1, -1}, {28927, -1, -1, -1}, {28934, -1, -1, -1}, {28947, -1, -1, -1}, {28928, -1, -1, -1}, {28920, -1, -1, -1}, {28918, -1, -1, -1}, {28939, -1, -1, -1}, {28930, -1, -1, -1}, {28942, -1, -1, -1}, {29310, -1, -1, -1}, {29307, -1, -1, -1}, {29308, -1, -1, -1}, {29311, -1, -1, -1}, {29469, -1, -1, -1}, {29463, -1, -1, -1}, {29447, -1, -1, -1}, {29457, -1, -1, -1}, {29464, -1, -1, -1}, {29450, -1, -1, -1}, {29448, -1, -1, -1}, {29439, -1, -1, -1}, {29455, -1, -1, -1}, {29470, -1, -1, -1}, {29576, -1, -1, -1}, {29686, -1, -1, -1}, {29688, -1, -1, -1}, {29685, -1, -1, -1}, {29700, -1, -1, -1}, {29697, -1, -1, -1}, {29693, -1, -1, -1}, {29703, -1, -1, -1}, {29696, -1, -1, -1}, {29690, -1, -1, -1}, {29692, -1, -1, -1}, {29695, -1, -1, -1}, {29708, -1, -1, -1}, {29707, -1, -1, -1}, {29684, -1, -1, -1}, {29704, -1, -1, -1}, {30052, -1, -1, -1}, {30051, -1, -1, -1}, {30158, -1, -1, -1}, {30162, -1, -1, -1}, {30159, -1, -1, -1}, {30155, -1, -1, -1}, {30156, -1, -1, -1}, {30161, -1, -1, -1}, {30160, -1, -1, -1}, {30351, -1, -1, -1}, {30345, -1, -1, -1}, {30419, -1, -1, -1}, {30521, -1, -1, -1}, {30511, -1, -1, -1}, {30509, -1, -1, -1}, {30513, -1, -1, -1}, {30514, -1, -1, -1}, {30516, -1, -1, -1}, {30515, -1, -1, -1}, {30525, -1, -1, -1}, {30501, -1, -1, -1}, {30523, -1, -1, -1}, {30517, -1, -1, -1}, {30792, -1, -1, -1}, {30802, -1, -1, -1}, {30793, -1, -1, -1}, {30797, -1, -1, -1}, {30794, -1, -1, -1}, {30796, -1, -1, -1}, {30758, -1, -1, -1}, {30789, -1, -1, -1}, {30800, -1, -1, -1}, {31076, -1, -1, -1}, {31079, -1, -1, -1}, {31081, -1, -1, -1}, {31082, -1, -1, -1}, {31075, -1, -1, -1}, {31083, -1, -1, -1}, {31073, -1, -1, -1}, {31163, -1, -1, -1}, {31226, -1, -1, -1}, {31224, -1, -1, -1}, {31222, -1, -1, -1}, {31223, -1, -1, -1}, {31375, -1, -1, -1}, {31380, -1, -1, -1}, {31376, -1, -1, -1}, {31541, -1, -1, -1}, {31547, -1, -1, -1}, {31540, -1, -1, -1}, {31525, -1, -1, -1}, {31536, -1, -1, -1}, {31522, -1, -1, -1}, {31524, -1, -1, -1}, {31539, -1, -1, -1}, {31512, -1, -1, -1}, {31530, -1, -1, -1}, {31517, -1, -1, -1}, {31537, -1, -1, -1}, {31531, -1, -1, -1}, {31533, -1, -1, -1}, {31535, -1, -1, -1}, {31538, -1, -1, -1}, {31544, -1, -1, -1}, {31514, -1, -1, -1}, {31523, -1, -1, -1}, {31892, -1, -1, -1}, {31896, -1, -1, -1}, {31894, -1, -1, -1}, {31907, -1, -1, -1}, {32053, -1, -1, -1}, {32061, -1, -1, -1}, {32056, -1, -1, -1}, {32054, -1, -1, -1}, {32058, -1, -1, -1}, {32069, -1, -1, -1}, {32044, -1, -1, -1}, {32041, -1, -1, -1}, {32065, -1, -1, -1}, {32071, -1, -1, -1}, {32062, -1, -1, -1}, {32063, -1, -1, -1}, {32074, -1, -1, -1}, {32059, -1, -1, -1}, {32040, -1, -1, -1}, {32611, -1, -1, -1}, {32661, -1, -1, -1}, {32668, -1, -1, -1}, {32669, -1, -1, -1}, {32667, -1, -1, -1}, {32714, -1, -1, -1}, {32715, -1, -1, -1}, {32717, -1, -1, -1}, {32720, -1, -1, -1}, {32721, -1, -1, -1}, {32711, -1, -1, -1}, {32719, -1, -1, -1}, {32713, -1, -1, -1} },
    {{32799, -1, -1, -1}, {32798, -1, -1, -1}, {32795, -1, -1, -1}, {32839, -1, -1, -1}, {32835, -1, -1, -1}, {32840, -1, -1, -1}, {33048, -1, -1, -1}, {33061, -1, -1, -1}, {33049, -1, -1, -1}, {33051, -1, -1, -1}, {33069, -1, -1, -1}, {33055, -1, -1, -1}, {33068, -1, -1, -1}, {33054, -1, -1, -1}, {33057, -1, -1, -1}, {33045, -1, -1, -1}, {33063, -1, -1, -1}, {33053, -1, -1, -1}, {33058, -1, -1, -1}, {33297, -1, -1, -1}, {33336, -1, -1, -1}, {33331, -1, -1, -1}, {33338, -1, -1, -1}, {33332, -1, -1, -1}, {33330, -1, -1, -1}, {33396, -1, -1, -1}, {33680, -1, -1, -1}, {33699, -1, -1, -1}, {33704, -1, -1, -1}, {33677, -1, -1, -1}, {33658, -1, -1, -1}, {33651, -1, -1, -1}, {33700, -1, -1, -1}, {33652, -1, -1, -1}, {33679, -1, -1, -1}, {33665, -1, -1, -1}, {33685, -1, -1, -1}, {33689, -1, -1, -1}, {33653, -1, -1, -1}, {33684, -1, -1, -1}, {33705, -1, -1, -1}, {33661, -1, -1, -1}, {33667, -1, -1, -1}, {33676, -1, -1, -1}, {33693, -1, -1, -1}, {33691, -1, -1, -1}, {33706, -1, -1, -1}, {33675, -1, -1, -1}, {33662, -1, -1, -1}, {33701, -1, -1, -1}, {33711, -1, -1, -1}, {33672, -1, -1, -1}, {33687, -1, -1, -1}, {33712, -1, -1, -1}, {33663, -1, -1, -1}, {33702, -1, -1, -1}, {33671, -1, -1, -1}, {33710, -1, -1, -1}, {33654, -1, -1, -1}, {34393, -1, -1, -1}, {34390, -1, -1, -1}, {34495, -1, -1, -1}, {34487, -1, -1, -1}, {34498, -1, -1, -1}, {34497, -1, -1, -1}, {34501, -1, -1, -1}, {34490, -1, -1, -1}, {34480, -1, -1, -1}, {34504, -1, -1, -1}, {34489, -1, -1, -1}, {34483, -1, -1, -1}, {34488, -1, -1, -1}, {34508, -1, -1, -1}, {34484, -1, -1, -1}, {34491, -1, -1, -1}, {34492, -1, -1, -1}, {34499, -1, -1, -1}, {34493, -1, -1, -1}, {34494, -1, -1, -1}, {34898, -1, -1, -1}, {34953, -1, -1, -1}, {34965, -1, -1, -1}, {34984, -1, -1, -1}, {34978, -1, -1, -1}, {34986, -1, -1, -1}, {34970, -1, -1, -1}, {34961, -1, -1, -1}, {34977, -1, -1, -1}, {34975, -1, -1, -1}, {34968, -1, -1, -1}, {34983, -1, -1, -1}, {34969, -1, -1, -1}, {34971, -1, -1, -1}, {34967, -1, -1, -1}, {34980, -1, -1, -1}, {34988, -1, -1, -1}, {34956, -1, -1, -1}, {34963, -1, -1, -1}, {34958, -1, -1, -1}, {35202, -1, -1, -1}, {35286, -1, -1, -1}, {35289, -1, -1, -1}, {35285, -1, -1, -1}, {35376, -1, -1, -1}, {35367, -1, -1, -1}, {35372, -1, -1, -1}, {35358, -1, -1, -1}, {35897, -1, -1, -1}, {35899, -1, -1, -1}, {35932, -1, -1, -1}, {35933, -1, -1, -1}, {35965, -1, -1, -1}, {36005, -1, -1, -1}, {36221, -1, -1, -1}, {36219, -1, -1, -1}, {36217, -1, -1, -1}, {36284, -1, -1, -1}, {36290, -1, -1, -1}, {36281, -1, -1, -1}, {36287, -1, -1, -1}, {36289, -1, -1, -1}, {36568, -1, -1, -1}, {36574, -1, -1, -1}, {36573, -1, -1, -1}, {36572, -1, -1, -1}, {36567, -1, -1, -1}, {36576, -1, -1, -1}, {36577, -1, -1, -1}, {36900, -1, -1, -1}, {36875, -1, -1, -1}, {36881, -1, -1, -1}, {36892, -1, -1, -1}, {36876, -1, -1, -1}, {36897, -1, -1, -1}, {37103, -1, -1, -1}, {37098, -1, -1, -1}, {37104, -1, -1, -1}, {37108, -1, -1, -1}, {37106, -1, -1, -1}, {37107, -1, -1, -1}, {37076, -1, -1, -1}, {37099, -1, -1, -1}, {37100, -1, -1, -1}, {37097, -1, -1, -1}, {37206, -1, -1, -1}, {37208, -1, -1, -1}, {37210, -1, -1, -1}, {37203, -1, -1, -1}, {37205, -1, -1, -1}, {37356, -1, -1, -1}, {37364, -1, -1, -1}, {37361, -1, -1, -1}, {37363, -1, -1, -1}, {37368, -1, -1, -1}, {37348, -1, -1, -1}, {37369, -1, -1, -1}, {37354, -1, -1, -1}, {37355, -1, -1, -1}, {37367, -1, -1, -1}, {37352, -1, -1, -1}, {37358, -1, -1, -1}, {38266, -1, -1, -1}, {38278, -1, -1, -1}, {38280, -1, -1, -1}, {38524, -1, -1, -1}, {38509, -1, -1, -1}, {38507, -1, -1, -1}, {38513, -1, -1, -1}, {38511, -1, -1, -1}, {38591, -1, -1, -1}, {38762, -1, -1, -1}, {38916, -1, -1, -1}, {39141, -1, -1, -1}, {39319, -1, -1, -1}, {20635, -1, -1, -1}, {20629, -1, -1, -1}, {20628, -1, -1, -1}, {20638, -1, -1, -1}, {20619, -1, -1, -1}, {20643, -1, -1, -1}, {20611, -1, -1, -1}, {20620, -1, -1, -1}, {20622, -1, -1, -1}, {20637, -1, -1, -1}, {20584, -1, -1, -1}, {20636, -1, -1, -1}, {20626, -1, -1, -1}, {20610, -1, -1, -1}, {20615, -1, -1, -1}, {20831, -1, -1, -1}, {20948, -1, -1, -1}, {21266, -1, -1, -1}, {21265, -1, -1, -1}, {21412, -1, -1, -1}, {21415, -1, -1, -1}, {21905, -1, -1, -1}, {21928, -1, -1, -1}, {21925, -1, -1, -1}, {21933, -1, -1, -1}, {21879, -1, -1, -1}, {22085, -1, -1, -1}, {21922, -1, -1, -1}, {21907, -1, -1, -1}, {21896, -1, -1, -1}, {21903, -1, -1, -1}, {21941, -1, -1, -1}, {21889, -1, -1, -1}, {21923, -1, -1, -1}, {21906, -1, -1, -1}, {21924, -1, -1, -1}, {21885, -1, -1, -1}, {21900, -1, -1, -1}, {21926, -1, -1, -1}, {21887, -1, -1, -1}, {21909, -1, -1, -1}, {21921, -1, -1, -1}, {21902, -1, -1, -1}, {22284, -1, -1, -1}, {22569, -1, -1, -1}, {22583, -1, -1, -1}, {22553, -1, -1, -1}, {22558, -1, -1, -1}, {22567, -1, -1, -1}, {22563, -1, -1, -1}, {22568, -1, -1, -1}, {22517, -1, -1, -1}, {22600, -1, -1, -1}, {22565, -1, -1, -1}, {22556, -1, -1, -1}, {22555, -1, -1, -1}, {22579, -1, -1, -1}, {22591, -1, -1, -1}, {22582, -1, -1, -1}, {22574, -1, -1, -1}, {22585, -1, -1, -1}, {22584, -1, -1, -1}, {22573, -1, -1, -1}, {22572, -1, -1, -1}, {22587, -1, -1, -1}, {22881, -1, -1, -1}, {23215, -1, -1, -1}, {23188, -1, -1, -1}, {23199, -1, -1, -1}, {23162, -1, -1, -1}, {23202, -1, -1, -1}, {23198, -1, -1, -1}, {23160, -1, -1, -1}, {23206, -1, -1, -1}, {23164, -1, -1, -1}, {23205, -1, -1, -1}, {23212, -1, -1, -1}, {23189, -1, -1, -1}, {23214, -1, -1, -1}, {23095, -1, -1, -1}, {23172, -1, -1, -1}, {23178, -1, -1, -1} },
    {{23191, -1, -1, -1}, {23171, -1, -1, -1}, {23179, -1, -1, -1}, {23209, -1, -1, -1}, {23163, -1, -1, -1}, {23165, -1, -1, -1}, {23180, -1, -1, -1}, {23196, -1, -1, -1}, {23183, -1, -1, -1}, {23187, -1, -1, -1}, {23197, -1, -1, -1}, {23530, -1, -1, -1}, {23501, -1, -1, -1}, {23499, -1, -1, -1}, {23508, -1, -1, -1}, {23505, -1, -1, -1}, {23498, -1, -1, -1}, {23502, -1, -1, -1}, {23564, -1, -1, -1}, {23600, -1, -1, -1}, {23863, -1, -1, -1}, {23875, -1, -1, -1}, {23915, -1, -1, -1}, {23873, -1, -1, -1}, {23883, -1, -1, -1}, {23871, -1, -1, -1}, {23861, -1, -1, -1}, {23889, -1, -1, -1}, {23886, -1, -1, -1}, {23893, -1, -1, -1}, {23859, -1, -1, -1}, {23866, -1, -1, -1}, {23890, -1, -1, -1}, {23869, -1, -1, -1}, {23857, -1, -1, -1}, {23897, -1, -1, -1}, {23874, -1, -1, -1}, {23865, -1, -1, -1}, {23881, -1, -1, -1}, {23864, -1, -1, -1}, {23868, -1, -1, -1}, {23858, -1, -1, -1}, {23862, -1, -1, -1}, {23872, -1, -1, -1}, {23877, -1, -1, -1}, {24132, -1, -1, -1}, {24129, -1, -1, -1}, {24408, -1, -1, -1}, {24486, -1, -1, -1}, {24485, -1, -1, -1}, {24491, -1, -1, -1}, {24777, -1, -1, -1}, {24761, -1, -1, -1}, {24780, -1, -1, -1}, {24802, -1, -1, -1}, {24782, -1, -1, -1}, {24772, -1, -1, -1}, {24852, -1, -1, -1}, {24818, -1, -1, -1}, {24842, -1, -1, -1}, {24854, -1, -1, -1}, {24837, -1, -1, -1}, {24821, -1, -1, -1}, {24851, -1, -1, -1}, {24824, -1, -1, -1}, {24828, -1, -1, -1}, {24830, -1, -1, -1}, {24769, -1, -1, -1}, {24835, -1, -1, -1}, {24856, -1, -1, -1}, {24861, -1, -1, -1}, {24848, -1, -1, -1}, {24831, -1, -1, -1}, {24836, -1, -1, -1}, {24843, -1, -1, -1}, {25162, -1, -1, -1}, {25492, -1, -1, -1}, {25521, -1, -1, -1}, {25520, -1, -1, -1}, {25550, -1, -1, -1}, {25573, -1, -1, -1}, {25576, -1, -1, -1}, {25583, -1, -1, -1}, {25539, -1, -1, -1}, {25757, -1, -1, -1}, {25587, -1, -1, -1}, {25546, -1, -1, -1}, {25568, -1, -1, -1}, {25590, -1, -1, -1}, {25557, -1, -1, -1}, {25586, -1, -1, -1}, {25589, -1, -1, -1}, {25697, -1, -1, -1}, {25567, -1, -1, -1}, {25534, -1, -1, -1}, {25565, -1, -1, -1}, {25564, -1, -1, -1}, {25540, -1, -1, -1}, {25560, -1, -1, -1}, {25555, -1, -1, -1}, {25538, -1, -1, -1}, {25543, -1, -1, -1}, {25548, -1, -1, -1}, {25547, -1, -1, -1}, {25544, -1, -1, -1}, {25584, -1, -1, -1}, {25559, -1, -1, -1}, {25561, -1, -1, -1}, {25906, -1, -1, -1}, {25959, -1, -1, -1}, {25962, -1, -1, -1}, {25956, -1, -1, -1}, {25948, -1, -1, -1}, {25960, -1, -1, -1}, {25957, -1, -1, -1}, {25996, -1, -1, -1}, {26013, -1, -1, -1}, {26014, -1, -1, -1}, {26030, -1, -1, -1}, {26064, -1, -1, -1}, {26066, -1, -1, -1}, {26236, -1, -1, -1}, {26220, -1, -1, -1}, {26235, -1, -1, -1}, {26240, -1, -1, -1}, {26225, -1, -1, -1}, {26233, -1, -1, -1}, {26218, -1, -1, -1}, {26226, -1, -1, -1}, {26369, -1, -1, -1}, {26892, -1, -1, -1}, {26835, -1, -1, -1}, {26884, -1, -1, -1}, {26844, -1, -1, -1}, {26922, -1, -1, -1}, {26860, -1, -1, -1}, {26858, -1, -1, -1}, {26865, -1, -1, -1}, {26895, -1, -1, -1}, {26838, -1, -1, -1}, {26871, -1, -1, -1}, {26859, -1, -1, -1}, {26852, -1, -1, -1}, {26870, -1, -1, -1}, {26899, -1, -1, -1}, {26896, -1, -1, -1}, {26867, -1, -1, -1}, {26849, -1, -1, -1}, {26887, -1, -1, -1}, {26828, -1, -1, -1}, {26888, -1, -1, -1}, {26992, -1, -1, -1}, {26804, -1, -1, -1}, {26897, -1, -1, -1}, {26863, -1, -1, -1}, {26822, -1, -1, -1}, {26900, -1, -1, -1}, {26872, -1, -1, -1}, {26832, -1, -1, -1}, {26877, -1, -1, -1}, {26876, -1, -1, -1}, {26856, -1, -1, -1}, {26891, -1, -1, -1}, {26890, -1, -1, -1}, {26903, -1, -1, -1}, {26830, -1, -1, -1}, {26824, -1, -1, -1}, {26845, -1, -1, -1}, {26846, -1, -1, -1}, {26854, -1, -1, -1}, {26868, -1, -1, -1}, {26833, -1, -1, -1}, {26886, -1, -1, -1}, {26836, -1, -1, -1}, {26857, -1, -1, -1}, {26901, -1, -1, -1}, {26917, -1, -1, -1}, {26823, -1, -1, -1}, {27449, -1, -1, -1}, {27451, -1, -1, -1}, {27455, -1, -1, -1}, {27452, -1, -1, -1}, {27540, -1, -1, -1}, {27543, -1, -1, -1}, {27545, -1, -1, -1}, {27541, -1, -1, -1}, {27581, -1, -1, -1}, {27632, -1, -1, -1}, {27634, -1, -1, -1}, {27635, -1, -1, -1}, {27696, -1, -1, -1}, {28156, -1, -1, -1}, {28230, -1, -1, -1}, {28231, -1, -1, -1}, {28191, -1, -1, -1}, {28233, -1, -1, -1}, {28296, -1, -1, -1}, {28220, -1, -1, -1}, {28221, -1, -1, -1}, {28229, -1, -1, -1}, {28258, -1, -1, -1}, {28203, -1, -1, -1}, {28223, -1, -1, -1}, {28225, -1, -1, -1}, {28253, -1, -1, -1}, {28275, -1, -1, -1}, {28188, -1, -1, -1}, {28211, -1, -1, -1}, {28235, -1, -1, -1}, {28224, -1, -1, -1}, {28241, -1, -1, -1}, {28219, -1, -1, -1}, {28163, -1, -1, -1}, {28206, -1, -1, -1}, {28254, -1, -1, -1}, {28264, -1, -1, -1}, {28252, -1, -1, -1}, {28257, -1, -1, -1}, {28209, -1, -1, -1}, {28200, -1, -1, -1}, {28256, -1, -1, -1}, {28273, -1, -1, -1}, {28267, -1, -1, -1}, {28217, -1, -1, -1}, {28194, -1, -1, -1}, {28208, -1, -1, -1}, {28243, -1, -1, -1}, {28261, -1, -1, -1}, {28199, -1, -1, -1}, {28280, -1, -1, -1}, {28260, -1, -1, -1}, {28279, -1, -1, -1}, {28245, -1, -1, -1}, {28281, -1, -1, -1}, {28242, -1, -1, -1}, {28262, -1, -1, -1}, {28213, -1, -1, -1}, {28214, -1, -1, -1}, {28250, -1, -1, -1}, {28960, -1, -1, -1}, {28958, -1, -1, -1}, {28975, -1, -1, -1}, {28923, -1, -1, -1}, {28974, -1, -1, -1}, {28977, -1, -1, -1}, {28963, -1, -1, -1}, {28965, -1, -1, -1}, {28962, -1, -1, -1}, {28978, -1, -1, -1}, {28959, -1, -1, -1}, {28968, -1, -1, -1}, {28986, -1, -1, -1}, {28955, -1, -1, -1}, {29259, -1, -1, -1}, {29274, -1, -1, -1}, {29320, -1, -1, -1} },
    {{29321, -1, -1, -1}, {29318, -1, -1, -1}, {29317, -1, -1, -1}, {29323, -1, -1, -1}, {29458, -1, -1, -1}, {29451, -1, -1, -1}, {29488, -1, -1, -1}, {29474, -1, -1, -1}, {29489, -1, -1, -1}, {29491, -1, -1, -1}, {29479, -1, -1, -1}, {29490, -1, -1, -1}, {29485, -1, -1, -1}, {29478, -1, -1, -1}, {29475, -1, -1, -1}, {29493, -1, -1, -1}, {29452, -1, -1, -1}, {29742, -1, -1, -1}, {29740, -1, -1, -1}, {29744, -1, -1, -1}, {29739, -1, -1, -1}, {29718, -1, -1, -1}, {29722, -1, -1, -1}, {29729, -1, -1, -1}, {29741, -1, -1, -1}, {29745, -1, -1, -1}, {29732, -1, -1, -1}, {29731, -1, -1, -1}, {29725, -1, -1, -1}, {29737, -1, -1, -1}, {29728, -1, -1, -1}, {29746, -1, -1, -1}, {29947, -1, -1, -1}, {29999, -1, -1, -1}, {30063, -1, -1, -1}, {30060, -1, -1, -1}, {30183, -1, -1, -1}, {30170, -1, -1, -1}, {30177, -1, -1, -1}, {30182, -1, -1, -1}, {30173, -1, -1, -1}, {30175, -1, -1, -1}, {30180, -1, -1, -1}, {30167, -1, -1, -1}, {30357, -1, -1, -1}, {30354, -1, -1, -1}, {30426, -1, -1, -1}, {30534, -1, -1, -1}, {30535, -1, -1, -1}, {30532, -1, -1, -1}, {30541, -1, -1, -1}, {30533, -1, -1, -1}, {30538, -1, -1, -1}, {30542, -1, -1, -1}, {30539, -1, -1, -1}, {30540, -1, -1, -1}, {30686, -1, -1, -1}, {30700, -1, -1, -1}, {30816, -1, -1, -1}, {30820, -1, -1, -1}, {30821, -1, -1, -1}, {30812, -1, -1, -1}, {30829, -1, -1, -1}, {30833, -1, -1, -1}, {30826, -1, -1, -1}, {30830, -1, -1, -1}, {30832, -1, -1, -1}, {30825, -1, -1, -1}, {30824, -1, -1, -1}, {30814, -1, -1, -1}, {30818, -1, -1, -1}, {31092, -1, -1, -1}, {31091, -1, -1, -1}, {31090, -1, -1, -1}, {31088, -1, -1, -1}, {31234, -1, -1, -1}, {31242, -1, -1, -1}, {31235, -1, -1, -1}, {31244, -1, -1, -1}, {31236, -1, -1, -1}, {31385, -1, -1, -1}, {31462, -1, -1, -1}, {31460, -1, -1, -1}, {31562, -1, -1, -1}, {31559, -1, -1, -1}, {31556, -1, -1, -1}, {31560, -1, -1, -1}, {31564, -1, -1, -1}, {31566, -1, -1, -1}, {31552, -1, -1, -1}, {31576, -1, -1, -1}, {31557, -1, -1, -1}, {31906, -1, -1, -1}, {31902, -1, -1, -1}, {31912, -1, -1, -1}, {31905, -1, -1, -1}, {32088, -1, -1, -1}, {32111, -1, -1, -1}, {32099, -1, -1, -1}, {32083, -1, -1, -1}, {32086, -1, -1, -1}, {32103, -1, -1, -1}, {32106, -1, -1, -1}, {32079, -1, -1, -1}, {32109, -1, -1, -1}, {32092, -1, -1, -1}, {32107, -1, -1, -1}, {32082, -1, -1, -1}, {32084, -1, -1, -1}, {32105, -1, -1, -1}, {32081, -1, -1, -1}, {32095, -1, -1, -1}, {32078, -1, -1, -1}, {32574, -1, -1, -1}, {32575, -1, -1, -1}, {32613, -1, -1, -1}, {32614, -1, -1, -1}, {32674, -1, -1, -1}, {32672, -1, -1, -1}, {32673, -1, -1, -1}, {32727, -1, -1, -1}, {32849, -1, -1, -1}, {32847, -1, -1, -1}, {32848, -1, -1, -1}, {33022, -1, -1, -1}, {32980, -1, -1, -1}, {33091, -1, -1, -1}, {33098, -1, -1, -1}, {33106, -1, -1, -1}, {33103, -1, -1, -1}, {33095, -1, -1, -1}, {33085, -1, -1, -1}, {33101, -1, -1, -1}, {33082, -1, -1, -1}, {33254, -1, -1, -1}, {33262, -1, -1, -1}, {33271, -1, -1, -1}, {33272, -1, -1, -1}, {33273, -1, -1, -1}, {33284, -1, -1, -1}, {33340, -1, -1, -1}, {33341, -1, -1, -1}, {33343, -1, -1, -1}, {33397, -1, -1, -1}, {33595, -1, -1, -1}, {33743, -1, -1, -1}, {33785, -1, -1, -1}, {33827, -1, -1, -1}, {33728, -1, -1, -1}, {33768, -1, -1, -1}, {33810, -1, -1, -1}, {33767, -1, -1, -1}, {33764, -1, -1, -1}, {33788, -1, -1, -1}, {33782, -1, -1, -1}, {33808, -1, -1, -1}, {33734, -1, -1, -1}, {33736, -1, -1, -1}, {33771, -1, -1, -1}, {33763, -1, -1, -1}, {33727, -1, -1, -1}, {33793, -1, -1, -1}, {33757, -1, -1, -1}, {33765, -1, -1, -1}, {33752, -1, -1, -1}, {33791, -1, -1, -1}, {33761, -1, -1, -1}, {33739, -1, -1, -1}, {33742, -1, -1, -1}, {33750, -1, -1, -1}, {33781, -1, -1, -1}, {33737, -1, -1, -1}, {33801, -1, -1, -1}, {33807, -1, -1, -1}, {33758, -1, -1, -1}, {33809, -1, -1, -1}, {33798, -1, -1, -1}, {33730, -1, -1, -1}, {33779, -1, -1, -1}, {33749, -1, -1, -1}, {33786, -1, -1, -1}, {33735, -1, -1, -1}, {33745, -1, -1, -1}, {33770, -1, -1, -1}, {33811, -1, -1, -1}, {33690, -1, -1, -1}, {33731, -1, -1, -1}, {33772, -1, -1, -1}, {33774, -1, -1, -1}, {33732, -1, -1, -1}, {33787, -1, -1, -1}, {33751, -1, -1, -1}, {33762, -1, -1, -1}, {33819, -1, -1, -1}, {33755, -1, -1, -1}, {33790, -1, -1, -1}, {34520, -1, -1, -1}, {34530, -1, -1, -1}, {34534, -1, -1, -1}, {34515, -1, -1, -1}, {34531, -1, -1, -1}, {34522, -1, -1, -1}, {34538, -1, -1, -1}, {34525, -1, -1, -1}, {34539, -1, -1, -1}, {34524, -1, -1, -1}, {34540, -1, -1, -1}, {34537, -1, -1, -1}, {34519, -1, -1, -1}, {34536, -1, -1, -1}, {34513, -1, -1, -1}, {34888, -1, -1, -1}, {34902, -1, -1, -1}, {34901, -1, -1, -1}, {35002, -1, -1, -1}, {35031, -1, -1, -1}, {35001, -1, -1, -1}, {35000, -1, -1, -1}, {35008, -1, -1, -1}, {35006, -1, -1, -1}, {34998, -1, -1, -1}, {35004, -1, -1, -1}, {34999, -1, -1, -1}, {35005, -1, -1, -1}, {34994, -1, -1, -1}, {35073, -1, -1, -1}, {35017, -1, -1, -1}, {35221, -1, -1, -1}, {35224, -1, -1, -1}, {35223, -1, -1, -1}, {35293, -1, -1, -1}, {35290, -1, -1, -1}, {35291, -1, -1, -1}, {35406, -1, -1, -1}, {35405, -1, -1, -1}, {35385, -1, -1, -1}, {35417, -1, -1, -1}, {35392, -1, -1, -1}, {35415, -1, -1, -1}, {35416, -1, -1, -1}, {35396, -1, -1, -1}, {35397, -1, -1, -1}, {35410, -1, -1, -1}, {35400, -1, -1, -1}, {35409, -1, -1, -1}, {35402, -1, -1, -1}, {35404, -1, -1, -1}, {35407, -1, -1, -1}, {35935, -1, -1, -1}, {35969, -1, -1, -1}, {35968, -1, -1, -1}, {36026, -1, -1, -1}, {36030, -1, -1, -1}, {36016, -1, -1, -1}, {36025, -1, -1, -1}, {36021, -1, -1, -1} },
    {{36228, -1, -1, -1}, {36224, -1, -1, -1}, {36233, -1, -1, -1}, {36312, -1, -1, -1}, {36307, -1, -1, -1}, {36301, -1, -1, -1}, {36295, -1, -1, -1}, {36310, -1, -1, -1}, {36316, -1, -1, -1}, {36303, -1, -1, -1}, {36309, -1, -1, -1}, {36313, -1, -1, -1}, {36296, -1, -1, -1}, {36311, -1, -1, -1}, {36293, -1, -1, -1}, {36591, -1, -1, -1}, {36599, -1, -1, -1}, {36602, -1, -1, -1}, {36601, -1, -1, -1}, {36582, -1, -1, -1}, {36590, -1, -1, -1}, {36581, -1, -1, -1}, {36597, -1, -1, -1}, {36583, -1, -1, -1}, {36584, -1, -1, -1}, {36598, -1, -1, -1}, {36587, -1, -1, -1}, {36593, -1, -1, -1}, {36588, -1, -1, -1}, {36596, -1, -1, -1}, {36585, -1, -1, -1}, {36909, -1, -1, -1}, {36916, -1, -1, -1}, {36911, -1, -1, -1}, {37126, -1, -1, -1}, {37164, -1, -1, -1}, {37124, -1, -1, -1}, {37119, -1, -1, -1}, {37116, -1, -1, -1}, {37128, -1, -1, -1}, {37113, -1, -1, -1}, {37115, -1, -1, -1}, {37121, -1, -1, -1}, {37120, -1, -1, -1}, {37127, -1, -1, -1}, {37125, -1, -1, -1}, {37123, -1, -1, -1}, {37217, -1, -1, -1}, {37220, -1, -1, -1}, {37215, -1, -1, -1}, {37218, -1, -1, -1}, {37216, -1, -1, -1}, {37377, -1, -1, -1}, {37386, -1, -1, -1}, {37413, -1, -1, -1}, {37379, -1, -1, -1}, {37402, -1, -1, -1}, {37414, -1, -1, -1}, {37391, -1, -1, -1}, {37388, -1, -1, -1}, {37376, -1, -1, -1}, {37394, -1, -1, -1}, {37375, -1, -1, -1}, {37373, -1, -1, -1}, {37382, -1, -1, -1}, {37380, -1, -1, -1}, {37415, -1, -1, -1}, {37378, -1, -1, -1}, {37404, -1, -1, -1}, {37412, -1, -1, -1}, {37401, -1, -1, -1}, {37399, -1, -1, -1}, {37381, -1, -1, -1}, {37398, -1, -1, -1}, {38267, -1, -1, -1}, {38285, -1, -1, -1}, {38284, -1, -1, -1}, {38288, -1, -1, -1}, {38535, -1, -1, -1}, {38526, -1, -1, -1}, {38536, -1, -1, -1}, {38537, -1, -1, -1}, {38531, -1, -1, -1}, {38528, -1, -1, -1}, {38594, -1, -1, -1}, {38600, -1, -1, -1}, {38595, -1, -1, -1}, {38641, -1, -1, -1}, {38640, -1, -1, -1}, {38764, -1, -1, -1}, {38768, -1, -1, -1}, {38766, -1, -1, -1}, {38919, -1, -1, -1}, {39081, -1, -1, -1}, {39147, -1, -1, -1}, {40166, -1, -1, -1}, {40697, -1, -1, -1}, {20099, -1, -1, -1}, {20100, -1, -1, -1}, {20150, -1, -1, -1}, {20669, -1, -1, -1}, {20671, -1, -1, -1}, {20678, -1, -1, -1}, {20654, -1, -1, -1}, {20676, -1, -1, -1}, {20682, -1, -1, -1}, {20660, -1, -1, -1}, {20680, -1, -1, -1}, {20674, -1, -1, -1}, {20656, -1, -1, -1}, {20673, -1, -1, -1}, {20666, -1, -1, -1}, {20657, -1, -1, -1}, {20683, -1, -1, -1}, {20681, -1, -1, -1}, {20662, -1, -1, -1}, {20664, -1, -1, -1}, {20951, -1, -1, -1}, {21114, -1, -1, -1}, {21112, -1, -1, -1}, {21115, -1, -1, -1}, {21116, -1, -1, -1}, {21955, -1, -1, -1}, {21979, -1, -1, -1}, {21964, -1, -1, -1}, {21968, -1, -1, -1}, {21963, -1, -1, -1}, {21962, -1, -1, -1}, {21981, -1, -1, -1}, {21952, 64013, -1, -1}, {21972, -1, -1, -1}, {21956, -1, -1, -1}, {21993, -1, -1, -1}, {21951, -1, -1, -1}, {21970, -1, -1, -1}, {21901, -1, -1, -1}, {21967, -1, -1, -1}, {21973, -1, -1, -1}, {21986, -1, -1, -1}, {21974, -1, -1, -1}, {21960, -1, -1, -1}, {22002, -1, -1, -1}, {21965, -1, -1, -1}, {21977, -1, -1, -1}, {21954, -1, -1, -1}, {22292, -1, -1, -1}, {22611, -1, -1, -1}, {22632, -1, -1, -1}, {22628, -1, -1, -1}, {22607, -1, -1, -1}, {22605, -1, -1, -1}, {22601, -1, -1, -1}, {22639, -1, -1, -1}, {22613, -1, -1, -1}, {22606, -1, -1, -1}, {22621, -1, -1, -1}, {22617, -1, -1, -1}, {22629, -1, -1, -1}, {22619, -1, -1, -1}, {22589, -1, -1, -1}, {22627, -1, -1, -1}, {22641, -1, -1, -1}, {22780, -1, -1, -1}, {23239, -1, -1, -1}, {23236, -1, -1, -1}, {23243, -1, -1, -1}, {23226, -1, -1, -1}, {23224, -1, -1, -1}, {23217, -1, -1, -1}, {23221, -1, -1, -1}, {23216, -1, -1, -1}, {23231, -1, -1, -1}, {23240, -1, -1, -1}, {23227, -1, -1, -1}, {23238, -1, -1, -1}, {23223, -1, -1, -1}, {23232, -1, -1, -1}, {23242, -1, -1, -1}, {23220, -1, -1, -1}, {23222, -1, -1, -1}, {23245, -1, -1, -1}, {23225, -1, -1, -1}, {23184, -1, -1, -1}, {23510, -1, -1, -1}, {23512, -1, -1, -1}, {23513, -1, -1, -1}, {23583, -1, -1, -1}, {23603, -1, -1, -1}, {23921, -1, -1, -1}, {23907, -1, -1, -1}, {23882, -1, -1, -1}, {23909, -1, -1, -1}, {23922, -1, -1, -1}, {23916, -1, -1, -1}, {23902, -1, -1, -1}, {23912, -1, -1, -1}, {23911, -1, -1, -1}, {23906, -1, -1, -1}, {24048, -1, -1, -1}, {24143, -1, -1, -1}, {24142, -1, -1, -1}, {24138, -1, -1, -1}, {24141, -1, -1, -1}, {24139, -1, -1, -1}, {24261, -1, -1, -1}, {24268, -1, -1, -1}, {24262, -1, -1, -1}, {24267, -1, -1, -1}, {24263, -1, -1, -1}, {24384, -1, -1, -1}, {24495, -1, -1, -1}, {24493, -1, -1, -1}, {24823, -1, -1, -1}, {24905, -1, -1, -1}, {24906, -1, -1, -1}, {24875, -1, -1, -1}, {24901, -1, -1, -1}, {24886, -1, -1, -1}, {24882, -1, -1, -1}, {24878, -1, -1, -1}, {24902, -1, -1, -1}, {24879, -1, -1, -1}, {24911, -1, -1, -1}, {24873, -1, -1, -1}, {24896, -1, -1, -1}, {25120, -1, -1, -1}, {37224, -1, -1, -1}, {25123, -1, -1, -1}, {25125, -1, -1, -1}, {25124, -1, -1, -1}, {25541, -1, -1, -1}, {25585, -1, -1, -1}, {25579, -1, -1, -1}, {25616, -1, -1, -1}, {25618, -1, -1, -1}, {25609, -1, -1, -1}, {25632, -1, -1, -1}, {25636, -1, -1, -1}, {25651, -1, -1, -1}, {25667, -1, -1, -1}, {25631, -1, -1, -1}, {25621, -1, -1, -1}, {25624, -1, -1, -1}, {25657, -1, -1, -1}, {25655, -1, -1, -1}, {25634, -1, -1, -1}, {25635, -1, -1, -1}, {25612, -1, -1, -1}, {25638, -1, -1, -1}, {25648, -1, -1, -1}, {25640, -1, -1, -1}, {25665, -1, -1, -1}, {25653, -1, -1, -1}, {25647, -1, -1, -1}, {25610, -1, -1, -1}, {25626, -1, -1, -1} },
    {{25664, -1, -1, -1}, {25637, -1, -1, -1}, {25639, -1, -1, -1}, {25611, -1, -1, -1}, {25575, -1, -1, -1}, {25627, -1, -1, -1}, {25646, -1, -1, -1}, {25633, -1, -1, -1}, {25614, -1, -1, -1}, {25967, -1, -1, -1}, {26002, -1, -1, -1}, {26067, -1, -1, -1}, {26246, -1, -1, -1}, {26252, -1, -1, -1}, {26261, -1, -1, -1}, {26256, -1, -1, -1}, {26251, -1, -1, -1}, {26250, -1, -1, -1}, {26265, -1, -1, -1}, {26260, -1, -1, -1}, {26232, -1, -1, -1}, {26400, -1, -1, -1}, {26982, -1, -1, -1}, {26975, -1, -1, -1}, {26936, -1, -1, -1}, {26958, -1, -1, -1}, {26978, -1, -1, -1}, {26993, -1, -1, -1}, {26943, -1, -1, -1}, {26949, -1, -1, -1}, {26986, -1, -1, -1}, {26937, -1, -1, -1}, {26946, -1, -1, -1}, {26967, -1, -1, -1}, {26969, -1, -1, -1}, {27002, -1, -1, -1}, {26952, -1, -1, -1}, {26953, -1, -1, -1}, {26933, -1, -1, -1}, {26988, -1, -1, -1}, {26931, -1, -1, -1}, {26941, -1, -1, -1}, {26981, -1, -1, -1}, {26864, -1, -1, -1}, {27000, -1, -1, -1}, {26932, -1, -1, -1}, {26985, -1, -1, -1}, {26944, -1, -1, -1}, {26991, -1, -1, -1}, {26948, -1, -1, -1}, {26998, -1, -1, -1}, {26968, -1, -1, -1}, {26945, -1, -1, -1}, {26996, -1, -1, -1}, {26956, -1, -1, -1}, {26939, -1, -1, -1}, {26955, -1, -1, -1}, {26935, -1, -1, -1}, {26972, -1, -1, -1}, {26959, -1, -1, -1}, {26961, -1, -1, -1}, {26930, -1, -1, -1}, {26962, -1, -1, -1}, {26927, -1, -1, -1}, {27003, -1, -1, -1}, {26940, -1, -1, -1}, {27462, -1, -1, -1}, {27461, -1, -1, -1}, {27459, -1, -1, -1}, {27458, -1, -1, -1}, {27464, -1, -1, -1}, {27457, -1, -1, -1}, {27547, -1, -1, -1}, {27643, -1, -1, -1}, {27644, -1, -1, -1}, {27641, -1, -1, -1}, {27639, -1, -1, -1}, {27640, -1, -1, -1}, {28315, -1, -1, -1}, {28374, -1, -1, -1}, {28360, -1, -1, -1}, {28303, -1, -1, -1}, {28352, -1, -1, -1}, {28319, -1, -1, -1}, {28307, -1, -1, -1}, {28308, -1, -1, -1}, {28320, -1, -1, -1}, {28337, -1, -1, -1}, {28345, -1, -1, -1}, {28358, -1, -1, -1}, {28370, -1, -1, -1}, {28349, -1, -1, -1}, {28353, -1, -1, -1}, {28318, -1, -1, -1}, {28361, -1, -1, -1}, {28343, -1, -1, -1}, {28336, -1, -1, -1}, {28365, -1, -1, -1}, {28326, -1, -1, -1}, {28367, -1, -1, -1}, {28338, -1, -1, -1}, {28350, -1, -1, -1}, {28355, -1, -1, -1}, {28380, -1, -1, -1}, {28376, -1, -1, -1}, {28313, -1, -1, -1}, {28306, -1, -1, -1}, {28302, -1, -1, -1}, {28301, -1, -1, -1}, {28324, -1, -1, -1}, {28321, -1, -1, -1}, {28351, -1, -1, -1}, {28339, -1, -1, -1}, {28368, -1, -1, -1}, {28362, -1, -1, -1}, {28311, -1, -1, -1}, {28334, -1, -1, -1}, {28323, -1, -1, -1}, {28999, -1, -1, -1}, {29012, -1, -1, -1}, {29010, -1, -1, -1}, {29027, -1, -1, -1}, {29024, -1, -1, -1}, {28993, -1, -1, -1}, {29021, -1, -1, -1}, {29026, -1, -1, -1}, {29042, -1, -1, -1}, {29048, -1, -1, -1}, {29034, -1, -1, -1}, {29025, -1, -1, -1}, {28994, -1, -1, -1}, {29016, -1, -1, -1}, {28995, -1, -1, -1}, {29003, -1, -1, -1}, {29040, -1, -1, -1}, {29023, -1, -1, -1}, {29008, -1, -1, -1}, {29011, -1, -1, -1}, {28996, -1, -1, -1}, {29005, -1, -1, -1}, {29018, -1, -1, -1}, {29263, -1, -1, -1}, {29325, -1, -1, -1}, {29324, -1, -1, -1}, {29329, -1, -1, -1}, {29328, -1, -1, -1}, {29326, -1, -1, -1}, {29500, -1, -1, -1}, {29506, -1, -1, -1}, {29499, -1, -1, -1}, {29498, -1, -1, -1}, {29504, -1, -1, -1}, {29514, -1, -1, -1}, {29513, -1, -1, -1}, {29764, -1, -1, -1}, {29770, -1, -1, -1}, {29771, -1, -1, -1}, {29778, -1, -1, -1}, {29777, -1, -1, -1}, {29783, -1, -1, -1}, {29760, -1, -1, -1}, {29775, -1, -1, -1}, {29776, -1, -1, -1}, {29774, -1, -1, -1}, {29762, -1, -1, -1}, {29766, -1, -1, -1}, {29773, -1, -1, -1}, {29780, -1, -1, -1}, {29921, -1, -1, -1}, {29951, -1, -1, -1}, {29950, -1, -1, -1}, {29949, -1, -1, -1}, {29981, -1, -1, -1}, {30073, -1, -1, -1}, {30071, -1, -1, -1}, {27011, -1, -1, -1}, {30191, -1, -1, -1}, {30223, -1, -1, -1}, {30211, -1, -1, -1}, {30199, -1, -1, -1}, {30206, -1, -1, -1}, {30204, -1, -1, -1}, {30201, -1, -1, -1}, {30200, -1, -1, -1}, {30224, -1, -1, -1}, {30203, -1, -1, -1}, {30198, -1, -1, -1}, {30189, -1, -1, -1}, {30197, -1, -1, -1}, {30205, -1, -1, -1}, {30361, -1, -1, -1}, {30389, -1, -1, -1}, {30429, -1, -1, -1}, {30549, -1, -1, -1}, {30559, -1, -1, -1}, {30560, -1, -1, -1}, {30546, -1, -1, -1}, {30550, -1, -1, -1}, {30554, -1, -1, -1}, {30569, -1, -1, -1}, {30567, -1, -1, -1}, {30548, -1, -1, -1}, {30553, -1, -1, -1}, {30573, -1, -1, -1}, {30688, -1, -1, -1}, {30855, -1, -1, -1}, {30874, -1, -1, -1}, {30868, -1, -1, -1}, {30863, -1, -1, -1}, {30852, -1, -1, -1}, {30869, -1, -1, -1}, {30853, -1, -1, -1}, {30854, -1, -1, -1}, {30881, -1, -1, -1}, {30851, -1, -1, -1}, {30841, -1, -1, -1}, {30873, -1, -1, -1}, {30848, -1, -1, -1}, {30870, -1, -1, -1}, {30843, -1, -1, -1}, {31100, -1, -1, -1}, {31106, -1, -1, -1}, {31101, -1, -1, -1}, {31097, -1, -1, -1}, {31249, -1, -1, -1}, {31256, -1, -1, -1}, {31257, -1, -1, -1}, {31250, -1, -1, -1}, {31255, -1, -1, -1}, {31253, -1, -1, -1}, {31266, -1, -1, -1}, {31251, -1, -1, -1}, {31259, -1, -1, -1}, {31248, -1, -1, -1}, {31395, -1, -1, -1}, {31394, -1, -1, -1}, {31390, -1, -1, -1}, {31467, -1, -1, -1}, {31590, -1, -1, -1}, {31588, -1, -1, -1}, {31597, -1, -1, -1}, {31604, -1, -1, -1}, {31593, -1, -1, -1}, {31602, -1, -1, -1}, {31589, -1, -1, -1}, {31603, -1, -1, -1}, {31601, -1, -1, -1}, {31600, -1, -1, -1}, {31585, -1, -1, -1}, {31608, -1, -1, -1}, {31606, -1, -1, -1}, {31587, -1, -1, -1}, {31922, -1, -1, -1}, {31924, -1, -1, -1}, {31919, -1, -1, -1}, {32136, -1, -1, -1} },
    {{32134, -1, -1, -1}, {32128, -1, -1, -1}, {32141, -1, -1, -1}, {32127, -1, -1, -1}, {32133, -1, -1, -1}, {32122, -1, -1, -1}, {32142, -1, -1, -1}, {32123, -1, -1, -1}, {32131, -1, -1, -1}, {32124, -1, -1, -1}, {32140, -1, -1, -1}, {32148, -1, -1, -1}, {32132, -1, -1, -1}, {32125, -1, -1, -1}, {32146, -1, -1, -1}, {32621, -1, -1, -1}, {32619, -1, -1, -1}, {32615, -1, -1, -1}, {32616, -1, -1, -1}, {32620, -1, -1, -1}, {32678, -1, -1, -1}, {32677, -1, -1, -1}, {32679, -1, -1, -1}, {32731, -1, -1, -1}, {32732, -1, -1, -1}, {32801, -1, -1, -1}, {33124, -1, -1, -1}, {33120, -1, -1, -1}, {33143, -1, -1, -1}, {33116, -1, -1, -1}, {33129, -1, -1, -1}, {33115, -1, -1, -1}, {33122, -1, -1, -1}, {33138, -1, -1, -1}, {26401, -1, -1, -1}, {33118, -1, -1, -1}, {33142, -1, -1, -1}, {33127, -1, -1, -1}, {33135, -1, -1, -1}, {33092, -1, -1, -1}, {33121, -1, -1, -1}, {33309, -1, -1, -1}, {33353, -1, -1, -1}, {33348, -1, -1, -1}, {33344, -1, -1, -1}, {33346, -1, -1, -1}, {33349, -1, -1, -1}, {34033, -1, -1, -1}, {33855, -1, -1, -1}, {33878, -1, -1, -1}, {33910, -1, -1, -1}, {33913, -1, -1, -1}, {33935, -1, -1, -1}, {33933, -1, -1, -1}, {33893, -1, -1, -1}, {33873, -1, -1, -1}, {33856, -1, -1, -1}, {33926, -1, -1, -1}, {33895, -1, -1, -1}, {33840, -1, -1, -1}, {33869, -1, -1, -1}, {33917, -1, -1, -1}, {33882, -1, -1, -1}, {33881, -1, -1, -1}, {33908, -1, -1, -1}, {33907, -1, -1, -1}, {33885, -1, -1, -1}, {34055, -1, -1, -1}, {33886, -1, -1, -1}, {33847, -1, -1, -1}, {33850, -1, -1, -1}, {33844, -1, -1, -1}, {33914, -1, -1, -1}, {33859, -1, -1, -1}, {33912, -1, -1, -1}, {33842, -1, -1, -1}, {33861, -1, -1, -1}, {33833, -1, -1, -1}, {33753, -1, -1, -1}, {33867, -1, -1, -1}, {33839, -1, -1, -1}, {33858, -1, -1, -1}, {33837, -1, -1, -1}, {33887, -1, -1, -1}, {33904, -1, -1, -1}, {33849, -1, -1, -1}, {33870, -1, -1, -1}, {33868, -1, -1, -1}, {33874, -1, -1, -1}, {33903, -1, -1, -1}, {33989, -1, -1, -1}, {33934, -1, -1, -1}, {33851, -1, -1, -1}, {33863, -1, -1, -1}, {33846, -1, -1, -1}, {33843, -1, -1, -1}, {33896, -1, -1, -1}, {33918, -1, -1, -1}, {33860, -1, -1, -1}, {33835, -1, -1, -1}, {33888, -1, -1, -1}, {33876, -1, -1, -1}, {33902, -1, -1, -1}, {33872, -1, -1, -1}, {34571, -1, -1, -1}, {34564, -1, -1, -1}, {34551, -1, -1, -1}, {34572, -1, -1, -1}, {34554, -1, -1, -1}, {34518, -1, -1, -1}, {34549, -1, -1, -1}, {34637, -1, -1, -1}, {34552, -1, -1, -1}, {34574, -1, -1, -1}, {34569, -1, -1, -1}, {34561, -1, -1, -1}, {34550, -1, -1, -1}, {34573, -1, -1, -1}, {34565, -1, -1, -1}, {35030, -1, -1, -1}, {35019, -1, -1, -1}, {35021, -1, -1, -1}, {35022, -1, -1, -1}, {35038, -1, -1, -1}, {35035, -1, -1, -1}, {35034, -1, -1, -1}, {35020, -1, -1, -1}, {35024, -1, -1, -1}, {35205, -1, -1, -1}, {35227, -1, -1, -1}, {35295, -1, -1, -1}, {35301, -1, -1, -1}, {35300, -1, -1, -1}, {35297, -1, -1, -1}, {35296, -1, -1, -1}, {35298, -1, -1, -1}, {35292, -1, -1, -1}, {35302, -1, -1, -1}, {35446, -1, -1, -1}, {35462, -1, -1, -1}, {35455, -1, -1, -1}, {35425, -1, -1, -1}, {35391, -1, -1, -1}, {35447, -1, -1, -1}, {35458, -1, -1, -1}, {35460, -1, -1, -1}, {35445, -1, -1, -1}, {35459, -1, -1, -1}, {35457, -1, -1, -1}, {35444, -1, -1, -1}, {35450, -1, -1, -1}, {35900, -1, -1, -1}, {35915, -1, -1, -1}, {35914, -1, -1, -1}, {35941, -1, -1, -1}, {35940, -1, -1, -1}, {35942, -1, -1, -1}, {35974, -1, -1, -1}, {35972, -1, -1, -1}, {35973, -1, -1, -1}, {36044, -1, -1, -1}, {36200, -1, -1, -1}, {36201, -1, -1, -1}, {36241, -1, -1, -1}, {36236, -1, -1, -1}, {36238, -1, -1, -1}, {36239, -1, -1, -1}, {36237, -1, -1, -1}, {36243, -1, -1, -1}, {36244, -1, -1, -1}, {36240, -1, -1, -1}, {36242, -1, -1, -1}, {36336, -1, -1, -1}, {36320, -1, -1, -1}, {36332, -1, -1, -1}, {36337, -1, -1, -1}, {36334, -1, -1, -1}, {36304, -1, -1, -1}, {36329, -1, -1, -1}, {36323, -1, -1, -1}, {36322, -1, -1, -1}, {36327, -1, -1, -1}, {36338, -1, -1, -1}, {36331, -1, -1, -1}, {36340, -1, -1, -1}, {36614, -1, -1, -1}, {36607, -1, -1, -1}, {36609, -1, -1, -1}, {36608, -1, -1, -1}, {36613, -1, -1, -1}, {36615, -1, -1, -1}, {36616, -1, -1, -1}, {36610, -1, -1, -1}, {36619, -1, -1, -1}, {36946, -1, -1, -1}, {36927, -1, -1, -1}, {36932, -1, -1, -1}, {36937, -1, -1, -1}, {36925, -1, -1, -1}, {37136, -1, -1, -1}, {37133, -1, -1, -1}, {37135, -1, -1, -1}, {37137, -1, -1, -1}, {37142, -1, -1, -1}, {37140, -1, -1, -1}, {37131, -1, -1, -1}, {37134, -1, -1, -1}, {37230, -1, -1, -1}, {37231, -1, -1, -1}, {37448, -1, -1, -1}, {37458, -1, -1, -1}, {37424, -1, -1, -1}, {37434, -1, -1, -1}, {37478, -1, -1, -1}, {37427, -1, -1, -1}, {37477, -1, -1, -1}, {37470, -1, -1, -1}, {37507, -1, -1, -1}, {37422, -1, -1, -1}, {37450, -1, -1, -1}, {37446, -1, -1, -1}, {37485, -1, -1, -1}, {37484, -1, -1, -1}, {37455, -1, -1, -1}, {37472, -1, -1, -1}, {37479, -1, -1, -1}, {37487, -1, -1, -1}, {37430, -1, -1, -1}, {37473, -1, -1, -1}, {37488, -1, -1, -1}, {37425, -1, -1, -1}, {37460, -1, -1, -1}, {37475, -1, -1, -1}, {37456, -1, -1, -1}, {37490, -1, -1, -1}, {37454, -1, -1, -1}, {37459, -1, -1, -1}, {37452, -1, -1, -1}, {37462, -1, -1, -1}, {37426, -1, -1, -1}, {38303, -1, -1, -1}, {38300, -1, -1, -1}, {38302, -1, -1, -1}, {38299, -1, -1, -1}, {38546, -1, -1, -1}, {38547, -1, -1, -1}, {38545, -1, -1, -1}, {38551, -1, -1, -1}, {38606, -1, -1, -1}, {38650, -1, -1, -1}, {38653, -1, -1, -1}, {38648, -1, -1, -1}, {38645, -1, -1, -1}, {38771, -1, -1, -1}, {38775, -1, -1, -1}, {38776, -1, -1, -1} },
    {{38770, -1, -1, -1}, {38927, -1, -1, -1}, {38925, -1, -1, -1}, {38926, -1, -1, -1}, {39084, -1, -1, -1}, {39158, -1, -1, -1}, {39161, -1, -1, -1}, {39343, -1, -1, -1}, {39346, -1, -1, -1}, {39344, -1, -1, -1}, {39349, -1, -1, -1}, {39597, -1, -1, -1}, {39595, -1, -1, -1}, {39771, -1, -1, -1}, {40170, -1, -1, -1}, {40173, -1, -1, -1}, {40167, -1, -1, -1}, {40576, -1, -1, -1}, {40701, -1, -1, -1}, {20710, -1, -1, -1}, {20692, -1, -1, -1}, {20695, -1, -1, -1}, {20712, -1, -1, -1}, {20723, -1, -1, -1}, {20699, -1, -1, -1}, {20714, -1, -1, -1}, {20701, -1, -1, -1}, {20708, -1, -1, -1}, {20691, -1, -1, -1}, {20716, -1, -1, -1}, {20720, -1, -1, -1}, {20719, -1, -1, -1}, {20707, -1, -1, -1}, {20704, -1, -1, -1}, {20952, -1, -1, -1}, {21120, -1, -1, -1}, {21121, -1, -1, -1}, {21225, -1, -1, -1}, {21227, -1, -1, -1}, {21296, -1, -1, -1}, {21420, -1, -1, -1}, {22055, -1, -1, -1}, {22037, -1, -1, -1}, {22028, -1, -1, -1}, {22034, -1, -1, -1}, {22012, -1, -1, -1}, {22031, -1, -1, -1}, {22044, -1, -1, -1}, {22017, -1, -1, -1}, {22035, -1, -1, -1}, {22018, -1, -1, -1}, {22010, -1, -1, -1}, {22045, -1, -1, -1}, {22020, -1, -1, -1}, {22015, -1, -1, -1}, {22009, -1, -1, -1}, {22665, -1, -1, -1}, {22652, -1, -1, -1}, {22672, -1, -1, -1}, {22680, -1, -1, -1}, {22662, -1, -1, -1}, {22657, -1, -1, -1}, {22655, -1, -1, -1}, {22644, -1, -1, -1}, {22667, -1, -1, -1}, {22650, -1, -1, -1}, {22663, -1, -1, -1}, {22673, -1, -1, -1}, {22670, -1, -1, -1}, {22646, -1, -1, -1}, {22658, -1, -1, -1}, {22664, -1, -1, -1}, {22651, -1, -1, -1}, {22676, -1, -1, -1}, {22671, -1, -1, -1}, {22782, -1, -1, -1}, {22891, -1, -1, -1}, {23260, -1, -1, -1}, {23278, -1, -1, -1}, {23269, -1, -1, -1}, {23253, -1, -1, -1}, {23274, -1, -1, -1}, {23258, -1, -1, -1}, {23277, -1, -1, -1}, {23275, -1, -1, -1}, {23283, -1, -1, -1}, {23266, -1, -1, -1}, {23264, -1, -1, -1}, {23259, -1, -1, -1}, {23276, -1, -1, -1}, {23262, -1, -1, -1}, {23261, -1, -1, -1}, {23257, -1, -1, -1}, {23272, -1, -1, -1}, {23263, -1, -1, -1}, {23415, -1, -1, -1}, {23520, -1, -1, -1}, {23523, -1, -1, -1}, {23651, -1, -1, -1}, {23938, -1, -1, -1}, {23936, -1, -1, -1}, {23933, -1, -1, -1}, {23942, -1, -1, -1}, {23930, -1, -1, -1}, {23937, -1, -1, -1}, {23927, -1, -1, -1}, {23946, -1, -1, -1}, {23945, -1, -1, -1}, {23944, -1, -1, -1}, {23934, -1, -1, -1}, {23932, -1, -1, -1}, {23949, -1, -1, -1}, {23929, -1, -1, -1}, {23935, -1, -1, -1}, {24152, -1, -1, -1}, {24153, -1, -1, -1}, {24147, -1, -1, -1}, {24280, -1, -1, -1}, {24273, -1, -1, -1}, {24279, -1, -1, -1}, {24270, -1, -1, -1}, {24284, -1, -1, -1}, {24277, -1, -1, -1}, {24281, -1, -1, -1}, {24274, -1, -1, -1}, {24276, -1, -1, -1}, {24388, -1, -1, -1}, {24387, -1, -1, -1}, {24431, -1, -1, -1}, {24502, -1, -1, -1}, {24876, -1, -1, -1}, {24872, -1, -1, -1}, {24897, -1, -1, -1}, {24926, -1, -1, -1}, {24945, -1, -1, -1}, {24947, -1, -1, -1}, {24914, -1, -1, -1}, {24915, -1, -1, -1}, {24946, -1, -1, -1}, {24940, -1, -1, -1}, {24960, -1, -1, -1}, {24948, -1, -1, -1}, {24916, -1, -1, -1}, {24954, -1, -1, -1}, {24923, -1, -1, -1}, {24933, -1, -1, -1}, {24891, -1, -1, -1}, {24938, -1, -1, -1}, {24929, -1, -1, -1}, {24918, -1, -1, -1}, {25129, -1, -1, -1}, {25127, -1, -1, -1}, {25131, -1, -1, -1}, {25643, -1, -1, -1}, {25677, -1, -1, -1}, {25691, -1, -1, -1}, {25693, -1, -1, -1}, {25716, -1, -1, -1}, {25718, -1, -1, -1}, {25714, -1, -1, -1}, {25715, -1, -1, -1}, {25725, -1, -1, -1}, {25717, -1, -1, -1}, {25702, -1, -1, -1}, {25766, -1, -1, -1}, {25678, -1, -1, -1}, {25730, -1, -1, -1}, {25694, -1, -1, -1}, {25692, -1, -1, -1}, {25675, -1, -1, -1}, {25683, -1, -1, -1}, {25696, -1, -1, -1}, {25680, -1, -1, -1}, {25727, -1, -1, -1}, {25663, -1, -1, -1}, {25708, -1, -1, -1}, {25707, -1, -1, -1}, {25689, -1, -1, -1}, {25701, -1, -1, -1}, {25719, -1, -1, -1}, {25971, -1, -1, -1}, {26016, -1, -1, -1}, {26273, -1, -1, -1}, {26272, -1, -1, -1}, {26271, -1, -1, -1}, {26373, -1, -1, -1}, {26372, -1, -1, -1}, {26402, -1, -1, -1}, {27057, -1, -1, -1}, {27062, -1, -1, -1}, {27081, -1, -1, -1}, {27040, -1, -1, -1}, {27086, -1, -1, -1}, {27030, -1, -1, -1}, {27056, -1, -1, -1}, {27052, -1, -1, -1}, {27068, -1, -1, -1}, {27025, -1, -1, -1}, {27033, -1, -1, -1}, {27022, -1, -1, -1}, {27047, -1, -1, -1}, {27021, -1, -1, -1}, {27049, -1, -1, -1}, {27070, -1, -1, -1}, {27055, -1, -1, -1}, {27071, -1, -1, -1}, {27076, -1, -1, -1}, {27069, -1, -1, -1}, {27044, -1, -1, -1}, {27092, -1, -1, -1}, {27065, -1, -1, -1}, {27082, -1, -1, -1}, {27034, -1, -1, -1}, {27087, -1, -1, -1}, {27059, -1, -1, -1}, {27027, -1, -1, -1}, {27050, -1, -1, -1}, {27041, -1, -1, -1}, {27038, -1, -1, -1}, {27097, -1, -1, -1}, {27031, -1, -1, -1}, {27024, -1, -1, -1}, {27074, -1, -1, -1}, {27061, -1, -1, -1}, {27045, -1, -1, -1}, {27078, -1, -1, -1}, {27466, -1, -1, -1}, {27469, -1, -1, -1}, {27467, -1, -1, -1}, {27550, -1, -1, -1}, {27551, -1, -1, -1}, {27552, -1, -1, -1}, {27587, -1, -1, -1}, {27588, -1, -1, -1}, {27646, -1, -1, -1}, {28366, -1, -1, -1}, {28405, -1, -1, -1}, {28401, -1, -1, -1}, {28419, -1, -1, -1}, {28453, -1, -1, -1}, {28408, -1, -1, -1}, {28471, -1, -1, -1}, {28411, -1, -1, -1}, {28462, -1, -1, -1}, {28425, -1, -1, -1}, {28494, -1, -1, -1}, {28441, -1, -1, -1}, {28442, -1, -1, -1}, {28455, -1, -1, -1}, {28440, -1, -1, -1}, {28475, -1, -1, -1}, {28434, -1, -1, -1}, {28397, -1, -1, -1}, {28426, -1, -1, -1}, {28470, -1, -1, -1}, {28531, -1, -1, -1} },
    {{28409, -1, -1, -1}, {28398, -1, -1, -1}, {28461, -1, -1, -1}, {28480, -1, -1, -1}, {28464, -1, -1, -1}, {28476, -1, -1, -1}, {28469, -1, -1, -1}, {28395, -1, -1, -1}, {28423, -1, -1, -1}, {28430, -1, -1, -1}, {28483, -1, -1, -1}, {28421, -1, -1, -1}, {28413, -1, -1, -1}, {28406, -1, -1, -1}, {28473, -1, -1, -1}, {28444, -1, -1, -1}, {28412, -1, -1, -1}, {28474, -1, -1, -1}, {28447, -1, -1, -1}, {28429, -1, -1, -1}, {28446, -1, -1, -1}, {28424, -1, -1, -1}, {28449, -1, -1, -1}, {29063, -1, -1, -1}, {29072, -1, -1, -1}, {29065, -1, -1, -1}, {29056, -1, -1, -1}, {29061, -1, -1, -1}, {29058, -1, -1, -1}, {29071, -1, -1, -1}, {29051, -1, -1, -1}, {29062, -1, -1, -1}, {29057, -1, -1, -1}, {29079, -1, -1, -1}, {29252, -1, -1, -1}, {29267, -1, -1, -1}, {29335, -1, -1, -1}, {29333, -1, -1, -1}, {29331, -1, -1, -1}, {29507, -1, -1, -1}, {29517, -1, -1, -1}, {29521, -1, -1, -1}, {29516, -1, -1, -1}, {29794, -1, -1, -1}, {29811, -1, -1, -1}, {29809, -1, -1, -1}, {29813, -1, -1, -1}, {29810, -1, -1, -1}, {29799, -1, -1, -1}, {29806, -1, -1, -1}, {29952, -1, -1, -1}, {29954, -1, -1, -1}, {29955, -1, -1, -1}, {30077, -1, -1, -1}, {30096, -1, -1, -1}, {30230, -1, -1, -1}, {30216, -1, -1, -1}, {30220, -1, -1, -1}, {30229, -1, -1, -1}, {30225, -1, -1, -1}, {30218, -1, -1, -1}, {30228, -1, -1, -1}, {30392, -1, -1, -1}, {30593, -1, -1, -1}, {30588, -1, -1, -1}, {30597, -1, -1, -1}, {30594, -1, -1, -1}, {30574, -1, -1, -1}, {30592, -1, -1, -1}, {30575, -1, -1, -1}, {30590, -1, -1, -1}, {30595, -1, -1, -1}, {30898, -1, -1, -1}, {30890, -1, -1, -1}, {30900, -1, -1, -1}, {30893, -1, -1, -1}, {30888, -1, -1, -1}, {30846, -1, -1, -1}, {30891, -1, -1, -1}, {30878, -1, -1, -1}, {30885, -1, -1, -1}, {30880, -1, -1, -1}, {30892, -1, -1, -1}, {30882, -1, -1, -1}, {30884, -1, -1, -1}, {31128, -1, -1, -1}, {31114, -1, -1, -1}, {31115, -1, -1, -1}, {31126, -1, -1, -1}, {31125, -1, -1, -1}, {31124, -1, -1, -1}, {31123, -1, -1, -1}, {31127, -1, -1, -1}, {31112, -1, -1, -1}, {31122, -1, -1, -1}, {31120, -1, -1, -1}, {31275, -1, -1, -1}, {31306, -1, -1, -1}, {31280, -1, -1, -1}, {31279, -1, -1, -1}, {31272, -1, -1, -1}, {31270, -1, -1, -1}, {31400, -1, -1, -1}, {31403, -1, -1, -1}, {31404, -1, -1, -1}, {31470, -1, -1, -1}, {31624, -1, -1, -1}, {31644, -1, -1, -1}, {31626, -1, -1, -1}, {31633, -1, -1, -1}, {31632, -1, -1, -1}, {31638, -1, -1, -1}, {31629, -1, -1, -1}, {31628, -1, -1, -1}, {31643, -1, -1, -1}, {31630, -1, -1, -1}, {31621, -1, -1, -1}, {31640, -1, -1, -1}, {21124, -1, -1, -1}, {31641, -1, -1, -1}, {31652, -1, -1, -1}, {31618, -1, -1, -1}, {31931, -1, -1, -1}, {31935, -1, -1, -1}, {31932, -1, -1, -1}, {31930, -1, -1, -1}, {32167, -1, -1, -1}, {32183, -1, -1, -1}, {32194, -1, -1, -1}, {32163, -1, -1, -1}, {32170, -1, -1, -1}, {32193, -1, -1, -1}, {32192, -1, -1, -1}, {32197, -1, -1, -1}, {32157, -1, -1, -1}, {32206, -1, -1, -1}, {32196, -1, -1, -1}, {32198, -1, -1, -1}, {32203, -1, -1, -1}, {32204, -1, -1, -1}, {32175, -1, -1, -1}, {32185, -1, -1, -1}, {32150, -1, -1, -1}, {32188, -1, -1, -1}, {32159, -1, -1, -1}, {32166, -1, -1, -1}, {32174, -1, -1, -1}, {32169, -1, -1, -1}, {32161, -1, -1, -1}, {32201, -1, -1, -1}, {32627, -1, -1, -1}, {32738, -1, -1, -1}, {32739, -1, -1, -1}, {32741, -1, -1, -1}, {32734, -1, -1, -1}, {32804, -1, -1, -1}, {32861, -1, -1, -1}, {32860, -1, -1, -1}, {33161, -1, -1, -1}, {33158, -1, -1, -1}, {33155, -1, -1, -1}, {33159, -1, -1, -1}, {33165, -1, -1, -1}, {33164, -1, -1, -1}, {33163, -1, -1, -1}, {33301, -1, -1, -1}, {33943, -1, -1, -1}, {33956, -1, -1, -1}, {33953, -1, -1, -1}, {33951, -1, -1, -1}, {33978, -1, -1, -1}, {33998, -1, -1, -1}, {33986, -1, -1, -1}, {33964, -1, -1, -1}, {33966, -1, -1, -1}, {33963, -1, -1, -1}, {33977, -1, -1, -1}, {33972, -1, -1, -1}, {33985, -1, -1, -1}, {33997, -1, -1, -1}, {33962, -1, -1, -1}, {33946, -1, -1, -1}, {33969, -1, -1, -1}, {34000, -1, -1, -1}, {33949, -1, -1, -1}, {33959, -1, -1, -1}, {33979, -1, -1, -1}, {33954, -1, -1, -1}, {33940, -1, -1, -1}, {33991, -1, -1, -1}, {33996, -1, -1, -1}, {33947, -1, -1, -1}, {33961, -1, -1, -1}, {33967, -1, -1, -1}, {33960, -1, -1, -1}, {34006, -1, -1, -1}, {33944, -1, -1, -1}, {33974, -1, -1, -1}, {33999, -1, -1, -1}, {33952, -1, -1, -1}, {34007, -1, -1, -1}, {34004, -1, -1, -1}, {34002, -1, -1, -1}, {34011, -1, -1, -1}, {33968, -1, -1, -1}, {33937, -1, -1, -1}, {34401, -1, -1, -1}, {34611, -1, -1, -1}, {34595, -1, -1, -1}, {34600, -1, -1, -1}, {34667, -1, -1, -1}, {34624, -1, -1, -1}, {34606, -1, -1, -1}, {34590, -1, -1, -1}, {34593, -1, -1, -1}, {34585, -1, -1, -1}, {34587, -1, -1, -1}, {34627, -1, -1, -1}, {34604, -1, -1, -1}, {34625, -1, -1, -1}, {34622, -1, -1, -1}, {34630, -1, -1, -1}, {34592, -1, -1, -1}, {34610, -1, -1, -1}, {34602, -1, -1, -1}, {34605, -1, -1, -1}, {34620, -1, -1, -1}, {34578, -1, -1, -1}, {34618, -1, -1, -1}, {34609, -1, -1, -1}, {34613, -1, -1, -1}, {34626, -1, -1, -1}, {34598, -1, -1, -1}, {34599, -1, -1, -1}, {34616, -1, -1, -1}, {34596, -1, -1, -1}, {34586, -1, -1, -1}, {34608, -1, -1, -1}, {34577, -1, -1, -1}, {35063, -1, -1, -1}, {35047, -1, -1, -1}, {35057, -1, -1, -1}, {35058, -1, -1, -1}, {35066, -1, -1, -1}, {35070, -1, -1, -1}, {35054, -1, -1, -1}, {35068, -1, -1, -1}, {35062, -1, -1, -1}, {35067, -1, -1, -1}, {35056, -1, -1, -1}, {35052, -1, -1, -1}, {35051, -1, -1, -1}, {35229, -1, -1, -1}, {35233, -1, -1, -1}, {35231, -1, -1, -1}, {35230, -1, -1, -1} },
    {{35305, -1, -1, -1}, {35307, -1, -1, -1}, {35304, -1, -1, -1}, {35499, -1, -1, -1}, {35481, -1, -1, -1}, {35467, -1, -1, -1}, {35474, -1, -1, -1}, {35471, -1, -1, -1}, {35478, -1, -1, -1}, {35901, -1, -1, -1}, {35944, -1, -1, -1}, {35945, -1, -1, -1}, {36053, -1, -1, -1}, {36047, -1, -1, -1}, {36055, -1, -1, -1}, {36246, -1, -1, -1}, {36361, -1, -1, -1}, {36354, -1, -1, -1}, {36351, -1, -1, -1}, {36365, -1, -1, -1}, {36349, -1, -1, -1}, {36362, -1, -1, -1}, {36355, -1, -1, -1}, {36359, -1, -1, -1}, {36358, -1, -1, -1}, {36357, -1, -1, -1}, {36350, -1, -1, -1}, {36352, -1, -1, -1}, {36356, -1, -1, -1}, {36624, -1, -1, -1}, {36625, -1, -1, -1}, {36622, -1, -1, -1}, {36621, -1, -1, -1}, {37155, -1, -1, -1}, {37148, -1, -1, -1}, {37152, -1, -1, -1}, {37154, -1, -1, -1}, {37151, -1, -1, -1}, {37149, -1, -1, -1}, {37146, -1, -1, -1}, {37156, -1, -1, -1}, {37153, -1, -1, -1}, {37147, -1, -1, -1}, {37242, -1, -1, -1}, {37234, -1, -1, -1}, {37241, -1, -1, -1}, {37235, -1, -1, -1}, {37541, -1, -1, -1}, {37540, -1, -1, -1}, {37494, -1, -1, -1}, {37531, -1, -1, -1}, {37498, -1, -1, -1}, {37536, -1, -1, -1}, {37524, -1, -1, -1}, {37546, -1, -1, -1}, {37517, -1, -1, -1}, {37542, -1, -1, -1}, {37530, -1, -1, -1}, {37547, -1, -1, -1}, {37497, -1, -1, -1}, {37527, -1, -1, -1}, {37503, -1, -1, -1}, {37539, -1, -1, -1}, {37614, -1, -1, -1}, {37518, -1, -1, -1}, {37506, -1, -1, -1}, {37525, -1, -1, -1}, {37538, -1, -1, -1}, {37501, -1, -1, -1}, {37512, -1, -1, -1}, {37537, -1, -1, -1}, {37514, -1, -1, -1}, {37510, -1, -1, -1}, {37516, -1, -1, -1}, {37529, -1, -1, -1}, {37543, -1, -1, -1}, {37502, -1, -1, -1}, {37511, -1, -1, -1}, {37545, -1, -1, -1}, {37533, -1, -1, -1}, {37515, -1, -1, -1}, {37421, -1, -1, -1}, {38558, -1, -1, -1}, {38561, -1, -1, -1}, {38655, -1, -1, -1}, {38744, -1, -1, -1}, {38781, -1, -1, -1}, {38778, -1, -1, -1}, {38782, -1, -1, -1}, {38787, -1, -1, -1}, {38784, -1, -1, -1}, {38786, -1, -1, -1}, {38779, -1, -1, -1}, {38788, -1, -1, -1}, {38785, -1, -1, -1}, {38783, -1, -1, -1}, {38862, -1, -1, -1}, {38861, -1, -1, -1}, {38934, -1, -1, -1}, {39085, -1, -1, -1}, {39086, -1, -1, -1}, {39170, -1, -1, -1}, {39168, -1, -1, -1}, {39175, -1, -1, -1}, {39325, -1, -1, -1}, {39324, -1, -1, -1}, {39363, -1, -1, -1}, {39353, -1, -1, -1}, {39355, -1, -1, -1}, {39354, -1, -1, -1}, {39362, -1, -1, -1}, {39357, -1, -1, -1}, {39367, -1, -1, -1}, {39601, -1, -1, -1}, {39651, -1, -1, -1}, {39655, -1, -1, -1}, {39742, -1, -1, -1}, {39743, -1, -1, -1}, {39776, -1, -1, -1}, {39777, -1, -1, -1}, {39775, -1, -1, -1}, {40177, -1, -1, -1}, {40178, -1, -1, -1}, {40181, -1, -1, -1}, {40615, -1, -1, -1}, {20735, -1, -1, -1}, {20739, -1, -1, -1}, {20784, -1, -1, -1}, {20728, -1, -1, -1}, {20742, -1, -1, -1}, {20743, -1, -1, -1}, {20726, -1, -1, -1}, {20734, -1, -1, -1}, {20747, -1, -1, -1}, {20748, -1, -1, -1}, {20733, -1, -1, -1}, {20746, -1, -1, -1}, {21131, -1, -1, -1}, {21132, -1, -1, -1}, {21233, -1, -1, -1}, {21231, -1, -1, -1}, {22088, -1, -1, -1}, {22082, -1, -1, -1}, {22092, -1, -1, -1}, {22069, -1, -1, -1}, {22081, -1, -1, -1}, {22090, -1, -1, -1}, {22089, -1, -1, -1}, {22086, -1, -1, -1}, {22104, -1, -1, -1}, {22106, -1, -1, -1}, {22080, -1, -1, -1}, {22067, -1, -1, -1}, {22077, -1, -1, -1}, {22060, -1, -1, -1}, {22078, -1, -1, -1}, {22072, -1, -1, -1}, {22058, -1, -1, -1}, {22074, -1, -1, -1}, {22298, -1, -1, -1}, {22699, -1, -1, -1}, {22685, -1, -1, -1}, {22705, -1, -1, -1}, {22688, -1, -1, -1}, {22691, -1, -1, -1}, {22703, -1, -1, -1}, {22700, -1, -1, -1}, {22693, -1, -1, -1}, {22689, -1, -1, -1}, {22783, -1, -1, -1}, {23295, -1, -1, -1}, {23284, -1, -1, -1}, {23293, -1, -1, -1}, {23287, -1, -1, -1}, {23286, -1, -1, -1}, {23299, -1, -1, -1}, {23288, -1, -1, -1}, {23298, -1, -1, -1}, {23289, -1, -1, -1}, {23297, -1, -1, -1}, {23303, -1, -1, -1}, {23301, -1, -1, -1}, {23311, -1, -1, -1}, {23655, -1, -1, -1}, {23961, -1, -1, -1}, {23959, -1, -1, -1}, {23967, -1, -1, -1}, {23954, -1, -1, -1}, {23970, -1, -1, -1}, {23955, -1, -1, -1}, {23957, -1, -1, -1}, {23968, -1, -1, -1}, {23964, -1, -1, -1}, {23969, -1, -1, -1}, {23962, -1, -1, -1}, {23966, -1, -1, -1}, {24169, -1, -1, -1}, {24157, -1, -1, -1}, {24160, -1, -1, -1}, {24156, -1, -1, -1}, {32243, -1, -1, -1}, {24283, -1, -1, -1}, {24286, -1, -1, -1}, {24289, -1, -1, -1}, {24393, -1, -1, -1}, {24498, -1, -1, -1}, {24971, -1, -1, -1}, {24963, -1, -1, -1}, {24953, -1, -1, -1}, {25009, -1, -1, -1}, {25008, -1, -1, -1}, {24994, -1, -1, -1}, {24969, -1, -1, -1}, {24987, -1, -1, -1}, {24979, -1, -1, -1}, {25007, -1, -1, -1}, {25005, -1, -1, -1}, {24991, -1, -1, -1}, {24978, -1, -1, -1}, {25002, -1, -1, -1}, {24993, -1, -1, -1}, {24973, -1, -1, -1}, {24934, -1, -1, -1}, {25011, -1, -1, -1}, {25133, -1, -1, -1}, {25710, -1, -1, -1}, {25712, -1, -1, -1}, {25750, -1, -1, -1}, {25760, -1, -1, -1}, {25733, -1, -1, -1}, {25751, -1, -1, -1}, {25756, -1, -1, -1}, {25743, -1, -1, -1}, {25739, -1, -1, -1}, {25738, -1, -1, -1}, {25740, -1, -1, -1}, {25763, -1, -1, -1}, {25759, -1, -1, -1}, {25704, -1, -1, -1}, {25777, -1, -1, -1}, {25752, -1, -1, -1}, {25974, -1, -1, -1}, {25978, -1, -1, -1}, {25977, -1, -1, -1}, {25979, -1, -1, -1}, {26034, -1, -1, -1}, {26035, -1, -1, -1}, {26293, -1, -1, -1}, {26288, -1, -1, -1}, {26281, -1, -1, -1}, {26290, -1, -1, -1}, {26295, -1, -1, -1}, {26282, -1, -1, -1}, {26287, -1, -1, -1}, {27136, -1, -1, -1}, {27142, -1, -1, -1} },
    {{27159, -1, -1, -1}, {27109, -1, -1, -1}, {27128, -1, -1, -1}, {27157, -1, -1, -1}, {27121, -1, -1, -1}, {27108, -1, -1, -1}, {27168, -1, -1, -1}, {27135, -1, -1, -1}, {27116, -1, -1, -1}, {27106, -1, -1, -1}, {27163, -1, -1, -1}, {27165, -1, -1, -1}, {27134, -1, -1, -1}, {27175, -1, -1, -1}, {27122, -1, -1, -1}, {27118, -1, -1, -1}, {27156, -1, -1, -1}, {27127, -1, -1, -1}, {27111, -1, -1, -1}, {27200, -1, -1, -1}, {27144, -1, -1, -1}, {27110, -1, -1, -1}, {27131, -1, -1, -1}, {27149, -1, -1, -1}, {27132, -1, -1, -1}, {27115, -1, -1, -1}, {27145, -1, -1, -1}, {27140, -1, -1, -1}, {27160, -1, -1, -1}, {27173, -1, -1, -1}, {27151, -1, -1, -1}, {27126, -1, -1, -1}, {27174, -1, -1, -1}, {27143, -1, -1, -1}, {27124, -1, -1, -1}, {27158, -1, -1, -1}, {27473, -1, -1, -1}, {27557, -1, -1, -1}, {27555, -1, -1, -1}, {27554, -1, -1, -1}, {27558, -1, -1, -1}, {27649, -1, -1, -1}, {27648, -1, -1, -1}, {27647, -1, -1, -1}, {27650, -1, -1, -1}, {28481, -1, -1, -1}, {28454, -1, -1, -1}, {28542, -1, -1, -1}, {28551, -1, -1, -1}, {28614, -1, -1, -1}, {28562, -1, -1, -1}, {28557, -1, -1, -1}, {28553, -1, -1, -1}, {28556, -1, -1, -1}, {28514, -1, -1, -1}, {28495, -1, -1, -1}, {28549, -1, -1, -1}, {28506, -1, -1, -1}, {28566, -1, -1, -1}, {28534, -1, -1, -1}, {28524, -1, -1, -1}, {28546, -1, -1, -1}, {28501, -1, -1, -1}, {28530, -1, -1, -1}, {28498, -1, -1, -1}, {28496, -1, -1, -1}, {28503, -1, -1, -1}, {28564, -1, -1, -1}, {28563, -1, -1, -1}, {28509, -1, -1, -1}, {28416, -1, -1, -1}, {28513, -1, -1, -1}, {28523, -1, -1, -1}, {28541, -1, -1, -1}, {28519, -1, -1, -1}, {28560, -1, -1, -1}, {28499, -1, -1, -1}, {28555, -1, -1, -1}, {28521, -1, -1, -1}, {28543, -1, -1, -1}, {28565, -1, -1, -1}, {28515, -1, -1, -1}, {28535, -1, -1, -1}, {28522, -1, -1, -1}, {28539, -1, -1, -1}, {29106, -1, -1, -1}, {29103, -1, -1, -1}, {29083, -1, -1, -1}, {29104, -1, -1, -1}, {29088, -1, -1, -1}, {29082, -1, -1, -1}, {29097, -1, -1, -1}, {29109, -1, -1, -1}, {29085, -1, -1, -1}, {29093, -1, -1, -1}, {29086, -1, -1, -1}, {29092, -1, -1, -1}, {29089, -1, -1, -1}, {29098, -1, -1, -1}, {29084, -1, -1, -1}, {29095, -1, -1, -1}, {29107, -1, -1, -1}, {29336, -1, -1, -1}, {29338, -1, -1, -1}, {29528, -1, -1, -1}, {29522, -1, -1, -1}, {29534, -1, -1, -1}, {29535, -1, -1, -1}, {29536, -1, -1, -1}, {29533, -1, -1, -1}, {29531, -1, -1, -1}, {29537, -1, -1, -1}, {29530, -1, -1, -1}, {29529, -1, -1, -1}, {29538, -1, -1, -1}, {29831, -1, -1, -1}, {29833, -1, -1, -1}, {29834, -1, -1, -1}, {29830, -1, -1, -1}, {29825, -1, -1, -1}, {29821, -1, -1, -1}, {29829, -1, -1, -1}, {29832, -1, -1, -1}, {29820, -1, -1, -1}, {29817, -1, -1, -1}, {29960, -1, -1, -1}, {29959, -1, -1, -1}, {30078, -1, -1, -1}, {30245, -1, -1, -1}, {30238, -1, -1, -1}, {30233, -1, -1, -1}, {30237, -1, -1, -1}, {30236, -1, -1, -1}, {30243, -1, -1, -1}, {30234, -1, -1, -1}, {30248, -1, -1, -1}, {30235, -1, -1, -1}, {30364, -1, -1, -1}, {30365, -1, -1, -1}, {30366, -1, -1, -1}, {30363, -1, -1, -1}, {30605, -1, -1, -1}, {30607, -1, -1, -1}, {30601, -1, -1, -1}, {30600, -1, -1, -1}, {30925, -1, -1, -1}, {30907, -1, -1, -1}, {30927, -1, -1, -1}, {30924, -1, -1, -1}, {30929, -1, -1, -1}, {30926, -1, -1, -1}, {30932, -1, -1, -1}, {30920, -1, -1, -1}, {30915, -1, -1, -1}, {30916, -1, -1, -1}, {30921, -1, -1, -1}, {31130, -1, -1, -1}, {31137, -1, -1, -1}, {31136, -1, -1, -1}, {31132, -1, -1, -1}, {31138, -1, -1, -1}, {31131, -1, -1, -1}, {27510, -1, -1, -1}, {31289, -1, -1, -1}, {31410, -1, -1, -1}, {31412, -1, -1, -1}, {31411, -1, -1, -1}, {31671, -1, -1, -1}, {31691, -1, -1, -1}, {31678, -1, -1, -1}, {31660, -1, -1, -1}, {31694, -1, -1, -1}, {31663, -1, -1, -1}, {31673, -1, -1, -1}, {31690, -1, -1, -1}, {31669, -1, -1, -1}, {31941, -1, -1, -1}, {31944, -1, -1, -1}, {31948, -1, -1, -1}, {31947, -1, -1, -1}, {32247, -1, -1, -1}, {32219, -1, -1, -1}, {32234, -1, -1, -1}, {32231, -1, -1, -1}, {32215, -1, -1, -1}, {32225, -1, -1, -1}, {32259, -1, -1, -1}, {32250, -1, -1, -1}, {32230, -1, -1, -1}, {32246, -1, -1, -1}, {32241, -1, -1, -1}, {32240, -1, -1, -1}, {32238, -1, -1, -1}, {32223, -1, -1, -1}, {32630, -1, -1, -1}, {32684, -1, -1, -1}, {32688, -1, -1, -1}, {32685, -1, -1, -1}, {32749, -1, -1, -1}, {32747, -1, -1, -1}, {32746, -1, -1, -1}, {32748, -1, -1, -1}, {32742, -1, -1, -1}, {32744, -1, -1, -1}, {32868, -1, -1, -1}, {32871, -1, -1, -1}, {33187, -1, -1, -1}, {33183, -1, -1, -1}, {33182, -1, -1, -1}, {33173, -1, -1, -1}, {33186, -1, -1, -1}, {33177, -1, -1, -1}, {33175, -1, -1, -1}, {33302, -1, -1, -1}, {33359, -1, -1, -1}, {33363, -1, -1, -1}, {33362, -1, -1, -1}, {33360, -1, -1, -1}, {33358, -1, -1, -1}, {33361, -1, -1, -1}, {34084, -1, -1, -1}, {34107, -1, -1, -1}, {34063, -1, -1, -1}, {34048, -1, -1, -1}, {34089, -1, -1, -1}, {34062, -1, -1, -1}, {34057, -1, -1, -1}, {34061, -1, -1, -1}, {34079, -1, -1, -1}, {34058, -1, -1, -1}, {34087, -1, -1, -1}, {34076, -1, -1, -1}, {34043, -1, -1, -1}, {34091, -1, -1, -1}, {34042, -1, -1, -1}, {34056, -1, -1, -1}, {34060, -1, -1, -1}, {34036, -1, -1, -1}, {34090, -1, -1, -1}, {34034, -1, -1, -1}, {34069, -1, -1, -1}, {34039, -1, -1, -1}, {34027, -1, -1, -1}, {34035, -1, -1, -1}, {34044, -1, -1, -1}, {34066, -1, -1, -1}, {34026, -1, -1, -1}, {34025, -1, -1, -1}, {34070, -1, -1, -1}, {34046, -1, -1, -1}, {34088, -1, -1, -1}, {34077, -1, -1, -1}, {34094, -1, -1, -1}, {34050, -1, -1, -1}, {34045, -1, -1, -1}, {34078, -1, -1, -1} },
    {{34038, -1, -1, -1}, {34097, -1, -1, -1}, {34086, -1, -1, -1}, {34023, -1, -1, -1}, {34024, -1, -1, -1}, {34032, -1, -1, -1}, {34031, -1, -1, -1}, {34041, -1, -1, -1}, {34072, -1, -1, -1}, {34080, -1, -1, -1}, {34096, -1, -1, -1}, {34059, -1, -1, -1}, {34073, -1, -1, -1}, {34095, -1, -1, -1}, {34402, -1, -1, -1}, {34646, -1, -1, -1}, {34659, -1, -1, -1}, {34660, -1, -1, -1}, {34679, -1, -1, -1}, {34785, -1, -1, -1}, {34675, -1, -1, -1}, {34648, -1, -1, -1}, {34644, -1, -1, -1}, {34651, -1, -1, -1}, {34642, -1, -1, -1}, {34657, -1, -1, -1}, {34650, -1, -1, -1}, {34641, -1, -1, -1}, {34654, -1, -1, -1}, {34669, -1, -1, -1}, {34666, -1, -1, -1}, {34640, -1, -1, -1}, {34638, -1, -1, -1}, {34655, -1, -1, -1}, {34653, -1, -1, -1}, {34671, -1, -1, -1}, {34668, -1, -1, -1}, {34682, -1, -1, -1}, {34670, -1, -1, -1}, {34652, -1, -1, -1}, {34661, -1, -1, -1}, {34639, -1, -1, -1}, {34683, -1, -1, -1}, {34677, -1, -1, -1}, {34658, -1, -1, -1}, {34663, -1, -1, -1}, {34665, -1, -1, -1}, {34906, -1, -1, -1}, {35077, -1, -1, -1}, {35084, -1, -1, -1}, {35092, -1, -1, -1}, {35083, -1, -1, -1}, {35095, -1, -1, -1}, {35096, -1, -1, -1}, {35097, -1, -1, -1}, {35078, -1, -1, -1}, {35094, -1, -1, -1}, {35089, -1, -1, -1}, {35086, -1, -1, -1}, {35081, -1, -1, -1}, {35234, -1, -1, -1}, {35236, -1, -1, -1}, {35235, -1, -1, -1}, {35309, -1, -1, -1}, {35312, -1, -1, -1}, {35308, -1, -1, -1}, {35535, -1, -1, -1}, {35526, -1, -1, -1}, {35512, -1, -1, -1}, {35539, -1, -1, -1}, {35537, -1, -1, -1}, {35540, -1, -1, -1}, {35541, -1, -1, -1}, {35515, -1, -1, -1}, {35543, -1, -1, -1}, {35518, -1, -1, -1}, {35520, -1, -1, -1}, {35525, -1, -1, -1}, {35544, -1, -1, -1}, {35523, -1, -1, -1}, {35514, -1, -1, -1}, {35517, -1, -1, -1}, {35545, -1, -1, -1}, {35902, -1, -1, -1}, {35917, -1, -1, -1}, {35983, -1, -1, -1}, {36069, -1, -1, -1}, {36063, -1, -1, -1}, {36057, -1, -1, -1}, {36072, -1, -1, -1}, {36058, -1, -1, -1}, {36061, -1, -1, -1}, {36071, -1, -1, -1}, {36256, -1, -1, -1}, {36252, -1, -1, -1}, {36257, -1, -1, -1}, {36251, -1, -1, -1}, {36384, -1, -1, -1}, {36387, -1, -1, -1}, {36389, -1, -1, -1}, {36388, -1, -1, -1}, {36398, -1, -1, -1}, {36373, -1, -1, -1}, {36379, -1, -1, -1}, {36374, -1, -1, -1}, {36369, -1, -1, -1}, {36377, -1, -1, -1}, {36390, -1, -1, -1}, {36391, -1, -1, -1}, {36372, -1, -1, -1}, {36370, -1, -1, -1}, {36376, -1, -1, -1}, {36371, -1, -1, -1}, {36380, -1, -1, -1}, {36375, -1, -1, -1}, {36378, -1, -1, -1}, {36652, -1, -1, -1}, {36644, -1, -1, -1}, {36632, -1, -1, -1}, {36634, -1, -1, -1}, {36640, -1, -1, -1}, {36643, -1, -1, -1}, {36630, -1, -1, -1}, {36631, -1, -1, -1}, {36979, -1, -1, -1}, {36976, -1, -1, -1}, {36975, -1, -1, -1}, {36967, -1, -1, -1}, {36971, -1, -1, -1}, {37167, -1, -1, -1}, {37163, -1, -1, -1}, {37161, -1, -1, -1}, {37162, -1, -1, -1}, {37170, -1, -1, -1}, {37158, -1, -1, -1}, {37166, -1, -1, -1}, {37253, -1, -1, -1}, {37254, -1, -1, -1}, {37258, -1, -1, -1}, {37249, -1, -1, -1}, {37250, -1, -1, -1}, {37252, -1, -1, -1}, {37248, -1, -1, -1}, {37584, -1, -1, -1}, {37571, -1, -1, -1}, {37572, -1, -1, -1}, {37568, -1, -1, -1}, {37593, -1, -1, -1}, {37558, -1, -1, -1}, {37583, -1, -1, -1}, {37617, -1, -1, -1}, {37599, -1, -1, -1}, {37592, -1, -1, -1}, {37609, -1, -1, -1}, {37591, -1, -1, -1}, {37597, -1, -1, -1}, {37580, -1, -1, -1}, {37615, -1, -1, -1}, {37570, -1, -1, -1}, {37608, -1, -1, -1}, {37578, -1, -1, -1}, {37576, -1, -1, -1}, {37582, -1, -1, -1}, {37606, -1, -1, -1}, {37581, -1, -1, -1}, {37589, -1, -1, -1}, {37577, -1, -1, -1}, {37600, -1, -1, -1}, {37598, -1, -1, -1}, {37607, -1, -1, -1}, {37585, -1, -1, -1}, {37587, -1, -1, -1}, {37557, -1, -1, -1}, {37601, -1, -1, -1}, {37669, -1, -1, -1}, {37574, -1, -1, -1}, {37556, -1, -1, -1}, {38268, -1, -1, -1}, {38316, -1, -1, -1}, {38315, -1, -1, -1}, {38318, -1, -1, -1}, {38320, -1, -1, -1}, {38564, -1, -1, -1}, {38562, -1, -1, -1}, {38611, -1, -1, -1}, {38661, -1, -1, -1}, {38664, -1, -1, -1}, {38658, -1, -1, -1}, {38746, -1, -1, -1}, {38794, -1, -1, -1}, {38798, -1, -1, -1}, {38792, -1, -1, -1}, {38864, -1, -1, -1}, {38863, -1, -1, -1}, {38942, -1, -1, -1}, {38941, -1, -1, -1}, {38950, -1, -1, -1}, {38953, -1, -1, -1}, {38952, -1, -1, -1}, {38944, -1, -1, -1}, {38939, -1, -1, -1}, {38951, -1, -1, -1}, {39090, -1, -1, -1}, {39176, -1, -1, -1}, {39162, -1, -1, -1}, {39185, -1, -1, -1}, {39188, -1, -1, -1}, {39190, -1, -1, -1}, {39191, -1, -1, -1}, {39189, -1, -1, -1}, {39388, -1, -1, -1}, {39373, -1, -1, -1}, {39375, -1, -1, -1}, {39379, -1, -1, -1}, {39380, -1, -1, -1}, {39374, -1, -1, -1}, {39369, -1, -1, -1}, {39382, -1, -1, -1}, {39384, -1, -1, -1}, {39371, -1, -1, -1}, {39383, -1, -1, -1}, {39372, -1, -1, -1}, {39603, -1, -1, -1}, {39660, -1, -1, -1}, {39659, -1, -1, -1}, {39667, -1, -1, -1}, {39666, -1, -1, -1}, {39665, -1, -1, -1}, {39750, -1, -1, -1}, {39747, -1, -1, -1}, {39783, -1, -1, -1}, {39796, -1, -1, -1}, {39793, -1, -1, -1}, {39782, -1, -1, -1}, {39798, -1, -1, -1}, {39797, -1, -1, -1}, {39792, -1, -1, -1}, {39784, -1, -1, -1}, {39780, -1, -1, -1}, {39788, -1, -1, -1}, {40188, -1, -1, -1}, {40186, -1, -1, -1}, {40189, -1, -1, -1}, {40191, -1, -1, -1}, {40183, -1, -1, -1}, {40199, -1, -1, -1}, {40192, -1, -1, -1}, {40185, -1, -1, -1}, {40187, -1, -1, -1}, {40200, -1, -1, -1}, {40197, -1, -1, -1}, {40196, -1, -1, -1}, {40579, -1, -1, -1}, {40659, -1, -1, -1}, {40719, -1, -1, -1}, {40720, -1, -1, -1} },
    {{20764, -1, -1, -1}, {20755, -1, -1, -1}, {20759, -1, -1, -1}, {20762, -1, -1, -1}, {20753, -1, -1, -1}, {20958, -1, -1, -1}, {21300, -1, -1, -1}, {21473, -1, -1, -1}, {22128, -1, -1, -1}, {22112, -1, -1, -1}, {22126, -1, -1, -1}, {22131, -1, -1, -1}, {22118, -1, -1, -1}, {22115, -1, -1, -1}, {22125, -1, -1, -1}, {22130, -1, -1, -1}, {22110, -1, -1, -1}, {22135, -1, -1, -1}, {22300, -1, -1, -1}, {22299, -1, -1, -1}, {22728, -1, -1, -1}, {22717, -1, -1, -1}, {22729, -1, -1, -1}, {22719, -1, -1, -1}, {22714, -1, -1, -1}, {22722, -1, -1, -1}, {22716, -1, -1, -1}, {22726, -1, -1, -1}, {23319, -1, -1, -1}, {23321, -1, -1, -1}, {23323, -1, -1, -1}, {23329, -1, -1, -1}, {23316, -1, -1, -1}, {23315, -1, -1, -1}, {23312, -1, -1, -1}, {23318, -1, -1, -1}, {23336, -1, -1, -1}, {23322, -1, -1, -1}, {23328, -1, -1, -1}, {23326, -1, -1, -1}, {23535, -1, -1, -1}, {23980, -1, -1, -1}, {23985, -1, -1, -1}, {23977, -1, -1, -1}, {23975, -1, -1, -1}, {23989, -1, -1, -1}, {23984, -1, -1, -1}, {23982, -1, -1, -1}, {23978, -1, -1, -1}, {23976, -1, -1, -1}, {23986, -1, -1, -1}, {23981, -1, -1, -1}, {23983, -1, -1, -1}, {23988, -1, -1, -1}, {24167, -1, -1, -1}, {24168, -1, -1, -1}, {24166, -1, -1, -1}, {24175, -1, -1, -1}, {24297, -1, -1, -1}, {24295, -1, -1, -1}, {24294, -1, -1, -1}, {24296, -1, -1, -1}, {24293, -1, -1, -1}, {24395, -1, -1, -1}, {24508, -1, -1, -1}, {24507, -1, -1, -1}, {24989, -1, -1, -1}, {25000, -1, -1, -1}, {24982, -1, -1, -1}, {25029, -1, -1, -1}, {25012, -1, -1, -1}, {25030, -1, -1, -1}, {25025, -1, -1, -1}, {25036, -1, -1, -1}, {25018, -1, -1, -1}, {25023, -1, -1, -1}, {25016, -1, -1, -1}, {24972, -1, -1, -1}, {25815, -1, -1, -1}, {25814, -1, -1, -1}, {25808, -1, -1, -1}, {25807, -1, -1, -1}, {25801, -1, -1, -1}, {25789, -1, -1, -1}, {25737, -1, -1, -1}, {25795, -1, -1, -1}, {25819, -1, -1, -1}, {25843, -1, -1, -1}, {25817, -1, -1, -1}, {25907, -1, -1, -1}, {25983, -1, -1, -1}, {25980, -1, -1, -1}, {26018, -1, -1, -1}, {26312, -1, -1, -1}, {26302, -1, -1, -1}, {26304, -1, -1, -1}, {26314, -1, -1, -1}, {26315, -1, -1, -1}, {26319, -1, -1, -1}, {26301, -1, -1, -1}, {26299, -1, -1, -1}, {26298, -1, -1, -1}, {26316, -1, -1, -1}, {26403, -1, -1, -1}, {27188, -1, -1, -1}, {27238, -1, -1, -1}, {27209, -1, -1, -1}, {27239, -1, -1, -1}, {27186, -1, -1, -1}, {27240, -1, -1, -1}, {27198, -1, -1, -1}, {27229, -1, -1, -1}, {27245, -1, -1, -1}, {27254, -1, -1, -1}, {27227, -1, -1, -1}, {27217, -1, -1, -1}, {27176, -1, -1, -1}, {27226, -1, -1, -1}, {27195, -1, -1, -1}, {27199, -1, -1, -1}, {27201, -1, -1, -1}, {27242, -1, -1, -1}, {27236, -1, -1, -1}, {27216, -1, -1, -1}, {27215, -1, -1, -1}, {27220, -1, -1, -1}, {27247, -1, -1, -1}, {27241, -1, -1, -1}, {27232, -1, -1, -1}, {27196, -1, -1, -1}, {27230, -1, -1, -1}, {27222, -1, -1, -1}, {27221, -1, -1, -1}, {27213, -1, -1, -1}, {27214, -1, -1, -1}, {27206, -1, -1, -1}, {27477, -1, -1, -1}, {27476, -1, -1, -1}, {27478, -1, -1, -1}, {27559, -1, -1, -1}, {27562, -1, -1, -1}, {27563, -1, -1, -1}, {27592, -1, -1, -1}, {27591, -1, -1, -1}, {27652, -1, -1, -1}, {27651, -1, -1, -1}, {27654, -1, -1, -1}, {28589, -1, -1, -1}, {28619, -1, -1, -1}, {28579, -1, -1, -1}, {28615, -1, -1, -1}, {28604, -1, -1, -1}, {28622, -1, -1, -1}, {28616, -1, -1, -1}, {28510, -1, -1, -1}, {28612, -1, -1, -1}, {28605, -1, -1, -1}, {28574, -1, -1, -1}, {28618, -1, -1, -1}, {28584, -1, -1, -1}, {28676, -1, -1, -1}, {28581, -1, -1, -1}, {28590, -1, -1, -1}, {28602, -1, -1, -1}, {28588, -1, -1, -1}, {28586, -1, -1, -1}, {28623, -1, -1, -1}, {28607, -1, -1, -1}, {28600, -1, -1, -1}, {28578, -1, -1, -1}, {28617, -1, -1, -1}, {28587, -1, -1, -1}, {28621, -1, -1, -1}, {28591, -1, -1, -1}, {28594, -1, -1, -1}, {28592, -1, -1, -1}, {29125, -1, -1, -1}, {29122, -1, -1, -1}, {29119, -1, -1, -1}, {29112, -1, -1, -1}, {29142, -1, -1, -1}, {29120, -1, -1, -1}, {29121, -1, -1, -1}, {29131, -1, -1, -1}, {29140, -1, -1, -1}, {29130, -1, -1, -1}, {29127, -1, -1, -1}, {29135, -1, -1, -1}, {29117, -1, -1, -1}, {29144, -1, -1, -1}, {29116, -1, -1, -1}, {29126, -1, -1, -1}, {29146, -1, -1, -1}, {29147, -1, -1, -1}, {29341, -1, -1, -1}, {29342, -1, -1, -1}, {29545, -1, -1, -1}, {29542, -1, -1, -1}, {29543, -1, -1, -1}, {29548, -1, -1, -1}, {29541, -1, -1, -1}, {29547, -1, -1, -1}, {29546, -1, -1, -1}, {29823, -1, -1, -1}, {29850, -1, -1, -1}, {29856, -1, -1, -1}, {29844, -1, -1, -1}, {29842, -1, -1, -1}, {29845, -1, -1, -1}, {29857, -1, -1, -1}, {29963, -1, -1, -1}, {30080, -1, -1, -1}, {30255, -1, -1, -1}, {30253, -1, -1, -1}, {30257, -1, -1, -1}, {30269, -1, -1, -1}, {30259, -1, -1, -1}, {30268, -1, -1, -1}, {30261, -1, -1, -1}, {30258, -1, -1, -1}, {30256, -1, -1, -1}, {30395, -1, -1, -1}, {30438, -1, -1, -1}, {30618, -1, -1, -1}, {30621, -1, -1, -1}, {30625, -1, -1, -1}, {30620, -1, -1, -1}, {30619, -1, -1, -1}, {30626, -1, -1, -1}, {30627, -1, -1, -1}, {30613, -1, -1, -1}, {30617, -1, -1, -1}, {30615, -1, -1, -1}, {30941, -1, -1, -1}, {30953, -1, -1, -1}, {30949, -1, -1, -1}, {30954, -1, -1, -1}, {30942, -1, -1, -1}, {30947, -1, -1, -1}, {30939, -1, -1, -1}, {30945, -1, -1, -1}, {30946, -1, -1, -1}, {30957, -1, -1, -1}, {30943, -1, -1, -1}, {30944, -1, -1, -1}, {31140, -1, -1, -1}, {31300, -1, -1, -1}, {31304, -1, -1, -1}, {31303, -1, -1, -1}, {31414, -1, -1, -1}, {31416, -1, -1, -1}, {31413, -1, -1, -1}, {31409, -1, -1, -1}, {31415, -1, -1, -1}, {31710, -1, -1, -1}, {31715, -1, -1, -1} },
    {{31719, -1, -1, -1}, {31709, -1, -1, -1}, {31701, -1, -1, -1}, {31717, -1, -1, -1}, {31706, -1, -1, -1}, {31720, -1, -1, -1}, {31737, -1, -1, -1}, {31700, -1, -1, -1}, {31722, -1, -1, -1}, {31714, -1, -1, -1}, {31708, -1, -1, -1}, {31723, -1, -1, -1}, {31704, -1, -1, -1}, {31711, -1, -1, -1}, {31954, -1, -1, -1}, {31956, -1, -1, -1}, {31959, -1, -1, -1}, {31952, -1, -1, -1}, {31953, -1, -1, -1}, {32274, -1, -1, -1}, {32289, -1, -1, -1}, {32279, -1, -1, -1}, {32268, -1, -1, -1}, {32287, -1, -1, -1}, {32288, -1, -1, -1}, {32275, -1, -1, -1}, {32270, -1, -1, -1}, {32284, -1, -1, -1}, {32277, -1, -1, -1}, {32282, -1, -1, -1}, {32290, -1, -1, -1}, {32267, -1, -1, -1}, {32271, -1, -1, -1}, {32278, -1, -1, -1}, {32269, -1, -1, -1}, {32276, -1, -1, -1}, {32293, -1, -1, -1}, {32292, -1, -1, -1}, {32579, -1, -1, -1}, {32635, -1, -1, -1}, {32636, -1, -1, -1}, {32634, -1, -1, -1}, {32689, -1, -1, -1}, {32751, -1, -1, -1}, {32810, -1, -1, -1}, {32809, -1, -1, -1}, {32876, -1, -1, -1}, {33201, -1, -1, -1}, {33190, -1, -1, -1}, {33198, -1, -1, -1}, {33209, -1, -1, -1}, {33205, -1, -1, -1}, {33195, -1, -1, -1}, {33200, -1, -1, -1}, {33196, -1, -1, -1}, {33204, -1, -1, -1}, {33202, -1, -1, -1}, {33207, -1, -1, -1}, {33191, -1, -1, -1}, {33266, -1, -1, -1}, {33365, -1, -1, -1}, {33366, -1, -1, -1}, {33367, -1, -1, -1}, {34134, -1, -1, -1}, {34117, -1, -1, -1}, {34155, -1, -1, -1}, {34125, -1, -1, -1}, {34131, -1, -1, -1}, {34145, -1, -1, -1}, {34136, -1, -1, -1}, {34112, -1, -1, -1}, {34118, -1, -1, -1}, {34148, -1, -1, -1}, {34113, -1, -1, -1}, {34146, -1, -1, -1}, {34116, -1, -1, -1}, {34129, -1, -1, -1}, {34119, -1, -1, -1}, {34147, -1, -1, -1}, {34110, -1, -1, -1}, {34139, -1, -1, -1}, {34161, -1, -1, -1}, {34126, -1, -1, -1}, {34158, -1, -1, -1}, {34165, -1, -1, -1}, {34133, -1, -1, -1}, {34151, -1, -1, -1}, {34144, -1, -1, -1}, {34188, -1, -1, -1}, {34150, -1, -1, -1}, {34141, -1, -1, -1}, {34132, -1, -1, -1}, {34149, -1, -1, -1}, {34156, -1, -1, -1}, {34403, -1, -1, -1}, {34405, -1, -1, -1}, {34404, -1, -1, -1}, {34724, -1, -1, -1}, {34715, -1, -1, -1}, {34703, -1, -1, -1}, {34711, -1, -1, -1}, {34707, -1, -1, -1}, {34706, -1, -1, -1}, {34696, -1, -1, -1}, {34689, -1, -1, -1}, {34710, -1, -1, -1}, {34712, -1, -1, -1}, {34681, -1, -1, -1}, {34695, -1, -1, -1}, {34723, -1, -1, -1}, {34693, -1, -1, -1}, {34704, -1, -1, -1}, {34705, -1, -1, -1}, {34717, -1, -1, -1}, {34692, -1, -1, -1}, {34708, -1, -1, -1}, {34716, -1, -1, -1}, {34714, -1, -1, -1}, {34697, -1, -1, -1}, {35102, -1, -1, -1}, {35110, -1, -1, -1}, {35120, -1, -1, -1}, {35117, -1, -1, -1}, {35118, -1, -1, -1}, {35111, -1, -1, -1}, {35121, -1, -1, -1}, {35106, -1, -1, -1}, {35113, -1, -1, -1}, {35107, -1, -1, -1}, {35119, -1, -1, -1}, {35116, -1, -1, -1}, {35103, -1, -1, -1}, {35313, -1, -1, -1}, {35552, -1, -1, -1}, {35554, -1, -1, -1}, {35570, -1, -1, -1}, {35572, -1, -1, -1}, {35573, -1, -1, -1}, {35549, -1, -1, -1}, {35604, -1, -1, -1}, {35556, -1, -1, -1}, {35551, -1, -1, -1}, {35568, -1, -1, -1}, {35528, -1, -1, -1}, {35550, -1, -1, -1}, {35553, -1, -1, -1}, {35560, -1, -1, -1}, {35583, -1, -1, -1}, {35567, -1, -1, -1}, {35579, -1, -1, -1}, {35985, -1, -1, -1}, {35986, -1, -1, -1}, {35984, -1, -1, -1}, {36085, -1, -1, -1}, {36078, -1, -1, -1}, {36081, -1, -1, -1}, {36080, -1, -1, -1}, {36083, -1, -1, -1}, {36204, -1, -1, -1}, {36206, -1, -1, -1}, {36261, -1, -1, -1}, {36263, -1, -1, -1}, {36403, -1, -1, -1}, {36414, -1, -1, -1}, {36408, -1, -1, -1}, {36416, -1, -1, -1}, {36421, -1, -1, -1}, {36406, -1, -1, -1}, {36412, -1, -1, -1}, {36413, -1, -1, -1}, {36417, -1, -1, -1}, {36400, -1, -1, -1}, {36415, -1, -1, -1}, {36541, -1, -1, -1}, {36662, -1, -1, -1}, {36654, -1, -1, -1}, {36661, -1, -1, -1}, {36658, -1, -1, -1}, {36665, -1, -1, -1}, {36663, -1, -1, -1}, {36660, -1, -1, -1}, {36982, -1, -1, -1}, {36985, -1, -1, -1}, {36987, -1, -1, -1}, {36998, -1, -1, -1}, {37114, -1, -1, -1}, {37171, -1, -1, -1}, {37173, -1, -1, -1}, {37174, -1, -1, -1}, {37267, -1, -1, -1}, {37264, -1, -1, -1}, {37265, -1, -1, -1}, {37261, -1, -1, -1}, {37263, -1, -1, -1}, {37671, -1, -1, -1}, {37662, -1, -1, -1}, {37640, -1, -1, -1}, {37663, -1, -1, -1}, {37638, -1, -1, -1}, {37647, -1, -1, -1}, {37754, -1, -1, -1}, {37688, -1, -1, -1}, {37692, -1, -1, -1}, {37659, -1, -1, -1}, {37667, -1, -1, -1}, {37650, -1, -1, -1}, {37633, -1, -1, -1}, {37702, -1, -1, -1}, {37677, -1, -1, -1}, {37646, -1, -1, -1}, {37645, -1, -1, -1}, {37579, -1, -1, -1}, {37661, -1, -1, -1}, {37626, -1, -1, -1}, {37651, -1, -1, -1}, {37625, -1, -1, -1}, {37623, -1, -1, -1}, {37684, -1, -1, -1}, {37634, -1, -1, -1}, {37668, -1, -1, -1}, {37631, -1, -1, -1}, {37673, -1, -1, -1}, {37689, -1, -1, -1}, {37685, -1, -1, -1}, {37674, -1, -1, -1}, {37652, -1, -1, -1}, {37644, -1, -1, -1}, {37643, -1, -1, -1}, {37630, -1, -1, -1}, {37641, -1, -1, -1}, {37632, -1, -1, -1}, {37627, -1, -1, -1}, {37654, -1, -1, -1}, {38332, -1, -1, -1}, {38349, -1, -1, -1}, {38334, -1, -1, -1}, {38329, -1, -1, -1}, {38330, -1, -1, -1}, {38326, -1, -1, -1}, {38335, -1, -1, -1}, {38325, -1, -1, -1}, {38333, -1, -1, -1}, {38569, -1, -1, -1}, {38612, -1, -1, -1}, {38667, -1, -1, -1}, {38674, -1, -1, -1}, {38672, -1, -1, -1}, {38809, -1, -1, -1}, {38807, -1, -1, -1}, {38804, -1, -1, -1}, {38896, -1, -1, -1}, {38904, -1, -1, -1}, {38965, -1, -1, -1}, {38959, -1, -1, -1}, {38962, -1, -1, -1}, {39204, -1, -1, -1} },
    {{39199, -1, -1, -1}, {39207, -1, -1, -1}, {39209, -1, -1, -1}, {39326, -1, -1, -1}, {39406, -1, -1, -1}, {39404, -1, -1, -1}, {39397, -1, -1, -1}, {39396, -1, -1, -1}, {39408, -1, -1, -1}, {39395, -1, -1, -1}, {39402, -1, -1, -1}, {39401, -1, -1, -1}, {39399, -1, -1, -1}, {39609, -1, -1, -1}, {39615, -1, -1, -1}, {39604, -1, -1, -1}, {39611, -1, -1, -1}, {39670, -1, -1, -1}, {39674, -1, -1, -1}, {39673, -1, -1, -1}, {39671, -1, -1, -1}, {39731, -1, -1, -1}, {39808, -1, -1, -1}, {39813, -1, -1, -1}, {39815, -1, -1, -1}, {39804, -1, -1, -1}, {39806, -1, -1, -1}, {39803, -1, -1, -1}, {39810, -1, -1, -1}, {39827, -1, -1, -1}, {39826, -1, -1, -1}, {39824, -1, -1, -1}, {39802, -1, -1, -1}, {39829, -1, -1, -1}, {39805, -1, -1, -1}, {39816, -1, -1, -1}, {40229, -1, -1, -1}, {40215, -1, -1, -1}, {40224, -1, -1, -1}, {40222, -1, -1, -1}, {40212, -1, -1, -1}, {40233, -1, -1, -1}, {40221, -1, -1, -1}, {40216, -1, -1, -1}, {40226, -1, -1, -1}, {40208, -1, -1, -1}, {40217, -1, -1, -1}, {40223, -1, -1, -1}, {40584, -1, -1, -1}, {40582, -1, -1, -1}, {40583, -1, -1, -1}, {40622, -1, -1, -1}, {40621, -1, -1, -1}, {40661, -1, -1, -1}, {40662, -1, -1, -1}, {40698, -1, -1, -1}, {40722, -1, -1, -1}, {40765, -1, -1, -1}, {20774, -1, -1, -1}, {20773, -1, -1, -1}, {20770, -1, -1, -1}, {20772, -1, -1, -1}, {20768, -1, -1, -1}, {20777, -1, -1, -1}, {21236, -1, -1, -1}, {22163, -1, -1, -1}, {22156, -1, -1, -1}, {22157, -1, -1, -1}, {22150, -1, -1, -1}, {22148, -1, -1, -1}, {22147, -1, -1, -1}, {22142, -1, -1, -1}, {22146, -1, -1, -1}, {22143, -1, -1, -1}, {22145, -1, -1, -1}, {22742, -1, -1, -1}, {22740, -1, -1, -1}, {22735, -1, -1, -1}, {22738, -1, -1, -1}, {23341, -1, -1, -1}, {23333, -1, -1, -1}, {23346, -1, -1, -1}, {23331, -1, -1, -1}, {23340, -1, -1, -1}, {23335, -1, -1, -1}, {23334, -1, -1, -1}, {23343, -1, -1, -1}, {23342, -1, -1, -1}, {23419, -1, -1, -1}, {23537, -1, -1, -1}, {23538, -1, -1, -1}, {23991, -1, -1, -1}, {24172, -1, -1, -1}, {24170, -1, -1, -1}, {24510, -1, -1, -1}, {25027, -1, -1, -1}, {25013, -1, -1, -1}, {25020, -1, -1, -1}, {25063, -1, -1, -1}, {25056, -1, -1, -1}, {25061, -1, -1, -1}, {25060, -1, -1, -1}, {25064, -1, -1, -1}, {25054, -1, -1, -1}, {25839, -1, -1, -1}, {25833, -1, -1, -1}, {25827, -1, -1, -1}, {25835, -1, -1, -1}, {25828, -1, -1, -1}, {25832, -1, -1, -1}, {25985, -1, -1, -1}, {25984, -1, -1, -1}, {26038, -1, -1, -1}, {26074, -1, -1, -1}, {26322, -1, -1, -1}, {27277, -1, -1, -1}, {27286, -1, -1, -1}, {27265, -1, -1, -1}, {27301, -1, -1, -1}, {27273, -1, -1, -1}, {27295, -1, -1, -1}, {27291, -1, -1, -1}, {27297, -1, -1, -1}, {27294, -1, -1, -1}, {27271, -1, -1, -1}, {27283, -1, -1, -1}, {27278, -1, -1, -1}, {27285, -1, -1, -1}, {27267, -1, -1, -1}, {27304, -1, -1, -1}, {27300, -1, -1, -1}, {27281, -1, -1, -1}, {27263, -1, -1, -1}, {27302, -1, -1, -1}, {27290, -1, -1, -1}, {27269, -1, -1, -1}, {27276, -1, -1, -1}, {27282, -1, -1, -1}, {27483, -1, -1, -1}, {27565, -1, -1, -1}, {27657, -1, -1, -1}, {28620, -1, -1, -1}, {28585, -1, -1, -1}, {28660, -1, -1, -1}, {28628, -1, -1, -1}, {28643, -1, -1, -1}, {28636, -1, -1, -1}, {28653, -1, -1, -1}, {28647, -1, -1, -1}, {28646, -1, -1, -1}, {28638, -1, -1, -1}, {28658, -1, -1, -1}, {28637, -1, -1, -1}, {28642, -1, -1, -1}, {28648, -1, -1, -1}, {29153, -1, -1, -1}, {29169, -1, -1, -1}, {29160, -1, -1, -1}, {29170, -1, -1, -1}, {29156, -1, -1, -1}, {29168, -1, -1, -1}, {29154, -1, -1, -1}, {29555, -1, -1, -1}, {29550, -1, -1, -1}, {29551, -1, -1, -1}, {29847, -1, -1, -1}, {29874, -1, -1, -1}, {29867, -1, -1, -1}, {29840, -1, -1, -1}, {29866, -1, -1, -1}, {29869, -1, -1, -1}, {29873, -1, -1, -1}, {29861, -1, -1, -1}, {29871, -1, -1, -1}, {29968, -1, -1, -1}, {29969, -1, -1, -1}, {29970, -1, -1, -1}, {29967, -1, -1, -1}, {30084, -1, -1, -1}, {30275, -1, -1, -1}, {30280, -1, -1, -1}, {30281, -1, -1, -1}, {30279, -1, -1, -1}, {30372, -1, -1, -1}, {30441, -1, -1, -1}, {30645, -1, -1, -1}, {30635, -1, -1, -1}, {30642, -1, -1, -1}, {30647, -1, -1, -1}, {30646, -1, -1, -1}, {30644, -1, -1, -1}, {30641, -1, -1, -1}, {30632, -1, -1, -1}, {30704, -1, -1, -1}, {30963, -1, -1, -1}, {30973, -1, -1, -1}, {30978, -1, -1, -1}, {30971, -1, -1, -1}, {30972, -1, -1, -1}, {30975, -1, -1, -1}, {30962, -1, -1, -1}, {30981, -1, -1, -1}, {30969, -1, -1, -1}, {30974, -1, -1, -1}, {30980, -1, -1, -1}, {31147, -1, -1, -1}, {31144, -1, -1, -1}, {31324, -1, -1, -1}, {31323, -1, -1, -1}, {31318, -1, -1, -1}, {31320, -1, -1, -1}, {31316, -1, -1, -1}, {31322, -1, -1, -1}, {31422, -1, -1, -1}, {31424, -1, -1, -1}, {31425, -1, -1, -1}, {31749, -1, -1, -1}, {31759, -1, -1, -1}, {31730, -1, -1, -1}, {31744, -1, -1, -1}, {31743, -1, -1, -1}, {31739, -1, -1, -1}, {31758, -1, -1, -1}, {31732, -1, -1, -1}, {31755, -1, -1, -1}, {31731, -1, -1, -1}, {31746, -1, -1, -1}, {31753, -1, -1, -1}, {31747, -1, -1, -1}, {31745, -1, -1, -1}, {31736, -1, -1, -1}, {31741, -1, -1, -1}, {31750, -1, -1, -1}, {31728, -1, -1, -1}, {31729, -1, -1, -1}, {31760, -1, -1, -1}, {31754, -1, -1, -1}, {31976, -1, -1, -1}, {32301, -1, -1, -1}, {32316, -1, -1, -1}, {32322, -1, -1, -1}, {32307, -1, -1, -1}, {38984, -1, -1, -1}, {32312, -1, -1, -1}, {32298, -1, -1, -1}, {32329, -1, -1, -1}, {32320, -1, -1, -1}, {32327, -1, -1, -1}, {32297, -1, -1, -1}, {32332, -1, -1, -1}, {32304, -1, -1, -1}, {32315, -1, -1, -1}, {32310, -1, -1, -1}, {32324, -1, -1, -1}, {32314, -1, -1, -1}, {32581, -1, -1, -1} },
    {{32639, -1, -1, -1}, {32638, -1, -1, -1}, {32637, -1, -1, -1}, {32756, -1, -1, -1}, {32754, -1, -1, -1}, {32812, -1, -1, -1}, {33211, -1, -1, -1}, {33220, -1, -1, -1}, {33228, -1, -1, -1}, {33226, -1, -1, -1}, {33221, -1, -1, -1}, {33223, -1, -1, -1}, {33212, -1, -1, -1}, {33257, -1, -1, -1}, {33371, -1, -1, -1}, {33370, -1, -1, -1}, {33372, -1, -1, -1}, {34179, -1, -1, -1}, {34176, -1, -1, -1}, {34191, -1, -1, -1}, {34215, -1, -1, -1}, {34197, -1, -1, -1}, {34208, -1, -1, -1}, {34187, -1, -1, -1}, {34211, -1, -1, -1}, {34171, -1, -1, -1}, {34212, -1, -1, -1}, {34202, -1, -1, -1}, {34206, -1, -1, -1}, {34167, -1, -1, -1}, {34172, -1, -1, -1}, {34185, -1, -1, -1}, {34209, -1, -1, -1}, {34170, -1, -1, -1}, {34168, -1, -1, -1}, {34135, -1, -1, -1}, {34190, -1, -1, -1}, {34198, -1, -1, -1}, {34182, -1, -1, -1}, {34189, -1, -1, -1}, {34201, -1, -1, -1}, {34205, -1, -1, -1}, {34177, -1, -1, -1}, {34210, -1, -1, -1}, {34178, -1, -1, -1}, {34184, -1, -1, -1}, {34181, -1, -1, -1}, {34169, -1, -1, -1}, {34166, -1, -1, -1}, {34200, -1, -1, -1}, {34192, -1, -1, -1}, {34207, -1, -1, -1}, {34408, -1, -1, -1}, {34750, -1, -1, -1}, {34730, -1, -1, -1}, {34733, -1, -1, -1}, {34757, -1, -1, -1}, {34736, -1, -1, -1}, {34732, -1, -1, -1}, {34745, -1, -1, -1}, {34741, -1, -1, -1}, {34748, -1, -1, -1}, {34734, -1, -1, -1}, {34761, -1, -1, -1}, {34755, -1, -1, -1}, {34754, -1, -1, -1}, {34764, -1, -1, -1}, {34743, -1, -1, -1}, {34735, -1, -1, -1}, {34756, -1, -1, -1}, {34762, -1, -1, -1}, {34740, -1, -1, -1}, {34742, -1, -1, -1}, {34751, -1, -1, -1}, {34744, -1, -1, -1}, {34749, -1, -1, -1}, {34782, -1, -1, -1}, {34738, -1, -1, -1}, {35125, -1, -1, -1}, {35123, -1, -1, -1}, {35132, -1, -1, -1}, {35134, -1, -1, -1}, {35137, -1, -1, -1}, {35154, -1, -1, -1}, {35127, -1, -1, -1}, {35138, -1, -1, -1}, {35245, -1, -1, -1}, {35247, -1, -1, -1}, {35246, -1, -1, -1}, {35314, -1, -1, -1}, {35315, -1, -1, -1}, {35614, -1, -1, -1}, {35608, -1, -1, -1}, {35606, -1, -1, -1}, {35601, -1, -1, -1}, {35589, -1, -1, -1}, {35595, -1, -1, -1}, {35618, -1, -1, -1}, {35599, -1, -1, -1}, {35602, -1, -1, -1}, {35605, -1, -1, -1}, {35591, -1, -1, -1}, {35597, -1, -1, -1}, {35592, -1, -1, -1}, {35590, -1, -1, -1}, {35612, -1, -1, -1}, {35603, -1, -1, -1}, {35610, -1, -1, -1}, {35919, -1, -1, -1}, {35952, -1, -1, -1}, {35954, -1, -1, -1}, {35953, -1, -1, -1}, {35951, -1, -1, -1}, {35989, -1, -1, -1}, {35988, -1, -1, -1}, {36089, -1, -1, -1}, {36207, -1, -1, -1}, {36430, -1, -1, -1}, {36429, -1, -1, -1}, {36435, -1, -1, -1}, {36432, -1, -1, -1}, {36428, -1, -1, -1}, {36423, -1, -1, -1}, {36675, -1, -1, -1}, {36672, -1, -1, -1}, {36997, -1, -1, -1}, {36990, -1, -1, -1}, {37176, -1, -1, -1}, {37274, -1, -1, -1}, {37282, -1, -1, -1}, {37275, -1, -1, -1}, {37273, -1, -1, -1}, {37279, -1, -1, -1}, {37281, -1, -1, -1}, {37277, -1, -1, -1}, {37280, -1, -1, -1}, {37793, -1, -1, -1}, {37763, -1, -1, -1}, {37807, -1, -1, -1}, {37732, -1, -1, -1}, {37718, -1, -1, -1}, {37703, -1, -1, -1}, {37756, -1, -1, -1}, {37720, -1, -1, -1}, {37724, -1, -1, -1}, {37750, -1, -1, -1}, {37705, -1, -1, -1}, {37712, -1, -1, -1}, {37713, -1, -1, -1}, {37728, -1, -1, -1}, {37741, -1, -1, -1}, {37775, -1, -1, -1}, {37708, -1, -1, -1}, {37738, -1, -1, -1}, {37753, -1, -1, -1}, {37719, -1, -1, -1}, {37717, -1, -1, -1}, {37714, -1, -1, -1}, {37711, -1, -1, -1}, {37745, -1, -1, -1}, {37751, -1, -1, -1}, {37755, -1, -1, -1}, {37729, -1, -1, -1}, {37726, -1, -1, -1}, {37731, -1, -1, -1}, {37735, -1, -1, -1}, {37710, -1, -1, -1}, {37721, -1, -1, -1}, {38343, -1, -1, -1}, {38336, -1, -1, -1}, {38345, -1, -1, -1}, {38339, -1, -1, -1}, {38341, -1, -1, -1}, {38327, -1, -1, -1}, {38574, -1, -1, -1}, {38576, -1, -1, -1}, {38572, -1, -1, -1}, {38688, -1, -1, -1}, {38687, -1, -1, -1}, {38680, -1, -1, -1}, {38685, -1, -1, -1}, {38681, -1, -1, -1}, {38810, -1, -1, -1}, {38817, -1, -1, -1}, {38812, -1, -1, -1}, {38814, -1, -1, -1}, {38813, -1, -1, -1}, {38869, -1, -1, -1}, {38868, -1, -1, -1}, {38897, -1, -1, -1}, {38977, -1, -1, -1}, {38980, -1, -1, -1}, {38986, -1, -1, -1}, {38985, -1, -1, -1}, {38981, -1, -1, -1}, {38979, -1, -1, -1}, {39205, -1, -1, -1}, {39211, -1, -1, -1}, {39212, -1, -1, -1}, {39210, -1, -1, -1}, {39219, -1, -1, -1}, {39218, -1, -1, -1}, {39215, -1, -1, -1}, {39213, -1, -1, -1}, {39217, -1, -1, -1}, {39216, -1, -1, -1}, {39320, -1, -1, -1}, {39331, -1, -1, -1}, {39329, -1, -1, -1}, {39426, -1, -1, -1}, {39418, -1, -1, -1}, {39412, -1, -1, -1}, {39415, -1, -1, -1}, {39417, -1, -1, -1}, {39416, -1, -1, -1}, {39414, -1, -1, -1}, {39419, -1, -1, -1}, {39421, -1, -1, -1}, {39422, -1, -1, -1}, {39420, -1, -1, -1}, {39427, -1, -1, -1}, {39614, -1, -1, -1}, {39678, -1, -1, -1}, {39677, -1, -1, -1}, {39681, -1, -1, -1}, {39676, -1, -1, -1}, {39752, -1, -1, -1}, {39834, -1, -1, -1}, {39848, -1, -1, -1}, {39838, -1, -1, -1}, {39835, -1, -1, -1}, {39846, -1, -1, -1}, {39841, -1, -1, -1}, {39845, -1, -1, -1}, {39844, -1, -1, -1}, {39814, -1, -1, -1}, {39842, -1, -1, -1}, {39840, -1, -1, -1}, {39855, -1, -1, -1}, {40243, -1, -1, -1}, {40257, -1, -1, -1}, {40295, -1, -1, -1}, {40246, -1, -1, -1}, {40238, -1, -1, -1}, {40239, -1, -1, -1}, {40241, -1, -1, -1}, {40248, -1, -1, -1}, {40240, -1, -1, -1}, {40261, -1, -1, -1}, {40258, -1, -1, -1}, {40259, -1, -1, -1}, {40254, -1, -1, -1}, {40247, -1, -1, -1}, {40256, -1, -1, -1}, {40253, -1, -1, -1}, {32757, -1, -1, -1} },
    {{40237, -1, -1, -1}, {40586, -1, -1, -1}, {40585, -1, -1, -1}, {40589, -1, -1, -1}, {40624, -1, -1, -1}, {40648, -1, -1, -1}, {40666, -1, -1, -1}, {40699, -1, -1, -1}, {40703, -1, -1, -1}, {40740, -1, -1, -1}, {40739, -1, -1, -1}, {40738, -1, -1, -1}, {40788, -1, -1, -1}, {40864, -1, -1, -1}, {20785, -1, -1, -1}, {20781, -1, -1, -1}, {20782, -1, -1, -1}, {22168, -1, -1, -1}, {22172, -1, -1, -1}, {22167, -1, -1, -1}, {22170, -1, -1, -1}, {22173, -1, -1, -1}, {22169, -1, -1, -1}, {22896, -1, -1, -1}, {23356, -1, -1, -1}, {23657, -1, -1, -1}, {23658, -1, -1, -1}, {24000, -1, -1, -1}, {24173, -1, -1, -1}, {24174, -1, -1, -1}, {25048, -1, -1, -1}, {25055, -1, -1, -1}, {25069, -1, -1, -1}, {25070, -1, -1, -1}, {25073, -1, -1, -1}, {25066, -1, -1, -1}, {25072, -1, -1, -1}, {25067, -1, -1, -1}, {25046, -1, -1, -1}, {25065, -1, -1, -1}, {25855, -1, -1, -1}, {25860, -1, -1, -1}, {25853, -1, -1, -1}, {25848, -1, -1, -1}, {25857, -1, -1, -1}, {25859, -1, -1, -1}, {25852, -1, -1, -1}, {26004, -1, -1, -1}, {26075, -1, -1, -1}, {26330, -1, -1, -1}, {26331, -1, -1, -1}, {26328, -1, -1, -1}, {27333, -1, -1, -1}, {27321, -1, -1, -1}, {27325, -1, -1, -1}, {27361, -1, -1, -1}, {27334, -1, -1, -1}, {27322, -1, -1, -1}, {27318, -1, -1, -1}, {27319, -1, -1, -1}, {27335, -1, -1, -1}, {27316, -1, -1, -1}, {27309, -1, -1, -1}, {27486, -1, -1, -1}, {27593, -1, -1, -1}, {27659, -1, -1, -1}, {28679, -1, -1, -1}, {28684, -1, -1, -1}, {28685, -1, -1, -1}, {28673, -1, -1, -1}, {28677, -1, -1, -1}, {28692, -1, -1, -1}, {28686, -1, -1, -1}, {28671, -1, -1, -1}, {28672, -1, -1, -1}, {28667, -1, -1, -1}, {28710, -1, -1, -1}, {28668, -1, -1, -1}, {28663, -1, -1, -1}, {28682, -1, -1, -1}, {29185, -1, -1, -1}, {29183, -1, -1, -1}, {29177, -1, -1, -1}, {29187, -1, -1, -1}, {29181, -1, -1, -1}, {29558, -1, -1, -1}, {29880, -1, -1, -1}, {29888, -1, -1, -1}, {29877, -1, -1, -1}, {29889, -1, -1, -1}, {29886, -1, -1, -1}, {29878, -1, -1, -1}, {29883, -1, -1, -1}, {29890, -1, -1, -1}, {29972, -1, -1, -1}, {29971, -1, -1, -1}, {30300, -1, -1, -1}, {30308, -1, -1, -1}, {30297, -1, -1, -1}, {30288, -1, -1, -1}, {30291, -1, -1, -1}, {30295, -1, -1, -1}, {30298, -1, -1, -1}, {30374, -1, -1, -1}, {30397, -1, -1, -1}, {30444, -1, -1, -1}, {30658, -1, -1, -1}, {30650, -1, -1, -1}, {30988, -1, -1, -1}, {30995, -1, -1, -1}, {30996, -1, -1, -1}, {30985, -1, -1, -1}, {30992, -1, -1, -1}, {30994, -1, -1, -1}, {30993, -1, -1, -1}, {31149, -1, -1, -1}, {31148, -1, -1, -1}, {31327, -1, -1, -1}, {31772, -1, -1, -1}, {31785, -1, -1, -1}, {31769, -1, -1, -1}, {31776, -1, -1, -1}, {31775, -1, -1, -1}, {31789, -1, -1, -1}, {31773, -1, -1, -1}, {31782, -1, -1, -1}, {31784, -1, -1, -1}, {31778, -1, -1, -1}, {31781, -1, -1, -1}, {31792, -1, -1, -1}, {32348, -1, -1, -1}, {32336, -1, -1, -1}, {32342, -1, -1, -1}, {32355, -1, -1, -1}, {32344, -1, -1, -1}, {32354, -1, -1, -1}, {32351, -1, -1, -1}, {32337, -1, -1, -1}, {32352, -1, -1, -1}, {32343, -1, -1, -1}, {32339, -1, -1, -1}, {32693, -1, -1, -1}, {32691, -1, -1, -1}, {32759, -1, -1, -1}, {32760, -1, -1, -1}, {32885, -1, -1, -1}, {33233, -1, -1, -1}, {33234, -1, -1, -1}, {33232, -1, -1, -1}, {33375, -1, -1, -1}, {33374, -1, -1, -1}, {34228, -1, -1, -1}, {34246, -1, -1, -1}, {34240, -1, -1, -1}, {34243, -1, -1, -1}, {34242, -1, -1, -1}, {34227, -1, -1, -1}, {34229, -1, -1, -1}, {34237, -1, -1, -1}, {34247, -1, -1, -1}, {34244, -1, -1, -1}, {34239, -1, -1, -1}, {34251, -1, -1, -1}, {34254, -1, -1, -1}, {34248, -1, -1, -1}, {34245, -1, -1, -1}, {34225, -1, -1, -1}, {34230, -1, -1, -1}, {34258, -1, -1, -1}, {34340, -1, -1, -1}, {34232, -1, -1, -1}, {34231, -1, -1, -1}, {34238, -1, -1, -1}, {34409, -1, -1, -1}, {34791, -1, -1, -1}, {34790, -1, -1, -1}, {34786, -1, -1, -1}, {34779, -1, -1, -1}, {34795, -1, -1, -1}, {34794, -1, -1, -1}, {34789, -1, -1, -1}, {34783, -1, -1, -1}, {34803, -1, -1, -1}, {34788, -1, -1, -1}, {34772, -1, -1, -1}, {34780, -1, -1, -1}, {34771, -1, -1, -1}, {34797, -1, -1, -1}, {34776, -1, -1, -1}, {34787, -1, -1, -1}, {34775, -1, -1, -1}, {34777, -1, -1, -1}, {34817, -1, -1, -1}, {34804, -1, -1, -1}, {34792, -1, -1, -1}, {34781, -1, -1, -1}, {35155, -1, -1, -1}, {35147, -1, -1, -1}, {35151, -1, -1, -1}, {35148, -1, -1, -1}, {35142, -1, -1, -1}, {35152, -1, -1, -1}, {35153, -1, -1, -1}, {35145, -1, -1, -1}, {35626, -1, -1, -1}, {35623, -1, -1, -1}, {35619, -1, -1, -1}, {35635, -1, -1, -1}, {35632, -1, -1, -1}, {35637, -1, -1, -1}, {35655, -1, -1, -1}, {35631, -1, -1, -1}, {35644, -1, -1, -1}, {35646, -1, -1, -1}, {35633, -1, -1, -1}, {35621, -1, -1, -1}, {35639, -1, -1, -1}, {35622, -1, -1, -1}, {35638, -1, -1, -1}, {35630, -1, -1, -1}, {35620, -1, -1, -1}, {35643, -1, -1, -1}, {35645, -1, -1, -1}, {35642, -1, -1, -1}, {35906, -1, -1, -1}, {35957, -1, -1, -1}, {35993, -1, -1, -1}, {35992, -1, -1, -1}, {35991, -1, -1, -1}, {36094, -1, -1, -1}, {36100, -1, -1, -1}, {36098, -1, -1, -1}, {36096, -1, -1, -1}, {36444, -1, -1, -1}, {36450, -1, -1, -1}, {36448, -1, -1, -1}, {36439, -1, -1, -1}, {36438, -1, -1, -1}, {36446, -1, -1, -1}, {36453, -1, -1, -1}, {36455, -1, -1, -1}, {36443, -1, -1, -1}, {36442, -1, -1, -1}, {36449, -1, -1, -1}, {36445, -1, -1, -1}, {36457, -1, -1, -1}, {36436, -1, -1, -1}, {36678, -1, -1, -1}, {36679, -1, -1, -1}, {36680, -1, -1, -1}, {36683, -1, -1, -1}, {37160, -1, -1, -1}, {37178, -1, -1, -1}, {37179, -1, -1, -1}, {37182, -1, -1, -1}, {37288, -1, -1, -1} },
    {{37285, -1, -1, -1}, {37287, -1, -1, -1}, {37295, -1, -1, -1}, {37290, -1, -1, -1}, {37813, -1, -1, -1}, {37772, -1, -1, -1}, {37778, -1, -1, -1}, {37815, -1, -1, -1}, {37787, -1, -1, -1}, {37789, -1, -1, -1}, {37769, -1, -1, -1}, {37799, -1, -1, -1}, {37774, -1, -1, -1}, {37802, -1, -1, -1}, {37790, -1, -1, -1}, {37798, -1, -1, -1}, {37781, -1, -1, -1}, {37768, -1, -1, -1}, {37785, -1, -1, -1}, {37791, -1, -1, -1}, {37760, -1, -1, -1}, {37773, -1, -1, -1}, {37809, -1, -1, -1}, {37777, -1, -1, -1}, {37810, -1, -1, -1}, {37796, -1, -1, -1}, {37800, -1, -1, -1}, {37812, -1, -1, -1}, {37795, -1, -1, -1}, {38354, -1, -1, -1}, {38355, -1, -1, -1}, {38353, -1, -1, -1}, {38579, -1, -1, -1}, {38615, -1, -1, -1}, {38618, -1, -1, -1}, {24002, -1, -1, -1}, {38623, -1, -1, -1}, {38616, -1, -1, -1}, {38621, -1, -1, -1}, {38691, -1, -1, -1}, {38690, -1, -1, -1}, {38693, -1, -1, -1}, {38828, -1, -1, -1}, {38830, -1, -1, -1}, {38824, -1, -1, -1}, {38827, -1, -1, -1}, {38820, -1, -1, -1}, {38826, -1, -1, -1}, {38818, -1, -1, -1}, {38821, -1, -1, -1}, {38871, -1, -1, -1}, {38873, -1, -1, -1}, {38870, -1, -1, -1}, {38872, -1, -1, -1}, {38906, -1, -1, -1}, {38992, -1, -1, -1}, {38993, -1, -1, -1}, {38994, -1, -1, -1}, {39096, -1, -1, -1}, {39233, -1, -1, -1}, {39228, -1, -1, -1}, {39226, -1, -1, -1}, {39439, -1, -1, -1}, {39435, -1, -1, -1}, {39433, -1, -1, -1}, {39437, -1, -1, -1}, {39428, -1, -1, -1}, {39441, -1, -1, -1}, {39434, -1, -1, -1}, {39429, -1, -1, -1}, {39431, -1, -1, -1}, {39430, -1, -1, -1}, {39616, -1, -1, -1}, {39644, -1, -1, -1}, {39688, -1, -1, -1}, {39684, -1, -1, -1}, {39685, -1, -1, -1}, {39721, -1, -1, -1}, {39733, -1, -1, -1}, {39754, -1, -1, -1}, {39756, -1, -1, -1}, {39755, -1, -1, -1}, {39879, -1, -1, -1}, {39878, -1, -1, -1}, {39875, -1, -1, -1}, {39871, -1, -1, -1}, {39873, -1, -1, -1}, {39861, -1, -1, -1}, {39864, -1, -1, -1}, {39891, -1, -1, -1}, {39862, -1, -1, -1}, {39876, -1, -1, -1}, {39865, -1, -1, -1}, {39869, -1, -1, -1}, {40284, -1, -1, -1}, {40275, -1, -1, -1}, {40271, -1, -1, -1}, {40266, -1, -1, -1}, {40283, -1, -1, -1}, {40267, -1, -1, -1}, {40281, -1, -1, -1}, {40278, -1, -1, -1}, {40268, -1, -1, -1}, {40279, -1, -1, -1}, {40274, -1, -1, -1}, {40276, -1, -1, -1}, {40287, -1, -1, -1}, {40280, -1, -1, -1}, {40282, -1, -1, -1}, {40590, -1, -1, -1}, {40588, -1, -1, -1}, {40671, -1, -1, -1}, {40705, -1, -1, -1}, {40704, -1, -1, -1}, {40726, -1, -1, -1}, {40741, -1, -1, -1}, {40747, -1, -1, -1}, {40746, -1, -1, -1}, {40745, -1, -1, -1}, {40744, -1, -1, -1}, {40780, -1, -1, -1}, {40789, -1, -1, -1}, {20788, -1, -1, -1}, {20789, -1, -1, -1}, {21142, -1, -1, -1}, {21239, -1, -1, -1}, {21428, -1, -1, -1}, {22187, -1, -1, -1}, {22189, -1, -1, -1}, {22182, -1, -1, -1}, {22183, -1, -1, -1}, {22186, -1, -1, -1}, {22188, -1, -1, -1}, {22746, -1, -1, -1}, {22749, -1, -1, -1}, {22747, -1, -1, -1}, {22802, -1, -1, -1}, {23357, -1, -1, -1}, {23358, -1, -1, -1}, {23359, -1, -1, -1}, {24003, -1, -1, -1}, {24176, -1, -1, -1}, {24511, -1, -1, -1}, {25083, -1, -1, -1}, {25863, -1, -1, -1}, {25872, -1, -1, -1}, {25869, -1, -1, -1}, {25865, -1, -1, -1}, {25868, -1, -1, -1}, {25870, -1, -1, -1}, {25988, -1, -1, -1}, {26078, -1, -1, -1}, {26077, -1, -1, -1}, {26334, -1, -1, -1}, {27367, -1, -1, -1}, {27360, -1, -1, -1}, {27340, -1, -1, -1}, {27345, -1, -1, -1}, {27353, -1, -1, -1}, {27339, -1, -1, -1}, {27359, -1, -1, -1}, {27356, -1, -1, -1}, {27344, -1, -1, -1}, {27371, -1, -1, -1}, {27343, -1, -1, -1}, {27341, -1, -1, -1}, {27358, -1, -1, -1}, {27488, -1, -1, -1}, {27568, -1, -1, -1}, {27660, -1, -1, -1}, {28697, -1, -1, -1}, {28711, -1, -1, -1}, {28704, -1, -1, -1}, {28694, -1, -1, -1}, {28715, -1, -1, -1}, {28705, -1, -1, -1}, {28706, -1, -1, -1}, {28707, -1, -1, -1}, {28713, -1, -1, -1}, {28695, -1, -1, -1}, {28708, -1, -1, -1}, {28700, -1, -1, -1}, {29196, -1, -1, -1}, {29194, -1, -1, -1}, {29191, -1, -1, -1}, {29186, -1, -1, -1}, {29189, -1, -1, -1}, {29349, -1, -1, -1}, {29350, -1, -1, -1}, {29348, -1, -1, -1}, {29347, -1, -1, -1}, {29345, -1, -1, -1}, {29899, -1, -1, -1}, {29893, -1, -1, -1}, {29879, -1, -1, -1}, {29891, -1, -1, -1}, {29974, -1, -1, -1}, {30304, -1, -1, -1}, {30665, -1, -1, -1}, {30666, -1, -1, -1}, {30660, -1, -1, -1}, {30705, -1, -1, -1}, {31005, -1, -1, -1}, {31003, -1, -1, -1}, {31009, -1, -1, -1}, {31004, -1, -1, -1}, {30999, -1, -1, -1}, {31006, -1, -1, -1}, {31152, -1, -1, -1}, {31335, -1, -1, -1}, {31336, -1, -1, -1}, {31795, -1, -1, -1}, {31804, -1, -1, -1}, {31801, -1, -1, -1}, {31788, -1, -1, -1}, {31803, -1, -1, -1}, {31980, -1, -1, -1}, {31978, -1, -1, -1}, {32374, -1, -1, -1}, {32373, -1, -1, -1}, {32376, -1, -1, -1}, {32368, -1, -1, -1}, {32375, -1, -1, -1}, {32367, -1, -1, -1}, {32378, -1, -1, -1}, {32370, -1, -1, -1}, {32372, -1, -1, -1}, {32360, -1, -1, -1}, {32587, -1, -1, -1}, {32586, -1, -1, -1}, {32643, -1, -1, -1}, {32646, -1, -1, -1}, {32695, -1, -1, -1}, {32765, -1, -1, -1}, {32766, -1, -1, -1}, {32888, -1, -1, -1}, {33239, -1, -1, -1}, {33237, -1, -1, -1}, {33291, -1, -1, -1}, {33380, -1, -1, -1}, {33377, -1, -1, -1}, {33379, -1, -1, -1}, {34283, -1, -1, -1}, {34289, -1, -1, -1}, {34285, -1, -1, -1}, {34265, -1, -1, -1}, {34273, -1, -1, -1}, {34280, -1, -1, -1}, {34266, -1, -1, -1}, {34263, -1, -1, -1}, {34284, -1, -1, -1}, {34290, -1, -1, -1}, {34296, -1, -1, -1}, {34264, -1, -1, -1}, {34271, -1, -1, -1}, {34275, -1, -1, -1} },
    {{34268, -1, -1, -1}, {34257, -1, -1, -1}, {34288, -1, -1, -1}, {34278, -1, -1, -1}, {34287, -1, -1, -1}, {34270, -1, -1, -1}, {34274, -1, -1, -1}, {34816, -1, -1, -1}, {34810, -1, -1, -1}, {34819, -1, -1, -1}, {34806, -1, -1, -1}, {34807, -1, -1, -1}, {34825, -1, -1, -1}, {34828, -1, -1, -1}, {34827, -1, -1, -1}, {34822, -1, -1, -1}, {34812, -1, -1, -1}, {34824, -1, -1, -1}, {34815, -1, -1, -1}, {34826, -1, -1, -1}, {34818, -1, -1, -1}, {35170, -1, -1, -1}, {35162, -1, -1, -1}, {35163, -1, -1, -1}, {35159, -1, -1, -1}, {35169, -1, -1, -1}, {35164, -1, -1, -1}, {35160, -1, -1, -1}, {35165, -1, -1, -1}, {35161, -1, -1, -1}, {35208, -1, -1, -1}, {35255, -1, -1, -1}, {35254, -1, -1, -1}, {35318, -1, -1, -1}, {35664, -1, -1, -1}, {35656, -1, -1, -1}, {35658, -1, -1, -1}, {35648, -1, -1, -1}, {35667, -1, -1, -1}, {35670, -1, -1, -1}, {35668, -1, -1, -1}, {35659, -1, -1, -1}, {35669, -1, -1, -1}, {35665, -1, -1, -1}, {35650, -1, -1, -1}, {35666, -1, -1, -1}, {35671, -1, -1, -1}, {35907, -1, -1, -1}, {35959, -1, -1, -1}, {35958, -1, -1, -1}, {35994, -1, -1, -1}, {36102, -1, -1, -1}, {36103, -1, -1, -1}, {36105, -1, -1, -1}, {36268, -1, -1, -1}, {36266, -1, -1, -1}, {36269, -1, -1, -1}, {36267, -1, -1, -1}, {36461, -1, -1, -1}, {36472, -1, -1, -1}, {36467, -1, -1, -1}, {36458, -1, -1, -1}, {36463, -1, -1, -1}, {36475, -1, -1, -1}, {36546, -1, -1, -1}, {36690, -1, -1, -1}, {36689, -1, -1, -1}, {36687, -1, -1, -1}, {36688, -1, -1, -1}, {36691, -1, -1, -1}, {36788, -1, -1, -1}, {37184, -1, -1, -1}, {37183, -1, -1, -1}, {37296, -1, -1, -1}, {37293, -1, -1, -1}, {37854, -1, -1, -1}, {37831, -1, -1, -1}, {37839, -1, -1, -1}, {37826, -1, -1, -1}, {37850, -1, -1, -1}, {37840, -1, -1, -1}, {37881, -1, -1, -1}, {37868, -1, -1, -1}, {37836, -1, -1, -1}, {37849, -1, -1, -1}, {37801, -1, -1, -1}, {37862, -1, -1, -1}, {37834, -1, -1, -1}, {37844, -1, -1, -1}, {37870, -1, -1, -1}, {37859, -1, -1, -1}, {37845, -1, -1, -1}, {37828, -1, -1, -1}, {37838, -1, -1, -1}, {37824, -1, -1, -1}, {37842, -1, -1, -1}, {37797, -1, -1, -1}, {37863, -1, -1, -1}, {38269, -1, -1, -1}, {38362, -1, -1, -1}, {38363, -1, -1, -1}, {38625, -1, -1, -1}, {38697, -1, -1, -1}, {38699, -1, -1, -1}, {38700, -1, -1, -1}, {38696, -1, -1, -1}, {38694, -1, -1, -1}, {38835, -1, -1, -1}, {38839, -1, -1, -1}, {38838, -1, -1, -1}, {38877, -1, -1, -1}, {38878, -1, -1, -1}, {38879, -1, -1, -1}, {39004, -1, -1, -1}, {39001, -1, -1, -1}, {39005, -1, -1, -1}, {38999, -1, -1, -1}, {39103, -1, -1, -1}, {39101, -1, -1, -1}, {39099, -1, -1, -1}, {39102, -1, -1, -1}, {39240, -1, -1, -1}, {39239, -1, -1, -1}, {39235, -1, -1, -1}, {39334, -1, -1, -1}, {39335, -1, -1, -1}, {39450, -1, -1, -1}, {39445, -1, -1, -1}, {39461, -1, -1, -1}, {39453, -1, -1, -1}, {39460, -1, -1, -1}, {39451, -1, -1, -1}, {39458, -1, -1, -1}, {39456, -1, -1, -1}, {39463, -1, -1, -1}, {39459, -1, -1, -1}, {39454, -1, -1, -1}, {39452, -1, -1, -1}, {39444, -1, -1, -1}, {39618, -1, -1, -1}, {39691, -1, -1, -1}, {39690, -1, -1, -1}, {39694, -1, -1, -1}, {39692, -1, -1, -1}, {39735, -1, -1, -1}, {39914, -1, -1, -1}, {39915, -1, -1, -1}, {39904, -1, -1, -1}, {39902, -1, -1, -1}, {39908, -1, -1, -1}, {39910, -1, -1, -1}, {39906, -1, -1, -1}, {39920, -1, -1, -1}, {39892, -1, -1, -1}, {39895, -1, -1, -1}, {39916, -1, -1, -1}, {39900, -1, -1, -1}, {39897, -1, -1, -1}, {39909, -1, -1, -1}, {39893, -1, -1, -1}, {39905, -1, -1, -1}, {39898, -1, -1, -1}, {40311, -1, -1, -1}, {40321, -1, -1, -1}, {40330, -1, -1, -1}, {40324, -1, -1, -1}, {40328, -1, -1, -1}, {40305, -1, -1, -1}, {40320, -1, -1, -1}, {40312, -1, -1, -1}, {40326, -1, -1, -1}, {40331, -1, -1, -1}, {40332, -1, -1, -1}, {40317, -1, -1, -1}, {40299, -1, -1, -1}, {40308, -1, -1, -1}, {40309, -1, -1, -1}, {40304, -1, -1, -1}, {40297, -1, -1, -1}, {40325, -1, -1, -1}, {40307, -1, -1, -1}, {40315, -1, -1, -1}, {40322, -1, -1, -1}, {40303, -1, -1, -1}, {40313, -1, -1, -1}, {40319, -1, -1, -1}, {40327, -1, -1, -1}, {40296, -1, -1, -1}, {40596, -1, -1, -1}, {40593, -1, -1, -1}, {40640, -1, -1, -1}, {40700, -1, -1, -1}, {40749, -1, -1, -1}, {40768, -1, -1, -1}, {40769, -1, -1, -1}, {40781, -1, -1, -1}, {40790, -1, -1, -1}, {40791, -1, -1, -1}, {40792, -1, -1, -1}, {21303, -1, -1, -1}, {22194, -1, -1, -1}, {22197, -1, -1, -1}, {22195, -1, -1, -1}, {22755, -1, -1, -1}, {23365, -1, -1, -1}, {24006, -1, -1, -1}, {24007, -1, -1, -1}, {24302, -1, -1, -1}, {24303, -1, -1, -1}, {24512, -1, -1, -1}, {24513, -1, -1, -1}, {25081, -1, -1, -1}, {25879, -1, -1, -1}, {25878, -1, -1, -1}, {25877, -1, -1, -1}, {25875, -1, -1, -1}, {26079, -1, -1, -1}, {26344, -1, -1, -1}, {26339, -1, -1, -1}, {26340, -1, -1, -1}, {27379, -1, -1, -1}, {27376, -1, -1, -1}, {27370, -1, -1, -1}, {27368, -1, -1, -1}, {27385, -1, -1, -1}, {27377, -1, -1, -1}, {27374, -1, -1, -1}, {27375, -1, -1, -1}, {28732, -1, -1, -1}, {28725, -1, -1, -1}, {28719, -1, -1, -1}, {28727, -1, -1, -1}, {28724, -1, -1, -1}, {28721, -1, -1, -1}, {28738, -1, -1, -1}, {28728, -1, -1, -1}, {28735, -1, -1, -1}, {28730, -1, -1, -1}, {28729, -1, -1, -1}, {28714, -1, -1, -1}, {28736, -1, -1, -1}, {28731, -1, -1, -1}, {28723, -1, -1, -1}, {28737, -1, -1, -1}, {29203, -1, -1, -1}, {29204, -1, -1, -1}, {29352, -1, -1, -1}, {29565, -1, -1, -1}, {29564, -1, -1, -1}, {29882, -1, -1, -1}, {30379, -1, -1, -1}, {30378, -1, -1, -1}, {30398, -1, -1, -1}, {30445, -1, -1, -1}, {30668, -1, -1, -1}, {30670, -1, -1, -1} },
    {{30671, -1, -1, -1}, {30669, -1, -1, -1}, {30706, -1, -1, -1}, {31013, -1, -1, -1}, {31011, -1, -1, -1}, {31015, -1, -1, -1}, {31016, -1, -1, -1}, {31012, -1, -1, -1}, {31017, -1, -1, -1}, {31154, -1, -1, -1}, {31342, -1, -1, -1}, {31340, -1, -1, -1}, {31341, -1, -1, -1}, {31479, -1, -1, -1}, {31817, -1, -1, -1}, {31816, -1, -1, -1}, {31818, -1, -1, -1}, {31815, -1, -1, -1}, {31813, -1, -1, -1}, {31982, -1, -1, -1}, {32379, -1, -1, -1}, {32382, -1, -1, -1}, {32385, -1, -1, -1}, {32384, -1, -1, -1}, {32698, -1, -1, -1}, {32767, -1, -1, -1}, {32889, -1, -1, -1}, {33243, -1, -1, -1}, {33241, -1, -1, -1}, {33384, -1, -1, -1}, {33385, -1, -1, -1}, {34338, -1, -1, -1}, {34303, -1, -1, -1}, {34305, -1, -1, -1}, {34302, -1, -1, -1}, {34331, -1, -1, -1}, {34304, -1, -1, -1}, {34294, -1, -1, -1}, {34308, -1, -1, -1}, {34313, -1, -1, -1}, {34309, -1, -1, -1}, {34316, -1, -1, -1}, {34301, -1, -1, -1}, {34841, -1, -1, -1}, {34832, -1, -1, -1}, {34833, -1, -1, -1}, {34839, -1, -1, -1}, {34835, -1, -1, -1}, {34838, -1, -1, -1}, {35171, -1, -1, -1}, {35174, -1, -1, -1}, {35257, -1, -1, -1}, {35319, -1, -1, -1}, {35680, -1, -1, -1}, {35690, -1, -1, -1}, {35677, -1, -1, -1}, {35688, -1, -1, -1}, {35683, -1, -1, -1}, {35685, -1, -1, -1}, {35687, -1, -1, -1}, {35693, -1, -1, -1}, {36270, -1, -1, -1}, {36486, -1, -1, -1}, {36488, -1, -1, -1}, {36484, -1, -1, -1}, {36697, -1, -1, -1}, {36694, -1, -1, -1}, {36695, -1, -1, -1}, {36693, -1, -1, -1}, {36696, -1, -1, -1}, {36698, -1, -1, -1}, {37005, -1, -1, -1}, {37187, -1, -1, -1}, {37185, -1, -1, -1}, {37303, -1, -1, -1}, {37301, -1, -1, -1}, {37298, -1, -1, -1}, {37299, -1, -1, -1}, {37899, -1, -1, -1}, {37907, -1, -1, -1}, {37883, -1, -1, -1}, {37920, -1, -1, -1}, {37903, -1, -1, -1}, {37908, -1, -1, -1}, {37886, -1, -1, -1}, {37909, -1, -1, -1}, {37904, -1, -1, -1}, {37928, -1, -1, -1}, {37913, -1, -1, -1}, {37901, -1, -1, -1}, {37877, -1, -1, -1}, {37888, -1, -1, -1}, {37879, -1, -1, -1}, {37895, -1, -1, -1}, {37902, -1, -1, -1}, {37910, -1, -1, -1}, {37906, -1, -1, -1}, {37882, -1, -1, -1}, {37897, -1, -1, -1}, {37880, -1, -1, -1}, {37948, -1, -1, -1}, {37898, -1, -1, -1}, {37887, -1, -1, -1}, {37884, -1, -1, -1}, {37900, -1, -1, -1}, {37878, -1, -1, -1}, {37905, -1, -1, -1}, {37894, -1, -1, -1}, {38366, -1, -1, -1}, {38368, -1, -1, -1}, {38367, -1, -1, -1}, {38702, -1, -1, -1}, {38703, -1, -1, -1}, {38841, -1, -1, -1}, {38843, -1, -1, -1}, {38909, -1, -1, -1}, {38910, -1, -1, -1}, {39008, -1, -1, -1}, {39010, -1, -1, -1}, {39011, -1, -1, -1}, {39007, -1, -1, -1}, {39105, -1, -1, -1}, {39106, -1, -1, -1}, {39248, -1, -1, -1}, {39246, -1, -1, -1}, {39257, -1, -1, -1}, {39244, -1, -1, -1}, {39243, -1, -1, -1}, {39251, -1, -1, -1}, {39474, -1, -1, -1}, {39476, -1, -1, -1}, {39473, -1, -1, -1}, {39468, -1, -1, -1}, {39466, -1, -1, -1}, {39478, -1, -1, -1}, {39465, -1, -1, -1}, {39470, -1, -1, -1}, {39480, -1, -1, -1}, {39469, -1, -1, -1}, {39623, -1, -1, -1}, {39626, -1, -1, -1}, {39622, -1, -1, -1}, {39696, -1, -1, -1}, {39698, -1, -1, -1}, {39697, -1, -1, -1}, {39947, -1, -1, -1}, {39944, -1, -1, -1}, {39927, -1, -1, -1}, {39941, -1, -1, -1}, {39954, -1, -1, -1}, {39928, -1, -1, -1}, {40000, -1, -1, -1}, {39943, -1, -1, -1}, {39950, -1, -1, -1}, {39942, -1, -1, -1}, {39959, -1, -1, -1}, {39956, -1, -1, -1}, {39945, -1, -1, -1}, {40351, -1, -1, -1}, {40345, -1, -1, -1}, {40356, -1, -1, -1}, {40349, -1, -1, -1}, {40338, -1, -1, -1}, {40344, -1, -1, -1}, {40336, -1, -1, -1}, {40347, -1, -1, -1}, {40352, -1, -1, -1}, {40340, -1, -1, -1}, {40348, -1, -1, -1}, {40362, -1, -1, -1}, {40343, -1, -1, -1}, {40353, -1, -1, -1}, {40346, -1, -1, -1}, {40354, -1, -1, -1}, {40360, -1, -1, -1}, {40350, -1, -1, -1}, {40355, -1, -1, -1}, {40383, -1, -1, -1}, {40361, -1, -1, -1}, {40342, -1, -1, -1}, {40358, -1, -1, -1}, {40359, -1, -1, -1}, {40601, -1, -1, -1}, {40603, -1, -1, -1}, {40602, -1, -1, -1}, {40677, -1, -1, -1}, {40676, -1, -1, -1}, {40679, -1, -1, -1}, {40678, -1, -1, -1}, {40752, -1, -1, -1}, {40750, -1, -1, -1}, {40795, -1, -1, -1}, {40800, -1, -1, -1}, {40798, -1, -1, -1}, {40797, -1, -1, -1}, {40793, -1, -1, -1}, {40849, -1, -1, -1}, {20794, -1, -1, -1}, {20793, -1, -1, -1}, {21144, -1, -1, -1}, {21143, -1, -1, -1}, {22211, -1, -1, -1}, {22205, -1, -1, -1}, {22206, -1, -1, -1}, {23368, -1, -1, -1}, {23367, -1, -1, -1}, {24011, -1, -1, -1}, {24015, -1, -1, -1}, {24305, -1, -1, -1}, {25085, -1, -1, -1}, {25883, -1, -1, -1}, {27394, -1, -1, -1}, {27388, -1, -1, -1}, {27395, -1, -1, -1}, {27384, -1, -1, -1}, {27392, -1, -1, -1}, {28739, -1, -1, -1}, {28740, -1, -1, -1}, {28746, -1, -1, -1}, {28744, -1, -1, -1}, {28745, -1, -1, -1}, {28741, -1, -1, -1}, {28742, -1, -1, -1}, {29213, -1, -1, -1}, {29210, -1, -1, -1}, {29209, -1, -1, -1}, {29566, -1, -1, -1}, {29975, -1, -1, -1}, {30314, -1, -1, -1}, {30672, -1, -1, -1}, {31021, -1, -1, -1}, {31025, -1, -1, -1}, {31023, -1, -1, -1}, {31828, -1, -1, -1}, {31827, -1, -1, -1}, {31986, -1, -1, -1}, {32394, -1, -1, -1}, {32391, -1, -1, -1}, {32392, -1, -1, -1}, {32395, -1, -1, -1}, {32390, -1, -1, -1}, {32397, -1, -1, -1}, {32589, -1, -1, -1}, {32699, -1, -1, -1}, {32816, -1, -1, -1}, {33245, -1, -1, -1}, {34328, -1, -1, -1}, {34346, -1, -1, -1}, {34342, -1, -1, -1}, {34335, -1, -1, -1}, {34339, -1, -1, -1}, {34332, -1, -1, -1}, {34329, -1, -1, -1}, {34343, -1, -1, -1}, {34350, -1, -1, -1}, {34337, -1, -1, -1} },
    {{34336, -1, -1, -1}, {34345, -1, -1, -1}, {34334, -1, -1, -1}, {34341, -1, -1, -1}, {34857, -1, -1, -1}, {34845, -1, -1, -1}, {34843, -1, -1, -1}, {34848, -1, -1, -1}, {34852, -1, -1, -1}, {34844, -1, -1, -1}, {34859, -1, -1, -1}, {34890, -1, -1, -1}, {35181, -1, -1, -1}, {35177, -1, -1, -1}, {35182, -1, -1, -1}, {35179, -1, -1, -1}, {35322, -1, -1, -1}, {35705, -1, -1, -1}, {35704, -1, -1, -1}, {35653, -1, -1, -1}, {35706, -1, -1, -1}, {35707, -1, -1, -1}, {36112, -1, -1, -1}, {36116, -1, -1, -1}, {36271, -1, -1, -1}, {36494, -1, -1, -1}, {36492, -1, -1, -1}, {36702, -1, -1, -1}, {36699, -1, -1, -1}, {36701, -1, -1, -1}, {37190, -1, -1, -1}, {37188, -1, -1, -1}, {37189, -1, -1, -1}, {37305, -1, -1, -1}, {37951, -1, -1, -1}, {37947, -1, -1, -1}, {37942, -1, -1, -1}, {37929, -1, -1, -1}, {37949, -1, -1, -1}, {37936, -1, -1, -1}, {37945, -1, -1, -1}, {37930, -1, -1, -1}, {37943, -1, -1, -1}, {37932, -1, -1, -1}, {37952, -1, -1, -1}, {37937, -1, -1, -1}, {38373, -1, -1, -1}, {38372, -1, -1, -1}, {38371, -1, -1, -1}, {38709, -1, -1, -1}, {38714, -1, -1, -1}, {38847, -1, -1, -1}, {38881, -1, -1, -1}, {39012, -1, -1, -1}, {39113, -1, -1, -1}, {39110, -1, -1, -1}, {39104, -1, -1, -1}, {39256, -1, -1, -1}, {39254, -1, -1, -1}, {39481, -1, -1, -1}, {39485, -1, -1, -1}, {39494, -1, -1, -1}, {39492, -1, -1, -1}, {39490, -1, -1, -1}, {39489, -1, -1, -1}, {39482, -1, -1, -1}, {39487, -1, -1, -1}, {39629, -1, -1, -1}, {39701, -1, -1, -1}, {39703, -1, -1, -1}, {39704, -1, -1, -1}, {39702, -1, -1, -1}, {39738, -1, -1, -1}, {39762, -1, -1, -1}, {39979, -1, -1, -1}, {39965, -1, -1, -1}, {39964, -1, -1, -1}, {39980, -1, -1, -1}, {39971, -1, -1, -1}, {39976, -1, -1, -1}, {39977, -1, -1, -1}, {39972, -1, -1, -1}, {39969, -1, -1, -1}, {40375, -1, -1, -1}, {40374, -1, -1, -1}, {40380, -1, -1, -1}, {40385, -1, -1, -1}, {40391, -1, -1, -1}, {40394, -1, -1, -1}, {40399, -1, -1, -1}, {40382, -1, -1, -1}, {40389, -1, -1, -1}, {40387, -1, -1, -1}, {40379, -1, -1, -1}, {40373, -1, -1, -1}, {40398, -1, -1, -1}, {40377, -1, -1, -1}, {40378, -1, -1, -1}, {40364, -1, -1, -1}, {40392, -1, -1, -1}, {40369, -1, -1, -1}, {40365, -1, -1, -1}, {40396, -1, -1, -1}, {40371, -1, -1, -1}, {40397, -1, -1, -1}, {40370, -1, -1, -1}, {40570, -1, -1, -1}, {40604, -1, -1, -1}, {40683, -1, -1, -1}, {40686, -1, -1, -1}, {40685, -1, -1, -1}, {40731, -1, -1, -1}, {40728, -1, -1, -1}, {40730, -1, -1, -1}, {40753, -1, -1, -1}, {40782, -1, -1, -1}, {40805, -1, -1, -1}, {40804, -1, -1, -1}, {40850, -1, -1, -1}, {20153, -1, -1, -1}, {22214, -1, -1, -1}, {22213, -1, -1, -1}, {22219, -1, -1, -1}, {22897, -1, -1, -1}, {23371, -1, -1, -1}, {23372, -1, -1, -1}, {24021, -1, -1, -1}, {24017, -1, -1, -1}, {24306, -1, -1, -1}, {25889, -1, -1, -1}, {25888, -1, -1, -1}, {25894, -1, -1, -1}, {25890, -1, -1, -1}, {27403, -1, -1, -1}, {27400, -1, -1, -1}, {27401, -1, -1, -1}, {27661, -1, -1, -1}, {28757, -1, -1, -1}, {28758, -1, -1, -1}, {28759, -1, -1, -1}, {28754, -1, -1, -1}, {29214, -1, -1, -1}, {29215, -1, -1, -1}, {29353, -1, -1, -1}, {29567, -1, -1, -1}, {29912, -1, -1, -1}, {29909, -1, -1, -1}, {29913, -1, -1, -1}, {29911, -1, -1, -1}, {30317, -1, -1, -1}, {30381, -1, -1, -1}, {31029, -1, -1, -1}, {31156, -1, -1, -1}, {31344, -1, -1, -1}, {31345, -1, -1, -1}, {31831, -1, -1, -1}, {31836, -1, -1, -1}, {31833, -1, -1, -1}, {31835, -1, -1, -1}, {31834, -1, -1, -1}, {31988, -1, -1, -1}, {31985, -1, -1, -1}, {32401, -1, -1, -1}, {32591, -1, -1, -1}, {32647, -1, -1, -1}, {33246, -1, -1, -1}, {33387, -1, -1, -1}, {34356, -1, -1, -1}, {34357, -1, -1, -1}, {34355, -1, -1, -1}, {34348, -1, -1, -1}, {34354, -1, -1, -1}, {34358, -1, -1, -1}, {34860, -1, -1, -1}, {34856, -1, -1, -1}, {34854, -1, -1, -1}, {34858, -1, -1, -1}, {34853, -1, -1, -1}, {35185, -1, -1, -1}, {35263, -1, -1, -1}, {35262, -1, -1, -1}, {35323, -1, -1, -1}, {35710, -1, -1, -1}, {35716, -1, -1, -1}, {35714, -1, -1, -1}, {35718, -1, -1, -1}, {35717, -1, -1, -1}, {35711, -1, -1, -1}, {36117, -1, -1, -1}, {36501, -1, -1, -1}, {36500, -1, -1, -1}, {36506, -1, -1, -1}, {36498, -1, -1, -1}, {36496, -1, -1, -1}, {36502, -1, -1, -1}, {36503, -1, -1, -1}, {36704, -1, -1, -1}, {36706, -1, -1, -1}, {37191, -1, -1, -1}, {37964, -1, -1, -1}, {37968, -1, -1, -1}, {37962, -1, -1, -1}, {37963, -1, -1, -1}, {37967, -1, -1, -1}, {37959, -1, -1, -1}, {37957, -1, -1, -1}, {37960, -1, -1, -1}, {37961, -1, -1, -1}, {37958, -1, -1, -1}, {38719, -1, -1, -1}, {38883, -1, -1, -1}, {39018, -1, -1, -1}, {39017, -1, -1, -1}, {39115, -1, -1, -1}, {39252, -1, -1, -1}, {39259, -1, -1, -1}, {39502, -1, -1, -1}, {39507, -1, -1, -1}, {39508, -1, -1, -1}, {39500, -1, -1, -1}, {39503, -1, -1, -1}, {39496, -1, -1, -1}, {39498, -1, -1, -1}, {39497, -1, -1, -1}, {39506, -1, -1, -1}, {39504, -1, -1, -1}, {39632, -1, -1, -1}, {39705, -1, -1, -1}, {39723, -1, -1, -1}, {39739, -1, -1, -1}, {39766, -1, -1, -1}, {39765, -1, -1, -1}, {40006, -1, -1, -1}, {40008, -1, -1, -1}, {39999, -1, -1, -1}, {40004, -1, -1, -1}, {39993, -1, -1, -1}, {39987, -1, -1, -1}, {40001, -1, -1, -1}, {39996, -1, -1, -1}, {39991, -1, -1, -1}, {39988, -1, -1, -1}, {39986, -1, -1, -1}, {39997, -1, -1, -1}, {39990, -1, -1, -1}, {40411, -1, -1, -1}, {40402, -1, -1, -1}, {40414, -1, -1, -1}, {40410, -1, -1, -1}, {40395, -1, -1, -1}, {40400, -1, -1, -1}, {40412, -1, -1, -1}, {40401, -1, -1, -1}, {40415, -1, -1, -1}, {40425, -1, -1, -1}, {40409, -1, -1, -1} },
    {{40408, -1, -1, -1}, {40406, -1, -1, -1}, {40437, -1, -1, -1}, {40405, -1, -1, -1}, {40413, -1, -1, -1}, {40630, -1, -1, -1}, {40688, -1, -1, -1}, {40757, -1, -1, -1}, {40755, -1, -1, -1}, {40754, -1, -1, -1}, {40770, -1, -1, -1}, {40811, -1, -1, -1}, {40853, -1, -1, -1}, {40866, -1, -1, -1}, {20797, -1, -1, -1}, {21145, -1, -1, -1}, {22760, -1, -1, -1}, {22759, -1, -1, -1}, {22898, -1, -1, -1}, {23373, -1, -1, -1}, {24024, -1, -1, -1}, {34863, -1, -1, -1}, {24399, -1, -1, -1}, {25089, -1, -1, -1}, {25091, -1, -1, -1}, {25092, -1, -1, -1}, {25897, -1, -1, -1}, {25893, -1, -1, -1}, {26006, -1, -1, -1}, {26347, -1, -1, -1}, {27409, -1, -1, -1}, {27410, -1, -1, -1}, {27407, -1, -1, -1}, {27594, -1, -1, -1}, {28763, -1, -1, -1}, {28762, -1, -1, -1}, {29218, -1, -1, -1}, {29570, -1, -1, -1}, {29569, -1, -1, -1}, {29571, -1, -1, -1}, {30320, -1, -1, -1}, {30676, -1, -1, -1}, {31847, -1, -1, -1}, {31846, -1, -1, -1}, {32405, -1, -1, -1}, {33388, -1, -1, -1}, {34362, -1, -1, -1}, {34368, -1, -1, -1}, {34361, -1, -1, -1}, {34364, -1, -1, -1}, {34353, -1, -1, -1}, {34363, -1, -1, -1}, {34366, -1, -1, -1}, {34864, -1, -1, -1}, {34866, -1, -1, -1}, {34862, -1, -1, -1}, {34867, -1, -1, -1}, {35190, -1, -1, -1}, {35188, -1, -1, -1}, {35187, -1, -1, -1}, {35326, -1, -1, -1}, {35724, -1, -1, -1}, {35726, -1, -1, -1}, {35723, -1, -1, -1}, {35720, -1, -1, -1}, {35909, -1, -1, -1}, {36121, -1, -1, -1}, {36504, -1, -1, -1}, {36708, -1, -1, -1}, {36707, -1, -1, -1}, {37308, -1, -1, -1}, {37986, -1, -1, -1}, {37973, -1, -1, -1}, {37981, -1, -1, -1}, {37975, -1, -1, -1}, {37982, -1, -1, -1}, {38852, -1, -1, -1}, {38853, -1, -1, -1}, {38912, -1, -1, -1}, {39510, -1, -1, -1}, {39513, -1, -1, -1}, {39710, -1, -1, -1}, {39711, -1, -1, -1}, {39712, -1, -1, -1}, {40018, -1, -1, -1}, {40024, -1, -1, -1}, {40016, -1, -1, -1}, {40010, -1, -1, -1}, {40013, -1, -1, -1}, {40011, -1, -1, -1}, {40021, -1, -1, -1}, {40025, -1, -1, -1}, {40012, -1, -1, -1}, {40014, -1, -1, -1}, {40443, -1, -1, -1}, {40439, -1, -1, -1}, {40431, -1, -1, -1}, {40419, -1, -1, -1}, {40427, -1, -1, -1}, {40440, -1, -1, -1}, {40420, -1, -1, -1}, {40438, -1, -1, -1}, {40417, -1, -1, -1}, {40430, -1, -1, -1}, {40422, -1, -1, -1}, {40434, -1, -1, -1}, {40432, -1, -1, -1}, {40418, -1, -1, -1}, {40428, -1, -1, -1}, {40436, -1, -1, -1}, {40435, -1, -1, -1}, {40424, -1, -1, -1}, {40429, -1, -1, -1}, {40642, -1, -1, -1}, {40656, -1, -1, -1}, {40690, -1, -1, -1}, {40691, -1, -1, -1}, {40710, -1, -1, -1}, {40732, -1, -1, -1}, {40760, -1, -1, -1}, {40759, -1, -1, -1}, {40758, -1, -1, -1}, {40771, -1, -1, -1}, {40783, -1, -1, -1}, {40817, -1, -1, -1}, {40816, -1, -1, -1}, {40814, -1, -1, -1}, {40815, -1, -1, -1}, {22227, -1, -1, -1}, {22221, -1, -1, -1}, {23374, -1, -1, -1}, {23661, -1, -1, -1}, {25901, -1, -1, -1}, {26349, -1, -1, -1}, {26350, -1, -1, -1}, {27411, -1, -1, -1}, {28767, -1, -1, -1}, {28769, -1, -1, -1}, {28765, -1, -1, -1}, {28768, -1, -1, -1}, {29219, -1, -1, -1}, {29915, -1, -1, -1}, {29925, -1, -1, -1}, {30677, -1, -1, -1}, {31032, -1, -1, -1}, {31159, -1, -1, -1}, {31158, -1, -1, -1}, {31850, -1, -1, -1}, {32407, -1, -1, -1}, {32649, -1, -1, -1}, {33389, -1, -1, -1}, {34371, -1, -1, -1}, {34872, -1, -1, -1}, {34871, -1, -1, -1}, {34869, -1, -1, -1}, {34891, -1, -1, -1}, {35732, -1, -1, -1}, {35733, -1, -1, -1}, {36510, -1, -1, -1}, {36511, -1, -1, -1}, {36512, -1, -1, -1}, {36509, -1, -1, -1}, {37310, -1, -1, -1}, {37309, -1, -1, -1}, {37314, -1, -1, -1}, {37995, -1, -1, -1}, {37992, -1, -1, -1}, {37993, -1, -1, -1}, {38629, -1, -1, -1}, {38726, -1, -1, -1}, {38723, -1, -1, -1}, {38727, -1, -1, -1}, {38855, -1, -1, -1}, {38885, -1, -1, -1}, {39518, -1, -1, -1}, {39637, -1, -1, -1}, {39769, -1, -1, -1}, {40035, -1, -1, -1}, {40039, -1, -1, -1}, {40038, -1, -1, -1}, {40034, -1, -1, -1}, {40030, -1, -1, -1}, {40032, -1, -1, -1}, {40450, -1, -1, -1}, {40446, -1, -1, -1}, {40455, -1, -1, -1}, {40451, -1, -1, -1}, {40454, -1, -1, -1}, {40453, -1, -1, -1}, {40448, -1, -1, -1}, {40449, -1, -1, -1}, {40457, -1, -1, -1}, {40447, -1, -1, -1}, {40445, -1, -1, -1}, {40452, -1, -1, -1}, {40608, -1, -1, -1}, {40734, -1, -1, -1}, {40774, -1, -1, -1}, {40820, -1, -1, -1}, {40821, -1, -1, -1}, {40822, -1, -1, -1}, {22228, -1, -1, -1}, {25902, -1, -1, -1}, {26040, -1, -1, -1}, {27416, -1, -1, -1}, {27417, -1, -1, -1}, {27415, -1, -1, -1}, {27418, -1, -1, -1}, {28770, -1, -1, -1}, {29222, -1, -1, -1}, {29354, -1, -1, -1}, {30680, -1, -1, -1}, {30681, -1, -1, -1}, {31033, -1, -1, -1}, {31849, -1, -1, -1}, {31851, -1, -1, -1}, {31990, -1, -1, -1}, {32410, -1, -1, -1}, {32408, -1, -1, -1}, {32411, -1, -1, -1}, {32409, -1, -1, -1}, {33248, -1, -1, -1}, {33249, -1, -1, -1}, {34374, -1, -1, -1}, {34375, -1, -1, -1}, {34376, -1, -1, -1}, {35193, -1, -1, -1}, {35194, -1, -1, -1}, {35196, -1, -1, -1}, {35195, -1, -1, -1}, {35327, -1, -1, -1}, {35736, -1, -1, -1}, {35737, -1, -1, -1}, {36517, -1, -1, -1}, {36516, -1, -1, -1}, {36515, -1, -1, -1}, {37998, -1, -1, -1}, {37997, -1, -1, -1}, {37999, -1, -1, -1}, {38001, -1, -1, -1}, {38003, -1, -1, -1}, {38729, -1, -1, -1}, {39026, -1, -1, -1}, {39263, -1, -1, -1}, {40040, -1, -1, -1}, {40046, -1, -1, -1}, {40045, -1, -1, -1}, {40459, -1, -1, -1}, {40461, -1, -1, -1}, {40464, -1, -1, -1}, {40463, -1, -1, -1}, {40466, -1, -1, -1}, {40465, -1, -1, -1}, {40609, -1, -1, -1}, {40693, -1, -1, -1}, {40713, -1, -1, -1} },
    {{40775, -1, -1, -1}, {40824, -1, -1, -1}, {40827, -1, -1, -1}, {40826, -1, -1, -1}, {40825, -1, -1, -1}, {22302, -1, -1, -1}, {28774, -1, -1, -1}, {31855, -1, -1, -1}, {34876, -1, -1, -1}, {36274, -1, -1, -1}, {36518, -1, -1, -1}, {37315, -1, -1, -1}, {38004, -1, -1, -1}, {38008, -1, -1, -1}, {38006, -1, -1, -1}, {38005, -1, -1, -1}, {39520, -1, -1, -1}, {39726, -1, -1, -1}, {40052, -1, -1, -1}, {40051, -1, -1, -1}, {40049, -1, -1, -1}, {40053, -1, -1, -1}, {40468, -1, -1, -1}, {40467, -1, -1, -1}, {40694, -1, -1, -1}, {40714, -1, -1, -1}, {40868, -1, -1, -1}, {28776, -1, -1, -1}, {28773, -1, -1, -1}, {31991, -1, -1, -1}, {34410, -1, -1, -1}, {34878, -1, -1, -1}, {34877, -1, -1, -1}, {34879, -1, -1, -1}, {35742, -1, -1, -1}, {35996, -1, -1, -1}, {36521, -1, -1, -1}, {36553, -1, -1, -1}, {38731, -1, -1, -1}, {39027, -1, -1, -1}, {39028, -1, -1, -1}, {39116, -1, -1, -1}, {39265, -1, -1, -1}, {39339, -1, -1, -1}, {39524, -1, -1, -1}, {39526, -1, -1, -1}, {39527, -1, -1, -1}, {39716, -1, -1, -1}, {40469, -1, -1, -1}, {40471, -1, -1, -1}, {40776, -1, -1, -1}, {25095, -1, -1, -1}, {27422, -1, -1, -1}, {29223, -1, -1, -1}, {34380, -1, -1, -1}, {36520, -1, -1, -1}, {38018, -1, -1, -1}, {38016, -1, -1, -1}, {38017, -1, -1, -1}, {39529, -1, -1, -1}, {39528, -1, -1, -1}, {40473, -1, -1, -1}, {34379, -1, -1, -1}, {35743, -1, -1, -1}, {38019, -1, -1, -1}, {40057, -1, -1, -1}, {40631, -1, -1, -1}, {30325, -1, -1, -1}, {39531, -1, -1, -1}, {40058, -1, -1, -1}, {40477, -1, -1, -1}, {28777, -1, -1, -1}, {28778, -1, -1, -1}, {29225, -1, -1, -1}, {40612, -1, -1, -1}, {40830, -1, -1, -1}, {40777, -1, -1, -1}, {40856, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {65075, -1, -1, -1}, {-1, -1, -1, -1}, {65076, 65103, -1, -1}, {65103, -1, -1, -1}, {776, 168, -1, -1}, {710, 65342, -1, -1}, {12541, -1, -1, -1}, {12542, -1, -1, -1}, {12445, -1, -1, -1}, {12446, -1, -1, -1}, {-1, -1, -1, -1}, {12293, -1, -1, -1}, {12294, -1, -1, -1}, {12295, -1, -1, -1}, {12540, -1, -1, -1}, {65339, -1, -1, -1}, {65341, -1, -1, -1}, {10045, -1, -1, -1}, {12353, -1, -1, -1}, {12354, -1, -1, -1}, {12355, -1, -1, -1}, {12356, -1, -1, -1}, {12357, -1, -1, -1}, {12358, -1, -1, -1}, {12359, -1, -1, -1}, {12360, -1, -1, -1}, {12361, -1, -1, -1}, {12362, -1, -1, -1}, {12363, -1, -1, -1}, {12364, -1, -1, -1}, {12365, -1, -1, -1}, {12366, -1, -1, -1}, {12367, -1, -1, -1}, {12368, -1, -1, -1}, {12369, -1, -1, -1}, {12370, -1, -1, -1}, {12371, -1, -1, -1}, {12372, -1, -1, -1}, {12373, -1, -1, -1}, {12374, -1, -1, -1}, {12375, -1, -1, -1}, {12376, -1, -1, -1}, {12377, -1, -1, -1}, {12378, -1, -1, -1}, {12379, -1, -1, -1}, {12380, -1, -1, -1}, {12381, -1, -1, -1}, {12382, -1, -1, -1}, {12383, -1, -1, -1}, {12384, -1, -1, -1}, {12385, -1, -1, -1}, {12386, -1, -1, -1}, {12387, -1, -1, -1}, {12388, -1, -1, -1}, {12389, -1, -1, -1}, {12390, -1, -1, -1}, {12391, -1, -1, -1}, {12392, -1, -1, -1}, {12393, -1, -1, -1}, {12394, -1, -1, -1}, {12395, -1, -1, -1}, {12396, -1, -1, -1}, {12397, -1, -1, -1}, {12398, -1, -1, -1}, {12399, -1, -1, -1}, {12400, -1, -1, -1}, {12401, -1, -1, -1}, {12402, -1, -1, -1}, {12403, -1, -1, -1}, {12404, -1, -1, -1}, {12405, -1, -1, -1}, {12406, -1, -1, -1}, {12407, -1, -1, -1}, {12408, -1, -1, -1}, {12409, -1, -1, -1}, {12410, -1, -1, -1}, {12411, -1, -1, -1}, {12412, -1, -1, -1}, {12413, -1, -1, -1}, {12414, -1, -1, -1}, {12415, -1, -1, -1} },
    {{12416, -1, -1, -1}, {12417, -1, -1, -1}, {12418, -1, -1, -1}, {12419, -1, -1, -1}, {12420, -1, -1, -1}, {12421, -1, -1, -1}, {12422, -1, -1, -1}, {12423, -1, -1, -1}, {12424, -1, -1, -1}, {12425, -1, -1, -1}, {12426, -1, -1, -1}, {12427, -1, -1, -1}, {12428, -1, -1, -1}, {12429, -1, -1, -1}, {12430, -1, -1, -1}, {12431, -1, -1, -1}, {12432, -1, -1, -1}, {12433, -1, -1, -1}, {12434, -1, -1, -1}, {12435, -1, -1, -1}, {12449, -1, -1, -1}, {12450, -1, -1, -1}, {12451, -1, -1, -1}, {12452, -1, -1, -1}, {12453, -1, -1, -1}, {12454, -1, -1, -1}, {12455, -1, -1, -1}, {12456, -1, -1, -1}, {12457, -1, -1, -1}, {12458, -1, -1, -1}, {12459, -1, -1, -1}, {12460, -1, -1, -1}, {12461, -1, -1, -1}, {12462, -1, -1, -1}, {12463, -1, -1, -1}, {12464, -1, -1, -1}, {12465, -1, -1, -1}, {12466, -1, -1, -1}, {12467, -1, -1, -1}, {12468, -1, -1, -1}, {12469, -1, -1, -1}, {12470, -1, -1, -1}, {12471, -1, -1, -1}, {12472, -1, -1, -1}, {12473, -1, -1, -1}, {12474, -1, -1, -1}, {12475, -1, -1, -1}, {12476, -1, -1, -1}, {12477, -1, -1, -1}, {12478, -1, -1, -1}, {12479, -1, -1, -1}, {12480, -1, -1, -1}, {12481, -1, -1, -1}, {12482, -1, -1, -1}, {12483, -1, -1, -1}, {12484, -1, -1, -1}, {12485, -1, -1, -1}, {12486, -1, -1, -1}, {12487, -1, -1, -1}, {12488, -1, -1, -1}, {12489, -1, -1, -1}, {12490, -1, -1, -1}, {12491, -1, -1, -1}, {12492, -1, -1, -1}, {12493, -1, -1, -1}, {12494, -1, -1, -1}, {12495, -1, -1, -1}, {12496, -1, -1, -1}, {12497, -1, -1, -1}, {12498, -1, -1, -1}, {12499, -1, -1, -1}, {12500, -1, -1, -1}, {12501, -1, -1, -1}, {12502, -1, -1, -1}, {12503, -1, -1, -1}, {12504, -1, -1, -1}, {12505, -1, -1, -1}, {12506, -1, -1, -1}, {12507, -1, -1, -1}, {12508, -1, -1, -1}, {12509, -1, -1, -1}, {12510, -1, -1, -1}, {12511, -1, -1, -1}, {12512, -1, -1, -1}, {12513, -1, -1, -1}, {12514, -1, -1, -1}, {12515, -1, -1, -1}, {12516, -1, -1, -1}, {12517, -1, -1, -1}, {12518, -1, -1, -1}, {12519, -1, -1, -1}, {12520, -1, -1, -1}, {12521, -1, -1, -1}, {12522, -1, -1, -1}, {12523, -1, -1, -1}, {12524, -1, -1, -1}, {12525, -1, -1, -1}, {12526, -1, -1, -1}, {12527, -1, -1, -1}, {12528, -1, -1, -1}, {12529, -1, -1, -1}, {12530, -1, -1, -1}, {12531, -1, -1, -1}, {12532, -1, -1, -1}, {12533, -1, -1, -1}, {12534, -1, -1, -1}, {1040, -1, -1, -1}, {1041, -1, -1, -1}, {1042, -1, -1, -1}, {1043, -1, -1, -1}, {1044, -1, -1, -1}, {1045, -1, -1, -1}, {1025, -1, -1, -1}, {1046, -1, -1, -1}, {1047, -1, -1, -1}, {1048, -1, -1, -1}, {1049, -1, -1, -1}, {1050, -1, -1, -1}, {1051, -1, -1, -1}, {1052, -1, -1, -1}, {1053, -1, -1, -1}, {1054, -1, -1, -1}, {1055, -1, -1, -1}, {1056, -1, -1, -1}, {1057, -1, -1, -1}, {1058, -1, -1, -1}, {1059, -1, -1, -1}, {1060, -1, -1, -1}, {1061, -1, -1, -1}, {1062, -1, -1, -1}, {1063, -1, -1, -1}, {1064, -1, -1, -1}, {1065, -1, -1, -1}, {1066, -1, -1, -1}, {1067, -1, -1, -1}, {1068, -1, -1, -1}, {1069, -1, -1, -1}, {1070, -1, -1, -1}, {1071, -1, -1, -1}, {1072, -1, -1, -1}, {1073, -1, -1, -1}, {1074, -1, -1, -1}, {1075, -1, -1, -1}, {1076, -1, -1, -1}, {1077, -1, -1, -1}, {1105, -1, -1, -1}, {1078, -1, -1, -1}, {1079, -1, -1, -1}, {1080, -1, -1, -1}, {1081, -1, -1, -1}, {1082, -1, -1, -1}, {1083, -1, -1, -1}, {1084, -1, -1, -1}, {1085, -1, -1, -1}, {1086, -1, -1, -1}, {1087, -1, -1, -1}, {1088, -1, -1, -1}, {1089, -1, -1, -1}, {1090, -1, -1, -1}, {1091, -1, -1, -1}, {1092, -1, -1, -1}, {1093, -1, -1, -1}, {1094, -1, -1, -1}, {1095, -1, -1, -1}, {1096, -1, -1, -1}, {1097, -1, -1, -1}, {1098, -1, -1, -1}, {1099, -1, -1, -1}, {1100, -1, -1, -1}, {1101, -1, -1, -1}, {1102, -1, -1, -1}, {1103, -1, -1, -1}, {8679, -1, -1, -1}, {8632, -1, -1, -1}, {8633, -1, -1, -1}, {20033, 63461, -1, -1}, {63462, -1, -1, -1}, {20058, -1, -1, -1}, {63464, -1, -1, -1}, {20994, -1, -1, -1}, {63466, -1, -1, -1}, {63467, -1, -1, -1}, {20872, -1, -1, -1}, {63469, -1, -1, -1}, {63470, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {172, 65506, -1, -1}, {65508, -1, -1, -1}, {65287, -1, -1, -1}, {65282, -1, -1, -1}, {12849, -1, -1, -1}, {8470, -1, -1, -1}, {8481, -1, -1, -1}, {30849, -1, -1, -1}, {37561, -1, -1, -1}, {35023, -1, -1, -1}, {22715, -1, -1, -1}, {24658, -1, -1, -1}, {31911, -1, -1, -1}, {23290, -1, -1, -1}, {9556, -1, -1, -1}, {9574, -1, -1, -1}, {9559, -1, -1, -1}, {9568, -1, -1, -1}, {9580, -1, -1, -1}, {9571, -1, -1, -1}, {9562, -1, -1, -1}, {9577, -1, -1, -1}, {9565, -1, -1, -1}, {9554, -1, -1, -1}, {9572, -1, -1, -1}, {9557, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {9560, -1, -1, -1}, {9575, -1, -1, -1} },
    {{9563, -1, -1, -1}, {9555, -1, -1, -1}, {9573, -1, -1, -1}, {9558, -1, -1, -1}, {9567, -1, -1, -1}, {9579, -1, -1, -1}, {9570, -1, -1, -1}, {9561, -1, -1, -1}, {9576, -1, -1, -1}, {9564, -1, -1, -1}, {9553, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {9619, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {58129, -1, -1, -1}, {22462, -1, -1, -1}, {58131, -1, -1, -1}, {28990, -1, -1, -1}, {58133, -1, -1, -1}, {27042, -1, -1, -1}, {58136, -1, -1, -1}, {23412, -1, -1, -1}, {31305, -1, -1, -1}, {58139, -1, -1, -1}, {58140, -1, -1, -1}, {31333, -1, -1, -1}, {31357, -1, -1, -1}, {58143, -1, -1, -1}, {31419, -1, -1, -1}, {31408, -1, -1, -1}, {31426, -1, -1, -1}, {31427, -1, -1, -1}, {29137, -1, -1, -1}, {58149, -1, -1, -1}, {16842, -1, -1, -1}, {31450, -1, -1, -1}, {31453, -1, -1, -1}, {31466, -1, -1, -1}, {16879, -1, -1, -1}, {21682, -1, -1, -1}, {58156, -1, -1, -1}, {31499, -1, -1, -1}, {31573, -1, -1, -1}, {31529, -1, -1, -1}, {58160, -1, -1, -1}, {58161, -1, -1, -1}, {31650, -1, -1, -1}, {31599, -1, -1, -1}, {33692, -1, -1, -1}, {58165, -1, -1, -1}, {58166, -1, -1, -1}, {31696, -1, -1, -1}, {33825, -1, -1, -1}, {31634, -1, -1, -1}, {-1, -1, -1, -1}, {58171, -1, -1, -1}, {-1, -1, -1, -1}, {33938, -1, -1, -1}, {31738, -1, -1, -1}, {-1, -1, -1, -1}, {31797, -1, -1, -1}, {58178, -1, -1, -1}, {31812, -1, -1, -1}, {31875, -1, -1, -1}, {58181, -1, -1, -1}, {31910, -1, -1, -1}, {58184, -1, -1, -1}, {31945, -1, -1, -1}, {31943, -1, -1, -1}, {31974, -1, -1, -1}, {-1, -1, -1, -1}, {31987, -1, -1, -1}, {31989, -1, -1, -1}, {32359, -1, -1, -1}, {17693, -1, -1, -1}, {58194, -1, -1, -1}, {32093, -1, -1, -1}, {58196, -1, -1, -1}, {32137, -1, -1, -1}, {32171, -1, -1, -1}, {28981, -1, -1, -1}, {32179, -1, -1, -1}, {32214, -1, -1, -1}, {58203, -1, -1, -1}, {58204, -1, -1, -1}, {32228, -1, -1, -1}, {15635, -1, -1, -1}, {32245, -1, -1, -1}, {58208, -1, -1, -1}, {32229, -1, -1, -1}, {58210, -1, -1, -1}, {-1, -1, -1, -1}, {58212, -1, -1, -1}, {58213, -1, -1, -1}, {32366, -1, -1, -1}, {-1, -1, -1, -1}, {17195, -1, -1, -1}, {37996, -1, -1, -1}, {32295, -1, -1, -1}, {32576, -1, -1, -1}, {32577, -1, -1, -1}, {32583, -1, -1, -1}, {31030, -1, -1, -1}, {58223, -1, -1, -1}, {39393, -1, -1, -1}, {32663, -1, -1, -1}, {58226, -1, -1, -1}, {32675, -1, -1, -1}, {58228, -1, -1, -1}, {58229, -1, -1, -1}, {17756, -1, -1, -1}, {58231, -1, -1, -1}, {58233, -1, -1, -1}, {32762, -1, -1, -1}, {58235, -1, -1, -1}, {-1, -1, -1, -1}, {32776, -1, -1, -1}, {32797, -1, -1, -1}, {-1, -1, -1, -1}, {32815, -1, -1, -1}, {58241, -1, -1, -1}, {58242, -1, -1, -1}, {32827, -1, -1, -1}, {32828, -1, -1, -1}, {32865, -1, -1, -1}, {58246, -1, -1, -1}, {18825, -1, -1, -1}, {58248, -1, -1, -1}, {58249, -1, -1, -1}, {58250, -1, -1, -1}, {26405, -1, -1, -1}, {32935, -1, -1, -1}, {58253, -1, -1, -1}, {33031, -1, -1, -1}, {33050, -1, -1, -1}, {22704, -1, -1, -1}, {58257, -1, -1, -1}, {27775, -1, -1, -1}, {58259, -1, -1, -1}, {25831, -1, -1, -1}, {58262, -1, -1, -1}, {33304, -1, -1, -1}, {58264, -1, -1, -1}, {27219, -1, -1, -1}, {58266, -1, -1, -1}, {58267, -1, -1, -1}, {17530, -1, -1, -1}, {33321, -1, -1, -1}, {58271, -1, -1, -1}, {58272, -1, -1, -1}, {20473, -1, -1, -1}, {58274, -1, -1, -1}, {34018, -1, -1, -1}, {33634, -1, -1, -1}, {-1, -1, -1, -1}, {58278, -1, -1, -1}, {58279, -1, -1, -1}, {58280, -1, -1, -1}, {58281, -1, -1, -1}, {33450, -1, -1, -1}, {26907, -1, -1, -1}, {58284, -1, -1, -1}, {16859, -1, -1, -1}, {34123, -1, -1, -1}, {33488, -1, -1, -1}, {33562, -1, -1, -1}, {58289, -1, -1, -1}, {58290, -1, -1, -1}, {14017, -1, -1, -1}, {58292, -1, -1, -1}, {58293, -1, -1, -1}, {33403, -1, -1, -1}, {33506, -1, -1, -1}, {33560, -1, -1, -1}, {58297, -1, -1, -1}, {58298, -1, -1, -1}, {58299, -1, -1, -1}, {58300, -1, -1, -1}, {58301, -1, -1, -1}, {15807, -1, -1, -1}, {33565, -1, -1, -1}, {21996, -1, -1, -1}, {33669, -1, -1, -1}, {17675, -1, -1, -1}, {58307, -1, -1, -1}, {33708, -1, -1, -1}, {-1, -1, -1, -1}, {33747, -1, -1, -1}, {58312, -1, -1, -1}, {27223, -1, -1, -1}, {34138, -1, -1, -1}, {13462, -1, -1, -1}, {58316, -1, -1, -1}, {33880, -1, -1, -1}, {58319, -1, -1, -1}, {33905, -1, -1, -1}, {15827, -1, -1, -1}, {17636, -1, -1, -1}, {27303, -1, -1, -1}, {33866, -1, -1, -1}, {31064, -1, -1, -1}, {-1, -1, -1, -1}, {58328, -1, -1, -1}, {58329, -1, -1, -1}, {58330, -1, -1, -1}, {34014, -1, -1, -1}, {-1, -1, -1, -1}, {33681, -1, -1, -1}, {17568, -1, -1, -1}, {33939, -1, -1, -1}, {34020, -1, -1, -1}, {58337, -1, -1, -1}, {16960, -1, -1, -1}, {58339, -1, -1, -1}, {17731, -1, -1, -1}, {34100, -1, -1, -1}, {23282, -1, -1, -1}, {-1, -1, -1, -1}, {17703, -1, -1, -1}, {34163, -1, -1, -1}, {17686, -1, -1, -1}, {26559, -1, -1, -1}, {34326, -1, -1, -1}, {58349, -1, -1, -1}, {58350, -1, -1, -1}, {34241, -1, -1, -1}, {58352, -1, -1, -1} },
    {{34306, -1, -1, -1}, {58354, -1, -1, -1}, {58355, -1, -1, -1}, {58356, -1, -1, -1}, {17770, -1, -1, -1}, {34344, -1, -1, -1}, {13896, -1, -1, -1}, {58360, -1, -1, -1}, {21495, -1, -1, -1}, {58362, -1, -1, -1}, {34430, -1, -1, -1}, {34673, -1, -1, -1}, {58365, -1, -1, -1}, {34798, -1, -1, -1}, {58367, -1, -1, -1}, {34737, -1, -1, -1}, {34778, -1, -1, -1}, {34831, -1, -1, -1}, {22113, -1, -1, -1}, {34412, -1, -1, -1}, {26710, -1, -1, -1}, {17935, -1, -1, -1}, {34885, -1, -1, -1}, {34886, -1, -1, -1}, {58377, -1, -1, -1}, {58378, -1, -1, -1}, {58379, -1, -1, -1}, {34910, -1, -1, -1}, {34972, -1, -1, -1}, {18011, -1, -1, -1}, {34996, -1, -1, -1}, {34997, -1, -1, -1}, {35013, -1, -1, -1}, {58388, -1, -1, -1}, {35207, -1, -1, -1}, {35210, -1, -1, -1}, {-1, -1, -1, -1}, {35241, -1, -1, -1}, {35239, -1, -1, -1}, {35260, -1, -1, -1}, {58395, -1, -1, -1}, {35303, -1, -1, -1}, {58397, -1, -1, -1}, {58398, -1, -1, -1}, {35484, -1, -1, -1}, {30611, -1, -1, -1}, {37374, -1, -1, -1}, {35472, -1, -1, -1}, {58403, -1, -1, -1}, {31465, -1, -1, -1}, {58405, -1, -1, -1}, {18195, -1, -1, -1}, {58408, -1, -1, -1}, {29052, -1, -1, -1}, {35596, -1, -1, -1}, {35615, -1, -1, -1}, {58412, -1, -1, -1}, {58413, -1, -1, -1}, {35647, -1, -1, -1}, {35660, -1, -1, -1}, {35661, -1, -1, -1}, {35497, -1, -1, -1}, {58418, -1, -1, -1}, {35728, -1, -1, -1}, {35739, -1, -1, -1}, {35503, -1, -1, -1}, {58422, -1, -1, -1}, {17941, -1, -1, -1}, {34895, -1, -1, -1}, {35995, -1, -1, -1}, {58426, -1, -1, -1}, {58427, -1, -1, -1}, {58428, -1, -1, -1}, {14117, -1, -1, -1}, {58430, -1, -1, -1}, {36054, -1, -1, -1}, {58432, -1, -1, -1}, {58433, -1, -1, -1}, {36114, -1, -1, -1}, {36099, -1, -1, -1}, {58436, -1, -1, -1}, {36059, -1, -1, -1}, {28764, -1, -1, -1}, {36113, -1, -1, -1}, {16080, -1, -1, -1}, {-1, -1, -1, -1}, {36265, -1, -1, -1}, {58444, -1, -1, -1}, {58445, -1, -1, -1}, {58446, -1, -1, -1}, {15228, -1, -1, -1}, {58448, -1, -1, -1}, {58449, -1, -1, -1}, {31463, -1, -1, -1}, {36525, -1, -1, -1}, {36534, -1, -1, -1}, {36547, -1, -1, -1}, {37588, -1, -1, -1}, {36633, -1, -1, -1}, {36653, -1, -1, -1}, {58457, -1, -1, -1}, {58458, -1, -1, -1}, {36773, -1, -1, -1}, {37635, -1, -1, -1}, {58461, -1, -1, -1}, {58462, -1, -1, -1}, {36787, -1, -1, -1}, {-1, -1, -1, -1}, {58465, -1, -1, -1}, {58466, -1, -1, -1}, {58467, -1, -1, -1}, {24312, -1, -1, -1}, {58469, -1, -1, -1}, {36857, -1, -1, -1}, {-1, -1, -1, -1}, {58474, -1, -1, -1}, {14720, -1, -1, -1}, {58476, -1, -1, -1}, {36919, -1, -1, -1}, {58478, -1, -1, -1}, {58479, -1, -1, -1}, {36961, -1, -1, -1}, {58481, -1, -1, -1}, {58482, -1, -1, -1}, {37032, -1, -1, -1}, {58484, -1, -1, -1}, {37060, -1, -1, -1}, {58486, -1, -1, -1}, {37038, -1, -1, -1}, {-1, -1, -1, -1}, {37223, -1, -1, -1}, {37289, -1, -1, -1}, {37316, -1, -1, -1}, {31916, -1, -1, -1}, {58494, -1, -1, -1}, {58495, -1, -1, -1}, {37390, -1, -1, -1}, {27807, -1, -1, -1}, {37441, -1, -1, -1}, {37474, -1, -1, -1}, {58500, -1, -1, -1}, {58502, -1, -1, -1}, {58503, -1, -1, -1}, {58504, -1, -1, -1}, {58505, -1, -1, -1}, {58506, -1, -1, -1}, {37676, -1, -1, -1}, {37739, -1, -1, -1}, {58509, -1, -1, -1}, {58510, -1, -1, -1}, {23235, -1, -1, -1}, {58513, -1, -1, -1}, {58514, -1, -1, -1}, {18789, -1, -1, -1}, {37444, -1, -1, -1}, {58517, -1, -1, -1}, {58518, -1, -1, -1}, {58519, -1, -1, -1}, {37747, -1, -1, -1}, {37979, -1, -1, -1}, {36540, -1, -1, -1}, {38277, -1, -1, -1}, {38310, -1, -1, -1}, {37926, -1, -1, -1}, {38304, -1, -1, -1}, {28662, -1, -1, -1}, {17081, -1, -1, -1}, {58530, -1, -1, -1}, {58531, -1, -1, -1}, {58532, -1, -1, -1}, {18911, -1, -1, -1}, {27676, -1, -1, -1}, {38523, -1, -1, -1}, {38550, -1, -1, -1}, {16748, -1, -1, -1}, {38563, -1, -1, -1}, {58539, -1, -1, -1}, {25050, -1, -1, -1}, {-1, -1, -1, -1}, {30965, -1, -1, -1}, {58543, -1, -1, -1}, {38589, -1, -1, -1}, {21452, -1, -1, -1}, {18849, -1, -1, -1}, {58547, -1, -1, -1}, {58548, -1, -1, -1}, {58549, -1, -1, -1}, {58550, -1, -1, -1}, {58551, -1, -1, -1}, {58552, -1, -1, -1}, {58553, -1, -1, -1}, {58554, -1, -1, -1}, {38705, -1, -1, -1}, {34370, -1, -1, -1}, {38710, -1, -1, -1}, {18959, -1, -1, -1}, {17725, -1, -1, -1}, {17797, -1, -1, -1}, {58561, -1, -1, -1}, {28789, -1, -1, -1}, {23361, -1, -1, -1}, {38683, -1, -1, -1}, {-1, -1, -1, -1}, {58566, -1, -1, -1}, {38743, -1, -1, -1}, {23370, -1, -1, -1}, {58569, -1, -1, -1}, {38751, -1, -1, -1}, {37925, -1, -1, -1}, {20688, -1, -1, -1}, {58573, -1, -1, -1}, {58574, -1, -1, -1}, {38793, -1, -1, -1}, {38815, -1, -1, -1}, {38833, -1, -1, -1}, {38846, -1, -1, -1}, {38848, -1, -1, -1}, {38866, -1, -1, -1}, {38880, -1, -1, -1}, {58582, -1, -1, -1}, {38894, -1, -1, -1}, {29724, -1, -1, -1}, {58585, -1, -1, -1}, {-1, -1, -1, -1}, {38901, -1, -1, -1}, {58588, -1, -1, -1}, {58589, -1, -1, -1}, {19153, -1, -1, -1}, {38964, -1, -1, -1}, {38963, -1, -1, -1}, {38987, -1, -1, -1}, {39014, -1, -1, -1}, {15118, -1, -1, -1}, {58596, -1, -1, -1}, {15697, -1, -1, -1}, {58598, -1, -1, -1}, {58599, -1, -1, -1}, {58600, -1, -1, -1}, {39114, -1, -1, -1}, {39095, -1, -1, -1}, {39112, -1, -1, -1}, {39111, -1, -1, -1}, {19199, -1, -1, -1}, {58606, -1, -1, -1}, {58607, -1, -1, -1}, {21936, -1, -1, -1}, {39137, -1, -1, -1}, {39142, -1, -1, -1}, {39148, -1, -1, -1}, {37752, -1, -1, -1}, {39225, -1, -1, -1}, {58614, -1, -1, -1}, {19314, -1, -1, -1}, {58616, -1, -1, -1}, {58617, -1, -1, -1}, {39413, -1, -1, -1} },
    {{39436, -1, -1, -1}, {39483, -1, -1, -1}, {39440, -1, -1, -1}, {39512, -1, -1, -1}, {58623, -1, -1, -1}, {14020, -1, -1, -1}, {58625, -1, -1, -1}, {58626, -1, -1, -1}, {39648, -1, -1, -1}, {39650, -1, -1, -1}, {58629, -1, -1, -1}, {39668, -1, -1, -1}, {19470, -1, -1, -1}, {39700, -1, -1, -1}, {39725, -1, -1, -1}, {58634, -1, -1, -1}, {20532, -1, -1, -1}, {39732, -1, -1, -1}, {14531, -1, -1, -1}, {58639, -1, -1, -1}, {39760, -1, -1, -1}, {39744, -1, -1, -1}, {58642, -1, -1, -1}, {23109, -1, -1, -1}, {58644, -1, -1, -1}, {39822, -1, -1, -1}, {39938, -1, -1, -1}, {39935, -1, -1, -1}, {39948, -1, -1, -1}, {58650, -1, -1, -1}, {40404, -1, -1, -1}, {58652, -1, -1, -1}, {58653, -1, -1, -1}, {58654, -1, -1, -1}, {58655, -1, -1, -1}, {58656, -1, -1, -1}, {58657, -1, -1, -1}, {40318, -1, -1, -1}, {40323, -1, -1, -1}, {58660, -1, -1, -1}, {40462, -1, -1, -1}, {40388, -1, -1, -1}, {58665, -1, -1, -1}, {58666, -1, -1, -1}, {58667, -1, -1, -1}, {58668, -1, -1, -1}, {40249, -1, -1, -1}, {58670, -1, -1, -1}, {58671, -1, -1, -1}, {40592, -1, -1, -1}, {40597, -1, -1, -1}, {40606, -1, -1, -1}, {40610, -1, -1, -1}, {19764, -1, -1, -1}, {40618, -1, -1, -1}, {40623, -1, -1, -1}, {58679, -1, -1, -1}, {40641, -1, -1, -1}, {15200, -1, -1, -1}, {14821, -1, -1, -1}, {15645, -1, -1, -1}, {20274, -1, -1, -1}, {14270, -1, -1, -1}, {58686, -1, -1, -1}, {40706, -1, -1, -1}, {40712, -1, -1, -1}, {19350, -1, -1, -1}, {37924, -1, -1, -1}, {58691, -1, -1, -1}, {40727, -1, -1, -1}, {-1, -1, -1, -1}, {40761, -1, -1, -1}, {22175, -1, -1, -1}, {22154, -1, -1, -1}, {40773, -1, -1, -1}, {39352, -1, -1, -1}, {58699, -1, -1, -1}, {38898, -1, -1, -1}, {33919, -1, -1, -1}, {40802, -1, -1, -1}, {40809, -1, -1, -1}, {31452, -1, -1, -1}, {40846, -1, -1, -1}, {29206, -1, -1, -1}, {19390, -1, -1, -1}, {58708, -1, -1, -1}, {58709, -1, -1, -1}, {29047, -1, -1, -1}, {58711, -1, -1, -1}, {58712, -1, -1, -1}, {58713, -1, -1, -1}, {29598, -1, -1, -1}, {58715, -1, -1, -1}, {58716, -1, -1, -1}, {31135, -1, -1, -1}, {58718, -1, -1, -1}, {58719, -1, -1, -1}, {37737, -1, -1, -1}, {37875, -1, -1, -1}, {58722, -1, -1, -1}, {37612, -1, -1, -1}, {37761, -1, -1, -1}, {37835, -1, -1, -1}, {58726, -1, -1, -1}, {58727, -1, -1, -1}, {29207, -1, -1, -1}, {16107, -1, -1, -1}, {30578, -1, -1, -1}, {31299, -1, -1, -1}, {28880, -1, -1, -1}, {58733, -1, -1, -1}, {58734, -1, -1, -1}, {29054, -1, -1, -1}, {58736, -1, -1, -1}, {28835, -1, -1, -1}, {58738, -1, -1, -1}, {58739, -1, -1, -1}, {16071, -1, -1, -1}, {58741, -1, -1, -1}, {58742, -1, -1, -1}, {58743, -1, -1, -1}, {14114, -1, -1, -1}, {58745, -1, -1, -1}, {58746, -1, -1, -1}, {14049, -1, -1, -1}, {58748, -1, -1, -1}, {58749, -1, -1, -1}, {58750, -1, -1, -1}, {14115, -1, -1, -1}, {58752, -1, -1, -1}, {22363, -1, -1, -1}, {58754, -1, -1, -1}, {58755, -1, -1, -1}, {58756, -1, -1, -1}, {58757, -1, -1, -1}, {58758, -1, -1, -1}, {-1, -1, -1, -1}, {58760, -1, -1, -1}, {34051, -1, -1, -1}, {33877, -1, -1, -1}, {58763, -1, -1, -1}, {58764, -1, -1, -1}, {58765, -1, -1, -1}, {58766, -1, -1, -1}, {58767, -1, -1, -1}, {58768, -1, -1, -1}, {17652, -1, -1, -1}, {58770, -1, -1, -1}, {58771, -1, -1, -1}, {58772, -1, -1, -1}, {26617, -1, -1, -1}, {14131, -1, -1, -1}, {15381, -1, -1, -1}, {15847, -1, -1, -1}, {22636, -1, -1, -1}, {58778, -1, -1, -1}, {26640, -1, -1, -1}, {16471, -1, -1, -1}, {58781, -1, -1, -1}, {58782, -1, -1, -1}, {58783, -1, -1, -1}, {58784, -1, -1, -1}, {58785, -1, -1, -1}, {21707, -1, -1, -1}, {22174, -1, -1, -1}, {58788, -1, -1, -1}, {22162, -1, -1, -1}, {58790, -1, -1, -1}, {58791, -1, -1, -1}, {58792, -1, -1, -1}, {37830, -1, -1, -1}, {58794, -1, -1, -1}, {37788, -1, -1, -1}, {20216, -1, -1, -1}, {20779, -1, -1, -1}, {14361, -1, -1, -1}, {58799, -1, -1, -1}, {20156, -1, -1, -1}, {58801, -1, -1, -1}, {-1, -1, -1, -1}, {20299, -1, -1, -1}, {20362, -1, -1, -1}, {58805, -1, -1, -1}, {23144, -1, -1, -1}, {58807, -1, -1, -1}, {58808, -1, -1, -1}, {14745, -1, -1, -1}, {58810, -1, -1, -1}, {58811, -1, -1, -1}, {13365, -1, -1, -1}, {20265, -1, -1, -1}, {58814, -1, -1, -1}, {58815, -1, -1, -1}, {58816, -1, -1, -1}, {35546, -1, -1, -1}, {58818, -1, -1, -1}, {20120, -1, -1, -1}, {20685, -1, -1, -1}, {20749, -1, -1, -1}, {20386, -1, -1, -1}, {20227, -1, -1, -1}, {58824, -1, -1, -1}, {58825, -1, -1, -1}, {20290, -1, -1, -1}, {20526, -1, -1, -1}, {20588, -1, -1, -1}, {20609, -1, -1, -1}, {20428, -1, -1, -1}, {20453, -1, -1, -1}, {20568, -1, -1, -1}, {20732, -1, -1, -1}, {28278, -1, -1, -1}, {58839, -1, -1, -1}, {58840, -1, -1, -1}, {58841, -1, -1, -1}, {28018, -1, -1, -1}, {58843, -1, -1, -1}, {58844, -1, -1, -1}, {20904, -1, -1, -1}, {20931, -1, -1, -1}, {58847, -1, -1, -1}, {17629, -1, -1, -1}, {58849, -1, -1, -1}, {58850, -1, -1, -1}, {58851, -1, -1, -1}, {36218, -1, -1, -1}, {58853, -1, -1, -1}, {58854, -1, -1, -1}, {21081, -1, -1, -1}, {21156, -1, -1, -1}, {58857, -1, -1, -1}, {21217, -1, -1, -1}, {37742, -1, -1, -1}, {18042, -1, -1, -1}, {29068, -1, -1, -1}, {58862, -1, -1, -1}, {58863, -1, -1, -1}, {58864, -1, -1, -1}, {58865, -1, -1, -1}, {27089, -1, -1, -1}, {58867, -1, -1, -1}, {-1, -1, -1, -1}, {16094, -1, -1, -1}, {29849, -1, -1, -1}, {29716, -1, -1, -1}, {29782, -1, -1, -1}, {29592, -1, -1, -1}, {19342, -1, -1, -1}, {58875, -1, -1, -1}, {58876, -1, -1, -1}, {21456, -1, -1, -1}, {13700, -1, -1, -1}, {29199, -1, -1, -1}, {58880, -1, -1, -1}, {21940, -1, -1, -1}, {58882, -1, -1, -1} },
    {{21709, -1, -1, -1}, {58884, -1, -1, -1}, {22301, -1, -1, -1}, {37469, -1, -1, -1}, {38644, -1, -1, -1}, {22493, -1, -1, -1}, {22413, -1, -1, -1}, {22399, -1, -1, -1}, {13886, -1, -1, -1}, {22731, -1, -1, -1}, {23193, -1, -1, -1}, {58895, -1, -1, -1}, {58896, -1, -1, -1}, {58897, -1, -1, -1}, {58898, -1, -1, -1}, {23084, -1, -1, -1}, {22968, -1, -1, -1}, {23166, -1, -1, -1}, {-1, -1, -1, -1}, {23058, -1, -1, -1}, {58905, -1, -1, -1}, {58906, -1, -1, -1}, {58907, -1, -1, -1}, {58908, -1, -1, -1}, {14069, -1, -1, -1}, {27909, -1, -1, -1}, {29763, -1, -1, -1}, {23073, -1, -1, -1}, {58913, -1, -1, -1}, {23169, -1, -1, -1}, {58915, -1, -1, -1}, {58916, -1, -1, -1}, {37856, -1, -1, -1}, {29836, -1, -1, -1}, {58919, -1, -1, -1}, {28933, -1, -1, -1}, {18802, -1, -1, -1}, {37896, -1, -1, -1}, {58923, -1, -1, -1}, {37821, -1, -1, -1}, {14240, -1, -1, -1}, {23582, -1, -1, -1}, {23710, -1, -1, -1}, {24158, -1, -1, -1}, {24136, -1, -1, -1}, {58930, -1, -1, -1}, {58931, -1, -1, -1}, {58932, -1, -1, -1}, {24269, -1, -1, -1}, {23375, -1, -1, -1}, {58935, -1, -1, -1}, {58936, -1, -1, -1}, {14081, -1, -1, -1}, {58938, -1, -1, -1}, {14045, -1, -1, -1}, {58940, -1, -1, -1}, {14035, -1, -1, -1}, {33066, -1, -1, -1}, {58943, -1, -1, -1}, {58944, -1, -1, -1}, {58945, -1, -1, -1}, {58946, -1, -1, -1}, {24332, -1, -1, -1}, {24334, -1, -1, -1}, {58949, -1, -1, -1}, {58950, -1, -1, -1}, {23147, -1, -1, -1}, {58952, -1, -1, -1}, {23364, -1, -1, -1}, {58955, -1, -1, -1}, {34912, -1, -1, -1}, {24702, -1, -1, -1}, {58958, -1, -1, -1}, {58959, -1, -1, -1}, {24539, -1, -1, -1}, {16056, -1, -1, -1}, {58962, -1, -1, -1}, {58963, -1, -1, -1}, {58964, -1, -1, -1}, {58965, -1, -1, -1}, {25024, -1, -1, -1}, {58967, -1, -1, -1}, {58968, -1, -1, -1}, {58969, -1, -1, -1}, {24985, -1, -1, -1}, {24984, -1, -1, -1}, {24693, -1, -1, -1}, {58973, -1, -1, -1}, {58974, -1, -1, -1}, {58975, -1, -1, -1}, {58976, -1, -1, -1}, {25713, -1, -1, -1}, {58978, -1, -1, -1}, {58979, -1, -1, -1}, {14889, -1, -1, -1}, {58981, -1, -1, -1}, {58982, -1, -1, -1}, {58983, -1, -1, -1}, {58984, -1, -1, -1}, {25399, -1, -1, -1}, {25782, -1, -1, -1}, {25393, -1, -1, -1}, {25553, -1, -1, -1}, {58990, -1, -1, -1}, {58991, -1, -1, -1}, {25252, -1, -1, -1}, {58993, -1, -1, -1}, {25659, -1, -1, -1}, {25963, -1, -1, -1}, {26994, -1, -1, -1}, {15348, -1, -1, -1}, {58998, -1, -1, -1}, {58999, -1, -1, -1}, {59000, -1, -1, -1}, {59001, -1, -1, -1}, {21773, -1, -1, -1}, {59003, -1, -1, -1}, {59004, -1, -1, -1}, {59005, -1, -1, -1}, {26318, -1, -1, -1}, {59007, -1, -1, -1}, {59008, -1, -1, -1}, {15072, -1, -1, -1}, {59011, -1, -1, -1}, {59012, -1, -1, -1}, {59013, -1, -1, -1}, {59014, -1, -1, -1}, {59015, -1, -1, -1}, {59016, -1, -1, -1}, {30958, -1, -1, -1}, {59018, -1, -1, -1}, {59019, -1, -1, -1}, {59020, -1, -1, -1}, {13412, -1, -1, -1}, {59022, -1, -1, -1}, {59023, -1, -1, -1}, {59024, -1, -1, -1}, {26254, -1, -1, -1}, {59026, -1, -1, -1}, {26219, -1, -1, -1}, {19347, -1, -1, -1}, {26160, -1, -1, -1}, {59030, -1, -1, -1}, {59031, -1, -1, -1}, {26211, -1, -1, -1}, {59033, -1, -1, -1}, {59034, -1, -1, -1}, {26142, -1, -1, -1}, {59036, -1, -1, -1}, {14545, -1, -1, -1}, {59038, -1, -1, -1}, {59039, -1, -1, -1}, {15257, -1, -1, -1}, {59041, -1, -1, -1}, {59042, -1, -1, -1}, {29904, -1, -1, -1}, {15254, -1, -1, -1}, {59046, -1, -1, -1}, {26806, -1, -1, -1}, {-1, -1, -1, -1}, {15300, -1, -1, -1}, {27326, -1, -1, -1}, {59052, -1, -1, -1}, {59053, -1, -1, -1}, {27187, -1, -1, -1}, {27218, -1, -1, -1}, {27337, -1, -1, -1}, {27397, -1, -1, -1}, {59058, -1, -1, -1}, {25873, -1, -1, -1}, {26776, -1, -1, -1}, {27212, -1, -1, -1}, {15319, -1, -1, -1}, {27258, -1, -1, -1}, {27479, -1, -1, -1}, {59065, -1, -1, -1}, {59066, -1, -1, -1}, {37792, -1, -1, -1}, {37618, -1, -1, -1}, {59069, -1, -1, -1}, {59070, -1, -1, -1}, {37513, -1, -1, -1}, {59072, -1, -1, -1}, {59073, -1, -1, -1}, {37991, -1, -1, -1}, {28069, -1, -1, -1}, {28427, -1, -1, -1}, {-1, -1, -1, -1}, {59079, -1, -1, -1}, {15759, -1, -1, -1}, {28164, -1, -1, -1}, {59082, -1, -1, -1}, {23101, -1, -1, -1}, {28170, -1, -1, -1}, {22599, -1, -1, -1}, {27940, -1, -1, -1}, {30786, -1, -1, -1}, {28987, -1, -1, -1}, {59089, -1, -1, -1}, {59090, -1, -1, -1}, {28913, -1, -1, -1}, {29264, -1, -1, -1}, {29319, -1, -1, -1}, {29332, -1, -1, -1}, {59095, -1, -1, -1}, {59096, -1, -1, -1}, {20857, -1, -1, -1}, {59098, -1, -1, -1}, {59099, -1, -1, -1}, {29818, -1, -1, -1}, {59101, -1, -1, -1}, {59102, -1, -1, -1}, {59103, -1, -1, -1}, {59104, -1, -1, -1}, {59105, -1, -1, -1}, {16134, -1, -1, -1}, {16049, -1, -1, -1}, {59108, -1, -1, -1}, {59109, -1, -1, -1}, {59110, -1, -1, -1}, {24743, -1, -1, -1}, {16115, -1, -1, -1}, {29900, -1, -1, -1}, {29756, -1, -1, -1}, {37767, -1, -1, -1}, {29751, -1, -1, -1}, {17567, -1, -1, -1}, {59118, -1, -1, -1}, {17745, -1, -1, -1}, {30083, -1, -1, -1}, {16227, -1, -1, -1}, {59122, -1, -1, -1}, {59123, -1, -1, -1}, {16216, -1, -1, -1}, {30037, -1, -1, -1}, {30323, -1, -1, -1}, {59127, -1, -1, -1}, {-1, -1, -1, -1}, {29800, -1, -1, -1}, {59130, -1, -1, -1}, {59131, -1, -1, -1}, {59132, -1, -1, -1}, {15099, -1, -1, -1}, {15821, -1, -1, -1}, {59135, -1, -1, -1}, {16127, -1, -1, -1}, {59137, -1, -1, -1}, {59138, -1, -1, -1}, {37370, -1, -1, -1}, {22322, -1, -1, -1}, {37698, -1, -1, -1}, {59142, -1, -1, -1}, {59143, -1, -1, -1}, {20703, -1, -1, -1}, {59145, -1, -1, -1}, {59146, -1, -1, -1} },
    {{30584, -1, -1, -1}, {59148, -1, -1, -1}, {30478, -1, -1, -1}, {30479, -1, -1, -1}, {30587, -1, -1, -1}, {59152, -1, -1, -1}, {59153, -1, -1, -1}, {14942, -1, -1, -1}, {59155, -1, -1, -1}, {29752, -1, -1, -1}, {29851, -1, -1, -1}, {16063, -1, -1, -1}, {59159, -1, -1, -1}, {59160, -1, -1, -1}, {16584, -1, -1, -1}, {59162, -1, -1, -1}, {59163, -1, -1, -1}, {37639, -1, -1, -1}, {59165, -1, -1, -1}, {30750, -1, -1, -1}, {30861, -1, -1, -1}, {30856, -1, -1, -1}, {30930, -1, -1, -1}, {29648, -1, -1, -1}, {31065, -1, -1, -1}, {59172, -1, -1, -1}, {59173, -1, -1, -1}, {16654, -1, -1, -1}, {-1, -1, -1, -1}, {33942, -1, -1, -1}, {31141, -1, -1, -1}, {27181, -1, -1, -1}, {59179, -1, -1, -1}, {31290, -1, -1, -1}, {31220, -1, -1, -1}, {16750, -1, -1, -1}, {59183, -1, -1, -1}, {16690, -1, -1, -1}, {37429, -1, -1, -1}, {31217, -1, -1, -1}, {59187, -1, -1, -1}, {59188, -1, -1, -1}, {59189, -1, -1, -1}, {59190, -1, -1, -1}, {59191, -1, -1, -1}, {13719, -1, -1, -1}, {21867, -1, -1, -1}, {13680, -1, -1, -1}, {13994, -1, -1, -1}, {59196, -1, -1, -1}, {59197, -1, -1, -1}, {31458, -1, -1, -1}, {23129, -1, -1, -1}, {59200, -1, -1, -1}, {59201, -1, -1, -1}, {59202, -1, -1, -1}, {23053, -1, -1, -1}, {59204, -1, -1, -1}, {30960, -1, -1, -1}, {23082, -1, -1, -1}, {59207, -1, -1, -1}, {31486, -1, -1, -1}, {16889, -1, -1, -1}, {31837, -1, -1, -1}, {31853, -1, -1, -1}, {16913, -1, -1, -1}, {59213, -1, -1, -1}, {59214, -1, -1, -1}, {59215, -1, -1, -1}, {31949, -1, -1, -1}, {59217, -1, -1, -1}, {59218, -1, -1, -1}, {31886, -1, -1, -1}, {31868, -1, -1, -1}, {31918, -1, -1, -1}, {27314, -1, -1, -1}, {32220, -1, -1, -1}, {32263, -1, -1, -1}, {32211, -1, -1, -1}, {32590, -1, -1, -1}, {59227, -1, -1, -1}, {59228, -1, -1, -1}, {59229, -1, -1, -1}, {32151, -1, -1, -1}, {59231, -1, -1, -1}, {17002, -1, -1, -1}, {59233, -1, -1, -1}, {59234, -1, -1, -1}, {26582, -1, -1, -1}, {59236, -1, -1, -1}, {59237, -1, -1, -1}, {22468, -1, -1, -1}, {59239, -1, -1, -1}, {59240, -1, -1, -1}, {32733, -1, -1, -1}, {31527, -1, -1, -1}, {59244, -1, -1, -1}, {59245, -1, -1, -1}, {59246, -1, -1, -1}, {31500, -1, -1, -1}, {59248, -1, -1, -1}, {39398, -1, -1, -1}, {34373, -1, -1, -1}, {39523, -1, -1, -1}, {27164, -1, -1, -1}, {59253, -1, -1, -1}, {59255, -1, -1, -1}, {59256, -1, -1, -1}, {39455, -1, -1, -1}, {59258, -1, -1, -1}, {33920, -1, -1, -1}, {59260, -1, -1, -1}, {59261, -1, -1, -1}, {17642, -1, -1, -1}, {33079, -1, -1, -1}, {17410, -1, -1, -1}, {32966, -1, -1, -1}, {33033, -1, -1, -1}, {33090, -1, -1, -1}, {59268, -1, -1, -1}, {39107, -1, -1, -1}, {59270, -1, -1, -1}, {33378, -1, -1, -1}, {33381, -1, -1, -1}, {59273, -1, -1, -1}, {33875, -1, -1, -1}, {59275, -1, -1, -1}, {34320, -1, -1, -1}, {59277, -1, -1, -1}, {23174, -1, -1, -1}, {16767, -1, -1, -1}, {59280, -1, -1, -1}, {23339, -1, -1, -1}, {59282, -1, -1, -1}, {23268, -1, -1, -1}, {59284, -1, -1, -1}, {34464, -1, -1, -1}, {59286, -1, -1, -1}, {59287, -1, -1, -1}, {34861, -1, -1, -1}, {59289, -1, -1, -1}, {23042, -1, -1, -1}, {34926, -1, -1, -1}, {20293, -1, -1, -1}, {34951, -1, -1, -1}, {35007, -1, -1, -1}, {35046, -1, -1, -1}, {35173, -1, -1, -1}, {35149, -1, -1, -1}, {59298, -1, -1, -1}, {35156, -1, -1, -1}, {59300, -1, -1, -1}, {59301, -1, -1, -1}, {59302, -1, -1, -1}, {59303, -1, -1, -1}, {59304, -1, -1, -1}, {59305, -1, -1, -1}, {16045, -1, -1, -1}, {33955, -1, -1, -1}, {18165, -1, -1, -1}, {18127, -1, -1, -1}, {14322, -1, -1, -1}, {35389, -1, -1, -1}, {35356, -1, -1, -1}, {59313, -1, -1, -1}, {24397, -1, -1, -1}, {37419, -1, -1, -1}, {59316, -1, -1, -1}, {26068, -1, -1, -1}, {28969, -1, -1, -1}, {28868, -1, -1, -1}, {59320, -1, -1, -1}, {40301, -1, -1, -1}, {35999, -1, -1, -1}, {36073, -1, -1, -1}, {59324, -1, -1, -1}, {22938, -1, -1, -1}, {30659, -1, -1, -1}, {23024, -1, -1, -1}, {14036, -1, -1, -1}, {36394, -1, -1, -1}, {36519, -1, -1, -1}, {59332, -1, -1, -1}, {36656, -1, -1, -1}, {36682, -1, -1, -1}, {17140, -1, -1, -1}, {27736, -1, -1, -1}, {28603, -1, -1, -1}, {59338, -1, -1, -1}, {18587, -1, -1, -1}, {28537, -1, -1, -1}, {28299, -1, -1, -1}, {59342, -1, -1, -1}, {39913, -1, -1, -1}, {14005, -1, -1, -1}, {59345, -1, -1, -1}, {37051, -1, -1, -1}, {-1, -1, -1, -1}, {21873, -1, -1, -1}, {18694, -1, -1, -1}, {37307, -1, -1, -1}, {37892, -1, -1, -1}, {59352, -1, -1, -1}, {16482, -1, -1, -1}, {59354, -1, -1, -1}, {37927, -1, -1, -1}, {59356, -1, -1, -1}, {59357, -1, -1, -1}, {34021, -1, -1, -1}, {35371, -1, -1, -1}, {38297, -1, -1, -1}, {38311, -1, -1, -1}, {38295, -1, -1, -1}, {38294, -1, -1, -1}, {59364, -1, -1, -1}, {29765, -1, -1, -1}, {16066, -1, -1, -1}, {59367, -1, -1, -1}, {59368, -1, -1, -1}, {59369, -1, -1, -1}, {16103, -1, -1, -1}, {59371, -1, -1, -1}, {38543, -1, -1, -1}, {59373, -1, -1, -1}, {59374, -1, -1, -1}, {59375, -1, -1, -1}, {16076, -1, -1, -1}, {59377, -1, -1, -1}, {59378, -1, -1, -1}, {59379, -1, -1, -1}, {29714, -1, -1, -1}, {29803, -1, -1, -1}, {16124, -1, -1, -1}, {38721, -1, -1, -1}, {59384, -1, -1, -1}, {26695, -1, -1, -1}, {18973, -1, -1, -1}, {59387, -1, -1, -1}, {59388, -1, -1, -1}, {38749, -1, -1, -1}, {37736, -1, -1, -1}, {59391, -1, -1, -1}, {59392, -1, -1, -1}, {59393, -1, -1, -1}, {59394, -1, -1, -1}, {37562, -1, -1, -1}, {23313, -1, -1, -1}, {35689, -1, -1, -1}, {18748, -1, -1, -1}, {29689, -1, -1, -1}, {59400, -1, -1, -1}, {38811, -1, -1, -1}, {38769, -1, -1, -1}, {39224, -1, -1, -1}, {59404, -1, -1, -1}, {24001, -1, -1, -1} },
    {{59406, -1, -1, -1}, {59407, -1, -1, -1}, {38943, -1, -1, -1}, {59409, -1, -1, -1}, {37622, -1, -1, -1}, {59411, -1, -1, -1}, {37349, -1, -1, -1}, {17600, -1, -1, -1}, {59414, -1, -1, -1}, {59415, -1, -1, -1}, {59416, -1, -1, -1}, {39132, -1, -1, -1}, {59418, -1, -1, -1}, {16128, -1, -1, -1}, {37418, -1, -1, -1}, {18725, -1, -1, -1}, {33812, -1, -1, -1}, {39227, -1, -1, -1}, {39245, -1, -1, -1}, {59425, -1, -1, -1}, {15869, -1, -1, -1}, {39323, -1, -1, -1}, {19311, -1, -1, -1}, {39338, -1, -1, -1}, {39516, -1, -1, -1}, {59431, -1, -1, -1}, {59432, -1, -1, -1}, {27279, -1, -1, -1}, {39457, -1, -1, -1}, {23294, -1, -1, -1}, {39471, -1, -1, -1}, {59437, -1, -1, -1}, {19344, -1, -1, -1}, {59439, -1, -1, -1}, {39356, -1, -1, -1}, {19389, -1, -1, -1}, {19351, -1, -1, -1}, {37757, -1, -1, -1}, {22642, -1, -1, -1}, {59445, -1, -1, -1}, {22562, -1, -1, -1}, {59447, -1, -1, -1}, {59448, -1, -1, -1}, {30788, -1, -1, -1}, {59450, -1, -1, -1}, {59451, -1, -1, -1}, {26821, -1, -1, -1}, {15741, -1, -1, -1}, {37976, -1, -1, -1}, {14631, -1, -1, -1}, {24912, -1, -1, -1}, {59457, -1, -1, -1}, {59458, -1, -1, -1}, {24839, -1, -1, -1}, {40015, -1, -1, -1}, {40019, -1, -1, -1}, {40059, -1, -1, -1}, {39989, -1, -1, -1}, {39952, -1, -1, -1}, {39807, -1, -1, -1}, {39887, -1, -1, -1}, {59467, -1, -1, -1}, {39839, -1, -1, -1}, {59469, -1, -1, -1}, {59470, -1, -1, -1}, {40225, -1, -1, -1}, {19630, -1, -1, -1}, {59473, -1, -1, -1}, {40472, -1, -1, -1}, {19632, -1, -1, -1}, {40204, -1, -1, -1}, {59477, -1, -1, -1}, {59478, -1, -1, -1}, {59479, -1, -1, -1}, {59480, -1, -1, -1}, {40357, -1, -1, -1}, {33981, -1, -1, -1}, {59483, -1, -1, -1}, {59484, -1, -1, -1}, {59485, -1, -1, -1}, {34300, -1, -1, -1}, {17715, -1, -1, -1}, {59488, -1, -1, -1}, {59489, -1, -1, -1}, {59490, -1, -1, -1}, {33824, -1, -1, -1}, {34286, -1, -1, -1}, {59493, -1, -1, -1}, {59494, -1, -1, -1}, {59495, -1, -1, -1}, {31202, -1, -1, -1}, {59497, -1, -1, -1}, {59498, -1, -1, -1}, {59500, -1, -1, -1}, {15714, -1, -1, -1}, {37851, -1, -1, -1}, {37566, -1, -1, -1}, {37704, -1, -1, -1}, {59505, -1, -1, -1}, {30905, -1, -1, -1}, {37495, -1, -1, -1}, {37965, -1, -1, -1}, {20452, -1, -1, -1}, {13376, -1, -1, -1}, {36964, -1, -1, -1}, {59512, -1, -1, -1}, {30781, -1, -1, -1}, {30804, -1, -1, -1}, {30902, -1, -1, -1}, {30795, -1, -1, -1}, {59517, -1, -1, -1}, {59518, -1, -1, -1}, {59519, -1, -1, -1}, {13978, -1, -1, -1}, {20338, -1, -1, -1}, {28634, -1, -1, -1}, {28633, -1, -1, -1}, {-1, -1, -1, -1}, {28702, -1, -1, -1}, {21524, -1, -1, -1}, {59527, -1, -1, -1}, {22459, -1, -1, -1}, {22771, -1, -1, -1}, {22410, -1, -1, -1}, {40214, -1, -1, -1}, {22487, -1, -1, -1}, {28980, -1, -1, -1}, {13487, -1, -1, -1}, {59535, -1, -1, -1}, {29163, -1, -1, -1}, {59537, -1, -1, -1}, {59538, -1, -1, -1}, {-1, -1, -1, -1}, {59540, -1, -1, -1}, {59541, -1, -1, -1}, {24844, -1, -1, -1}, {23246, -1, -1, -1}, {23051, -1, -1, -1}, {17084, -1, -1, -1}, {59546, -1, -1, -1}, {14124, -1, -1, -1}, {19323, -1, -1, -1}, {59549, -1, -1, -1}, {37819, -1, -1, -1}, {37816, -1, -1, -1}, {59552, -1, -1, -1}, {59553, -1, -1, -1}, {33906, -1, -1, -1}, {59555, -1, -1, -1}, {59556, -1, -1, -1}, {59557, -1, -1, -1}, {59558, -1, -1, -1}, {59559, -1, -1, -1}, {22932, -1, -1, -1}, {59561, -1, -1, -1}, {59562, -1, -1, -1}, {32168, -1, -1, -1}, {59564, -1, -1, -1}, {59565, -1, -1, -1}, {59566, -1, -1, -1}, {59567, -1, -1, -1}, {59568, -1, -1, -1}, {37605, -1, -1, -1}, {29666, -1, -1, -1}, {16105, -1, -1, -1}, {29876, -1, -1, -1}, {59573, -1, -1, -1}, {59574, -1, -1, -1}, {16097, -1, -1, -1}, {59576, -1, -1, -1}, {27352, -1, -1, -1}, {29683, -1, -1, -1}, {29691, -1, -1, -1}, {16086, -1, -1, -1}, {59581, -1, -1, -1}, {59582, -1, -1, -1}, {59583, -1, -1, -1}, {59584, -1, -1, -1}, {59585, -1, -1, -1}, {59586, -1, -1, -1}, {59587, -1, -1, -1}, {29768, -1, -1, -1}, {59589, -1, -1, -1}, {28837, -1, -1, -1}, {59591, -1, -1, -1}, {37508, -1, -1, -1}, {29670, -1, -1, -1}, {37727, -1, -1, -1}, {59595, -1, -1, -1}, {37681, -1, -1, -1}, {59597, -1, -1, -1}, {59598, -1, -1, -1}, {37766, -1, -1, -1}, {59600, -1, -1, -1}, {59601, -1, -1, -1}, {18741, -1, -1, -1}, {59603, -1, -1, -1}, {29035, -1, -1, -1}, {59605, -1, -1, -1}, {59606, -1, -1, -1}, {22180, -1, -1, -1}, {59608, -1, -1, -1}, {59609, -1, -1, -1}, {59610, -1, -1, -1}, {21762, -1, -1, -1}, {31172, -1, -1, -1}, {59613, -1, -1, -1}, {32254, -1, -1, -1}, {59615, -1, -1, -1}, {59616, -1, -1, -1}, {59617, -1, -1, -1}, {17710, -1, -1, -1}, {37889, -1, -1, -1}, {14090, -1, -1, -1}, {59621, -1, -1, -1}, {59622, -1, -1, -1}, {22960, -1, -1, -1}, {59624, -1, -1, -1}, {59625, -1, -1, -1}, {59626, -1, -1, -1}, {23201, -1, -1, -1}, {14050, -1, -1, -1}, {59629, -1, -1, -1}, {14000, -1, -1, -1}, {37471, -1, -1, -1}, {23161, -1, -1, -1}, {59633, -1, -1, -1}, {59634, -1, -1, -1}, {37748, -1, -1, -1}, {15565, -1, -1, -1}, {59637, -1, -1, -1}, {19094, -1, -1, -1}, {14730, -1, -1, -1}, {20724, -1, -1, -1}, {15721, -1, -1, -1}, {15692, -1, -1, -1}, {59643, -1, -1, -1}, {29045, -1, -1, -1}, {17147, -1, -1, -1}, {59646, -1, -1, -1}, {28175, -1, -1, -1}, {59648, -1, -1, -1}, {17643, -1, -1, -1}, {27991, -1, -1, -1}, {59651, -1, -1, -1}, {28775, -1, -1, -1}, {27823, -1, -1, -1}, {15574, -1, -1, -1}, {59655, -1, -1, -1}, {59656, -1, -1, -1}, {28162, -1, -1, -1}, {28428, -1, -1, -1}, {15727, -1, -1, -1}, {59660, -1, -1, -1}, {30033, -1, -1, -1}, {14012, -1, -1, -1} },
    {{13512, -1, -1, -1}, {18048, -1, -1, -1}, {16090, -1, -1, -1}, {18545, -1, -1, -1}, {22980, -1, -1, -1}, {37486, -1, -1, -1}, {18750, -1, -1, -1}, {36673, -1, -1, -1}, {59671, -1, -1, -1}, {59672, -1, -1, -1}, {22546, -1, -1, -1}, {22472, -1, -1, -1}, {14038, -1, -1, -1}, {59676, -1, -1, -1}, {28926, -1, -1, -1}, {59678, -1, -1, -1}, {59679, -1, -1, -1}, {59680, -1, -1, -1}, {59681, -1, -1, -1}, {59682, -1, -1, -1}, {26809, -1, -1, -1}, {26983, -1, -1, -1}, {59685, -1, -1, -1}, {59686, -1, -1, -1}, {59687, -1, -1, -1}, {59688, -1, -1, -1}, {59689, -1, -1, -1}, {59690, -1, -1, -1}, {59691, -1, -1, -1}, {59692, -1, -1, -1}, {27162, -1, -1, -1}, {59694, -1, -1, -1}, {59695, -1, -1, -1}, {33854, -1, -1, -1}, {17631, -1, -1, -1}, {17614, -1, -1, -1}, {59699, -1, -1, -1}, {59700, -1, -1, -1}, {59701, -1, -1, -1}, {59702, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {33597, -1, -1, -1}, {59706, -1, -1, -1}, {33773, -1, -1, -1}, {59708, -1, -1, -1}, {59709, -1, -1, -1}, {59710, -1, -1, -1}, {22921, -1, -1, -1}, {23170, -1, -1, -1}, {59713, -1, -1, -1}, {23137, -1, -1, -1}, {23153, -1, -1, -1}, {59716, -1, -1, -1}, {59717, -1, -1, -1}, {14125, -1, -1, -1}, {23023, -1, -1, -1}, {59720, -1, -1, -1}, {14023, -1, -1, -1}, {29070, -1, -1, -1}, {37776, -1, -1, -1}, {26266, -1, -1, -1}, {59725, -1, -1, -1}, {23150, -1, -1, -1}, {23083, -1, -1, -1}, {59728, -1, -1, -1}, {27179, -1, -1, -1}, {59730, -1, -1, -1}, {59731, -1, -1, -1}, {59732, -1, -1, -1}, {59733, -1, -1, -1}, {28957, -1, -1, -1}, {59735, -1, -1, -1}, {59736, -1, -1, -1}, {20400, -1, -1, -1}, {59738, -1, -1, -1}, {23746, -1, -1, -1}, {59740, -1, -1, -1}, {59741, -1, -1, -1}, {59742, -1, -1, -1}, {27148, -1, -1, -1}, {59744, -1, -1, -1}, {59745, -1, -1, -1}, {28838, -1, -1, -1}, {28979, -1, -1, -1}, {59748, -1, -1, -1}, {15781, -1, -1, -1}, {27871, -1, -1, -1}, {59751, -1, -1, -1}, {23019, -1, -1, -1}, {24412, -1, -1, -1}, {59764, -1, -1, -1}, {31955, -1, -1, -1}, {59783, -1, -1, -1}, {59786, -1, -1, -1}, {59790, -1, -1, -1}, {36972, -1, -1, -1}, {33270, -1, -1, -1}, {30476, -1, -1, -1}, {27810, -1, -1, -1}, {22269, -1, -1, -1}, {22633, -1, -1, -1}, {26465, -1, -1, -1}, {23646, -1, -1, -1}, {22770, -1, -1, -1}, {28857, -1, -1, -1}, {26627, -1, -1, -1}, {36795, -1, -1, -1}, {36796, -1, -1, -1}, {20001, -1, -1, -1}, {31545, -1, -1, -1}, {15820, -1, -1, -1}, {29482, -1, -1, -1}, {30048, -1, -1, -1}, {22586, -1, -1, -1}, {33446, -1, -1, -1}, {27018, -1, -1, -1}, {24803, -1, -1, -1}, {20206, -1, -1, -1}, {39364, -1, -1, -1}, {40639, -1, -1, -1}, {21249, -1, -1, -1}, {26528, -1, -1, -1}, {24808, -1, -1, -1}, {20916, -1, -1, -1}, {31363, -1, -1, -1}, {39994, -1, -1, -1}, {31432, -1, -1, -1}, {26906, -1, -1, -1}, {22956, -1, -1, -1}, {22592, -1, -1, -1}, {21610, -1, -1, -1}, {24807, -1, -1, -1}, {22138, -1, -1, -1}, {26965, -1, -1, -1}, {39983, -1, -1, -1}, {34725, -1, -1, -1}, {23584, -1, -1, -1}, {24075, -1, -1, -1}, {26398, -1, -1, -1}, {33965, -1, -1, -1}, {35713, -1, -1, -1}, {20088, -1, -1, -1}, {25283, -1, -1, -1}, {26709, -1, -1, -1}, {27113, -1, -1, -1}, {33533, -1, -1, -1}, {35237, -1, -1, -1}, {36768, -1, -1, -1}, {38840, -1, -1, -1}, {38983, -1, -1, -1}, {39613, -1, -1, -1}, {24497, -1, -1, -1}, {26184, -1, -1, -1}, {26303, -1, -1, -1}, {60221, -1, -1, -1}, {-1, -1, -1, -1}, {60225, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {60230, -1, -1, -1}, {26382, -1, -1, -1}, {26904, -1, -1, -1}, {60235, -1, -1, -1}, {60236, -1, -1, -1}, {60239, -1, -1, -1}, {60240, -1, -1, -1}, {18640, -1, -1, -1}, {19128, -1, -1, -1}, {60244, -1, -1, -1}, {60247, -1, -1, -1}, {60250, -1, -1, -1}, {60251, -1, -1, -1}, {20946, -1, -1, -1}, {60253, -1, -1, -1}, {22943, -1, -1, -1}, {60255, -1, -1, -1}, {15294, -1, -1, -1}, {60257, -1, -1, -1}, {14747, -1, -1, -1}, {60264, -1, -1, -1}, {60265, -1, -1, -1}, {14178, -1, -1, -1}, {60267, -1, -1, -1}, {35678, -1, -1, -1}, {60269, -1, -1, -1}, {-1, -1, -1, -1}, {29193, -1, -1, -1}, {60276, -1, -1, -1}, {60280, -1, -1, -1}, {36570, -1, -1, -1}, {21135, -1, -1, -1}, {29041, -1, -1, -1}, {60288, -1, -1, -1}, {60289, -1, -1, -1}, {21948, -1, -1, -1}, {60293, -1, -1, -1}, {13427, -1, -1, -1}, {60297, -1, -1, -1}, {18200, -1, -1, -1}, {60303, -1, -1, -1}, {20582, -1, -1, -1}, {13563, -1, -1, -1}, {60307, -1, -1, -1}, {24798, -1, -1, -1}, {18300, -1, -1, -1}, {60311, -1, -1, -1}, {60315, -1, -1, -1}, {-1, -1, -1, -1}, {60320, -1, -1, -1}, {36950, -1, -1, -1}, {60323, -1, -1, -1}, {35682, -1, -1, -1}, {23899, -1, -1, -1}, {60328, -1, -1, -1}, {-1, -1, -1, -1}, {60331, -1, -1, -1}, {35562, -1, -1, -1}, {60333, -1, -1, -1}, {60335, -1, -1, -1}, {19392, -1, -1, -1}, {60340, -1, -1, -1}, {37989, -1, -1, -1}, {60342, -1, -1, -1}, {24981, -1, -1, -1}, {23079, -1, -1, -1}, {60345, -1, -1, -1}, {-1, -1, -1, -1}, {60348, -1, -1, -1}, {20074, -1, -1, -1}, {60351, -1, -1, -1}, {38486, -1, -1, -1}, {28047, -1, -1, -1}, {60354, -1, -1, -1}, {35191, -1, -1, -1}, {60359, -1, -1, -1}, {-1, -1, -1, -1}, {31554, -1, -1, -1}, {60364, -1, -1, -1}, {60365, -1, -1, -1}, {-1, -1, -1, -1}, {31301, -1, -1, -1}, {39462, -1, -1, -1}, {13919, -1, -1, -1}, {60375, -1, -1, -1}, {60376, -1, -1, -1}, {31107, -1, -1, -1}, {23852, -1, -1, -1}, {60381, -1, -1, -1}, {-1, -1, -1, -1}, {18128, -1, -1, -1}, {30011, -1, -1, -1}, {34917, -1, -1, -1}, {22710, -1, -1, -1}, {14108, -1, -1, -1}, {60391, -1, -1, -1} },
    {{15444, -1, -1, -1}, {37505, -1, -1, -1}, {60398, -1, -1, -1}, {37680, -1, -1, -1}, {60402, -1, -1, -1}, {27705, -1, -1, -1}, {60406, -1, -1, -1}, {34855, -1, -1, -1}, {35061, -1, -1, -1}, {60409, -1, -1, -1}, {60410, -1, -1, -1}, {60411, -1, -1, -1}, {28344, -1, -1, -1}, {60413, -1, -1, -1}, {60414, -1, -1, -1}, {14756, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {17727, -1, -1, -1}, {26294, -1, -1, -1}, {60421, -1, -1, -1}, {60422, -1, -1, -1}, {35139, -1, -1, -1}, {16607, -1, -1, -1}, {60428, -1, -1, -1}, {14753, -1, -1, -1}, {60430, -1, -1, -1}, {60431, -1, -1, -1}, {60432, -1, -1, -1}, {29101, -1, -1, -1}, {33638, -1, -1, -1}, {60436, -1, -1, -1}, {-1, -1, -1, -1}, {19639, -1, -1, -1}, {60439, -1, -1, -1}, {60440, -1, -1, -1}, {60445, -1, -1, -1}, {31555, -1, -1, -1}, {31102, -1, -1, -1}, {28597, -1, -1, -1}, {60450, -1, -1, -1}, {27139, -1, -1, -1}, {60452, -1, -1, -1}, {21410, -1, -1, -1}, {60454, -1, -1, -1}, {37823, -1, -1, -1}, {26678, -1, -1, -1}, {-1, -1, -1, -1}, {60458, -1, -1, -1}, {60460, -1, -1, -1}, {60461, -1, -1, -1}, {60462, -1, -1, -1}, {23941, -1, -1, -1}, {60465, -1, -1, -1}, {22293, -1, -1, -1}, {38947, -1, -1, -1}, {60469, -1, -1, -1}, {23979, -1, -1, -1}, {60471, -1, -1, -1}, {26046, -1, -1, -1}, {27093, -1, -1, -1}, {21458, -1, -1, -1}, {60475, -1, -1, -1}, {60476, -1, -1, -1}, {15377, -1, -1, -1}, {26422, -1, -1, -1}, {60482, -1, -1, -1}, {13770, -1, -1, -1}, {18682, -1, -1, -1}, {-1, -1, -1, -1}, {30728, -1, -1, -1}, {37461, -1, -1, -1}, {17394, -1, -1, -1}, {17375, -1, -1, -1}, {23032, -1, -1, -1}, {-1, -1, -1, -1}, {22155, -1, -1, -1}, {60520, -1, -1, -1}, {36882, -1, -1, -1}, {21953, -1, -1, -1}, {17673, -1, -1, -1}, {32383, -1, -1, -1}, {28502, -1, -1, -1}, {27313, -1, -1, -1}, {13540, -1, -1, -1}, {60558, -1, -1, -1}, {14138, -1, -1, -1}, {36480, -1, -1, -1}, {60562, -1, -1, -1}, {60565, -1, -1, -1}, {15851, -1, -1, -1}, {60569, -1, -1, -1}, {60574, -1, -1, -1}, {22207, -1, -1, -1}, {36366, -1, -1, -1}, {23405, -1, -1, -1}, {25566, -1, -1, -1}, {-1, -1, -1, -1}, {25904, -1, -1, -1}, {22061, -1, -1, -1}, {21530, -1, -1, -1}, {60591, -1, -1, -1}, {19581, -1, -1, -1}, {22050, -1, -1, -1}, {22046, -1, -1, -1}, {32585, -1, -1, -1}, {22901, -1, -1, -1}, {60598, -1, -1, -1}, {34672, -1, -1, -1}, {33047, -1, -1, -1}, {40286, -1, -1, -1}, {36120, -1, -1, -1}, {30267, -1, -1, -1}, {40005, -1, -1, -1}, {30286, -1, -1, -1}, {30649, -1, -1, -1}, {37701, -1, -1, -1}, {21554, -1, -1, -1}, {33096, -1, -1, -1}, {33527, -1, -1, -1}, {22053, -1, -1, -1}, {33074, -1, -1, -1}, {33816, -1, -1, -1}, {32957, -1, -1, -1}, {21994, -1, -1, -1}, {31074, -1, -1, -1}, {22083, -1, -1, -1}, {21526, -1, -1, -1}, {60623, -1, -1, -1}, {13774, -1, -1, -1}, {22021, -1, -1, -1}, {22001, -1, -1, -1}, {26353, -1, -1, -1}, {60628, -1, -1, -1}, {13869, -1, -1, -1}, {30004, -1, -1, -1}, {22000, -1, -1, -1}, {21946, -1, -1, -1}, {21655, -1, -1, -1}, {21874, -1, -1, -1}, {60635, -1, -1, -1}, {60636, -1, -1, -1}, {-1, -1, -1, -1}, {60639, -1, -1, -1}, {60640, -1, -1, -1}, {60641, -1, -1, -1}, {40619, -1, -1, -1}, {32090, -1, -1, -1}, {21982, -1, -1, -1}, {60645, -1, -1, -1}, {25245, -1, -1, -1}, {38765, -1, -1, -1}, {21652, -1, -1, -1}, {36045, -1, -1, -1}, {29174, -1, -1, -1}, {37238, -1, -1, -1}, {25596, -1, -1, -1}, {25529, -1, -1, -1}, {25598, -1, -1, -1}, {21865, -1, -1, -1}, {60656, -1, -1, -1}, {40050, -1, -1, -1}, {60658, -1, -1, -1}, {20890, -1, -1, -1}, {13535, -1, -1, -1}, {60661, -1, -1, -1}, {20903, -1, -1, -1}, {21581, -1, -1, -1}, {21790, -1, -1, -1}, {21779, -1, -1, -1}, {30310, -1, -1, -1}, {36397, -1, -1, -1}, {60668, -1, -1, -1}, {30129, -1, -1, -1}, {32950, -1, -1, -1}, {34820, -1, -1, -1}, {34694, -1, -1, -1}, {35015, -1, -1, -1}, {33206, -1, -1, -1}, {33820, -1, -1, -1}, {17644, -1, -1, -1}, {29444, -1, -1, -1}, {33547, -1, -1, -1}, {22139, -1, -1, -1}, {37232, -1, -1, -1}, {37384, -1, -1, -1}, {60696, -1, -1, -1}, {29286, -1, -1, -1}, {18254, -1, -1, -1}, {60701, -1, -1, -1}, {16634, -1, -1, -1}, {40029, -1, -1, -1}, {25887, -1, -1, -1}, {18675, -1, -1, -1}, {60708, -1, -1, -1}, {60709, -1, -1, -1}, {-1, -1, -1, -1}, {60713, -1, -1, -1}, {-1, -1, -1, -1}, {60716, -1, -1, -1}, {29091, -1, -1, -1}, {32398, -1, -1, -1}, {40272, -1, -1, -1}, {13687, -1, -1, -1}, {27826, -1, -1, -1}, {21351, -1, -1, -1}, {14812, -1, -1, -1}, {60731, -1, -1, -1}, {33325, -1, -1, -1}, {21579, -1, -1, -1}, {-1, -1, -1, -1}, {14930, -1, -1, -1}, {29556, -1, -1, -1}, {60743, -1, -1, -1}, {19721, -1, -1, -1}, {39917, -1, -1, -1}, {-1, -1, -1, -1}, {19547, -1, -1, -1}, {60751, -1, -1, -1}, {33884, -1, -1, -1}, {60754, -1, -1, -1}, {25390, -1, -1, -1}, {32037, -1, -1, -1}, {14890, -1, -1, -1}, {36872, -1, -1, -1}, {21196, -1, -1, -1}, {15988, -1, -1, -1}, {13946, -1, -1, -1}, {17897, -1, -1, -1}, {60767, -1, -1, -1}, {30272, -1, -1, -1}, {23280, -1, -1, -1}, {60770, -1, -1, -1}, {30842, -1, -1, -1}, {18358, -1, -1, -1}, {22695, -1, -1, -1}, {16575, -1, -1, -1}, {22140, -1, -1, -1}, {39819, -1, -1, -1}, {23924, -1, -1, -1}, {30292, -1, -1, -1}, {60779, -1, -1, -1}, {40581, -1, -1, -1}, {19681, -1, -1, -1}, {-1, -1, -1, -1}, {14331, -1, -1, -1}, {24857, -1, -1, -1}, {60786, -1, -1, -1}, {-1, -1, -1, -1}, {22109, -1, -1, -1}, {60792, -1, -1, -1}, {21044, -1, -1, -1}, {13741, -1, -1, -1}, {-1, -1, -1, -1}, {40316, -1, -1, -1}, {31830, -1, -1, -1} },
    {{39737, -1, -1, -1}, {22494, -1, -1, -1}, {23635, -1, -1, -1}, {25811, -1, -1, -1}, {60804, -1, -1, -1}, {60805, -1, -1, -1}, {34477, -1, -1, -1}, {60808, -1, -1, -1}, {60811, -1, -1, -1}, {-1, -1, -1, -1}, {20990, -1, -1, -1}, {60814, -1, -1, -1}, {23950, -1, -1, -1}, {38659, -1, -1, -1}, {60817, -1, -1, -1}, {40577, -1, -1, -1}, {36940, -1, -1, -1}, {31519, -1, -1, -1}, {39682, -1, -1, -1}, {23761, -1, -1, -1}, {31651, -1, -1, -1}, {25192, -1, -1, -1}, {25397, -1, -1, -1}, {39679, -1, -1, -1}, {31695, -1, -1, -1}, {39722, -1, -1, -1}, {31870, -1, -1, -1}, {-1, -1, -1, -1}, {31810, -1, -1, -1}, {31878, -1, -1, -1}, {39957, -1, -1, -1}, {31740, -1, -1, -1}, {39689, -1, -1, -1}, {-1, -1, -1, -1}, {39982, -1, -1, -1}, {40794, -1, -1, -1}, {21875, -1, -1, -1}, {23491, -1, -1, -1}, {20477, -1, -1, -1}, {40600, -1, -1, -1}, {20466, -1, -1, -1}, {21088, -1, -1, -1}, {21201, -1, -1, -1}, {22375, -1, -1, -1}, {20566, -1, -1, -1}, {22967, -1, -1, -1}, {24082, -1, -1, -1}, {38856, -1, -1, -1}, {40363, -1, -1, -1}, {36700, -1, -1, -1}, {21609, -1, -1, -1}, {38836, -1, -1, -1}, {39232, -1, -1, -1}, {38842, -1, -1, -1}, {21292, -1, -1, -1}, {24880, -1, -1, -1}, {26924, -1, -1, -1}, {21466, -1, -1, -1}, {39946, -1, -1, -1}, {40194, -1, -1, -1}, {19515, -1, -1, -1}, {38465, -1, -1, -1}, {27008, -1, -1, -1}, {20646, -1, -1, -1}, {30022, -1, -1, -1}, {60870, -1, -1, -1}, {39386, -1, -1, -1}, {21107, -1, -1, -1}, {-1, -1, -1, -1}, {37209, -1, -1, -1}, {38529, -1, -1, -1}, {37212, -1, -1, -1}, {-1, -1, -1, -1}, {37201, -1, -1, -1}, {60879, -1, -1, -1}, {25471, -1, -1, -1}, {27338, -1, -1, -1}, {22033, -1, -1, -1}, {37262, -1, -1, -1}, {30074, -1, -1, -1}, {25221, -1, -1, -1}, {29519, -1, -1, -1}, {31856, -1, -1, -1}, {60890, -1, -1, -1}, {-1, -1, -1, -1}, {30422, -1, -1, -1}, {39837, -1, -1, -1}, {20010, -1, -1, -1}, {60897, -1, -1, -1}, {33726, -1, -1, -1}, {34882, -1, -1, -1}, {-1, -1, -1, -1}, {23626, -1, -1, -1}, {27072, -1, -1, -1}, {-1, -1, -1, -1}, {22394, -1, -1, -1}, {21023, -1, -1, -1}, {24053, -1, -1, -1}, {20174, -1, -1, -1}, {27697, -1, -1, -1}, {60909, -1, -1, -1}, {20281, -1, -1, -1}, {21660, -1, -1, -1}, {-1, -1, -1, -1}, {21146, -1, -1, -1}, {36226, -1, -1, -1}, {13822, -1, -1, -1}, {-1, -1, -1, -1}, {13811, -1, -1, -1}, {-1, -1, -1, -1}, {27474, -1, -1, -1}, {37244, -1, -1, -1}, {40869, -1, -1, -1}, {39831, -1, -1, -1}, {38958, -1, -1, -1}, {39092, -1, -1, -1}, {39610, -1, -1, -1}, {40616, -1, -1, -1}, {40580, -1, -1, -1}, {31508, -1, -1, -1}, {-1, -1, -1, -1}, {27642, -1, -1, -1}, {34840, -1, -1, -1}, {32632, -1, -1, -1}, {-1, -1, -1, -1}, {22048, -1, -1, -1}, {60936, -1, -1, -1}, {36471, -1, -1, -1}, {40787, -1, -1, -1}, {-1, -1, -1, -1}, {36308, -1, -1, -1}, {36431, -1, -1, -1}, {40476, -1, -1, -1}, {36353, -1, -1, -1}, {25218, -1, -1, -1}, {60945, -1, -1, -1}, {36392, -1, -1, -1}, {36469, -1, -1, -1}, {31443, -1, -1, -1}, {31294, -1, -1, -1}, {30936, -1, -1, -1}, {27882, -1, -1, -1}, {35431, -1, -1, -1}, {30215, -1, -1, -1}, {40742, -1, -1, -1}, {27854, -1, -1, -1}, {34774, -1, -1, -1}, {30147, -1, -1, -1}, {60960, -1, -1, -1}, {30803, -1, -1, -1}, {36108, -1, -1, -1}, {29410, -1, -1, -1}, {29553, -1, -1, -1}, {35629, -1, -1, -1}, {29442, -1, -1, -1}, {29937, -1, -1, -1}, {36075, -1, -1, -1}, {60970, -1, -1, -1}, {34351, -1, -1, -1}, {24506, -1, -1, -1}, {34976, -1, -1, -1}, {17591, -1, -1, -1}, {-1, -1, -1, -1}, {60977, -1, -1, -1}, {-1, -1, -1, -1}, {35454, -1, -1, -1}, {60980, -1, -1, -1}, {-1, -1, -1, -1}, {24829, -1, -1, -1}, {30311, -1, -1, -1}, {39639, -1, -1, -1}, {40260, -1, -1, -1}, {-1, -1, -1, -1}, {39823, -1, -1, -1}, {34805, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {36087, -1, -1, -1}, {29484, -1, -1, -1}, {38689, -1, -1, -1}, {39856, -1, -1, -1}, {13782, -1, -1, -1}, {29362, -1, -1, -1}, {19463, -1, -1, -1}, {31825, -1, -1, -1}, {39242, -1, -1, -1}, {24921, -1, -1, -1}, {19460, -1, -1, -1}, {40598, -1, -1, -1}, {24957, -1, -1, -1}, {-1, -1, -1, -1}, {22367, -1, -1, -1}, {24943, -1, -1, -1}, {25254, -1, -1, -1}, {25145, -1, -1, -1}, {-1, -1, -1, -1}, {14940, -1, -1, -1}, {25058, -1, -1, -1}, {21418, -1, -1, -1}, {25444, -1, -1, -1}, {26626, -1, -1, -1}, {13778, -1, -1, -1}, {23895, -1, -1, -1}, {36826, -1, -1, -1}, {61021, -1, -1, -1}, {-1, -1, -1, -1}, {20697, -1, -1, -1}, {30982, -1, -1, -1}, {21298, -1, -1, -1}, {38456, -1, -1, -1}, {61028, -1, -1, -1}, {16485, -1, -1, -1}, {-1, -1, -1, -1}, {30718, -1, -1, -1}, {-1, -1, -1, -1}, {31938, -1, -1, -1}, {61034, -1, -1, -1}, {31962, -1, -1, -1}, {31277, -1, -1, -1}, {32870, -1, -1, -1}, {32867, -1, -1, -1}, {32077, -1, -1, -1}, {29957, -1, -1, -1}, {29938, -1, -1, -1}, {35220, -1, -1, -1}, {33306, -1, -1, -1}, {26380, -1, -1, -1}, {32866, -1, -1, -1}, {61046, -1, -1, -1}, {32859, -1, -1, -1}, {29936, -1, -1, -1}, {33027, -1, -1, -1}, {30500, -1, -1, -1}, {35209, -1, -1, -1}, {61052, -1, -1, -1}, {30035, -1, -1, -1}, {34729, -1, -1, -1}, {34766, -1, -1, -1}, {33224, -1, -1, -1}, {34700, -1, -1, -1}, {35401, -1, -1, -1}, {36013, -1, -1, -1}, {35651, -1, -1, -1}, {30507, -1, -1, -1}, {29944, -1, -1, -1}, {34010, -1, -1, -1}, {27058, -1, -1, -1}, {36262, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {28089, -1, -1, -1}, {34753, -1, -1, -1}, {61073, -1, -1, -1}, {29927, -1, -1, -1}, {15835, -1, -1, -1} },
    {{29046, -1, -1, -1}, {24740, -1, -1, -1}, {24988, -1, -1, -1}, {15569, -1, -1, -1}, {-1, -1, -1, -1}, {24695, -1, -1, -1}, {-1, -1, -1, -1}, {32625, -1, -1, -1}, {-1, -1, -1, -1}, {24809, -1, -1, -1}, {19326, -1, -1, -1}, {57344, -1, -1, -1}, {37595, -1, -1, -1}, {57346, -1, -1, -1}, {57347, -1, -1, -1}, {34124, -1, -1, -1}, {17077, -1, -1, -1}, {29679, -1, -1, -1}, {20917, -1, -1, -1}, {13897, -1, -1, -1}, {57353, -1, -1, -1}, {57354, -1, -1, -1}, {37700, -1, -1, -1}, {57356, -1, -1, -1}, {33518, -1, -1, -1}, {57358, -1, -1, -1}, {30780, -1, -1, -1}, {26436, -1, -1, -1}, {25311, -1, -1, -1}, {57362, -1, -1, -1}, {57363, -1, -1, -1}, {57364, -1, -1, -1}, {57365, -1, -1, -1}, {57366, -1, -1, -1}, {20395, -1, -1, -1}, {57368, -1, -1, -1}, {20488, -1, -1, -1}, {57370, -1, -1, -1}, {57371, -1, -1, -1}, {57372, -1, -1, -1}, {57373, -1, -1, -1}, {57374, -1, -1, -1}, {-1, -1, -1, -1}, {57376, -1, -1, -1}, {24484, -1, -1, -1}, {57378, -1, -1, -1}, {57379, -1, -1, -1}, {28379, -1, -1, -1}, {57381, -1, -1, -1}, {20702, -1, -1, -1}, {20737, -1, -1, -1}, {13434, -1, -1, -1}, {20750, -1, -1, -1}, {39020, -1, -1, -1}, {14147, -1, -1, -1}, {33814, -1, -1, -1}, {57389, -1, -1, -1}, {57390, -1, -1, -1}, {20832, -1, -1, -1}, {57392, -1, -1, -1}, {20842, -1, -1, -1}, {57394, -1, -1, -1}, {57395, -1, -1, -1}, {57396, -1, -1, -1}, {57397, -1, -1, -1}, {57398, -1, -1, -1}, {57399, -1, -1, -1}, {57400, -1, -1, -1}, {23426, -1, -1, -1}, {34685, -1, -1, -1}, {57403, -1, -1, -1}, {57404, -1, -1, -1}, {20914, -1, -1, -1}, {20920, -1, -1, -1}, {40244, -1, -1, -1}, {20937, -1, -1, -1}, {20943, -1, -1, -1}, {20945, -1, -1, -1}, {15580, -1, -1, -1}, {20947, -1, -1, -1}, {57413, -1, -1, -1}, {20915, -1, -1, -1}, {20962, -1, -1, -1}, {-1, -1, -1, -1}, {20973, -1, -1, -1}, {33741, -1, -1, -1}, {26942, -1, -1, -1}, {57420, -1, -1, -1}, {24443, -1, -1, -1}, {21003, -1, -1, -1}, {21030, -1, -1, -1}, {21052, -1, -1, -1}, {21173, -1, -1, -1}, {21079, -1, -1, -1}, {21140, -1, -1, -1}, {21177, -1, -1, -1}, {21189, -1, -1, -1}, {31765, -1, -1, -1}, {34114, -1, -1, -1}, {21216, -1, -1, -1}, {34317, -1, -1, -1}, {57434, -1, -1, -1}, {-1, -1, -1, -1}, {57436, -1, -1, -1}, {21833, -1, -1, -1}, {28377, -1, -1, -1}, {57439, -1, -1, -1}, {57440, -1, -1, -1}, {57441, -1, -1, -1}, {21299, -1, -1, -1}, {-1, -1, -1, -1}, {57444, -1, -1, -1}, {27851, -1, -1, -1}, {57446, -1, -1, -1}, {26651, -1, -1, -1}, {29653, -1, -1, -1}, {24650, -1, -1, -1}, {16042, -1, -1, -1}, {14540, -1, -1, -1}, {57452, -1, -1, -1}, {29149, -1, -1, -1}, {17570, -1, -1, -1}, {21357, -1, -1, -1}, {21364, -1, -1, -1}, {57457, -1, -1, -1}, {21374, -1, -1, -1}, {-1, -1, -1, -1}, {57460, -1, -1, -1}, {57461, -1, -1, -1}, {30694, -1, -1, -1}, {21395, -1, -1, -1}, {57464, -1, -1, -1}, {21408, -1, -1, -1}, {21419, -1, -1, -1}, {21422, -1, -1, -1}, {29607, -1, -1, -1}, {57469, -1, -1, -1}, {16217, -1, -1, -1}, {29596, -1, -1, -1}, {21441, -1, -1, -1}, {21445, -1, -1, -1}, {27721, -1, -1, -1}, {20041, -1, -1, -1}, {22526, -1, -1, -1}, {21465, -1, -1, -1}, {15019, -1, -1, -1}, {57479, -1, -1, -1}, {21472, -1, -1, -1}, {57481, -1, -1, -1}, {57482, -1, -1, -1}, {21494, -1, -1, -1}, {57484, -1, -1, -1}, {21523, -1, -1, -1}, {28793, -1, -1, -1}, {21803, -1, -1, -1}, {26199, -1, -1, -1}, {27995, -1, -1, -1}, {21613, -1, -1, -1}, {57491, -1, -1, -1}, {57492, -1, -1, -1}, {21853, -1, -1, -1}, {21647, -1, -1, -1}, {21668, -1, -1, -1}, {18342, -1, -1, -1}, {57497, -1, -1, -1}, {57498, -1, -1, -1}, {15796, -1, -1, -1}, {57500, -1, -1, -1}, {57501, -1, -1, -1}, {57502, -1, -1, -1}, {21831, -1, -1, -1}, {19693, -1, -1, -1}, {21551, -1, -1, -1}, {29719, -1, -1, -1}, {21894, -1, -1, -1}, {21929, -1, -1, -1}, {-1, -1, -1, -1}, {57510, -1, -1, -1}, {57511, -1, -1, -1}, {17746, -1, -1, -1}, {57513, -1, -1, -1}, {26291, -1, -1, -1}, {57515, -1, -1, -1}, {22071, -1, -1, -1}, {26317, -1, -1, -1}, {57518, -1, -1, -1}, {26276, -1, -1, -1}, {-1, -1, -1, -1}, {22093, -1, -1, -1}, {22095, -1, -1, -1}, {30961, -1, -1, -1}, {22257, -1, -1, -1}, {38791, -1, -1, -1}, {21502, -1, -1, -1}, {22272, -1, -1, -1}, {22255, -1, -1, -1}, {22253, -1, -1, -1}, {57530, -1, -1, -1}, {13859, -1, -1, -1}, {57532, -1, -1, -1}, {22342, -1, -1, -1}, {57534, -1, -1, -1}, {27758, -1, -1, -1}, {28811, -1, -1, -1}, {22338, -1, -1, -1}, {14001, -1, -1, -1}, {57539, -1, -1, -1}, {22502, -1, -1, -1}, {57541, -1, -1, -1}, {22531, -1, -1, -1}, {57543, -1, -1, -1}, {57544, -1, -1, -1}, {22566, -1, -1, -1}, {57546, -1, -1, -1}, {-1, -1, -1, -1}, {22698, -1, -1, -1}, {13665, -1, -1, -1}, {22752, -1, -1, -1}, {22748, -1, -1, -1}, {57552, -1, -1, -1}, {22779, -1, -1, -1}, {23551, -1, -1, -1}, {22339, -1, -1, -1}, {57556, -1, -1, -1}, {57557, -1, -1, -1}, {37843, -1, -1, -1}, {13729, -1, -1, -1}, {22815, -1, -1, -1}, {26790, -1, -1, -1}, {14019, -1, -1, -1}, {28249, -1, -1, -1}, {57564, -1, -1, -1}, {23076, -1, -1, -1}, {-1, -1, -1, -1}, {57567, -1, -1, -1}, {34053, -1, -1, -1}, {22985, -1, -1, -1}, {57570, -1, -1, -1}, {57571, -1, -1, -1}, {57572, -1, -1, -1}, {57573, -1, -1, -1}, {23001, -1, -1, -1}, {57575, -1, -1, -1}, {57576, -1, -1, -1}, {57577, -1, -1, -1}, {28017, -1, -1, -1}, {57579, -1, -1, -1}, {57580, -1, -1, -1}, {23033, -1, -1, -1}, {57582, -1, -1, -1}, {23211, -1, -1, -1}, {23139, -1, -1, -1}, {14054, -1, -1, -1}, {57586, -1, -1, -1}, {-1, -1, -1, -1}, {14088, -1, -1, -1} },
    {{23190, -1, -1, -1}, {29797, -1, -1, -1}, {23251, -1, -1, -1}, {57592, -1, -1, -1}, {57593, -1, -1, -1}, {57595, -1, -1, -1}, {14130, -1, -1, -1}, {57597, -1, -1, -1}, {24195, -1, -1, -1}, {21200, -1, -1, -1}, {23414, -1, -1, -1}, {25992, -1, -1, -1}, {23420, -1, -1, -1}, {57603, -1, -1, -1}, {16388, -1, -1, -1}, {18525, -1, -1, -1}, {57606, -1, -1, -1}, {23509, -1, -1, -1}, {57609, -1, -1, -1}, {57610, -1, -1, -1}, {57611, -1, -1, -1}, {23539, -1, -1, -1}, {23453, -1, -1, -1}, {19728, -1, -1, -1}, {23557, -1, -1, -1}, {57616, -1, -1, -1}, {23571, -1, -1, -1}, {29646, -1, -1, -1}, {23572, -1, -1, -1}, {57620, -1, -1, -1}, {57621, -1, -1, -1}, {23625, -1, -1, -1}, {18653, -1, -1, -1}, {23685, -1, -1, -1}, {23785, -1, -1, -1}, {23791, -1, -1, -1}, {23947, -1, -1, -1}, {57628, -1, -1, -1}, {57629, -1, -1, -1}, {23824, -1, -1, -1}, {23832, -1, -1, -1}, {23878, -1, -1, -1}, {57633, -1, -1, -1}, {23738, -1, -1, -1}, {24023, -1, -1, -1}, {33532, -1, -1, -1}, {14381, -1, -1, -1}, {57638, -1, -1, -1}, {57639, -1, -1, -1}, {57640, -1, -1, -1}, {33415, -1, -1, -1}, {14390, -1, -1, -1}, {15298, -1, -1, -1}, {24110, -1, -1, -1}, {27274, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {57648, -1, -1, -1}, {57649, -1, -1, -1}, {21414, -1, -1, -1}, {20151, -1, -1, -1}, {24272, -1, -1, -1}, {21416, -1, -1, -1}, {57654, -1, -1, -1}, {24073, -1, -1, -1}, {-1, -1, -1, -1}, {57657, -1, -1, -1}, {24313, -1, -1, -1}, {24315, -1, -1, -1}, {14496, -1, -1, -1}, {24316, -1, -1, -1}, {26686, -1, -1, -1}, {37915, -1, -1, -1}, {24333, -1, -1, -1}, {57665, -1, -1, -1}, {57666, -1, -1, -1}, {15070, -1, -1, -1}, {57669, -1, -1, -1}, {24378, -1, -1, -1}, {57671, -1, -1, -1}, {57672, -1, -1, -1}, {57674, -1, -1, -1}, {24419, -1, -1, -1}, {57677, -1, -1, -1}, {24434, -1, -1, -1}, {37696, -1, -1, -1}, {57680, -1, -1, -1}, {24487, -1, -1, -1}, {23990, -1, -1, -1}, {15711, -1, -1, -1}, {57684, -1, -1, -1}, {57685, -1, -1, -1}, {57686, -1, -1, -1}, {57687, -1, -1, -1}, {37334, -1, -1, -1}, {57689, -1, -1, -1}, {57690, -1, -1, -1}, {24625, -1, -1, -1}, {26245, -1, -1, -1}, {14691, -1, -1, -1}, {15815, -1, -1, -1}, {13881, -1, -1, -1}, {22416, -1, -1, -1}, {57698, -1, -1, -1}, {31089, -1, -1, -1}, {15936, -1, -1, -1}, {24734, -1, -1, -1}, {-1, -1, -1, -1}, {24755, -1, -1, -1}, {57704, -1, -1, -1}, {57705, -1, -1, -1}, {57706, -1, -1, -1}, {29860, -1, -1, -1}, {20705, -1, -1, -1}, {23200, -1, -1, -1}, {24932, -1, -1, -1}, {24898, -1, -1, -1}, {57713, -1, -1, -1}, {57714, -1, -1, -1}, {24961, -1, -1, -1}, {20980, -1, -1, -1}, {57717, -1, -1, -1}, {24967, -1, -1, -1}, {23466, -1, -1, -1}, {57720, -1, -1, -1}, {57721, -1, -1, -1}, {25043, -1, -1, -1}, {57723, -1, -1, -1}, {57724, -1, -1, -1}, {25040, -1, -1, -1}, {14642, -1, -1, -1}, {57727, -1, -1, -1}, {57728, -1, -1, -1}, {24611, -1, -1, -1}, {24924, -1, -1, -1}, {25886, -1, -1, -1}, {25483, -1, -1, -1}, {57733, -1, -1, -1}, {25285, -1, -1, -1}, {57735, -1, -1, -1}, {25301, -1, -1, -1}, {57737, -1, -1, -1}, {25452, -1, -1, -1}, {57739, -1, -1, -1}, {14871, -1, -1, -1}, {25656, -1, -1, -1}, {25592, -1, -1, -1}, {57743, -1, -1, -1}, {57744, -1, -1, -1}, {28554, -1, -1, -1}, {57747, -1, -1, -1}, {-1, -1, -1, -1}, {57750, -1, -1, -1}, {25825, -1, -1, -1}, {25829, -1, -1, -1}, {38011, -1, -1, -1}, {14950, -1, -1, -1}, {25658, -1, -1, -1}, {14935, -1, -1, -1}, {25933, -1, -1, -1}, {28438, -1, -1, -1}, {57759, -1, -1, -1}, {57760, -1, -1, -1}, {25989, -1, -1, -1}, {25965, -1, -1, -1}, {25951, -1, -1, -1}, {-1, -1, -1, -1}, {26037, -1, -1, -1}, {57766, -1, -1, -1}, {19255, -1, -1, -1}, {26065, -1, -1, -1}, {16600, -1, -1, -1}, {57770, -1, -1, -1}, {-1, -1, -1, -1}, {26083, -1, -1, -1}, {24543, -1, -1, -1}, {57774, -1, -1, -1}, {26136, -1, -1, -1}, {57776, -1, -1, -1}, {57777, -1, -1, -1}, {26180, -1, -1, -1}, {57779, -1, -1, -1}, {57780, -1, -1, -1}, {26187, -1, -1, -1}, {57782, -1, -1, -1}, {26215, -1, -1, -1}, {57784, -1, -1, -1}, {26227, -1, -1, -1}, {-1, -1, -1, -1}, {57788, -1, -1, -1}, {57789, -1, -1, -1}, {57790, -1, -1, -1}, {57791, -1, -1, -1}, {30661, -1, -1, -1}, {57793, -1, -1, -1}, {39332, -1, -1, -1}, {26370, -1, -1, -1}, {57796, -1, -1, -1}, {57797, -1, -1, -1}, {27130, -1, -1, -1}, {57800, -1, -1, -1}, {-1, -1, -1, -1}, {26471, -1, -1, -1}, {26466, -1, -1, -1}, {57804, -1, -1, -1}, {57805, -1, -1, -1}, {26583, -1, -1, -1}, {17641, -1, -1, -1}, {26658, -1, -1, -1}, {28240, -1, -1, -1}, {37436, -1, -1, -1}, {26625, -1, -1, -1}, {57812, -1, -1, -1}, {57813, -1, -1, -1}, {26717, -1, -1, -1}, {57815, -1, -1, -1}, {27105, -1, -1, -1}, {27147, -1, -1, -1}, {57818, -1, -1, -1}, {26995, -1, -1, -1}, {26819, -1, -1, -1}, {57821, -1, -1, -1}, {26881, -1, -1, -1}, {26880, -1, -1, -1}, {14849, -1, -1, -1}, {57826, -1, -1, -1}, {15232, -1, -1, -1}, {26540, -1, -1, -1}, {26977, -1, -1, -1}, {57830, -1, -1, -1}, {17148, -1, -1, -1}, {26934, -1, -1, -1}, {27032, -1, -1, -1}, {15265, -1, -1, -1}, {57835, -1, -1, -1}, {33635, -1, -1, -1}, {20624, -1, -1, -1}, {27129, -1, -1, -1}, {57839, -1, -1, -1}, {57840, -1, -1, -1}, {27205, -1, -1, -1}, {57842, -1, -1, -1}, {27293, -1, -1, -1}, {15347, -1, -1, -1}, {26545, -1, -1, -1}, {27336, -1, -1, -1}, {57847, -1, -1, -1}, {15373, -1, -1, -1}, {27421, -1, -1, -1}, {57850, -1, -1, -1}, {-1, -1, -1, -1}, {27445, -1, -1, -1}, {27508, -1, -1, -1}, {57854, -1, -1, -1}, {28341, -1, -1, -1}, {57856, -1, -1, -1} },
    {{-1, -1, -1, -1}, {57858, -1, -1, -1}, {14144, -1, -1, -1}, {21537, -1, -1, -1}, {57861, -1, -1, -1}, {27617, -1, -1, -1}, {57863, -1, -1, -1}, {27612, -1, -1, -1}, {27703, -1, -1, -1}, {57866, -1, -1, -1}, {57867, -1, -1, -1}, {57868, -1, -1, -1}, {27738, -1, -1, -1}, {33318, -1, -1, -1}, {27769, -1, -1, -1}, {57872, -1, -1, -1}, {17605, -1, -1, -1}, {57874, -1, -1, -1}, {57875, -1, -1, -1}, {57876, -1, -1, -1}, {57877, -1, -1, -1}, {57878, -1, -1, -1}, {14053, -1, -1, -1}, {15595, -1, -1, -1}, {57881, -1, -1, -1}, {39811, -1, -1, -1}, {57883, -1, -1, -1}, {57884, -1, -1, -1}, {32655, -1, -1, -1}, {26679, -1, -1, -1}, {57887, -1, -1, -1}, {57888, -1, -1, -1}, {57889, -1, -1, -1}, {28054, -1, -1, -1}, {27996, -1, -1, -1}, {28284, -1, -1, -1}, {28420, -1, -1, -1}, {57894, -1, -1, -1}, {57895, -1, -1, -1}, {57896, -1, -1, -1}, {34099, -1, -1, -1}, {57898, -1, -1, -1}, {20935, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {33838, -1, -1, -1}, {57903, -1, -1, -1}, {-1, -1, -1, -1}, {57905, -1, -1, -1}, {29779, -1, -1, -1}, {57907, -1, -1, -1}, {31180, -1, -1, -1}, {28239, -1, -1, -1}, {23185, -1, -1, -1}, {57911, -1, -1, -1}, {28664, -1, -1, -1}, {14093, -1, -1, -1}, {28573, -1, -1, -1}, {57915, -1, -1, -1}, {28410, -1, -1, -1}, {57917, -1, -1, -1}, {57918, -1, -1, -1}, {17749, -1, -1, -1}, {37872, -1, -1, -1}, {28484, -1, -1, -1}, {28508, -1, -1, -1}, {15694, -1, -1, -1}, {28532, -1, -1, -1}, {57925, -1, -1, -1}, {15675, -1, -1, -1}, {28575, -1, -1, -1}, {57928, -1, -1, -1}, {28627, -1, -1, -1}, {57930, -1, -1, -1}, {57931, -1, -1, -1}, {57932, -1, -1, -1}, {57933, -1, -1, -1}, {57934, -1, -1, -1}, {57935, -1, -1, -1}, {20959, -1, -1, -1}, {57937, -1, -1, -1}, {57938, -1, -1, -1}, {57939, -1, -1, -1}, {57940, -1, -1, -1}, {28747, -1, -1, -1}, {28798, -1, -1, -1}, {28839, -1, -1, -1}, {-1, -1, -1, -1}, {28876, -1, -1, -1}, {28885, -1, -1, -1}, {28886, -1, -1, -1}, {28895, -1, -1, -1}, {16644, -1, -1, -1}, {15848, -1, -1, -1}, {29108, -1, -1, -1}, {29078, -1, -1, -1}, {57953, -1, -1, -1}, {28971, -1, -1, -1}, {28997, -1, -1, -1}, {23176, -1, -1, -1}, {29002, -1, -1, -1}, {-1, -1, -1, -1}, {57960, -1, -1, -1}, {29007, -1, -1, -1}, {37730, -1, -1, -1}, {57963, -1, -1, -1}, {28972, -1, -1, -1}, {57965, -1, -1, -1}, {57966, -1, -1, -1}, {57967, -1, -1, -1}, {29114, -1, -1, -1}, {57969, -1, -1, -1}, {28861, -1, -1, -1}, {29198, -1, -1, -1}, {37954, -1, -1, -1}, {29205, -1, -1, -1}, {22801, -1, -1, -1}, {37955, -1, -1, -1}, {29220, -1, -1, -1}, {37697, -1, -1, -1}, {57978, -1, -1, -1}, {29230, -1, -1, -1}, {29248, -1, -1, -1}, {57981, -1, -1, -1}, {26813, -1, -1, -1}, {29269, -1, -1, -1}, {29271, -1, -1, -1}, {15957, -1, -1, -1}, {57986, -1, -1, -1}, {26637, -1, -1, -1}, {28477, -1, -1, -1}, {29314, -1, -1, -1}, {-1, -1, -1, -1}, {29483, -1, -1, -1}, {57992, -1, -1, -1}, {57993, -1, -1, -1}, {18669, -1, -1, -1}, {57995, -1, -1, -1}, {29480, -1, -1, -1}, {29486, -1, -1, -1}, {29647, -1, -1, -1}, {29610, -1, -1, -1}, {58000, -1, -1, -1}, {58001, -1, -1, -1}, {29641, -1, -1, -1}, {29769, -1, -1, -1}, {58004, -1, -1, -1}, {58005, -1, -1, -1}, {58006, -1, -1, -1}, {26147, -1, -1, -1}, {14021, -1, -1, -1}, {58009, -1, -1, -1}, {58010, -1, -1, -1}, {58011, -1, -1, -1}, {29687, -1, -1, -1}, {29717, -1, -1, -1}, {26883, -1, -1, -1}, {58015, -1, -1, -1}, {29753, -1, -1, -1}, {16087, -1, -1, -1}, {-1, -1, -1, -1}, {58020, -1, -1, -1}, {29792, -1, -1, -1}, {58022, -1, -1, -1}, {29767, -1, -1, -1}, {29668, -1, -1, -1}, {29814, -1, -1, -1}, {33721, -1, -1, -1}, {29804, -1, -1, -1}, {29812, -1, -1, -1}, {37873, -1, -1, -1}, {27180, -1, -1, -1}, {29826, -1, -1, -1}, {18771, -1, -1, -1}, {58034, -1, -1, -1}, {58035, -1, -1, -1}, {58036, -1, -1, -1}, {58037, -1, -1, -1}, {23366, -1, -1, -1}, {58039, -1, -1, -1}, {58040, -1, -1, -1}, {29896, -1, -1, -1}, {58042, -1, -1, -1}, {29966, -1, -1, -1}, {29982, -1, -1, -1}, {58046, -1, -1, -1}, {58047, -1, -1, -1}, {23511, -1, -1, -1}, {58049, -1, -1, -1}, {37765, -1, -1, -1}, {30029, -1, -1, -1}, {30026, -1, -1, -1}, {30055, -1, -1, -1}, {30062, -1, -1, -1}, {58055, -1, -1, -1}, {16132, -1, -1, -1}, {58057, -1, -1, -1}, {30094, -1, -1, -1}, {29789, -1, -1, -1}, {30110, -1, -1, -1}, {30132, -1, -1, -1}, {30210, -1, -1, -1}, {30252, -1, -1, -1}, {30289, -1, -1, -1}, {30287, -1, -1, -1}, {30319, -1, -1, -1}, {-1, -1, -1, -1}, {58068, -1, -1, -1}, {30352, -1, -1, -1}, {33263, -1, -1, -1}, {14328, -1, -1, -1}, {58072, -1, -1, -1}, {58073, -1, -1, -1}, {30369, -1, -1, -1}, {30373, -1, -1, -1}, {30391, -1, -1, -1}, {30412, -1, -1, -1}, {58078, -1, -1, -1}, {33890, -1, -1, -1}, {58080, -1, -1, -1}, {58081, -1, -1, -1}, {58082, -1, -1, -1}, {30494, -1, -1, -1}, {30502, -1, -1, -1}, {30528, -1, -1, -1}, {25775, -1, -1, -1}, {58087, -1, -1, -1}, {30552, -1, -1, -1}, {58089, -1, -1, -1}, {30639, -1, -1, -1}, {58091, -1, -1, -1}, {58092, -1, -1, -1}, {58093, -1, -1, -1}, {30708, -1, -1, -1}, {-1, -1, -1, -1}, {26826, -1, -1, -1}, {30895, -1, -1, -1}, {30919, -1, -1, -1}, {30931, -1, -1, -1}, {38565, -1, -1, -1}, {31022, -1, -1, -1}, {58104, -1, -1, -1}, {30935, -1, -1, -1}, {31028, -1, -1, -1}, {30897, -1, -1, -1}, {58108, -1, -1, -1}, {36792, -1, -1, -1}, {34948, -1, -1, -1}, {58113, -1, -1, -1}, {31110, -1, -1, -1}, {35072, -1, -1, -1}, {26882, -1, -1, -1}, {31104, -1, -1, -1}, {58118, -1, -1, -1}, {31133, -1, -1, -1}, {58120, -1, -1, -1} },
    {{31036, -1, -1, -1}, {31145, -1, -1, -1}, {28202, -1, -1, -1}, {58124, -1, -1, -1}, {16040, -1, -1, -1}, {31174, -1, -1, -1}, {58127, -1, -1, -1}, {31188, -1, -1, -1}, {-1, -1, -1, -1}, {21797, -1, -1, -1}, {-1, -1, -1, -1}, {62528, -1, -1, -1}, {62529, -1, -1, -1}, {62530, -1, -1, -1}, {21904, -1, -1, -1}, {62532, -1, -1, -1}, {14828, -1, -1, -1}, {62534, -1, -1, -1}, {36422, -1, -1, -1}, {62536, -1, -1, -1}, {62537, -1, -1, -1}, {-1, -1, -1, -1}, {62539, -1, -1, -1}, {30586, -1, -1, -1}, {62541, -1, -1, -1}, {14900, -1, -1, -1}, {18389, -1, -1, -1}, {62544, -1, -1, -1}, {62545, -1, -1, -1}, {62546, -1, -1, -1}, {25821, -1, -1, -1}, {62548, -1, -1, -1}, {62549, -1, -1, -1}, {62550, -1, -1, -1}, {-1, -1, -1, -1}, {25741, -1, -1, -1}, {36478, -1, -1, -1}, {62554, -1, -1, -1}, {-1, -1, -1, -1}, {62556, -1, -1, -1}, {62557, -1, -1, -1}, {62558, -1, -1, -1}, {62559, -1, -1, -1}, {-1, -1, -1, -1}, {62561, -1, -1, -1}, {62562, -1, -1, -1}, {62563, -1, -1, -1}, {18420, -1, -1, -1}, {62565, -1, -1, -1}, {62566, -1, -1, -1}, {39602, -1, -1, -1}, {14951, -1, -1, -1}, {62569, -1, -1, -1}, {16365, -1, -1, -1}, {13574, -1, -1, -1}, {62572, -1, -1, -1}, {62573, -1, -1, -1}, {-1, -1, -1, -1}, {62575, -1, -1, -1}, {40302, -1, -1, -1}, {38933, -1, -1, -1}, {-1, -1, -1, -1}, {17369, -1, -1, -1}, {-1, -1, -1, -1}, {25780, -1, -1, -1}, {21731, -1, -1, -1}, {-1, -1, -1, -1}, {62584, -1, -1, -1}, {-1, -1, -1, -1}, {14843, -1, -1, -1}, {-1, -1, -1, -1}, {62588, -1, -1, -1}, {62589, -1, -1, -1}, {62590, -1, -1, -1}, {25834, -1, -1, -1}, {62592, -1, -1, -1}, {62593, -1, -1, -1}, {36456, -1, -1, -1}, {-1, -1, -1, -1}, {62596, -1, -1, -1}, {62597, -1, -1, -1}, {-1, -1, -1, -1}, {18443, -1, -1, -1}, {62600, -1, -1, -1}, {16378, -1, -1, -1}, {22643, -1, -1, -1}, {62603, -1, -1, -1}, {-1, -1, -1, -1}, {62605, -1, -1, -1}, {62606, -1, -1, -1}, {62607, -1, -1, -1}, {62608, -1, -1, -1}, {-1, -1, -1, -1}, {21881, -1, -1, -1}, {-1, -1, -1, -1}, {17338, -1, -1, -1}, {-1, -1, -1, -1}, {19124, -1, -1, -1}, {62615, -1, -1, -1}, {62616, -1, -1, -1}, {33194, -1, -1, -1}, {39157, -1, -1, -1}, {62619, -1, -1, -1}, {25465, -1, -1, -1}, {14846, -1, -1, -1}, {62622, -1, -1, -1}, {36288, -1, -1, -1}, {22177, -1, -1, -1}, {25724, -1, -1, -1}, {15939, -1, -1, -1}, {-1, -1, -1, -1}, {62628, -1, -1, -1}, {62629, -1, -1, -1}, {62630, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {62633, -1, -1, -1}, {62634, -1, -1, -1}, {14738, -1, -1, -1}, {14854, -1, -1, -1}, {62637, -1, -1, -1}, {13688, -1, -1, -1}, {62639, -1, -1, -1}, {62640, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {62643, -1, -1, -1}, {62644, -1, -1, -1}, {13500, -1, -1, -1}, {27709, -1, -1, -1}, {62647, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {62650, -1, -1, -1}, {62651, -1, -1, -1}, {62652, -1, -1, -1}, {62653, -1, -1, -1}, {62654, -1, -1, -1}, {62655, -1, -1, -1}, {62656, -1, -1, -1}, {62683, -1, -1, -1}, {62684, -1, -1, -1}, {62687, -1, -1, -1}, {14872, -1, -1, -1}, {62691, -1, -1, -1}, {62693, -1, -1, -1}, {62695, -1, -1, -1}, {62696, -1, -1, -1}, {62697, -1, -1, -1}, {38314, -1, -1, -1}, {-1, -1, -1, -1}, {62706, -1, -1, -1}, {28992, -1, -1, -1}, {-1, -1, -1, -1}, {20822, -1, -1, -1}, {-1, -1, -1, -1}, {20616, -1, -1, -1}, {-1, -1, -1, -1}, {13459, -1, -1, -1}, {20870, -1, -1, -1}, {24130, -1, -1, -1}, {20997, -1, -1, -1}, {21031, -1, -1, -1}, {21113, -1, -1, -1}, {-1, -1, -1, -1}, {13651, -1, -1, -1}, {21442, -1, -1, -1}, {21343, -1, -1, -1}, {21708, -1, -1, -1}, {21823, -1, -1, -1}, {21945, -1, -1, -1}, {21976, -1, -1, -1}, {13789, -1, -1, -1}, {22049, -1, -1, -1}, {21843, -1, -1, -1}, {22100, -1, -1, -1}, {60148, -1, -1, -1}, {-1, -1, -1, -1}, {60153, -1, -1, -1}, {-1, -1, -1, -1}, {61095, -1, -1, -1}, {23247, -1, -1, -1}, {-1, -1, -1, -1}, {14265, -1, -1, -1}, {23745, -1, -1, -1}, {23829, -1, -1, -1}, {23894, -1, -1, -1}, {14392, -1, -1, -1}, {20097, -1, -1, -1}, {24253, -1, -1, -1}, {14612, -1, -1, -1}, {25017, -1, -1, -1}, {25232, -1, -1, -1}, {25368, -1, -1, -1}, {25690, -1, -1, -1}, {25745, -1, -1, -1}, {33133, -1, -1, -1}, {33156, -1, -1, -1}, {33171, -1, -1, -1}, {26624, -1, -1, -1}, {15292, -1, -1, -1}, {29327, -1, -1, -1}, {29389, -1, -1, -1}, {-1, -1, -1, -1}, {29497, -1, -1, -1}, {30018, -1, -1, -1}, {30172, -1, -1, -1}, {16320, -1, -1, -1}, {60278, -1, -1, -1}, {16343, -1, -1, -1}, {-1, -1, -1, -1}, {30336, -1, -1, -1}, {30348, 59824, -1, -1}, {16552, -1, -1, -1}, {30777, -1, -1, -1}, {16643, -1, -1, -1}, {31377, -1, -1, -1}, {31771, -1, -1, -1}, {31981, -1, -1, -1}, {32659, -1, -1, -1}, {32686, -1, -1, -1}, {-1, -1, -1, -1}, {33535, -1, -1, -1}, {22623, -1, -1, -1}, {34482, -1, -1, -1}, {-1, -1, -1, -1}, {34699, -1, -1, -1}, {35143, -1, -1, -1}, {-1, -1, -1, -1}, {35369, -1, -1, -1}, {-1, -1, -1, -1}, {36465, -1, -1, -1}, {60484, -1, -1, -1}, {36528, -1, -1, -1}, {-1, -1, -1, -1}, {37214, -1, -1, -1}, {37260, -1, -1, -1}, {39182, -1, -1, -1}, {39196, -1, -1, -1}, {39266, -1, -1, -1}, {39606, -1, -1, -1}, {39809, -1, -1, -1}, {40384, -1, -1, -1}, {40339, -1, -1, -1}, {40620, -1, -1, -1}, {19857, -1, -1, -1}, {-1, -1, -1, -1}, {37818, -1, -1, -1}, {40571, -1, -1, -1}, {28809, -1, -1, -1}, {29512, -1, -1, -1}, {-1, -1, -1, -1}, {31129, -1, -1, -1}, {36791, -1, -1, -1}, {-1, -1, -1, -1}, {39234, -1, -1, -1} },
    {{-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {8364, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {12443, -1, -1, -1}, {12444, -1, -1, -1}, {11904, -1, -1, -1}, {62211, -1, -1, -1}, {62212, -1, -1, -1}, {62213, -1, -1, -1}, {62214, -1, -1, -1}, {62215, -1, -1, -1}, {62216, -1, -1, -1}, {62217, -1, -1, -1}, {62218, -1, -1, -1}, {62219, -1, -1, -1}, {62220, -1, -1, -1}, {62221, -1, -1, -1}, {62222, -1, -1, -1}, {62223, -1, -1, -1}, {62224, -1, -1, -1}, {62225, -1, -1, -1}, {62226, -1, -1, -1}, {62227, -1, -1, -1}, {62228, -1, -1, -1}, {62229, -1, -1, -1}, {62230, -1, -1, -1}, {62231, -1, -1, -1}, {62232, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {62778, -1, -1, -1}, {62779, -1, -1, -1}, {38737, -1, -1, -1}, {62781, -1, -1, -1}, {20059, -1, -1, -1}, {20155, -1, -1, -1}, {13630, -1, -1, -1}, {23587, -1, -1, -1}, {24401, -1, -1, -1}, {24516, -1, -1, -1}, {14586, -1, -1, -1}, {25164, -1, -1, -1}, {25909, -1, -1, -1}, {27514, -1, -1, -1}, {27701, -1, -1, -1}, {27706, -1, -1, -1}, {28780, -1, -1, -1}, {29227, -1, -1, -1}, {20012, -1, -1, -1}, {29357, -1, -1, -1}, {62798, -1, -1, -1}, {32594, -1, -1, -1}, {31035, -1, -1, -1}, {31993, -1, -1, -1}, {32595, -1, -1, -1}, {62803, -1, -1, -1}, {13505, -1, -1, -1}, {62806, -1, -1, -1}, {32770, -1, -1, -1}, {32896, -1, -1, -1}, {62809, -1, -1, -1} },
    {{62810, -1, -1, -1}, {21341, -1, -1, -1}, {34916, -1, -1, -1}, {35265, -1, -1, -1}, {62814, -1, -1, -1}, {35744, -1, -1, -1}, {36125, -1, -1, -1}, {38021, -1, -1, -1}, {38264, -1, -1, -1}, {38271, -1, -1, -1}, {38376, -1, -1, -1}, {62821, -1, -1, -1}, {38886, -1, -1, -1}, {39029, -1, -1, -1}, {39118, -1, -1, -1}, {39134, -1, -1, -1}, {39267, -1, -1, -1}, {62827, -1, -1, -1}, {40060, -1, -1, -1}, {40479, -1, -1, -1}, {40644, -1, -1, -1}, {27503, -1, -1, -1}, {-1, -1, -1, -1}, {20023, -1, -1, -1}, {62834, -1, -1, -1}, {38429, -1, -1, -1}, {25143, -1, -1, -1}, {38050, -1, -1, -1}, {11908, -1, -1, -1}, {11910, -1, -1, -1}, {11911, -1, -1, -1}, {11912, -1, -1, -1}, {11914, -1, -1, -1}, {11916, -1, -1, -1}, {11917, -1, -1, -1}, {11925, -1, -1, -1}, {11932, -1, -1, -1}, {11941, -1, -1, -1}, {11943, -1, -1, -1}, {11946, -1, -1, -1}, {11948, -1, -1, -1}, {11950, -1, -1, -1}, {11958, -1, -1, -1}, {11964, -1, -1, -1}, {11966, -1, -1, -1}, {11978, -1, -1, -1}, {11980, -1, -1, -1}, {11981, -1, -1, -1}, {11983, -1, -1, -1}, {11990, -1, -1, -1}, {11991, -1, -1, -1}, {11998, -1, -1, -1}, {62368, -1, -1, -1}, {62369, -1, -1, -1}, {25866, -1, -1, -1}, {20029, -1, -1, -1}, {28381, -1, -1, -1}, {40270, -1, -1, -1}, {37343, -1, -1, -1}, {62380, -1, -1, -1}, {20250, -1, -1, -1}, {20264, -1, -1, -1}, {20392, -1, -1, -1}, {20852, -1, -1, -1}, {20892, -1, -1, -1}, {20964, -1, -1, -1}, {21153, -1, -1, -1}, {21160, -1, -1, -1}, {21307, -1, -1, -1}, {21326, -1, -1, -1}, {21457, -1, -1, -1}, {21464, -1, -1, -1}, {22242, -1, -1, -1}, {22768, -1, -1, -1}, {22788, -1, -1, -1}, {22791, -1, -1, -1}, {22834, -1, -1, -1}, {22836, -1, -1, -1}, {23398, -1, -1, -1}, {23454, -1, -1, -1}, {23455, -1, -1, -1}, {23706, -1, -1, -1}, {24198, -1, -1, -1}, {24635, -1, -1, -1}, {25993, -1, -1, -1}, {26622, -1, -1, -1}, {26628, -1, -1, -1}, {26725, -1, -1, -1}, {27982, -1, -1, -1}, {28860, -1, -1, -1}, {30005, -1, -1, -1}, {32420, -1, -1, -1}, {32428, -1, -1, -1}, {32442, -1, -1, -1}, {32455, -1, -1, -1}, {32463, -1, -1, -1}, {32479, -1, -1, -1}, {32518, -1, -1, -1}, {32567, -1, -1, -1}, {33402, -1, -1, -1}, {33487, -1, -1, -1}, {33647, -1, -1, -1}, {35270, -1, -1, -1}, {35774, -1, -1, -1}, {35810, -1, -1, -1}, {36710, -1, -1, -1}, {36711, -1, -1, -1}, {36718, -1, -1, -1}, {29713, -1, -1, -1}, {31996, -1, -1, -1}, {32205, -1, -1, -1}, {26950, -1, -1, -1}, {31433, -1, -1, -1}, {30904, -1, -1, -1}, {32956, -1, -1, -1}, {36107, -1, -1, -1}, {33014, -1, -1, -1}, {62448, -1, -1, -1}, {32927, -1, -1, -1}, {40647, -1, -1, -1}, {19661, -1, -1, -1}, {40393, -1, -1, -1}, {40460, -1, -1, -1}, {19518, -1, -1, -1}, {62457, -1, -1, -1}, {62458, -1, -1, -1}, {40458, -1, -1, -1}, {62460, -1, -1, -1}, {13761, -1, -1, -1}, {28314, -1, -1, -1}, {33342, -1, -1, -1}, {29977, -1, -1, -1}, {18705, -1, -1, -1}, {39532, -1, -1, -1}, {39567, -1, -1, -1}, {40857, -1, -1, -1}, {31111, -1, -1, -1}, {62472, -1, -1, -1}, {62473, -1, -1, -1}, {62474, -1, -1, -1}, {62475, -1, -1, -1}, {20004, -1, -1, -1}, {20096, -1, -1, -1}, {20103, -1, -1, -1}, {20159, -1, -1, -1}, {20203, -1, -1, -1}, {20279, -1, -1, -1}, {13388, -1, -1, -1}, {20413, -1, -1, -1}, {15944, -1, -1, -1}, {20483, -1, -1, -1}, {13437, -1, -1, -1}, {13477, -1, -1, -1}, {22789, -1, -1, -1}, {20955, -1, -1, -1}, {20988, -1, -1, -1}, {20105, -1, -1, -1}, {21136, -1, -1, -1}, {21287, -1, -1, -1}, {13767, -1, -1, -1}, {21417, -1, -1, -1}, {13649, -1, -1, -1}, {21424, -1, -1, -1}, {21539, -1, -1, -1}, {13677, -1, -1, -1}, {13682, -1, -1, -1}, {13953, -1, -1, -1}, {21651, -1, -1, -1}, {21667, -1, -1, -1}, {21684, -1, -1, -1}, {21689, -1, -1, -1}, {21712, -1, -1, -1}, {21743, -1, -1, -1}, {21784, -1, -1, -1}, {21795, -1, -1, -1}, {21800, -1, -1, -1}, {13720, -1, -1, -1}, {13733, -1, -1, -1}, {13759, -1, -1, -1}, {21975, -1, -1, -1}, {13765, -1, -1, -1}, {62525, -1, -1, -1}, {16467, -1, -1, -1}, {62551, -1, -1, -1}, {62555, -1, -1, -1}, {62574, -1, -1, -1}, {62580, -1, -1, -1}, {62583, -1, -1, -1}, {62585, -1, -1, -1}, {62587, -1, -1, -1}, {62595, -1, -1, -1}, {62609, -1, -1, -1}, {16571, -1, -1, -1}, {62631, -1, -1, -1}, {22098, -1, -1, -1}, {62642, -1, -1, -1}, {62657, -1, -1, -1}, {62659, -1, -1, -1}, {62660, -1, -1, -1}, {62661, -1, -1, -1}, {13819, -1, -1, -1}, {62663, -1, -1, -1}, {62664, -1, -1, -1}, {62665, -1, -1, -1}, {62666, -1, -1, -1}, {16275, -1, -1, -1}, {62668, -1, -1, -1}, {62669, -1, -1, -1}, {62670, -1, -1, -1}, {62671, -1, -1, -1}, {62673, -1, -1, -1}, {62674, -1, -1, -1}, {62675, -1, -1, -1}, {62676, -1, -1, -1}, {62677, -1, -1, -1}, {16377, -1, -1, -1}, {62679, -1, -1, -1}, {25650, -1, -1, -1}, {62681, -1, -1, -1}, {62682, -1, -1, -1}, {62685, -1, -1, -1}, {62686, -1, -1, -1}, {62688, -1, -1, -1}, {62690, -1, -1, -1}, {62692, -1, -1, -1}, {62694, -1, -1, -1}, {-1, -1, -1, -1}, {33476, -1, -1, -1}, {-1, -1, -1, -1}, {62703, -1, -1, -1}, {39974, -1, -1, -1}, {-1, -1, -1, -1}, {62707, -1, -1, -1}, {33004, -1, -1, -1}, {23580, -1, -1, -1}, {62712, -1, -1, -1}, {33076, -1, -1, -1}, {14231, -1, -1, -1}, {62716, -1, -1, -1}, {37302, -1, -1, -1}, {62718, -1, -1, -1}, {62719, -1, -1, -1}, {62720, -1, -1, -1}, {62721, -1, -1, -1}, {62723, -1, -1, -1}, {13833, -1, -1, -1}, {62725, -1, -1, -1}, {22191, -1, -1, -1}, {62727, -1, -1, -1}, {62728, -1, -1, -1}, {62729, -1, -1, -1}, {62730, -1, -1, -1}, {62731, -1, -1, -1}, {62732, -1, -1, -1}, {62733, -1, -1, -1}, {62734, -1, -1, -1} },
    {{62735, -1, -1, -1}, {62736, -1, -1, -1}, {62737, -1, -1, -1}, {23124, -1, -1, -1}, {62739, -1, -1, -1}, {62740, -1, -1, -1}, {62741, -1, -1, -1}, {62742, -1, -1, -1}, {22428, -1, -1, -1}, {62744, -1, -1, -1}, {62745, -1, -1, -1}, {62746, -1, -1, -1}, {62747, -1, -1, -1}, {62748, -1, -1, -1}, {62749, -1, -1, -1}, {14083, -1, -1, -1}, {62751, -1, -1, -1}, {62752, -1, -1, -1}, {62753, -1, -1, -1}, {62754, -1, -1, -1}, {62755, -1, -1, -1}, {62756, -1, -1, -1}, {62757, -1, -1, -1}, {62758, -1, -1, -1}, {22681, -1, -1, -1}, {21096, -1, -1, -1}, {13850, -1, -1, -1}, {62762, -1, -1, -1}, {31666, -1, -1, -1}, {23400, -1, -1, -1}, {18432, -1, -1, -1}, {19244, -1, -1, -1}, {40743, -1, -1, -1}, {18919, -1, -1, -1}, {39967, -1, -1, -1}, {39821, -1, -1, -1}, {62771, -1, -1, -1}, {62772, -1, -1, -1}, {22011, -1, -1, -1}, {13810, -1, -1, -1}, {22153, -1, -1, -1}, {23870, -1, -1, -1}, {23880, -1, -1, -1}, {15868, -1, -1, -1}, {14351, -1, -1, -1}, {23972, -1, -1, -1}, {23993, -1, -1, -1}, {14368, -1, -1, -1}, {24357, -1, -1, -1}, {24451, -1, -1, -1}, {14600, -1, -1, -1}, {14655, -1, -1, -1}, {14669, -1, -1, -1}, {24791, -1, -1, -1}, {24893, -1, -1, -1}, {23781, -1, -1, -1}, {14729, -1, -1, -1}, {25015, -1, -1, -1}, {25039, -1, -1, -1}, {14776, -1, -1, -1}, {25132, -1, -1, -1}, {25317, -1, -1, -1}, {14840, -1, -1, -1}, {22193, -1, -1, -1}, {14851, -1, -1, -1}, {25570, -1, -1, -1}, {25595, -1, -1, -1}, {25607, -1, -1, -1}, {14923, -1, -1, -1}, {25792, -1, -1, -1}, {40863, -1, -1, -1}, {14999, -1, -1, -1}, {25990, -1, -1, -1}, {15037, -1, -1, -1}, {26111, -1, -1, -1}, {26195, -1, -1, -1}, {15090, -1, -1, -1}, {26258, -1, -1, -1}, {15138, -1, -1, -1}, {26390, -1, -1, -1}, {15170, -1, -1, -1}, {26532, -1, -1, -1}, {15192, -1, -1, -1}, {26698, -1, -1, -1}, {26756, -1, -1, -1}, {15218, -1, -1, -1}, {15217, -1, -1, -1}, {15227, -1, -1, -1}, {26889, -1, -1, -1}, {26947, -1, -1, -1}, {29276, -1, -1, -1}, {26980, -1, -1, -1}, {27039, -1, -1, -1}, {27013, -1, -1, -1}, {27094, -1, -1, -1}, {15325, -1, -1, -1}, {27237, -1, -1, -1}, {27252, -1, -1, -1}, {27249, -1, -1, -1}, {27266, -1, -1, -1}, {15340, -1, -1, -1}, {27289, -1, -1, -1}, {15346, -1, -1, -1}, {27307, -1, -1, -1}, {27317, -1, -1, -1}, {27348, -1, -1, -1}, {27382, -1, -1, -1}, {27521, -1, -1, -1}, {27585, -1, -1, -1}, {27626, -1, -1, -1}, {27765, -1, -1, -1}, {27818, -1, -1, -1}, {15563, -1, -1, -1}, {27906, -1, -1, -1}, {27910, -1, -1, -1}, {27942, -1, -1, -1}, {28033, -1, -1, -1}, {15599, -1, -1, -1}, {28068, -1, -1, -1}, {28081, -1, -1, -1}, {28181, -1, -1, -1}, {28184, -1, -1, -1}, {28201, -1, -1, -1}, {28294, -1, -1, -1}, {63124, -1, -1, -1}, {28347, -1, -1, -1}, {28386, -1, -1, -1}, {28378, -1, -1, -1}, {40831, -1, -1, -1}, {28392, -1, -1, -1}, {28393, -1, -1, -1}, {28452, -1, -1, -1}, {28468, -1, -1, -1}, {15686, -1, -1, -1}, {63134, -1, -1, -1}, {28545, -1, -1, -1}, {28606, -1, -1, -1}, {15722, -1, -1, -1}, {15733, -1, -1, -1}, {29111, -1, -1, -1}, {23705, -1, -1, -1}, {15754, -1, -1, -1}, {28716, -1, -1, -1}, {15761, -1, -1, -1}, {28752, -1, -1, -1}, {28756, -1, -1, -1}, {28783, -1, -1, -1}, {28799, -1, -1, -1}, {63149, -1, -1, -1}, {17345, -1, -1, -1}, {13809, -1, -1, -1}, {63152, -1, -1, -1}, {13902, -1, -1, -1}, {15789, -1, -1, -1}, {58173, -1, -1, -1}, {26237, -1, -1, -1}, {31860, -1, -1, -1}, {29837, -1, -1, -1}, {32402, -1, -1, -1}, {17667, -1, -1, -1}, {58260, -1, -1, -1}, {58270, -1, -1, -1}, {58277, -1, -1, -1}, {13438, -1, -1, -1}, {58317, -1, -1, -1}, {58325, -1, -1, -1}, {58343, -1, -1, -1}, {-1, -1, -1, -1}, {25537, -1, -1, -1}, {30583, -1, -1, -1}, {-1, -1, -1, -1}, {58406, -1, -1, -1}, {-1, -1, -1, -1}, {58440, -1, -1, -1}, {18730, -1, -1, -1}, {58471, -1, -1, -1}, {58472, -1, -1, -1}, {58473, -1, -1, -1}, {15088, -1, -1, -1}, {28815, -1, -1, -1}, {58529, -1, -1, -1}, {58637, -1, -1, -1}, {58646, -1, -1, -1}, {26760, -1, -1, -1}, {58664, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {58802, -1, -1, -1}, {37734, -1, -1, -1}, {37519, -1, -1, -1}, {34324, -1, -1, -1}, {58986, -1, -1, -1}, {16784, -1, -1, -1}, {26511, -1, -1, -1}, {26654, -1, -1, -1}, {14435, -1, -1, -1}, {59077, -1, -1, -1}, {15129, -1, -1, -1}, {-1, -1, -1, -1}, {59241, -1, -1, -1}, {14818, -1, -1, -1}, {-1, -1, -1, -1}, {17262, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {18733, -1, -1, -1}, {28439, -1, -1, -1}, {59704, -1, -1, -1}, {-1, -1, -1, -1}, {59752, -1, -1, -1}, {32357, -1, -1, -1}, {23855, -1, -1, -1}, {15859, -1, -1, -1}, {59758, -1, -1, -1}, {59759, -1, -1, -1}, {32164, -1, -1, -1}, {33830, -1, -1, -1}, {21637, -1, -1, -1}, {59763, -1, -1, -1}, {59765, -1, -1, -1}, {22398, -1, -1, -1}, {59767, -1, -1, -1}, {59768, -1, -1, -1}, {16357, -1, -1, -1}, {59770, -1, -1, -1}, {59771, -1, -1, -1}, {28675, -1, -1, -1}, {59773, -1, -1, -1}, {23920, -1, -1, -1}, {29583, -1, -1, -1}, {59777, -1, -1, -1}, {59778, -1, -1, -1}, {20424, -1, -1, -1}, {32743, -1, -1, -1}, {29456, -1, -1, -1}, {29496, -1, -1, -1}, {29505, -1, -1, -1}, {16041, -1, -1, -1}, {29173, -1, -1, -1}, {59793, -1, -1, -1}, {29665, -1, -1, -1}, {16074, -1, -1, -1}, {16081, -1, -1, -1}, {29721, -1, -1, -1}, {29726, -1, -1, -1}, {29727, -1, -1, -1}, {16098, -1, -1, -1}, {16112, -1, -1, -1}, {16116, -1, -1, -1}, {16122, -1, -1, -1}, {29907, -1, -1, -1}, {16142, -1, -1, -1}, {16211, -1, -1, -1}, {30061, -1, -1, -1}, {30066, -1, -1, -1}, {30093, -1, -1, -1} },
    {{16252, -1, -1, -1}, {30152, -1, -1, -1}, {30285, -1, -1, -1}, {30324, -1, -1, -1}, {16348, -1, -1, -1}, {30330, -1, -1, -1}, {29064, -1, -1, -1}, {22051, -1, -1, -1}, {35200, -1, -1, -1}, {16413, -1, -1, -1}, {30531, -1, -1, -1}, {16441, -1, -1, -1}, {16453, -1, -1, -1}, {13787, -1, -1, -1}, {30616, -1, -1, -1}, {16490, -1, -1, -1}, {16495, -1, -1, -1}, {30654, -1, -1, -1}, {30667, -1, -1, -1}, {30744, -1, -1, -1}, {30748, -1, -1, -1}, {30791, -1, -1, -1}, {30801, -1, -1, -1}, {30822, -1, -1, -1}, {33864, -1, -1, -1}, {59851, -1, -1, -1}, {31027, -1, -1, -1}, {31026, -1, -1, -1}, {16649, -1, -1, -1}, {31121, -1, -1, -1}, {31238, -1, -1, -1}, {16743, -1, -1, -1}, {16818, -1, -1, -1}, {31420, -1, -1, -1}, {33401, -1, -1, -1}, {16836, -1, -1, -1}, {31439, -1, -1, -1}, {31451, -1, -1, -1}, {16847, -1, -1, -1}, {31586, -1, -1, -1}, {31596, -1, -1, -1}, {31611, -1, -1, -1}, {31762, -1, -1, -1}, {16992, -1, -1, -1}, {17018, -1, -1, -1}, {31867, -1, -1, -1}, {31900, -1, -1, -1}, {17036, -1, -1, -1}, {31928, -1, -1, -1}, {17044, -1, -1, -1}, {36755, -1, -1, -1}, {28864, -1, -1, -1}, {59887, -1, -1, -1}, {32207, -1, -1, -1}, {32212, -1, -1, -1}, {32208, -1, -1, -1}, {32253, -1, -1, -1}, {32692, -1, -1, -1}, {29343, -1, -1, -1}, {17303, -1, -1, -1}, {32800, -1, -1, -1}, {32805, -1, -1, -1}, {32814, -1, -1, -1}, {32817, -1, -1, -1}, {32852, -1, -1, -1}, {22452, -1, -1, -1}, {28832, -1, -1, -1}, {32951, -1, -1, -1}, {33001, -1, -1, -1}, {17389, -1, -1, -1}, {33036, -1, -1, -1}, {33038, -1, -1, -1}, {33042, -1, -1, -1}, {33044, -1, -1, -1}, {17409, -1, -1, -1}, {15161, -1, -1, -1}, {33110, -1, -1, -1}, {33113, -1, -1, -1}, {33114, -1, -1, -1}, {17427, -1, -1, -1}, {33148, -1, -1, -1}, {17445, -1, -1, -1}, {17453, -1, -1, -1}, {33189, -1, -1, -1}, {22511, -1, -1, -1}, {33217, -1, -1, -1}, {33252, -1, -1, -1}, {33364, -1, -1, -1}, {17551, -1, -1, -1}, {33398, -1, -1, -1}, {33482, -1, -1, -1}, {33496, -1, -1, -1}, {17584, -1, -1, -1}, {33623, -1, -1, -1}, {38505, -1, -1, -1}, {33797, -1, -1, -1}, {28917, -1, -1, -1}, {33892, -1, -1, -1}, {33928, -1, -1, -1}, {17668, -1, -1, -1}, {33982, -1, -1, -1}, {34017, -1, -1, -1}, {34040, -1, -1, -1}, {34064, -1, -1, -1}, {34104, -1, -1, -1}, {34130, -1, -1, -1}, {17723, -1, -1, -1}, {34159, -1, -1, -1}, {34160, -1, -1, -1}, {34272, -1, -1, -1}, {17783, -1, -1, -1}, {34418, -1, -1, -1}, {34450, -1, -1, -1}, {34543, -1, -1, -1}, {38469, -1, -1, -1}, {17926, -1, -1, -1}, {17943, -1, -1, -1}, {34990, -1, -1, -1}, {35071, -1, -1, -1}, {35108, -1, -1, -1}, {35217, -1, -1, -1}, {59971, -1, -1, -1}, {35384, -1, -1, -1}, {35476, -1, -1, -1}, {35508, -1, -1, -1}, {35921, -1, -1, -1}, {36052, -1, -1, -1}, {36082, -1, -1, -1}, {36124, -1, -1, -1}, {18328, -1, -1, -1}, {36291, -1, -1, -1}, {18413, -1, -1, -1}, {36410, -1, -1, -1}, {22356, -1, -1, -1}, {22005, -1, -1, -1}, {18487, -1, -1, -1}, {36558, -1, -1, -1}, {36578, -1, -1, -1}, {36580, -1, -1, -1}, {36589, -1, -1, -1}, {36594, -1, -1, -1}, {36801, -1, -1, -1}, {36810, -1, -1, -1}, {36812, -1, -1, -1}, {36915, -1, -1, -1}, {18605, -1, -1, -1}, {39136, -1, -1, -1}, {37395, -1, -1, -1}, {18718, -1, -1, -1}, {37416, -1, -1, -1}, {37464, -1, -1, -1}, {37483, -1, -1, -1}, {37553, -1, -1, -1}, {37550, -1, -1, -1}, {37567, -1, -1, -1}, {37603, -1, -1, -1}, {37611, -1, -1, -1}, {37619, -1, -1, -1}, {37620, -1, -1, -1}, {37629, -1, -1, -1}, {37699, -1, -1, -1}, {37764, -1, -1, -1}, {37805, -1, -1, -1}, {18757, -1, -1, -1}, {18769, -1, -1, -1}, {37911, -1, -1, -1}, {37917, -1, -1, -1}, {37933, -1, -1, -1}, {37950, -1, -1, -1}, {18794, -1, -1, -1}, {37972, -1, -1, -1}, {38009, -1, -1, -1}, {38189, -1, -1, -1}, {38306, -1, -1, -1}, {18855, -1, -1, -1}, {38388, -1, -1, -1}, {38451, -1, -1, -1}, {18917, -1, -1, -1}, {18980, -1, -1, -1}, {38720, -1, -1, -1}, {18997, -1, -1, -1}, {38834, -1, -1, -1}, {38850, -1, -1, -1}, {19172, -1, -1, -1}, {39097, -1, -1, -1}, {19225, -1, -1, -1}, {39153, -1, -1, -1}, {22596, -1, -1, -1}, {39193, -1, -1, -1}, {39223, -1, -1, -1}, {39261, -1, -1, -1}, {-1, -1, -1, -1}, {19312, -1, -1, -1}, {39365, -1, -1, -1}, {19357, -1, -1, -1}, {39484, -1, -1, -1}, {39695, -1, -1, -1}, {39785, -1, -1, -1}, {39901, -1, -1, -1}, {39921, -1, -1, -1}, {39924, -1, -1, -1}, {19565, -1, -1, -1}, {39968, -1, -1, -1}, {14191, -1, -1, -1}, {60073, -1, -1, -1}, {40265, -1, -1, -1}, {40702, -1, -1, -1}, {22096, -1, -1, -1}, {40381, -1, -1, -1}, {40444, -1, -1, -1}, {38134, -1, -1, -1}, {36790, -1, -1, -1}, {40625, -1, -1, -1}, {40637, -1, -1, -1}, {40646, -1, -1, -1}, {38108, -1, -1, -1}, {40674, -1, -1, -1}, {40689, -1, -1, -1}, {40696, -1, -1, -1}, {40772, -1, -1, -1}, {60095, -1, -1, -1}, {60096, -1, -1, -1}, {60097, -1, -1, -1}, {38083, -1, -1, -1}, {60101, -1, -1, -1}, {38081, -1, -1, -1}, {60105, -1, -1, -1}, {60106, -1, -1, -1}, {60107, -1, -1, -1}, {60108, -1, -1, -1}, {22359, -1, -1, -1}, {29043, -1, -1, -1}, {60111, -1, -1, -1}, {60112, -1, -1, -1}, {60113, -1, -1, -1}, {60115, -1, -1, -1}, {60116, -1, -1, -1}, {21662, -1, -1, -1}, {60118, -1, -1, -1}, {60119, -1, -1, -1}, {60120, -1, -1, -1}, {60121, -1, -1, -1}, {60122, -1, -1, -1}, {60124, -1, -1, -1}, {60126, -1, -1, -1}, {60127, -1, -1, -1}, {60128, -1, -1, -1}, {60129, -1, -1, -1}, {60130, -1, -1, -1}, {60131, -1, -1, -1}, {60135, -1, -1, -1}, {60136, -1, -1, -1}, {60137, -1, -1, -1}, {60138, -1, -1, -1}, {60139, -1, -1, -1}, {60140, -1, -1, -1} },
    {{60142, -1, -1, -1}, {60144, -1, -1, -1}, {60145, -1, -1, -1}, {60146, -1, -1, -1}, {60149, -1, -1, -1}, {60150, -1, -1, -1}, {13895, -1, -1, -1}, {60152, -1, -1, -1}, {60154, -1, -1, -1}, {60155, -1, -1, -1}, {21348, -1, -1, -1}, {60158, -1, -1, -1}, {60159, -1, -1, -1}, {60160, -1, -1, -1}, {60162, -1, -1, -1}, {60163, -1, -1, -1}, {60164, -1, -1, -1}, {60165, -1, -1, -1}, {28859, -1, -1, -1}, {60168, -1, -1, -1}, {60169, -1, -1, -1}, {60170, -1, -1, -1}, {60171, -1, -1, -1}, {60172, -1, -1, -1}, {60173, -1, -1, -1}, {60174, -1, -1, -1}, {60175, -1, -1, -1}, {60177, -1, -1, -1}, {60178, -1, -1, -1}, {29080, -1, -1, -1}, {60181, -1, -1, -1}, {-1, -1, -1, -1}, {14024, -1, -1, -1}, {60184, -1, -1, -1}, {60185, -1, -1, -1}, {60186, -1, -1, -1}, {60187, -1, -1, -1}, {60188, -1, -1, -1}, {60189, -1, -1, -1}, {60191, -1, -1, -1}, {60192, -1, -1, -1}, {60193, -1, -1, -1}, {60195, -1, -1, -1}, {60197, -1, -1, -1}, {60199, -1, -1, -1}, {60202, -1, -1, -1}, {60204, -1, -1, -1}, {60205, -1, -1, -1}, {60206, -1, -1, -1}, {60207, -1, -1, -1}, {60208, -1, -1, -1}, {60209, -1, -1, -1}, {60210, -1, -1, -1}, {60211, -1, -1, -1}, {60212, -1, -1, -1}, {60213, -1, -1, -1}, {60214, -1, -1, -1}, {60215, -1, -1, -1}, {60216, -1, -1, -1}, {60217, -1, -1, -1}, {60222, -1, -1, -1}, {60223, -1, -1, -1}, {60227, -1, -1, -1}, {60228, -1, -1, -1}, {22709, -1, -1, -1}, {60234, -1, -1, -1}, {60237, -1, -1, -1}, {60238, -1, -1, -1}, {60243, -1, -1, -1}, {60245, -1, -1, -1}, {60246, -1, -1, -1}, {60248, -1, -1, -1}, {60249, -1, -1, -1}, {60258, -1, -1, -1}, {60259, -1, -1, -1}, {22408, -1, -1, -1}, {60261, -1, -1, -1}, {60263, -1, -1, -1}, {60271, -1, -1, -1}, {60272, -1, -1, -1}, {60273, -1, -1, -1}, {60275, -1, -1, -1}, {22885, -1, -1, -1}, {60279, -1, -1, -1}, {60282, -1, -1, -1}, {22335, -1, -1, -1}, {60286, -1, -1, -1}, {60287, -1, -1, -1}, {60291, -1, -1, -1}, {60292, -1, -1, -1}, {60296, -1, -1, -1}, {60298, -1, -1, -1}, {60300, -1, -1, -1}, {60301, -1, -1, -1}, {60302, -1, -1, -1}, {60304, -1, -1, -1}, {60309, -1, -1, -1}, {60312, -1, -1, -1}, {60313, -1, -1, -1}, {60314, -1, -1, -1}, {22433, -1, -1, -1}, {29009, -1, -1, -1}, {60319, -1, -1, -1}, {60322, -1, -1, -1}, {60325, -1, -1, -1}, {60326, -1, -1, -1}, {60330, -1, -1, -1}, {60334, -1, -1, -1}, {60336, -1, -1, -1}, {60338, -1, -1, -1}, {60339, -1, -1, -1}, {22201, -1, -1, -1}, {60349, -1, -1, -1}, {13848, -1, -1, -1}, {60357, -1, -1, -1}, {60358, -1, -1, -1}, {60360, -1, -1, -1}, {60362, -1, -1, -1}, {60366, -1, -1, -1}, {60368, -1, -1, -1}, {60371, -1, -1, -1}, {60373, -1, -1, -1}, {60378, -1, -1, -1}, {60379, -1, -1, -1}, {60383, -1, -1, -1}, {60385, -1, -1, -1}, {60388, -1, -1, -1}, {60392, -1, -1, -1}, {60393, -1, -1, -1}, {60395, -1, -1, -1}, {60396, -1, -1, -1}, {60399, -1, -1, -1}, {60401, -1, -1, -1}, {38047, -1, -1, -1}, {60405, -1, -1, -1}, {14009, -1, -1, -1}, {60424, -1, -1, -1}, {60425, -1, -1, -1}, {22230, -1, -1, -1}, {60435, -1, -1, -1}, {60441, -1, -1, -1}, {60442, -1, -1, -1}, {60443, -1, -1, -1}, {60444, -1, -1, -1}, {60448, -1, -1, -1}, {60459, -1, -1, -1}, {60463, -1, -1, -1}, {60466, -1, -1, -1}, {60479, -1, -1, -1}, {60480, -1, -1, -1}, {60481, -1, -1, -1}, {60483, -1, -1, -1}, {60485, -1, -1, -1}, {60486, -1, -1, -1}, {60487, -1, -1, -1}, {60488, -1, -1, -1}, {60489, -1, -1, -1}, {60491, -1, -1, -1}, {60492, -1, -1, -1}, {25574, -1, -1, -1}, {60495, -1, -1, -1}, {60498, -1, -1, -1}, {60500, -1, -1, -1}, {60502, -1, -1, -1}, {60503, -1, -1, -1}, {60504, -1, -1, -1}, {60506, -1, -1, -1}, {60508, -1, -1, -1}, {60509, -1, -1, -1}, {60511, -1, -1, -1}, {60512, -1, -1, -1}, {15863, -1, -1, -1}, {60514, -1, -1, -1}, {60515, -1, -1, -1}, {36816, -1, -1, -1}, {60519, -1, -1, -1}, {60521, -1, -1, -1}, {60522, -1, -1, -1}, {60523, -1, -1, -1}, {60524, -1, -1, -1}, {60525, -1, -1, -1}, {60526, -1, -1, -1}, {60527, -1, -1, -1}, {60528, -1, -1, -1}, {60529, -1, -1, -1}, {60530, -1, -1, -1}, {60531, -1, -1, -1}, {32415, -1, -1, -1}, {60533, -1, -1, -1}, {60534, -1, -1, -1}, {19620, -1, -1, -1}, {38215, -1, -1, -1}, {60537, -1, -1, -1}, {29090, -1, -1, -1}, {60539, -1, -1, -1}, {60542, -1, -1, -1}, {19868, -1, -1, -1}, {60544, -1, -1, -1}, {36798, -1, -1, -1}, {36794, -1, -1, -1}, {60548, -1, -1, -1}, {36793, -1, -1, -1}, {60550, -1, -1, -1}, {20202, -1, -1, -1}, {60557, -1, -1, -1}, {-1, -1, -1, -1}, {60561, -1, -1, -1}, {60563, -1, -1, -1}, {60564, -1, -1, -1}, {60566, -1, -1, -1}, {60568, -1, -1, -1}, {60570, -1, -1, -1}, {60571, -1, -1, -1}, {20122, -1, -1, -1}, {60573, -1, -1, -1}, {60576, -1, -1, -1}, {60579, -1, -1, -1}, {60580, -1, -1, -1}, {60583, -1, -1, -1}, {60584, -1, -1, -1}, {60587, -1, -1, -1}, {60589, -1, -1, -1}, {15814, -1, -1, -1}, {60596, -1, -1, -1}, {19996, -1, -1, -1}, {60601, -1, -1, -1}, {60602, -1, -1, -1}, {60603, -1, -1, -1}, {60638, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {60676, -1, -1, -1}, {60679, -1, -1, -1}, {23440, -1, -1, -1}, {60682, -1, -1, -1}, {60684, -1, -1, -1}, {60685, -1, -1, -1}, {60686, -1, -1, -1}, {60687, -1, -1, -1}, {60688, -1, -1, -1}, {60689, -1, -1, -1}, {60691, -1, -1, -1}, {60693, -1, -1, -1}, {60694, -1, -1, -1}, {60695, -1, -1, -1}, {60698, -1, -1, -1}, {60700, -1, -1, -1}, {60702, -1, -1, -1}, {60706, -1, -1, -1}, {60710, -1, -1, -1}, {60711, -1, -1, -1}, {60714, -1, -1, -1}, {60717, -1, -1, -1}, {19994, -1, -1, -1}, {19972, -1, -1, -1}, {23309, -1, -1, -1} },
    {{13996, -1, -1, -1}, {21373, -1, -1, -1}, {13989, -1, -1, -1}, {22682, -1, -1, -1}, {60733, -1, -1, -1}, {22442, -1, -1, -1}, {60737, -1, -1, -1}, {60738, -1, -1, -1}, {60741, -1, -1, -1}, {60746, -1, -1, -1}, {60747, -1, -1, -1}, {60749, -1, -1, -1}, {60750, -1, -1, -1}, {60753, -1, -1, -1}, {60755, -1, -1, -1}, {60756, -1, -1, -1}, {60759, -1, -1, -1}, {60760, -1, -1, -1}, {60785, -1, -1, -1}, {60789, -1, -1, -1}, {22439, -1, -1, -1}, {60791, -1, -1, -1}, {60794, -1, -1, -1}, {60801, -1, -1, -1}, {60806, -1, -1, -1}, {60809, -1, -1, -1}, {60810, -1, -1, -1}, {39963, -1, -1, -1}, {60838, -1, -1, -1}, {15878, -1, -1, -1}, {60881, -1, -1, -1}, {60887, -1, -1, -1}, {60891, -1, -1, -1}, {60893, -1, -1, -1}, {-1, -1, -1, -1}, {21722, -1, -1, -1}, {29050, -1, -1, -1}, {60949, -1, -1, -1}, {60955, -1, -1, -1}, {60962, -1, -1, -1}, {60976, -1, -1, -1}, {61000, -1, -1, -1}, {61014, -1, -1, -1}, {61019, -1, -1, -1}, {61024, -1, -1, -1}, {61054, -1, -1, -1}, {13877, -1, -1, -1}, {61084, -1, -1, -1}, {21024, -1, -1, -1}, {61089, -1, -1, -1}, {61090, -1, -1, -1}, {61091, -1, -1, -1}, {61092, -1, -1, -1}, {61093, -1, -1, -1}, {61094, -1, -1, -1}, {61096, -1, -1, -1}, {61097, -1, -1, -1}, {61098, -1, -1, -1}, {61100, -1, -1, -1}, {61101, -1, -1, -1}, {61102, -1, -1, -1}, {61103, -1, -1, -1}, {61104, -1, -1, -1}, {61105, -1, -1, -1}, {17762, -1, -1, -1}, {23327, -1, -1, -1}, {61108, -1, -1, -1}, {40784, -1, -1, -1}, {40614, -1, -1, -1}, {61111, -1, -1, -1}, {-1, -1, -1, -1}, {21314, -1, -1, -1}, {26285, -1, -1, -1}, {22620, -1, -1, -1}, {-1, -1, -1, -1}, {15749, -1, -1, -1}, {24928, -1, -1, -1}, {18606, -1, -1, -1}, {38845, -1, -1, -1}, {57693, -1, -1, -1}, {-1, -1, -1, -1}, {33828, -1, -1, -1}, {38932, -1, -1, -1}, {57749, -1, -1, -1}, {57764, -1, -1, -1}, {57787, -1, -1, -1}, {15147, -1, -1, -1}, {15666, -1, -1, -1}, {57857, -1, -1, -1}, {28801, -1, -1, -1}, {23708, -1, -1, -1}, {58017, -1, -1, -1}, {14128, -1, -1, -1}, {58096, -1, -1, -1}, {58097, -1, -1, -1}, {58111, -1, -1, -1}, {58112, -1, -1, -1}, {256, -1, -1, -1}, {193, -1, -1, -1}, {461, -1, -1, -1}, {192, -1, -1, -1}, {274, -1, -1, -1}, {201, -1, -1, -1}, {282, -1, -1, -1}, {200, -1, -1, -1}, {332, -1, -1, -1}, {211, -1, -1, -1}, {465, -1, -1, -1}, {210, -1, -1, -1}, {62245, -1, -1, -1}, {7870, -1, -1, -1}, {62247, -1, -1, -1}, {7872, -1, -1, -1}, {202, -1, -1, -1}, {257, -1, -1, -1}, {225, -1, -1, -1}, {462, -1, -1, -1}, {224, -1, -1, -1}, {593, -1, -1, -1}, {275, -1, -1, -1}, {233, -1, -1, -1}, {283, -1, -1, -1}, {232, -1, -1, -1}, {299, -1, -1, -1}, {237, -1, -1, -1}, {464, -1, -1, -1}, {236, -1, -1, -1}, {333, -1, -1, -1}, {243, -1, -1, -1}, {466, -1, -1, -1}, {242, -1, -1, -1}, {363, -1, -1, -1}, {250, -1, -1, -1}, {468, -1, -1, -1}, {249, -1, -1, -1}, {470, -1, -1, -1}, {472, -1, -1, -1}, {474, -1, -1, -1}, {476, -1, -1, -1}, {252, -1, -1, -1}, {62276, -1, -1, -1}, {7871, -1, -1, -1}, {62278, -1, -1, -1}, {7873, -1, -1, -1}, {234, -1, -1, -1}, {609, -1, -1, -1}, {643, -1, -1, -1}, {592, -1, -1, -1}, {603, -1, -1, -1}, {596, -1, -1, -1}, {629, -1, -1, -1}, {339, -1, -1, -1}, {248, -1, -1, -1}, {331, -1, -1, -1}, {650, -1, -1, -1}, {618, -1, -1, -1}, {62282, -1, -1, -1}, {62283, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1} },
  }
};

static const pdfi_cid_decoding_t gb1_unicode = {
  "GB1", "Unicode",
  114,
  4,
 {
    {{-1, -1, -1, -1}, {32, -1, -1, -1}, {33, -1, -1, -1}, {34, -1, -1, -1}, {35, -1, -1, -1}, {36, -1, -1, -1}, {37, -1, -1, -1}, {38, -1, -1, -1}, {39, -1, -1, -1}, {40, -1, -1, -1}, {41, -1, -1, -1}, {42, -1, -1, -1}, {43, -1, -1, -1}, {44, -1, -1, -1}, {45, -1, -1, -1}, {46, -1, -1, -1}, {47, -1, -1, -1}, {48, -1, -1, -1}, {49, -1, -1, -1}, {50, -1, -1, -1}, {51, -1, -1, -1}, {52, -1, -1, -1}, {53, -1, -1, -1}, {54, -1, -1, -1}, {55, -1, -1, -1}, {56, -1, -1, -1}, {57, -1, -1, -1}, {58, -1, -1, -1}, {59, -1, -1, -1}, {60, -1, -1, -1}, {61, -1, -1, -1}, {62, -1, -1, -1}, {63, -1, -1, -1}, {64, -1, -1, -1}, {65, -1, -1, -1}, {66, -1, -1, -1}, {67, -1, -1, -1}, {68, -1, -1, -1}, {69, -1, -1, -1}, {70, -1, -1, -1}, {71, -1, -1, -1}, {72, -1, -1, -1}, {73, -1, -1, -1}, {74, -1, -1, -1}, {75, -1, -1, -1}, {76, -1, -1, -1}, {77, -1, -1, -1}, {78, -1, -1, -1}, {79, -1, -1, -1}, {80, -1, -1, -1}, {81, -1, -1, -1}, {82, -1, -1, -1}, {83, -1, -1, -1}, {84, -1, -1, -1}, {85, -1, -1, -1}, {86, -1, -1, -1}, {87, -1, -1, -1}, {88, -1, -1, -1}, {89, -1, -1, -1}, {90, -1, -1, -1}, {91, -1, -1, -1}, {92, -1, -1, -1}, {93, -1, -1, -1}, {94, -1, -1, -1}, {95, -1, -1, -1}, {96, -1, -1, -1}, {97, -1, -1, -1}, {98, -1, -1, -1}, {99, -1, -1, -1}, {100, -1, -1, -1}, {101, -1, -1, -1}, {102, -1, -1, -1}, {103, -1, -1, -1}, {104, -1, -1, -1}, {105, -1, -1, -1}, {106, -1, -1, -1}, {107, -1, -1, -1}, {108, -1, -1, -1}, {109, -1, -1, -1}, {110, -1, -1, -1}, {111, -1, -1, -1}, {112, -1, -1, -1}, {113, -1, -1, -1}, {114, -1, -1, -1}, {115, -1, -1, -1}, {116, -1, -1, -1}, {117, -1, -1, -1}, {118, -1, -1, -1}, {119, -1, -1, -1}, {120, -1, -1, -1}, {121, -1, -1, -1}, {122, -1, -1, -1}, {123, -1, -1, -1}, {124, -1, -1, -1}, {125, -1, -1, -1}, {126, -1, -1, -1}, {12288, -1, -1, -1}, {12289, -1, -1, -1}, {12290, -1, -1, -1}, {12539, -1, -1, -1}, {713, -1, -1, -1}, {711, -1, -1, -1}, {168, -1, -1, -1}, {12291, -1, -1, -1}, {12293, -1, -1, -1}, {8212, -1, -1, -1}, {65374, -1, -1, -1}, {8214, -1, -1, -1}, {8230, 8943, -1, -1}, {8216, -1, -1, -1}, {8217, -1, -1, -1}, {8220, -1, -1, -1}, {8221, -1, -1, -1}, {12308, -1, -1, -1}, {12309, -1, -1, -1}, {12296, -1, -1, -1}, {12297, -1, -1, -1}, {12298, -1, -1, -1}, {12299, -1, -1, -1}, {12300, -1, -1, -1}, {12301, -1, -1, -1}, {12302, -1, -1, -1}, {12303, -1, -1, -1}, {12310, -1, -1, -1}, {12311, -1, -1, -1}, {12304, -1, -1, -1}, {12305, -1, -1, -1}, {177, -1, -1, -1}, {215, -1, -1, -1}, {247, -1, -1, -1}, {8758, -1, -1, -1}, {8743, -1, -1, -1}, {8744, -1, -1, -1}, {8721, -1, -1, -1}, {8719, -1, -1, -1}, {8746, -1, -1, -1}, {8745, -1, -1, -1}, {8712, -1, -1, -1}, {8759, -1, -1, -1}, {8730, -1, -1, -1}, {8869, -1, -1, -1}, {8741, -1, -1, -1}, {8736, -1, -1, -1}, {8978, -1, -1, -1}, {8857, -1, -1, -1}, {8747, -1, -1, -1}, {8750, -1, -1, -1}, {8801, -1, -1, -1}, {8780, -1, -1, -1}, {8776, -1, -1, -1}, {8765, -1, -1, -1}, {8733, -1, -1, -1}, {8800, -1, -1, -1}, {8814, -1, -1, -1}, {8815, -1, -1, -1}, {8804, -1, -1, -1}, {8805, -1, -1, -1}, {8734, -1, -1, -1}, {8757, -1, -1, -1}, {8756, -1, -1, -1}, {9794, -1, -1, -1}, {9792, -1, -1, -1}, {176, -1, -1, -1}, {8242, -1, -1, -1}, {8243, -1, -1, -1}, {8451, -1, -1, -1}, {65284, -1, -1, -1}, {164, -1, -1, -1}, {65504, -1, -1, -1}, {65505, -1, -1, -1}, {8240, -1, -1, -1}, {167, -1, -1, -1}, {8470, -1, -1, -1}, {9734, -1, -1, -1}, {9733, -1, -1, -1}, {9675, -1, -1, -1}, {9679, -1, -1, -1}, {9678, -1, -1, -1}, {9671, -1, -1, -1}, {9670, -1, -1, -1}, {9633, -1, -1, -1}, {9632, -1, -1, -1}, {9651, -1, -1, -1}, {9650, -1, -1, -1}, {8251, -1, -1, -1}, {8594, -1, -1, -1}, {8592, -1, -1, -1}, {8593, -1, -1, -1}, {8595, -1, -1, -1}, {12307, -1, -1, -1}, {9352, -1, -1, -1}, {9353, -1, -1, -1}, {9354, -1, -1, -1}, {9355, -1, -1, -1}, {9356, -1, -1, -1}, {9357, -1, -1, -1}, {9358, -1, -1, -1}, {9359, -1, -1, -1}, {9360, -1, -1, -1}, {9361, -1, -1, -1}, {9362, -1, -1, -1}, {9363, -1, -1, -1}, {9364, -1, -1, -1}, {9365, -1, -1, -1}, {9366, -1, -1, -1}, {9367, -1, -1, -1}, {9368, -1, -1, -1}, {9369, -1, -1, -1}, {9370, -1, -1, -1}, {9371, -1, -1, -1}, {9332, -1, -1, -1}, {9333, -1, -1, -1}, {9334, -1, -1, -1}, {9335, -1, -1, -1}, {9336, -1, -1, -1}, {9337, -1, -1, -1}, {9338, -1, -1, -1}, {9339, -1, -1, -1}, {9340, -1, -1, -1}, {9341, -1, -1, -1}, {9342, -1, -1, -1}, {9343, -1, -1, -1}, {9344, -1, -1, -1}, {9345, -1, -1, -1}, {9346, -1, -1, -1}, {9347, -1, -1, -1}, {9348, -1, -1, -1}, {9349, -1, -1, -1}, {9350, -1, -1, -1}, {9351, -1, -1, -1}, {9312, -1, -1, -1}, {9313, -1, -1, -1}, {9314, -1, -1, -1}, {9315, -1, -1, -1}, {9316, -1, -1, -1}, {9317, -1, -1, -1}, {9318, -1, -1, -1}, {9319, -1, -1, -1}, {9320, -1, -1, -1}, {9321, -1, -1, -1}, {12832, -1, -1, -1}, {12833, -1, -1, -1}, {12834, -1, -1, -1}, {12835, -1, -1, -1}, {12836, -1, -1, -1}, {12837, -1, -1, -1}, {12838, -1, -1, -1}, {12839, -1, -1, -1}, {12840, -1, -1, -1}, {12841, -1, -1, -1}, {8544, -1, -1, -1}, {8545, -1, -1, -1}, {8546, -1, -1, -1}, {8547, -1, -1, -1}, {8548, -1, -1, -1}, {8549, -1, -1, -1} },
    {{8550, -1, -1, -1}, {8551, -1, -1, -1}, {8552, -1, -1, -1}, {8553, -1, -1, -1}, {8554, -1, -1, -1}, {8555, -1, -1, -1}, {65281, -1, -1, -1}, {65282, -1, -1, -1}, {65283, -1, -1, -1}, {65509, -1, -1, -1}, {65285, -1, -1, -1}, {65286, -1, -1, -1}, {65287, -1, -1, -1}, {65288, -1, -1, -1}, {65289, -1, -1, -1}, {65290, -1, -1, -1}, {65291, -1, -1, -1}, {65292, -1, -1, -1}, {65293, -1, -1, -1}, {65294, -1, -1, -1}, {65295, -1, -1, -1}, {65296, -1, -1, -1}, {65297, -1, -1, -1}, {65298, -1, -1, -1}, {65299, -1, -1, -1}, {65300, -1, -1, -1}, {65301, -1, -1, -1}, {65302, -1, -1, -1}, {65303, -1, -1, -1}, {65304, -1, -1, -1}, {65305, -1, -1, -1}, {65306, -1, -1, -1}, {65307, -1, -1, -1}, {65308, -1, -1, -1}, {65309, -1, -1, -1}, {65310, -1, -1, -1}, {65311, -1, -1, -1}, {65312, -1, -1, -1}, {65313, -1, -1, -1}, {65314, -1, -1, -1}, {65315, -1, -1, -1}, {65316, -1, -1, -1}, {65317, -1, -1, -1}, {65318, -1, -1, -1}, {65319, -1, -1, -1}, {65320, -1, -1, -1}, {65321, -1, -1, -1}, {65322, -1, -1, -1}, {65323, -1, -1, -1}, {65324, -1, -1, -1}, {65325, -1, -1, -1}, {65326, -1, -1, -1}, {65327, -1, -1, -1}, {65328, -1, -1, -1}, {65329, -1, -1, -1}, {65330, -1, -1, -1}, {65331, -1, -1, -1}, {65332, -1, -1, -1}, {65333, -1, -1, -1}, {65334, -1, -1, -1}, {65335, -1, -1, -1}, {65336, -1, -1, -1}, {65337, -1, -1, -1}, {65338, -1, -1, -1}, {65339, -1, -1, -1}, {65340, -1, -1, -1}, {65341, -1, -1, -1}, {65342, -1, -1, -1}, {65343, -1, -1, -1}, {65344, -1, -1, -1}, {65345, -1, -1, -1}, {65346, -1, -1, -1}, {65347, -1, -1, -1}, {65348, -1, -1, -1}, {65349, -1, -1, -1}, {65350, -1, -1, -1}, {65351, -1, -1, -1}, {65352, -1, -1, -1}, {65353, -1, -1, -1}, {65354, -1, -1, -1}, {65355, -1, -1, -1}, {65356, -1, -1, -1}, {65357, -1, -1, -1}, {65358, -1, -1, -1}, {65359, -1, -1, -1}, {65360, -1, -1, -1}, {65361, -1, -1, -1}, {65362, -1, -1, -1}, {65363, -1, -1, -1}, {65364, -1, -1, -1}, {65365, -1, -1, -1}, {65366, -1, -1, -1}, {65367, -1, -1, -1}, {65368, -1, -1, -1}, {65369, -1, -1, -1}, {65370, -1, -1, -1}, {65371, -1, -1, -1}, {65372, -1, -1, -1}, {65373, -1, -1, -1}, {65507, -1, -1, -1}, {12353, -1, -1, -1}, {12354, -1, -1, -1}, {12355, -1, -1, -1}, {12356, -1, -1, -1}, {12357, -1, -1, -1}, {12358, -1, -1, -1}, {12359, -1, -1, -1}, {12360, -1, -1, -1}, {12361, -1, -1, -1}, {12362, -1, -1, -1}, {12363, -1, -1, -1}, {12364, -1, -1, -1}, {12365, -1, -1, -1}, {12366, -1, -1, -1}, {12367, -1, -1, -1}, {12368, -1, -1, -1}, {12369, -1, -1, -1}, {12370, -1, -1, -1}, {12371, -1, -1, -1}, {12372, -1, -1, -1}, {12373, -1, -1, -1}, {12374, -1, -1, -1}, {12375, -1, -1, -1}, {12376, -1, -1, -1}, {12377, -1, -1, -1}, {12378, -1, -1, -1}, {12379, -1, -1, -1}, {12380, -1, -1, -1}, {12381, -1, -1, -1}, {12382, -1, -1, -1}, {12383, -1, -1, -1}, {12384, -1, -1, -1}, {12385, -1, -1, -1}, {12386, -1, -1, -1}, {12387, -1, -1, -1}, {12388, -1, -1, -1}, {12389, -1, -1, -1}, {12390, -1, -1, -1}, {12391, -1, -1, -1}, {12392, -1, -1, -1}, {12393, -1, -1, -1}, {12394, -1, -1, -1}, {12395, -1, -1, -1}, {12396, -1, -1, -1}, {12397, -1, -1, -1}, {12398, -1, -1, -1}, {12399, -1, -1, -1}, {12400, -1, -1, -1}, {12401, -1, -1, -1}, {12402, -1, -1, -1}, {12403, -1, -1, -1}, {12404, -1, -1, -1}, {12405, -1, -1, -1}, {12406, -1, -1, -1}, {12407, -1, -1, -1}, {12408, -1, -1, -1}, {12409, -1, -1, -1}, {12410, -1, -1, -1}, {12411, -1, -1, -1}, {12412, -1, -1, -1}, {12413, -1, -1, -1}, {12414, -1, -1, -1}, {12415, -1, -1, -1}, {12416, -1, -1, -1}, {12417, -1, -1, -1}, {12418, -1, -1, -1}, {12419, -1, -1, -1}, {12420, -1, -1, -1}, {12421, -1, -1, -1}, {12422, -1, -1, -1}, {12423, -1, -1, -1}, {12424, -1, -1, -1}, {12425, -1, -1, -1}, {12426, -1, -1, -1}, {12427, -1, -1, -1}, {12428, -1, -1, -1}, {12429, -1, -1, -1}, {12430, -1, -1, -1}, {12431, -1, -1, -1}, {12432, -1, -1, -1}, {12433, -1, -1, -1}, {12434, -1, -1, -1}, {12435, -1, -1, -1}, {12449, -1, -1, -1}, {12450, -1, -1, -1}, {12451, -1, -1, -1}, {12452, -1, -1, -1}, {12453, -1, -1, -1}, {12454, -1, -1, -1}, {12455, -1, -1, -1}, {12456, -1, -1, -1}, {12457, -1, -1, -1}, {12458, -1, -1, -1}, {12459, -1, -1, -1}, {12460, -1, -1, -1}, {12461, -1, -1, -1}, {12462, -1, -1, -1}, {12463, -1, -1, -1}, {12464, -1, -1, -1}, {12465, -1, -1, -1}, {12466, -1, -1, -1}, {12467, -1, -1, -1}, {12468, -1, -1, -1}, {12469, -1, -1, -1}, {12470, -1, -1, -1}, {12471, -1, -1, -1}, {12472, -1, -1, -1}, {12473, -1, -1, -1}, {12474, -1, -1, -1}, {12475, -1, -1, -1}, {12476, -1, -1, -1}, {12477, -1, -1, -1}, {12478, -1, -1, -1}, {12479, -1, -1, -1}, {12480, -1, -1, -1}, {12481, -1, -1, -1}, {12482, -1, -1, -1}, {12483, -1, -1, -1}, {12484, -1, -1, -1}, {12485, -1, -1, -1}, {12486, -1, -1, -1}, {12487, -1, -1, -1}, {12488, -1, -1, -1}, {12489, -1, -1, -1}, {12490, -1, -1, -1}, {12491, -1, -1, -1}, {12492, -1, -1, -1}, {12493, -1, -1, -1}, {12494, -1, -1, -1}, {12495, -1, -1, -1}, {12496, -1, -1, -1}, {12497, -1, -1, -1}, {12498, -1, -1, -1}, {12499, -1, -1, -1}, {12500, -1, -1, -1}, {12501, -1, -1, -1}, {12502, -1, -1, -1}, {12503, -1, -1, -1}, {12504, -1, -1, -1}, {12505, -1, -1, -1}, {12506, -1, -1, -1}, {12507, -1, -1, -1}, {12508, -1, -1, -1}, {12509, -1, -1, -1}, {12510, -1, -1, -1}, {12511, -1, -1, -1}, {12512, -1, -1, -1}, {12513, -1, -1, -1}, {12514, -1, -1, -1}, {12515, -1, -1, -1}, {12516, -1, -1, -1}, {12517, -1, -1, -1}, {12518, -1, -1, -1}, {12519, -1, -1, -1}, {12520, -1, -1, -1}, {12521, -1, -1, -1} },
    {{12522, -1, -1, -1}, {12523, -1, -1, -1}, {12524, -1, -1, -1}, {12525, -1, -1, -1}, {12526, -1, -1, -1}, {12527, -1, -1, -1}, {12528, -1, -1, -1}, {12529, -1, -1, -1}, {12530, -1, -1, -1}, {12531, -1, -1, -1}, {12532, -1, -1, -1}, {12533, -1, -1, -1}, {12534, -1, -1, -1}, {913, -1, -1, -1}, {914, -1, -1, -1}, {915, -1, -1, -1}, {916, -1, -1, -1}, {917, -1, -1, -1}, {918, -1, -1, -1}, {919, -1, -1, -1}, {920, -1, -1, -1}, {921, -1, -1, -1}, {922, -1, -1, -1}, {923, -1, -1, -1}, {924, -1, -1, -1}, {925, -1, -1, -1}, {926, -1, -1, -1}, {927, -1, -1, -1}, {928, -1, -1, -1}, {929, -1, -1, -1}, {931, -1, -1, -1}, {932, -1, -1, -1}, {933, -1, -1, -1}, {934, -1, -1, -1}, {935, -1, -1, -1}, {936, -1, -1, -1}, {937, -1, -1, -1}, {945, -1, -1, -1}, {946, -1, -1, -1}, {947, -1, -1, -1}, {948, -1, -1, -1}, {949, -1, -1, -1}, {950, -1, -1, -1}, {951, -1, -1, -1}, {952, -1, -1, -1}, {953, -1, -1, -1}, {954, -1, -1, -1}, {955, -1, -1, -1}, {956, -1, -1, -1}, {957, -1, -1, -1}, {958, -1, -1, -1}, {959, -1, -1, -1}, {960, -1, -1, -1}, {961, -1, -1, -1}, {963, -1, -1, -1}, {964, -1, -1, -1}, {965, -1, -1, -1}, {966, -1, -1, -1}, {967, -1, -1, -1}, {968, -1, -1, -1}, {969, -1, -1, -1}, {65292, -1, -1, -1}, {12290, -1, -1, -1}, {12289, -1, -1, -1}, {65306, -1, -1, -1}, {65307, -1, -1, -1}, {65281, -1, -1, -1}, {65311, -1, -1, -1}, {65288, -1, -1, -1}, {65289, -1, -1, -1}, {12308, -1, -1, -1}, {12309, -1, -1, -1}, {12296, -1, -1, -1}, {12297, -1, -1, -1}, {12298, -1, -1, -1}, {12299, -1, -1, -1}, {12300, -1, -1, -1}, {12301, -1, -1, -1}, {12302, -1, -1, -1}, {12303, -1, -1, -1}, {12310, -1, -1, -1}, {12311, -1, -1, -1}, {12304, -1, -1, -1}, {12305, -1, -1, -1}, {65371, -1, -1, -1}, {65373, -1, -1, -1}, {8212, -1, -1, -1}, {8230, -1, -1, -1}, {65343, -1, -1, -1}, {-1, -1, -1, -1}, {1040, -1, -1, -1}, {1041, -1, -1, -1}, {1042, -1, -1, -1}, {1043, -1, -1, -1}, {1044, -1, -1, -1}, {1045, -1, -1, -1}, {1025, -1, -1, -1}, {1046, -1, -1, -1}, {1047, -1, -1, -1}, {1048, -1, -1, -1}, {1049, -1, -1, -1}, {1050, -1, -1, -1}, {1051, -1, -1, -1}, {1052, -1, -1, -1}, {1053, -1, -1, -1}, {1054, -1, -1, -1}, {1055, -1, -1, -1}, {1056, -1, -1, -1}, {1057, -1, -1, -1}, {1058, -1, -1, -1}, {1059, -1, -1, -1}, {1060, -1, -1, -1}, {1061, -1, -1, -1}, {1062, -1, -1, -1}, {1063, -1, -1, -1}, {1064, -1, -1, -1}, {1065, -1, -1, -1}, {1066, -1, -1, -1}, {1067, -1, -1, -1}, {1068, -1, -1, -1}, {1069, -1, -1, -1}, {1070, -1, -1, -1}, {1071, -1, -1, -1}, {1072, -1, -1, -1}, {1073, -1, -1, -1}, {1074, -1, -1, -1}, {1075, -1, -1, -1}, {1076, -1, -1, -1}, {1077, -1, -1, -1}, {1105, -1, -1, -1}, {1078, -1, -1, -1}, {1079, -1, -1, -1}, {1080, -1, -1, -1}, {1081, -1, -1, -1}, {1082, -1, -1, -1}, {1083, -1, -1, -1}, {1084, -1, -1, -1}, {1085, -1, -1, -1}, {1086, -1, -1, -1}, {1087, -1, -1, -1}, {1088, -1, -1, -1}, {1089, -1, -1, -1}, {1090, -1, -1, -1}, {1091, -1, -1, -1}, {1092, -1, -1, -1}, {1093, -1, -1, -1}, {1094, -1, -1, -1}, {1095, -1, -1, -1}, {1096, -1, -1, -1}, {1097, -1, -1, -1}, {1098, -1, -1, -1}, {1099, -1, -1, -1}, {1100, -1, -1, -1}, {1101, -1, -1, -1}, {1102, -1, -1, -1}, {1103, -1, -1, -1}, {257, -1, -1, -1}, {225, -1, -1, -1}, {462, -1, -1, -1}, {224, -1, -1, -1}, {275, -1, -1, -1}, {233, -1, -1, -1}, {283, -1, -1, -1}, {232, -1, -1, -1}, {299, -1, -1, -1}, {237, -1, -1, -1}, {464, -1, -1, -1}, {236, -1, -1, -1}, {333, -1, -1, -1}, {243, -1, -1, -1}, {466, -1, -1, -1}, {242, -1, -1, -1}, {363, -1, -1, -1}, {250, -1, -1, -1}, {468, -1, -1, -1}, {249, -1, -1, -1}, {470, -1, -1, -1}, {472, -1, -1, -1}, {474, -1, -1, -1}, {476, -1, -1, -1}, {252, -1, -1, -1}, {234, -1, -1, -1}, {-1, -1, -1, -1}, {7743, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {505, -1, -1, -1}, {-1, -1, -1, -1}, {12549, -1, -1, -1}, {12550, -1, -1, -1}, {12551, -1, -1, -1}, {12552, -1, -1, -1}, {12553, -1, -1, -1}, {12554, -1, -1, -1}, {12555, -1, -1, -1}, {12556, -1, -1, -1}, {12557, -1, -1, -1}, {12558, -1, -1, -1}, {12559, -1, -1, -1}, {12560, -1, -1, -1}, {12561, -1, -1, -1}, {12562, -1, -1, -1}, {12563, -1, -1, -1}, {12564, -1, -1, -1}, {12565, -1, -1, -1}, {12566, -1, -1, -1}, {12567, -1, -1, -1}, {12568, -1, -1, -1}, {12569, -1, -1, -1}, {12570, -1, -1, -1}, {12571, -1, -1, -1}, {12572, -1, -1, -1}, {12573, -1, -1, -1}, {12574, -1, -1, -1}, {12575, -1, -1, -1}, {12576, -1, -1, -1}, {12577, -1, -1, -1}, {12578, -1, -1, -1}, {12579, -1, -1, -1}, {12580, -1, -1, -1}, {12581, -1, -1, -1}, {12582, -1, -1, -1}, {12583, -1, -1, -1}, {12584, -1, -1, -1}, {12585, -1, -1, -1}, {-1, -1, -1, -1}, {9472, -1, -1, -1}, {9473, -1, -1, -1}, {9474, -1, -1, -1}, {9475, -1, -1, -1}, {9476, -1, -1, -1}, {9477, -1, -1, -1}, {9478, -1, -1, -1}, {9479, -1, -1, -1}, {9480, -1, -1, -1}, {9481, -1, -1, -1}, {9482, -1, -1, -1}, {9483, -1, -1, -1}, {9484, -1, -1, -1}, {9485, -1, -1, -1}, {9486, -1, -1, -1}, {9487, -1, -1, -1}, {9488, -1, -1, -1}, {9489, -1, -1, -1}, {9490, -1, -1, -1}, {9491, -1, -1, -1}, {9492, -1, -1, -1}, {9493, -1, -1, -1}, {9494, -1, -1, -1}, {9495, -1, -1, -1}, {9496, -1, -1, -1}, {9497, -1, -1, -1}, {9498, -1, -1, -1}, {9499, -1, -1, -1}, {9500, -1, -1, -1}, {9501, -1, -1, -1} },
    {{9502, -1, -1, -1}, {9503, -1, -1, -1}, {9504, -1, -1, -1}, {9505, -1, -1, -1}, {9506, -1, -1, -1}, {9507, -1, -1, -1}, {9508, -1, -1, -1}, {9509, -1, -1, -1}, {9510, -1, -1, -1}, {9511, -1, -1, -1}, {9512, -1, -1, -1}, {9513, -1, -1, -1}, {9514, -1, -1, -1}, {9515, -1, -1, -1}, {9516, -1, -1, -1}, {9517, -1, -1, -1}, {9518, -1, -1, -1}, {9519, -1, -1, -1}, {9520, -1, -1, -1}, {9521, -1, -1, -1}, {9522, -1, -1, -1}, {9523, -1, -1, -1}, {9524, -1, -1, -1}, {9525, -1, -1, -1}, {9526, -1, -1, -1}, {9527, -1, -1, -1}, {9528, -1, -1, -1}, {9529, -1, -1, -1}, {9530, -1, -1, -1}, {9531, -1, -1, -1}, {9532, -1, -1, -1}, {9533, -1, -1, -1}, {9534, -1, -1, -1}, {9535, -1, -1, -1}, {9536, -1, -1, -1}, {9537, -1, -1, -1}, {9538, -1, -1, -1}, {9539, -1, -1, -1}, {9540, -1, -1, -1}, {9541, -1, -1, -1}, {9542, -1, -1, -1}, {9543, -1, -1, -1}, {9544, -1, -1, -1}, {9545, -1, -1, -1}, {9546, -1, -1, -1}, {9547, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {21834, -1, -1, -1}, {38463, -1, -1, -1}, {22467, -1, -1, -1}, {25384, -1, -1, -1}, {21710, -1, -1, -1}, {21769, -1, -1, -1}, {21696, -1, -1, -1}, {30353, -1, -1, -1}, {30284, -1, -1, -1}, {34108, -1, -1, -1}, {30702, -1, -1, -1}, {33406, -1, -1, -1}, {30861, -1, -1, -1}, {29233, -1, -1, -1}, {38552, -1, -1, -1}, {38797, -1, -1, -1}, {27688, -1, -1, -1}, {23433, -1, -1, -1}, {20474, -1, -1, -1}, {25353, -1, -1, -1}, {26263, -1, -1, -1}, {23736, -1, -1, -1}, {33018, -1, -1, -1}, {26696, -1, -1, -1}, {32942, -1, -1, -1}, {26114, -1, -1, -1}, {30414, -1, -1, -1}, {20985, -1, -1, -1}, {25942, -1, -1, -1}, {29100, -1, -1, -1}, {32753, -1, -1, -1}, {34948, -1, -1, -1}, {20658, -1, -1, -1}, {22885, -1, -1, -1}, {25034, -1, -1, -1}, {28595, -1, -1, -1}, {33453, -1, -1, -1}, {25420, -1, -1, -1}, {25170, -1, -1, -1}, {21485, -1, -1, -1}, {21543, -1, -1, -1}, {31494, -1, -1, -1}, {12043, 20843, -1, -1}, {30116, -1, -1, -1}, {24052, -1, -1, -1}, {25300, -1, -1, -1}, {36299, -1, -1, -1}, {38774, -1, -1, -1}, {25226, -1, -1, -1}, {32793, -1, -1, -1}, {22365, -1, -1, -1}, {38712, -1, -1, -1}, {32610, -1, -1, -1}, {29240, -1, -1, -1}, {12137, 30333, -1, -1}, {26575, -1, -1, -1}, {30334, -1, -1, -1}, {25670, -1, -1, -1}, {20336, -1, -1, -1}, {36133, -1, -1, -1}, {25308, -1, -1, -1}, {31255, -1, -1, -1}, {26001, -1, -1, -1}, {29677, -1, -1, -1}, {25644, -1, -1, -1}, {25203, -1, -1, -1}, {33324, -1, -1, -1}, {39041, -1, -1, -1}, {26495, -1, -1, -1}, {29256, -1, -1, -1}, {25198, -1, -1, -1}, {25292, -1, -1, -1}, {20276, -1, -1, -1}, {29923, -1, -1, -1}, {21322, -1, -1, -1}, {21150, -1, -1, -1}, {32458, -1, -1, -1}, {37030, -1, -1, -1}, {24110, -1, -1, -1}, {26758, -1, -1, -1}, {27036, -1, -1, -1}, {33152, -1, -1, -1}, {32465, -1, -1, -1}, {26834, -1, -1, -1} },
    {{30917, -1, -1, -1}, {34444, -1, -1, -1}, {38225, -1, -1, -1}, {20621, -1, -1, -1}, {35876, -1, -1, -1}, {33502, -1, -1, -1}, {32990, -1, -1, -1}, {21253, -1, -1, -1}, {35090, -1, -1, -1}, {21093, -1, -1, -1}, {34180, -1, -1, -1}, {38649, -1, -1, -1}, {20445, -1, -1, -1}, {22561, -1, -1, -1}, {39281, -1, -1, -1}, {23453, -1, -1, -1}, {25265, -1, -1, -1}, {25253, -1, -1, -1}, {26292, -1, -1, -1}, {35961, -1, -1, -1}, {40077, -1, -1, -1}, {29190, -1, -1, -1}, {26479, -1, -1, -1}, {30865, -1, -1, -1}, {24754, -1, -1, -1}, {21329, -1, -1, -1}, {21271, -1, -1, -1}, {36744, -1, -1, -1}, {32972, -1, -1, -1}, {36125, -1, -1, -1}, {38049, -1, -1, -1}, {20493, -1, -1, -1}, {29384, -1, -1, -1}, {22791, -1, -1, -1}, {24811, -1, -1, -1}, {28953, -1, -1, -1}, {34987, -1, -1, -1}, {22868, -1, -1, -1}, {33519, -1, -1, -1}, {26412, -1, -1, -1}, {31528, -1, -1, -1}, {23849, -1, -1, -1}, {32503, -1, -1, -1}, {29997, -1, -1, -1}, {27893, -1, -1, -1}, {36454, -1, -1, -1}, {36856, -1, -1, -1}, {36924, -1, -1, -1}, {12240, 40763, -1, -1}, {12112, 27604, -1, -1}, {37145, -1, -1, -1}, {31508, -1, -1, -1}, {24444, -1, -1, -1}, {30887, -1, -1, -1}, {34006, -1, -1, -1}, {34109, -1, -1, -1}, {27605, -1, -1, -1}, {27609, -1, -1, -1}, {27606, -1, -1, -1}, {24065, -1, -1, -1}, {24199, -1, -1, -1}, {30201, -1, -1, -1}, {38381, -1, -1, -1}, {25949, -1, -1, -1}, {24330, -1, -1, -1}, {24517, -1, -1, -1}, {36767, -1, -1, -1}, {22721, -1, -1, -1}, {33218, -1, -1, -1}, {36991, -1, -1, -1}, {38491, -1, -1, -1}, {38829, -1, -1, -1}, {36793, -1, -1, -1}, {32534, -1, -1, -1}, {36140, -1, -1, -1}, {25153, -1, -1, -1}, {20415, -1, -1, -1}, {21464, -1, -1, -1}, {21342, -1, -1, -1}, {36776, -1, -1, -1}, {36777, -1, -1, -1}, {36779, -1, -1, -1}, {36941, -1, -1, -1}, {26631, -1, -1, -1}, {24426, -1, -1, -1}, {33176, -1, -1, -1}, {34920, -1, -1, -1}, {40150, -1, -1, -1}, {24971, -1, -1, -1}, {21035, -1, -1, -1}, {30250, -1, -1, -1}, {24428, -1, -1, -1}, {25996, -1, -1, -1}, {28626, -1, -1, -1}, {28392, -1, -1, -1}, {23486, -1, -1, -1}, {25672, -1, -1, -1}, {20853, -1, -1, -1}, {20912, -1, -1, -1}, {26564, -1, -1, -1}, {19993, -1, -1, -1}, {31177, -1, -1, -1}, {39292, -1, -1, -1}, {28851, -1, -1, -1}, {30149, -1, -1, -1}, {24182, -1, -1, -1}, {29627, -1, -1, -1}, {33760, -1, -1, -1}, {25773, -1, -1, -1}, {25320, -1, -1, -1}, {38069, -1, -1, -1}, {27874, -1, -1, -1}, {21338, -1, -1, -1}, {21187, -1, -1, -1}, {25615, -1, -1, -1}, {38082, -1, -1, -1}, {31636, -1, -1, -1}, {20271, -1, -1, -1}, {24091, -1, -1, -1}, {33334, -1, -1, -1}, {33046, -1, -1, -1}, {33162, -1, -1, -1}, {28196, -1, -1, -1}, {27850, -1, -1, -1}, {39539, -1, -1, -1}, {25429, -1, -1, -1}, {12056, 21340, -1, -1}, {21754, -1, -1, -1}, {34917, -1, -1, -1}, {22496, -1, -1, -1}, {19981, -1, -1, -1}, {24067, -1, -1, -1}, {27493, -1, -1, -1}, {31807, -1, -1, -1}, {37096, -1, -1, -1}, {24598, -1, -1, -1}, {25830, -1, -1, -1}, {29468, -1, -1, -1}, {35009, -1, -1, -1}, {26448, -1, -1, -1}, {25165, -1, -1, -1}, {36130, -1, -1, -1}, {30572, -1, -1, -1}, {36393, -1, -1, -1}, {37319, -1, -1, -1}, {24425, -1, -1, -1}, {33756, -1, -1, -1}, {34081, -1, -1, -1}, {39184, -1, -1, -1}, {21442, -1, -1, -1}, {34453, -1, -1, -1}, {27531, -1, -1, -1}, {24813, -1, -1, -1}, {24808, -1, -1, -1}, {28799, -1, -1, -1}, {33485, -1, -1, -1}, {33329, -1, -1, -1}, {20179, -1, -1, -1}, {27815, -1, -1, -1}, {34255, -1, -1, -1}, {25805, -1, -1, -1}, {31961, -1, -1, -1}, {27133, -1, -1, -1}, {26361, -1, -1, -1}, {33609, -1, -1, -1}, {21397, -1, -1, -1}, {31574, -1, -1, -1}, {20391, -1, -1, -1}, {20876, -1, -1, -1}, {27979, -1, -1, -1}, {23618, -1, -1, -1}, {36461, -1, -1, -1}, {25554, -1, -1, -1}, {21449, -1, -1, -1}, {33580, -1, -1, -1}, {33590, -1, -1, -1}, {26597, -1, -1, -1}, {30900, -1, -1, -1}, {25661, -1, -1, -1}, {23519, -1, -1, -1}, {23700, -1, -1, -1}, {24046, -1, -1, -1}, {35815, -1, -1, -1}, {25286, -1, -1, -1}, {26612, -1, -1, -1}, {35962, -1, -1, -1}, {25600, -1, -1, -1}, {25530, -1, -1, -1}, {34633, -1, -1, -1}, {39307, -1, -1, -1}, {35863, -1, -1, -1}, {32544, -1, -1, -1}, {38130, -1, -1, -1}, {20135, -1, -1, -1}, {38416, -1, -1, -1}, {39076, -1, -1, -1}, {26124, -1, -1, -1}, {29462, -1, -1, -1}, {22330, -1, -1, -1}, {23581, -1, -1, -1}, {24120, -1, -1, -1}, {38271, -1, -1, -1}, {20607, -1, -1, -1}, {32928, -1, -1, -1}, {12058, 21378, -1, -1}, {25950, -1, -1, -1}, {30021, -1, -1, -1}, {21809, -1, -1, -1}, {20513, -1, -1, -1}, {36229, -1, -1, -1}, {25220, -1, -1, -1}, {38046, -1, -1, -1}, {26397, -1, -1, -1}, {22066, -1, -1, -1}, {28526, -1, -1, -1}, {24034, -1, -1, -1}, {21557, -1, -1, -1}, {28818, -1, -1, -1}, {36710, -1, -1, -1}, {25199, -1, -1, -1}, {25764, -1, -1, -1}, {25507, -1, -1, -1}, {24443, -1, -1, -1}, {28552, -1, -1, -1}, {37108, -1, -1, -1}, {12162, 33251, -1, -1}, {12192, 36784, -1, -1}, {23576, -1, -1, -1}, {26216, -1, -1, -1}, {24561, -1, -1, -1}, {27785, -1, -1, -1}, {38472, -1, -1, -1}, {36225, -1, -1, -1}, {34924, -1, -1, -1}, {25745, -1, -1, -1}, {31216, -1, -1, -1}, {22478, -1, -1, -1}, {27225, -1, -1, -1}, {25104, -1, -1, -1}, {21576, -1, -1, -1}, {20056, -1, -1, -1}, {31243, -1, -1, -1}, {24809, -1, -1, -1}, {28548, -1, -1, -1}, {35802, -1, -1, -1}, {25215, -1, -1, -1}, {36894, -1, -1, -1}, {39563, -1, -1, -1}, {31204, -1, -1, -1}, {21507, -1, -1, -1}, {30196, -1, -1, -1}, {25345, -1, -1, -1}, {21273, -1, -1, -1}, {27744, -1, -1, -1}, {36831, -1, -1, -1}, {24347, -1, -1, -1} },
    {{39536, -1, -1, -1}, {32827, -1, -1, -1}, {40831, -1, -1, -1}, {20360, -1, -1, -1}, {23610, -1, -1, -1}, {12186, 36196, -1, -1}, {32709, -1, -1, -1}, {26021, -1, -1, -1}, {28861, -1, -1, -1}, {20805, -1, -1, -1}, {20914, -1, -1, -1}, {12173, 34411, -1, -1}, {23815, -1, -1, -1}, {23456, -1, -1, -1}, {25277, -1, -1, -1}, {37228, -1, -1, -1}, {30068, -1, -1, -1}, {36364, -1, -1, -1}, {31264, -1, -1, -1}, {24833, -1, -1, -1}, {31609, -1, -1, -1}, {20167, -1, -1, -1}, {32504, -1, -1, -1}, {30597, -1, -1, -1}, {19985, -1, -1, -1}, {33261, -1, -1, -1}, {21021, -1, -1, -1}, {20986, -1, -1, -1}, {27249, -1, -1, -1}, {21416, -1, -1, -1}, {36487, -1, -1, -1}, {38148, -1, -1, -1}, {38607, -1, -1, -1}, {28353, -1, -1, -1}, {38500, -1, -1, -1}, {26970, -1, -1, -1}, {30784, -1, -1, -1}, {20648, -1, -1, -1}, {30679, -1, -1, -1}, {25616, -1, -1, -1}, {35302, -1, -1, -1}, {22788, -1, -1, -1}, {25571, -1, -1, -1}, {24029, -1, -1, -1}, {31359, -1, -1, -1}, {26941, -1, -1, -1}, {20256, -1, -1, -1}, {33337, -1, -1, -1}, {21912, -1, -1, -1}, {20018, -1, -1, -1}, {30126, -1, -1, -1}, {31383, -1, -1, -1}, {24162, -1, -1, -1}, {24202, -1, -1, -1}, {38383, -1, -1, -1}, {21019, -1, -1, -1}, {21561, -1, -1, -1}, {28810, -1, -1, -1}, {25462, -1, -1, -1}, {38180, -1, -1, -1}, {22402, -1, -1, -1}, {26149, -1, -1, -1}, {26943, -1, -1, -1}, {37255, -1, -1, -1}, {21767, -1, -1, -1}, {28147, -1, -1, -1}, {32431, -1, -1, -1}, {34850, -1, -1, -1}, {25139, -1, -1, -1}, {32496, -1, -1, -1}, {30133, -1, -1, -1}, {33576, -1, -1, -1}, {30913, -1, -1, -1}, {38604, -1, -1, -1}, {36766, -1, -1, -1}, {24904, -1, -1, -1}, {29943, -1, -1, -1}, {35789, -1, -1, -1}, {27492, -1, -1, -1}, {21050, -1, -1, -1}, {36176, -1, -1, -1}, {27425, -1, -1, -1}, {32874, -1, -1, -1}, {33905, -1, -1, -1}, {22257, -1, -1, -1}, {21254, -1, -1, -1}, {20174, -1, -1, -1}, {19995, -1, -1, -1}, {20945, -1, -1, -1}, {31895, -1, -1, -1}, {37259, -1, -1, -1}, {31751, -1, -1, -1}, {20419, -1, -1, -1}, {36479, -1, -1, -1}, {31713, -1, -1, -1}, {31388, -1, -1, -1}, {25703, -1, -1, -1}, {23828, -1, -1, -1}, {20652, -1, -1, -1}, {33030, -1, -1, -1}, {30209, -1, -1, -1}, {31929, -1, -1, -1}, {28140, -1, -1, -1}, {32736, -1, -1, -1}, {26449, -1, -1, -1}, {23384, -1, -1, -1}, {12072, 23544, -1, -1}, {30923, -1, -1, -1}, {25774, -1, -1, -1}, {25619, -1, -1, -1}, {25514, -1, -1, -1}, {25387, -1, -1, -1}, {38169, -1, -1, -1}, {25645, -1, -1, -1}, {36798, -1, -1, -1}, {31572, -1, -1, -1}, {30249, -1, -1, -1}, {25171, -1, -1, -1}, {12068, 22823, -1, -1}, {21574, -1, -1, -1}, {12109, 27513, -1, -1}, {20643, -1, -1, -1}, {25140, -1, -1, -1}, {24102, -1, -1, -1}, {27526, -1, -1, -1}, {20195, -1, -1, -1}, {36151, -1, -1, -1}, {34955, -1, -1, -1}, {24453, -1, -1, -1}, {36910, -1, -1, -1}, {24608, -1, -1, -1}, {32829, -1, -1, -1}, {25285, -1, -1, -1}, {20025, -1, -1, -1}, {21333, -1, -1, -1}, {37112, -1, -1, -1}, {25528, -1, -1, -1}, {32966, -1, -1, -1}, {26086, -1, -1, -1}, {27694, -1, -1, -1}, {20294, -1, -1, -1}, {24814, -1, -1, -1}, {28129, -1, -1, -1}, {35806, -1, -1, -1}, {24377, -1, -1, -1}, {34507, -1, -1, -1}, {24403, -1, -1, -1}, {25377, -1, -1, -1}, {20826, -1, -1, -1}, {33633, -1, -1, -1}, {26723, -1, -1, -1}, {12049, 20992, -1, -1}, {25443, -1, -1, -1}, {36424, -1, -1, -1}, {20498, -1, -1, -1}, {23707, -1, -1, -1}, {31095, -1, -1, -1}, {23548, -1, -1, -1}, {21040, -1, -1, -1}, {31291, -1, -1, -1}, {24764, -1, -1, -1}, {36947, -1, -1, -1}, {30423, -1, -1, -1}, {24503, -1, -1, -1}, {24471, -1, -1, -1}, {30340, -1, -1, -1}, {36460, -1, -1, -1}, {28783, -1, -1, -1}, {30331, -1, -1, -1}, {31561, -1, -1, -1}, {30634, -1, -1, -1}, {20979, -1, -1, -1}, {37011, -1, -1, -1}, {22564, -1, -1, -1}, {20302, -1, -1, -1}, {28404, -1, -1, -1}, {36842, -1, -1, -1}, {25932, -1, -1, -1}, {31515, -1, -1, -1}, {29380, -1, -1, -1}, {28068, -1, -1, -1}, {32735, -1, -1, -1}, {23265, -1, -1, -1}, {25269, -1, -1, -1}, {24213, -1, -1, -1}, {22320, -1, -1, -1}, {33922, -1, -1, -1}, {31532, -1, -1, -1}, {24093, -1, -1, -1}, {24351, -1, -1, -1}, {36882, -1, -1, -1}, {32532, -1, -1, -1}, {39072, -1, -1, -1}, {25474, -1, -1, -1}, {28359, -1, -1, -1}, {30872, -1, -1, -1}, {28857, -1, -1, -1}, {20856, -1, -1, -1}, {38747, -1, -1, -1}, {22443, -1, -1, -1}, {30005, -1, -1, -1}, {20291, -1, -1, -1}, {30008, -1, -1, -1}, {24215, -1, -1, -1}, {24806, -1, -1, -1}, {22880, -1, -1, -1}, {28096, -1, -1, -1}, {27583, -1, -1, -1}, {30857, -1, -1, -1}, {21500, -1, -1, -1}, {38613, -1, -1, -1}, {20939, -1, -1, -1}, {20993, -1, -1, -1}, {25481, -1, -1, -1}, {21514, -1, -1, -1}, {38035, -1, -1, -1}, {35843, -1, -1, -1}, {36300, -1, -1, -1}, {29241, -1, -1, -1}, {30879, -1, -1, -1}, {34678, -1, -1, -1}, {36845, -1, -1, -1}, {35853, -1, -1, -1}, {21472, -1, -1, -1}, {19969, -1, -1, -1}, {30447, -1, -1, -1}, {21486, -1, -1, -1}, {38025, -1, -1, -1}, {39030, -1, -1, -1}, {12237, 40718, -1, -1}, {38189, -1, -1, -1}, {23450, -1, -1, -1}, {35746, -1, -1, -1}, {20002, -1, -1, -1}, {19996, -1, -1, -1}, {20908, -1, -1, -1}, {33891, -1, -1, -1}, {25026, -1, -1, -1}, {21160, -1, -1, -1}, {26635, -1, -1, -1}, {20375, -1, -1, -1}, {24683, -1, -1, -1}, {20923, -1, -1, -1}, {27934, -1, -1, -1}, {20828, -1, -1, -1}, {25238, -1, -1, -1}, {12099, 26007, -1, -1}, {38497, -1, -1, -1}, {12182, 35910, -1, -1}, {36887, -1, -1, -1}, {30168, -1, -1, -1}, {37117, -1, -1, -1}, {30563, -1, -1, -1}, {27602, -1, -1, -1}, {29322, -1, -1, -1}, {29420, -1, -1, -1} },
    {{35835, -1, -1, -1}, {22581, -1, -1, -1}, {30585, -1, -1, -1}, {36172, -1, -1, -1}, {26460, -1, -1, -1}, {38208, -1, -1, -1}, {32922, -1, -1, -1}, {24230, -1, -1, -1}, {28193, -1, -1, -1}, {22930, -1, -1, -1}, {31471, -1, -1, -1}, {30701, -1, -1, -1}, {38203, -1, -1, -1}, {27573, -1, -1, -1}, {26029, -1, -1, -1}, {32526, -1, -1, -1}, {22534, -1, -1, -1}, {20817, -1, -1, -1}, {38431, -1, -1, -1}, {23545, -1, -1, -1}, {22697, -1, -1, -1}, {21544, -1, -1, -1}, {36466, -1, -1, -1}, {25958, -1, -1, -1}, {39039, -1, -1, -1}, {22244, -1, -1, -1}, {38045, -1, -1, -1}, {30462, -1, -1, -1}, {36929, -1, -1, -1}, {25479, -1, -1, -1}, {21702, -1, -1, -1}, {22810, -1, -1, -1}, {22842, -1, -1, -1}, {22427, -1, -1, -1}, {36530, -1, -1, -1}, {26421, -1, -1, -1}, {36346, -1, -1, -1}, {33333, -1, -1, -1}, {21057, -1, -1, -1}, {24816, -1, -1, -1}, {22549, -1, -1, -1}, {34558, -1, -1, -1}, {23784, -1, -1, -1}, {40517, -1, -1, -1}, {20420, -1, -1, -1}, {39069, -1, -1, -1}, {35769, -1, -1, -1}, {23077, -1, -1, -1}, {24694, -1, -1, -1}, {21380, -1, -1, -1}, {25212, -1, -1, -1}, {36943, -1, -1, -1}, {37122, -1, -1, -1}, {39295, -1, -1, -1}, {24681, -1, -1, -1}, {12157, 32780, -1, -1}, {12041, 20799, -1, -1}, {12159, 32819, -1, -1}, {23572, -1, -1, -1}, {39285, -1, -1, -1}, {27953, -1, -1, -1}, {12038, 20108, -1, -1}, {36144, -1, -1, -1}, {21457, -1, -1, -1}, {32602, -1, -1, -1}, {31567, -1, -1, -1}, {20240, -1, -1, -1}, {20047, -1, -1, -1}, {38400, -1, -1, -1}, {27861, -1, -1, -1}, {29648, -1, -1, -1}, {34281, -1, -1, -1}, {24070, -1, -1, -1}, {30058, -1, -1, -1}, {32763, -1, -1, -1}, {27146, -1, -1, -1}, {30718, -1, -1, -1}, {38034, -1, -1, -1}, {32321, -1, -1, -1}, {20961, -1, -1, -1}, {28902, -1, -1, -1}, {21453, -1, -1, -1}, {36820, -1, -1, -1}, {33539, -1, -1, -1}, {36137, -1, -1, -1}, {29359, -1, -1, -1}, {39277, -1, -1, -1}, {27867, -1, -1, -1}, {22346, -1, -1, -1}, {33459, -1, -1, -1}, {12101, 26041, -1, -1}, {32938, -1, -1, -1}, {25151, -1, -1, -1}, {38450, -1, -1, -1}, {22952, -1, -1, -1}, {20223, -1, -1, -1}, {35775, -1, -1, -1}, {32442, -1, -1, -1}, {25918, -1, -1, -1}, {33778, -1, -1, -1}, {12206, 38750, -1, -1}, {21857, -1, -1, -1}, {39134, -1, -1, -1}, {32933, -1, -1, -1}, {21290, -1, -1, -1}, {35837, -1, -1, -1}, {21536, -1, -1, -1}, {32954, -1, -1, -1}, {24223, -1, -1, -1}, {27832, -1, -1, -1}, {36153, -1, -1, -1}, {33452, -1, -1, -1}, {37210, -1, -1, -1}, {21545, -1, -1, -1}, {27675, -1, -1, -1}, {20998, -1, -1, -1}, {32439, -1, -1, -1}, {22367, -1, -1, -1}, {28954, -1, -1, -1}, {27774, -1, -1, -1}, {31881, -1, -1, -1}, {22859, -1, -1, -1}, {20221, -1, -1, -1}, {24575, -1, -1, -1}, {24868, -1, -1, -1}, {31914, -1, -1, -1}, {20016, -1, -1, -1}, {23553, -1, -1, -1}, {26539, -1, -1, -1}, {34562, -1, -1, -1}, {23792, -1, -1, -1}, {38155, -1, -1, -1}, {39118, -1, -1, -1}, {30127, -1, -1, -1}, {28925, -1, -1, -1}, {36898, -1, -1, -1}, {20911, -1, -1, -1}, {32541, -1, -1, -1}, {35773, -1, -1, -1}, {22857, -1, -1, -1}, {20964, -1, -1, -1}, {20315, -1, -1, -1}, {21542, -1, -1, -1}, {22827, -1, -1, -1}, {25975, -1, -1, -1}, {32932, -1, -1, -1}, {23413, -1, -1, -1}, {25206, -1, -1, -1}, {25282, -1, -1, -1}, {36752, -1, -1, -1}, {24133, -1, -1, -1}, {27679, -1, -1, -1}, {31526, -1, -1, -1}, {20239, -1, -1, -1}, {20440, -1, -1, -1}, {26381, -1, -1, -1}, {28014, -1, -1, -1}, {28074, -1, -1, -1}, {31119, -1, -1, -1}, {34993, -1, -1, -1}, {24343, -1, -1, -1}, {29995, -1, -1, -1}, {25242, -1, -1, -1}, {36741, -1, -1, -1}, {20463, -1, -1, -1}, {37340, -1, -1, -1}, {26023, -1, -1, -1}, {33071, -1, -1, -1}, {33105, -1, -1, -1}, {24220, -1, -1, -1}, {33104, -1, -1, -1}, {36212, -1, -1, -1}, {21103, -1, -1, -1}, {35206, -1, -1, -1}, {36171, -1, -1, -1}, {22797, -1, -1, -1}, {20613, -1, -1, -1}, {20184, -1, -1, -1}, {12201, 38428, -1, -1}, {12119, 29238, -1, -1}, {33145, -1, -1, -1}, {36127, -1, -1, -1}, {23500, -1, -1, -1}, {35747, -1, -1, -1}, {38468, -1, -1, -1}, {22919, -1, -1, -1}, {32538, -1, -1, -1}, {21648, -1, -1, -1}, {22134, -1, -1, -1}, {22030, -1, -1, -1}, {35813, -1, -1, -1}, {25913, -1, -1, -1}, {27010, -1, -1, -1}, {38041, -1, -1, -1}, {30422, -1, -1, -1}, {28297, -1, -1, -1}, {12082, 24178, -1, -1}, {12130, 29976, -1, -1}, {26438, -1, -1, -1}, {26577, -1, -1, -1}, {31487, -1, -1, -1}, {32925, -1, -1, -1}, {36214, -1, -1, -1}, {24863, -1, -1, -1}, {31174, -1, -1, -1}, {25954, -1, -1, -1}, {36195, -1, -1, -1}, {20872, -1, -1, -1}, {21018, -1, -1, -1}, {38050, -1, -1, -1}, {32568, -1, -1, -1}, {32923, -1, -1, -1}, {32434, -1, -1, -1}, {23703, -1, -1, -1}, {28207, -1, -1, -1}, {26464, -1, -1, -1}, {31705, -1, -1, -1}, {30347, -1, -1, -1}, {12220, 39640, -1, -1}, {33167, -1, -1, -1}, {32660, -1, -1, -1}, {31957, -1, -1, -1}, {25630, -1, -1, -1}, {38224, -1, -1, -1}, {31295, -1, -1, -1}, {21578, -1, -1, -1}, {21733, -1, -1, -1}, {27468, -1, -1, -1}, {25601, -1, -1, -1}, {12093, 25096, -1, -1}, {40509, -1, -1, -1}, {33011, -1, -1, -1}, {30105, -1, -1, -1}, {21106, -1, -1, -1}, {12208, 38761, -1, -1}, {33883, -1, -1, -1}, {26684, -1, -1, -1}, {34532, -1, -1, -1}, {38401, -1, -1, -1}, {38548, -1, -1, -1}, {38124, -1, -1, -1}, {20010, -1, -1, -1}, {21508, -1, -1, -1}, {32473, -1, -1, -1}, {26681, -1, -1, -1}, {36319, -1, -1, -1}, {32789, -1, -1, -1}, {26356, -1, -1, -1}, {24218, -1, -1, -1}, {32697, -1, -1, -1}, {22466, -1, -1, -1}, {32831, -1, -1, -1}, {26775, -1, -1, -1}, {12079, 24037, -1, -1}, {25915, -1, -1, -1}, {21151, -1, -1, -1} },
    {{24685, -1, -1, -1}, {40858, -1, -1, -1}, {20379, -1, -1, -1}, {36524, -1, -1, -1}, {20844, -1, -1, -1}, {23467, -1, -1, -1}, {12088, 24339, -1, -1}, {24041, -1, -1, -1}, {27742, -1, -1, -1}, {25329, -1, -1, -1}, {36129, -1, -1, -1}, {20849, -1, -1, -1}, {38057, -1, -1, -1}, {21246, -1, -1, -1}, {27807, -1, -1, -1}, {33503, -1, -1, -1}, {29399, -1, -1, -1}, {22434, -1, -1, -1}, {26500, -1, -1, -1}, {36141, -1, -1, -1}, {22815, -1, -1, -1}, {36764, -1, -1, -1}, {33735, -1, -1, -1}, {21653, -1, -1, -1}, {31629, -1, -1, -1}, {20272, -1, -1, -1}, {27837, -1, -1, -1}, {23396, -1, -1, -1}, {22993, -1, -1, -1}, {12238, 40723, -1, -1}, {21476, -1, -1, -1}, {34506, -1, -1, -1}, {12219, 39592, -1, -1}, {12181, 35895, -1, -1}, {32929, -1, -1, -1}, {25925, -1, -1, -1}, {39038, -1, -1, -1}, {22266, -1, -1, -1}, {38599, -1, -1, -1}, {21038, -1, -1, -1}, {12128, 29916, -1, -1}, {21072, -1, -1, -1}, {23521, -1, -1, -1}, {25346, -1, -1, -1}, {35074, -1, -1, -1}, {20054, -1, -1, -1}, {25296, -1, -1, -1}, {24618, -1, -1, -1}, {26874, -1, -1, -1}, {20851, -1, -1, -1}, {23448, -1, -1, -1}, {20896, -1, -1, -1}, {35266, -1, -1, -1}, {31649, -1, -1, -1}, {39302, -1, -1, -1}, {32592, -1, -1, -1}, {24815, -1, -1, -1}, {28748, -1, -1, -1}, {36143, -1, -1, -1}, {20809, -1, -1, -1}, {12084, 24191, -1, -1}, {36891, -1, -1, -1}, {29808, -1, -1, -1}, {35268, -1, -1, -1}, {22317, -1, -1, -1}, {30789, -1, -1, -1}, {24402, -1, -1, -1}, {40863, -1, -1, -1}, {38394, -1, -1, -1}, {36712, -1, -1, -1}, {12225, 39740, -1, -1}, {35809, -1, -1, -1}, {30328, -1, -1, -1}, {26690, -1, -1, -1}, {26588, -1, -1, -1}, {36330, -1, -1, -1}, {36149, -1, -1, -1}, {21053, -1, -1, -1}, {36746, -1, -1, -1}, {28378, -1, -1, -1}, {26829, -1, -1, -1}, {38149, -1, -1, -1}, {37101, -1, -1, -1}, {22269, -1, -1, -1}, {26524, -1, -1, -1}, {35065, -1, -1, -1}, {36807, -1, -1, -1}, {21704, -1, -1, -1}, {39608, -1, -1, -1}, {23401, -1, -1, -1}, {28023, -1, -1, -1}, {27686, -1, -1, -1}, {20133, -1, -1, -1}, {23475, -1, -1, -1}, {39559, -1, -1, -1}, {37219, -1, -1, -1}, {25000, -1, -1, -1}, {37039, -1, -1, -1}, {38889, -1, -1, -1}, {21547, -1, -1, -1}, {28085, -1, -1, -1}, {23506, -1, -1, -1}, {20989, -1, -1, -1}, {21898, -1, -1, -1}, {32597, -1, -1, -1}, {32752, -1, -1, -1}, {25788, -1, -1, -1}, {25421, -1, -1, -1}, {26097, -1, -1, -1}, {25022, -1, -1, -1}, {24717, -1, -1, -1}, {28938, -1, -1, -1}, {27735, -1, -1, -1}, {27721, -1, -1, -1}, {22831, -1, -1, -1}, {26477, -1, -1, -1}, {33322, -1, -1, -1}, {22741, -1, -1, -1}, {22158, -1, -1, -1}, {35946, -1, -1, -1}, {27627, -1, -1, -1}, {37085, -1, -1, -1}, {22909, -1, -1, -1}, {32791, -1, -1, -1}, {21495, -1, -1, -1}, {28009, -1, -1, -1}, {21621, -1, -1, -1}, {21917, -1, -1, -1}, {33655, -1, -1, -1}, {33743, -1, -1, -1}, {26680, -1, -1, -1}, {12146, 31166, -1, -1}, {21644, -1, -1, -1}, {20309, -1, -1, -1}, {21512, -1, -1, -1}, {30418, -1, -1, -1}, {35977, -1, -1, -1}, {38402, -1, -1, -1}, {27827, -1, -1, -1}, {28088, -1, -1, -1}, {36203, -1, -1, -1}, {35088, -1, -1, -1}, {40548, -1, -1, -1}, {36154, -1, -1, -1}, {22079, -1, -1, -1}, {12234, 40657, -1, -1}, {30165, -1, -1, -1}, {24456, -1, -1, -1}, {29408, -1, -1, -1}, {24680, -1, -1, -1}, {21756, -1, -1, -1}, {20136, -1, -1, -1}, {27178, -1, -1, -1}, {34913, -1, -1, -1}, {24658, -1, -1, -1}, {36720, -1, -1, -1}, {21700, -1, -1, -1}, {28888, -1, -1, -1}, {34425, -1, -1, -1}, {40511, -1, -1, -1}, {27946, -1, -1, -1}, {23439, -1, -1, -1}, {24344, -1, -1, -1}, {32418, -1, -1, -1}, {21897, -1, -1, -1}, {20399, -1, -1, -1}, {29492, -1, -1, -1}, {21564, -1, -1, -1}, {21402, -1, -1, -1}, {20505, -1, -1, -1}, {21518, -1, -1, -1}, {21628, -1, -1, -1}, {20046, -1, -1, -1}, {24573, -1, -1, -1}, {29786, -1, -1, -1}, {22774, -1, -1, -1}, {33899, -1, -1, -1}, {32993, -1, -1, -1}, {34676, -1, -1, -1}, {29392, -1, -1, -1}, {31946, -1, -1, -1}, {28246, -1, -1, -1}, {24359, -1, -1, -1}, {34382, -1, -1, -1}, {21804, -1, -1, -1}, {25252, -1, -1, -1}, {20114, -1, -1, -1}, {27818, -1, -1, -1}, {25143, -1, -1, -1}, {33457, -1, -1, -1}, {21719, -1, -1, -1}, {21326, -1, -1, -1}, {29502, -1, -1, -1}, {28369, -1, -1, -1}, {30011, -1, -1, -1}, {21010, -1, -1, -1}, {21270, -1, -1, -1}, {35805, -1, -1, -1}, {27088, -1, -1, -1}, {24458, -1, -1, -1}, {24576, -1, -1, -1}, {28142, -1, -1, -1}, {22351, -1, -1, -1}, {27426, -1, -1, -1}, {29615, -1, -1, -1}, {26707, -1, -1, -1}, {36824, -1, -1, -1}, {32531, -1, -1, -1}, {25442, -1, -1, -1}, {24739, -1, -1, -1}, {21796, -1, -1, -1}, {30186, -1, -1, -1}, {35938, -1, -1, -1}, {28949, -1, -1, -1}, {28067, -1, -1, -1}, {23462, -1, -1, -1}, {24187, -1, -1, -1}, {33618, -1, -1, -1}, {24908, -1, -1, -1}, {40644, -1, -1, -1}, {30970, -1, -1, -1}, {34647, -1, -1, -1}, {31783, -1, -1, -1}, {30343, -1, -1, -1}, {20976, -1, -1, -1}, {24822, -1, -1, -1}, {29004, -1, -1, -1}, {26179, -1, -1, -1}, {24140, -1, -1, -1}, {24653, -1, -1, -1}, {35854, -1, -1, -1}, {28784, -1, -1, -1}, {25381, -1, -1, -1}, {36745, -1, -1, -1}, {24509, -1, -1, -1}, {24674, -1, -1, -1}, {34516, -1, -1, -1}, {22238, -1, -1, -1}, {27585, -1, -1, -1}, {24724, -1, -1, -1}, {24935, -1, -1, -1}, {21321, -1, -1, -1}, {24800, -1, -1, -1}, {26214, -1, -1, -1}, {36159, -1, -1, -1}, {31229, -1, -1, -1}, {20250, -1, -1, -1}, {28905, -1, -1, -1}, {27719, -1, -1, -1}, {35763, -1, -1, -1}, {35826, -1, -1, -1}, {32472, -1, -1, -1}, {33636, -1, -1, -1}, {26127, -1, -1, -1}, {23130, -1, -1, -1}, {39746, -1, -1, -1} },
    {{27985, -1, -1, -1}, {28151, -1, -1, -1}, {35905, -1, -1, -1}, {27963, -1, -1, -1}, {20249, -1, -1, -1}, {12117, 28779, -1, -1}, {33719, -1, -1, -1}, {25110, -1, -1, -1}, {24785, -1, -1, -1}, {38669, -1, -1, -1}, {36135, -1, -1, -1}, {31096, -1, -1, -1}, {20987, -1, -1, -1}, {22334, -1, -1, -1}, {22522, -1, -1, -1}, {26426, -1, -1, -1}, {30072, -1, -1, -1}, {31293, -1, -1, -1}, {31215, -1, -1, -1}, {31637, -1, -1, -1}, {32908, -1, -1, -1}, {39269, -1, -1, -1}, {36857, -1, -1, -1}, {28608, -1, -1, -1}, {35749, -1, -1, -1}, {40481, -1, -1, -1}, {23020, -1, -1, -1}, {32489, -1, -1, -1}, {32521, -1, -1, -1}, {21513, -1, -1, -1}, {26497, -1, -1, -1}, {26840, -1, -1, -1}, {36753, -1, -1, -1}, {31821, -1, -1, -1}, {38598, -1, -1, -1}, {21450, -1, -1, -1}, {24613, -1, -1, -1}, {30142, -1, -1, -1}, {27762, -1, -1, -1}, {21363, -1, -1, -1}, {23241, -1, -1, -1}, {32423, -1, -1, -1}, {25380, -1, -1, -1}, {12047, 20960, -1, -1}, {33034, -1, -1, -1}, {12080, 24049, -1, -1}, {34015, -1, -1, -1}, {25216, -1, -1, -1}, {20864, -1, -1, -1}, {23395, -1, -1, -1}, {20238, -1, -1, -1}, {31085, -1, -1, -1}, {21058, -1, -1, -1}, {24760, -1, -1, -1}, {27982, -1, -1, -1}, {23492, -1, -1, -1}, {23490, -1, -1, -1}, {35745, -1, -1, -1}, {35760, -1, -1, -1}, {26082, -1, -1, -1}, {24524, -1, -1, -1}, {38469, -1, -1, -1}, {22931, -1, -1, -1}, {32487, -1, -1, -1}, {32426, -1, -1, -1}, {22025, -1, -1, -1}, {26551, -1, -1, -1}, {22841, -1, -1, -1}, {20339, -1, -1, -1}, {23478, -1, -1, -1}, {21152, -1, -1, -1}, {33626, -1, -1, -1}, {39050, -1, -1, -1}, {36158, -1, -1, -1}, {30002, -1, -1, -1}, {38078, -1, -1, -1}, {20551, -1, -1, -1}, {31292, -1, -1, -1}, {20215, -1, -1, -1}, {26550, -1, -1, -1}, {39550, -1, -1, -1}, {23233, -1, -1, -1}, {27516, -1, -1, -1}, {30417, -1, -1, -1}, {22362, -1, -1, -1}, {23574, -1, -1, -1}, {31546, -1, -1, -1}, {38388, -1, -1, -1}, {29006, -1, -1, -1}, {20860, -1, -1, -1}, {32937, -1, -1, -1}, {33392, -1, -1, -1}, {22904, -1, -1, -1}, {32516, -1, -1, -1}, {33575, -1, -1, -1}, {26816, -1, -1, -1}, {26604, -1, -1, -1}, {30897, -1, -1, -1}, {30839, -1, -1, -1}, {25315, -1, -1, -1}, {25441, -1, -1, -1}, {31616, -1, -1, -1}, {20461, -1, -1, -1}, {21098, -1, -1, -1}, {20943, -1, -1, -1}, {33616, -1, -1, -1}, {27099, -1, -1, -1}, {37492, -1, -1, -1}, {36341, -1, -1, -1}, {36145, -1, -1, -1}, {35265, -1, -1, -1}, {38190, -1, -1, -1}, {31661, -1, -1, -1}, {20214, -1, -1, -1}, {20581, -1, -1, -1}, {33328, -1, -1, -1}, {21073, -1, -1, -1}, {39279, -1, -1, -1}, {28176, -1, -1, -1}, {28293, -1, -1, -1}, {28071, -1, -1, -1}, {24314, -1, -1, -1}, {20725, -1, -1, -1}, {23004, -1, -1, -1}, {23558, -1, -1, -1}, {27974, -1, -1, -1}, {27743, -1, -1, -1}, {30086, -1, -1, -1}, {33931, -1, -1, -1}, {26728, -1, -1, -1}, {22870, -1, -1, -1}, {35762, -1, -1, -1}, {21280, -1, -1, -1}, {37233, -1, -1, -1}, {38477, -1, -1, -1}, {34121, -1, -1, -1}, {26898, -1, -1, -1}, {30977, -1, -1, -1}, {28966, -1, -1, -1}, {33014, -1, -1, -1}, {20132, -1, -1, -1}, {37066, -1, -1, -1}, {27975, -1, -1, -1}, {39556, -1, -1, -1}, {23047, -1, -1, -1}, {22204, -1, -1, -1}, {25605, -1, -1, -1}, {38128, -1, -1, -1}, {30699, -1, -1, -1}, {20389, -1, -1, -1}, {33050, -1, -1, -1}, {29409, -1, -1, -1}, {12179, 35282, -1, -1}, {39290, -1, -1, -1}, {32564, -1, -1, -1}, {32478, -1, -1, -1}, {21119, -1, -1, -1}, {25945, -1, -1, -1}, {37237, -1, -1, -1}, {36735, -1, -1, -1}, {36739, -1, -1, -1}, {21483, -1, -1, -1}, {31382, -1, -1, -1}, {25581, -1, -1, -1}, {25509, -1, -1, -1}, {30342, -1, -1, -1}, {31224, -1, -1, -1}, {34903, -1, -1, -1}, {38454, -1, -1, -1}, {25130, -1, -1, -1}, {21163, -1, -1, -1}, {33410, -1, -1, -1}, {26708, -1, -1, -1}, {26480, -1, -1, -1}, {25463, -1, -1, -1}, {30571, -1, -1, -1}, {31469, -1, -1, -1}, {27905, -1, -1, -1}, {32467, -1, -1, -1}, {35299, -1, -1, -1}, {22992, -1, -1, -1}, {25106, -1, -1, -1}, {34249, -1, -1, -1}, {33445, -1, -1, -1}, {30028, -1, -1, -1}, {20511, -1, -1, -1}, {20171, -1, -1, -1}, {30117, -1, -1, -1}, {35819, -1, -1, -1}, {23626, -1, -1, -1}, {12081, 24062, -1, -1}, {31563, -1, -1, -1}, {12100, 26020, -1, -1}, {12198, 37329, -1, -1}, {20170, -1, -1, -1}, {27941, -1, -1, -1}, {35167, -1, -1, -1}, {32039, -1, -1, -1}, {38182, -1, -1, -1}, {20165, -1, -1, -1}, {35880, -1, -1, -1}, {36827, -1, -1, -1}, {38771, -1, -1, -1}, {26187, -1, -1, -1}, {31105, -1, -1, -1}, {36817, -1, -1, -1}, {28908, -1, -1, -1}, {28024, -1, -1, -1}, {23613, -1, -1, -1}, {21170, -1, -1, -1}, {33606, -1, -1, -1}, {20834, -1, -1, -1}, {33550, -1, -1, -1}, {30555, -1, -1, -1}, {26230, -1, -1, -1}, {40120, -1, -1, -1}, {20140, -1, -1, -1}, {24778, -1, -1, -1}, {31934, -1, -1, -1}, {31923, -1, -1, -1}, {32463, -1, -1, -1}, {20117, -1, -1, -1}, {35686, -1, -1, -1}, {26223, -1, -1, -1}, {39048, -1, -1, -1}, {38745, -1, -1, -1}, {22659, -1, -1, -1}, {25964, -1, -1, -1}, {38236, -1, -1, -1}, {24452, -1, -1, -1}, {30153, -1, -1, -1}, {38742, -1, -1, -1}, {31455, -1, -1, -1}, {31454, -1, -1, -1}, {20928, -1, -1, -1}, {28847, -1, -1, -1}, {31384, -1, -1, -1}, {25578, -1, -1, -1}, {31350, -1, -1, -1}, {32416, -1, -1, -1}, {29590, -1, -1, -1}, {12210, 38893, -1, -1}, {20037, -1, -1, -1}, {28792, -1, -1, -1}, {20061, -1, -1, -1}, {37202, -1, -1, -1}, {21417, -1, -1, -1}, {25937, -1, -1, -1}, {26087, -1, -1, -1}, {12165, 33276, -1, -1}, {33285, -1, -1, -1}, {21646, -1, -1, -1}, {23601, -1, -1, -1}, {30106, -1, -1, -1}, {38816, -1, -1, -1}, {25304, -1, -1, -1} },
    {{29401, -1, -1, -1}, {30141, -1, -1, -1}, {23621, -1, -1, -1}, {39545, -1, -1, -1}, {33738, -1, -1, -1}, {23616, -1, -1, -1}, {21632, -1, -1, -1}, {30697, -1, -1, -1}, {20030, -1, -1, -1}, {27822, -1, -1, -1}, {32858, -1, -1, -1}, {25298, -1, -1, -1}, {25454, -1, -1, -1}, {24040, -1, -1, -1}, {20855, -1, -1, -1}, {36317, -1, -1, -1}, {36382, -1, -1, -1}, {38191, -1, -1, -1}, {20465, -1, -1, -1}, {21477, -1, -1, -1}, {24807, -1, -1, -1}, {28844, -1, -1, -1}, {21095, -1, -1, -1}, {25424, -1, -1, -1}, {40515, -1, -1, -1}, {23071, -1, -1, -1}, {20518, -1, -1, -1}, {30519, -1, -1, -1}, {21367, -1, -1, -1}, {32482, -1, -1, -1}, {25733, -1, -1, -1}, {25899, -1, -1, -1}, {25225, -1, -1, -1}, {25496, -1, -1, -1}, {20500, -1, -1, -1}, {29237, -1, -1, -1}, {35273, -1, -1, -1}, {20915, -1, -1, -1}, {35776, -1, -1, -1}, {32477, -1, -1, -1}, {22343, -1, -1, -1}, {33740, -1, -1, -1}, {38055, -1, -1, -1}, {20891, -1, -1, -1}, {21531, -1, -1, -1}, {23803, -1, -1, -1}, {20426, -1, -1, -1}, {31459, -1, -1, -1}, {27994, -1, -1, -1}, {37089, -1, -1, -1}, {39567, -1, -1, -1}, {21888, -1, -1, -1}, {21654, -1, -1, -1}, {21345, -1, -1, -1}, {21679, -1, -1, -1}, {24320, -1, -1, -1}, {25577, -1, -1, -1}, {26999, -1, -1, -1}, {20975, -1, -1, -1}, {24936, -1, -1, -1}, {21002, -1, -1, -1}, {22570, -1, -1, -1}, {21208, -1, -1, -1}, {22350, -1, -1, -1}, {30733, -1, -1, -1}, {30475, -1, -1, -1}, {24247, -1, -1, -1}, {24951, -1, -1, -1}, {31968, -1, -1, -1}, {25179, -1, -1, -1}, {25239, -1, -1, -1}, {20130, -1, -1, -1}, {28821, -1, -1, -1}, {32771, -1, -1, -1}, {25335, -1, -1, -1}, {28900, -1, -1, -1}, {38752, -1, -1, -1}, {22391, -1, -1, -1}, {33499, -1, -1, -1}, {26607, -1, -1, -1}, {26869, -1, -1, -1}, {30933, -1, -1, -1}, {39063, -1, -1, -1}, {31185, -1, -1, -1}, {22771, -1, -1, -1}, {21683, -1, -1, -1}, {21487, -1, -1, -1}, {28212, -1, -1, -1}, {20811, -1, -1, -1}, {21051, -1, -1, -1}, {23458, -1, -1, -1}, {35838, -1, -1, -1}, {32943, -1, -1, -1}, {21827, -1, -1, -1}, {22438, -1, -1, -1}, {24691, -1, -1, -1}, {22353, -1, -1, -1}, {21549, -1, -1, -1}, {31354, -1, -1, -1}, {24656, -1, -1, -1}, {23380, -1, -1, -1}, {25511, -1, -1, -1}, {25248, -1, -1, -1}, {12061, 21475, -1, -1}, {25187, -1, -1, -1}, {23495, -1, -1, -1}, {26543, -1, -1, -1}, {21741, -1, -1, -1}, {31391, -1, -1, -1}, {33510, -1, -1, -1}, {37239, -1, -1, -1}, {24211, -1, -1, -1}, {35044, -1, -1, -1}, {22840, -1, -1, -1}, {22446, -1, -1, -1}, {25358, -1, -1, -1}, {36328, -1, -1, -1}, {33007, -1, -1, -1}, {22359, -1, -1, -1}, {31607, -1, -1, -1}, {20393, -1, -1, -1}, {24555, -1, -1, -1}, {23485, -1, -1, -1}, {27454, -1, -1, -1}, {21281, -1, -1, -1}, {31568, -1, -1, -1}, {29378, -1, -1, -1}, {26694, -1, -1, -1}, {30719, -1, -1, -1}, {30518, -1, -1, -1}, {26103, -1, -1, -1}, {20917, -1, -1, -1}, {20111, -1, -1, -1}, {30420, -1, -1, -1}, {23743, -1, -1, -1}, {31397, -1, -1, -1}, {33909, -1, -1, -1}, {22862, -1, -1, -1}, {39745, -1, -1, -1}, {20608, -1, -1, -1}, {39304, -1, -1, -1}, {24871, -1, -1, -1}, {28291, -1, -1, -1}, {22372, -1, -1, -1}, {26118, -1, -1, -1}, {25414, -1, -1, -1}, {22256, -1, -1, -1}, {25324, -1, -1, -1}, {25193, -1, -1, -1}, {24275, -1, -1, -1}, {38420, -1, -1, -1}, {22403, -1, -1, -1}, {25289, -1, -1, -1}, {21895, -1, -1, -1}, {34593, -1, -1, -1}, {33098, -1, -1, -1}, {36771, -1, -1, -1}, {21862, -1, -1, -1}, {33713, -1, -1, -1}, {26469, -1, -1, -1}, {36182, -1, -1, -1}, {34013, -1, -1, -1}, {23146, -1, -1, -1}, {26639, -1, -1, -1}, {25318, -1, -1, -1}, {31726, -1, -1, -1}, {38417, -1, -1, -1}, {20848, -1, -1, -1}, {28572, -1, -1, -1}, {35888, -1, -1, -1}, {25597, -1, -1, -1}, {35272, -1, -1, -1}, {25042, -1, -1, -1}, {32518, -1, -1, -1}, {28866, -1, -1, -1}, {28389, -1, -1, -1}, {29701, -1, -1, -1}, {27028, -1, -1, -1}, {29436, -1, -1, -1}, {24266, -1, -1, -1}, {37070, -1, -1, -1}, {26391, -1, -1, -1}, {28010, -1, -1, -1}, {25438, -1, -1, -1}, {21171, -1, -1, -1}, {29282, -1, -1, -1}, {12156, 32769, -1, -1}, {20332, -1, -1, -1}, {23013, -1, -1, -1}, {37226, -1, -1, -1}, {28889, -1, -1, -1}, {28061, -1, -1, -1}, {21202, -1, -1, -1}, {20048, -1, -1, -1}, {38647, -1, -1, -1}, {38253, -1, -1, -1}, {34174, -1, -1, -1}, {30922, -1, -1, -1}, {32047, -1, -1, -1}, {20769, -1, -1, -1}, {22418, -1, -1, -1}, {25794, -1, -1, -1}, {32907, -1, -1, -1}, {31867, -1, -1, -1}, {27882, -1, -1, -1}, {26865, -1, -1, -1}, {26974, -1, -1, -1}, {20919, -1, -1, -1}, {21400, -1, -1, -1}, {26792, -1, -1, -1}, {29313, -1, -1, -1}, {40654, -1, -1, -1}, {31729, -1, -1, -1}, {29432, -1, -1, -1}, {31163, -1, -1, -1}, {28435, -1, -1, -1}, {29702, -1, -1, -1}, {26446, -1, -1, -1}, {12197, 37324, -1, -1}, {40100, -1, -1, -1}, {31036, -1, -1, -1}, {33673, -1, -1, -1}, {33620, -1, -1, -1}, {21519, -1, -1, -1}, {26647, -1, -1, -1}, {20029, -1, -1, -1}, {21385, -1, -1, -1}, {21169, -1, -1, -1}, {30782, -1, -1, -1}, {21382, -1, -1, -1}, {21033, -1, -1, -1}, {20616, -1, -1, -1}, {20363, -1, -1, -1}, {20432, -1, -1, -1}, {30178, -1, -1, -1}, {12148, 31435, -1, -1}, {31890, -1, -1, -1}, {27813, -1, -1, -1}, {12202, 38582, -1, -1}, {12050, 21147, -1, -1}, {29827, -1, -1, -1}, {21737, -1, -1, -1}, {20457, -1, -1, -1}, {32852, -1, -1, -1}, {33714, -1, -1, -1}, {36830, -1, -1, -1}, {38256, -1, -1, -1}, {24265, -1, -1, -1}, {24604, -1, -1, -1}, {28063, -1, -1, -1}, {24088, -1, -1, -1}, {25947, -1, -1, -1}, {33080, -1, -1, -1}, {38142, -1, -1, -1}, {24651, -1, -1, -1}, {28860, -1, -1, -1} },
    {{32451, -1, -1, -1}, {31918, -1, -1, -1}, {20937, -1, -1, -1}, {26753, -1, -1, -1}, {31921, -1, -1, -1}, {33391, -1, -1, -1}, {20004, -1, -1, -1}, {36742, -1, -1, -1}, {37327, -1, -1, -1}, {26238, -1, -1, -1}, {20142, -1, -1, -1}, {35845, -1, -1, -1}, {25769, -1, -1, -1}, {32842, -1, -1, -1}, {20698, -1, -1, -1}, {30103, -1, -1, -1}, {29134, -1, -1, -1}, {23525, -1, -1, -1}, {36797, -1, -1, -1}, {28518, -1, -1, -1}, {20102, -1, -1, -1}, {25730, -1, -1, -1}, {38243, -1, -1, -1}, {24278, -1, -1, -1}, {26009, -1, -1, -1}, {21015, -1, -1, -1}, {35010, -1, -1, -1}, {28872, -1, -1, -1}, {21155, -1, -1, -1}, {29454, -1, -1, -1}, {29747, -1, -1, -1}, {26519, -1, -1, -1}, {30967, -1, -1, -1}, {38678, -1, -1, -1}, {20020, -1, -1, -1}, {37051, -1, -1, -1}, {40158, -1, -1, -1}, {28107, -1, -1, -1}, {20955, -1, -1, -1}, {36161, -1, -1, -1}, {21533, -1, -1, -1}, {25294, -1, -1, -1}, {29618, -1, -1, -1}, {33777, -1, -1, -1}, {38646, -1, -1, -1}, {40836, -1, -1, -1}, {38083, -1, -1, -1}, {20278, -1, -1, -1}, {32666, -1, -1, -1}, {20940, -1, -1, -1}, {28789, -1, -1, -1}, {38517, -1, -1, -1}, {23725, -1, -1, -1}, {39046, -1, -1, -1}, {21478, -1, -1, -1}, {20196, -1, -1, -1}, {28316, -1, -1, -1}, {29705, -1, -1, -1}, {27060, -1, -1, -1}, {30827, -1, -1, -1}, {39311, -1, -1, -1}, {30041, -1, -1, -1}, {21016, -1, -1, -1}, {30244, -1, -1, -1}, {27969, -1, -1, -1}, {26611, -1, -1, -1}, {20845, -1, -1, -1}, {40857, -1, -1, -1}, {32843, -1, -1, -1}, {21657, -1, -1, -1}, {31548, -1, -1, -1}, {31423, -1, -1, -1}, {38534, -1, -1, -1}, {22404, -1, -1, -1}, {25314, -1, -1, -1}, {38471, -1, -1, -1}, {27004, -1, -1, -1}, {23044, -1, -1, -1}, {25602, -1, -1, -1}, {31699, -1, -1, -1}, {28431, -1, -1, -1}, {38475, -1, -1, -1}, {33446, -1, -1, -1}, {21346, -1, -1, -1}, {39045, -1, -1, -1}, {24208, -1, -1, -1}, {28809, -1, -1, -1}, {25523, -1, -1, -1}, {21348, -1, -1, -1}, {34383, -1, -1, -1}, {40065, -1, -1, -1}, {40595, -1, -1, -1}, {30860, -1, -1, -1}, {38706, -1, -1, -1}, {36335, -1, -1, -1}, {36162, -1, -1, -1}, {12229, 40575, -1, -1}, {28510, -1, -1, -1}, {31108, -1, -1, -1}, {24405, -1, -1, -1}, {38470, -1, -1, -1}, {25134, -1, -1, -1}, {39540, -1, -1, -1}, {21525, -1, -1, -1}, {38109, -1, -1, -1}, {20387, -1, -1, -1}, {26053, -1, -1, -1}, {23653, -1, -1, -1}, {23649, -1, -1, -1}, {32533, -1, -1, -1}, {34385, -1, -1, -1}, {27695, -1, -1, -1}, {24459, -1, -1, -1}, {29575, -1, -1, -1}, {28388, -1, -1, -1}, {32511, -1, -1, -1}, {23782, -1, -1, -1}, {25371, -1, -1, -1}, {23402, -1, -1, -1}, {28390, -1, -1, -1}, {21365, -1, -1, -1}, {20081, -1, -1, -1}, {25504, -1, -1, -1}, {30053, -1, -1, -1}, {25249, -1, -1, -1}, {36718, -1, -1, -1}, {20262, -1, -1, -1}, {20177, -1, -1, -1}, {27814, -1, -1, -1}, {32438, -1, -1, -1}, {35770, -1, -1, -1}, {33821, -1, -1, -1}, {34746, -1, -1, -1}, {32599, -1, -1, -1}, {36923, -1, -1, -1}, {38179, -1, -1, -1}, {31657, -1, -1, -1}, {39585, -1, -1, -1}, {35064, -1, -1, -1}, {33853, -1, -1, -1}, {27931, -1, -1, -1}, {39558, -1, -1, -1}, {32476, -1, -1, -1}, {22920, -1, -1, -1}, {12231, 40635, -1, -1}, {29595, -1, -1, -1}, {30721, -1, -1, -1}, {34434, -1, -1, -1}, {39532, -1, -1, -1}, {39554, -1, -1, -1}, {22043, -1, -1, -1}, {21527, -1, -1, -1}, {22475, -1, -1, -1}, {20080, -1, -1, -1}, {40614, -1, -1, -1}, {21334, -1, -1, -1}, {36808, -1, -1, -1}, {33033, -1, -1, -1}, {30610, -1, -1, -1}, {39314, -1, -1, -1}, {34542, -1, -1, -1}, {28385, -1, -1, -1}, {34067, -1, -1, -1}, {26364, -1, -1, -1}, {24930, -1, -1, -1}, {28459, -1, -1, -1}, {35881, -1, -1, -1}, {33426, -1, -1, -1}, {33579, -1, -1, -1}, {30450, -1, -1, -1}, {27667, -1, -1, -1}, {24537, -1, -1, -1}, {33725, -1, -1, -1}, {29483, -1, -1, -1}, {33541, -1, -1, -1}, {38170, -1, -1, -1}, {12113, 27611, -1, -1}, {12141, 30683, -1, -1}, {38086, -1, -1, -1}, {21359, -1, -1, -1}, {33538, -1, -1, -1}, {20882, -1, -1, -1}, {24125, -1, -1, -1}, {35980, -1, -1, -1}, {36152, -1, -1, -1}, {20040, -1, -1, -1}, {29611, -1, -1, -1}, {26522, -1, -1, -1}, {26757, -1, -1, -1}, {37238, -1, -1, -1}, {38665, -1, -1, -1}, {29028, -1, -1, -1}, {27809, -1, -1, -1}, {30473, -1, -1, -1}, {23186, -1, -1, -1}, {38209, -1, -1, -1}, {27599, -1, -1, -1}, {32654, -1, -1, -1}, {26151, -1, -1, -1}, {23504, -1, -1, -1}, {22969, -1, -1, -1}, {23194, -1, -1, -1}, {38376, -1, -1, -1}, {38391, -1, -1, -1}, {20204, -1, -1, -1}, {33804, -1, -1, -1}, {33945, -1, -1, -1}, {27308, -1, -1, -1}, {30431, -1, -1, -1}, {38192, -1, -1, -1}, {29467, -1, -1, -1}, {26790, -1, -1, -1}, {23391, -1, -1, -1}, {30511, -1, -1, -1}, {37274, -1, -1, -1}, {38753, -1, -1, -1}, {31964, -1, -1, -1}, {36855, -1, -1, -1}, {35868, -1, -1, -1}, {24357, -1, -1, -1}, {12150, 31859, -1, -1}, {31192, -1, -1, -1}, {35269, -1, -1, -1}, {27852, -1, -1, -1}, {34588, -1, -1, -1}, {23494, -1, -1, -1}, {24130, -1, -1, -1}, {26825, -1, -1, -1}, {30496, -1, -1, -1}, {32501, -1, -1, -1}, {20885, -1, -1, -1}, {20813, -1, -1, -1}, {21193, -1, -1, -1}, {23081, -1, -1, -1}, {32517, -1, -1, -1}, {12207, 38754, -1, -1}, {33495, -1, -1, -1}, {25551, -1, -1, -1}, {30596, -1, -1, -1}, {34256, -1, -1, -1}, {31186, -1, -1, -1}, {28218, -1, -1, -1}, {24217, -1, -1, -1}, {22937, -1, -1, -1}, {34065, -1, -1, -1}, {28781, -1, -1, -1}, {27665, -1, -1, -1}, {25279, -1, -1, -1}, {12139, 30399, -1, -1}, {25935, -1, -1, -1}, {24751, -1, -1, -1}, {38397, -1, -1, -1}, {26126, -1, -1, -1}, {34719, -1, -1, -1}, {40483, -1, -1, -1}, {38125, -1, -1, -1} },
    {{21517, -1, -1, -1}, {21629, -1, -1, -1}, {35884, -1, -1, -1}, {25720, -1, -1, -1}, {25721, -1, -1, -1}, {34321, -1, -1, -1}, {27169, -1, -1, -1}, {33180, -1, -1, -1}, {30952, -1, -1, -1}, {25705, -1, -1, -1}, {39764, -1, -1, -1}, {25273, -1, -1, -1}, {26411, -1, -1, -1}, {33707, -1, -1, -1}, {22696, -1, -1, -1}, {40664, -1, -1, -1}, {27819, -1, -1, -1}, {28448, -1, -1, -1}, {23518, -1, -1, -1}, {38476, -1, -1, -1}, {35851, -1, -1, -1}, {29279, -1, -1, -1}, {26576, -1, -1, -1}, {25287, -1, -1, -1}, {29281, -1, -1, -1}, {20137, -1, -1, -1}, {22982, -1, -1, -1}, {27597, -1, -1, -1}, {22675, -1, -1, -1}, {26286, -1, -1, -1}, {24149, -1, -1, -1}, {21215, -1, -1, -1}, {24917, -1, -1, -1}, {12106, 26408, -1, -1}, {12140, 30446, -1, -1}, {30566, -1, -1, -1}, {29287, -1, -1, -1}, {31302, -1, -1, -1}, {25343, -1, -1, -1}, {21738, -1, -1, -1}, {21584, -1, -1, -1}, {38048, -1, -1, -1}, {37027, -1, -1, -1}, {23068, -1, -1, -1}, {32435, -1, -1, -1}, {27670, -1, -1, -1}, {20035, -1, -1, -1}, {22902, -1, -1, -1}, {32784, -1, -1, -1}, {22856, -1, -1, -1}, {21335, -1, -1, -1}, {30007, -1, -1, -1}, {38590, -1, -1, -1}, {22218, -1, -1, -1}, {25376, -1, -1, -1}, {33041, -1, -1, -1}, {24700, -1, -1, -1}, {38393, -1, -1, -1}, {28118, -1, -1, -1}, {21602, -1, -1, -1}, {39297, -1, -1, -1}, {20869, -1, -1, -1}, {23273, -1, -1, -1}, {33021, -1, -1, -1}, {22958, -1, -1, -1}, {38675, -1, -1, -1}, {20522, -1, -1, -1}, {27877, -1, -1, -1}, {23612, -1, -1, -1}, {25311, -1, -1, -1}, {20320, -1, -1, -1}, {21311, -1, -1, -1}, {33147, -1, -1, -1}, {36870, -1, -1, -1}, {28346, -1, -1, -1}, {34091, -1, -1, -1}, {25288, -1, -1, -1}, {24180, -1, -1, -1}, {30910, -1, -1, -1}, {25781, -1, -1, -1}, {25467, -1, -1, -1}, {24565, -1, -1, -1}, {23064, -1, -1, -1}, {37247, -1, -1, -1}, {40479, -1, -1, -1}, {23615, -1, -1, -1}, {25423, -1, -1, -1}, {32834, -1, -1, -1}, {23421, -1, -1, -1}, {21870, -1, -1, -1}, {38218, -1, -1, -1}, {38221, -1, -1, -1}, {28037, -1, -1, -1}, {24744, -1, -1, -1}, {26592, -1, -1, -1}, {29406, -1, -1, -1}, {20957, -1, -1, -1}, {23425, -1, -1, -1}, {25319, -1, -1, -1}, {27870, -1, -1, -1}, {12124, 29275, -1, -1}, {25197, -1, -1, -1}, {38062, -1, -1, -1}, {32445, -1, -1, -1}, {33043, -1, -1, -1}, {27987, -1, -1, -1}, {20892, -1, -1, -1}, {24324, -1, -1, -1}, {22900, -1, -1, -1}, {21162, -1, -1, -1}, {24594, -1, -1, -1}, {12069, 22899, -1, -1}, {26262, -1, -1, -1}, {34384, -1, -1, -1}, {30111, -1, -1, -1}, {25386, -1, -1, -1}, {25062, -1, -1, -1}, {31983, -1, -1, -1}, {35834, -1, -1, -1}, {21734, -1, -1, -1}, {27431, -1, -1, -1}, {40485, -1, -1, -1}, {27572, -1, -1, -1}, {34261, -1, -1, -1}, {21589, -1, -1, -1}, {20598, -1, -1, -1}, {27812, -1, -1, -1}, {21866, -1, -1, -1}, {36276, -1, -1, -1}, {29228, -1, -1, -1}, {24085, -1, -1, -1}, {24597, -1, -1, -1}, {29750, -1, -1, -1}, {25293, -1, -1, -1}, {25490, -1, -1, -1}, {29260, -1, -1, -1}, {24472, -1, -1, -1}, {28227, -1, -1, -1}, {27966, -1, -1, -1}, {25856, -1, -1, -1}, {28504, -1, -1, -1}, {30424, -1, -1, -1}, {30928, -1, -1, -1}, {30460, -1, -1, -1}, {30036, -1, -1, -1}, {21028, -1, -1, -1}, {21467, -1, -1, -1}, {20051, -1, -1, -1}, {24222, -1, -1, -1}, {26049, -1, -1, -1}, {32810, -1, -1, -1}, {32982, -1, -1, -1}, {25243, -1, -1, -1}, {21638, -1, -1, -1}, {21032, -1, -1, -1}, {28846, -1, -1, -1}, {34957, -1, -1, -1}, {36305, -1, -1, -1}, {27873, -1, -1, -1}, {21624, -1, -1, -1}, {32986, -1, -1, -1}, {22521, -1, -1, -1}, {35060, -1, -1, -1}, {36180, -1, -1, -1}, {38506, -1, -1, -1}, {37197, -1, -1, -1}, {20329, -1, -1, -1}, {27803, -1, -1, -1}, {21943, -1, -1, -1}, {30406, -1, -1, -1}, {30768, -1, -1, -1}, {25256, -1, -1, -1}, {28921, -1, -1, -1}, {28558, -1, -1, -1}, {24429, -1, -1, -1}, {34028, -1, -1, -1}, {26842, -1, -1, -1}, {30844, -1, -1, -1}, {31735, -1, -1, -1}, {33192, -1, -1, -1}, {26379, -1, -1, -1}, {40527, -1, -1, -1}, {25447, -1, -1, -1}, {30896, -1, -1, -1}, {22383, -1, -1, -1}, {30738, -1, -1, -1}, {38713, -1, -1, -1}, {25209, -1, -1, -1}, {25259, -1, -1, -1}, {21128, -1, -1, -1}, {29749, -1, -1, -1}, {27607, -1, -1, -1}, {21860, -1, -1, -1}, {33086, -1, -1, -1}, {30130, -1, -1, -1}, {12138, 30382, -1, -1}, {21305, -1, -1, -1}, {30174, -1, -1, -1}, {20731, -1, -1, -1}, {23617, -1, -1, -1}, {35692, -1, -1, -1}, {31687, -1, -1, -1}, {20559, -1, -1, -1}, {12122, 29255, -1, -1}, {39575, -1, -1, -1}, {39128, -1, -1, -1}, {28418, -1, -1, -1}, {29922, -1, -1, -1}, {31080, -1, -1, -1}, {25735, -1, -1, -1}, {30629, -1, -1, -1}, {25340, -1, -1, -1}, {39057, -1, -1, -1}, {36139, -1, -1, -1}, {21697, -1, -1, -1}, {32856, -1, -1, -1}, {20050, -1, -1, -1}, {22378, -1, -1, -1}, {33529, -1, -1, -1}, {33805, -1, -1, -1}, {24179, -1, -1, -1}, {20973, -1, -1, -1}, {29942, -1, -1, -1}, {35780, -1, -1, -1}, {23631, -1, -1, -1}, {22369, -1, -1, -1}, {27900, -1, -1, -1}, {39047, -1, -1, -1}, {23110, -1, -1, -1}, {30772, -1, -1, -1}, {39748, -1, -1, -1}, {36843, -1, -1, -1}, {31893, -1, -1, -1}, {21078, -1, -1, -1}, {25169, -1, -1, -1}, {38138, -1, -1, -1}, {20166, -1, -1, -1}, {33670, -1, -1, -1}, {33889, -1, -1, -1}, {33769, -1, -1, -1}, {33970, -1, -1, -1}, {22484, -1, -1, -1}, {26420, -1, -1, -1}, {22275, -1, -1, -1}, {26222, -1, -1, -1}, {28006, -1, -1, -1}, {35889, -1, -1, -1}, {26333, -1, -1, -1}, {28689, -1, -1, -1}, {26399, -1, -1, -1}, {27450, -1, -1, -1}, {26646, -1, -1, -1}, {25114, -1, -1, -1}, {22971, -1, -1, -1}, {19971, -1, -1, -1}, {20932, -1, -1, -1} },
    {{28422, -1, -1, -1}, {26578, -1, -1, -1}, {27791, -1, -1, -1}, {20854, -1, -1, -1}, {26827, -1, -1, -1}, {22855, -1, -1, -1}, {27495, -1, -1, -1}, {30054, -1, -1, -1}, {23822, -1, -1, -1}, {33040, -1, -1, -1}, {40784, -1, -1, -1}, {26071, -1, -1, -1}, {31048, -1, -1, -1}, {31041, -1, -1, -1}, {39569, -1, -1, -1}, {36215, -1, -1, -1}, {23682, -1, -1, -1}, {20062, -1, -1, -1}, {20225, -1, -1, -1}, {21551, -1, -1, -1}, {22865, -1, -1, -1}, {30732, -1, -1, -1}, {22120, -1, -1, -1}, {12115, 27668, -1, -1}, {36804, -1, -1, -1}, {24323, -1, -1, -1}, {27773, -1, -1, -1}, {27875, -1, -1, -1}, {35755, -1, -1, -1}, {25488, -1, -1, -1}, {24688, -1, -1, -1}, {27965, -1, -1, -1}, {29301, -1, -1, -1}, {25190, -1, -1, -1}, {38030, -1, -1, -1}, {38085, -1, -1, -1}, {21315, -1, -1, -1}, {36801, -1, -1, -1}, {31614, -1, -1, -1}, {20191, -1, -1, -1}, {35878, -1, -1, -1}, {20094, -1, -1, -1}, {40660, -1, -1, -1}, {38065, -1, -1, -1}, {38067, -1, -1, -1}, {21069, -1, -1, -1}, {28508, -1, -1, -1}, {36963, -1, -1, -1}, {27973, -1, -1, -1}, {35892, -1, -1, -1}, {22545, -1, -1, -1}, {23884, -1, -1, -1}, {12107, 27424, -1, -1}, {27465, -1, -1, -1}, {26538, -1, -1, -1}, {21595, -1, -1, -1}, {33108, -1, -1, -1}, {32652, -1, -1, -1}, {22681, -1, -1, -1}, {34103, -1, -1, -1}, {24378, -1, -1, -1}, {25250, -1, -1, -1}, {27207, -1, -1, -1}, {38201, -1, -1, -1}, {25970, -1, -1, -1}, {24708, -1, -1, -1}, {26725, -1, -1, -1}, {30631, -1, -1, -1}, {20052, -1, -1, -1}, {20392, -1, -1, -1}, {24039, -1, -1, -1}, {38808, -1, -1, -1}, {25772, -1, -1, -1}, {32728, -1, -1, -1}, {23789, -1, -1, -1}, {20431, -1, -1, -1}, {31373, -1, -1, -1}, {20999, -1, -1, -1}, {33540, -1, -1, -1}, {19988, -1, -1, -1}, {24623, -1, -1, -1}, {31363, -1, -1, -1}, {38054, -1, -1, -1}, {20405, -1, -1, -1}, {20146, -1, -1, -1}, {31206, -1, -1, -1}, {29748, -1, -1, -1}, {21220, -1, -1, -1}, {33465, -1, -1, -1}, {25810, -1, -1, -1}, {31165, -1, -1, -1}, {23517, -1, -1, -1}, {27777, -1, -1, -1}, {38738, -1, -1, -1}, {36731, -1, -1, -1}, {27682, -1, -1, -1}, {20542, -1, -1, -1}, {21375, -1, -1, -1}, {28165, -1, -1, -1}, {25806, -1, -1, -1}, {26228, -1, -1, -1}, {27696, -1, -1, -1}, {24773, -1, -1, -1}, {39031, -1, -1, -1}, {35831, -1, -1, -1}, {24198, -1, -1, -1}, {29756, -1, -1, -1}, {31351, -1, -1, -1}, {31179, -1, -1, -1}, {19992, -1, -1, -1}, {37041, -1, -1, -1}, {29699, -1, -1, -1}, {27714, -1, -1, -1}, {22234, -1, -1, -1}, {37195, -1, -1, -1}, {27845, -1, -1, -1}, {36235, -1, -1, -1}, {21306, -1, -1, -1}, {34502, -1, -1, -1}, {26354, -1, -1, -1}, {36527, -1, -1, -1}, {23624, -1, -1, -1}, {39537, -1, -1, -1}, {28192, -1, -1, -1}, {21462, -1, -1, -1}, {23094, -1, -1, -1}, {40843, -1, -1, -1}, {36259, -1, -1, -1}, {21435, -1, -1, -1}, {22280, -1, -1, -1}, {39079, -1, -1, -1}, {26435, -1, -1, -1}, {37275, -1, -1, -1}, {27849, -1, -1, -1}, {20840, -1, -1, -1}, {30154, -1, -1, -1}, {25331, -1, -1, -1}, {12125, 29356, -1, -1}, {21048, -1, -1, -1}, {21149, -1, -1, -1}, {32570, -1, -1, -1}, {28820, -1, -1, -1}, {30264, -1, -1, -1}, {21364, -1, -1, -1}, {40522, -1, -1, -1}, {27063, -1, -1, -1}, {30830, -1, -1, -1}, {38592, -1, -1, -1}, {35033, -1, -1, -1}, {32676, -1, -1, -1}, {28982, -1, -1, -1}, {29123, -1, -1, -1}, {20873, -1, -1, -1}, {26579, -1, -1, -1}, {29924, -1, -1, -1}, {22756, -1, -1, -1}, {25880, -1, -1, -1}, {22199, -1, -1, -1}, {35753, -1, -1, -1}, {39286, -1, -1, -1}, {25200, -1, -1, -1}, {32469, -1, -1, -1}, {24825, -1, -1, -1}, {28909, -1, -1, -1}, {22764, -1, -1, -1}, {20161, -1, -1, -1}, {12040, 20154, -1, -1}, {24525, -1, -1, -1}, {38887, -1, -1, -1}, {20219, -1, -1, -1}, {35748, -1, -1, -1}, {20995, -1, -1, -1}, {22922, -1, -1, -1}, {32427, -1, -1, -1}, {25172, -1, -1, -1}, {20173, -1, -1, -1}, {12103, 26085, -1, -1}, {25102, -1, -1, -1}, {33592, -1, -1, -1}, {33993, -1, -1, -1}, {33635, -1, -1, -1}, {34701, -1, -1, -1}, {29076, -1, -1, -1}, {28342, -1, -1, -1}, {23481, -1, -1, -1}, {32466, -1, -1, -1}, {20887, -1, -1, -1}, {25545, -1, -1, -1}, {26580, -1, -1, -1}, {12161, 32905, -1, -1}, {33593, -1, -1, -1}, {34837, -1, -1, -1}, {20754, -1, -1, -1}, {23418, -1, -1, -1}, {22914, -1, -1, -1}, {36785, -1, -1, -1}, {20083, -1, -1, -1}, {27741, -1, -1, -1}, {12042, 20837, -1, -1}, {35109, -1, -1, -1}, {36719, -1, -1, -1}, {38446, -1, -1, -1}, {34122, -1, -1, -1}, {29790, -1, -1, -1}, {38160, -1, -1, -1}, {38384, -1, -1, -1}, {28070, -1, -1, -1}, {33509, -1, -1, -1}, {24369, -1, -1, -1}, {25746, -1, -1, -1}, {27922, -1, -1, -1}, {33832, -1, -1, -1}, {33134, -1, -1, -1}, {40131, -1, -1, -1}, {22622, -1, -1, -1}, {36187, -1, -1, -1}, {19977, -1, -1, -1}, {21441, -1, -1, -1}, {20254, -1, -1, -1}, {25955, -1, -1, -1}, {26705, -1, -1, -1}, {21971, -1, -1, -1}, {20007, -1, -1, -1}, {25620, -1, -1, -1}, {39578, -1, -1, -1}, {25195, -1, -1, -1}, {23234, -1, -1, -1}, {29791, -1, -1, -1}, {12170, 33394, -1, -1}, {28073, -1, -1, -1}, {26862, -1, -1, -1}, {20711, -1, -1, -1}, {33678, -1, -1, -1}, {30722, -1, -1, -1}, {26432, -1, -1, -1}, {21049, -1, -1, -1}, {27801, -1, -1, -1}, {32433, -1, -1, -1}, {20667, -1, -1, -1}, {21861, -1, -1, -1}, {29022, -1, -1, -1}, {31579, -1, -1, -1}, {26194, -1, -1, -1}, {29642, -1, -1, -1}, {33515, -1, -1, -1}, {26441, -1, -1, -1}, {12077, 23665, -1, -1}, {21024, -1, -1, -1}, {29053, -1, -1, -1}, {34923, -1, -1, -1}, {38378, -1, -1, -1}, {38485, -1, -1, -1}, {25797, -1, -1, -1}, {36193, -1, -1, -1}, {33203, -1, -1, -1}, {21892, -1, -1, -1} },
    {{27733, -1, -1, -1}, {25159, -1, -1, -1}, {32558, -1, -1, -1}, {22674, -1, -1, -1}, {20260, -1, -1, -1}, {21830, -1, -1, -1}, {36175, -1, -1, -1}, {26188, -1, -1, -1}, {19978, -1, -1, -1}, {23578, -1, -1, -1}, {35059, -1, -1, -1}, {26786, -1, -1, -1}, {25422, -1, -1, -1}, {31245, -1, -1, -1}, {28903, -1, -1, -1}, {33421, -1, -1, -1}, {21242, -1, -1, -1}, {38902, -1, -1, -1}, {23569, -1, -1, -1}, {21736, -1, -1, -1}, {37045, -1, -1, -1}, {32461, -1, -1, -1}, {22882, -1, -1, -1}, {36170, -1, -1, -1}, {34503, -1, -1, -1}, {12166, 33292, -1, -1}, {33293, -1, -1, -1}, {36198, -1, -1, -1}, {25668, -1, -1, -1}, {23556, -1, -1, -1}, {24913, -1, -1, -1}, {28041, -1, -1, -1}, {31038, -1, -1, -1}, {35774, -1, -1, -1}, {30775, -1, -1, -1}, {30003, -1, -1, -1}, {21627, -1, -1, -1}, {20280, -1, -1, -1}, {12189, 36523, -1, -1}, {28145, -1, -1, -1}, {23072, -1, -1, -1}, {32453, -1, -1, -1}, {31070, -1, -1, -1}, {27784, -1, -1, -1}, {23457, -1, -1, -1}, {23158, -1, -1, -1}, {29978, -1, -1, -1}, {32958, -1, -1, -1}, {24910, -1, -1, -1}, {28183, -1, -1, -1}, {22768, -1, -1, -1}, {12131, 29983, -1, -1}, {29989, -1, -1, -1}, {29298, -1, -1, -1}, {21319, -1, -1, -1}, {32499, -1, -1, -1}, {30465, -1, -1, -1}, {30427, -1, -1, -1}, {21097, -1, -1, -1}, {32988, -1, -1, -1}, {22307, -1, -1, -1}, {24072, -1, -1, -1}, {22833, -1, -1, -1}, {29422, -1, -1, -1}, {26045, -1, -1, -1}, {28287, -1, -1, -1}, {35799, -1, -1, -1}, {12075, 23608, -1, -1}, {34417, -1, -1, -1}, {12055, 21313, -1, -1}, {12143, 30707, -1, -1}, {25342, -1, -1, -1}, {26102, -1, -1, -1}, {20160, -1, -1, -1}, {12215, 39135, -1, -1}, {34432, -1, -1, -1}, {23454, -1, -1, -1}, {35782, -1, -1, -1}, {21490, -1, -1, -1}, {12142, 30690, -1, -1}, {20351, -1, -1, -1}, {23630, -1, -1, -1}, {39542, -1, -1, -1}, {22987, -1, -1, -1}, {24335, -1, -1, -1}, {12144, 31034, -1, -1}, {12064, 22763, -1, -1}, {19990, -1, -1, -1}, {26623, -1, -1, -1}, {20107, -1, -1, -1}, {25325, -1, -1, -1}, {35475, -1, -1, -1}, {36893, -1, -1, -1}, {21183, -1, -1, -1}, {26159, -1, -1, -1}, {21980, -1, -1, -1}, {22124, -1, -1, -1}, {36866, -1, -1, -1}, {20181, -1, -1, -1}, {20365, -1, -1, -1}, {37322, -1, -1, -1}, {39280, -1, -1, -1}, {12114, 27663, -1, -1}, {24066, -1, -1, -1}, {24643, -1, -1, -1}, {23460, -1, -1, -1}, {35270, -1, -1, -1}, {35797, -1, -1, -1}, {25910, -1, -1, -1}, {12095, 25163, -1, -1}, {12216, 39318, -1, -1}, {23432, -1, -1, -1}, {23551, -1, -1, -1}, {25480, -1, -1, -1}, {21806, -1, -1, -1}, {21463, -1, -1, -1}, {30246, -1, -1, -1}, {20861, -1, -1, -1}, {34092, -1, -1, -1}, {26530, -1, -1, -1}, {26803, -1, -1, -1}, {27530, -1, -1, -1}, {25234, -1, -1, -1}, {36755, -1, -1, -1}, {21460, -1, -1, -1}, {33298, -1, -1, -1}, {28113, -1, -1, -1}, {30095, -1, -1, -1}, {20070, -1, -1, -1}, {36174, -1, -1, -1}, {23408, -1, -1, -1}, {29087, -1, -1, -1}, {34223, -1, -1, -1}, {26257, -1, -1, -1}, {26329, -1, -1, -1}, {32626, -1, -1, -1}, {34560, -1, -1, -1}, {12233, 40653, -1, -1}, {12239, 40736, -1, -1}, {23646, -1, -1, -1}, {26415, -1, -1, -1}, {36848, -1, -1, -1}, {26641, -1, -1, -1}, {26463, -1, -1, -1}, {25101, -1, -1, -1}, {31446, -1, -1, -1}, {22661, -1, -1, -1}, {24246, -1, -1, -1}, {25968, -1, -1, -1}, {28465, -1, -1, -1}, {24661, -1, -1, -1}, {21047, -1, -1, -1}, {32781, -1, -1, -1}, {25684, -1, -1, -1}, {34928, -1, -1, -1}, {29993, -1, -1, -1}, {24069, -1, -1, -1}, {26643, -1, -1, -1}, {25332, -1, -1, -1}, {38684, -1, -1, -1}, {21452, -1, -1, -1}, {29245, -1, -1, -1}, {35841, -1, -1, -1}, {12116, 27700, -1, -1}, {30561, -1, -1, -1}, {31246, -1, -1, -1}, {21550, -1, -1, -1}, {30636, -1, -1, -1}, {39034, -1, -1, -1}, {33308, -1, -1, -1}, {35828, -1, -1, -1}, {30805, -1, -1, -1}, {26388, -1, -1, -1}, {28865, -1, -1, -1}, {26031, -1, -1, -1}, {25749, -1, -1, -1}, {22070, -1, -1, -1}, {24605, -1, -1, -1}, {31169, -1, -1, -1}, {21496, -1, -1, -1}, {19997, -1, -1, -1}, {27515, -1, -1, -1}, {32902, -1, -1, -1}, {23546, -1, -1, -1}, {21987, -1, -1, -1}, {22235, -1, -1, -1}, {20282, -1, -1, -1}, {20284, -1, -1, -1}, {39282, -1, -1, -1}, {24051, -1, -1, -1}, {26494, -1, -1, -1}, {32824, -1, -1, -1}, {24578, -1, -1, -1}, {39042, -1, -1, -1}, {36865, -1, -1, -1}, {23435, -1, -1, -1}, {35772, -1, -1, -1}, {35829, -1, -1, -1}, {25628, -1, -1, -1}, {33368, -1, -1, -1}, {25822, -1, -1, -1}, {22013, -1, -1, -1}, {33487, -1, -1, -1}, {37221, -1, -1, -1}, {20439, -1, -1, -1}, {32032, -1, -1, -1}, {36895, -1, -1, -1}, {31903, -1, -1, -1}, {20723, -1, -1, -1}, {22609, -1, -1, -1}, {28335, -1, -1, -1}, {23487, -1, -1, -1}, {35785, -1, -1, -1}, {32899, -1, -1, -1}, {37240, -1, -1, -1}, {33948, -1, -1, -1}, {31639, -1, -1, -1}, {34429, -1, -1, -1}, {38539, -1, -1, -1}, {38543, -1, -1, -1}, {32485, -1, -1, -1}, {39635, -1, -1, -1}, {30862, -1, -1, -1}, {23681, -1, -1, -1}, {31319, -1, -1, -1}, {36930, -1, -1, -1}, {38567, -1, -1, -1}, {31071, -1, -1, -1}, {23385, -1, -1, -1}, {25439, -1, -1, -1}, {31499, -1, -1, -1}, {34001, -1, -1, -1}, {26797, -1, -1, -1}, {21766, -1, -1, -1}, {32553, -1, -1, -1}, {29712, -1, -1, -1}, {32034, -1, -1, -1}, {38145, -1, -1, -1}, {25152, -1, -1, -1}, {22604, -1, -1, -1}, {20182, -1, -1, -1}, {23427, -1, -1, -1}, {22905, -1, -1, -1}, {22612, -1, -1, -1}, {29549, -1, -1, -1}, {25374, -1, -1, -1}, {36427, -1, -1, -1}, {36367, -1, -1, -1}, {32974, -1, -1, -1}, {33492, -1, -1, -1}, {25260, -1, -1, -1}, {21488, -1, -1, -1}, {27888, -1, -1, -1}, {37214, -1, -1, -1}, {22826, -1, -1, -1}, {24577, -1, -1, -1} },
    {{27760, -1, -1, -1}, {22349, -1, -1, -1}, {25674, -1, -1, -1}, {36138, -1, -1, -1}, {30251, -1, -1, -1}, {28393, -1, -1, -1}, {22363, -1, -1, -1}, {27264, -1, -1, -1}, {30192, -1, -1, -1}, {28525, -1, -1, -1}, {35885, -1, -1, -1}, {35848, -1, -1, -1}, {22374, -1, -1, -1}, {27631, -1, -1, -1}, {34962, -1, -1, -1}, {30899, -1, -1, -1}, {25506, -1, -1, -1}, {21497, -1, -1, -1}, {28845, -1, -1, -1}, {27748, -1, -1, -1}, {22616, -1, -1, -1}, {25642, -1, -1, -1}, {22530, -1, -1, -1}, {26848, -1, -1, -1}, {33179, -1, -1, -1}, {21776, -1, -1, -1}, {31958, -1, -1, -1}, {20504, -1, -1, -1}, {36538, -1, -1, -1}, {28108, -1, -1, -1}, {36255, -1, -1, -1}, {28907, -1, -1, -1}, {25487, -1, -1, -1}, {28059, -1, -1, -1}, {28372, -1, -1, -1}, {32486, -1, -1, -1}, {33796, -1, -1, -1}, {26691, -1, -1, -1}, {36867, -1, -1, -1}, {28120, -1, -1, -1}, {38518, -1, -1, -1}, {35752, -1, -1, -1}, {22871, -1, -1, -1}, {29305, -1, -1, -1}, {34276, -1, -1, -1}, {33150, -1, -1, -1}, {30140, -1, -1, -1}, {35466, -1, -1, -1}, {26799, -1, -1, -1}, {21076, -1, -1, -1}, {36386, -1, -1, -1}, {38161, -1, -1, -1}, {25552, -1, -1, -1}, {39064, -1, -1, -1}, {36420, -1, -1, -1}, {21884, -1, -1, -1}, {20307, -1, -1, -1}, {26367, -1, -1, -1}, {22159, -1, -1, -1}, {24789, -1, -1, -1}, {28053, -1, -1, -1}, {21059, -1, -1, -1}, {23625, -1, -1, -1}, {22825, -1, -1, -1}, {28155, -1, -1, -1}, {22635, -1, -1, -1}, {12133, 30000, -1, -1}, {29980, -1, -1, -1}, {24684, -1, -1, -1}, {33300, -1, -1, -1}, {33094, -1, -1, -1}, {25361, -1, -1, -1}, {26465, -1, -1, -1}, {36834, -1, -1, -1}, {30522, -1, -1, -1}, {36339, -1, -1, -1}, {36148, -1, -1, -1}, {38081, -1, -1, -1}, {24086, -1, -1, -1}, {21381, -1, -1, -1}, {21548, -1, -1, -1}, {28867, -1, -1, -1}, {27712, -1, -1, -1}, {24311, -1, -1, -1}, {20572, -1, -1, -1}, {20141, -1, -1, -1}, {24237, -1, -1, -1}, {25402, -1, -1, -1}, {33351, -1, -1, -1}, {36890, -1, -1, -1}, {26704, -1, -1, -1}, {37230, -1, -1, -1}, {30643, -1, -1, -1}, {21516, -1, -1, -1}, {38108, -1, -1, -1}, {24420, -1, -1, -1}, {31461, -1, -1, -1}, {26742, -1, -1, -1}, {25413, -1, -1, -1}, {31570, -1, -1, -1}, {32479, -1, -1, -1}, {30171, -1, -1, -1}, {20599, -1, -1, -1}, {25237, -1, -1, -1}, {22836, -1, -1, -1}, {36879, -1, -1, -1}, {20984, -1, -1, -1}, {31171, -1, -1, -1}, {31361, -1, -1, -1}, {22270, -1, -1, -1}, {24466, -1, -1, -1}, {36884, -1, -1, -1}, {28034, -1, -1, -1}, {23648, -1, -1, -1}, {12063, 22303, -1, -1}, {21520, -1, -1, -1}, {20820, -1, -1, -1}, {28237, -1, -1, -1}, {22242, -1, -1, -1}, {25512, -1, -1, -1}, {39059, -1, -1, -1}, {33151, -1, -1, -1}, {34581, -1, -1, -1}, {35114, -1, -1, -1}, {36864, -1, -1, -1}, {21534, -1, -1, -1}, {23663, -1, -1, -1}, {33216, -1, -1, -1}, {25302, -1, -1, -1}, {25176, -1, -1, -1}, {33073, -1, -1, -1}, {40501, -1, -1, -1}, {38464, -1, -1, -1}, {39534, -1, -1, -1}, {39548, -1, -1, -1}, {26925, -1, -1, -1}, {22949, -1, -1, -1}, {25299, -1, -1, -1}, {21822, -1, -1, -1}, {25366, -1, -1, -1}, {21703, -1, -1, -1}, {34521, -1, -1, -1}, {27964, -1, -1, -1}, {23043, -1, -1, -1}, {12129, 29926, -1, -1}, {34972, -1, -1, -1}, {27498, -1, -1, -1}, {22806, -1, -1, -1}, {35916, -1, -1, -1}, {24367, -1, -1, -1}, {28286, -1, -1, -1}, {29609, -1, -1, -1}, {39037, -1, -1, -1}, {20024, -1, -1, -1}, {28919, -1, -1, -1}, {23436, -1, -1, -1}, {30871, -1, -1, -1}, {25405, -1, -1, -1}, {26202, -1, -1, -1}, {30358, -1, -1, -1}, {24779, -1, -1, -1}, {23451, -1, -1, -1}, {23113, -1, -1, -1}, {19975, -1, -1, -1}, {33109, -1, -1, -1}, {27754, -1, -1, -1}, {29579, -1, -1, -1}, {20129, -1, -1, -1}, {26505, -1, -1, -1}, {12153, 32593, -1, -1}, {24448, -1, -1, -1}, {26106, -1, -1, -1}, {26395, -1, -1, -1}, {24536, -1, -1, -1}, {22916, -1, -1, -1}, {23041, -1, -1, -1}, {24013, -1, -1, -1}, {24494, -1, -1, -1}, {21361, -1, -1, -1}, {38886, -1, -1, -1}, {36829, -1, -1, -1}, {26693, -1, -1, -1}, {22260, -1, -1, -1}, {21807, -1, -1, -1}, {24799, -1, -1, -1}, {20026, -1, -1, -1}, {28493, -1, -1, -1}, {32500, -1, -1, -1}, {33479, -1, -1, -1}, {33806, -1, -1, -1}, {22996, -1, -1, -1}, {20255, -1, -1, -1}, {20266, -1, -1, -1}, {23614, -1, -1, -1}, {32428, -1, -1, -1}, {26410, -1, -1, -1}, {34074, -1, -1, -1}, {21619, -1, -1, -1}, {30031, -1, -1, -1}, {32963, -1, -1, -1}, {21890, -1, -1, -1}, {39759, -1, -1, -1}, {20301, -1, -1, -1}, {28205, -1, -1, -1}, {35859, -1, -1, -1}, {23561, -1, -1, -1}, {24944, -1, -1, -1}, {21355, -1, -1, -1}, {30239, -1, -1, -1}, {28201, -1, -1, -1}, {34442, -1, -1, -1}, {12098, 25991, -1, -1}, {38395, -1, -1, -1}, {32441, -1, -1, -1}, {21563, -1, -1, -1}, {31283, -1, -1, -1}, {32010, -1, -1, -1}, {38382, -1, -1, -1}, {21985, -1, -1, -1}, {32705, -1, -1, -1}, {29934, -1, -1, -1}, {25373, -1, -1, -1}, {34583, -1, -1, -1}, {28065, -1, -1, -1}, {31389, -1, -1, -1}, {25105, -1, -1, -1}, {26017, -1, -1, -1}, {21351, -1, -1, -1}, {25569, -1, -1, -1}, {27779, -1, -1, -1}, {24043, -1, -1, -1}, {21596, -1, -1, -1}, {38056, -1, -1, -1}, {20044, -1, -1, -1}, {27745, -1, -1, -1}, {35820, -1, -1, -1}, {23627, -1, -1, -1}, {12102, 26080, -1, -1}, {33436, -1, -1, -1}, {26791, -1, -1, -1}, {21566, -1, -1, -1}, {21556, -1, -1, -1}, {12111, 27595, -1, -1}, {27494, -1, -1, -1}, {20116, -1, -1, -1}, {25410, -1, -1, -1}, {21320, -1, -1, -1}, {33310, -1, -1, -1}, {20237, -1, -1, -1}, {20398, -1, -1, -1}, {22366, -1, -1, -1}, {25098, -1, -1, -1}, {38654, -1, -1, -1}, {26212, -1, -1, -1}, {29289, -1, -1, -1}, {21247, -1, -1, -1} },
    {{21153, -1, -1, -1}, {24735, -1, -1, -1}, {35823, -1, -1, -1}, {26132, -1, -1, -1}, {29081, -1, -1, -1}, {26512, -1, -1, -1}, {35199, -1, -1, -1}, {30802, -1, -1, -1}, {30717, -1, -1, -1}, {26224, -1, -1, -1}, {22075, -1, -1, -1}, {21560, -1, -1, -1}, {38177, -1, -1, -1}, {29306, -1, -1, -1}, {31232, -1, -1, -1}, {24687, -1, -1, -1}, {24076, -1, -1, -1}, {24713, -1, -1, -1}, {33181, -1, -1, -1}, {12067, 22805, -1, -1}, {24796, -1, -1, -1}, {29060, -1, -1, -1}, {28911, -1, -1, -1}, {28330, -1, -1, -1}, {27728, -1, -1, -1}, {29312, -1, -1, -1}, {27268, -1, -1, -1}, {34989, -1, -1, -1}, {24109, -1, -1, -1}, {20064, -1, -1, -1}, {23219, -1, -1, -1}, {21916, -1, -1, -1}, {38115, -1, -1, -1}, {27927, -1, -1, -1}, {31995, -1, -1, -1}, {38553, -1, -1, -1}, {25103, -1, -1, -1}, {32454, -1, -1, -1}, {30606, -1, -1, -1}, {34430, -1, -1, -1}, {21283, -1, -1, -1}, {38686, -1, -1, -1}, {36758, -1, -1, -1}, {26247, -1, -1, -1}, {23777, -1, -1, -1}, {20384, -1, -1, -1}, {29421, -1, -1, -1}, {19979, -1, -1, -1}, {21414, -1, -1, -1}, {22799, -1, -1, -1}, {21523, -1, -1, -1}, {25472, -1, -1, -1}, {38184, -1, -1, -1}, {20808, -1, -1, -1}, {20185, -1, -1, -1}, {40092, -1, -1, -1}, {32420, -1, -1, -1}, {21688, -1, -1, -1}, {36132, -1, -1, -1}, {34900, -1, -1, -1}, {33335, -1, -1, -1}, {38386, -1, -1, -1}, {28046, -1, -1, -1}, {24358, -1, -1, -1}, {23244, -1, -1, -1}, {26174, -1, -1, -1}, {38505, -1, -1, -1}, {29616, -1, -1, -1}, {29486, -1, -1, -1}, {21439, -1, -1, -1}, {33146, -1, -1, -1}, {39301, -1, -1, -1}, {32673, -1, -1, -1}, {23466, -1, -1, -1}, {38519, -1, -1, -1}, {38480, -1, -1, -1}, {32447, -1, -1, -1}, {30456, -1, -1, -1}, {21410, -1, -1, -1}, {38262, -1, -1, -1}, {12217, 39321, -1, -1}, {31665, -1, -1, -1}, {35140, -1, -1, -1}, {28248, -1, -1, -1}, {20065, -1, -1, -1}, {32724, -1, -1, -1}, {31077, -1, -1, -1}, {35814, -1, -1, -1}, {24819, -1, -1, -1}, {21709, -1, -1, -1}, {20139, -1, -1, -1}, {39033, -1, -1, -1}, {24055, -1, -1, -1}, {27233, -1, -1, -1}, {20687, -1, -1, -1}, {21521, -1, -1, -1}, {35937, -1, -1, -1}, {33831, -1, -1, -1}, {30813, -1, -1, -1}, {38660, -1, -1, -1}, {21066, -1, -1, -1}, {21742, -1, -1, -1}, {22179, -1, -1, -1}, {38144, -1, -1, -1}, {28040, -1, -1, -1}, {23477, -1, -1, -1}, {28102, -1, -1, -1}, {26195, -1, -1, -1}, {12073, 23567, -1, -1}, {23389, -1, -1, -1}, {26657, -1, -1, -1}, {32918, -1, -1, -1}, {21880, -1, -1, -1}, {31505, -1, -1, -1}, {25928, -1, -1, -1}, {26964, -1, -1, -1}, {20123, -1, -1, -1}, {27463, -1, -1, -1}, {34638, -1, -1, -1}, {38795, -1, -1, -1}, {21327, -1, -1, -1}, {25375, -1, -1, -1}, {25658, -1, -1, -1}, {37034, -1, -1, -1}, {26012, -1, -1, -1}, {32961, -1, -1, -1}, {35856, -1, -1, -1}, {20889, -1, -1, -1}, {26800, -1, -1, -1}, {21368, -1, -1, -1}, {34809, -1, -1, -1}, {25032, -1, -1, -1}, {27844, -1, -1, -1}, {27899, -1, -1, -1}, {35874, -1, -1, -1}, {23633, -1, -1, -1}, {34218, -1, -1, -1}, {33455, -1, -1, -1}, {38156, -1, -1, -1}, {27427, -1, -1, -1}, {12191, 36763, -1, -1}, {26032, -1, -1, -1}, {24571, -1, -1, -1}, {12092, 24515, -1, -1}, {20449, -1, -1, -1}, {34885, -1, -1, -1}, {26143, -1, -1, -1}, {33125, -1, -1, -1}, {29481, -1, -1, -1}, {24826, -1, -1, -1}, {20852, -1, -1, -1}, {21009, -1, -1, -1}, {22411, -1, -1, -1}, {24418, -1, -1, -1}, {37026, -1, -1, -1}, {12175, 34892, -1, -1}, {37266, -1, -1, -1}, {24184, -1, -1, -1}, {26447, -1, -1, -1}, {24615, -1, -1, -1}, {22995, -1, -1, -1}, {20804, -1, -1, -1}, {20982, -1, -1, -1}, {33016, -1, -1, -1}, {21256, -1, -1, -1}, {27769, -1, -1, -1}, {38596, -1, -1, -1}, {29066, -1, -1, -1}, {20241, -1, -1, -1}, {20462, -1, -1, -1}, {32670, -1, -1, -1}, {26429, -1, -1, -1}, {21957, -1, -1, -1}, {38152, -1, -1, -1}, {31168, -1, -1, -1}, {34966, -1, -1, -1}, {32483, -1, -1, -1}, {22687, -1, -1, -1}, {25100, -1, -1, -1}, {38656, -1, -1, -1}, {34394, -1, -1, -1}, {22040, -1, -1, -1}, {39035, -1, -1, -1}, {24464, -1, -1, -1}, {35768, -1, -1, -1}, {33988, -1, -1, -1}, {37207, -1, -1, -1}, {21465, -1, -1, -1}, {26093, -1, -1, -1}, {24207, -1, -1, -1}, {30044, -1, -1, -1}, {24676, -1, -1, -1}, {32110, -1, -1, -1}, {23167, -1, -1, -1}, {32490, -1, -1, -1}, {32493, -1, -1, -1}, {36713, -1, -1, -1}, {21927, -1, -1, -1}, {23459, -1, -1, -1}, {24748, -1, -1, -1}, {26059, -1, -1, -1}, {12126, 29572, -1, -1}, {36873, -1, -1, -1}, {30307, -1, -1, -1}, {30505, -1, -1, -1}, {32474, -1, -1, -1}, {38772, -1, -1, -1}, {34203, -1, -1, -1}, {23398, -1, -1, -1}, {12147, 31348, -1, -1}, {38634, -1, -1, -1}, {12174, 34880, -1, -1}, {21195, -1, -1, -1}, {29071, -1, -1, -1}, {24490, -1, -1, -1}, {26092, -1, -1, -1}, {35810, -1, -1, -1}, {23547, -1, -1, -1}, {39535, -1, -1, -1}, {24033, -1, -1, -1}, {27529, -1, -1, -1}, {27739, -1, -1, -1}, {35757, -1, -1, -1}, {35759, -1, -1, -1}, {36874, -1, -1, -1}, {36805, -1, -1, -1}, {21387, -1, -1, -1}, {25276, -1, -1, -1}, {40486, -1, -1, -1}, {40493, -1, -1, -1}, {21568, -1, -1, -1}, {20011, -1, -1, -1}, {33469, -1, -1, -1}, {12123, 29273, -1, -1}, {34460, -1, -1, -1}, {23830, -1, -1, -1}, {34905, -1, -1, -1}, {28079, -1, -1, -1}, {38597, -1, -1, -1}, {21713, -1, -1, -1}, {20122, -1, -1, -1}, {35766, -1, -1, -1}, {28937, -1, -1, -1}, {21693, -1, -1, -1}, {38409, -1, -1, -1}, {28895, -1, -1, -1}, {28153, -1, -1, -1}, {30416, -1, -1, -1}, {20005, -1, -1, -1}, {30740, -1, -1, -1}, {34578, -1, -1, -1}, {23721, -1, -1, -1}, {24310, -1, -1, -1}, {12180, 35328, -1, -1}, {39068, -1, -1, -1}, {38414, -1, -1, -1} },
    {{28814, -1, -1, -1}, {27839, -1, -1, -1}, {22852, -1, -1, -1}, {25513, -1, -1, -1}, {30524, -1, -1, -1}, {34893, -1, -1, -1}, {28436, -1, -1, -1}, {33395, -1, -1, -1}, {22576, -1, -1, -1}, {29141, -1, -1, -1}, {21388, -1, -1, -1}, {30746, -1, -1, -1}, {38593, -1, -1, -1}, {21761, -1, -1, -1}, {24422, -1, -1, -1}, {28976, -1, -1, -1}, {23476, -1, -1, -1}, {35866, -1, -1, -1}, {39564, -1, -1, -1}, {27523, -1, -1, -1}, {22830, -1, -1, -1}, {40495, -1, -1, -1}, {31207, -1, -1, -1}, {26472, -1, -1, -1}, {25196, -1, -1, -1}, {20335, -1, -1, -1}, {30113, -1, -1, -1}, {12154, 32650, -1, -1}, {27915, -1, -1, -1}, {38451, -1, -1, -1}, {27687, -1, -1, -1}, {20208, -1, -1, -1}, {30162, -1, -1, -1}, {20859, -1, -1, -1}, {26679, -1, -1, -1}, {28478, -1, -1, -1}, {36992, -1, -1, -1}, {33136, -1, -1, -1}, {22934, -1, -1, -1}, {29814, -1, -1, -1}, {25671, -1, -1, -1}, {23591, -1, -1, -1}, {36965, -1, -1, -1}, {31377, -1, -1, -1}, {35875, -1, -1, -1}, {23002, -1, -1, -1}, {21676, -1, -1, -1}, {33280, -1, -1, -1}, {33647, -1, -1, -1}, {35201, -1, -1, -1}, {32768, -1, -1, -1}, {26928, -1, -1, -1}, {22094, -1, -1, -1}, {32822, -1, -1, -1}, {29239, -1, -1, -1}, {37326, -1, -1, -1}, {20918, -1, -1, -1}, {20063, -1, -1, -1}, {39029, -1, -1, -1}, {25494, -1, -1, -1}, {19994, -1, -1, -1}, {21494, -1, -1, -1}, {26355, -1, -1, -1}, {33099, -1, -1, -1}, {22812, -1, -1, -1}, {28082, -1, -1, -1}, {12032, 19968, -1, -1}, {22777, -1, -1, -1}, {21307, -1, -1, -1}, {25558, -1, -1, -1}, {38129, -1, -1, -1}, {20381, -1, -1, -1}, {20234, -1, -1, -1}, {12176, 34915, -1, -1}, {39056, -1, -1, -1}, {22839, -1, -1, -1}, {36951, -1, -1, -1}, {31227, -1, -1, -1}, {20202, -1, -1, -1}, {33008, -1, -1, -1}, {30097, -1, -1, -1}, {27778, -1, -1, -1}, {23452, -1, -1, -1}, {23016, -1, -1, -1}, {24413, -1, -1, -1}, {26885, -1, -1, -1}, {34433, -1, -1, -1}, {20506, -1, -1, -1}, {24050, -1, -1, -1}, {12036, 20057, -1, -1}, {30691, -1, -1, -1}, {20197, -1, -1, -1}, {33402, -1, -1, -1}, {25233, -1, -1, -1}, {26131, -1, -1, -1}, {12194, 37009, -1, -1}, {23673, -1, -1, -1}, {20159, -1, -1, -1}, {24441, -1, -1, -1}, {33222, -1, -1, -1}, {36920, -1, -1, -1}, {32900, -1, -1, -1}, {30123, -1, -1, -1}, {20134, -1, -1, -1}, {35028, -1, -1, -1}, {24847, -1, -1, -1}, {27589, -1, -1, -1}, {24518, -1, -1, -1}, {20041, -1, -1, -1}, {30410, -1, -1, -1}, {28322, -1, -1, -1}, {35811, -1, -1, -1}, {35758, -1, -1, -1}, {35850, -1, -1, -1}, {35793, -1, -1, -1}, {24322, -1, -1, -1}, {32764, -1, -1, -1}, {32716, -1, -1, -1}, {32462, -1, -1, -1}, {33589, -1, -1, -1}, {33643, -1, -1, -1}, {22240, -1, -1, -1}, {27575, -1, -1, -1}, {12211, 38899, -1, -1}, {38452, -1, -1, -1}, {23035, -1, -1, -1}, {21535, -1, -1, -1}, {38134, -1, -1, -1}, {28139, -1, -1, -1}, {23493, -1, -1, -1}, {39278, -1, -1, -1}, {23609, -1, -1, -1}, {24341, -1, -1, -1}, {38544, -1, -1, -1}, {21360, -1, -1, -1}, {33521, -1, -1, -1}, {27185, -1, -1, -1}, {23156, -1, -1, -1}, {40560, -1, -1, -1}, {24212, -1, -1, -1}, {32552, -1, -1, -1}, {33721, -1, -1, -1}, {33828, -1, -1, -1}, {33829, -1, -1, -1}, {33639, -1, -1, -1}, {34631, -1, -1, -1}, {36814, -1, -1, -1}, {36194, -1, -1, -1}, {30408, -1, -1, -1}, {24433, -1, -1, -1}, {39062, -1, -1, -1}, {30828, -1, -1, -1}, {26144, -1, -1, -1}, {21727, -1, -1, -1}, {25317, -1, -1, -1}, {20323, -1, -1, -1}, {33219, -1, -1, -1}, {30152, -1, -1, -1}, {24248, -1, -1, -1}, {38605, -1, -1, -1}, {36362, -1, -1, -1}, {34553, -1, -1, -1}, {21647, -1, -1, -1}, {27891, -1, -1, -1}, {28044, -1, -1, -1}, {27704, -1, -1, -1}, {24703, -1, -1, -1}, {21191, -1, -1, -1}, {12132, 29992, -1, -1}, {24189, -1, -1, -1}, {20248, -1, -1, -1}, {24736, -1, -1, -1}, {24551, -1, -1, -1}, {23588, -1, -1, -1}, {30001, -1, -1, -1}, {37038, -1, -1, -1}, {38080, -1, -1, -1}, {29369, -1, -1, -1}, {27833, -1, -1, -1}, {28216, -1, -1, -1}, {12195, 37193, -1, -1}, {26377, -1, -1, -1}, {21451, -1, -1, -1}, {21491, -1, -1, -1}, {20305, -1, -1, -1}, {37321, -1, -1, -1}, {35825, -1, -1, -1}, {12060, 21448, -1, -1}, {24188, -1, -1, -1}, {36802, -1, -1, -1}, {28132, -1, -1, -1}, {20110, -1, -1, -1}, {30402, -1, -1, -1}, {27014, -1, -1, -1}, {34398, -1, -1, -1}, {24858, -1, -1, -1}, {33286, -1, -1, -1}, {20313, -1, -1, -1}, {20446, -1, -1, -1}, {36926, -1, -1, -1}, {40060, -1, -1, -1}, {24841, -1, -1, -1}, {28189, -1, -1, -1}, {28180, -1, -1, -1}, {38533, -1, -1, -1}, {20104, -1, -1, -1}, {23089, -1, -1, -1}, {12204, 38632, -1, -1}, {19982, -1, -1, -1}, {23679, -1, -1, -1}, {31161, -1, -1, -1}, {23431, -1, -1, -1}, {35821, -1, -1, -1}, {12155, 32701, -1, -1}, {12127, 29577, -1, -1}, {22495, -1, -1, -1}, {33419, -1, -1, -1}, {37057, -1, -1, -1}, {21505, -1, -1, -1}, {36935, -1, -1, -1}, {21947, -1, -1, -1}, {23786, -1, -1, -1}, {24481, -1, -1, -1}, {24840, -1, -1, -1}, {27442, -1, -1, -1}, {29425, -1, -1, -1}, {32946, -1, -1, -1}, {35465, -1, -1, -1}, {28020, -1, -1, -1}, {23507, -1, -1, -1}, {35029, -1, -1, -1}, {39044, -1, -1, -1}, {35947, -1, -1, -1}, {39533, -1, -1, -1}, {40499, -1, -1, -1}, {28170, -1, -1, -1}, {20900, -1, -1, -1}, {20803, -1, -1, -1}, {22435, -1, -1, -1}, {34945, -1, -1, -1}, {21407, -1, -1, -1}, {25588, -1, -1, -1}, {36757, -1, -1, -1}, {22253, -1, -1, -1}, {21592, -1, -1, -1}, {22278, -1, -1, -1}, {29503, -1, -1, -1}, {28304, -1, -1, -1}, {32536, -1, -1, -1}, {36828, -1, -1, -1}, {33489, -1, -1, -1}, {24895, -1, -1, -1}, {24616, -1, -1, -1}, {38498, -1, -1, -1}, {12104, 26352, -1, -1}, {32422, -1, -1, -1} },
    {{36234, -1, -1, -1}, {36291, -1, -1, -1}, {38053, -1, -1, -1}, {23731, -1, -1, -1}, {31908, -1, -1, -1}, {12105, 26376, -1, -1}, {24742, -1, -1, -1}, {38405, -1, -1, -1}, {32792, -1, -1, -1}, {20113, -1, -1, -1}, {37095, -1, -1, -1}, {21248, -1, -1, -1}, {38504, -1, -1, -1}, {20801, -1, -1, -1}, {36816, -1, -1, -1}, {34164, -1, -1, -1}, {37213, -1, -1, -1}, {26197, -1, -1, -1}, {38901, -1, -1, -1}, {23381, -1, -1, -1}, {21277, -1, -1, -1}, {30776, -1, -1, -1}, {26434, -1, -1, -1}, {26685, -1, -1, -1}, {21705, -1, -1, -1}, {28798, -1, -1, -1}, {23472, -1, -1, -1}, {36733, -1, -1, -1}, {20877, -1, -1, -1}, {22312, -1, -1, -1}, {21681, -1, -1, -1}, {25874, -1, -1, -1}, {26242, -1, -1, -1}, {36190, -1, -1, -1}, {36163, -1, -1, -1}, {33039, -1, -1, -1}, {33900, -1, -1, -1}, {36973, -1, -1, -1}, {31967, -1, -1, -1}, {20991, -1, -1, -1}, {34299, -1, -1, -1}, {26531, -1, -1, -1}, {26089, -1, -1, -1}, {28577, -1, -1, -1}, {34468, -1, -1, -1}, {36481, -1, -1, -1}, {22122, -1, -1, -1}, {36896, -1, -1, -1}, {30338, -1, -1, -1}, {28790, -1, -1, -1}, {29157, -1, -1, -1}, {36131, -1, -1, -1}, {25321, -1, -1, -1}, {21017, -1, -1, -1}, {27901, -1, -1, -1}, {36156, -1, -1, -1}, {24590, -1, -1, -1}, {22686, -1, -1, -1}, {24974, -1, -1, -1}, {26366, -1, -1, -1}, {36192, -1, -1, -1}, {25166, -1, -1, -1}, {21939, -1, -1, -1}, {28195, -1, -1, -1}, {26413, -1, -1, -1}, {36711, -1, -1, -1}, {38113, -1, -1, -1}, {38392, -1, -1, -1}, {30504, -1, -1, -1}, {26629, -1, -1, -1}, {27048, -1, -1, -1}, {21643, -1, -1, -1}, {20045, -1, -1, -1}, {28856, -1, -1, -1}, {35784, -1, -1, -1}, {25688, -1, -1, -1}, {25995, -1, -1, -1}, {23429, -1, -1, -1}, {31364, -1, -1, -1}, {20538, -1, -1, -1}, {23528, -1, -1, -1}, {30651, -1, -1, -1}, {27617, -1, -1, -1}, {35449, -1, -1, -1}, {31896, -1, -1, -1}, {27838, -1, -1, -1}, {30415, -1, -1, -1}, {26025, -1, -1, -1}, {36759, -1, -1, -1}, {23853, -1, -1, -1}, {23637, -1, -1, -1}, {34360, -1, -1, -1}, {26632, -1, -1, -1}, {21344, -1, -1, -1}, {25112, -1, -1, -1}, {31449, -1, -1, -1}, {28251, -1, -1, -1}, {32509, -1, -1, -1}, {27167, -1, -1, -1}, {31456, -1, -1, -1}, {24432, -1, -1, -1}, {28467, -1, -1, -1}, {24352, -1, -1, -1}, {25484, -1, -1, -1}, {28072, -1, -1, -1}, {26454, -1, -1, -1}, {19976, -1, -1, -1}, {24080, -1, -1, -1}, {36134, -1, -1, -1}, {20183, -1, -1, -1}, {32960, -1, -1, -1}, {30260, -1, -1, -1}, {38556, -1, -1, -1}, {25307, -1, -1, -1}, {26157, -1, -1, -1}, {25214, -1, -1, -1}, {27836, -1, -1, -1}, {36213, -1, -1, -1}, {29031, -1, -1, -1}, {32617, -1, -1, -1}, {20806, -1, -1, -1}, {32903, -1, -1, -1}, {21484, -1, -1, -1}, {36974, -1, -1, -1}, {25240, -1, -1, -1}, {21746, -1, -1, -1}, {34544, -1, -1, -1}, {36761, -1, -1, -1}, {32773, -1, -1, -1}, {38167, -1, -1, -1}, {34071, -1, -1, -1}, {36825, -1, -1, -1}, {27993, -1, -1, -1}, {29645, -1, -1, -1}, {26015, -1, -1, -1}, {30495, -1, -1, -1}, {29956, -1, -1, -1}, {30759, -1, -1, -1}, {33275, -1, -1, -1}, {36126, -1, -1, -1}, {38024, -1, -1, -1}, {20390, -1, -1, -1}, {26517, -1, -1, -1}, {30137, -1, -1, -1}, {35786, -1, -1, -1}, {38663, -1, -1, -1}, {25391, -1, -1, -1}, {38215, -1, -1, -1}, {38453, -1, -1, -1}, {33976, -1, -1, -1}, {25379, -1, -1, -1}, {30529, -1, -1, -1}, {24449, -1, -1, -1}, {29424, -1, -1, -1}, {20105, -1, -1, -1}, {24596, -1, -1, -1}, {25972, -1, -1, -1}, {25327, -1, -1, -1}, {27491, -1, -1, -1}, {25919, -1, -1, -1}, {24103, -1, -1, -1}, {30151, -1, -1, -1}, {37073, -1, -1, -1}, {35777, -1, -1, -1}, {33437, -1, -1, -1}, {26525, -1, -1, -1}, {12096, 25903, -1, -1}, {21553, -1, -1, -1}, {34584, -1, -1, -1}, {30693, -1, -1, -1}, {32930, -1, -1, -1}, {33026, -1, -1, -1}, {27713, -1, -1, -1}, {20043, -1, -1, -1}, {32455, -1, -1, -1}, {32844, -1, -1, -1}, {30452, -1, -1, -1}, {26893, -1, -1, -1}, {27542, -1, -1, -1}, {25191, -1, -1, -1}, {20540, -1, -1, -1}, {20356, -1, -1, -1}, {22336, -1, -1, -1}, {25351, -1, -1, -1}, {12108, 27490, -1, -1}, {36286, -1, -1, -1}, {21482, -1, -1, -1}, {26088, -1, -1, -1}, {32440, -1, -1, -1}, {24535, -1, -1, -1}, {25370, -1, -1, -1}, {25527, -1, -1, -1}, {12164, 33267, -1, -1}, {33268, -1, -1, -1}, {32622, -1, -1, -1}, {24092, -1, -1, -1}, {23769, -1, -1, -1}, {21046, -1, -1, -1}, {26234, -1, -1, -1}, {31209, -1, -1, -1}, {31258, -1, -1, -1}, {36136, -1, -1, -1}, {28825, -1, -1, -1}, {30164, -1, -1, -1}, {28382, -1, -1, -1}, {27835, -1, -1, -1}, {31378, -1, -1, -1}, {20013, -1, -1, -1}, {30405, -1, -1, -1}, {24544, -1, -1, -1}, {38047, -1, -1, -1}, {34935, -1, -1, -1}, {32456, -1, -1, -1}, {31181, -1, -1, -1}, {32959, -1, -1, -1}, {37325, -1, -1, -1}, {20210, -1, -1, -1}, {20247, -1, -1, -1}, {12168, 33311, -1, -1}, {21608, -1, -1, -1}, {24030, -1, -1, -1}, {27954, -1, -1, -1}, {35788, -1, -1, -1}, {31909, -1, -1, -1}, {36724, -1, -1, -1}, {32920, -1, -1, -1}, {24090, -1, -1, -1}, {21650, -1, -1, -1}, {30385, -1, -1, -1}, {23449, -1, -1, -1}, {26172, -1, -1, -1}, {39588, -1, -1, -1}, {29664, -1, -1, -1}, {26666, -1, -1, -1}, {34523, -1, -1, -1}, {26417, -1, -1, -1}, {29482, -1, -1, -1}, {35832, -1, -1, -1}, {35803, -1, -1, -1}, {36880, -1, -1, -1}, {12149, 31481, -1, -1}, {28891, -1, -1, -1}, {29038, -1, -1, -1}, {25284, -1, -1, -1}, {30633, -1, -1, -1}, {22065, -1, -1, -1}, {20027, -1, -1, -1}, {33879, -1, -1, -1}, {26609, -1, -1, -1}, {21161, -1, -1, -1}, {34496, -1, -1, -1}, {36142, -1, -1, -1}, {38136, -1, -1, -1}, {31569, -1, -1, -1}, {20303, -1, -1, -1}, {27880, -1, -1, -1} },
    {{31069, -1, -1, -1}, {39547, -1, -1, -1}, {25235, -1, -1, -1}, {12118, 29226, -1, -1}, {25341, -1, -1, -1}, {19987, -1, -1, -1}, {30742, -1, -1, -1}, {36716, -1, -1, -1}, {25776, -1, -1, -1}, {36186, -1, -1, -1}, {31686, -1, -1, -1}, {26729, -1, -1, -1}, {24196, -1, -1, -1}, {35013, -1, -1, -1}, {22918, -1, -1, -1}, {25758, -1, -1, -1}, {22766, -1, -1, -1}, {29366, -1, -1, -1}, {26894, -1, -1, -1}, {38181, -1, -1, -1}, {36861, -1, -1, -1}, {36184, -1, -1, -1}, {22368, -1, -1, -1}, {32512, -1, -1, -1}, {35846, -1, -1, -1}, {20934, -1, -1, -1}, {25417, -1, -1, -1}, {25305, -1, -1, -1}, {21331, -1, -1, -1}, {26700, -1, -1, -1}, {29730, -1, -1, -1}, {33537, -1, -1, -1}, {37196, -1, -1, -1}, {21828, -1, -1, -1}, {30528, -1, -1, -1}, {28796, -1, -1, -1}, {27978, -1, -1, -1}, {20857, -1, -1, -1}, {21672, -1, -1, -1}, {36164, -1, -1, -1}, {23039, -1, -1, -1}, {28363, -1, -1, -1}, {28100, -1, -1, -1}, {23388, -1, -1, -1}, {32043, -1, -1, -1}, {20180, -1, -1, -1}, {31869, -1, -1, -1}, {28371, -1, -1, -1}, {12070, 23376, -1, -1}, {12163, 33258, -1, -1}, {28173, -1, -1, -1}, {23383, -1, -1, -1}, {39683, -1, -1, -1}, {26837, -1, -1, -1}, {36394, -1, -1, -1}, {23447, -1, -1, -1}, {32508, -1, -1, -1}, {24635, -1, -1, -1}, {32437, -1, -1, -1}, {37049, -1, -1, -1}, {12187, 36208, -1, -1}, {22863, -1, -1, -1}, {25549, -1, -1, -1}, {31199, -1, -1, -1}, {12188, 36275, -1, -1}, {21330, -1, -1, -1}, {26063, -1, -1, -1}, {31062, -1, -1, -1}, {35781, -1, -1, -1}, {38459, -1, -1, -1}, {32452, -1, -1, -1}, {38075, -1, -1, -1}, {32386, -1, -1, -1}, {22068, -1, -1, -1}, {37257, -1, -1, -1}, {26368, -1, -1, -1}, {32618, -1, -1, -1}, {23562, -1, -1, -1}, {36981, -1, -1, -1}, {26152, -1, -1, -1}, {24038, -1, -1, -1}, {20304, -1, -1, -1}, {26590, -1, -1, -1}, {20570, -1, -1, -1}, {20316, -1, -1, -1}, {22352, -1, -1, -1}, {24231, -1, -1, -1}, {20109, -1, -1, -1}, {19980, -1, -1, -1}, {20800, -1, -1, -1}, {19984, -1, -1, -1}, {24319, -1, -1, -1}, {21317, -1, -1, -1}, {19989, -1, -1, -1}, {20120, -1, -1, -1}, {19998, -1, -1, -1}, {12224, 39730, -1, -1}, {23404, -1, -1, -1}, {22121, -1, -1, -1}, {12033, 20008, -1, -1}, {31162, -1, -1, -1}, {12035, 20031, -1, -1}, {12052, 21269, -1, -1}, {20039, -1, -1, -1}, {22829, -1, -1, -1}, {12120, 29243, -1, -1}, {21358, -1, -1, -1}, {27664, -1, -1, -1}, {22239, -1, -1, -1}, {32996, -1, -1, -1}, {39319, -1, -1, -1}, {27603, -1, -1, -1}, {30590, -1, -1, -1}, {40727, -1, -1, -1}, {12034, 20022, -1, -1}, {20127, -1, -1, -1}, {40720, -1, -1, -1}, {20060, -1, -1, -1}, {20073, -1, -1, -1}, {20115, -1, -1, -1}, {33416, -1, -1, -1}, {23387, -1, -1, -1}, {21868, -1, -1, -1}, {22031, -1, -1, -1}, {20164, -1, -1, -1}, {21389, -1, -1, -1}, {21405, -1, -1, -1}, {21411, -1, -1, -1}, {21413, -1, -1, -1}, {21422, -1, -1, -1}, {38757, -1, -1, -1}, {36189, -1, -1, -1}, {12053, 21274, -1, -1}, {21493, -1, -1, -1}, {21286, -1, -1, -1}, {21294, -1, -1, -1}, {21310, -1, -1, -1}, {36188, -1, -1, -1}, {21350, -1, -1, -1}, {21347, -1, -1, -1}, {20994, -1, -1, -1}, {21000, -1, -1, -1}, {21006, -1, -1, -1}, {21037, -1, -1, -1}, {21043, -1, -1, -1}, {21055, -1, -1, -1}, {21056, -1, -1, -1}, {21068, -1, -1, -1}, {21086, -1, -1, -1}, {21089, -1, -1, -1}, {21084, -1, -1, -1}, {33967, -1, -1, -1}, {21117, -1, -1, -1}, {21122, -1, -1, -1}, {21121, -1, -1, -1}, {21136, -1, -1, -1}, {21139, -1, -1, -1}, {12044, 20866, -1, -1}, {32596, -1, -1, -1}, {20155, -1, -1, -1}, {20163, -1, -1, -1}, {20169, -1, -1, -1}, {20162, -1, -1, -1}, {20200, -1, -1, -1}, {20193, -1, -1, -1}, {20203, -1, -1, -1}, {20190, -1, -1, -1}, {20251, -1, -1, -1}, {20211, -1, -1, -1}, {20258, -1, -1, -1}, {20324, -1, -1, -1}, {20213, -1, -1, -1}, {20261, -1, -1, -1}, {20263, -1, -1, -1}, {20233, -1, -1, -1}, {20267, -1, -1, -1}, {20318, -1, -1, -1}, {20327, -1, -1, -1}, {25912, -1, -1, -1}, {20314, -1, -1, -1}, {20317, -1, -1, -1}, {20319, -1, -1, -1}, {20311, -1, -1, -1}, {20274, -1, -1, -1}, {20285, -1, -1, -1}, {20342, -1, -1, -1}, {20340, -1, -1, -1}, {20369, -1, -1, -1}, {20361, -1, -1, -1}, {20355, -1, -1, -1}, {20367, -1, -1, -1}, {20350, -1, -1, -1}, {20347, -1, -1, -1}, {20394, -1, -1, -1}, {20348, -1, -1, -1}, {20396, -1, -1, -1}, {20372, -1, -1, -1}, {20454, -1, -1, -1}, {20456, -1, -1, -1}, {20458, -1, -1, -1}, {20421, -1, -1, -1}, {20442, -1, -1, -1}, {20451, -1, -1, -1}, {20444, -1, -1, -1}, {20433, -1, -1, -1}, {20447, -1, -1, -1}, {20472, -1, -1, -1}, {20521, -1, -1, -1}, {20556, -1, -1, -1}, {20467, -1, -1, -1}, {20524, -1, -1, -1}, {20495, -1, -1, -1}, {20526, -1, -1, -1}, {20525, -1, -1, -1}, {20478, -1, -1, -1}, {20508, -1, -1, -1}, {20492, -1, -1, -1}, {20517, -1, -1, -1}, {20520, -1, -1, -1}, {20606, -1, -1, -1}, {20547, -1, -1, -1}, {20565, -1, -1, -1}, {20552, -1, -1, -1}, {20558, -1, -1, -1}, {20588, -1, -1, -1}, {20603, -1, -1, -1}, {20645, -1, -1, -1}, {20647, -1, -1, -1}, {20649, -1, -1, -1}, {20666, -1, -1, -1}, {20694, -1, -1, -1}, {20742, -1, -1, -1}, {20717, -1, -1, -1}, {20716, -1, -1, -1}, {20710, -1, -1, -1}, {20718, -1, -1, -1}, {20743, -1, -1, -1}, {20747, -1, -1, -1}, {20189, -1, -1, -1}, {27709, -1, -1, -1}, {20312, -1, -1, -1}, {20325, -1, -1, -1}, {20430, -1, -1, -1}, {12245, 40864, -1, -1}, {27718, -1, -1, -1}, {31860, -1, -1, -1}, {20846, -1, -1, -1}, {24061, -1, -1, -1}, {40649, -1, -1, -1}, {39320, -1, -1, -1}, {20865, -1, -1, -1}, {22804, -1, -1, -1}, {12051, 21241, -1, -1}, {21261, -1, -1, -1}, {35335, -1, -1, -1}, {21264, -1, -1, -1} },
    {{20971, -1, -1, -1}, {22809, -1, -1, -1}, {20821, -1, -1, -1}, {12039, 20128, -1, -1}, {20822, -1, -1, -1}, {20147, -1, -1, -1}, {34926, -1, -1, -1}, {34980, -1, -1, -1}, {20149, -1, -1, -1}, {33044, -1, -1, -1}, {35026, -1, -1, -1}, {31104, -1, -1, -1}, {23348, -1, -1, -1}, {34819, -1, -1, -1}, {32696, -1, -1, -1}, {12046, 20907, -1, -1}, {20913, -1, -1, -1}, {20925, -1, -1, -1}, {20924, -1, -1, -1}, {20935, -1, -1, -1}, {12045, 20886, -1, -1}, {20898, -1, -1, -1}, {20901, -1, -1, -1}, {35744, -1, -1, -1}, {35750, -1, -1, -1}, {35751, -1, -1, -1}, {35754, -1, -1, -1}, {35764, -1, -1, -1}, {35765, -1, -1, -1}, {35767, -1, -1, -1}, {35778, -1, -1, -1}, {35779, -1, -1, -1}, {35787, -1, -1, -1}, {35791, -1, -1, -1}, {35790, -1, -1, -1}, {35794, -1, -1, -1}, {35795, -1, -1, -1}, {35796, -1, -1, -1}, {35798, -1, -1, -1}, {35800, -1, -1, -1}, {35801, -1, -1, -1}, {35804, -1, -1, -1}, {35807, -1, -1, -1}, {35808, -1, -1, -1}, {35812, -1, -1, -1}, {35816, -1, -1, -1}, {35817, -1, -1, -1}, {35822, -1, -1, -1}, {35824, -1, -1, -1}, {35827, -1, -1, -1}, {35830, -1, -1, -1}, {35833, -1, -1, -1}, {35836, -1, -1, -1}, {35839, -1, -1, -1}, {35840, -1, -1, -1}, {35842, -1, -1, -1}, {35844, -1, -1, -1}, {35847, -1, -1, -1}, {35852, -1, -1, -1}, {35855, -1, -1, -1}, {35857, -1, -1, -1}, {35858, -1, -1, -1}, {35860, -1, -1, -1}, {35861, -1, -1, -1}, {35862, -1, -1, -1}, {35865, -1, -1, -1}, {35867, -1, -1, -1}, {35864, -1, -1, -1}, {35869, -1, -1, -1}, {35871, -1, -1, -1}, {35872, -1, -1, -1}, {35873, -1, -1, -1}, {35877, -1, -1, -1}, {35879, -1, -1, -1}, {35882, -1, -1, -1}, {35883, -1, -1, -1}, {35886, -1, -1, -1}, {35887, -1, -1, -1}, {35890, -1, -1, -1}, {35891, -1, -1, -1}, {35893, -1, -1, -1}, {35894, -1, -1, -1}, {12057, 21353, -1, -1}, {21370, -1, -1, -1}, {38429, -1, -1, -1}, {38434, -1, -1, -1}, {38433, -1, -1, -1}, {38449, -1, -1, -1}, {38442, -1, -1, -1}, {38461, -1, -1, -1}, {38460, -1, -1, -1}, {38466, -1, -1, -1}, {38473, -1, -1, -1}, {38484, -1, -1, -1}, {38495, -1, -1, -1}, {38503, -1, -1, -1}, {38508, -1, -1, -1}, {38514, -1, -1, -1}, {38516, -1, -1, -1}, {38536, -1, -1, -1}, {38541, -1, -1, -1}, {38551, -1, -1, -1}, {38576, -1, -1, -1}, {37015, -1, -1, -1}, {37019, -1, -1, -1}, {37021, -1, -1, -1}, {37017, -1, -1, -1}, {37036, -1, -1, -1}, {37025, -1, -1, -1}, {37044, -1, -1, -1}, {37043, -1, -1, -1}, {37046, -1, -1, -1}, {37050, -1, -1, -1}, {37048, -1, -1, -1}, {37040, -1, -1, -1}, {37071, -1, -1, -1}, {37061, -1, -1, -1}, {37054, -1, -1, -1}, {37072, -1, -1, -1}, {37060, -1, -1, -1}, {37063, -1, -1, -1}, {37075, -1, -1, -1}, {37094, -1, -1, -1}, {37090, -1, -1, -1}, {37084, -1, -1, -1}, {37079, -1, -1, -1}, {37083, -1, -1, -1}, {37099, -1, -1, -1}, {37103, -1, -1, -1}, {37118, -1, -1, -1}, {37124, -1, -1, -1}, {37154, -1, -1, -1}, {37150, -1, -1, -1}, {37155, -1, -1, -1}, {37169, -1, -1, -1}, {37167, -1, -1, -1}, {37177, -1, -1, -1}, {37187, -1, -1, -1}, {37190, -1, -1, -1}, {21005, -1, -1, -1}, {22850, -1, -1, -1}, {21154, -1, -1, -1}, {21164, -1, -1, -1}, {21165, -1, -1, -1}, {21182, -1, -1, -1}, {21759, -1, -1, -1}, {21200, -1, -1, -1}, {21206, -1, -1, -1}, {21232, -1, -1, -1}, {21471, -1, -1, -1}, {29166, -1, -1, -1}, {30669, -1, -1, -1}, {12085, 24308, -1, -1}, {12048, 20981, -1, -1}, {20988, -1, -1, -1}, {12223, 39727, -1, -1}, {12059, 21430, -1, -1}, {24321, -1, -1, -1}, {30042, -1, -1, -1}, {24047, -1, -1, -1}, {22348, -1, -1, -1}, {22441, -1, -1, -1}, {22433, -1, -1, -1}, {22654, -1, -1, -1}, {22716, -1, -1, -1}, {22725, -1, -1, -1}, {22737, -1, -1, -1}, {22313, -1, -1, -1}, {22316, -1, -1, -1}, {22314, -1, -1, -1}, {22323, -1, -1, -1}, {22329, -1, -1, -1}, {22318, -1, -1, -1}, {22319, -1, -1, -1}, {22364, -1, -1, -1}, {22331, -1, -1, -1}, {22338, -1, -1, -1}, {22377, -1, -1, -1}, {22405, -1, -1, -1}, {22379, -1, -1, -1}, {22406, -1, -1, -1}, {22396, -1, -1, -1}, {22395, -1, -1, -1}, {22376, -1, -1, -1}, {22381, -1, -1, -1}, {22390, -1, -1, -1}, {22387, -1, -1, -1}, {22445, -1, -1, -1}, {22436, -1, -1, -1}, {22412, -1, -1, -1}, {22450, -1, -1, -1}, {22479, -1, -1, -1}, {22439, -1, -1, -1}, {22452, -1, -1, -1}, {22419, -1, -1, -1}, {22432, -1, -1, -1}, {22485, -1, -1, -1}, {22488, -1, -1, -1}, {22490, -1, -1, -1}, {22489, -1, -1, -1}, {22482, -1, -1, -1}, {22456, -1, -1, -1}, {22516, -1, -1, -1}, {22511, -1, -1, -1}, {22520, -1, -1, -1}, {22500, -1, -1, -1}, {22493, -1, -1, -1}, {22539, -1, -1, -1}, {22541, -1, -1, -1}, {22525, -1, -1, -1}, {22509, -1, -1, -1}, {22528, -1, -1, -1}, {22558, -1, -1, -1}, {22553, -1, -1, -1}, {22596, -1, -1, -1}, {22560, -1, -1, -1}, {22629, -1, -1, -1}, {22636, -1, -1, -1}, {22657, -1, -1, -1}, {22665, -1, -1, -1}, {22682, -1, -1, -1}, {22656, -1, -1, -1}, {39336, -1, -1, -1}, {40729, -1, -1, -1}, {25087, -1, -1, -1}, {33401, -1, -1, -1}, {33405, -1, -1, -1}, {33407, -1, -1, -1}, {33423, -1, -1, -1}, {33418, -1, -1, -1}, {33448, -1, -1, -1}, {33412, -1, -1, -1}, {33422, -1, -1, -1}, {33425, -1, -1, -1}, {33431, -1, -1, -1}, {33433, -1, -1, -1}, {33451, -1, -1, -1}, {33464, -1, -1, -1}, {33470, -1, -1, -1}, {33456, -1, -1, -1}, {33480, -1, -1, -1}, {33482, -1, -1, -1}, {33507, -1, -1, -1}, {33432, -1, -1, -1}, {33463, -1, -1, -1}, {33454, -1, -1, -1}, {33483, -1, -1, -1}, {33484, -1, -1, -1}, {33473, -1, -1, -1}, {33449, -1, -1, -1}, {33460, -1, -1, -1}, {33441, -1, -1, -1}, {33450, -1, -1, -1}, {33439, -1, -1, -1}, {33476, -1, -1, -1}, {33486, -1, -1, -1} },
    {{33444, -1, -1, -1}, {33505, -1, -1, -1}, {33545, -1, -1, -1}, {33527, -1, -1, -1}, {33508, -1, -1, -1}, {33551, -1, -1, -1}, {33543, -1, -1, -1}, {33500, -1, -1, -1}, {33524, -1, -1, -1}, {33490, -1, -1, -1}, {33496, -1, -1, -1}, {33548, -1, -1, -1}, {33531, -1, -1, -1}, {33491, -1, -1, -1}, {33553, -1, -1, -1}, {33562, -1, -1, -1}, {33542, -1, -1, -1}, {33556, -1, -1, -1}, {33557, -1, -1, -1}, {33504, -1, -1, -1}, {33493, -1, -1, -1}, {33564, -1, -1, -1}, {33617, -1, -1, -1}, {33627, -1, -1, -1}, {33628, -1, -1, -1}, {33544, -1, -1, -1}, {33682, -1, -1, -1}, {33596, -1, -1, -1}, {33588, -1, -1, -1}, {33585, -1, -1, -1}, {33691, -1, -1, -1}, {33630, -1, -1, -1}, {33583, -1, -1, -1}, {33615, -1, -1, -1}, {33607, -1, -1, -1}, {33603, -1, -1, -1}, {33631, -1, -1, -1}, {33600, -1, -1, -1}, {33559, -1, -1, -1}, {33632, -1, -1, -1}, {33581, -1, -1, -1}, {33594, -1, -1, -1}, {33587, -1, -1, -1}, {33638, -1, -1, -1}, {33637, -1, -1, -1}, {33640, -1, -1, -1}, {33563, -1, -1, -1}, {33641, -1, -1, -1}, {33644, -1, -1, -1}, {33642, -1, -1, -1}, {33645, -1, -1, -1}, {33646, -1, -1, -1}, {33712, -1, -1, -1}, {33656, -1, -1, -1}, {33715, -1, -1, -1}, {33716, -1, -1, -1}, {33696, -1, -1, -1}, {33706, -1, -1, -1}, {33683, -1, -1, -1}, {33692, -1, -1, -1}, {33669, -1, -1, -1}, {33660, -1, -1, -1}, {33718, -1, -1, -1}, {33705, -1, -1, -1}, {33661, -1, -1, -1}, {33720, -1, -1, -1}, {33659, -1, -1, -1}, {33688, -1, -1, -1}, {33694, -1, -1, -1}, {33704, -1, -1, -1}, {33722, -1, -1, -1}, {33724, -1, -1, -1}, {33729, -1, -1, -1}, {33793, -1, -1, -1}, {33765, -1, -1, -1}, {33752, -1, -1, -1}, {22535, -1, -1, -1}, {33816, -1, -1, -1}, {33803, -1, -1, -1}, {33757, -1, -1, -1}, {33789, -1, -1, -1}, {33750, -1, -1, -1}, {33820, -1, -1, -1}, {33848, -1, -1, -1}, {33809, -1, -1, -1}, {33798, -1, -1, -1}, {33748, -1, -1, -1}, {33759, -1, -1, -1}, {33807, -1, -1, -1}, {33795, -1, -1, -1}, {33784, -1, -1, -1}, {33785, -1, -1, -1}, {33770, -1, -1, -1}, {33733, -1, -1, -1}, {33728, -1, -1, -1}, {33830, -1, -1, -1}, {33776, -1, -1, -1}, {33761, -1, -1, -1}, {33884, -1, -1, -1}, {33873, -1, -1, -1}, {33882, -1, -1, -1}, {33881, -1, -1, -1}, {33907, -1, -1, -1}, {33927, -1, -1, -1}, {33928, -1, -1, -1}, {33914, -1, -1, -1}, {33929, -1, -1, -1}, {33912, -1, -1, -1}, {33852, -1, -1, -1}, {33862, -1, -1, -1}, {33897, -1, -1, -1}, {33910, -1, -1, -1}, {33932, -1, -1, -1}, {33934, -1, -1, -1}, {33841, -1, -1, -1}, {33901, -1, -1, -1}, {33985, -1, -1, -1}, {33997, -1, -1, -1}, {34000, -1, -1, -1}, {34022, -1, -1, -1}, {33981, -1, -1, -1}, {34003, -1, -1, -1}, {33994, -1, -1, -1}, {33983, -1, -1, -1}, {33978, -1, -1, -1}, {34016, -1, -1, -1}, {33953, -1, -1, -1}, {33977, -1, -1, -1}, {33972, -1, -1, -1}, {33943, -1, -1, -1}, {34021, -1, -1, -1}, {34019, -1, -1, -1}, {34060, -1, -1, -1}, {29965, -1, -1, -1}, {34104, -1, -1, -1}, {34032, -1, -1, -1}, {34105, -1, -1, -1}, {34079, -1, -1, -1}, {34106, -1, -1, -1}, {34134, -1, -1, -1}, {34107, -1, -1, -1}, {34047, -1, -1, -1}, {34044, -1, -1, -1}, {34137, -1, -1, -1}, {34120, -1, -1, -1}, {34152, -1, -1, -1}, {34148, -1, -1, -1}, {34142, -1, -1, -1}, {34170, -1, -1, -1}, {30626, -1, -1, -1}, {34115, -1, -1, -1}, {34162, -1, -1, -1}, {34171, -1, -1, -1}, {34212, -1, -1, -1}, {34216, -1, -1, -1}, {34183, -1, -1, -1}, {34191, -1, -1, -1}, {34169, -1, -1, -1}, {34222, -1, -1, -1}, {34204, -1, -1, -1}, {34181, -1, -1, -1}, {34233, -1, -1, -1}, {34231, -1, -1, -1}, {34224, -1, -1, -1}, {34259, -1, -1, -1}, {34241, -1, -1, -1}, {34268, -1, -1, -1}, {34303, -1, -1, -1}, {34343, -1, -1, -1}, {34309, -1, -1, -1}, {34345, -1, -1, -1}, {34326, -1, -1, -1}, {34364, -1, -1, -1}, {12086, 24318, -1, -1}, {24328, -1, -1, -1}, {22844, -1, -1, -1}, {22849, -1, -1, -1}, {32823, -1, -1, -1}, {22869, -1, -1, -1}, {22874, -1, -1, -1}, {22872, -1, -1, -1}, {21263, -1, -1, -1}, {12074, 23586, -1, -1}, {23589, -1, -1, -1}, {23596, -1, -1, -1}, {23604, -1, -1, -1}, {25164, -1, -1, -1}, {25194, -1, -1, -1}, {25247, -1, -1, -1}, {25275, -1, -1, -1}, {25290, -1, -1, -1}, {25306, -1, -1, -1}, {25303, -1, -1, -1}, {25326, -1, -1, -1}, {25378, -1, -1, -1}, {25334, -1, -1, -1}, {25401, -1, -1, -1}, {25419, -1, -1, -1}, {25411, -1, -1, -1}, {25517, -1, -1, -1}, {25590, -1, -1, -1}, {25457, -1, -1, -1}, {25466, -1, -1, -1}, {25486, -1, -1, -1}, {25524, -1, -1, -1}, {25453, -1, -1, -1}, {25516, -1, -1, -1}, {25482, -1, -1, -1}, {25449, -1, -1, -1}, {25518, -1, -1, -1}, {25532, -1, -1, -1}, {25586, -1, -1, -1}, {25592, -1, -1, -1}, {25568, -1, -1, -1}, {25599, -1, -1, -1}, {25540, -1, -1, -1}, {25566, -1, -1, -1}, {25550, -1, -1, -1}, {25682, -1, -1, -1}, {25542, -1, -1, -1}, {25534, -1, -1, -1}, {25669, -1, -1, -1}, {25665, -1, -1, -1}, {25611, -1, -1, -1}, {25627, -1, -1, -1}, {25632, -1, -1, -1}, {25612, -1, -1, -1}, {25638, -1, -1, -1}, {25633, -1, -1, -1}, {25694, -1, -1, -1}, {25732, -1, -1, -1}, {25709, -1, -1, -1}, {25750, -1, -1, -1}, {25722, -1, -1, -1}, {25783, -1, -1, -1}, {25784, -1, -1, -1}, {25753, -1, -1, -1}, {25786, -1, -1, -1}, {25792, -1, -1, -1}, {25808, -1, -1, -1}, {25815, -1, -1, -1}, {25828, -1, -1, -1}, {25826, -1, -1, -1}, {25865, -1, -1, -1}, {25893, -1, -1, -1}, {25902, -1, -1, -1}, {12087, 24331, -1, -1}, {24530, -1, -1, -1}, {29977, -1, -1, -1}, {24337, -1, -1, -1}, {21343, -1, -1, -1}, {21489, -1, -1, -1}, {21501, -1, -1, -1}, {21481, -1, -1, -1}, {21480, -1, -1, -1}, {21499, -1, -1, -1} },
    {{21522, -1, -1, -1}, {21526, -1, -1, -1}, {21510, -1, -1, -1}, {21579, -1, -1, -1}, {21586, -1, -1, -1}, {21587, -1, -1, -1}, {21588, -1, -1, -1}, {21590, -1, -1, -1}, {21571, -1, -1, -1}, {21537, -1, -1, -1}, {21591, -1, -1, -1}, {21593, -1, -1, -1}, {21539, -1, -1, -1}, {21554, -1, -1, -1}, {21634, -1, -1, -1}, {21652, -1, -1, -1}, {21623, -1, -1, -1}, {21617, -1, -1, -1}, {21604, -1, -1, -1}, {21658, -1, -1, -1}, {21659, -1, -1, -1}, {21636, -1, -1, -1}, {21622, -1, -1, -1}, {21606, -1, -1, -1}, {21661, -1, -1, -1}, {21712, -1, -1, -1}, {21677, -1, -1, -1}, {21698, -1, -1, -1}, {21684, -1, -1, -1}, {21714, -1, -1, -1}, {21671, -1, -1, -1}, {21670, -1, -1, -1}, {21715, -1, -1, -1}, {21716, -1, -1, -1}, {21618, -1, -1, -1}, {21667, -1, -1, -1}, {21717, -1, -1, -1}, {21691, -1, -1, -1}, {21695, -1, -1, -1}, {21708, -1, -1, -1}, {21721, -1, -1, -1}, {21722, -1, -1, -1}, {21724, -1, -1, -1}, {21673, -1, -1, -1}, {21674, -1, -1, -1}, {21668, -1, -1, -1}, {21725, -1, -1, -1}, {21711, -1, -1, -1}, {21726, -1, -1, -1}, {21787, -1, -1, -1}, {21735, -1, -1, -1}, {21792, -1, -1, -1}, {21757, -1, -1, -1}, {21780, -1, -1, -1}, {21747, -1, -1, -1}, {21794, -1, -1, -1}, {21795, -1, -1, -1}, {21775, -1, -1, -1}, {21777, -1, -1, -1}, {21799, -1, -1, -1}, {21802, -1, -1, -1}, {21863, -1, -1, -1}, {21903, -1, -1, -1}, {21941, -1, -1, -1}, {21833, -1, -1, -1}, {21869, -1, -1, -1}, {21825, -1, -1, -1}, {21845, -1, -1, -1}, {21823, -1, -1, -1}, {21840, -1, -1, -1}, {21820, -1, -1, -1}, {21815, -1, -1, -1}, {21846, -1, -1, -1}, {21877, -1, -1, -1}, {21878, -1, -1, -1}, {21879, -1, -1, -1}, {21811, -1, -1, -1}, {21808, -1, -1, -1}, {21852, -1, -1, -1}, {21899, -1, -1, -1}, {21970, -1, -1, -1}, {21891, -1, -1, -1}, {21937, -1, -1, -1}, {21945, -1, -1, -1}, {21896, -1, -1, -1}, {21889, -1, -1, -1}, {21919, -1, -1, -1}, {21886, -1, -1, -1}, {21974, -1, -1, -1}, {21905, -1, -1, -1}, {21883, -1, -1, -1}, {21983, -1, -1, -1}, {21949, -1, -1, -1}, {21950, -1, -1, -1}, {21908, -1, -1, -1}, {21913, -1, -1, -1}, {21994, -1, -1, -1}, {22007, -1, -1, -1}, {21961, -1, -1, -1}, {22047, -1, -1, -1}, {21969, -1, -1, -1}, {21995, -1, -1, -1}, {21996, -1, -1, -1}, {21972, -1, -1, -1}, {21990, -1, -1, -1}, {21981, -1, -1, -1}, {21956, -1, -1, -1}, {21999, -1, -1, -1}, {21989, -1, -1, -1}, {22002, -1, -1, -1}, {22003, -1, -1, -1}, {21964, -1, -1, -1}, {21965, -1, -1, -1}, {21992, -1, -1, -1}, {22005, -1, -1, -1}, {21988, -1, -1, -1}, {36756, -1, -1, -1}, {22046, -1, -1, -1}, {22024, -1, -1, -1}, {22028, -1, -1, -1}, {22017, -1, -1, -1}, {22052, -1, -1, -1}, {22051, -1, -1, -1}, {22014, -1, -1, -1}, {22016, -1, -1, -1}, {22055, -1, -1, -1}, {22061, -1, -1, -1}, {22104, -1, -1, -1}, {22073, -1, -1, -1}, {22103, -1, -1, -1}, {22060, -1, -1, -1}, {22093, -1, -1, -1}, {22114, -1, -1, -1}, {22105, -1, -1, -1}, {22108, -1, -1, -1}, {22092, -1, -1, -1}, {22100, -1, -1, -1}, {22150, -1, -1, -1}, {22116, -1, -1, -1}, {22129, -1, -1, -1}, {22123, -1, -1, -1}, {22139, -1, -1, -1}, {22140, -1, -1, -1}, {22149, -1, -1, -1}, {22163, -1, -1, -1}, {22191, -1, -1, -1}, {22228, -1, -1, -1}, {12062, 22231, -1, -1}, {22237, -1, -1, -1}, {22241, -1, -1, -1}, {22261, -1, -1, -1}, {22251, -1, -1, -1}, {22265, -1, -1, -1}, {22271, -1, -1, -1}, {22276, -1, -1, -1}, {22282, -1, -1, -1}, {22281, -1, -1, -1}, {22300, -1, -1, -1}, {24079, -1, -1, -1}, {24089, -1, -1, -1}, {24084, -1, -1, -1}, {24081, -1, -1, -1}, {24113, -1, -1, -1}, {24123, -1, -1, -1}, {24124, -1, -1, -1}, {24119, -1, -1, -1}, {24132, -1, -1, -1}, {24148, -1, -1, -1}, {24155, -1, -1, -1}, {24158, -1, -1, -1}, {24161, -1, -1, -1}, {23692, -1, -1, -1}, {23674, -1, -1, -1}, {23693, -1, -1, -1}, {23696, -1, -1, -1}, {23702, -1, -1, -1}, {23688, -1, -1, -1}, {23704, -1, -1, -1}, {23705, -1, -1, -1}, {23697, -1, -1, -1}, {23706, -1, -1, -1}, {23708, -1, -1, -1}, {23733, -1, -1, -1}, {23714, -1, -1, -1}, {23741, -1, -1, -1}, {23724, -1, -1, -1}, {23723, -1, -1, -1}, {23729, -1, -1, -1}, {23715, -1, -1, -1}, {23745, -1, -1, -1}, {23735, -1, -1, -1}, {23748, -1, -1, -1}, {23762, -1, -1, -1}, {23780, -1, -1, -1}, {23755, -1, -1, -1}, {23781, -1, -1, -1}, {23810, -1, -1, -1}, {23811, -1, -1, -1}, {23847, -1, -1, -1}, {23846, -1, -1, -1}, {23854, -1, -1, -1}, {23844, -1, -1, -1}, {23838, -1, -1, -1}, {23814, -1, -1, -1}, {23835, -1, -1, -1}, {23896, -1, -1, -1}, {23870, -1, -1, -1}, {23860, -1, -1, -1}, {23869, -1, -1, -1}, {23916, -1, -1, -1}, {23899, -1, -1, -1}, {23919, -1, -1, -1}, {23901, -1, -1, -1}, {23915, -1, -1, -1}, {23883, -1, -1, -1}, {23882, -1, -1, -1}, {23913, -1, -1, -1}, {23924, -1, -1, -1}, {23938, -1, -1, -1}, {23961, -1, -1, -1}, {23965, -1, -1, -1}, {35955, -1, -1, -1}, {23991, -1, -1, -1}, {24005, -1, -1, -1}, {12091, 24435, -1, -1}, {24439, -1, -1, -1}, {24450, -1, -1, -1}, {24455, -1, -1, -1}, {24457, -1, -1, -1}, {24460, -1, -1, -1}, {24469, -1, -1, -1}, {24473, -1, -1, -1}, {24476, -1, -1, -1}, {24488, -1, -1, -1}, {24493, -1, -1, -1}, {24501, -1, -1, -1}, {24508, -1, -1, -1}, {34914, -1, -1, -1}, {12090, 24417, -1, -1}, {29357, -1, -1, -1}, {29360, -1, -1, -1}, {29364, -1, -1, -1}, {29367, -1, -1, -1}, {29368, -1, -1, -1}, {29379, -1, -1, -1}, {29377, -1, -1, -1}, {29390, -1, -1, -1}, {29389, -1, -1, -1}, {29394, -1, -1, -1}, {29416, -1, -1, -1}, {29423, -1, -1, -1}, {29417, -1, -1, -1}, {29426, -1, -1, -1}, {29428, -1, -1, -1}, {29431, -1, -1, -1}, {29441, -1, -1, -1} },
    {{29427, -1, -1, -1}, {29443, -1, -1, -1}, {29434, -1, -1, -1}, {29435, -1, -1, -1}, {29463, -1, -1, -1}, {29459, -1, -1, -1}, {29473, -1, -1, -1}, {29450, -1, -1, -1}, {29470, -1, -1, -1}, {29469, -1, -1, -1}, {29461, -1, -1, -1}, {29474, -1, -1, -1}, {29497, -1, -1, -1}, {29477, -1, -1, -1}, {29484, -1, -1, -1}, {29496, -1, -1, -1}, {29489, -1, -1, -1}, {29520, -1, -1, -1}, {29517, -1, -1, -1}, {29527, -1, -1, -1}, {29536, -1, -1, -1}, {29548, -1, -1, -1}, {29551, -1, -1, -1}, {29566, -1, -1, -1}, {12167, 33307, -1, -1}, {22821, -1, -1, -1}, {39143, -1, -1, -1}, {22820, -1, -1, -1}, {12065, 22786, -1, -1}, {39267, -1, -1, -1}, {39271, -1, -1, -1}, {39272, -1, -1, -1}, {39273, -1, -1, -1}, {39274, -1, -1, -1}, {39275, -1, -1, -1}, {39276, -1, -1, -1}, {39284, -1, -1, -1}, {39287, -1, -1, -1}, {39293, -1, -1, -1}, {39296, -1, -1, -1}, {39300, -1, -1, -1}, {39303, -1, -1, -1}, {39306, -1, -1, -1}, {39309, -1, -1, -1}, {39312, -1, -1, -1}, {39313, -1, -1, -1}, {39315, -1, -1, -1}, {39316, -1, -1, -1}, {39317, -1, -1, -1}, {24192, -1, -1, -1}, {24209, -1, -1, -1}, {24203, -1, -1, -1}, {24214, -1, -1, -1}, {24229, -1, -1, -1}, {24224, -1, -1, -1}, {24249, -1, -1, -1}, {24245, -1, -1, -1}, {24254, -1, -1, -1}, {24243, -1, -1, -1}, {36179, -1, -1, -1}, {24274, -1, -1, -1}, {24273, -1, -1, -1}, {24283, -1, -1, -1}, {24296, -1, -1, -1}, {24298, -1, -1, -1}, {33210, -1, -1, -1}, {24516, -1, -1, -1}, {24521, -1, -1, -1}, {24534, -1, -1, -1}, {24527, -1, -1, -1}, {24579, -1, -1, -1}, {24558, -1, -1, -1}, {24580, -1, -1, -1}, {24545, -1, -1, -1}, {24548, -1, -1, -1}, {24574, -1, -1, -1}, {24581, -1, -1, -1}, {24582, -1, -1, -1}, {24554, -1, -1, -1}, {24557, -1, -1, -1}, {24568, -1, -1, -1}, {24601, -1, -1, -1}, {24629, -1, -1, -1}, {24614, -1, -1, -1}, {24603, -1, -1, -1}, {24591, -1, -1, -1}, {24589, -1, -1, -1}, {24617, -1, -1, -1}, {24619, -1, -1, -1}, {24586, -1, -1, -1}, {24639, -1, -1, -1}, {24609, -1, -1, -1}, {24696, -1, -1, -1}, {24697, -1, -1, -1}, {24699, -1, -1, -1}, {24698, -1, -1, -1}, {24642, -1, -1, -1}, {24682, -1, -1, -1}, {24701, -1, -1, -1}, {24726, -1, -1, -1}, {24730, -1, -1, -1}, {24749, -1, -1, -1}, {24733, -1, -1, -1}, {24707, -1, -1, -1}, {24722, -1, -1, -1}, {24716, -1, -1, -1}, {24731, -1, -1, -1}, {24812, -1, -1, -1}, {24763, -1, -1, -1}, {24753, -1, -1, -1}, {24797, -1, -1, -1}, {24792, -1, -1, -1}, {24774, -1, -1, -1}, {24794, -1, -1, -1}, {24756, -1, -1, -1}, {24864, -1, -1, -1}, {24870, -1, -1, -1}, {24853, -1, -1, -1}, {24867, -1, -1, -1}, {24820, -1, -1, -1}, {24832, -1, -1, -1}, {24846, -1, -1, -1}, {24875, -1, -1, -1}, {24906, -1, -1, -1}, {24949, -1, -1, -1}, {25004, -1, -1, -1}, {24980, -1, -1, -1}, {24999, -1, -1, -1}, {25015, -1, -1, -1}, {25044, -1, -1, -1}, {25077, -1, -1, -1}, {24541, -1, -1, -1}, {38579, -1, -1, -1}, {38377, -1, -1, -1}, {38379, -1, -1, -1}, {38385, -1, -1, -1}, {38387, -1, -1, -1}, {38389, -1, -1, -1}, {38390, -1, -1, -1}, {38396, -1, -1, -1}, {38398, -1, -1, -1}, {38403, -1, -1, -1}, {38404, -1, -1, -1}, {38406, -1, -1, -1}, {38408, -1, -1, -1}, {38410, -1, -1, -1}, {38411, -1, -1, -1}, {38412, -1, -1, -1}, {38413, -1, -1, -1}, {38415, -1, -1, -1}, {38418, -1, -1, -1}, {38421, -1, -1, -1}, {38422, -1, -1, -1}, {38423, -1, -1, -1}, {38425, -1, -1, -1}, {38426, -1, -1, -1}, {20012, -1, -1, -1}, {12121, 29247, -1, -1}, {25109, -1, -1, -1}, {27701, -1, -1, -1}, {27732, -1, -1, -1}, {27740, -1, -1, -1}, {27722, -1, -1, -1}, {27811, -1, -1, -1}, {27781, -1, -1, -1}, {27792, -1, -1, -1}, {27796, -1, -1, -1}, {27788, -1, -1, -1}, {27752, -1, -1, -1}, {27753, -1, -1, -1}, {27764, -1, -1, -1}, {27766, -1, -1, -1}, {27782, -1, -1, -1}, {27817, -1, -1, -1}, {27856, -1, -1, -1}, {27860, -1, -1, -1}, {27821, -1, -1, -1}, {27895, -1, -1, -1}, {27896, -1, -1, -1}, {27889, -1, -1, -1}, {27863, -1, -1, -1}, {27826, -1, -1, -1}, {27872, -1, -1, -1}, {27862, -1, -1, -1}, {27898, -1, -1, -1}, {27883, -1, -1, -1}, {27886, -1, -1, -1}, {27825, -1, -1, -1}, {27859, -1, -1, -1}, {27887, -1, -1, -1}, {27902, -1, -1, -1}, {27961, -1, -1, -1}, {27943, -1, -1, -1}, {27916, -1, -1, -1}, {27971, -1, -1, -1}, {27976, -1, -1, -1}, {27911, -1, -1, -1}, {27908, -1, -1, -1}, {27929, -1, -1, -1}, {27918, -1, -1, -1}, {27947, -1, -1, -1}, {27981, -1, -1, -1}, {27950, -1, -1, -1}, {27957, -1, -1, -1}, {27930, -1, -1, -1}, {27983, -1, -1, -1}, {27986, -1, -1, -1}, {27988, -1, -1, -1}, {27955, -1, -1, -1}, {28049, -1, -1, -1}, {28015, -1, -1, -1}, {28062, -1, -1, -1}, {28064, -1, -1, -1}, {27998, -1, -1, -1}, {28051, -1, -1, -1}, {28052, -1, -1, -1}, {27996, -1, -1, -1}, {28000, -1, -1, -1}, {28028, -1, -1, -1}, {28003, -1, -1, -1}, {28186, -1, -1, -1}, {28103, -1, -1, -1}, {28101, -1, -1, -1}, {28126, -1, -1, -1}, {28174, -1, -1, -1}, {28095, -1, -1, -1}, {28128, -1, -1, -1}, {28177, -1, -1, -1}, {28134, -1, -1, -1}, {28125, -1, -1, -1}, {28121, -1, -1, -1}, {28182, -1, -1, -1}, {28075, -1, -1, -1}, {28172, -1, -1, -1}, {28078, -1, -1, -1}, {28203, -1, -1, -1}, {28270, -1, -1, -1}, {28238, -1, -1, -1}, {28267, -1, -1, -1}, {28338, -1, -1, -1}, {28255, -1, -1, -1}, {28294, -1, -1, -1}, {28243, -1, -1, -1}, {28244, -1, -1, -1}, {28210, -1, -1, -1}, {28197, -1, -1, -1}, {28228, -1, -1, -1}, {28383, -1, -1, -1}, {28337, -1, -1, -1}, {28312, -1, -1, -1}, {28384, -1, -1, -1}, {28461, -1, -1, -1}, {28386, -1, -1, -1}, {28325, -1, -1, -1}, {28327, -1, -1, -1}, {28349, -1, -1, -1} },
    {{28347, -1, -1, -1}, {28343, -1, -1, -1}, {28375, -1, -1, -1}, {28340, -1, -1, -1}, {28367, -1, -1, -1}, {28303, -1, -1, -1}, {28354, -1, -1, -1}, {28319, -1, -1, -1}, {28514, -1, -1, -1}, {28486, -1, -1, -1}, {28487, -1, -1, -1}, {28452, -1, -1, -1}, {28437, -1, -1, -1}, {28409, -1, -1, -1}, {28463, -1, -1, -1}, {28470, -1, -1, -1}, {28491, -1, -1, -1}, {28532, -1, -1, -1}, {28458, -1, -1, -1}, {28425, -1, -1, -1}, {28457, -1, -1, -1}, {28553, -1, -1, -1}, {28557, -1, -1, -1}, {28556, -1, -1, -1}, {28536, -1, -1, -1}, {28530, -1, -1, -1}, {28540, -1, -1, -1}, {28538, -1, -1, -1}, {28625, -1, -1, -1}, {28617, -1, -1, -1}, {28583, -1, -1, -1}, {28601, -1, -1, -1}, {28598, -1, -1, -1}, {28610, -1, -1, -1}, {28641, -1, -1, -1}, {28654, -1, -1, -1}, {28638, -1, -1, -1}, {28640, -1, -1, -1}, {28655, -1, -1, -1}, {28698, -1, -1, -1}, {28707, -1, -1, -1}, {28699, -1, -1, -1}, {28729, -1, -1, -1}, {28725, -1, -1, -1}, {28751, -1, -1, -1}, {28766, -1, -1, -1}, {12071, 23424, -1, -1}, {23428, -1, -1, -1}, {23445, -1, -1, -1}, {23443, -1, -1, -1}, {23461, -1, -1, -1}, {23480, -1, -1, -1}, {29999, -1, -1, -1}, {39582, -1, -1, -1}, {25652, -1, -1, -1}, {23524, -1, -1, -1}, {23534, -1, -1, -1}, {35120, -1, -1, -1}, {23536, -1, -1, -1}, {36423, -1, -1, -1}, {35591, -1, -1, -1}, {36790, -1, -1, -1}, {36819, -1, -1, -1}, {36821, -1, -1, -1}, {36837, -1, -1, -1}, {36846, -1, -1, -1}, {36836, -1, -1, -1}, {36841, -1, -1, -1}, {36838, -1, -1, -1}, {36851, -1, -1, -1}, {36840, -1, -1, -1}, {36869, -1, -1, -1}, {36868, -1, -1, -1}, {36875, -1, -1, -1}, {36902, -1, -1, -1}, {36881, -1, -1, -1}, {36877, -1, -1, -1}, {36886, -1, -1, -1}, {36897, -1, -1, -1}, {36917, -1, -1, -1}, {36918, -1, -1, -1}, {36909, -1, -1, -1}, {36911, -1, -1, -1}, {36932, -1, -1, -1}, {36945, -1, -1, -1}, {36946, -1, -1, -1}, {36944, -1, -1, -1}, {36968, -1, -1, -1}, {36952, -1, -1, -1}, {36962, -1, -1, -1}, {36955, -1, -1, -1}, {26297, -1, -1, -1}, {36980, -1, -1, -1}, {36989, -1, -1, -1}, {36994, -1, -1, -1}, {37000, -1, -1, -1}, {36995, -1, -1, -1}, {37003, -1, -1, -1}, {12089, 24400, -1, -1}, {24407, -1, -1, -1}, {24406, -1, -1, -1}, {24408, -1, -1, -1}, {23611, -1, -1, -1}, {21675, -1, -1, -1}, {23632, -1, -1, -1}, {23641, -1, -1, -1}, {23409, -1, -1, -1}, {23651, -1, -1, -1}, {23654, -1, -1, -1}, {32700, -1, -1, -1}, {24362, -1, -1, -1}, {24361, -1, -1, -1}, {24365, -1, -1, -1}, {33396, -1, -1, -1}, {24380, -1, -1, -1}, {39739, -1, -1, -1}, {12076, 23662, -1, -1}, {22913, -1, -1, -1}, {22915, -1, -1, -1}, {22925, -1, -1, -1}, {22953, -1, -1, -1}, {22954, -1, -1, -1}, {22947, -1, -1, -1}, {22935, -1, -1, -1}, {22986, -1, -1, -1}, {22955, -1, -1, -1}, {22942, -1, -1, -1}, {22948, -1, -1, -1}, {22994, -1, -1, -1}, {22962, -1, -1, -1}, {22959, -1, -1, -1}, {22999, -1, -1, -1}, {22974, -1, -1, -1}, {23045, -1, -1, -1}, {23046, -1, -1, -1}, {23005, -1, -1, -1}, {23048, -1, -1, -1}, {23011, -1, -1, -1}, {23000, -1, -1, -1}, {23033, -1, -1, -1}, {23052, -1, -1, -1}, {23049, -1, -1, -1}, {23090, -1, -1, -1}, {23092, -1, -1, -1}, {23057, -1, -1, -1}, {23075, -1, -1, -1}, {23059, -1, -1, -1}, {23104, -1, -1, -1}, {23143, -1, -1, -1}, {23114, -1, -1, -1}, {23125, -1, -1, -1}, {23100, -1, -1, -1}, {23138, -1, -1, -1}, {23157, -1, -1, -1}, {33004, -1, -1, -1}, {23210, -1, -1, -1}, {23195, -1, -1, -1}, {23159, -1, -1, -1}, {23162, -1, -1, -1}, {23230, -1, -1, -1}, {23275, -1, -1, -1}, {23218, -1, -1, -1}, {23250, -1, -1, -1}, {23252, -1, -1, -1}, {23224, -1, -1, -1}, {23264, -1, -1, -1}, {23267, -1, -1, -1}, {23281, -1, -1, -1}, {23254, -1, -1, -1}, {23270, -1, -1, -1}, {23256, -1, -1, -1}, {23260, -1, -1, -1}, {23305, -1, -1, -1}, {23319, -1, -1, -1}, {23318, -1, -1, -1}, {23346, -1, -1, -1}, {23351, -1, -1, -1}, {23360, -1, -1, -1}, {23573, -1, -1, -1}, {23580, -1, -1, -1}, {23386, -1, -1, -1}, {23397, -1, -1, -1}, {23411, -1, -1, -1}, {23377, -1, -1, -1}, {23379, -1, -1, -1}, {23394, -1, -1, -1}, {39541, -1, -1, -1}, {39543, -1, -1, -1}, {39544, -1, -1, -1}, {39546, -1, -1, -1}, {39551, -1, -1, -1}, {39549, -1, -1, -1}, {39552, -1, -1, -1}, {39553, -1, -1, -1}, {39557, -1, -1, -1}, {39560, -1, -1, -1}, {39562, -1, -1, -1}, {39568, -1, -1, -1}, {39570, -1, -1, -1}, {39571, -1, -1, -1}, {39574, -1, -1, -1}, {39576, -1, -1, -1}, {39579, -1, -1, -1}, {39580, -1, -1, -1}, {39581, -1, -1, -1}, {39583, -1, -1, -1}, {39584, -1, -1, -1}, {39586, -1, -1, -1}, {39587, -1, -1, -1}, {39589, -1, -1, -1}, {39591, -1, -1, -1}, {32415, -1, -1, -1}, {32417, -1, -1, -1}, {32419, -1, -1, -1}, {32421, -1, -1, -1}, {32424, -1, -1, -1}, {32425, -1, -1, -1}, {32429, -1, -1, -1}, {32432, -1, -1, -1}, {32446, -1, -1, -1}, {32448, -1, -1, -1}, {32449, -1, -1, -1}, {32450, -1, -1, -1}, {32457, -1, -1, -1}, {32459, -1, -1, -1}, {32460, -1, -1, -1}, {32464, -1, -1, -1}, {32468, -1, -1, -1}, {32471, -1, -1, -1}, {32475, -1, -1, -1}, {32480, -1, -1, -1}, {32481, -1, -1, -1}, {32488, -1, -1, -1}, {32491, -1, -1, -1}, {32494, -1, -1, -1}, {32495, -1, -1, -1}, {32497, -1, -1, -1}, {32498, -1, -1, -1}, {32525, -1, -1, -1}, {32502, -1, -1, -1}, {32506, -1, -1, -1}, {32507, -1, -1, -1}, {32510, -1, -1, -1}, {32513, -1, -1, -1}, {32514, -1, -1, -1}, {32515, -1, -1, -1}, {32519, -1, -1, -1}, {32520, -1, -1, -1}, {32523, -1, -1, -1}, {32524, -1, -1, -1}, {32527, -1, -1, -1}, {32529, -1, -1, -1}, {32530, -1, -1, -1}, {32535, -1, -1, -1}, {32537, -1, -1, -1}, {32540, -1, -1, -1} },
    {{32539, -1, -1, -1}, {32543, -1, -1, -1}, {32545, -1, -1, -1}, {32546, -1, -1, -1}, {32547, -1, -1, -1}, {32548, -1, -1, -1}, {32549, -1, -1, -1}, {32550, -1, -1, -1}, {32551, -1, -1, -1}, {32554, -1, -1, -1}, {32555, -1, -1, -1}, {32556, -1, -1, -1}, {32557, -1, -1, -1}, {32559, -1, -1, -1}, {32560, -1, -1, -1}, {32561, -1, -1, -1}, {32562, -1, -1, -1}, {32563, -1, -1, -1}, {32565, -1, -1, -1}, {12083, 24186, -1, -1}, {30079, -1, -1, -1}, {12078, 24027, -1, -1}, {30014, -1, -1, -1}, {37013, -1, -1, -1}, {29582, -1, -1, -1}, {29585, -1, -1, -1}, {29614, -1, -1, -1}, {29602, -1, -1, -1}, {29599, -1, -1, -1}, {29647, -1, -1, -1}, {29634, -1, -1, -1}, {29649, -1, -1, -1}, {29623, -1, -1, -1}, {29619, -1, -1, -1}, {29632, -1, -1, -1}, {29641, -1, -1, -1}, {29640, -1, -1, -1}, {29669, -1, -1, -1}, {29657, -1, -1, -1}, {39036, -1, -1, -1}, {29706, -1, -1, -1}, {29673, -1, -1, -1}, {29671, -1, -1, -1}, {29662, -1, -1, -1}, {29626, -1, -1, -1}, {29682, -1, -1, -1}, {29711, -1, -1, -1}, {29738, -1, -1, -1}, {29787, -1, -1, -1}, {29734, -1, -1, -1}, {29733, -1, -1, -1}, {29736, -1, -1, -1}, {29744, -1, -1, -1}, {29742, -1, -1, -1}, {29740, -1, -1, -1}, {29723, -1, -1, -1}, {29722, -1, -1, -1}, {29761, -1, -1, -1}, {29788, -1, -1, -1}, {29783, -1, -1, -1}, {29781, -1, -1, -1}, {29785, -1, -1, -1}, {29815, -1, -1, -1}, {29805, -1, -1, -1}, {29822, -1, -1, -1}, {29852, -1, -1, -1}, {29838, -1, -1, -1}, {29824, -1, -1, -1}, {29825, -1, -1, -1}, {29831, -1, -1, -1}, {29835, -1, -1, -1}, {29854, -1, -1, -1}, {29864, -1, -1, -1}, {29865, -1, -1, -1}, {29840, -1, -1, -1}, {29863, -1, -1, -1}, {29906, -1, -1, -1}, {29882, -1, -1, -1}, {38890, -1, -1, -1}, {38891, -1, -1, -1}, {38892, -1, -1, -1}, {26444, -1, -1, -1}, {26451, -1, -1, -1}, {26462, -1, -1, -1}, {26440, -1, -1, -1}, {26473, -1, -1, -1}, {26533, -1, -1, -1}, {26503, -1, -1, -1}, {26474, -1, -1, -1}, {26483, -1, -1, -1}, {26520, -1, -1, -1}, {26535, -1, -1, -1}, {26485, -1, -1, -1}, {26536, -1, -1, -1}, {26526, -1, -1, -1}, {26541, -1, -1, -1}, {26507, -1, -1, -1}, {26487, -1, -1, -1}, {26492, -1, -1, -1}, {26608, -1, -1, -1}, {26633, -1, -1, -1}, {26584, -1, -1, -1}, {26634, -1, -1, -1}, {26601, -1, -1, -1}, {26544, -1, -1, -1}, {26636, -1, -1, -1}, {26585, -1, -1, -1}, {26549, -1, -1, -1}, {26586, -1, -1, -1}, {26547, -1, -1, -1}, {26589, -1, -1, -1}, {26624, -1, -1, -1}, {26563, -1, -1, -1}, {26552, -1, -1, -1}, {26594, -1, -1, -1}, {26638, -1, -1, -1}, {26561, -1, -1, -1}, {26621, -1, -1, -1}, {26674, -1, -1, -1}, {26675, -1, -1, -1}, {26720, -1, -1, -1}, {26721, -1, -1, -1}, {26702, -1, -1, -1}, {26722, -1, -1, -1}, {26692, -1, -1, -1}, {26724, -1, -1, -1}, {26755, -1, -1, -1}, {26653, -1, -1, -1}, {26709, -1, -1, -1}, {26726, -1, -1, -1}, {26689, -1, -1, -1}, {26727, -1, -1, -1}, {26688, -1, -1, -1}, {26686, -1, -1, -1}, {26698, -1, -1, -1}, {26697, -1, -1, -1}, {26665, -1, -1, -1}, {26805, -1, -1, -1}, {26767, -1, -1, -1}, {26740, -1, -1, -1}, {26743, -1, -1, -1}, {26771, -1, -1, -1}, {26731, -1, -1, -1}, {26818, -1, -1, -1}, {26990, -1, -1, -1}, {26876, -1, -1, -1}, {26911, -1, -1, -1}, {26912, -1, -1, -1}, {26873, -1, -1, -1}, {26916, -1, -1, -1}, {26864, -1, -1, -1}, {26891, -1, -1, -1}, {26881, -1, -1, -1}, {26967, -1, -1, -1}, {26851, -1, -1, -1}, {26896, -1, -1, -1}, {26993, -1, -1, -1}, {26937, -1, -1, -1}, {26976, -1, -1, -1}, {26946, -1, -1, -1}, {26973, -1, -1, -1}, {27012, -1, -1, -1}, {26987, -1, -1, -1}, {27008, -1, -1, -1}, {27032, -1, -1, -1}, {27000, -1, -1, -1}, {26932, -1, -1, -1}, {27084, -1, -1, -1}, {27015, -1, -1, -1}, {27016, -1, -1, -1}, {27086, -1, -1, -1}, {27017, -1, -1, -1}, {26982, -1, -1, -1}, {26979, -1, -1, -1}, {27001, -1, -1, -1}, {27035, -1, -1, -1}, {27047, -1, -1, -1}, {27067, -1, -1, -1}, {27051, -1, -1, -1}, {27053, -1, -1, -1}, {27092, -1, -1, -1}, {27057, -1, -1, -1}, {27073, -1, -1, -1}, {27082, -1, -1, -1}, {27103, -1, -1, -1}, {27029, -1, -1, -1}, {27104, -1, -1, -1}, {27021, -1, -1, -1}, {27135, -1, -1, -1}, {27183, -1, -1, -1}, {27117, -1, -1, -1}, {27159, -1, -1, -1}, {27160, -1, -1, -1}, {27237, -1, -1, -1}, {27122, -1, -1, -1}, {27204, -1, -1, -1}, {27198, -1, -1, -1}, {27296, -1, -1, -1}, {27216, -1, -1, -1}, {27227, -1, -1, -1}, {27189, -1, -1, -1}, {27278, -1, -1, -1}, {27257, -1, -1, -1}, {27197, -1, -1, -1}, {27176, -1, -1, -1}, {27224, -1, -1, -1}, {27260, -1, -1, -1}, {27281, -1, -1, -1}, {27280, -1, -1, -1}, {27305, -1, -1, -1}, {27287, -1, -1, -1}, {27307, -1, -1, -1}, {29495, -1, -1, -1}, {29522, -1, -1, -1}, {27521, -1, -1, -1}, {27522, -1, -1, -1}, {27527, -1, -1, -1}, {27524, -1, -1, -1}, {27538, -1, -1, -1}, {27539, -1, -1, -1}, {27533, -1, -1, -1}, {27546, -1, -1, -1}, {27547, -1, -1, -1}, {27553, -1, -1, -1}, {27562, -1, -1, -1}, {36715, -1, -1, -1}, {36717, -1, -1, -1}, {36721, -1, -1, -1}, {36722, -1, -1, -1}, {36723, -1, -1, -1}, {36725, -1, -1, -1}, {36726, -1, -1, -1}, {36728, -1, -1, -1}, {36727, -1, -1, -1}, {36729, -1, -1, -1}, {36730, -1, -1, -1}, {36732, -1, -1, -1}, {36734, -1, -1, -1}, {36737, -1, -1, -1}, {36738, -1, -1, -1}, {36740, -1, -1, -1}, {36743, -1, -1, -1}, {36747, -1, -1, -1}, {36749, -1, -1, -1}, {36750, -1, -1, -1}, {36751, -1, -1, -1}, {36760, -1, -1, -1}, {36762, -1, -1, -1}, {36558, -1, -1, -1}, {25099, -1, -1, -1}, {25111, -1, -1, -1}, {25115, -1, -1, -1}, {25119, -1, -1, -1}, {25122, -1, -1, -1}, {25121, -1, -1, -1}, {25125, -1, -1, -1} },
    {{25124, -1, -1, -1}, {25132, -1, -1, -1}, {33255, -1, -1, -1}, {29935, -1, -1, -1}, {29940, -1, -1, -1}, {29951, -1, -1, -1}, {29967, -1, -1, -1}, {29969, -1, -1, -1}, {29971, -1, -1, -1}, {12097, 25908, -1, -1}, {26094, -1, -1, -1}, {26095, -1, -1, -1}, {26096, -1, -1, -1}, {26122, -1, -1, -1}, {26137, -1, -1, -1}, {26482, -1, -1, -1}, {26115, -1, -1, -1}, {26133, -1, -1, -1}, {26112, -1, -1, -1}, {28805, -1, -1, -1}, {26359, -1, -1, -1}, {26141, -1, -1, -1}, {26164, -1, -1, -1}, {26161, -1, -1, -1}, {26166, -1, -1, -1}, {26165, -1, -1, -1}, {32774, -1, -1, -1}, {26207, -1, -1, -1}, {26196, -1, -1, -1}, {26177, -1, -1, -1}, {26191, -1, -1, -1}, {26198, -1, -1, -1}, {26209, -1, -1, -1}, {26199, -1, -1, -1}, {26231, -1, -1, -1}, {26244, -1, -1, -1}, {26252, -1, -1, -1}, {26279, -1, -1, -1}, {26269, -1, -1, -1}, {26302, -1, -1, -1}, {26331, -1, -1, -1}, {26332, -1, -1, -1}, {26342, -1, -1, -1}, {26345, -1, -1, -1}, {36146, -1, -1, -1}, {36147, -1, -1, -1}, {36150, -1, -1, -1}, {36155, -1, -1, -1}, {36157, -1, -1, -1}, {36160, -1, -1, -1}, {36165, -1, -1, -1}, {36166, -1, -1, -1}, {36168, -1, -1, -1}, {36169, -1, -1, -1}, {36167, -1, -1, -1}, {36173, -1, -1, -1}, {36181, -1, -1, -1}, {36185, -1, -1, -1}, {35271, -1, -1, -1}, {35274, -1, -1, -1}, {35275, -1, -1, -1}, {35276, -1, -1, -1}, {35278, -1, -1, -1}, {35279, -1, -1, -1}, {35280, -1, -1, -1}, {35281, -1, -1, -1}, {29294, -1, -1, -1}, {29343, -1, -1, -1}, {29277, -1, -1, -1}, {29286, -1, -1, -1}, {29295, -1, -1, -1}, {29310, -1, -1, -1}, {29311, -1, -1, -1}, {29316, -1, -1, -1}, {29323, -1, -1, -1}, {29325, -1, -1, -1}, {29327, -1, -1, -1}, {29330, -1, -1, -1}, {25352, -1, -1, -1}, {25394, -1, -1, -1}, {25520, -1, -1, -1}, {25663, -1, -1, -1}, {25816, -1, -1, -1}, {32772, -1, -1, -1}, {27626, -1, -1, -1}, {27635, -1, -1, -1}, {27645, -1, -1, -1}, {27637, -1, -1, -1}, {27641, -1, -1, -1}, {27653, -1, -1, -1}, {27655, -1, -1, -1}, {27654, -1, -1, -1}, {27661, -1, -1, -1}, {27669, -1, -1, -1}, {27672, -1, -1, -1}, {27673, -1, -1, -1}, {27674, -1, -1, -1}, {27681, -1, -1, -1}, {27689, -1, -1, -1}, {27684, -1, -1, -1}, {27690, -1, -1, -1}, {27698, -1, -1, -1}, {25909, -1, -1, -1}, {25941, -1, -1, -1}, {25963, -1, -1, -1}, {29261, -1, -1, -1}, {29266, -1, -1, -1}, {29270, -1, -1, -1}, {29232, -1, -1, -1}, {34402, -1, -1, -1}, {21014, -1, -1, -1}, {32927, -1, -1, -1}, {32924, -1, -1, -1}, {32915, -1, -1, -1}, {32956, -1, -1, -1}, {26378, -1, -1, -1}, {32957, -1, -1, -1}, {32945, -1, -1, -1}, {32939, -1, -1, -1}, {32941, -1, -1, -1}, {32948, -1, -1, -1}, {32951, -1, -1, -1}, {32999, -1, -1, -1}, {33000, -1, -1, -1}, {33001, -1, -1, -1}, {33002, -1, -1, -1}, {32987, -1, -1, -1}, {32962, -1, -1, -1}, {32964, -1, -1, -1}, {32985, -1, -1, -1}, {32973, -1, -1, -1}, {32983, -1, -1, -1}, {26384, -1, -1, -1}, {32989, -1, -1, -1}, {33003, -1, -1, -1}, {33009, -1, -1, -1}, {33012, -1, -1, -1}, {33005, -1, -1, -1}, {33037, -1, -1, -1}, {33038, -1, -1, -1}, {33010, -1, -1, -1}, {33020, -1, -1, -1}, {26389, -1, -1, -1}, {33042, -1, -1, -1}, {35930, -1, -1, -1}, {33078, -1, -1, -1}, {33054, -1, -1, -1}, {33068, -1, -1, -1}, {33048, -1, -1, -1}, {33074, -1, -1, -1}, {33096, -1, -1, -1}, {33100, -1, -1, -1}, {33107, -1, -1, -1}, {33140, -1, -1, -1}, {33113, -1, -1, -1}, {33114, -1, -1, -1}, {33137, -1, -1, -1}, {33120, -1, -1, -1}, {33129, -1, -1, -1}, {33148, -1, -1, -1}, {33149, -1, -1, -1}, {33133, -1, -1, -1}, {33127, -1, -1, -1}, {22605, -1, -1, -1}, {23221, -1, -1, -1}, {33160, -1, -1, -1}, {33154, -1, -1, -1}, {33169, -1, -1, -1}, {28373, -1, -1, -1}, {33187, -1, -1, -1}, {33194, -1, -1, -1}, {33228, -1, -1, -1}, {26406, -1, -1, -1}, {33226, -1, -1, -1}, {33211, -1, -1, -1}, {33217, -1, -1, -1}, {33190, -1, -1, -1}, {27428, -1, -1, -1}, {27447, -1, -1, -1}, {27449, -1, -1, -1}, {27459, -1, -1, -1}, {27462, -1, -1, -1}, {27481, -1, -1, -1}, {39121, -1, -1, -1}, {39122, -1, -1, -1}, {39123, -1, -1, -1}, {39125, -1, -1, -1}, {39129, -1, -1, -1}, {39130, -1, -1, -1}, {12110, 27571, -1, -1}, {24384, -1, -1, -1}, {27586, -1, -1, -1}, {35315, -1, -1, -1}, {26000, -1, -1, -1}, {40785, -1, -1, -1}, {26003, -1, -1, -1}, {26044, -1, -1, -1}, {26054, -1, -1, -1}, {26052, -1, -1, -1}, {26051, -1, -1, -1}, {26060, -1, -1, -1}, {26062, -1, -1, -1}, {26066, -1, -1, -1}, {26070, -1, -1, -1}, {28800, -1, -1, -1}, {28828, -1, -1, -1}, {28822, -1, -1, -1}, {28829, -1, -1, -1}, {28859, -1, -1, -1}, {28864, -1, -1, -1}, {28855, -1, -1, -1}, {28843, -1, -1, -1}, {28849, -1, -1, -1}, {28904, -1, -1, -1}, {28874, -1, -1, -1}, {28944, -1, -1, -1}, {28947, -1, -1, -1}, {28950, -1, -1, -1}, {28975, -1, -1, -1}, {28977, -1, -1, -1}, {29043, -1, -1, -1}, {29020, -1, -1, -1}, {29032, -1, -1, -1}, {28997, -1, -1, -1}, {29042, -1, -1, -1}, {29002, -1, -1, -1}, {29048, -1, -1, -1}, {29050, -1, -1, -1}, {29080, -1, -1, -1}, {29107, -1, -1, -1}, {29109, -1, -1, -1}, {29096, -1, -1, -1}, {29088, -1, -1, -1}, {29152, -1, -1, -1}, {29140, -1, -1, -1}, {29159, -1, -1, -1}, {29177, -1, -1, -1}, {29213, -1, -1, -1}, {29224, -1, -1, -1}, {28780, -1, -1, -1}, {28952, -1, -1, -1}, {29030, -1, -1, -1}, {29113, -1, -1, -1}, {25150, -1, -1, -1}, {25149, -1, -1, -1}, {25155, -1, -1, -1}, {25160, -1, -1, -1}, {25161, -1, -1, -1}, {31035, -1, -1, -1}, {31040, -1, -1, -1}, {31046, -1, -1, -1}, {31049, -1, -1, -1}, {31067, -1, -1, -1}, {31068, -1, -1, -1}, {31059, -1, -1, -1}, {31066, -1, -1, -1} },
    {{31074, -1, -1, -1}, {31063, -1, -1, -1}, {31072, -1, -1, -1}, {31087, -1, -1, -1}, {31079, -1, -1, -1}, {31098, -1, -1, -1}, {31109, -1, -1, -1}, {31114, -1, -1, -1}, {31130, -1, -1, -1}, {31143, -1, -1, -1}, {31155, -1, -1, -1}, {24529, -1, -1, -1}, {24528, -1, -1, -1}, {24636, -1, -1, -1}, {24669, -1, -1, -1}, {24666, -1, -1, -1}, {24679, -1, -1, -1}, {24641, -1, -1, -1}, {24665, -1, -1, -1}, {24675, -1, -1, -1}, {24747, -1, -1, -1}, {24838, -1, -1, -1}, {24845, -1, -1, -1}, {24925, -1, -1, -1}, {25001, -1, -1, -1}, {24989, -1, -1, -1}, {25035, -1, -1, -1}, {25041, -1, -1, -1}, {25094, -1, -1, -1}, {32896, -1, -1, -1}, {12160, 32895, -1, -1}, {27795, -1, -1, -1}, {27894, -1, -1, -1}, {28156, -1, -1, -1}, {30710, -1, -1, -1}, {30712, -1, -1, -1}, {30720, -1, -1, -1}, {30729, -1, -1, -1}, {30743, -1, -1, -1}, {30744, -1, -1, -1}, {30737, -1, -1, -1}, {26027, -1, -1, -1}, {30765, -1, -1, -1}, {30748, -1, -1, -1}, {30749, -1, -1, -1}, {30777, -1, -1, -1}, {30778, -1, -1, -1}, {30779, -1, -1, -1}, {30751, -1, -1, -1}, {30780, -1, -1, -1}, {30757, -1, -1, -1}, {30764, -1, -1, -1}, {30755, -1, -1, -1}, {30761, -1, -1, -1}, {30798, -1, -1, -1}, {30829, -1, -1, -1}, {30806, -1, -1, -1}, {30807, -1, -1, -1}, {30758, -1, -1, -1}, {30800, -1, -1, -1}, {30791, -1, -1, -1}, {30796, -1, -1, -1}, {30826, -1, -1, -1}, {30875, -1, -1, -1}, {30867, -1, -1, -1}, {30874, -1, -1, -1}, {30855, -1, -1, -1}, {30876, -1, -1, -1}, {30881, -1, -1, -1}, {30883, -1, -1, -1}, {30898, -1, -1, -1}, {30905, -1, -1, -1}, {30885, -1, -1, -1}, {30932, -1, -1, -1}, {30937, -1, -1, -1}, {30921, -1, -1, -1}, {30956, -1, -1, -1}, {30962, -1, -1, -1}, {30981, -1, -1, -1}, {30964, -1, -1, -1}, {30995, -1, -1, -1}, {31012, -1, -1, -1}, {31006, -1, -1, -1}, {31028, -1, -1, -1}, {40859, -1, -1, -1}, {12235, 40697, -1, -1}, {40699, -1, -1, -1}, {40700, -1, -1, -1}, {30449, -1, -1, -1}, {30468, -1, -1, -1}, {30477, -1, -1, -1}, {30457, -1, -1, -1}, {30471, -1, -1, -1}, {30472, -1, -1, -1}, {30490, -1, -1, -1}, {30498, -1, -1, -1}, {30489, -1, -1, -1}, {30509, -1, -1, -1}, {30502, -1, -1, -1}, {30517, -1, -1, -1}, {30520, -1, -1, -1}, {30544, -1, -1, -1}, {30545, -1, -1, -1}, {30535, -1, -1, -1}, {30531, -1, -1, -1}, {30554, -1, -1, -1}, {30568, -1, -1, -1}, {30562, -1, -1, -1}, {30565, -1, -1, -1}, {30591, -1, -1, -1}, {30605, -1, -1, -1}, {30589, -1, -1, -1}, {30592, -1, -1, -1}, {30604, -1, -1, -1}, {30609, -1, -1, -1}, {30623, -1, -1, -1}, {30624, -1, -1, -1}, {30640, -1, -1, -1}, {30645, -1, -1, -1}, {30653, -1, -1, -1}, {30010, -1, -1, -1}, {30016, -1, -1, -1}, {30030, -1, -1, -1}, {30027, -1, -1, -1}, {30024, -1, -1, -1}, {30043, -1, -1, -1}, {30066, -1, -1, -1}, {30073, -1, -1, -1}, {30083, -1, -1, -1}, {32600, -1, -1, -1}, {32609, -1, -1, -1}, {32607, -1, -1, -1}, {35400, -1, -1, -1}, {32616, -1, -1, -1}, {32628, -1, -1, -1}, {32625, -1, -1, -1}, {32633, -1, -1, -1}, {32641, -1, -1, -1}, {32638, -1, -1, -1}, {30413, -1, -1, -1}, {30437, -1, -1, -1}, {34866, -1, -1, -1}, {38021, -1, -1, -1}, {38022, -1, -1, -1}, {38023, -1, -1, -1}, {38027, -1, -1, -1}, {38026, -1, -1, -1}, {38028, -1, -1, -1}, {38029, -1, -1, -1}, {38031, -1, -1, -1}, {38032, -1, -1, -1}, {38036, -1, -1, -1}, {38039, -1, -1, -1}, {38037, -1, -1, -1}, {38042, -1, -1, -1}, {38043, -1, -1, -1}, {38044, -1, -1, -1}, {38051, -1, -1, -1}, {38052, -1, -1, -1}, {38059, -1, -1, -1}, {38058, -1, -1, -1}, {38061, -1, -1, -1}, {38060, -1, -1, -1}, {38063, -1, -1, -1}, {38064, -1, -1, -1}, {38066, -1, -1, -1}, {38068, -1, -1, -1}, {38070, -1, -1, -1}, {38071, -1, -1, -1}, {38072, -1, -1, -1}, {38073, -1, -1, -1}, {38074, -1, -1, -1}, {38076, -1, -1, -1}, {38077, -1, -1, -1}, {38079, -1, -1, -1}, {38084, -1, -1, -1}, {38088, -1, -1, -1}, {38089, -1, -1, -1}, {38090, -1, -1, -1}, {38091, -1, -1, -1}, {38092, -1, -1, -1}, {38093, -1, -1, -1}, {38094, -1, -1, -1}, {38096, -1, -1, -1}, {38097, -1, -1, -1}, {38098, -1, -1, -1}, {38101, -1, -1, -1}, {38102, -1, -1, -1}, {38103, -1, -1, -1}, {38105, -1, -1, -1}, {38104, -1, -1, -1}, {38107, -1, -1, -1}, {38110, -1, -1, -1}, {38111, -1, -1, -1}, {38112, -1, -1, -1}, {38114, -1, -1, -1}, {38116, -1, -1, -1}, {38117, -1, -1, -1}, {38119, -1, -1, -1}, {38120, -1, -1, -1}, {38122, -1, -1, -1}, {38121, -1, -1, -1}, {38123, -1, -1, -1}, {38126, -1, -1, -1}, {38127, -1, -1, -1}, {38131, -1, -1, -1}, {38132, -1, -1, -1}, {38133, -1, -1, -1}, {38135, -1, -1, -1}, {38137, -1, -1, -1}, {38140, -1, -1, -1}, {38141, -1, -1, -1}, {38143, -1, -1, -1}, {38147, -1, -1, -1}, {38146, -1, -1, -1}, {38150, -1, -1, -1}, {38151, -1, -1, -1}, {38153, -1, -1, -1}, {38154, -1, -1, -1}, {38157, -1, -1, -1}, {38158, -1, -1, -1}, {38159, -1, -1, -1}, {38162, -1, -1, -1}, {38163, -1, -1, -1}, {38164, -1, -1, -1}, {38165, -1, -1, -1}, {38166, -1, -1, -1}, {38168, -1, -1, -1}, {38171, -1, -1, -1}, {38173, -1, -1, -1}, {38174, -1, -1, -1}, {38175, -1, -1, -1}, {38178, -1, -1, -1}, {38186, -1, -1, -1}, {38187, -1, -1, -1}, {38185, -1, -1, -1}, {38188, -1, -1, -1}, {38193, -1, -1, -1}, {38194, -1, -1, -1}, {38196, -1, -1, -1}, {38198, -1, -1, -1}, {38199, -1, -1, -1}, {38200, -1, -1, -1}, {38204, -1, -1, -1}, {38206, -1, -1, -1}, {38207, -1, -1, -1}, {38210, -1, -1, -1}, {38197, -1, -1, -1}, {38212, -1, -1, -1}, {38213, -1, -1, -1}, {38214, -1, -1, -1}, {38217, -1, -1, -1}, {38220, -1, -1, -1}, {38222, -1, -1, -1}, {38223, -1, -1, -1}, {38226, -1, -1, -1} },
    {{38227, -1, -1, -1}, {38228, -1, -1, -1}, {38230, -1, -1, -1}, {38231, -1, -1, -1}, {38232, -1, -1, -1}, {38233, -1, -1, -1}, {38235, -1, -1, -1}, {38238, -1, -1, -1}, {38239, -1, -1, -1}, {38237, -1, -1, -1}, {38241, -1, -1, -1}, {38242, -1, -1, -1}, {38244, -1, -1, -1}, {38245, -1, -1, -1}, {38246, -1, -1, -1}, {38247, -1, -1, -1}, {38248, -1, -1, -1}, {38249, -1, -1, -1}, {38250, -1, -1, -1}, {38251, -1, -1, -1}, {38252, -1, -1, -1}, {38255, -1, -1, -1}, {38257, -1, -1, -1}, {38258, -1, -1, -1}, {38259, -1, -1, -1}, {38202, -1, -1, -1}, {30695, -1, -1, -1}, {30700, -1, -1, -1}, {38601, -1, -1, -1}, {31189, -1, -1, -1}, {31213, -1, -1, -1}, {31203, -1, -1, -1}, {31211, -1, -1, -1}, {31238, -1, -1, -1}, {23879, -1, -1, -1}, {31235, -1, -1, -1}, {31234, -1, -1, -1}, {31262, -1, -1, -1}, {31252, -1, -1, -1}, {31289, -1, -1, -1}, {31287, -1, -1, -1}, {31313, -1, -1, -1}, {40655, -1, -1, -1}, {39333, -1, -1, -1}, {31344, -1, -1, -1}, {30344, -1, -1, -1}, {30350, -1, -1, -1}, {30355, -1, -1, -1}, {30361, -1, -1, -1}, {30372, -1, -1, -1}, {29918, -1, -1, -1}, {29920, -1, -1, -1}, {29996, -1, -1, -1}, {40480, -1, -1, -1}, {40482, -1, -1, -1}, {40488, -1, -1, -1}, {40489, -1, -1, -1}, {40490, -1, -1, -1}, {40491, -1, -1, -1}, {40492, -1, -1, -1}, {40498, -1, -1, -1}, {40497, -1, -1, -1}, {40502, -1, -1, -1}, {40504, -1, -1, -1}, {40503, -1, -1, -1}, {40505, -1, -1, -1}, {40506, -1, -1, -1}, {40510, -1, -1, -1}, {40513, -1, -1, -1}, {40514, -1, -1, -1}, {40516, -1, -1, -1}, {40518, -1, -1, -1}, {40519, -1, -1, -1}, {40520, -1, -1, -1}, {40521, -1, -1, -1}, {40523, -1, -1, -1}, {40524, -1, -1, -1}, {40526, -1, -1, -1}, {40529, -1, -1, -1}, {40533, -1, -1, -1}, {40535, -1, -1, -1}, {40538, -1, -1, -1}, {40539, -1, -1, -1}, {40540, -1, -1, -1}, {40542, -1, -1, -1}, {40547, -1, -1, -1}, {40550, -1, -1, -1}, {40551, -1, -1, -1}, {40552, -1, -1, -1}, {40553, -1, -1, -1}, {40554, -1, -1, -1}, {40555, -1, -1, -1}, {40556, -1, -1, -1}, {40561, -1, -1, -1}, {40557, -1, -1, -1}, {40563, -1, -1, -1}, {12135, 30098, -1, -1}, {30100, -1, -1, -1}, {30102, -1, -1, -1}, {30112, -1, -1, -1}, {30109, -1, -1, -1}, {30124, -1, -1, -1}, {30115, -1, -1, -1}, {30131, -1, -1, -1}, {30132, -1, -1, -1}, {30136, -1, -1, -1}, {30148, -1, -1, -1}, {30129, -1, -1, -1}, {30128, -1, -1, -1}, {30147, -1, -1, -1}, {30146, -1, -1, -1}, {30166, -1, -1, -1}, {30157, -1, -1, -1}, {30179, -1, -1, -1}, {30184, -1, -1, -1}, {30182, -1, -1, -1}, {30180, -1, -1, -1}, {30187, -1, -1, -1}, {30183, -1, -1, -1}, {30211, -1, -1, -1}, {30193, -1, -1, -1}, {30204, -1, -1, -1}, {30207, -1, -1, -1}, {30224, -1, -1, -1}, {30208, -1, -1, -1}, {30213, -1, -1, -1}, {30220, -1, -1, -1}, {30231, -1, -1, -1}, {30218, -1, -1, -1}, {30245, -1, -1, -1}, {30232, -1, -1, -1}, {30229, -1, -1, -1}, {30233, -1, -1, -1}, {30235, -1, -1, -1}, {30268, -1, -1, -1}, {30242, -1, -1, -1}, {30240, -1, -1, -1}, {30272, -1, -1, -1}, {30253, -1, -1, -1}, {30256, -1, -1, -1}, {30271, -1, -1, -1}, {30261, -1, -1, -1}, {30275, -1, -1, -1}, {30270, -1, -1, -1}, {30259, -1, -1, -1}, {30285, -1, -1, -1}, {30302, -1, -1, -1}, {30292, -1, -1, -1}, {30300, -1, -1, -1}, {30294, -1, -1, -1}, {30315, -1, -1, -1}, {30319, -1, -1, -1}, {32714, -1, -1, -1}, {31462, -1, -1, -1}, {31352, -1, -1, -1}, {31353, -1, -1, -1}, {31360, -1, -1, -1}, {31366, -1, -1, -1}, {31368, -1, -1, -1}, {31381, -1, -1, -1}, {31398, -1, -1, -1}, {31392, -1, -1, -1}, {31404, -1, -1, -1}, {31400, -1, -1, -1}, {31405, -1, -1, -1}, {31411, -1, -1, -1}, {34916, -1, -1, -1}, {34921, -1, -1, -1}, {34930, -1, -1, -1}, {34941, -1, -1, -1}, {34943, -1, -1, -1}, {34946, -1, -1, -1}, {34978, -1, -1, -1}, {35014, -1, -1, -1}, {34999, -1, -1, -1}, {35004, -1, -1, -1}, {35017, -1, -1, -1}, {35042, -1, -1, -1}, {35022, -1, -1, -1}, {35043, -1, -1, -1}, {35045, -1, -1, -1}, {35057, -1, -1, -1}, {35098, -1, -1, -1}, {35068, -1, -1, -1}, {35048, -1, -1, -1}, {35070, -1, -1, -1}, {35056, -1, -1, -1}, {35105, -1, -1, -1}, {35097, -1, -1, -1}, {35091, -1, -1, -1}, {35099, -1, -1, -1}, {35082, -1, -1, -1}, {35124, -1, -1, -1}, {35115, -1, -1, -1}, {35126, -1, -1, -1}, {35137, -1, -1, -1}, {35174, -1, -1, -1}, {35195, -1, -1, -1}, {12134, 30091, -1, -1}, {32997, -1, -1, -1}, {30386, -1, -1, -1}, {30388, -1, -1, -1}, {30684, -1, -1, -1}, {12158, 32786, -1, -1}, {32788, -1, -1, -1}, {32790, -1, -1, -1}, {32796, -1, -1, -1}, {32800, -1, -1, -1}, {32802, -1, -1, -1}, {32805, -1, -1, -1}, {32806, -1, -1, -1}, {32807, -1, -1, -1}, {32809, -1, -1, -1}, {32808, -1, -1, -1}, {32817, -1, -1, -1}, {32779, -1, -1, -1}, {32821, -1, -1, -1}, {32835, -1, -1, -1}, {32838, -1, -1, -1}, {32845, -1, -1, -1}, {32850, -1, -1, -1}, {32873, -1, -1, -1}, {32881, -1, -1, -1}, {35203, -1, -1, -1}, {39032, -1, -1, -1}, {39040, -1, -1, -1}, {39043, -1, -1, -1}, {39049, -1, -1, -1}, {39052, -1, -1, -1}, {39053, -1, -1, -1}, {39055, -1, -1, -1}, {39060, -1, -1, -1}, {39066, -1, -1, -1}, {39067, -1, -1, -1}, {39070, -1, -1, -1}, {39071, -1, -1, -1}, {39073, -1, -1, -1}, {39074, -1, -1, -1}, {39077, -1, -1, -1}, {39078, -1, -1, -1}, {12172, 34381, -1, -1}, {34388, -1, -1, -1}, {34412, -1, -1, -1}, {34414, -1, -1, -1}, {34431, -1, -1, -1}, {34426, -1, -1, -1}, {34428, -1, -1, -1}, {34427, -1, -1, -1}, {34472, -1, -1, -1}, {34445, -1, -1, -1}, {34443, -1, -1, -1}, {34476, -1, -1, -1}, {34461, -1, -1, -1}, {34471, -1, -1, -1}, {34467, -1, -1, -1}, {34474, -1, -1, -1} },
    {{34451, -1, -1, -1}, {34473, -1, -1, -1}, {34486, -1, -1, -1}, {34500, -1, -1, -1}, {34485, -1, -1, -1}, {34510, -1, -1, -1}, {34480, -1, -1, -1}, {34490, -1, -1, -1}, {34481, -1, -1, -1}, {34479, -1, -1, -1}, {34505, -1, -1, -1}, {34511, -1, -1, -1}, {34484, -1, -1, -1}, {34537, -1, -1, -1}, {34545, -1, -1, -1}, {34546, -1, -1, -1}, {34541, -1, -1, -1}, {34547, -1, -1, -1}, {34512, -1, -1, -1}, {34579, -1, -1, -1}, {34526, -1, -1, -1}, {34548, -1, -1, -1}, {34527, -1, -1, -1}, {34520, -1, -1, -1}, {34513, -1, -1, -1}, {34563, -1, -1, -1}, {34567, -1, -1, -1}, {34552, -1, -1, -1}, {34568, -1, -1, -1}, {34570, -1, -1, -1}, {34573, -1, -1, -1}, {34569, -1, -1, -1}, {34595, -1, -1, -1}, {34619, -1, -1, -1}, {34590, -1, -1, -1}, {34597, -1, -1, -1}, {34606, -1, -1, -1}, {34586, -1, -1, -1}, {34622, -1, -1, -1}, {34632, -1, -1, -1}, {34612, -1, -1, -1}, {34609, -1, -1, -1}, {34601, -1, -1, -1}, {34615, -1, -1, -1}, {34623, -1, -1, -1}, {34690, -1, -1, -1}, {34594, -1, -1, -1}, {34685, -1, -1, -1}, {34686, -1, -1, -1}, {34683, -1, -1, -1}, {34656, -1, -1, -1}, {34672, -1, -1, -1}, {34636, -1, -1, -1}, {34670, -1, -1, -1}, {34699, -1, -1, -1}, {34643, -1, -1, -1}, {34659, -1, -1, -1}, {34684, -1, -1, -1}, {34660, -1, -1, -1}, {34649, -1, -1, -1}, {34661, -1, -1, -1}, {34707, -1, -1, -1}, {34735, -1, -1, -1}, {34728, -1, -1, -1}, {34770, -1, -1, -1}, {34758, -1, -1, -1}, {34696, -1, -1, -1}, {34693, -1, -1, -1}, {34733, -1, -1, -1}, {34711, -1, -1, -1}, {34691, -1, -1, -1}, {34731, -1, -1, -1}, {34789, -1, -1, -1}, {34732, -1, -1, -1}, {34741, -1, -1, -1}, {34739, -1, -1, -1}, {34763, -1, -1, -1}, {34771, -1, -1, -1}, {34749, -1, -1, -1}, {34769, -1, -1, -1}, {34752, -1, -1, -1}, {34762, -1, -1, -1}, {34779, -1, -1, -1}, {34794, -1, -1, -1}, {34784, -1, -1, -1}, {34798, -1, -1, -1}, {34838, -1, -1, -1}, {34835, -1, -1, -1}, {34814, -1, -1, -1}, {34826, -1, -1, -1}, {34843, -1, -1, -1}, {34849, -1, -1, -1}, {34873, -1, -1, -1}, {34876, -1, -1, -1}, {12152, 32566, -1, -1}, {32578, -1, -1, -1}, {32580, -1, -1, -1}, {32581, -1, -1, -1}, {33296, -1, -1, -1}, {31482, -1, -1, -1}, {31485, -1, -1, -1}, {31496, -1, -1, -1}, {31491, -1, -1, -1}, {31492, -1, -1, -1}, {31509, -1, -1, -1}, {31498, -1, -1, -1}, {31531, -1, -1, -1}, {31503, -1, -1, -1}, {31559, -1, -1, -1}, {31544, -1, -1, -1}, {31530, -1, -1, -1}, {31513, -1, -1, -1}, {31534, -1, -1, -1}, {31537, -1, -1, -1}, {31520, -1, -1, -1}, {31525, -1, -1, -1}, {31524, -1, -1, -1}, {31539, -1, -1, -1}, {31550, -1, -1, -1}, {31518, -1, -1, -1}, {31576, -1, -1, -1}, {31578, -1, -1, -1}, {31557, -1, -1, -1}, {31605, -1, -1, -1}, {31564, -1, -1, -1}, {31581, -1, -1, -1}, {31584, -1, -1, -1}, {31598, -1, -1, -1}, {31611, -1, -1, -1}, {31586, -1, -1, -1}, {31602, -1, -1, -1}, {31601, -1, -1, -1}, {31632, -1, -1, -1}, {31654, -1, -1, -1}, {31655, -1, -1, -1}, {31672, -1, -1, -1}, {31660, -1, -1, -1}, {31645, -1, -1, -1}, {31656, -1, -1, -1}, {31621, -1, -1, -1}, {31658, -1, -1, -1}, {31644, -1, -1, -1}, {31650, -1, -1, -1}, {31659, -1, -1, -1}, {31668, -1, -1, -1}, {31697, -1, -1, -1}, {31681, -1, -1, -1}, {31692, -1, -1, -1}, {31709, -1, -1, -1}, {31706, -1, -1, -1}, {31717, -1, -1, -1}, {31718, -1, -1, -1}, {31722, -1, -1, -1}, {31756, -1, -1, -1}, {31742, -1, -1, -1}, {31740, -1, -1, -1}, {31759, -1, -1, -1}, {31766, -1, -1, -1}, {31755, -1, -1, -1}, {31775, -1, -1, -1}, {31786, -1, -1, -1}, {31782, -1, -1, -1}, {31800, -1, -1, -1}, {31809, -1, -1, -1}, {31808, -1, -1, -1}, {33278, -1, -1, -1}, {33281, -1, -1, -1}, {33282, -1, -1, -1}, {33284, -1, -1, -1}, {33260, -1, -1, -1}, {34884, -1, -1, -1}, {33313, -1, -1, -1}, {33314, -1, -1, -1}, {33315, -1, -1, -1}, {33325, -1, -1, -1}, {33327, -1, -1, -1}, {33320, -1, -1, -1}, {33323, -1, -1, -1}, {33336, -1, -1, -1}, {33339, -1, -1, -1}, {33331, -1, -1, -1}, {33332, -1, -1, -1}, {33342, -1, -1, -1}, {33348, -1, -1, -1}, {33353, -1, -1, -1}, {33355, -1, -1, -1}, {33359, -1, -1, -1}, {33370, -1, -1, -1}, {33375, -1, -1, -1}, {33384, -1, -1, -1}, {34942, -1, -1, -1}, {34949, -1, -1, -1}, {34952, -1, -1, -1}, {35032, -1, -1, -1}, {35039, -1, -1, -1}, {35166, -1, -1, -1}, {32669, -1, -1, -1}, {32671, -1, -1, -1}, {32679, -1, -1, -1}, {32687, -1, -1, -1}, {32688, -1, -1, -1}, {32690, -1, -1, -1}, {31868, -1, -1, -1}, {25929, -1, -1, -1}, {31889, -1, -1, -1}, {31901, -1, -1, -1}, {31900, -1, -1, -1}, {31902, -1, -1, -1}, {31906, -1, -1, -1}, {31922, -1, -1, -1}, {31932, -1, -1, -1}, {31933, -1, -1, -1}, {31937, -1, -1, -1}, {31943, -1, -1, -1}, {31948, -1, -1, -1}, {31949, -1, -1, -1}, {31944, -1, -1, -1}, {31941, -1, -1, -1}, {31959, -1, -1, -1}, {31976, -1, -1, -1}, {12169, 33390, -1, -1}, {26280, -1, -1, -1}, {32703, -1, -1, -1}, {32718, -1, -1, -1}, {32725, -1, -1, -1}, {32741, -1, -1, -1}, {32737, -1, -1, -1}, {32742, -1, -1, -1}, {32745, -1, -1, -1}, {32750, -1, -1, -1}, {32755, -1, -1, -1}, {12151, 31992, -1, -1}, {32119, -1, -1, -1}, {32166, -1, -1, -1}, {32174, -1, -1, -1}, {32327, -1, -1, -1}, {32411, -1, -1, -1}, {40632, -1, -1, -1}, {40628, -1, -1, -1}, {36211, -1, -1, -1}, {36228, -1, -1, -1}, {36244, -1, -1, -1}, {36241, -1, -1, -1}, {36273, -1, -1, -1}, {36199, -1, -1, -1}, {36205, -1, -1, -1}, {35911, -1, -1, -1}, {35913, -1, -1, -1}, {37194, -1, -1, -1}, {37200, -1, -1, -1}, {37198, -1, -1, -1}, {37199, -1, -1, -1}, {37220, -1, -1, -1}, {37218, -1, -1, -1}, {37217, -1, -1, -1}, {37232, -1, -1, -1} },
    {{37225, -1, -1, -1}, {37231, -1, -1, -1}, {37245, -1, -1, -1}, {37246, -1, -1, -1}, {37234, -1, -1, -1}, {37236, -1, -1, -1}, {37241, -1, -1, -1}, {37260, -1, -1, -1}, {37253, -1, -1, -1}, {37264, -1, -1, -1}, {37261, -1, -1, -1}, {37265, -1, -1, -1}, {37282, -1, -1, -1}, {37283, -1, -1, -1}, {37290, -1, -1, -1}, {37293, -1, -1, -1}, {37294, -1, -1, -1}, {37295, -1, -1, -1}, {37301, -1, -1, -1}, {37300, -1, -1, -1}, {37306, -1, -1, -1}, {12183, 35925, -1, -1}, {40574, -1, -1, -1}, {36280, -1, -1, -1}, {36331, -1, -1, -1}, {36357, -1, -1, -1}, {36441, -1, -1, -1}, {36457, -1, -1, -1}, {36277, -1, -1, -1}, {36287, -1, -1, -1}, {36284, -1, -1, -1}, {36282, -1, -1, -1}, {36292, -1, -1, -1}, {36310, -1, -1, -1}, {36311, -1, -1, -1}, {36314, -1, -1, -1}, {36318, -1, -1, -1}, {36302, -1, -1, -1}, {36303, -1, -1, -1}, {36315, -1, -1, -1}, {36294, -1, -1, -1}, {36332, -1, -1, -1}, {36343, -1, -1, -1}, {36344, -1, -1, -1}, {36323, -1, -1, -1}, {36345, -1, -1, -1}, {36347, -1, -1, -1}, {36324, -1, -1, -1}, {36361, -1, -1, -1}, {36349, -1, -1, -1}, {36372, -1, -1, -1}, {36381, -1, -1, -1}, {36383, -1, -1, -1}, {36396, -1, -1, -1}, {36398, -1, -1, -1}, {36387, -1, -1, -1}, {36399, -1, -1, -1}, {36410, -1, -1, -1}, {36416, -1, -1, -1}, {36409, -1, -1, -1}, {36405, -1, -1, -1}, {36413, -1, -1, -1}, {36401, -1, -1, -1}, {36425, -1, -1, -1}, {36417, -1, -1, -1}, {36418, -1, -1, -1}, {36433, -1, -1, -1}, {36434, -1, -1, -1}, {36426, -1, -1, -1}, {36464, -1, -1, -1}, {36470, -1, -1, -1}, {36476, -1, -1, -1}, {36463, -1, -1, -1}, {36468, -1, -1, -1}, {36485, -1, -1, -1}, {36495, -1, -1, -1}, {36500, -1, -1, -1}, {36496, -1, -1, -1}, {36508, -1, -1, -1}, {36510, -1, -1, -1}, {12184, 35960, -1, -1}, {35970, -1, -1, -1}, {35978, -1, -1, -1}, {35973, -1, -1, -1}, {35992, -1, -1, -1}, {35988, -1, -1, -1}, {26011, -1, -1, -1}, {35286, -1, -1, -1}, {35294, -1, -1, -1}, {35290, -1, -1, -1}, {35292, -1, -1, -1}, {35301, -1, -1, -1}, {35307, -1, -1, -1}, {35311, -1, -1, -1}, {35390, -1, -1, -1}, {35622, -1, -1, -1}, {38739, -1, -1, -1}, {38633, -1, -1, -1}, {38643, -1, -1, -1}, {38639, -1, -1, -1}, {38662, -1, -1, -1}, {38657, -1, -1, -1}, {38664, -1, -1, -1}, {38671, -1, -1, -1}, {38670, -1, -1, -1}, {38698, -1, -1, -1}, {38701, -1, -1, -1}, {38704, -1, -1, -1}, {38718, -1, -1, -1}, {40832, -1, -1, -1}, {40835, -1, -1, -1}, {40837, -1, -1, -1}, {40838, -1, -1, -1}, {40839, -1, -1, -1}, {40840, -1, -1, -1}, {40841, -1, -1, -1}, {40842, -1, -1, -1}, {40844, -1, -1, -1}, {40702, -1, -1, -1}, {40715, -1, -1, -1}, {40717, -1, -1, -1}, {12203, 38585, -1, -1}, {38588, -1, -1, -1}, {38589, -1, -1, -1}, {38606, -1, -1, -1}, {38610, -1, -1, -1}, {30655, -1, -1, -1}, {38624, -1, -1, -1}, {37518, -1, -1, -1}, {37550, -1, -1, -1}, {37576, -1, -1, -1}, {37694, -1, -1, -1}, {37738, -1, -1, -1}, {37834, -1, -1, -1}, {37775, -1, -1, -1}, {37950, -1, -1, -1}, {37995, -1, -1, -1}, {40063, -1, -1, -1}, {40066, -1, -1, -1}, {40069, -1, -1, -1}, {40070, -1, -1, -1}, {40071, -1, -1, -1}, {40072, -1, -1, -1}, {31267, -1, -1, -1}, {40075, -1, -1, -1}, {40078, -1, -1, -1}, {40080, -1, -1, -1}, {40081, -1, -1, -1}, {40082, -1, -1, -1}, {40084, -1, -1, -1}, {40085, -1, -1, -1}, {40090, -1, -1, -1}, {40091, -1, -1, -1}, {40094, -1, -1, -1}, {40095, -1, -1, -1}, {40096, -1, -1, -1}, {40097, -1, -1, -1}, {40098, -1, -1, -1}, {40099, -1, -1, -1}, {40101, -1, -1, -1}, {40102, -1, -1, -1}, {40103, -1, -1, -1}, {40104, -1, -1, -1}, {40105, -1, -1, -1}, {40107, -1, -1, -1}, {40109, -1, -1, -1}, {40110, -1, -1, -1}, {40112, -1, -1, -1}, {40113, -1, -1, -1}, {40114, -1, -1, -1}, {40115, -1, -1, -1}, {40116, -1, -1, -1}, {40117, -1, -1, -1}, {40118, -1, -1, -1}, {40119, -1, -1, -1}, {40122, -1, -1, -1}, {40123, -1, -1, -1}, {40124, -1, -1, -1}, {40125, -1, -1, -1}, {40132, -1, -1, -1}, {40133, -1, -1, -1}, {40134, -1, -1, -1}, {40135, -1, -1, -1}, {40138, -1, -1, -1}, {40139, -1, -1, -1}, {40140, -1, -1, -1}, {40141, -1, -1, -1}, {40142, -1, -1, -1}, {40143, -1, -1, -1}, {40144, -1, -1, -1}, {40147, -1, -1, -1}, {40148, -1, -1, -1}, {40149, -1, -1, -1}, {40151, -1, -1, -1}, {40152, -1, -1, -1}, {40153, -1, -1, -1}, {40156, -1, -1, -1}, {40157, -1, -1, -1}, {40159, -1, -1, -1}, {40162, -1, -1, -1}, {38780, -1, -1, -1}, {38789, -1, -1, -1}, {38801, -1, -1, -1}, {38802, -1, -1, -1}, {38804, -1, -1, -1}, {38831, -1, -1, -1}, {38827, -1, -1, -1}, {38819, -1, -1, -1}, {38834, -1, -1, -1}, {38836, -1, -1, -1}, {39601, -1, -1, -1}, {39600, -1, -1, -1}, {39607, -1, -1, -1}, {40536, -1, -1, -1}, {39606, -1, -1, -1}, {39610, -1, -1, -1}, {39612, -1, -1, -1}, {39617, -1, -1, -1}, {39616, -1, -1, -1}, {39621, -1, -1, -1}, {39618, -1, -1, -1}, {39627, -1, -1, -1}, {39628, -1, -1, -1}, {39633, -1, -1, -1}, {39749, -1, -1, -1}, {39747, -1, -1, -1}, {39751, -1, -1, -1}, {39753, -1, -1, -1}, {39752, -1, -1, -1}, {39757, -1, -1, -1}, {39761, -1, -1, -1}, {39144, -1, -1, -1}, {39181, -1, -1, -1}, {39214, -1, -1, -1}, {39253, -1, -1, -1}, {39252, -1, -1, -1}, {12221, 39647, -1, -1}, {39649, -1, -1, -1}, {39654, -1, -1, -1}, {39663, -1, -1, -1}, {39659, -1, -1, -1}, {39675, -1, -1, -1}, {39661, -1, -1, -1}, {39673, -1, -1, -1}, {39688, -1, -1, -1}, {39695, -1, -1, -1}, {39699, -1, -1, -1}, {39711, -1, -1, -1}, {39715, -1, -1, -1}, {40637, -1, -1, -1}, {40638, -1, -1, -1}, {32315, -1, -1, -1}, {40578, -1, -1, -1}, {40583, -1, -1, -1}, {40584, -1, -1, -1}, {40587, -1, -1, -1} },
    {{40594, -1, -1, -1}, {37846, -1, -1, -1}, {40605, -1, -1, -1}, {40607, -1, -1, -1}, {40667, -1, -1, -1}, {40668, -1, -1, -1}, {40669, -1, -1, -1}, {40672, -1, -1, -1}, {40671, -1, -1, -1}, {40674, -1, -1, -1}, {40681, -1, -1, -1}, {40679, -1, -1, -1}, {40677, -1, -1, -1}, {40682, -1, -1, -1}, {40687, -1, -1, -1}, {40738, -1, -1, -1}, {40748, -1, -1, -1}, {40751, -1, -1, -1}, {40761, -1, -1, -1}, {40759, -1, -1, -1}, {40765, -1, -1, -1}, {40766, -1, -1, -1}, {40772, -1, -1, -1}, {12295, -1, -1, -1}, {65374, -1, -1, -1}, {-1, -1, -1, -1}, {12307, -1, -1, -1}, {65294, -1, -1, -1}, {65309, 8741, -1, -1}, {65339, -1, -1, -1}, {65341, -1, -1, -1}, {65507, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {30362, -1, -1, -1}, {34297, -1, -1, -1}, {31001, -1, -1, -1}, {24859, -1, -1, -1}, {39599, -1, -1, -1}, {35158, -1, -1, -1}, {22761, -1, -1, -1}, {32631, -1, -1, -1}, {25850, -1, -1, -1}, {25943, -1, -1, -1}, {38930, -1, -1, -1}, {36774, -1, -1, -1}, {32070, -1, -1, -1}, {24171, -1, -1, -1}, {32129, -1, -1, -1}, {37770, -1, -1, -1}, {35607, -1, -1, -1}, {39165, -1, -1, -1}, {23542, -1, -1, -1}, {22577, -1, -1, -1}, {39825, -1, -1, -1}, {36649, -1, -1, -1}, {12185, 35997, -1, -1}, {37575, -1, -1, -1}, {29437, -1, -1, -1}, {20633, -1, -1, -1}, {24970, -1, -1, -1}, {32179, -1, -1, -1}, {31558, -1, -1, -1}, {30050, -1, -1, -1}, {25987, -1, -1, -1}, {24163, -1, -1, -1}, {38281, -1, -1, -1}, {37002, -1, -1, -1}, {32232, -1, -1, -1}, {36022, -1, -1, -1}, {35722, -1, -1, -1}, {36783, -1, -1, -1}, {36782, -1, -1, -1}, {27161, -1, -1, -1}, {40009, -1, -1, -1}, {30303, -1, -1, -1}, {28693, -1, -1, -1}, {28657, -1, -1, -1}, {36051, -1, -1, -1}, {25839, -1, -1, -1}, {39173, -1, -1, -1}, {25765, -1, -1, -1}, {37474, -1, -1, -1}, {37457, -1, -1, -1}, {39361, -1, -1, -1}, {35036, -1, -1, -1}, {36001, -1, -1, -1}, {21443, -1, -1, -1}, {34870, -1, -1, -1}, {27544, -1, -1, -1}, {24922, -1, -1, -1}, {24920, -1, -1, -1}, {29158, -1, -1, -1}, {33980, -1, -1, -1}, {33369, -1, -1, -1}, {20489, -1, -1, -1}, {28356, -1, -1, -1}, {21408, -1, -1, -1}, {20596, -1, -1, -1}, {28204, -1, -1, -1}, {23652, -1, -1, -1}, {35435, -1, -1, -1}, {25881, -1, -1, -1}, {25723, -1, -1, -1}, {34796, -1, -1, -1}, {39262, -1, -1, -1}, {35730, -1, -1, -1}, {32399, -1, -1, -1}, {37855, -1, -1, -1}, {29987, -1, -1, -1}, {38369, -1, -1, -1}, {39019, -1, -1, -1}, {22580, -1, -1, -1}, {22039, -1, -1, -1}, {12199, 38263, -1, -1}, {20767, -1, -1, -1}, {33144, -1, -1, -1}, {24288, -1, -1, -1}, {26274, -1, -1, -1}, {37396, -1, -1, -1}, {12190, 36554, -1, -1}, {24505, -1, -1, -1}, {22645, -1, -1, -1}, {38515, -1, -1, -1}, {35183, -1, -1, -1}, {31281, -1, -1, -1}, {25074, -1, -1, -1}, {35488, -1, -1, -1}, {39425, -1, -1, -1}, {36978, -1, -1, -1}, {39347, -1, -1, -1}, {12242, 40786, -1, -1}, {29118, -1, -1, -1}, {34909, -1, -1, -1}, {34802, -1, -1, -1}, {23541, -1, -1, -1}, {30087, -1, -1, -1}, {36490, -1, -1, -1}, {31820, -1, -1, -1}, {32162, -1, -1, -1}, {37276, -1, -1, -1}, {37604, -1, -1, -1}, {38619, -1, -1, -1}, {30990, -1, -1, -1}, {20786, -1, -1, -1}, {35320, -1, -1, -1}, {34389, -1, -1, -1}, {20659, -1, -1, -1}, {30241, -1, -1, -1}, {38358, -1, -1, -1}, {21109, -1, -1, -1}, {37656, -1, -1, -1}, {32020, -1, -1, -1}, {32189, -1, -1, -1}, {36781, -1, -1, -1}, {35422, -1, -1, -1}, {36060, -1, -1, -1}, {32880, -1, -1, -1}, {24478, -1, -1, -1}, {21474, -1, -1, -1}, {36517, -1, -1, -1}, {31428, -1, -1, -1}, {37679, -1, -1, -1}, {36948, -1, -1, -1}, {24118, -1, -1, -1}, {36024, -1, -1, -1}, {25812, -1, -1, -1}, {21934, -1, -1, -1}, {37170, -1, -1, -1}, {25763, -1, -1, -1}, {33213, -1, -1, -1}, {24986, -1, -1, -1}, {35477, -1, -1, -1}, {24392, -1, -1, -1}, {30070, -1, -1, -1}, {25803, -1, -1, -1}, {40680, -1, -1, -1}, {34153, -1, -1, -1}, {27284, -1, -1, -1}, {25623, -1, -1, -1}, {23798, -1, -1, -1}, {31153, -1, -1, -1}, {23566, -1, -1, -1}, {29128, -1, -1, -1}, {37159, -1, -1, -1}, {25973, -1, -1, -1}, {28364, -1, -1, -1}, {36958, -1, -1, -1}, {32224, -1, -1, -1}, {39003, -1, -1, -1}, {40670, -1, -1, -1}, {22666, -1, -1, -1}, {38651, -1, -1, -1}, {28593, -1, -1, -1}, {37347, -1, -1, -1}, {35519, -1, -1, -1}, {35548, -1, -1, -1}, {37336, -1, -1, -1}, {38914, -1, -1, -1}, {37664, -1, -1, -1}, {35330, -1, -1, -1}, {26481, -1, -1, -1}, {21205, -1, -1, -1}, {26847, -1, -1, -1}, {20941, -1, -1, -1}, {12222, 39717, -1, -1}, {29346, -1, -1, -1}, {29544, -1, -1, -1}, {35712, -1, -1, -1}, {36077, -1, -1, -1}, {37709, -1, -1, -1}, {37723, -1, -1, -1}, {26039, -1, -1, -1}, {32222, -1, -1, -1}, {38538, -1, -1, -1}, {23565, -1, -1, -1}, {22136, -1, -1, -1}, {38931, -1, -1, -1}, {37389, -1, -1, -1}, {22890, -1, -1, -1}, {22702, -1, -1, -1}, {40285, -1, -1, -1}, {38989, -1, -1, -1}, {35355, -1, -1, -1}, {24801, -1, -1, -1}, {39187, -1, -1, -1}, {20818, -1, -1, -1}, {29246, -1, -1, -1}, {39180, -1, -1, -1}, {36019, -1, -1, -1}, {30332, -1, -1, -1}, {32624, -1, -1, -1}, {38309, -1, -1, -1}, {31020, -1, -1, -1}, {37353, -1, -1, -1}, {29033, -1, -1, -1}, {31684, -1, -1, -1}, {36009, -1, -1, -1}, {39151, -1, -1, -1}, {35370, -1, -1, -1}, {32033, -1, -1, -1}, {12214, 39131, -1, -1}, {35513, -1, -1, -1}, {24290, -1, -1, -1}, {36027, -1, -1, -1}, {32027, -1, -1, -1}, {22707, -1, -1, -1}, {22894, -1, -1, -1}, {24996, -1, -1, -1}, {31966, -1, -1, -1}, {35920, -1, -1, -1}, {26963, -1, -1, -1}, {37586, -1, -1, -1} },
    {{12213, 39080, -1, -1}, {30219, -1, -1, -1}, {39342, -1, -1, -1}, {32299, -1, -1, -1}, {35575, -1, -1, -1}, {40179, -1, -1, -1}, {33178, -1, -1, -1}, {36667, -1, -1, -1}, {25771, -1, -1, -1}, {36628, -1, -1, -1}, {36070, -1, -1, -1}, {24489, -1, -1, -1}, {36000, -1, -1, -1}, {35331, -1, -1, -1}, {23142, -1, -1, -1}, {32283, -1, -1, -1}, {35442, -1, -1, -1}, {37411, -1, -1, -1}, {33995, -1, -1, -1}, {24185, -1, -1, -1}, {36245, -1, -1, -1}, {36123, -1, -1, -1}, {23713, -1, -1, -1}, {21083, -1, -1, -1}, {37628, -1, -1, -1}, {32177, -1, -1, -1}, {23831, -1, -1, -1}, {37804, -1, -1, -1}, {25841, -1, -1, -1}, {40255, -1, -1, -1}, {38307, -1, -1, -1}, {37499, -1, -1, -1}, {20491, -1, -1, -1}, {32102, -1, -1, -1}, {40852, -1, -1, -1}, {38799, -1, -1, -1}, {36002, -1, -1, -1}, {37390, -1, -1, -1}, {28317, -1, -1, -1}, {27083, -1, -1, -1}, {36092, -1, -1, -1}, {34865, -1, -1, -1}, {39015, -1, -1, -1}, {21102, -1, -1, -1}, {38364, -1, -1, -1}, {35264, -1, -1, -1}, {39208, -1, -1, -1}, {24931, -1, -1, -1}, {36011, -1, -1, -1}, {24291, -1, -1, -1}, {35215, -1, -1, -1}, {27512, -1, -1, -1}, {12244, 40860, -1, -1}, {38312, -1, -1, -1}, {36556, -1, -1, -1}, {35437, -1, -1, -1}, {27331, -1, -1, -1}, {36020, -1, -1, -1}, {21130, -1, -1, -1}, {36645, -1, -1, -1}, {37707, -1, -1, -1}, {22283, -1, -1, -1}, {36942, -1, -1, -1}, {39405, -1, -1, -1}, {38867, -1, -1, -1}, {28450, -1, -1, -1}, {34399, -1, -1, -1}, {38305, -1, -1, -1}, {40372, -1, -1, -1}, {36032, -1, -1, -1}, {36703, -1, -1, -1}, {40251, -1, -1, -1}, {32005, -1, -1, -1}, {22778, -1, -1, -1}, {35703, -1, -1, -1}, {28396, -1, -1, -1}, {22057, -1, -1, -1}, {33775, -1, -1, -1}, {30059, -1, -1, -1}, {21123, -1, -1, -1}, {35441, -1, -1, -1}, {25079, -1, -1, -1}, {22750, -1, -1, -1}, {27489, -1, -1, -1}, {29872, -1, -1, -1}, {36996, -1, -1, -1}, {32233, -1, -1, -1}, {35594, -1, -1, -1}, {25582, -1, -1, -1}, {36637, -1, -1, -1}, {36036, -1, -1, -1}, {31330, -1, -1, -1}, {26371, -1, -1, -1}, {29172, -1, -1, -1}, {21295, -1, -1, -1}, {35569, -1, -1, -1}, {35496, -1, -1, -1}, {32362, -1, -1, -1}, {33911, -1, -1, -1}, {28222, -1, -1, -1}, {29554, -1, -1, -1}, {36008, -1, -1, -1}, {31117, -1, -1, -1}, {25802, -1, -1, -1}, {27231, -1, -1, -1}, {31309, -1, -1, -1}, {39249, -1, -1, -1}, {35663, -1, -1, -1}, {40388, -1, -1, -1}, {32318, -1, -1, -1}, {32221, -1, -1, -1}, {26997, -1, -1, -1}, {36655, -1, -1, -1}, {32026, -1, -1, -1}, {25824, -1, -1, -1}, {24190, -1, -1, -1}, {34186, -1, -1, -1}, {21137, -1, -1, -1}, {28639, -1, -1, -1}, {35336, -1, -1, -1}, {35352, -1, -1, -1}, {38555, -1, -1, -1}, {32380, -1, -1, -1}, {32000, -1, -1, -1}, {22846, -1, -1, -1}, {33698, -1, -1, -1}, {38960, -1, -1, -1}, {36040, -1, -1, -1}, {37440, -1, -1, -1}, {20729, -1, -1, -1}, {39381, -1, -1, -1}, {27570, -1, -1, -1}, {30435, -1, -1, -1}, {22533, -1, -1, -1}, {31627, -1, -1, -1}, {38291, -1, -1, -1}, {33393, -1, -1, -1}, {32216, -1, -1, -1}, {32365, -1, -1, -1}, {27298, -1, -1, -1}, {40572, -1, -1, -1}, {25536, -1, -1, -1}, {25791, -1, -1, -1}, {31777, -1, -1, -1}, {20745, -1, -1, -1}, {34214, -1, -1, -1}, {27323, -1, -1, -1}, {37970, -1, -1, -1}, {36368, -1, -1, -1}, {36068, -1, -1, -1}, {12178, 35211, -1, -1}, {37749, -1, -1, -1}, {33382, -1, -1, -1}, {21133, -1, -1, -1}, {39198, -1, -1, -1}, {28472, -1, -1, -1}, {28666, -1, -1, -1}, {28567, -1, -1, -1}, {23559, -1, -1, -1}, {28479, -1, -1, -1}, {34083, -1, -1, -1}, {27123, -1, -1, -1}, {22892, -1, -1, -1}, {35611, -1, -1, -1}, {37292, -1, -1, -1}, {33184, -1, -1, -1}, {28550, -1, -1, -1}, {39509, -1, -1, -1}, {23308, -1, -1, -1}, {25898, -1, -1, -1}, {37496, -1, -1, -1}, {30703, -1, -1, -1}, {20709, -1, -1, -1}, {39171, -1, -1, -1}, {32371, -1, -1, -1}, {32094, -1, -1, -1}, {36686, -1, -1, -1}, {36611, -1, -1, -1}, {38542, -1, -1, -1}, {31680, -1, -1, -1}, {28500, -1, -1, -1}, {32080, -1, -1, -1}, {35489, -1, -1, -1}, {32202, -1, -1, -1}, {37670, -1, -1, -1}, {20677, -1, -1, -1}, {35641, -1, -1, -1}, {36914, -1, -1, -1}, {29180, -1, -1, -1}, {30433, -1, -1, -1}, {21185, -1, -1, -1}, {33686, -1, -1, -1}, {39912, -1, -1, -1}, {39514, -1, -1, -1}, {32147, -1, -1, -1}, {38968, -1, -1, -1}, {37857, -1, -1, -1}, {24465, -1, -1, -1}, {30169, -1, -1, -1}, {31478, -1, -1, -1}, {31998, -1, -1, -1}, {33290, -1, -1, -1}, {39378, -1, -1, -1}, {33289, -1, -1, -1}, {25818, -1, -1, -1}, {37624, -1, -1, -1}, {25084, -1, -1, -1}, {21127, -1, -1, -1}, {40273, -1, -1, -1}, {32121, -1, -1, -1}, {35258, -1, -1, -1}, {35363, -1, -1, -1}, {32118, -1, -1, -1}, {37406, -1, -1, -1}, {36557, -1, -1, -1}, {39423, -1, -1, -1}, {38283, -1, -1, -1}, {20977, -1, -1, -1}, {38982, -1, -1, -1}, {27579, -1, -1, -1}, {35506, -1, -1, -1}, {22718, -1, -1, -1}, {25031, -1, -1, -1}, {25715, -1, -1, -1}, {24235, -1, -1, -1}, {35122, -1, -1, -1}, {35463, -1, -1, -1}, {22602, -1, -1, -1}, {20744, -1, -1, -1}, {23532, -1, -1, -1}, {31014, -1, -1, -1}, {26336, -1, -1, -1}, {34407, -1, -1, -1}, {24011, -1, -1, -1}, {31418, -1, -1, -1}, {39243, -1, -1, -1}, {28528, -1, -1, -1}, {25844, -1, -1, -1}, {38346, -1, -1, -1}, {34847, -1, -1, -1}, {33240, -1, -1, -1}, {33802, -1, -1, -1}, {20358, -1, -1, -1}, {36084, -1, -1, -1}, {34253, -1, -1, -1}, {27396, -1, -1, -1}, {25876, -1, -1, -1}, {31811, -1, -1, -1}, {38348, -1, -1, -1}, {34349, -1, -1, -1}, {28734, -1, -1, -1}, {35733, -1, -1, -1}, {25900, -1, -1, -1}, {35261, -1, -1, -1}, {25078, -1, -1, -1}, {32412, -1, -1, -1} },
    {{29211, -1, -1, -1}, {28651, -1, -1, -1}, {25736, -1, -1, -1}, {21214, -1, -1, -1}, {28551, -1, -1, -1}, {27138, -1, -1, -1}, {37939, -1, -1, -1}, {22744, -1, -1, -1}, {39006, -1, -1, -1}, {31852, -1, -1, -1}, {38626, -1, -1, -1}, {28757, -1, -1, -1}, {35023, -1, -1, -1}, {39881, -1, -1, -1}, {31150, -1, -1, -1}, {40599, -1, -1, -1}, {21426, -1, -1, -1}, {21237, -1, -1, -1}, {31019, -1, -1, -1}, {27511, -1, -1, -1}, {28701, -1, -1, -1}, {38584, -1, -1, -1}, {20486, -1, -1, -1}, {32879, -1, -1, -1}, {34030, -1, -1, -1}, {36899, -1, -1, -1}, {37934, -1, -1, -1}, {24976, -1, -1, -1}, {28451, -1, -1, -1}, {31806, -1, -1, -1}, {25986, -1, -1, -1}, {33225, -1, -1, -1}, {37832, -1, -1, -1}, {25088, -1, -1, -1}, {29001, -1, -1, -1}, {32244, -1, -1, -1}, {31975, -1, -1, -1}, {20841, -1, -1, -1}, {36635, -1, -1, -1}, {35538, -1, -1, -1}, {30274, -1, -1, -1}, {36988, -1, -1, -1}, {37904, -1, -1, -1}, {29557, -1, -1, -1}, {33256, -1, -1, -1}, {37168, -1, -1, -1}, {40023, -1, -1, -1}, {36035, -1, -1, -1}, {40801, -1, -1, -1}, {37428, -1, -1, -1}, {38728, -1, -1, -1}, {23994, -1, -1, -1}, {38936, -1, -1, -1}, {39230, -1, -1, -1}, {21129, -1, -1, -1}, {12243, 40845, -1, -1}, {32894, -1, -1, -1}, {22184, -1, -1, -1}, {31840, -1, -1, -1}, {22751, -1, -1, -1}, {25871, -1, -1, -1}, {38580, -1, -1, -1}, {27155, -1, -1, -1}, {23105, -1, -1, -1}, {25695, -1, -1, -1}, {31757, -1, -1, -1}, {34310, -1, -1, -1}, {30439, -1, -1, -1}, {39025, -1, -1, -1}, {24300, -1, -1, -1}, {29200, -1, -1, -1}, {25796, -1, -1, -1}, {28407, -1, -1, -1}, {34396, -1, -1, -1}, {39791, -1, -1, -1}, {36034, -1, -1, -1}, {37682, -1, -1, -1}, {38520, -1, -1, -1}, {39522, -1, -1, -1}, {37569, -1, -1, -1}, {23650, -1, -1, -1}, {32311, -1, -1, -1}, {24942, -1, -1, -1}, {28670, -1, -1, -1}, {32209, -1, -1, -1}, {24018, -1, -1, -1}, {25891, -1, -1, -1}, {23423, -1, -1, -1}, {28772, -1, -1, -1}, {20098, -1, -1, -1}, {25476, -1, -1, -1}, {36650, -1, -1, -1}, {20523, -1, -1, -1}, {20374, -1, -1, -1}, {28138, -1, -1, -1}, {32184, -1, -1, -1}, {35542, -1, -1, -1}, {34367, -1, -1, -1}, {32645, -1, -1, -1}, {37007, -1, -1, -1}, {38012, -1, -1, -1}, {31854, -1, -1, -1}, {39486, -1, -1, -1}, {39409, -1, -1, -1}, {32097, -1, -1, -1}, {23229, -1, -1, -1}, {29802, -1, -1, -1}, {30908, -1, -1, -1}, {34718, -1, -1, -1}, {12218, 39340, -1, -1}, {39393, -1, -1, -1}, {21966, -1, -1, -1}, {36023, -1, -1, -1}, {12230, 40613, -1, -1}, {36067, -1, -1, -1}, {36993, -1, -1, -1}, {30622, -1, -1, -1}, {39237, -1, -1, -1}, {34875, -1, -1, -1}, {28415, -1, -1, -1}, {35646, -1, -1, -1}, {37672, -1, -1, -1}, {37466, -1, -1, -1}, {36031, -1, -1, -1}, {37762, -1, -1, -1}, {12200, 38272, -1, -1}, {24758, -1, -1, -1}, {20497, -1, -1, -1}, {37683, -1, -1, -1}, {22818, -1, -1, -1}, {35598, -1, -1, -1}, {24396, -1, -1, -1}, {35219, -1, -1, -1}, {32191, -1, -1, -1}, {32236, -1, -1, -1}, {24287, -1, -1, -1}, {28357, -1, -1, -1}, {25003, -1, -1, -1}, {38313, -1, -1, -1}, {40180, -1, -1, -1}, {37528, -1, -1, -1}, {35628, -1, -1, -1}, {35584, -1, -1, -1}, {30045, -1, -1, -1}, {37385, -1, -1, -1}, {32013, -1, -1, -1}, {38627, -1, -1, -1}, {25747, -1, -1, -1}, {33126, -1, -1, -1}, {24817, -1, -1, -1}, {39719, -1, -1, -1}, {39186, -1, -1, -1}, {25836, -1, -1, -1}, {33193, -1, -1, -1}, {25862, -1, -1, -1}, {37312, -1, -1, -1}, {12227, 40165, -1, -1}, {32886, -1, -1, -1}, {22169, -1, -1, -1}, {38007, -1, -1, -1}, {37811, -1, -1, -1}, {27320, -1, -1, -1}, {29552, -1, -1, -1}, {23527, -1, -1, -1}, {25840, -1, -1, -1}, {28632, -1, -1, -1}, {37397, -1, -1, -1}, {32016, -1, -1, -1}, {33215, -1, -1, -1}, {28611, -1, -1, -1}, {36786, -1, -1, -1}, {30247, -1, -1, -1}, {35582, -1, -1, -1}, {27472, -1, -1, -1}, {40407, -1, -1, -1}, {27590, -1, -1, -1}, {22036, -1, -1, -1}, {28442, -1, -1, -1}, {30436, -1, -1, -1}, {40848, -1, -1, -1}, {36064, -1, -1, -1}, {22132, -1, -1, -1}, {40300, -1, -1, -1}, {39449, -1, -1, -1}, {39108, -1, -1, -1}, {38971, -1, -1, -1}, {36007, -1, -1, -1}, {34315, -1, -1, -1}, {24977, -1, -1, -1}, {35413, -1, -1, -1}, {28497, -1, -1, -1}, {38935, -1, -1, -1}, {25778, -1, -1, -1}, {37610, -1, -1, -1}, {20693, -1, -1, -1}, {27192, -1, -1, -1}, {35676, -1, -1, -1}, {33229, -1, -1, -1}, {12241, 40778, -1, -1}, {39438, -1, -1, -1}, {35912, -1, -1, -1}, {21843, -1, -1, -1}, {27683, -1, -1, -1}, {35350, -1, -1, -1}, {29309, -1, -1, -1}, {37370, -1, -1, -1}, {37467, -1, -1, -1}, {36983, -1, -1, -1}, {31805, -1, -1, -1}, {35609, -1, -1, -1}, {37666, -1, -1, -1}, {37463, -1, -1, -1}, {28154, -1, -1, -1}, {35700, -1, -1, -1}, {22649, -1, -1, -1}, {27085, -1, -1, -1}, {21958, -1, -1, -1}, {22715, -1, -1, -1}, {34196, -1, -1, -1}, {25654, -1, -1, -1}, {37740, -1, -1, -1}, {27211, -1, -1, -1}, {21932, -1, -1, -1}, {20689, -1, -1, -1}, {32761, -1, -1, -1}, {31429, -1, -1, -1}, {31434, -1, -1, -1}, {27453, -1, -1, -1}, {35242, -1, -1, -1}, {23522, -1, -1, -1}, {36629, -1, -1, -1}, {27691, -1, -1, -1}, {20670, -1, -1, -1}, {38915, -1, -1, -1}, {35531, -1, -1, -1}, {24950, -1, -1, -1}, {29898, -1, -1, -1}, {31406, -1, -1, -1}, {36264, -1, -1, -1}, {21312, -1, -1, -1}, {36544, -1, -1, -1}, {39493, -1, -1, -1}, {40818, -1, -1, -1}, {39028, -1, -1, -1}, {27402, -1, -1, -1}, {21240, -1, -1, -1}, {40306, -1, -1, -1}, {30906, -1, -1, -1}, {35731, -1, -1, -1}, {39250, -1, -1, -1}, {25854, -1, -1, -1}, {32350, -1, -1, -1}, {29105, -1, -1, -1}, {38860, -1, -1, -1}, {35469, -1, -1, -1}, {32009, -1, -1, -1} },
    {{27054, -1, -1, -1}, {32104, -1, -1, -1}, {36575, -1, -1, -1}, {37613, -1, -1, -1}, {38287, -1, -1, -1}, {28516, -1, -1, -1}, {28753, -1, -1, -1}, {34217, -1, -1, -1}, {39955, -1, -1, -1}, {36093, -1, -1, -1}, {20632, -1, -1, -1}, {21930, -1, -1, -1}, {39479, -1, -1, -1}, {25475, -1, -1, -1}, {28544, -1, -1, -1}, {27578, -1, -1, -1}, {32023, -1, -1, -1}, {31721, -1, -1, -1}, {26348, -1, -1, -1}, {38275, -1, -1, -1}, {38493, -1, -1, -1}, {36109, -1, -1, -1}, {32341, -1, -1, -1}, {20663, -1, -1, -1}, {36062, -1, -1, -1}, {29138, -1, -1, -1}, {32057, -1, -1, -1}, {36050, -1, -1, -1}, {25448, -1, -1, -1}, {25885, -1, -1, -1}, {25086, -1, -1, -1}, {35373, -1, -1, -1}, {32051, -1, -1, -1}, {23529, -1, -1, -1}, {23352, -1, -1, -1}, {33102, -1, -1, -1}, {28402, -1, -1, -1}, {32882, -1, -1, -1}, {32361, -1, -1, -1}, {21213, -1, -1, -1}, {32854, -1, -1, -1}, {24107, -1, -1, -1}, {29509, -1, -1, -1}, {28629, -1, -1, -1}, {35433, -1, -1, -1}, {26178, -1, -1, -1}, {34645, -1, -1, -1}, {23526, -1, -1, -1}, {35672, -1, -1, -1}, {39387, -1, -1, -1}, {21218, -1, -1, -1}, {36969, -1, -1, -1}, {37323, -1, -1, -1}, {39166, -1, -1, -1}, {35222, -1, -1, -1}, {35430, -1, -1, -1}, {22781, -1, -1, -1}, {29560, -1, -1, -1}, {27166, -1, -1, -1}, {36664, -1, -1, -1}, {26360, -1, -1, -1}, {36118, -1, -1, -1}, {23660, -1, -1, -1}, {34899, -1, -1, -1}, {27193, -1, -1, -1}, {31466, -1, -1, -1}, {25976, -1, -1, -1}, {24101, -1, -1, -1}, {38617, -1, -1, -1}, {35504, -1, -1, -1}, {38918, -1, -1, -1}, {35500, -1, -1, -1}, {30889, -1, -1, -1}, {29197, -1, -1, -1}, {32114, -1, -1, -1}, {39164, -1, -1, -1}, {39686, -1, -1, -1}, {32883, -1, -1, -1}, {24939, -1, -1, -1}, {38924, -1, -1, -1}, {35359, -1, -1, -1}, {35494, -1, -1, -1}, {25851, -1, -1, -1}, {34311, -1, -1, -1}, {35380, -1, -1, -1}, {32901, -1, -1, -1}, {38614, -1, -1, -1}, {38568, -1, -1, -1}, {32143, -1, -1, -1}, {27506, -1, -1, -1}, {23403, -1, -1, -1}, {25613, -1, -1, -1}, {32302, -1, -1, -1}, {29795, -1, -1, -1}, {37782, -1, -1, -1}, {29562, -1, -1, -1}, {25787, -1, -1, -1}, {33274, -1, -1, -1}, {24907, -1, -1, -1}, {25892, -1, -1, -1}, {36010, -1, -1, -1}, {30321, -1, -1, -1}, {28760, -1, -1, -1}, {22727, -1, -1, -1}, {35674, -1, -1, -1}, {35527, -1, -1, -1}, {22022, -1, -1, -1}, {28271, -1, -1, -1}, {29145, -1, -1, -1}, {28644, -1, -1, -1}, {32295, -1, -1, -1}, {35342, -1, -1, -1}, {39472, -1, -1, -1}, {35588, -1, -1, -1}, {37563, -1, -1, -1}, {38988, -1, -1, -1}, {39636, -1, -1, -1}, {26781, -1, -1, -1}, {36028, -1, -1, -1}, {37941, -1, -1, -1}, {24307, -1, -1, -1}, {32893, -1, -1, -1}, {28916, -1, -1, -1}, {37509, -1, -1, -1}, {32113, -1, -1, -1}, {38957, -1, -1, -1}, {22294, -1, -1, -1}, {22615, -1, -1, -1}, {22296, -1, -1, -1}, {38973, -1, -1, -1}, {40213, -1, -1, -1}, {39345, -1, -1, -1}, {39389, -1, -1, -1}, {27234, -1, -1, -1}, {31402, -1, -1, -1}, {35178, -1, -1, -1}, {24398, -1, -1, -1}, {28771, -1, -1, -1}, {38929, -1, -1, -1}, {33836, -1, -1, -1}, {32178, -1, -1, -1}, {12209, 38859, -1, -1}, {36949, -1, -1, -1}, {22285, -1, -1, -1}, {29234, -1, -1, -1}, {28656, -1, -1, -1}, {32173, -1, -1, -1}, {33894, -1, -1, -1}, {20553, -1, -1, -1}, {20702, -1, -1, -1}, {32239, -1, -1, -1}, {35586, -1, -1, -1}, {34907, -1, -1, -1}, {32862, -1, -1, -1}, {32011, -1, -1, -1}, {31337, -1, -1, -1}, {21839, -1, -1, -1}, {25790, -1, -1, -1}, {34680, -1, -1, -1}, {28198, -1, -1, -1}, {31401, -1, -1, -1}, {21978, -1, -1, -1}, {37794, -1, -1, -1}, {28879, -1, -1, -1}, {35491, -1, -1, -1}, {28961, -1, -1, -1}, {34154, -1, -1, -1}, {22626, -1, -1, -1}, {38695, -1, -1, -1}, {21209, -1, -1, -1}, {35492, -1, -1, -1}, {37675, -1, -1, -1}, {29351, -1, -1, -1}, {35186, -1, -1, -1}, {32722, -1, -1, -1}, {37521, -1, -1, -1}, {25138, -1, -1, -1}, {32048, -1, -1, -1}, {34662, -1, -1, -1}, {36676, -1, -1, -1}, {23805, -1, -1, -1}, {20448, -1, -1, -1}, {29433, -1, -1, -1}, {22151, -1, -1, -1}, {37697, -1, -1, -1}, {39854, -1, -1, -1}, {32406, -1, -1, -1}, {36066, -1, -1, -1}, {37532, -1, -1, -1}, {38289, -1, -1, -1}, {39023, -1, -1, -1}, {38570, -1, -1, -1}, {29694, -1, -1, -1}, {29563, -1, -1, -1}, {32291, -1, -1, -1}, {39201, -1, -1, -1}, {25010, -1, -1, -1}, {32171, -1, -1, -1}, {38002, -1, -1, -1}, {37129, -1, -1, -1}, {35443, -1, -1, -1}, {38911, -1, -1, -1}, {38917, -1, -1, -1}, {34157, -1, -1, -1}, {22210, -1, -1, -1}, {37559, -1, -1, -1}, {26313, -1, -1, -1}, {22063, -1, -1, -1}, {21332, -1, -1, -1}, {25406, -1, -1, -1}, {33029, -1, -1, -1}, {35559, -1, -1, -1}, {23531, -1, -1, -1}, {28681, -1, -1, -1}, {35613, -1, -1, -1}, {37573, -1, -1, -1}, {37313, -1, -1, -1}, {33288, -1, -1, -1}, {37561, -1, -1, -1}, {32137, -1, -1, -1}, {38920, -1, -1, -1}, {35377, -1, -1, -1}, {32210, -1, -1, -1}, {32396, -1, -1, -1}, {36562, -1, -1, -1}, {25080, -1, -1, -1}, {36984, -1, -1, -1}, {30316, -1, -1, -1}, {32098, -1, -1, -1}, {23416, -1, -1, -1}, {21211, -1, -1, -1}, {35426, -1, -1, -1}, {23563, -1, -1, -1}, {39348, -1, -1, -1}, {35347, -1, -1, -1}, {35338, -1, -1, -1}, {36956, -1, -1, -1}, {22739, -1, -1, -1}, {40201, -1, -1, -1}, {40232, -1, -1, -1}, {21854, -1, -1, -1}, {20126, -1, -1, -1}, {35357, -1, -1, -1}, {38329, -1, -1, -1}, {40573, -1, -1, -1}, {22196, -1, -1, -1}, {38996, -1, -1, -1}, {38331, -1, -1, -1}, {33399, -1, -1, -1}, {21421, -1, -1, -1}, {30831, -1, -1, -1}, {35578, -1, -1, -1}, {39511, -1, -1, -1}, {40230, -1, -1, -1}, {26954, -1, -1, -1}, {25562, -1, -1, -1} },
    {{30221, -1, -1, -1}, {38525, -1, -1, -1}, {30306, -1, -1, -1}, {39178, -1, -1, -1}, {27171, -1, -1, -1}, {22575, -1, -1, -1}, {35617, -1, -1, -1}, {34277, -1, -1, -1}, {29242, -1, -1, -1}, {12212, 38913, -1, -1}, {26989, -1, -1, -1}, {33865, -1, -1, -1}, {37291, -1, -1, -1}, {37541, -1, -1, -1}, {38948, -1, -1, -1}, {36986, -1, -1, -1}, {20736, -1, -1, -1}, {34811, -1, -1, -1}, {34269, -1, -1, -1}, {20740, -1, -1, -1}, {25014, -1, -1, -1}, {32681, -1, -1, -1}, {35427, -1, -1, -1}, {35696, -1, -1, -1}, {35516, -1, -1, -1}, {35695, -1, -1, -1}, {32377, -1, -1, -1}, {34093, -1, -1, -1}, {38512, -1, -1, -1}, {37504, -1, -1, -1}, {39154, -1, -1, -1}, {38577, -1, -1, -1}, {27387, -1, -1, -1}, {23344, -1, -1, -1}, {40441, -1, -1, -1}, {25033, -1, -1, -1}, {32403, -1, -1, -1}, {29801, -1, -1, -1}, {34722, -1, -1, -1}, {29151, -1, -1, -1}, {29074, -1, -1, -1}, {34821, -1, -1, -1}, {36111, -1, -1, -1}, {31310, -1, -1, -1}, {21938, -1, -1, -1}, {25793, -1, -1, -1}, {20653, -1, -1, -1}, {30320, -1, -1, -1}, {36404, -1, -1, -1}, {20778, -1, -1, -1}, {24962, -1, -1, -1}, {37109, -1, -1, -1}, {37438, -1, -1, -1}, {29494, -1, -1, -1}, {35480, -1, -1, -1}, {36671, -1, -1, -1}, {39192, -1, -1, -1}, {12226, 39770, -1, -1}, {28417, -1, -1, -1}, {33287, -1, -1, -1}, {23996, -1, -1, -1}, {35486, -1, -1, -1}, {39729, -1, -1, -1}, {29508, -1, -1, -1}, {35709, -1, -1, -1}, {38928, -1, -1, -1}, {39341, -1, -1, -1}, {40219, -1, -1, -1}, {28149, -1, -1, -1}, {36677, -1, -1, -1}, {22290, -1, -1, -1}, {21729, -1, -1, -1}, {22291, -1, -1, -1}, {32227, -1, -1, -1}, {36960, -1, -1, -1}, {39000, -1, -1, -1}, {32004, -1, -1, -1}, {36493, -1, -1, -1}, {38000, -1, -1, -1}, {38322, -1, -1, -1}, {38642, -1, -1, -1}, {37142, -1, -1, -1}, {38549, -1, -1, -1}, {36939, -1, -1, -1}, {34292, -1, -1, -1}, {37270, -1, -1, -1}, {26248, -1, -1, -1}, {38620, -1, -1, -1}, {36617, -1, -1, -1}, {25890, -1, -1, -1}, {26283, -1, -1, -1}, {36106, -1, -1, -1}, {36124, -1, -1, -1}, {33247, -1, -1, -1}, {38015, -1, -1, -1}, {26839, -1, -1, -1}, {31432, -1, -1, -1}, {36012, -1, -1, -1}, {25799, -1, -1, -1}, {21063, -1, -1, -1}, {28580, -1, -1, -1}, {36042, -1, -1, -1}, {36104, -1, -1, -1}, {36555, -1, -1, -1}, {37720, -1, -1, -1}, {38296, -1, -1, -1}, {35408, -1, -1, -1}, {40779, -1, -1, -1}, {20661, -1, -1, -1}, {27656, -1, -1, -1}, {30430, -1, -1, -1}, {26028, -1, -1, -1}, {36670, -1, -1, -1}, {23940, -1, -1, -1}, {26855, -1, -1, -1}, {25136, -1, -1, -1}, {32187, -1, -1, -1}, {24373, -1, -1, -1}, {28466, -1, -1, -1}, {24115, -1, -1, -1}, {36076, -1, -1, -1}, {33081, -1, -1, -1}, {36249, -1, -1, -1}, {34756, -1, -1, -1}, {36685, -1, -1, -1}, {37754, -1, -1, -1}, {36889, -1, -1, -1}, {35998, -1, -1, -1}, {37341, -1, -1, -1}, {20597, -1, -1, -1}, {35386, -1, -1, -1}, {37806, -1, -1, -1}, {38499, -1, -1, -1}, {24128, -1, -1, -1}, {30309, -1, -1, -1}, {37165, -1, -1, -1}, {35657, -1, -1, -1}, {32340, -1, -1, -1}, {32887, -1, -1, -1}, {22519, -1, -1, -1}, {34937, -1, -1, -1}, {32025, -1, -1, -1}, {25711, -1, -1, -1}, {25842, -1, -1, -1}, {24159, -1, -1, -1}, {36074, -1, -1, -1}, {28399, -1, -1, -1}, {37912, -1, -1, -1}, {32066, -1, -1, -1}, {31278, -1, -1, -1}, {33131, -1, -1, -1}, {34886, -1, -1, -1}, {35589, -1, -1, -1}, {36600, -1, -1, -1}, {30394, -1, -1, -1}, {26205, -1, -1, -1}, {39519, -1, -1, -1}, {35576, -1, -1, -1}, {35461, -1, -1, -1}, {29165, -1, -1, -1}, {30682, -1, -1, -1}, {22225, -1, -1, -1}, {36015, -1, -1, -1}, {37956, -1, -1, -1}, {31689, -1, -1, -1}, {39376, -1, -1, -1}, {23560, -1, -1, -1}, {30938, -1, -1, -1}, {36681, -1, -1, -1}, {36090, -1, -1, -1}, {27137, -1, -1, -1}, {33674, -1, -1, -1}, {35037, -1, -1, -1}, {22941, -1, -1, -1}, {22767, -1, -1, -1}, {29376, -1, -1, -1}, {37648, -1, -1, -1}, {36101, -1, -1, -1}, {22684, -1, -1, -1}, {32180, -1, -1, -1}, {35524, -1, -1, -1}, {28310, -1, -1, -1}, {28609, -1, -1, -1}, {36039, -1, -1, -1}, {28460, -1, -1, -1}, {32156, -1, -1, -1}, {32317, -1, -1, -1}, {32305, -1, -1, -1}, {37138, -1, -1, -1}, {35419, -1, -1, -1}, {32068, -1, -1, -1}, {38013, -1, -1, -1}, {21959, -1, -1, -1}, {21401, -1, -1, -1}, {21428, -1, -1, -1}, {38760, -1, -1, -1}, {36107, -1, -1, -1}, {21293, -1, -1, -1}, {21297, -1, -1, -1}, {36094, -1, -1, -1}, {21060, -1, -1, -1}, {21132, -1, -1, -1}, {21108, -1, -1, -1}, {20660, -1, -1, -1}, {20480, -1, -1, -1}, {20630, -1, -1, -1}, {20757, -1, -1, -1}, {20738, -1, -1, -1}, {20756, -1, -1, -1}, {20796, -1, -1, -1}, {20791, -1, -1, -1}, {20712, -1, -1, -1}, {20674, -1, -1, -1}, {20795, -1, -1, -1}, {20752, -1, -1, -1}, {20794, -1, -1, -1}, {20681, -1, -1, -1}, {31988, -1, -1, -1}, {40652, -1, -1, -1}, {22213, -1, -1, -1}, {40172, -1, -1, -1}, {35131, -1, -1, -1}, {33248, -1, -1, -1}, {35329, -1, -1, -1}, {35344, -1, -1, -1}, {35340, -1, -1, -1}, {35349, -1, -1, -1}, {35635, -1, -1, -1}, {35406, -1, -1, -1}, {35365, -1, -1, -1}, {35393, -1, -1, -1}, {35382, -1, -1, -1}, {35398, -1, -1, -1}, {35412, -1, -1, -1}, {35416, -1, -1, -1}, {35410, -1, -1, -1}, {35462, -1, -1, -1}, {35460, -1, -1, -1}, {35455, -1, -1, -1}, {35440, -1, -1, -1}, {35452, -1, -1, -1}, {35445, -1, -1, -1}, {35436, -1, -1, -1}, {35438, -1, -1, -1}, {35533, -1, -1, -1}, {35554, -1, -1, -1}, {35425, -1, -1, -1}, {35482, -1, -1, -1}, {35493, -1, -1, -1}, {35473, -1, -1, -1}, {35474, -1, -1, -1}, {35535, -1, -1, -1}, {35537, -1, -1, -1}, {35529, -1, -1, -1}, {35547, -1, -1, -1}, {35543, -1, -1, -1} },
    {{35522, -1, -1, -1}, {35510, -1, -1, -1}, {35574, -1, -1, -1}, {35563, -1, -1, -1}, {35604, -1, -1, -1}, {35585, -1, -1, -1}, {35556, -1, -1, -1}, {35565, -1, -1, -1}, {35580, -1, -1, -1}, {35571, -1, -1, -1}, {35558, -1, -1, -1}, {35566, -1, -1, -1}, {35550, -1, -1, -1}, {35624, -1, -1, -1}, {35740, -1, -1, -1}, {35606, -1, -1, -1}, {35610, -1, -1, -1}, {35600, -1, -1, -1}, {35627, -1, -1, -1}, {35629, -1, -1, -1}, {35670, -1, -1, -1}, {35673, -1, -1, -1}, {35662, -1, -1, -1}, {35742, -1, -1, -1}, {35691, -1, -1, -1}, {35734, -1, -1, -1}, {38488, -1, -1, -1}, {37178, -1, -1, -1}, {37140, -1, -1, -1}, {37172, -1, -1, -1}, {37087, -1, -1, -1}, {37174, -1, -1, -1}, {37126, -1, -1, -1}, {37192, -1, -1, -1}, {33467, -1, -1, -1}, {21233, -1, -1, -1}, {24048, -1, -1, -1}, {22538, -1, -1, -1}, {22745, -1, -1, -1}, {22754, -1, -1, -1}, {22752, -1, -1, -1}, {22746, -1, -1, -1}, {22497, -1, -1, -1}, {22607, -1, -1, -1}, {22550, -1, -1, -1}, {22610, -1, -1, -1}, {22557, -1, -1, -1}, {22628, -1, -1, -1}, {34188, -1, -1, -1}, {34131, -1, -1, -1}, {34294, -1, -1, -1}, {33703, -1, -1, -1}, {33799, -1, -1, -1}, {34031, -1, -1, -1}, {33511, -1, -1, -1}, {34338, -1, -1, -1}, {34086, -1, -1, -1}, {22603, -1, -1, -1}, {29026, -1, -1, -1}, {34136, -1, -1, -1}, {34045, -1, -1, -1}, {34126, -1, -1, -1}, {34184, -1, -1, -1}, {34234, -1, -1, -1}, {29334, -1, -1, -1}, {28366, -1, -1, -1}, {34113, -1, -1, -1}, {34254, -1, -1, -1}, {34130, -1, -1, -1}, {33984, -1, -1, -1}, {33874, -1, -1, -1}, {33892, -1, -1, -1}, {33940, -1, -1, -1}, {33845, -1, -1, -1}, {34207, -1, -1, -1}, {34133, -1, -1, -1}, {40367, -1, -1, -1}, {33939, -1, -1, -1}, {32264, -1, -1, -1}, {34118, -1, -1, -1}, {34146, -1, -1, -1}, {34078, -1, -1, -1}, {39488, -1, -1, -1}, {34362, -1, -1, -1}, {37795, -1, -1, -1}, {34167, -1, -1, -1}, {34334, -1, -1, -1}, {34298, -1, -1, -1}, {34308, -1, -1, -1}, {34282, -1, -1, -1}, {34330, -1, -1, -1}, {22889, -1, -1, -1}, {23607, -1, -1, -1}, {25451, -1, -1, -1}, {25718, -1, -1, -1}, {25759, -1, -1, -1}, {25681, -1, -1, -1}, {25692, -1, -1, -1}, {25779, -1, -1, -1}, {25860, -1, -1, -1}, {25878, -1, -1, -1}, {25847, -1, -1, -1}, {25852, -1, -1, -1}, {25883, -1, -1, -1}, {22064, -1, -1, -1}, {22072, -1, -1, -1}, {22216, -1, -1, -1}, {22182, -1, -1, -1}, {21764, -1, -1, -1}, {21692, -1, -1, -1}, {22144, -1, -1, -1}, {22109, -1, -1, -1}, {22112, -1, -1, -1}, {22069, -1, -1, -1}, {22006, -1, -1, -1}, {22118, -1, -1, -1}, {22130, -1, -1, -1}, {22156, -1, -1, -1}, {22117, -1, -1, -1}, {22044, -1, -1, -1}, {22062, -1, -1, -1}, {21993, -1, -1, -1}, {22038, -1, -1, -1}, {22208, -1, -1, -1}, {22029, -1, -1, -1}, {22195, -1, -1, -1}, {22209, -1, -1, -1}, {22127, -1, -1, -1}, {36705, -1, -1, -1}, {22198, -1, -1, -1}, {22165, -1, -1, -1}, {22279, -1, -1, -1}, {24131, -1, -1, -1}, {24172, -1, -1, -1}, {24152, -1, -1, -1}, {24151, -1, -1, -1}, {23943, -1, -1, -1}, {23796, -1, -1, -1}, {23888, -1, -1, -1}, {23852, -1, -1, -1}, {23975, -1, -1, -1}, {23968, -1, -1, -1}, {23959, -1, -1, -1}, {23821, -1, -1, -1}, {23992, -1, -1, -1}, {23937, -1, -1, -1}, {24020, -1, -1, -1}, {24480, -1, -1, -1}, {29559, -1, -1, -1}, {29505, -1, -1, -1}, {29546, -1, -1, -1}, {29499, -1, -1, -1}, {29547, -1, -1, -1}, {29568, -1, -1, -1}, {29564, -1, -1, -1}, {39136, -1, -1, -1}, {39219, -1, -1, -1}, {39145, -1, -1, -1}, {39228, -1, -1, -1}, {39146, -1, -1, -1}, {39147, -1, -1, -1}, {39149, -1, -1, -1}, {39156, -1, -1, -1}, {39177, -1, -1, -1}, {39185, -1, -1, -1}, {39195, -1, -1, -1}, {39223, -1, -1, -1}, {39231, -1, -1, -1}, {39235, -1, -1, -1}, {39240, -1, -1, -1}, {39241, -1, -1, -1}, {39242, -1, -1, -1}, {39244, -1, -1, -1}, {39266, -1, -1, -1}, {24289, -1, -1, -1}, {36065, -1, -1, -1}, {25082, -1, -1, -1}, {25006, -1, -1, -1}, {24938, -1, -1, -1}, {24894, -1, -1, -1}, {24757, -1, -1, -1}, {24884, -1, -1, -1}, {25036, -1, -1, -1}, {24927, -1, -1, -1}, {25064, -1, -1, -1}, {24827, -1, -1, -1}, {24887, -1, -1, -1}, {24818, -1, -1, -1}, {24947, -1, -1, -1}, {24860, -1, -1, -1}, {24978, -1, -1, -1}, {38274, -1, -1, -1}, {38278, -1, -1, -1}, {38344, -1, -1, -1}, {38286, -1, -1, -1}, {38292, -1, -1, -1}, {38284, -1, -1, -1}, {38373, -1, -1, -1}, {38317, -1, -1, -1}, {38315, -1, -1, -1}, {39726, -1, -1, -1}, {38316, -1, -1, -1}, {38334, -1, -1, -1}, {38326, -1, -1, -1}, {39721, -1, -1, -1}, {38335, -1, -1, -1}, {38333, -1, -1, -1}, {38332, -1, -1, -1}, {38339, -1, -1, -1}, {38347, -1, -1, -1}, {38356, -1, -1, -1}, {38352, -1, -1, -1}, {38357, -1, -1, -1}, {38366, -1, -1, -1}, {28739, -1, -1, -1}, {28505, -1, -1, -1}, {28711, -1, -1, -1}, {28696, -1, -1, -1}, {28668, -1, -1, -1}, {28039, -1, -1, -1}, {28025, -1, -1, -1}, {28254, -1, -1, -1}, {28590, -1, -1, -1}, {28687, -1, -1, -1}, {28408, -1, -1, -1}, {28527, -1, -1, -1}, {28150, -1, -1, -1}, {28543, -1, -1, -1}, {28678, -1, -1, -1}, {28576, -1, -1, -1}, {28683, -1, -1, -1}, {28775, -1, -1, -1}, {28740, -1, -1, -1}, {28677, -1, -1, -1}, {28535, -1, -1, -1}, {28704, -1, -1, -1}, {28703, -1, -1, -1}, {28722, -1, -1, -1}, {28712, -1, -1, -1}, {28765, -1, -1, -1}, {39467, -1, -1, -1}, {36999, -1, -1, -1}, {36885, -1, -1, -1}, {37008, -1, -1, -1}, {23656, -1, -1, -1}, {24371, -1, -1, -1}, {23285, -1, -1, -1}, {23255, -1, -1, -1}, {23296, -1, -1, -1}, {23149, -1, -1, -1}, {23304, -1, -1, -1}, {23372, -1, -1, -1}, {23207, -1, -1, -1}, {23291, -1, -1, -1}, {23307, -1, -1, -1}, {23329, -1, -1, -1} },
    {{23338, -1, -1, -1}, {23321, -1, -1, -1}, {39380, -1, -1, -1}, {39391, -1, -1, -1}, {39385, -1, -1, -1}, {39478, -1, -1, -1}, {39515, -1, -1, -1}, {39377, -1, -1, -1}, {39384, -1, -1, -1}, {39501, -1, -1, -1}, {39498, -1, -1, -1}, {39394, -1, -1, -1}, {39530, -1, -1, -1}, {39439, -1, -1, -1}, {39437, -1, -1, -1}, {39429, -1, -1, -1}, {39490, -1, -1, -1}, {39469, -1, -1, -1}, {39446, -1, -1, -1}, {39489, -1, -1, -1}, {39470, -1, -1, -1}, {39480, -1, -1, -1}, {39491, -1, -1, -1}, {39492, -1, -1, -1}, {39503, -1, -1, -1}, {39525, -1, -1, -1}, {39524, -1, -1, -1}, {31993, -1, -1, -1}, {32006, -1, -1, -1}, {32002, -1, -1, -1}, {32007, -1, -1, -1}, {32008, -1, -1, -1}, {32394, -1, -1, -1}, {32028, -1, -1, -1}, {32021, -1, -1, -1}, {32019, -1, -1, -1}, {32058, -1, -1, -1}, {32050, -1, -1, -1}, {32049, -1, -1, -1}, {32272, -1, -1, -1}, {32060, -1, -1, -1}, {32064, -1, -1, -1}, {32063, -1, -1, -1}, {32093, -1, -1, -1}, {32078, -1, -1, -1}, {32115, -1, -1, -1}, {32134, -1, -1, -1}, {32131, -1, -1, -1}, {32136, -1, -1, -1}, {32190, -1, -1, -1}, {32186, -1, -1, -1}, {32203, -1, -1, -1}, {32212, -1, -1, -1}, {32196, -1, -1, -1}, {32158, -1, -1, -1}, {32172, -1, -1, -1}, {32185, -1, -1, -1}, {32163, -1, -1, -1}, {32176, -1, -1, -1}, {32199, -1, -1, -1}, {32217, -1, -1, -1}, {32215, -1, -1, -1}, {32249, -1, -1, -1}, {32242, -1, -1, -1}, {32354, -1, -1, -1}, {32230, -1, -1, -1}, {32246, -1, -1, -1}, {32241, -1, -1, -1}, {32267, -1, -1, -1}, {32225, -1, -1, -1}, {32265, -1, -1, -1}, {32285, -1, -1, -1}, {32287, -1, -1, -1}, {32286, -1, -1, -1}, {32301, -1, -1, -1}, {32266, -1, -1, -1}, {32273, -1, -1, -1}, {32381, -1, -1, -1}, {32313, -1, -1, -1}, {32309, -1, -1, -1}, {32306, -1, -1, -1}, {32326, -1, -1, -1}, {32325, -1, -1, -1}, {32392, -1, -1, -1}, {32346, -1, -1, -1}, {32338, -1, -1, -1}, {32366, -1, -1, -1}, {32382, -1, -1, -1}, {32368, -1, -1, -1}, {32367, -1, -1, -1}, {32408, -1, -1, -1}, {29859, -1, -1, -1}, {29771, -1, -1, -1}, {29903, -1, -1, -1}, {38922, -1, -1, -1}, {29885, -1, -1, -1}, {29759, -1, -1, -1}, {29833, -1, -1, -1}, {29862, -1, -1, -1}, {29908, -1, -1, -1}, {29914, -1, -1, -1}, {38873, -1, -1, -1}, {38878, -1, -1, -1}, {38876, -1, -1, -1}, {27050, -1, -1, -1}, {27370, -1, -1, -1}, {26776, -1, -1, -1}, {26838, -1, -1, -1}, {27141, -1, -1, -1}, {26783, -1, -1, -1}, {27355, -1, -1, -1}, {27379, -1, -1, -1}, {27368, -1, -1, -1}, {27359, -1, -1, -1}, {27273, -1, -1, -1}, {26895, -1, -1, -1}, {27208, -1, -1, -1}, {26984, -1, -1, -1}, {27071, -1, -1, -1}, {27194, -1, -1, -1}, {27292, -1, -1, -1}, {27410, -1, -1, -1}, {27422, -1, -1, -1}, {27357, -1, -1, -1}, {27111, -1, -1, -1}, {27407, -1, -1, -1}, {27414, -1, -1, -1}, {27372, -1, -1, -1}, {27354, -1, -1, -1}, {27384, -1, -1, -1}, {27315, -1, -1, -1}, {27367, -1, -1, -1}, {27299, -1, -1, -1}, {27347, -1, -1, -1}, {27358, -1, -1, -1}, {27556, -1, -1, -1}, {27550, -1, -1, -1}, {27566, -1, -1, -1}, {27563, -1, -1, -1}, {27567, -1, -1, -1}, {36564, -1, -1, -1}, {36571, -1, -1, -1}, {36594, -1, -1, -1}, {36603, -1, -1, -1}, {36708, -1, -1, -1}, {36601, -1, -1, -1}, {36604, -1, -1, -1}, {36587, -1, -1, -1}, {36580, -1, -1, -1}, {36706, -1, -1, -1}, {36602, -1, -1, -1}, {36606, -1, -1, -1}, {36618, -1, -1, -1}, {36615, -1, -1, -1}, {36613, -1, -1, -1}, {36626, -1, -1, -1}, {36646, -1, -1, -1}, {36638, -1, -1, -1}, {36639, -1, -1, -1}, {36636, -1, -1, -1}, {36659, -1, -1, -1}, {36678, -1, -1, -1}, {36692, -1, -1, -1}, {25108, -1, -1, -1}, {25127, -1, -1, -1}, {29964, -1, -1, -1}, {26311, -1, -1, -1}, {26308, -1, -1, -1}, {26249, -1, -1, -1}, {26326, -1, -1, -1}, {36033, -1, -1, -1}, {36016, -1, -1, -1}, {36026, -1, -1, -1}, {36029, -1, -1, -1}, {36100, -1, -1, -1}, {36018, -1, -1, -1}, {36037, -1, -1, -1}, {36112, -1, -1, -1}, {36049, -1, -1, -1}, {36058, -1, -1, -1}, {36053, -1, -1, -1}, {36075, -1, -1, -1}, {36071, -1, -1, -1}, {36091, -1, -1, -1}, {35224, -1, -1, -1}, {35244, -1, -1, -1}, {35233, -1, -1, -1}, {35263, -1, -1, -1}, {35238, -1, -1, -1}, {35247, -1, -1, -1}, {35250, -1, -1, -1}, {35255, -1, -1, -1}, {27647, -1, -1, -1}, {27660, -1, -1, -1}, {27692, -1, -1, -1}, {29272, -1, -1, -1}, {26407, -1, -1, -1}, {33110, -1, -1, -1}, {33242, -1, -1, -1}, {33051, -1, -1, -1}, {33214, -1, -1, -1}, {33121, -1, -1, -1}, {33231, -1, -1, -1}, {27487, -1, -1, -1}, {39086, -1, -1, -1}, {39087, -1, -1, -1}, {39094, -1, -1, -1}, {39100, -1, -1, -1}, {39110, -1, -1, -1}, {39112, -1, -1, -1}, {36674, -1, -1, -1}, {40783, -1, -1, -1}, {26005, -1, -1, -1}, {29036, -1, -1, -1}, {29010, -1, -1, -1}, {29079, -1, -1, -1}, {29121, -1, -1, -1}, {29148, -1, -1, -1}, {29182, -1, -1, -1}, {31152, -1, -1, -1}, {31118, -1, -1, -1}, {31146, -1, -1, -1}, {25055, -1, -1, -1}, {24932, -1, -1, -1}, {25059, -1, -1, -1}, {25095, -1, -1, -1}, {28585, -1, -1, -1}, {30959, -1, -1, -1}, {30893, -1, -1, -1}, {30824, -1, -1, -1}, {30904, -1, -1, -1}, {31018, -1, -1, -1}, {31025, -1, -1, -1}, {30820, -1, -1, -1}, {30973, -1, -1, -1}, {30951, -1, -1, -1}, {30947, -1, -1, -1}, {40853, -1, -1, -1}, {30616, -1, -1, -1}, {30558, -1, -1, -1}, {30652, -1, -1, -1}, {32646, -1, -1, -1}, {32648, -1, -1, -1}, {37330, -1, -1, -1}, {37331, -1, -1, -1}, {37332, -1, -1, -1}, {37337, -1, -1, -1}, {37335, -1, -1, -1}, {37333, -1, -1, -1}, {37367, -1, -1, -1}, {37351, -1, -1, -1}, {37348, -1, -1, -1}, {37702, -1, -1, -1}, {37365, -1, -1, -1}, {37369, -1, -1, -1}, {37384, -1, -1, -1} },
    {{37414, -1, -1, -1}, {37445, -1, -1, -1}, {37393, -1, -1, -1}, {37392, -1, -1, -1}, {37377, -1, -1, -1}, {37415, -1, -1, -1}, {37380, -1, -1, -1}, {37413, -1, -1, -1}, {37376, -1, -1, -1}, {37434, -1, -1, -1}, {37478, -1, -1, -1}, {37431, -1, -1, -1}, {37427, -1, -1, -1}, {37461, -1, -1, -1}, {37437, -1, -1, -1}, {37432, -1, -1, -1}, {37470, -1, -1, -1}, {37484, -1, -1, -1}, {37485, -1, -1, -1}, {37439, -1, -1, -1}, {37984, -1, -1, -1}, {37424, -1, -1, -1}, {37449, -1, -1, -1}, {37448, -1, -1, -1}, {37453, -1, -1, -1}, {37422, -1, -1, -1}, {37433, -1, -1, -1}, {37944, -1, -1, -1}, {37548, -1, -1, -1}, {37536, -1, -1, -1}, {37498, -1, -1, -1}, {37546, -1, -1, -1}, {37614, -1, -1, -1}, {37583, -1, -1, -1}, {37891, -1, -1, -1}, {37603, -1, -1, -1}, {37946, -1, -1, -1}, {37553, -1, -1, -1}, {37542, -1, -1, -1}, {37799, -1, -1, -1}, {37526, -1, -1, -1}, {37580, -1, -1, -1}, {37545, -1, -1, -1}, {37877, -1, -1, -1}, {37523, -1, -1, -1}, {37503, -1, -1, -1}, {37801, -1, -1, -1}, {37530, -1, -1, -1}, {37658, -1, -1, -1}, {37547, -1, -1, -1}, {37507, -1, -1, -1}, {37899, -1, -1, -1}, {37544, -1, -1, -1}, {37539, -1, -1, -1}, {37906, -1, -1, -1}, {37688, -1, -1, -1}, {37617, -1, -1, -1}, {37847, -1, -1, -1}, {37605, -1, -1, -1}, {37616, -1, -1, -1}, {37615, -1, -1, -1}, {37608, -1, -1, -1}, {37564, -1, -1, -1}, {37597, -1, -1, -1}, {37622, -1, -1, -1}, {37926, -1, -1, -1}, {37927, -1, -1, -1}, {37571, -1, -1, -1}, {37599, -1, -1, -1}, {37606, -1, -1, -1}, {37650, -1, -1, -1}, {37638, -1, -1, -1}, {37737, -1, -1, -1}, {37659, -1, -1, -1}, {37696, -1, -1, -1}, {37633, -1, -1, -1}, {37653, -1, -1, -1}, {37678, -1, -1, -1}, {37699, -1, -1, -1}, {37639, -1, -1, -1}, {37640, -1, -1, -1}, {37663, -1, -1, -1}, {37657, -1, -1, -1}, {37733, -1, -1, -1}, {37703, -1, -1, -1}, {37750, -1, -1, -1}, {37716, -1, -1, -1}, {37732, -1, -1, -1}, {37802, -1, -1, -1}, {37744, -1, -1, -1}, {37764, -1, -1, -1}, {37860, -1, -1, -1}, {37848, -1, -1, -1}, {37928, -1, -1, -1}, {37767, -1, -1, -1}, {37836, -1, -1, -1}, {37784, -1, -1, -1}, {37816, -1, -1, -1}, {37823, -1, -1, -1}, {37798, -1, -1, -1}, {37808, -1, -1, -1}, {37813, -1, -1, -1}, {37964, -1, -1, -1}, {37858, -1, -1, -1}, {37852, -1, -1, -1}, {37853, -1, -1, -1}, {37837, -1, -1, -1}, {37854, -1, -1, -1}, {37827, -1, -1, -1}, {37831, -1, -1, -1}, {37841, -1, -1, -1}, {37908, -1, -1, -1}, {37917, -1, -1, -1}, {37879, -1, -1, -1}, {37989, -1, -1, -1}, {37907, -1, -1, -1}, {37997, -1, -1, -1}, {37920, -1, -1, -1}, {38009, -1, -1, -1}, {37881, -1, -1, -1}, {37913, -1, -1, -1}, {37962, -1, -1, -1}, {37938, -1, -1, -1}, {37951, -1, -1, -1}, {37972, -1, -1, -1}, {37987, -1, -1, -1}, {37758, -1, -1, -1}, {31329, -1, -1, -1}, {40169, -1, -1, -1}, {40182, -1, -1, -1}, {40199, -1, -1, -1}, {40198, -1, -1, -1}, {40227, -1, -1, -1}, {40327, -1, -1, -1}, {40469, -1, -1, -1}, {40221, -1, -1, -1}, {40223, -1, -1, -1}, {40421, -1, -1, -1}, {40239, -1, -1, -1}, {40409, -1, -1, -1}, {40240, -1, -1, -1}, {40258, -1, -1, -1}, {40478, -1, -1, -1}, {40275, -1, -1, -1}, {40477, -1, -1, -1}, {40288, -1, -1, -1}, {40274, -1, -1, -1}, {40435, -1, -1, -1}, {40284, -1, -1, -1}, {40289, -1, -1, -1}, {40339, -1, -1, -1}, {40298, -1, -1, -1}, {40303, -1, -1, -1}, {40329, -1, -1, -1}, {40344, -1, -1, -1}, {40346, -1, -1, -1}, {40384, -1, -1, -1}, {40357, -1, -1, -1}, {40361, -1, -1, -1}, {40386, -1, -1, -1}, {40380, -1, -1, -1}, {40474, -1, -1, -1}, {40403, -1, -1, -1}, {40410, -1, -1, -1}, {40431, -1, -1, -1}, {40422, -1, -1, -1}, {40434, -1, -1, -1}, {40440, -1, -1, -1}, {40460, -1, -1, -1}, {40442, -1, -1, -1}, {40475, -1, -1, -1}, {30308, -1, -1, -1}, {30296, -1, -1, -1}, {30311, -1, -1, -1}, {30210, -1, -1, -1}, {30278, -1, -1, -1}, {30279, -1, -1, -1}, {30281, -1, -1, -1}, {30238, -1, -1, -1}, {30267, -1, -1, -1}, {30317, -1, -1, -1}, {30318, -1, -1, -1}, {30313, -1, -1, -1}, {30322, -1, -1, -1}, {31431, -1, -1, -1}, {31414, -1, -1, -1}, {35168, -1, -1, -1}, {35123, -1, -1, -1}, {35165, -1, -1, -1}, {35143, -1, -1, -1}, {35128, -1, -1, -1}, {35172, -1, -1, -1}, {30392, -1, -1, -1}, {32814, -1, -1, -1}, {32812, -1, -1, -1}, {32889, -1, -1, -1}, {32885, -1, -1, -1}, {38919, -1, -1, -1}, {38926, -1, -1, -1}, {38927, -1, -1, -1}, {38945, -1, -1, -1}, {38940, -1, -1, -1}, {28481, -1, -1, -1}, {38950, -1, -1, -1}, {38967, -1, -1, -1}, {38990, -1, -1, -1}, {38995, -1, -1, -1}, {39027, -1, -1, -1}, {39010, -1, -1, -1}, {39001, -1, -1, -1}, {39013, -1, -1, -1}, {39020, -1, -1, -1}, {39024, -1, -1, -1}, {34787, -1, -1, -1}, {34822, -1, -1, -1}, {34566, -1, -1, -1}, {34851, -1, -1, -1}, {34806, -1, -1, -1}, {34554, -1, -1, -1}, {34799, -1, -1, -1}, {34692, -1, -1, -1}, {34832, -1, -1, -1}, {34760, -1, -1, -1}, {34833, -1, -1, -1}, {34747, -1, -1, -1}, {34766, -1, -1, -1}, {32588, -1, -1, -1}, {31716, -1, -1, -1}, {31591, -1, -1, -1}, {31849, -1, -1, -1}, {31731, -1, -1, -1}, {31744, -1, -1, -1}, {31691, -1, -1, -1}, {31836, -1, -1, -1}, {31774, -1, -1, -1}, {31787, -1, -1, -1}, {31779, -1, -1, -1}, {31850, -1, -1, -1}, {31839, -1, -1, -1}, {33380, -1, -1, -1}, {33387, -1, -1, -1}, {35018, -1, -1, -1}, {32677, -1, -1, -1}, {31986, -1, -1, -1}, {31990, -1, -1, -1}, {31965, -1, -1, -1}, {32310, -1, -1, -1}, {40617, -1, -1, -1}, {36274, -1, -1, -1}, {37317, -1, -1, -1}, {37315, -1, -1, -1}, {40570, -1, -1, -1}, {36489, -1, -1, -1}, {36428, -1, -1, -1}, {36498, -1, -1, -1}, {36474, -1, -1, -1} },
    {{36437, -1, -1, -1}, {36506, -1, -1, -1}, {36491, -1, -1, -1}, {36499, -1, -1, -1}, {36497, -1, -1, -1}, {36513, -1, -1, -1}, {36451, -1, -1, -1}, {36522, -1, -1, -1}, {36518, -1, -1, -1}, {35316, -1, -1, -1}, {35318, -1, -1, -1}, {38746, -1, -1, -1}, {38722, -1, -1, -1}, {38717, -1, -1, -1}, {38724, -1, -1, -1}, {40788, -1, -1, -1}, {40799, -1, -1, -1}, {40793, -1, -1, -1}, {40800, -1, -1, -1}, {40796, -1, -1, -1}, {40806, -1, -1, -1}, {40812, -1, -1, -1}, {40810, -1, -1, -1}, {40823, -1, -1, -1}, {12236, 40701, -1, -1}, {40703, -1, -1, -1}, {40713, -1, -1, -1}, {35726, -1, -1, -1}, {38014, -1, -1, -1}, {37864, -1, -1, -1}, {39799, -1, -1, -1}, {39796, -1, -1, -1}, {39809, -1, -1, -1}, {39811, -1, -1, -1}, {39822, -1, -1, -1}, {40056, -1, -1, -1}, {31308, -1, -1, -1}, {39826, -1, -1, -1}, {40031, -1, -1, -1}, {39824, -1, -1, -1}, {39853, -1, -1, -1}, {39834, -1, -1, -1}, {39850, -1, -1, -1}, {39838, -1, -1, -1}, {40045, -1, -1, -1}, {39851, -1, -1, -1}, {39837, -1, -1, -1}, {40024, -1, -1, -1}, {39873, -1, -1, -1}, {40058, -1, -1, -1}, {39985, -1, -1, -1}, {39993, -1, -1, -1}, {39971, -1, -1, -1}, {39991, -1, -1, -1}, {39872, -1, -1, -1}, {39882, -1, -1, -1}, {39879, -1, -1, -1}, {39933, -1, -1, -1}, {39894, -1, -1, -1}, {39914, -1, -1, -1}, {39915, -1, -1, -1}, {39905, -1, -1, -1}, {39908, -1, -1, -1}, {39911, -1, -1, -1}, {39901, -1, -1, -1}, {39906, -1, -1, -1}, {39920, -1, -1, -1}, {39899, -1, -1, -1}, {39924, -1, -1, -1}, {39892, -1, -1, -1}, {40029, -1, -1, -1}, {39944, -1, -1, -1}, {39952, -1, -1, -1}, {39949, -1, -1, -1}, {39954, -1, -1, -1}, {39945, -1, -1, -1}, {39935, -1, -1, -1}, {39968, -1, -1, -1}, {39986, -1, -1, -1}, {39981, -1, -1, -1}, {39976, -1, -1, -1}, {39973, -1, -1, -1}, {39977, -1, -1, -1}, {39987, -1, -1, -1}, {39998, -1, -1, -1}, {40008, -1, -1, -1}, {39995, -1, -1, -1}, {39989, -1, -1, -1}, {40005, -1, -1, -1}, {40022, -1, -1, -1}, {40020, -1, -1, -1}, {40018, -1, -1, -1}, {40039, -1, -1, -1}, {38851, -1, -1, -1}, {38845, -1, -1, -1}, {38857, -1, -1, -1}, {40379, -1, -1, -1}, {39631, -1, -1, -1}, {39638, -1, -1, -1}, {39637, -1, -1, -1}, {39768, -1, -1, -1}, {39758, -1, -1, -1}, {39255, -1, -1, -1}, {39260, -1, -1, -1}, {39714, -1, -1, -1}, {40695, -1, -1, -1}, {40690, -1, -1, -1}, {35180, -1, -1, -1}, {38342, -1, -1, -1}, {37686, -1, -1, -1}, {24390, -1, -1, -1}, {34068, -1, -1, -1}, {32404, -1, -1, -1}, {40803, -1, -1, -1}, {22137, -1, -1, -1}, {40725, -1, -1, -1}, {22081, -1, -1, -1}, {39662, -1, -1, -1}, {35079, -1, -1, -1}, {31296, -1, -1, -1}, {39091, -1, -1, -1}, {38308, -1, -1, -1}, {39693, -1, -1, -1}, {36852, -1, -1, -1}, {24409, -1, -1, -1}, {31339, -1, -1, -1}, {39138, -1, -1, -1}, {20642, -1, -1, -1}, {34193, -1, -1, -1}, {20760, -1, -1, -1}, {25458, -1, -1, -1}, {21067, -1, -1, -1}, {30543, -1, -1, -1}, {32397, -1, -1, -1}, {26310, -1, -1, -1}, {30637, -1, -1, -1}, {12228, 40565, -1, -1}, {22217, -1, -1, -1}, {40692, -1, -1, -1}, {28635, -1, -1, -1}, {25054, -1, -1, -1}, {30663, -1, -1, -1}, {28720, -1, -1, -1}, {40629, -1, -1, -1}, {34890, -1, -1, -1}, {38370, -1, -1, -1}, {38854, -1, -1, -1}, {31844, -1, -1, -1}, {32308, -1, -1, -1}, {38822, -1, -1, -1}, {40623, -1, -1, -1}, {22220, -1, -1, -1}, {39089, -1, -1, -1}, {27311, -1, -1, -1}, {32590, -1, -1, -1}, {31984, -1, -1, -1}, {20418, -1, -1, -1}, {32363, -1, -1, -1}, {40569, -1, -1, -1}, {22190, -1, -1, -1}, {39706, -1, -1, -1}, {33903, -1, -1, -1}, {31142, -1, -1, -1}, {31858, -1, -1, -1}, {39634, -1, -1, -1}, {38587, -1, -1, -1}, {32251, -1, -1, -1}, {35069, -1, -1, -1}, {30787, -1, -1, -1}, {8560, -1, -1, -1}, {8561, -1, -1, -1}, {8562, -1, -1, -1}, {8563, -1, -1, -1}, {8564, -1, -1, -1}, {8565, -1, -1, -1}, {8566, -1, -1, -1}, {8567, -1, -1, -1}, {8568, -1, -1, -1}, {8569, -1, -1, -1}, {714, -1, -1, -1}, {715, -1, -1, -1}, {729, -1, -1, -1}, {8211, -1, -1, -1}, {8213, -1, -1, -1}, {8229, -1, -1, -1}, {8245, -1, -1, -1}, {8453, -1, -1, -1}, {8457, -1, -1, -1}, {8598, -1, -1, -1}, {8599, -1, -1, -1}, {8600, -1, -1, -1}, {8601, -1, -1, -1}, {8725, -1, -1, -1}, {8735, -1, -1, -1}, {8739, -1, -1, -1}, {8786, -1, -1, -1}, {8806, -1, -1, -1}, {8807, -1, -1, -1}, {8895, -1, -1, -1}, {9552, -1, -1, -1}, {9553, -1, -1, -1}, {9554, -1, -1, -1}, {9555, -1, -1, -1}, {9556, -1, -1, -1}, {9557, -1, -1, -1}, {9558, -1, -1, -1}, {9559, -1, -1, -1}, {9560, -1, -1, -1}, {9561, -1, -1, -1}, {9562, -1, -1, -1}, {9563, -1, -1, -1}, {9564, -1, -1, -1}, {9565, -1, -1, -1}, {9566, -1, -1, -1}, {9567, -1, -1, -1}, {9568, -1, -1, -1}, {9569, -1, -1, -1}, {9570, -1, -1, -1}, {9571, -1, -1, -1}, {9572, -1, -1, -1}, {9573, -1, -1, -1}, {9574, -1, -1, -1}, {9575, -1, -1, -1}, {9576, -1, -1, -1}, {9577, -1, -1, -1}, {9578, -1, -1, -1}, {9579, -1, -1, -1}, {9580, -1, -1, -1}, {9581, -1, -1, -1}, {9582, -1, -1, -1}, {9583, -1, -1, -1}, {9584, -1, -1, -1}, {9585, -1, -1, -1}, {9586, -1, -1, -1}, {9587, -1, -1, -1}, {9601, -1, -1, -1}, {9602, -1, -1, -1}, {9603, -1, -1, -1}, {9604, -1, -1, -1}, {9605, -1, -1, -1}, {9606, -1, -1, -1}, {9607, -1, -1, -1}, {9608, -1, -1, -1}, {9609, -1, -1, -1}, {9610, -1, -1, -1}, {9611, -1, -1, -1}, {9612, -1, -1, -1}, {9613, -1, -1, -1}, {9614, -1, -1, -1}, {9615, -1, -1, -1}, {9619, -1, -1, -1}, {9620, -1, -1, -1}, {9621, -1, -1, -1}, {9660, -1, -1, -1}, {9661, -1, -1, -1}, {9698, -1, -1, -1} },
    {{9699, -1, -1, -1}, {9700, -1, -1, -1}, {9701, -1, -1, -1}, {9737, -1, -1, -1}, {8853, -1, -1, -1}, {12306, -1, -1, -1}, {12317, -1, -1, -1}, {12318, -1, -1, -1}, {12321, -1, -1, -1}, {12322, -1, -1, -1}, {12323, -1, -1, -1}, {12324, -1, -1, -1}, {12325, -1, -1, -1}, {12326, -1, -1, -1}, {12327, -1, -1, -1}, {12328, -1, -1, -1}, {12329, -1, -1, -1}, {12963, -1, -1, -1}, {13198, -1, -1, -1}, {13199, -1, -1, -1}, {13212, -1, -1, -1}, {13213, -1, -1, -1}, {13214, -1, -1, -1}, {13217, -1, -1, -1}, {13252, -1, -1, -1}, {13262, -1, -1, -1}, {13265, -1, -1, -1}, {13266, -1, -1, -1}, {13269, -1, -1, -1}, {65072, -1, -1, -1}, {65506, -1, -1, -1}, {65508, -1, -1, -1}, {8481, -1, -1, -1}, {12849, -1, -1, -1}, {8208, -1, -1, -1}, {12540, -1, -1, -1}, {12443, -1, -1, -1}, {12444, -1, -1, -1}, {12541, -1, -1, -1}, {12542, -1, -1, -1}, {12294, -1, -1, -1}, {12445, -1, -1, -1}, {12446, -1, -1, -1}, {65097, -1, -1, -1}, {65098, -1, -1, -1}, {65099, -1, -1, -1}, {65100, -1, -1, -1}, {65101, -1, -1, -1}, {65102, -1, -1, -1}, {65103, -1, -1, -1}, {65104, -1, -1, -1}, {65105, -1, -1, -1}, {65106, -1, -1, -1}, {65108, -1, -1, -1}, {65109, -1, -1, -1}, {65110, -1, -1, -1}, {65111, -1, -1, -1}, {65113, -1, -1, -1}, {65114, -1, -1, -1}, {65115, -1, -1, -1}, {65116, -1, -1, -1}, {65117, -1, -1, -1}, {65118, -1, -1, -1}, {65119, -1, -1, -1}, {65120, -1, -1, -1}, {65121, -1, -1, -1}, {65122, -1, -1, -1}, {65123, -1, -1, -1}, {65124, -1, -1, -1}, {65125, -1, -1, -1}, {65126, -1, -1, -1}, {65128, -1, -1, -1}, {65129, -1, -1, -1}, {65130, -1, -1, -1}, {65131, -1, -1, -1}, {12350, -1, -1, -1}, {12272, -1, -1, -1}, {12273, -1, -1, -1}, {12274, -1, -1, -1}, {12275, -1, -1, -1}, {12276, -1, -1, -1}, {12277, -1, -1, -1}, {12278, -1, -1, -1}, {12279, -1, -1, -1}, {12280, -1, -1, -1}, {12281, -1, -1, -1}, {12282, -1, -1, -1}, {12283, -1, -1, -1}, {19970, -1, -1, -1}, {19972, -1, -1, -1}, {19973, -1, -1, -1}, {19974, -1, -1, -1}, {19983, -1, -1, -1}, {19986, -1, -1, -1}, {19991, -1, -1, -1}, {19999, -1, -1, -1}, {20000, -1, -1, -1}, {20001, -1, -1, -1}, {20003, -1, -1, -1}, {20006, -1, -1, -1}, {20009, -1, -1, -1}, {20014, -1, -1, -1}, {20015, -1, -1, -1}, {20017, -1, -1, -1}, {20019, -1, -1, -1}, {20021, -1, -1, -1}, {20023, -1, -1, -1}, {20028, -1, -1, -1}, {20032, -1, -1, -1}, {20033, -1, -1, -1}, {20034, -1, -1, -1}, {20036, -1, -1, -1}, {20038, -1, -1, -1}, {20042, -1, -1, -1}, {20049, -1, -1, -1}, {20053, -1, -1, -1}, {20055, -1, -1, -1}, {20058, -1, -1, -1}, {20059, -1, -1, -1}, {20066, -1, -1, -1}, {20067, -1, -1, -1}, {20068, -1, -1, -1}, {20069, -1, -1, -1}, {20071, -1, -1, -1}, {20072, -1, -1, -1}, {20074, -1, -1, -1}, {20075, -1, -1, -1}, {20076, -1, -1, -1}, {20077, -1, -1, -1}, {20078, -1, -1, -1}, {20079, -1, -1, -1}, {20082, -1, -1, -1}, {20084, -1, -1, -1}, {20085, -1, -1, -1}, {20086, -1, -1, -1}, {20087, -1, -1, -1}, {20088, -1, -1, -1}, {20089, -1, -1, -1}, {20090, -1, -1, -1}, {20091, -1, -1, -1}, {20092, -1, -1, -1}, {20093, -1, -1, -1}, {20095, -1, -1, -1}, {20096, -1, -1, -1}, {20097, -1, -1, -1}, {20099, -1, -1, -1}, {20100, -1, -1, -1}, {12037, 20101, -1, -1}, {20103, -1, -1, -1}, {20106, -1, -1, -1}, {20112, -1, -1, -1}, {20118, -1, -1, -1}, {20119, -1, -1, -1}, {20121, -1, -1, -1}, {20124, -1, -1, -1}, {20125, -1, -1, -1}, {20131, -1, -1, -1}, {20138, -1, -1, -1}, {20143, -1, -1, -1}, {20144, -1, -1, -1}, {20145, -1, -1, -1}, {20148, -1, -1, -1}, {20150, -1, -1, -1}, {20151, -1, -1, -1}, {20152, -1, -1, -1}, {20153, -1, -1, -1}, {20156, -1, -1, -1}, {20157, -1, -1, -1}, {20158, -1, -1, -1}, {20168, -1, -1, -1}, {20172, -1, -1, -1}, {20175, -1, -1, -1}, {20176, -1, -1, -1}, {20178, -1, -1, -1}, {20186, -1, -1, -1}, {20187, -1, -1, -1}, {20188, -1, -1, -1}, {20192, -1, -1, -1}, {20194, -1, -1, -1}, {20198, -1, -1, -1}, {20199, -1, -1, -1}, {20201, -1, -1, -1}, {20205, -1, -1, -1}, {20206, -1, -1, -1}, {20207, -1, -1, -1}, {20209, -1, -1, -1}, {20212, -1, -1, -1}, {20216, -1, -1, -1}, {20217, -1, -1, -1}, {20218, -1, -1, -1}, {20220, -1, -1, -1}, {20222, -1, -1, -1}, {20224, -1, -1, -1}, {20226, -1, -1, -1}, {20227, -1, -1, -1}, {20228, -1, -1, -1}, {20229, -1, -1, -1}, {20230, -1, -1, -1}, {20231, -1, -1, -1}, {20232, -1, -1, -1}, {20235, -1, -1, -1}, {20236, -1, -1, -1}, {20242, -1, -1, -1}, {20243, -1, -1, -1}, {20244, -1, -1, -1}, {20245, -1, -1, -1}, {20246, -1, -1, -1}, {20252, -1, -1, -1}, {20253, -1, -1, -1}, {20257, -1, -1, -1}, {20259, -1, -1, -1}, {20264, -1, -1, -1}, {20265, -1, -1, -1}, {20268, -1, -1, -1}, {20269, -1, -1, -1}, {20270, -1, -1, -1}, {20273, -1, -1, -1}, {20275, -1, -1, -1}, {20277, -1, -1, -1}, {20279, -1, -1, -1}, {20281, -1, -1, -1}, {20283, -1, -1, -1}, {20286, -1, -1, -1}, {20287, -1, -1, -1}, {20288, -1, -1, -1}, {20289, -1, -1, -1}, {20290, -1, -1, -1}, {20292, -1, -1, -1}, {20293, -1, -1, -1}, {20295, -1, -1, -1}, {20296, -1, -1, -1}, {20297, -1, -1, -1}, {20298, -1, -1, -1}, {20299, -1, -1, -1}, {20300, -1, -1, -1}, {20306, -1, -1, -1}, {20308, -1, -1, -1}, {20310, -1, -1, -1}, {20321, -1, -1, -1}, {20322, -1, -1, -1}, {20326, -1, -1, -1}, {20328, -1, -1, -1}, {20330, -1, -1, -1}, {20331, -1, -1, -1}, {20333, -1, -1, -1}, {20334, -1, -1, -1}, {20337, -1, -1, -1}, {20338, -1, -1, -1}, {20341, -1, -1, -1}, {20343, -1, -1, -1}, {20344, -1, -1, -1}, {20345, -1, -1, -1}, {20346, -1, -1, -1}, {20349, -1, -1, -1}, {20352, -1, -1, -1}, {20353, -1, -1, -1} },
    {{20354, -1, -1, -1}, {20357, -1, -1, -1}, {20359, -1, -1, -1}, {20362, -1, -1, -1}, {20364, -1, -1, -1}, {20366, -1, -1, -1}, {20368, -1, -1, -1}, {20370, -1, -1, -1}, {20371, -1, -1, -1}, {20373, -1, -1, -1}, {20376, -1, -1, -1}, {20377, -1, -1, -1}, {20378, -1, -1, -1}, {20380, -1, -1, -1}, {20382, -1, -1, -1}, {20383, -1, -1, -1}, {20385, -1, -1, -1}, {20386, -1, -1, -1}, {20388, -1, -1, -1}, {20395, -1, -1, -1}, {20397, -1, -1, -1}, {20400, -1, -1, -1}, {20401, -1, -1, -1}, {20402, -1, -1, -1}, {20403, -1, -1, -1}, {20404, -1, -1, -1}, {20406, -1, -1, -1}, {20407, -1, -1, -1}, {20408, -1, -1, -1}, {20409, -1, -1, -1}, {20410, -1, -1, -1}, {20411, -1, -1, -1}, {20412, -1, -1, -1}, {20413, -1, -1, -1}, {20414, -1, -1, -1}, {20416, -1, -1, -1}, {20417, -1, -1, -1}, {20422, -1, -1, -1}, {20423, -1, -1, -1}, {20424, -1, -1, -1}, {20425, -1, -1, -1}, {20427, -1, -1, -1}, {20428, -1, -1, -1}, {20429, -1, -1, -1}, {20434, -1, -1, -1}, {20435, -1, -1, -1}, {20436, -1, -1, -1}, {20437, -1, -1, -1}, {20438, -1, -1, -1}, {20441, -1, -1, -1}, {20443, -1, -1, -1}, {20450, -1, -1, -1}, {20452, -1, -1, -1}, {20453, -1, -1, -1}, {20455, -1, -1, -1}, {20459, -1, -1, -1}, {20460, -1, -1, -1}, {20464, -1, -1, -1}, {20466, -1, -1, -1}, {20468, -1, -1, -1}, {20469, -1, -1, -1}, {20470, -1, -1, -1}, {20471, -1, -1, -1}, {20473, -1, -1, -1}, {20475, -1, -1, -1}, {20476, -1, -1, -1}, {20477, -1, -1, -1}, {20479, -1, -1, -1}, {20481, -1, -1, -1}, {20482, -1, -1, -1}, {20483, -1, -1, -1}, {20484, -1, -1, -1}, {20485, -1, -1, -1}, {20487, -1, -1, -1}, {20488, -1, -1, -1}, {20490, -1, -1, -1}, {20494, -1, -1, -1}, {20496, -1, -1, -1}, {20499, -1, -1, -1}, {20501, -1, -1, -1}, {20502, -1, -1, -1}, {20503, -1, -1, -1}, {20507, -1, -1, -1}, {20509, -1, -1, -1}, {20510, -1, -1, -1}, {20512, -1, -1, -1}, {20514, -1, -1, -1}, {20515, -1, -1, -1}, {20516, -1, -1, -1}, {20519, -1, -1, -1}, {20527, -1, -1, -1}, {20528, -1, -1, -1}, {20529, -1, -1, -1}, {20530, -1, -1, -1}, {20531, -1, -1, -1}, {20532, -1, -1, -1}, {20533, -1, -1, -1}, {20534, -1, -1, -1}, {20535, -1, -1, -1}, {20536, -1, -1, -1}, {20537, -1, -1, -1}, {20539, -1, -1, -1}, {20541, -1, -1, -1}, {20543, -1, -1, -1}, {20544, -1, -1, -1}, {20545, -1, -1, -1}, {20546, -1, -1, -1}, {20548, -1, -1, -1}, {20549, -1, -1, -1}, {20550, -1, -1, -1}, {20554, -1, -1, -1}, {20555, -1, -1, -1}, {20557, -1, -1, -1}, {20560, -1, -1, -1}, {20561, -1, -1, -1}, {20562, -1, -1, -1}, {20563, -1, -1, -1}, {20564, -1, -1, -1}, {20566, -1, -1, -1}, {20567, -1, -1, -1}, {20568, -1, -1, -1}, {20569, -1, -1, -1}, {20571, -1, -1, -1}, {20573, -1, -1, -1}, {20574, -1, -1, -1}, {20575, -1, -1, -1}, {20576, -1, -1, -1}, {20577, -1, -1, -1}, {20578, -1, -1, -1}, {20579, -1, -1, -1}, {20580, -1, -1, -1}, {20582, -1, -1, -1}, {20583, -1, -1, -1}, {20584, -1, -1, -1}, {20585, -1, -1, -1}, {20586, -1, -1, -1}, {20587, -1, -1, -1}, {20589, -1, -1, -1}, {20590, -1, -1, -1}, {20591, -1, -1, -1}, {20592, -1, -1, -1}, {20593, -1, -1, -1}, {20594, -1, -1, -1}, {20595, -1, -1, -1}, {20600, -1, -1, -1}, {20601, -1, -1, -1}, {20602, -1, -1, -1}, {20604, -1, -1, -1}, {20605, -1, -1, -1}, {20609, -1, -1, -1}, {20610, -1, -1, -1}, {20611, -1, -1, -1}, {20612, -1, -1, -1}, {20614, -1, -1, -1}, {20615, -1, -1, -1}, {20617, -1, -1, -1}, {20618, -1, -1, -1}, {20619, -1, -1, -1}, {20620, -1, -1, -1}, {20622, -1, -1, -1}, {20623, -1, -1, -1}, {20624, -1, -1, -1}, {20625, -1, -1, -1}, {20626, -1, -1, -1}, {20627, -1, -1, -1}, {20628, -1, -1, -1}, {20629, -1, -1, -1}, {20631, -1, -1, -1}, {20634, -1, -1, -1}, {20635, -1, -1, -1}, {20636, -1, -1, -1}, {20637, -1, -1, -1}, {20638, -1, -1, -1}, {20639, -1, -1, -1}, {20640, -1, -1, -1}, {20641, -1, -1, -1}, {20644, -1, -1, -1}, {20646, -1, -1, -1}, {20650, -1, -1, -1}, {20651, -1, -1, -1}, {20654, -1, -1, -1}, {20655, -1, -1, -1}, {20656, -1, -1, -1}, {20657, -1, -1, -1}, {20662, -1, -1, -1}, {20664, -1, -1, -1}, {20665, -1, -1, -1}, {20668, -1, -1, -1}, {20669, -1, -1, -1}, {20671, -1, -1, -1}, {20672, -1, -1, -1}, {20673, -1, -1, -1}, {20675, -1, -1, -1}, {20676, -1, -1, -1}, {20678, -1, -1, -1}, {20679, -1, -1, -1}, {20680, -1, -1, -1}, {20682, -1, -1, -1}, {20683, -1, -1, -1}, {20684, -1, -1, -1}, {20685, -1, -1, -1}, {20686, -1, -1, -1}, {20688, -1, -1, -1}, {20690, -1, -1, -1}, {20691, -1, -1, -1}, {20692, -1, -1, -1}, {20695, -1, -1, -1}, {20696, -1, -1, -1}, {20697, -1, -1, -1}, {20699, -1, -1, -1}, {20700, -1, -1, -1}, {20701, -1, -1, -1}, {20703, -1, -1, -1}, {20704, -1, -1, -1}, {20705, -1, -1, -1}, {20706, -1, -1, -1}, {20707, -1, -1, -1}, {20708, -1, -1, -1}, {20713, -1, -1, -1}, {20714, -1, -1, -1}, {20715, -1, -1, -1}, {20719, -1, -1, -1}, {20720, -1, -1, -1}, {20721, -1, -1, -1}, {20722, -1, -1, -1}, {20724, -1, -1, -1}, {20726, -1, -1, -1}, {20727, -1, -1, -1}, {20728, -1, -1, -1}, {20730, -1, -1, -1}, {20732, -1, -1, -1}, {20733, -1, -1, -1}, {20734, -1, -1, -1}, {20735, -1, -1, -1}, {20737, -1, -1, -1}, {20739, -1, -1, -1}, {20741, -1, -1, -1}, {20746, -1, -1, -1}, {20748, -1, -1, -1}, {20749, -1, -1, -1}, {20750, -1, -1, -1}, {20751, -1, -1, -1}, {20753, -1, -1, -1}, {20755, -1, -1, -1}, {20758, -1, -1, -1}, {20759, -1, -1, -1}, {20761, -1, -1, -1}, {20762, -1, -1, -1}, {20763, -1, -1, -1}, {20764, -1, -1, -1}, {20765, -1, -1, -1}, {20766, -1, -1, -1}, {20768, -1, -1, -1}, {20770, -1, -1, -1}, {20771, -1, -1, -1}, {20772, -1, -1, -1} },
    {{20773, -1, -1, -1}, {20774, -1, -1, -1}, {20775, -1, -1, -1}, {20776, -1, -1, -1}, {20777, -1, -1, -1}, {20779, -1, -1, -1}, {20780, -1, -1, -1}, {20781, -1, -1, -1}, {20782, -1, -1, -1}, {20783, -1, -1, -1}, {20784, -1, -1, -1}, {20785, -1, -1, -1}, {20787, -1, -1, -1}, {20788, -1, -1, -1}, {20789, -1, -1, -1}, {20790, -1, -1, -1}, {20792, -1, -1, -1}, {20793, -1, -1, -1}, {20797, -1, -1, -1}, {20798, -1, -1, -1}, {20802, -1, -1, -1}, {20807, -1, -1, -1}, {20810, -1, -1, -1}, {20812, -1, -1, -1}, {20814, -1, -1, -1}, {20815, -1, -1, -1}, {20816, -1, -1, -1}, {20819, -1, -1, -1}, {20823, -1, -1, -1}, {20824, -1, -1, -1}, {20825, -1, -1, -1}, {20827, -1, -1, -1}, {20829, -1, -1, -1}, {20830, -1, -1, -1}, {20831, -1, -1, -1}, {20832, -1, -1, -1}, {20833, -1, -1, -1}, {20835, -1, -1, -1}, {20836, -1, -1, -1}, {20838, -1, -1, -1}, {20839, -1, -1, -1}, {20842, -1, -1, -1}, {20847, -1, -1, -1}, {20850, -1, -1, -1}, {20858, -1, -1, -1}, {20862, -1, -1, -1}, {20863, -1, -1, -1}, {20867, -1, -1, -1}, {20868, -1, -1, -1}, {20870, -1, -1, -1}, {20871, -1, -1, -1}, {20874, -1, -1, -1}, {20875, -1, -1, -1}, {20878, -1, -1, -1}, {20879, -1, -1, -1}, {20880, -1, -1, -1}, {20881, -1, -1, -1}, {20883, -1, -1, -1}, {20884, -1, -1, -1}, {20888, -1, -1, -1}, {20890, -1, -1, -1}, {20893, -1, -1, -1}, {20894, -1, -1, -1}, {20895, -1, -1, -1}, {20897, -1, -1, -1}, {20899, -1, -1, -1}, {20902, -1, -1, -1}, {20903, -1, -1, -1}, {20904, -1, -1, -1}, {20905, -1, -1, -1}, {20906, -1, -1, -1}, {20909, -1, -1, -1}, {20910, -1, -1, -1}, {20916, -1, -1, -1}, {20920, -1, -1, -1}, {20921, -1, -1, -1}, {20922, -1, -1, -1}, {20926, -1, -1, -1}, {20927, -1, -1, -1}, {20929, -1, -1, -1}, {20930, -1, -1, -1}, {20931, -1, -1, -1}, {20933, -1, -1, -1}, {20936, -1, -1, -1}, {20938, -1, -1, -1}, {20942, -1, -1, -1}, {20944, -1, -1, -1}, {20946, -1, -1, -1}, {20947, -1, -1, -1}, {20948, -1, -1, -1}, {20949, -1, -1, -1}, {20950, -1, -1, -1}, {20951, -1, -1, -1}, {20952, -1, -1, -1}, {20953, -1, -1, -1}, {20954, -1, -1, -1}, {20956, -1, -1, -1}, {20958, -1, -1, -1}, {20959, -1, -1, -1}, {20962, -1, -1, -1}, {20963, -1, -1, -1}, {20965, -1, -1, -1}, {20966, -1, -1, -1}, {20967, -1, -1, -1}, {20968, -1, -1, -1}, {20969, -1, -1, -1}, {20970, -1, -1, -1}, {20972, -1, -1, -1}, {20974, -1, -1, -1}, {20978, -1, -1, -1}, {20980, -1, -1, -1}, {20983, -1, -1, -1}, {20990, -1, -1, -1}, {20996, -1, -1, -1}, {20997, -1, -1, -1}, {21001, -1, -1, -1}, {21003, -1, -1, -1}, {21004, -1, -1, -1}, {21007, -1, -1, -1}, {21008, -1, -1, -1}, {21011, -1, -1, -1}, {21012, -1, -1, -1}, {21013, -1, -1, -1}, {21020, -1, -1, -1}, {21022, -1, -1, -1}, {21023, -1, -1, -1}, {21025, -1, -1, -1}, {21026, -1, -1, -1}, {21027, -1, -1, -1}, {21029, -1, -1, -1}, {21030, -1, -1, -1}, {21031, -1, -1, -1}, {21034, -1, -1, -1}, {21036, -1, -1, -1}, {21039, -1, -1, -1}, {21041, -1, -1, -1}, {21042, -1, -1, -1}, {21044, -1, -1, -1}, {21045, -1, -1, -1}, {21052, -1, -1, -1}, {21054, -1, -1, -1}, {21061, -1, -1, -1}, {21062, -1, -1, -1}, {21064, -1, -1, -1}, {21065, -1, -1, -1}, {21070, -1, -1, -1}, {21071, -1, -1, -1}, {21074, -1, -1, -1}, {21075, -1, -1, -1}, {21077, -1, -1, -1}, {21079, -1, -1, -1}, {21080, -1, -1, -1}, {21081, -1, -1, -1}, {21082, -1, -1, -1}, {21085, -1, -1, -1}, {21087, -1, -1, -1}, {21088, -1, -1, -1}, {21090, -1, -1, -1}, {21091, -1, -1, -1}, {21092, -1, -1, -1}, {21094, -1, -1, -1}, {21096, -1, -1, -1}, {21099, -1, -1, -1}, {21100, -1, -1, -1}, {21101, -1, -1, -1}, {21104, -1, -1, -1}, {21105, -1, -1, -1}, {21107, -1, -1, -1}, {21110, -1, -1, -1}, {21111, -1, -1, -1}, {21112, -1, -1, -1}, {21113, -1, -1, -1}, {21114, -1, -1, -1}, {21115, -1, -1, -1}, {21116, -1, -1, -1}, {21118, -1, -1, -1}, {21120, -1, -1, -1}, {21124, -1, -1, -1}, {21125, -1, -1, -1}, {21126, -1, -1, -1}, {21131, -1, -1, -1}, {21134, -1, -1, -1}, {21135, -1, -1, -1}, {21138, -1, -1, -1}, {21140, -1, -1, -1}, {21141, -1, -1, -1}, {21142, -1, -1, -1}, {21143, -1, -1, -1}, {21144, -1, -1, -1}, {21145, -1, -1, -1}, {21146, -1, -1, -1}, {21148, -1, -1, -1}, {21156, -1, -1, -1}, {21157, -1, -1, -1}, {21158, -1, -1, -1}, {21159, -1, -1, -1}, {21166, -1, -1, -1}, {21167, -1, -1, -1}, {21168, -1, -1, -1}, {21172, -1, -1, -1}, {21173, -1, -1, -1}, {21174, -1, -1, -1}, {21175, -1, -1, -1}, {21176, -1, -1, -1}, {21177, -1, -1, -1}, {21178, -1, -1, -1}, {21179, -1, -1, -1}, {21180, -1, -1, -1}, {21181, -1, -1, -1}, {21184, -1, -1, -1}, {21186, -1, -1, -1}, {21188, -1, -1, -1}, {21189, -1, -1, -1}, {21190, -1, -1, -1}, {21192, -1, -1, -1}, {21194, -1, -1, -1}, {21196, -1, -1, -1}, {21197, -1, -1, -1}, {21198, -1, -1, -1}, {21199, -1, -1, -1}, {21201, -1, -1, -1}, {21203, -1, -1, -1}, {21204, -1, -1, -1}, {21207, -1, -1, -1}, {21210, -1, -1, -1}, {21212, -1, -1, -1}, {21216, -1, -1, -1}, {21217, -1, -1, -1}, {21219, -1, -1, -1}, {21221, -1, -1, -1}, {21222, -1, -1, -1}, {21223, -1, -1, -1}, {21224, -1, -1, -1}, {21225, -1, -1, -1}, {21226, -1, -1, -1}, {21227, -1, -1, -1}, {21228, -1, -1, -1}, {21229, -1, -1, -1}, {21230, -1, -1, -1}, {21231, -1, -1, -1}, {21234, -1, -1, -1}, {21235, -1, -1, -1}, {21236, -1, -1, -1}, {21238, -1, -1, -1}, {21239, -1, -1, -1}, {21243, -1, -1, -1}, {21244, -1, -1, -1}, {21245, -1, -1, -1}, {21249, -1, -1, -1}, {21250, -1, -1, -1}, {21251, -1, -1, -1}, {21252, -1, -1, -1}, {21255, -1, -1, -1}, {21257, -1, -1, -1}, {21258, -1, -1, -1}, {21259, -1, -1, -1} },
    {{21260, -1, -1, -1}, {21262, -1, -1, -1}, {21265, -1, -1, -1}, {21266, -1, -1, -1}, {21267, -1, -1, -1}, {21268, -1, -1, -1}, {21272, -1, -1, -1}, {21275, -1, -1, -1}, {21276, -1, -1, -1}, {21278, -1, -1, -1}, {21279, -1, -1, -1}, {21282, -1, -1, -1}, {21284, -1, -1, -1}, {21285, -1, -1, -1}, {21287, -1, -1, -1}, {21288, -1, -1, -1}, {21289, -1, -1, -1}, {21291, -1, -1, -1}, {21292, -1, -1, -1}, {21296, -1, -1, -1}, {21298, -1, -1, -1}, {21299, -1, -1, -1}, {21300, -1, -1, -1}, {21301, -1, -1, -1}, {21302, -1, -1, -1}, {21303, -1, -1, -1}, {12054, 21304, -1, -1}, {21308, -1, -1, -1}, {21309, -1, -1, -1}, {21314, -1, -1, -1}, {21316, -1, -1, -1}, {21318, -1, -1, -1}, {21323, -1, -1, -1}, {21324, -1, -1, -1}, {21325, -1, -1, -1}, {21328, -1, -1, -1}, {21336, -1, -1, -1}, {21337, -1, -1, -1}, {21339, -1, -1, -1}, {21341, -1, -1, -1}, {21349, -1, -1, -1}, {21352, -1, -1, -1}, {21354, -1, -1, -1}, {21356, -1, -1, -1}, {21357, -1, -1, -1}, {21362, -1, -1, -1}, {21366, -1, -1, -1}, {21369, -1, -1, -1}, {21371, -1, -1, -1}, {21372, -1, -1, -1}, {21373, -1, -1, -1}, {21374, -1, -1, -1}, {21376, -1, -1, -1}, {21377, -1, -1, -1}, {21379, -1, -1, -1}, {21383, -1, -1, -1}, {21384, -1, -1, -1}, {21386, -1, -1, -1}, {21390, -1, -1, -1}, {21391, -1, -1, -1}, {21392, -1, -1, -1}, {21393, -1, -1, -1}, {21394, -1, -1, -1}, {21395, -1, -1, -1}, {21396, -1, -1, -1}, {21398, -1, -1, -1}, {21399, -1, -1, -1}, {21403, -1, -1, -1}, {21404, -1, -1, -1}, {21406, -1, -1, -1}, {21409, -1, -1, -1}, {21412, -1, -1, -1}, {21415, -1, -1, -1}, {21418, -1, -1, -1}, {21419, -1, -1, -1}, {21420, -1, -1, -1}, {21423, -1, -1, -1}, {21424, -1, -1, -1}, {21425, -1, -1, -1}, {21427, -1, -1, -1}, {21429, -1, -1, -1}, {21431, -1, -1, -1}, {21432, -1, -1, -1}, {21433, -1, -1, -1}, {21434, -1, -1, -1}, {21436, -1, -1, -1}, {21437, -1, -1, -1}, {21438, -1, -1, -1}, {21440, -1, -1, -1}, {21444, -1, -1, -1}, {21445, -1, -1, -1}, {21446, -1, -1, -1}, {21447, -1, -1, -1}, {21454, -1, -1, -1}, {21455, -1, -1, -1}, {21456, -1, -1, -1}, {21458, -1, -1, -1}, {21459, -1, -1, -1}, {21461, -1, -1, -1}, {21466, -1, -1, -1}, {21468, -1, -1, -1}, {21469, -1, -1, -1}, {21470, -1, -1, -1}, {21473, -1, -1, -1}, {21479, -1, -1, -1}, {21492, -1, -1, -1}, {21498, -1, -1, -1}, {21502, -1, -1, -1}, {21503, -1, -1, -1}, {21504, -1, -1, -1}, {21506, -1, -1, -1}, {21509, -1, -1, -1}, {21511, -1, -1, -1}, {21515, -1, -1, -1}, {21524, -1, -1, -1}, {21528, -1, -1, -1}, {21529, -1, -1, -1}, {21530, -1, -1, -1}, {21532, -1, -1, -1}, {21538, -1, -1, -1}, {21540, -1, -1, -1}, {21541, -1, -1, -1}, {21546, -1, -1, -1}, {21552, -1, -1, -1}, {21555, -1, -1, -1}, {21558, -1, -1, -1}, {21559, -1, -1, -1}, {21562, -1, -1, -1}, {21565, -1, -1, -1}, {21567, -1, -1, -1}, {21569, -1, -1, -1}, {21570, -1, -1, -1}, {21572, -1, -1, -1}, {21573, -1, -1, -1}, {21575, -1, -1, -1}, {21577, -1, -1, -1}, {21580, -1, -1, -1}, {21581, -1, -1, -1}, {21582, -1, -1, -1}, {21583, -1, -1, -1}, {21585, -1, -1, -1}, {21594, -1, -1, -1}, {21597, -1, -1, -1}, {21598, -1, -1, -1}, {21599, -1, -1, -1}, {21600, -1, -1, -1}, {21601, -1, -1, -1}, {21603, -1, -1, -1}, {21605, -1, -1, -1}, {21607, -1, -1, -1}, {21609, -1, -1, -1}, {21610, -1, -1, -1}, {21611, -1, -1, -1}, {21612, -1, -1, -1}, {21613, -1, -1, -1}, {21614, -1, -1, -1}, {21615, -1, -1, -1}, {21616, -1, -1, -1}, {21620, -1, -1, -1}, {21625, -1, -1, -1}, {21626, -1, -1, -1}, {21630, -1, -1, -1}, {21631, -1, -1, -1}, {21633, -1, -1, -1}, {21635, -1, -1, -1}, {21637, -1, -1, -1}, {21639, -1, -1, -1}, {21640, -1, -1, -1}, {21641, -1, -1, -1}, {21642, -1, -1, -1}, {21645, -1, -1, -1}, {21649, -1, -1, -1}, {21651, -1, -1, -1}, {21655, -1, -1, -1}, {21656, -1, -1, -1}, {21660, -1, -1, -1}, {21662, -1, -1, -1}, {21663, -1, -1, -1}, {21664, -1, -1, -1}, {21665, -1, -1, -1}, {21666, -1, -1, -1}, {21669, -1, -1, -1}, {21678, -1, -1, -1}, {21680, -1, -1, -1}, {21682, -1, -1, -1}, {21685, -1, -1, -1}, {21686, -1, -1, -1}, {21687, -1, -1, -1}, {21689, -1, -1, -1}, {21690, -1, -1, -1}, {21694, -1, -1, -1}, {21699, -1, -1, -1}, {21701, -1, -1, -1}, {21706, -1, -1, -1}, {21707, -1, -1, -1}, {21718, -1, -1, -1}, {21720, -1, -1, -1}, {21723, -1, -1, -1}, {21728, -1, -1, -1}, {21730, -1, -1, -1}, {21731, -1, -1, -1}, {21732, -1, -1, -1}, {21739, -1, -1, -1}, {21740, -1, -1, -1}, {21743, -1, -1, -1}, {21744, -1, -1, -1}, {21745, -1, -1, -1}, {21748, -1, -1, -1}, {21749, -1, -1, -1}, {21750, -1, -1, -1}, {21751, -1, -1, -1}, {21752, -1, -1, -1}, {21753, -1, -1, -1}, {21755, -1, -1, -1}, {21758, -1, -1, -1}, {21760, -1, -1, -1}, {21762, -1, -1, -1}, {21763, -1, -1, -1}, {21765, -1, -1, -1}, {21768, -1, -1, -1}, {21770, -1, -1, -1}, {21771, -1, -1, -1}, {21772, -1, -1, -1}, {21773, -1, -1, -1}, {21774, -1, -1, -1}, {21778, -1, -1, -1}, {21779, -1, -1, -1}, {21781, -1, -1, -1}, {21782, -1, -1, -1}, {21783, -1, -1, -1}, {21784, -1, -1, -1}, {21785, -1, -1, -1}, {21786, -1, -1, -1}, {21788, -1, -1, -1}, {21789, -1, -1, -1}, {21790, -1, -1, -1}, {21791, -1, -1, -1}, {21793, -1, -1, -1}, {21797, -1, -1, -1}, {21798, -1, -1, -1}, {21800, -1, -1, -1}, {21801, -1, -1, -1}, {21803, -1, -1, -1}, {21805, -1, -1, -1}, {21810, -1, -1, -1}, {21812, -1, -1, -1}, {21813, -1, -1, -1}, {21814, -1, -1, -1}, {21816, -1, -1, -1}, {21817, -1, -1, -1}, {21818, -1, -1, -1}, {21819, -1, -1, -1}, {21821, -1, -1, -1}, {21824, -1, -1, -1}, {21826, -1, -1, -1}, {21829, -1, -1, -1} },
    {{21831, -1, -1, -1}, {21832, -1, -1, -1}, {21835, -1, -1, -1}, {21836, -1, -1, -1}, {21837, -1, -1, -1}, {21838, -1, -1, -1}, {21841, -1, -1, -1}, {21842, -1, -1, -1}, {21844, -1, -1, -1}, {21847, -1, -1, -1}, {21848, -1, -1, -1}, {21849, -1, -1, -1}, {21850, -1, -1, -1}, {21851, -1, -1, -1}, {21853, -1, -1, -1}, {21855, -1, -1, -1}, {21856, -1, -1, -1}, {21858, -1, -1, -1}, {21859, -1, -1, -1}, {21864, -1, -1, -1}, {21865, -1, -1, -1}, {21867, -1, -1, -1}, {21871, -1, -1, -1}, {21872, -1, -1, -1}, {21873, -1, -1, -1}, {21874, -1, -1, -1}, {21875, -1, -1, -1}, {21876, -1, -1, -1}, {21881, -1, -1, -1}, {21882, -1, -1, -1}, {21885, -1, -1, -1}, {21887, -1, -1, -1}, {21893, -1, -1, -1}, {21894, -1, -1, -1}, {21900, -1, -1, -1}, {21901, -1, -1, -1}, {21902, -1, -1, -1}, {21904, -1, -1, -1}, {21906, -1, -1, -1}, {21907, -1, -1, -1}, {21909, -1, -1, -1}, {21910, -1, -1, -1}, {21911, -1, -1, -1}, {21914, -1, -1, -1}, {21915, -1, -1, -1}, {21918, -1, -1, -1}, {21920, -1, -1, -1}, {21921, -1, -1, -1}, {21922, -1, -1, -1}, {21923, -1, -1, -1}, {21924, -1, -1, -1}, {21925, -1, -1, -1}, {21926, -1, -1, -1}, {21928, -1, -1, -1}, {21929, -1, -1, -1}, {21931, -1, -1, -1}, {21933, -1, -1, -1}, {21935, -1, -1, -1}, {21936, -1, -1, -1}, {21940, -1, -1, -1}, {21942, -1, -1, -1}, {21944, -1, -1, -1}, {21946, -1, -1, -1}, {21948, -1, -1, -1}, {21951, -1, -1, -1}, {21952, -1, -1, -1}, {21953, -1, -1, -1}, {21954, -1, -1, -1}, {21955, -1, -1, -1}, {21960, -1, -1, -1}, {21962, -1, -1, -1}, {21963, -1, -1, -1}, {21967, -1, -1, -1}, {21968, -1, -1, -1}, {21973, -1, -1, -1}, {21975, -1, -1, -1}, {21976, -1, -1, -1}, {21977, -1, -1, -1}, {21979, -1, -1, -1}, {21982, -1, -1, -1}, {21984, -1, -1, -1}, {21986, -1, -1, -1}, {21991, -1, -1, -1}, {21997, -1, -1, -1}, {21998, -1, -1, -1}, {22000, -1, -1, -1}, {22001, -1, -1, -1}, {22004, -1, -1, -1}, {22008, -1, -1, -1}, {22009, -1, -1, -1}, {22010, -1, -1, -1}, {22011, -1, -1, -1}, {22012, -1, -1, -1}, {22015, -1, -1, -1}, {22018, -1, -1, -1}, {22019, -1, -1, -1}, {22020, -1, -1, -1}, {22021, -1, -1, -1}, {22023, -1, -1, -1}, {22026, -1, -1, -1}, {22027, -1, -1, -1}, {22032, -1, -1, -1}, {22033, -1, -1, -1}, {22034, -1, -1, -1}, {22035, -1, -1, -1}, {22037, -1, -1, -1}, {22041, -1, -1, -1}, {22042, -1, -1, -1}, {22045, -1, -1, -1}, {22048, -1, -1, -1}, {22049, -1, -1, -1}, {22050, -1, -1, -1}, {22053, -1, -1, -1}, {22054, -1, -1, -1}, {22056, -1, -1, -1}, {22058, -1, -1, -1}, {22059, -1, -1, -1}, {22067, -1, -1, -1}, {22071, -1, -1, -1}, {22074, -1, -1, -1}, {22076, -1, -1, -1}, {22077, -1, -1, -1}, {22078, -1, -1, -1}, {22080, -1, -1, -1}, {22082, -1, -1, -1}, {22083, -1, -1, -1}, {22084, -1, -1, -1}, {22085, -1, -1, -1}, {22086, -1, -1, -1}, {22087, -1, -1, -1}, {22088, -1, -1, -1}, {22089, -1, -1, -1}, {22090, -1, -1, -1}, {22091, -1, -1, -1}, {22095, -1, -1, -1}, {22096, -1, -1, -1}, {22097, -1, -1, -1}, {22098, -1, -1, -1}, {22099, -1, -1, -1}, {22101, -1, -1, -1}, {22102, -1, -1, -1}, {22106, -1, -1, -1}, {22107, -1, -1, -1}, {22110, -1, -1, -1}, {22111, -1, -1, -1}, {22113, -1, -1, -1}, {22115, -1, -1, -1}, {22119, -1, -1, -1}, {22125, -1, -1, -1}, {22126, -1, -1, -1}, {22128, -1, -1, -1}, {22131, -1, -1, -1}, {22133, -1, -1, -1}, {22135, -1, -1, -1}, {22138, -1, -1, -1}, {22141, -1, -1, -1}, {22142, -1, -1, -1}, {22143, -1, -1, -1}, {22145, -1, -1, -1}, {22146, -1, -1, -1}, {22147, -1, -1, -1}, {22148, -1, -1, -1}, {22152, -1, -1, -1}, {22153, -1, -1, -1}, {22154, -1, -1, -1}, {22155, -1, -1, -1}, {22157, -1, -1, -1}, {22160, -1, -1, -1}, {22161, -1, -1, -1}, {22162, -1, -1, -1}, {22164, -1, -1, -1}, {22166, -1, -1, -1}, {22167, -1, -1, -1}, {22168, -1, -1, -1}, {22170, -1, -1, -1}, {22171, -1, -1, -1}, {22172, -1, -1, -1}, {22173, -1, -1, -1}, {22174, -1, -1, -1}, {22175, -1, -1, -1}, {22176, -1, -1, -1}, {22177, -1, -1, -1}, {22178, -1, -1, -1}, {22180, -1, -1, -1}, {22181, -1, -1, -1}, {22183, -1, -1, -1}, {22185, -1, -1, -1}, {22186, -1, -1, -1}, {22187, -1, -1, -1}, {22188, -1, -1, -1}, {22189, -1, -1, -1}, {22192, -1, -1, -1}, {22193, -1, -1, -1}, {22194, -1, -1, -1}, {22197, -1, -1, -1}, {22200, -1, -1, -1}, {22201, -1, -1, -1}, {22202, -1, -1, -1}, {22203, -1, -1, -1}, {22205, -1, -1, -1}, {22206, -1, -1, -1}, {22207, -1, -1, -1}, {22211, -1, -1, -1}, {22212, -1, -1, -1}, {22214, -1, -1, -1}, {22215, -1, -1, -1}, {22219, -1, -1, -1}, {22221, -1, -1, -1}, {22222, -1, -1, -1}, {22223, -1, -1, -1}, {22224, -1, -1, -1}, {22226, -1, -1, -1}, {22227, -1, -1, -1}, {22229, -1, -1, -1}, {22230, -1, -1, -1}, {22232, -1, -1, -1}, {22233, -1, -1, -1}, {22236, -1, -1, -1}, {22243, -1, -1, -1}, {22245, -1, -1, -1}, {22246, -1, -1, -1}, {22247, -1, -1, -1}, {22248, -1, -1, -1}, {22249, -1, -1, -1}, {22250, -1, -1, -1}, {22252, -1, -1, -1}, {22254, -1, -1, -1}, {22255, -1, -1, -1}, {22258, -1, -1, -1}, {22259, -1, -1, -1}, {22262, -1, -1, -1}, {22263, -1, -1, -1}, {22264, -1, -1, -1}, {22267, -1, -1, -1}, {22268, -1, -1, -1}, {22272, -1, -1, -1}, {22273, -1, -1, -1}, {22274, -1, -1, -1}, {22277, -1, -1, -1}, {22284, -1, -1, -1}, {22286, -1, -1, -1}, {22287, -1, -1, -1}, {22288, -1, -1, -1}, {22289, -1, -1, -1}, {22292, -1, -1, -1}, {22293, -1, -1, -1}, {22295, -1, -1, -1}, {22297, -1, -1, -1}, {22298, -1, -1, -1}, {22299, -1, -1, -1}, {22301, -1, -1, -1}, {22302, -1, -1, -1}, {22304, -1, -1, -1}, {22305, -1, -1, -1}, {22306, -1, -1, -1}, {22308, -1, -1, -1} },
    {{22309, -1, -1, -1}, {22310, -1, -1, -1}, {22311, -1, -1, -1}, {22315, -1, -1, -1}, {22321, -1, -1, -1}, {22322, -1, -1, -1}, {22324, -1, -1, -1}, {22325, -1, -1, -1}, {22326, -1, -1, -1}, {22327, -1, -1, -1}, {22328, -1, -1, -1}, {22332, -1, -1, -1}, {22333, -1, -1, -1}, {22335, -1, -1, -1}, {22337, -1, -1, -1}, {22339, -1, -1, -1}, {22340, -1, -1, -1}, {22341, -1, -1, -1}, {22342, -1, -1, -1}, {22344, -1, -1, -1}, {22345, -1, -1, -1}, {22347, -1, -1, -1}, {22354, -1, -1, -1}, {22355, -1, -1, -1}, {22356, -1, -1, -1}, {22357, -1, -1, -1}, {22358, -1, -1, -1}, {22360, -1, -1, -1}, {22361, -1, -1, -1}, {22370, -1, -1, -1}, {22371, -1, -1, -1}, {22373, -1, -1, -1}, {22375, -1, -1, -1}, {22380, -1, -1, -1}, {22382, -1, -1, -1}, {22384, -1, -1, -1}, {22385, -1, -1, -1}, {22386, -1, -1, -1}, {22388, -1, -1, -1}, {22389, -1, -1, -1}, {22392, -1, -1, -1}, {22393, -1, -1, -1}, {22394, -1, -1, -1}, {22397, -1, -1, -1}, {22398, -1, -1, -1}, {22399, -1, -1, -1}, {22400, -1, -1, -1}, {22401, -1, -1, -1}, {22407, -1, -1, -1}, {22408, -1, -1, -1}, {22409, -1, -1, -1}, {22410, -1, -1, -1}, {22413, -1, -1, -1}, {22414, -1, -1, -1}, {22415, -1, -1, -1}, {22416, -1, -1, -1}, {22417, -1, -1, -1}, {22420, -1, -1, -1}, {22421, -1, -1, -1}, {22422, -1, -1, -1}, {22423, -1, -1, -1}, {22424, -1, -1, -1}, {22425, -1, -1, -1}, {22426, -1, -1, -1}, {22428, -1, -1, -1}, {22429, -1, -1, -1}, {22430, -1, -1, -1}, {22431, -1, -1, -1}, {22437, -1, -1, -1}, {22440, -1, -1, -1}, {22442, -1, -1, -1}, {22444, -1, -1, -1}, {22447, -1, -1, -1}, {22448, -1, -1, -1}, {22449, -1, -1, -1}, {22451, -1, -1, -1}, {22453, -1, -1, -1}, {22454, -1, -1, -1}, {22455, -1, -1, -1}, {22457, -1, -1, -1}, {22458, -1, -1, -1}, {22459, -1, -1, -1}, {22460, -1, -1, -1}, {22461, -1, -1, -1}, {22462, -1, -1, -1}, {22463, -1, -1, -1}, {22464, -1, -1, -1}, {22465, -1, -1, -1}, {22468, -1, -1, -1}, {22469, -1, -1, -1}, {22470, -1, -1, -1}, {22471, -1, -1, -1}, {22472, -1, -1, -1}, {22473, -1, -1, -1}, {22474, -1, -1, -1}, {22476, -1, -1, -1}, {22477, -1, -1, -1}, {22480, -1, -1, -1}, {22481, -1, -1, -1}, {22483, -1, -1, -1}, {22486, -1, -1, -1}, {22487, -1, -1, -1}, {22491, -1, -1, -1}, {22492, -1, -1, -1}, {22494, -1, -1, -1}, {22498, -1, -1, -1}, {22499, -1, -1, -1}, {22501, -1, -1, -1}, {22502, -1, -1, -1}, {22503, -1, -1, -1}, {22504, -1, -1, -1}, {22505, -1, -1, -1}, {22506, -1, -1, -1}, {22507, -1, -1, -1}, {22508, -1, -1, -1}, {22510, -1, -1, -1}, {22512, -1, -1, -1}, {22513, -1, -1, -1}, {22514, -1, -1, -1}, {22515, -1, -1, -1}, {22517, -1, -1, -1}, {22518, -1, -1, -1}, {22523, -1, -1, -1}, {22524, -1, -1, -1}, {22526, -1, -1, -1}, {22527, -1, -1, -1}, {22529, -1, -1, -1}, {22531, -1, -1, -1}, {22532, -1, -1, -1}, {22536, -1, -1, -1}, {22537, -1, -1, -1}, {22540, -1, -1, -1}, {22542, -1, -1, -1}, {22543, -1, -1, -1}, {22544, -1, -1, -1}, {22546, -1, -1, -1}, {22547, -1, -1, -1}, {22548, -1, -1, -1}, {22551, -1, -1, -1}, {22552, -1, -1, -1}, {22554, -1, -1, -1}, {22555, -1, -1, -1}, {22556, -1, -1, -1}, {22559, -1, -1, -1}, {22562, -1, -1, -1}, {22563, -1, -1, -1}, {22565, -1, -1, -1}, {22566, -1, -1, -1}, {22567, -1, -1, -1}, {22568, -1, -1, -1}, {22569, -1, -1, -1}, {22571, -1, -1, -1}, {22572, -1, -1, -1}, {22573, -1, -1, -1}, {22574, -1, -1, -1}, {22578, -1, -1, -1}, {22579, -1, -1, -1}, {22582, -1, -1, -1}, {22583, -1, -1, -1}, {22584, -1, -1, -1}, {22585, -1, -1, -1}, {22586, -1, -1, -1}, {22587, -1, -1, -1}, {22588, -1, -1, -1}, {22589, -1, -1, -1}, {22590, -1, -1, -1}, {22591, -1, -1, -1}, {22592, -1, -1, -1}, {22593, -1, -1, -1}, {22594, -1, -1, -1}, {22595, -1, -1, -1}, {22597, -1, -1, -1}, {22598, -1, -1, -1}, {22599, -1, -1, -1}, {22600, -1, -1, -1}, {22601, -1, -1, -1}, {22606, -1, -1, -1}, {22608, -1, -1, -1}, {22611, -1, -1, -1}, {22613, -1, -1, -1}, {22614, -1, -1, -1}, {22617, -1, -1, -1}, {22618, -1, -1, -1}, {22619, -1, -1, -1}, {22620, -1, -1, -1}, {22621, -1, -1, -1}, {22623, -1, -1, -1}, {22624, -1, -1, -1}, {22625, -1, -1, -1}, {22627, -1, -1, -1}, {22630, -1, -1, -1}, {22631, -1, -1, -1}, {22632, -1, -1, -1}, {22633, -1, -1, -1}, {22634, -1, -1, -1}, {22637, -1, -1, -1}, {22638, -1, -1, -1}, {22639, -1, -1, -1}, {22640, -1, -1, -1}, {22641, -1, -1, -1}, {22642, -1, -1, -1}, {22643, -1, -1, -1}, {22644, -1, -1, -1}, {22646, -1, -1, -1}, {22647, -1, -1, -1}, {22648, -1, -1, -1}, {22650, -1, -1, -1}, {22651, -1, -1, -1}, {22652, -1, -1, -1}, {22653, -1, -1, -1}, {22655, -1, -1, -1}, {22658, -1, -1, -1}, {22660, -1, -1, -1}, {22662, -1, -1, -1}, {22663, -1, -1, -1}, {22664, -1, -1, -1}, {22667, -1, -1, -1}, {22668, -1, -1, -1}, {22669, -1, -1, -1}, {22670, -1, -1, -1}, {22671, -1, -1, -1}, {22672, -1, -1, -1}, {22673, -1, -1, -1}, {22676, -1, -1, -1}, {22677, -1, -1, -1}, {22678, -1, -1, -1}, {22679, -1, -1, -1}, {22680, -1, -1, -1}, {22683, -1, -1, -1}, {22685, -1, -1, -1}, {22688, -1, -1, -1}, {22689, -1, -1, -1}, {22690, -1, -1, -1}, {22691, -1, -1, -1}, {22692, -1, -1, -1}, {22693, -1, -1, -1}, {22694, -1, -1, -1}, {22695, -1, -1, -1}, {22698, -1, -1, -1}, {22699, -1, -1, -1}, {22700, -1, -1, -1}, {22701, -1, -1, -1}, {22703, -1, -1, -1}, {22704, -1, -1, -1}, {22705, -1, -1, -1}, {22706, -1, -1, -1}, {22708, -1, -1, -1}, {22709, -1, -1, -1}, {22710, -1, -1, -1}, {22711, -1, -1, -1}, {22712, -1, -1, -1}, {22713, -1, -1, -1}, {22714, -1, -1, -1}, {22717, -1, -1, -1}, {22719, -1, -1, -1}, {22720, -1, -1, -1} },
    {{22722, -1, -1, -1}, {22723, -1, -1, -1}, {22724, -1, -1, -1}, {22726, -1, -1, -1}, {22728, -1, -1, -1}, {22729, -1, -1, -1}, {22730, -1, -1, -1}, {22731, -1, -1, -1}, {22732, -1, -1, -1}, {22733, -1, -1, -1}, {22734, -1, -1, -1}, {22735, -1, -1, -1}, {22736, -1, -1, -1}, {22738, -1, -1, -1}, {22740, -1, -1, -1}, {22742, -1, -1, -1}, {22743, -1, -1, -1}, {22747, -1, -1, -1}, {22748, -1, -1, -1}, {22749, -1, -1, -1}, {22753, -1, -1, -1}, {22755, -1, -1, -1}, {22757, -1, -1, -1}, {22758, -1, -1, -1}, {22759, -1, -1, -1}, {22760, -1, -1, -1}, {22762, -1, -1, -1}, {22765, -1, -1, -1}, {22769, -1, -1, -1}, {22770, -1, -1, -1}, {22772, -1, -1, -1}, {22773, -1, -1, -1}, {22775, -1, -1, -1}, {22776, -1, -1, -1}, {22779, -1, -1, -1}, {22780, -1, -1, -1}, {22782, -1, -1, -1}, {22783, -1, -1, -1}, {22784, -1, -1, -1}, {22785, -1, -1, -1}, {22787, -1, -1, -1}, {22789, -1, -1, -1}, {22790, -1, -1, -1}, {22792, -1, -1, -1}, {22793, -1, -1, -1}, {12066, 22794, -1, -1}, {22795, -1, -1, -1}, {22796, -1, -1, -1}, {22798, -1, -1, -1}, {22800, -1, -1, -1}, {22801, -1, -1, -1}, {22802, -1, -1, -1}, {22803, -1, -1, -1}, {22807, -1, -1, -1}, {22808, -1, -1, -1}, {22811, -1, -1, -1}, {22813, -1, -1, -1}, {22814, -1, -1, -1}, {22816, -1, -1, -1}, {22817, -1, -1, -1}, {22819, -1, -1, -1}, {22822, -1, -1, -1}, {22824, -1, -1, -1}, {22828, -1, -1, -1}, {22832, -1, -1, -1}, {22834, -1, -1, -1}, {22835, -1, -1, -1}, {22837, -1, -1, -1}, {22838, -1, -1, -1}, {22843, -1, -1, -1}, {22845, -1, -1, -1}, {22847, -1, -1, -1}, {22848, -1, -1, -1}, {22851, -1, -1, -1}, {22853, -1, -1, -1}, {22854, -1, -1, -1}, {22858, -1, -1, -1}, {22860, -1, -1, -1}, {22861, -1, -1, -1}, {22864, -1, -1, -1}, {22866, -1, -1, -1}, {22867, -1, -1, -1}, {22873, -1, -1, -1}, {22875, -1, -1, -1}, {22876, -1, -1, -1}, {22877, -1, -1, -1}, {22878, -1, -1, -1}, {22879, -1, -1, -1}, {22881, -1, -1, -1}, {22883, -1, -1, -1}, {22884, -1, -1, -1}, {22886, -1, -1, -1}, {22887, -1, -1, -1}, {22888, -1, -1, -1}, {22891, -1, -1, -1}, {22893, -1, -1, -1}, {22895, -1, -1, -1}, {22896, -1, -1, -1}, {22897, -1, -1, -1}, {22898, -1, -1, -1}, {22901, -1, -1, -1}, {22903, -1, -1, -1}, {22906, -1, -1, -1}, {22907, -1, -1, -1}, {22908, -1, -1, -1}, {22910, -1, -1, -1}, {22911, -1, -1, -1}, {22912, -1, -1, -1}, {22917, -1, -1, -1}, {22921, -1, -1, -1}, {22923, -1, -1, -1}, {22924, -1, -1, -1}, {22926, -1, -1, -1}, {22927, -1, -1, -1}, {22928, -1, -1, -1}, {22929, -1, -1, -1}, {22932, -1, -1, -1}, {22933, -1, -1, -1}, {22936, -1, -1, -1}, {22938, -1, -1, -1}, {22939, -1, -1, -1}, {22940, -1, -1, -1}, {22943, -1, -1, -1}, {22944, -1, -1, -1}, {22945, -1, -1, -1}, {22946, -1, -1, -1}, {22950, -1, -1, -1}, {22951, -1, -1, -1}, {22956, -1, -1, -1}, {22957, -1, -1, -1}, {22960, -1, -1, -1}, {22961, -1, -1, -1}, {22963, -1, -1, -1}, {22964, -1, -1, -1}, {22965, -1, -1, -1}, {22966, -1, -1, -1}, {22967, -1, -1, -1}, {22968, -1, -1, -1}, {22970, -1, -1, -1}, {22972, -1, -1, -1}, {22973, -1, -1, -1}, {22975, -1, -1, -1}, {22976, -1, -1, -1}, {22977, -1, -1, -1}, {22978, -1, -1, -1}, {22979, -1, -1, -1}, {22980, -1, -1, -1}, {22981, -1, -1, -1}, {22983, -1, -1, -1}, {22984, -1, -1, -1}, {22985, -1, -1, -1}, {22988, -1, -1, -1}, {22989, -1, -1, -1}, {22990, -1, -1, -1}, {22991, -1, -1, -1}, {22997, -1, -1, -1}, {22998, -1, -1, -1}, {23001, -1, -1, -1}, {23003, -1, -1, -1}, {23006, -1, -1, -1}, {23007, -1, -1, -1}, {23008, -1, -1, -1}, {23009, -1, -1, -1}, {23010, -1, -1, -1}, {23012, -1, -1, -1}, {23014, -1, -1, -1}, {23015, -1, -1, -1}, {23017, -1, -1, -1}, {23018, -1, -1, -1}, {23019, -1, -1, -1}, {23021, -1, -1, -1}, {23022, -1, -1, -1}, {23023, -1, -1, -1}, {23024, -1, -1, -1}, {23025, -1, -1, -1}, {23026, -1, -1, -1}, {23027, -1, -1, -1}, {23028, -1, -1, -1}, {23029, -1, -1, -1}, {23030, -1, -1, -1}, {23031, -1, -1, -1}, {23032, -1, -1, -1}, {23034, -1, -1, -1}, {23036, -1, -1, -1}, {23037, -1, -1, -1}, {23038, -1, -1, -1}, {23040, -1, -1, -1}, {23042, -1, -1, -1}, {23050, -1, -1, -1}, {23051, -1, -1, -1}, {23053, -1, -1, -1}, {23054, -1, -1, -1}, {23055, -1, -1, -1}, {23056, -1, -1, -1}, {23058, -1, -1, -1}, {23060, -1, -1, -1}, {23061, -1, -1, -1}, {23062, -1, -1, -1}, {23063, -1, -1, -1}, {23065, -1, -1, -1}, {23066, -1, -1, -1}, {23067, -1, -1, -1}, {23069, -1, -1, -1}, {23070, -1, -1, -1}, {23073, -1, -1, -1}, {23074, -1, -1, -1}, {23076, -1, -1, -1}, {23078, -1, -1, -1}, {23079, -1, -1, -1}, {23080, -1, -1, -1}, {23082, -1, -1, -1}, {23083, -1, -1, -1}, {23084, -1, -1, -1}, {23085, -1, -1, -1}, {23086, -1, -1, -1}, {23087, -1, -1, -1}, {23088, -1, -1, -1}, {23091, -1, -1, -1}, {23093, -1, -1, -1}, {23095, -1, -1, -1}, {23096, -1, -1, -1}, {23097, -1, -1, -1}, {23098, -1, -1, -1}, {23099, -1, -1, -1}, {23101, -1, -1, -1}, {23102, -1, -1, -1}, {23103, -1, -1, -1}, {23106, -1, -1, -1}, {23107, -1, -1, -1}, {23108, -1, -1, -1}, {23109, -1, -1, -1}, {23111, -1, -1, -1}, {23112, -1, -1, -1}, {23115, -1, -1, -1}, {23116, -1, -1, -1}, {23117, -1, -1, -1}, {23118, -1, -1, -1}, {23119, -1, -1, -1}, {23120, -1, -1, -1}, {23121, -1, -1, -1}, {23122, -1, -1, -1}, {23123, -1, -1, -1}, {23124, -1, -1, -1}, {23126, -1, -1, -1}, {23127, -1, -1, -1}, {23128, -1, -1, -1}, {23129, -1, -1, -1}, {23131, -1, -1, -1}, {23132, -1, -1, -1}, {23133, -1, -1, -1}, {23134, -1, -1, -1}, {23135, -1, -1, -1}, {23136, -1, -1, -1}, {23137, -1, -1, -1}, {23139, -1, -1, -1}, {23140, -1, -1, -1} },
    {{23141, -1, -1, -1}, {23144, -1, -1, -1}, {23145, -1, -1, -1}, {23147, -1, -1, -1}, {23148, -1, -1, -1}, {23150, -1, -1, -1}, {23151, -1, -1, -1}, {23152, -1, -1, -1}, {23153, -1, -1, -1}, {23154, -1, -1, -1}, {23155, -1, -1, -1}, {23160, -1, -1, -1}, {23161, -1, -1, -1}, {23163, -1, -1, -1}, {23164, -1, -1, -1}, {23165, -1, -1, -1}, {23166, -1, -1, -1}, {23168, -1, -1, -1}, {23169, -1, -1, -1}, {23170, -1, -1, -1}, {23171, -1, -1, -1}, {23172, -1, -1, -1}, {23173, -1, -1, -1}, {23174, -1, -1, -1}, {23175, -1, -1, -1}, {23176, -1, -1, -1}, {23177, -1, -1, -1}, {23178, -1, -1, -1}, {23179, -1, -1, -1}, {23180, -1, -1, -1}, {23181, -1, -1, -1}, {23182, -1, -1, -1}, {23183, -1, -1, -1}, {23184, -1, -1, -1}, {23185, -1, -1, -1}, {23187, -1, -1, -1}, {23188, -1, -1, -1}, {23189, -1, -1, -1}, {23190, -1, -1, -1}, {23191, -1, -1, -1}, {23192, -1, -1, -1}, {23193, -1, -1, -1}, {23196, -1, -1, -1}, {23197, -1, -1, -1}, {23198, -1, -1, -1}, {23199, -1, -1, -1}, {23200, -1, -1, -1}, {23201, -1, -1, -1}, {23202, -1, -1, -1}, {23203, -1, -1, -1}, {23204, -1, -1, -1}, {23205, -1, -1, -1}, {23206, -1, -1, -1}, {23208, -1, -1, -1}, {23209, -1, -1, -1}, {23211, -1, -1, -1}, {23212, -1, -1, -1}, {23213, -1, -1, -1}, {23214, -1, -1, -1}, {23215, -1, -1, -1}, {23216, -1, -1, -1}, {23217, -1, -1, -1}, {23220, -1, -1, -1}, {23222, -1, -1, -1}, {23223, -1, -1, -1}, {23225, -1, -1, -1}, {23226, -1, -1, -1}, {23227, -1, -1, -1}, {23228, -1, -1, -1}, {23231, -1, -1, -1}, {23232, -1, -1, -1}, {23235, -1, -1, -1}, {23236, -1, -1, -1}, {23237, -1, -1, -1}, {23238, -1, -1, -1}, {23239, -1, -1, -1}, {23240, -1, -1, -1}, {23242, -1, -1, -1}, {23243, -1, -1, -1}, {23245, -1, -1, -1}, {23246, -1, -1, -1}, {23247, -1, -1, -1}, {23248, -1, -1, -1}, {23249, -1, -1, -1}, {23251, -1, -1, -1}, {23253, -1, -1, -1}, {23257, -1, -1, -1}, {23258, -1, -1, -1}, {23259, -1, -1, -1}, {23261, -1, -1, -1}, {23262, -1, -1, -1}, {23263, -1, -1, -1}, {23266, -1, -1, -1}, {23268, -1, -1, -1}, {23269, -1, -1, -1}, {23271, -1, -1, -1}, {23272, -1, -1, -1}, {23274, -1, -1, -1}, {23276, -1, -1, -1}, {23277, -1, -1, -1}, {23278, -1, -1, -1}, {23279, -1, -1, -1}, {23280, -1, -1, -1}, {23282, -1, -1, -1}, {23283, -1, -1, -1}, {23284, -1, -1, -1}, {23286, -1, -1, -1}, {23287, -1, -1, -1}, {23288, -1, -1, -1}, {23289, -1, -1, -1}, {23290, -1, -1, -1}, {23292, -1, -1, -1}, {23293, -1, -1, -1}, {23294, -1, -1, -1}, {23295, -1, -1, -1}, {23297, -1, -1, -1}, {23298, -1, -1, -1}, {23299, -1, -1, -1}, {23300, -1, -1, -1}, {23301, -1, -1, -1}, {23302, -1, -1, -1}, {23303, -1, -1, -1}, {23306, -1, -1, -1}, {23309, -1, -1, -1}, {23310, -1, -1, -1}, {23311, -1, -1, -1}, {23312, -1, -1, -1}, {23313, -1, -1, -1}, {23314, -1, -1, -1}, {23315, -1, -1, -1}, {23316, -1, -1, -1}, {23317, -1, -1, -1}, {23320, -1, -1, -1}, {23322, -1, -1, -1}, {23323, -1, -1, -1}, {23324, -1, -1, -1}, {23325, -1, -1, -1}, {23326, -1, -1, -1}, {23327, -1, -1, -1}, {23328, -1, -1, -1}, {23330, -1, -1, -1}, {23331, -1, -1, -1}, {23332, -1, -1, -1}, {23333, -1, -1, -1}, {23334, -1, -1, -1}, {23335, -1, -1, -1}, {23336, -1, -1, -1}, {23337, -1, -1, -1}, {23339, -1, -1, -1}, {23340, -1, -1, -1}, {23341, -1, -1, -1}, {23342, -1, -1, -1}, {23343, -1, -1, -1}, {23345, -1, -1, -1}, {23347, -1, -1, -1}, {23349, -1, -1, -1}, {23350, -1, -1, -1}, {23353, -1, -1, -1}, {23354, -1, -1, -1}, {23355, -1, -1, -1}, {23356, -1, -1, -1}, {23357, -1, -1, -1}, {23358, -1, -1, -1}, {23359, -1, -1, -1}, {23361, -1, -1, -1}, {23362, -1, -1, -1}, {23363, -1, -1, -1}, {23364, -1, -1, -1}, {23365, -1, -1, -1}, {23366, -1, -1, -1}, {23367, -1, -1, -1}, {23368, -1, -1, -1}, {23369, -1, -1, -1}, {23370, -1, -1, -1}, {23371, -1, -1, -1}, {23373, -1, -1, -1}, {23374, -1, -1, -1}, {23375, -1, -1, -1}, {23378, -1, -1, -1}, {23382, -1, -1, -1}, {23390, -1, -1, -1}, {23392, -1, -1, -1}, {23393, -1, -1, -1}, {23399, -1, -1, -1}, {23400, -1, -1, -1}, {23405, -1, -1, -1}, {23406, -1, -1, -1}, {23407, -1, -1, -1}, {23410, -1, -1, -1}, {23412, -1, -1, -1}, {23414, -1, -1, -1}, {23415, -1, -1, -1}, {23417, -1, -1, -1}, {23419, -1, -1, -1}, {23420, -1, -1, -1}, {23422, -1, -1, -1}, {23426, -1, -1, -1}, {23430, -1, -1, -1}, {23434, -1, -1, -1}, {23437, -1, -1, -1}, {23438, -1, -1, -1}, {23440, -1, -1, -1}, {23441, -1, -1, -1}, {23442, -1, -1, -1}, {23444, -1, -1, -1}, {23446, -1, -1, -1}, {23455, -1, -1, -1}, {23463, -1, -1, -1}, {23464, -1, -1, -1}, {23465, -1, -1, -1}, {23468, -1, -1, -1}, {23469, -1, -1, -1}, {23470, -1, -1, -1}, {23471, -1, -1, -1}, {23473, -1, -1, -1}, {23474, -1, -1, -1}, {23479, -1, -1, -1}, {23482, -1, -1, -1}, {23483, -1, -1, -1}, {23484, -1, -1, -1}, {23488, -1, -1, -1}, {23489, -1, -1, -1}, {23491, -1, -1, -1}, {23496, -1, -1, -1}, {23497, -1, -1, -1}, {23498, -1, -1, -1}, {23499, -1, -1, -1}, {23501, -1, -1, -1}, {23502, -1, -1, -1}, {23503, -1, -1, -1}, {23505, -1, -1, -1}, {23508, -1, -1, -1}, {23509, -1, -1, -1}, {23510, -1, -1, -1}, {23511, -1, -1, -1}, {23512, -1, -1, -1}, {23513, -1, -1, -1}, {23514, -1, -1, -1}, {23515, -1, -1, -1}, {23516, -1, -1, -1}, {23520, -1, -1, -1}, {23523, -1, -1, -1}, {23530, -1, -1, -1}, {23533, -1, -1, -1}, {23535, -1, -1, -1}, {23537, -1, -1, -1}, {23538, -1, -1, -1}, {23539, -1, -1, -1}, {23540, -1, -1, -1}, {23543, -1, -1, -1}, {23549, -1, -1, -1}, {23550, -1, -1, -1}, {23552, -1, -1, -1}, {23554, -1, -1, -1}, {23555, -1, -1, -1}, {23557, -1, -1, -1} },
    {{23564, -1, -1, -1}, {23568, -1, -1, -1}, {23570, -1, -1, -1}, {23571, -1, -1, -1}, {23575, -1, -1, -1}, {23577, -1, -1, -1}, {23579, -1, -1, -1}, {23582, -1, -1, -1}, {23583, -1, -1, -1}, {23584, -1, -1, -1}, {23585, -1, -1, -1}, {23587, -1, -1, -1}, {23590, -1, -1, -1}, {23592, -1, -1, -1}, {23593, -1, -1, -1}, {23594, -1, -1, -1}, {23595, -1, -1, -1}, {23597, -1, -1, -1}, {23598, -1, -1, -1}, {23599, -1, -1, -1}, {23600, -1, -1, -1}, {23602, -1, -1, -1}, {23603, -1, -1, -1}, {23605, -1, -1, -1}, {23606, -1, -1, -1}, {23619, -1, -1, -1}, {23620, -1, -1, -1}, {23622, -1, -1, -1}, {23623, -1, -1, -1}, {23628, -1, -1, -1}, {23629, -1, -1, -1}, {23634, -1, -1, -1}, {23635, -1, -1, -1}, {23636, -1, -1, -1}, {23638, -1, -1, -1}, {23639, -1, -1, -1}, {23640, -1, -1, -1}, {23642, -1, -1, -1}, {23643, -1, -1, -1}, {23644, -1, -1, -1}, {23645, -1, -1, -1}, {23647, -1, -1, -1}, {23655, -1, -1, -1}, {23657, -1, -1, -1}, {23658, -1, -1, -1}, {23659, -1, -1, -1}, {23661, -1, -1, -1}, {23664, -1, -1, -1}, {23666, -1, -1, -1}, {23667, -1, -1, -1}, {23668, -1, -1, -1}, {23669, -1, -1, -1}, {23670, -1, -1, -1}, {23671, -1, -1, -1}, {23672, -1, -1, -1}, {23675, -1, -1, -1}, {23676, -1, -1, -1}, {23677, -1, -1, -1}, {23678, -1, -1, -1}, {23680, -1, -1, -1}, {23683, -1, -1, -1}, {23684, -1, -1, -1}, {23685, -1, -1, -1}, {23686, -1, -1, -1}, {23687, -1, -1, -1}, {23689, -1, -1, -1}, {23690, -1, -1, -1}, {23691, -1, -1, -1}, {23694, -1, -1, -1}, {23695, -1, -1, -1}, {23698, -1, -1, -1}, {23699, -1, -1, -1}, {23701, -1, -1, -1}, {23709, -1, -1, -1}, {23710, -1, -1, -1}, {23711, -1, -1, -1}, {23712, -1, -1, -1}, {23716, -1, -1, -1}, {23717, -1, -1, -1}, {23718, -1, -1, -1}, {23719, -1, -1, -1}, {23720, -1, -1, -1}, {23722, -1, -1, -1}, {23726, -1, -1, -1}, {23727, -1, -1, -1}, {23728, -1, -1, -1}, {23730, -1, -1, -1}, {23732, -1, -1, -1}, {23734, -1, -1, -1}, {23737, -1, -1, -1}, {23738, -1, -1, -1}, {23739, -1, -1, -1}, {23740, -1, -1, -1}, {23742, -1, -1, -1}, {23744, -1, -1, -1}, {23746, -1, -1, -1}, {23747, -1, -1, -1}, {23749, -1, -1, -1}, {23750, -1, -1, -1}, {23751, -1, -1, -1}, {23752, -1, -1, -1}, {23753, -1, -1, -1}, {23754, -1, -1, -1}, {23756, -1, -1, -1}, {23757, -1, -1, -1}, {23758, -1, -1, -1}, {23759, -1, -1, -1}, {23760, -1, -1, -1}, {23761, -1, -1, -1}, {23763, -1, -1, -1}, {23764, -1, -1, -1}, {23765, -1, -1, -1}, {23766, -1, -1, -1}, {23767, -1, -1, -1}, {23768, -1, -1, -1}, {23770, -1, -1, -1}, {23771, -1, -1, -1}, {23772, -1, -1, -1}, {23773, -1, -1, -1}, {23774, -1, -1, -1}, {23775, -1, -1, -1}, {23776, -1, -1, -1}, {23778, -1, -1, -1}, {23779, -1, -1, -1}, {23783, -1, -1, -1}, {23785, -1, -1, -1}, {23787, -1, -1, -1}, {23788, -1, -1, -1}, {23790, -1, -1, -1}, {23791, -1, -1, -1}, {23793, -1, -1, -1}, {23794, -1, -1, -1}, {23795, -1, -1, -1}, {23797, -1, -1, -1}, {23799, -1, -1, -1}, {23800, -1, -1, -1}, {23801, -1, -1, -1}, {23802, -1, -1, -1}, {23804, -1, -1, -1}, {23806, -1, -1, -1}, {23807, -1, -1, -1}, {23808, -1, -1, -1}, {23809, -1, -1, -1}, {23812, -1, -1, -1}, {23813, -1, -1, -1}, {23816, -1, -1, -1}, {23817, -1, -1, -1}, {23818, -1, -1, -1}, {23819, -1, -1, -1}, {23820, -1, -1, -1}, {23823, -1, -1, -1}, {23824, -1, -1, -1}, {23825, -1, -1, -1}, {23826, -1, -1, -1}, {23827, -1, -1, -1}, {23829, -1, -1, -1}, {23832, -1, -1, -1}, {23833, -1, -1, -1}, {23834, -1, -1, -1}, {23836, -1, -1, -1}, {23837, -1, -1, -1}, {23839, -1, -1, -1}, {23840, -1, -1, -1}, {23841, -1, -1, -1}, {23842, -1, -1, -1}, {23843, -1, -1, -1}, {23845, -1, -1, -1}, {23848, -1, -1, -1}, {23850, -1, -1, -1}, {23851, -1, -1, -1}, {23855, -1, -1, -1}, {23856, -1, -1, -1}, {23857, -1, -1, -1}, {23858, -1, -1, -1}, {23859, -1, -1, -1}, {23861, -1, -1, -1}, {23862, -1, -1, -1}, {23863, -1, -1, -1}, {23864, -1, -1, -1}, {23865, -1, -1, -1}, {23866, -1, -1, -1}, {23867, -1, -1, -1}, {23868, -1, -1, -1}, {23871, -1, -1, -1}, {23872, -1, -1, -1}, {23873, -1, -1, -1}, {23874, -1, -1, -1}, {23875, -1, -1, -1}, {23876, -1, -1, -1}, {23877, -1, -1, -1}, {23878, -1, -1, -1}, {23880, -1, -1, -1}, {23881, -1, -1, -1}, {23885, -1, -1, -1}, {23886, -1, -1, -1}, {23887, -1, -1, -1}, {23889, -1, -1, -1}, {23890, -1, -1, -1}, {23891, -1, -1, -1}, {23892, -1, -1, -1}, {23893, -1, -1, -1}, {23894, -1, -1, -1}, {23895, -1, -1, -1}, {23897, -1, -1, -1}, {23898, -1, -1, -1}, {23900, -1, -1, -1}, {23902, -1, -1, -1}, {23903, -1, -1, -1}, {23904, -1, -1, -1}, {23905, -1, -1, -1}, {23906, -1, -1, -1}, {23907, -1, -1, -1}, {23908, -1, -1, -1}, {23909, -1, -1, -1}, {23910, -1, -1, -1}, {23911, -1, -1, -1}, {23912, -1, -1, -1}, {23914, -1, -1, -1}, {23917, -1, -1, -1}, {23918, -1, -1, -1}, {23920, -1, -1, -1}, {23921, -1, -1, -1}, {23922, -1, -1, -1}, {23923, -1, -1, -1}, {23925, -1, -1, -1}, {23926, -1, -1, -1}, {23927, -1, -1, -1}, {23928, -1, -1, -1}, {23929, -1, -1, -1}, {23930, -1, -1, -1}, {23931, -1, -1, -1}, {23932, -1, -1, -1}, {23933, -1, -1, -1}, {23934, -1, -1, -1}, {23935, -1, -1, -1}, {23936, -1, -1, -1}, {23939, -1, -1, -1}, {23941, -1, -1, -1}, {23942, -1, -1, -1}, {23944, -1, -1, -1}, {23945, -1, -1, -1}, {23946, -1, -1, -1}, {23947, -1, -1, -1}, {23948, -1, -1, -1}, {23949, -1, -1, -1}, {23950, -1, -1, -1}, {23951, -1, -1, -1}, {23952, -1, -1, -1}, {23953, -1, -1, -1}, {23954, -1, -1, -1}, {23955, -1, -1, -1}, {23956, -1, -1, -1}, {23957, -1, -1, -1}, {23958, -1, -1, -1}, {23960, -1, -1, -1}, {23962, -1, -1, -1} },
    {{23963, -1, -1, -1}, {23964, -1, -1, -1}, {23966, -1, -1, -1}, {23967, -1, -1, -1}, {23969, -1, -1, -1}, {23970, -1, -1, -1}, {23971, -1, -1, -1}, {23972, -1, -1, -1}, {23973, -1, -1, -1}, {23974, -1, -1, -1}, {23976, -1, -1, -1}, {23977, -1, -1, -1}, {23978, -1, -1, -1}, {23979, -1, -1, -1}, {23980, -1, -1, -1}, {23981, -1, -1, -1}, {23982, -1, -1, -1}, {23983, -1, -1, -1}, {23984, -1, -1, -1}, {23985, -1, -1, -1}, {23986, -1, -1, -1}, {23987, -1, -1, -1}, {23988, -1, -1, -1}, {23989, -1, -1, -1}, {23990, -1, -1, -1}, {23993, -1, -1, -1}, {23995, -1, -1, -1}, {23997, -1, -1, -1}, {23998, -1, -1, -1}, {23999, -1, -1, -1}, {24000, -1, -1, -1}, {24001, -1, -1, -1}, {24002, -1, -1, -1}, {24003, -1, -1, -1}, {24004, -1, -1, -1}, {24006, -1, -1, -1}, {24007, -1, -1, -1}, {24008, -1, -1, -1}, {24009, -1, -1, -1}, {24010, -1, -1, -1}, {24012, -1, -1, -1}, {24014, -1, -1, -1}, {24015, -1, -1, -1}, {24016, -1, -1, -1}, {24017, -1, -1, -1}, {24019, -1, -1, -1}, {24021, -1, -1, -1}, {24022, -1, -1, -1}, {24023, -1, -1, -1}, {24024, -1, -1, -1}, {24025, -1, -1, -1}, {24026, -1, -1, -1}, {24028, -1, -1, -1}, {24031, -1, -1, -1}, {24032, -1, -1, -1}, {24035, -1, -1, -1}, {24036, -1, -1, -1}, {24042, -1, -1, -1}, {24044, -1, -1, -1}, {24045, -1, -1, -1}, {24053, -1, -1, -1}, {24054, -1, -1, -1}, {24056, -1, -1, -1}, {24057, -1, -1, -1}, {24058, -1, -1, -1}, {24059, -1, -1, -1}, {24060, -1, -1, -1}, {24063, -1, -1, -1}, {24064, -1, -1, -1}, {24068, -1, -1, -1}, {24071, -1, -1, -1}, {24073, -1, -1, -1}, {24074, -1, -1, -1}, {24075, -1, -1, -1}, {24077, -1, -1, -1}, {24078, -1, -1, -1}, {24082, -1, -1, -1}, {24083, -1, -1, -1}, {24087, -1, -1, -1}, {24094, -1, -1, -1}, {24095, -1, -1, -1}, {24096, -1, -1, -1}, {24097, -1, -1, -1}, {24098, -1, -1, -1}, {24099, -1, -1, -1}, {24100, -1, -1, -1}, {24104, -1, -1, -1}, {24105, -1, -1, -1}, {24106, -1, -1, -1}, {24108, -1, -1, -1}, {24111, -1, -1, -1}, {24112, -1, -1, -1}, {24114, -1, -1, -1}, {24116, -1, -1, -1}, {24117, -1, -1, -1}, {24121, -1, -1, -1}, {24122, -1, -1, -1}, {24126, -1, -1, -1}, {24127, -1, -1, -1}, {24129, -1, -1, -1}, {24134, -1, -1, -1}, {24135, -1, -1, -1}, {24136, -1, -1, -1}, {24137, -1, -1, -1}, {24138, -1, -1, -1}, {24139, -1, -1, -1}, {24141, -1, -1, -1}, {24142, -1, -1, -1}, {24143, -1, -1, -1}, {24144, -1, -1, -1}, {24145, -1, -1, -1}, {24146, -1, -1, -1}, {24147, -1, -1, -1}, {24150, -1, -1, -1}, {24153, -1, -1, -1}, {24154, -1, -1, -1}, {24156, -1, -1, -1}, {24157, -1, -1, -1}, {24160, -1, -1, -1}, {24164, -1, -1, -1}, {24165, -1, -1, -1}, {24166, -1, -1, -1}, {24167, -1, -1, -1}, {24168, -1, -1, -1}, {24169, -1, -1, -1}, {24170, -1, -1, -1}, {24173, -1, -1, -1}, {24174, -1, -1, -1}, {24175, -1, -1, -1}, {24176, -1, -1, -1}, {24177, -1, -1, -1}, {24181, -1, -1, -1}, {24183, -1, -1, -1}, {24193, -1, -1, -1}, {24194, -1, -1, -1}, {24195, -1, -1, -1}, {24197, -1, -1, -1}, {24200, -1, -1, -1}, {24201, -1, -1, -1}, {24204, -1, -1, -1}, {24205, -1, -1, -1}, {24206, -1, -1, -1}, {24210, -1, -1, -1}, {24216, -1, -1, -1}, {24219, -1, -1, -1}, {24221, -1, -1, -1}, {24225, -1, -1, -1}, {24226, -1, -1, -1}, {24227, -1, -1, -1}, {24228, -1, -1, -1}, {24232, -1, -1, -1}, {24233, -1, -1, -1}, {24234, -1, -1, -1}, {24236, -1, -1, -1}, {24238, -1, -1, -1}, {24239, -1, -1, -1}, {24240, -1, -1, -1}, {24241, -1, -1, -1}, {24242, -1, -1, -1}, {24244, -1, -1, -1}, {24250, -1, -1, -1}, {24251, -1, -1, -1}, {24252, -1, -1, -1}, {24253, -1, -1, -1}, {24255, -1, -1, -1}, {24256, -1, -1, -1}, {24257, -1, -1, -1}, {24258, -1, -1, -1}, {24259, -1, -1, -1}, {24260, -1, -1, -1}, {24261, -1, -1, -1}, {24262, -1, -1, -1}, {24263, -1, -1, -1}, {24264, -1, -1, -1}, {24267, -1, -1, -1}, {24268, -1, -1, -1}, {24269, -1, -1, -1}, {24270, -1, -1, -1}, {24271, -1, -1, -1}, {24272, -1, -1, -1}, {24276, -1, -1, -1}, {24277, -1, -1, -1}, {24279, -1, -1, -1}, {24280, -1, -1, -1}, {24281, -1, -1, -1}, {24282, -1, -1, -1}, {24284, -1, -1, -1}, {24285, -1, -1, -1}, {24286, -1, -1, -1}, {24292, -1, -1, -1}, {24293, -1, -1, -1}, {24294, -1, -1, -1}, {24295, -1, -1, -1}, {24297, -1, -1, -1}, {24299, -1, -1, -1}, {24301, -1, -1, -1}, {24302, -1, -1, -1}, {24303, -1, -1, -1}, {24304, -1, -1, -1}, {24305, -1, -1, -1}, {24306, -1, -1, -1}, {24309, -1, -1, -1}, {24312, -1, -1, -1}, {24313, -1, -1, -1}, {24315, -1, -1, -1}, {24316, -1, -1, -1}, {24317, -1, -1, -1}, {24325, -1, -1, -1}, {24326, -1, -1, -1}, {24327, -1, -1, -1}, {24329, -1, -1, -1}, {24332, -1, -1, -1}, {24333, -1, -1, -1}, {24334, -1, -1, -1}, {24336, -1, -1, -1}, {24338, -1, -1, -1}, {24340, -1, -1, -1}, {24342, -1, -1, -1}, {24345, -1, -1, -1}, {24346, -1, -1, -1}, {24348, -1, -1, -1}, {24349, -1, -1, -1}, {24350, -1, -1, -1}, {24353, -1, -1, -1}, {24354, -1, -1, -1}, {24355, -1, -1, -1}, {24356, -1, -1, -1}, {24360, -1, -1, -1}, {24363, -1, -1, -1}, {24364, -1, -1, -1}, {24366, -1, -1, -1}, {24368, -1, -1, -1}, {24370, -1, -1, -1}, {24372, -1, -1, -1}, {24374, -1, -1, -1}, {24375, -1, -1, -1}, {24376, -1, -1, -1}, {24379, -1, -1, -1}, {24381, -1, -1, -1}, {24382, -1, -1, -1}, {24383, -1, -1, -1}, {24385, -1, -1, -1}, {24386, -1, -1, -1}, {24387, -1, -1, -1}, {24388, -1, -1, -1}, {24389, -1, -1, -1}, {24391, -1, -1, -1}, {24393, -1, -1, -1}, {24394, -1, -1, -1}, {24395, -1, -1, -1}, {24397, -1, -1, -1}, {24399, -1, -1, -1}, {24401, -1, -1, -1}, {24404, -1, -1, -1}, {24410, -1, -1, -1}, {24411, -1, -1, -1} },
    {{24412, -1, -1, -1}, {24414, -1, -1, -1}, {24415, -1, -1, -1}, {24416, -1, -1, -1}, {24419, -1, -1, -1}, {24421, -1, -1, -1}, {24423, -1, -1, -1}, {24424, -1, -1, -1}, {24427, -1, -1, -1}, {24430, -1, -1, -1}, {24431, -1, -1, -1}, {24434, -1, -1, -1}, {24436, -1, -1, -1}, {24437, -1, -1, -1}, {24438, -1, -1, -1}, {24440, -1, -1, -1}, {24442, -1, -1, -1}, {24445, -1, -1, -1}, {24446, -1, -1, -1}, {24447, -1, -1, -1}, {24451, -1, -1, -1}, {24454, -1, -1, -1}, {24461, -1, -1, -1}, {24462, -1, -1, -1}, {24463, -1, -1, -1}, {24467, -1, -1, -1}, {24468, -1, -1, -1}, {24470, -1, -1, -1}, {24474, -1, -1, -1}, {24475, -1, -1, -1}, {24477, -1, -1, -1}, {24479, -1, -1, -1}, {24482, -1, -1, -1}, {24483, -1, -1, -1}, {24484, -1, -1, -1}, {24485, -1, -1, -1}, {24486, -1, -1, -1}, {24487, -1, -1, -1}, {24491, -1, -1, -1}, {24492, -1, -1, -1}, {24495, -1, -1, -1}, {24496, -1, -1, -1}, {24497, -1, -1, -1}, {24498, -1, -1, -1}, {24499, -1, -1, -1}, {24500, -1, -1, -1}, {24502, -1, -1, -1}, {24504, -1, -1, -1}, {24506, -1, -1, -1}, {24507, -1, -1, -1}, {24510, -1, -1, -1}, {24511, -1, -1, -1}, {24512, -1, -1, -1}, {24513, -1, -1, -1}, {24514, -1, -1, -1}, {24519, -1, -1, -1}, {24520, -1, -1, -1}, {24522, -1, -1, -1}, {24523, -1, -1, -1}, {24526, -1, -1, -1}, {24531, -1, -1, -1}, {24532, -1, -1, -1}, {24533, -1, -1, -1}, {24538, -1, -1, -1}, {24539, -1, -1, -1}, {24540, -1, -1, -1}, {24542, -1, -1, -1}, {24543, -1, -1, -1}, {24546, -1, -1, -1}, {24547, -1, -1, -1}, {24549, -1, -1, -1}, {24550, -1, -1, -1}, {24552, -1, -1, -1}, {24553, -1, -1, -1}, {24556, -1, -1, -1}, {24559, -1, -1, -1}, {24560, -1, -1, -1}, {24562, -1, -1, -1}, {24563, -1, -1, -1}, {24564, -1, -1, -1}, {24566, -1, -1, -1}, {24567, -1, -1, -1}, {24569, -1, -1, -1}, {24570, -1, -1, -1}, {24572, -1, -1, -1}, {24583, -1, -1, -1}, {24584, -1, -1, -1}, {24585, -1, -1, -1}, {24587, -1, -1, -1}, {24588, -1, -1, -1}, {24592, -1, -1, -1}, {24593, -1, -1, -1}, {24595, -1, -1, -1}, {24599, -1, -1, -1}, {24600, -1, -1, -1}, {24602, -1, -1, -1}, {24606, -1, -1, -1}, {24607, -1, -1, -1}, {24610, -1, -1, -1}, {24611, -1, -1, -1}, {24612, -1, -1, -1}, {24620, -1, -1, -1}, {24621, -1, -1, -1}, {24622, -1, -1, -1}, {24624, -1, -1, -1}, {24625, -1, -1, -1}, {24626, -1, -1, -1}, {24627, -1, -1, -1}, {24628, -1, -1, -1}, {24630, -1, -1, -1}, {24631, -1, -1, -1}, {24632, -1, -1, -1}, {24633, -1, -1, -1}, {24634, -1, -1, -1}, {24637, -1, -1, -1}, {24638, -1, -1, -1}, {24640, -1, -1, -1}, {24644, -1, -1, -1}, {24645, -1, -1, -1}, {24646, -1, -1, -1}, {24647, -1, -1, -1}, {24648, -1, -1, -1}, {24649, -1, -1, -1}, {24650, -1, -1, -1}, {24652, -1, -1, -1}, {24654, -1, -1, -1}, {24655, -1, -1, -1}, {24657, -1, -1, -1}, {24659, -1, -1, -1}, {24660, -1, -1, -1}, {24662, -1, -1, -1}, {24663, -1, -1, -1}, {24664, -1, -1, -1}, {24667, -1, -1, -1}, {24668, -1, -1, -1}, {24670, -1, -1, -1}, {24671, -1, -1, -1}, {24672, -1, -1, -1}, {24673, -1, -1, -1}, {24677, -1, -1, -1}, {24678, -1, -1, -1}, {24686, -1, -1, -1}, {24689, -1, -1, -1}, {24690, -1, -1, -1}, {24692, -1, -1, -1}, {24693, -1, -1, -1}, {24695, -1, -1, -1}, {24702, -1, -1, -1}, {24704, -1, -1, -1}, {24705, -1, -1, -1}, {24706, -1, -1, -1}, {24709, -1, -1, -1}, {24710, -1, -1, -1}, {24711, -1, -1, -1}, {24712, -1, -1, -1}, {24714, -1, -1, -1}, {24715, -1, -1, -1}, {24718, -1, -1, -1}, {24719, -1, -1, -1}, {24720, -1, -1, -1}, {24721, -1, -1, -1}, {24723, -1, -1, -1}, {24725, -1, -1, -1}, {24727, -1, -1, -1}, {24728, -1, -1, -1}, {24729, -1, -1, -1}, {24732, -1, -1, -1}, {24734, -1, -1, -1}, {24737, -1, -1, -1}, {24738, -1, -1, -1}, {24740, -1, -1, -1}, {24741, -1, -1, -1}, {24743, -1, -1, -1}, {24745, -1, -1, -1}, {24746, -1, -1, -1}, {24750, -1, -1, -1}, {24752, -1, -1, -1}, {24755, -1, -1, -1}, {24759, -1, -1, -1}, {24761, -1, -1, -1}, {24762, -1, -1, -1}, {24765, -1, -1, -1}, {24766, -1, -1, -1}, {24767, -1, -1, -1}, {24768, -1, -1, -1}, {24769, -1, -1, -1}, {24770, -1, -1, -1}, {24771, -1, -1, -1}, {24772, -1, -1, -1}, {24775, -1, -1, -1}, {24776, -1, -1, -1}, {24777, -1, -1, -1}, {24780, -1, -1, -1}, {24781, -1, -1, -1}, {24782, -1, -1, -1}, {24783, -1, -1, -1}, {24784, -1, -1, -1}, {24786, -1, -1, -1}, {24787, -1, -1, -1}, {24788, -1, -1, -1}, {24790, -1, -1, -1}, {24791, -1, -1, -1}, {24793, -1, -1, -1}, {24795, -1, -1, -1}, {24798, -1, -1, -1}, {24802, -1, -1, -1}, {24803, -1, -1, -1}, {24804, -1, -1, -1}, {24805, -1, -1, -1}, {24810, -1, -1, -1}, {24821, -1, -1, -1}, {24823, -1, -1, -1}, {24824, -1, -1, -1}, {24828, -1, -1, -1}, {24829, -1, -1, -1}, {24830, -1, -1, -1}, {24831, -1, -1, -1}, {24834, -1, -1, -1}, {24835, -1, -1, -1}, {24836, -1, -1, -1}, {24837, -1, -1, -1}, {24839, -1, -1, -1}, {24842, -1, -1, -1}, {24843, -1, -1, -1}, {24844, -1, -1, -1}, {24848, -1, -1, -1}, {24849, -1, -1, -1}, {24850, -1, -1, -1}, {24851, -1, -1, -1}, {24852, -1, -1, -1}, {24854, -1, -1, -1}, {24855, -1, -1, -1}, {24856, -1, -1, -1}, {24857, -1, -1, -1}, {24861, -1, -1, -1}, {24862, -1, -1, -1}, {24865, -1, -1, -1}, {24866, -1, -1, -1}, {24869, -1, -1, -1}, {24872, -1, -1, -1}, {24873, -1, -1, -1}, {24874, -1, -1, -1}, {24876, -1, -1, -1}, {24877, -1, -1, -1}, {24878, -1, -1, -1}, {24879, -1, -1, -1}, {24880, -1, -1, -1}, {24881, -1, -1, -1}, {24882, -1, -1, -1}, {24883, -1, -1, -1}, {24885, -1, -1, -1}, {24886, -1, -1, -1}, {24888, -1, -1, -1}, {24889, -1, -1, -1}, {24890, -1, -1, -1}, {24891, -1, -1, -1} },
    {{24892, -1, -1, -1}, {24893, -1, -1, -1}, {24896, -1, -1, -1}, {24897, -1, -1, -1}, {24898, -1, -1, -1}, {24899, -1, -1, -1}, {24900, -1, -1, -1}, {24901, -1, -1, -1}, {24902, -1, -1, -1}, {24903, -1, -1, -1}, {24905, -1, -1, -1}, {24909, -1, -1, -1}, {24911, -1, -1, -1}, {24912, -1, -1, -1}, {24914, -1, -1, -1}, {24915, -1, -1, -1}, {24916, -1, -1, -1}, {24918, -1, -1, -1}, {24919, -1, -1, -1}, {24921, -1, -1, -1}, {24923, -1, -1, -1}, {24924, -1, -1, -1}, {24926, -1, -1, -1}, {24928, -1, -1, -1}, {24929, -1, -1, -1}, {24933, -1, -1, -1}, {24934, -1, -1, -1}, {24937, -1, -1, -1}, {24940, -1, -1, -1}, {24941, -1, -1, -1}, {24943, -1, -1, -1}, {24945, -1, -1, -1}, {24946, -1, -1, -1}, {24948, -1, -1, -1}, {24952, -1, -1, -1}, {24953, -1, -1, -1}, {24954, -1, -1, -1}, {24955, -1, -1, -1}, {24956, -1, -1, -1}, {24957, -1, -1, -1}, {24958, -1, -1, -1}, {24959, -1, -1, -1}, {24960, -1, -1, -1}, {24961, -1, -1, -1}, {24963, -1, -1, -1}, {24964, -1, -1, -1}, {24965, -1, -1, -1}, {24966, -1, -1, -1}, {24967, -1, -1, -1}, {24968, -1, -1, -1}, {24969, -1, -1, -1}, {24972, -1, -1, -1}, {24973, -1, -1, -1}, {24975, -1, -1, -1}, {24979, -1, -1, -1}, {24981, -1, -1, -1}, {24982, -1, -1, -1}, {24983, -1, -1, -1}, {24984, -1, -1, -1}, {24985, -1, -1, -1}, {24987, -1, -1, -1}, {24988, -1, -1, -1}, {24990, -1, -1, -1}, {24991, -1, -1, -1}, {24992, -1, -1, -1}, {24993, -1, -1, -1}, {24994, -1, -1, -1}, {24995, -1, -1, -1}, {24997, -1, -1, -1}, {24998, -1, -1, -1}, {25002, -1, -1, -1}, {25005, -1, -1, -1}, {25007, -1, -1, -1}, {25008, -1, -1, -1}, {25009, -1, -1, -1}, {25011, -1, -1, -1}, {25012, -1, -1, -1}, {25013, -1, -1, -1}, {25016, -1, -1, -1}, {25017, -1, -1, -1}, {25018, -1, -1, -1}, {25019, -1, -1, -1}, {25020, -1, -1, -1}, {25021, -1, -1, -1}, {25023, -1, -1, -1}, {25024, -1, -1, -1}, {25025, -1, -1, -1}, {25027, -1, -1, -1}, {25028, -1, -1, -1}, {25029, -1, -1, -1}, {25030, -1, -1, -1}, {25037, -1, -1, -1}, {25038, -1, -1, -1}, {25039, -1, -1, -1}, {25040, -1, -1, -1}, {25043, -1, -1, -1}, {25045, -1, -1, -1}, {25046, -1, -1, -1}, {25047, -1, -1, -1}, {25048, -1, -1, -1}, {25049, -1, -1, -1}, {25050, -1, -1, -1}, {25051, -1, -1, -1}, {25052, -1, -1, -1}, {25053, -1, -1, -1}, {25056, -1, -1, -1}, {25057, -1, -1, -1}, {25058, -1, -1, -1}, {25060, -1, -1, -1}, {25061, -1, -1, -1}, {25063, -1, -1, -1}, {25065, -1, -1, -1}, {25066, -1, -1, -1}, {25067, -1, -1, -1}, {25068, -1, -1, -1}, {25069, -1, -1, -1}, {25070, -1, -1, -1}, {25071, -1, -1, -1}, {25072, -1, -1, -1}, {25073, -1, -1, -1}, {25075, -1, -1, -1}, {25076, -1, -1, -1}, {25081, -1, -1, -1}, {25083, -1, -1, -1}, {25085, -1, -1, -1}, {25089, -1, -1, -1}, {25090, -1, -1, -1}, {25091, -1, -1, -1}, {25092, -1, -1, -1}, {25093, -1, -1, -1}, {25097, -1, -1, -1}, {25107, -1, -1, -1}, {25113, -1, -1, -1}, {25116, -1, -1, -1}, {25117, -1, -1, -1}, {25118, -1, -1, -1}, {25120, -1, -1, -1}, {25123, -1, -1, -1}, {25126, -1, -1, -1}, {25128, -1, -1, -1}, {25129, -1, -1, -1}, {25131, -1, -1, -1}, {25133, -1, -1, -1}, {25135, -1, -1, -1}, {25137, -1, -1, -1}, {25141, -1, -1, -1}, {12094, 25142, -1, -1}, {25144, -1, -1, -1}, {25145, -1, -1, -1}, {25146, -1, -1, -1}, {25147, -1, -1, -1}, {25148, -1, -1, -1}, {25154, -1, -1, -1}, {25156, -1, -1, -1}, {25157, -1, -1, -1}, {25158, -1, -1, -1}, {25162, -1, -1, -1}, {25167, -1, -1, -1}, {25168, -1, -1, -1}, {25173, -1, -1, -1}, {25174, -1, -1, -1}, {25175, -1, -1, -1}, {25177, -1, -1, -1}, {25178, -1, -1, -1}, {25180, -1, -1, -1}, {25181, -1, -1, -1}, {25182, -1, -1, -1}, {25183, -1, -1, -1}, {25184, -1, -1, -1}, {25185, -1, -1, -1}, {25186, -1, -1, -1}, {25188, -1, -1, -1}, {25189, -1, -1, -1}, {25192, -1, -1, -1}, {25201, -1, -1, -1}, {25202, -1, -1, -1}, {25204, -1, -1, -1}, {25205, -1, -1, -1}, {25207, -1, -1, -1}, {25208, -1, -1, -1}, {25210, -1, -1, -1}, {25211, -1, -1, -1}, {25213, -1, -1, -1}, {25217, -1, -1, -1}, {25218, -1, -1, -1}, {25219, -1, -1, -1}, {25221, -1, -1, -1}, {25222, -1, -1, -1}, {25223, -1, -1, -1}, {25224, -1, -1, -1}, {25227, -1, -1, -1}, {25228, -1, -1, -1}, {25229, -1, -1, -1}, {25230, -1, -1, -1}, {25231, -1, -1, -1}, {25232, -1, -1, -1}, {25236, -1, -1, -1}, {25241, -1, -1, -1}, {25244, -1, -1, -1}, {25245, -1, -1, -1}, {25246, -1, -1, -1}, {25251, -1, -1, -1}, {25254, -1, -1, -1}, {25255, -1, -1, -1}, {25257, -1, -1, -1}, {25258, -1, -1, -1}, {25261, -1, -1, -1}, {25262, -1, -1, -1}, {25263, -1, -1, -1}, {25264, -1, -1, -1}, {25266, -1, -1, -1}, {25267, -1, -1, -1}, {25268, -1, -1, -1}, {25270, -1, -1, -1}, {25271, -1, -1, -1}, {25272, -1, -1, -1}, {25274, -1, -1, -1}, {25278, -1, -1, -1}, {25280, -1, -1, -1}, {25281, -1, -1, -1}, {25283, -1, -1, -1}, {25291, -1, -1, -1}, {25295, -1, -1, -1}, {25297, -1, -1, -1}, {25301, -1, -1, -1}, {25309, -1, -1, -1}, {25310, -1, -1, -1}, {25312, -1, -1, -1}, {25313, -1, -1, -1}, {25316, -1, -1, -1}, {25322, -1, -1, -1}, {25323, -1, -1, -1}, {25328, -1, -1, -1}, {25330, -1, -1, -1}, {25333, -1, -1, -1}, {25336, -1, -1, -1}, {25337, -1, -1, -1}, {25338, -1, -1, -1}, {25339, -1, -1, -1}, {25344, -1, -1, -1}, {25347, -1, -1, -1}, {25348, -1, -1, -1}, {25349, -1, -1, -1}, {25350, -1, -1, -1}, {25354, -1, -1, -1}, {25355, -1, -1, -1}, {25356, -1, -1, -1}, {25357, -1, -1, -1}, {25359, -1, -1, -1}, {25360, -1, -1, -1}, {25362, -1, -1, -1}, {25363, -1, -1, -1}, {25364, -1, -1, -1}, {25365, -1, -1, -1}, {25367, -1, -1, -1}, {25368, -1, -1, -1} },
    {{25369, -1, -1, -1}, {25372, -1, -1, -1}, {25382, -1, -1, -1}, {25383, -1, -1, -1}, {25385, -1, -1, -1}, {25388, -1, -1, -1}, {25389, -1, -1, -1}, {25390, -1, -1, -1}, {25392, -1, -1, -1}, {25393, -1, -1, -1}, {25395, -1, -1, -1}, {25396, -1, -1, -1}, {25397, -1, -1, -1}, {25398, -1, -1, -1}, {25399, -1, -1, -1}, {25400, -1, -1, -1}, {25403, -1, -1, -1}, {25404, -1, -1, -1}, {25407, -1, -1, -1}, {25408, -1, -1, -1}, {25409, -1, -1, -1}, {25412, -1, -1, -1}, {25415, -1, -1, -1}, {25416, -1, -1, -1}, {25418, -1, -1, -1}, {25425, -1, -1, -1}, {25426, -1, -1, -1}, {25427, -1, -1, -1}, {25428, -1, -1, -1}, {25430, -1, -1, -1}, {25431, -1, -1, -1}, {25432, -1, -1, -1}, {25433, -1, -1, -1}, {25434, -1, -1, -1}, {25435, -1, -1, -1}, {25436, -1, -1, -1}, {25437, -1, -1, -1}, {25440, -1, -1, -1}, {25444, -1, -1, -1}, {25445, -1, -1, -1}, {25446, -1, -1, -1}, {25450, -1, -1, -1}, {25452, -1, -1, -1}, {25455, -1, -1, -1}, {25456, -1, -1, -1}, {25459, -1, -1, -1}, {25460, -1, -1, -1}, {25461, -1, -1, -1}, {25464, -1, -1, -1}, {25465, -1, -1, -1}, {25468, -1, -1, -1}, {25469, -1, -1, -1}, {25470, -1, -1, -1}, {25471, -1, -1, -1}, {25473, -1, -1, -1}, {25477, -1, -1, -1}, {25478, -1, -1, -1}, {25483, -1, -1, -1}, {25485, -1, -1, -1}, {25489, -1, -1, -1}, {25491, -1, -1, -1}, {25492, -1, -1, -1}, {25493, -1, -1, -1}, {25495, -1, -1, -1}, {25497, -1, -1, -1}, {25498, -1, -1, -1}, {25499, -1, -1, -1}, {25500, -1, -1, -1}, {25501, -1, -1, -1}, {25502, -1, -1, -1}, {25503, -1, -1, -1}, {25505, -1, -1, -1}, {25508, -1, -1, -1}, {25510, -1, -1, -1}, {25515, -1, -1, -1}, {25519, -1, -1, -1}, {25521, -1, -1, -1}, {25522, -1, -1, -1}, {25525, -1, -1, -1}, {25526, -1, -1, -1}, {25529, -1, -1, -1}, {25531, -1, -1, -1}, {25533, -1, -1, -1}, {25535, -1, -1, -1}, {25537, -1, -1, -1}, {25538, -1, -1, -1}, {25539, -1, -1, -1}, {25541, -1, -1, -1}, {25543, -1, -1, -1}, {25544, -1, -1, -1}, {25546, -1, -1, -1}, {25547, -1, -1, -1}, {25548, -1, -1, -1}, {25553, -1, -1, -1}, {25555, -1, -1, -1}, {25556, -1, -1, -1}, {25557, -1, -1, -1}, {25559, -1, -1, -1}, {25560, -1, -1, -1}, {25561, -1, -1, -1}, {25563, -1, -1, -1}, {25564, -1, -1, -1}, {25565, -1, -1, -1}, {25567, -1, -1, -1}, {25570, -1, -1, -1}, {25572, -1, -1, -1}, {25573, -1, -1, -1}, {25574, -1, -1, -1}, {25575, -1, -1, -1}, {25576, -1, -1, -1}, {25579, -1, -1, -1}, {25580, -1, -1, -1}, {25583, -1, -1, -1}, {25584, -1, -1, -1}, {25585, -1, -1, -1}, {25587, -1, -1, -1}, {25589, -1, -1, -1}, {25591, -1, -1, -1}, {25593, -1, -1, -1}, {25594, -1, -1, -1}, {25595, -1, -1, -1}, {25596, -1, -1, -1}, {25598, -1, -1, -1}, {25603, -1, -1, -1}, {25604, -1, -1, -1}, {25606, -1, -1, -1}, {25607, -1, -1, -1}, {25608, -1, -1, -1}, {25609, -1, -1, -1}, {25610, -1, -1, -1}, {25614, -1, -1, -1}, {25617, -1, -1, -1}, {25618, -1, -1, -1}, {25621, -1, -1, -1}, {25622, -1, -1, -1}, {25624, -1, -1, -1}, {25625, -1, -1, -1}, {25626, -1, -1, -1}, {25629, -1, -1, -1}, {25631, -1, -1, -1}, {25634, -1, -1, -1}, {25635, -1, -1, -1}, {25636, -1, -1, -1}, {25637, -1, -1, -1}, {25639, -1, -1, -1}, {25640, -1, -1, -1}, {25641, -1, -1, -1}, {25643, -1, -1, -1}, {25646, -1, -1, -1}, {25647, -1, -1, -1}, {25648, -1, -1, -1}, {25649, -1, -1, -1}, {25650, -1, -1, -1}, {25651, -1, -1, -1}, {25653, -1, -1, -1}, {25655, -1, -1, -1}, {25656, -1, -1, -1}, {25657, -1, -1, -1}, {25659, -1, -1, -1}, {25660, -1, -1, -1}, {25662, -1, -1, -1}, {25664, -1, -1, -1}, {25666, -1, -1, -1}, {25667, -1, -1, -1}, {25673, -1, -1, -1}, {25675, -1, -1, -1}, {25676, -1, -1, -1}, {25677, -1, -1, -1}, {25678, -1, -1, -1}, {25679, -1, -1, -1}, {25680, -1, -1, -1}, {25683, -1, -1, -1}, {25685, -1, -1, -1}, {25686, -1, -1, -1}, {25687, -1, -1, -1}, {25689, -1, -1, -1}, {25690, -1, -1, -1}, {25691, -1, -1, -1}, {25693, -1, -1, -1}, {25696, -1, -1, -1}, {25697, -1, -1, -1}, {25698, -1, -1, -1}, {25699, -1, -1, -1}, {25700, -1, -1, -1}, {25701, -1, -1, -1}, {25702, -1, -1, -1}, {25704, -1, -1, -1}, {25706, -1, -1, -1}, {25707, -1, -1, -1}, {25708, -1, -1, -1}, {25710, -1, -1, -1}, {25712, -1, -1, -1}, {25713, -1, -1, -1}, {25714, -1, -1, -1}, {25716, -1, -1, -1}, {25717, -1, -1, -1}, {25719, -1, -1, -1}, {25724, -1, -1, -1}, {25725, -1, -1, -1}, {25726, -1, -1, -1}, {25727, -1, -1, -1}, {25728, -1, -1, -1}, {25729, -1, -1, -1}, {25731, -1, -1, -1}, {25734, -1, -1, -1}, {25737, -1, -1, -1}, {25738, -1, -1, -1}, {25739, -1, -1, -1}, {25740, -1, -1, -1}, {25741, -1, -1, -1}, {25742, -1, -1, -1}, {25743, -1, -1, -1}, {25744, -1, -1, -1}, {25748, -1, -1, -1}, {25751, -1, -1, -1}, {25752, -1, -1, -1}, {25754, -1, -1, -1}, {25755, -1, -1, -1}, {25756, -1, -1, -1}, {25757, -1, -1, -1}, {25760, -1, -1, -1}, {25761, -1, -1, -1}, {25762, -1, -1, -1}, {25766, -1, -1, -1}, {25767, -1, -1, -1}, {25768, -1, -1, -1}, {25770, -1, -1, -1}, {25775, -1, -1, -1}, {25777, -1, -1, -1}, {25780, -1, -1, -1}, {25782, -1, -1, -1}, {25785, -1, -1, -1}, {25789, -1, -1, -1}, {25795, -1, -1, -1}, {25798, -1, -1, -1}, {25800, -1, -1, -1}, {25801, -1, -1, -1}, {25804, -1, -1, -1}, {25807, -1, -1, -1}, {25809, -1, -1, -1}, {25811, -1, -1, -1}, {25813, -1, -1, -1}, {25814, -1, -1, -1}, {25817, -1, -1, -1}, {25819, -1, -1, -1}, {25820, -1, -1, -1}, {25821, -1, -1, -1}, {25823, -1, -1, -1}, {25825, -1, -1, -1}, {25827, -1, -1, -1}, {25829, -1, -1, -1}, {25831, -1, -1, -1}, {25832, -1, -1, -1}, {25833, -1, -1, -1}, {25834, -1, -1, -1}, {25835, -1, -1, -1} },
    {{25837, -1, -1, -1}, {25838, -1, -1, -1}, {25843, -1, -1, -1}, {25845, -1, -1, -1}, {25846, -1, -1, -1}, {25848, -1, -1, -1}, {25849, -1, -1, -1}, {25853, -1, -1, -1}, {25855, -1, -1, -1}, {25857, -1, -1, -1}, {25858, -1, -1, -1}, {25859, -1, -1, -1}, {25861, -1, -1, -1}, {25863, -1, -1, -1}, {25864, -1, -1, -1}, {25866, -1, -1, -1}, {25867, -1, -1, -1}, {25868, -1, -1, -1}, {25869, -1, -1, -1}, {25870, -1, -1, -1}, {25872, -1, -1, -1}, {25873, -1, -1, -1}, {25875, -1, -1, -1}, {25877, -1, -1, -1}, {25879, -1, -1, -1}, {25882, -1, -1, -1}, {25884, -1, -1, -1}, {25886, -1, -1, -1}, {25887, -1, -1, -1}, {25888, -1, -1, -1}, {25889, -1, -1, -1}, {25894, -1, -1, -1}, {25895, -1, -1, -1}, {25896, -1, -1, -1}, {25897, -1, -1, -1}, {25901, -1, -1, -1}, {25904, -1, -1, -1}, {25905, -1, -1, -1}, {25906, -1, -1, -1}, {25907, -1, -1, -1}, {25911, -1, -1, -1}, {25914, -1, -1, -1}, {25916, -1, -1, -1}, {25917, -1, -1, -1}, {25920, -1, -1, -1}, {25921, -1, -1, -1}, {25922, -1, -1, -1}, {25923, -1, -1, -1}, {25924, -1, -1, -1}, {25926, -1, -1, -1}, {25927, -1, -1, -1}, {25930, -1, -1, -1}, {25931, -1, -1, -1}, {25933, -1, -1, -1}, {25934, -1, -1, -1}, {25936, -1, -1, -1}, {25938, -1, -1, -1}, {25939, -1, -1, -1}, {25940, -1, -1, -1}, {25944, -1, -1, -1}, {25946, -1, -1, -1}, {25948, -1, -1, -1}, {25951, -1, -1, -1}, {25952, -1, -1, -1}, {25953, -1, -1, -1}, {25956, -1, -1, -1}, {25957, -1, -1, -1}, {25959, -1, -1, -1}, {25960, -1, -1, -1}, {25961, -1, -1, -1}, {25962, -1, -1, -1}, {25965, -1, -1, -1}, {25966, -1, -1, -1}, {25967, -1, -1, -1}, {25969, -1, -1, -1}, {25971, -1, -1, -1}, {25974, -1, -1, -1}, {25977, -1, -1, -1}, {25978, -1, -1, -1}, {25979, -1, -1, -1}, {25980, -1, -1, -1}, {25981, -1, -1, -1}, {25982, -1, -1, -1}, {25983, -1, -1, -1}, {25984, -1, -1, -1}, {25985, -1, -1, -1}, {25988, -1, -1, -1}, {25989, -1, -1, -1}, {25990, -1, -1, -1}, {25992, -1, -1, -1}, {25993, -1, -1, -1}, {25994, -1, -1, -1}, {25997, -1, -1, -1}, {25998, -1, -1, -1}, {25999, -1, -1, -1}, {26002, -1, -1, -1}, {26004, -1, -1, -1}, {26006, -1, -1, -1}, {26008, -1, -1, -1}, {26010, -1, -1, -1}, {26013, -1, -1, -1}, {26014, -1, -1, -1}, {26016, -1, -1, -1}, {26018, -1, -1, -1}, {26019, -1, -1, -1}, {26022, -1, -1, -1}, {26024, -1, -1, -1}, {26026, -1, -1, -1}, {26030, -1, -1, -1}, {26033, -1, -1, -1}, {26034, -1, -1, -1}, {26035, -1, -1, -1}, {26036, -1, -1, -1}, {26037, -1, -1, -1}, {26038, -1, -1, -1}, {26040, -1, -1, -1}, {26042, -1, -1, -1}, {26043, -1, -1, -1}, {26046, -1, -1, -1}, {26047, -1, -1, -1}, {26048, -1, -1, -1}, {26050, -1, -1, -1}, {26055, -1, -1, -1}, {26056, -1, -1, -1}, {26057, -1, -1, -1}, {26058, -1, -1, -1}, {26061, -1, -1, -1}, {26064, -1, -1, -1}, {26065, -1, -1, -1}, {26067, -1, -1, -1}, {26068, -1, -1, -1}, {26069, -1, -1, -1}, {26072, -1, -1, -1}, {26073, -1, -1, -1}, {26074, -1, -1, -1}, {26075, -1, -1, -1}, {26076, -1, -1, -1}, {26077, -1, -1, -1}, {26078, -1, -1, -1}, {26079, -1, -1, -1}, {26081, -1, -1, -1}, {26083, -1, -1, -1}, {26084, -1, -1, -1}, {26090, -1, -1, -1}, {26091, -1, -1, -1}, {26098, -1, -1, -1}, {26099, -1, -1, -1}, {26100, -1, -1, -1}, {26101, -1, -1, -1}, {26104, -1, -1, -1}, {26105, -1, -1, -1}, {26107, -1, -1, -1}, {26108, -1, -1, -1}, {26109, -1, -1, -1}, {26110, -1, -1, -1}, {26111, -1, -1, -1}, {26113, -1, -1, -1}, {26116, -1, -1, -1}, {26117, -1, -1, -1}, {26119, -1, -1, -1}, {26120, -1, -1, -1}, {26121, -1, -1, -1}, {26123, -1, -1, -1}, {26125, -1, -1, -1}, {26128, -1, -1, -1}, {26129, -1, -1, -1}, {26130, -1, -1, -1}, {26134, -1, -1, -1}, {26135, -1, -1, -1}, {26136, -1, -1, -1}, {26138, -1, -1, -1}, {26139, -1, -1, -1}, {26140, -1, -1, -1}, {26142, -1, -1, -1}, {26145, -1, -1, -1}, {26146, -1, -1, -1}, {26147, -1, -1, -1}, {26148, -1, -1, -1}, {26150, -1, -1, -1}, {26153, -1, -1, -1}, {26154, -1, -1, -1}, {26155, -1, -1, -1}, {26156, -1, -1, -1}, {26158, -1, -1, -1}, {26160, -1, -1, -1}, {26162, -1, -1, -1}, {26163, -1, -1, -1}, {26167, -1, -1, -1}, {26168, -1, -1, -1}, {26169, -1, -1, -1}, {26170, -1, -1, -1}, {26171, -1, -1, -1}, {26173, -1, -1, -1}, {26175, -1, -1, -1}, {26176, -1, -1, -1}, {26180, -1, -1, -1}, {26181, -1, -1, -1}, {26182, -1, -1, -1}, {26183, -1, -1, -1}, {26184, -1, -1, -1}, {26185, -1, -1, -1}, {26186, -1, -1, -1}, {26189, -1, -1, -1}, {26190, -1, -1, -1}, {26192, -1, -1, -1}, {26193, -1, -1, -1}, {26200, -1, -1, -1}, {26201, -1, -1, -1}, {26203, -1, -1, -1}, {26204, -1, -1, -1}, {26206, -1, -1, -1}, {26208, -1, -1, -1}, {26210, -1, -1, -1}, {26211, -1, -1, -1}, {26213, -1, -1, -1}, {26215, -1, -1, -1}, {26217, -1, -1, -1}, {26218, -1, -1, -1}, {26219, -1, -1, -1}, {26220, -1, -1, -1}, {26221, -1, -1, -1}, {26225, -1, -1, -1}, {26226, -1, -1, -1}, {26227, -1, -1, -1}, {26229, -1, -1, -1}, {26232, -1, -1, -1}, {26233, -1, -1, -1}, {26235, -1, -1, -1}, {26236, -1, -1, -1}, {26237, -1, -1, -1}, {26239, -1, -1, -1}, {26240, -1, -1, -1}, {26241, -1, -1, -1}, {26243, -1, -1, -1}, {26245, -1, -1, -1}, {26246, -1, -1, -1}, {26250, -1, -1, -1}, {26251, -1, -1, -1}, {26253, -1, -1, -1}, {26254, -1, -1, -1}, {26255, -1, -1, -1}, {26256, -1, -1, -1}, {26258, -1, -1, -1}, {26259, -1, -1, -1}, {26260, -1, -1, -1}, {26261, -1, -1, -1}, {26264, -1, -1, -1}, {26265, -1, -1, -1}, {26266, -1, -1, -1}, {26267, -1, -1, -1}, {26268, -1, -1, -1}, {26270, -1, -1, -1}, {26271, -1, -1, -1}, {26272, -1, -1, -1}, {26273, -1, -1, -1}, {26275, -1, -1, -1} },
    {{26276, -1, -1, -1}, {26277, -1, -1, -1}, {26278, -1, -1, -1}, {26281, -1, -1, -1}, {26282, -1, -1, -1}, {26284, -1, -1, -1}, {26285, -1, -1, -1}, {26287, -1, -1, -1}, {26288, -1, -1, -1}, {26289, -1, -1, -1}, {26290, -1, -1, -1}, {26291, -1, -1, -1}, {26293, -1, -1, -1}, {26294, -1, -1, -1}, {26295, -1, -1, -1}, {26296, -1, -1, -1}, {26298, -1, -1, -1}, {26299, -1, -1, -1}, {26300, -1, -1, -1}, {26301, -1, -1, -1}, {26303, -1, -1, -1}, {26304, -1, -1, -1}, {26305, -1, -1, -1}, {26306, -1, -1, -1}, {26307, -1, -1, -1}, {26309, -1, -1, -1}, {26312, -1, -1, -1}, {26314, -1, -1, -1}, {26315, -1, -1, -1}, {26316, -1, -1, -1}, {26317, -1, -1, -1}, {26318, -1, -1, -1}, {26319, -1, -1, -1}, {26320, -1, -1, -1}, {26321, -1, -1, -1}, {26322, -1, -1, -1}, {26323, -1, -1, -1}, {26324, -1, -1, -1}, {26325, -1, -1, -1}, {26327, -1, -1, -1}, {26328, -1, -1, -1}, {26330, -1, -1, -1}, {26334, -1, -1, -1}, {26335, -1, -1, -1}, {26337, -1, -1, -1}, {26338, -1, -1, -1}, {26339, -1, -1, -1}, {26340, -1, -1, -1}, {26341, -1, -1, -1}, {26343, -1, -1, -1}, {26344, -1, -1, -1}, {26346, -1, -1, -1}, {26347, -1, -1, -1}, {26349, -1, -1, -1}, {26350, -1, -1, -1}, {26351, -1, -1, -1}, {26353, -1, -1, -1}, {26357, -1, -1, -1}, {26358, -1, -1, -1}, {26362, -1, -1, -1}, {26363, -1, -1, -1}, {26365, -1, -1, -1}, {26369, -1, -1, -1}, {26370, -1, -1, -1}, {26372, -1, -1, -1}, {26373, -1, -1, -1}, {26374, -1, -1, -1}, {26375, -1, -1, -1}, {26380, -1, -1, -1}, {26382, -1, -1, -1}, {26383, -1, -1, -1}, {26385, -1, -1, -1}, {26386, -1, -1, -1}, {26387, -1, -1, -1}, {26390, -1, -1, -1}, {26392, -1, -1, -1}, {26393, -1, -1, -1}, {26394, -1, -1, -1}, {26396, -1, -1, -1}, {26398, -1, -1, -1}, {26400, -1, -1, -1}, {26401, -1, -1, -1}, {26402, -1, -1, -1}, {26403, -1, -1, -1}, {26404, -1, -1, -1}, {26405, -1, -1, -1}, {26409, -1, -1, -1}, {26414, -1, -1, -1}, {26416, -1, -1, -1}, {26418, -1, -1, -1}, {26419, -1, -1, -1}, {26422, -1, -1, -1}, {26423, -1, -1, -1}, {26424, -1, -1, -1}, {26425, -1, -1, -1}, {26427, -1, -1, -1}, {26428, -1, -1, -1}, {26430, -1, -1, -1}, {26431, -1, -1, -1}, {26433, -1, -1, -1}, {26436, -1, -1, -1}, {26437, -1, -1, -1}, {26439, -1, -1, -1}, {26442, -1, -1, -1}, {26443, -1, -1, -1}, {26445, -1, -1, -1}, {26450, -1, -1, -1}, {26452, -1, -1, -1}, {26453, -1, -1, -1}, {26455, -1, -1, -1}, {26456, -1, -1, -1}, {26457, -1, -1, -1}, {26458, -1, -1, -1}, {26459, -1, -1, -1}, {26461, -1, -1, -1}, {26466, -1, -1, -1}, {26467, -1, -1, -1}, {26468, -1, -1, -1}, {26470, -1, -1, -1}, {26471, -1, -1, -1}, {26475, -1, -1, -1}, {26476, -1, -1, -1}, {26478, -1, -1, -1}, {26484, -1, -1, -1}, {26486, -1, -1, -1}, {26488, -1, -1, -1}, {26489, -1, -1, -1}, {26490, -1, -1, -1}, {26491, -1, -1, -1}, {26493, -1, -1, -1}, {26496, -1, -1, -1}, {26498, -1, -1, -1}, {26499, -1, -1, -1}, {26501, -1, -1, -1}, {26502, -1, -1, -1}, {26504, -1, -1, -1}, {26506, -1, -1, -1}, {26508, -1, -1, -1}, {26509, -1, -1, -1}, {26510, -1, -1, -1}, {26511, -1, -1, -1}, {26513, -1, -1, -1}, {26514, -1, -1, -1}, {26515, -1, -1, -1}, {26516, -1, -1, -1}, {26518, -1, -1, -1}, {26521, -1, -1, -1}, {26523, -1, -1, -1}, {26527, -1, -1, -1}, {26528, -1, -1, -1}, {26529, -1, -1, -1}, {26532, -1, -1, -1}, {26534, -1, -1, -1}, {26537, -1, -1, -1}, {26540, -1, -1, -1}, {26542, -1, -1, -1}, {26545, -1, -1, -1}, {26546, -1, -1, -1}, {26548, -1, -1, -1}, {26553, -1, -1, -1}, {26554, -1, -1, -1}, {26555, -1, -1, -1}, {26556, -1, -1, -1}, {26557, -1, -1, -1}, {26558, -1, -1, -1}, {26559, -1, -1, -1}, {26560, -1, -1, -1}, {26562, -1, -1, -1}, {26565, -1, -1, -1}, {26566, -1, -1, -1}, {26567, -1, -1, -1}, {26568, -1, -1, -1}, {26569, -1, -1, -1}, {26570, -1, -1, -1}, {26571, -1, -1, -1}, {26572, -1, -1, -1}, {26573, -1, -1, -1}, {26574, -1, -1, -1}, {26581, -1, -1, -1}, {26582, -1, -1, -1}, {26583, -1, -1, -1}, {26587, -1, -1, -1}, {26591, -1, -1, -1}, {26593, -1, -1, -1}, {26595, -1, -1, -1}, {26596, -1, -1, -1}, {26598, -1, -1, -1}, {26599, -1, -1, -1}, {26600, -1, -1, -1}, {26602, -1, -1, -1}, {26603, -1, -1, -1}, {26605, -1, -1, -1}, {26606, -1, -1, -1}, {26610, -1, -1, -1}, {26613, -1, -1, -1}, {26614, -1, -1, -1}, {26615, -1, -1, -1}, {26616, -1, -1, -1}, {26617, -1, -1, -1}, {26618, -1, -1, -1}, {26619, -1, -1, -1}, {26620, -1, -1, -1}, {26622, -1, -1, -1}, {26625, -1, -1, -1}, {26626, -1, -1, -1}, {26627, -1, -1, -1}, {26628, -1, -1, -1}, {26630, -1, -1, -1}, {26637, -1, -1, -1}, {26640, -1, -1, -1}, {26642, -1, -1, -1}, {26644, -1, -1, -1}, {26645, -1, -1, -1}, {26648, -1, -1, -1}, {26649, -1, -1, -1}, {26650, -1, -1, -1}, {26651, -1, -1, -1}, {26652, -1, -1, -1}, {26654, -1, -1, -1}, {26655, -1, -1, -1}, {26656, -1, -1, -1}, {26658, -1, -1, -1}, {26659, -1, -1, -1}, {26660, -1, -1, -1}, {26661, -1, -1, -1}, {26662, -1, -1, -1}, {26663, -1, -1, -1}, {26664, -1, -1, -1}, {26667, -1, -1, -1}, {26668, -1, -1, -1}, {26669, -1, -1, -1}, {26670, -1, -1, -1}, {26671, -1, -1, -1}, {26672, -1, -1, -1}, {26673, -1, -1, -1}, {26676, -1, -1, -1}, {26677, -1, -1, -1}, {26678, -1, -1, -1}, {26682, -1, -1, -1}, {26683, -1, -1, -1}, {26687, -1, -1, -1}, {26695, -1, -1, -1}, {26699, -1, -1, -1}, {26701, -1, -1, -1}, {26703, -1, -1, -1}, {26706, -1, -1, -1}, {26710, -1, -1, -1}, {26711, -1, -1, -1}, {26712, -1, -1, -1}, {26713, -1, -1, -1}, {26714, -1, -1, -1}, {26715, -1, -1, -1}, {26716, -1, -1, -1}, {26717, -1, -1, -1}, {26718, -1, -1, -1}, {26719, -1, -1, -1} },
    {{26730, -1, -1, -1}, {26732, -1, -1, -1}, {26733, -1, -1, -1}, {26734, -1, -1, -1}, {26735, -1, -1, -1}, {26736, -1, -1, -1}, {26737, -1, -1, -1}, {26738, -1, -1, -1}, {26739, -1, -1, -1}, {26741, -1, -1, -1}, {26744, -1, -1, -1}, {26745, -1, -1, -1}, {26746, -1, -1, -1}, {26747, -1, -1, -1}, {26748, -1, -1, -1}, {26749, -1, -1, -1}, {26750, -1, -1, -1}, {26751, -1, -1, -1}, {26752, -1, -1, -1}, {26754, -1, -1, -1}, {26756, -1, -1, -1}, {26759, -1, -1, -1}, {26760, -1, -1, -1}, {26761, -1, -1, -1}, {26762, -1, -1, -1}, {26763, -1, -1, -1}, {26764, -1, -1, -1}, {26765, -1, -1, -1}, {26766, -1, -1, -1}, {26768, -1, -1, -1}, {26769, -1, -1, -1}, {26770, -1, -1, -1}, {26772, -1, -1, -1}, {26773, -1, -1, -1}, {26774, -1, -1, -1}, {26777, -1, -1, -1}, {26778, -1, -1, -1}, {26779, -1, -1, -1}, {26780, -1, -1, -1}, {26782, -1, -1, -1}, {26784, -1, -1, -1}, {26785, -1, -1, -1}, {26787, -1, -1, -1}, {26788, -1, -1, -1}, {26789, -1, -1, -1}, {26793, -1, -1, -1}, {26794, -1, -1, -1}, {26795, -1, -1, -1}, {26796, -1, -1, -1}, {26798, -1, -1, -1}, {26801, -1, -1, -1}, {26802, -1, -1, -1}, {26804, -1, -1, -1}, {26806, -1, -1, -1}, {26807, -1, -1, -1}, {26808, -1, -1, -1}, {26809, -1, -1, -1}, {26810, -1, -1, -1}, {26811, -1, -1, -1}, {26812, -1, -1, -1}, {26813, -1, -1, -1}, {26814, -1, -1, -1}, {26815, -1, -1, -1}, {26817, -1, -1, -1}, {26819, -1, -1, -1}, {26820, -1, -1, -1}, {26821, -1, -1, -1}, {26822, -1, -1, -1}, {26823, -1, -1, -1}, {26824, -1, -1, -1}, {26826, -1, -1, -1}, {26828, -1, -1, -1}, {26830, -1, -1, -1}, {26831, -1, -1, -1}, {26832, -1, -1, -1}, {26833, -1, -1, -1}, {26835, -1, -1, -1}, {26836, -1, -1, -1}, {26841, -1, -1, -1}, {26843, -1, -1, -1}, {26844, -1, -1, -1}, {26845, -1, -1, -1}, {26846, -1, -1, -1}, {26849, -1, -1, -1}, {26850, -1, -1, -1}, {26852, -1, -1, -1}, {26853, -1, -1, -1}, {26854, -1, -1, -1}, {26856, -1, -1, -1}, {26857, -1, -1, -1}, {26858, -1, -1, -1}, {26859, -1, -1, -1}, {26860, -1, -1, -1}, {26861, -1, -1, -1}, {26863, -1, -1, -1}, {26866, -1, -1, -1}, {26867, -1, -1, -1}, {26868, -1, -1, -1}, {26870, -1, -1, -1}, {26871, -1, -1, -1}, {26872, -1, -1, -1}, {26875, -1, -1, -1}, {26877, -1, -1, -1}, {26878, -1, -1, -1}, {26879, -1, -1, -1}, {26880, -1, -1, -1}, {26882, -1, -1, -1}, {26883, -1, -1, -1}, {26884, -1, -1, -1}, {26886, -1, -1, -1}, {26887, -1, -1, -1}, {26888, -1, -1, -1}, {26889, -1, -1, -1}, {26890, -1, -1, -1}, {26892, -1, -1, -1}, {26897, -1, -1, -1}, {26899, -1, -1, -1}, {26900, -1, -1, -1}, {26901, -1, -1, -1}, {26902, -1, -1, -1}, {26903, -1, -1, -1}, {26904, -1, -1, -1}, {26905, -1, -1, -1}, {26906, -1, -1, -1}, {26907, -1, -1, -1}, {26908, -1, -1, -1}, {26909, -1, -1, -1}, {26910, -1, -1, -1}, {26913, -1, -1, -1}, {26914, -1, -1, -1}, {26915, -1, -1, -1}, {26917, -1, -1, -1}, {26918, -1, -1, -1}, {26919, -1, -1, -1}, {26920, -1, -1, -1}, {26921, -1, -1, -1}, {26922, -1, -1, -1}, {26923, -1, -1, -1}, {26924, -1, -1, -1}, {26926, -1, -1, -1}, {26927, -1, -1, -1}, {26929, -1, -1, -1}, {26930, -1, -1, -1}, {26931, -1, -1, -1}, {26933, -1, -1, -1}, {26934, -1, -1, -1}, {26935, -1, -1, -1}, {26936, -1, -1, -1}, {26938, -1, -1, -1}, {26939, -1, -1, -1}, {26940, -1, -1, -1}, {26942, -1, -1, -1}, {26944, -1, -1, -1}, {26945, -1, -1, -1}, {26947, -1, -1, -1}, {26948, -1, -1, -1}, {26949, -1, -1, -1}, {26950, -1, -1, -1}, {26951, -1, -1, -1}, {26952, -1, -1, -1}, {26953, -1, -1, -1}, {26955, -1, -1, -1}, {26956, -1, -1, -1}, {26957, -1, -1, -1}, {26958, -1, -1, -1}, {26959, -1, -1, -1}, {26960, -1, -1, -1}, {26961, -1, -1, -1}, {26962, -1, -1, -1}, {26965, -1, -1, -1}, {26966, -1, -1, -1}, {26968, -1, -1, -1}, {26969, -1, -1, -1}, {26971, -1, -1, -1}, {26972, -1, -1, -1}, {26975, -1, -1, -1}, {26977, -1, -1, -1}, {26978, -1, -1, -1}, {26980, -1, -1, -1}, {26981, -1, -1, -1}, {26983, -1, -1, -1}, {26985, -1, -1, -1}, {26986, -1, -1, -1}, {26988, -1, -1, -1}, {26991, -1, -1, -1}, {26992, -1, -1, -1}, {26994, -1, -1, -1}, {26995, -1, -1, -1}, {26996, -1, -1, -1}, {26998, -1, -1, -1}, {27002, -1, -1, -1}, {27003, -1, -1, -1}, {27005, -1, -1, -1}, {27006, -1, -1, -1}, {27007, -1, -1, -1}, {27009, -1, -1, -1}, {27011, -1, -1, -1}, {27013, -1, -1, -1}, {27018, -1, -1, -1}, {27019, -1, -1, -1}, {27020, -1, -1, -1}, {27022, -1, -1, -1}, {27023, -1, -1, -1}, {27024, -1, -1, -1}, {27025, -1, -1, -1}, {27026, -1, -1, -1}, {27027, -1, -1, -1}, {27030, -1, -1, -1}, {27031, -1, -1, -1}, {27033, -1, -1, -1}, {27034, -1, -1, -1}, {27037, -1, -1, -1}, {27038, -1, -1, -1}, {27039, -1, -1, -1}, {27040, -1, -1, -1}, {27041, -1, -1, -1}, {27042, -1, -1, -1}, {27043, -1, -1, -1}, {27044, -1, -1, -1}, {27045, -1, -1, -1}, {27046, -1, -1, -1}, {27049, -1, -1, -1}, {27052, -1, -1, -1}, {27055, -1, -1, -1}, {27056, -1, -1, -1}, {27058, -1, -1, -1}, {27059, -1, -1, -1}, {27061, -1, -1, -1}, {27062, -1, -1, -1}, {27064, -1, -1, -1}, {27065, -1, -1, -1}, {27066, -1, -1, -1}, {27068, -1, -1, -1}, {27069, -1, -1, -1}, {27070, -1, -1, -1}, {27072, -1, -1, -1}, {27074, -1, -1, -1}, {27075, -1, -1, -1}, {27076, -1, -1, -1}, {27077, -1, -1, -1}, {27078, -1, -1, -1}, {27079, -1, -1, -1}, {27080, -1, -1, -1}, {27081, -1, -1, -1}, {27087, -1, -1, -1}, {27089, -1, -1, -1}, {27090, -1, -1, -1}, {27091, -1, -1, -1}, {27093, -1, -1, -1}, {27094, -1, -1, -1}, {27095, -1, -1, -1}, {27096, -1, -1, -1}, {27097, -1, -1, -1}, {27098, -1, -1, -1}, {27100, -1, -1, -1}, {27101, -1, -1, -1} },
    {{27102, -1, -1, -1}, {27105, -1, -1, -1}, {27106, -1, -1, -1}, {27107, -1, -1, -1}, {27108, -1, -1, -1}, {27109, -1, -1, -1}, {27110, -1, -1, -1}, {27112, -1, -1, -1}, {27113, -1, -1, -1}, {27114, -1, -1, -1}, {27115, -1, -1, -1}, {27116, -1, -1, -1}, {27118, -1, -1, -1}, {27119, -1, -1, -1}, {27120, -1, -1, -1}, {27121, -1, -1, -1}, {27124, -1, -1, -1}, {27125, -1, -1, -1}, {27126, -1, -1, -1}, {27127, -1, -1, -1}, {27128, -1, -1, -1}, {27129, -1, -1, -1}, {27130, -1, -1, -1}, {27131, -1, -1, -1}, {27132, -1, -1, -1}, {27134, -1, -1, -1}, {27136, -1, -1, -1}, {27139, -1, -1, -1}, {27140, -1, -1, -1}, {27142, -1, -1, -1}, {27143, -1, -1, -1}, {27144, -1, -1, -1}, {27145, -1, -1, -1}, {27147, -1, -1, -1}, {27148, -1, -1, -1}, {27149, -1, -1, -1}, {27150, -1, -1, -1}, {27151, -1, -1, -1}, {27152, -1, -1, -1}, {27153, -1, -1, -1}, {27154, -1, -1, -1}, {27156, -1, -1, -1}, {27157, -1, -1, -1}, {27158, -1, -1, -1}, {27162, -1, -1, -1}, {27163, -1, -1, -1}, {27164, -1, -1, -1}, {27165, -1, -1, -1}, {27168, -1, -1, -1}, {27170, -1, -1, -1}, {27172, -1, -1, -1}, {27173, -1, -1, -1}, {27174, -1, -1, -1}, {27175, -1, -1, -1}, {27177, -1, -1, -1}, {27179, -1, -1, -1}, {27180, -1, -1, -1}, {27181, -1, -1, -1}, {27182, -1, -1, -1}, {27184, -1, -1, -1}, {27186, -1, -1, -1}, {27187, -1, -1, -1}, {27188, -1, -1, -1}, {27190, -1, -1, -1}, {27191, -1, -1, -1}, {27195, -1, -1, -1}, {27196, -1, -1, -1}, {27199, -1, -1, -1}, {27200, -1, -1, -1}, {27201, -1, -1, -1}, {27202, -1, -1, -1}, {27203, -1, -1, -1}, {27205, -1, -1, -1}, {27206, -1, -1, -1}, {27209, -1, -1, -1}, {27210, -1, -1, -1}, {27212, -1, -1, -1}, {27213, -1, -1, -1}, {27214, -1, -1, -1}, {27215, -1, -1, -1}, {27217, -1, -1, -1}, {27218, -1, -1, -1}, {27219, -1, -1, -1}, {27220, -1, -1, -1}, {27221, -1, -1, -1}, {27222, -1, -1, -1}, {27223, -1, -1, -1}, {27226, -1, -1, -1}, {27228, -1, -1, -1}, {27229, -1, -1, -1}, {27230, -1, -1, -1}, {27232, -1, -1, -1}, {27235, -1, -1, -1}, {27236, -1, -1, -1}, {27238, -1, -1, -1}, {27239, -1, -1, -1}, {27240, -1, -1, -1}, {27241, -1, -1, -1}, {27242, -1, -1, -1}, {27243, -1, -1, -1}, {27244, -1, -1, -1}, {27245, -1, -1, -1}, {27246, -1, -1, -1}, {27247, -1, -1, -1}, {27248, -1, -1, -1}, {27250, -1, -1, -1}, {27251, -1, -1, -1}, {27252, -1, -1, -1}, {27253, -1, -1, -1}, {27254, -1, -1, -1}, {27255, -1, -1, -1}, {27256, -1, -1, -1}, {27258, -1, -1, -1}, {27259, -1, -1, -1}, {27261, -1, -1, -1}, {27262, -1, -1, -1}, {27263, -1, -1, -1}, {27265, -1, -1, -1}, {27266, -1, -1, -1}, {27267, -1, -1, -1}, {27269, -1, -1, -1}, {27270, -1, -1, -1}, {27271, -1, -1, -1}, {27272, -1, -1, -1}, {27274, -1, -1, -1}, {27275, -1, -1, -1}, {27276, -1, -1, -1}, {27277, -1, -1, -1}, {27279, -1, -1, -1}, {27282, -1, -1, -1}, {27283, -1, -1, -1}, {27285, -1, -1, -1}, {27286, -1, -1, -1}, {27288, -1, -1, -1}, {27289, -1, -1, -1}, {27290, -1, -1, -1}, {27291, -1, -1, -1}, {27293, -1, -1, -1}, {27294, -1, -1, -1}, {27295, -1, -1, -1}, {27297, -1, -1, -1}, {27300, -1, -1, -1}, {27301, -1, -1, -1}, {27302, -1, -1, -1}, {27303, -1, -1, -1}, {27304, -1, -1, -1}, {27306, -1, -1, -1}, {27309, -1, -1, -1}, {27310, -1, -1, -1}, {27312, -1, -1, -1}, {27313, -1, -1, -1}, {27314, -1, -1, -1}, {27316, -1, -1, -1}, {27317, -1, -1, -1}, {27318, -1, -1, -1}, {27319, -1, -1, -1}, {27321, -1, -1, -1}, {27322, -1, -1, -1}, {27324, -1, -1, -1}, {27325, -1, -1, -1}, {27326, -1, -1, -1}, {27327, -1, -1, -1}, {27328, -1, -1, -1}, {27329, -1, -1, -1}, {27330, -1, -1, -1}, {27332, -1, -1, -1}, {27333, -1, -1, -1}, {27334, -1, -1, -1}, {27335, -1, -1, -1}, {27336, -1, -1, -1}, {27337, -1, -1, -1}, {27338, -1, -1, -1}, {27339, -1, -1, -1}, {27340, -1, -1, -1}, {27341, -1, -1, -1}, {27342, -1, -1, -1}, {27343, -1, -1, -1}, {27344, -1, -1, -1}, {27345, -1, -1, -1}, {27346, -1, -1, -1}, {27348, -1, -1, -1}, {27349, -1, -1, -1}, {27350, -1, -1, -1}, {27351, -1, -1, -1}, {27352, -1, -1, -1}, {27353, -1, -1, -1}, {27356, -1, -1, -1}, {27360, -1, -1, -1}, {27361, -1, -1, -1}, {27362, -1, -1, -1}, {27363, -1, -1, -1}, {27364, -1, -1, -1}, {27365, -1, -1, -1}, {27366, -1, -1, -1}, {27369, -1, -1, -1}, {27371, -1, -1, -1}, {27373, -1, -1, -1}, {27374, -1, -1, -1}, {27375, -1, -1, -1}, {27376, -1, -1, -1}, {27377, -1, -1, -1}, {27378, -1, -1, -1}, {27380, -1, -1, -1}, {27381, -1, -1, -1}, {27382, -1, -1, -1}, {27383, -1, -1, -1}, {27385, -1, -1, -1}, {27386, -1, -1, -1}, {27388, -1, -1, -1}, {27389, -1, -1, -1}, {27390, -1, -1, -1}, {27391, -1, -1, -1}, {27392, -1, -1, -1}, {27393, -1, -1, -1}, {27394, -1, -1, -1}, {27395, -1, -1, -1}, {27397, -1, -1, -1}, {27398, -1, -1, -1}, {27399, -1, -1, -1}, {27400, -1, -1, -1}, {27401, -1, -1, -1}, {27403, -1, -1, -1}, {27404, -1, -1, -1}, {27405, -1, -1, -1}, {27406, -1, -1, -1}, {27408, -1, -1, -1}, {27409, -1, -1, -1}, {27411, -1, -1, -1}, {27412, -1, -1, -1}, {27413, -1, -1, -1}, {27415, -1, -1, -1}, {27416, -1, -1, -1}, {27417, -1, -1, -1}, {27418, -1, -1, -1}, {27419, -1, -1, -1}, {27420, -1, -1, -1}, {27421, -1, -1, -1}, {27423, -1, -1, -1}, {27429, -1, -1, -1}, {27430, -1, -1, -1}, {27432, -1, -1, -1}, {27433, -1, -1, -1}, {27434, -1, -1, -1}, {27435, -1, -1, -1}, {27436, -1, -1, -1}, {27437, -1, -1, -1}, {27438, -1, -1, -1}, {27439, -1, -1, -1}, {27440, -1, -1, -1}, {27441, -1, -1, -1}, {27443, -1, -1, -1}, {27444, -1, -1, -1}, {27445, -1, -1, -1}, {27446, -1, -1, -1}, {27448, -1, -1, -1}, {27451, -1, -1, -1} },
    {{27452, -1, -1, -1}, {27455, -1, -1, -1}, {27456, -1, -1, -1}, {27457, -1, -1, -1}, {27458, -1, -1, -1}, {27460, -1, -1, -1}, {27461, -1, -1, -1}, {27464, -1, -1, -1}, {27466, -1, -1, -1}, {27467, -1, -1, -1}, {27469, -1, -1, -1}, {27470, -1, -1, -1}, {27471, -1, -1, -1}, {27473, -1, -1, -1}, {27474, -1, -1, -1}, {27475, -1, -1, -1}, {27476, -1, -1, -1}, {27477, -1, -1, -1}, {27478, -1, -1, -1}, {27479, -1, -1, -1}, {27480, -1, -1, -1}, {27482, -1, -1, -1}, {27483, -1, -1, -1}, {27484, -1, -1, -1}, {27485, -1, -1, -1}, {27486, -1, -1, -1}, {27488, -1, -1, -1}, {27496, -1, -1, -1}, {27497, -1, -1, -1}, {27499, -1, -1, -1}, {27500, -1, -1, -1}, {27501, -1, -1, -1}, {27502, -1, -1, -1}, {27503, -1, -1, -1}, {27504, -1, -1, -1}, {27505, -1, -1, -1}, {27507, -1, -1, -1}, {27508, -1, -1, -1}, {27509, -1, -1, -1}, {27510, -1, -1, -1}, {27514, -1, -1, -1}, {27517, -1, -1, -1}, {27518, -1, -1, -1}, {27519, -1, -1, -1}, {27520, -1, -1, -1}, {27525, -1, -1, -1}, {27528, -1, -1, -1}, {27532, -1, -1, -1}, {27534, -1, -1, -1}, {27535, -1, -1, -1}, {27536, -1, -1, -1}, {27537, -1, -1, -1}, {27540, -1, -1, -1}, {27541, -1, -1, -1}, {27543, -1, -1, -1}, {27545, -1, -1, -1}, {27548, -1, -1, -1}, {27549, -1, -1, -1}, {27551, -1, -1, -1}, {27552, -1, -1, -1}, {27554, -1, -1, -1}, {27555, -1, -1, -1}, {27557, -1, -1, -1}, {27558, -1, -1, -1}, {27559, -1, -1, -1}, {27560, -1, -1, -1}, {27561, -1, -1, -1}, {27564, -1, -1, -1}, {27565, -1, -1, -1}, {27568, -1, -1, -1}, {27569, -1, -1, -1}, {27574, -1, -1, -1}, {27576, -1, -1, -1}, {27577, -1, -1, -1}, {27580, -1, -1, -1}, {27581, -1, -1, -1}, {27582, -1, -1, -1}, {27584, -1, -1, -1}, {27587, -1, -1, -1}, {27588, -1, -1, -1}, {27591, -1, -1, -1}, {27592, -1, -1, -1}, {27593, -1, -1, -1}, {27594, -1, -1, -1}, {27596, -1, -1, -1}, {27598, -1, -1, -1}, {27600, -1, -1, -1}, {27601, -1, -1, -1}, {27608, -1, -1, -1}, {27610, -1, -1, -1}, {27612, -1, -1, -1}, {27613, -1, -1, -1}, {27614, -1, -1, -1}, {27615, -1, -1, -1}, {27616, -1, -1, -1}, {27618, -1, -1, -1}, {27619, -1, -1, -1}, {27620, -1, -1, -1}, {27621, -1, -1, -1}, {27622, -1, -1, -1}, {27623, -1, -1, -1}, {27624, -1, -1, -1}, {27625, -1, -1, -1}, {27628, -1, -1, -1}, {27629, -1, -1, -1}, {27630, -1, -1, -1}, {27632, -1, -1, -1}, {27633, -1, -1, -1}, {27634, -1, -1, -1}, {27636, -1, -1, -1}, {27638, -1, -1, -1}, {27639, -1, -1, -1}, {27640, -1, -1, -1}, {27642, -1, -1, -1}, {27643, -1, -1, -1}, {27644, -1, -1, -1}, {27646, -1, -1, -1}, {27648, -1, -1, -1}, {27649, -1, -1, -1}, {27650, -1, -1, -1}, {27651, -1, -1, -1}, {27652, -1, -1, -1}, {27657, -1, -1, -1}, {27658, -1, -1, -1}, {27659, -1, -1, -1}, {27662, -1, -1, -1}, {27666, -1, -1, -1}, {27671, -1, -1, -1}, {27676, -1, -1, -1}, {27677, -1, -1, -1}, {27678, -1, -1, -1}, {27680, -1, -1, -1}, {27685, -1, -1, -1}, {27693, -1, -1, -1}, {27697, -1, -1, -1}, {27699, -1, -1, -1}, {27702, -1, -1, -1}, {27703, -1, -1, -1}, {27705, -1, -1, -1}, {27706, -1, -1, -1}, {27707, -1, -1, -1}, {27708, -1, -1, -1}, {27710, -1, -1, -1}, {27711, -1, -1, -1}, {27715, -1, -1, -1}, {27716, -1, -1, -1}, {27717, -1, -1, -1}, {27720, -1, -1, -1}, {27723, -1, -1, -1}, {27724, -1, -1, -1}, {27725, -1, -1, -1}, {27726, -1, -1, -1}, {27727, -1, -1, -1}, {27729, -1, -1, -1}, {27730, -1, -1, -1}, {27731, -1, -1, -1}, {27734, -1, -1, -1}, {27736, -1, -1, -1}, {27737, -1, -1, -1}, {27738, -1, -1, -1}, {27746, -1, -1, -1}, {27747, -1, -1, -1}, {27749, -1, -1, -1}, {27750, -1, -1, -1}, {27751, -1, -1, -1}, {27755, -1, -1, -1}, {27756, -1, -1, -1}, {27757, -1, -1, -1}, {27758, -1, -1, -1}, {27759, -1, -1, -1}, {27761, -1, -1, -1}, {27763, -1, -1, -1}, {27765, -1, -1, -1}, {27767, -1, -1, -1}, {27768, -1, -1, -1}, {27770, -1, -1, -1}, {27771, -1, -1, -1}, {27772, -1, -1, -1}, {27775, -1, -1, -1}, {27776, -1, -1, -1}, {27780, -1, -1, -1}, {27783, -1, -1, -1}, {27786, -1, -1, -1}, {27787, -1, -1, -1}, {27789, -1, -1, -1}, {27790, -1, -1, -1}, {27793, -1, -1, -1}, {27794, -1, -1, -1}, {27797, -1, -1, -1}, {27798, -1, -1, -1}, {27799, -1, -1, -1}, {27800, -1, -1, -1}, {27802, -1, -1, -1}, {27804, -1, -1, -1}, {27805, -1, -1, -1}, {27806, -1, -1, -1}, {27808, -1, -1, -1}, {27810, -1, -1, -1}, {27816, -1, -1, -1}, {27820, -1, -1, -1}, {27823, -1, -1, -1}, {27824, -1, -1, -1}, {27828, -1, -1, -1}, {27829, -1, -1, -1}, {27830, -1, -1, -1}, {27831, -1, -1, -1}, {27834, -1, -1, -1}, {27840, -1, -1, -1}, {27841, -1, -1, -1}, {27842, -1, -1, -1}, {27843, -1, -1, -1}, {27846, -1, -1, -1}, {27847, -1, -1, -1}, {27848, -1, -1, -1}, {27851, -1, -1, -1}, {27853, -1, -1, -1}, {27854, -1, -1, -1}, {27855, -1, -1, -1}, {27857, -1, -1, -1}, {27858, -1, -1, -1}, {27864, -1, -1, -1}, {27865, -1, -1, -1}, {27866, -1, -1, -1}, {27868, -1, -1, -1}, {27869, -1, -1, -1}, {27871, -1, -1, -1}, {27876, -1, -1, -1}, {27878, -1, -1, -1}, {27879, -1, -1, -1}, {27881, -1, -1, -1}, {27884, -1, -1, -1}, {27885, -1, -1, -1}, {27890, -1, -1, -1}, {27892, -1, -1, -1}, {27897, -1, -1, -1}, {27903, -1, -1, -1}, {27904, -1, -1, -1}, {27906, -1, -1, -1}, {27907, -1, -1, -1}, {27909, -1, -1, -1}, {27910, -1, -1, -1}, {27912, -1, -1, -1}, {27913, -1, -1, -1}, {27914, -1, -1, -1}, {27917, -1, -1, -1}, {27919, -1, -1, -1}, {27920, -1, -1, -1}, {27921, -1, -1, -1}, {27923, -1, -1, -1}, {27924, -1, -1, -1}, {27925, -1, -1, -1}, {27926, -1, -1, -1}, {27928, -1, -1, -1}, {27932, -1, -1, -1}, {27933, -1, -1, -1}, {27935, -1, -1, -1} },
    {{27936, -1, -1, -1}, {27937, -1, -1, -1}, {27938, -1, -1, -1}, {27939, -1, -1, -1}, {27940, -1, -1, -1}, {27942, -1, -1, -1}, {27944, -1, -1, -1}, {27945, -1, -1, -1}, {27948, -1, -1, -1}, {27949, -1, -1, -1}, {27951, -1, -1, -1}, {27952, -1, -1, -1}, {27956, -1, -1, -1}, {27958, -1, -1, -1}, {27959, -1, -1, -1}, {27960, -1, -1, -1}, {27962, -1, -1, -1}, {27967, -1, -1, -1}, {27968, -1, -1, -1}, {27970, -1, -1, -1}, {27972, -1, -1, -1}, {27977, -1, -1, -1}, {27980, -1, -1, -1}, {27984, -1, -1, -1}, {27989, -1, -1, -1}, {27990, -1, -1, -1}, {27991, -1, -1, -1}, {27992, -1, -1, -1}, {27995, -1, -1, -1}, {27997, -1, -1, -1}, {27999, -1, -1, -1}, {28001, -1, -1, -1}, {28002, -1, -1, -1}, {28004, -1, -1, -1}, {28005, -1, -1, -1}, {28007, -1, -1, -1}, {28008, -1, -1, -1}, {28011, -1, -1, -1}, {28012, -1, -1, -1}, {28013, -1, -1, -1}, {28016, -1, -1, -1}, {28017, -1, -1, -1}, {28018, -1, -1, -1}, {28019, -1, -1, -1}, {28021, -1, -1, -1}, {28022, -1, -1, -1}, {28026, -1, -1, -1}, {28027, -1, -1, -1}, {28029, -1, -1, -1}, {28030, -1, -1, -1}, {28031, -1, -1, -1}, {28032, -1, -1, -1}, {28033, -1, -1, -1}, {28035, -1, -1, -1}, {28036, -1, -1, -1}, {28038, -1, -1, -1}, {28042, -1, -1, -1}, {28043, -1, -1, -1}, {28045, -1, -1, -1}, {28047, -1, -1, -1}, {28048, -1, -1, -1}, {28050, -1, -1, -1}, {28054, -1, -1, -1}, {28055, -1, -1, -1}, {28056, -1, -1, -1}, {28057, -1, -1, -1}, {28058, -1, -1, -1}, {28060, -1, -1, -1}, {28066, -1, -1, -1}, {28069, -1, -1, -1}, {28076, -1, -1, -1}, {28077, -1, -1, -1}, {28080, -1, -1, -1}, {28081, -1, -1, -1}, {28083, -1, -1, -1}, {28084, -1, -1, -1}, {28086, -1, -1, -1}, {28087, -1, -1, -1}, {28089, -1, -1, -1}, {28090, -1, -1, -1}, {28091, -1, -1, -1}, {28092, -1, -1, -1}, {28093, -1, -1, -1}, {28094, -1, -1, -1}, {28097, -1, -1, -1}, {28098, -1, -1, -1}, {28099, -1, -1, -1}, {28104, -1, -1, -1}, {28105, -1, -1, -1}, {28106, -1, -1, -1}, {28109, -1, -1, -1}, {28110, -1, -1, -1}, {28111, -1, -1, -1}, {28112, -1, -1, -1}, {28114, -1, -1, -1}, {28115, -1, -1, -1}, {28116, -1, -1, -1}, {28117, -1, -1, -1}, {28119, -1, -1, -1}, {28122, -1, -1, -1}, {28123, -1, -1, -1}, {28124, -1, -1, -1}, {28127, -1, -1, -1}, {28130, -1, -1, -1}, {28131, -1, -1, -1}, {28133, -1, -1, -1}, {28135, -1, -1, -1}, {28136, -1, -1, -1}, {28137, -1, -1, -1}, {28141, -1, -1, -1}, {28143, -1, -1, -1}, {28144, -1, -1, -1}, {28146, -1, -1, -1}, {28148, -1, -1, -1}, {28152, -1, -1, -1}, {28157, -1, -1, -1}, {28158, -1, -1, -1}, {28159, -1, -1, -1}, {28160, -1, -1, -1}, {28161, -1, -1, -1}, {28162, -1, -1, -1}, {28163, -1, -1, -1}, {28164, -1, -1, -1}, {28166, -1, -1, -1}, {28167, -1, -1, -1}, {28168, -1, -1, -1}, {28169, -1, -1, -1}, {28171, -1, -1, -1}, {28175, -1, -1, -1}, {28178, -1, -1, -1}, {28179, -1, -1, -1}, {28181, -1, -1, -1}, {28184, -1, -1, -1}, {28185, -1, -1, -1}, {28187, -1, -1, -1}, {28188, -1, -1, -1}, {28190, -1, -1, -1}, {28191, -1, -1, -1}, {28194, -1, -1, -1}, {28199, -1, -1, -1}, {28200, -1, -1, -1}, {28202, -1, -1, -1}, {28206, -1, -1, -1}, {28208, -1, -1, -1}, {28209, -1, -1, -1}, {28211, -1, -1, -1}, {28213, -1, -1, -1}, {28214, -1, -1, -1}, {28215, -1, -1, -1}, {28217, -1, -1, -1}, {28219, -1, -1, -1}, {28220, -1, -1, -1}, {28221, -1, -1, -1}, {28223, -1, -1, -1}, {28224, -1, -1, -1}, {28225, -1, -1, -1}, {28226, -1, -1, -1}, {28229, -1, -1, -1}, {28230, -1, -1, -1}, {28231, -1, -1, -1}, {28232, -1, -1, -1}, {28233, -1, -1, -1}, {28234, -1, -1, -1}, {28235, -1, -1, -1}, {28236, -1, -1, -1}, {28239, -1, -1, -1}, {28240, -1, -1, -1}, {28241, -1, -1, -1}, {28242, -1, -1, -1}, {28245, -1, -1, -1}, {28247, -1, -1, -1}, {28249, -1, -1, -1}, {28250, -1, -1, -1}, {28252, -1, -1, -1}, {28253, -1, -1, -1}, {28256, -1, -1, -1}, {28257, -1, -1, -1}, {28258, -1, -1, -1}, {28259, -1, -1, -1}, {28260, -1, -1, -1}, {28261, -1, -1, -1}, {28262, -1, -1, -1}, {28263, -1, -1, -1}, {28264, -1, -1, -1}, {28265, -1, -1, -1}, {28266, -1, -1, -1}, {28268, -1, -1, -1}, {28269, -1, -1, -1}, {28272, -1, -1, -1}, {28273, -1, -1, -1}, {28274, -1, -1, -1}, {28275, -1, -1, -1}, {28276, -1, -1, -1}, {28277, -1, -1, -1}, {28278, -1, -1, -1}, {28279, -1, -1, -1}, {28280, -1, -1, -1}, {28281, -1, -1, -1}, {28282, -1, -1, -1}, {28283, -1, -1, -1}, {28284, -1, -1, -1}, {28285, -1, -1, -1}, {28288, -1, -1, -1}, {28289, -1, -1, -1}, {28290, -1, -1, -1}, {28292, -1, -1, -1}, {28295, -1, -1, -1}, {28296, -1, -1, -1}, {28298, -1, -1, -1}, {28299, -1, -1, -1}, {28300, -1, -1, -1}, {28301, -1, -1, -1}, {28302, -1, -1, -1}, {28305, -1, -1, -1}, {28306, -1, -1, -1}, {28307, -1, -1, -1}, {28308, -1, -1, -1}, {28309, -1, -1, -1}, {28311, -1, -1, -1}, {28313, -1, -1, -1}, {28314, -1, -1, -1}, {28315, -1, -1, -1}, {28318, -1, -1, -1}, {28320, -1, -1, -1}, {28321, -1, -1, -1}, {28323, -1, -1, -1}, {28324, -1, -1, -1}, {28326, -1, -1, -1}, {28328, -1, -1, -1}, {28329, -1, -1, -1}, {28331, -1, -1, -1}, {28332, -1, -1, -1}, {28333, -1, -1, -1}, {28334, -1, -1, -1}, {28336, -1, -1, -1}, {28339, -1, -1, -1}, {28341, -1, -1, -1}, {28344, -1, -1, -1}, {28345, -1, -1, -1}, {28348, -1, -1, -1}, {28350, -1, -1, -1}, {28351, -1, -1, -1}, {28352, -1, -1, -1}, {28355, -1, -1, -1}, {28358, -1, -1, -1}, {28360, -1, -1, -1}, {28361, -1, -1, -1}, {28362, -1, -1, -1}, {28365, -1, -1, -1}, {28368, -1, -1, -1}, {28370, -1, -1, -1}, {28374, -1, -1, -1}, {28376, -1, -1, -1}, {28377, -1, -1, -1}, {28379, -1, -1, -1}, {28380, -1, -1, -1} },
    {{28381, -1, -1, -1}, {28387, -1, -1, -1}, {28391, -1, -1, -1}, {28394, -1, -1, -1}, {28395, -1, -1, -1}, {28397, -1, -1, -1}, {28398, -1, -1, -1}, {28400, -1, -1, -1}, {28401, -1, -1, -1}, {28403, -1, -1, -1}, {28405, -1, -1, -1}, {28406, -1, -1, -1}, {28410, -1, -1, -1}, {28411, -1, -1, -1}, {28412, -1, -1, -1}, {28413, -1, -1, -1}, {28414, -1, -1, -1}, {28416, -1, -1, -1}, {28419, -1, -1, -1}, {28420, -1, -1, -1}, {28421, -1, -1, -1}, {28423, -1, -1, -1}, {28424, -1, -1, -1}, {28426, -1, -1, -1}, {28427, -1, -1, -1}, {28428, -1, -1, -1}, {28429, -1, -1, -1}, {28430, -1, -1, -1}, {28432, -1, -1, -1}, {28433, -1, -1, -1}, {28434, -1, -1, -1}, {28438, -1, -1, -1}, {28439, -1, -1, -1}, {28440, -1, -1, -1}, {28441, -1, -1, -1}, {28443, -1, -1, -1}, {28444, -1, -1, -1}, {28445, -1, -1, -1}, {28446, -1, -1, -1}, {28447, -1, -1, -1}, {28449, -1, -1, -1}, {28453, -1, -1, -1}, {28454, -1, -1, -1}, {28455, -1, -1, -1}, {28456, -1, -1, -1}, {28462, -1, -1, -1}, {28464, -1, -1, -1}, {28468, -1, -1, -1}, {28469, -1, -1, -1}, {28471, -1, -1, -1}, {28473, -1, -1, -1}, {28474, -1, -1, -1}, {28475, -1, -1, -1}, {28476, -1, -1, -1}, {28477, -1, -1, -1}, {28480, -1, -1, -1}, {28482, -1, -1, -1}, {28483, -1, -1, -1}, {28484, -1, -1, -1}, {28485, -1, -1, -1}, {28488, -1, -1, -1}, {28489, -1, -1, -1}, {28490, -1, -1, -1}, {28492, -1, -1, -1}, {28494, -1, -1, -1}, {28495, -1, -1, -1}, {28496, -1, -1, -1}, {28498, -1, -1, -1}, {28499, -1, -1, -1}, {28501, -1, -1, -1}, {28502, -1, -1, -1}, {28503, -1, -1, -1}, {28506, -1, -1, -1}, {28507, -1, -1, -1}, {28509, -1, -1, -1}, {28511, -1, -1, -1}, {28512, -1, -1, -1}, {28513, -1, -1, -1}, {28515, -1, -1, -1}, {28517, -1, -1, -1}, {28519, -1, -1, -1}, {28520, -1, -1, -1}, {28521, -1, -1, -1}, {28522, -1, -1, -1}, {28523, -1, -1, -1}, {28524, -1, -1, -1}, {28529, -1, -1, -1}, {28531, -1, -1, -1}, {28533, -1, -1, -1}, {28534, -1, -1, -1}, {28537, -1, -1, -1}, {28539, -1, -1, -1}, {28541, -1, -1, -1}, {28542, -1, -1, -1}, {28545, -1, -1, -1}, {28546, -1, -1, -1}, {28547, -1, -1, -1}, {28549, -1, -1, -1}, {28554, -1, -1, -1}, {28555, -1, -1, -1}, {28559, -1, -1, -1}, {28560, -1, -1, -1}, {28561, -1, -1, -1}, {28562, -1, -1, -1}, {28563, -1, -1, -1}, {28564, -1, -1, -1}, {28565, -1, -1, -1}, {28566, -1, -1, -1}, {28568, -1, -1, -1}, {28569, -1, -1, -1}, {28570, -1, -1, -1}, {28571, -1, -1, -1}, {28573, -1, -1, -1}, {28574, -1, -1, -1}, {28575, -1, -1, -1}, {28578, -1, -1, -1}, {28579, -1, -1, -1}, {28581, -1, -1, -1}, {28582, -1, -1, -1}, {28584, -1, -1, -1}, {28586, -1, -1, -1}, {28587, -1, -1, -1}, {28588, -1, -1, -1}, {28589, -1, -1, -1}, {28591, -1, -1, -1}, {28592, -1, -1, -1}, {28594, -1, -1, -1}, {28596, -1, -1, -1}, {28597, -1, -1, -1}, {28599, -1, -1, -1}, {28600, -1, -1, -1}, {28602, -1, -1, -1}, {28603, -1, -1, -1}, {28604, -1, -1, -1}, {28605, -1, -1, -1}, {28606, -1, -1, -1}, {28607, -1, -1, -1}, {28612, -1, -1, -1}, {28613, -1, -1, -1}, {28614, -1, -1, -1}, {28615, -1, -1, -1}, {28616, -1, -1, -1}, {28618, -1, -1, -1}, {28619, -1, -1, -1}, {28620, -1, -1, -1}, {28621, -1, -1, -1}, {28622, -1, -1, -1}, {28623, -1, -1, -1}, {28624, -1, -1, -1}, {28627, -1, -1, -1}, {28628, -1, -1, -1}, {28630, -1, -1, -1}, {28631, -1, -1, -1}, {28633, -1, -1, -1}, {28634, -1, -1, -1}, {28636, -1, -1, -1}, {28637, -1, -1, -1}, {28642, -1, -1, -1}, {28643, -1, -1, -1}, {28645, -1, -1, -1}, {28646, -1, -1, -1}, {28647, -1, -1, -1}, {28648, -1, -1, -1}, {28649, -1, -1, -1}, {28650, -1, -1, -1}, {28652, -1, -1, -1}, {28653, -1, -1, -1}, {28658, -1, -1, -1}, {28659, -1, -1, -1}, {28660, -1, -1, -1}, {28661, -1, -1, -1}, {28662, -1, -1, -1}, {28663, -1, -1, -1}, {28664, -1, -1, -1}, {28665, -1, -1, -1}, {28667, -1, -1, -1}, {28669, -1, -1, -1}, {28671, -1, -1, -1}, {28672, -1, -1, -1}, {28673, -1, -1, -1}, {28674, -1, -1, -1}, {28675, -1, -1, -1}, {28676, -1, -1, -1}, {28679, -1, -1, -1}, {28680, -1, -1, -1}, {28682, -1, -1, -1}, {28684, -1, -1, -1}, {28685, -1, -1, -1}, {28686, -1, -1, -1}, {28688, -1, -1, -1}, {28690, -1, -1, -1}, {28691, -1, -1, -1}, {28692, -1, -1, -1}, {28694, -1, -1, -1}, {28695, -1, -1, -1}, {28697, -1, -1, -1}, {28700, -1, -1, -1}, {28702, -1, -1, -1}, {28705, -1, -1, -1}, {28706, -1, -1, -1}, {28708, -1, -1, -1}, {28709, -1, -1, -1}, {28710, -1, -1, -1}, {28713, -1, -1, -1}, {28714, -1, -1, -1}, {28715, -1, -1, -1}, {28716, -1, -1, -1}, {28717, -1, -1, -1}, {28718, -1, -1, -1}, {28719, -1, -1, -1}, {28721, -1, -1, -1}, {28723, -1, -1, -1}, {28724, -1, -1, -1}, {28726, -1, -1, -1}, {28727, -1, -1, -1}, {28728, -1, -1, -1}, {28730, -1, -1, -1}, {28731, -1, -1, -1}, {28732, -1, -1, -1}, {28733, -1, -1, -1}, {28735, -1, -1, -1}, {28736, -1, -1, -1}, {28737, -1, -1, -1}, {28738, -1, -1, -1}, {28741, -1, -1, -1}, {28742, -1, -1, -1}, {28743, -1, -1, -1}, {28744, -1, -1, -1}, {28745, -1, -1, -1}, {28746, -1, -1, -1}, {28747, -1, -1, -1}, {28749, -1, -1, -1}, {28750, -1, -1, -1}, {28752, -1, -1, -1}, {28754, -1, -1, -1}, {28755, -1, -1, -1}, {28756, -1, -1, -1}, {28758, -1, -1, -1}, {28759, -1, -1, -1}, {28761, -1, -1, -1}, {28762, -1, -1, -1}, {28763, -1, -1, -1}, {28764, -1, -1, -1}, {28767, -1, -1, -1}, {28768, -1, -1, -1}, {28769, -1, -1, -1}, {28770, -1, -1, -1}, {28773, -1, -1, -1}, {28774, -1, -1, -1}, {28776, -1, -1, -1}, {28777, -1, -1, -1}, {28778, -1, -1, -1}, {28782, -1, -1, -1}, {28785, -1, -1, -1}, {28786, -1, -1, -1}, {28787, -1, -1, -1} },
    {{28788, -1, -1, -1}, {28791, -1, -1, -1}, {28793, -1, -1, -1}, {28794, -1, -1, -1}, {28795, -1, -1, -1}, {28797, -1, -1, -1}, {28801, -1, -1, -1}, {28802, -1, -1, -1}, {28803, -1, -1, -1}, {28804, -1, -1, -1}, {28806, -1, -1, -1}, {28807, -1, -1, -1}, {28808, -1, -1, -1}, {28811, -1, -1, -1}, {28812, -1, -1, -1}, {28813, -1, -1, -1}, {28815, -1, -1, -1}, {28816, -1, -1, -1}, {28817, -1, -1, -1}, {28819, -1, -1, -1}, {28823, -1, -1, -1}, {28824, -1, -1, -1}, {28826, -1, -1, -1}, {28827, -1, -1, -1}, {28830, -1, -1, -1}, {28831, -1, -1, -1}, {28832, -1, -1, -1}, {28833, -1, -1, -1}, {28834, -1, -1, -1}, {28835, -1, -1, -1}, {28836, -1, -1, -1}, {28837, -1, -1, -1}, {28838, -1, -1, -1}, {28839, -1, -1, -1}, {28840, -1, -1, -1}, {28841, -1, -1, -1}, {28842, -1, -1, -1}, {28848, -1, -1, -1}, {28850, -1, -1, -1}, {28852, -1, -1, -1}, {28853, -1, -1, -1}, {28854, -1, -1, -1}, {28858, -1, -1, -1}, {28862, -1, -1, -1}, {28863, -1, -1, -1}, {28868, -1, -1, -1}, {28869, -1, -1, -1}, {28870, -1, -1, -1}, {28871, -1, -1, -1}, {28873, -1, -1, -1}, {28875, -1, -1, -1}, {28876, -1, -1, -1}, {28877, -1, -1, -1}, {28878, -1, -1, -1}, {28880, -1, -1, -1}, {28881, -1, -1, -1}, {28882, -1, -1, -1}, {28883, -1, -1, -1}, {28884, -1, -1, -1}, {28885, -1, -1, -1}, {28886, -1, -1, -1}, {28887, -1, -1, -1}, {28890, -1, -1, -1}, {28892, -1, -1, -1}, {28893, -1, -1, -1}, {28894, -1, -1, -1}, {28896, -1, -1, -1}, {28897, -1, -1, -1}, {28898, -1, -1, -1}, {28899, -1, -1, -1}, {28901, -1, -1, -1}, {28906, -1, -1, -1}, {28910, -1, -1, -1}, {28912, -1, -1, -1}, {28913, -1, -1, -1}, {28914, -1, -1, -1}, {28915, -1, -1, -1}, {28917, -1, -1, -1}, {28918, -1, -1, -1}, {28920, -1, -1, -1}, {28922, -1, -1, -1}, {28923, -1, -1, -1}, {28924, -1, -1, -1}, {28926, -1, -1, -1}, {28927, -1, -1, -1}, {28928, -1, -1, -1}, {28929, -1, -1, -1}, {28930, -1, -1, -1}, {28931, -1, -1, -1}, {28932, -1, -1, -1}, {28933, -1, -1, -1}, {28934, -1, -1, -1}, {28935, -1, -1, -1}, {28936, -1, -1, -1}, {28939, -1, -1, -1}, {28940, -1, -1, -1}, {28941, -1, -1, -1}, {28942, -1, -1, -1}, {28943, -1, -1, -1}, {28945, -1, -1, -1}, {28946, -1, -1, -1}, {28948, -1, -1, -1}, {28951, -1, -1, -1}, {28955, -1, -1, -1}, {28956, -1, -1, -1}, {28957, -1, -1, -1}, {28958, -1, -1, -1}, {28959, -1, -1, -1}, {28960, -1, -1, -1}, {28962, -1, -1, -1}, {28963, -1, -1, -1}, {28964, -1, -1, -1}, {28965, -1, -1, -1}, {28967, -1, -1, -1}, {28968, -1, -1, -1}, {28969, -1, -1, -1}, {28970, -1, -1, -1}, {28971, -1, -1, -1}, {28972, -1, -1, -1}, {28973, -1, -1, -1}, {28974, -1, -1, -1}, {28978, -1, -1, -1}, {28979, -1, -1, -1}, {28980, -1, -1, -1}, {28981, -1, -1, -1}, {28983, -1, -1, -1}, {28984, -1, -1, -1}, {28985, -1, -1, -1}, {28986, -1, -1, -1}, {28987, -1, -1, -1}, {28988, -1, -1, -1}, {28989, -1, -1, -1}, {28990, -1, -1, -1}, {28991, -1, -1, -1}, {28992, -1, -1, -1}, {28993, -1, -1, -1}, {28994, -1, -1, -1}, {28995, -1, -1, -1}, {28996, -1, -1, -1}, {28998, -1, -1, -1}, {28999, -1, -1, -1}, {29000, -1, -1, -1}, {29003, -1, -1, -1}, {29005, -1, -1, -1}, {29007, -1, -1, -1}, {29008, -1, -1, -1}, {29009, -1, -1, -1}, {29011, -1, -1, -1}, {29012, -1, -1, -1}, {29013, -1, -1, -1}, {29014, -1, -1, -1}, {29015, -1, -1, -1}, {29016, -1, -1, -1}, {29017, -1, -1, -1}, {29018, -1, -1, -1}, {29019, -1, -1, -1}, {29021, -1, -1, -1}, {29023, -1, -1, -1}, {29024, -1, -1, -1}, {29025, -1, -1, -1}, {29027, -1, -1, -1}, {29029, -1, -1, -1}, {29034, -1, -1, -1}, {29035, -1, -1, -1}, {29037, -1, -1, -1}, {29039, -1, -1, -1}, {29040, -1, -1, -1}, {29041, -1, -1, -1}, {29044, -1, -1, -1}, {29045, -1, -1, -1}, {29046, -1, -1, -1}, {29047, -1, -1, -1}, {29049, -1, -1, -1}, {29051, -1, -1, -1}, {29052, -1, -1, -1}, {29054, -1, -1, -1}, {29055, -1, -1, -1}, {29056, -1, -1, -1}, {29057, -1, -1, -1}, {29058, -1, -1, -1}, {29059, -1, -1, -1}, {29061, -1, -1, -1}, {29062, -1, -1, -1}, {29063, -1, -1, -1}, {29064, -1, -1, -1}, {29065, -1, -1, -1}, {29067, -1, -1, -1}, {29068, -1, -1, -1}, {29069, -1, -1, -1}, {29070, -1, -1, -1}, {29072, -1, -1, -1}, {29073, -1, -1, -1}, {29075, -1, -1, -1}, {29077, -1, -1, -1}, {29078, -1, -1, -1}, {29082, -1, -1, -1}, {29083, -1, -1, -1}, {29084, -1, -1, -1}, {29085, -1, -1, -1}, {29086, -1, -1, -1}, {29089, -1, -1, -1}, {29090, -1, -1, -1}, {29091, -1, -1, -1}, {29092, -1, -1, -1}, {29093, -1, -1, -1}, {29094, -1, -1, -1}, {29095, -1, -1, -1}, {29097, -1, -1, -1}, {29098, -1, -1, -1}, {29099, -1, -1, -1}, {29101, -1, -1, -1}, {29102, -1, -1, -1}, {29103, -1, -1, -1}, {29104, -1, -1, -1}, {29106, -1, -1, -1}, {29108, -1, -1, -1}, {29110, -1, -1, -1}, {29111, -1, -1, -1}, {29112, -1, -1, -1}, {29114, -1, -1, -1}, {29115, -1, -1, -1}, {29116, -1, -1, -1}, {29117, -1, -1, -1}, {29119, -1, -1, -1}, {29120, -1, -1, -1}, {29122, -1, -1, -1}, {29124, -1, -1, -1}, {29125, -1, -1, -1}, {29126, -1, -1, -1}, {29127, -1, -1, -1}, {29129, -1, -1, -1}, {29130, -1, -1, -1}, {29131, -1, -1, -1}, {29132, -1, -1, -1}, {29133, -1, -1, -1}, {29135, -1, -1, -1}, {29136, -1, -1, -1}, {29137, -1, -1, -1}, {29139, -1, -1, -1}, {29142, -1, -1, -1}, {29143, -1, -1, -1}, {29144, -1, -1, -1}, {29146, -1, -1, -1}, {29147, -1, -1, -1}, {29149, -1, -1, -1}, {29150, -1, -1, -1}, {29153, -1, -1, -1}, {29154, -1, -1, -1}, {29155, -1, -1, -1}, {29156, -1, -1, -1}, {29160, -1, -1, -1}, {29161, -1, -1, -1}, {29162, -1, -1, -1}, {29163, -1, -1, -1}, {29164, -1, -1, -1}, {29167, -1, -1, -1} },
    {{29168, -1, -1, -1}, {29169, -1, -1, -1}, {29170, -1, -1, -1}, {29171, -1, -1, -1}, {29173, -1, -1, -1}, {29174, -1, -1, -1}, {29175, -1, -1, -1}, {29176, -1, -1, -1}, {29178, -1, -1, -1}, {29179, -1, -1, -1}, {29181, -1, -1, -1}, {29183, -1, -1, -1}, {29184, -1, -1, -1}, {29185, -1, -1, -1}, {29186, -1, -1, -1}, {29187, -1, -1, -1}, {29188, -1, -1, -1}, {29189, -1, -1, -1}, {29191, -1, -1, -1}, {29192, -1, -1, -1}, {29193, -1, -1, -1}, {29194, -1, -1, -1}, {29195, -1, -1, -1}, {29196, -1, -1, -1}, {29198, -1, -1, -1}, {29199, -1, -1, -1}, {29201, -1, -1, -1}, {29202, -1, -1, -1}, {29203, -1, -1, -1}, {29204, -1, -1, -1}, {29205, -1, -1, -1}, {29206, -1, -1, -1}, {29207, -1, -1, -1}, {29208, -1, -1, -1}, {29209, -1, -1, -1}, {29210, -1, -1, -1}, {29212, -1, -1, -1}, {29214, -1, -1, -1}, {29215, -1, -1, -1}, {29216, -1, -1, -1}, {29217, -1, -1, -1}, {29218, -1, -1, -1}, {29219, -1, -1, -1}, {29220, -1, -1, -1}, {29221, -1, -1, -1}, {29222, -1, -1, -1}, {29223, -1, -1, -1}, {29225, -1, -1, -1}, {29227, -1, -1, -1}, {29229, -1, -1, -1}, {29230, -1, -1, -1}, {29231, -1, -1, -1}, {29235, -1, -1, -1}, {29236, -1, -1, -1}, {29244, -1, -1, -1}, {29248, -1, -1, -1}, {29249, -1, -1, -1}, {29250, -1, -1, -1}, {29251, -1, -1, -1}, {29252, -1, -1, -1}, {29253, -1, -1, -1}, {29254, -1, -1, -1}, {29257, -1, -1, -1}, {29258, -1, -1, -1}, {29259, -1, -1, -1}, {29262, -1, -1, -1}, {29263, -1, -1, -1}, {29264, -1, -1, -1}, {29265, -1, -1, -1}, {29267, -1, -1, -1}, {29268, -1, -1, -1}, {29269, -1, -1, -1}, {29271, -1, -1, -1}, {29274, -1, -1, -1}, {29276, -1, -1, -1}, {29278, -1, -1, -1}, {29280, -1, -1, -1}, {29283, -1, -1, -1}, {29284, -1, -1, -1}, {29285, -1, -1, -1}, {29288, -1, -1, -1}, {29290, -1, -1, -1}, {29291, -1, -1, -1}, {29292, -1, -1, -1}, {29293, -1, -1, -1}, {29296, -1, -1, -1}, {29297, -1, -1, -1}, {29299, -1, -1, -1}, {29300, -1, -1, -1}, {29302, -1, -1, -1}, {29303, -1, -1, -1}, {29304, -1, -1, -1}, {29307, -1, -1, -1}, {29308, -1, -1, -1}, {29314, -1, -1, -1}, {29315, -1, -1, -1}, {29317, -1, -1, -1}, {29318, -1, -1, -1}, {29319, -1, -1, -1}, {29320, -1, -1, -1}, {29321, -1, -1, -1}, {29324, -1, -1, -1}, {29326, -1, -1, -1}, {29328, -1, -1, -1}, {29329, -1, -1, -1}, {29331, -1, -1, -1}, {29332, -1, -1, -1}, {29333, -1, -1, -1}, {29335, -1, -1, -1}, {29336, -1, -1, -1}, {29337, -1, -1, -1}, {29338, -1, -1, -1}, {29339, -1, -1, -1}, {29340, -1, -1, -1}, {29341, -1, -1, -1}, {29342, -1, -1, -1}, {29344, -1, -1, -1}, {29345, -1, -1, -1}, {29347, -1, -1, -1}, {29348, -1, -1, -1}, {29349, -1, -1, -1}, {29350, -1, -1, -1}, {29352, -1, -1, -1}, {29353, -1, -1, -1}, {29354, -1, -1, -1}, {29355, -1, -1, -1}, {29358, -1, -1, -1}, {29361, -1, -1, -1}, {29362, -1, -1, -1}, {29363, -1, -1, -1}, {29365, -1, -1, -1}, {29370, -1, -1, -1}, {29371, -1, -1, -1}, {29372, -1, -1, -1}, {29373, -1, -1, -1}, {29374, -1, -1, -1}, {29375, -1, -1, -1}, {29381, -1, -1, -1}, {29382, -1, -1, -1}, {29383, -1, -1, -1}, {29385, -1, -1, -1}, {29386, -1, -1, -1}, {29387, -1, -1, -1}, {29388, -1, -1, -1}, {29391, -1, -1, -1}, {29393, -1, -1, -1}, {29395, -1, -1, -1}, {29396, -1, -1, -1}, {29397, -1, -1, -1}, {29398, -1, -1, -1}, {29400, -1, -1, -1}, {29402, -1, -1, -1}, {29403, -1, -1, -1}, {29404, -1, -1, -1}, {29405, -1, -1, -1}, {29407, -1, -1, -1}, {29410, -1, -1, -1}, {29411, -1, -1, -1}, {29412, -1, -1, -1}, {29413, -1, -1, -1}, {29414, -1, -1, -1}, {29415, -1, -1, -1}, {29418, -1, -1, -1}, {29419, -1, -1, -1}, {29429, -1, -1, -1}, {29430, -1, -1, -1}, {29438, -1, -1, -1}, {29439, -1, -1, -1}, {29440, -1, -1, -1}, {29442, -1, -1, -1}, {29444, -1, -1, -1}, {29445, -1, -1, -1}, {29446, -1, -1, -1}, {29447, -1, -1, -1}, {29448, -1, -1, -1}, {29449, -1, -1, -1}, {29451, -1, -1, -1}, {29452, -1, -1, -1}, {29453, -1, -1, -1}, {29455, -1, -1, -1}, {29456, -1, -1, -1}, {29457, -1, -1, -1}, {29458, -1, -1, -1}, {29460, -1, -1, -1}, {29464, -1, -1, -1}, {29465, -1, -1, -1}, {29466, -1, -1, -1}, {29471, -1, -1, -1}, {29472, -1, -1, -1}, {29475, -1, -1, -1}, {29476, -1, -1, -1}, {29478, -1, -1, -1}, {29479, -1, -1, -1}, {29480, -1, -1, -1}, {29485, -1, -1, -1}, {29487, -1, -1, -1}, {29488, -1, -1, -1}, {29490, -1, -1, -1}, {29491, -1, -1, -1}, {29493, -1, -1, -1}, {29498, -1, -1, -1}, {29500, -1, -1, -1}, {29501, -1, -1, -1}, {29504, -1, -1, -1}, {29506, -1, -1, -1}, {29507, -1, -1, -1}, {29510, -1, -1, -1}, {29511, -1, -1, -1}, {29512, -1, -1, -1}, {29513, -1, -1, -1}, {29514, -1, -1, -1}, {29515, -1, -1, -1}, {29516, -1, -1, -1}, {29518, -1, -1, -1}, {29519, -1, -1, -1}, {29521, -1, -1, -1}, {29523, -1, -1, -1}, {29524, -1, -1, -1}, {29525, -1, -1, -1}, {29526, -1, -1, -1}, {29528, -1, -1, -1}, {29529, -1, -1, -1}, {29530, -1, -1, -1}, {29531, -1, -1, -1}, {29532, -1, -1, -1}, {29533, -1, -1, -1}, {29534, -1, -1, -1}, {29535, -1, -1, -1}, {29537, -1, -1, -1}, {29538, -1, -1, -1}, {29539, -1, -1, -1}, {29540, -1, -1, -1}, {29541, -1, -1, -1}, {29542, -1, -1, -1}, {29543, -1, -1, -1}, {29545, -1, -1, -1}, {29550, -1, -1, -1}, {29553, -1, -1, -1}, {29555, -1, -1, -1}, {29556, -1, -1, -1}, {29558, -1, -1, -1}, {29561, -1, -1, -1}, {29565, -1, -1, -1}, {29567, -1, -1, -1}, {29569, -1, -1, -1}, {29570, -1, -1, -1}, {29571, -1, -1, -1}, {29573, -1, -1, -1}, {29574, -1, -1, -1}, {29576, -1, -1, -1}, {29578, -1, -1, -1}, {29580, -1, -1, -1}, {29581, -1, -1, -1}, {29583, -1, -1, -1}, {29584, -1, -1, -1}, {29586, -1, -1, -1} },
    {{29587, -1, -1, -1}, {29588, -1, -1, -1}, {29589, -1, -1, -1}, {29591, -1, -1, -1}, {29592, -1, -1, -1}, {29593, -1, -1, -1}, {29594, -1, -1, -1}, {29596, -1, -1, -1}, {29597, -1, -1, -1}, {29598, -1, -1, -1}, {29600, -1, -1, -1}, {29601, -1, -1, -1}, {29603, -1, -1, -1}, {29604, -1, -1, -1}, {29605, -1, -1, -1}, {29606, -1, -1, -1}, {29607, -1, -1, -1}, {29608, -1, -1, -1}, {29610, -1, -1, -1}, {29612, -1, -1, -1}, {29613, -1, -1, -1}, {29617, -1, -1, -1}, {29620, -1, -1, -1}, {29621, -1, -1, -1}, {29622, -1, -1, -1}, {29624, -1, -1, -1}, {29625, -1, -1, -1}, {29628, -1, -1, -1}, {29629, -1, -1, -1}, {29630, -1, -1, -1}, {29631, -1, -1, -1}, {29633, -1, -1, -1}, {29635, -1, -1, -1}, {29636, -1, -1, -1}, {29637, -1, -1, -1}, {29638, -1, -1, -1}, {29639, -1, -1, -1}, {29643, -1, -1, -1}, {29644, -1, -1, -1}, {29646, -1, -1, -1}, {29650, -1, -1, -1}, {29651, -1, -1, -1}, {29652, -1, -1, -1}, {29653, -1, -1, -1}, {29654, -1, -1, -1}, {29655, -1, -1, -1}, {29656, -1, -1, -1}, {29658, -1, -1, -1}, {29659, -1, -1, -1}, {29660, -1, -1, -1}, {29661, -1, -1, -1}, {29663, -1, -1, -1}, {29665, -1, -1, -1}, {29666, -1, -1, -1}, {29667, -1, -1, -1}, {29668, -1, -1, -1}, {29670, -1, -1, -1}, {29672, -1, -1, -1}, {29674, -1, -1, -1}, {29675, -1, -1, -1}, {29676, -1, -1, -1}, {29678, -1, -1, -1}, {29679, -1, -1, -1}, {29680, -1, -1, -1}, {29681, -1, -1, -1}, {29683, -1, -1, -1}, {29684, -1, -1, -1}, {29685, -1, -1, -1}, {29686, -1, -1, -1}, {29687, -1, -1, -1}, {29688, -1, -1, -1}, {29689, -1, -1, -1}, {29690, -1, -1, -1}, {29691, -1, -1, -1}, {29692, -1, -1, -1}, {29693, -1, -1, -1}, {29695, -1, -1, -1}, {29696, -1, -1, -1}, {29697, -1, -1, -1}, {29698, -1, -1, -1}, {29700, -1, -1, -1}, {29703, -1, -1, -1}, {29704, -1, -1, -1}, {29707, -1, -1, -1}, {29708, -1, -1, -1}, {29709, -1, -1, -1}, {29710, -1, -1, -1}, {29713, -1, -1, -1}, {29714, -1, -1, -1}, {29715, -1, -1, -1}, {29716, -1, -1, -1}, {29717, -1, -1, -1}, {29718, -1, -1, -1}, {29719, -1, -1, -1}, {29720, -1, -1, -1}, {29721, -1, -1, -1}, {29724, -1, -1, -1}, {29725, -1, -1, -1}, {29726, -1, -1, -1}, {29727, -1, -1, -1}, {29728, -1, -1, -1}, {29729, -1, -1, -1}, {29731, -1, -1, -1}, {29732, -1, -1, -1}, {29735, -1, -1, -1}, {29737, -1, -1, -1}, {29739, -1, -1, -1}, {29741, -1, -1, -1}, {29743, -1, -1, -1}, {29745, -1, -1, -1}, {29746, -1, -1, -1}, {29751, -1, -1, -1}, {29752, -1, -1, -1}, {29753, -1, -1, -1}, {29754, -1, -1, -1}, {29755, -1, -1, -1}, {29757, -1, -1, -1}, {29758, -1, -1, -1}, {29760, -1, -1, -1}, {29762, -1, -1, -1}, {29763, -1, -1, -1}, {29764, -1, -1, -1}, {29765, -1, -1, -1}, {29766, -1, -1, -1}, {29767, -1, -1, -1}, {29768, -1, -1, -1}, {29769, -1, -1, -1}, {29770, -1, -1, -1}, {29772, -1, -1, -1}, {29773, -1, -1, -1}, {29774, -1, -1, -1}, {29775, -1, -1, -1}, {29776, -1, -1, -1}, {29777, -1, -1, -1}, {29778, -1, -1, -1}, {29779, -1, -1, -1}, {29780, -1, -1, -1}, {29782, -1, -1, -1}, {29784, -1, -1, -1}, {29789, -1, -1, -1}, {29792, -1, -1, -1}, {29793, -1, -1, -1}, {29794, -1, -1, -1}, {29796, -1, -1, -1}, {29797, -1, -1, -1}, {29798, -1, -1, -1}, {29799, -1, -1, -1}, {29800, -1, -1, -1}, {29803, -1, -1, -1}, {29804, -1, -1, -1}, {29806, -1, -1, -1}, {29807, -1, -1, -1}, {29809, -1, -1, -1}, {29810, -1, -1, -1}, {29811, -1, -1, -1}, {29812, -1, -1, -1}, {29813, -1, -1, -1}, {29816, -1, -1, -1}, {29817, -1, -1, -1}, {29818, -1, -1, -1}, {29819, -1, -1, -1}, {29820, -1, -1, -1}, {29821, -1, -1, -1}, {29823, -1, -1, -1}, {29826, -1, -1, -1}, {29828, -1, -1, -1}, {29829, -1, -1, -1}, {29830, -1, -1, -1}, {29832, -1, -1, -1}, {29834, -1, -1, -1}, {29836, -1, -1, -1}, {29837, -1, -1, -1}, {29839, -1, -1, -1}, {29841, -1, -1, -1}, {29842, -1, -1, -1}, {29843, -1, -1, -1}, {29844, -1, -1, -1}, {29845, -1, -1, -1}, {29846, -1, -1, -1}, {29847, -1, -1, -1}, {29848, -1, -1, -1}, {29849, -1, -1, -1}, {29850, -1, -1, -1}, {29851, -1, -1, -1}, {29853, -1, -1, -1}, {29855, -1, -1, -1}, {29856, -1, -1, -1}, {29857, -1, -1, -1}, {29858, -1, -1, -1}, {29860, -1, -1, -1}, {29861, -1, -1, -1}, {29866, -1, -1, -1}, {29867, -1, -1, -1}, {29868, -1, -1, -1}, {29869, -1, -1, -1}, {29870, -1, -1, -1}, {29871, -1, -1, -1}, {29873, -1, -1, -1}, {29874, -1, -1, -1}, {29875, -1, -1, -1}, {29876, -1, -1, -1}, {29877, -1, -1, -1}, {29878, -1, -1, -1}, {29879, -1, -1, -1}, {29880, -1, -1, -1}, {29881, -1, -1, -1}, {29883, -1, -1, -1}, {29884, -1, -1, -1}, {29886, -1, -1, -1}, {29887, -1, -1, -1}, {29888, -1, -1, -1}, {29889, -1, -1, -1}, {29890, -1, -1, -1}, {29891, -1, -1, -1}, {29892, -1, -1, -1}, {29893, -1, -1, -1}, {29894, -1, -1, -1}, {29895, -1, -1, -1}, {29896, -1, -1, -1}, {29897, -1, -1, -1}, {29899, -1, -1, -1}, {29900, -1, -1, -1}, {29901, -1, -1, -1}, {29902, -1, -1, -1}, {29904, -1, -1, -1}, {29905, -1, -1, -1}, {29907, -1, -1, -1}, {29909, -1, -1, -1}, {29910, -1, -1, -1}, {29911, -1, -1, -1}, {29912, -1, -1, -1}, {29913, -1, -1, -1}, {29915, -1, -1, -1}, {29917, -1, -1, -1}, {29919, -1, -1, -1}, {29921, -1, -1, -1}, {29925, -1, -1, -1}, {29927, -1, -1, -1}, {29928, -1, -1, -1}, {29929, -1, -1, -1}, {29930, -1, -1, -1}, {29931, -1, -1, -1}, {29932, -1, -1, -1}, {29933, -1, -1, -1}, {29936, -1, -1, -1}, {29937, -1, -1, -1}, {29938, -1, -1, -1}, {29939, -1, -1, -1}, {29941, -1, -1, -1}, {29944, -1, -1, -1}, {29945, -1, -1, -1}, {29946, -1, -1, -1}, {29947, -1, -1, -1}, {29948, -1, -1, -1}, {29949, -1, -1, -1}, {29950, -1, -1, -1} },
    {{29952, -1, -1, -1}, {29953, -1, -1, -1}, {29954, -1, -1, -1}, {29955, -1, -1, -1}, {29957, -1, -1, -1}, {29958, -1, -1, -1}, {29959, -1, -1, -1}, {29960, -1, -1, -1}, {29961, -1, -1, -1}, {29962, -1, -1, -1}, {29963, -1, -1, -1}, {29966, -1, -1, -1}, {29968, -1, -1, -1}, {29970, -1, -1, -1}, {29972, -1, -1, -1}, {29973, -1, -1, -1}, {29974, -1, -1, -1}, {29975, -1, -1, -1}, {29979, -1, -1, -1}, {29981, -1, -1, -1}, {29982, -1, -1, -1}, {29984, -1, -1, -1}, {29985, -1, -1, -1}, {29986, -1, -1, -1}, {29988, -1, -1, -1}, {29990, -1, -1, -1}, {29991, -1, -1, -1}, {29994, -1, -1, -1}, {29998, -1, -1, -1}, {30004, -1, -1, -1}, {30006, -1, -1, -1}, {30009, -1, -1, -1}, {30012, -1, -1, -1}, {30013, -1, -1, -1}, {30015, -1, -1, -1}, {30017, -1, -1, -1}, {30018, -1, -1, -1}, {30019, -1, -1, -1}, {30020, -1, -1, -1}, {30022, -1, -1, -1}, {30023, -1, -1, -1}, {30025, -1, -1, -1}, {30026, -1, -1, -1}, {30029, -1, -1, -1}, {30032, -1, -1, -1}, {30033, -1, -1, -1}, {30034, -1, -1, -1}, {30035, -1, -1, -1}, {30037, -1, -1, -1}, {30038, -1, -1, -1}, {30039, -1, -1, -1}, {30040, -1, -1, -1}, {30046, -1, -1, -1}, {30047, -1, -1, -1}, {30048, -1, -1, -1}, {30049, -1, -1, -1}, {30051, -1, -1, -1}, {30052, -1, -1, -1}, {30055, -1, -1, -1}, {30056, -1, -1, -1}, {30057, -1, -1, -1}, {30060, -1, -1, -1}, {30061, -1, -1, -1}, {30062, -1, -1, -1}, {30063, -1, -1, -1}, {30064, -1, -1, -1}, {30065, -1, -1, -1}, {30067, -1, -1, -1}, {30069, -1, -1, -1}, {30071, -1, -1, -1}, {30074, -1, -1, -1}, {30075, -1, -1, -1}, {30076, -1, -1, -1}, {30077, -1, -1, -1}, {30078, -1, -1, -1}, {30080, -1, -1, -1}, {30081, -1, -1, -1}, {30082, -1, -1, -1}, {30084, -1, -1, -1}, {30085, -1, -1, -1}, {30088, -1, -1, -1}, {30089, -1, -1, -1}, {30090, -1, -1, -1}, {30092, -1, -1, -1}, {30093, -1, -1, -1}, {30094, -1, -1, -1}, {30096, -1, -1, -1}, {30099, -1, -1, -1}, {30101, -1, -1, -1}, {30104, -1, -1, -1}, {30107, -1, -1, -1}, {30108, -1, -1, -1}, {30110, -1, -1, -1}, {30114, -1, -1, -1}, {30118, -1, -1, -1}, {30119, -1, -1, -1}, {30120, -1, -1, -1}, {30121, -1, -1, -1}, {30122, -1, -1, -1}, {30125, -1, -1, -1}, {30134, -1, -1, -1}, {30135, -1, -1, -1}, {30138, -1, -1, -1}, {30139, -1, -1, -1}, {30143, -1, -1, -1}, {30144, -1, -1, -1}, {30145, -1, -1, -1}, {30150, -1, -1, -1}, {30155, -1, -1, -1}, {30156, -1, -1, -1}, {30158, -1, -1, -1}, {30159, -1, -1, -1}, {30160, -1, -1, -1}, {30161, -1, -1, -1}, {30163, -1, -1, -1}, {30167, -1, -1, -1}, {30170, -1, -1, -1}, {30172, -1, -1, -1}, {30173, -1, -1, -1}, {30175, -1, -1, -1}, {30176, -1, -1, -1}, {30177, -1, -1, -1}, {30181, -1, -1, -1}, {30185, -1, -1, -1}, {30188, -1, -1, -1}, {30189, -1, -1, -1}, {30190, -1, -1, -1}, {30191, -1, -1, -1}, {30194, -1, -1, -1}, {30195, -1, -1, -1}, {30197, -1, -1, -1}, {30198, -1, -1, -1}, {30199, -1, -1, -1}, {30200, -1, -1, -1}, {30202, -1, -1, -1}, {30203, -1, -1, -1}, {30205, -1, -1, -1}, {30206, -1, -1, -1}, {30212, -1, -1, -1}, {30214, -1, -1, -1}, {30215, -1, -1, -1}, {30216, -1, -1, -1}, {30217, -1, -1, -1}, {30222, -1, -1, -1}, {30223, -1, -1, -1}, {30225, -1, -1, -1}, {30226, -1, -1, -1}, {30227, -1, -1, -1}, {30228, -1, -1, -1}, {30230, -1, -1, -1}, {30234, -1, -1, -1}, {30236, -1, -1, -1}, {30237, -1, -1, -1}, {30243, -1, -1, -1}, {30248, -1, -1, -1}, {30252, -1, -1, -1}, {30254, -1, -1, -1}, {30255, -1, -1, -1}, {30257, -1, -1, -1}, {30258, -1, -1, -1}, {30262, -1, -1, -1}, {30263, -1, -1, -1}, {30265, -1, -1, -1}, {30266, -1, -1, -1}, {30269, -1, -1, -1}, {30273, -1, -1, -1}, {30276, -1, -1, -1}, {30277, -1, -1, -1}, {30280, -1, -1, -1}, {30282, -1, -1, -1}, {30283, -1, -1, -1}, {30286, -1, -1, -1}, {30287, -1, -1, -1}, {30288, -1, -1, -1}, {30289, -1, -1, -1}, {30290, -1, -1, -1}, {30291, -1, -1, -1}, {30293, -1, -1, -1}, {30295, -1, -1, -1}, {30297, -1, -1, -1}, {30298, -1, -1, -1}, {30299, -1, -1, -1}, {30301, -1, -1, -1}, {30304, -1, -1, -1}, {30305, -1, -1, -1}, {30310, -1, -1, -1}, {30312, -1, -1, -1}, {30314, -1, -1, -1}, {30323, -1, -1, -1}, {30324, -1, -1, -1}, {30325, -1, -1, -1}, {12136, 30326, -1, -1}, {30327, -1, -1, -1}, {30329, -1, -1, -1}, {30330, -1, -1, -1}, {30335, -1, -1, -1}, {30336, -1, -1, -1}, {30337, -1, -1, -1}, {30339, -1, -1, -1}, {30341, -1, -1, -1}, {30345, -1, -1, -1}, {30346, -1, -1, -1}, {30348, -1, -1, -1}, {30349, -1, -1, -1}, {30351, -1, -1, -1}, {30352, -1, -1, -1}, {30354, -1, -1, -1}, {30356, -1, -1, -1}, {30357, -1, -1, -1}, {30359, -1, -1, -1}, {30360, -1, -1, -1}, {30363, -1, -1, -1}, {30364, -1, -1, -1}, {30365, -1, -1, -1}, {30366, -1, -1, -1}, {30367, -1, -1, -1}, {30368, -1, -1, -1}, {30369, -1, -1, -1}, {30370, -1, -1, -1}, {30371, -1, -1, -1}, {30373, -1, -1, -1}, {30374, -1, -1, -1}, {30375, -1, -1, -1}, {30376, -1, -1, -1}, {30377, -1, -1, -1}, {30378, -1, -1, -1}, {30379, -1, -1, -1}, {30380, -1, -1, -1}, {30381, -1, -1, -1}, {30383, -1, -1, -1}, {30384, -1, -1, -1}, {30387, -1, -1, -1}, {30389, -1, -1, -1}, {30390, -1, -1, -1}, {30391, -1, -1, -1}, {30393, -1, -1, -1}, {30395, -1, -1, -1}, {30396, -1, -1, -1}, {30397, -1, -1, -1}, {30398, -1, -1, -1}, {30400, -1, -1, -1}, {30401, -1, -1, -1}, {30403, -1, -1, -1}, {30404, -1, -1, -1}, {30407, -1, -1, -1}, {30409, -1, -1, -1}, {30411, -1, -1, -1}, {30412, -1, -1, -1}, {30419, -1, -1, -1}, {30421, -1, -1, -1}, {30425, -1, -1, -1}, {30426, -1, -1, -1}, {30428, -1, -1, -1}, {30429, -1, -1, -1}, {30432, -1, -1, -1}, {30434, -1, -1, -1} },
    {{30438, -1, -1, -1}, {30440, -1, -1, -1}, {30441, -1, -1, -1}, {30442, -1, -1, -1}, {30443, -1, -1, -1}, {30444, -1, -1, -1}, {30445, -1, -1, -1}, {30448, -1, -1, -1}, {30451, -1, -1, -1}, {30453, -1, -1, -1}, {30454, -1, -1, -1}, {30455, -1, -1, -1}, {30458, -1, -1, -1}, {30459, -1, -1, -1}, {30461, -1, -1, -1}, {30463, -1, -1, -1}, {30464, -1, -1, -1}, {30466, -1, -1, -1}, {30467, -1, -1, -1}, {30469, -1, -1, -1}, {30470, -1, -1, -1}, {30474, -1, -1, -1}, {30476, -1, -1, -1}, {30478, -1, -1, -1}, {30479, -1, -1, -1}, {30480, -1, -1, -1}, {30481, -1, -1, -1}, {30482, -1, -1, -1}, {30483, -1, -1, -1}, {30484, -1, -1, -1}, {30485, -1, -1, -1}, {30486, -1, -1, -1}, {30487, -1, -1, -1}, {30488, -1, -1, -1}, {30491, -1, -1, -1}, {30492, -1, -1, -1}, {30493, -1, -1, -1}, {30494, -1, -1, -1}, {30497, -1, -1, -1}, {30499, -1, -1, -1}, {30500, -1, -1, -1}, {30501, -1, -1, -1}, {30503, -1, -1, -1}, {30506, -1, -1, -1}, {30507, -1, -1, -1}, {30508, -1, -1, -1}, {30510, -1, -1, -1}, {30512, -1, -1, -1}, {30513, -1, -1, -1}, {30514, -1, -1, -1}, {30515, -1, -1, -1}, {30516, -1, -1, -1}, {30521, -1, -1, -1}, {30523, -1, -1, -1}, {30525, -1, -1, -1}, {30526, -1, -1, -1}, {30527, -1, -1, -1}, {30530, -1, -1, -1}, {30532, -1, -1, -1}, {30533, -1, -1, -1}, {30534, -1, -1, -1}, {30536, -1, -1, -1}, {30537, -1, -1, -1}, {30538, -1, -1, -1}, {30539, -1, -1, -1}, {30540, -1, -1, -1}, {30541, -1, -1, -1}, {30542, -1, -1, -1}, {30546, -1, -1, -1}, {30547, -1, -1, -1}, {30548, -1, -1, -1}, {30549, -1, -1, -1}, {30550, -1, -1, -1}, {30551, -1, -1, -1}, {30552, -1, -1, -1}, {30553, -1, -1, -1}, {30556, -1, -1, -1}, {30557, -1, -1, -1}, {30559, -1, -1, -1}, {30560, -1, -1, -1}, {30564, -1, -1, -1}, {30567, -1, -1, -1}, {30569, -1, -1, -1}, {30570, -1, -1, -1}, {30573, -1, -1, -1}, {30574, -1, -1, -1}, {30575, -1, -1, -1}, {30576, -1, -1, -1}, {30577, -1, -1, -1}, {30578, -1, -1, -1}, {30579, -1, -1, -1}, {30580, -1, -1, -1}, {30581, -1, -1, -1}, {30582, -1, -1, -1}, {30583, -1, -1, -1}, {30584, -1, -1, -1}, {30586, -1, -1, -1}, {30587, -1, -1, -1}, {30588, -1, -1, -1}, {30593, -1, -1, -1}, {30594, -1, -1, -1}, {30595, -1, -1, -1}, {30598, -1, -1, -1}, {30599, -1, -1, -1}, {30600, -1, -1, -1}, {30601, -1, -1, -1}, {30602, -1, -1, -1}, {30603, -1, -1, -1}, {30607, -1, -1, -1}, {30608, -1, -1, -1}, {30611, -1, -1, -1}, {30612, -1, -1, -1}, {30613, -1, -1, -1}, {30614, -1, -1, -1}, {30615, -1, -1, -1}, {30617, -1, -1, -1}, {30618, -1, -1, -1}, {30619, -1, -1, -1}, {30620, -1, -1, -1}, {30621, -1, -1, -1}, {30625, -1, -1, -1}, {30627, -1, -1, -1}, {30628, -1, -1, -1}, {30630, -1, -1, -1}, {30632, -1, -1, -1}, {30635, -1, -1, -1}, {30638, -1, -1, -1}, {30639, -1, -1, -1}, {30641, -1, -1, -1}, {30642, -1, -1, -1}, {30644, -1, -1, -1}, {30646, -1, -1, -1}, {30647, -1, -1, -1}, {30648, -1, -1, -1}, {30649, -1, -1, -1}, {30650, -1, -1, -1}, {30654, -1, -1, -1}, {30656, -1, -1, -1}, {30657, -1, -1, -1}, {30658, -1, -1, -1}, {30659, -1, -1, -1}, {30660, -1, -1, -1}, {30661, -1, -1, -1}, {30662, -1, -1, -1}, {30664, -1, -1, -1}, {30665, -1, -1, -1}, {30666, -1, -1, -1}, {30667, -1, -1, -1}, {30668, -1, -1, -1}, {30670, -1, -1, -1}, {30671, -1, -1, -1}, {30672, -1, -1, -1}, {30673, -1, -1, -1}, {30674, -1, -1, -1}, {30675, -1, -1, -1}, {30676, -1, -1, -1}, {30677, -1, -1, -1}, {30678, -1, -1, -1}, {30680, -1, -1, -1}, {30681, -1, -1, -1}, {30685, -1, -1, -1}, {30686, -1, -1, -1}, {30687, -1, -1, -1}, {30688, -1, -1, -1}, {30689, -1, -1, -1}, {30692, -1, -1, -1}, {30694, -1, -1, -1}, {30696, -1, -1, -1}, {30698, -1, -1, -1}, {30704, -1, -1, -1}, {30705, -1, -1, -1}, {30706, -1, -1, -1}, {30708, -1, -1, -1}, {30709, -1, -1, -1}, {30711, -1, -1, -1}, {30713, -1, -1, -1}, {30714, -1, -1, -1}, {30715, -1, -1, -1}, {30716, -1, -1, -1}, {30723, -1, -1, -1}, {30724, -1, -1, -1}, {30725, -1, -1, -1}, {30726, -1, -1, -1}, {30727, -1, -1, -1}, {30728, -1, -1, -1}, {30730, -1, -1, -1}, {30731, -1, -1, -1}, {30734, -1, -1, -1}, {30735, -1, -1, -1}, {30736, -1, -1, -1}, {30739, -1, -1, -1}, {30741, -1, -1, -1}, {30745, -1, -1, -1}, {30747, -1, -1, -1}, {30750, -1, -1, -1}, {30752, -1, -1, -1}, {30753, -1, -1, -1}, {30754, -1, -1, -1}, {30756, -1, -1, -1}, {30760, -1, -1, -1}, {30762, -1, -1, -1}, {30763, -1, -1, -1}, {30766, -1, -1, -1}, {30767, -1, -1, -1}, {30769, -1, -1, -1}, {30770, -1, -1, -1}, {30771, -1, -1, -1}, {30773, -1, -1, -1}, {30774, -1, -1, -1}, {30781, -1, -1, -1}, {30783, -1, -1, -1}, {30785, -1, -1, -1}, {30786, -1, -1, -1}, {30788, -1, -1, -1}, {30790, -1, -1, -1}, {30792, -1, -1, -1}, {30793, -1, -1, -1}, {30794, -1, -1, -1}, {30795, -1, -1, -1}, {30797, -1, -1, -1}, {30799, -1, -1, -1}, {30801, -1, -1, -1}, {30803, -1, -1, -1}, {30804, -1, -1, -1}, {30808, -1, -1, -1}, {30809, -1, -1, -1}, {30810, -1, -1, -1}, {30811, -1, -1, -1}, {30812, -1, -1, -1}, {30814, -1, -1, -1}, {30815, -1, -1, -1}, {30816, -1, -1, -1}, {30817, -1, -1, -1}, {30818, -1, -1, -1}, {30819, -1, -1, -1}, {30821, -1, -1, -1}, {30822, -1, -1, -1}, {30823, -1, -1, -1}, {30825, -1, -1, -1}, {30832, -1, -1, -1}, {30833, -1, -1, -1}, {30834, -1, -1, -1}, {30835, -1, -1, -1}, {30836, -1, -1, -1}, {30837, -1, -1, -1}, {30838, -1, -1, -1}, {30840, -1, -1, -1}, {30841, -1, -1, -1}, {30842, -1, -1, -1}, {30843, -1, -1, -1}, {30845, -1, -1, -1}, {30846, -1, -1, -1}, {30847, -1, -1, -1}, {30848, -1, -1, -1}, {30849, -1, -1, -1}, {30850, -1, -1, -1} },
    {{30851, -1, -1, -1}, {30852, -1, -1, -1}, {30853, -1, -1, -1}, {30854, -1, -1, -1}, {30856, -1, -1, -1}, {30858, -1, -1, -1}, {30859, -1, -1, -1}, {30863, -1, -1, -1}, {30864, -1, -1, -1}, {30866, -1, -1, -1}, {30868, -1, -1, -1}, {30869, -1, -1, -1}, {30870, -1, -1, -1}, {30873, -1, -1, -1}, {30877, -1, -1, -1}, {30878, -1, -1, -1}, {30880, -1, -1, -1}, {30882, -1, -1, -1}, {30884, -1, -1, -1}, {30886, -1, -1, -1}, {30888, -1, -1, -1}, {30890, -1, -1, -1}, {30891, -1, -1, -1}, {30892, -1, -1, -1}, {30894, -1, -1, -1}, {30895, -1, -1, -1}, {30901, -1, -1, -1}, {30902, -1, -1, -1}, {30903, -1, -1, -1}, {30907, -1, -1, -1}, {30909, -1, -1, -1}, {30911, -1, -1, -1}, {30912, -1, -1, -1}, {30914, -1, -1, -1}, {30915, -1, -1, -1}, {30916, -1, -1, -1}, {30918, -1, -1, -1}, {30919, -1, -1, -1}, {30920, -1, -1, -1}, {30924, -1, -1, -1}, {30925, -1, -1, -1}, {30926, -1, -1, -1}, {30927, -1, -1, -1}, {30929, -1, -1, -1}, {30930, -1, -1, -1}, {30931, -1, -1, -1}, {30934, -1, -1, -1}, {30935, -1, -1, -1}, {30936, -1, -1, -1}, {30939, -1, -1, -1}, {30940, -1, -1, -1}, {30941, -1, -1, -1}, {30942, -1, -1, -1}, {30943, -1, -1, -1}, {30944, -1, -1, -1}, {30945, -1, -1, -1}, {30946, -1, -1, -1}, {30948, -1, -1, -1}, {30949, -1, -1, -1}, {30950, -1, -1, -1}, {30953, -1, -1, -1}, {30954, -1, -1, -1}, {30955, -1, -1, -1}, {30957, -1, -1, -1}, {30958, -1, -1, -1}, {30960, -1, -1, -1}, {30961, -1, -1, -1}, {30963, -1, -1, -1}, {30965, -1, -1, -1}, {30966, -1, -1, -1}, {30968, -1, -1, -1}, {30969, -1, -1, -1}, {30971, -1, -1, -1}, {30972, -1, -1, -1}, {30974, -1, -1, -1}, {30975, -1, -1, -1}, {30976, -1, -1, -1}, {30978, -1, -1, -1}, {30979, -1, -1, -1}, {30980, -1, -1, -1}, {30982, -1, -1, -1}, {30983, -1, -1, -1}, {30984, -1, -1, -1}, {30985, -1, -1, -1}, {30986, -1, -1, -1}, {30987, -1, -1, -1}, {30988, -1, -1, -1}, {30989, -1, -1, -1}, {30991, -1, -1, -1}, {30992, -1, -1, -1}, {30993, -1, -1, -1}, {30994, -1, -1, -1}, {30996, -1, -1, -1}, {30997, -1, -1, -1}, {30998, -1, -1, -1}, {30999, -1, -1, -1}, {31000, -1, -1, -1}, {31002, -1, -1, -1}, {31003, -1, -1, -1}, {31004, -1, -1, -1}, {31005, -1, -1, -1}, {31007, -1, -1, -1}, {31008, -1, -1, -1}, {31009, -1, -1, -1}, {31010, -1, -1, -1}, {31011, -1, -1, -1}, {31013, -1, -1, -1}, {31015, -1, -1, -1}, {31016, -1, -1, -1}, {31017, -1, -1, -1}, {31021, -1, -1, -1}, {31022, -1, -1, -1}, {31023, -1, -1, -1}, {31024, -1, -1, -1}, {31026, -1, -1, -1}, {31027, -1, -1, -1}, {31029, -1, -1, -1}, {31030, -1, -1, -1}, {31031, -1, -1, -1}, {31032, -1, -1, -1}, {31033, -1, -1, -1}, {31037, -1, -1, -1}, {31039, -1, -1, -1}, {31042, -1, -1, -1}, {31043, -1, -1, -1}, {31044, -1, -1, -1}, {31045, -1, -1, -1}, {31047, -1, -1, -1}, {31050, -1, -1, -1}, {31051, -1, -1, -1}, {31052, -1, -1, -1}, {31053, -1, -1, -1}, {31054, -1, -1, -1}, {31055, -1, -1, -1}, {31056, -1, -1, -1}, {31057, -1, -1, -1}, {31058, -1, -1, -1}, {31060, -1, -1, -1}, {31061, -1, -1, -1}, {31064, -1, -1, -1}, {31065, -1, -1, -1}, {31073, -1, -1, -1}, {31075, -1, -1, -1}, {31076, -1, -1, -1}, {31078, -1, -1, -1}, {31081, -1, -1, -1}, {31082, -1, -1, -1}, {31083, -1, -1, -1}, {31084, -1, -1, -1}, {31086, -1, -1, -1}, {31088, -1, -1, -1}, {31089, -1, -1, -1}, {31090, -1, -1, -1}, {31091, -1, -1, -1}, {31092, -1, -1, -1}, {31093, -1, -1, -1}, {31094, -1, -1, -1}, {31097, -1, -1, -1}, {31099, -1, -1, -1}, {31100, -1, -1, -1}, {31101, -1, -1, -1}, {31102, -1, -1, -1}, {31103, -1, -1, -1}, {31106, -1, -1, -1}, {31107, -1, -1, -1}, {31110, -1, -1, -1}, {31111, -1, -1, -1}, {31112, -1, -1, -1}, {31113, -1, -1, -1}, {31115, -1, -1, -1}, {31116, -1, -1, -1}, {31120, -1, -1, -1}, {31121, -1, -1, -1}, {31122, -1, -1, -1}, {31123, -1, -1, -1}, {31124, -1, -1, -1}, {31125, -1, -1, -1}, {31126, -1, -1, -1}, {31127, -1, -1, -1}, {31128, -1, -1, -1}, {31129, -1, -1, -1}, {31131, -1, -1, -1}, {31132, -1, -1, -1}, {31133, -1, -1, -1}, {31134, -1, -1, -1}, {31135, -1, -1, -1}, {31136, -1, -1, -1}, {31137, -1, -1, -1}, {31138, -1, -1, -1}, {31139, -1, -1, -1}, {31140, -1, -1, -1}, {31141, -1, -1, -1}, {31144, -1, -1, -1}, {31145, -1, -1, -1}, {31147, -1, -1, -1}, {31148, -1, -1, -1}, {31149, -1, -1, -1}, {31151, -1, -1, -1}, {31154, -1, -1, -1}, {31156, -1, -1, -1}, {31157, -1, -1, -1}, {31158, -1, -1, -1}, {31159, -1, -1, -1}, {12145, 31160, -1, -1}, {31164, -1, -1, -1}, {31167, -1, -1, -1}, {31170, -1, -1, -1}, {31172, -1, -1, -1}, {31173, -1, -1, -1}, {31175, -1, -1, -1}, {31176, -1, -1, -1}, {31178, -1, -1, -1}, {31180, -1, -1, -1}, {31182, -1, -1, -1}, {31183, -1, -1, -1}, {31184, -1, -1, -1}, {31187, -1, -1, -1}, {31188, -1, -1, -1}, {31190, -1, -1, -1}, {31191, -1, -1, -1}, {31193, -1, -1, -1}, {31194, -1, -1, -1}, {31195, -1, -1, -1}, {31196, -1, -1, -1}, {31197, -1, -1, -1}, {31198, -1, -1, -1}, {31200, -1, -1, -1}, {31201, -1, -1, -1}, {31202, -1, -1, -1}, {31205, -1, -1, -1}, {31208, -1, -1, -1}, {31210, -1, -1, -1}, {31212, -1, -1, -1}, {31214, -1, -1, -1}, {31217, -1, -1, -1}, {31218, -1, -1, -1}, {31219, -1, -1, -1}, {31220, -1, -1, -1}, {31221, -1, -1, -1}, {31222, -1, -1, -1}, {31223, -1, -1, -1}, {31225, -1, -1, -1}, {31226, -1, -1, -1}, {31228, -1, -1, -1}, {31230, -1, -1, -1}, {31231, -1, -1, -1}, {31233, -1, -1, -1}, {31236, -1, -1, -1}, {31237, -1, -1, -1}, {31239, -1, -1, -1}, {31240, -1, -1, -1}, {31241, -1, -1, -1}, {31242, -1, -1, -1}, {31244, -1, -1, -1}, {31247, -1, -1, -1}, {31248, -1, -1, -1} },
    {{31249, -1, -1, -1}, {31250, -1, -1, -1}, {31251, -1, -1, -1}, {31253, -1, -1, -1}, {31254, -1, -1, -1}, {31256, -1, -1, -1}, {31257, -1, -1, -1}, {31259, -1, -1, -1}, {31260, -1, -1, -1}, {31261, -1, -1, -1}, {31263, -1, -1, -1}, {31265, -1, -1, -1}, {31266, -1, -1, -1}, {31268, -1, -1, -1}, {31269, -1, -1, -1}, {31270, -1, -1, -1}, {31271, -1, -1, -1}, {31272, -1, -1, -1}, {31273, -1, -1, -1}, {31274, -1, -1, -1}, {31275, -1, -1, -1}, {31276, -1, -1, -1}, {31277, -1, -1, -1}, {31279, -1, -1, -1}, {31280, -1, -1, -1}, {31282, -1, -1, -1}, {31284, -1, -1, -1}, {31285, -1, -1, -1}, {31286, -1, -1, -1}, {31288, -1, -1, -1}, {31290, -1, -1, -1}, {31294, -1, -1, -1}, {31297, -1, -1, -1}, {31298, -1, -1, -1}, {31299, -1, -1, -1}, {31300, -1, -1, -1}, {31301, -1, -1, -1}, {31303, -1, -1, -1}, {31304, -1, -1, -1}, {31305, -1, -1, -1}, {31306, -1, -1, -1}, {31307, -1, -1, -1}, {31311, -1, -1, -1}, {31312, -1, -1, -1}, {31314, -1, -1, -1}, {31315, -1, -1, -1}, {31316, -1, -1, -1}, {31317, -1, -1, -1}, {31318, -1, -1, -1}, {31320, -1, -1, -1}, {31321, -1, -1, -1}, {31322, -1, -1, -1}, {31323, -1, -1, -1}, {31324, -1, -1, -1}, {31325, -1, -1, -1}, {31326, -1, -1, -1}, {31327, -1, -1, -1}, {31328, -1, -1, -1}, {31331, -1, -1, -1}, {31332, -1, -1, -1}, {31333, -1, -1, -1}, {31334, -1, -1, -1}, {31335, -1, -1, -1}, {31336, -1, -1, -1}, {31338, -1, -1, -1}, {31340, -1, -1, -1}, {31341, -1, -1, -1}, {31342, -1, -1, -1}, {31343, -1, -1, -1}, {31345, -1, -1, -1}, {31346, -1, -1, -1}, {31347, -1, -1, -1}, {31349, -1, -1, -1}, {31355, -1, -1, -1}, {31356, -1, -1, -1}, {31357, -1, -1, -1}, {31358, -1, -1, -1}, {31362, -1, -1, -1}, {31365, -1, -1, -1}, {31367, -1, -1, -1}, {31369, -1, -1, -1}, {31370, -1, -1, -1}, {31371, -1, -1, -1}, {31372, -1, -1, -1}, {31374, -1, -1, -1}, {31375, -1, -1, -1}, {31376, -1, -1, -1}, {31379, -1, -1, -1}, {31380, -1, -1, -1}, {31385, -1, -1, -1}, {31386, -1, -1, -1}, {31387, -1, -1, -1}, {31390, -1, -1, -1}, {31393, -1, -1, -1}, {31394, -1, -1, -1}, {31395, -1, -1, -1}, {31396, -1, -1, -1}, {31399, -1, -1, -1}, {31403, -1, -1, -1}, {31407, -1, -1, -1}, {31408, -1, -1, -1}, {31409, -1, -1, -1}, {31410, -1, -1, -1}, {31412, -1, -1, -1}, {31413, -1, -1, -1}, {31415, -1, -1, -1}, {31416, -1, -1, -1}, {31417, -1, -1, -1}, {31419, -1, -1, -1}, {31420, -1, -1, -1}, {31421, -1, -1, -1}, {31422, -1, -1, -1}, {31424, -1, -1, -1}, {31425, -1, -1, -1}, {31426, -1, -1, -1}, {31427, -1, -1, -1}, {31430, -1, -1, -1}, {31433, -1, -1, -1}, {31436, -1, -1, -1}, {31437, -1, -1, -1}, {31438, -1, -1, -1}, {31439, -1, -1, -1}, {31440, -1, -1, -1}, {31441, -1, -1, -1}, {31442, -1, -1, -1}, {31443, -1, -1, -1}, {31444, -1, -1, -1}, {31445, -1, -1, -1}, {31447, -1, -1, -1}, {31448, -1, -1, -1}, {31450, -1, -1, -1}, {31451, -1, -1, -1}, {31452, -1, -1, -1}, {31453, -1, -1, -1}, {31457, -1, -1, -1}, {31458, -1, -1, -1}, {31460, -1, -1, -1}, {31463, -1, -1, -1}, {31464, -1, -1, -1}, {31465, -1, -1, -1}, {31467, -1, -1, -1}, {31468, -1, -1, -1}, {31470, -1, -1, -1}, {31472, -1, -1, -1}, {31473, -1, -1, -1}, {31474, -1, -1, -1}, {31475, -1, -1, -1}, {31476, -1, -1, -1}, {31477, -1, -1, -1}, {31479, -1, -1, -1}, {31480, -1, -1, -1}, {31483, -1, -1, -1}, {31484, -1, -1, -1}, {31486, -1, -1, -1}, {31488, -1, -1, -1}, {31489, -1, -1, -1}, {31490, -1, -1, -1}, {31493, -1, -1, -1}, {31495, -1, -1, -1}, {31497, -1, -1, -1}, {31500, -1, -1, -1}, {31501, -1, -1, -1}, {31502, -1, -1, -1}, {31504, -1, -1, -1}, {31506, -1, -1, -1}, {31507, -1, -1, -1}, {31510, -1, -1, -1}, {31511, -1, -1, -1}, {31512, -1, -1, -1}, {31514, -1, -1, -1}, {31516, -1, -1, -1}, {31517, -1, -1, -1}, {31519, -1, -1, -1}, {31521, -1, -1, -1}, {31522, -1, -1, -1}, {31523, -1, -1, -1}, {31527, -1, -1, -1}, {31529, -1, -1, -1}, {31533, -1, -1, -1}, {31535, -1, -1, -1}, {31536, -1, -1, -1}, {31538, -1, -1, -1}, {31540, -1, -1, -1}, {31541, -1, -1, -1}, {31542, -1, -1, -1}, {31543, -1, -1, -1}, {31545, -1, -1, -1}, {31547, -1, -1, -1}, {31549, -1, -1, -1}, {31551, -1, -1, -1}, {31552, -1, -1, -1}, {31553, -1, -1, -1}, {31554, -1, -1, -1}, {31555, -1, -1, -1}, {31556, -1, -1, -1}, {31560, -1, -1, -1}, {31562, -1, -1, -1}, {31565, -1, -1, -1}, {31566, -1, -1, -1}, {31571, -1, -1, -1}, {31573, -1, -1, -1}, {31575, -1, -1, -1}, {31577, -1, -1, -1}, {31580, -1, -1, -1}, {31582, -1, -1, -1}, {31583, -1, -1, -1}, {31585, -1, -1, -1}, {31587, -1, -1, -1}, {31588, -1, -1, -1}, {31589, -1, -1, -1}, {31590, -1, -1, -1}, {31592, -1, -1, -1}, {31593, -1, -1, -1}, {31594, -1, -1, -1}, {31595, -1, -1, -1}, {31596, -1, -1, -1}, {31597, -1, -1, -1}, {31599, -1, -1, -1}, {31600, -1, -1, -1}, {31603, -1, -1, -1}, {31604, -1, -1, -1}, {31606, -1, -1, -1}, {31608, -1, -1, -1}, {31610, -1, -1, -1}, {31612, -1, -1, -1}, {31613, -1, -1, -1}, {31615, -1, -1, -1}, {31617, -1, -1, -1}, {31618, -1, -1, -1}, {31619, -1, -1, -1}, {31620, -1, -1, -1}, {31622, -1, -1, -1}, {31623, -1, -1, -1}, {31624, -1, -1, -1}, {31625, -1, -1, -1}, {31626, -1, -1, -1}, {31628, -1, -1, -1}, {31630, -1, -1, -1}, {31631, -1, -1, -1}, {31633, -1, -1, -1}, {31634, -1, -1, -1}, {31635, -1, -1, -1}, {31638, -1, -1, -1}, {31640, -1, -1, -1}, {31641, -1, -1, -1}, {31642, -1, -1, -1}, {31643, -1, -1, -1}, {31646, -1, -1, -1}, {31647, -1, -1, -1}, {31648, -1, -1, -1}, {31651, -1, -1, -1}, {31652, -1, -1, -1}, {31653, -1, -1, -1}, {31662, -1, -1, -1}, {31663, -1, -1, -1}, {31664, -1, -1, -1} },
    {{31666, -1, -1, -1}, {31667, -1, -1, -1}, {31669, -1, -1, -1}, {31670, -1, -1, -1}, {31671, -1, -1, -1}, {31673, -1, -1, -1}, {31674, -1, -1, -1}, {31675, -1, -1, -1}, {31676, -1, -1, -1}, {31677, -1, -1, -1}, {31678, -1, -1, -1}, {31679, -1, -1, -1}, {31682, -1, -1, -1}, {31683, -1, -1, -1}, {31685, -1, -1, -1}, {31688, -1, -1, -1}, {31690, -1, -1, -1}, {31693, -1, -1, -1}, {31694, -1, -1, -1}, {31695, -1, -1, -1}, {31696, -1, -1, -1}, {31698, -1, -1, -1}, {31700, -1, -1, -1}, {31701, -1, -1, -1}, {31702, -1, -1, -1}, {31703, -1, -1, -1}, {31704, -1, -1, -1}, {31707, -1, -1, -1}, {31708, -1, -1, -1}, {31710, -1, -1, -1}, {31711, -1, -1, -1}, {31712, -1, -1, -1}, {31714, -1, -1, -1}, {31715, -1, -1, -1}, {31719, -1, -1, -1}, {31720, -1, -1, -1}, {31723, -1, -1, -1}, {31724, -1, -1, -1}, {31725, -1, -1, -1}, {31727, -1, -1, -1}, {31728, -1, -1, -1}, {31730, -1, -1, -1}, {31732, -1, -1, -1}, {31733, -1, -1, -1}, {31734, -1, -1, -1}, {31736, -1, -1, -1}, {31737, -1, -1, -1}, {31738, -1, -1, -1}, {31739, -1, -1, -1}, {31741, -1, -1, -1}, {31743, -1, -1, -1}, {31745, -1, -1, -1}, {31746, -1, -1, -1}, {31747, -1, -1, -1}, {31748, -1, -1, -1}, {31749, -1, -1, -1}, {31750, -1, -1, -1}, {31752, -1, -1, -1}, {31753, -1, -1, -1}, {31754, -1, -1, -1}, {31758, -1, -1, -1}, {31760, -1, -1, -1}, {31761, -1, -1, -1}, {31762, -1, -1, -1}, {31763, -1, -1, -1}, {31764, -1, -1, -1}, {31765, -1, -1, -1}, {31767, -1, -1, -1}, {31768, -1, -1, -1}, {31769, -1, -1, -1}, {31770, -1, -1, -1}, {31771, -1, -1, -1}, {31772, -1, -1, -1}, {31773, -1, -1, -1}, {31776, -1, -1, -1}, {31778, -1, -1, -1}, {31780, -1, -1, -1}, {31781, -1, -1, -1}, {31784, -1, -1, -1}, {31785, -1, -1, -1}, {31788, -1, -1, -1}, {31789, -1, -1, -1}, {31790, -1, -1, -1}, {31791, -1, -1, -1}, {31792, -1, -1, -1}, {31793, -1, -1, -1}, {31794, -1, -1, -1}, {31795, -1, -1, -1}, {31796, -1, -1, -1}, {31797, -1, -1, -1}, {31798, -1, -1, -1}, {31799, -1, -1, -1}, {31801, -1, -1, -1}, {31802, -1, -1, -1}, {31803, -1, -1, -1}, {31804, -1, -1, -1}, {31810, -1, -1, -1}, {31812, -1, -1, -1}, {31813, -1, -1, -1}, {31814, -1, -1, -1}, {31815, -1, -1, -1}, {31816, -1, -1, -1}, {31817, -1, -1, -1}, {31818, -1, -1, -1}, {31819, -1, -1, -1}, {31822, -1, -1, -1}, {31823, -1, -1, -1}, {31824, -1, -1, -1}, {31825, -1, -1, -1}, {31826, -1, -1, -1}, {31827, -1, -1, -1}, {31828, -1, -1, -1}, {31829, -1, -1, -1}, {31830, -1, -1, -1}, {31831, -1, -1, -1}, {31832, -1, -1, -1}, {31833, -1, -1, -1}, {31834, -1, -1, -1}, {31835, -1, -1, -1}, {31837, -1, -1, -1}, {31838, -1, -1, -1}, {31841, -1, -1, -1}, {31842, -1, -1, -1}, {31843, -1, -1, -1}, {31845, -1, -1, -1}, {31846, -1, -1, -1}, {31847, -1, -1, -1}, {31848, -1, -1, -1}, {31851, -1, -1, -1}, {31853, -1, -1, -1}, {31855, -1, -1, -1}, {31856, -1, -1, -1}, {31857, -1, -1, -1}, {31861, -1, -1, -1}, {31862, -1, -1, -1}, {31863, -1, -1, -1}, {31864, -1, -1, -1}, {31865, -1, -1, -1}, {31866, -1, -1, -1}, {31870, -1, -1, -1}, {31871, -1, -1, -1}, {31872, -1, -1, -1}, {31873, -1, -1, -1}, {31874, -1, -1, -1}, {31875, -1, -1, -1}, {31876, -1, -1, -1}, {31877, -1, -1, -1}, {31878, -1, -1, -1}, {31879, -1, -1, -1}, {31880, -1, -1, -1}, {31882, -1, -1, -1}, {31883, -1, -1, -1}, {31884, -1, -1, -1}, {31885, -1, -1, -1}, {31886, -1, -1, -1}, {31887, -1, -1, -1}, {31888, -1, -1, -1}, {31891, -1, -1, -1}, {31892, -1, -1, -1}, {31894, -1, -1, -1}, {31897, -1, -1, -1}, {31898, -1, -1, -1}, {31899, -1, -1, -1}, {31904, -1, -1, -1}, {31905, -1, -1, -1}, {31907, -1, -1, -1}, {31910, -1, -1, -1}, {31911, -1, -1, -1}, {31912, -1, -1, -1}, {31913, -1, -1, -1}, {31915, -1, -1, -1}, {31916, -1, -1, -1}, {31917, -1, -1, -1}, {31919, -1, -1, -1}, {31920, -1, -1, -1}, {31924, -1, -1, -1}, {31925, -1, -1, -1}, {31926, -1, -1, -1}, {31927, -1, -1, -1}, {31928, -1, -1, -1}, {31930, -1, -1, -1}, {31931, -1, -1, -1}, {31935, -1, -1, -1}, {31936, -1, -1, -1}, {31938, -1, -1, -1}, {31939, -1, -1, -1}, {31940, -1, -1, -1}, {31942, -1, -1, -1}, {31945, -1, -1, -1}, {31947, -1, -1, -1}, {31950, -1, -1, -1}, {31951, -1, -1, -1}, {31952, -1, -1, -1}, {31953, -1, -1, -1}, {31954, -1, -1, -1}, {31955, -1, -1, -1}, {31956, -1, -1, -1}, {31960, -1, -1, -1}, {31962, -1, -1, -1}, {31963, -1, -1, -1}, {31969, -1, -1, -1}, {31970, -1, -1, -1}, {31971, -1, -1, -1}, {31972, -1, -1, -1}, {31973, -1, -1, -1}, {31974, -1, -1, -1}, {31977, -1, -1, -1}, {31978, -1, -1, -1}, {31979, -1, -1, -1}, {31980, -1, -1, -1}, {31981, -1, -1, -1}, {31982, -1, -1, -1}, {31985, -1, -1, -1}, {31987, -1, -1, -1}, {31989, -1, -1, -1}, {31991, -1, -1, -1}, {31994, -1, -1, -1}, {31996, -1, -1, -1}, {31997, -1, -1, -1}, {31999, -1, -1, -1}, {32001, -1, -1, -1}, {32003, -1, -1, -1}, {32012, -1, -1, -1}, {32014, -1, -1, -1}, {32015, -1, -1, -1}, {32017, -1, -1, -1}, {32018, -1, -1, -1}, {32022, -1, -1, -1}, {32024, -1, -1, -1}, {32029, -1, -1, -1}, {32030, -1, -1, -1}, {32031, -1, -1, -1}, {32035, -1, -1, -1}, {32036, -1, -1, -1}, {32037, -1, -1, -1}, {32038, -1, -1, -1}, {32040, -1, -1, -1}, {32041, -1, -1, -1}, {32042, -1, -1, -1}, {32044, -1, -1, -1}, {32045, -1, -1, -1}, {32046, -1, -1, -1}, {32052, -1, -1, -1}, {32053, -1, -1, -1}, {32054, -1, -1, -1}, {32055, -1, -1, -1}, {32056, -1, -1, -1}, {32059, -1, -1, -1}, {32061, -1, -1, -1}, {32062, -1, -1, -1}, {32065, -1, -1, -1}, {32067, -1, -1, -1}, {32069, -1, -1, -1}, {32071, -1, -1, -1}, {32072, -1, -1, -1}, {32073, -1, -1, -1} },
    {{32074, -1, -1, -1}, {32075, -1, -1, -1}, {32076, -1, -1, -1}, {32077, -1, -1, -1}, {32079, -1, -1, -1}, {32081, -1, -1, -1}, {32082, -1, -1, -1}, {32083, -1, -1, -1}, {32084, -1, -1, -1}, {32085, -1, -1, -1}, {32086, -1, -1, -1}, {32087, -1, -1, -1}, {32088, -1, -1, -1}, {32089, -1, -1, -1}, {32090, -1, -1, -1}, {32091, -1, -1, -1}, {32092, -1, -1, -1}, {32095, -1, -1, -1}, {32096, -1, -1, -1}, {32099, -1, -1, -1}, {32100, -1, -1, -1}, {32101, -1, -1, -1}, {32103, -1, -1, -1}, {32105, -1, -1, -1}, {32106, -1, -1, -1}, {32107, -1, -1, -1}, {32108, -1, -1, -1}, {32109, -1, -1, -1}, {32111, -1, -1, -1}, {32112, -1, -1, -1}, {32116, -1, -1, -1}, {32117, -1, -1, -1}, {32120, -1, -1, -1}, {32122, -1, -1, -1}, {32123, -1, -1, -1}, {32124, -1, -1, -1}, {32125, -1, -1, -1}, {32126, -1, -1, -1}, {32127, -1, -1, -1}, {32128, -1, -1, -1}, {32130, -1, -1, -1}, {32132, -1, -1, -1}, {32133, -1, -1, -1}, {32135, -1, -1, -1}, {32138, -1, -1, -1}, {32139, -1, -1, -1}, {32140, -1, -1, -1}, {32141, -1, -1, -1}, {32142, -1, -1, -1}, {32144, -1, -1, -1}, {32145, -1, -1, -1}, {32146, -1, -1, -1}, {32148, -1, -1, -1}, {32149, -1, -1, -1}, {32150, -1, -1, -1}, {32151, -1, -1, -1}, {32152, -1, -1, -1}, {32153, -1, -1, -1}, {32154, -1, -1, -1}, {32155, -1, -1, -1}, {32157, -1, -1, -1}, {32159, -1, -1, -1}, {32160, -1, -1, -1}, {32161, -1, -1, -1}, {32164, -1, -1, -1}, {32165, -1, -1, -1}, {32167, -1, -1, -1}, {32168, -1, -1, -1}, {32169, -1, -1, -1}, {32170, -1, -1, -1}, {32175, -1, -1, -1}, {32181, -1, -1, -1}, {32182, -1, -1, -1}, {32183, -1, -1, -1}, {32188, -1, -1, -1}, {32192, -1, -1, -1}, {32193, -1, -1, -1}, {32194, -1, -1, -1}, {32195, -1, -1, -1}, {32197, -1, -1, -1}, {32198, -1, -1, -1}, {32200, -1, -1, -1}, {32201, -1, -1, -1}, {32204, -1, -1, -1}, {32205, -1, -1, -1}, {32206, -1, -1, -1}, {32207, -1, -1, -1}, {32208, -1, -1, -1}, {32211, -1, -1, -1}, {32213, -1, -1, -1}, {32214, -1, -1, -1}, {32218, -1, -1, -1}, {32219, -1, -1, -1}, {32220, -1, -1, -1}, {32223, -1, -1, -1}, {32226, -1, -1, -1}, {32228, -1, -1, -1}, {32229, -1, -1, -1}, {32231, -1, -1, -1}, {32234, -1, -1, -1}, {32235, -1, -1, -1}, {32237, -1, -1, -1}, {32238, -1, -1, -1}, {32240, -1, -1, -1}, {32243, -1, -1, -1}, {32245, -1, -1, -1}, {32247, -1, -1, -1}, {32248, -1, -1, -1}, {32250, -1, -1, -1}, {32252, -1, -1, -1}, {32253, -1, -1, -1}, {32254, -1, -1, -1}, {32255, -1, -1, -1}, {32256, -1, -1, -1}, {32257, -1, -1, -1}, {32258, -1, -1, -1}, {32259, -1, -1, -1}, {32260, -1, -1, -1}, {32261, -1, -1, -1}, {32262, -1, -1, -1}, {32263, -1, -1, -1}, {32268, -1, -1, -1}, {32269, -1, -1, -1}, {32270, -1, -1, -1}, {32271, -1, -1, -1}, {32274, -1, -1, -1}, {32275, -1, -1, -1}, {32276, -1, -1, -1}, {32277, -1, -1, -1}, {32278, -1, -1, -1}, {32279, -1, -1, -1}, {32280, -1, -1, -1}, {32281, -1, -1, -1}, {32282, -1, -1, -1}, {32284, -1, -1, -1}, {32288, -1, -1, -1}, {32289, -1, -1, -1}, {32290, -1, -1, -1}, {32292, -1, -1, -1}, {32293, -1, -1, -1}, {32294, -1, -1, -1}, {32296, -1, -1, -1}, {32297, -1, -1, -1}, {32298, -1, -1, -1}, {32300, -1, -1, -1}, {32303, -1, -1, -1}, {32304, -1, -1, -1}, {32307, -1, -1, -1}, {32312, -1, -1, -1}, {32314, -1, -1, -1}, {32316, -1, -1, -1}, {32319, -1, -1, -1}, {32320, -1, -1, -1}, {32322, -1, -1, -1}, {32323, -1, -1, -1}, {32324, -1, -1, -1}, {32328, -1, -1, -1}, {32329, -1, -1, -1}, {32330, -1, -1, -1}, {32331, -1, -1, -1}, {32332, -1, -1, -1}, {32333, -1, -1, -1}, {32334, -1, -1, -1}, {32335, -1, -1, -1}, {32336, -1, -1, -1}, {32337, -1, -1, -1}, {32339, -1, -1, -1}, {32342, -1, -1, -1}, {32343, -1, -1, -1}, {32344, -1, -1, -1}, {32345, -1, -1, -1}, {32347, -1, -1, -1}, {32348, -1, -1, -1}, {32349, -1, -1, -1}, {32351, -1, -1, -1}, {32352, -1, -1, -1}, {32353, -1, -1, -1}, {32355, -1, -1, -1}, {32356, -1, -1, -1}, {32357, -1, -1, -1}, {32358, -1, -1, -1}, {32359, -1, -1, -1}, {32360, -1, -1, -1}, {32364, -1, -1, -1}, {32369, -1, -1, -1}, {32370, -1, -1, -1}, {32372, -1, -1, -1}, {32373, -1, -1, -1}, {32374, -1, -1, -1}, {32375, -1, -1, -1}, {32376, -1, -1, -1}, {32378, -1, -1, -1}, {32379, -1, -1, -1}, {32383, -1, -1, -1}, {32384, -1, -1, -1}, {32385, -1, -1, -1}, {32387, -1, -1, -1}, {32388, -1, -1, -1}, {32389, -1, -1, -1}, {32390, -1, -1, -1}, {32391, -1, -1, -1}, {32393, -1, -1, -1}, {32395, -1, -1, -1}, {32398, -1, -1, -1}, {32400, -1, -1, -1}, {32401, -1, -1, -1}, {32402, -1, -1, -1}, {32405, -1, -1, -1}, {32407, -1, -1, -1}, {32409, -1, -1, -1}, {32410, -1, -1, -1}, {32413, -1, -1, -1}, {32414, -1, -1, -1}, {32430, -1, -1, -1}, {32436, -1, -1, -1}, {32443, -1, -1, -1}, {32444, -1, -1, -1}, {32470, -1, -1, -1}, {32484, -1, -1, -1}, {32492, -1, -1, -1}, {32505, -1, -1, -1}, {32522, -1, -1, -1}, {32528, -1, -1, -1}, {32542, -1, -1, -1}, {32567, -1, -1, -1}, {32569, -1, -1, -1}, {32571, -1, -1, -1}, {32572, -1, -1, -1}, {32573, -1, -1, -1}, {32574, -1, -1, -1}, {32575, -1, -1, -1}, {32576, -1, -1, -1}, {32577, -1, -1, -1}, {32579, -1, -1, -1}, {32582, -1, -1, -1}, {32583, -1, -1, -1}, {32584, -1, -1, -1}, {32585, -1, -1, -1}, {32586, -1, -1, -1}, {32587, -1, -1, -1}, {32589, -1, -1, -1}, {32591, -1, -1, -1}, {32594, -1, -1, -1}, {32595, -1, -1, -1}, {32598, -1, -1, -1}, {32601, -1, -1, -1}, {32603, -1, -1, -1}, {32604, -1, -1, -1}, {32605, -1, -1, -1}, {32606, -1, -1, -1}, {32608, -1, -1, -1}, {32611, -1, -1, -1}, {32612, -1, -1, -1}, {32613, -1, -1, -1}, {32614, -1, -1, -1}, {32615, -1, -1, -1} },
    {{32619, -1, -1, -1}, {32620, -1, -1, -1}, {32621, -1, -1, -1}, {32623, -1, -1, -1}, {32627, -1, -1, -1}, {32629, -1, -1, -1}, {32630, -1, -1, -1}, {32632, -1, -1, -1}, {32634, -1, -1, -1}, {32635, -1, -1, -1}, {32636, -1, -1, -1}, {32637, -1, -1, -1}, {32639, -1, -1, -1}, {32640, -1, -1, -1}, {32642, -1, -1, -1}, {32643, -1, -1, -1}, {32644, -1, -1, -1}, {32647, -1, -1, -1}, {32649, -1, -1, -1}, {32651, -1, -1, -1}, {32653, -1, -1, -1}, {32655, -1, -1, -1}, {32656, -1, -1, -1}, {32657, -1, -1, -1}, {32658, -1, -1, -1}, {32659, -1, -1, -1}, {32661, -1, -1, -1}, {32662, -1, -1, -1}, {32663, -1, -1, -1}, {32664, -1, -1, -1}, {32665, -1, -1, -1}, {32667, -1, -1, -1}, {32668, -1, -1, -1}, {32672, -1, -1, -1}, {32674, -1, -1, -1}, {32675, -1, -1, -1}, {32678, -1, -1, -1}, {32680, -1, -1, -1}, {32682, -1, -1, -1}, {32683, -1, -1, -1}, {32684, -1, -1, -1}, {32685, -1, -1, -1}, {32686, -1, -1, -1}, {32689, -1, -1, -1}, {32691, -1, -1, -1}, {32692, -1, -1, -1}, {32693, -1, -1, -1}, {32694, -1, -1, -1}, {32695, -1, -1, -1}, {32698, -1, -1, -1}, {32699, -1, -1, -1}, {32702, -1, -1, -1}, {32704, -1, -1, -1}, {32706, -1, -1, -1}, {32707, -1, -1, -1}, {32708, -1, -1, -1}, {32710, -1, -1, -1}, {32711, -1, -1, -1}, {32712, -1, -1, -1}, {32713, -1, -1, -1}, {32715, -1, -1, -1}, {32717, -1, -1, -1}, {32719, -1, -1, -1}, {32720, -1, -1, -1}, {32721, -1, -1, -1}, {32723, -1, -1, -1}, {32726, -1, -1, -1}, {32727, -1, -1, -1}, {32729, -1, -1, -1}, {32730, -1, -1, -1}, {32731, -1, -1, -1}, {32732, -1, -1, -1}, {32733, -1, -1, -1}, {32734, -1, -1, -1}, {32738, -1, -1, -1}, {32739, -1, -1, -1}, {32740, -1, -1, -1}, {32743, -1, -1, -1}, {32744, -1, -1, -1}, {32746, -1, -1, -1}, {32747, -1, -1, -1}, {32748, -1, -1, -1}, {32749, -1, -1, -1}, {32751, -1, -1, -1}, {32754, -1, -1, -1}, {32756, -1, -1, -1}, {32757, -1, -1, -1}, {32758, -1, -1, -1}, {32759, -1, -1, -1}, {32760, -1, -1, -1}, {32762, -1, -1, -1}, {32765, -1, -1, -1}, {32766, -1, -1, -1}, {32767, -1, -1, -1}, {32770, -1, -1, -1}, {32775, -1, -1, -1}, {32776, -1, -1, -1}, {32777, -1, -1, -1}, {32778, -1, -1, -1}, {32782, -1, -1, -1}, {32783, -1, -1, -1}, {32785, -1, -1, -1}, {32787, -1, -1, -1}, {32794, -1, -1, -1}, {32795, -1, -1, -1}, {32797, -1, -1, -1}, {32798, -1, -1, -1}, {32799, -1, -1, -1}, {32801, -1, -1, -1}, {32803, -1, -1, -1}, {32804, -1, -1, -1}, {32811, -1, -1, -1}, {32813, -1, -1, -1}, {32815, -1, -1, -1}, {32816, -1, -1, -1}, {32818, -1, -1, -1}, {32820, -1, -1, -1}, {32825, -1, -1, -1}, {32826, -1, -1, -1}, {32828, -1, -1, -1}, {32830, -1, -1, -1}, {32832, -1, -1, -1}, {32833, -1, -1, -1}, {32836, -1, -1, -1}, {32837, -1, -1, -1}, {32839, -1, -1, -1}, {32840, -1, -1, -1}, {32841, -1, -1, -1}, {32846, -1, -1, -1}, {32847, -1, -1, -1}, {32848, -1, -1, -1}, {32849, -1, -1, -1}, {32851, -1, -1, -1}, {32853, -1, -1, -1}, {32855, -1, -1, -1}, {32857, -1, -1, -1}, {32859, -1, -1, -1}, {32860, -1, -1, -1}, {32861, -1, -1, -1}, {32863, -1, -1, -1}, {32864, -1, -1, -1}, {32865, -1, -1, -1}, {32866, -1, -1, -1}, {32867, -1, -1, -1}, {32868, -1, -1, -1}, {32869, -1, -1, -1}, {32870, -1, -1, -1}, {32871, -1, -1, -1}, {32872, -1, -1, -1}, {32875, -1, -1, -1}, {32876, -1, -1, -1}, {32877, -1, -1, -1}, {32878, -1, -1, -1}, {32884, -1, -1, -1}, {32888, -1, -1, -1}, {32890, -1, -1, -1}, {32891, -1, -1, -1}, {32892, -1, -1, -1}, {32897, -1, -1, -1}, {32898, -1, -1, -1}, {32904, -1, -1, -1}, {32906, -1, -1, -1}, {32909, -1, -1, -1}, {32910, -1, -1, -1}, {32911, -1, -1, -1}, {32912, -1, -1, -1}, {32913, -1, -1, -1}, {32914, -1, -1, -1}, {32916, -1, -1, -1}, {32917, -1, -1, -1}, {32919, -1, -1, -1}, {32921, -1, -1, -1}, {32926, -1, -1, -1}, {32931, -1, -1, -1}, {32934, -1, -1, -1}, {32935, -1, -1, -1}, {32936, -1, -1, -1}, {32940, -1, -1, -1}, {32944, -1, -1, -1}, {32947, -1, -1, -1}, {32949, -1, -1, -1}, {32950, -1, -1, -1}, {32952, -1, -1, -1}, {32953, -1, -1, -1}, {32955, -1, -1, -1}, {32965, -1, -1, -1}, {32967, -1, -1, -1}, {32968, -1, -1, -1}, {32969, -1, -1, -1}, {32970, -1, -1, -1}, {32971, -1, -1, -1}, {32975, -1, -1, -1}, {32976, -1, -1, -1}, {32977, -1, -1, -1}, {32978, -1, -1, -1}, {32979, -1, -1, -1}, {32980, -1, -1, -1}, {32981, -1, -1, -1}, {32984, -1, -1, -1}, {32991, -1, -1, -1}, {32992, -1, -1, -1}, {32994, -1, -1, -1}, {32995, -1, -1, -1}, {32998, -1, -1, -1}, {33006, -1, -1, -1}, {33013, -1, -1, -1}, {33015, -1, -1, -1}, {33017, -1, -1, -1}, {33019, -1, -1, -1}, {33022, -1, -1, -1}, {33023, -1, -1, -1}, {33024, -1, -1, -1}, {33025, -1, -1, -1}, {33027, -1, -1, -1}, {33028, -1, -1, -1}, {33031, -1, -1, -1}, {33032, -1, -1, -1}, {33035, -1, -1, -1}, {33036, -1, -1, -1}, {33045, -1, -1, -1}, {33047, -1, -1, -1}, {33049, -1, -1, -1}, {33052, -1, -1, -1}, {33053, -1, -1, -1}, {33055, -1, -1, -1}, {33056, -1, -1, -1}, {33057, -1, -1, -1}, {33058, -1, -1, -1}, {33059, -1, -1, -1}, {33060, -1, -1, -1}, {33061, -1, -1, -1}, {33062, -1, -1, -1}, {33063, -1, -1, -1}, {33064, -1, -1, -1}, {33065, -1, -1, -1}, {33066, -1, -1, -1}, {33067, -1, -1, -1}, {33069, -1, -1, -1}, {33070, -1, -1, -1}, {33072, -1, -1, -1}, {33075, -1, -1, -1}, {33076, -1, -1, -1}, {33077, -1, -1, -1}, {33079, -1, -1, -1}, {33082, -1, -1, -1}, {33083, -1, -1, -1}, {33084, -1, -1, -1}, {33085, -1, -1, -1}, {33087, -1, -1, -1}, {33088, -1, -1, -1}, {33089, -1, -1, -1}, {33090, -1, -1, -1}, {33091, -1, -1, -1}, {33092, -1, -1, -1}, {33093, -1, -1, -1}, {33095, -1, -1, -1} },
    {{33097, -1, -1, -1}, {33101, -1, -1, -1}, {33103, -1, -1, -1}, {33106, -1, -1, -1}, {33111, -1, -1, -1}, {33112, -1, -1, -1}, {33115, -1, -1, -1}, {33116, -1, -1, -1}, {33117, -1, -1, -1}, {33118, -1, -1, -1}, {33119, -1, -1, -1}, {33122, -1, -1, -1}, {33123, -1, -1, -1}, {33124, -1, -1, -1}, {33128, -1, -1, -1}, {33130, -1, -1, -1}, {33132, -1, -1, -1}, {33135, -1, -1, -1}, {33138, -1, -1, -1}, {33139, -1, -1, -1}, {33141, -1, -1, -1}, {33142, -1, -1, -1}, {33143, -1, -1, -1}, {33153, -1, -1, -1}, {33155, -1, -1, -1}, {33156, -1, -1, -1}, {33157, -1, -1, -1}, {33158, -1, -1, -1}, {33159, -1, -1, -1}, {33161, -1, -1, -1}, {33163, -1, -1, -1}, {33164, -1, -1, -1}, {33165, -1, -1, -1}, {33166, -1, -1, -1}, {33168, -1, -1, -1}, {33170, -1, -1, -1}, {33171, -1, -1, -1}, {33172, -1, -1, -1}, {33173, -1, -1, -1}, {33174, -1, -1, -1}, {33175, -1, -1, -1}, {33177, -1, -1, -1}, {33182, -1, -1, -1}, {33183, -1, -1, -1}, {33185, -1, -1, -1}, {33186, -1, -1, -1}, {33188, -1, -1, -1}, {33189, -1, -1, -1}, {33191, -1, -1, -1}, {33195, -1, -1, -1}, {33196, -1, -1, -1}, {33197, -1, -1, -1}, {33198, -1, -1, -1}, {33199, -1, -1, -1}, {33200, -1, -1, -1}, {33201, -1, -1, -1}, {33202, -1, -1, -1}, {33204, -1, -1, -1}, {33205, -1, -1, -1}, {33206, -1, -1, -1}, {33207, -1, -1, -1}, {33208, -1, -1, -1}, {33209, -1, -1, -1}, {33212, -1, -1, -1}, {33220, -1, -1, -1}, {33221, -1, -1, -1}, {33223, -1, -1, -1}, {33224, -1, -1, -1}, {33227, -1, -1, -1}, {33230, -1, -1, -1}, {33232, -1, -1, -1}, {33233, -1, -1, -1}, {33234, -1, -1, -1}, {33235, -1, -1, -1}, {33236, -1, -1, -1}, {33237, -1, -1, -1}, {33238, -1, -1, -1}, {33239, -1, -1, -1}, {33241, -1, -1, -1}, {33243, -1, -1, -1}, {33244, -1, -1, -1}, {33245, -1, -1, -1}, {33246, -1, -1, -1}, {33249, -1, -1, -1}, {33250, -1, -1, -1}, {33252, -1, -1, -1}, {33253, -1, -1, -1}, {33254, -1, -1, -1}, {33257, -1, -1, -1}, {33259, -1, -1, -1}, {33262, -1, -1, -1}, {33263, -1, -1, -1}, {33264, -1, -1, -1}, {33265, -1, -1, -1}, {33266, -1, -1, -1}, {33269, -1, -1, -1}, {33270, -1, -1, -1}, {33271, -1, -1, -1}, {33272, -1, -1, -1}, {33273, -1, -1, -1}, {33277, -1, -1, -1}, {33279, -1, -1, -1}, {33283, -1, -1, -1}, {33291, -1, -1, -1}, {33294, -1, -1, -1}, {33295, -1, -1, -1}, {33297, -1, -1, -1}, {33299, -1, -1, -1}, {33301, -1, -1, -1}, {33302, -1, -1, -1}, {33303, -1, -1, -1}, {33304, -1, -1, -1}, {33305, -1, -1, -1}, {33306, -1, -1, -1}, {33309, -1, -1, -1}, {33312, -1, -1, -1}, {33316, -1, -1, -1}, {33317, -1, -1, -1}, {33318, -1, -1, -1}, {33319, -1, -1, -1}, {33321, -1, -1, -1}, {33326, -1, -1, -1}, {33330, -1, -1, -1}, {33338, -1, -1, -1}, {33340, -1, -1, -1}, {33341, -1, -1, -1}, {33343, -1, -1, -1}, {33344, -1, -1, -1}, {33345, -1, -1, -1}, {33346, -1, -1, -1}, {33347, -1, -1, -1}, {33349, -1, -1, -1}, {33350, -1, -1, -1}, {33352, -1, -1, -1}, {33354, -1, -1, -1}, {33356, -1, -1, -1}, {33357, -1, -1, -1}, {33358, -1, -1, -1}, {33360, -1, -1, -1}, {33361, -1, -1, -1}, {33362, -1, -1, -1}, {33363, -1, -1, -1}, {33364, -1, -1, -1}, {33365, -1, -1, -1}, {33366, -1, -1, -1}, {33367, -1, -1, -1}, {33371, -1, -1, -1}, {33372, -1, -1, -1}, {33373, -1, -1, -1}, {33374, -1, -1, -1}, {33376, -1, -1, -1}, {33377, -1, -1, -1}, {33378, -1, -1, -1}, {33379, -1, -1, -1}, {33381, -1, -1, -1}, {33383, -1, -1, -1}, {33385, -1, -1, -1}, {33386, -1, -1, -1}, {33388, -1, -1, -1}, {33389, -1, -1, -1}, {33397, -1, -1, -1}, {33398, -1, -1, -1}, {12171, 33400, -1, -1}, {33403, -1, -1, -1}, {33404, -1, -1, -1}, {33408, -1, -1, -1}, {33409, -1, -1, -1}, {33411, -1, -1, -1}, {33413, -1, -1, -1}, {33414, -1, -1, -1}, {33415, -1, -1, -1}, {33417, -1, -1, -1}, {33420, -1, -1, -1}, {33424, -1, -1, -1}, {33427, -1, -1, -1}, {33428, -1, -1, -1}, {33429, -1, -1, -1}, {33430, -1, -1, -1}, {33434, -1, -1, -1}, {33435, -1, -1, -1}, {33438, -1, -1, -1}, {33440, -1, -1, -1}, {33442, -1, -1, -1}, {33443, -1, -1, -1}, {33447, -1, -1, -1}, {33458, -1, -1, -1}, {33461, -1, -1, -1}, {33462, -1, -1, -1}, {33466, -1, -1, -1}, {33468, -1, -1, -1}, {33471, -1, -1, -1}, {33472, -1, -1, -1}, {33474, -1, -1, -1}, {33475, -1, -1, -1}, {33477, -1, -1, -1}, {33478, -1, -1, -1}, {33481, -1, -1, -1}, {33488, -1, -1, -1}, {33494, -1, -1, -1}, {33497, -1, -1, -1}, {33498, -1, -1, -1}, {33501, -1, -1, -1}, {33506, -1, -1, -1}, {33512, -1, -1, -1}, {33513, -1, -1, -1}, {33514, -1, -1, -1}, {33516, -1, -1, -1}, {33517, -1, -1, -1}, {33518, -1, -1, -1}, {33520, -1, -1, -1}, {33522, -1, -1, -1}, {33523, -1, -1, -1}, {33525, -1, -1, -1}, {33526, -1, -1, -1}, {33528, -1, -1, -1}, {33530, -1, -1, -1}, {33532, -1, -1, -1}, {33533, -1, -1, -1}, {33534, -1, -1, -1}, {33535, -1, -1, -1}, {33536, -1, -1, -1}, {33546, -1, -1, -1}, {33547, -1, -1, -1}, {33549, -1, -1, -1}, {33552, -1, -1, -1}, {33554, -1, -1, -1}, {33555, -1, -1, -1}, {33558, -1, -1, -1}, {33560, -1, -1, -1}, {33561, -1, -1, -1}, {33565, -1, -1, -1}, {33566, -1, -1, -1}, {33567, -1, -1, -1}, {33568, -1, -1, -1}, {33569, -1, -1, -1}, {33570, -1, -1, -1}, {33571, -1, -1, -1}, {33572, -1, -1, -1}, {33573, -1, -1, -1}, {33574, -1, -1, -1}, {33577, -1, -1, -1}, {33578, -1, -1, -1}, {33582, -1, -1, -1}, {33584, -1, -1, -1}, {33586, -1, -1, -1}, {33591, -1, -1, -1}, {33595, -1, -1, -1}, {33597, -1, -1, -1}, {33598, -1, -1, -1}, {33599, -1, -1, -1}, {33601, -1, -1, -1}, {33602, -1, -1, -1}, {33604, -1, -1, -1}, {33605, -1, -1, -1}, {33608, -1, -1, -1}, {33610, -1, -1, -1} },
    {{33611, -1, -1, -1}, {33612, -1, -1, -1}, {33613, -1, -1, -1}, {33614, -1, -1, -1}, {33619, -1, -1, -1}, {33621, -1, -1, -1}, {33622, -1, -1, -1}, {33623, -1, -1, -1}, {33624, -1, -1, -1}, {33625, -1, -1, -1}, {33629, -1, -1, -1}, {33634, -1, -1, -1}, {33648, -1, -1, -1}, {33649, -1, -1, -1}, {33650, -1, -1, -1}, {33651, -1, -1, -1}, {33652, -1, -1, -1}, {33653, -1, -1, -1}, {33654, -1, -1, -1}, {33657, -1, -1, -1}, {33658, -1, -1, -1}, {33662, -1, -1, -1}, {33663, -1, -1, -1}, {33664, -1, -1, -1}, {33665, -1, -1, -1}, {33666, -1, -1, -1}, {33667, -1, -1, -1}, {33668, -1, -1, -1}, {33671, -1, -1, -1}, {33672, -1, -1, -1}, {33675, -1, -1, -1}, {33676, -1, -1, -1}, {33677, -1, -1, -1}, {33679, -1, -1, -1}, {33680, -1, -1, -1}, {33681, -1, -1, -1}, {33684, -1, -1, -1}, {33685, -1, -1, -1}, {33687, -1, -1, -1}, {33689, -1, -1, -1}, {33690, -1, -1, -1}, {33693, -1, -1, -1}, {33695, -1, -1, -1}, {33697, -1, -1, -1}, {33699, -1, -1, -1}, {33700, -1, -1, -1}, {33701, -1, -1, -1}, {33702, -1, -1, -1}, {33708, -1, -1, -1}, {33709, -1, -1, -1}, {33710, -1, -1, -1}, {33711, -1, -1, -1}, {33717, -1, -1, -1}, {33723, -1, -1, -1}, {33726, -1, -1, -1}, {33727, -1, -1, -1}, {33730, -1, -1, -1}, {33731, -1, -1, -1}, {33732, -1, -1, -1}, {33734, -1, -1, -1}, {33736, -1, -1, -1}, {33737, -1, -1, -1}, {33739, -1, -1, -1}, {33741, -1, -1, -1}, {33742, -1, -1, -1}, {33744, -1, -1, -1}, {33745, -1, -1, -1}, {33746, -1, -1, -1}, {33747, -1, -1, -1}, {33749, -1, -1, -1}, {33751, -1, -1, -1}, {33753, -1, -1, -1}, {33754, -1, -1, -1}, {33755, -1, -1, -1}, {33758, -1, -1, -1}, {33762, -1, -1, -1}, {33763, -1, -1, -1}, {33764, -1, -1, -1}, {33766, -1, -1, -1}, {33767, -1, -1, -1}, {33768, -1, -1, -1}, {33771, -1, -1, -1}, {33772, -1, -1, -1}, {33773, -1, -1, -1}, {33774, -1, -1, -1}, {33779, -1, -1, -1}, {33780, -1, -1, -1}, {33781, -1, -1, -1}, {33782, -1, -1, -1}, {33783, -1, -1, -1}, {33786, -1, -1, -1}, {33787, -1, -1, -1}, {33788, -1, -1, -1}, {33790, -1, -1, -1}, {33791, -1, -1, -1}, {33792, -1, -1, -1}, {33794, -1, -1, -1}, {33797, -1, -1, -1}, {33800, -1, -1, -1}, {33801, -1, -1, -1}, {33808, -1, -1, -1}, {33810, -1, -1, -1}, {33811, -1, -1, -1}, {33812, -1, -1, -1}, {33813, -1, -1, -1}, {33814, -1, -1, -1}, {33815, -1, -1, -1}, {33817, -1, -1, -1}, {33818, -1, -1, -1}, {33819, -1, -1, -1}, {33822, -1, -1, -1}, {33823, -1, -1, -1}, {33824, -1, -1, -1}, {33825, -1, -1, -1}, {33826, -1, -1, -1}, {33827, -1, -1, -1}, {33833, -1, -1, -1}, {33834, -1, -1, -1}, {33835, -1, -1, -1}, {33837, -1, -1, -1}, {33838, -1, -1, -1}, {33839, -1, -1, -1}, {33840, -1, -1, -1}, {33842, -1, -1, -1}, {33843, -1, -1, -1}, {33844, -1, -1, -1}, {33846, -1, -1, -1}, {33847, -1, -1, -1}, {33849, -1, -1, -1}, {33850, -1, -1, -1}, {33851, -1, -1, -1}, {33854, -1, -1, -1}, {33855, -1, -1, -1}, {33856, -1, -1, -1}, {33857, -1, -1, -1}, {33858, -1, -1, -1}, {33859, -1, -1, -1}, {33860, -1, -1, -1}, {33861, -1, -1, -1}, {33863, -1, -1, -1}, {33864, -1, -1, -1}, {33866, -1, -1, -1}, {33867, -1, -1, -1}, {33868, -1, -1, -1}, {33869, -1, -1, -1}, {33870, -1, -1, -1}, {33871, -1, -1, -1}, {33872, -1, -1, -1}, {33875, -1, -1, -1}, {33876, -1, -1, -1}, {33877, -1, -1, -1}, {33878, -1, -1, -1}, {33880, -1, -1, -1}, {33885, -1, -1, -1}, {33886, -1, -1, -1}, {33887, -1, -1, -1}, {33888, -1, -1, -1}, {33890, -1, -1, -1}, {33893, -1, -1, -1}, {33895, -1, -1, -1}, {33896, -1, -1, -1}, {33898, -1, -1, -1}, {33902, -1, -1, -1}, {33904, -1, -1, -1}, {33906, -1, -1, -1}, {33908, -1, -1, -1}, {33913, -1, -1, -1}, {33915, -1, -1, -1}, {33916, -1, -1, -1}, {33917, -1, -1, -1}, {33918, -1, -1, -1}, {33919, -1, -1, -1}, {33920, -1, -1, -1}, {33921, -1, -1, -1}, {33923, -1, -1, -1}, {33924, -1, -1, -1}, {33925, -1, -1, -1}, {33926, -1, -1, -1}, {33930, -1, -1, -1}, {33933, -1, -1, -1}, {33935, -1, -1, -1}, {33936, -1, -1, -1}, {33937, -1, -1, -1}, {33938, -1, -1, -1}, {33941, -1, -1, -1}, {33942, -1, -1, -1}, {33944, -1, -1, -1}, {33946, -1, -1, -1}, {33947, -1, -1, -1}, {33949, -1, -1, -1}, {33950, -1, -1, -1}, {33951, -1, -1, -1}, {33952, -1, -1, -1}, {33954, -1, -1, -1}, {33955, -1, -1, -1}, {33956, -1, -1, -1}, {33957, -1, -1, -1}, {33958, -1, -1, -1}, {33959, -1, -1, -1}, {33960, -1, -1, -1}, {33961, -1, -1, -1}, {33962, -1, -1, -1}, {33963, -1, -1, -1}, {33964, -1, -1, -1}, {33965, -1, -1, -1}, {33966, -1, -1, -1}, {33968, -1, -1, -1}, {33969, -1, -1, -1}, {33971, -1, -1, -1}, {33973, -1, -1, -1}, {33974, -1, -1, -1}, {33975, -1, -1, -1}, {33979, -1, -1, -1}, {33982, -1, -1, -1}, {33986, -1, -1, -1}, {33987, -1, -1, -1}, {33989, -1, -1, -1}, {33990, -1, -1, -1}, {33991, -1, -1, -1}, {33992, -1, -1, -1}, {33996, -1, -1, -1}, {33998, -1, -1, -1}, {33999, -1, -1, -1}, {34002, -1, -1, -1}, {34004, -1, -1, -1}, {34005, -1, -1, -1}, {34007, -1, -1, -1}, {34008, -1, -1, -1}, {34009, -1, -1, -1}, {34010, -1, -1, -1}, {34011, -1, -1, -1}, {34012, -1, -1, -1}, {34014, -1, -1, -1}, {34017, -1, -1, -1}, {34018, -1, -1, -1}, {34020, -1, -1, -1}, {34023, -1, -1, -1}, {34024, -1, -1, -1}, {34025, -1, -1, -1}, {34026, -1, -1, -1}, {34027, -1, -1, -1}, {34029, -1, -1, -1}, {34033, -1, -1, -1}, {34034, -1, -1, -1}, {34035, -1, -1, -1}, {34036, -1, -1, -1}, {34037, -1, -1, -1}, {34038, -1, -1, -1}, {34039, -1, -1, -1}, {34040, -1, -1, -1}, {34041, -1, -1, -1}, {34042, -1, -1, -1}, {34043, -1, -1, -1}, {34046, -1, -1, -1}, {34048, -1, -1, -1}, {34049, -1, -1, -1} },
    {{34050, -1, -1, -1}, {34051, -1, -1, -1}, {34052, -1, -1, -1}, {34053, -1, -1, -1}, {34054, -1, -1, -1}, {34055, -1, -1, -1}, {34056, -1, -1, -1}, {34057, -1, -1, -1}, {34058, -1, -1, -1}, {34059, -1, -1, -1}, {34061, -1, -1, -1}, {34062, -1, -1, -1}, {34063, -1, -1, -1}, {34064, -1, -1, -1}, {34066, -1, -1, -1}, {34069, -1, -1, -1}, {34070, -1, -1, -1}, {34072, -1, -1, -1}, {34073, -1, -1, -1}, {34075, -1, -1, -1}, {34076, -1, -1, -1}, {34077, -1, -1, -1}, {34080, -1, -1, -1}, {34082, -1, -1, -1}, {34084, -1, -1, -1}, {34085, -1, -1, -1}, {34087, -1, -1, -1}, {34088, -1, -1, -1}, {34089, -1, -1, -1}, {34090, -1, -1, -1}, {34094, -1, -1, -1}, {34095, -1, -1, -1}, {34096, -1, -1, -1}, {34097, -1, -1, -1}, {34098, -1, -1, -1}, {34099, -1, -1, -1}, {34100, -1, -1, -1}, {34101, -1, -1, -1}, {34102, -1, -1, -1}, {34110, -1, -1, -1}, {34111, -1, -1, -1}, {34112, -1, -1, -1}, {34114, -1, -1, -1}, {34116, -1, -1, -1}, {34117, -1, -1, -1}, {34119, -1, -1, -1}, {34123, -1, -1, -1}, {34124, -1, -1, -1}, {34125, -1, -1, -1}, {34127, -1, -1, -1}, {34128, -1, -1, -1}, {34129, -1, -1, -1}, {34132, -1, -1, -1}, {34135, -1, -1, -1}, {34138, -1, -1, -1}, {34139, -1, -1, -1}, {34140, -1, -1, -1}, {34141, -1, -1, -1}, {34143, -1, -1, -1}, {34144, -1, -1, -1}, {34145, -1, -1, -1}, {34147, -1, -1, -1}, {34149, -1, -1, -1}, {34150, -1, -1, -1}, {34151, -1, -1, -1}, {34155, -1, -1, -1}, {34156, -1, -1, -1}, {34158, -1, -1, -1}, {34159, -1, -1, -1}, {34160, -1, -1, -1}, {34161, -1, -1, -1}, {34163, -1, -1, -1}, {34165, -1, -1, -1}, {34166, -1, -1, -1}, {34168, -1, -1, -1}, {34172, -1, -1, -1}, {34173, -1, -1, -1}, {34175, -1, -1, -1}, {34176, -1, -1, -1}, {34177, -1, -1, -1}, {34178, -1, -1, -1}, {34179, -1, -1, -1}, {34182, -1, -1, -1}, {34185, -1, -1, -1}, {34187, -1, -1, -1}, {34189, -1, -1, -1}, {34190, -1, -1, -1}, {34192, -1, -1, -1}, {34194, -1, -1, -1}, {34195, -1, -1, -1}, {34197, -1, -1, -1}, {34198, -1, -1, -1}, {34199, -1, -1, -1}, {34200, -1, -1, -1}, {34201, -1, -1, -1}, {34202, -1, -1, -1}, {34205, -1, -1, -1}, {34206, -1, -1, -1}, {34208, -1, -1, -1}, {34209, -1, -1, -1}, {34210, -1, -1, -1}, {34211, -1, -1, -1}, {34213, -1, -1, -1}, {34215, -1, -1, -1}, {34219, -1, -1, -1}, {34220, -1, -1, -1}, {34221, -1, -1, -1}, {34225, -1, -1, -1}, {34226, -1, -1, -1}, {34227, -1, -1, -1}, {34228, -1, -1, -1}, {34229, -1, -1, -1}, {34230, -1, -1, -1}, {34232, -1, -1, -1}, {34235, -1, -1, -1}, {34236, -1, -1, -1}, {34237, -1, -1, -1}, {34238, -1, -1, -1}, {34239, -1, -1, -1}, {34240, -1, -1, -1}, {34242, -1, -1, -1}, {34243, -1, -1, -1}, {34244, -1, -1, -1}, {34245, -1, -1, -1}, {34246, -1, -1, -1}, {34247, -1, -1, -1}, {34248, -1, -1, -1}, {34250, -1, -1, -1}, {34251, -1, -1, -1}, {34252, -1, -1, -1}, {34257, -1, -1, -1}, {34258, -1, -1, -1}, {34260, -1, -1, -1}, {34262, -1, -1, -1}, {34263, -1, -1, -1}, {34264, -1, -1, -1}, {34265, -1, -1, -1}, {34266, -1, -1, -1}, {34267, -1, -1, -1}, {34270, -1, -1, -1}, {34271, -1, -1, -1}, {34272, -1, -1, -1}, {34273, -1, -1, -1}, {34274, -1, -1, -1}, {34275, -1, -1, -1}, {34278, -1, -1, -1}, {34279, -1, -1, -1}, {34280, -1, -1, -1}, {34283, -1, -1, -1}, {34284, -1, -1, -1}, {34285, -1, -1, -1}, {34286, -1, -1, -1}, {34287, -1, -1, -1}, {34288, -1, -1, -1}, {34289, -1, -1, -1}, {34290, -1, -1, -1}, {34291, -1, -1, -1}, {34293, -1, -1, -1}, {34295, -1, -1, -1}, {34296, -1, -1, -1}, {34300, -1, -1, -1}, {34301, -1, -1, -1}, {34302, -1, -1, -1}, {34304, -1, -1, -1}, {34305, -1, -1, -1}, {34306, -1, -1, -1}, {34307, -1, -1, -1}, {34312, -1, -1, -1}, {34313, -1, -1, -1}, {34314, -1, -1, -1}, {34316, -1, -1, -1}, {34317, -1, -1, -1}, {34318, -1, -1, -1}, {34319, -1, -1, -1}, {34320, -1, -1, -1}, {34322, -1, -1, -1}, {34323, -1, -1, -1}, {34324, -1, -1, -1}, {34325, -1, -1, -1}, {34327, -1, -1, -1}, {34328, -1, -1, -1}, {34329, -1, -1, -1}, {34331, -1, -1, -1}, {34332, -1, -1, -1}, {34333, -1, -1, -1}, {34335, -1, -1, -1}, {34336, -1, -1, -1}, {34337, -1, -1, -1}, {34339, -1, -1, -1}, {34340, -1, -1, -1}, {34341, -1, -1, -1}, {34342, -1, -1, -1}, {34344, -1, -1, -1}, {34346, -1, -1, -1}, {34347, -1, -1, -1}, {34348, -1, -1, -1}, {34350, -1, -1, -1}, {34351, -1, -1, -1}, {34352, -1, -1, -1}, {34353, -1, -1, -1}, {34354, -1, -1, -1}, {34355, -1, -1, -1}, {34356, -1, -1, -1}, {34357, -1, -1, -1}, {34358, -1, -1, -1}, {34359, -1, -1, -1}, {34361, -1, -1, -1}, {34363, -1, -1, -1}, {34365, -1, -1, -1}, {34366, -1, -1, -1}, {34368, -1, -1, -1}, {34369, -1, -1, -1}, {34370, -1, -1, -1}, {34371, -1, -1, -1}, {34372, -1, -1, -1}, {34373, -1, -1, -1}, {34374, -1, -1, -1}, {34375, -1, -1, -1}, {34376, -1, -1, -1}, {34377, -1, -1, -1}, {34378, -1, -1, -1}, {34379, -1, -1, -1}, {34380, -1, -1, -1}, {34386, -1, -1, -1}, {34387, -1, -1, -1}, {34390, -1, -1, -1}, {34391, -1, -1, -1}, {34392, -1, -1, -1}, {34393, -1, -1, -1}, {34395, -1, -1, -1}, {34397, -1, -1, -1}, {34400, -1, -1, -1}, {34401, -1, -1, -1}, {34403, -1, -1, -1}, {34404, -1, -1, -1}, {34405, -1, -1, -1}, {34406, -1, -1, -1}, {34408, -1, -1, -1}, {34409, -1, -1, -1}, {34410, -1, -1, -1}, {34413, -1, -1, -1}, {34415, -1, -1, -1}, {34416, -1, -1, -1}, {34418, -1, -1, -1}, {34419, -1, -1, -1}, {34420, -1, -1, -1}, {34421, -1, -1, -1}, {34422, -1, -1, -1}, {34423, -1, -1, -1}, {34424, -1, -1, -1}, {34435, -1, -1, -1}, {34436, -1, -1, -1}, {34437, -1, -1, -1}, {34438, -1, -1, -1}, {34439, -1, -1, -1}, {34440, -1, -1, -1} },
    {{34441, -1, -1, -1}, {34446, -1, -1, -1}, {34447, -1, -1, -1}, {34448, -1, -1, -1}, {34449, -1, -1, -1}, {34450, -1, -1, -1}, {34452, -1, -1, -1}, {34454, -1, -1, -1}, {34455, -1, -1, -1}, {34456, -1, -1, -1}, {34457, -1, -1, -1}, {34458, -1, -1, -1}, {34459, -1, -1, -1}, {34462, -1, -1, -1}, {34463, -1, -1, -1}, {34464, -1, -1, -1}, {34465, -1, -1, -1}, {34466, -1, -1, -1}, {34469, -1, -1, -1}, {34470, -1, -1, -1}, {34475, -1, -1, -1}, {34477, -1, -1, -1}, {34478, -1, -1, -1}, {34482, -1, -1, -1}, {34483, -1, -1, -1}, {34487, -1, -1, -1}, {34488, -1, -1, -1}, {34489, -1, -1, -1}, {34491, -1, -1, -1}, {34492, -1, -1, -1}, {34493, -1, -1, -1}, {34494, -1, -1, -1}, {34495, -1, -1, -1}, {34497, -1, -1, -1}, {34498, -1, -1, -1}, {34499, -1, -1, -1}, {34501, -1, -1, -1}, {34504, -1, -1, -1}, {34508, -1, -1, -1}, {34509, -1, -1, -1}, {34514, -1, -1, -1}, {34515, -1, -1, -1}, {34517, -1, -1, -1}, {34518, -1, -1, -1}, {34519, -1, -1, -1}, {34522, -1, -1, -1}, {34524, -1, -1, -1}, {34525, -1, -1, -1}, {34528, -1, -1, -1}, {34529, -1, -1, -1}, {34530, -1, -1, -1}, {34531, -1, -1, -1}, {34533, -1, -1, -1}, {34534, -1, -1, -1}, {34535, -1, -1, -1}, {34536, -1, -1, -1}, {34538, -1, -1, -1}, {34539, -1, -1, -1}, {34540, -1, -1, -1}, {34543, -1, -1, -1}, {34549, -1, -1, -1}, {34550, -1, -1, -1}, {34551, -1, -1, -1}, {34555, -1, -1, -1}, {34556, -1, -1, -1}, {34557, -1, -1, -1}, {34559, -1, -1, -1}, {34561, -1, -1, -1}, {34564, -1, -1, -1}, {34565, -1, -1, -1}, {34571, -1, -1, -1}, {34572, -1, -1, -1}, {34574, -1, -1, -1}, {34575, -1, -1, -1}, {34576, -1, -1, -1}, {34577, -1, -1, -1}, {34580, -1, -1, -1}, {34582, -1, -1, -1}, {34585, -1, -1, -1}, {34587, -1, -1, -1}, {34589, -1, -1, -1}, {34591, -1, -1, -1}, {34592, -1, -1, -1}, {34596, -1, -1, -1}, {34598, -1, -1, -1}, {34599, -1, -1, -1}, {34600, -1, -1, -1}, {34602, -1, -1, -1}, {34603, -1, -1, -1}, {34604, -1, -1, -1}, {34605, -1, -1, -1}, {34607, -1, -1, -1}, {34608, -1, -1, -1}, {34610, -1, -1, -1}, {34611, -1, -1, -1}, {34613, -1, -1, -1}, {34614, -1, -1, -1}, {34616, -1, -1, -1}, {34617, -1, -1, -1}, {34618, -1, -1, -1}, {34620, -1, -1, -1}, {34621, -1, -1, -1}, {34624, -1, -1, -1}, {34625, -1, -1, -1}, {34626, -1, -1, -1}, {34627, -1, -1, -1}, {34628, -1, -1, -1}, {34629, -1, -1, -1}, {34630, -1, -1, -1}, {34634, -1, -1, -1}, {34635, -1, -1, -1}, {34637, -1, -1, -1}, {34639, -1, -1, -1}, {34640, -1, -1, -1}, {34641, -1, -1, -1}, {34642, -1, -1, -1}, {34644, -1, -1, -1}, {34646, -1, -1, -1}, {34648, -1, -1, -1}, {34650, -1, -1, -1}, {34651, -1, -1, -1}, {34652, -1, -1, -1}, {34653, -1, -1, -1}, {34654, -1, -1, -1}, {34655, -1, -1, -1}, {34657, -1, -1, -1}, {34658, -1, -1, -1}, {34663, -1, -1, -1}, {34664, -1, -1, -1}, {34665, -1, -1, -1}, {34666, -1, -1, -1}, {34667, -1, -1, -1}, {34668, -1, -1, -1}, {34669, -1, -1, -1}, {34671, -1, -1, -1}, {34673, -1, -1, -1}, {34674, -1, -1, -1}, {34675, -1, -1, -1}, {34677, -1, -1, -1}, {34679, -1, -1, -1}, {34681, -1, -1, -1}, {34682, -1, -1, -1}, {34687, -1, -1, -1}, {34688, -1, -1, -1}, {34689, -1, -1, -1}, {34694, -1, -1, -1}, {34695, -1, -1, -1}, {34697, -1, -1, -1}, {34698, -1, -1, -1}, {34700, -1, -1, -1}, {34702, -1, -1, -1}, {34703, -1, -1, -1}, {34704, -1, -1, -1}, {34705, -1, -1, -1}, {34706, -1, -1, -1}, {34708, -1, -1, -1}, {34709, -1, -1, -1}, {34710, -1, -1, -1}, {34712, -1, -1, -1}, {34713, -1, -1, -1}, {34714, -1, -1, -1}, {34715, -1, -1, -1}, {34716, -1, -1, -1}, {34717, -1, -1, -1}, {34720, -1, -1, -1}, {34721, -1, -1, -1}, {34723, -1, -1, -1}, {34724, -1, -1, -1}, {34725, -1, -1, -1}, {34726, -1, -1, -1}, {34727, -1, -1, -1}, {34729, -1, -1, -1}, {34730, -1, -1, -1}, {34734, -1, -1, -1}, {34736, -1, -1, -1}, {34737, -1, -1, -1}, {34738, -1, -1, -1}, {34740, -1, -1, -1}, {34742, -1, -1, -1}, {34743, -1, -1, -1}, {34744, -1, -1, -1}, {34745, -1, -1, -1}, {34748, -1, -1, -1}, {34750, -1, -1, -1}, {34751, -1, -1, -1}, {34753, -1, -1, -1}, {34754, -1, -1, -1}, {34755, -1, -1, -1}, {34757, -1, -1, -1}, {34759, -1, -1, -1}, {34761, -1, -1, -1}, {34764, -1, -1, -1}, {34765, -1, -1, -1}, {34767, -1, -1, -1}, {34768, -1, -1, -1}, {34772, -1, -1, -1}, {34773, -1, -1, -1}, {34774, -1, -1, -1}, {34775, -1, -1, -1}, {34776, -1, -1, -1}, {34777, -1, -1, -1}, {34778, -1, -1, -1}, {34780, -1, -1, -1}, {34781, -1, -1, -1}, {34782, -1, -1, -1}, {34783, -1, -1, -1}, {34785, -1, -1, -1}, {34786, -1, -1, -1}, {34788, -1, -1, -1}, {34790, -1, -1, -1}, {34791, -1, -1, -1}, {34792, -1, -1, -1}, {34793, -1, -1, -1}, {34795, -1, -1, -1}, {34797, -1, -1, -1}, {34800, -1, -1, -1}, {34801, -1, -1, -1}, {34803, -1, -1, -1}, {34804, -1, -1, -1}, {34805, -1, -1, -1}, {34807, -1, -1, -1}, {34808, -1, -1, -1}, {34810, -1, -1, -1}, {34812, -1, -1, -1}, {34813, -1, -1, -1}, {34815, -1, -1, -1}, {34816, -1, -1, -1}, {34817, -1, -1, -1}, {34818, -1, -1, -1}, {34820, -1, -1, -1}, {34823, -1, -1, -1}, {34824, -1, -1, -1}, {34825, -1, -1, -1}, {34827, -1, -1, -1}, {34828, -1, -1, -1}, {34829, -1, -1, -1}, {34830, -1, -1, -1}, {34831, -1, -1, -1}, {34834, -1, -1, -1}, {34836, -1, -1, -1}, {34839, -1, -1, -1}, {34840, -1, -1, -1}, {34841, -1, -1, -1}, {34842, -1, -1, -1}, {34844, -1, -1, -1}, {34845, -1, -1, -1}, {34846, -1, -1, -1}, {34848, -1, -1, -1}, {34852, -1, -1, -1}, {34853, -1, -1, -1}, {34854, -1, -1, -1}, {34855, -1, -1, -1}, {34856, -1, -1, -1}, {34857, -1, -1, -1}, {34858, -1, -1, -1}, {34859, -1, -1, -1} },
    {{34860, -1, -1, -1}, {34861, -1, -1, -1}, {34862, -1, -1, -1}, {34863, -1, -1, -1}, {34864, -1, -1, -1}, {34867, -1, -1, -1}, {34868, -1, -1, -1}, {34869, -1, -1, -1}, {34871, -1, -1, -1}, {34872, -1, -1, -1}, {34874, -1, -1, -1}, {34877, -1, -1, -1}, {34878, -1, -1, -1}, {34879, -1, -1, -1}, {34881, -1, -1, -1}, {34882, -1, -1, -1}, {34883, -1, -1, -1}, {34887, -1, -1, -1}, {34888, -1, -1, -1}, {34889, -1, -1, -1}, {34891, -1, -1, -1}, {34894, -1, -1, -1}, {34895, -1, -1, -1}, {34896, -1, -1, -1}, {34897, -1, -1, -1}, {34898, -1, -1, -1}, {34901, -1, -1, -1}, {34902, -1, -1, -1}, {34904, -1, -1, -1}, {34906, -1, -1, -1}, {34908, -1, -1, -1}, {34910, -1, -1, -1}, {34911, -1, -1, -1}, {34912, -1, -1, -1}, {34918, -1, -1, -1}, {34919, -1, -1, -1}, {34922, -1, -1, -1}, {34925, -1, -1, -1}, {34927, -1, -1, -1}, {34929, -1, -1, -1}, {34931, -1, -1, -1}, {34932, -1, -1, -1}, {34933, -1, -1, -1}, {34934, -1, -1, -1}, {34936, -1, -1, -1}, {34938, -1, -1, -1}, {34939, -1, -1, -1}, {34940, -1, -1, -1}, {34944, -1, -1, -1}, {34947, -1, -1, -1}, {34950, -1, -1, -1}, {34951, -1, -1, -1}, {34953, -1, -1, -1}, {34954, -1, -1, -1}, {34956, -1, -1, -1}, {34958, -1, -1, -1}, {34959, -1, -1, -1}, {34960, -1, -1, -1}, {34961, -1, -1, -1}, {34963, -1, -1, -1}, {34964, -1, -1, -1}, {34965, -1, -1, -1}, {34967, -1, -1, -1}, {34968, -1, -1, -1}, {34969, -1, -1, -1}, {34970, -1, -1, -1}, {34971, -1, -1, -1}, {34973, -1, -1, -1}, {34974, -1, -1, -1}, {34975, -1, -1, -1}, {34976, -1, -1, -1}, {34977, -1, -1, -1}, {34979, -1, -1, -1}, {34981, -1, -1, -1}, {34982, -1, -1, -1}, {34983, -1, -1, -1}, {34984, -1, -1, -1}, {34985, -1, -1, -1}, {34986, -1, -1, -1}, {34988, -1, -1, -1}, {34990, -1, -1, -1}, {34991, -1, -1, -1}, {34992, -1, -1, -1}, {34994, -1, -1, -1}, {34995, -1, -1, -1}, {34996, -1, -1, -1}, {34997, -1, -1, -1}, {34998, -1, -1, -1}, {35000, -1, -1, -1}, {35001, -1, -1, -1}, {35002, -1, -1, -1}, {35003, -1, -1, -1}, {35005, -1, -1, -1}, {35006, -1, -1, -1}, {35007, -1, -1, -1}, {35008, -1, -1, -1}, {35011, -1, -1, -1}, {35012, -1, -1, -1}, {35015, -1, -1, -1}, {35016, -1, -1, -1}, {35019, -1, -1, -1}, {35020, -1, -1, -1}, {35021, -1, -1, -1}, {35024, -1, -1, -1}, {35025, -1, -1, -1}, {35027, -1, -1, -1}, {35030, -1, -1, -1}, {35031, -1, -1, -1}, {35034, -1, -1, -1}, {35035, -1, -1, -1}, {35038, -1, -1, -1}, {35040, -1, -1, -1}, {35041, -1, -1, -1}, {35046, -1, -1, -1}, {35047, -1, -1, -1}, {35049, -1, -1, -1}, {35050, -1, -1, -1}, {35051, -1, -1, -1}, {35052, -1, -1, -1}, {35053, -1, -1, -1}, {35054, -1, -1, -1}, {35055, -1, -1, -1}, {35058, -1, -1, -1}, {35061, -1, -1, -1}, {35062, -1, -1, -1}, {35063, -1, -1, -1}, {35066, -1, -1, -1}, {35067, -1, -1, -1}, {35071, -1, -1, -1}, {35072, -1, -1, -1}, {35073, -1, -1, -1}, {35075, -1, -1, -1}, {35076, -1, -1, -1}, {35077, -1, -1, -1}, {35078, -1, -1, -1}, {35080, -1, -1, -1}, {35081, -1, -1, -1}, {35083, -1, -1, -1}, {35084, -1, -1, -1}, {35085, -1, -1, -1}, {35086, -1, -1, -1}, {35087, -1, -1, -1}, {35089, -1, -1, -1}, {35092, -1, -1, -1}, {35093, -1, -1, -1}, {35094, -1, -1, -1}, {35095, -1, -1, -1}, {35096, -1, -1, -1}, {35100, -1, -1, -1}, {35101, -1, -1, -1}, {35102, -1, -1, -1}, {35103, -1, -1, -1}, {35104, -1, -1, -1}, {35106, -1, -1, -1}, {35107, -1, -1, -1}, {35108, -1, -1, -1}, {35110, -1, -1, -1}, {35111, -1, -1, -1}, {35112, -1, -1, -1}, {35113, -1, -1, -1}, {35116, -1, -1, -1}, {35117, -1, -1, -1}, {35118, -1, -1, -1}, {35119, -1, -1, -1}, {35121, -1, -1, -1}, {35125, -1, -1, -1}, {35127, -1, -1, -1}, {35129, -1, -1, -1}, {35130, -1, -1, -1}, {35132, -1, -1, -1}, {35133, -1, -1, -1}, {35134, -1, -1, -1}, {35135, -1, -1, -1}, {35136, -1, -1, -1}, {35138, -1, -1, -1}, {35139, -1, -1, -1}, {35141, -1, -1, -1}, {35142, -1, -1, -1}, {35144, -1, -1, -1}, {35145, -1, -1, -1}, {35146, -1, -1, -1}, {35147, -1, -1, -1}, {35148, -1, -1, -1}, {35149, -1, -1, -1}, {35150, -1, -1, -1}, {35151, -1, -1, -1}, {35152, -1, -1, -1}, {35153, -1, -1, -1}, {35154, -1, -1, -1}, {35155, -1, -1, -1}, {35156, -1, -1, -1}, {35157, -1, -1, -1}, {35159, -1, -1, -1}, {35160, -1, -1, -1}, {35161, -1, -1, -1}, {35162, -1, -1, -1}, {35163, -1, -1, -1}, {35164, -1, -1, -1}, {35169, -1, -1, -1}, {35170, -1, -1, -1}, {35171, -1, -1, -1}, {35173, -1, -1, -1}, {35175, -1, -1, -1}, {35176, -1, -1, -1}, {35177, -1, -1, -1}, {35179, -1, -1, -1}, {35181, -1, -1, -1}, {35182, -1, -1, -1}, {35184, -1, -1, -1}, {35185, -1, -1, -1}, {35187, -1, -1, -1}, {35188, -1, -1, -1}, {35189, -1, -1, -1}, {35190, -1, -1, -1}, {35191, -1, -1, -1}, {35192, -1, -1, -1}, {35193, -1, -1, -1}, {35194, -1, -1, -1}, {35196, -1, -1, -1}, {35197, -1, -1, -1}, {12177, 35198, -1, -1}, {35200, -1, -1, -1}, {35202, -1, -1, -1}, {35204, -1, -1, -1}, {35205, -1, -1, -1}, {35207, -1, -1, -1}, {35208, -1, -1, -1}, {35209, -1, -1, -1}, {35210, -1, -1, -1}, {35212, -1, -1, -1}, {35213, -1, -1, -1}, {35214, -1, -1, -1}, {35216, -1, -1, -1}, {35217, -1, -1, -1}, {35218, -1, -1, -1}, {35220, -1, -1, -1}, {35221, -1, -1, -1}, {35223, -1, -1, -1}, {35225, -1, -1, -1}, {35226, -1, -1, -1}, {35227, -1, -1, -1}, {35228, -1, -1, -1}, {35229, -1, -1, -1}, {35230, -1, -1, -1}, {35231, -1, -1, -1}, {35232, -1, -1, -1}, {35234, -1, -1, -1}, {35235, -1, -1, -1}, {35236, -1, -1, -1}, {35237, -1, -1, -1}, {35239, -1, -1, -1}, {35240, -1, -1, -1}, {35241, -1, -1, -1}, {35243, -1, -1, -1}, {35245, -1, -1, -1}, {35246, -1, -1, -1} },
    {{35248, -1, -1, -1}, {35249, -1, -1, -1}, {35251, -1, -1, -1}, {35252, -1, -1, -1}, {35253, -1, -1, -1}, {35254, -1, -1, -1}, {35256, -1, -1, -1}, {35257, -1, -1, -1}, {35259, -1, -1, -1}, {35260, -1, -1, -1}, {35262, -1, -1, -1}, {35267, -1, -1, -1}, {35277, -1, -1, -1}, {35283, -1, -1, -1}, {35284, -1, -1, -1}, {35285, -1, -1, -1}, {35287, -1, -1, -1}, {35288, -1, -1, -1}, {35289, -1, -1, -1}, {35291, -1, -1, -1}, {35293, -1, -1, -1}, {35295, -1, -1, -1}, {35296, -1, -1, -1}, {35297, -1, -1, -1}, {35298, -1, -1, -1}, {35300, -1, -1, -1}, {35303, -1, -1, -1}, {35304, -1, -1, -1}, {35305, -1, -1, -1}, {35306, -1, -1, -1}, {35308, -1, -1, -1}, {35309, -1, -1, -1}, {35310, -1, -1, -1}, {35312, -1, -1, -1}, {35313, -1, -1, -1}, {35314, -1, -1, -1}, {35317, -1, -1, -1}, {35319, -1, -1, -1}, {35321, -1, -1, -1}, {35322, -1, -1, -1}, {35323, -1, -1, -1}, {35324, -1, -1, -1}, {35325, -1, -1, -1}, {35326, -1, -1, -1}, {35327, -1, -1, -1}, {35332, -1, -1, -1}, {35333, -1, -1, -1}, {35334, -1, -1, -1}, {35337, -1, -1, -1}, {35339, -1, -1, -1}, {35341, -1, -1, -1}, {35343, -1, -1, -1}, {35345, -1, -1, -1}, {35346, -1, -1, -1}, {35348, -1, -1, -1}, {35351, -1, -1, -1}, {35353, -1, -1, -1}, {35354, -1, -1, -1}, {35356, -1, -1, -1}, {35358, -1, -1, -1}, {35360, -1, -1, -1}, {35361, -1, -1, -1}, {35362, -1, -1, -1}, {35364, -1, -1, -1}, {35366, -1, -1, -1}, {35367, -1, -1, -1}, {35368, -1, -1, -1}, {35369, -1, -1, -1}, {35371, -1, -1, -1}, {35372, -1, -1, -1}, {35374, -1, -1, -1}, {35375, -1, -1, -1}, {35376, -1, -1, -1}, {35378, -1, -1, -1}, {35379, -1, -1, -1}, {35381, -1, -1, -1}, {35383, -1, -1, -1}, {35384, -1, -1, -1}, {35385, -1, -1, -1}, {35387, -1, -1, -1}, {35388, -1, -1, -1}, {35389, -1, -1, -1}, {35391, -1, -1, -1}, {35392, -1, -1, -1}, {35394, -1, -1, -1}, {35395, -1, -1, -1}, {35396, -1, -1, -1}, {35397, -1, -1, -1}, {35399, -1, -1, -1}, {35401, -1, -1, -1}, {35402, -1, -1, -1}, {35403, -1, -1, -1}, {35404, -1, -1, -1}, {35405, -1, -1, -1}, {35407, -1, -1, -1}, {35409, -1, -1, -1}, {35411, -1, -1, -1}, {35414, -1, -1, -1}, {35415, -1, -1, -1}, {35417, -1, -1, -1}, {35418, -1, -1, -1}, {35420, -1, -1, -1}, {35421, -1, -1, -1}, {35423, -1, -1, -1}, {35424, -1, -1, -1}, {35428, -1, -1, -1}, {35429, -1, -1, -1}, {35431, -1, -1, -1}, {35432, -1, -1, -1}, {35434, -1, -1, -1}, {35439, -1, -1, -1}, {35444, -1, -1, -1}, {35446, -1, -1, -1}, {35447, -1, -1, -1}, {35448, -1, -1, -1}, {35450, -1, -1, -1}, {35451, -1, -1, -1}, {35453, -1, -1, -1}, {35454, -1, -1, -1}, {35456, -1, -1, -1}, {35457, -1, -1, -1}, {35458, -1, -1, -1}, {35459, -1, -1, -1}, {35464, -1, -1, -1}, {35467, -1, -1, -1}, {35468, -1, -1, -1}, {35470, -1, -1, -1}, {35471, -1, -1, -1}, {35472, -1, -1, -1}, {35476, -1, -1, -1}, {35478, -1, -1, -1}, {35479, -1, -1, -1}, {35481, -1, -1, -1}, {35483, -1, -1, -1}, {35484, -1, -1, -1}, {35485, -1, -1, -1}, {35487, -1, -1, -1}, {35490, -1, -1, -1}, {35495, -1, -1, -1}, {35497, -1, -1, -1}, {35498, -1, -1, -1}, {35499, -1, -1, -1}, {35501, -1, -1, -1}, {35502, -1, -1, -1}, {35503, -1, -1, -1}, {35505, -1, -1, -1}, {35507, -1, -1, -1}, {35508, -1, -1, -1}, {35509, -1, -1, -1}, {35511, -1, -1, -1}, {35512, -1, -1, -1}, {35514, -1, -1, -1}, {35515, -1, -1, -1}, {35517, -1, -1, -1}, {35518, -1, -1, -1}, {35520, -1, -1, -1}, {35521, -1, -1, -1}, {35523, -1, -1, -1}, {35525, -1, -1, -1}, {35526, -1, -1, -1}, {35528, -1, -1, -1}, {35530, -1, -1, -1}, {35532, -1, -1, -1}, {35534, -1, -1, -1}, {35536, -1, -1, -1}, {35539, -1, -1, -1}, {35540, -1, -1, -1}, {35541, -1, -1, -1}, {35544, -1, -1, -1}, {35545, -1, -1, -1}, {35546, -1, -1, -1}, {35549, -1, -1, -1}, {35551, -1, -1, -1}, {35552, -1, -1, -1}, {35553, -1, -1, -1}, {35555, -1, -1, -1}, {35557, -1, -1, -1}, {35560, -1, -1, -1}, {35561, -1, -1, -1}, {35562, -1, -1, -1}, {35564, -1, -1, -1}, {35567, -1, -1, -1}, {35568, -1, -1, -1}, {35570, -1, -1, -1}, {35572, -1, -1, -1}, {35573, -1, -1, -1}, {35577, -1, -1, -1}, {35579, -1, -1, -1}, {35581, -1, -1, -1}, {35583, -1, -1, -1}, {35587, -1, -1, -1}, {35590, -1, -1, -1}, {35592, -1, -1, -1}, {35593, -1, -1, -1}, {35595, -1, -1, -1}, {35596, -1, -1, -1}, {35597, -1, -1, -1}, {35599, -1, -1, -1}, {35601, -1, -1, -1}, {35602, -1, -1, -1}, {35603, -1, -1, -1}, {35605, -1, -1, -1}, {35608, -1, -1, -1}, {35612, -1, -1, -1}, {35614, -1, -1, -1}, {35615, -1, -1, -1}, {35616, -1, -1, -1}, {35618, -1, -1, -1}, {35619, -1, -1, -1}, {35620, -1, -1, -1}, {35621, -1, -1, -1}, {35623, -1, -1, -1}, {35625, -1, -1, -1}, {35626, -1, -1, -1}, {35630, -1, -1, -1}, {35631, -1, -1, -1}, {35632, -1, -1, -1}, {35633, -1, -1, -1}, {35634, -1, -1, -1}, {35636, -1, -1, -1}, {35637, -1, -1, -1}, {35638, -1, -1, -1}, {35639, -1, -1, -1}, {35640, -1, -1, -1}, {35642, -1, -1, -1}, {35643, -1, -1, -1}, {35644, -1, -1, -1}, {35645, -1, -1, -1}, {35647, -1, -1, -1}, {35648, -1, -1, -1}, {35649, -1, -1, -1}, {35650, -1, -1, -1}, {35651, -1, -1, -1}, {35652, -1, -1, -1}, {35653, -1, -1, -1}, {35654, -1, -1, -1}, {35655, -1, -1, -1}, {35656, -1, -1, -1}, {35658, -1, -1, -1}, {35659, -1, -1, -1}, {35660, -1, -1, -1}, {35661, -1, -1, -1}, {35664, -1, -1, -1}, {35665, -1, -1, -1}, {35666, -1, -1, -1}, {35667, -1, -1, -1}, {35668, -1, -1, -1}, {35669, -1, -1, -1}, {35671, -1, -1, -1}, {35675, -1, -1, -1}, {35677, -1, -1, -1}, {35678, -1, -1, -1}, {35679, -1, -1, -1}, {35680, -1, -1, -1}, {35681, -1, -1, -1}, {35682, -1, -1, -1} },
    {{35683, -1, -1, -1}, {35684, -1, -1, -1}, {35685, -1, -1, -1}, {35687, -1, -1, -1}, {35688, -1, -1, -1}, {35689, -1, -1, -1}, {35690, -1, -1, -1}, {35693, -1, -1, -1}, {35694, -1, -1, -1}, {35697, -1, -1, -1}, {35698, -1, -1, -1}, {35699, -1, -1, -1}, {35701, -1, -1, -1}, {35702, -1, -1, -1}, {35704, -1, -1, -1}, {35705, -1, -1, -1}, {35706, -1, -1, -1}, {35707, -1, -1, -1}, {35708, -1, -1, -1}, {35710, -1, -1, -1}, {35711, -1, -1, -1}, {35713, -1, -1, -1}, {35714, -1, -1, -1}, {35715, -1, -1, -1}, {35716, -1, -1, -1}, {35717, -1, -1, -1}, {35718, -1, -1, -1}, {35719, -1, -1, -1}, {35720, -1, -1, -1}, {35721, -1, -1, -1}, {35723, -1, -1, -1}, {35724, -1, -1, -1}, {35725, -1, -1, -1}, {35727, -1, -1, -1}, {35728, -1, -1, -1}, {35729, -1, -1, -1}, {35732, -1, -1, -1}, {35735, -1, -1, -1}, {35736, -1, -1, -1}, {35737, -1, -1, -1}, {35738, -1, -1, -1}, {35739, -1, -1, -1}, {35741, -1, -1, -1}, {35743, -1, -1, -1}, {35756, -1, -1, -1}, {35761, -1, -1, -1}, {35771, -1, -1, -1}, {35783, -1, -1, -1}, {35792, -1, -1, -1}, {35818, -1, -1, -1}, {35849, -1, -1, -1}, {35870, -1, -1, -1}, {35896, -1, -1, -1}, {35897, -1, -1, -1}, {35898, -1, -1, -1}, {35899, -1, -1, -1}, {35900, -1, -1, -1}, {35901, -1, -1, -1}, {35902, -1, -1, -1}, {35903, -1, -1, -1}, {35904, -1, -1, -1}, {35906, -1, -1, -1}, {35907, -1, -1, -1}, {35908, -1, -1, -1}, {35909, -1, -1, -1}, {35914, -1, -1, -1}, {35915, -1, -1, -1}, {35917, -1, -1, -1}, {35918, -1, -1, -1}, {35919, -1, -1, -1}, {35921, -1, -1, -1}, {35922, -1, -1, -1}, {35923, -1, -1, -1}, {35924, -1, -1, -1}, {35926, -1, -1, -1}, {35927, -1, -1, -1}, {35928, -1, -1, -1}, {35929, -1, -1, -1}, {35931, -1, -1, -1}, {35932, -1, -1, -1}, {35933, -1, -1, -1}, {35934, -1, -1, -1}, {35935, -1, -1, -1}, {35936, -1, -1, -1}, {35939, -1, -1, -1}, {35940, -1, -1, -1}, {35941, -1, -1, -1}, {35942, -1, -1, -1}, {35943, -1, -1, -1}, {35944, -1, -1, -1}, {35945, -1, -1, -1}, {35948, -1, -1, -1}, {35949, -1, -1, -1}, {35950, -1, -1, -1}, {35951, -1, -1, -1}, {35952, -1, -1, -1}, {35953, -1, -1, -1}, {35954, -1, -1, -1}, {35956, -1, -1, -1}, {35957, -1, -1, -1}, {35958, -1, -1, -1}, {35959, -1, -1, -1}, {35963, -1, -1, -1}, {35964, -1, -1, -1}, {35965, -1, -1, -1}, {35966, -1, -1, -1}, {35967, -1, -1, -1}, {35968, -1, -1, -1}, {35969, -1, -1, -1}, {35971, -1, -1, -1}, {35972, -1, -1, -1}, {35974, -1, -1, -1}, {35975, -1, -1, -1}, {35976, -1, -1, -1}, {35979, -1, -1, -1}, {35981, -1, -1, -1}, {35982, -1, -1, -1}, {35983, -1, -1, -1}, {35984, -1, -1, -1}, {35985, -1, -1, -1}, {35986, -1, -1, -1}, {35987, -1, -1, -1}, {35989, -1, -1, -1}, {35990, -1, -1, -1}, {35991, -1, -1, -1}, {35993, -1, -1, -1}, {35994, -1, -1, -1}, {35995, -1, -1, -1}, {35996, -1, -1, -1}, {35999, -1, -1, -1}, {36003, -1, -1, -1}, {36004, -1, -1, -1}, {36005, -1, -1, -1}, {36006, -1, -1, -1}, {36013, -1, -1, -1}, {36014, -1, -1, -1}, {36017, -1, -1, -1}, {36021, -1, -1, -1}, {36025, -1, -1, -1}, {36030, -1, -1, -1}, {36038, -1, -1, -1}, {36041, -1, -1, -1}, {36043, -1, -1, -1}, {36044, -1, -1, -1}, {36045, -1, -1, -1}, {36046, -1, -1, -1}, {36047, -1, -1, -1}, {36048, -1, -1, -1}, {36052, -1, -1, -1}, {36054, -1, -1, -1}, {36055, -1, -1, -1}, {36056, -1, -1, -1}, {36057, -1, -1, -1}, {36059, -1, -1, -1}, {36061, -1, -1, -1}, {36063, -1, -1, -1}, {36069, -1, -1, -1}, {36072, -1, -1, -1}, {36073, -1, -1, -1}, {36078, -1, -1, -1}, {36079, -1, -1, -1}, {36080, -1, -1, -1}, {36081, -1, -1, -1}, {36082, -1, -1, -1}, {36083, -1, -1, -1}, {36085, -1, -1, -1}, {36086, -1, -1, -1}, {36087, -1, -1, -1}, {36088, -1, -1, -1}, {36089, -1, -1, -1}, {36095, -1, -1, -1}, {36096, -1, -1, -1}, {36097, -1, -1, -1}, {36098, -1, -1, -1}, {36099, -1, -1, -1}, {36102, -1, -1, -1}, {36103, -1, -1, -1}, {36105, -1, -1, -1}, {36108, -1, -1, -1}, {36110, -1, -1, -1}, {36113, -1, -1, -1}, {36114, -1, -1, -1}, {36115, -1, -1, -1}, {36116, -1, -1, -1}, {36117, -1, -1, -1}, {36119, -1, -1, -1}, {36120, -1, -1, -1}, {36121, -1, -1, -1}, {36122, -1, -1, -1}, {36128, -1, -1, -1}, {36177, -1, -1, -1}, {36178, -1, -1, -1}, {36183, -1, -1, -1}, {36191, -1, -1, -1}, {36197, -1, -1, -1}, {36200, -1, -1, -1}, {36201, -1, -1, -1}, {36202, -1, -1, -1}, {36204, -1, -1, -1}, {36206, -1, -1, -1}, {36207, -1, -1, -1}, {36209, -1, -1, -1}, {36210, -1, -1, -1}, {36216, -1, -1, -1}, {36217, -1, -1, -1}, {36218, -1, -1, -1}, {36219, -1, -1, -1}, {36220, -1, -1, -1}, {36221, -1, -1, -1}, {36222, -1, -1, -1}, {36223, -1, -1, -1}, {36224, -1, -1, -1}, {36226, -1, -1, -1}, {36227, -1, -1, -1}, {36230, -1, -1, -1}, {36231, -1, -1, -1}, {36232, -1, -1, -1}, {36233, -1, -1, -1}, {36236, -1, -1, -1}, {36237, -1, -1, -1}, {36238, -1, -1, -1}, {36239, -1, -1, -1}, {36240, -1, -1, -1}, {36242, -1, -1, -1}, {36243, -1, -1, -1}, {36246, -1, -1, -1}, {36247, -1, -1, -1}, {36248, -1, -1, -1}, {36250, -1, -1, -1}, {36251, -1, -1, -1}, {36252, -1, -1, -1}, {36253, -1, -1, -1}, {36254, -1, -1, -1}, {36256, -1, -1, -1}, {36257, -1, -1, -1}, {36258, -1, -1, -1}, {36260, -1, -1, -1}, {36261, -1, -1, -1}, {36262, -1, -1, -1}, {36263, -1, -1, -1}, {36265, -1, -1, -1}, {36266, -1, -1, -1}, {36267, -1, -1, -1}, {36268, -1, -1, -1}, {36269, -1, -1, -1}, {36270, -1, -1, -1}, {36271, -1, -1, -1}, {36272, -1, -1, -1}, {36278, -1, -1, -1}, {36279, -1, -1, -1}, {36281, -1, -1, -1}, {36283, -1, -1, -1}, {36285, -1, -1, -1}, {36288, -1, -1, -1}, {36289, -1, -1, -1}, {36290, -1, -1, -1} },
    {{36293, -1, -1, -1}, {36295, -1, -1, -1}, {36296, -1, -1, -1}, {36297, -1, -1, -1}, {36298, -1, -1, -1}, {36301, -1, -1, -1}, {36304, -1, -1, -1}, {36306, -1, -1, -1}, {36307, -1, -1, -1}, {36308, -1, -1, -1}, {36309, -1, -1, -1}, {36312, -1, -1, -1}, {36313, -1, -1, -1}, {36316, -1, -1, -1}, {36320, -1, -1, -1}, {36321, -1, -1, -1}, {36322, -1, -1, -1}, {36325, -1, -1, -1}, {36326, -1, -1, -1}, {36327, -1, -1, -1}, {36329, -1, -1, -1}, {36333, -1, -1, -1}, {36334, -1, -1, -1}, {36336, -1, -1, -1}, {36337, -1, -1, -1}, {36338, -1, -1, -1}, {36340, -1, -1, -1}, {36342, -1, -1, -1}, {36348, -1, -1, -1}, {36350, -1, -1, -1}, {36351, -1, -1, -1}, {36352, -1, -1, -1}, {36353, -1, -1, -1}, {36354, -1, -1, -1}, {36355, -1, -1, -1}, {36356, -1, -1, -1}, {36358, -1, -1, -1}, {36359, -1, -1, -1}, {36360, -1, -1, -1}, {36363, -1, -1, -1}, {36365, -1, -1, -1}, {36366, -1, -1, -1}, {36369, -1, -1, -1}, {36370, -1, -1, -1}, {36371, -1, -1, -1}, {36373, -1, -1, -1}, {36374, -1, -1, -1}, {36375, -1, -1, -1}, {36376, -1, -1, -1}, {36377, -1, -1, -1}, {36378, -1, -1, -1}, {36379, -1, -1, -1}, {36380, -1, -1, -1}, {36384, -1, -1, -1}, {36385, -1, -1, -1}, {36388, -1, -1, -1}, {36389, -1, -1, -1}, {36390, -1, -1, -1}, {36391, -1, -1, -1}, {36392, -1, -1, -1}, {36395, -1, -1, -1}, {36397, -1, -1, -1}, {36400, -1, -1, -1}, {36402, -1, -1, -1}, {36403, -1, -1, -1}, {36406, -1, -1, -1}, {36407, -1, -1, -1}, {36408, -1, -1, -1}, {36411, -1, -1, -1}, {36412, -1, -1, -1}, {36414, -1, -1, -1}, {36415, -1, -1, -1}, {36419, -1, -1, -1}, {36421, -1, -1, -1}, {36422, -1, -1, -1}, {36429, -1, -1, -1}, {36430, -1, -1, -1}, {36431, -1, -1, -1}, {36432, -1, -1, -1}, {36435, -1, -1, -1}, {36436, -1, -1, -1}, {36438, -1, -1, -1}, {36439, -1, -1, -1}, {36440, -1, -1, -1}, {36442, -1, -1, -1}, {36443, -1, -1, -1}, {36444, -1, -1, -1}, {36445, -1, -1, -1}, {36446, -1, -1, -1}, {36447, -1, -1, -1}, {36448, -1, -1, -1}, {36449, -1, -1, -1}, {36450, -1, -1, -1}, {36452, -1, -1, -1}, {36453, -1, -1, -1}, {36455, -1, -1, -1}, {36456, -1, -1, -1}, {36458, -1, -1, -1}, {36459, -1, -1, -1}, {36462, -1, -1, -1}, {36465, -1, -1, -1}, {36467, -1, -1, -1}, {36469, -1, -1, -1}, {36471, -1, -1, -1}, {36472, -1, -1, -1}, {36473, -1, -1, -1}, {36475, -1, -1, -1}, {36477, -1, -1, -1}, {36478, -1, -1, -1}, {36480, -1, -1, -1}, {36482, -1, -1, -1}, {36483, -1, -1, -1}, {36484, -1, -1, -1}, {36486, -1, -1, -1}, {36488, -1, -1, -1}, {36492, -1, -1, -1}, {36494, -1, -1, -1}, {36501, -1, -1, -1}, {36502, -1, -1, -1}, {36503, -1, -1, -1}, {36504, -1, -1, -1}, {36505, -1, -1, -1}, {36507, -1, -1, -1}, {36509, -1, -1, -1}, {36511, -1, -1, -1}, {36512, -1, -1, -1}, {36514, -1, -1, -1}, {36515, -1, -1, -1}, {36516, -1, -1, -1}, {36519, -1, -1, -1}, {36520, -1, -1, -1}, {36521, -1, -1, -1}, {36525, -1, -1, -1}, {36526, -1, -1, -1}, {36528, -1, -1, -1}, {36529, -1, -1, -1}, {36531, -1, -1, -1}, {36532, -1, -1, -1}, {36533, -1, -1, -1}, {36534, -1, -1, -1}, {36535, -1, -1, -1}, {36536, -1, -1, -1}, {36537, -1, -1, -1}, {36539, -1, -1, -1}, {36540, -1, -1, -1}, {36541, -1, -1, -1}, {36542, -1, -1, -1}, {36543, -1, -1, -1}, {36545, -1, -1, -1}, {36546, -1, -1, -1}, {36547, -1, -1, -1}, {36548, -1, -1, -1}, {36549, -1, -1, -1}, {36550, -1, -1, -1}, {36551, -1, -1, -1}, {36552, -1, -1, -1}, {36553, -1, -1, -1}, {36559, -1, -1, -1}, {36560, -1, -1, -1}, {36561, -1, -1, -1}, {36563, -1, -1, -1}, {36565, -1, -1, -1}, {36566, -1, -1, -1}, {36567, -1, -1, -1}, {36568, -1, -1, -1}, {36569, -1, -1, -1}, {36570, -1, -1, -1}, {36572, -1, -1, -1}, {36573, -1, -1, -1}, {36574, -1, -1, -1}, {36576, -1, -1, -1}, {36577, -1, -1, -1}, {36578, -1, -1, -1}, {36579, -1, -1, -1}, {36581, -1, -1, -1}, {36582, -1, -1, -1}, {36583, -1, -1, -1}, {36584, -1, -1, -1}, {36585, -1, -1, -1}, {36586, -1, -1, -1}, {36588, -1, -1, -1}, {36589, -1, -1, -1}, {36590, -1, -1, -1}, {36591, -1, -1, -1}, {36592, -1, -1, -1}, {36593, -1, -1, -1}, {36595, -1, -1, -1}, {36596, -1, -1, -1}, {36597, -1, -1, -1}, {36598, -1, -1, -1}, {36599, -1, -1, -1}, {36605, -1, -1, -1}, {36607, -1, -1, -1}, {36608, -1, -1, -1}, {36609, -1, -1, -1}, {36610, -1, -1, -1}, {36612, -1, -1, -1}, {36614, -1, -1, -1}, {36616, -1, -1, -1}, {36619, -1, -1, -1}, {36620, -1, -1, -1}, {36621, -1, -1, -1}, {36622, -1, -1, -1}, {36623, -1, -1, -1}, {36624, -1, -1, -1}, {36625, -1, -1, -1}, {36627, -1, -1, -1}, {36630, -1, -1, -1}, {36631, -1, -1, -1}, {36632, -1, -1, -1}, {36633, -1, -1, -1}, {36634, -1, -1, -1}, {36640, -1, -1, -1}, {36641, -1, -1, -1}, {36642, -1, -1, -1}, {36643, -1, -1, -1}, {36644, -1, -1, -1}, {36647, -1, -1, -1}, {36648, -1, -1, -1}, {36651, -1, -1, -1}, {36652, -1, -1, -1}, {36653, -1, -1, -1}, {36654, -1, -1, -1}, {36656, -1, -1, -1}, {36657, -1, -1, -1}, {36658, -1, -1, -1}, {36660, -1, -1, -1}, {36661, -1, -1, -1}, {36662, -1, -1, -1}, {36663, -1, -1, -1}, {36665, -1, -1, -1}, {36666, -1, -1, -1}, {36668, -1, -1, -1}, {36669, -1, -1, -1}, {36672, -1, -1, -1}, {36673, -1, -1, -1}, {36675, -1, -1, -1}, {36679, -1, -1, -1}, {36680, -1, -1, -1}, {36682, -1, -1, -1}, {36683, -1, -1, -1}, {36684, -1, -1, -1}, {36687, -1, -1, -1}, {36688, -1, -1, -1}, {36689, -1, -1, -1}, {36690, -1, -1, -1}, {36691, -1, -1, -1}, {36693, -1, -1, -1}, {36694, -1, -1, -1}, {36695, -1, -1, -1}, {36696, -1, -1, -1}, {36697, -1, -1, -1}, {36698, -1, -1, -1}, {36699, -1, -1, -1}, {36700, -1, -1, -1}, {36701, -1, -1, -1} },
    {{36702, -1, -1, -1}, {36704, -1, -1, -1}, {36707, -1, -1, -1}, {36709, -1, -1, -1}, {36714, -1, -1, -1}, {36736, -1, -1, -1}, {36748, -1, -1, -1}, {36754, -1, -1, -1}, {36765, -1, -1, -1}, {36768, -1, -1, -1}, {36769, -1, -1, -1}, {36770, -1, -1, -1}, {36772, -1, -1, -1}, {36773, -1, -1, -1}, {36775, -1, -1, -1}, {36778, -1, -1, -1}, {36780, -1, -1, -1}, {36787, -1, -1, -1}, {36788, -1, -1, -1}, {12193, 36789, -1, -1}, {36791, -1, -1, -1}, {36792, -1, -1, -1}, {36794, -1, -1, -1}, {36795, -1, -1, -1}, {36796, -1, -1, -1}, {36799, -1, -1, -1}, {36800, -1, -1, -1}, {36803, -1, -1, -1}, {36806, -1, -1, -1}, {36809, -1, -1, -1}, {36810, -1, -1, -1}, {36811, -1, -1, -1}, {36812, -1, -1, -1}, {36813, -1, -1, -1}, {36815, -1, -1, -1}, {36818, -1, -1, -1}, {36822, -1, -1, -1}, {36823, -1, -1, -1}, {36826, -1, -1, -1}, {36832, -1, -1, -1}, {36833, -1, -1, -1}, {36835, -1, -1, -1}, {36839, -1, -1, -1}, {36844, -1, -1, -1}, {36847, -1, -1, -1}, {36849, -1, -1, -1}, {36850, -1, -1, -1}, {36853, -1, -1, -1}, {36854, -1, -1, -1}, {36858, -1, -1, -1}, {36859, -1, -1, -1}, {36860, -1, -1, -1}, {36862, -1, -1, -1}, {36863, -1, -1, -1}, {36871, -1, -1, -1}, {36872, -1, -1, -1}, {36876, -1, -1, -1}, {36878, -1, -1, -1}, {36883, -1, -1, -1}, {36888, -1, -1, -1}, {36892, -1, -1, -1}, {36900, -1, -1, -1}, {36901, -1, -1, -1}, {36903, -1, -1, -1}, {36904, -1, -1, -1}, {36905, -1, -1, -1}, {36906, -1, -1, -1}, {36907, -1, -1, -1}, {36908, -1, -1, -1}, {36912, -1, -1, -1}, {36913, -1, -1, -1}, {36915, -1, -1, -1}, {36916, -1, -1, -1}, {36919, -1, -1, -1}, {36921, -1, -1, -1}, {36922, -1, -1, -1}, {36925, -1, -1, -1}, {36927, -1, -1, -1}, {36928, -1, -1, -1}, {36931, -1, -1, -1}, {36933, -1, -1, -1}, {36934, -1, -1, -1}, {36936, -1, -1, -1}, {36937, -1, -1, -1}, {36938, -1, -1, -1}, {36940, -1, -1, -1}, {36950, -1, -1, -1}, {36953, -1, -1, -1}, {36954, -1, -1, -1}, {36957, -1, -1, -1}, {36959, -1, -1, -1}, {36961, -1, -1, -1}, {36964, -1, -1, -1}, {36966, -1, -1, -1}, {36967, -1, -1, -1}, {36970, -1, -1, -1}, {36971, -1, -1, -1}, {36972, -1, -1, -1}, {36975, -1, -1, -1}, {36976, -1, -1, -1}, {36977, -1, -1, -1}, {36979, -1, -1, -1}, {36982, -1, -1, -1}, {36985, -1, -1, -1}, {36987, -1, -1, -1}, {36990, -1, -1, -1}, {36997, -1, -1, -1}, {36998, -1, -1, -1}, {37001, -1, -1, -1}, {37004, -1, -1, -1}, {37005, -1, -1, -1}, {37006, -1, -1, -1}, {37010, -1, -1, -1}, {37012, -1, -1, -1}, {37014, -1, -1, -1}, {37016, -1, -1, -1}, {37018, -1, -1, -1}, {37020, -1, -1, -1}, {37022, -1, -1, -1}, {37023, -1, -1, -1}, {37024, -1, -1, -1}, {37028, -1, -1, -1}, {37029, -1, -1, -1}, {37031, -1, -1, -1}, {37032, -1, -1, -1}, {37033, -1, -1, -1}, {37035, -1, -1, -1}, {37037, -1, -1, -1}, {37042, -1, -1, -1}, {37047, -1, -1, -1}, {37052, -1, -1, -1}, {37053, -1, -1, -1}, {37055, -1, -1, -1}, {37056, -1, -1, -1}, {37058, -1, -1, -1}, {37059, -1, -1, -1}, {37062, -1, -1, -1}, {37064, -1, -1, -1}, {37065, -1, -1, -1}, {37067, -1, -1, -1}, {37068, -1, -1, -1}, {37069, -1, -1, -1}, {37074, -1, -1, -1}, {37076, -1, -1, -1}, {37077, -1, -1, -1}, {37078, -1, -1, -1}, {37080, -1, -1, -1}, {37081, -1, -1, -1}, {37082, -1, -1, -1}, {37086, -1, -1, -1}, {37088, -1, -1, -1}, {37091, -1, -1, -1}, {37092, -1, -1, -1}, {37093, -1, -1, -1}, {37097, -1, -1, -1}, {37098, -1, -1, -1}, {37100, -1, -1, -1}, {37102, -1, -1, -1}, {37104, -1, -1, -1}, {37105, -1, -1, -1}, {37106, -1, -1, -1}, {37107, -1, -1, -1}, {37110, -1, -1, -1}, {37111, -1, -1, -1}, {37113, -1, -1, -1}, {37114, -1, -1, -1}, {37115, -1, -1, -1}, {37116, -1, -1, -1}, {37119, -1, -1, -1}, {37120, -1, -1, -1}, {37121, -1, -1, -1}, {37123, -1, -1, -1}, {37125, -1, -1, -1}, {37127, -1, -1, -1}, {37128, -1, -1, -1}, {37130, -1, -1, -1}, {37131, -1, -1, -1}, {37132, -1, -1, -1}, {37133, -1, -1, -1}, {37134, -1, -1, -1}, {37135, -1, -1, -1}, {37136, -1, -1, -1}, {37137, -1, -1, -1}, {37139, -1, -1, -1}, {37141, -1, -1, -1}, {37143, -1, -1, -1}, {37144, -1, -1, -1}, {37146, -1, -1, -1}, {37147, -1, -1, -1}, {37148, -1, -1, -1}, {37149, -1, -1, -1}, {37151, -1, -1, -1}, {37152, -1, -1, -1}, {37153, -1, -1, -1}, {37156, -1, -1, -1}, {37157, -1, -1, -1}, {37158, -1, -1, -1}, {37160, -1, -1, -1}, {37161, -1, -1, -1}, {37162, -1, -1, -1}, {37163, -1, -1, -1}, {37164, -1, -1, -1}, {37166, -1, -1, -1}, {37171, -1, -1, -1}, {37173, -1, -1, -1}, {37175, -1, -1, -1}, {37176, -1, -1, -1}, {37179, -1, -1, -1}, {37180, -1, -1, -1}, {37181, -1, -1, -1}, {37182, -1, -1, -1}, {37183, -1, -1, -1}, {37184, -1, -1, -1}, {37185, -1, -1, -1}, {37186, -1, -1, -1}, {37188, -1, -1, -1}, {37189, -1, -1, -1}, {37191, -1, -1, -1}, {37201, -1, -1, -1}, {37203, -1, -1, -1}, {37204, -1, -1, -1}, {37205, -1, -1, -1}, {37206, -1, -1, -1}, {37208, -1, -1, -1}, {37209, -1, -1, -1}, {37211, -1, -1, -1}, {37212, -1, -1, -1}, {37215, -1, -1, -1}, {37216, -1, -1, -1}, {37222, -1, -1, -1}, {37223, -1, -1, -1}, {37224, -1, -1, -1}, {37227, -1, -1, -1}, {37229, -1, -1, -1}, {37235, -1, -1, -1}, {37242, -1, -1, -1}, {37243, -1, -1, -1}, {37244, -1, -1, -1}, {37248, -1, -1, -1}, {37249, -1, -1, -1}, {37250, -1, -1, -1}, {37251, -1, -1, -1}, {37252, -1, -1, -1}, {37254, -1, -1, -1}, {37256, -1, -1, -1}, {37258, -1, -1, -1}, {37262, -1, -1, -1}, {37263, -1, -1, -1}, {37267, -1, -1, -1}, {37268, -1, -1, -1}, {37269, -1, -1, -1}, {37271, -1, -1, -1}, {37272, -1, -1, -1}, {37273, -1, -1, -1}, {37277, -1, -1, -1}, {37278, -1, -1, -1} },
    {{37279, -1, -1, -1}, {37280, -1, -1, -1}, {37281, -1, -1, -1}, {37284, -1, -1, -1}, {37285, -1, -1, -1}, {37286, -1, -1, -1}, {37287, -1, -1, -1}, {37288, -1, -1, -1}, {37289, -1, -1, -1}, {37296, -1, -1, -1}, {37297, -1, -1, -1}, {37298, -1, -1, -1}, {37299, -1, -1, -1}, {37302, -1, -1, -1}, {37303, -1, -1, -1}, {37304, -1, -1, -1}, {37305, -1, -1, -1}, {37307, -1, -1, -1}, {37308, -1, -1, -1}, {37309, -1, -1, -1}, {37310, -1, -1, -1}, {37311, -1, -1, -1}, {37314, -1, -1, -1}, {37316, -1, -1, -1}, {12196, 37318, -1, -1}, {37320, -1, -1, -1}, {37328, -1, -1, -1}, {37334, -1, -1, -1}, {37338, -1, -1, -1}, {37339, -1, -1, -1}, {37342, -1, -1, -1}, {37343, -1, -1, -1}, {37344, -1, -1, -1}, {37345, -1, -1, -1}, {37346, -1, -1, -1}, {37349, -1, -1, -1}, {37350, -1, -1, -1}, {37352, -1, -1, -1}, {37354, -1, -1, -1}, {37355, -1, -1, -1}, {37356, -1, -1, -1}, {37357, -1, -1, -1}, {37358, -1, -1, -1}, {37359, -1, -1, -1}, {37360, -1, -1, -1}, {37361, -1, -1, -1}, {37362, -1, -1, -1}, {37363, -1, -1, -1}, {37364, -1, -1, -1}, {37366, -1, -1, -1}, {37368, -1, -1, -1}, {37371, -1, -1, -1}, {37372, -1, -1, -1}, {37373, -1, -1, -1}, {37374, -1, -1, -1}, {37375, -1, -1, -1}, {37378, -1, -1, -1}, {37379, -1, -1, -1}, {37381, -1, -1, -1}, {37382, -1, -1, -1}, {37383, -1, -1, -1}, {37386, -1, -1, -1}, {37387, -1, -1, -1}, {37388, -1, -1, -1}, {37391, -1, -1, -1}, {37394, -1, -1, -1}, {37395, -1, -1, -1}, {37398, -1, -1, -1}, {37399, -1, -1, -1}, {37400, -1, -1, -1}, {37401, -1, -1, -1}, {37402, -1, -1, -1}, {37403, -1, -1, -1}, {37404, -1, -1, -1}, {37405, -1, -1, -1}, {37407, -1, -1, -1}, {37408, -1, -1, -1}, {37409, -1, -1, -1}, {37410, -1, -1, -1}, {37412, -1, -1, -1}, {37416, -1, -1, -1}, {37417, -1, -1, -1}, {37418, -1, -1, -1}, {37419, -1, -1, -1}, {37420, -1, -1, -1}, {37421, -1, -1, -1}, {37423, -1, -1, -1}, {37425, -1, -1, -1}, {37426, -1, -1, -1}, {37429, -1, -1, -1}, {37430, -1, -1, -1}, {37435, -1, -1, -1}, {37436, -1, -1, -1}, {37441, -1, -1, -1}, {37442, -1, -1, -1}, {37443, -1, -1, -1}, {37444, -1, -1, -1}, {37446, -1, -1, -1}, {37447, -1, -1, -1}, {37450, -1, -1, -1}, {37451, -1, -1, -1}, {37452, -1, -1, -1}, {37454, -1, -1, -1}, {37455, -1, -1, -1}, {37456, -1, -1, -1}, {37458, -1, -1, -1}, {37459, -1, -1, -1}, {37460, -1, -1, -1}, {37462, -1, -1, -1}, {37464, -1, -1, -1}, {37465, -1, -1, -1}, {37468, -1, -1, -1}, {37469, -1, -1, -1}, {37471, -1, -1, -1}, {37472, -1, -1, -1}, {37473, -1, -1, -1}, {37475, -1, -1, -1}, {37476, -1, -1, -1}, {37477, -1, -1, -1}, {37479, -1, -1, -1}, {37480, -1, -1, -1}, {37481, -1, -1, -1}, {37482, -1, -1, -1}, {37483, -1, -1, -1}, {37486, -1, -1, -1}, {37487, -1, -1, -1}, {37488, -1, -1, -1}, {37489, -1, -1, -1}, {37490, -1, -1, -1}, {37491, -1, -1, -1}, {37493, -1, -1, -1}, {37494, -1, -1, -1}, {37495, -1, -1, -1}, {37497, -1, -1, -1}, {37500, -1, -1, -1}, {37501, -1, -1, -1}, {37502, -1, -1, -1}, {37505, -1, -1, -1}, {37506, -1, -1, -1}, {37508, -1, -1, -1}, {37510, -1, -1, -1}, {37511, -1, -1, -1}, {37512, -1, -1, -1}, {37513, -1, -1, -1}, {37514, -1, -1, -1}, {37515, -1, -1, -1}, {37516, -1, -1, -1}, {37517, -1, -1, -1}, {37519, -1, -1, -1}, {37520, -1, -1, -1}, {37522, -1, -1, -1}, {37524, -1, -1, -1}, {37525, -1, -1, -1}, {37527, -1, -1, -1}, {37529, -1, -1, -1}, {37531, -1, -1, -1}, {37533, -1, -1, -1}, {37534, -1, -1, -1}, {37535, -1, -1, -1}, {37537, -1, -1, -1}, {37538, -1, -1, -1}, {37540, -1, -1, -1}, {37543, -1, -1, -1}, {37549, -1, -1, -1}, {37551, -1, -1, -1}, {37552, -1, -1, -1}, {37554, -1, -1, -1}, {37555, -1, -1, -1}, {37556, -1, -1, -1}, {37557, -1, -1, -1}, {37558, -1, -1, -1}, {37560, -1, -1, -1}, {37562, -1, -1, -1}, {37565, -1, -1, -1}, {37566, -1, -1, -1}, {37567, -1, -1, -1}, {37568, -1, -1, -1}, {37570, -1, -1, -1}, {37572, -1, -1, -1}, {37574, -1, -1, -1}, {37577, -1, -1, -1}, {37578, -1, -1, -1}, {37579, -1, -1, -1}, {37581, -1, -1, -1}, {37582, -1, -1, -1}, {37584, -1, -1, -1}, {37585, -1, -1, -1}, {37587, -1, -1, -1}, {37588, -1, -1, -1}, {37589, -1, -1, -1}, {37590, -1, -1, -1}, {37591, -1, -1, -1}, {37592, -1, -1, -1}, {37593, -1, -1, -1}, {37594, -1, -1, -1}, {37595, -1, -1, -1}, {37596, -1, -1, -1}, {37598, -1, -1, -1}, {37600, -1, -1, -1}, {37601, -1, -1, -1}, {37602, -1, -1, -1}, {37607, -1, -1, -1}, {37609, -1, -1, -1}, {37611, -1, -1, -1}, {37612, -1, -1, -1}, {37618, -1, -1, -1}, {37619, -1, -1, -1}, {37620, -1, -1, -1}, {37621, -1, -1, -1}, {37623, -1, -1, -1}, {37625, -1, -1, -1}, {37626, -1, -1, -1}, {37627, -1, -1, -1}, {37629, -1, -1, -1}, {37630, -1, -1, -1}, {37631, -1, -1, -1}, {37632, -1, -1, -1}, {37634, -1, -1, -1}, {37635, -1, -1, -1}, {37636, -1, -1, -1}, {37637, -1, -1, -1}, {37641, -1, -1, -1}, {37642, -1, -1, -1}, {37643, -1, -1, -1}, {37644, -1, -1, -1}, {37645, -1, -1, -1}, {37646, -1, -1, -1}, {37647, -1, -1, -1}, {37649, -1, -1, -1}, {37651, -1, -1, -1}, {37652, -1, -1, -1}, {37654, -1, -1, -1}, {37655, -1, -1, -1}, {37660, -1, -1, -1}, {37661, -1, -1, -1}, {37662, -1, -1, -1}, {37665, -1, -1, -1}, {37667, -1, -1, -1}, {37668, -1, -1, -1}, {37669, -1, -1, -1}, {37671, -1, -1, -1}, {37673, -1, -1, -1}, {37674, -1, -1, -1}, {37676, -1, -1, -1}, {37677, -1, -1, -1}, {37680, -1, -1, -1}, {37681, -1, -1, -1}, {37684, -1, -1, -1}, {37685, -1, -1, -1}, {37687, -1, -1, -1}, {37689, -1, -1, -1}, {37690, -1, -1, -1}, {37691, -1, -1, -1}, {37692, -1, -1, -1}, {37693, -1, -1, -1}, {37695, -1, -1, -1} },
    {{37698, -1, -1, -1}, {37700, -1, -1, -1}, {37701, -1, -1, -1}, {37704, -1, -1, -1}, {37705, -1, -1, -1}, {37706, -1, -1, -1}, {37708, -1, -1, -1}, {37710, -1, -1, -1}, {37711, -1, -1, -1}, {37712, -1, -1, -1}, {37713, -1, -1, -1}, {37714, -1, -1, -1}, {37715, -1, -1, -1}, {37717, -1, -1, -1}, {37718, -1, -1, -1}, {37719, -1, -1, -1}, {37721, -1, -1, -1}, {37722, -1, -1, -1}, {37724, -1, -1, -1}, {37725, -1, -1, -1}, {37726, -1, -1, -1}, {37727, -1, -1, -1}, {37728, -1, -1, -1}, {37729, -1, -1, -1}, {37730, -1, -1, -1}, {37731, -1, -1, -1}, {37734, -1, -1, -1}, {37735, -1, -1, -1}, {37736, -1, -1, -1}, {37739, -1, -1, -1}, {37741, -1, -1, -1}, {37742, -1, -1, -1}, {37743, -1, -1, -1}, {37745, -1, -1, -1}, {37746, -1, -1, -1}, {37747, -1, -1, -1}, {37748, -1, -1, -1}, {37751, -1, -1, -1}, {37752, -1, -1, -1}, {37753, -1, -1, -1}, {37755, -1, -1, -1}, {37756, -1, -1, -1}, {37757, -1, -1, -1}, {37759, -1, -1, -1}, {37760, -1, -1, -1}, {37761, -1, -1, -1}, {37763, -1, -1, -1}, {37765, -1, -1, -1}, {37766, -1, -1, -1}, {37768, -1, -1, -1}, {37769, -1, -1, -1}, {37771, -1, -1, -1}, {37772, -1, -1, -1}, {37773, -1, -1, -1}, {37774, -1, -1, -1}, {37776, -1, -1, -1}, {37777, -1, -1, -1}, {37778, -1, -1, -1}, {37779, -1, -1, -1}, {37780, -1, -1, -1}, {37781, -1, -1, -1}, {37783, -1, -1, -1}, {37785, -1, -1, -1}, {37786, -1, -1, -1}, {37787, -1, -1, -1}, {37788, -1, -1, -1}, {37789, -1, -1, -1}, {37790, -1, -1, -1}, {37791, -1, -1, -1}, {37792, -1, -1, -1}, {37793, -1, -1, -1}, {37796, -1, -1, -1}, {37797, -1, -1, -1}, {37800, -1, -1, -1}, {37803, -1, -1, -1}, {37805, -1, -1, -1}, {37807, -1, -1, -1}, {37809, -1, -1, -1}, {37810, -1, -1, -1}, {37812, -1, -1, -1}, {37814, -1, -1, -1}, {37815, -1, -1, -1}, {37817, -1, -1, -1}, {37818, -1, -1, -1}, {37819, -1, -1, -1}, {37820, -1, -1, -1}, {37821, -1, -1, -1}, {37822, -1, -1, -1}, {37824, -1, -1, -1}, {37825, -1, -1, -1}, {37826, -1, -1, -1}, {37828, -1, -1, -1}, {37829, -1, -1, -1}, {37830, -1, -1, -1}, {37833, -1, -1, -1}, {37835, -1, -1, -1}, {37838, -1, -1, -1}, {37839, -1, -1, -1}, {37840, -1, -1, -1}, {37842, -1, -1, -1}, {37843, -1, -1, -1}, {37844, -1, -1, -1}, {37845, -1, -1, -1}, {37849, -1, -1, -1}, {37850, -1, -1, -1}, {37851, -1, -1, -1}, {37856, -1, -1, -1}, {37859, -1, -1, -1}, {37861, -1, -1, -1}, {37862, -1, -1, -1}, {37863, -1, -1, -1}, {37865, -1, -1, -1}, {37866, -1, -1, -1}, {37867, -1, -1, -1}, {37868, -1, -1, -1}, {37869, -1, -1, -1}, {37870, -1, -1, -1}, {37871, -1, -1, -1}, {37872, -1, -1, -1}, {37873, -1, -1, -1}, {37874, -1, -1, -1}, {37875, -1, -1, -1}, {37876, -1, -1, -1}, {37878, -1, -1, -1}, {37880, -1, -1, -1}, {37882, -1, -1, -1}, {37883, -1, -1, -1}, {37884, -1, -1, -1}, {37885, -1, -1, -1}, {37886, -1, -1, -1}, {37887, -1, -1, -1}, {37888, -1, -1, -1}, {37889, -1, -1, -1}, {37890, -1, -1, -1}, {37892, -1, -1, -1}, {37893, -1, -1, -1}, {37894, -1, -1, -1}, {37895, -1, -1, -1}, {37896, -1, -1, -1}, {37897, -1, -1, -1}, {37898, -1, -1, -1}, {37900, -1, -1, -1}, {37901, -1, -1, -1}, {37902, -1, -1, -1}, {37903, -1, -1, -1}, {37905, -1, -1, -1}, {37909, -1, -1, -1}, {37910, -1, -1, -1}, {37911, -1, -1, -1}, {37914, -1, -1, -1}, {37915, -1, -1, -1}, {37916, -1, -1, -1}, {37918, -1, -1, -1}, {37919, -1, -1, -1}, {37921, -1, -1, -1}, {37922, -1, -1, -1}, {37923, -1, -1, -1}, {37924, -1, -1, -1}, {37925, -1, -1, -1}, {37929, -1, -1, -1}, {37930, -1, -1, -1}, {37931, -1, -1, -1}, {37932, -1, -1, -1}, {37933, -1, -1, -1}, {37935, -1, -1, -1}, {37936, -1, -1, -1}, {37937, -1, -1, -1}, {37940, -1, -1, -1}, {37942, -1, -1, -1}, {37943, -1, -1, -1}, {37945, -1, -1, -1}, {37947, -1, -1, -1}, {37948, -1, -1, -1}, {37949, -1, -1, -1}, {37952, -1, -1, -1}, {37953, -1, -1, -1}, {37954, -1, -1, -1}, {37955, -1, -1, -1}, {37957, -1, -1, -1}, {37958, -1, -1, -1}, {37959, -1, -1, -1}, {37960, -1, -1, -1}, {37961, -1, -1, -1}, {37963, -1, -1, -1}, {37965, -1, -1, -1}, {37966, -1, -1, -1}, {37967, -1, -1, -1}, {37968, -1, -1, -1}, {37969, -1, -1, -1}, {37971, -1, -1, -1}, {37973, -1, -1, -1}, {37974, -1, -1, -1}, {37975, -1, -1, -1}, {37976, -1, -1, -1}, {37977, -1, -1, -1}, {37978, -1, -1, -1}, {37979, -1, -1, -1}, {37980, -1, -1, -1}, {37981, -1, -1, -1}, {37982, -1, -1, -1}, {37983, -1, -1, -1}, {37985, -1, -1, -1}, {37986, -1, -1, -1}, {37988, -1, -1, -1}, {37990, -1, -1, -1}, {37991, -1, -1, -1}, {37992, -1, -1, -1}, {37993, -1, -1, -1}, {37994, -1, -1, -1}, {37996, -1, -1, -1}, {37998, -1, -1, -1}, {37999, -1, -1, -1}, {38001, -1, -1, -1}, {38003, -1, -1, -1}, {38004, -1, -1, -1}, {38005, -1, -1, -1}, {38006, -1, -1, -1}, {38008, -1, -1, -1}, {38010, -1, -1, -1}, {38011, -1, -1, -1}, {38016, -1, -1, -1}, {38017, -1, -1, -1}, {38018, -1, -1, -1}, {38019, -1, -1, -1}, {38020, -1, -1, -1}, {38033, -1, -1, -1}, {38038, -1, -1, -1}, {38040, -1, -1, -1}, {38087, -1, -1, -1}, {38095, -1, -1, -1}, {38099, -1, -1, -1}, {38100, -1, -1, -1}, {38106, -1, -1, -1}, {38118, -1, -1, -1}, {38139, -1, -1, -1}, {38172, -1, -1, -1}, {38176, -1, -1, -1}, {38183, -1, -1, -1}, {38195, -1, -1, -1}, {38205, -1, -1, -1}, {38211, -1, -1, -1}, {38216, -1, -1, -1}, {38219, -1, -1, -1}, {38229, -1, -1, -1}, {38234, -1, -1, -1}, {38240, -1, -1, -1}, {38254, -1, -1, -1}, {38260, -1, -1, -1}, {38261, -1, -1, -1}, {38264, -1, -1, -1}, {38265, -1, -1, -1}, {38266, -1, -1, -1}, {38267, -1, -1, -1}, {38268, -1, -1, -1}, {38269, -1, -1, -1}, {38270, -1, -1, -1} },
    {{38273, -1, -1, -1}, {38276, -1, -1, -1}, {38277, -1, -1, -1}, {38279, -1, -1, -1}, {38280, -1, -1, -1}, {38282, -1, -1, -1}, {38285, -1, -1, -1}, {38288, -1, -1, -1}, {38290, -1, -1, -1}, {38293, -1, -1, -1}, {38294, -1, -1, -1}, {38295, -1, -1, -1}, {38297, -1, -1, -1}, {38298, -1, -1, -1}, {38299, -1, -1, -1}, {38300, -1, -1, -1}, {38301, -1, -1, -1}, {38302, -1, -1, -1}, {38303, -1, -1, -1}, {38304, -1, -1, -1}, {38306, -1, -1, -1}, {38310, -1, -1, -1}, {38311, -1, -1, -1}, {38314, -1, -1, -1}, {38318, -1, -1, -1}, {38319, -1, -1, -1}, {38320, -1, -1, -1}, {38321, -1, -1, -1}, {38323, -1, -1, -1}, {38324, -1, -1, -1}, {38325, -1, -1, -1}, {38327, -1, -1, -1}, {38328, -1, -1, -1}, {38330, -1, -1, -1}, {38336, -1, -1, -1}, {38337, -1, -1, -1}, {38338, -1, -1, -1}, {38340, -1, -1, -1}, {38341, -1, -1, -1}, {38343, -1, -1, -1}, {38345, -1, -1, -1}, {38349, -1, -1, -1}, {38350, -1, -1, -1}, {38351, -1, -1, -1}, {38353, -1, -1, -1}, {38354, -1, -1, -1}, {38355, -1, -1, -1}, {38359, -1, -1, -1}, {38360, -1, -1, -1}, {38361, -1, -1, -1}, {38362, -1, -1, -1}, {38363, -1, -1, -1}, {38365, -1, -1, -1}, {38367, -1, -1, -1}, {38368, -1, -1, -1}, {38371, -1, -1, -1}, {38372, -1, -1, -1}, {38374, -1, -1, -1}, {38375, -1, -1, -1}, {38380, -1, -1, -1}, {38399, -1, -1, -1}, {38407, -1, -1, -1}, {38419, -1, -1, -1}, {38424, -1, -1, -1}, {38427, -1, -1, -1}, {38430, -1, -1, -1}, {38432, -1, -1, -1}, {38435, -1, -1, -1}, {38436, -1, -1, -1}, {38437, -1, -1, -1}, {38438, -1, -1, -1}, {38439, -1, -1, -1}, {38440, -1, -1, -1}, {38441, -1, -1, -1}, {38443, -1, -1, -1}, {38444, -1, -1, -1}, {38445, -1, -1, -1}, {38447, -1, -1, -1}, {38448, -1, -1, -1}, {38455, -1, -1, -1}, {38456, -1, -1, -1}, {38457, -1, -1, -1}, {38458, -1, -1, -1}, {38462, -1, -1, -1}, {38465, -1, -1, -1}, {38467, -1, -1, -1}, {38474, -1, -1, -1}, {38478, -1, -1, -1}, {38479, -1, -1, -1}, {38481, -1, -1, -1}, {38482, -1, -1, -1}, {38483, -1, -1, -1}, {38486, -1, -1, -1}, {38487, -1, -1, -1}, {38489, -1, -1, -1}, {38490, -1, -1, -1}, {38492, -1, -1, -1}, {38494, -1, -1, -1}, {38496, -1, -1, -1}, {38501, -1, -1, -1}, {38502, -1, -1, -1}, {38507, -1, -1, -1}, {38509, -1, -1, -1}, {38510, -1, -1, -1}, {38511, -1, -1, -1}, {38513, -1, -1, -1}, {38521, -1, -1, -1}, {38522, -1, -1, -1}, {38523, -1, -1, -1}, {38524, -1, -1, -1}, {38526, -1, -1, -1}, {38527, -1, -1, -1}, {38528, -1, -1, -1}, {38529, -1, -1, -1}, {38530, -1, -1, -1}, {38531, -1, -1, -1}, {38532, -1, -1, -1}, {38535, -1, -1, -1}, {38537, -1, -1, -1}, {38540, -1, -1, -1}, {38545, -1, -1, -1}, {38546, -1, -1, -1}, {38547, -1, -1, -1}, {38550, -1, -1, -1}, {38554, -1, -1, -1}, {38557, -1, -1, -1}, {38558, -1, -1, -1}, {38559, -1, -1, -1}, {38560, -1, -1, -1}, {38561, -1, -1, -1}, {38562, -1, -1, -1}, {38563, -1, -1, -1}, {38564, -1, -1, -1}, {38565, -1, -1, -1}, {38566, -1, -1, -1}, {38569, -1, -1, -1}, {38571, -1, -1, -1}, {38572, -1, -1, -1}, {38573, -1, -1, -1}, {38574, -1, -1, -1}, {38575, -1, -1, -1}, {38578, -1, -1, -1}, {38581, -1, -1, -1}, {38583, -1, -1, -1}, {38586, -1, -1, -1}, {38591, -1, -1, -1}, {38594, -1, -1, -1}, {38595, -1, -1, -1}, {38600, -1, -1, -1}, {38602, -1, -1, -1}, {38603, -1, -1, -1}, {38608, -1, -1, -1}, {38609, -1, -1, -1}, {38611, -1, -1, -1}, {38612, -1, -1, -1}, {38615, -1, -1, -1}, {38616, -1, -1, -1}, {38618, -1, -1, -1}, {38621, -1, -1, -1}, {38622, -1, -1, -1}, {38623, -1, -1, -1}, {38625, -1, -1, -1}, {38628, -1, -1, -1}, {38629, -1, -1, -1}, {38630, -1, -1, -1}, {38631, -1, -1, -1}, {38635, -1, -1, -1}, {38636, -1, -1, -1}, {38637, -1, -1, -1}, {38638, -1, -1, -1}, {38640, -1, -1, -1}, {38641, -1, -1, -1}, {38644, -1, -1, -1}, {38645, -1, -1, -1}, {38648, -1, -1, -1}, {38650, -1, -1, -1}, {38652, -1, -1, -1}, {38653, -1, -1, -1}, {38655, -1, -1, -1}, {38658, -1, -1, -1}, {38659, -1, -1, -1}, {38661, -1, -1, -1}, {38666, -1, -1, -1}, {38667, -1, -1, -1}, {38668, -1, -1, -1}, {38672, -1, -1, -1}, {38673, -1, -1, -1}, {38674, -1, -1, -1}, {38676, -1, -1, -1}, {38677, -1, -1, -1}, {38679, -1, -1, -1}, {38680, -1, -1, -1}, {38681, -1, -1, -1}, {38682, -1, -1, -1}, {38683, -1, -1, -1}, {38685, -1, -1, -1}, {38687, -1, -1, -1}, {38688, -1, -1, -1}, {38689, -1, -1, -1}, {38690, -1, -1, -1}, {38691, -1, -1, -1}, {38692, -1, -1, -1}, {38693, -1, -1, -1}, {38694, -1, -1, -1}, {38696, -1, -1, -1}, {38697, -1, -1, -1}, {38699, -1, -1, -1}, {38700, -1, -1, -1}, {38702, -1, -1, -1}, {38703, -1, -1, -1}, {38705, -1, -1, -1}, {38707, -1, -1, -1}, {38708, -1, -1, -1}, {38709, -1, -1, -1}, {38710, -1, -1, -1}, {38711, -1, -1, -1}, {38714, -1, -1, -1}, {38715, -1, -1, -1}, {38716, -1, -1, -1}, {38719, -1, -1, -1}, {38720, -1, -1, -1}, {38721, -1, -1, -1}, {38723, -1, -1, -1}, {38725, -1, -1, -1}, {38726, -1, -1, -1}, {38727, -1, -1, -1}, {38729, -1, -1, -1}, {38730, -1, -1, -1}, {38731, -1, -1, -1}, {38732, -1, -1, -1}, {38733, -1, -1, -1}, {38734, -1, -1, -1}, {38735, -1, -1, -1}, {38736, -1, -1, -1}, {12205, 38737, -1, -1}, {38740, -1, -1, -1}, {38741, -1, -1, -1}, {38743, -1, -1, -1}, {38744, -1, -1, -1}, {38748, -1, -1, -1}, {38749, -1, -1, -1}, {38751, -1, -1, -1}, {38755, -1, -1, -1}, {38756, -1, -1, -1}, {38758, -1, -1, -1}, {38759, -1, -1, -1}, {38762, -1, -1, -1}, {38763, -1, -1, -1}, {38764, -1, -1, -1}, {38765, -1, -1, -1}, {38766, -1, -1, -1}, {38767, -1, -1, -1}, {38768, -1, -1, -1}, {38769, -1, -1, -1}, {38770, -1, -1, -1}, {38773, -1, -1, -1} },
    {{38775, -1, -1, -1}, {38776, -1, -1, -1}, {38777, -1, -1, -1}, {38778, -1, -1, -1}, {38779, -1, -1, -1}, {38781, -1, -1, -1}, {38782, -1, -1, -1}, {38783, -1, -1, -1}, {38784, -1, -1, -1}, {38785, -1, -1, -1}, {38786, -1, -1, -1}, {38787, -1, -1, -1}, {38788, -1, -1, -1}, {38790, -1, -1, -1}, {38791, -1, -1, -1}, {38792, -1, -1, -1}, {38793, -1, -1, -1}, {38794, -1, -1, -1}, {38796, -1, -1, -1}, {38798, -1, -1, -1}, {38800, -1, -1, -1}, {38803, -1, -1, -1}, {38805, -1, -1, -1}, {38806, -1, -1, -1}, {38807, -1, -1, -1}, {38809, -1, -1, -1}, {38810, -1, -1, -1}, {38811, -1, -1, -1}, {38812, -1, -1, -1}, {38813, -1, -1, -1}, {38814, -1, -1, -1}, {38815, -1, -1, -1}, {38817, -1, -1, -1}, {38818, -1, -1, -1}, {38820, -1, -1, -1}, {38821, -1, -1, -1}, {38823, -1, -1, -1}, {38824, -1, -1, -1}, {38825, -1, -1, -1}, {38826, -1, -1, -1}, {38828, -1, -1, -1}, {38830, -1, -1, -1}, {38832, -1, -1, -1}, {38833, -1, -1, -1}, {38835, -1, -1, -1}, {38837, -1, -1, -1}, {38838, -1, -1, -1}, {38839, -1, -1, -1}, {38840, -1, -1, -1}, {38841, -1, -1, -1}, {38842, -1, -1, -1}, {38843, -1, -1, -1}, {38844, -1, -1, -1}, {38846, -1, -1, -1}, {38847, -1, -1, -1}, {38848, -1, -1, -1}, {38849, -1, -1, -1}, {38850, -1, -1, -1}, {38852, -1, -1, -1}, {38853, -1, -1, -1}, {38855, -1, -1, -1}, {38856, -1, -1, -1}, {38858, -1, -1, -1}, {38861, -1, -1, -1}, {38862, -1, -1, -1}, {38863, -1, -1, -1}, {38864, -1, -1, -1}, {38865, -1, -1, -1}, {38866, -1, -1, -1}, {38868, -1, -1, -1}, {38869, -1, -1, -1}, {38870, -1, -1, -1}, {38871, -1, -1, -1}, {38872, -1, -1, -1}, {38874, -1, -1, -1}, {38875, -1, -1, -1}, {38877, -1, -1, -1}, {38879, -1, -1, -1}, {38880, -1, -1, -1}, {38881, -1, -1, -1}, {38882, -1, -1, -1}, {38883, -1, -1, -1}, {38884, -1, -1, -1}, {38885, -1, -1, -1}, {38888, -1, -1, -1}, {38894, -1, -1, -1}, {38895, -1, -1, -1}, {38896, -1, -1, -1}, {38897, -1, -1, -1}, {38898, -1, -1, -1}, {38900, -1, -1, -1}, {38903, -1, -1, -1}, {38904, -1, -1, -1}, {38905, -1, -1, -1}, {38906, -1, -1, -1}, {38907, -1, -1, -1}, {38908, -1, -1, -1}, {38909, -1, -1, -1}, {38910, -1, -1, -1}, {38912, -1, -1, -1}, {38916, -1, -1, -1}, {38921, -1, -1, -1}, {38923, -1, -1, -1}, {38925, -1, -1, -1}, {38932, -1, -1, -1}, {38933, -1, -1, -1}, {38934, -1, -1, -1}, {38937, -1, -1, -1}, {38938, -1, -1, -1}, {38939, -1, -1, -1}, {38941, -1, -1, -1}, {38942, -1, -1, -1}, {38943, -1, -1, -1}, {38944, -1, -1, -1}, {38946, -1, -1, -1}, {38947, -1, -1, -1}, {38949, -1, -1, -1}, {38951, -1, -1, -1}, {38952, -1, -1, -1}, {38953, -1, -1, -1}, {38954, -1, -1, -1}, {38955, -1, -1, -1}, {38956, -1, -1, -1}, {38958, -1, -1, -1}, {38959, -1, -1, -1}, {38961, -1, -1, -1}, {38962, -1, -1, -1}, {38963, -1, -1, -1}, {38964, -1, -1, -1}, {38965, -1, -1, -1}, {38966, -1, -1, -1}, {38969, -1, -1, -1}, {38970, -1, -1, -1}, {38972, -1, -1, -1}, {38974, -1, -1, -1}, {38975, -1, -1, -1}, {38976, -1, -1, -1}, {38977, -1, -1, -1}, {38978, -1, -1, -1}, {38979, -1, -1, -1}, {38980, -1, -1, -1}, {38981, -1, -1, -1}, {38983, -1, -1, -1}, {38984, -1, -1, -1}, {38985, -1, -1, -1}, {38986, -1, -1, -1}, {38987, -1, -1, -1}, {38991, -1, -1, -1}, {38992, -1, -1, -1}, {38993, -1, -1, -1}, {38994, -1, -1, -1}, {38997, -1, -1, -1}, {38998, -1, -1, -1}, {38999, -1, -1, -1}, {39002, -1, -1, -1}, {39004, -1, -1, -1}, {39005, -1, -1, -1}, {39007, -1, -1, -1}, {39008, -1, -1, -1}, {39009, -1, -1, -1}, {39011, -1, -1, -1}, {39012, -1, -1, -1}, {39014, -1, -1, -1}, {39016, -1, -1, -1}, {39017, -1, -1, -1}, {39018, -1, -1, -1}, {39021, -1, -1, -1}, {39022, -1, -1, -1}, {39026, -1, -1, -1}, {39051, -1, -1, -1}, {39054, -1, -1, -1}, {39058, -1, -1, -1}, {39061, -1, -1, -1}, {39065, -1, -1, -1}, {39075, -1, -1, -1}, {39081, -1, -1, -1}, {39082, -1, -1, -1}, {39083, -1, -1, -1}, {39084, -1, -1, -1}, {39085, -1, -1, -1}, {39088, -1, -1, -1}, {39090, -1, -1, -1}, {39092, -1, -1, -1}, {39093, -1, -1, -1}, {39095, -1, -1, -1}, {39096, -1, -1, -1}, {39097, -1, -1, -1}, {39098, -1, -1, -1}, {39099, -1, -1, -1}, {39101, -1, -1, -1}, {39102, -1, -1, -1}, {39103, -1, -1, -1}, {39104, -1, -1, -1}, {39105, -1, -1, -1}, {39106, -1, -1, -1}, {39107, -1, -1, -1}, {39109, -1, -1, -1}, {39111, -1, -1, -1}, {39113, -1, -1, -1}, {39114, -1, -1, -1}, {39115, -1, -1, -1}, {39116, -1, -1, -1}, {39117, -1, -1, -1}, {39119, -1, -1, -1}, {39120, -1, -1, -1}, {39124, -1, -1, -1}, {39126, -1, -1, -1}, {39127, -1, -1, -1}, {39132, -1, -1, -1}, {39133, -1, -1, -1}, {39137, -1, -1, -1}, {39139, -1, -1, -1}, {39140, -1, -1, -1}, {39141, -1, -1, -1}, {39142, -1, -1, -1}, {39148, -1, -1, -1}, {39150, -1, -1, -1}, {39152, -1, -1, -1}, {39153, -1, -1, -1}, {39155, -1, -1, -1}, {39157, -1, -1, -1}, {39158, -1, -1, -1}, {39159, -1, -1, -1}, {39160, -1, -1, -1}, {39161, -1, -1, -1}, {39162, -1, -1, -1}, {39163, -1, -1, -1}, {39167, -1, -1, -1}, {39168, -1, -1, -1}, {39169, -1, -1, -1}, {39170, -1, -1, -1}, {39172, -1, -1, -1}, {39174, -1, -1, -1}, {39175, -1, -1, -1}, {39176, -1, -1, -1}, {39179, -1, -1, -1}, {39182, -1, -1, -1}, {39183, -1, -1, -1}, {39188, -1, -1, -1}, {39189, -1, -1, -1}, {39190, -1, -1, -1}, {39191, -1, -1, -1}, {39193, -1, -1, -1}, {39194, -1, -1, -1}, {39196, -1, -1, -1}, {39197, -1, -1, -1}, {39199, -1, -1, -1}, {39200, -1, -1, -1}, {39202, -1, -1, -1}, {39203, -1, -1, -1}, {39204, -1, -1, -1}, {39205, -1, -1, -1}, {39206, -1, -1, -1}, {39207, -1, -1, -1}, {39209, -1, -1, -1}, {39210, -1, -1, -1} },
    {{39211, -1, -1, -1}, {39212, -1, -1, -1}, {39213, -1, -1, -1}, {39215, -1, -1, -1}, {39216, -1, -1, -1}, {39217, -1, -1, -1}, {39218, -1, -1, -1}, {39220, -1, -1, -1}, {39221, -1, -1, -1}, {39222, -1, -1, -1}, {39224, -1, -1, -1}, {39225, -1, -1, -1}, {39226, -1, -1, -1}, {39227, -1, -1, -1}, {39229, -1, -1, -1}, {39232, -1, -1, -1}, {39233, -1, -1, -1}, {39234, -1, -1, -1}, {39236, -1, -1, -1}, {39238, -1, -1, -1}, {39239, -1, -1, -1}, {39245, -1, -1, -1}, {39246, -1, -1, -1}, {39247, -1, -1, -1}, {39248, -1, -1, -1}, {39251, -1, -1, -1}, {39254, -1, -1, -1}, {39256, -1, -1, -1}, {39257, -1, -1, -1}, {39258, -1, -1, -1}, {39259, -1, -1, -1}, {39261, -1, -1, -1}, {39263, -1, -1, -1}, {39264, -1, -1, -1}, {39265, -1, -1, -1}, {39268, -1, -1, -1}, {39270, -1, -1, -1}, {39283, -1, -1, -1}, {39288, -1, -1, -1}, {39289, -1, -1, -1}, {39291, -1, -1, -1}, {39294, -1, -1, -1}, {39298, -1, -1, -1}, {39299, -1, -1, -1}, {39305, -1, -1, -1}, {39308, -1, -1, -1}, {39310, -1, -1, -1}, {39322, -1, -1, -1}, {39323, -1, -1, -1}, {39324, -1, -1, -1}, {39325, -1, -1, -1}, {39326, -1, -1, -1}, {39327, -1, -1, -1}, {39328, -1, -1, -1}, {39329, -1, -1, -1}, {39330, -1, -1, -1}, {39331, -1, -1, -1}, {39332, -1, -1, -1}, {39334, -1, -1, -1}, {39335, -1, -1, -1}, {39337, -1, -1, -1}, {39338, -1, -1, -1}, {39339, -1, -1, -1}, {39343, -1, -1, -1}, {39344, -1, -1, -1}, {39346, -1, -1, -1}, {39349, -1, -1, -1}, {39350, -1, -1, -1}, {39351, -1, -1, -1}, {39352, -1, -1, -1}, {39353, -1, -1, -1}, {39354, -1, -1, -1}, {39355, -1, -1, -1}, {39356, -1, -1, -1}, {39357, -1, -1, -1}, {39358, -1, -1, -1}, {39359, -1, -1, -1}, {39360, -1, -1, -1}, {39362, -1, -1, -1}, {39363, -1, -1, -1}, {39364, -1, -1, -1}, {39365, -1, -1, -1}, {39366, -1, -1, -1}, {39367, -1, -1, -1}, {39368, -1, -1, -1}, {39369, -1, -1, -1}, {39370, -1, -1, -1}, {39371, -1, -1, -1}, {39372, -1, -1, -1}, {39373, -1, -1, -1}, {39374, -1, -1, -1}, {39375, -1, -1, -1}, {39379, -1, -1, -1}, {39382, -1, -1, -1}, {39383, -1, -1, -1}, {39386, -1, -1, -1}, {39388, -1, -1, -1}, {39390, -1, -1, -1}, {39392, -1, -1, -1}, {39395, -1, -1, -1}, {39396, -1, -1, -1}, {39397, -1, -1, -1}, {39398, -1, -1, -1}, {39399, -1, -1, -1}, {39400, -1, -1, -1}, {39401, -1, -1, -1}, {39402, -1, -1, -1}, {39403, -1, -1, -1}, {39404, -1, -1, -1}, {39406, -1, -1, -1}, {39407, -1, -1, -1}, {39408, -1, -1, -1}, {39410, -1, -1, -1}, {39411, -1, -1, -1}, {39412, -1, -1, -1}, {39413, -1, -1, -1}, {39414, -1, -1, -1}, {39415, -1, -1, -1}, {39416, -1, -1, -1}, {39417, -1, -1, -1}, {39418, -1, -1, -1}, {39419, -1, -1, -1}, {39420, -1, -1, -1}, {39421, -1, -1, -1}, {39422, -1, -1, -1}, {39424, -1, -1, -1}, {39426, -1, -1, -1}, {39427, -1, -1, -1}, {39428, -1, -1, -1}, {39430, -1, -1, -1}, {39431, -1, -1, -1}, {39432, -1, -1, -1}, {39433, -1, -1, -1}, {39434, -1, -1, -1}, {39435, -1, -1, -1}, {39436, -1, -1, -1}, {39440, -1, -1, -1}, {39441, -1, -1, -1}, {39442, -1, -1, -1}, {39443, -1, -1, -1}, {39444, -1, -1, -1}, {39445, -1, -1, -1}, {39447, -1, -1, -1}, {39448, -1, -1, -1}, {39450, -1, -1, -1}, {39451, -1, -1, -1}, {39452, -1, -1, -1}, {39453, -1, -1, -1}, {39454, -1, -1, -1}, {39455, -1, -1, -1}, {39456, -1, -1, -1}, {39457, -1, -1, -1}, {39458, -1, -1, -1}, {39459, -1, -1, -1}, {39460, -1, -1, -1}, {39461, -1, -1, -1}, {39462, -1, -1, -1}, {39463, -1, -1, -1}, {39464, -1, -1, -1}, {39465, -1, -1, -1}, {39466, -1, -1, -1}, {39468, -1, -1, -1}, {39471, -1, -1, -1}, {39473, -1, -1, -1}, {39474, -1, -1, -1}, {39475, -1, -1, -1}, {39476, -1, -1, -1}, {39477, -1, -1, -1}, {39481, -1, -1, -1}, {39482, -1, -1, -1}, {39483, -1, -1, -1}, {39484, -1, -1, -1}, {39485, -1, -1, -1}, {39487, -1, -1, -1}, {39494, -1, -1, -1}, {39495, -1, -1, -1}, {39496, -1, -1, -1}, {39497, -1, -1, -1}, {39499, -1, -1, -1}, {39500, -1, -1, -1}, {39502, -1, -1, -1}, {39504, -1, -1, -1}, {39505, -1, -1, -1}, {39506, -1, -1, -1}, {39507, -1, -1, -1}, {39508, -1, -1, -1}, {39510, -1, -1, -1}, {39512, -1, -1, -1}, {39513, -1, -1, -1}, {39516, -1, -1, -1}, {39517, -1, -1, -1}, {39518, -1, -1, -1}, {39520, -1, -1, -1}, {39521, -1, -1, -1}, {39523, -1, -1, -1}, {39526, -1, -1, -1}, {39527, -1, -1, -1}, {39528, -1, -1, -1}, {39529, -1, -1, -1}, {39531, -1, -1, -1}, {39538, -1, -1, -1}, {39555, -1, -1, -1}, {39561, -1, -1, -1}, {39565, -1, -1, -1}, {39566, -1, -1, -1}, {39572, -1, -1, -1}, {39573, -1, -1, -1}, {39577, -1, -1, -1}, {39590, -1, -1, -1}, {39593, -1, -1, -1}, {39594, -1, -1, -1}, {39595, -1, -1, -1}, {39596, -1, -1, -1}, {39597, -1, -1, -1}, {39598, -1, -1, -1}, {39602, -1, -1, -1}, {39603, -1, -1, -1}, {39604, -1, -1, -1}, {39605, -1, -1, -1}, {39609, -1, -1, -1}, {39611, -1, -1, -1}, {39613, -1, -1, -1}, {39614, -1, -1, -1}, {39615, -1, -1, -1}, {39619, -1, -1, -1}, {39620, -1, -1, -1}, {39622, -1, -1, -1}, {39623, -1, -1, -1}, {39624, -1, -1, -1}, {39625, -1, -1, -1}, {39626, -1, -1, -1}, {39629, -1, -1, -1}, {39630, -1, -1, -1}, {39632, -1, -1, -1}, {39639, -1, -1, -1}, {39641, -1, -1, -1}, {39642, -1, -1, -1}, {39643, -1, -1, -1}, {39644, -1, -1, -1}, {39645, -1, -1, -1}, {39646, -1, -1, -1}, {39648, -1, -1, -1}, {39650, -1, -1, -1}, {39651, -1, -1, -1}, {39652, -1, -1, -1}, {39653, -1, -1, -1}, {39655, -1, -1, -1}, {39656, -1, -1, -1}, {39657, -1, -1, -1}, {39658, -1, -1, -1}, {39660, -1, -1, -1}, {39664, -1, -1, -1}, {39665, -1, -1, -1}, {39666, -1, -1, -1}, {39667, -1, -1, -1}, {39668, -1, -1, -1} },
    {{39669, -1, -1, -1}, {39670, -1, -1, -1}, {39671, -1, -1, -1}, {39672, -1, -1, -1}, {39674, -1, -1, -1}, {39676, -1, -1, -1}, {39677, -1, -1, -1}, {39678, -1, -1, -1}, {39679, -1, -1, -1}, {39680, -1, -1, -1}, {39681, -1, -1, -1}, {39682, -1, -1, -1}, {39684, -1, -1, -1}, {39685, -1, -1, -1}, {39687, -1, -1, -1}, {39689, -1, -1, -1}, {39690, -1, -1, -1}, {39691, -1, -1, -1}, {39692, -1, -1, -1}, {39694, -1, -1, -1}, {39696, -1, -1, -1}, {39697, -1, -1, -1}, {39698, -1, -1, -1}, {39700, -1, -1, -1}, {39701, -1, -1, -1}, {39702, -1, -1, -1}, {39703, -1, -1, -1}, {39704, -1, -1, -1}, {39705, -1, -1, -1}, {39707, -1, -1, -1}, {39708, -1, -1, -1}, {39709, -1, -1, -1}, {39710, -1, -1, -1}, {39712, -1, -1, -1}, {39713, -1, -1, -1}, {39716, -1, -1, -1}, {39718, -1, -1, -1}, {39720, -1, -1, -1}, {39722, -1, -1, -1}, {39723, -1, -1, -1}, {39724, -1, -1, -1}, {39725, -1, -1, -1}, {39728, -1, -1, -1}, {39731, -1, -1, -1}, {39732, -1, -1, -1}, {39733, -1, -1, -1}, {39734, -1, -1, -1}, {39735, -1, -1, -1}, {39736, -1, -1, -1}, {39737, -1, -1, -1}, {39738, -1, -1, -1}, {39741, -1, -1, -1}, {39742, -1, -1, -1}, {39743, -1, -1, -1}, {39744, -1, -1, -1}, {39750, -1, -1, -1}, {39754, -1, -1, -1}, {39755, -1, -1, -1}, {39756, -1, -1, -1}, {39760, -1, -1, -1}, {39762, -1, -1, -1}, {39763, -1, -1, -1}, {39765, -1, -1, -1}, {39766, -1, -1, -1}, {39767, -1, -1, -1}, {39769, -1, -1, -1}, {39771, -1, -1, -1}, {39772, -1, -1, -1}, {39773, -1, -1, -1}, {39774, -1, -1, -1}, {39775, -1, -1, -1}, {39776, -1, -1, -1}, {39777, -1, -1, -1}, {39778, -1, -1, -1}, {39779, -1, -1, -1}, {39780, -1, -1, -1}, {39781, -1, -1, -1}, {39782, -1, -1, -1}, {39783, -1, -1, -1}, {39784, -1, -1, -1}, {39785, -1, -1, -1}, {39786, -1, -1, -1}, {39787, -1, -1, -1}, {39788, -1, -1, -1}, {39789, -1, -1, -1}, {39790, -1, -1, -1}, {39792, -1, -1, -1}, {39793, -1, -1, -1}, {39794, -1, -1, -1}, {39795, -1, -1, -1}, {39797, -1, -1, -1}, {39798, -1, -1, -1}, {39800, -1, -1, -1}, {39801, -1, -1, -1}, {39802, -1, -1, -1}, {39803, -1, -1, -1}, {39804, -1, -1, -1}, {39805, -1, -1, -1}, {39806, -1, -1, -1}, {39807, -1, -1, -1}, {39808, -1, -1, -1}, {39810, -1, -1, -1}, {39812, -1, -1, -1}, {39813, -1, -1, -1}, {39814, -1, -1, -1}, {39815, -1, -1, -1}, {39816, -1, -1, -1}, {39817, -1, -1, -1}, {39818, -1, -1, -1}, {39819, -1, -1, -1}, {39820, -1, -1, -1}, {39821, -1, -1, -1}, {39823, -1, -1, -1}, {39827, -1, -1, -1}, {39828, -1, -1, -1}, {39829, -1, -1, -1}, {39830, -1, -1, -1}, {39831, -1, -1, -1}, {39832, -1, -1, -1}, {39833, -1, -1, -1}, {39835, -1, -1, -1}, {39836, -1, -1, -1}, {39839, -1, -1, -1}, {39840, -1, -1, -1}, {39841, -1, -1, -1}, {39842, -1, -1, -1}, {39843, -1, -1, -1}, {39844, -1, -1, -1}, {39845, -1, -1, -1}, {39846, -1, -1, -1}, {39847, -1, -1, -1}, {39848, -1, -1, -1}, {39849, -1, -1, -1}, {39852, -1, -1, -1}, {39855, -1, -1, -1}, {39856, -1, -1, -1}, {39857, -1, -1, -1}, {39858, -1, -1, -1}, {39859, -1, -1, -1}, {39860, -1, -1, -1}, {39861, -1, -1, -1}, {39862, -1, -1, -1}, {39863, -1, -1, -1}, {39864, -1, -1, -1}, {39865, -1, -1, -1}, {39866, -1, -1, -1}, {39867, -1, -1, -1}, {39868, -1, -1, -1}, {39869, -1, -1, -1}, {39870, -1, -1, -1}, {39871, -1, -1, -1}, {39874, -1, -1, -1}, {39875, -1, -1, -1}, {39876, -1, -1, -1}, {39877, -1, -1, -1}, {39878, -1, -1, -1}, {39880, -1, -1, -1}, {39883, -1, -1, -1}, {39884, -1, -1, -1}, {39885, -1, -1, -1}, {39886, -1, -1, -1}, {39887, -1, -1, -1}, {39888, -1, -1, -1}, {39889, -1, -1, -1}, {39890, -1, -1, -1}, {39891, -1, -1, -1}, {39893, -1, -1, -1}, {39895, -1, -1, -1}, {39896, -1, -1, -1}, {39897, -1, -1, -1}, {39898, -1, -1, -1}, {39900, -1, -1, -1}, {39902, -1, -1, -1}, {39903, -1, -1, -1}, {39904, -1, -1, -1}, {39907, -1, -1, -1}, {39909, -1, -1, -1}, {39910, -1, -1, -1}, {39913, -1, -1, -1}, {39916, -1, -1, -1}, {39917, -1, -1, -1}, {39918, -1, -1, -1}, {39919, -1, -1, -1}, {39921, -1, -1, -1}, {39922, -1, -1, -1}, {39923, -1, -1, -1}, {39925, -1, -1, -1}, {39926, -1, -1, -1}, {39927, -1, -1, -1}, {39928, -1, -1, -1}, {39929, -1, -1, -1}, {39930, -1, -1, -1}, {39931, -1, -1, -1}, {39932, -1, -1, -1}, {39934, -1, -1, -1}, {39936, -1, -1, -1}, {39937, -1, -1, -1}, {39938, -1, -1, -1}, {39939, -1, -1, -1}, {39940, -1, -1, -1}, {39941, -1, -1, -1}, {39942, -1, -1, -1}, {39943, -1, -1, -1}, {39946, -1, -1, -1}, {39947, -1, -1, -1}, {39948, -1, -1, -1}, {39950, -1, -1, -1}, {39951, -1, -1, -1}, {39953, -1, -1, -1}, {39956, -1, -1, -1}, {39957, -1, -1, -1}, {39958, -1, -1, -1}, {39959, -1, -1, -1}, {39960, -1, -1, -1}, {39961, -1, -1, -1}, {39962, -1, -1, -1}, {39963, -1, -1, -1}, {39964, -1, -1, -1}, {39965, -1, -1, -1}, {39966, -1, -1, -1}, {39967, -1, -1, -1}, {39969, -1, -1, -1}, {39970, -1, -1, -1}, {39972, -1, -1, -1}, {39974, -1, -1, -1}, {39975, -1, -1, -1}, {39978, -1, -1, -1}, {39979, -1, -1, -1}, {39980, -1, -1, -1}, {39982, -1, -1, -1}, {39983, -1, -1, -1}, {39984, -1, -1, -1}, {39988, -1, -1, -1}, {39990, -1, -1, -1}, {39992, -1, -1, -1}, {39994, -1, -1, -1}, {39996, -1, -1, -1}, {39997, -1, -1, -1}, {39999, -1, -1, -1}, {40000, -1, -1, -1}, {40001, -1, -1, -1}, {40002, -1, -1, -1}, {40003, -1, -1, -1}, {40004, -1, -1, -1}, {40006, -1, -1, -1}, {40007, -1, -1, -1}, {40010, -1, -1, -1}, {40011, -1, -1, -1}, {40012, -1, -1, -1}, {40013, -1, -1, -1}, {40014, -1, -1, -1}, {40015, -1, -1, -1}, {40016, -1, -1, -1}, {40017, -1, -1, -1}, {40019, -1, -1, -1}, {40021, -1, -1, -1} },
    {{40025, -1, -1, -1}, {40026, -1, -1, -1}, {40027, -1, -1, -1}, {40028, -1, -1, -1}, {40030, -1, -1, -1}, {40032, -1, -1, -1}, {40033, -1, -1, -1}, {40034, -1, -1, -1}, {40035, -1, -1, -1}, {40036, -1, -1, -1}, {40037, -1, -1, -1}, {40038, -1, -1, -1}, {40040, -1, -1, -1}, {40041, -1, -1, -1}, {40042, -1, -1, -1}, {40043, -1, -1, -1}, {40044, -1, -1, -1}, {40046, -1, -1, -1}, {40047, -1, -1, -1}, {40048, -1, -1, -1}, {40049, -1, -1, -1}, {40050, -1, -1, -1}, {40051, -1, -1, -1}, {40052, -1, -1, -1}, {40053, -1, -1, -1}, {40054, -1, -1, -1}, {40055, -1, -1, -1}, {40057, -1, -1, -1}, {40059, -1, -1, -1}, {40061, -1, -1, -1}, {40062, -1, -1, -1}, {40064, -1, -1, -1}, {40067, -1, -1, -1}, {40068, -1, -1, -1}, {40073, -1, -1, -1}, {40074, -1, -1, -1}, {40076, -1, -1, -1}, {40079, -1, -1, -1}, {40083, -1, -1, -1}, {40086, -1, -1, -1}, {40087, -1, -1, -1}, {40088, -1, -1, -1}, {40089, -1, -1, -1}, {40093, -1, -1, -1}, {40106, -1, -1, -1}, {40108, -1, -1, -1}, {40111, -1, -1, -1}, {40121, -1, -1, -1}, {40126, -1, -1, -1}, {40127, -1, -1, -1}, {40128, -1, -1, -1}, {40129, -1, -1, -1}, {40130, -1, -1, -1}, {40136, -1, -1, -1}, {40137, -1, -1, -1}, {40145, -1, -1, -1}, {40146, -1, -1, -1}, {40154, -1, -1, -1}, {40155, -1, -1, -1}, {40160, -1, -1, -1}, {40161, -1, -1, -1}, {40163, -1, -1, -1}, {40164, -1, -1, -1}, {40166, -1, -1, -1}, {40167, -1, -1, -1}, {40168, -1, -1, -1}, {40170, -1, -1, -1}, {40171, -1, -1, -1}, {40173, -1, -1, -1}, {40174, -1, -1, -1}, {40175, -1, -1, -1}, {40176, -1, -1, -1}, {40177, -1, -1, -1}, {40178, -1, -1, -1}, {40181, -1, -1, -1}, {40183, -1, -1, -1}, {40184, -1, -1, -1}, {40185, -1, -1, -1}, {40186, -1, -1, -1}, {40187, -1, -1, -1}, {40188, -1, -1, -1}, {40189, -1, -1, -1}, {40190, -1, -1, -1}, {40191, -1, -1, -1}, {40192, -1, -1, -1}, {40193, -1, -1, -1}, {40194, -1, -1, -1}, {40195, -1, -1, -1}, {40196, -1, -1, -1}, {40197, -1, -1, -1}, {40200, -1, -1, -1}, {40202, -1, -1, -1}, {40203, -1, -1, -1}, {40204, -1, -1, -1}, {40205, -1, -1, -1}, {40206, -1, -1, -1}, {40207, -1, -1, -1}, {40208, -1, -1, -1}, {40209, -1, -1, -1}, {40210, -1, -1, -1}, {40211, -1, -1, -1}, {40212, -1, -1, -1}, {40214, -1, -1, -1}, {40215, -1, -1, -1}, {40216, -1, -1, -1}, {40217, -1, -1, -1}, {40218, -1, -1, -1}, {40220, -1, -1, -1}, {40222, -1, -1, -1}, {40224, -1, -1, -1}, {40225, -1, -1, -1}, {40226, -1, -1, -1}, {40228, -1, -1, -1}, {40229, -1, -1, -1}, {40231, -1, -1, -1}, {40233, -1, -1, -1}, {40234, -1, -1, -1}, {40235, -1, -1, -1}, {40236, -1, -1, -1}, {40237, -1, -1, -1}, {40238, -1, -1, -1}, {40241, -1, -1, -1}, {40242, -1, -1, -1}, {40243, -1, -1, -1}, {40244, -1, -1, -1}, {40245, -1, -1, -1}, {40246, -1, -1, -1}, {40247, -1, -1, -1}, {40248, -1, -1, -1}, {40249, -1, -1, -1}, {40250, -1, -1, -1}, {40252, -1, -1, -1}, {40253, -1, -1, -1}, {40254, -1, -1, -1}, {40256, -1, -1, -1}, {40257, -1, -1, -1}, {40259, -1, -1, -1}, {40260, -1, -1, -1}, {40261, -1, -1, -1}, {40262, -1, -1, -1}, {40263, -1, -1, -1}, {40264, -1, -1, -1}, {40265, -1, -1, -1}, {40266, -1, -1, -1}, {40267, -1, -1, -1}, {40268, -1, -1, -1}, {40269, -1, -1, -1}, {40270, -1, -1, -1}, {40271, -1, -1, -1}, {40272, -1, -1, -1}, {40276, -1, -1, -1}, {40277, -1, -1, -1}, {40278, -1, -1, -1}, {40279, -1, -1, -1}, {40280, -1, -1, -1}, {40281, -1, -1, -1}, {40282, -1, -1, -1}, {40283, -1, -1, -1}, {40286, -1, -1, -1}, {40287, -1, -1, -1}, {40290, -1, -1, -1}, {40291, -1, -1, -1}, {40292, -1, -1, -1}, {40293, -1, -1, -1}, {40294, -1, -1, -1}, {40295, -1, -1, -1}, {40296, -1, -1, -1}, {40297, -1, -1, -1}, {40299, -1, -1, -1}, {40301, -1, -1, -1}, {40302, -1, -1, -1}, {40304, -1, -1, -1}, {40305, -1, -1, -1}, {40307, -1, -1, -1}, {40308, -1, -1, -1}, {40309, -1, -1, -1}, {40310, -1, -1, -1}, {40311, -1, -1, -1}, {40312, -1, -1, -1}, {40313, -1, -1, -1}, {40314, -1, -1, -1}, {40315, -1, -1, -1}, {40316, -1, -1, -1}, {40317, -1, -1, -1}, {40318, -1, -1, -1}, {40319, -1, -1, -1}, {40320, -1, -1, -1}, {40321, -1, -1, -1}, {40322, -1, -1, -1}, {40323, -1, -1, -1}, {40324, -1, -1, -1}, {40325, -1, -1, -1}, {40326, -1, -1, -1}, {40328, -1, -1, -1}, {40330, -1, -1, -1}, {40331, -1, -1, -1}, {40332, -1, -1, -1}, {40333, -1, -1, -1}, {40334, -1, -1, -1}, {40335, -1, -1, -1}, {40336, -1, -1, -1}, {40337, -1, -1, -1}, {40338, -1, -1, -1}, {40340, -1, -1, -1}, {40341, -1, -1, -1}, {40342, -1, -1, -1}, {40343, -1, -1, -1}, {40345, -1, -1, -1}, {40347, -1, -1, -1}, {40348, -1, -1, -1}, {40349, -1, -1, -1}, {40350, -1, -1, -1}, {40351, -1, -1, -1}, {40352, -1, -1, -1}, {40353, -1, -1, -1}, {40354, -1, -1, -1}, {40355, -1, -1, -1}, {40356, -1, -1, -1}, {40358, -1, -1, -1}, {40359, -1, -1, -1}, {40360, -1, -1, -1}, {40362, -1, -1, -1}, {40363, -1, -1, -1}, {40364, -1, -1, -1}, {40365, -1, -1, -1}, {40366, -1, -1, -1}, {40368, -1, -1, -1}, {40369, -1, -1, -1}, {40370, -1, -1, -1}, {40371, -1, -1, -1}, {40373, -1, -1, -1}, {40374, -1, -1, -1}, {40375, -1, -1, -1}, {40376, -1, -1, -1}, {40377, -1, -1, -1}, {40378, -1, -1, -1}, {40381, -1, -1, -1}, {40382, -1, -1, -1}, {40383, -1, -1, -1}, {40385, -1, -1, -1}, {40387, -1, -1, -1}, {40389, -1, -1, -1}, {40390, -1, -1, -1}, {40391, -1, -1, -1}, {40392, -1, -1, -1}, {40393, -1, -1, -1}, {40394, -1, -1, -1}, {40395, -1, -1, -1}, {40396, -1, -1, -1}, {40397, -1, -1, -1}, {40398, -1, -1, -1}, {40399, -1, -1, -1}, {40400, -1, -1, -1}, {40401, -1, -1, -1}, {40402, -1, -1, -1}, {40404, -1, -1, -1} },
    {{40405, -1, -1, -1}, {40406, -1, -1, -1}, {40408, -1, -1, -1}, {40411, -1, -1, -1}, {40412, -1, -1, -1}, {40413, -1, -1, -1}, {40414, -1, -1, -1}, {40415, -1, -1, -1}, {40416, -1, -1, -1}, {40417, -1, -1, -1}, {40418, -1, -1, -1}, {40419, -1, -1, -1}, {40420, -1, -1, -1}, {40423, -1, -1, -1}, {40424, -1, -1, -1}, {40425, -1, -1, -1}, {40426, -1, -1, -1}, {40427, -1, -1, -1}, {40428, -1, -1, -1}, {40429, -1, -1, -1}, {40430, -1, -1, -1}, {40432, -1, -1, -1}, {40433, -1, -1, -1}, {40436, -1, -1, -1}, {40437, -1, -1, -1}, {40438, -1, -1, -1}, {40439, -1, -1, -1}, {40443, -1, -1, -1}, {40444, -1, -1, -1}, {40445, -1, -1, -1}, {40446, -1, -1, -1}, {40447, -1, -1, -1}, {40448, -1, -1, -1}, {40449, -1, -1, -1}, {40450, -1, -1, -1}, {40451, -1, -1, -1}, {40452, -1, -1, -1}, {40453, -1, -1, -1}, {40454, -1, -1, -1}, {40455, -1, -1, -1}, {40456, -1, -1, -1}, {40457, -1, -1, -1}, {40458, -1, -1, -1}, {40459, -1, -1, -1}, {40461, -1, -1, -1}, {40462, -1, -1, -1}, {40463, -1, -1, -1}, {40464, -1, -1, -1}, {40465, -1, -1, -1}, {40466, -1, -1, -1}, {40467, -1, -1, -1}, {40468, -1, -1, -1}, {40470, -1, -1, -1}, {40471, -1, -1, -1}, {40472, -1, -1, -1}, {40473, -1, -1, -1}, {40476, -1, -1, -1}, {40484, -1, -1, -1}, {40487, -1, -1, -1}, {40494, -1, -1, -1}, {40496, -1, -1, -1}, {40500, -1, -1, -1}, {40507, -1, -1, -1}, {40508, -1, -1, -1}, {40512, -1, -1, -1}, {40525, -1, -1, -1}, {40528, -1, -1, -1}, {40530, -1, -1, -1}, {40531, -1, -1, -1}, {40532, -1, -1, -1}, {40534, -1, -1, -1}, {40537, -1, -1, -1}, {40541, -1, -1, -1}, {40543, -1, -1, -1}, {40544, -1, -1, -1}, {40545, -1, -1, -1}, {40546, -1, -1, -1}, {40549, -1, -1, -1}, {40558, -1, -1, -1}, {40559, -1, -1, -1}, {40562, -1, -1, -1}, {40564, -1, -1, -1}, {40566, -1, -1, -1}, {40567, -1, -1, -1}, {40568, -1, -1, -1}, {40571, -1, -1, -1}, {40576, -1, -1, -1}, {40577, -1, -1, -1}, {40579, -1, -1, -1}, {40580, -1, -1, -1}, {40581, -1, -1, -1}, {40582, -1, -1, -1}, {40585, -1, -1, -1}, {40586, -1, -1, -1}, {40588, -1, -1, -1}, {40589, -1, -1, -1}, {40590, -1, -1, -1}, {40591, -1, -1, -1}, {40592, -1, -1, -1}, {40593, -1, -1, -1}, {40596, -1, -1, -1}, {40597, -1, -1, -1}, {40598, -1, -1, -1}, {40600, -1, -1, -1}, {40601, -1, -1, -1}, {40602, -1, -1, -1}, {40603, -1, -1, -1}, {40604, -1, -1, -1}, {40606, -1, -1, -1}, {40608, -1, -1, -1}, {40609, -1, -1, -1}, {40610, -1, -1, -1}, {40611, -1, -1, -1}, {40612, -1, -1, -1}, {40615, -1, -1, -1}, {40616, -1, -1, -1}, {40618, -1, -1, -1}, {40619, -1, -1, -1}, {40620, -1, -1, -1}, {40621, -1, -1, -1}, {40622, -1, -1, -1}, {40624, -1, -1, -1}, {40625, -1, -1, -1}, {40626, -1, -1, -1}, {40627, -1, -1, -1}, {40630, -1, -1, -1}, {40631, -1, -1, -1}, {40633, -1, -1, -1}, {40634, -1, -1, -1}, {40636, -1, -1, -1}, {40639, -1, -1, -1}, {40640, -1, -1, -1}, {40641, -1, -1, -1}, {40642, -1, -1, -1}, {12232, 40643, -1, -1}, {40645, -1, -1, -1}, {40646, -1, -1, -1}, {40647, -1, -1, -1}, {40648, -1, -1, -1}, {40650, -1, -1, -1}, {40651, -1, -1, -1}, {40656, -1, -1, -1}, {40658, -1, -1, -1}, {40659, -1, -1, -1}, {40661, -1, -1, -1}, {40662, -1, -1, -1}, {40663, -1, -1, -1}, {40665, -1, -1, -1}, {40666, -1, -1, -1}, {40673, -1, -1, -1}, {40675, -1, -1, -1}, {40676, -1, -1, -1}, {40678, -1, -1, -1}, {40683, -1, -1, -1}, {40684, -1, -1, -1}, {40685, -1, -1, -1}, {40686, -1, -1, -1}, {40688, -1, -1, -1}, {40689, -1, -1, -1}, {40691, -1, -1, -1}, {40693, -1, -1, -1}, {40694, -1, -1, -1}, {40696, -1, -1, -1}, {40698, -1, -1, -1}, {40704, -1, -1, -1}, {40705, -1, -1, -1}, {40706, -1, -1, -1}, {40707, -1, -1, -1}, {40708, -1, -1, -1}, {40709, -1, -1, -1}, {40710, -1, -1, -1}, {40711, -1, -1, -1}, {40712, -1, -1, -1}, {40714, -1, -1, -1}, {40716, -1, -1, -1}, {40719, -1, -1, -1}, {40721, -1, -1, -1}, {40722, -1, -1, -1}, {40724, -1, -1, -1}, {40726, -1, -1, -1}, {40728, -1, -1, -1}, {40730, -1, -1, -1}, {40731, -1, -1, -1}, {40732, -1, -1, -1}, {40733, -1, -1, -1}, {40734, -1, -1, -1}, {40735, -1, -1, -1}, {40737, -1, -1, -1}, {40739, -1, -1, -1}, {40740, -1, -1, -1}, {40741, -1, -1, -1}, {40742, -1, -1, -1}, {40743, -1, -1, -1}, {40744, -1, -1, -1}, {40745, -1, -1, -1}, {40746, -1, -1, -1}, {40747, -1, -1, -1}, {40749, -1, -1, -1}, {40750, -1, -1, -1}, {40752, -1, -1, -1}, {40753, -1, -1, -1}, {40754, -1, -1, -1}, {40755, -1, -1, -1}, {40756, -1, -1, -1}, {40757, -1, -1, -1}, {40758, -1, -1, -1}, {40760, -1, -1, -1}, {40762, -1, -1, -1}, {40764, -1, -1, -1}, {40767, -1, -1, -1}, {40768, -1, -1, -1}, {40769, -1, -1, -1}, {40770, -1, -1, -1}, {40771, -1, -1, -1}, {40773, -1, -1, -1}, {40774, -1, -1, -1}, {40775, -1, -1, -1}, {40776, -1, -1, -1}, {40777, -1, -1, -1}, {40780, -1, -1, -1}, {40781, -1, -1, -1}, {40782, -1, -1, -1}, {40787, -1, -1, -1}, {40789, -1, -1, -1}, {40790, -1, -1, -1}, {40791, -1, -1, -1}, {40792, -1, -1, -1}, {40794, -1, -1, -1}, {40795, -1, -1, -1}, {40797, -1, -1, -1}, {40798, -1, -1, -1}, {40802, -1, -1, -1}, {40804, -1, -1, -1}, {40805, -1, -1, -1}, {40807, -1, -1, -1}, {40808, -1, -1, -1}, {40809, -1, -1, -1}, {40811, -1, -1, -1}, {40813, -1, -1, -1}, {40814, -1, -1, -1}, {40815, -1, -1, -1}, {40816, -1, -1, -1}, {40817, -1, -1, -1}, {40819, -1, -1, -1}, {40820, -1, -1, -1}, {40821, -1, -1, -1}, {40822, -1, -1, -1}, {40824, -1, -1, -1}, {40825, -1, -1, -1}, {40826, -1, -1, -1}, {40827, -1, -1, -1}, {40828, -1, -1, -1}, {40829, -1, -1, -1}, {40830, -1, -1, -1}, {40833, -1, -1, -1}, {40834, -1, -1, -1} },
    {{40846, -1, -1, -1}, {40847, -1, -1, -1}, {40849, -1, -1, -1}, {40850, -1, -1, -1}, {40851, -1, -1, -1}, {40854, -1, -1, -1}, {40855, -1, -1, -1}, {40856, -1, -1, -1}, {40861, -1, -1, -1}, {40862, -1, -1, -1}, {40865, -1, -1, -1}, {40866, -1, -1, -1}, {40867, -1, -1, -1}, {40868, -1, -1, -1}, {40869, -1, -1, -1}, {63788, -1, -1, -1}, {64013, -1, -1, -1}, {64014, -1, -1, -1}, {64015, -1, -1, -1}, {64017, -1, -1, -1}, {64019, -1, -1, -1}, {64020, -1, -1, -1}, {64024, -1, -1, -1}, {64031, -1, -1, -1}, {64032, -1, -1, -1}, {64033, -1, -1, -1}, {64035, -1, -1, -1}, {64036, -1, -1, -1}, {64039, -1, -1, -1}, {64040, -1, -1, -1}, {64041, -1, -1, -1}, {11905, -1, -1, -1}, {59414, -1, -1, -1}, {59415, -1, -1, -1}, {59416, -1, -1, -1}, {11908, -1, -1, -1}, {13427, -1, -1, -1}, {13383, -1, -1, -1}, {11912, -1, -1, -1}, {11915, -1, -1, -1}, {59422, -1, -1, -1}, {13726, -1, -1, -1}, {13850, -1, -1, -1}, {13838, -1, -1, -1}, {11916, -1, -1, -1}, {11927, -1, -1, -1}, {14702, -1, -1, -1}, {14616, -1, -1, -1}, {59430, -1, -1, -1}, {14799, -1, -1, -1}, {14815, -1, -1, -1}, {14963, -1, -1, -1}, {14800, -1, -1, -1}, {59435, -1, -1, -1}, {59436, -1, -1, -1}, {15182, -1, -1, -1}, {15470, -1, -1, -1}, {15584, -1, -1, -1}, {11943, -1, -1, -1}, {59441, -1, -1, -1}, {59442, -1, -1, -1}, {11946, -1, -1, -1}, {16470, -1, -1, -1}, {16735, -1, -1, -1}, {11950, -1, -1, -1}, {17207, -1, -1, -1}, {11955, -1, -1, -1}, {11958, -1, -1, -1}, {11959, -1, -1, -1}, {59451, -1, -1, -1}, {17329, -1, -1, -1}, {17324, -1, -1, -1}, {11963, -1, -1, -1}, {17373, -1, -1, -1}, {17622, -1, -1, -1}, {18017, -1, -1, -1}, {17996, -1, -1, -1}, {59459, -1, -1, -1}, {18211, -1, -1, -1}, {18217, -1, -1, -1}, {18300, -1, -1, -1}, {18317, -1, -1, -1}, {11978, -1, -1, -1}, {18759, -1, -1, -1}, {18810, -1, -1, -1}, {18813, -1, -1, -1}, {18818, -1, -1, -1}, {18819, -1, -1, -1}, {18821, -1, -1, -1}, {18822, -1, -1, -1}, {18847, -1, -1, -1}, {18843, -1, -1, -1}, {18871, -1, -1, -1}, {18870, -1, -1, -1}, {59476, -1, -1, -1}, {59477, -1, -1, -1}, {19619, -1, -1, -1}, {19615, -1, -1, -1}, {19616, -1, -1, -1}, {19617, -1, -1, -1}, {19575, -1, -1, -1}, {19618, -1, -1, -1}, {19731, -1, -1, -1}, {19732, -1, -1, -1}, {19733, -1, -1, -1}, {19734, -1, -1, -1}, {19735, -1, -1, -1}, {19736, -1, -1, -1}, {19737, -1, -1, -1}, {19886, -1, -1, -1}, {59492, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1} },
    {{-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {8364, -1, -1, -1}, {165, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {12351, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {12436, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {-1, -1, -1, -1}, {12535, -1, -1, -1}, {12536, -1, -1, -1}, {12537, -1, -1, -1}, {12538, -1, -1, -1}, {-1, -1, -1, -1}, {12339, -1, -1, -1}, {12340, -1, -1, -1}, {12341, -1, -1, -1}, {12344, -1, -1, -1}, {12345, -1, -1, -1}, {12346, -1, -1, -1}, {12586, -1, -1, -1}, {12587, -1, -1, -1}, {12588, -1, -1, -1}, {12704, -1, -1, -1}, {12705, -1, -1, -1}, {12706, -1, -1, -1}, {12707, -1, -1, -1}, {12708, -1, -1, -1}, {12709, -1, -1, -1}, {12710, -1, -1, -1}, {12711, -1, -1, -1}, {12712, -1, -1, -1}, {12713, -1, -1, -1}, {12714, -1, -1, -1}, {12715, -1, -1, -1}, {12716, -1, -1, -1}, {12717, -1, -1, -1}, {12718, -1, -1, -1}, {12719, -1, -1, -1}, {12720, -1, -1, -1}, {12721, -1, -1, -1}, {12722, -1, -1, -1}, {12723, -1, -1, -1}, {12724, -1, -1, -1}, {12725, -1, -1, -1}, {12726, -1, -1, -1}, {12727, -1, -1, -1}, {11904, -1, -1, -1}, {11906, -1, -1, -1}, {11907, -1, -1, -1}, {11909, -1, -1, -1}, {11910, -1, -1, -1}, {11911, -1, -1, -1}, {11913, -1, -1, -1}, {11914, -1, -1, -1}, {11917, -1, -1, -1}, {11918, -1, -1, -1}, {11919, -1, -1, -1}, {11920, -1, -1, -1}, {11921, -1, -1, -1}, {11922, -1, -1, -1}, {11923, -1, -1, -1}, {11924, -1, -1, -1}, {11925, -1, -1, -1}, {11926, -1, -1, -1}, {11928, -1, -1, -1}, {11929, -1, -1, -1}, {11931, -1, -1, -1}, {11932, -1, -1, -1}, {11933, -1, -1, -1}, {11934, -1, -1, -1}, {11935, -1, -1, -1}, {11936, -1, -1, -1}, {11937, -1, -1, -1}, {11938, -1, -1, -1}, {11939, -1, -1, -1}, {11940, -1, -1, -1}, {11941, -1, -1, -1}, {11942, -1, -1, -1}, {11944, -1, -1, -1}, {11945, -1, -1, -1}, {11947, -1, -1, -1}, {11948, -1, -1, -1}, {11949, -1, -1, -1}, {11951, -1, -1, -1}, {11952, -1, -1, -1}, {11953, -1, -1, -1}, {11954, -1, -1, -1}, {11956, -1, -1, -1}, {11957, -1, -1, -1}, {11960, -1, -1, -1}, {11961, -1, -1, -1}, {11962, -1, -1, -1}, {11964, -1, -1, -1}, {11965, -1, -1, -1}, {11966, -1, -1, -1}, {11967, -1, -1, -1}, {11968, -1, -1, -1}, {11969, -1, -1, -1}, {11970, -1, -1, -1}, {11971, -1, -1, -1}, {11972, -1, -1, -1}, {11973, -1, -1, -1}, {11974, -1, -1, -1}, {11975, -1, -1, -1}, {11976, -1, -1, -1}, {11977, -1, -1, -1}, {11979, -1, -1, -1}, {11980, -1, -1, -1}, {11981, -1, -1, -1}, {11982, -1, -1, -1}, {11983, -1, -1, -1}, {11984, -1, -1, -1}, {11985, -1, -1, -1}, {11986, -1, -1, -1}, {11987, -1, -1, -1}, {11988, -1, -1, -1}, {11989, -1, -1, -1}, {11990, -1, -1, -1}, {11991, -1, -1, -1}, {11992, -1, -1, -1}, {11993, -1, -1, -1}, {11994, -1, -1, -1}, {11995, -1, -1, -1}, {11996, -1, -1, -1}, {11997, -1, -1, -1}, {11998, -1, -1, -1}, {11999, -1, -1, -1}, {12000, -1, -1, -1}, {12001, -1, -1, -1}, {12002, -1, -1, -1}, {12003, -1, -1, -1}, {12004, -1, -1, -1}, {12005, -1, -1, -1}, {12006, -1, -1, -1}, {12007, -1, -1, -1}, {12008, -1, -1, -1}, {12009, -1, -1, -1}, {12010, -1, -1, -1}, {12011, -1, -1, -1}, {12012, -1, -1, -1}, {12013, -1, -1, -1}, {12014, -1, -1, -1}, {12015, -1, -1, -1}, {12016, -1, -1, -1}, {12017, -1, -1, -1}, {12018, -1, -1, -1} },
    {{12019, -1, -1, -1}, {13312, -1, -1, -1}, {13313, -1, -1, -1}, {13314, -1, -1, -1}, {13315, -1, -1, -1}, {13316, -1, -1, -1}, {13317, -1, -1, -1}, {13318, -1, -1, -1}, {13319, -1, -1, -1}, {13320, -1, -1, -1}, {13321, -1, -1, -1}, {13322, -1, -1, -1}, {13323, -1, -1, -1}, {13324, -1, -1, -1}, {13325, -1, -1, -1}, {13326, -1, -1, -1}, {13327, -1, -1, -1}, {13328, -1, -1, -1}, {13329, -1, -1, -1}, {13330, -1, -1, -1}, {13331, -1, -1, -1}, {13332, -1, -1, -1}, {13333, -1, -1, -1}, {13334, -1, -1, -1}, {13335, -1, -1, -1}, {13336, -1, -1, -1}, {13337, -1, -1, -1}, {13338, -1, -1, -1}, {13339, -1, -1, -1}, {13340, -1, -1, -1}, {13341, -1, -1, -1}, {13342, -1, -1, -1}, {13343, -1, -1, -1}, {13344, -1, -1, -1}, {13345, -1, -1, -1}, {13346, -1, -1, -1}, {13347, -1, -1, -1}, {13348, -1, -1, -1}, {13349, -1, -1, -1}, {13350, -1, -1, -1}, {13351, -1, -1, -1}, {13352, -1, -1, -1}, {13353, -1, -1, -1}, {13354, -1, -1, -1}, {13355, -1, -1, -1}, {13356, -1, -1, -1}, {13357, -1, -1, -1}, {13358, -1, -1, -1}, {13359, -1, -1, -1}, {13360, -1, -1, -1}, {13361, -1, -1, -1}, {13362, -1, -1, -1}, {13363, -1, -1, -1}, {13364, -1, -1, -1}, {13365, -1, -1, -1}, {13366, -1, -1, -1}, {13367, -1, -1, -1}, {13368, -1, -1, -1}, {13369, -1, -1, -1}, {13370, -1, -1, -1}, {13371, -1, -1, -1}, {13372, -1, -1, -1}, {13373, -1, -1, -1}, {13374, -1, -1, -1}, {13375, -1, -1, -1}, {13376, -1, -1, -1}, {13377, -1, -1, -1}, {13378, -1, -1, -1}, {13379, -1, -1, -1}, {13380, -1, -1, -1}, {13381, -1, -1, -1}, {13382, -1, -1, -1}, {13384, -1, -1, -1}, {13385, -1, -1, -1}, {13386, -1, -1, -1}, {13387, -1, -1, -1}, {13388, -1, -1, -1}, {13389, -1, -1, -1}, {13390, -1, -1, -1}, {13391, -1, -1, -1}, {13392, -1, -1, -1}, {13393, -1, -1, -1}, {13394, -1, -1, -1}, {13395, -1, -1, -1}, {13396, -1, -1, -1}, {13397, -1, -1, -1}, {13398, -1, -1, -1}, {13399, -1, -1, -1}, {13400, -1, -1, -1}, {13401, -1, -1, -1}, {13402, -1, -1, -1}, {13403, -1, -1, -1}, {13404, -1, -1, -1}, {13405, -1, -1, -1}, {13406, -1, -1, -1}, {13407, -1, -1, -1}, {13408, -1, -1, -1}, {13409, -1, -1, -1}, {13410, -1, -1, -1}, {13411, -1, -1, -1}, {13412, -1, -1, -1}, {13413, -1, -1, -1}, {13414, -1, -1, -1}, {13415, -1, -1, -1}, {13416, -1, -1, -1}, {13417, -1, -1, -1}, {13418, -1, -1, -1}, {13419, -1, -1, -1}, {13420, -1, -1, -1}, {13421, -1, -1, -1}, {13422, -1, -1, -1}, {13423, -1, -1, -1}, {13424, -1, -1, -1}, {13425, -1, -1, -1}, {13426, -1, -1, -1}, {13428, -1, -1, -1}, {13429, -1, -1, -1}, {13430, -1, -1, -1}, {13431, -1, -1, -1}, {13432, -1, -1, -1}, {13433, -1, -1, -1}, {13434, -1, -1, -1}, {13435, -1, -1, -1}, {13436, -1, -1, -1}, {13437, -1, -1, -1}, {13438, -1, -1, -1}, {13439, -1, -1, -1}, {13440, -1, -1, -1}, {13441, -1, -1, -1}, {13442, -1, -1, -1}, {13443, -1, -1, -1}, {13444, -1, -1, -1}, {13445, -1, -1, -1}, {13446, -1, -1, -1}, {13447, -1, -1, -1}, {13448, -1, -1, -1}, {13449, -1, -1, -1}, {13450, -1, -1, -1}, {13451, -1, -1, -1}, {13452, -1, -1, -1}, {13453, -1, -1, -1}, {13454, -1, -1, -1}, {13455, -1, -1, -1}, {13456, -1, -1, -1}, {13457, -1, -1, -1}, {13458, -1, -1, -1}, {13459, -1, -1, -1}, {13460, -1, -1, -1}, {13461, -1, -1, -1}, {13462, -1, -1, -1}, {13463, -1, -1, -1}, {13464, -1, -1, -1}, {13465, -1, -1, -1}, {13466, -1, -1, -1}, {13467, -1, -1, -1}, {13468, -1, -1, -1}, {13469, -1, -1, -1}, {13470, -1, -1, -1}, {13471, -1, -1, -1}, {13472, -1, -1, -1}, {13473, -1, -1, -1}, {13474, -1, -1, -1}, {13475, -1, -1, -1}, {13476, -1, -1, -1}, {13477, -1, -1, -1}, {13478, -1, -1, -1}, {13479, -1, -1, -1}, {13480, -1, -1, -1}, {13481, -1, -1, -1}, {13482, -1, -1, -1}, {13483, -1, -1, -1}, {13484, -1, -1, -1}, {13485, -1, -1, -1}, {13486, -1, -1, -1}, {13487, -1, -1, -1}, {13488, -1, -1, -1}, {13489, -1, -1, -1}, {13490, -1, -1, -1}, {13491, -1, -1, -1}, {13492, -1, -1, -1}, {13493, -1, -1, -1}, {13494, -1, -1, -1}, {13495, -1, -1, -1}, {13496, -1, -1, -1}, {13497, -1, -1, -1}, {13498, -1, -1, -1}, {13499, -1, -1, -1}, {13500, -1, -1, -1}, {13501, -1, -1, -1}, {13502, -1, -1, -1}, {13503, -1, -1, -1}, {13504, -1, -1, -1}, {13505, -1, -1, -1}, {13506, -1, -1, -1}, {13507, -1, -1, -1}, {13508, -1, -1, -1}, {13509, -1, -1, -1}, {13510, -1, -1, -1}, {13511, -1, -1, -1}, {13512, -1, -1, -1}, {13513, -1, -1, -1}, {13514, -1, -1, -1}, {13515, -1, -1, -1}, {13516, -1, -1, -1}, {13517, -1, -1, -1}, {13518, -1, -1, -1}, {13519, -1, -1, -1}, {13520, -1, -1, -1}, {13521, -1, -1, -1}, {13522, -1, -1, -1}, {13523, -1, -1, -1}, {13524, -1, -1, -1}, {13525, -1, -1, -1}, {13526, -1, -1, -1}, {13527, -1, -1, -1}, {13528, -1, -1, -1}, {13529, -1, -1, -1}, {13530, -1, -1, -1}, {13531, -1, -1, -1}, {13532, -1, -1, -1}, {13533, -1, -1, -1}, {13534, -1, -1, -1}, {13535, -1, -1, -1}, {13536, -1, -1, -1}, {13537, -1, -1, -1}, {13538, -1, -1, -1}, {13539, -1, -1, -1}, {13540, -1, -1, -1}, {13541, -1, -1, -1}, {13542, -1, -1, -1}, {13543, -1, -1, -1}, {13544, -1, -1, -1}, {13545, -1, -1, -1}, {13546, -1, -1, -1}, {13547, -1, -1, -1}, {13548, -1, -1, -1}, {13549, -1, -1, -1}, {13550, -1, -1, -1}, {13551, -1, -1, -1}, {13552, -1, -1, -1}, {13553, -1, -1, -1}, {13554, -1, -1, -1}, {13555, -1, -1, -1}, {13556, -1, -1, -1}, {13557, -1, -1, -1}, {13558, -1, -1, -1}, {13559, -1, -1, -1}, {13560, -1, -1, -1}, {13561, -1, -1, -1}, {13562, -1, -1, -1}, {13563, -1, -1, -1}, {13564, -1, -1, -1}, {13565, -1, -1, -1}, {13566, -1, -1, -1}, {13567, -1, -1, -1}, {13568, -1, -1, -1} },
    {{13569, -1, -1, -1}, {13570, -1, -1, -1}, {13571, -1, -1, -1}, {13572, -1, -1, -1}, {13573, -1, -1, -1}, {13574, -1, -1, -1}, {13575, -1, -1, -1}, {13576, -1, -1, -1}, {13577, -1, -1, -1}, {13578, -1, -1, -1}, {13579, -1, -1, -1}, {13580, -1, -1, -1}, {13581, -1, -1, -1}, {13582, -1, -1, -1}, {13583, -1, -1, -1}, {13584, -1, -1, -1}, {13585, -1, -1, -1}, {13586, -1, -1, -1}, {13587, -1, -1, -1}, {13588, -1, -1, -1}, {13589, -1, -1, -1}, {13590, -1, -1, -1}, {13591, -1, -1, -1}, {13592, -1, -1, -1}, {13593, -1, -1, -1}, {13594, -1, -1, -1}, {13595, -1, -1, -1}, {13596, -1, -1, -1}, {13597, -1, -1, -1}, {13598, -1, -1, -1}, {13599, -1, -1, -1}, {13600, -1, -1, -1}, {13601, -1, -1, -1}, {13602, -1, -1, -1}, {13603, -1, -1, -1}, {13604, -1, -1, -1}, {13605, -1, -1, -1}, {13606, -1, -1, -1}, {13607, -1, -1, -1}, {13608, -1, -1, -1}, {13609, -1, -1, -1}, {13610, -1, -1, -1}, {13611, -1, -1, -1}, {13612, -1, -1, -1}, {13613, -1, -1, -1}, {13614, -1, -1, -1}, {13615, -1, -1, -1}, {13616, -1, -1, -1}, {13617, -1, -1, -1}, {13618, -1, -1, -1}, {13619, -1, -1, -1}, {13620, -1, -1, -1}, {13621, -1, -1, -1}, {13622, -1, -1, -1}, {13623, -1, -1, -1}, {13624, -1, -1, -1}, {13625, -1, -1, -1}, {13626, -1, -1, -1}, {13627, -1, -1, -1}, {13628, -1, -1, -1}, {13629, -1, -1, -1}, {13630, -1, -1, -1}, {13631, -1, -1, -1}, {13632, -1, -1, -1}, {13633, -1, -1, -1}, {13634, -1, -1, -1}, {13635, -1, -1, -1}, {13636, -1, -1, -1}, {13637, -1, -1, -1}, {13638, -1, -1, -1}, {13639, -1, -1, -1}, {13640, -1, -1, -1}, {13641, -1, -1, -1}, {13642, -1, -1, -1}, {13643, -1, -1, -1}, {13644, -1, -1, -1}, {13645, -1, -1, -1}, {13646, -1, -1, -1}, {13647, -1, -1, -1}, {13648, -1, -1, -1}, {13649, -1, -1, -1}, {13650, -1, -1, -1}, {13651, -1, -1, -1}, {13652, -1, -1, -1}, {13653, -1, -1, -1}, {13654, -1, -1, -1}, {13655, -1, -1, -1}, {13656, -1, -1, -1}, {13657, -1, -1, -1}, {13658, -1, -1, -1}, {13659, -1, -1, -1}, {13660, -1, -1, -1}, {13661, -1, -1, -1}, {13662, -1, -1, -1}, {13663, -1, -1, -1}, {13664, -1, -1, -1}, {13665, -1, -1, -1}, {13666, -1, -1, -1}, {13667, -1, -1, -1}, {13668, -1, -1, -1}, {13669, -1, -1, -1}, {13670, -1, -1, -1}, {13671, -1, -1, -1}, {13672, -1, -1, -1}, {13673, -1, -1, -1}, {13674, -1, -1, -1}, {13675, -1, -1, -1}, {13676, -1, -1, -1}, {13677, -1, -1, -1}, {13678, -1, -1, -1}, {13679, -1, -1, -1}, {13680, -1, -1, -1}, {13681, -1, -1, -1}, {13682, -1, -1, -1}, {13683, -1, -1, -1}, {13684, -1, -1, -1}, {13685, -1, -1, -1}, {13686, -1, -1, -1}, {13687, -1, -1, -1}, {13688, -1, -1, -1}, {13689, -1, -1, -1}, {13690, -1, -1, -1}, {13691, -1, -1, -1}, {13692, -1, -1, -1}, {13693, -1, -1, -1}, {13694, -1, -1, -1}, {13695, -1, -1, -1}, {13696, -1, -1, -1}, {13697, -1, -1, -1}, {13698, -1, -1, -1}, {13699, -1, -1, -1}, {13700, -1, -1, -1}, {13701, -1, -1, -1}, {13702, -1, -1, -1}, {13703, -1, -1, -1}, {13704, -1, -1, -1}, {13705, -1, -1, -1}, {13706, -1, -1, -1}, {13707, -1, -1, -1}, {13708, -1, -1, -1}, {13709, -1, -1, -1}, {13710, -1, -1, -1}, {13711, -1, -1, -1}, {13712, -1, -1, -1}, {13713, -1, -1, -1}, {13714, -1, -1, -1}, {13715, -1, -1, -1}, {13716, -1, -1, -1}, {13717, -1, -1, -1}, {13718, -1, -1, -1}, {13719, -1, -1, -1}, {13720, -1, -1, -1}, {13721, -1, -1, -1}, {13722, -1, -1, -1}, {13723, -1, -1, -1}, {13724, -1, -1, -1}, {13725, -1, -1, -1}, {13727, -1, -1, -1}, {13728, -1, -1, -1}, {13729, -1, -1, -1}, {13730, -1, -1, -1}, {13731, -1, -1, -1}, {13732, -1, -1, -1}, {13733, -1, -1, -1}, {13734, -1, -1, -1}, {13735, -1, -1, -1}, {13736, -1, -1, -1}, {13737, -1, -1, -1}, {13738, -1, -1, -1}, {13739, -1, -1, -1}, {13740, -1, -1, -1}, {13741, -1, -1, -1}, {13742, -1, -1, -1}, {13743, -1, -1, -1}, {13744, -1, -1, -1}, {13745, -1, -1, -1}, {13746, -1, -1, -1}, {13747, -1, -1, -1}, {13748, -1, -1, -1}, {13749, -1, -1, -1}, {13750, -1, -1, -1}, {13751, -1, -1, -1}, {13752, -1, -1, -1}, {13753, -1, -1, -1}, {13754, -1, -1, -1}, {13755, -1, -1, -1}, {13756, -1, -1, -1}, {13757, -1, -1, -1}, {13758, -1, -1, -1}, {13759, -1, -1, -1}, {13760, -1, -1, -1}, {13761, -1, -1, -1}, {13762, -1, -1, -1}, {13763, -1, -1, -1}, {13764, -1, -1, -1}, {13765, -1, -1, -1}, {13766, -1, -1, -1}, {13767, -1, -1, -1}, {13768, -1, -1, -1}, {13769, -1, -1, -1}, {13770, -1, -1, -1}, {13771, -1, -1, -1}, {13772, -1, -1, -1}, {13773, -1, -1, -1}, {13774, -1, -1, -1}, {13775, -1, -1, -1}, {13776, -1, -1, -1}, {13777, -1, -1, -1}, {13778, -1, -1, -1}, {13779, -1, -1, -1}, {13780, -1, -1, -1}, {13781, -1, -1, -1}, {13782, -1, -1, -1}, {13783, -1, -1, -1}, {13784, -1, -1, -1}, {13785, -1, -1, -1}, {13786, -1, -1, -1}, {13787, -1, -1, -1}, {13788, -1, -1, -1}, {13789, -1, -1, -1}, {13790, -1, -1, -1}, {13791, -1, -1, -1}, {13792, -1, -1, -1}, {13793, -1, -1, -1}, {13794, -1, -1, -1}, {13795, -1, -1, -1}, {13796, -1, -1, -1}, {13797, -1, -1, -1}, {13798, -1, -1, -1}, {13799, -1, -1, -1}, {13800, -1, -1, -1}, {13801, -1, -1, -1}, {13802, -1, -1, -1}, {13803, -1, -1, -1}, {13804, -1, -1, -1}, {13805, -1, -1, -1}, {13806, -1, -1, -1}, {13807, -1, -1, -1}, {13808, -1, -1, -1}, {13809, -1, -1, -1}, {13810, -1, -1, -1}, {13811, -1, -1, -1}, {13812, -1, -1, -1}, {13813, -1, -1, -1}, {13814, -1, -1, -1}, {13815, -1, -1, -1}, {13816, -1, -1, -1}, {13817, -1, -1, -1}, {13818, -1, -1, -1}, {13819, -1, -1, -1}, {13820, -1, -1, -1}, {13821, -1, -1, -1}, {13822, -1, -1, -1}, {13823, -1, -1, -1}, {13824, -1, -1, -1}, {13825, -1, -1, -1} },
    {{13826, -1, -1, -1}, {13827, -1, -1, -1}, {13828, -1, -1, -1}, {13829, -1, -1, -1}, {13830, -1, -1, -1}, {13831, -1, -1, -1}, {13832, -1, -1, -1}, {13833, -1, -1, -1}, {13834, -1, -1, -1}, {13835, -1, -1, -1}, {13836, -1, -1, -1}, {13837, -1, -1, -1}, {13839, -1, -1, -1}, {13840, -1, -1, -1}, {13841, -1, -1, -1}, {13842, -1, -1, -1}, {13843, -1, -1, -1}, {13844, -1, -1, -1}, {13845, -1, -1, -1}, {13846, -1, -1, -1}, {13847, -1, -1, -1}, {13848, -1, -1, -1}, {13849, -1, -1, -1}, {13851, -1, -1, -1}, {13852, -1, -1, -1}, {13853, -1, -1, -1}, {13854, -1, -1, -1}, {13855, -1, -1, -1}, {13856, -1, -1, -1}, {13857, -1, -1, -1}, {13858, -1, -1, -1}, {13859, -1, -1, -1}, {13860, -1, -1, -1}, {13861, -1, -1, -1}, {13862, -1, -1, -1}, {13863, -1, -1, -1}, {13864, -1, -1, -1}, {13865, -1, -1, -1}, {13866, -1, -1, -1}, {13867, -1, -1, -1}, {13868, -1, -1, -1}, {13869, -1, -1, -1}, {13870, -1, -1, -1}, {13871, -1, -1, -1}, {13872, -1, -1, -1}, {13873, -1, -1, -1}, {13874, -1, -1, -1}, {13875, -1, -1, -1}, {13876, -1, -1, -1}, {13877, -1, -1, -1}, {13878, -1, -1, -1}, {13879, -1, -1, -1}, {13880, -1, -1, -1}, {13881, -1, -1, -1}, {13882, -1, -1, -1}, {13883, -1, -1, -1}, {13884, -1, -1, -1}, {13885, -1, -1, -1}, {13886, -1, -1, -1}, {13887, -1, -1, -1}, {13888, -1, -1, -1}, {13889, -1, -1, -1}, {13890, -1, -1, -1}, {13891, -1, -1, -1}, {13892, -1, -1, -1}, {13893, -1, -1, -1}, {13894, -1, -1, -1}, {13895, -1, -1, -1}, {13896, -1, -1, -1}, {13897, -1, -1, -1}, {13898, -1, -1, -1}, {13899, -1, -1, -1}, {13900, -1, -1, -1}, {13901, -1, -1, -1}, {13902, -1, -1, -1}, {13903, -1, -1, -1}, {13904, -1, -1, -1}, {13905, -1, -1, -1}, {13906, -1, -1, -1}, {13907, -1, -1, -1}, {13908, -1, -1, -1}, {13909, -1, -1, -1}, {13910, -1, -1, -1}, {13911, -1, -1, -1}, {13912, -1, -1, -1}, {13913, -1, -1, -1}, {13914, -1, -1, -1}, {13915, -1, -1, -1}, {13916, -1, -1, -1}, {13917, -1, -1, -1}, {13918, -1, -1, -1}, {13919, -1, -1, -1}, {13920, -1, -1, -1}, {13921, -1, -1, -1}, {13922, -1, -1, -1}, {13923, -1, -1, -1}, {13924, -1, -1, -1}, {13925, -1, -1, -1}, {13926, -1, -1, -1}, {13927, -1, -1, -1}, {13928, -1, -1, -1}, {13929, -1, -1, -1}, {13930, -1, -1, -1}, {13931, -1, -1, -1}, {13932, -1, -1, -1}, {13933, -1, -1, -1}, {13934, -1, -1, -1}, {13935, -1, -1, -1}, {13936, -1, -1, -1}, {13937, -1, -1, -1}, {13938, -1, -1, -1}, {13939, -1, -1, -1}, {13940, -1, -1, -1}, {13941, -1, -1, -1}, {13942, -1, -1, -1}, {13943, -1, -1, -1}, {13944, -1, -1, -1}, {13945, -1, -1, -1}, {13946, -1, -1, -1}, {13947, -1, -1, -1}, {13948, -1, -1, -1}, {13949, -1, -1, -1}, {13950, -1, -1, -1}, {13951, -1, -1, -1}, {13952, -1, -1, -1}, {13953, -1, -1, -1}, {13954, -1, -1, -1}, {13955, -1, -1, -1}, {13956, -1, -1, -1}, {13957, -1, -1, -1}, {13958, -1, -1, -1}, {13959, -1, -1, -1}, {13960, -1, -1, -1}, {13961, -1, -1, -1}, {13962, -1, -1, -1}, {13963, -1, -1, -1}, {13964, -1, -1, -1}, {13965, -1, -1, -1}, {13966, -1, -1, -1}, {13967, -1, -1, -1}, {13968, -1, -1, -1}, {13969, -1, -1, -1}, {13970, -1, -1, -1}, {13971, -1, -1, -1}, {13972, -1, -1, -1}, {13973, -1, -1, -1}, {13974, -1, -1, -1}, {13975, -1, -1, -1}, {13976, -1, -1, -1}, {13977, -1, -1, -1}, {13978, -1, -1, -1}, {13979, -1, -1, -1}, {13980, -1, -1, -1}, {13981, -1, -1, -1}, {13982, -1, -1, -1}, {13983, -1, -1, -1}, {13984, -1, -1, -1}, {13985, -1, -1, -1}, {13986, -1, -1, -1}, {13987, -1, -1, -1}, {13988, -1, -1, -1}, {13989, -1, -1, -1}, {13990, -1, -1, -1}, {13991, -1, -1, -1}, {13992, -1, -1, -1}, {13993, -1, -1, -1}, {13994, -1, -1, -1}, {13995, -1, -1, -1}, {13996, -1, -1, -1}, {13997, -1, -1, -1}, {13998, -1, -1, -1}, {13999, -1, -1, -1}, {14000, -1, -1, -1}, {14001, -1, -1, -1}, {14002, -1, -1, -1}, {14003, -1, -1, -1}, {14004, -1, -1, -1}, {14005, -1, -1, -1}, {14006, -1, -1, -1}, {14007, -1, -1, -1}, {14008, -1, -1, -1}, {14009, -1, -1, -1}, {14010, -1, -1, -1}, {14011, -1, -1, -1}, {14012, -1, -1, -1}, {14013, -1, -1, -1}, {14014, -1, -1, -1}, {14015, -1, -1, -1}, {14016, -1, -1, -1}, {14017, -1, -1, -1}, {14018, -1, -1, -1}, {14019, -1, -1, -1}, {14020, -1, -1, -1}, {14021, -1, -1, -1}, {14022, -1, -1, -1}, {14023, -1, -1, -1}, {14024, -1, -1, -1}, {14025, -1, -1, -1}, {14026, -1, -1, -1}, {14027, -1, -1, -1}, {14028, -1, -1, -1}, {14029, -1, -1, -1}, {14030, -1, -1, -1}, {14031, -1, -1, -1}, {14032, -1, -1, -1}, {14033, -1, -1, -1}, {14034, -1, -1, -1}, {14035, -1, -1, -1}, {14036, -1, -1, -1}, {14037, -1, -1, -1}, {14038, -1, -1, -1}, {14039, -1, -1, -1}, {14040, -1, -1, -1}, {14041, -1, -1, -1}, {14042, -1, -1, -1}, {14043, -1, -1, -1}, {14044, -1, -1, -1}, {14045, -1, -1, -1}, {14046, -1, -1, -1}, {14047, -1, -1, -1}, {14048, -1, -1, -1}, {14049, -1, -1, -1}, {14050, -1, -1, -1}, {14051, -1, -1, -1}, {14052, -1, -1, -1}, {14053, -1, -1, -1}, {14054, -1, -1, -1}, {14055, -1, -1, -1}, {14056, -1, -1, -1}, {14057, -1, -1, -1}, {14058, -1, -1, -1}, {14059, -1, -1, -1}, {14060, -1, -1, -1}, {14061, -1, -1, -1}, {14062, -1, -1, -1}, {14063, -1, -1, -1}, {14064, -1, -1, -1}, {14065, -1, -1, -1}, {14066, -1, -1, -1}, {14067, -1, -1, -1}, {14068, -1, -1, -1}, {14069, -1, -1, -1}, {14070, -1, -1, -1}, {14071, -1, -1, -1}, {14072, -1, -1, -1}, {14073, -1, -1, -1}, {14074, -1, -1, -1}, {14075, -1, -1, -1}, {14076, -1, -1, -1}, {14077, -1, -1, -1}, {14078, -1, -1, -1}, {14079, -1, -1, -1}, {14080, -1, -1, -1}, {14081, -1, -1, -1}, {14082, -1, -1, -1}, {14083, -1, -1, -1} },
    {{14084, -1, -1, -1}, {14085, -1, -1, -1}, {14086, -1, -1, -1}, {14087, -1, -1, -1}, {14088, -1, -1, -1}, {14089, -1, -1, -1}, {14090, -1, -1, -1}, {14091, -1, -1, -1}, {14092, -1, -1, -1}, {14093, -1, -1, -1}, {14094, -1, -1, -1}, {14095, -1, -1, -1}, {14096, -1, -1, -1}, {14097, -1, -1, -1}, {14098, -1, -1, -1}, {14099, -1, -1, -1}, {14100, -1, -1, -1}, {14101, -1, -1, -1}, {14102, -1, -1, -1}, {14103, -1, -1, -1}, {14104, -1, -1, -1}, {14105, -1, -1, -1}, {14106, -1, -1, -1}, {14107, -1, -1, -1}, {14108, -1, -1, -1}, {14109, -1, -1, -1}, {14110, -1, -1, -1}, {14111, -1, -1, -1}, {14112, -1, -1, -1}, {14113, -1, -1, -1}, {14114, -1, -1, -1}, {14115, -1, -1, -1}, {14116, -1, -1, -1}, {14117, -1, -1, -1}, {14118, -1, -1, -1}, {14119, -1, -1, -1}, {14120, -1, -1, -1}, {14121, -1, -1, -1}, {14122, -1, -1, -1}, {14123, -1, -1, -1}, {14124, -1, -1, -1}, {14125, -1, -1, -1}, {14126, -1, -1, -1}, {14127, -1, -1, -1}, {14128, -1, -1, -1}, {14129, -1, -1, -1}, {14130, -1, -1, -1}, {14131, -1, -1, -1}, {14132, -1, -1, -1}, {14133, -1, -1, -1}, {14134, -1, -1, -1}, {14135, -1, -1, -1}, {14136, -1, -1, -1}, {14137, -1, -1, -1}, {14138, -1, -1, -1}, {14139, -1, -1, -1}, {14140, -1, -1, -1}, {14141, -1, -1, -1}, {14142, -1, -1, -1}, {14143, -1, -1, -1}, {14144, -1, -1, -1}, {14145, -1, -1, -1}, {14146, -1, -1, -1}, {14147, -1, -1, -1}, {14148, -1, -1, -1}, {14149, -1, -1, -1}, {14150, -1, -1, -1}, {14151, -1, -1, -1}, {14152, -1, -1, -1}, {14153, -1, -1, -1}, {14154, -1, -1, -1}, {14155, -1, -1, -1}, {14156, -1, -1, -1}, {14157, -1, -1, -1}, {14158, -1, -1, -1}, {14159, -1, -1, -1}, {14160, -1, -1, -1}, {14161, -1, -1, -1}, {14162, -1, -1, -1}, {14163, -1, -1, -1}, {14164, -1, -1, -1}, {14165, -1, -1, -1}, {14166, -1, -1, -1}, {14167, -1, -1, -1}, {14168, -1, -1, -1}, {14169, -1, -1, -1}, {14170, -1, -1, -1}, {14171, -1, -1, -1}, {14172, -1, -1, -1}, {14173, -1, -1, -1}, {14174, -1, -1, -1}, {14175, -1, -1, -1}, {14176, -1, -1, -1}, {14177, -1, -1, -1}, {14178, -1, -1, -1}, {14179, -1, -1, -1}, {14180, -1, -1, -1}, {14181, -1, -1, -1}, {14182, -1, -1, -1}, {14183, -1, -1, -1}, {14184, -1, -1, -1}, {14185, -1, -1, -1}, {14186, -1, -1, -1}, {14187, -1, -1, -1}, {14188, -1, -1, -1}, {14189, -1, -1, -1}, {14190, -1, -1, -1}, {14191, -1, -1, -1}, {14192, -1, -1, -1}, {14193, -1, -1, -1}, {14194, -1, -1, -1}, {14195, -1, -1, -1}, {14196, -1, -1, -1}, {14197, -1, -1, -1}, {14198, -1, -1, -1}, {14199, -1, -1, -1}, {14200, -1, -1, -1}, {14201, -1, -1, -1}, {14202, -1, -1, -1}, {14203, -1, -1, -1}, {14204, -1, -1, -1}, {14205, -1, -1, -1}, {14206, -1, -1, -1}, {14207, -1, -1, -1}, {14208, -1, -1, -1}, {14209, -1, -1, -1}, {14210, -1, -1, -1}, {14211, -1, -1, -1}, {14212, -1, -1, -1}, {14213, -1, -1, -1}, {14214, -1, -1, -1}, {14215, -1, -1, -1}, {14216, -1, -1, -1}, {14217, -1, -1, -1}, {14218, -1, -1, -1}, {14219, -1, -1, -1}, {14220, -1, -1, -1}, {14221, -1, -1, -1}, {14222, -1, -1, -1}, {14223, -1, -1, -1}, {14224, -1, -1, -1}, {14225, -1, -1, -1}, {14226, -1, -1, -1}, {14227, -1, -1, -1}, {14228, -1, -1, -1}, {14229, -1, -1, -1}, {14230, -1, -1, -1}, {14231, -1, -1, -1}, {14232, -1, -1, -1}, {14233, -1, -1, -1}, {14234, -1, -1, -1}, {14235, -1, -1, -1}, {14236, -1, -1, -1}, {14237, -1, -1, -1}, {14238, -1, -1, -1}, {14239, -1, -1, -1}, {14240, -1, -1, -1}, {14241, -1, -1, -1}, {14242, -1, -1, -1}, {14243, -1, -1, -1}, {14244, -1, -1, -1}, {14245, -1, -1, -1}, {14246, -1, -1, -1}, {14247, -1, -1, -1}, {14248, -1, -1, -1}, {14249, -1, -1, -1}, {14250, -1, -1, -1}, {14251, -1, -1, -1}, {14252, -1, -1, -1}, {14253, -1, -1, -1}, {14254, -1, -1, -1}, {14255, -1, -1, -1}, {14256, -1, -1, -1}, {14257, -1, -1, -1}, {14258, -1, -1, -1}, {14259, -1, -1, -1}, {14260, -1, -1, -1}, {14261, -1, -1, -1}, {14262, -1, -1, -1}, {14263, -1, -1, -1}, {14264, -1, -1, -1}, {14265, -1, -1, -1}, {14266, -1, -1, -1}, {14267, -1, -1, -1}, {14268, -1, -1, -1}, {14269, -1, -1, -1}, {14270, -1, -1, -1}, {14271, -1, -1, -1}, {14272, -1, -1, -1}, {14273, -1, -1, -1}, {14274, -1, -1, -1}, {14275, -1, -1, -1}, {14276, -1, -1, -1}, {14277, -1, -1, -1}, {14278, -1, -1, -1}, {14279, -1, -1, -1}, {14280, -1, -1, -1}, {14281, -1, -1, -1}, {14282, -1, -1, -1}, {14283, -1, -1, -1}, {14284, -1, -1, -1}, {14285, -1, -1, -1}, {14286, -1, -1, -1}, {14287, -1, -1, -1}, {14288, -1, -1, -1}, {14289, -1, -1, -1}, {14290, -1, -1, -1}, {14291, -1, -1, -1}, {14292, -1, -1, -1}, {14293, -1, -1, -1}, {14294, -1, -1, -1}, {14295, -1, -1, -1}, {14296, -1, -1, -1}, {14297, -1, -1, -1}, {14298, -1, -1, -1}, {14299, -1, -1, -1}, {14300, -1, -1, -1}, {14301, -1, -1, -1}, {14302, -1, -1, -1}, {14303, -1, -1, -1}, {14304, -1, -1, -1}, {14305, -1, -1, -1}, {14306, -1, -1, -1}, {14307, -1, -1, -1}, {14308, -1, -1, -1}, {14309, -1, -1, -1}, {14310, -1, -1, -1}, {14311, -1, -1, -1}, {14312, -1, -1, -1}, {14313, -1, -1, -1}, {14314, -1, -1, -1}, {14315, -1, -1, -1}, {14316, -1, -1, -1}, {14317, -1, -1, -1}, {14318, -1, -1, -1}, {14319, -1, -1, -1}, {14320, -1, -1, -1}, {14321, -1, -1, -1}, {14322, -1, -1, -1}, {14323, -1, -1, -1}, {14324, -1, -1, -1}, {14325, -1, -1, -1}, {14326, -1, -1, -1}, {14327, -1, -1, -1}, {14328, -1, -1, -1}, {14329, -1, -1, -1}, {14330, -1, -1, -1}, {14331, -1, -1, -1}, {14332, -1, -1, -1}, {14333, -1, -1, -1}, {14334, -1, -1, -1}, {14335, -1, -1, -1}, {14336, -1, -1, -1}, {14337, -1, -1, -1}, {14338, -1, -1, -1}, {14339, -1, -1, -1} },
    {{14340, -1, -1, -1}, {14341, -1, -1, -1}, {14342, -1, -1, -1}, {14343, -1, -1, -1}, {14344, -1, -1, -1}, {14345, -1, -1, -1}, {14346, -1, -1, -1}, {14347, -1, -1, -1}, {14348, -1, -1, -1}, {14349, -1, -1, -1}, {14350, -1, -1, -1}, {14351, -1, -1, -1}, {14352, -1, -1, -1}, {14353, -1, -1, -1}, {14354, -1, -1, -1}, {14355, -1, -1, -1}, {14356, -1, -1, -1}, {14357, -1, -1, -1}, {14358, -1, -1, -1}, {14359, -1, -1, -1}, {14360, -1, -1, -1}, {14361, -1, -1, -1}, {14362, -1, -1, -1}, {14363, -1, -1, -1}, {14364, -1, -1, -1}, {14365, -1, -1, -1}, {14366, -1, -1, -1}, {14367, -1, -1, -1}, {14368, -1, -1, -1}, {14369, -1, -1, -1}, {14370, -1, -1, -1}, {14371, -1, -1, -1}, {14372, -1, -1, -1}, {14373, -1, -1, -1}, {14374, -1, -1, -1}, {14375, -1, -1, -1}, {14376, -1, -1, -1}, {14377, -1, -1, -1}, {14378, -1, -1, -1}, {14379, -1, -1, -1}, {14380, -1, -1, -1}, {14381, -1, -1, -1}, {14382, -1, -1, -1}, {14383, -1, -1, -1}, {14384, -1, -1, -1}, {14385, -1, -1, -1}, {14386, -1, -1, -1}, {14387, -1, -1, -1}, {14388, -1, -1, -1}, {14389, -1, -1, -1}, {14390, -1, -1, -1}, {14391, -1, -1, -1}, {14392, -1, -1, -1}, {14393, -1, -1, -1}, {14394, -1, -1, -1}, {14395, -1, -1, -1}, {14396, -1, -1, -1}, {14397, -1, -1, -1}, {14398, -1, -1, -1}, {14399, -1, -1, -1}, {14400, -1, -1, -1}, {14401, -1, -1, -1}, {14402, -1, -1, -1}, {14403, -1, -1, -1}, {14404, -1, -1, -1}, {14405, -1, -1, -1}, {14406, -1, -1, -1}, {14407, -1, -1, -1}, {14408, -1, -1, -1}, {14409, -1, -1, -1}, {14410, -1, -1, -1}, {14411, -1, -1, -1}, {14412, -1, -1, -1}, {14413, -1, -1, -1}, {14414, -1, -1, -1}, {14415, -1, -1, -1}, {14416, -1, -1, -1}, {14417, -1, -1, -1}, {14418, -1, -1, -1}, {14419, -1, -1, -1}, {14420, -1, -1, -1}, {14421, -1, -1, -1}, {14422, -1, -1, -1}, {14423, -1, -1, -1}, {14424, -1, -1, -1}, {14425, -1, -1, -1}, {14426, -1, -1, -1}, {14427, -1, -1, -1}, {14428, -1, -1, -1}, {14429, -1, -1, -1}, {14430, -1, -1, -1}, {14431, -1, -1, -1}, {14432, -1, -1, -1}, {14433, -1, -1, -1}, {14434, -1, -1, -1}, {14435, -1, -1, -1}, {14436, -1, -1, -1}, {14437, -1, -1, -1}, {14438, -1, -1, -1}, {14439, -1, -1, -1}, {14440, -1, -1, -1}, {14441, -1, -1, -1}, {14442, -1, -1, -1}, {14443, -1, -1, -1}, {14444, -1, -1, -1}, {14445, -1, -1, -1}, {14446, -1, -1, -1}, {14447, -1, -1, -1}, {14448, -1, -1, -1}, {14449, -1, -1, -1}, {14450, -1, -1, -1}, {14451, -1, -1, -1}, {14452, -1, -1, -1}, {14453, -1, -1, -1}, {14454, -1, -1, -1}, {14455, -1, -1, -1}, {14456, -1, -1, -1}, {14457, -1, -1, -1}, {14458, -1, -1, -1}, {14459, -1, -1, -1}, {14460, -1, -1, -1}, {14461, -1, -1, -1}, {14462, -1, -1, -1}, {14463, -1, -1, -1}, {14464, -1, -1, -1}, {14465, -1, -1, -1}, {14466, -1, -1, -1}, {14467, -1, -1, -1}, {14468, -1, -1, -1}, {14469, -1, -1, -1}, {14470, -1, -1, -1}, {14471, -1, -1, -1}, {14472, -1, -1, -1}, {14473, -1, -1, -1}, {14474, -1, -1, -1}, {14475, -1, -1, -1}, {14476, -1, -1, -1}, {14477, -1, -1, -1}, {14478, -1, -1, -1}, {14479, -1, -1, -1}, {14480, -1, -1, -1}, {14481, -1, -1, -1}, {14482, -1, -1, -1}, {14483, -1, -1, -1}, {14484, -1, -1, -1}, {14485, -1, -1, -1}, {14486, -1, -1, -1}, {14487, -1, -1, -1}, {14488, -1, -1, -1}, {14489, -1, -1, -1}, {14490, -1, -1, -1}, {14491, -1, -1, -1}, {14492, -1, -1, -1}, {14493, -1, -1, -1}, {14494, -1, -1, -1}, {14495, -1, -1, -1}, {14496, -1, -1, -1}, {14497, -1, -1, -1}, {14498, -1, -1, -1}, {14499, -1, -1, -1}, {14500, -1, -1, -1}, {14501, -1, -1, -1}, {14502, -1, -1, -1}, {14503, -1, -1, -1}, {14504, -1, -1, -1}, {14505, -1, -1, -1}, {14506, -1, -1, -1}, {14507, -1, -1, -1}, {14508, -1, -1, -1}, {14509, -1, -1, -1}, {14510, -1, -1, -1}, {14511, -1, -1, -1}, {14512, -1, -1, -1}, {14513, -1, -1, -1}, {14514, -1, -1, -1}, {14515, -1, -1, -1}, {14516, -1, -1, -1}, {14517, -1, -1, -1}, {14518, -1, -1, -1}, {14519, -1, -1, -1}, {14520, -1, -1, -1}, {14521, -1, -1, -1}, {14522, -1, -1, -1}, {14523, -1, -1, -1}, {14524, -1, -1, -1}, {14525, -1, -1, -1}, {14526, -1, -1, -1}, {14527, -1, -1, -1}, {14528, -1, -1, -1}, {14529, -1, -1, -1}, {14530, -1, -1, -1}, {14531, -1, -1, -1}, {14532, -1, -1, -1}, {14533, -1, -1, -1}, {14534, -1, -1, -1}, {14535, -1, -1, -1}, {14536, -1, -1, -1}, {14537, -1, -1, -1}, {14538, -1, -1, -1}, {14539, -1, -1, -1}, {14540, -1, -1, -1}, {14541, -1, -1, -1}, {14542, -1, -1, -1}, {14543, -1, -1, -1}, {14544, -1, -1, -1}, {14545, -1, -1, -1}, {14546, -1, -1, -1}, {14547, -1, -1, -1}, {14548, -1, -1, -1}, {14549, -1, -1, -1}, {14550, -1, -1, -1}, {14551, -1, -1, -1}, {14552, -1, -1, -1}, {14553, -1, -1, -1}, {14554, -1, -1, -1}, {14555, -1, -1, -1}, {14556, -1, -1, -1}, {14557, -1, -1, -1}, {14558, -1, -1, -1}, {14559, -1, -1, -1}, {14560, -1, -1, -1}, {14561, -1, -1, -1}, {14562, -1, -1, -1}, {14563, -1, -1, -1}, {14564, -1, -1, -1}, {14565, -1, -1, -1}, {14566, -1, -1, -1}, {14567, -1, -1, -1}, {14568, -1, -1, -1}, {14569, -1, -1, -1}, {14570, -1, -1, -1}, {14571, -1, -1, -1}, {14572, -1, -1, -1}, {14573, -1, -1, -1}, {14574, -1, -1, -1}, {14575, -1, -1, -1}, {14576, -1, -1, -1}, {14577, -1, -1, -1}, {14578, -1, -1, -1}, {14579, -1, -1, -1}, {14580, -1, -1, -1}, {14581, -1, -1, -1}, {14582, -1, -1, -1}, {14583, -1, -1, -1}, {14584, -1, -1, -1}, {14585, -1, -1, -1}, {14586, -1, -1, -1}, {14587, -1, -1, -1}, {14588, -1, -1, -1}, {14589, -1, -1, -1}, {14590, -1, -1, -1}, {14591, -1, -1, -1}, {14592, -1, -1, -1}, {14593, -1, -1, -1}, {14594, -1, -1, -1}, {14595, -1, -1, -1} },
    {{14596, -1, -1, -1}, {14597, -1, -1, -1}, {14598, -1, -1, -1}, {14599, -1, -1, -1}, {14600, -1, -1, -1}, {14601, -1, -1, -1}, {14602, -1, -1, -1}, {14603, -1, -1, -1}, {14604, -1, -1, -1}, {14605, -1, -1, -1}, {14606, -1, -1, -1}, {14607, -1, -1, -1}, {14608, -1, -1, -1}, {14609, -1, -1, -1}, {14610, -1, -1, -1}, {14611, -1, -1, -1}, {14612, -1, -1, -1}, {14613, -1, -1, -1}, {14614, -1, -1, -1}, {14615, -1, -1, -1}, {14617, -1, -1, -1}, {14618, -1, -1, -1}, {14619, -1, -1, -1}, {14620, -1, -1, -1}, {14621, -1, -1, -1}, {14622, -1, -1, -1}, {14623, -1, -1, -1}, {14624, -1, -1, -1}, {14625, -1, -1, -1}, {14626, -1, -1, -1}, {14627, -1, -1, -1}, {14628, -1, -1, -1}, {14629, -1, -1, -1}, {14630, -1, -1, -1}, {14631, -1, -1, -1}, {14632, -1, -1, -1}, {14633, -1, -1, -1}, {14634, -1, -1, -1}, {14635, -1, -1, -1}, {14636, -1, -1, -1}, {14637, -1, -1, -1}, {14638, -1, -1, -1}, {14639, -1, -1, -1}, {14640, -1, -1, -1}, {14641, -1, -1, -1}, {14642, -1, -1, -1}, {14643, -1, -1, -1}, {14644, -1, -1, -1}, {14645, -1, -1, -1}, {14646, -1, -1, -1}, {14647, -1, -1, -1}, {14648, -1, -1, -1}, {14649, -1, -1, -1}, {14650, -1, -1, -1}, {14651, -1, -1, -1}, {14652, -1, -1, -1}, {14653, -1, -1, -1}, {14654, -1, -1, -1}, {14655, -1, -1, -1}, {14656, -1, -1, -1}, {14657, -1, -1, -1}, {14658, -1, -1, -1}, {14659, -1, -1, -1}, {14660, -1, -1, -1}, {14661, -1, -1, -1}, {14662, -1, -1, -1}, {14663, -1, -1, -1}, {14664, -1, -1, -1}, {14665, -1, -1, -1}, {14666, -1, -1, -1}, {14667, -1, -1, -1}, {14668, -1, -1, -1}, {14669, -1, -1, -1}, {14670, -1, -1, -1}, {14671, -1, -1, -1}, {14672, -1, -1, -1}, {14673, -1, -1, -1}, {14674, -1, -1, -1}, {14675, -1, -1, -1}, {14676, -1, -1, -1}, {14677, -1, -1, -1}, {14678, -1, -1, -1}, {14679, -1, -1, -1}, {14680, -1, -1, -1}, {14681, -1, -1, -1}, {14682, -1, -1, -1}, {14683, -1, -1, -1}, {14684, -1, -1, -1}, {14685, -1, -1, -1}, {14686, -1, -1, -1}, {14687, -1, -1, -1}, {14688, -1, -1, -1}, {14689, -1, -1, -1}, {14690, -1, -1, -1}, {14691, -1, -1, -1}, {14692, -1, -1, -1}, {14693, -1, -1, -1}, {14694, -1, -1, -1}, {14695, -1, -1, -1}, {14696, -1, -1, -1}, {14697, -1, -1, -1}, {14698, -1, -1, -1}, {14699, -1, -1, -1}, {14700, -1, -1, -1}, {14701, -1, -1, -1}, {14703, -1, -1, -1}, {14704, -1, -1, -1}, {14705, -1, -1, -1}, {14706, -1, -1, -1}, {14707, -1, -1, -1}, {14708, -1, -1, -1}, {14709, -1, -1, -1}, {14710, -1, -1, -1}, {14711, -1, -1, -1}, {14712, -1, -1, -1}, {14713, -1, -1, -1}, {14714, -1, -1, -1}, {14715, -1, -1, -1}, {14716, -1, -1, -1}, {14717, -1, -1, -1}, {14718, -1, -1, -1}, {14719, -1, -1, -1}, {14720, -1, -1, -1}, {14721, -1, -1, -1}, {14722, -1, -1, -1}, {14723, -1, -1, -1}, {14724, -1, -1, -1}, {14725, -1, -1, -1}, {14726, -1, -1, -1}, {14727, -1, -1, -1}, {14728, -1, -1, -1}, {14729, -1, -1, -1}, {14730, -1, -1, -1}, {14731, -1, -1, -1}, {14732, -1, -1, -1}, {14733, -1, -1, -1}, {14734, -1, -1, -1}, {14735, -1, -1, -1}, {14736, -1, -1, -1}, {14737, -1, -1, -1}, {14738, -1, -1, -1}, {14739, -1, -1, -1}, {14740, -1, -1, -1}, {14741, -1, -1, -1}, {14742, -1, -1, -1}, {14743, -1, -1, -1}, {14744, -1, -1, -1}, {14745, -1, -1, -1}, {14746, -1, -1, -1}, {14747, -1, -1, -1}, {14748, -1, -1, -1}, {14749, -1, -1, -1}, {14750, -1, -1, -1}, {14751, -1, -1, -1}, {14752, -1, -1, -1}, {14753, -1, -1, -1}, {14754, -1, -1, -1}, {14755, -1, -1, -1}, {14756, -1, -1, -1}, {14757, -1, -1, -1}, {14758, -1, -1, -1}, {14759, -1, -1, -1}, {14760, -1, -1, -1}, {14761, -1, -1, -1}, {14762, -1, -1, -1}, {14763, -1, -1, -1}, {14764, -1, -1, -1}, {14765, -1, -1, -1}, {14766, -1, -1, -1}, {14767, -1, -1, -1}, {14768, -1, -1, -1}, {14769, -1, -1, -1}, {14770, -1, -1, -1}, {14771, -1, -1, -1}, {14772, -1, -1, -1}, {14773, -1, -1, -1}, {14774, -1, -1, -1}, {14775, -1, -1, -1}, {14776, -1, -1, -1}, {14777, -1, -1, -1}, {14778, -1, -1, -1}, {14779, -1, -1, -1}, {14780, -1, -1, -1}, {14781, -1, -1, -1}, {14782, -1, -1, -1}, {14783, -1, -1, -1}, {14784, -1, -1, -1}, {14785, -1, -1, -1}, {14786, -1, -1, -1}, {14787, -1, -1, -1}, {14788, -1, -1, -1}, {14789, -1, -1, -1}, {14790, -1, -1, -1}, {14791, -1, -1, -1}, {14792, -1, -1, -1}, {14793, -1, -1, -1}, {14794, -1, -1, -1}, {14795, -1, -1, -1}, {14796, -1, -1, -1}, {14797, -1, -1, -1}, {14798, -1, -1, -1}, {14801, -1, -1, -1}, {14802, -1, -1, -1}, {14803, -1, -1, -1}, {14804, -1, -1, -1}, {14805, -1, -1, -1}, {14806, -1, -1, -1}, {14807, -1, -1, -1}, {14808, -1, -1, -1}, {14809, -1, -1, -1}, {14810, -1, -1, -1}, {14811, -1, -1, -1}, {14812, -1, -1, -1}, {14813, -1, -1, -1}, {14814, -1, -1, -1}, {14816, -1, -1, -1}, {14817, -1, -1, -1}, {14818, -1, -1, -1}, {14819, -1, -1, -1}, {14820, -1, -1, -1}, {14821, -1, -1, -1}, {14822, -1, -1, -1}, {14823, -1, -1, -1}, {14824, -1, -1, -1}, {14825, -1, -1, -1}, {14826, -1, -1, -1}, {14827, -1, -1, -1}, {14828, -1, -1, -1}, {14829, -1, -1, -1}, {14830, -1, -1, -1}, {14831, -1, -1, -1}, {14832, -1, -1, -1}, {14833, -1, -1, -1}, {14834, -1, -1, -1}, {14835, -1, -1, -1}, {14836, -1, -1, -1}, {14837, -1, -1, -1}, {14838, -1, -1, -1}, {14839, -1, -1, -1}, {14840, -1, -1, -1}, {14841, -1, -1, -1}, {14842, -1, -1, -1}, {14843, -1, -1, -1}, {14844, -1, -1, -1}, {14845, -1, -1, -1}, {14846, -1, -1, -1}, {14847, -1, -1, -1}, {14848, -1, -1, -1}, {14849, -1, -1, -1}, {14850, -1, -1, -1}, {14851, -1, -1, -1}, {14852, -1, -1, -1}, {14853, -1, -1, -1}, {14854, -1, -1, -1}, {14855, -1, -1, -1}, {14856, -1, -1, -1} },
    {{14857, -1, -1, -1}, {14858, -1, -1, -1}, {14859, -1, -1, -1}, {14860, -1, -1, -1}, {14861, -1, -1, -1}, {14862, -1, -1, -1}, {14863, -1, -1, -1}, {14864, -1, -1, -1}, {14865, -1, -1, -1}, {14866, -1, -1, -1}, {14867, -1, -1, -1}, {14868, -1, -1, -1}, {14869, -1, -1, -1}, {14870, -1, -1, -1}, {14871, -1, -1, -1}, {14872, -1, -1, -1}, {14873, -1, -1, -1}, {14874, -1, -1, -1}, {14875, -1, -1, -1}, {14876, -1, -1, -1}, {14877, -1, -1, -1}, {14878, -1, -1, -1}, {14879, -1, -1, -1}, {14880, -1, -1, -1}, {14881, -1, -1, -1}, {14882, -1, -1, -1}, {14883, -1, -1, -1}, {14884, -1, -1, -1}, {14885, -1, -1, -1}, {14886, -1, -1, -1}, {14887, -1, -1, -1}, {14888, -1, -1, -1}, {14889, -1, -1, -1}, {14890, -1, -1, -1}, {14891, -1, -1, -1}, {14892, -1, -1, -1}, {14893, -1, -1, -1}, {14894, -1, -1, -1}, {14895, -1, -1, -1}, {14896, -1, -1, -1}, {14897, -1, -1, -1}, {14898, -1, -1, -1}, {14899, -1, -1, -1}, {14900, -1, -1, -1}, {14901, -1, -1, -1}, {14902, -1, -1, -1}, {14903, -1, -1, -1}, {14904, -1, -1, -1}, {14905, -1, -1, -1}, {14906, -1, -1, -1}, {14907, -1, -1, -1}, {14908, -1, -1, -1}, {14909, -1, -1, -1}, {14910, -1, -1, -1}, {14911, -1, -1, -1}, {14912, -1, -1, -1}, {14913, -1, -1, -1}, {14914, -1, -1, -1}, {14915, -1, -1, -1}, {14916, -1, -1, -1}, {14917, -1, -1, -1}, {14918, -1, -1, -1}, {14919, -1, -1, -1}, {14920, -1, -1, -1}, {14921, -1, -1, -1}, {14922, -1, -1, -1}, {14923, -1, -1, -1}, {14924, -1, -1, -1}, {14925, -1, -1, -1}, {14926, -1, -1, -1}, {14927, -1, -1, -1}, {14928, -1, -1, -1}, {14929, -1, -1, -1}, {14930, -1, -1, -1}, {14931, -1, -1, -1}, {14932, -1, -1, -1}, {14933, -1, -1, -1}, {14934, -1, -1, -1}, {14935, -1, -1, -1}, {14936, -1, -1, -1}, {14937, -1, -1, -1}, {14938, -1, -1, -1}, {14939, -1, -1, -1}, {14940, -1, -1, -1}, {14941, -1, -1, -1}, {14942, -1, -1, -1}, {14943, -1, -1, -1}, {14944, -1, -1, -1}, {14945, -1, -1, -1}, {14946, -1, -1, -1}, {14947, -1, -1, -1}, {14948, -1, -1, -1}, {14949, -1, -1, -1}, {14950, -1, -1, -1}, {14951, -1, -1, -1}, {14952, -1, -1, -1}, {14953, -1, -1, -1}, {14954, -1, -1, -1}, {14955, -1, -1, -1}, {14956, -1, -1, -1}, {14957, -1, -1, -1}, {14958, -1, -1, -1}, {14959, -1, -1, -1}, {14960, -1, -1, -1}, {14961, -1, -1, -1}, {14962, -1, -1, -1}, {14964, -1, -1, -1}, {14965, -1, -1, -1}, {14966, -1, -1, -1}, {14967, -1, -1, -1}, {14968, -1, -1, -1}, {14969, -1, -1, -1}, {14970, -1, -1, -1}, {14971, -1, -1, -1}, {14972, -1, -1, -1}, {14973, -1, -1, -1}, {14974, -1, -1, -1}, {14975, -1, -1, -1}, {14976, -1, -1, -1}, {14977, -1, -1, -1}, {14978, -1, -1, -1}, {14979, -1, -1, -1}, {14980, -1, -1, -1}, {14981, -1, -1, -1}, {14982, -1, -1, -1}, {14983, -1, -1, -1}, {14984, -1, -1, -1}, {14985, -1, -1, -1}, {14986, -1, -1, -1}, {14987, -1, -1, -1}, {14988, -1, -1, -1}, {14989, -1, -1, -1}, {14990, -1, -1, -1}, {14991, -1, -1, -1}, {14992, -1, -1, -1}, {14993, -1, -1, -1}, {14994, -1, -1, -1}, {14995, -1, -1, -1}, {14996, -1, -1, -1}, {14997, -1, -1, -1}, {14998, -1, -1, -1}, {14999, -1, -1, -1}, {15000, -1, -1, -1}, {15001, -1, -1, -1}, {15002, -1, -1, -1}, {15003, -1, -1, -1}, {15004, -1, -1, -1}, {15005, -1, -1, -1}, {15006, -1, -1, -1}, {15007, -1, -1, -1}, {15008, -1, -1, -1}, {15009, -1, -1, -1}, {15010, -1, -1, -1}, {15011, -1, -1, -1}, {15012, -1, -1, -1}, {15013, -1, -1, -1}, {15014, -1, -1, -1}, {15015, -1, -1, -1}, {15016, -1, -1, -1}, {15017, -1, -1, -1}, {15018, -1, -1, -1}, {15019, -1, -1, -1}, {15020, -1, -1, -1}, {15021, -1, -1, -1}, {15022, -1, -1, -1}, {15023, -1, -1, -1}, {15024, -1, -1, -1}, {15025, -1, -1, -1}, {15026, -1, -1, -1}, {15027, -1, -1, -1}, {15028, -1, -1, -1}, {15029, -1, -1, -1}, {15030, -1, -1, -1}, {15031, -1, -1, -1}, {15032, -1, -1, -1}, {15033, -1, -1, -1}, {15034, -1, -1, -1}, {15035, -1, -1, -1}, {15036, -1, -1, -1}, {15037, -1, -1, -1}, {15038, -1, -1, -1}, {15039, -1, -1, -1}, {15040, -1, -1, -1}, {15041, -1, -1, -1}, {15042, -1, -1, -1}, {15043, -1, -1, -1}, {15044, -1, -1, -1}, {15045, -1, -1, -1}, {15046, -1, -1, -1}, {15047, -1, -1, -1}, {15048, -1, -1, -1}, {15049, -1, -1, -1}, {15050, -1, -1, -1}, {15051, -1, -1, -1}, {15052, -1, -1, -1}, {15053, -1, -1, -1}, {15054, -1, -1, -1}, {15055, -1, -1, -1}, {15056, -1, -1, -1}, {15057, -1, -1, -1}, {15058, -1, -1, -1}, {15059, -1, -1, -1}, {15060, -1, -1, -1}, {15061, -1, -1, -1}, {15062, -1, -1, -1}, {15063, -1, -1, -1}, {15064, -1, -1, -1}, {15065, -1, -1, -1}, {15066, -1, -1, -1}, {15067, -1, -1, -1}, {15068, -1, -1, -1}, {15069, -1, -1, -1}, {15070, -1, -1, -1}, {15071, -1, -1, -1}, {15072, -1, -1, -1}, {15073, -1, -1, -1}, {15074, -1, -1, -1}, {15075, -1, -1, -1}, {15076, -1, -1, -1}, {15077, -1, -1, -1}, {15078, -1, -1, -1}, {15079, -1, -1, -1}, {15080, -1, -1, -1}, {15081, -1, -1, -1}, {15082, -1, -1, -1}, {15083, -1, -1, -1}, {15084, -1, -1, -1}, {15085, -1, -1, -1}, {15086, -1, -1, -1}, {15087, -1, -1, -1}, {15088, -1, -1, -1}, {15089, -1, -1, -1}, {15090, -1, -1, -1}, {15091, -1, -1, -1}, {15092, -1, -1, -1}, {15093, -1, -1, -1}, {15094, -1, -1, -1}, {15095, -1, -1, -1}, {15096, -1, -1, -1}, {15097, -1, -1, -1}, {15098, -1, -1, -1}, {15099, -1, -1, -1}, {15100, -1, -1, -1}, {15101, -1, -1, -1}, {15102, -1, -1, -1}, {15103, -1, -1, -1}, {15104, -1, -1, -1}, {15105, -1, -1, -1}, {15106, -1, -1, -1}, {15107, -1, -1, -1}, {15108, -1, -1, -1}, {15109, -1, -1, -1}, {15110, -1, -1, -1}, {15111, -1, -1, -1}, {15112, -1, -1, -1}, {15113, -1, -1, -1} },
    {{15114, -1, -1, -1}, {15115, -1, -1, -1}, {15116, -1, -1, -1}, {15117, -1, -1, -1}, {15118, -1, -1, -1}, {15119, -1, -1, -1}, {15120, -1, -1, -1}, {15121, -1, -1, -1}, {15122, -1, -1, -1}, {15123, -1, -1, -1}, {15124, -1, -1, -1}, {15125, -1, -1, -1}, {15126, -1, -1, -1}, {15127, -1, -1, -1}, {15128, -1, -1, -1}, {15129, -1, -1, -1}, {15130, -1, -1, -1}, {15131, -1, -1, -1}, {15132, -1, -1, -1}, {15133, -1, -1, -1}, {15134, -1, -1, -1}, {15135, -1, -1, -1}, {15136, -1, -1, -1}, {15137, -1, -1, -1}, {15138, -1, -1, -1}, {15139, -1, -1, -1}, {15140, -1, -1, -1}, {15141, -1, -1, -1}, {15142, -1, -1, -1}, {15143, -1, -1, -1}, {15144, -1, -1, -1}, {15145, -1, -1, -1}, {15146, -1, -1, -1}, {15147, -1, -1, -1}, {15148, -1, -1, -1}, {15149, -1, -1, -1}, {15150, -1, -1, -1}, {15151, -1, -1, -1}, {15152, -1, -1, -1}, {15153, -1, -1, -1}, {15154, -1, -1, -1}, {15155, -1, -1, -1}, {15156, -1, -1, -1}, {15157, -1, -1, -1}, {15158, -1, -1, -1}, {15159, -1, -1, -1}, {15160, -1, -1, -1}, {15161, -1, -1, -1}, {15162, -1, -1, -1}, {15163, -1, -1, -1}, {15164, -1, -1, -1}, {15165, -1, -1, -1}, {15166, -1, -1, -1}, {15167, -1, -1, -1}, {15168, -1, -1, -1}, {15169, -1, -1, -1}, {15170, -1, -1, -1}, {15171, -1, -1, -1}, {15172, -1, -1, -1}, {15173, -1, -1, -1}, {15174, -1, -1, -1}, {15175, -1, -1, -1}, {15176, -1, -1, -1}, {15177, -1, -1, -1}, {15178, -1, -1, -1}, {15179, -1, -1, -1}, {15180, -1, -1, -1}, {15181, -1, -1, -1}, {15183, -1, -1, -1}, {15184, -1, -1, -1}, {15185, -1, -1, -1}, {15186, -1, -1, -1}, {15187, -1, -1, -1}, {15188, -1, -1, -1}, {15189, -1, -1, -1}, {15190, -1, -1, -1}, {15191, -1, -1, -1}, {15192, -1, -1, -1}, {15193, -1, -1, -1}, {15194, -1, -1, -1}, {15195, -1, -1, -1}, {15196, -1, -1, -1}, {15197, -1, -1, -1}, {15198, -1, -1, -1}, {15199, -1, -1, -1}, {15200, -1, -1, -1}, {15201, -1, -1, -1}, {15202, -1, -1, -1}, {15203, -1, -1, -1}, {15204, -1, -1, -1}, {15205, -1, -1, -1}, {15206, -1, -1, -1}, {15207, -1, -1, -1}, {15208, -1, -1, -1}, {15209, -1, -1, -1}, {15210, -1, -1, -1}, {15211, -1, -1, -1}, {15212, -1, -1, -1}, {15213, -1, -1, -1}, {15214, -1, -1, -1}, {15215, -1, -1, -1}, {15216, -1, -1, -1}, {15217, -1, -1, -1}, {15218, -1, -1, -1}, {15219, -1, -1, -1}, {15220, -1, -1, -1}, {15221, -1, -1, -1}, {15222, -1, -1, -1}, {15223, -1, -1, -1}, {15224, -1, -1, -1}, {15225, -1, -1, -1}, {15226, -1, -1, -1}, {15227, -1, -1, -1}, {15228, -1, -1, -1}, {15229, -1, -1, -1}, {15230, -1, -1, -1}, {15231, -1, -1, -1}, {15232, -1, -1, -1}, {15233, -1, -1, -1}, {15234, -1, -1, -1}, {15235, -1, -1, -1}, {15236, -1, -1, -1}, {15237, -1, -1, -1}, {15238, -1, -1, -1}, {15239, -1, -1, -1}, {15240, -1, -1, -1}, {15241, -1, -1, -1}, {15242, -1, -1, -1}, {15243, -1, -1, -1}, {15244, -1, -1, -1}, {15245, -1, -1, -1}, {15246, -1, -1, -1}, {15247, -1, -1, -1}, {15248, -1, -1, -1}, {15249, -1, -1, -1}, {15250, -1, -1, -1}, {15251, -1, -1, -1}, {15252, -1, -1, -1}, {15253, -1, -1, -1}, {15254, -1, -1, -1}, {15255, -1, -1, -1}, {15256, -1, -1, -1}, {15257, -1, -1, -1}, {15258, -1, -1, -1}, {15259, -1, -1, -1}, {15260, -1, -1, -1}, {15261, -1, -1, -1}, {15262, -1, -1, -1}, {15263, -1, -1, -1}, {15264, -1, -1, -1}, {15265, -1, -1, -1}, {15266, -1, -1, -1}, {15267, -1, -1, -1}, {15268, -1, -1, -1}, {15269, -1, -1, -1}, {15270, -1, -1, -1}, {15271, -1, -1, -1}, {15272, -1, -1, -1}, {15273, -1, -1, -1}, {15274, -1, -1, -1}, {15275, -1, -1, -1}, {15276, -1, -1, -1}, {15277, -1, -1, -1}, {15278, -1, -1, -1}, {15279, -1, -1, -1}, {15280, -1, -1, -1}, {15281, -1, -1, -1}, {15282, -1, -1, -1}, {15283, -1, -1, -1}, {15284, -1, -1, -1}, {15285, -1, -1, -1}, {15286, -1, -1, -1}, {15287, -1, -1, -1}, {15288, -1, -1, -1}, {15289, -1, -1, -1}, {15290, -1, -1, -1}, {15291, -1, -1, -1}, {15292, -1, -1, -1}, {15293, -1, -1, -1}, {15294, -1, -1, -1}, {15295, -1, -1, -1}, {15296, -1, -1, -1}, {15297, -1, -1, -1}, {15298, -1, -1, -1}, {15299, -1, -1, -1}, {15300, -1, -1, -1}, {15301, -1, -1, -1}, {15302, -1, -1, -1}, {15303, -1, -1, -1}, {15304, -1, -1, -1}, {15305, -1, -1, -1}, {15306, -1, -1, -1}, {15307, -1, -1, -1}, {15308, -1, -1, -1}, {15309, -1, -1, -1}, {15310, -1, -1, -1}, {15311, -1, -1, -1}, {15312, -1, -1, -1}, {15313, -1, -1, -1}, {15314, -1, -1, -1}, {15315, -1, -1, -1}, {15316, -1, -1, -1}, {15317, -1, -1, -1}, {15318, -1, -1, -1}, {15319, -1, -1, -1}, {15320, -1, -1, -1}, {15321, -1, -1, -1}, {15322, -1, -1, -1}, {15323, -1, -1, -1}, {15324, -1, -1, -1}, {15325, -1, -1, -1}, {15326, -1, -1, -1}, {15327, -1, -1, -1}, {15328, -1, -1, -1}, {15329, -1, -1, -1}, {15330, -1, -1, -1}, {15331, -1, -1, -1}, {15332, -1, -1, -1}, {15333, -1, -1, -1}, {15334, -1, -1, -1}, {15335, -1, -1, -1}, {15336, -1, -1, -1}, {15337, -1, -1, -1}, {15338, -1, -1, -1}, {15339, -1, -1, -1}, {15340, -1, -1, -1}, {15341, -1, -1, -1}, {15342, -1, -1, -1}, {15343, -1, -1, -1}, {15344, -1, -1, -1}, {15345, -1, -1, -1}, {15346, -1, -1, -1}, {15347, -1, -1, -1}, {15348, -1, -1, -1}, {15349, -1, -1, -1}, {15350, -1, -1, -1}, {15351, -1, -1, -1}, {15352, -1, -1, -1}, {15353, -1, -1, -1}, {15354, -1, -1, -1}, {15355, -1, -1, -1}, {15356, -1, -1, -1}, {15357, -1, -1, -1}, {15358, -1, -1, -1}, {15359, -1, -1, -1}, {15360, -1, -1, -1}, {15361, -1, -1, -1}, {15362, -1, -1, -1}, {15363, -1, -1, -1}, {15364, -1, -1, -1}, {15365, -1, -1, -1}, {15366, -1, -1, -1}, {15367, -1, -1, -1}, {15368, -1, -1, -1}, {15369, -1, -1, -1}, {15370, -1, -1, -1} },
    {{15371, -1, -1, -1}, {15372, -1, -1, -1}, {15373, -1, -1, -1}, {15374, -1, -1, -1}, {15375, -1, -1, -1}, {15376, -1, -1, -1}, {15377, -1, -1, -1}, {15378, -1, -1, -1}, {15379, -1, -1, -1}, {15380, -1, -1, -1}, {15381, -1, -1, -1}, {15382, -1, -1, -1}, {15383, -1, -1, -1}, {15384, -1, -1, -1}, {15385, -1, -1, -1}, {15386, -1, -1, -1}, {15387, -1, -1, -1}, {15388, -1, -1, -1}, {15389, -1, -1, -1}, {15390, -1, -1, -1}, {15391, -1, -1, -1}, {15392, -1, -1, -1}, {15393, -1, -1, -1}, {15394, -1, -1, -1}, {15395, -1, -1, -1}, {15396, -1, -1, -1}, {15397, -1, -1, -1}, {15398, -1, -1, -1}, {15399, -1, -1, -1}, {15400, -1, -1, -1}, {15401, -1, -1, -1}, {15402, -1, -1, -1}, {15403, -1, -1, -1}, {15404, -1, -1, -1}, {15405, -1, -1, -1}, {15406, -1, -1, -1}, {15407, -1, -1, -1}, {15408, -1, -1, -1}, {15409, -1, -1, -1}, {15410, -1, -1, -1}, {15411, -1, -1, -1}, {15412, -1, -1, -1}, {15413, -1, -1, -1}, {15414, -1, -1, -1}, {15415, -1, -1, -1}, {15416, -1, -1, -1}, {15417, -1, -1, -1}, {15418, -1, -1, -1}, {15419, -1, -1, -1}, {15420, -1, -1, -1}, {15421, -1, -1, -1}, {15422, -1, -1, -1}, {15423, -1, -1, -1}, {15424, -1, -1, -1}, {15425, -1, -1, -1}, {15426, -1, -1, -1}, {15427, -1, -1, -1}, {15428, -1, -1, -1}, {15429, -1, -1, -1}, {15430, -1, -1, -1}, {15431, -1, -1, -1}, {15432, -1, -1, -1}, {15433, -1, -1, -1}, {15434, -1, -1, -1}, {15435, -1, -1, -1}, {15436, -1, -1, -1}, {15437, -1, -1, -1}, {15438, -1, -1, -1}, {15439, -1, -1, -1}, {15440, -1, -1, -1}, {15441, -1, -1, -1}, {15442, -1, -1, -1}, {15443, -1, -1, -1}, {15444, -1, -1, -1}, {15445, -1, -1, -1}, {15446, -1, -1, -1}, {15447, -1, -1, -1}, {15448, -1, -1, -1}, {15449, -1, -1, -1}, {15450, -1, -1, -1}, {15451, -1, -1, -1}, {15452, -1, -1, -1}, {15453, -1, -1, -1}, {15454, -1, -1, -1}, {15455, -1, -1, -1}, {15456, -1, -1, -1}, {15457, -1, -1, -1}, {15458, -1, -1, -1}, {15459, -1, -1, -1}, {15460, -1, -1, -1}, {15461, -1, -1, -1}, {15462, -1, -1, -1}, {15463, -1, -1, -1}, {15464, -1, -1, -1}, {15465, -1, -1, -1}, {15466, -1, -1, -1}, {15467, -1, -1, -1}, {15468, -1, -1, -1}, {15469, -1, -1, -1}, {15471, -1, -1, -1}, {15472, -1, -1, -1}, {15473, -1, -1, -1}, {15474, -1, -1, -1}, {15475, -1, -1, -1}, {15476, -1, -1, -1}, {15477, -1, -1, -1}, {15478, -1, -1, -1}, {15479, -1, -1, -1}, {15480, -1, -1, -1}, {15481, -1, -1, -1}, {15482, -1, -1, -1}, {15483, -1, -1, -1}, {15484, -1, -1, -1}, {15485, -1, -1, -1}, {15486, -1, -1, -1}, {15487, -1, -1, -1}, {15488, -1, -1, -1}, {15489, -1, -1, -1}, {15490, -1, -1, -1}, {15491, -1, -1, -1}, {15492, -1, -1, -1}, {15493, -1, -1, -1}, {15494, -1, -1, -1}, {15495, -1, -1, -1}, {15496, -1, -1, -1}, {15497, -1, -1, -1}, {15498, -1, -1, -1}, {15499, -1, -1, -1}, {15500, -1, -1, -1}, {15501, -1, -1, -1}, {15502, -1, -1, -1}, {15503, -1, -1, -1}, {15504, -1, -1, -1}, {15505, -1, -1, -1}, {15506, -1, -1, -1}, {15507, -1, -1, -1}, {15508, -1, -1, -1}, {15509, -1, -1, -1}, {15510, -1, -1, -1}, {15511, -1, -1, -1}, {15512, -1, -1, -1}, {15513, -1, -1, -1}, {15514, -1, -1, -1}, {15515, -1, -1, -1}, {15516, -1, -1, -1}, {15517, -1, -1, -1}, {15518, -1, -1, -1}, {15519, -1, -1, -1}, {15520, -1, -1, -1}, {15521, -1, -1, -1}, {15522, -1, -1, -1}, {15523, -1, -1, -1}, {15524, -1, -1, -1}, {15525, -1, -1, -1}, {15526, -1, -1, -1}, {15527, -1, -1, -1}, {15528, -1, -1, -1}, {15529, -1, -1, -1}, {15530, -1, -1, -1}, {15531, -1, -1, -1}, {15532, -1, -1, -1}, {15533, -1, -1, -1}, {15534, -1, -1, -1}, {15535, -1, -1, -1}, {15536, -1, -1, -1}, {15537, -1, -1, -1}, {15538, -1, -1, -1}, {15539, -1, -1, -1}, {15540, -1, -1, -1}, {15541, -1, -1, -1}, {15542, -1, -1, -1}, {15543, -1, -1, -1}, {15544, -1, -1, -1}, {15545, -1, -1, -1}, {15546, -1, -1, -1}, {15547, -1, -1, -1}, {15548, -1, -1, -1}, {15549, -1, -1, -1}, {15550, -1, -1, -1}, {15551, -1, -1, -1}, {15552, -1, -1, -1}, {15553, -1, -1, -1}, {15554, -1, -1, -1}, {15555, -1, -1, -1}, {15556, -1, -1, -1}, {15557, -1, -1, -1}, {15558, -1, -1, -1}, {15559, -1, -1, -1}, {15560, -1, -1, -1}, {15561, -1, -1, -1}, {15562, -1, -1, -1}, {15563, -1, -1, -1}, {15564, -1, -1, -1}, {15565, -1, -1, -1}, {15566, -1, -1, -1}, {15567, -1, -1, -1}, {15568, -1, -1, -1}, {15569, -1, -1, -1}, {15570, -1, -1, -1}, {15571, -1, -1, -1}, {15572, -1, -1, -1}, {15573, -1, -1, -1}, {15574, -1, -1, -1}, {15575, -1, -1, -1}, {15576, -1, -1, -1}, {15577, -1, -1, -1}, {15578, -1, -1, -1}, {15579, -1, -1, -1}, {15580, -1, -1, -1}, {15581, -1, -1, -1}, {15582, -1, -1, -1}, {15583, -1, -1, -1}, {15585, -1, -1, -1}, {15586, -1, -1, -1}, {15587, -1, -1, -1}, {15588, -1, -1, -1}, {15589, -1, -1, -1}, {15590, -1, -1, -1}, {15591, -1, -1, -1}, {15592, -1, -1, -1}, {15593, -1, -1, -1}, {15594, -1, -1, -1}, {15595, -1, -1, -1}, {15596, -1, -1, -1}, {15597, -1, -1, -1}, {15598, -1, -1, -1}, {15599, -1, -1, -1}, {15600, -1, -1, -1}, {15601, -1, -1, -1}, {15602, -1, -1, -1}, {15603, -1, -1, -1}, {15604, -1, -1, -1}, {15605, -1, -1, -1}, {15606, -1, -1, -1}, {15607, -1, -1, -1}, {15608, -1, -1, -1}, {15609, -1, -1, -1}, {15610, -1, -1, -1}, {15611, -1, -1, -1}, {15612, -1, -1, -1}, {15613, -1, -1, -1}, {15614, -1, -1, -1}, {15615, -1, -1, -1}, {15616, -1, -1, -1}, {15617, -1, -1, -1}, {15618, -1, -1, -1}, {15619, -1, -1, -1}, {15620, -1, -1, -1}, {15621, -1, -1, -1}, {15622, -1, -1, -1}, {15623, -1, -1, -1}, {15624, -1, -1, -1}, {15625, -1, -1, -1}, {15626, -1, -1, -1}, {15627, -1, -1, -1}, {15628, -1, -1, -1} },
    {{15629, -1, -1, -1}, {15630, -1, -1, -1}, {15631, -1, -1, -1}, {15632, -1, -1, -1}, {15633, -1, -1, -1}, {15634, -1, -1, -1}, {15635, -1, -1, -1}, {15636, -1, -1, -1}, {15637, -1, -1, -1}, {15638, -1, -1, -1}, {15639, -1, -1, -1}, {15640, -1, -1, -1}, {15641, -1, -1, -1}, {15642, -1, -1, -1}, {15643, -1, -1, -1}, {15644, -1, -1, -1}, {15645, -1, -1, -1}, {15646, -1, -1, -1}, {15647, -1, -1, -1}, {15648, -1, -1, -1}, {15649, -1, -1, -1}, {15650, -1, -1, -1}, {15651, -1, -1, -1}, {15652, -1, -1, -1}, {15653, -1, -1, -1}, {15654, -1, -1, -1}, {15655, -1, -1, -1}, {15656, -1, -1, -1}, {15657, -1, -1, -1}, {15658, -1, -1, -1}, {15659, -1, -1, -1}, {15660, -1, -1, -1}, {15661, -1, -1, -1}, {15662, -1, -1, -1}, {15663, -1, -1, -1}, {15664, -1, -1, -1}, {15665, -1, -1, -1}, {15666, -1, -1, -1}, {15667, -1, -1, -1}, {15668, -1, -1, -1}, {15669, -1, -1, -1}, {15670, -1, -1, -1}, {15671, -1, -1, -1}, {15672, -1, -1, -1}, {15673, -1, -1, -1}, {15674, -1, -1, -1}, {15675, -1, -1, -1}, {15676, -1, -1, -1}, {15677, -1, -1, -1}, {15678, -1, -1, -1}, {15679, -1, -1, -1}, {15680, -1, -1, -1}, {15681, -1, -1, -1}, {15682, -1, -1, -1}, {15683, -1, -1, -1}, {15684, -1, -1, -1}, {15685, -1, -1, -1}, {15686, -1, -1, -1}, {15687, -1, -1, -1}, {15688, -1, -1, -1}, {15689, -1, -1, -1}, {15690, -1, -1, -1}, {15691, -1, -1, -1}, {15692, -1, -1, -1}, {15693, -1, -1, -1}, {15694, -1, -1, -1}, {15695, -1, -1, -1}, {15696, -1, -1, -1}, {15697, -1, -1, -1}, {15698, -1, -1, -1}, {15699, -1, -1, -1}, {15700, -1, -1, -1}, {15701, -1, -1, -1}, {15702, -1, -1, -1}, {15703, -1, -1, -1}, {15704, -1, -1, -1}, {15705, -1, -1, -1}, {15706, -1, -1, -1}, {15707, -1, -1, -1}, {15708, -1, -1, -1}, {15709, -1, -1, -1}, {15710, -1, -1, -1}, {15711, -1, -1, -1}, {15712, -1, -1, -1}, {15713, -1, -1, -1}, {15714, -1, -1, -1}, {15715, -1, -1, -1}, {15716, -1, -1, -1}, {15717, -1, -1, -1}, {15718, -1, -1, -1}, {15719, -1, -1, -1}, {15720, -1, -1, -1}, {15721, -1, -1, -1}, {15722, -1, -1, -1}, {15723, -1, -1, -1}, {15724, -1, -1, -1}, {15725, -1, -1, -1}, {15726, -1, -1, -1}, {15727, -1, -1, -1}, {15728, -1, -1, -1}, {15729, -1, -1, -1}, {15730, -1, -1, -1}, {15731, -1, -1, -1}, {15732, -1, -1, -1}, {15733, -1, -1, -1}, {15734, -1, -1, -1}, {15735, -1, -1, -1}, {15736, -1, -1, -1}, {15737, -1, -1, -1}, {15738, -1, -1, -1}, {15739, -1, -1, -1}, {15740, -1, -1, -1}, {15741, -1, -1, -1}, {15742, -1, -1, -1}, {15743, -1, -1, -1}, {15744, -1, -1, -1}, {15745, -1, -1, -1}, {15746, -1, -1, -1}, {15747, -1, -1, -1}, {15748, -1, -1, -1}, {15749, -1, -1, -1}, {15750, -1, -1, -1}, {15751, -1, -1, -1}, {15752, -1, -1, -1}, {15753, -1, -1, -1}, {15754, -1, -1, -1}, {15755, -1, -1, -1}, {15756, -1, -1, -1}, {15757, -1, -1, -1}, {15758, -1, -1, -1}, {15759, -1, -1, -1}, {15760, -1, -1, -1}, {15761, -1, -1, -1}, {15762, -1, -1, -1}, {15763, -1, -1, -1}, {15764, -1, -1, -1}, {15765, -1, -1, -1}, {15766, -1, -1, -1}, {15767, -1, -1, -1}, {15768, -1, -1, -1}, {15769, -1, -1, -1}, {15770, -1, -1, -1}, {15771, -1, -1, -1}, {15772, -1, -1, -1}, {15773, -1, -1, -1}, {15774, -1, -1, -1}, {15775, -1, -1, -1}, {15776, -1, -1, -1}, {15777, -1, -1, -1}, {15778, -1, -1, -1}, {15779, -1, -1, -1}, {15780, -1, -1, -1}, {15781, -1, -1, -1}, {15782, -1, -1, -1}, {15783, -1, -1, -1}, {15784, -1, -1, -1}, {15785, -1, -1, -1}, {15786, -1, -1, -1}, {15787, -1, -1, -1}, {15788, -1, -1, -1}, {15789, -1, -1, -1}, {15790, -1, -1, -1}, {15791, -1, -1, -1}, {15792, -1, -1, -1}, {15793, -1, -1, -1}, {15794, -1, -1, -1}, {15795, -1, -1, -1}, {15796, -1, -1, -1}, {15797, -1, -1, -1}, {15798, -1, -1, -1}, {15799, -1, -1, -1}, {15800, -1, -1, -1}, {15801, -1, -1, -1}, {15802, -1, -1, -1}, {15803, -1, -1, -1}, {15804, -1, -1, -1}, {15805, -1, -1, -1}, {15806, -1, -1, -1}, {15807, -1, -1, -1}, {15808, -1, -1, -1}, {15809, -1, -1, -1}, {15810, -1, -1, -1}, {15811, -1, -1, -1}, {15812, -1, -1, -1}, {15813, -1, -1, -1}, {15814, -1, -1, -1}, {15815, -1, -1, -1}, {15816, -1, -1, -1}, {15817, -1, -1, -1}, {15818, -1, -1, -1}, {15819, -1, -1, -1}, {15820, -1, -1, -1}, {15821, -1, -1, -1}, {15822, -1, -1, -1}, {15823, -1, -1, -1}, {15824, -1, -1, -1}, {15825, -1, -1, -1}, {15826, -1, -1, -1}, {15827, -1, -1, -1}, {15828, -1, -1, -1}, {15829, -1, -1, -1}, {15830, -1, -1, -1}, {15831, -1, -1, -1}, {15832, -1, -1, -1}, {15833, -1, -1, -1}, {15834, -1, -1, -1}, {15835, -1, -1, -1}, {15836, -1, -1, -1}, {15837, -1, -1, -1}, {15838, -1, -1, -1}, {15839, -1, -1, -1}, {15840, -1, -1, -1}, {15841, -1, -1, -1}, {15842, -1, -1, -1}, {15843, -1, -1, -1}, {15844, -1, -1, -1}, {15845, -1, -1, -1}, {15846, -1, -1, -1}, {15847, -1, -1, -1}, {15848, -1, -1, -1}, {15849, -1, -1, -1}, {15850, -1, -1, -1}, {15851, -1, -1, -1}, {15852, -1, -1, -1}, {15853, -1, -1, -1}, {15854, -1, -1, -1}, {15855, -1, -1, -1}, {15856, -1, -1, -1}, {15857, -1, -1, -1}, {15858, -1, -1, -1}, {15859, -1, -1, -1}, {15860, -1, -1, -1}, {15861, -1, -1, -1}, {15862, -1, -1, -1}, {15863, -1, -1, -1}, {15864, -1, -1, -1}, {15865, -1, -1, -1}, {15866, -1, -1, -1}, {15867, -1, -1, -1}, {15868, -1, -1, -1}, {15869, -1, -1, -1}, {15870, -1, -1, -1}, {15871, -1, -1, -1}, {15872, -1, -1, -1}, {15873, -1, -1, -1}, {15874, -1, -1, -1}, {15875, -1, -1, -1}, {15876, -1, -1, -1}, {15877, -1, -1, -1}, {15878, -1, -1, -1}, {15879, -1, -1, -1}, {15880, -1, -1, -1}, {15881, -1, -1, -1}, {15882, -1, -1, -1}, {15883, -1, -1, -1}, {15884, -1, -1, -1} },
    {{15885, -1, -1, -1}, {15886, -1, -1, -1}, {15887, -1, -1, -1}, {15888, -1, -1, -1}, {15889, -1, -1, -1}, {15890, -1, -1, -1}, {15891, -1, -1, -1}, {15892, -1, -1, -1}, {15893, -1, -1, -1}, {15894, -1, -1, -1}, {15895, -1, -1, -1}, {15896, -1, -1, -1}, {15897, -1, -1, -1}, {15898, -1, -1, -1}, {15899, -1, -1, -1}, {15900, -1, -1, -1}, {15901, -1, -1, -1}, {15902, -1, -1, -1}, {15903, -1, -1, -1}, {15904, -1, -1, -1}, {15905, -1, -1, -1}, {15906, -1, -1, -1}, {15907, -1, -1, -1}, {15908, -1, -1, -1}, {15909, -1, -1, -1}, {15910, -1, -1, -1}, {15911, -1, -1, -1}, {15912, -1, -1, -1}, {15913, -1, -1, -1}, {15914, -1, -1, -1}, {15915, -1, -1, -1}, {15916, -1, -1, -1}, {15917, -1, -1, -1}, {15918, -1, -1, -1}, {15919, -1, -1, -1}, {15920, -1, -1, -1}, {15921, -1, -1, -1}, {15922, -1, -1, -1}, {15923, -1, -1, -1}, {15924, -1, -1, -1}, {15925, -1, -1, -1}, {15926, -1, -1, -1}, {15927, -1, -1, -1}, {15928, -1, -1, -1}, {15929, -1, -1, -1}, {15930, -1, -1, -1}, {15931, -1, -1, -1}, {15932, -1, -1, -1}, {15933, -1, -1, -1}, {15934, -1, -1, -1}, {15935, -1, -1, -1}, {15936, -1, -1, -1}, {15937, -1, -1, -1}, {15938, -1, -1, -1}, {15939, -1, -1, -1}, {15940, -1, -1, -1}, {15941, -1, -1, -1}, {15942, -1, -1, -1}, {15943, -1, -1, -1}, {15944, -1, -1, -1}, {15945, -1, -1, -1}, {15946, -1, -1, -1}, {15947, -1, -1, -1}, {15948, -1, -1, -1}, {15949, -1, -1, -1}, {15950, -1, -1, -1}, {15951, -1, -1, -1}, {15952, -1, -1, -1}, {15953, -1, -1, -1}, {15954, -1, -1, -1}, {15955, -1, -1, -1}, {15956, -1, -1, -1}, {15957, -1, -1, -1}, {15958, -1, -1, -1}, {15959, -1, -1, -1}, {15960, -1, -1, -1}, {15961, -1, -1, -1}, {15962, -1, -1, -1}, {15963, -1, -1, -1}, {15964, -1, -1, -1}, {15965, -1, -1, -1}, {15966, -1, -1, -1}, {15967, -1, -1, -1}, {15968, -1, -1, -1}, {15969, -1, -1, -1}, {15970, -1, -1, -1}, {15971, -1, -1, -1}, {15972, -1, -1, -1}, {15973, -1, -1, -1}, {15974, -1, -1, -1}, {15975, -1, -1, -1}, {15976, -1, -1, -1}, {15977, -1, -1, -1}, {15978, -1, -1, -1}, {15979, -1, -1, -1}, {15980, -1, -1, -1}, {15981, -1, -1, -1}, {15982, -1, -1, -1}, {15983, -1, -1, -1}, {15984, -1, -1, -1}, {15985, -1, -1, -1}, {15986, -1, -1, -1}, {15987, -1, -1, -1}, {15988, -1, -1, -1}, {15989, -1, -1, -1}, {15990, -1, -1, -1}, {15991, -1, -1, -1}, {15992, -1, -1, -1}, {15993, -1, -1, -1}, {15994, -1, -1, -1}, {15995, -1, -1, -1}, {15996, -1, -1, -1}, {15997, -1, -1, -1}, {15998, -1, -1, -1}, {15999, -1, -1, -1}, {16000, -1, -1, -1}, {16001, -1, -1, -1}, {16002, -1, -1, -1}, {16003, -1, -1, -1}, {16004, -1, -1, -1}, {16005, -1, -1, -1}, {16006, -1, -1, -1}, {16007, -1, -1, -1}, {16008, -1, -1, -1}, {16009, -1, -1, -1}, {16010, -1, -1, -1}, {16011, -1, -1, -1}, {16012, -1, -1, -1}, {16013, -1, -1, -1}, {16014, -1, -1, -1}, {16015, -1, -1, -1}, {16016, -1, -1, -1}, {16017, -1, -1, -1}, {16018, -1, -1, -1}, {16019, -1, -1, -1}, {16020, -1, -1, -1}, {16021, -1, -1, -1}, {16022, -1, -1, -1}, {16023, -1, -1, -1}, {16024, -1, -1, -1}, {16025, -1, -1, -1}, {16026, -1, -1, -1}, {16027, -1, -1, -1}, {16028, -1, -1, -1}, {16029, -1, -1, -1}, {16030, -1, -1, -1}, {16031, -1, -1, -1}, {16032, -1, -1, -1}, {16033, -1, -1, -1}, {16034, -1, -1, -1}, {16035, -1, -1, -1}, {16036, -1, -1, -1}, {16037, -1, -1, -1}, {16038, -1, -1, -1}, {16039, -1, -1, -1}, {16040, -1, -1, -1}, {16041, -1, -1, -1}, {16042, -1, -1, -1}, {16043, -1, -1, -1}, {16044, -1, -1, -1}, {16045, -1, -1, -1}, {16046, -1, -1, -1}, {16047, -1, -1, -1}, {16048, -1, -1, -1}, {16049, -1, -1, -1}, {16050, -1, -1, -1}, {16051, -1, -1, -1}, {16052, -1, -1, -1}, {16053, -1, -1, -1}, {16054, -1, -1, -1}, {16055, -1, -1, -1}, {16056, -1, -1, -1}, {16057, -1, -1, -1}, {16058, -1, -1, -1}, {16059, -1, -1, -1}, {16060, -1, -1, -1}, {16061, -1, -1, -1}, {16062, -1, -1, -1}, {16063, -1, -1, -1}, {16064, -1, -1, -1}, {16065, -1, -1, -1}, {16066, -1, -1, -1}, {16067, -1, -1, -1}, {16068, -1, -1, -1}, {16069, -1, -1, -1}, {16070, -1, -1, -1}, {16071, -1, -1, -1}, {16072, -1, -1, -1}, {16073, -1, -1, -1}, {16074, -1, -1, -1}, {16075, -1, -1, -1}, {16076, -1, -1, -1}, {16077, -1, -1, -1}, {16078, -1, -1, -1}, {16079, -1, -1, -1}, {16080, -1, -1, -1}, {16081, -1, -1, -1}, {16082, -1, -1, -1}, {16083, -1, -1, -1}, {16084, -1, -1, -1}, {16085, -1, -1, -1}, {16086, -1, -1, -1}, {16087, -1, -1, -1}, {16088, -1, -1, -1}, {16089, -1, -1, -1}, {16090, -1, -1, -1}, {16091, -1, -1, -1}, {16092, -1, -1, -1}, {16093, -1, -1, -1}, {16094, -1, -1, -1}, {16095, -1, -1, -1}, {16096, -1, -1, -1}, {16097, -1, -1, -1}, {16098, -1, -1, -1}, {16099, -1, -1, -1}, {16100, -1, -1, -1}, {16101, -1, -1, -1}, {16102, -1, -1, -1}, {16103, -1, -1, -1}, {16104, -1, -1, -1}, {16105, -1, -1, -1}, {16106, -1, -1, -1}, {16107, -1, -1, -1}, {16108, -1, -1, -1}, {16109, -1, -1, -1}, {16110, -1, -1, -1}, {16111, -1, -1, -1}, {16112, -1, -1, -1}, {16113, -1, -1, -1}, {16114, -1, -1, -1}, {16115, -1, -1, -1}, {16116, -1, -1, -1}, {16117, -1, -1, -1}, {16118, -1, -1, -1}, {16119, -1, -1, -1}, {16120, -1, -1, -1}, {16121, -1, -1, -1}, {16122, -1, -1, -1}, {16123, -1, -1, -1}, {16124, -1, -1, -1}, {16125, -1, -1, -1}, {16126, -1, -1, -1}, {16127, -1, -1, -1}, {16128, -1, -1, -1}, {16129, -1, -1, -1}, {16130, -1, -1, -1}, {16131, -1, -1, -1}, {16132, -1, -1, -1}, {16133, -1, -1, -1}, {16134, -1, -1, -1}, {16135, -1, -1, -1}, {16136, -1, -1, -1}, {16137, -1, -1, -1}, {16138, -1, -1, -1}, {16139, -1, -1, -1}, {16140, -1, -1, -1} },
    {{16141, -1, -1, -1}, {16142, -1, -1, -1}, {16143, -1, -1, -1}, {16144, -1, -1, -1}, {16145, -1, -1, -1}, {16146, -1, -1, -1}, {16147, -1, -1, -1}, {16148, -1, -1, -1}, {16149, -1, -1, -1}, {16150, -1, -1, -1}, {16151, -1, -1, -1}, {16152, -1, -1, -1}, {16153, -1, -1, -1}, {16154, -1, -1, -1}, {16155, -1, -1, -1}, {16156, -1, -1, -1}, {16157, -1, -1, -1}, {16158, -1, -1, -1}, {16159, -1, -1, -1}, {16160, -1, -1, -1}, {16161, -1, -1, -1}, {16162, -1, -1, -1}, {16163, -1, -1, -1}, {16164, -1, -1, -1}, {16165, -1, -1, -1}, {16166, -1, -1, -1}, {16167, -1, -1, -1}, {16168, -1, -1, -1}, {16169, -1, -1, -1}, {16170, -1, -1, -1}, {16171, -1, -1, -1}, {16172, -1, -1, -1}, {16173, -1, -1, -1}, {16174, -1, -1, -1}, {16175, -1, -1, -1}, {16176, -1, -1, -1}, {16177, -1, -1, -1}, {16178, -1, -1, -1}, {16179, -1, -1, -1}, {16180, -1, -1, -1}, {16181, -1, -1, -1}, {16182, -1, -1, -1}, {16183, -1, -1, -1}, {16184, -1, -1, -1}, {16185, -1, -1, -1}, {16186, -1, -1, -1}, {16187, -1, -1, -1}, {16188, -1, -1, -1}, {16189, -1, -1, -1}, {16190, -1, -1, -1}, {16191, -1, -1, -1}, {16192, -1, -1, -1}, {16193, -1, -1, -1}, {16194, -1, -1, -1}, {16195, -1, -1, -1}, {16196, -1, -1, -1}, {16197, -1, -1, -1}, {16198, -1, -1, -1}, {16199, -1, -1, -1}, {16200, -1, -1, -1}, {16201, -1, -1, -1}, {16202, -1, -1, -1}, {16203, -1, -1, -1}, {16204, -1, -1, -1}, {16205, -1, -1, -1}, {16206, -1, -1, -1}, {16207, -1, -1, -1}, {16208, -1, -1, -1}, {16209, -1, -1, -1}, {16210, -1, -1, -1}, {16211, -1, -1, -1}, {16212, -1, -1, -1}, {16213, -1, -1, -1}, {16214, -1, -1, -1}, {16215, -1, -1, -1}, {16216, -1, -1, -1}, {16217, -1, -1, -1}, {16218, -1, -1, -1}, {16219, -1, -1, -1}, {16220, -1, -1, -1}, {16221, -1, -1, -1}, {16222, -1, -1, -1}, {16223, -1, -1, -1}, {16224, -1, -1, -1}, {16225, -1, -1, -1}, {16226, -1, -1, -1}, {16227, -1, -1, -1}, {16228, -1, -1, -1}, {16229, -1, -1, -1}, {16230, -1, -1, -1}, {16231, -1, -1, -1}, {16232, -1, -1, -1}, {16233, -1, -1, -1}, {16234, -1, -1, -1}, {16235, -1, -1, -1}, {16236, -1, -1, -1}, {16237, -1, -1, -1}, {16238, -1, -1, -1}, {16239, -1, -1, -1}, {16240, -1, -1, -1}, {16241, -1, -1, -1}, {16242, -1, -1, -1}, {16243, -1, -1, -1}, {16244, -1, -1, -1}, {16245, -1, -1, -1}, {16246, -1, -1, -1}, {16247, -1, -1, -1}, {16248, -1, -1, -1}, {16249, -1, -1, -1}, {16250, -1, -1, -1}, {16251, -1, -1, -1}, {16252, -1, -1, -1}, {16253, -1, -1, -1}, {16254, -1, -1, -1}, {16255, -1, -1, -1}, {16256, -1, -1, -1}, {16257, -1, -1, -1}, {16258, -1, -1, -1}, {16259, -1, -1, -1}, {16260, -1, -1, -1}, {16261, -1, -1, -1}, {16262, -1, -1, -1}, {16263, -1, -1, -1}, {16264, -1, -1, -1}, {16265, -1, -1, -1}, {16266, -1, -1, -1}, {16267, -1, -1, -1}, {16268, -1, -1, -1}, {16269, -1, -1, -1}, {16270, -1, -1, -1}, {16271, -1, -1, -1}, {16272, -1, -1, -1}, {16273, -1, -1, -1}, {16274, -1, -1, -1}, {16275, -1, -1, -1}, {16276, -1, -1, -1}, {16277, -1, -1, -1}, {16278, -1, -1, -1}, {16279, -1, -1, -1}, {16280, -1, -1, -1}, {16281, -1, -1, -1}, {16282, -1, -1, -1}, {16283, -1, -1, -1}, {16284, -1, -1, -1}, {16285, -1, -1, -1}, {16286, -1, -1, -1}, {16287, -1, -1, -1}, {16288, -1, -1, -1}, {16289, -1, -1, -1}, {16290, -1, -1, -1}, {16291, -1, -1, -1}, {16292, -1, -1, -1}, {16293, -1, -1, -1}, {16294, -1, -1, -1}, {16295, -1, -1, -1}, {16296, -1, -1, -1}, {16297, -1, -1, -1}, {16298, -1, -1, -1}, {16299, -1, -1, -1}, {16300, -1, -1, -1}, {16301, -1, -1, -1}, {16302, -1, -1, -1}, {16303, -1, -1, -1}, {16304, -1, -1, -1}, {16305, -1, -1, -1}, {16306, -1, -1, -1}, {16307, -1, -1, -1}, {16308, -1, -1, -1}, {16309, -1, -1, -1}, {16310, -1, -1, -1}, {16311, -1, -1, -1}, {16312, -1, -1, -1}, {16313, -1, -1, -1}, {16314, -1, -1, -1}, {16315, -1, -1, -1}, {16316, -1, -1, -1}, {16317, -1, -1, -1}, {16318, -1, -1, -1}, {16319, -1, -1, -1}, {16320, -1, -1, -1}, {16321, -1, -1, -1}, {16322, -1, -1, -1}, {16323, -1, -1, -1}, {16324, -1, -1, -1}, {16325, -1, -1, -1}, {16326, -1, -1, -1}, {16327, -1, -1, -1}, {16328, -1, -1, -1}, {16329, -1, -1, -1}, {16330, -1, -1, -1}, {16331, -1, -1, -1}, {16332, -1, -1, -1}, {16333, -1, -1, -1}, {16334, -1, -1, -1}, {16335, -1, -1, -1}, {16336, -1, -1, -1}, {16337, -1, -1, -1}, {16338, -1, -1, -1}, {16339, -1, -1, -1}, {16340, -1, -1, -1}, {16341, -1, -1, -1}, {16342, -1, -1, -1}, {16343, -1, -1, -1}, {16344, -1, -1, -1}, {16345, -1, -1, -1}, {16346, -1, -1, -1}, {16347, -1, -1, -1}, {16348, -1, -1, -1}, {16349, -1, -1, -1}, {16350, -1, -1, -1}, {16351, -1, -1, -1}, {16352, -1, -1, -1}, {16353, -1, -1, -1}, {16354, -1, -1, -1}, {16355, -1, -1, -1}, {16356, -1, -1, -1}, {16357, -1, -1, -1}, {16358, -1, -1, -1}, {16359, -1, -1, -1}, {16360, -1, -1, -1}, {16361, -1, -1, -1}, {16362, -1, -1, -1}, {16363, -1, -1, -1}, {16364, -1, -1, -1}, {16365, -1, -1, -1}, {16366, -1, -1, -1}, {16367, -1, -1, -1}, {16368, -1, -1, -1}, {16369, -1, -1, -1}, {16370, -1, -1, -1}, {16371, -1, -1, -1}, {16372, -1, -1, -1}, {16373, -1, -1, -1}, {16374, -1, -1, -1}, {16375, -1, -1, -1}, {16376, -1, -1, -1}, {16377, -1, -1, -1}, {16378, -1, -1, -1}, {16379, -1, -1, -1}, {16380, -1, -1, -1}, {16381, -1, -1, -1}, {16382, -1, -1, -1}, {16383, -1, -1, -1}, {16384, -1, -1, -1}, {16385, -1, -1, -1}, {16386, -1, -1, -1}, {16387, -1, -1, -1}, {16388, -1, -1, -1}, {16389, -1, -1, -1}, {16390, -1, -1, -1}, {16391, -1, -1, -1}, {16392, -1, -1, -1}, {16393, -1, -1, -1}, {16394, -1, -1, -1}, {16395, -1, -1, -1}, {16396, -1, -1, -1} },
    {{16397, -1, -1, -1}, {16398, -1, -1, -1}, {16399, -1, -1, -1}, {16400, -1, -1, -1}, {16401, -1, -1, -1}, {16402, -1, -1, -1}, {16403, -1, -1, -1}, {16404, -1, -1, -1}, {16405, -1, -1, -1}, {16406, -1, -1, -1}, {16407, -1, -1, -1}, {16408, -1, -1, -1}, {16409, -1, -1, -1}, {16410, -1, -1, -1}, {16411, -1, -1, -1}, {16412, -1, -1, -1}, {16413, -1, -1, -1}, {16414, -1, -1, -1}, {16415, -1, -1, -1}, {16416, -1, -1, -1}, {16417, -1, -1, -1}, {16418, -1, -1, -1}, {16419, -1, -1, -1}, {16420, -1, -1, -1}, {16421, -1, -1, -1}, {16422, -1, -1, -1}, {16423, -1, -1, -1}, {16424, -1, -1, -1}, {16425, -1, -1, -1}, {16426, -1, -1, -1}, {16427, -1, -1, -1}, {16428, -1, -1, -1}, {16429, -1, -1, -1}, {16430, -1, -1, -1}, {16431, -1, -1, -1}, {16432, -1, -1, -1}, {16433, -1, -1, -1}, {16434, -1, -1, -1}, {16435, -1, -1, -1}, {16436, -1, -1, -1}, {16437, -1, -1, -1}, {16438, -1, -1, -1}, {16439, -1, -1, -1}, {16440, -1, -1, -1}, {16441, -1, -1, -1}, {16442, -1, -1, -1}, {16443, -1, -1, -1}, {16444, -1, -1, -1}, {16445, -1, -1, -1}, {16446, -1, -1, -1}, {16447, -1, -1, -1}, {16448, -1, -1, -1}, {16449, -1, -1, -1}, {16450, -1, -1, -1}, {16451, -1, -1, -1}, {16452, -1, -1, -1}, {16453, -1, -1, -1}, {16454, -1, -1, -1}, {16455, -1, -1, -1}, {16456, -1, -1, -1}, {16457, -1, -1, -1}, {16458, -1, -1, -1}, {16459, -1, -1, -1}, {16460, -1, -1, -1}, {16461, -1, -1, -1}, {16462, -1, -1, -1}, {16463, -1, -1, -1}, {16464, -1, -1, -1}, {16465, -1, -1, -1}, {16466, -1, -1, -1}, {16467, -1, -1, -1}, {16468, -1, -1, -1}, {16469, -1, -1, -1}, {16471, -1, -1, -1}, {16472, -1, -1, -1}, {16473, -1, -1, -1}, {16474, -1, -1, -1}, {16475, -1, -1, -1}, {16476, -1, -1, -1}, {16477, -1, -1, -1}, {16478, -1, -1, -1}, {16479, -1, -1, -1}, {16480, -1, -1, -1}, {16481, -1, -1, -1}, {16482, -1, -1, -1}, {16483, -1, -1, -1}, {16484, -1, -1, -1}, {16485, -1, -1, -1}, {16486, -1, -1, -1}, {16487, -1, -1, -1}, {16488, -1, -1, -1}, {16489, -1, -1, -1}, {16490, -1, -1, -1}, {16491, -1, -1, -1}, {16492, -1, -1, -1}, {16493, -1, -1, -1}, {16494, -1, -1, -1}, {16495, -1, -1, -1}, {16496, -1, -1, -1}, {16497, -1, -1, -1}, {16498, -1, -1, -1}, {16499, -1, -1, -1}, {16500, -1, -1, -1}, {16501, -1, -1, -1}, {16502, -1, -1, -1}, {16503, -1, -1, -1}, {16504, -1, -1, -1}, {16505, -1, -1, -1}, {16506, -1, -1, -1}, {16507, -1, -1, -1}, {16508, -1, -1, -1}, {16509, -1, -1, -1}, {16510, -1, -1, -1}, {16511, -1, -1, -1}, {16512, -1, -1, -1}, {16513, -1, -1, -1}, {16514, -1, -1, -1}, {16515, -1, -1, -1}, {16516, -1, -1, -1}, {16517, -1, -1, -1}, {16518, -1, -1, -1}, {16519, -1, -1, -1}, {16520, -1, -1, -1}, {16521, -1, -1, -1}, {16522, -1, -1, -1}, {16523, -1, -1, -1}, {16524, -1, -1, -1}, {16525, -1, -1, -1}, {16526, -1, -1, -1}, {16527, -1, -1, -1}, {16528, -1, -1, -1}, {16529, -1, -1, -1}, {16530, -1, -1, -1}, {16531, -1, -1, -1}, {16532, -1, -1, -1}, {16533, -1, -1, -1}, {16534, -1, -1, -1}, {16535, -1, -1, -1}, {16536, -1, -1, -1}, {16537, -1, -1, -1}, {16538, -1, -1, -1}, {16539, -1, -1, -1}, {16540, -1, -1, -1}, {16541, -1, -1, -1}, {16542, -1, -1, -1}, {16543, -1, -1, -1}, {16544, -1, -1, -1}, {16545, -1, -1, -1}, {16546, -1, -1, -1}, {16547, -1, -1, -1}, {16548, -1, -1, -1}, {16549, -1, -1, -1}, {16550, -1, -1, -1}, {16551, -1, -1, -1}, {16552, -1, -1, -1}, {16553, -1, -1, -1}, {16554, -1, -1, -1}, {16555, -1, -1, -1}, {16556, -1, -1, -1}, {16557, -1, -1, -1}, {16558, -1, -1, -1}, {16559, -1, -1, -1}, {16560, -1, -1, -1}, {16561, -1, -1, -1}, {16562, -1, -1, -1}, {16563, -1, -1, -1}, {16564, -1, -1, -1}, {16565, -1, -1, -1}, {16566, -1, -1, -1}, {16567, -1, -1, -1}, {16568, -1, -1, -1}, {16569, -1, -1, -1}, {16570, -1, -1, -1}, {16571, -1, -1, -1}, {16572, -1, -1, -1}, {16573, -1, -1, -1}, {16574, -1, -1, -1}, {16575, -1, -1, -1}, {16576, -1, -1, -1}, {16577, -1, -1, -1}, {16578, -1, -1, -1}, {16579, -1, -1, -1}, {16580, -1, -1, -1}, {16581, -1, -1, -1}, {16582, -1, -1, -1}, {16583, -1, -1, -1}, {16584, -1, -1, -1}, {16585, -1, -1, -1}, {16586, -1, -1, -1}, {16587, -1, -1, -1}, {16588, -1, -1, -1}, {16589, -1, -1, -1}, {16590, -1, -1, -1}, {16591, -1, -1, -1}, {16592, -1, -1, -1}, {16593, -1, -1, -1}, {16594, -1, -1, -1}, {16595, -1, -1, -1}, {16596, -1, -1, -1}, {16597, -1, -1, -1}, {16598, -1, -1, -1}, {16599, -1, -1, -1}, {16600, -1, -1, -1}, {16601, -1, -1, -1}, {16602, -1, -1, -1}, {16603, -1, -1, -1}, {16604, -1, -1, -1}, {16605, -1, -1, -1}, {16606, -1, -1, -1}, {16607, -1, -1, -1}, {16608, -1, -1, -1}, {16609, -1, -1, -1}, {16610, -1, -1, -1}, {16611, -1, -1, -1}, {16612, -1, -1, -1}, {16613, -1, -1, -1}, {16614, -1, -1, -1}, {16615, -1, -1, -1}, {16616, -1, -1, -1}, {16617, -1, -1, -1}, {16618, -1, -1, -1}, {16619, -1, -1, -1}, {16620, -1, -1, -1}, {16621, -1, -1, -1}, {16622, -1, -1, -1}, {16623, -1, -1, -1}, {16624, -1, -1, -1}, {16625, -1, -1, -1}, {16626, -1, -1, -1}, {16627, -1, -1, -1}, {16628, -1, -1, -1}, {16629, -1, -1, -1}, {16630, -1, -1, -1}, {16631, -1, -1, -1}, {16632, -1, -1, -1}, {16633, -1, -1, -1}, {16634, -1, -1, -1}, {16635, -1, -1, -1}, {16636, -1, -1, -1}, {16637, -1, -1, -1}, {16638, -1, -1, -1}, {16639, -1, -1, -1}, {16640, -1, -1, -1}, {16641, -1, -1, -1}, {16642, -1, -1, -1}, {16643, -1, -1, -1}, {16644, -1, -1, -1}, {16645, -1, -1, -1}, {16646, -1, -1, -1}, {16647, -1, -1, -1}, {16648, -1, -1, -1}, {16649, -1, -1, -1}, {16650, -1, -1, -1}, {16651, -1, -1, -1}, {16652, -1, -1, -1}, {16653, -1, -1, -1} },
    {{16654, -1, -1, -1}, {16655, -1, -1, -1}, {16656, -1, -1, -1}, {16657, -1, -1, -1}, {16658, -1, -1, -1}, {16659, -1, -1, -1}, {16660, -1, -1, -1}, {16661, -1, -1, -1}, {16662, -1, -1, -1}, {16663, -1, -1, -1}, {16664, -1, -1, -1}, {16665, -1, -1, -1}, {16666, -1, -1, -1}, {16667, -1, -1, -1}, {16668, -1, -1, -1}, {16669, -1, -1, -1}, {16670, -1, -1, -1}, {16671, -1, -1, -1}, {16672, -1, -1, -1}, {16673, -1, -1, -1}, {16674, -1, -1, -1}, {16675, -1, -1, -1}, {16676, -1, -1, -1}, {16677, -1, -1, -1}, {16678, -1, -1, -1}, {16679, -1, -1, -1}, {16680, -1, -1, -1}, {16681, -1, -1, -1}, {16682, -1, -1, -1}, {16683, -1, -1, -1}, {16684, -1, -1, -1}, {16685, -1, -1, -1}, {16686, -1, -1, -1}, {16687, -1, -1, -1}, {16688, -1, -1, -1}, {16689, -1, -1, -1}, {16690, -1, -1, -1}, {16691, -1, -1, -1}, {16692, -1, -1, -1}, {16693, -1, -1, -1}, {16694, -1, -1, -1}, {16695, -1, -1, -1}, {16696, -1, -1, -1}, {16697, -1, -1, -1}, {16698, -1, -1, -1}, {16699, -1, -1, -1}, {16700, -1, -1, -1}, {16701, -1, -1, -1}, {16702, -1, -1, -1}, {16703, -1, -1, -1}, {16704, -1, -1, -1}, {16705, -1, -1, -1}, {16706, -1, -1, -1}, {16707, -1, -1, -1}, {16708, -1, -1, -1}, {16709, -1, -1, -1}, {16710, -1, -1, -1}, {16711, -1, -1, -1}, {16712, -1, -1, -1}, {16713, -1, -1, -1}, {16714, -1, -1, -1}, {16715, -1, -1, -1}, {16716, -1, -1, -1}, {16717, -1, -1, -1}, {16718, -1, -1, -1}, {16719, -1, -1, -1}, {16720, -1, -1, -1}, {16721, -1, -1, -1}, {16722, -1, -1, -1}, {16723, -1, -1, -1}, {16724, -1, -1, -1}, {16725, -1, -1, -1}, {16726, -1, -1, -1}, {16727, -1, -1, -1}, {16728, -1, -1, -1}, {16729, -1, -1, -1}, {16730, -1, -1, -1}, {16731, -1, -1, -1}, {16732, -1, -1, -1}, {16733, -1, -1, -1}, {16734, -1, -1, -1}, {16736, -1, -1, -1}, {16737, -1, -1, -1}, {16738, -1, -1, -1}, {16739, -1, -1, -1}, {16740, -1, -1, -1}, {16741, -1, -1, -1}, {16742, -1, -1, -1}, {16743, -1, -1, -1}, {16744, -1, -1, -1}, {16745, -1, -1, -1}, {16746, -1, -1, -1}, {16747, -1, -1, -1}, {16748, -1, -1, -1}, {16749, -1, -1, -1}, {16750, -1, -1, -1}, {16751, -1, -1, -1}, {16752, -1, -1, -1}, {16753, -1, -1, -1}, {16754, -1, -1, -1}, {16755, -1, -1, -1}, {16756, -1, -1, -1}, {16757, -1, -1, -1}, {16758, -1, -1, -1}, {16759, -1, -1, -1}, {16760, -1, -1, -1}, {16761, -1, -1, -1}, {16762, -1, -1, -1}, {16763, -1, -1, -1}, {16764, -1, -1, -1}, {16765, -1, -1, -1}, {16766, -1, -1, -1}, {16767, -1, -1, -1}, {16768, -1, -1, -1}, {16769, -1, -1, -1}, {16770, -1, -1, -1}, {16771, -1, -1, -1}, {16772, -1, -1, -1}, {16773, -1, -1, -1}, {16774, -1, -1, -1}, {16775, -1, -1, -1}, {16776, -1, -1, -1}, {16777, -1, -1, -1}, {16778, -1, -1, -1}, {16779, -1, -1, -1}, {16780, -1, -1, -1}, {16781, -1, -1, -1}, {16782, -1, -1, -1}, {16783, -1, -1, -1}, {16784, -1, -1, -1}, {16785, -1, -1, -1}, {16786, -1, -1, -1}, {16787, -1, -1, -1}, {16788, -1, -1, -1}, {16789, -1, -1, -1}, {16790, -1, -1, -1}, {16791, -1, -1, -1}, {16792, -1, -1, -1}, {16793, -1, -1, -1}, {16794, -1, -1, -1}, {16795, -1, -1, -1}, {16796, -1, -1, -1}, {16797, -1, -1, -1}, {16798, -1, -1, -1}, {16799, -1, -1, -1}, {16800, -1, -1, -1}, {16801, -1, -1, -1}, {16802, -1, -1, -1}, {16803, -1, -1, -1}, {16804, -1, -1, -1}, {16805, -1, -1, -1}, {16806, -1, -1, -1}, {16807, -1, -1, -1}, {16808, -1, -1, -1}, {16809, -1, -1, -1}, {16810, -1, -1, -1}, {16811, -1, -1, -1}, {16812, -1, -1, -1}, {16813, -1, -1, -1}, {16814, -1, -1, -1}, {16815, -1, -1, -1}, {16816, -1, -1, -1}, {16817, -1, -1, -1}, {16818, -1, -1, -1}, {16819, -1, -1, -1}, {16820, -1, -1, -1}, {16821, -1, -1, -1}, {16822, -1, -1, -1}, {16823, -1, -1, -1}, {16824, -1, -1, -1}, {16825, -1, -1, -1}, {16826, -1, -1, -1}, {16827, -1, -1, -1}, {16828, -1, -1, -1}, {16829, -1, -1, -1}, {16830, -1, -1, -1}, {16831, -1, -1, -1}, {16832, -1, -1, -1}, {16833, -1, -1, -1}, {16834, -1, -1, -1}, {16835, -1, -1, -1}, {16836, -1, -1, -1}, {16837, -1, -1, -1}, {16838, -1, -1, -1}, {16839, -1, -1, -1}, {16840, -1, -1, -1}, {16841, -1, -1, -1}, {16842, -1, -1, -1}, {16843, -1, -1, -1}, {16844, -1, -1, -1}, {16845, -1, -1, -1}, {16846, -1, -1, -1}, {16847, -1, -1, -1}, {16848, -1, -1, -1}, {16849, -1, -1, -1}, {16850, -1, -1, -1}, {16851, -1, -1, -1}, {16852, -1, -1, -1}, {16853, -1, -1, -1}, {16854, -1, -1, -1}, {16855, -1, -1, -1}, {16856, -1, -1, -1}, {16857, -1, -1, -1}, {16858, -1, -1, -1}, {16859, -1, -1, -1}, {16860, -1, -1, -1}, {16861, -1, -1, -1}, {16862, -1, -1, -1}, {16863, -1, -1, -1}, {16864, -1, -1, -1}, {16865, -1, -1, -1}, {16866, -1, -1, -1}, {16867, -1, -1, -1}, {16868, -1, -1, -1}, {16869, -1, -1, -1}, {16870, -1, -1, -1}, {16871, -1, -1, -1}, {16872, -1, -1, -1}, {16873, -1, -1, -1}, {16874, -1, -1, -1}, {16875, -1, -1, -1}, {16876, -1, -1, -1}, {16877, -1, -1, -1}, {16878, -1, -1, -1}, {16879, -1, -1, -1}, {16880, -1, -1, -1}, {16881, -1, -1, -1}, {16882, -1, -1, -1}, {16883, -1, -1, -1}, {16884, -1, -1, -1}, {16885, -1, -1, -1}, {16886, -1, -1, -1}, {16887, -1, -1, -1}, {16888, -1, -1, -1}, {16889, -1, -1, -1}, {16890, -1, -1, -1}, {16891, -1, -1, -1}, {16892, -1, -1, -1}, {16893, -1, -1, -1}, {16894, -1, -1, -1}, {16895, -1, -1, -1}, {16896, -1, -1, -1}, {16897, -1, -1, -1}, {16898, -1, -1, -1}, {16899, -1, -1, -1}, {16900, -1, -1, -1}, {16901, -1, -1, -1}, {16902, -1, -1, -1}, {16903, -1, -1, -1}, {16904, -1, -1, -1}, {16905, -1, -1, -1}, {16906, -1, -1, -1}, {16907, -1, -1, -1}, {16908, -1, -1, -1}, {16909, -1, -1, -1}, {16910, -1, -1, -1} },
    {{16911, -1, -1, -1}, {16912, -1, -1, -1}, {16913, -1, -1, -1}, {16914, -1, -1, -1}, {16915, -1, -1, -1}, {16916, -1, -1, -1}, {16917, -1, -1, -1}, {16918, -1, -1, -1}, {16919, -1, -1, -1}, {16920, -1, -1, -1}, {16921, -1, -1, -1}, {16922, -1, -1, -1}, {16923, -1, -1, -1}, {16924, -1, -1, -1}, {16925, -1, -1, -1}, {16926, -1, -1, -1}, {16927, -1, -1, -1}, {16928, -1, -1, -1}, {16929, -1, -1, -1}, {16930, -1, -1, -1}, {16931, -1, -1, -1}, {16932, -1, -1, -1}, {16933, -1, -1, -1}, {16934, -1, -1, -1}, {16935, -1, -1, -1}, {16936, -1, -1, -1}, {16937, -1, -1, -1}, {16938, -1, -1, -1}, {16939, -1, -1, -1}, {16940, -1, -1, -1}, {16941, -1, -1, -1}, {16942, -1, -1, -1}, {16943, -1, -1, -1}, {16944, -1, -1, -1}, {16945, -1, -1, -1}, {16946, -1, -1, -1}, {16947, -1, -1, -1}, {16948, -1, -1, -1}, {16949, -1, -1, -1}, {16950, -1, -1, -1}, {16951, -1, -1, -1}, {16952, -1, -1, -1}, {16953, -1, -1, -1}, {16954, -1, -1, -1}, {16955, -1, -1, -1}, {16956, -1, -1, -1}, {16957, -1, -1, -1}, {16958, -1, -1, -1}, {16959, -1, -1, -1}, {16960, -1, -1, -1}, {16961, -1, -1, -1}, {16962, -1, -1, -1}, {16963, -1, -1, -1}, {16964, -1, -1, -1}, {16965, -1, -1, -1}, {16966, -1, -1, -1}, {16967, -1, -1, -1}, {16968, -1, -1, -1}, {16969, -1, -1, -1}, {16970, -1, -1, -1}, {16971, -1, -1, -1}, {16972, -1, -1, -1}, {16973, -1, -1, -1}, {16974, -1, -1, -1}, {16975, -1, -1, -1}, {16976, -1, -1, -1}, {16977, -1, -1, -1}, {16978, -1, -1, -1}, {16979, -1, -1, -1}, {16980, -1, -1, -1}, {16981, -1, -1, -1}, {16982, -1, -1, -1}, {16983, -1, -1, -1}, {16984, -1, -1, -1}, {16985, -1, -1, -1}, {16986, -1, -1, -1}, {16987, -1, -1, -1}, {16988, -1, -1, -1}, {16989, -1, -1, -1}, {16990, -1, -1, -1}, {16991, -1, -1, -1}, {16992, -1, -1, -1}, {16993, -1, -1, -1}, {16994, -1, -1, -1}, {16995, -1, -1, -1}, {16996, -1, -1, -1}, {16997, -1, -1, -1}, {16998, -1, -1, -1}, {16999, -1, -1, -1}, {17000, -1, -1, -1}, {17001, -1, -1, -1}, {17002, -1, -1, -1}, {17003, -1, -1, -1}, {17004, -1, -1, -1}, {17005, -1, -1, -1}, {17006, -1, -1, -1}, {17007, -1, -1, -1}, {17008, -1, -1, -1}, {17009, -1, -1, -1}, {17010, -1, -1, -1}, {17011, -1, -1, -1}, {17012, -1, -1, -1}, {17013, -1, -1, -1}, {17014, -1, -1, -1}, {17015, -1, -1, -1}, {17016, -1, -1, -1}, {17017, -1, -1, -1}, {17018, -1, -1, -1}, {17019, -1, -1, -1}, {17020, -1, -1, -1}, {17021, -1, -1, -1}, {17022, -1, -1, -1}, {17023, -1, -1, -1}, {17024, -1, -1, -1}, {17025, -1, -1, -1}, {17026, -1, -1, -1}, {17027, -1, -1, -1}, {17028, -1, -1, -1}, {17029, -1, -1, -1}, {17030, -1, -1, -1}, {17031, -1, -1, -1}, {17032, -1, -1, -1}, {17033, -1, -1, -1}, {17034, -1, -1, -1}, {17035, -1, -1, -1}, {17036, -1, -1, -1}, {17037, -1, -1, -1}, {17038, -1, -1, -1}, {17039, -1, -1, -1}, {17040, -1, -1, -1}, {17041, -1, -1, -1}, {17042, -1, -1, -1}, {17043, -1, -1, -1}, {17044, -1, -1, -1}, {17045, -1, -1, -1}, {17046, -1, -1, -1}, {17047, -1, -1, -1}, {17048, -1, -1, -1}, {17049, -1, -1, -1}, {17050, -1, -1, -1}, {17051, -1, -1, -1}, {17052, -1, -1, -1}, {17053, -1, -1, -1}, {17054, -1, -1, -1}, {17055, -1, -1, -1}, {17056, -1, -1, -1}, {17057, -1, -1, -1}, {17058, -1, -1, -1}, {17059, -1, -1, -1}, {17060, -1, -1, -1}, {17061, -1, -1, -1}, {17062, -1, -1, -1}, {17063, -1, -1, -1}, {17064, -1, -1, -1}, {17065, -1, -1, -1}, {17066, -1, -1, -1}, {17067, -1, -1, -1}, {17068, -1, -1, -1}, {17069, -1, -1, -1}, {17070, -1, -1, -1}, {17071, -1, -1, -1}, {17072, -1, -1, -1}, {17073, -1, -1, -1}, {17074, -1, -1, -1}, {17075, -1, -1, -1}, {17076, -1, -1, -1}, {17077, -1, -1, -1}, {17078, -1, -1, -1}, {17079, -1, -1, -1}, {17080, -1, -1, -1}, {17081, -1, -1, -1}, {17082, -1, -1, -1}, {17083, -1, -1, -1}, {17084, -1, -1, -1}, {17085, -1, -1, -1}, {17086, -1, -1, -1}, {17087, -1, -1, -1}, {17088, -1, -1, -1}, {17089, -1, -1, -1}, {17090, -1, -1, -1}, {17091, -1, -1, -1}, {17092, -1, -1, -1}, {17093, -1, -1, -1}, {17094, -1, -1, -1}, {17095, -1, -1, -1}, {17096, -1, -1, -1}, {17097, -1, -1, -1}, {17098, -1, -1, -1}, {17099, -1, -1, -1}, {17100, -1, -1, -1}, {17101, -1, -1, -1}, {17102, -1, -1, -1}, {17103, -1, -1, -1}, {17104, -1, -1, -1}, {17105, -1, -1, -1}, {17106, -1, -1, -1}, {17107, -1, -1, -1}, {17108, -1, -1, -1}, {17109, -1, -1, -1}, {17110, -1, -1, -1}, {17111, -1, -1, -1}, {17112, -1, -1, -1}, {17113, -1, -1, -1}, {17114, -1, -1, -1}, {17115, -1, -1, -1}, {17116, -1, -1, -1}, {17117, -1, -1, -1}, {17118, -1, -1, -1}, {17119, -1, -1, -1}, {17120, -1, -1, -1}, {17121, -1, -1, -1}, {17122, -1, -1, -1}, {17123, -1, -1, -1}, {17124, -1, -1, -1}, {17125, -1, -1, -1}, {17126, -1, -1, -1}, {17127, -1, -1, -1}, {17128, -1, -1, -1}, {17129, -1, -1, -1}, {17130, -1, -1, -1}, {17131, -1, -1, -1}, {17132, -1, -1, -1}, {17133, -1, -1, -1}, {17134, -1, -1, -1}, {17135, -1, -1, -1}, {17136, -1, -1, -1}, {17137, -1, -1, -1}, {17138, -1, -1, -1}, {17139, -1, -1, -1}, {17140, -1, -1, -1}, {17141, -1, -1, -1}, {17142, -1, -1, -1}, {17143, -1, -1, -1}, {17144, -1, -1, -1}, {17145, -1, -1, -1}, {17146, -1, -1, -1}, {17147, -1, -1, -1}, {17148, -1, -1, -1}, {17149, -1, -1, -1}, {17150, -1, -1, -1}, {17151, -1, -1, -1}, {17152, -1, -1, -1}, {17153, -1, -1, -1}, {17154, -1, -1, -1}, {17155, -1, -1, -1}, {17156, -1, -1, -1}, {17157, -1, -1, -1}, {17158, -1, -1, -1}, {17159, -1, -1, -1}, {17160, -1, -1, -1}, {17161, -1, -1, -1}, {17162, -1, -1, -1}, {17163, -1, -1, -1}, {17164, -1, -1, -1}, {17165, -1, -1, -1}, {17166, -1, -1, -1} },
    {{17167, -1, -1, -1}, {17168, -1, -1, -1}, {17169, -1, -1, -1}, {17170, -1, -1, -1}, {17171, -1, -1, -1}, {17172, -1, -1, -1}, {17173, -1, -1, -1}, {17174, -1, -1, -1}, {17175, -1, -1, -1}, {17176, -1, -1, -1}, {17177, -1, -1, -1}, {17178, -1, -1, -1}, {17179, -1, -1, -1}, {17180, -1, -1, -1}, {17181, -1, -1, -1}, {17182, -1, -1, -1}, {17183, -1, -1, -1}, {17184, -1, -1, -1}, {17185, -1, -1, -1}, {17186, -1, -1, -1}, {17187, -1, -1, -1}, {17188, -1, -1, -1}, {17189, -1, -1, -1}, {17190, -1, -1, -1}, {17191, -1, -1, -1}, {17192, -1, -1, -1}, {17193, -1, -1, -1}, {17194, -1, -1, -1}, {17195, -1, -1, -1}, {17196, -1, -1, -1}, {17197, -1, -1, -1}, {17198, -1, -1, -1}, {17199, -1, -1, -1}, {17200, -1, -1, -1}, {17201, -1, -1, -1}, {17202, -1, -1, -1}, {17203, -1, -1, -1}, {17204, -1, -1, -1}, {17205, -1, -1, -1}, {17206, -1, -1, -1}, {17208, -1, -1, -1}, {17209, -1, -1, -1}, {17210, -1, -1, -1}, {17211, -1, -1, -1}, {17212, -1, -1, -1}, {17213, -1, -1, -1}, {17214, -1, -1, -1}, {17215, -1, -1, -1}, {17216, -1, -1, -1}, {17217, -1, -1, -1}, {17218, -1, -1, -1}, {17219, -1, -1, -1}, {17220, -1, -1, -1}, {17221, -1, -1, -1}, {17222, -1, -1, -1}, {17223, -1, -1, -1}, {17224, -1, -1, -1}, {17225, -1, -1, -1}, {17226, -1, -1, -1}, {17227, -1, -1, -1}, {17228, -1, -1, -1}, {17229, -1, -1, -1}, {17230, -1, -1, -1}, {17231, -1, -1, -1}, {17232, -1, -1, -1}, {17233, -1, -1, -1}, {17234, -1, -1, -1}, {17235, -1, -1, -1}, {17236, -1, -1, -1}, {17237, -1, -1, -1}, {17238, -1, -1, -1}, {17239, -1, -1, -1}, {17240, -1, -1, -1}, {17241, -1, -1, -1}, {17242, -1, -1, -1}, {17243, -1, -1, -1}, {17244, -1, -1, -1}, {17245, -1, -1, -1}, {17246, -1, -1, -1}, {17247, -1, -1, -1}, {17248, -1, -1, -1}, {17249, -1, -1, -1}, {17250, -1, -1, -1}, {17251, -1, -1, -1}, {17252, -1, -1, -1}, {17253, -1, -1, -1}, {17254, -1, -1, -1}, {17255, -1, -1, -1}, {17256, -1, -1, -1}, {17257, -1, -1, -1}, {17258, -1, -1, -1}, {17259, -1, -1, -1}, {17260, -1, -1, -1}, {17261, -1, -1, -1}, {17262, -1, -1, -1}, {17263, -1, -1, -1}, {17264, -1, -1, -1}, {17265, -1, -1, -1}, {17266, -1, -1, -1}, {17267, -1, -1, -1}, {17268, -1, -1, -1}, {17269, -1, -1, -1}, {17270, -1, -1, -1}, {17271, -1, -1, -1}, {17272, -1, -1, -1}, {17273, -1, -1, -1}, {17274, -1, -1, -1}, {17275, -1, -1, -1}, {17276, -1, -1, -1}, {17277, -1, -1, -1}, {17278, -1, -1, -1}, {17279, -1, -1, -1}, {17280, -1, -1, -1}, {17281, -1, -1, -1}, {17282, -1, -1, -1}, {17283, -1, -1, -1}, {17284, -1, -1, -1}, {17285, -1, -1, -1}, {17286, -1, -1, -1}, {17287, -1, -1, -1}, {17288, -1, -1, -1}, {17289, -1, -1, -1}, {17290, -1, -1, -1}, {17291, -1, -1, -1}, {17292, -1, -1, -1}, {17293, -1, -1, -1}, {17294, -1, -1, -1}, {17295, -1, -1, -1}, {17296, -1, -1, -1}, {17297, -1, -1, -1}, {17298, -1, -1, -1}, {17299, -1, -1, -1}, {17300, -1, -1, -1}, {17301, -1, -1, -1}, {17302, -1, -1, -1}, {17303, -1, -1, -1}, {17304, -1, -1, -1}, {17305, -1, -1, -1}, {17306, -1, -1, -1}, {17307, -1, -1, -1}, {17308, -1, -1, -1}, {17309, -1, -1, -1}, {17310, -1, -1, -1}, {17311, -1, -1, -1}, {17312, -1, -1, -1}, {17313, -1, -1, -1}, {17314, -1, -1, -1}, {17315, -1, -1, -1}, {17316, -1, -1, -1}, {17317, -1, -1, -1}, {17318, -1, -1, -1}, {17319, -1, -1, -1}, {17320, -1, -1, -1}, {17321, -1, -1, -1}, {17322, -1, -1, -1}, {17323, -1, -1, -1}, {17325, -1, -1, -1}, {17326, -1, -1, -1}, {17327, -1, -1, -1}, {17328, -1, -1, -1}, {17330, -1, -1, -1}, {17331, -1, -1, -1}, {17332, -1, -1, -1}, {17333, -1, -1, -1}, {17334, -1, -1, -1}, {17335, -1, -1, -1}, {17336, -1, -1, -1}, {17337, -1, -1, -1}, {17338, -1, -1, -1}, {17339, -1, -1, -1}, {17340, -1, -1, -1}, {17341, -1, -1, -1}, {17342, -1, -1, -1}, {17343, -1, -1, -1}, {17344, -1, -1, -1}, {17345, -1, -1, -1}, {17346, -1, -1, -1}, {17347, -1, -1, -1}, {17348, -1, -1, -1}, {17349, -1, -1, -1}, {17350, -1, -1, -1}, {17351, -1, -1, -1}, {17352, -1, -1, -1}, {17353, -1, -1, -1}, {17354, -1, -1, -1}, {17355, -1, -1, -1}, {17356, -1, -1, -1}, {17357, -1, -1, -1}, {17358, -1, -1, -1}, {17359, -1, -1, -1}, {17360, -1, -1, -1}, {17361, -1, -1, -1}, {17362, -1, -1, -1}, {17363, -1, -1, -1}, {17364, -1, -1, -1}, {17365, -1, -1, -1}, {17366, -1, -1, -1}, {17367, -1, -1, -1}, {17368, -1, -1, -1}, {17369, -1, -1, -1}, {17370, -1, -1, -1}, {17371, -1, -1, -1}, {17372, -1, -1, -1}, {17374, -1, -1, -1}, {17375, -1, -1, -1}, {17376, -1, -1, -1}, {17377, -1, -1, -1}, {17378, -1, -1, -1}, {17379, -1, -1, -1}, {17380, -1, -1, -1}, {17381, -1, -1, -1}, {17382, -1, -1, -1}, {17383, -1, -1, -1}, {17384, -1, -1, -1}, {17385, -1, -1, -1}, {17386, -1, -1, -1}, {17387, -1, -1, -1}, {17388, -1, -1, -1}, {17389, -1, -1, -1}, {17390, -1, -1, -1}, {17391, -1, -1, -1}, {17392, -1, -1, -1}, {17393, -1, -1, -1}, {17394, -1, -1, -1}, {17395, -1, -1, -1}, {17396, -1, -1, -1}, {17397, -1, -1, -1}, {17398, -1, -1, -1}, {17399, -1, -1, -1}, {17400, -1, -1, -1}, {17401, -1, -1, -1}, {17402, -1, -1, -1}, {17403, -1, -1, -1}, {17404, -1, -1, -1}, {17405, -1, -1, -1}, {17406, -1, -1, -1}, {17407, -1, -1, -1}, {17408, -1, -1, -1}, {17409, -1, -1, -1}, {17410, -1, -1, -1}, {17411, -1, -1, -1}, {17412, -1, -1, -1}, {17413, -1, -1, -1}, {17414, -1, -1, -1}, {17415, -1, -1, -1}, {17416, -1, -1, -1}, {17417, -1, -1, -1}, {17418, -1, -1, -1}, {17419, -1, -1, -1}, {17420, -1, -1, -1}, {17421, -1, -1, -1}, {17422, -1, -1, -1}, {17423, -1, -1, -1}, {17424, -1, -1, -1}, {17425, -1, -1, -1}, {17426, -1, -1, -1} },
    {{17427, -1, -1, -1}, {17428, -1, -1, -1}, {17429, -1, -1, -1}, {17430, -1, -1, -1}, {17431, -1, -1, -1}, {17432, -1, -1, -1}, {17433, -1, -1, -1}, {17434, -1, -1, -1}, {17435, -1, -1, -1}, {17436, -1, -1, -1}, {17437, -1, -1, -1}, {17438, -1, -1, -1}, {17439, -1, -1, -1}, {17440, -1, -1, -1}, {17441, -1, -1, -1}, {17442, -1, -1, -1}, {17443, -1, -1, -1}, {17444, -1, -1, -1}, {17445, -1, -1, -1}, {17446, -1, -1, -1}, {17447, -1, -1, -1}, {17448, -1, -1, -1}, {17449, -1, -1, -1}, {17450, -1, -1, -1}, {17451, -1, -1, -1}, {17452, -1, -1, -1}, {17453, -1, -1, -1}, {17454, -1, -1, -1}, {17455, -1, -1, -1}, {17456, -1, -1, -1}, {17457, -1, -1, -1}, {17458, -1, -1, -1}, {17459, -1, -1, -1}, {17460, -1, -1, -1}, {17461, -1, -1, -1}, {17462, -1, -1, -1}, {17463, -1, -1, -1}, {17464, -1, -1, -1}, {17465, -1, -1, -1}, {17466, -1, -1, -1}, {17467, -1, -1, -1}, {17468, -1, -1, -1}, {17469, -1, -1, -1}, {17470, -1, -1, -1}, {17471, -1, -1, -1}, {17472, -1, -1, -1}, {17473, -1, -1, -1}, {17474, -1, -1, -1}, {17475, -1, -1, -1}, {17476, -1, -1, -1}, {17477, -1, -1, -1}, {17478, -1, -1, -1}, {17479, -1, -1, -1}, {17480, -1, -1, -1}, {17481, -1, -1, -1}, {17482, -1, -1, -1}, {17483, -1, -1, -1}, {17484, -1, -1, -1}, {17485, -1, -1, -1}, {17486, -1, -1, -1}, {17487, -1, -1, -1}, {17488, -1, -1, -1}, {17489, -1, -1, -1}, {17490, -1, -1, -1}, {17491, -1, -1, -1}, {17492, -1, -1, -1}, {17493, -1, -1, -1}, {17494, -1, -1, -1}, {17495, -1, -1, -1}, {17496, -1, -1, -1}, {17497, -1, -1, -1}, {17498, -1, -1, -1}, {17499, -1, -1, -1}, {17500, -1, -1, -1}, {17501, -1, -1, -1}, {17502, -1, -1, -1}, {17503, -1, -1, -1}, {17504, -1, -1, -1}, {17505, -1, -1, -1}, {17506, -1, -1, -1}, {17507, -1, -1, -1}, {17508, -1, -1, -1}, {17509, -1, -1, -1}, {17510, -1, -1, -1}, {17511, -1, -1, -1}, {17512, -1, -1, -1}, {17513, -1, -1, -1}, {17514, -1, -1, -1}, {17515, -1, -1, -1}, {17516, -1, -1, -1}, {17517, -1, -1, -1}, {17518, -1, -1, -1}, {17519, -1, -1, -1}, {17520, -1, -1, -1}, {17521, -1, -1, -1}, {17522, -1, -1, -1}, {17523, -1, -1, -1}, {17524, -1, -1, -1}, {17525, -1, -1, -1}, {17526, -1, -1, -1}, {17527, -1, -1, -1}, {17528, -1, -1, -1}, {17529, -1, -1, -1}, {17530, -1, -1, -1}, {17531, -1, -1, -1}, {17532, -1, -1, -1}, {17533, -1, -1, -1}, {17534, -1, -1, -1}, {17535, -1, -1, -1}, {17536, -1, -1, -1}, {17537, -1, -1, -1}, {17538, -1, -1, -1}, {17539, -1, -1, -1}, {17540, -1, -1, -1}, {17541, -1, -1, -1}, {17542, -1, -1, -1}, {17543, -1, -1, -1}, {17544, -1, -1, -1}, {17545, -1, -1, -1}, {17546, -1, -1, -1}, {17547, -1, -1, -1}, {17548, -1, -1, -1}, {17549, -1, -1, -1}, {17550, -1, -1, -1}, {17551, -1, -1, -1}, {17552, -1, -1, -1}, {17553, -1, -1, -1}, {17554, -1, -1, -1}, {17555, -1, -1, -1}, {17556, -1, -1, -1}, {17557, -1, -1, -1}, {17558, -1, -1, -1}, {17559, -1, -1, -1}, {17560, -1, -1, -1}, {17561, -1, -1, -1}, {17562, -1, -1, -1}, {17563, -1, -1, -1}, {17564, -1, -1, -1}, {17565, -1, -1, -1}, {17566, -1, -1, -1}, {17567, -1, -1, -1}, {17568, -1, -1, -1}, {17569, -1, -1, -1}, {17570, -1, -1, -1}, {17571, -1, -1, -1}, {17572, -1, -1, -1}, {17573, -1, -1, -1}, {17574, -1, -1, -1}, {17575, -1, -1, -1}, {17576, -1, -1, -1}, {17577, -1, -1, -1}, {17578, -1, -1, -1}, {17579, -1, -1, -1}, {17580, -1, -1, -1}, {17581, -1, -1, -1}, {17582, -1, -1, -1}, {17583, -1, -1, -1}, {17584, -1, -1, -1}, {17585, -1, -1, -1}, {17586, -1, -1, -1}, {17587, -1, -1, -1}, {17588, -1, -1, -1}, {17589, -1, -1, -1}, {17590, -1, -1, -1}, {17591, -1, -1, -1}, {17592, -1, -1, -1}, {17593, -1, -1, -1}, {17594, -1, -1, -1}, {17595, -1, -1, -1}, {17596, -1, -1, -1}, {17597, -1, -1, -1}, {17598, -1, -1, -1}, {17599, -1, -1, -1}, {17600, -1, -1, -1}, {17601, -1, -1, -1}, {17602, -1, -1, -1}, {17603, -1, -1, -1}, {17604, -1, -1, -1}, {17605, -1, -1, -1}, {17606, -1, -1, -1}, {17607, -1, -1, -1}, {17608, -1, -1, -1}, {17609, -1, -1, -1}, {17610, -1, -1, -1}, {17611, -1, -1, -1}, {17612, -1, -1, -1}, {17613, -1, -1, -1}, {17614, -1, -1, -1}, {17615, -1, -1, -1}, {17616, -1, -1, -1}, {17617, -1, -1, -1}, {17618, -1, -1, -1}, {17619, -1, -1, -1}, {17620, -1, -1, -1}, {17621, -1, -1, -1}, {17623, -1, -1, -1}, {17624, -1, -1, -1}, {17625, -1, -1, -1}, {17626, -1, -1, -1}, {17627, -1, -1, -1}, {17628, -1, -1, -1}, {17629, -1, -1, -1}, {17630, -1, -1, -1}, {17631, -1, -1, -1}, {17632, -1, -1, -1}, {17633, -1, -1, -1}, {17634, -1, -1, -1}, {17635, -1, -1, -1}, {17636, -1, -1, -1}, {17637, -1, -1, -1}, {17638, -1, -1, -1}, {17639, -1, -1, -1}, {17640, -1, -1, -1}, {17641, -1, -1, -1}, {17642, -1, -1, -1}, {17643, -1, -1, -1}, {17644, -1, -1, -1}, {17645, -1, -1, -1}, {17646, -1, -1, -1}, {17647, -1, -1, -1}, {17648, -1, -1, -1}, {17649, -1, -1, -1}, {17650, -1, -1, -1}, {17651, -1, -1, -1}, {17652, -1, -1, -1}, {17653, -1, -1, -1}, {17654, -1, -1, -1}, {17655, -1, -1, -1}, {17656, -1, -1, -1}, {17657, -1, -1, -1}, {17658, -1, -1, -1}, {17659, -1, -1, -1}, {17660, -1, -1, -1}, {17661, -1, -1, -1}, {17662, -1, -1, -1}, {17663, -1, -1, -1}, {17664, -1, -1, -1}, {17665, -1, -1, -1}, {17666, -1, -1, -1}, {17667, -1, -1, -1}, {17668, -1, -1, -1}, {17669, -1, -1, -1}, {17670, -1, -1, -1}, {17671, -1, -1, -1}, {17672, -1, -1, -1}, {17673, -1, -1, -1}, {17674, -1, -1, -1}, {17675, -1, -1, -1}, {17676, -1, -1, -1}, {17677, -1, -1, -1}, {17678, -1, -1, -1}, {17679, -1, -1, -1}, {17680, -1, -1, -1}, {17681, -1, -1, -1}, {17682, -1, -1, -1}, {17683, -1, -1, -1} },
    {{17684, -1, -1, -1}, {17685, -1, -1, -1}, {17686, -1, -1, -1}, {17687, -1, -1, -1}, {17688, -1, -1, -1}, {17689, -1, -1, -1}, {17690, -1, -1, -1}, {17691, -1, -1, -1}, {17692, -1, -1, -1}, {17693, -1, -1, -1}, {17694, -1, -1, -1}, {17695, -1, -1, -1}, {17696, -1, -1, -1}, {17697, -1, -1, -1}, {17698, -1, -1, -1}, {17699, -1, -1, -1}, {17700, -1, -1, -1}, {17701, -1, -1, -1}, {17702, -1, -1, -1}, {17703, -1, -1, -1}, {17704, -1, -1, -1}, {17705, -1, -1, -1}, {17706, -1, -1, -1}, {17707, -1, -1, -1}, {17708, -1, -1, -1}, {17709, -1, -1, -1}, {17710, -1, -1, -1}, {17711, -1, -1, -1}, {17712, -1, -1, -1}, {17713, -1, -1, -1}, {17714, -1, -1, -1}, {17715, -1, -1, -1}, {17716, -1, -1, -1}, {17717, -1, -1, -1}, {17718, -1, -1, -1}, {17719, -1, -1, -1}, {17720, -1, -1, -1}, {17721, -1, -1, -1}, {17722, -1, -1, -1}, {17723, -1, -1, -1}, {17724, -1, -1, -1}, {17725, -1, -1, -1}, {17726, -1, -1, -1}, {17727, -1, -1, -1}, {17728, -1, -1, -1}, {17729, -1, -1, -1}, {17730, -1, -1, -1}, {17731, -1, -1, -1}, {17732, -1, -1, -1}, {17733, -1, -1, -1}, {17734, -1, -1, -1}, {17735, -1, -1, -1}, {17736, -1, -1, -1}, {17737, -1, -1, -1}, {17738, -1, -1, -1}, {17739, -1, -1, -1}, {17740, -1, -1, -1}, {17741, -1, -1, -1}, {17742, -1, -1, -1}, {17743, -1, -1, -1}, {17744, -1, -1, -1}, {17745, -1, -1, -1}, {17746, -1, -1, -1}, {17747, -1, -1, -1}, {17748, -1, -1, -1}, {17749, -1, -1, -1}, {17750, -1, -1, -1}, {17751, -1, -1, -1}, {17752, -1, -1, -1}, {17753, -1, -1, -1}, {17754, -1, -1, -1}, {17755, -1, -1, -1}, {17756, -1, -1, -1}, {17757, -1, -1, -1}, {17758, -1, -1, -1}, {17759, -1, -1, -1}, {17760, -1, -1, -1}, {17761, -1, -1, -1}, {17762, -1, -1, -1}, {17763, -1, -1, -1}, {17764, -1, -1, -1}, {17765, -1, -1, -1}, {17766, -1, -1, -1}, {17767, -1, -1, -1}, {17768, -1, -1, -1}, {17769, -1, -1, -1}, {17770, -1, -1, -1}, {17771, -1, -1, -1}, {17772, -1, -1, -1}, {17773, -1, -1, -1}, {17774, -1, -1, -1}, {17775, -1, -1, -1}, {17776, -1, -1, -1}, {17777, -1, -1, -1}, {17778, -1, -1, -1}, {17779, -1, -1, -1}, {17780, -1, -1, -1}, {17781, -1, -1, -1}, {17782, -1, -1, -1}, {17783, -1, -1, -1}, {17784, -1, -1, -1}, {17785, -1, -1, -1}, {17786, -1, -1, -1}, {17787, -1, -1, -1}, {17788, -1, -1, -1}, {17789, -1, -1, -1}, {17790, -1, -1, -1}, {17791, -1, -1, -1}, {17792, -1, -1, -1}, {17793, -1, -1, -1}, {17794, -1, -1, -1}, {17795, -1, -1, -1}, {17796, -1, -1, -1}, {17797, -1, -1, -1}, {17798, -1, -1, -1}, {17799, -1, -1, -1}, {17800, -1, -1, -1}, {17801, -1, -1, -1}, {17802, -1, -1, -1}, {17803, -1, -1, -1}, {17804, -1, -1, -1}, {17805, -1, -1, -1}, {17806, -1, -1, -1}, {17807, -1, -1, -1}, {17808, -1, -1, -1}, {17809, -1, -1, -1}, {17810, -1, -1, -1}, {17811, -1, -1, -1}, {17812, -1, -1, -1}, {17813, -1, -1, -1}, {17814, -1, -1, -1}, {17815, -1, -1, -1}, {17816, -1, -1, -1}, {17817, -1, -1, -1}, {17818, -1, -1, -1}, {17819, -1, -1, -1}, {17820, -1, -1, -1}, {17821, -1, -1, -1}, {17822, -1, -1, -1}, {17823, -1, -1, -1}, {17824, -1, -1, -1}, {17825, -1, -1, -1}, {17826, -1, -1, -1}, {17827, -1, -1, -1}, {17828, -1, -1, -1}, {17829, -1, -1, -1}, {17830, -1, -1, -1}, {17831, -1, -1, -1}, {17832, -1, -1, -1}, {17833, -1, -1, -1}, {17834, -1, -1, -1}, {17835, -1, -1, -1}, {17836, -1, -1, -1}, {17837, -1, -1, -1}, {17838, -1, -1, -1}, {17839, -1, -1, -1}, {17840, -1, -1, -1}, {17841, -1, -1, -1}, {17842, -1, -1, -1}, {17843, -1, -1, -1}, {17844, -1, -1, -1}, {17845, -1, -1, -1}, {17846, -1, -1, -1}, {17847, -1, -1, -1}, {17848, -1, -1, -1}, {17849, -1, -1, -1}, {17850, -1, -1, -1}, {17851, -1, -1, -1}, {17852, -1, -1, -1}, {17853, -1, -1, -1}, {17854, -1, -1, -1}, {17855, -1, -1, -1}, {17856, -1, -1, -1}, {17857, -1, -1, -1}, {17858, -1, -1, -1}, {17859, -1, -1, -1}, {17860, -1, -1, -1}, {17861, -1, -1, -1}, {17862, -1, -1, -1}, {17863, -1, -1, -1}, {17864, -1, -1, -1}, {17865, -1, -1, -1}, {17866, -1, -1, -1}, {17867, -1, -1, -1}, {17868, -1, -1, -1}, {17869, -1, -1, -1}, {17870, -1, -1, -1}, {17871, -1, -1, -1}, {17872, -1, -1, -1}, {17873, -1, -1, -1}, {17874, -1, -1, -1}, {17875, -1, -1, -1}, {17876, -1, -1, -1}, {17877, -1, -1, -1}, {17878, -1, -1, -1}, {17879, -1, -1, -1}, {17880, -1, -1, -1}, {17881, -1, -1, -1}, {17882, -1, -1, -1}, {17883, -1, -1, -1}, {17884, -1, -1, -1}, {17885, -1, -1, -1}, {17886, -1, -1, -1}, {17887, -1, -1, -1}, {17888, -1, -1, -1}, {17889, -1, -1, -1}, {17890, -1, -1, -1}, {17891, -1, -1, -1}, {17892, -1, -1, -1}, {17893, -1, -1, -1}, {17894, -1, -1, -1}, {17895, -1, -1, -1}, {17896, -1, -1, -1}, {17897, -1, -1, -1}, {17898, -1, -1, -1}, {17899, -1, -1, -1}, {17900, -1, -1, -1}, {17901, -1, -1, -1}, {17902, -1, -1, -1}, {17903, -1, -1, -1}, {17904, -1, -1, -1}, {17905, -1, -1, -1}, {17906, -1, -1, -1}, {17907, -1, -1, -1}, {17908, -1, -1, -1}, {17909, -1, -1, -1}, {17910, -1, -1, -1}, {17911, -1, -1, -1}, {17912, -1, -1, -1}, {17913, -1, -1, -1}, {17914, -1, -1, -1}, {17915, -1, -1, -1}, {17916, -1, -1, -1}, {17917, -1, -1, -1}, {17918, -1, -1, -1}, {17919, -1, -1, -1}, {17920, -1, -1, -1}, {17921, -1, -1, -1}, {17922, -1, -1, -1}, {17923, -1, -1, -1}, {17924, -1, -1, -1}, {17925, -1, -1, -1}, {17926, -1, -1, -1}, {17927, -1, -1, -1}, {17928, -1, -1, -1}, {17929, -1, -1, -1}, {17930, -1, -1, -1}, {17931, -1, -1, -1}, {17932, -1, -1, -1}, {17933, -1, -1, -1}, {17934, -1, -1, -1}, {17935, -1, -1, -1}, {17936, -1, -1, -1}, {17937, -1, -1, -1}, {17938, -1, -1, -1}, {17939, -1, -1, -1} },
    {{17940, -1, -1, -1}, {17941, -1, -1, -1}, {17942, -1, -1, -1}, {17943, -1, -1, -1}, {17944, -1, -1, -1}, {17945, -1, -1, -1}, {17946, -1, -1, -1}, {17947, -1, -1, -1}, {17948, -1, -1, -1}, {17949, -1, -1, -1}, {17950, -1, -1, -1}, {17951, -1, -1, -1}, {17952, -1, -1, -1}, {17953, -1, -1, -1}, {17954, -1, -1, -1}, {17955, -1, -1, -1}, {17956, -1, -1, -1}, {17957, -1, -1, -1}, {17958, -1, -1, -1}, {17959, -1, -1, -1}, {17960, -1, -1, -1}, {17961, -1, -1, -1}, {17962, -1, -1, -1}, {17963, -1, -1, -1}, {17964, -1, -1, -1}, {17965, -1, -1, -1}, {17966, -1, -1, -1}, {17967, -1, -1, -1}, {17968, -1, -1, -1}, {17969, -1, -1, -1}, {17970, -1, -1, -1}, {17971, -1, -1, -1}, {17972, -1, -1, -1}, {17973, -1, -1, -1}, {17974, -1, -1, -1}, {17975, -1, -1, -1}, {17976, -1, -1, -1}, {17977, -1, -1, -1}, {17978, -1, -1, -1}, {17979, -1, -1, -1}, {17980, -1, -1, -1}, {17981, -1, -1, -1}, {17982, -1, -1, -1}, {17983, -1, -1, -1}, {17984, -1, -1, -1}, {17985, -1, -1, -1}, {17986, -1, -1, -1}, {17987, -1, -1, -1}, {17988, -1, -1, -1}, {17989, -1, -1, -1}, {17990, -1, -1, -1}, {17991, -1, -1, -1}, {17992, -1, -1, -1}, {17993, -1, -1, -1}, {17994, -1, -1, -1}, {17995, -1, -1, -1}, {17997, -1, -1, -1}, {17998, -1, -1, -1}, {17999, -1, -1, -1}, {18000, -1, -1, -1}, {18001, -1, -1, -1}, {18002, -1, -1, -1}, {18003, -1, -1, -1}, {18004, -1, -1, -1}, {18005, -1, -1, -1}, {18006, -1, -1, -1}, {18007, -1, -1, -1}, {18008, -1, -1, -1}, {18009, -1, -1, -1}, {18010, -1, -1, -1}, {18011, -1, -1, -1}, {18012, -1, -1, -1}, {18013, -1, -1, -1}, {18014, -1, -1, -1}, {18015, -1, -1, -1}, {18016, -1, -1, -1}, {18018, -1, -1, -1}, {18019, -1, -1, -1}, {18020, -1, -1, -1}, {18021, -1, -1, -1}, {18022, -1, -1, -1}, {18023, -1, -1, -1}, {18024, -1, -1, -1}, {18025, -1, -1, -1}, {18026, -1, -1, -1}, {18027, -1, -1, -1}, {18028, -1, -1, -1}, {18029, -1, -1, -1}, {18030, -1, -1, -1}, {18031, -1, -1, -1}, {18032, -1, -1, -1}, {18033, -1, -1, -1}, {18034, -1, -1, -1}, {18035, -1, -1, -1}, {18036, -1, -1, -1}, {18037, -1, -1, -1}, {18038, -1, -1, -1}, {18039, -1, -1, -1}, {18040, -1, -1, -1}, {18041, -1, -1, -1}, {18042, -1, -1, -1}, {18043, -1, -1, -1}, {18044, -1, -1, -1}, {18045, -1, -1, -1}, {18046, -1, -1, -1}, {18047, -1, -1, -1}, {18048, -1, -1, -1}, {18049, -1, -1, -1}, {18050, -1, -1, -1}, {18051, -1, -1, -1}, {18052, -1, -1, -1}, {18053, -1, -1, -1}, {18054, -1, -1, -1}, {18055, -1, -1, -1}, {18056, -1, -1, -1}, {18057, -1, -1, -1}, {18058, -1, -1, -1}, {18059, -1, -1, -1}, {18060, -1, -1, -1}, {18061, -1, -1, -1}, {18062, -1, -1, -1}, {18063, -1, -1, -1}, {18064, -1, -1, -1}, {18065, -1, -1, -1}, {18066, -1, -1, -1}, {18067, -1, -1, -1}, {18068, -1, -1, -1}, {18069, -1, -1, -1}, {18070, -1, -1, -1}, {18071, -1, -1, -1}, {18072, -1, -1, -1}, {18073, -1, -1, -1}, {18074, -1, -1, -1}, {18075, -1, -1, -1}, {18076, -1, -1, -1}, {18077, -1, -1, -1}, {18078, -1, -1, -1}, {18079, -1, -1, -1}, {18080, -1, -1, -1}, {18081, -1, -1, -1}, {18082, -1, -1, -1}, {18083, -1, -1, -1}, {18084, -1, -1, -1}, {18085, -1, -1, -1}, {18086, -1, -1, -1}, {18087, -1, -1, -1}, {18088, -1, -1, -1}, {18089, -1, -1, -1}, {18090, -1, -1, -1}, {18091, -1, -1, -1}, {18092, -1, -1, -1}, {18093, -1, -1, -1}, {18094, -1, -1, -1}, {18095, -1, -1, -1}, {18096, -1, -1, -1}, {18097, -1, -1, -1}, {18098, -1, -1, -1}, {18099, -1, -1, -1}, {18100, -1, -1, -1}, {18101, -1, -1, -1}, {18102, -1, -1, -1}, {18103, -1, -1, -1}, {18104, -1, -1, -1}, {18105, -1, -1, -1}, {18106, -1, -1, -1}, {18107, -1, -1, -1}, {18108, -1, -1, -1}, {18109, -1, -1, -1}, {18110, -1, -1, -1}, {18111, -1, -1, -1}, {18112, -1, -1, -1}, {18113, -1, -1, -1}, {18114, -1, -1, -1}, {18115, -1, -1, -1}, {18116, -1, -1, -1}, {18117, -1, -1, -1}, {18118, -1, -1, -1}, {18119, -1, -1, -1}, {18120, -1, -1, -1}, {18121, -1, -1, -1}, {18122, -1, -1, -1}, {18123, -1, -1, -1}, {18124, -1, -1, -1}, {18125, -1, -1, -1}, {18126, -1, -1, -1}, {18127, -1, -1, -1}, {18128, -1, -1, -1}, {18129, -1, -1, -1}, {18130, -1, -1, -1}, {18131, -1, -1, -1}, {18132, -1, -1, -1}, {18133, -1, -1, -1}, {18134, -1, -1, -1}, {18135, -1, -1, -1}, {18136, -1, -1, -1}, {18137, -1, -1, -1}, {18138, -1, -1, -1}, {18139, -1, -1, -1}, {18140, -1, -1, -1}, {18141, -1, -1, -1}, {18142, -1, -1, -1}, {18143, -1, -1, -1}, {18144, -1, -1, -1}, {18145, -1, -1, -1}, {18146, -1, -1, -1}, {18147, -1, -1, -1}, {18148, -1, -1, -1}, {18149, -1, -1, -1}, {18150, -1, -1, -1}, {18151, -1, -1, -1}, {18152, -1, -1, -1}, {18153, -1, -1, -1}, {18154, -1, -1, -1}, {18155, -1, -1, -1}, {18156, -1, -1, -1}, {18157, -1, -1, -1}, {18158, -1, -1, -1}, {18159, -1, -1, -1}, {18160, -1, -1, -1}, {18161, -1, -1, -1}, {18162, -1, -1, -1}, {18163, -1, -1, -1}, {18164, -1, -1, -1}, {18165, -1, -1, -1}, {18166, -1, -1, -1}, {18167, -1, -1, -1}, {18168, -1, -1, -1}, {18169, -1, -1, -1}, {18170, -1, -1, -1}, {18171, -1, -1, -1}, {18172, -1, -1, -1}, {18173, -1, -1, -1}, {18174, -1, -1, -1}, {18175, -1, -1, -1}, {18176, -1, -1, -1}, {18177, -1, -1, -1}, {18178, -1, -1, -1}, {18179, -1, -1, -1}, {18180, -1, -1, -1}, {18181, -1, -1, -1}, {18182, -1, -1, -1}, {18183, -1, -1, -1}, {18184, -1, -1, -1}, {18185, -1, -1, -1}, {18186, -1, -1, -1}, {18187, -1, -1, -1}, {18188, -1, -1, -1}, {18189, -1, -1, -1}, {18190, -1, -1, -1}, {18191, -1, -1, -1}, {18192, -1, -1, -1}, {18193, -1, -1, -1}, {18194, -1, -1, -1}, {18195, -1, -1, -1}, {18196, -1, -1, -1}, {18197, -1, -1, -1} },
    {{18198, -1, -1, -1}, {18199, -1, -1, -1}, {18200, -1, -1, -1}, {18201, -1, -1, -1}, {18202, -1, -1, -1}, {18203, -1, -1, -1}, {18204, -1, -1, -1}, {18205, -1, -1, -1}, {18206, -1, -1, -1}, {18207, -1, -1, -1}, {18208, -1, -1, -1}, {18209, -1, -1, -1}, {18210, -1, -1, -1}, {18212, -1, -1, -1}, {18213, -1, -1, -1}, {18214, -1, -1, -1}, {18215, -1, -1, -1}, {18216, -1, -1, -1}, {18218, -1, -1, -1}, {18219, -1, -1, -1}, {18220, -1, -1, -1}, {18221, -1, -1, -1}, {18222, -1, -1, -1}, {18223, -1, -1, -1}, {18224, -1, -1, -1}, {18225, -1, -1, -1}, {18226, -1, -1, -1}, {18227, -1, -1, -1}, {18228, -1, -1, -1}, {18229, -1, -1, -1}, {18230, -1, -1, -1}, {18231, -1, -1, -1}, {18232, -1, -1, -1}, {18233, -1, -1, -1}, {18234, -1, -1, -1}, {18235, -1, -1, -1}, {18236, -1, -1, -1}, {18237, -1, -1, -1}, {18238, -1, -1, -1}, {18239, -1, -1, -1}, {18240, -1, -1, -1}, {18241, -1, -1, -1}, {18242, -1, -1, -1}, {18243, -1, -1, -1}, {18244, -1, -1, -1}, {18245, -1, -1, -1}, {18246, -1, -1, -1}, {18247, -1, -1, -1}, {18248, -1, -1, -1}, {18249, -1, -1, -1}, {18250, -1, -1, -1}, {18251, -1, -1, -1}, {18252, -1, -1, -1}, {18253, -1, -1, -1}, {18254, -1, -1, -1}, {18255, -1, -1, -1}, {18256, -1, -1, -1}, {18257, -1, -1, -1}, {18258, -1, -1, -1}, {18259, -1, -1, -1}, {18260, -1, -1, -1}, {18261, -1, -1, -1}, {18262, -1, -1, -1}, {18263, -1, -1, -1}, {18264, -1, -1, -1}, {18265, -1, -1, -1}, {18266, -1, -1, -1}, {18267, -1, -1, -1}, {18268, -1, -1, -1}, {18269, -1, -1, -1}, {18270, -1, -1, -1}, {18271, -1, -1, -1}, {18272, -1, -1, -1}, {18273, -1, -1, -1}, {18274, -1, -1, -1}, {18275, -1, -1, -1}, {18276, -1, -1, -1}, {18277, -1, -1, -1}, {18278, -1, -1, -1}, {18279, -1, -1, -1}, {18280, -1, -1, -1}, {18281, -1, -1, -1}, {18282, -1, -1, -1}, {18283, -1, -1, -1}, {18284, -1, -1, -1}, {18285, -1, -1, -1}, {18286, -1, -1, -1}, {18287, -1, -1, -1}, {18288, -1, -1, -1}, {18289, -1, -1, -1}, {18290, -1, -1, -1}, {18291, -1, -1, -1}, {18292, -1, -1, -1}, {18293, -1, -1, -1}, {18294, -1, -1, -1}, {18295, -1, -1, -1}, {18296, -1, -1, -1}, {18297, -1, -1, -1}, {18298, -1, -1, -1}, {18299, -1, -1, -1}, {18301, -1, -1, -1}, {18302, -1, -1, -1}, {18303, -1, -1, -1}, {18304, -1, -1, -1}, {18305, -1, -1, -1}, {18306, -1, -1, -1}, {18307, -1, -1, -1}, {18308, -1, -1, -1}, {18309, -1, -1, -1}, {18310, -1, -1, -1}, {18311, -1, -1, -1}, {18312, -1, -1, -1}, {18313, -1, -1, -1}, {18314, -1, -1, -1}, {18315, -1, -1, -1}, {18316, -1, -1, -1}, {18318, -1, -1, -1}, {18319, -1, -1, -1}, {18320, -1, -1, -1}, {18321, -1, -1, -1}, {18322, -1, -1, -1}, {18323, -1, -1, -1}, {18324, -1, -1, -1}, {18325, -1, -1, -1}, {18326, -1, -1, -1}, {18327, -1, -1, -1}, {18328, -1, -1, -1}, {18329, -1, -1, -1}, {18330, -1, -1, -1}, {18331, -1, -1, -1}, {18332, -1, -1, -1}, {18333, -1, -1, -1}, {18334, -1, -1, -1}, {18335, -1, -1, -1}, {18336, -1, -1, -1}, {18337, -1, -1, -1}, {18338, -1, -1, -1}, {18339, -1, -1, -1}, {18340, -1, -1, -1}, {18341, -1, -1, -1}, {18342, -1, -1, -1}, {18343, -1, -1, -1}, {18344, -1, -1, -1}, {18345, -1, -1, -1}, {18346, -1, -1, -1}, {18347, -1, -1, -1}, {18348, -1, -1, -1}, {18349, -1, -1, -1}, {18350, -1, -1, -1}, {18351, -1, -1, -1}, {18352, -1, -1, -1}, {18353, -1, -1, -1}, {18354, -1, -1, -1}, {18355, -1, -1, -1}, {18356, -1, -1, -1}, {18357, -1, -1, -1}, {18358, -1, -1, -1}, {18359, -1, -1, -1}, {18360, -1, -1, -1}, {18361, -1, -1, -1}, {18362, -1, -1, -1}, {18363, -1, -1, -1}, {18364, -1, -1, -1}, {18365, -1, -1, -1}, {18366, -1, -1, -1}, {18367, -1, -1, -1}, {18368, -1, -1, -1}, {18369, -1, -1, -1}, {18370, -1, -1, -1}, {18371, -1, -1, -1}, {18372, -1, -1, -1}, {18373, -1, -1, -1}, {18374, -1, -1, -1}, {18375, -1, -1, -1}, {18376, -1, -1, -1}, {18377, -1, -1, -1}, {18378, -1, -1, -1}, {18379, -1, -1, -1}, {18380, -1, -1, -1}, {18381, -1, -1, -1}, {18382, -1, -1, -1}, {18383, -1, -1, -1}, {18384, -1, -1, -1}, {18385, -1, -1, -1}, {18386, -1, -1, -1}, {18387, -1, -1, -1}, {18388, -1, -1, -1}, {18389, -1, -1, -1}, {18390, -1, -1, -1}, {18391, -1, -1, -1}, {18392, -1, -1, -1}, {18393, -1, -1, -1}, {18394, -1, -1, -1}, {18395, -1, -1, -1}, {18396, -1, -1, -1}, {18397, -1, -1, -1}, {18398, -1, -1, -1}, {18399, -1, -1, -1}, {18400, -1, -1, -1}, {18401, -1, -1, -1}, {18402, -1, -1, -1}, {18403, -1, -1, -1}, {18404, -1, -1, -1}, {18405, -1, -1, -1}, {18406, -1, -1, -1}, {18407, -1, -1, -1}, {18408, -1, -1, -1}, {18409, -1, -1, -1}, {18410, -1, -1, -1}, {18411, -1, -1, -1}, {18412, -1, -1, -1}, {18413, -1, -1, -1}, {18414, -1, -1, -1}, {18415, -1, -1, -1}, {18416, -1, -1, -1}, {18417, -1, -1, -1}, {18418, -1, -1, -1}, {18419, -1, -1, -1}, {18420, -1, -1, -1}, {18421, -1, -1, -1}, {18422, -1, -1, -1}, {18423, -1, -1, -1}, {18424, -1, -1, -1}, {18425, -1, -1, -1}, {18426, -1, -1, -1}, {18427, -1, -1, -1}, {18428, -1, -1, -1}, {18429, -1, -1, -1}, {18430, -1, -1, -1}, {18431, -1, -1, -1}, {18432, -1, -1, -1}, {18433, -1, -1, -1}, {18434, -1, -1, -1}, {18435, -1, -1, -1}, {18436, -1, -1, -1}, {18437, -1, -1, -1}, {18438, -1, -1, -1}, {18439, -1, -1, -1}, {18440, -1, -1, -1}, {18441, -1, -1, -1}, {18442, -1, -1, -1}, {18443, -1, -1, -1}, {18444, -1, -1, -1}, {18445, -1, -1, -1}, {18446, -1, -1, -1}, {18447, -1, -1, -1}, {18448, -1, -1, -1}, {18449, -1, -1, -1}, {18450, -1, -1, -1}, {18451, -1, -1, -1}, {18452, -1, -1, -1}, {18453, -1, -1, -1}, {18454, -1, -1, -1}, {18455, -1, -1, -1}, {18456, -1, -1, -1}, {18457, -1, -1, -1} },
    {{18458, -1, -1, -1}, {18459, -1, -1, -1}, {18460, -1, -1, -1}, {18461, -1, -1, -1}, {18462, -1, -1, -1}, {18463, -1, -1, -1}, {18464, -1, -1, -1}, {18465, -1, -1, -1}, {18466, -1, -1, -1}, {18467, -1, -1, -1}, {18468, -1, -1, -1}, {18469, -1, -1, -1}, {18470, -1, -1, -1}, {18471, -1, -1, -1}, {18472, -1, -1, -1}, {18473, -1, -1, -1}, {18474, -1, -1, -1}, {18475, -1, -1, -1}, {18476, -1, -1, -1}, {18477, -1, -1, -1}, {18478, -1, -1, -1}, {18479, -1, -1, -1}, {18480, -1, -1, -1}, {18481, -1, -1, -1}, {18482, -1, -1, -1}, {18483, -1, -1, -1}, {18484, -1, -1, -1}, {18485, -1, -1, -1}, {18486, -1, -1, -1}, {18487, -1, -1, -1}, {18488, -1, -1, -1}, {18489, -1, -1, -1}, {18490, -1, -1, -1}, {18491, -1, -1, -1}, {18492, -1, -1, -1}, {18493, -1, -1, -1}, {18494, -1, -1, -1}, {18495, -1, -1, -1}, {18496, -1, -1, -1}, {18497, -1, -1, -1}, {18498, -1, -1, -1}, {18499, -1, -1, -1}, {18500, -1, -1, -1}, {18501, -1, -1, -1}, {18502, -1, -1, -1}, {18503, -1, -1, -1}, {18504, -1, -1, -1}, {18505, -1, -1, -1}, {18506, -1, -1, -1}, {18507, -1, -1, -1}, {18508, -1, -1, -1}, {18509, -1, -1, -1}, {18510, -1, -1, -1}, {18511, -1, -1, -1}, {18512, -1, -1, -1}, {18513, -1, -1, -1}, {18514, -1, -1, -1}, {18515, -1, -1, -1}, {18516, -1, -1, -1}, {18517, -1, -1, -1}, {18518, -1, -1, -1}, {18519, -1, -1, -1}, {18520, -1, -1, -1}, {18521, -1, -1, -1}, {18522, -1, -1, -1}, {18523, -1, -1, -1}, {18524, -1, -1, -1}, {18525, -1, -1, -1}, {18526, -1, -1, -1}, {18527, -1, -1, -1}, {18528, -1, -1, -1}, {18529, -1, -1, -1}, {18530, -1, -1, -1}, {18531, -1, -1, -1}, {18532, -1, -1, -1}, {18533, -1, -1, -1}, {18534, -1, -1, -1}, {18535, -1, -1, -1}, {18536, -1, -1, -1}, {18537, -1, -1, -1}, {18538, -1, -1, -1}, {18539, -1, -1, -1}, {18540, -1, -1, -1}, {18541, -1, -1, -1}, {18542, -1, -1, -1}, {18543, -1, -1, -1}, {18544, -1, -1, -1}, {18545, -1, -1, -1}, {18546, -1, -1, -1}, {18547, -1, -1, -1}, {18548, -1, -1, -1}, {18549, -1, -1, -1}, {18550, -1, -1, -1}, {18551, -1, -1, -1}, {18552, -1, -1, -1}, {18553, -1, -1, -1}, {18554, -1, -1, -1}, {18555, -1, -1, -1}, {18556, -1, -1, -1}, {18557, -1, -1, -1}, {18558, -1, -1, -1}, {18559, -1, -1, -1}, {18560, -1, -1, -1}, {18561, -1, -1, -1}, {18562, -1, -1, -1}, {18563, -1, -1, -1}, {18564, -1, -1, -1}, {18565, -1, -1, -1}, {18566, -1, -1, -1}, {18567, -1, -1, -1}, {18568, -1, -1, -1}, {18569, -1, -1, -1}, {18570, -1, -1, -1}, {18571, -1, -1, -1}, {18572, -1, -1, -1}, {18573, -1, -1, -1}, {18574, -1, -1, -1}, {18575, -1, -1, -1}, {18576, -1, -1, -1}, {18577, -1, -1, -1}, {18578, -1, -1, -1}, {18579, -1, -1, -1}, {18580, -1, -1, -1}, {18581, -1, -1, -1}, {18582, -1, -1, -1}, {18583, -1, -1, -1}, {18584, -1, -1, -1}, {18585, -1, -1, -1}, {18586, -1, -1, -1}, {18587, -1, -1, -1}, {18588, -1, -1, -1}, {18589, -1, -1, -1}, {18590, -1, -1, -1}, {18591, -1, -1, -1}, {18592, -1, -1, -1}, {18593, -1, -1, -1}, {18594, -1, -1, -1}, {18595, -1, -1, -1}, {18596, -1, -1, -1}, {18597, -1, -1, -1}, {18598, -1, -1, -1}, {18599, -1, -1, -1}, {18600, -1, -1, -1}, {18601, -1, -1, -1}, {18602, -1, -1, -1}, {18603, -1, -1, -1}, {18604, -1, -1, -1}, {18605, -1, -1, -1}, {18606, -1, -1, -1}, {18607, -1, -1, -1}, {18608, -1, -1, -1}, {18609, -1, -1, -1}, {18610, -1, -1, -1}, {18611, -1, -1, -1}, {18612, -1, -1, -1}, {18613, -1, -1, -1}, {18614, -1, -1, -1}, {18615, -1, -1, -1}, {18616, -1, -1, -1}, {18617, -1, -1, -1}, {18618, -1, -1, -1}, {18619, -1, -1, -1}, {18620, -1, -1, -1}, {18621, -1, -1, -1}, {18622, -1, -1, -1}, {18623, -1, -1, -1}, {18624, -1, -1, -1}, {18625, -1, -1, -1}, {18626, -1, -1, -1}, {18627, -1, -1, -1}, {18628, -1, -1, -1}, {18629, -1, -1, -1}, {18630, -1, -1, -1}, {18631, -1, -1, -1}, {18632, -1, -1, -1}, {18633, -1, -1, -1}, {18634, -1, -1, -1}, {18635, -1, -1, -1}, {18636, -1, -1, -1}, {18637, -1, -1, -1}, {18638, -1, -1, -1}, {18639, -1, -1, -1}, {18640, -1, -1, -1}, {18641, -1, -1, -1}, {18642, -1, -1, -1}, {18643, -1, -1, -1}, {18644, -1, -1, -1}, {18645, -1, -1, -1}, {18646, -1, -1, -1}, {18647, -1, -1, -1}, {18648, -1, -1, -1}, {18649, -1, -1, -1}, {18650, -1, -1, -1}, {18651, -1, -1, -1}, {18652, -1, -1, -1}, {18653, -1, -1, -1}, {18654, -1, -1, -1}, {18655, -1, -1, -1}, {18656, -1, -1, -1}, {18657, -1, -1, -1}, {18658, -1, -1, -1}, {18659, -1, -1, -1}, {18660, -1, -1, -1}, {18661, -1, -1, -1}, {18662, -1, -1, -1}, {18663, -1, -1, -1}, {18664, -1, -1, -1}, {18665, -1, -1, -1}, {18666, -1, -1, -1}, {18667, -1, -1, -1}, {18668, -1, -1, -1}, {18669, -1, -1, -1}, {18670, -1, -1, -1}, {18671, -1, -1, -1}, {18672, -1, -1, -1}, {18673, -1, -1, -1}, {18674, -1, -1, -1}, {18675, -1, -1, -1}, {18676, -1, -1, -1}, {18677, -1, -1, -1}, {18678, -1, -1, -1}, {18679, -1, -1, -1}, {18680, -1, -1, -1}, {18681, -1, -1, -1}, {18682, -1, -1, -1}, {18683, -1, -1, -1}, {18684, -1, -1, -1}, {18685, -1, -1, -1}, {18686, -1, -1, -1}, {18687, -1, -1, -1}, {18688, -1, -1, -1}, {18689, -1, -1, -1}, {18690, -1, -1, -1}, {18691, -1, -1, -1}, {18692, -1, -1, -1}, {18693, -1, -1, -1}, {18694, -1, -1, -1}, {18695, -1, -1, -1}, {18696, -1, -1, -1}, {18697, -1, -1, -1}, {18698, -1, -1, -1}, {18699, -1, -1, -1}, {18700, -1, -1, -1}, {18701, -1, -1, -1}, {18702, -1, -1, -1}, {18703, -1, -1, -1}, {18704, -1, -1, -1}, {18705, -1, -1, -1}, {18706, -1, -1, -1}, {18707, -1, -1, -1}, {18708, -1, -1, -1}, {18709, -1, -1, -1}, {18710, -1, -1, -1}, {18711, -1, -1, -1}, {18712, -1, -1, -1}, {18713, -1, -1, -1} },
    {{18714, -1, -1, -1}, {18715, -1, -1, -1}, {18716, -1, -1, -1}, {18717, -1, -1, -1}, {18718, -1, -1, -1}, {18719, -1, -1, -1}, {18720, -1, -1, -1}, {18721, -1, -1, -1}, {18722, -1, -1, -1}, {18723, -1, -1, -1}, {18724, -1, -1, -1}, {18725, -1, -1, -1}, {18726, -1, -1, -1}, {18727, -1, -1, -1}, {18728, -1, -1, -1}, {18729, -1, -1, -1}, {18730, -1, -1, -1}, {18731, -1, -1, -1}, {18732, -1, -1, -1}, {18733, -1, -1, -1}, {18734, -1, -1, -1}, {18735, -1, -1, -1}, {18736, -1, -1, -1}, {18737, -1, -1, -1}, {18738, -1, -1, -1}, {18739, -1, -1, -1}, {18740, -1, -1, -1}, {18741, -1, -1, -1}, {18742, -1, -1, -1}, {18743, -1, -1, -1}, {18744, -1, -1, -1}, {18745, -1, -1, -1}, {18746, -1, -1, -1}, {18747, -1, -1, -1}, {18748, -1, -1, -1}, {18749, -1, -1, -1}, {18750, -1, -1, -1}, {18751, -1, -1, -1}, {18752, -1, -1, -1}, {18753, -1, -1, -1}, {18754, -1, -1, -1}, {18755, -1, -1, -1}, {18756, -1, -1, -1}, {18757, -1, -1, -1}, {18758, -1, -1, -1}, {18760, -1, -1, -1}, {18761, -1, -1, -1}, {18762, -1, -1, -1}, {18763, -1, -1, -1}, {18764, -1, -1, -1}, {18765, -1, -1, -1}, {18766, -1, -1, -1}, {18767, -1, -1, -1}, {18768, -1, -1, -1}, {18769, -1, -1, -1}, {18770, -1, -1, -1}, {18771, -1, -1, -1}, {18772, -1, -1, -1}, {18773, -1, -1, -1}, {18774, -1, -1, -1}, {18775, -1, -1, -1}, {18776, -1, -1, -1}, {18777, -1, -1, -1}, {18778, -1, -1, -1}, {18779, -1, -1, -1}, {18780, -1, -1, -1}, {18781, -1, -1, -1}, {18782, -1, -1, -1}, {18783, -1, -1, -1}, {18784, -1, -1, -1}, {18785, -1, -1, -1}, {18786, -1, -1, -1}, {18787, -1, -1, -1}, {18788, -1, -1, -1}, {18789, -1, -1, -1}, {18790, -1, -1, -1}, {18791, -1, -1, -1}, {18792, -1, -1, -1}, {18793, -1, -1, -1}, {18794, -1, -1, -1}, {18795, -1, -1, -1}, {18796, -1, -1, -1}, {18797, -1, -1, -1}, {18798, -1, -1, -1}, {18799, -1, -1, -1}, {18800, -1, -1, -1}, {18801, -1, -1, -1}, {18802, -1, -1, -1}, {18803, -1, -1, -1}, {18804, -1, -1, -1}, {18805, -1, -1, -1}, {18806, -1, -1, -1}, {18807, -1, -1, -1}, {18808, -1, -1, -1}, {18809, -1, -1, -1}, {18811, -1, -1, -1}, {18812, -1, -1, -1}, {18814, -1, -1, -1}, {18815, -1, -1, -1}, {18816, -1, -1, -1}, {18817, -1, -1, -1}, {18820, -1, -1, -1}, {18823, -1, -1, -1}, {18824, -1, -1, -1}, {18825, -1, -1, -1}, {18826, -1, -1, -1}, {18827, -1, -1, -1}, {18828, -1, -1, -1}, {18829, -1, -1, -1}, {18830, -1, -1, -1}, {18831, -1, -1, -1}, {18832, -1, -1, -1}, {18833, -1, -1, -1}, {18834, -1, -1, -1}, {18835, -1, -1, -1}, {18836, -1, -1, -1}, {18837, -1, -1, -1}, {18838, -1, -1, -1}, {18839, -1, -1, -1}, {18840, -1, -1, -1}, {18841, -1, -1, -1}, {18842, -1, -1, -1}, {18844, -1, -1, -1}, {18845, -1, -1, -1}, {18846, -1, -1, -1}, {18848, -1, -1, -1}, {18849, -1, -1, -1}, {18850, -1, -1, -1}, {18851, -1, -1, -1}, {18852, -1, -1, -1}, {18853, -1, -1, -1}, {18854, -1, -1, -1}, {18855, -1, -1, -1}, {18856, -1, -1, -1}, {18857, -1, -1, -1}, {18858, -1, -1, -1}, {18859, -1, -1, -1}, {18860, -1, -1, -1}, {18861, -1, -1, -1}, {18862, -1, -1, -1}, {18863, -1, -1, -1}, {18864, -1, -1, -1}, {18865, -1, -1, -1}, {18866, -1, -1, -1}, {18867, -1, -1, -1}, {18868, -1, -1, -1}, {18869, -1, -1, -1}, {18872, -1, -1, -1}, {18873, -1, -1, -1}, {18874, -1, -1, -1}, {18875, -1, -1, -1}, {18876, -1, -1, -1}, {18877, -1, -1, -1}, {18878, -1, -1, -1}, {18879, -1, -1, -1}, {18880, -1, -1, -1}, {18881, -1, -1, -1}, {18882, -1, -1, -1}, {18883, -1, -1, -1}, {18884, -1, -1, -1}, {18885, -1, -1, -1}, {18886, -1, -1, -1}, {18887, -1, -1, -1}, {18888, -1, -1, -1}, {18889, -1, -1, -1}, {18890, -1, -1, -1}, {18891, -1, -1, -1}, {18892, -1, -1, -1}, {18893, -1, -1, -1}, {18894, -1, -1, -1}, {18895, -1, -1, -1}, {18896, -1, -1, -1}, {18897, -1, -1, -1}, {18898, -1, -1, -1}, {18899, -1, -1, -1}, {18900, -1, -1, -1}, {18901, -1, -1, -1}, {18902, -1, -1, -1}, {18903, -1, -1, -1}, {18904, -1, -1, -1}, {18905, -1, -1, -1}, {18906, -1, -1, -1}, {18907, -1, -1, -1}, {18908, -1, -1, -1}, {18909, -1, -1, -1}, {18910, -1, -1, -1}, {18911, -1, -1, -1}, {18912, -1, -1, -1}, {18913, -1, -1, -1}, {18914, -1, -1, -1}, {18915, -1, -1, -1}, {18916, -1, -1, -1}, {18917, -1, -1, -1}, {18918, -1, -1, -1}, {18919, -1, -1, -1}, {18920, -1, -1, -1}, {18921, -1, -1, -1}, {18922, -1, -1, -1}, {18923, -1, -1, -1}, {18924, -1, -1, -1}, {18925, -1, -1, -1}, {18926, -1, -1, -1}, {18927, -1, -1, -1}, {18928, -1, -1, -1}, {18929, -1, -1, -1}, {18930, -1, -1, -1}, {18931, -1, -1, -1}, {18932, -1, -1, -1}, {18933, -1, -1, -1}, {18934, -1, -1, -1}, {18935, -1, -1, -1}, {18936, -1, -1, -1}, {18937, -1, -1, -1}, {18938, -1, -1, -1}, {18939, -1, -1, -1}, {18940, -1, -1, -1}, {18941, -1, -1, -1}, {18942, -1, -1, -1}, {18943, -1, -1, -1}, {18944, -1, -1, -1}, {18945, -1, -1, -1}, {18946, -1, -1, -1}, {18947, -1, -1, -1}, {18948, -1, -1, -1}, {18949, -1, -1, -1}, {18950, -1, -1, -1}, {18951, -1, -1, -1}, {18952, -1, -1, -1}, {18953, -1, -1, -1}, {18954, -1, -1, -1}, {18955, -1, -1, -1}, {18956, -1, -1, -1}, {18957, -1, -1, -1}, {18958, -1, -1, -1}, {18959, -1, -1, -1}, {18960, -1, -1, -1}, {18961, -1, -1, -1}, {18962, -1, -1, -1}, {18963, -1, -1, -1}, {18964, -1, -1, -1}, {18965, -1, -1, -1}, {18966, -1, -1, -1}, {18967, -1, -1, -1}, {18968, -1, -1, -1}, {18969, -1, -1, -1}, {18970, -1, -1, -1}, {18971, -1, -1, -1}, {18972, -1, -1, -1}, {18973, -1, -1, -1}, {18974, -1, -1, -1}, {18975, -1, -1, -1}, {18976, -1, -1, -1}, {18977, -1, -1, -1}, {18978, -1, -1, -1}, {18979, -1, -1, -1}, {18980, -1, -1, -1} },
    {{18981, -1, -1, -1}, {18982, -1, -1, -1}, {18983, -1, -1, -1}, {18984, -1, -1, -1}, {18985, -1, -1, -1}, {18986, -1, -1, -1}, {18987, -1, -1, -1}, {18988, -1, -1, -1}, {18989, -1, -1, -1}, {18990, -1, -1, -1}, {18991, -1, -1, -1}, {18992, -1, -1, -1}, {18993, -1, -1, -1}, {18994, -1, -1, -1}, {18995, -1, -1, -1}, {18996, -1, -1, -1}, {18997, -1, -1, -1}, {18998, -1, -1, -1}, {18999, -1, -1, -1}, {19000, -1, -1, -1}, {19001, -1, -1, -1}, {19002, -1, -1, -1}, {19003, -1, -1, -1}, {19004, -1, -1, -1}, {19005, -1, -1, -1}, {19006, -1, -1, -1}, {19007, -1, -1, -1}, {19008, -1, -1, -1}, {19009, -1, -1, -1}, {19010, -1, -1, -1}, {19011, -1, -1, -1}, {19012, -1, -1, -1}, {19013, -1, -1, -1}, {19014, -1, -1, -1}, {19015, -1, -1, -1}, {19016, -1, -1, -1}, {19017, -1, -1, -1}, {19018, -1, -1, -1}, {19019, -1, -1, -1}, {19020, -1, -1, -1}, {19021, -1, -1, -1}, {19022, -1, -1, -1}, {19023, -1, -1, -1}, {19024, -1, -1, -1}, {19025, -1, -1, -1}, {19026, -1, -1, -1}, {19027, -1, -1, -1}, {19028, -1, -1, -1}, {19029, -1, -1, -1}, {19030, -1, -1, -1}, {19031, -1, -1, -1}, {19032, -1, -1, -1}, {19033, -1, -1, -1}, {19034, -1, -1, -1}, {19035, -1, -1, -1}, {19036, -1, -1, -1}, {19037, -1, -1, -1}, {19038, -1, -1, -1}, {19039, -1, -1, -1}, {19040, -1, -1, -1}, {19041, -1, -1, -1}, {19042, -1, -1, -1}, {19043, -1, -1, -1}, {19044, -1, -1, -1}, {19045, -1, -1, -1}, {19046, -1, -1, -1}, {19047, -1, -1, -1}, {19048, -1, -1, -1}, {19049, -1, -1, -1}, {19050, -1, -1, -1}, {19051, -1, -1, -1}, {19052, -1, -1, -1}, {19053, -1, -1, -1}, {19054, -1, -1, -1}, {19055, -1, -1, -1}, {19056, -1, -1, -1}, {19057, -1, -1, -1}, {19058, -1, -1, -1}, {19059, -1, -1, -1}, {19060, -1, -1, -1}, {19061, -1, -1, -1}, {19062, -1, -1, -1}, {19063, -1, -1, -1}, {19064, -1, -1, -1}, {19065, -1, -1, -1}, {19066, -1, -1, -1}, {19067, -1, -1, -1}, {19068, -1, -1, -1}, {19069, -1, -1, -1}, {19070, -1, -1, -1}, {19071, -1, -1, -1}, {19072, -1, -1, -1}, {19073, -1, -1, -1}, {19074, -1, -1, -1}, {19075, -1, -1, -1}, {19076, -1, -1, -1}, {19077, -1, -1, -1}, {19078, -1, -1, -1}, {19079, -1, -1, -1}, {19080, -1, -1, -1}, {19081, -1, -1, -1}, {19082, -1, -1, -1}, {19083, -1, -1, -1}, {19084, -1, -1, -1}, {19085, -1, -1, -1}, {19086, -1, -1, -1}, {19087, -1, -1, -1}, {19088, -1, -1, -1}, {19089, -1, -1, -1}, {19090, -1, -1, -1}, {19091, -1, -1, -1}, {19092, -1, -1, -1}, {19093, -1, -1, -1}, {19094, -1, -1, -1}, {19095, -1, -1, -1}, {19096, -1, -1, -1}, {19097, -1, -1, -1}, {19098, -1, -1, -1}, {19099, -1, -1, -1}, {19100, -1, -1, -1}, {19101, -1, -1, -1}, {19102, -1, -1, -1}, {19103, -1, -1, -1}, {19104, -1, -1, -1}, {19105, -1, -1, -1}, {19106, -1, -1, -1}, {19107, -1, -1, -1}, {19108, -1, -1, -1}, {19109, -1, -1, -1}, {19110, -1, -1, -1}, {19111, -1, -1, -1}, {19112, -1, -1, -1}, {19113, -1, -1, -1}, {19114, -1, -1, -1}, {19115, -1, -1, -1}, {19116, -1, -1, -1}, {19117, -1, -1, -1}, {19118, -1, -1, -1}, {19119, -1, -1, -1}, {19120, -1, -1, -1}, {19121, -1, -1, -1}, {19122, -1, -1, -1}, {19123, -1, -1, -1}, {19124, -1, -1, -1}, {19125, -1, -1, -1}, {19126, -1, -1, -1}, {19127, -1, -1, -1}, {19128, -1, -1, -1}, {19129, -1, -1, -1}, {19130, -1, -1, -1}, {19131, -1, -1, -1}, {19132, -1, -1, -1}, {19133, -1, -1, -1}, {19134, -1, -1, -1}, {19135, -1, -1, -1}, {19136, -1, -1, -1}, {19137, -1, -1, -1}, {19138, -1, -1, -1}, {19139, -1, -1, -1}, {19140, -1, -1, -1}, {19141, -1, -1, -1}, {19142, -1, -1, -1}, {19143, -1, -1, -1}, {19144, -1, -1, -1}, {19145, -1, -1, -1}, {19146, -1, -1, -1}, {19147, -1, -1, -1}, {19148, -1, -1, -1}, {19149, -1, -1, -1}, {19150, -1, -1, -1}, {19151, -1, -1, -1}, {19152, -1, -1, -1}, {19153, -1, -1, -1}, {19154, -1, -1, -1}, {19155, -1, -1, -1}, {19156, -1, -1, -1}, {19157, -1, -1, -1}, {19158, -1, -1, -1}, {19159, -1, -1, -1}, {19160, -1, -1, -1}, {19161, -1, -1, -1}, {19162, -1, -1, -1}, {19163, -1, -1, -1}, {19164, -1, -1, -1}, {19165, -1, -1, -1}, {19166, -1, -1, -1}, {19167, -1, -1, -1}, {19168, -1, -1, -1}, {19169, -1, -1, -1}, {19170, -1, -1, -1}, {19171, -1, -1, -1}, {19172, -1, -1, -1}, {19173, -1, -1, -1}, {19174, -1, -1, -1}, {19175, -1, -1, -1}, {19176, -1, -1, -1}, {19177, -1, -1, -1}, {19178, -1, -1, -1}, {19179, -1, -1, -1}, {19180, -1, -1, -1}, {19181, -1, -1, -1}, {19182, -1, -1, -1}, {19183, -1, -1, -1}, {19184, -1, -1, -1}, {19185, -1, -1, -1}, {19186, -1, -1, -1}, {19187, -1, -1, -1}, {19188, -1, -1, -1}, {19189, -1, -1, -1}, {19190, -1, -1, -1}, {19191, -1, -1, -1}, {19192, -1, -1, -1}, {19193, -1, -1, -1}, {19194, -1, -1, -1}, {19195, -1, -1, -1}, {19196, -1, -1, -1}, {19197, -1, -1, -1}, {19198, -1, -1, -1}, {19199, -1, -1, -1}, {19200, -1, -1, -1}, {19201, -1, -1, -1}, {19202, -1, -1, -1}, {19203, -1, -1, -1}, {19204, -1, -1, -1}, {19205, -1, -1, -1}, {19206, -1, -1, -1}, {19207, -1, -1, -1}, {19208, -1, -1, -1}, {19209, -1, -1, -1}, {19210, -1, -1, -1}, {19211, -1, -1, -1}, {19212, -1, -1, -1}, {19213, -1, -1, -1}, {19214, -1, -1, -1}, {19215, -1, -1, -1}, {19216, -1, -1, -1}, {19217, -1, -1, -1}, {19218, -1, -1, -1}, {19219, -1, -1, -1}, {19220, -1, -1, -1}, {19221, -1, -1, -1}, {19222, -1, -1, -1}, {19223, -1, -1, -1}, {19224, -1, -1, -1}, {19225, -1, -1, -1}, {19226, -1, -1, -1}, {19227, -1, -1, -1}, {19228, -1, -1, -1}, {19229, -1, -1, -1}, {19230, -1, -1, -1}, {19231, -1, -1, -1}, {19232, -1, -1, -1}, {19233, -1, -1, -1}, {19234, -1, -1, -1}, {19235, -1, -1, -1}, {19236, -1, -1, -1} },
    {{19237, -1, -1, -1}, {19238, -1, -1, -1}, {19239, -1, -1, -1}, {19240, -1, -1, -1}, {19241, -1, -1, -1}, {19242, -1, -1, -1}, {19243, -1, -1, -1}, {19244, -1, -1, -1}, {19245, -1, -1, -1}, {19246, -1, -1, -1}, {19247, -1, -1, -1}, {19248, -1, -1, -1}, {19249, -1, -1, -1}, {19250, -1, -1, -1}, {19251, -1, -1, -1}, {19252, -1, -1, -1}, {19253, -1, -1, -1}, {19254, -1, -1, -1}, {19255, -1, -1, -1}, {19256, -1, -1, -1}, {19257, -1, -1, -1}, {19258, -1, -1, -1}, {19259, -1, -1, -1}, {19260, -1, -1, -1}, {19261, -1, -1, -1}, {19262, -1, -1, -1}, {19263, -1, -1, -1}, {19264, -1, -1, -1}, {19265, -1, -1, -1}, {19266, -1, -1, -1}, {19267, -1, -1, -1}, {19268, -1, -1, -1}, {19269, -1, -1, -1}, {19270, -1, -1, -1}, {19271, -1, -1, -1}, {19272, -1, -1, -1}, {19273, -1, -1, -1}, {19274, -1, -1, -1}, {19275, -1, -1, -1}, {19276, -1, -1, -1}, {19277, -1, -1, -1}, {19278, -1, -1, -1}, {19279, -1, -1, -1}, {19280, -1, -1, -1}, {19281, -1, -1, -1}, {19282, -1, -1, -1}, {19283, -1, -1, -1}, {19284, -1, -1, -1}, {19285, -1, -1, -1}, {19286, -1, -1, -1}, {19287, -1, -1, -1}, {19288, -1, -1, -1}, {19289, -1, -1, -1}, {19290, -1, -1, -1}, {19291, -1, -1, -1}, {19292, -1, -1, -1}, {19293, -1, -1, -1}, {19294, -1, -1, -1}, {19295, -1, -1, -1}, {19296, -1, -1, -1}, {19297, -1, -1, -1}, {19298, -1, -1, -1}, {19299, -1, -1, -1}, {19300, -1, -1, -1}, {19301, -1, -1, -1}, {19302, -1, -1, -1}, {19303, -1, -1, -1}, {19304, -1, -1, -1}, {19305, -1, -1, -1}, {19306, -1, -1, -1}, {19307, -1, -1, -1}, {19308, -1, -1, -1}, {19309, -1, -1, -1}, {19310, -1, -1, -1}, {19311, -1, -1, -1}, {19312, -1, -1, -1}, {19313, -1, -1, -1}, {19314, -1, -1, -1}, {19315, -1, -1, -1}, {19316, -1, -1, -1}, {19317, -1, -1, -1}, {19318, -1, -1, -1}, {19319, -1, -1, -1}, {19320, -1, -1, -1}, {19321, -1, -1, -1}, {19322, -1, -1, -1}, {19323, -1, -1, -1}, {19324, -1, -1, -1}, {19325, -1, -1, -1}, {19326, -1, -1, -1}, {19327, -1, -1, -1}, {19328, -1, -1, -1}, {19329, -1, -1, -1}, {19330, -1, -1, -1}, {19331, -1, -1, -1}, {19332, -1, -1, -1}, {19333, -1, -1, -1}, {19334, -1, -1, -1}, {19335, -1, -1, -1}, {19336, -1, -1, -1}, {19337, -1, -1, -1}, {19338, -1, -1, -1}, {19339, -1, -1, -1}, {19340, -1, -1, -1}, {19341, -1, -1, -1}, {19342, -1, -1, -1}, {19343, -1, -1, -1}, {19344, -1, -1, -1}, {19345, -1, -1, -1}, {19346, -1, -1, -1}, {19347, -1, -1, -1}, {19348, -1, -1, -1}, {19349, -1, -1, -1}, {19350, -1, -1, -1}, {19351, -1, -1, -1}, {19352, -1, -1, -1}, {19353, -1, -1, -1}, {19354, -1, -1, -1}, {19355, -1, -1, -1}, {19356, -1, -1, -1}, {19357, -1, -1, -1}, {19358, -1, -1, -1}, {19359, -1, -1, -1}, {19360, -1, -1, -1}, {19361, -1, -1, -1}, {19362, -1, -1, -1}, {19363, -1, -1, -1}, {19364, -1, -1, -1}, {19365, -1, -1, -1}, {19366, -1, -1, -1}, {19367, -1, -1, -1}, {19368, -1, -1, -1}, {19369, -1, -1, -1}, {19370, -1, -1, -1}, {19371, -1, -1, -1}, {19372, -1, -1, -1}, {19373, -1, -1, -1}, {19374, -1, -1, -1}, {19375, -1, -1, -1}, {19376, -1, -1, -1}, {19377, -1, -1, -1}, {19378, -1, -1, -1}, {19379, -1, -1, -1}, {19380, -1, -1, -1}, {19381, -1, -1, -1}, {19382, -1, -1, -1}, {19383, -1, -1, -1}, {19384, -1, -1, -1}, {19385, -1, -1, -1}, {19386, -1, -1, -1}, {19387, -1, -1, -1}, {19388, -1, -1, -1}, {19389, -1, -1, -1}, {19390, -1, -1, -1}, {19391, -1, -1, -1}, {19392, -1, -1, -1}, {19393, -1, -1, -1}, {19394, -1, -1, -1}, {19395, -1, -1, -1}, {19396, -1, -1, -1}, {19397, -1, -1, -1}, {19398, -1, -1, -1}, {19399, -1, -1, -1}, {19400, -1, -1, -1}, {19401, -1, -1, -1}, {19402, -1, -1, -1}, {19403, -1, -1, -1}, {19404, -1, -1, -1}, {19405, -1, -1, -1}, {19406, -1, -1, -1}, {19407, -1, -1, -1}, {19408, -1, -1, -1}, {19409, -1, -1, -1}, {19410, -1, -1, -1}, {19411, -1, -1, -1}, {19412, -1, -1, -1}, {19413, -1, -1, -1}, {19414, -1, -1, -1}, {19415, -1, -1, -1}, {19416, -1, -1, -1}, {19417, -1, -1, -1}, {19418, -1, -1, -1}, {19419, -1, -1, -1}, {19420, -1, -1, -1}, {19421, -1, -1, -1}, {19422, -1, -1, -1}, {19423, -1, -1, -1}, {19424, -1, -1, -1}, {19425, -1, -1, -1}, {19426, -1, -1, -1}, {19427, -1, -1, -1}, {19428, -1, -1, -1}, {19429, -1, -1, -1}, {19430, -1, -1, -1}, {19431, -1, -1, -1}, {19432, -1, -1, -1}, {19433, -1, -1, -1}, {19434, -1, -1, -1}, {19435, -1, -1, -1}, {19436, -1, -1, -1}, {19437, -1, -1, -1}, {19438, -1, -1, -1}, {19439, -1, -1, -1}, {19440, -1, -1, -1}, {19441, -1, -1, -1}, {19442, -1, -1, -1}, {19443, -1, -1, -1}, {19444, -1, -1, -1}, {19445, -1, -1, -1}, {19446, -1, -1, -1}, {19447, -1, -1, -1}, {19448, -1, -1, -1}, {19449, -1, -1, -1}, {19450, -1, -1, -1}, {19451, -1, -1, -1}, {19452, -1, -1, -1}, {19453, -1, -1, -1}, {19454, -1, -1, -1}, {19455, -1, -1, -1}, {19456, -1, -1, -1}, {19457, -1, -1, -1}, {19458, -1, -1, -1}, {19459, -1, -1, -1}, {19460, -1, -1, -1}, {19461, -1, -1, -1}, {19462, -1, -1, -1}, {19463, -1, -1, -1}, {19464, -1, -1, -1}, {19465, -1, -1, -1}, {19466, -1, -1, -1}, {19467, -1, -1, -1}, {19468, -1, -1, -1}, {19469, -1, -1, -1}, {19470, -1, -1, -1}, {19471, -1, -1, -1}, {19472, -1, -1, -1}, {19473, -1, -1, -1}, {19474, -1, -1, -1}, {19475, -1, -1, -1}, {19476, -1, -1, -1}, {19477, -1, -1, -1}, {19478, -1, -1, -1}, {19479, -1, -1, -1}, {19480, -1, -1, -1}, {19481, -1, -1, -1}, {19482, -1, -1, -1}, {19483, -1, -1, -1}, {19484, -1, -1, -1}, {19485, -1, -1, -1}, {19486, -1, -1, -1}, {19487, -1, -1, -1}, {19488, -1, -1, -1}, {19489, -1, -1, -1}, {19490, -1, -1, -1}, {19491, -1, -1, -1}, {19492, -1, -1, -1} },
    {{19493, -1, -1, -1}, {19494, -1, -1, -1}, {19495, -1, -1, -1}, {19496, -1, -1, -1}, {19497, -1, -1, -1}, {19498, -1, -1, -1}, {19499, -1, -1, -1}, {19500, -1, -1, -1}, {19501, -1, -1, -1}, {19502, -1, -1, -1}, {19503, -1, -1, -1}, {19504, -1, -1, -1}, {19505, -1, -1, -1}, {19506, -1, -1, -1}, {19507, -1, -1, -1}, {19508, -1, -1, -1}, {19509, -1, -1, -1}, {19510, -1, -1, -1}, {19511, -1, -1, -1}, {19512, -1, -1, -1}, {19513, -1, -1, -1}, {19514, -1, -1, -1}, {19515, -1, -1, -1}, {19516, -1, -1, -1}, {19517, -1, -1, -1}, {19518, -1, -1, -1}, {19519, -1, -1, -1}, {19520, -1, -1, -1}, {19521, -1, -1, -1}, {19522, -1, -1, -1}, {19523, -1, -1, -1}, {19524, -1, -1, -1}, {19525, -1, -1, -1}, {19526, -1, -1, -1}, {19527, -1, -1, -1}, {19528, -1, -1, -1}, {19529, -1, -1, -1}, {19530, -1, -1, -1}, {19531, -1, -1, -1}, {19532, -1, -1, -1}, {19533, -1, -1, -1}, {19534, -1, -1, -1}, {19535, -1, -1, -1}, {19536, -1, -1, -1}, {19537, -1, -1, -1}, {19538, -1, -1, -1}, {19539, -1, -1, -1}, {19540, -1, -1, -1}, {19541, -1, -1, -1}, {19542, -1, -1, -1}, {19543, -1, -1, -1}, {19544, -1, -1, -1}, {19545, -1, -1, -1}, {19546, -1, -1, -1}, {19547, -1, -1, -1}, {19548, -1, -1, -1}, {19549, -1, -1, -1}, {19550, -1, -1, -1}, {19551, -1, -1, -1}, {19552, -1, -1, -1}, {19553, -1, -1, -1}, {19554, -1, -1, -1}, {19555, -1, -1, -1}, {19556, -1, -1, -1}, {19557, -1, -1, -1}, {19558, -1, -1, -1}, {19559, -1, -1, -1}, {19560, -1, -1, -1}, {19561, -1, -1, -1}, {19562, -1, -1, -1}, {19563, -1, -1, -1}, {19564, -1, -1, -1}, {19565, -1, -1, -1}, {19566, -1, -1, -1}, {19567, -1, -1, -1}, {19568, -1, -1, -1}, {19569, -1, -1, -1},