/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.PaintContext;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

class ColorPaintContext
implements PaintContext {
    final int color;
    final ColorModel colorModel;
    private ColorRaster cachedRaster;

    ColorPaintContext(int colorRGB) {
        this(ColorModel.getRGBdefault(), colorRGB);
    }

    ColorPaintContext(ColorModel cm, int colorRGB) {
        this.color = colorRGB;
        this.colorModel = cm;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Raster getRaster(int x, int y, int width, int height) {
        if (this.cachedRaster == null || this.cachedRaster.getWidth() < width || this.cachedRaster.getHeight() < height) {
            this.cachedRaster = new ColorRaster(this.colorModel, 0, 0, width, height, this.color);
        }
        return this.cachedRaster.createChild(0, 0, width, height, 0, 0, null);
    }

    private class ColorRaster
    extends Raster {
        ColorRaster(ColorModel cm, int x, int y, int width, int height, int rgbPixel) {
            super(cm.createCompatibleSampleModel(width, height), new Point(x, y));
            Object pixel = cm.getDataElements(rgbPixel, null);
            int[] pixelComps = cm.getComponents(pixel, null, 0);
            int[] d = (int[])this.multiplyData(pixelComps, null, width * height);
            this.getSampleModel().setPixels(0, 0, width, height, d, this.dataBuffer);
        }

        private Object multiplyData(Object src, Object dest, int factor) {
            int srcLength = 0;
            if (src instanceof byte[]) {
                srcLength = ((byte[])src).length;
                if (dest == null) {
                    dest = new byte[factor * srcLength];
                }
            } else if (src instanceof short[]) {
                srcLength = ((short[])src).length;
                if (dest == null) {
                    dest = new short[factor * srcLength];
                }
            } else if (src instanceof int[]) {
                srcLength = ((int[])src).length;
                if (dest == null) {
                    dest = new int[factor * srcLength];
                }
            } else {
                throw new ClassCastException("Unknown data buffer type");
            }
            System.arraycopy(src, 0, dest, 0, srcLength);
            int count = 1;
            while (count * 2 < factor) {
                System.arraycopy(dest, 0, dest, count * srcLength, count * srcLength);
                count *= 2;
            }
            if (factor > count) {
                System.arraycopy(dest, 0, dest, count * srcLength, (factor - count) * srcLength);
            }
            return dest;
        }
    }
}

