/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.x509.X500DistinguishedName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;

class SelfCertCmd
extends Command {
    private static final Logger log = Logger.getLogger(SelfCertCmd.class.getName());
    protected String _alias;
    protected String _sigAlgorithm;
    protected String _dName;
    protected String _password;
    protected String _validityStr;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private X500DistinguishedName distinguishedName;
    private int validityInDays;

    SelfCertCmd() {
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setSigalg(String algorithm) {
        this._sigAlgorithm = algorithm;
    }

    public void setDname(String name) {
        this._dName = name;
    }

    public void setValidity(String days) {
        this._validityStr = days;
    }

    public void setKeypass(String password) {
        this._password = password;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    void setup() throws Exception {
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordNoPrompt(this._password);
        this.setValidityParam(this._validityStr);
        if (Configuration.DEBUG) {
            log.fine("-selfcert handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -sigalg=" + this._sigAlgorithm);
            log.fine("  -dname=" + this._dName);
            log.fine("  -validity=" + this.validityInDays);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, UnsupportedCallbackException, InvalidKeyException, SignatureException, CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        Key privateKey = this.getAliasPrivateKey();
        Certificate[] chain = this.store.getCertificateChain(this.alias);
        X509Certificate bottomCertificate = (X509Certificate)chain[0];
        X500Principal defaultPrincipal = bottomCertificate.getIssuerX500Principal();
        this.setDName(this._dName, defaultPrincipal);
        PublicKey publicKey = bottomCertificate.getPublicKey();
        this.setSignatureAlgorithmParam(this._sigAlgorithm, privateKey);
        byte[] derBytes = this.getSelfSignedCertificate(this.distinguishedName, publicKey, (PrivateKey)privateKey);
        CertificateFactory x509Factory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(derBytes);
        Certificate certificate = x509Factory.generateCertificate(bais);
        chain = new Certificate[]{certificate};
        this.store.setKeyEntry(this.alias, privateKey, this.keyPasswordChars, chain);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("selfcert", true);
        result.setHeader(Messages.getString("SelfCertCmd.14"));
        result.setFooter(Messages.getString("SelfCertCmd.15"));
        OptionGroup options = new OptionGroup(Messages.getString("SelfCertCmd.16"));
        options.add(new Option("alias", Messages.getString("SelfCertCmd.17"), Messages.getString("SelfCertCmd.18")){

            public void parsed(String argument) throws OptionException {
                SelfCertCmd.this._alias = argument;
            }
        });
        options.add(new Option("sigalg", Messages.getString("SelfCertCmd.19"), Messages.getString("SelfCertCmd.20")){

            public void parsed(String argument) throws OptionException {
                SelfCertCmd.this._sigAlgorithm = argument;
            }
        });
        options.add(new Option("dname", Messages.getString("SelfCertCmd.21"), Messages.getString("SelfCertCmd.22")){

            public void parsed(String argument) throws OptionException {
                SelfCertCmd.this._dName = argument;
            }
        });
        options.add(new Option("keypass", Messages.getString("SelfCertCmd.23"), Messages.getString("SelfCertCmd.24")){

            public void parsed(String argument) throws OptionException {
                SelfCertCmd.this._password = argument;
            }
        });
        options.add(new Option("validity", Messages.getString("SelfCertCmd.25"), Messages.getString("SelfCertCmd.26")){

            public void parsed(String argument) throws OptionException {
                SelfCertCmd.this._validityStr = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("SelfCertCmd.27"), Messages.getString("SelfCertCmd.28")){

            public void parsed(String argument) throws OptionException {
                SelfCertCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("SelfCertCmd.29"), Messages.getString("SelfCertCmd.30")){

            public void parsed(String argument) throws OptionException {
                SelfCertCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("SelfCertCmd.31"), Messages.getString("SelfCertCmd.32")){

            public void parsed(String argument) throws OptionException {
                SelfCertCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("SelfCertCmd.33"), Messages.getString("SelfCertCmd.34")){

            public void parsed(String argument) throws OptionException {
                SelfCertCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("SelfCertCmd.35")){

            public void parsed(String argument) throws OptionException {
                SelfCertCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    private void setDName(String name, X500Principal defaultName) {
        name = name != null && name.trim().length() > 0 ? name.trim() : defaultName.toString().trim();
        this.distinguishedName = new X500DistinguishedName(name);
    }
}

