/******************************************************************************
 *
 * Copyright (C) 1997-2018 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby
 * granted. No representations are made about the suitability of this software
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * Documents produced by Doxygen are derivative works derived from the
 * input used in their production; they are not affected by this license.
 *
 */

#include "emoji.h"
#include "message.h"
#include "util.h"
#include "textstream.h"

static struct emojiEntityInfo
{
  const char *name;
  const char *unicode;
} g_emojiEntities[] =
/* generated using the download_github_emojis.py script */
{
  { ":+1:",                                    "&#x1f44d;"                            },
  { ":-1:",                                    "&#x1f44e;"                            },
  { ":100:",                                   "&#x1f4af;"                            },
  { ":1234:",                                  "&#x1f522;"                            },
  { ":1st_place_medal:",                       "&#x1f947;"                            },
  { ":2nd_place_medal:",                       "&#x1f948;"                            },
  { ":3rd_place_medal:",                       "&#x1f949;"                            },
  { ":8ball:",                                 "&#x1f3b1;"                            },
  { ":a:",                                     "&#x1f170;"                            },
  { ":ab:",                                    "&#x1f18e;"                            },
  { ":abc:",                                   "&#x1f524;"                            },
  { ":abcd:",                                  "&#x1f521;"                            },
  { ":accept:",                                "&#x1f251;"                            },
  { ":aerial_tramway:",                        "&#x1f6a1;"                            },
  { ":afghanistan:",                           "&#x1f1e6;&#x1f1eb;"                   },
  { ":airplane:",                              "&#x2708;"                             },
  { ":aland_islands:",                         "&#x1f1e6;&#x1f1fd;"                   },
  { ":alarm_clock:",                           "&#x23f0;"                             },
  { ":albania:",                               "&#x1f1e6;&#x1f1f1;"                   },
  { ":alembic:",                               "&#x2697;"                             },
  { ":algeria:",                               "&#x1f1e9;&#x1f1ff;"                   },
  { ":alien:",                                 "&#x1f47d;"                            },
  { ":ambulance:",                             "&#x1f691;"                            },
  { ":american_samoa:",                        "&#x1f1e6;&#x1f1f8;"                   },
  { ":amphora:",                               "&#x1f3fa;"                            },
  { ":anchor:",                                "&#x2693;"                             },
  { ":andorra:",                               "&#x1f1e6;&#x1f1e9;"                   },
  { ":angel:",                                 "&#x1f47c;"                            },
  { ":anger:",                                 "&#x1f4a2;"                            },
  { ":angola:",                                "&#x1f1e6;&#x1f1f4;"                   },
  { ":angry:",                                 "&#x1f620;"                            },
  { ":anguilla:",                              "&#x1f1e6;&#x1f1ee;"                   },
  { ":anguished:",                             "&#x1f627;"                            },
  { ":ant:",                                   "&#x1f41c;"                            },
  { ":antarctica:",                            "&#x1f1e6;&#x1f1f6;"                   },
  { ":antigua_barbuda:",                       "&#x1f1e6;&#x1f1ec;"                   },
  { ":apple:",                                 "&#x1f34e;"                            },
  { ":aquarius:",                              "&#x2652;"                             },
  { ":argentina:",                             "&#x1f1e6;&#x1f1f7;"                   },
  { ":aries:",                                 "&#x2648;"                             },
  { ":armenia:",                               "&#x1f1e6;&#x1f1f2;"                   },
  { ":arrow_backward:",                        "&#x25c0;"                             },
  { ":arrow_double_down:",                     "&#x23ec;"                             },
  { ":arrow_double_up:",                       "&#x23eb;"                             },
  { ":arrow_down:",                            "&#x2b07;"                             },
  { ":arrow_down_small:",                      "&#x1f53d;"                            },
  { ":arrow_forward:",                         "&#x25b6;"                             },
  { ":arrow_heading_down:",                    "&#x2935;"                             },
  { ":arrow_heading_up:",                      "&#x2934;"                             },
  { ":arrow_left:",                            "&#x2b05;"                             },
  { ":arrow_lower_left:",                      "&#x2199;"                             },
  { ":arrow_lower_right:",                     "&#x2198;"                             },
  { ":arrow_right:",                           "&#x27a1;"                             },
  { ":arrow_right_hook:",                      "&#x21aa;"                             },
  { ":arrow_up:",                              "&#x2b06;"                             },
  { ":arrow_up_down:",                         "&#x2195;"                             },
  { ":arrow_up_small:",                        "&#x1f53c;"                            },
  { ":arrow_upper_left:",                      "&#x2196;"                             },
  { ":arrow_upper_right:",                     "&#x2197;"                             },
  { ":arrows_clockwise:",                      "&#x1f503;"                            },
  { ":arrows_counterclockwise:",               "&#x1f504;"                            },
  { ":art:",                                   "&#x1f3a8;"                            },
  { ":articulated_lorry:",                     "&#x1f69b;"                            },
  { ":artificial_satellite:",                  "&#x1f6f0;"                            },
  { ":aruba:",                                 "&#x1f1e6;&#x1f1fc;"                   },
  { ":asterisk:",                              "&#x002a;&#x20e3;"                     },
  { ":astonished:",                            "&#x1f632;"                            },
  { ":athletic_shoe:",                         "&#x1f45f;"                            },
  { ":atm:",                                   "&#x1f3e7;"                            },
  { ":atom_symbol:",                           "&#x269b;"                             },
  { ":australia:",                             "&#x1f1e6;&#x1f1fa;"                   },
  { ":austria:",                               "&#x1f1e6;&#x1f1f9;"                   },
  { ":avocado:",                               "&#x1f951;"                            },
  { ":azerbaijan:",                            "&#x1f1e6;&#x1f1ff;"                   },
  { ":b:",                                     "&#x1f171;"                            },
  { ":baby:",                                  "&#x1f476;"                            },
  { ":baby_bottle:",                           "&#x1f37c;"                            },
  { ":baby_chick:",                            "&#x1f424;"                            },
  { ":baby_symbol:",                           "&#x1f6bc;"                            },
  { ":back:",                                  "&#x1f519;"                            },
  { ":bacon:",                                 "&#x1f953;"                            },
  { ":badminton:",                             "&#x1f3f8;"                            },
  { ":baggage_claim:",                         "&#x1f6c4;"                            },
  { ":baguette_bread:",                        "&#x1f956;"                            },
  { ":bahamas:",                               "&#x1f1e7;&#x1f1f8;"                   },
  { ":bahrain:",                               "&#x1f1e7;&#x1f1ed;"                   },
  { ":balance_scale:",                         "&#x2696;"                             },
  { ":balloon:",                               "&#x1f388;"                            },
  { ":ballot_box:",                            "&#x1f5f3;"                            },
  { ":ballot_box_with_check:",                 "&#x2611;"                             },
  { ":bamboo:",                                "&#x1f38d;"                            },
  { ":banana:",                                "&#x1f34c;"                            },
  { ":bangbang:",                              "&#x203c;"                             },
  { ":bangladesh:",                            "&#x1f1e7;&#x1f1e9;"                   },
  { ":bank:",                                  "&#x1f3e6;"                            },
  { ":bar_chart:",                             "&#x1f4ca;"                            },
  { ":barbados:",                              "&#x1f1e7;&#x1f1e7;"                   },
  { ":barber:",                                "&#x1f488;"                            },
  { ":baseball:",                              "&#x26be;"                             },
  { ":basketball:",                            "&#x1f3c0;"                            },
  { ":basketball_man:",                        "&#x26f9;"                             },
  { ":basketball_woman:",                      "&#x26f9;&#x2640;"                     },
  { ":bat:",                                   "&#x1f987;"                            },
  { ":bath:",                                  "&#x1f6c0;"                            },
  { ":bathtub:",                               "&#x1f6c1;"                            },
  { ":battery:",                               "&#x1f50b;"                            },
  { ":beach_umbrella:",                        "&#x1f3d6;"                            },
  { ":bear:",                                  "&#x1f43b;"                            },
  { ":bed:",                                   "&#x1f6cf;"                            },
  { ":bee:",                                   "&#x1f41d;"                            },
  { ":beer:",                                  "&#x1f37a;"                            },
  { ":beers:",                                 "&#x1f37b;"                            },
  { ":beetle:",                                "&#x1f41e;"                            },
  { ":beginner:",                              "&#x1f530;"                            },
  { ":belarus:",                               "&#x1f1e7;&#x1f1fe;"                   },
  { ":belgium:",                               "&#x1f1e7;&#x1f1ea;"                   },
  { ":belize:",                                "&#x1f1e7;&#x1f1ff;"                   },
  { ":bell:",                                  "&#x1f514;"                            },
  { ":bellhop_bell:",                          "&#x1f6ce;"                            },
  { ":benin:",                                 "&#x1f1e7;&#x1f1ef;"                   },
  { ":bento:",                                 "&#x1f371;"                            },
  { ":bermuda:",                               "&#x1f1e7;&#x1f1f2;"                   },
  { ":bhutan:",                                "&#x1f1e7;&#x1f1f9;"                   },
  { ":bicyclist:",                             "&#x1f6b4;"                            },
  { ":bike:",                                  "&#x1f6b2;"                            },
  { ":biking_man:",                            "&#x1f6b4;"                            },
  { ":biking_woman:",                          "&#x1f6b4;&#x2640;"                    },
  { ":bikini:",                                "&#x1f459;"                            },
  { ":biohazard:",                             "&#x2623;"                             },
  { ":bird:",                                  "&#x1f426;"                            },
  { ":birthday:",                              "&#x1f382;"                            },
  { ":black_circle:",                          "&#x26ab;"                             },
  { ":black_flag:",                            "&#x1f3f4;"                            },
  { ":black_heart:",                           "&#x1f5a4;"                            },
  { ":black_joker:",                           "&#x1f0cf;"                            },
  { ":black_large_square:",                    "&#x2b1b;"                             },
  { ":black_medium_small_square:",             "&#x25fe;"                             },
  { ":black_medium_square:",                   "&#x25fc;"                             },
  { ":black_nib:",                             "&#x2712;"                             },
  { ":black_small_square:",                    "&#x25aa;"                             },
  { ":black_square_button:",                   "&#x1f532;"                            },
  { ":blonde_man:",                            "&#x1f471;"                            },
  { ":blonde_woman:",                          "&#x1f471;&#x2640;"                    },
  { ":blossom:",                               "&#x1f33c;"                            },
  { ":blowfish:",                              "&#x1f421;"                            },
  { ":blue_book:",                             "&#x1f4d8;"                            },
  { ":blue_car:",                              "&#x1f699;"                            },
  { ":blue_heart:",                            "&#x1f499;"                            },
  { ":blush:",                                 "&#x1f60a;"                            },
  { ":boar:",                                  "&#x1f417;"                            },
  { ":boat:",                                  "&#x26f5;"                             },
  { ":bolivia:",                               "&#x1f1e7;&#x1f1f4;"                   },
  { ":bomb:",                                  "&#x1f4a3;"                            },
  { ":book:",                                  "&#x1f4d6;"                            },
  { ":bookmark:",                              "&#x1f516;"                            },
  { ":bookmark_tabs:",                         "&#x1f4d1;"                            },
  { ":books:",                                 "&#x1f4da;"                            },
  { ":boom:",                                  "&#x1f4a5;"                            },
  { ":boot:",                                  "&#x1f462;"                            },
  { ":bosnia_herzegovina:",                    "&#x1f1e7;&#x1f1e6;"                   },
  { ":botswana:",                              "&#x1f1e7;&#x1f1fc;"                   },
  { ":bouquet:",                               "&#x1f490;"                            },
  { ":bow:",                                   "&#x1f647;"                            },
  { ":bow_and_arrow:",                         "&#x1f3f9;"                            },
  { ":bowing_man:",                            "&#x1f647;"                            },
  { ":bowing_woman:",                          "&#x1f647;&#x2640;"                    },
  { ":bowling:",                               "&#x1f3b3;"                            },
  { ":boxing_glove:",                          "&#x1f94a;"                            },
  { ":boy:",                                   "&#x1f466;"                            },
  { ":brazil:",                                "&#x1f1e7;&#x1f1f7;"                   },
  { ":bread:",                                 "&#x1f35e;"                            },
  { ":bride_with_veil:",                       "&#x1f470;"                            },
  { ":bridge_at_night:",                       "&#x1f309;"                            },
  { ":briefcase:",                             "&#x1f4bc;"                            },
  { ":british_indian_ocean_territory:",        "&#x1f1ee;&#x1f1f4;"                   },
  { ":british_virgin_islands:",                "&#x1f1fb;&#x1f1ec;"                   },
  { ":broken_heart:",                          "&#x1f494;"                            },
  { ":brunei:",                                "&#x1f1e7;&#x1f1f3;"                   },
  { ":bug:",                                   "&#x1f41b;"                            },
  { ":building_construction:",                 "&#x1f3d7;"                            },
  { ":bulb:",                                  "&#x1f4a1;"                            },
  { ":bulgaria:",                              "&#x1f1e7;&#x1f1ec;"                   },
  { ":bullettrain_front:",                     "&#x1f685;"                            },
  { ":bullettrain_side:",                      "&#x1f684;"                            },
  { ":burkina_faso:",                          "&#x1f1e7;&#x1f1eb;"                   },
  { ":burrito:",                               "&#x1f32f;"                            },
  { ":burundi:",                               "&#x1f1e7;&#x1f1ee;"                   },
  { ":bus:",                                   "&#x1f68c;"                            },
  { ":business_suit_levitating:",              "&#x1f574;"                            },
  { ":busstop:",                               "&#x1f68f;"                            },
  { ":bust_in_silhouette:",                    "&#x1f464;"                            },
  { ":busts_in_silhouette:",                   "&#x1f465;"                            },
  { ":butterfly:",                             "&#x1f98b;"                            },
  { ":cactus:",                                "&#x1f335;"                            },
  { ":cake:",                                  "&#x1f370;"                            },
  { ":calendar:",                              "&#x1f4c6;"                            },
  { ":call_me_hand:",                          "&#x1f919;"                            },
  { ":calling:",                               "&#x1f4f2;"                            },
  { ":cambodia:",                              "&#x1f1f0;&#x1f1ed;"                   },
  { ":camel:",                                 "&#x1f42b;"                            },
  { ":camera:",                                "&#x1f4f7;"                            },
  { ":camera_flash:",                          "&#x1f4f8;"                            },
  { ":cameroon:",                              "&#x1f1e8;&#x1f1f2;"                   },
  { ":camping:",                               "&#x1f3d5;"                            },
  { ":canada:",                                "&#x1f1e8;&#x1f1e6;"                   },
  { ":canary_islands:",                        "&#x1f1ee;&#x1f1e8;"                   },
  { ":cancer:",                                "&#x264b;"                             },
  { ":candle:",                                "&#x1f56f;"                            },
  { ":candy:",                                 "&#x1f36c;"                            },
  { ":canoe:",                                 "&#x1f6f6;"                            },
  { ":cape_verde:",                            "&#x1f1e8;&#x1f1fb;"                   },
  { ":capital_abcd:",                          "&#x1f520;"                            },
  { ":capricorn:",                             "&#x2651;"                             },
  { ":car:",                                   "&#x1f697;"                            },
  { ":card_file_box:",                         "&#x1f5c3;"                            },
  { ":card_index:",                            "&#x1f4c7;"                            },
  { ":card_index_dividers:",                   "&#x1f5c2;"                            },
  { ":caribbean_netherlands:",                 "&#x1f1e7;&#x1f1f6;"                   },
  { ":carousel_horse:",                        "&#x1f3a0;"                            },
  { ":carrot:",                                "&#x1f955;"                            },
  { ":cat:",                                   "&#x1f431;"                            },
  { ":cat2:",                                  "&#x1f408;"                            },
  { ":cayman_islands:",                        "&#x1f1f0;&#x1f1fe;"                   },
  { ":cd:",                                    "&#x1f4bf;"                            },
  { ":central_african_republic:",              "&#x1f1e8;&#x1f1eb;"                   },
  { ":chad:",                                  "&#x1f1f9;&#x1f1e9;"                   },
  { ":chains:",                                "&#x26d3;"                             },
  { ":champagne:",                             "&#x1f37e;"                            },
  { ":chart:",                                 "&#x1f4b9;"                            },
  { ":chart_with_downwards_trend:",            "&#x1f4c9;"                            },
  { ":chart_with_upwards_trend:",              "&#x1f4c8;"                            },
  { ":checkered_flag:",                        "&#x1f3c1;"                            },
  { ":cheese:",                                "&#x1f9c0;"                            },
  { ":cherries:",                              "&#x1f352;"                            },
  { ":cherry_blossom:",                        "&#x1f338;"                            },
  { ":chestnut:",                              "&#x1f330;"                            },
  { ":chicken:",                               "&#x1f414;"                            },
  { ":children_crossing:",                     "&#x1f6b8;"                            },
  { ":chile:",                                 "&#x1f1e8;&#x1f1f1;"                   },
  { ":chipmunk:",                              "&#x1f43f;"                            },
  { ":chocolate_bar:",                         "&#x1f36b;"                            },
  { ":christmas_island:",                      "&#x1f1e8;&#x1f1fd;"                   },
  { ":christmas_tree:",                        "&#x1f384;"                            },
  { ":church:",                                "&#x26ea;"                             },
  { ":cinema:",                                "&#x1f3a6;"                            },
  { ":circus_tent:",                           "&#x1f3aa;"                            },
  { ":city_sunrise:",                          "&#x1f307;"                            },
  { ":city_sunset:",                           "&#x1f306;"                            },
  { ":cityscape:",                             "&#x1f3d9;"                            },
  { ":cl:",                                    "&#x1f191;"                            },
  { ":clamp:",                                 "&#x1f5dc;"                            },
  { ":clap:",                                  "&#x1f44f;"                            },
  { ":clapper:",                               "&#x1f3ac;"                            },
  { ":classical_building:",                    "&#x1f3db;"                            },
  { ":clinking_glasses:",                      "&#x1f942;"                            },
  { ":clipboard:",                             "&#x1f4cb;"                            },
  { ":clock1:",                                "&#x1f550;"                            },
  { ":clock10:",                               "&#x1f559;"                            },
  { ":clock1030:",                             "&#x1f565;"                            },
  { ":clock11:",                               "&#x1f55a;"                            },
  { ":clock1130:",                             "&#x1f566;"                            },
  { ":clock12:",                               "&#x1f55b;"                            },
  { ":clock1230:",                             "&#x1f567;"                            },
  { ":clock130:",                              "&#x1f55c;"                            },
  { ":clock2:",                                "&#x1f551;"                            },
  { ":clock230:",                              "&#x1f55d;"                            },
  { ":clock3:",                                "&#x1f552;"                            },
  { ":clock330:",                              "&#x1f55e;"                            },
  { ":clock4:",                                "&#x1f553;"                            },
  { ":clock430:",                              "&#x1f55f;"                            },
  { ":clock5:",                                "&#x1f554;"                            },
  { ":clock530:",                              "&#x1f560;"                            },
  { ":clock6:",                                "&#x1f555;"                            },
  { ":clock630:",                              "&#x1f561;"                            },
  { ":clock7:",                                "&#x1f556;"                            },
  { ":clock730:",                              "&#x1f562;"                            },
  { ":clock8:",                                "&#x1f557;"                            },
  { ":clock830:",                              "&#x1f563;"                            },
  { ":clock9:",                                "&#x1f558;"                            },
  { ":clock930:",                              "&#x1f564;"                            },
  { ":closed_book:",                           "&#x1f4d5;"                            },
  { ":closed_lock_with_key:",                  "&#x1f510;"                            },
  { ":closed_umbrella:",                       "&#x1f302;"                            },
  { ":cloud:",                                 "&#x2601;"                             },
  { ":cloud_with_lightning:",                  "&#x1f329;"                            },
  { ":cloud_with_lightning_and_rain:",         "&#x26c8;"                             },
  { ":cloud_with_rain:",                       "&#x1f327;"                            },
  { ":cloud_with_snow:",                       "&#x1f328;"                            },
  { ":clown_face:",                            "&#x1f921;"                            },
  { ":clubs:",                                 "&#x2663;"                             },
  { ":cn:",                                    "&#x1f1e8;&#x1f1f3;"                   },
  { ":cocktail:",                              "&#x1f378;"                            },
  { ":cocos_islands:",                         "&#x1f1e8;&#x1f1e8;"                   },
  { ":coffee:",                                "&#x2615;"                             },
  { ":coffin:",                                "&#x26b0;"                             },
  { ":cold_sweat:",                            "&#x1f630;"                            },
  { ":collision:",                             "&#x1f4a5;"                            },
  { ":colombia:",                              "&#x1f1e8;&#x1f1f4;"                   },
  { ":comet:",                                 "&#x2604;"                             },
  { ":comoros:",                               "&#x1f1f0;&#x1f1f2;"                   },
  { ":computer:",                              "&#x1f4bb;"                            },
  { ":computer_mouse:",                        "&#x1f5b1;"                            },
  { ":confetti_ball:",                         "&#x1f38a;"                            },
  { ":confounded:",                            "&#x1f616;"                            },
  { ":confused:",                              "&#x1f615;"                            },
  { ":congo_brazzaville:",                     "&#x1f1e8;&#x1f1ec;"                   },
  { ":congo_kinshasa:",                        "&#x1f1e8;&#x1f1e9;"                   },
  { ":congratulations:",                       "&#x3297;"                             },
  { ":construction:",                          "&#x1f6a7;"                            },
  { ":construction_worker:",                   "&#x1f477;"                            },
  { ":construction_worker_man:",               "&#x1f477;"                            },
  { ":construction_worker_woman:",             "&#x1f477;&#x2640;"                    },
  { ":control_knobs:",                         "&#x1f39b;"                            },
  { ":convenience_store:",                     "&#x1f3ea;"                            },
  { ":cook_islands:",                          "&#x1f1e8;&#x1f1f0;"                   },
  { ":cookie:",                                "&#x1f36a;"                            },
  { ":cool:",                                  "&#x1f192;"                            },
  { ":cop:",                                   "&#x1f46e;"                            },
  { ":copyright:",                             "&#x00a9;"                             },
  { ":corn:",                                  "&#x1f33d;"                            },
  { ":costa_rica:",                            "&#x1f1e8;&#x1f1f7;"                   },
  { ":cote_divoire:",                          "&#x1f1e8;&#x1f1ee;"                   },
  { ":couch_and_lamp:",                        "&#x1f6cb;"                            },
  { ":couple:",                                "&#x1f46b;"                            },
  { ":couple_with_heart:",                     "&#x1f491;"                            },
  { ":couple_with_heart_man_man:",             "&#x1f468;&#x2764;&#x1f468;"           },
  { ":couple_with_heart_woman_man:",           "&#x1f491;"                            },
  { ":couple_with_heart_woman_woman:",         "&#x1f469;&#x2764;&#x1f469;"           },
  { ":couplekiss_man_man:",                    "&#x1f468;&#x2764;&#x1f48b;&#x1f468;"  },
  { ":couplekiss_man_woman:",                  "&#x1f48f;"                            },
  { ":couplekiss_woman_woman:",                "&#x1f469;&#x2764;&#x1f48b;&#x1f469;"  },
  { ":cow:",                                   "&#x1f42e;"                            },
  { ":cow2:",                                  "&#x1f404;"                            },
  { ":cowboy_hat_face:",                       "&#x1f920;"                            },
  { ":crab:",                                  "&#x1f980;"                            },
  { ":crayon:",                                "&#x1f58d;"                            },
  { ":credit_card:",                           "&#x1f4b3;"                            },
  { ":crescent_moon:",                         "&#x1f319;"                            },
  { ":cricket:",                               "&#x1f3cf;"                            },
  { ":croatia:",                               "&#x1f1ed;&#x1f1f7;"                   },
  { ":crocodile:",                             "&#x1f40a;"                            },
  { ":croissant:",                             "&#x1f950;"                            },
  { ":crossed_fingers:",                       "&#x1f91e;"                            },
  { ":crossed_flags:",                         "&#x1f38c;"                            },
  { ":crossed_swords:",                        "&#x2694;"                             },
  { ":crown:",                                 "&#x1f451;"                            },
  { ":cry:",                                   "&#x1f622;"                            },
  { ":crying_cat_face:",                       "&#x1f63f;"                            },
  { ":crystal_ball:",                          "&#x1f52e;"                            },
  { ":cuba:",                                  "&#x1f1e8;&#x1f1fa;"                   },
  { ":cucumber:",                              "&#x1f952;"                            },
  { ":cupid:",                                 "&#x1f498;"                            },
  { ":curacao:",                               "&#x1f1e8;&#x1f1fc;"                   },
  { ":curly_loop:",                            "&#x27b0;"                             },
  { ":currency_exchange:",                     "&#x1f4b1;"                            },
  { ":curry:",                                 "&#x1f35b;"                            },
  { ":custard:",                               "&#x1f36e;"                            },
  { ":customs:",                               "&#x1f6c3;"                            },
  { ":cyclone:",                               "&#x1f300;"                            },
  { ":cyprus:",                                "&#x1f1e8;&#x1f1fe;"                   },
  { ":czech_republic:",                        "&#x1f1e8;&#x1f1ff;"                   },
  { ":dagger:",                                "&#x1f5e1;"                            },
  { ":dancer:",                                "&#x1f483;"                            },
  { ":dancers:",                               "&#x1f46f;"                            },
  { ":dancing_men:",                           "&#x1f46f;&#x2642;"                    },
  { ":dancing_women:",                         "&#x1f46f;"                            },
  { ":dango:",                                 "&#x1f361;"                            },
  { ":dark_sunglasses:",                       "&#x1f576;"                            },
  { ":dart:",                                  "&#x1f3af;"                            },
  { ":dash:",                                  "&#x1f4a8;"                            },
  { ":date:",                                  "&#x1f4c5;"                            },
  { ":de:",                                    "&#x1f1e9;&#x1f1ea;"                   },
  { ":deciduous_tree:",                        "&#x1f333;"                            },
  { ":deer:",                                  "&#x1f98c;"                            },
  { ":denmark:",                               "&#x1f1e9;&#x1f1f0;"                   },
  { ":department_store:",                      "&#x1f3ec;"                            },
  { ":derelict_house:",                        "&#x1f3da;"                            },
  { ":desert:",                                "&#x1f3dc;"                            },
  { ":desert_island:",                         "&#x1f3dd;"                            },
  { ":desktop_computer:",                      "&#x1f5a5;"                            },
  { ":detective:",                             "&#x1f575;"                            },
  { ":diamond_shape_with_a_dot_inside:",       "&#x1f4a0;"                            },
  { ":diamonds:",                              "&#x2666;"                             },
  { ":disappointed:",                          "&#x1f61e;"                            },
  { ":disappointed_relieved:",                 "&#x1f625;"                            },
  { ":dizzy:",                                 "&#x1f4ab;"                            },
  { ":dizzy_face:",                            "&#x1f635;"                            },
  { ":djibouti:",                              "&#x1f1e9;&#x1f1ef;"                   },
  { ":do_not_litter:",                         "&#x1f6af;"                            },
  { ":dog:",                                   "&#x1f436;"                            },
  { ":dog2:",                                  "&#x1f415;"                            },
  { ":dollar:",                                "&#x1f4b5;"                            },
  { ":dolls:",                                 "&#x1f38e;"                            },
  { ":dolphin:",                               "&#x1f42c;"                            },
  { ":dominica:",                              "&#x1f1e9;&#x1f1f2;"                   },
  { ":dominican_republic:",                    "&#x1f1e9;&#x1f1f4;"                   },
  { ":door:",                                  "&#x1f6aa;"                            },
  { ":doughnut:",                              "&#x1f369;"                            },
  { ":dove:",                                  "&#x1f54a;"                            },
  { ":dragon:",                                "&#x1f409;"                            },
  { ":dragon_face:",                           "&#x1f432;"                            },
  { ":dress:",                                 "&#x1f457;"                            },
  { ":dromedary_camel:",                       "&#x1f42a;"                            },
  { ":drooling_face:",                         "&#x1f924;"                            },
  { ":droplet:",                               "&#x1f4a7;"                            },
  { ":drum:",                                  "&#x1f941;"                            },
  { ":duck:",                                  "&#x1f986;"                            },
  { ":dvd:",                                   "&#x1f4c0;"                            },
  { ":e-mail:",                                "&#x1f4e7;"                            },
  { ":eagle:",                                 "&#x1f985;"                            },
  { ":ear:",                                   "&#x1f442;"                            },
  { ":ear_of_rice:",                           "&#x1f33e;"                            },
  { ":earth_africa:",                          "&#x1f30d;"                            },
  { ":earth_americas:",                        "&#x1f30e;"                            },
  { ":earth_asia:",                            "&#x1f30f;"                            },
  { ":ecuador:",                               "&#x1f1ea;&#x1f1e8;"                   },
  { ":egg:",                                   "&#x1f95a;"                            },
  { ":eggplant:",                              "&#x1f346;"                            },
  { ":egypt:",                                 "&#x1f1ea;&#x1f1ec;"                   },
  { ":eight:",                                 "&#x0038;&#x20e3;"                     },
  { ":eight_pointed_black_star:",              "&#x2734;"                             },
  { ":eight_spoked_asterisk:",                 "&#x2733;"                             },
  { ":el_salvador:",                           "&#x1f1f8;&#x1f1fb;"                   },
  { ":electric_plug:",                         "&#x1f50c;"                            },
  { ":elephant:",                              "&#x1f418;"                            },
  { ":email:",                                 "&#x2709;"                             },
  { ":end:",                                   "&#x1f51a;"                            },
  { ":envelope:",                              "&#x2709;"                             },
  { ":envelope_with_arrow:",                   "&#x1f4e9;"                            },
  { ":equatorial_guinea:",                     "&#x1f1ec;&#x1f1f6;"                   },
  { ":eritrea:",                               "&#x1f1ea;&#x1f1f7;"                   },
  { ":es:",                                    "&#x1f1ea;&#x1f1f8;"                   },
  { ":estonia:",                               "&#x1f1ea;&#x1f1ea;"                   },
  { ":ethiopia:",                              "&#x1f1ea;&#x1f1f9;"                   },
  { ":eu:",                                    "&#x1f1ea;&#x1f1fa;"                   },
  { ":euro:",                                  "&#x1f4b6;"                            },
  { ":european_castle:",                       "&#x1f3f0;"                            },
  { ":european_post_office:",                  "&#x1f3e4;"                            },
  { ":european_union:",                        "&#x1f1ea;&#x1f1fa;"                   },
  { ":evergreen_tree:",                        "&#x1f332;"                            },
  { ":exclamation:",                           "&#x2757;"                             },
  { ":expressionless:",                        "&#x1f611;"                            },
  { ":eye:",                                   "&#x1f441;"                            },
  { ":eye_speech_bubble:",                     "&#x1f441;&#x1f5e8;"                   },
  { ":eyeglasses:",                            "&#x1f453;"                            },
  { ":eyes:",                                  "&#x1f440;"                            },
  { ":face_with_head_bandage:",                "&#x1f915;"                            },
  { ":face_with_thermometer:",                 "&#x1f912;"                            },
  { ":facepunch:",                             "&#x1f44a;"                            },
  { ":factory:",                               "&#x1f3ed;"                            },
  { ":falkland_islands:",                      "&#x1f1eb;&#x1f1f0;"                   },
  { ":fallen_leaf:",                           "&#x1f342;"                            },
  { ":family:",                                "&#x1f46a;"                            },
  { ":family_man_boy:",                        "&#x1f468;&#x1f466;"                   },
  { ":family_man_boy_boy:",                    "&#x1f468;&#x1f466;&#x1f466;"          },
  { ":family_man_girl:",                       "&#x1f468;&#x1f467;"                   },
  { ":family_man_girl_boy:",                   "&#x1f468;&#x1f467;&#x1f466;"          },
  { ":family_man_girl_girl:",                  "&#x1f468;&#x1f467;&#x1f467;"          },
  { ":family_man_man_boy:",                    "&#x1f468;&#x1f468;&#x1f466;"          },
  { ":family_man_man_boy_boy:",                "&#x1f468;&#x1f468;&#x1f466;&#x1f466;" },
  { ":family_man_man_girl:",                   "&#x1f468;&#x1f468;&#x1f467;"          },
  { ":family_man_man_girl_boy:",               "&#x1f468;&#x1f468;&#x1f467;&#x1f466;" },
  { ":family_man_man_girl_girl:",              "&#x1f468;&#x1f468;&#x1f467;&#x1f467;" },
  { ":family_man_woman_boy:",                  "&#x1f46a;"                            },
  { ":family_man_woman_boy_boy:",              "&#x1f468;&#x1f469;&#x1f466;&#x1f466;" },
  { ":family_man_woman_girl:",                 "&#x1f468;&#x1f469;&#x1f467;"          },
  { ":family_man_woman_girl_boy:",             "&#x1f468;&#x1f469;&#x1f467;&#x1f466;" },
  { ":family_man_woman_girl_girl:",            "&#x1f468;&#x1f469;&#x1f467;&#x1f467;" },
  { ":family_woman_boy:",                      "&#x1f469;&#x1f466;"                   },
  { ":family_woman_boy_boy:",                  "&#x1f469;&#x1f466;&#x1f466;"          },
  { ":family_woman_girl:",                     "&#x1f469;&#x1f467;"                   },
  { ":family_woman_girl_boy:",                 "&#x1f469;&#x1f467;&#x1f466;"          },
  { ":family_woman_girl_girl:",                "&#x1f469;&#x1f467;&#x1f467;"          },
  { ":family_woman_woman_boy:",                "&#x1f469;&#x1f469;&#x1f466;"          },
  { ":family_woman_woman_boy_boy:",            "&#x1f469;&#x1f469;&#x1f466;&#x1f466;" },
  { ":family_woman_woman_girl:",               "&#x1f469;&#x1f469;&#x1f467;"          },
  { ":family_woman_woman_girl_boy:",           "&#x1f469;&#x1f469;&#x1f467;&#x1f466;" },
  { ":family_woman_woman_girl_girl:",          "&#x1f469;&#x1f469;&#x1f467;&#x1f467;" },
  { ":faroe_islands:",                         "&#x1f1eb;&#x1f1f4;"                   },
  { ":fast_forward:",                          "&#x23e9;"                             },
  { ":fax:",                                   "&#x1f4e0;"                            },
  { ":fearful:",                               "&#x1f628;"                            },
  { ":feet:",                                  "&#x1f43e;"                            },
  { ":female_detective:",                      "&#x1f575;&#x2640;"                    },
  { ":ferris_wheel:",                          "&#x1f3a1;"                            },
  { ":ferry:",                                 "&#x26f4;"                             },
  { ":field_hockey:",                          "&#x1f3d1;"                            },
  { ":fiji:",                                  "&#x1f1eb;&#x1f1ef;"                   },
  { ":file_cabinet:",                          "&#x1f5c4;"                            },
  { ":file_folder:",                           "&#x1f4c1;"                            },
  { ":film_projector:",                        "&#x1f4fd;"                            },
  { ":film_strip:",                            "&#x1f39e;"                            },
  { ":finland:",                               "&#x1f1eb;&#x1f1ee;"                   },
  { ":fire:",                                  "&#x1f525;"                            },
  { ":fire_engine:",                           "&#x1f692;"                            },
  { ":fireworks:",                             "&#x1f386;"                            },
  { ":first_quarter_moon:",                    "&#x1f313;"                            },
  { ":first_quarter_moon_with_face:",          "&#x1f31b;"                            },
  { ":fish:",                                  "&#x1f41f;"                            },
  { ":fish_cake:",                             "&#x1f365;"                            },
  { ":fishing_pole_and_fish:",                 "&#x1f3a3;"                            },
  { ":fist:",                                  "&#x270a;"                             },
  { ":fist_left:",                             "&#x1f91b;"                            },
  { ":fist_oncoming:",                         "&#x1f44a;"                            },
  { ":fist_raised:",                           "&#x270a;"                             },
  { ":fist_right:",                            "&#x1f91c;"                            },
  { ":five:",                                  "&#x0035;&#x20e3;"                     },
  { ":flags:",                                 "&#x1f38f;"                            },
  { ":flashlight:",                            "&#x1f526;"                            },
  { ":fleur_de_lis:",                          "&#x269c;"                             },
  { ":flight_arrival:",                        "&#x1f6ec;"                            },
  { ":flight_departure:",                      "&#x1f6eb;"                            },
  { ":flipper:",                               "&#x1f42c;"                            },
  { ":floppy_disk:",                           "&#x1f4be;"                            },
  { ":flower_playing_cards:",                  "&#x1f3b4;"                            },
  { ":flushed:",                               "&#x1f633;"                            },
  { ":fog:",                                   "&#x1f32b;"                            },
  { ":foggy:",                                 "&#x1f301;"                            },
  { ":football:",                              "&#x1f3c8;"                            },
  { ":footprints:",                            "&#x1f463;"                            },
  { ":fork_and_knife:",                        "&#x1f374;"                            },
  { ":fountain:",                              "&#x26f2;"                             },
  { ":fountain_pen:",                          "&#x1f58b;"                            },
  { ":four:",                                  "&#x0034;&#x20e3;"                     },
  { ":four_leaf_clover:",                      "&#x1f340;"                            },
  { ":fox_face:",                              "&#x1f98a;"                            },
  { ":fr:",                                    "&#x1f1eb;&#x1f1f7;"                   },
  { ":framed_picture:",                        "&#x1f5bc;"                            },
  { ":free:",                                  "&#x1f193;"                            },
  { ":french_guiana:",                         "&#x1f1ec;&#x1f1eb;"                   },
  { ":french_polynesia:",                      "&#x1f1f5;&#x1f1eb;"                   },
  { ":french_southern_territories:",           "&#x1f1f9;&#x1f1eb;"                   },
  { ":fried_egg:",                             "&#x1f373;"                            },
  { ":fried_shrimp:",                          "&#x1f364;"                            },
  { ":fries:",                                 "&#x1f35f;"                            },
  { ":frog:",                                  "&#x1f438;"                            },
  { ":frowning:",                              "&#x1f626;"                            },
  { ":frowning_face:",                         "&#x2639;"                             },
  { ":frowning_man:",                          "&#x1f64d;&#x2642;"                    },
  { ":frowning_woman:",                        "&#x1f64d;"                            },
  { ":fu:",                                    "&#x1f595;"                            },
  { ":fuelpump:",                              "&#x26fd;"                             },
  { ":full_moon:",                             "&#x1f315;"                            },
  { ":full_moon_with_face:",                   "&#x1f31d;"                            },
  { ":funeral_urn:",                           "&#x26b1;"                             },
  { ":gabon:",                                 "&#x1f1ec;&#x1f1e6;"                   },
  { ":gambia:",                                "&#x1f1ec;&#x1f1f2;"                   },
  { ":game_die:",                              "&#x1f3b2;"                            },
  { ":gb:",                                    "&#x1f1ec;&#x1f1e7;"                   },
  { ":gear:",                                  "&#x2699;"                             },
  { ":gem:",                                   "&#x1f48e;"                            },
  { ":gemini:",                                "&#x264a;"                             },
  { ":georgia:",                               "&#x1f1ec;&#x1f1ea;"                   },
  { ":ghana:",                                 "&#x1f1ec;&#x1f1ed;"                   },
  { ":ghost:",                                 "&#x1f47b;"                            },
  { ":gibraltar:",                             "&#x1f1ec;&#x1f1ee;"                   },
  { ":gift:",                                  "&#x1f381;"                            },
  { ":gift_heart:",                            "&#x1f49d;"                            },
  { ":girl:",                                  "&#x1f467;"                            },
  { ":globe_with_meridians:",                  "&#x1f310;"                            },
  { ":goal_net:",                              "&#x1f945;"                            },
  { ":goat:",                                  "&#x1f410;"                            },
  { ":golf:",                                  "&#x26f3;"                             },
  { ":golfing_man:",                           "&#x1f3cc;"                            },
  { ":golfing_woman:",                         "&#x1f3cc;&#x2640;"                    },
  { ":gorilla:",                               "&#x1f98d;"                            },
  { ":grapes:",                                "&#x1f347;"                            },
  { ":greece:",                                "&#x1f1ec;&#x1f1f7;"                   },
  { ":green_apple:",                           "&#x1f34f;"                            },
  { ":green_book:",                            "&#x1f4d7;"                            },
  { ":green_heart:",                           "&#x1f49a;"                            },
  { ":green_salad:",                           "&#x1f957;"                            },
  { ":greenland:",                             "&#x1f1ec;&#x1f1f1;"                   },
  { ":grenada:",                               "&#x1f1ec;&#x1f1e9;"                   },
  { ":grey_exclamation:",                      "&#x2755;"                             },
  { ":grey_question:",                         "&#x2754;"                             },
  { ":grimacing:",                             "&#x1f62c;"                            },
  { ":grin:",                                  "&#x1f601;"                            },
  { ":grinning:",                              "&#x1f600;"                            },
  { ":guadeloupe:",                            "&#x1f1ec;&#x1f1f5;"                   },
  { ":guam:",                                  "&#x1f1ec;&#x1f1fa;"                   },
  { ":guardsman:",                             "&#x1f482;"                            },
  { ":guardswoman:",                           "&#x1f482;&#x2640;"                    },
  { ":guatemala:",                             "&#x1f1ec;&#x1f1f9;"                   },
  { ":guernsey:",                              "&#x1f1ec;&#x1f1ec;"                   },
  { ":guinea:",                                "&#x1f1ec;&#x1f1f3;"                   },
  { ":guinea_bissau:",                         "&#x1f1ec;&#x1f1fc;"                   },
  { ":guitar:",                                "&#x1f3b8;"                            },
  { ":gun:",                                   "&#x1f52b;"                            },
  { ":guyana:",                                "&#x1f1ec;&#x1f1fe;"                   },
  { ":haircut:",                               "&#x1f487;"                            },
  { ":haircut_man:",                           "&#x1f487;&#x2642;"                    },
  { ":haircut_woman:",                         "&#x1f487;"                            },
  { ":haiti:",                                 "&#x1f1ed;&#x1f1f9;"                   },
  { ":hamburger:",                             "&#x1f354;"                            },
  { ":hammer:",                                "&#x1f528;"                            },
  { ":hammer_and_pick:",                       "&#x2692;"                             },
  { ":hammer_and_wrench:",                     "&#x1f6e0;"                            },
  { ":hamster:",                               "&#x1f439;"                            },
  { ":hand:",                                  "&#x270b;"                             },
  { ":handbag:",                               "&#x1f45c;"                            },
  { ":handshake:",                             "&#x1f91d;"                            },
  { ":hankey:",                                "&#x1f4a9;"                            },
  { ":hash:",                                  "&#x0023;&#x20e3;"                     },
  { ":hatched_chick:",                         "&#x1f425;"                            },
  { ":hatching_chick:",                        "&#x1f423;"                            },
  { ":headphones:",                            "&#x1f3a7;"                            },
  { ":hear_no_evil:",                          "&#x1f649;"                            },
  { ":heart:",                                 "&#x2764;"                             },
  { ":heart_decoration:",                      "&#x1f49f;"                            },
  { ":heart_eyes:",                            "&#x1f60d;"                            },
  { ":heart_eyes_cat:",                        "&#x1f63b;"                            },
  { ":heartbeat:",                             "&#x1f493;"                            },
  { ":heartpulse:",                            "&#x1f497;"                            },
  { ":hearts:",                                "&#x2665;"                             },
  { ":heavy_check_mark:",                      "&#x2714;"                             },
  { ":heavy_division_sign:",                   "&#x2797;"                             },
  { ":heavy_dollar_sign:",                     "&#x1f4b2;"                            },
  { ":heavy_exclamation_mark:",                "&#x2757;"                             },
  { ":heavy_heart_exclamation:",               "&#x2763;"                             },
  { ":heavy_minus_sign:",                      "&#x2796;"                             },
  { ":heavy_multiplication_x:",                "&#x2716;"                             },
  { ":heavy_plus_sign:",                       "&#x2795;"                             },
  { ":helicopter:",                            "&#x1f681;"                            },
  { ":herb:",                                  "&#x1f33f;"                            },
  { ":hibiscus:",                              "&#x1f33a;"                            },
  { ":high_brightness:",                       "&#x1f506;"                            },
  { ":high_heel:",                             "&#x1f460;"                            },
  { ":hocho:",                                 "&#x1f52a;"                            },
  { ":hole:",                                  "&#x1f573;"                            },
  { ":honduras:",                              "&#x1f1ed;&#x1f1f3;"                   },
  { ":honey_pot:",                             "&#x1f36f;"                            },
  { ":honeybee:",                              "&#x1f41d;"                            },
  { ":hong_kong:",                             "&#x1f1ed;&#x1f1f0;"                   },
  { ":horse:",                                 "&#x1f434;"                            },
  { ":horse_racing:",                          "&#x1f3c7;"                            },
  { ":hospital:",                              "&#x1f3e5;"                            },
  { ":hot_pepper:",                            "&#x1f336;"                            },
  { ":hotdog:",                                "&#x1f32d;"                            },
  { ":hotel:",                                 "&#x1f3e8;"                            },
  { ":hotsprings:",                            "&#x2668;"                             },
  { ":hourglass:",                             "&#x231b;"                             },
  { ":hourglass_flowing_sand:",                "&#x23f3;"                             },
  { ":house:",                                 "&#x1f3e0;"                            },
  { ":house_with_garden:",                     "&#x1f3e1;"                            },
  { ":houses:",                                "&#x1f3d8;"                            },
  { ":hugs:",                                  "&#x1f917;"                            },
  { ":hungary:",                               "&#x1f1ed;&#x1f1fa;"                   },
  { ":hushed:",                                "&#x1f62f;"                            },
  { ":ice_cream:",                             "&#x1f368;"                            },
  { ":ice_hockey:",                            "&#x1f3d2;"                            },
  { ":ice_skate:",                             "&#x26f8;"                             },
  { ":icecream:",                              "&#x1f366;"                            },
  { ":iceland:",                               "&#x1f1ee;&#x1f1f8;"                   },
  { ":id:",                                    "&#x1f194;"                            },
  { ":ideograph_advantage:",                   "&#x1f250;"                            },
  { ":imp:",                                   "&#x1f47f;"                            },
  { ":inbox_tray:",                            "&#x1f4e5;"                            },
  { ":incoming_envelope:",                     "&#x1f4e8;"                            },
  { ":india:",                                 "&#x1f1ee;&#x1f1f3;"                   },
  { ":indonesia:",                             "&#x1f1ee;&#x1f1e9;"                   },
  { ":information_desk_person:",               "&#x1f481;"                            },
  { ":information_source:",                    "&#x2139;"                             },
  { ":innocent:",                              "&#x1f607;"                            },
  { ":interrobang:",                           "&#x2049;"                             },
  { ":iphone:",                                "&#x1f4f1;"                            },
  { ":iran:",                                  "&#x1f1ee;&#x1f1f7;"                   },
  { ":iraq:",                                  "&#x1f1ee;&#x1f1f6;"                   },
  { ":ireland:",                               "&#x1f1ee;&#x1f1ea;"                   },
  { ":isle_of_man:",                           "&#x1f1ee;&#x1f1f2;"                   },
  { ":israel:",                                "&#x1f1ee;&#x1f1f1;"                   },
  { ":it:",                                    "&#x1f1ee;&#x1f1f9;"                   },
  { ":izakaya_lantern:",                       "&#x1f3ee;"                            },
  { ":jack_o_lantern:",                        "&#x1f383;"                            },
  { ":jamaica:",                               "&#x1f1ef;&#x1f1f2;"                   },
  { ":japan:",                                 "&#x1f5fe;"                            },
  { ":japanese_castle:",                       "&#x1f3ef;"                            },
  { ":japanese_goblin:",                       "&#x1f47a;"                            },
  { ":japanese_ogre:",                         "&#x1f479;"                            },
  { ":jeans:",                                 "&#x1f456;"                            },
  { ":jersey:",                                "&#x1f1ef;&#x1f1ea;"                   },
  { ":jordan:",                                "&#x1f1ef;&#x1f1f4;"                   },
  { ":joy:",                                   "&#x1f602;"                            },
  { ":joy_cat:",                               "&#x1f639;"                            },
  { ":joystick:",                              "&#x1f579;"                            },
  { ":jp:",                                    "&#x1f1ef;&#x1f1f5;"                   },
  { ":kaaba:",                                 "&#x1f54b;"                            },
  { ":kazakhstan:",                            "&#x1f1f0;&#x1f1ff;"                   },
  { ":kenya:",                                 "&#x1f1f0;&#x1f1ea;"                   },
  { ":key:",                                   "&#x1f511;"                            },
  { ":keyboard:",                              "&#x2328;"                             },
  { ":keycap_ten:",                            "&#x1f51f;"                            },
  { ":kick_scooter:",                          "&#x1f6f4;"                            },
  { ":kimono:",                                "&#x1f458;"                            },
  { ":kiribati:",                              "&#x1f1f0;&#x1f1ee;"                   },
  { ":kiss:",                                  "&#x1f48b;"                            },
  { ":kissing:",                               "&#x1f617;"                            },
  { ":kissing_cat:",                           "&#x1f63d;"                            },
  { ":kissing_closed_eyes:",                   "&#x1f61a;"                            },
  { ":kissing_heart:",                         "&#x1f618;"                            },
  { ":kissing_smiling_eyes:",                  "&#x1f619;"                            },
  { ":kiwi_fruit:",                            "&#x1f95d;"                            },
  { ":knife:",                                 "&#x1f52a;"                            },
  { ":koala:",                                 "&#x1f428;"                            },
  { ":koko:",                                  "&#x1f201;"                            },
  { ":kosovo:",                                "&#x1f1fd;&#x1f1f0;"                   },
  { ":kr:",                                    "&#x1f1f0;&#x1f1f7;"                   },
  { ":kuwait:",                                "&#x1f1f0;&#x1f1fc;"                   },
  { ":kyrgyzstan:",                            "&#x1f1f0;&#x1f1ec;"                   },
  { ":label:",                                 "&#x1f3f7;"                            },
  { ":lantern:",                               "&#x1f3ee;"                            },
  { ":laos:",                                  "&#x1f1f1;&#x1f1e6;"                   },
  { ":large_blue_circle:",                     "&#x1f535;"                            },
  { ":large_blue_diamond:",                    "&#x1f537;"                            },
  { ":large_orange_diamond:",                  "&#x1f536;"                            },
  { ":last_quarter_moon:",                     "&#x1f317;"                            },
  { ":last_quarter_moon_with_face:",           "&#x1f31c;"                            },
  { ":latin_cross:",                           "&#x271d;"                             },
  { ":latvia:",                                "&#x1f1f1;&#x1f1fb;"                   },
  { ":laughing:",                              "&#x1f606;"                            },
  { ":leaves:",                                "&#x1f343;"                            },
  { ":lebanon:",                               "&#x1f1f1;&#x1f1e7;"                   },
  { ":ledger:",                                "&#x1f4d2;"                            },
  { ":left_luggage:",                          "&#x1f6c5;"                            },
  { ":left_right_arrow:",                      "&#x2194;"                             },
  { ":leftwards_arrow_with_hook:",             "&#x21a9;"                             },
  { ":lemon:",                                 "&#x1f34b;"                            },
  { ":leo:",                                   "&#x264c;"                             },
  { ":leopard:",                               "&#x1f406;"                            },
  { ":lesotho:",                               "&#x1f1f1;&#x1f1f8;"                   },
  { ":level_slider:",                          "&#x1f39a;"                            },
  { ":liberia:",                               "&#x1f1f1;&#x1f1f7;"                   },
  { ":libra:",                                 "&#x264e;"                             },
  { ":libya:",                                 "&#x1f1f1;&#x1f1fe;"                   },
  { ":liechtenstein:",                         "&#x1f1f1;&#x1f1ee;"                   },
  { ":light_rail:",                            "&#x1f688;"                            },
  { ":link:",                                  "&#x1f517;"                            },
  { ":lion:",                                  "&#x1f981;"                            },
  { ":lips:",                                  "&#x1f444;"                            },
  { ":lipstick:",                              "&#x1f484;"                            },
  { ":lithuania:",                             "&#x1f1f1;&#x1f1f9;"                   },
  { ":lizard:",                                "&#x1f98e;"                            },
  { ":lock:",                                  "&#x1f512;"                            },
  { ":lock_with_ink_pen:",                     "&#x1f50f;"                            },
  { ":lollipop:",                              "&#x1f36d;"                            },
  { ":loop:",                                  "&#x27bf;"                             },
  { ":loud_sound:",                            "&#x1f50a;"                            },
  { ":loudspeaker:",                           "&#x1f4e2;"                            },
  { ":love_hotel:",                            "&#x1f3e9;"                            },
  { ":love_letter:",                           "&#x1f48c;"                            },
  { ":low_brightness:",                        "&#x1f505;"                            },
  { ":luxembourg:",                            "&#x1f1f1;&#x1f1fa;"                   },
  { ":lying_face:",                            "&#x1f925;"                            },
  { ":m:",                                     "&#x24c2;"                             },
  { ":macau:",                                 "&#x1f1f2;&#x1f1f4;"                   },
  { ":macedonia:",                             "&#x1f1f2;&#x1f1f0;"                   },
  { ":madagascar:",                            "&#x1f1f2;&#x1f1ec;"                   },
  { ":mag:",                                   "&#x1f50d;"                            },
  { ":mag_right:",                             "&#x1f50e;"                            },
  { ":mahjong:",                               "&#x1f004;"                            },
  { ":mailbox:",                               "&#x1f4eb;"                            },
  { ":mailbox_closed:",                        "&#x1f4ea;"                            },
  { ":mailbox_with_mail:",                     "&#x1f4ec;"                            },
  { ":mailbox_with_no_mail:",                  "&#x1f4ed;"                            },
  { ":malawi:",                                "&#x1f1f2;&#x1f1fc;"                   },
  { ":malaysia:",                              "&#x1f1f2;&#x1f1fe;"                   },
  { ":maldives:",                              "&#x1f1f2;&#x1f1fb;"                   },
  { ":male_detective:",                        "&#x1f575;"                            },
  { ":mali:",                                  "&#x1f1f2;&#x1f1f1;"                   },
  { ":malta:",                                 "&#x1f1f2;&#x1f1f9;"                   },
  { ":man:",                                   "&#x1f468;"                            },
  { ":man_artist:",                            "&#x1f468;&#x1f3a8;"                   },
  { ":man_astronaut:",                         "&#x1f468;&#x1f680;"                   },
  { ":man_cartwheeling:",                      "&#x1f938;&#x2642;"                    },
  { ":man_cook:",                              "&#x1f468;&#x1f373;"                   },
  { ":man_dancing:",                           "&#x1f57a;"                            },
  { ":man_facepalming:",                       "&#x1f926;&#x2642;"                    },
  { ":man_factory_worker:",                    "&#x1f468;&#x1f3ed;"                   },
  { ":man_farmer:",                            "&#x1f468;&#x1f33e;"                   },
  { ":man_firefighter:",                       "&#x1f468;&#x1f692;"                   },
  { ":man_health_worker:",                     "&#x1f468;&#x2695;"                    },
  { ":man_in_tuxedo:",                         "&#x1f935;"                            },
  { ":man_judge:",                             "&#x1f468;&#x2696;"                    },
  { ":man_juggling:",                          "&#x1f939;&#x2642;"                    },
  { ":man_mechanic:",                          "&#x1f468;&#x1f527;"                   },
  { ":man_office_worker:",                     "&#x1f468;&#x1f4bc;"                   },
  { ":man_pilot:",                             "&#x1f468;&#x2708;"                    },
  { ":man_playing_handball:",                  "&#x1f93e;&#x2642;"                    },
  { ":man_playing_water_polo:",                "&#x1f93d;&#x2642;"                    },
  { ":man_scientist:",                         "&#x1f468;&#x1f52c;"                   },
  { ":man_shrugging:",                         "&#x1f937;&#x2642;"                    },
  { ":man_singer:",                            "&#x1f468;&#x1f3a4;"                   },
  { ":man_student:",                           "&#x1f468;&#x1f393;"                   },
  { ":man_teacher:",                           "&#x1f468;&#x1f3eb;"                   },
  { ":man_technologist:",                      "&#x1f468;&#x1f4bb;"                   },
  { ":man_with_gua_pi_mao:",                   "&#x1f472;"                            },
  { ":man_with_turban:",                       "&#x1f473;"                            },
  { ":mandarin:",                              "&#x1f34a;"                            },
  { ":mans_shoe:",                             "&#x1f45e;"                            },
  { ":mantelpiece_clock:",                     "&#x1f570;"                            },
  { ":maple_leaf:",                            "&#x1f341;"                            },
  { ":marshall_islands:",                      "&#x1f1f2;&#x1f1ed;"                   },
  { ":martial_arts_uniform:",                  "&#x1f94b;"                            },
  { ":martinique:",                            "&#x1f1f2;&#x1f1f6;"                   },
  { ":mask:",                                  "&#x1f637;"                            },
  { ":massage:",                               "&#x1f486;"                            },
  { ":massage_man:",                           "&#x1f486;&#x2642;"                    },
  { ":massage_woman:",                         "&#x1f486;"                            },
  { ":mauritania:",                            "&#x1f1f2;&#x1f1f7;"                   },
  { ":mauritius:",                             "&#x1f1f2;&#x1f1fa;"                   },
  { ":mayotte:",                               "&#x1f1fe;&#x1f1f9;"                   },
  { ":meat_on_bone:",                          "&#x1f356;"                            },
  { ":medal_military:",                        "&#x1f396;"                            },
  { ":medal_sports:",                          "&#x1f3c5;"                            },
  { ":mega:",                                  "&#x1f4e3;"                            },
  { ":melon:",                                 "&#x1f348;"                            },
  { ":memo:",                                  "&#x1f4dd;"                            },
  { ":men_wrestling:",                         "&#x1f93c;&#x2642;"                    },
  { ":menorah:",                               "&#x1f54e;"                            },
  { ":mens:",                                  "&#x1f6b9;"                            },
  { ":metal:",                                 "&#x1f918;"                            },
  { ":metro:",                                 "&#x1f687;"                            },
  { ":mexico:",                                "&#x1f1f2;&#x1f1fd;"                   },
  { ":micronesia:",                            "&#x1f1eb;&#x1f1f2;"                   },
  { ":microphone:",                            "&#x1f3a4;"                            },
  { ":microscope:",                            "&#x1f52c;"                            },
  { ":middle_finger:",                         "&#x1f595;"                            },
  { ":milk_glass:",                            "&#x1f95b;"                            },
  { ":milky_way:",                             "&#x1f30c;"                            },
  { ":minibus:",                               "&#x1f690;"                            },
  { ":minidisc:",                              "&#x1f4bd;"                            },
  { ":mobile_phone_off:",                      "&#x1f4f4;"                            },
  { ":moldova:",                               "&#x1f1f2;&#x1f1e9;"                   },
  { ":monaco:",                                "&#x1f1f2;&#x1f1e8;"                   },
  { ":money_mouth_face:",                      "&#x1f911;"                            },
  { ":money_with_wings:",                      "&#x1f4b8;"                            },
  { ":moneybag:",                              "&#x1f4b0;"                            },
  { ":mongolia:",                              "&#x1f1f2;&#x1f1f3;"                   },
  { ":monkey:",                                "&#x1f412;"                            },
  { ":monkey_face:",                           "&#x1f435;"                            },
  { ":monorail:",                              "&#x1f69d;"                            },
  { ":montenegro:",                            "&#x1f1f2;&#x1f1ea;"                   },
  { ":montserrat:",                            "&#x1f1f2;&#x1f1f8;"                   },
  { ":moon:",                                  "&#x1f314;"                            },
  { ":morocco:",                               "&#x1f1f2;&#x1f1e6;"                   },
  { ":mortar_board:",                          "&#x1f393;"                            },
  { ":mosque:",                                "&#x1f54c;"                            },
  { ":motor_boat:",                            "&#x1f6e5;"                            },
  { ":motor_scooter:",                         "&#x1f6f5;"                            },
  { ":motorcycle:",                            "&#x1f3cd;"                            },
  { ":motorway:",                              "&#x1f6e3;"                            },
  { ":mount_fuji:",                            "&#x1f5fb;"                            },
  { ":mountain:",                              "&#x26f0;"                             },
  { ":mountain_bicyclist:",                    "&#x1f6b5;"                            },
  { ":mountain_biking_man:",                   "&#x1f6b5;"                            },
  { ":mountain_biking_woman:",                 "&#x1f6b5;&#x2640;"                    },
  { ":mountain_cableway:",                     "&#x1f6a0;"                            },
  { ":mountain_railway:",                      "&#x1f69e;"                            },
  { ":mountain_snow:",                         "&#x1f3d4;"                            },
  { ":mouse:",                                 "&#x1f42d;"                            },
  { ":mouse2:",                                "&#x1f401;"                            },
  { ":movie_camera:",                          "&#x1f3a5;"                            },
  { ":moyai:",                                 "&#x1f5ff;"                            },
  { ":mozambique:",                            "&#x1f1f2;&#x1f1ff;"                   },
  { ":mrs_claus:",                             "&#x1f936;"                            },
  { ":muscle:",                                "&#x1f4aa;"                            },
  { ":mushroom:",                              "&#x1f344;"                            },
  { ":musical_keyboard:",                      "&#x1f3b9;"                            },
  { ":musical_note:",                          "&#x1f3b5;"                            },
  { ":musical_score:",                         "&#x1f3bc;"                            },
  { ":mute:",                                  "&#x1f507;"                            },
  { ":myanmar:",                               "&#x1f1f2;&#x1f1f2;"                   },
  { ":nail_care:",                             "&#x1f485;"                            },
  { ":name_badge:",                            "&#x1f4db;"                            },
  { ":namibia:",                               "&#x1f1f3;&#x1f1e6;"                   },
  { ":national_park:",                         "&#x1f3de;"                            },
  { ":nauru:",                                 "&#x1f1f3;&#x1f1f7;"                   },
  { ":nauseated_face:",                        "&#x1f922;"                            },
  { ":necktie:",                               "&#x1f454;"                            },
  { ":negative_squared_cross_mark:",           "&#x274e;"                             },
  { ":nepal:",                                 "&#x1f1f3;&#x1f1f5;"                   },
  { ":nerd_face:",                             "&#x1f913;"                            },
  { ":netherlands:",                           "&#x1f1f3;&#x1f1f1;"                   },
  { ":neutral_face:",                          "&#x1f610;"                            },
  { ":new:",                                   "&#x1f195;"                            },
  { ":new_caledonia:",                         "&#x1f1f3;&#x1f1e8;"                   },
  { ":new_moon:",                              "&#x1f311;"                            },
  { ":new_moon_with_face:",                    "&#x1f31a;"                            },
  { ":new_zealand:",                           "&#x1f1f3;&#x1f1ff;"                   },
  { ":newspaper:",                             "&#x1f4f0;"                            },
  { ":newspaper_roll:",                        "&#x1f5de;"                            },
  { ":next_track_button:",                     "&#x23ed;"                             },
  { ":ng:",                                    "&#x1f196;"                            },
  { ":ng_man:",                                "&#x1f645;&#x2642;"                    },
  { ":ng_woman:",                              "&#x1f645;"                            },
  { ":nicaragua:",                             "&#x1f1f3;&#x1f1ee;"                   },
  { ":niger:",                                 "&#x1f1f3;&#x1f1ea;"                   },
  { ":nigeria:",                               "&#x1f1f3;&#x1f1ec;"                   },
  { ":night_with_stars:",                      "&#x1f303;"                            },
  { ":nine:",                                  "&#x0039;&#x20e3;"                     },
  { ":niue:",                                  "&#x1f1f3;&#x1f1fa;"                   },
  { ":no_bell:",                               "&#x1f515;"                            },
  { ":no_bicycles:",                           "&#x1f6b3;"                            },
  { ":no_entry:",                              "&#x26d4;"                             },
  { ":no_entry_sign:",                         "&#x1f6ab;"                            },
  { ":no_good:",                               "&#x1f645;"                            },
  { ":no_good_man:",                           "&#x1f645;&#x2642;"                    },
  { ":no_good_woman:",                         "&#x1f645;"                            },
  { ":no_mobile_phones:",                      "&#x1f4f5;"                            },
  { ":no_mouth:",                              "&#x1f636;"                            },
  { ":no_pedestrians:",                        "&#x1f6b7;"                            },
  { ":no_smoking:",                            "&#x1f6ad;"                            },
  { ":non-potable_water:",                     "&#x1f6b1;"                            },
  { ":norfolk_island:",                        "&#x1f1f3;&#x1f1eb;"                   },
  { ":north_korea:",                           "&#x1f1f0;&#x1f1f5;"                   },
  { ":northern_mariana_islands:",              "&#x1f1f2;&#x1f1f5;"                   },
  { ":norway:",                                "&#x1f1f3;&#x1f1f4;"                   },
  { ":nose:",                                  "&#x1f443;"                            },
  { ":notebook:",                              "&#x1f4d3;"                            },
  { ":notebook_with_decorative_cover:",        "&#x1f4d4;"                            },
  { ":notes:",                                 "&#x1f3b6;"                            },
  { ":nut_and_bolt:",                          "&#x1f529;"                            },
  { ":o:",                                     "&#x2b55;"                             },
  { ":o2:",                                    "&#x1f17e;"                            },
  { ":ocean:",                                 "&#x1f30a;"                            },
  { ":octopus:",                               "&#x1f419;"                            },
  { ":oden:",                                  "&#x1f362;"                            },
  { ":office:",                                "&#x1f3e2;"                            },
  { ":oil_drum:",                              "&#x1f6e2;"                            },
  { ":ok:",                                    "&#x1f197;"                            },
  { ":ok_hand:",                               "&#x1f44c;"                            },
  { ":ok_man:",                                "&#x1f646;&#x2642;"                    },
  { ":ok_woman:",                              "&#x1f646;"                            },
  { ":old_key:",                               "&#x1f5dd;"                            },
  { ":older_man:",                             "&#x1f474;"                            },
  { ":older_woman:",                           "&#x1f475;"                            },
  { ":om:",                                    "&#x1f549;"                            },
  { ":oman:",                                  "&#x1f1f4;&#x1f1f2;"                   },
  { ":on:",                                    "&#x1f51b;"                            },
  { ":oncoming_automobile:",                   "&#x1f698;"                            },
  { ":oncoming_bus:",                          "&#x1f68d;"                            },
  { ":oncoming_police_car:",                   "&#x1f694;"                            },
  { ":oncoming_taxi:",                         "&#x1f696;"                            },
  { ":one:",                                   "&#x0031;&#x20e3;"                     },
  { ":open_book:",                             "&#x1f4d6;"                            },
  { ":open_file_folder:",                      "&#x1f4c2;"                            },
  { ":open_hands:",                            "&#x1f450;"                            },
  { ":open_mouth:",                            "&#x1f62e;"                            },
  { ":open_umbrella:",                         "&#x2602;"                             },
  { ":ophiuchus:",                             "&#x26ce;"                             },
  { ":orange:",                                "&#x1f34a;"                            },
  { ":orange_book:",                           "&#x1f4d9;"                            },
  { ":orthodox_cross:",                        "&#x2626;"                             },
  { ":outbox_tray:",                           "&#x1f4e4;"                            },
  { ":owl:",                                   "&#x1f989;"                            },
  { ":ox:",                                    "&#x1f402;"                            },
  { ":package:",                               "&#x1f4e6;"                            },
  { ":page_facing_up:",                        "&#x1f4c4;"                            },
  { ":page_with_curl:",                        "&#x1f4c3;"                            },
  { ":pager:",                                 "&#x1f4df;"                            },
  { ":paintbrush:",                            "&#x1f58c;"                            },
  { ":pakistan:",                              "&#x1f1f5;&#x1f1f0;"                   },
  { ":palau:",                                 "&#x1f1f5;&#x1f1fc;"                   },
  { ":palestinian_territories:",               "&#x1f1f5;&#x1f1f8;"                   },
  { ":palm_tree:",                             "&#x1f334;"                            },
  { ":panama:",                                "&#x1f1f5;&#x1f1e6;"                   },
  { ":pancakes:",                              "&#x1f95e;"                            },
  { ":panda_face:",                            "&#x1f43c;"                            },
  { ":paperclip:",                             "&#x1f4ce;"                            },
  { ":paperclips:",                            "&#x1f587;"                            },
  { ":papua_new_guinea:",                      "&#x1f1f5;&#x1f1ec;"                   },
  { ":paraguay:",                              "&#x1f1f5;&#x1f1fe;"                   },
  { ":parasol_on_ground:",                     "&#x26f1;"                             },
  { ":parking:",                               "&#x1f17f;"                            },
  { ":part_alternation_mark:",                 "&#x303d;"                             },
  { ":partly_sunny:",                          "&#x26c5;"                             },
  { ":passenger_ship:",                        "&#x1f6f3;"                            },
  { ":passport_control:",                      "&#x1f6c2;"                            },
  { ":pause_button:",                          "&#x23f8;"                             },
  { ":paw_prints:",                            "&#x1f43e;"                            },
  { ":peace_symbol:",                          "&#x262e;"                             },
  { ":peach:",                                 "&#x1f351;"                            },
  { ":peanuts:",                               "&#x1f95c;"                            },
  { ":pear:",                                  "&#x1f350;"                            },
  { ":pen:",                                   "&#x1f58a;"                            },
  { ":pencil:",                                "&#x1f4dd;"                            },
  { ":pencil2:",                               "&#x270f;"                             },
  { ":penguin:",                               "&#x1f427;"                            },
  { ":pensive:",                               "&#x1f614;"                            },
  { ":performing_arts:",                       "&#x1f3ad;"                            },
  { ":persevere:",                             "&#x1f623;"                            },
  { ":person_fencing:",                        "&#x1f93a;"                            },
  { ":person_frowning:",                       "&#x1f64d;"                            },
  { ":person_with_blond_hair:",                "&#x1f471;"                            },
  { ":person_with_pouting_face:",              "&#x1f64e;"                            },
  { ":peru:",                                  "&#x1f1f5;&#x1f1ea;"                   },
  { ":philippines:",                           "&#x1f1f5;&#x1f1ed;"                   },
  { ":phone:",                                 "&#x260e;"                             },
  { ":pick:",                                  "&#x26cf;"                             },
  { ":pig:",                                   "&#x1f437;"                            },
  { ":pig2:",                                  "&#x1f416;"                            },
  { ":pig_nose:",                              "&#x1f43d;"                            },
  { ":pill:",                                  "&#x1f48a;"                            },
  { ":pineapple:",                             "&#x1f34d;"                            },
  { ":ping_pong:",                             "&#x1f3d3;"                            },
  { ":pisces:",                                "&#x2653;"                             },
  { ":pitcairn_islands:",                      "&#x1f1f5;&#x1f1f3;"                   },
  { ":pizza:",                                 "&#x1f355;"                            },
  { ":place_of_worship:",                      "&#x1f6d0;"                            },
  { ":plate_with_cutlery:",                    "&#x1f37d;"                            },
  { ":play_or_pause_button:",                  "&#x23ef;"                             },
  { ":point_down:",                            "&#x1f447;"                            },
  { ":point_left:",                            "&#x1f448;"                            },
  { ":point_right:",                           "&#x1f449;"                            },
  { ":point_up:",                              "&#x261d;"                             },
  { ":point_up_2:",                            "&#x1f446;"                            },
  { ":poland:",                                "&#x1f1f5;&#x1f1f1;"                   },
  { ":police_car:",                            "&#x1f693;"                            },
  { ":policeman:",                             "&#x1f46e;"                            },
  { ":policewoman:",                           "&#x1f46e;&#x2640;"                    },
  { ":poodle:",                                "&#x1f429;"                            },
  { ":poop:",                                  "&#x1f4a9;"                            },
  { ":popcorn:",                               "&#x1f37f;"                            },
  { ":portugal:",                              "&#x1f1f5;&#x1f1f9;"                   },
  { ":post_office:",                           "&#x1f3e3;"                            },
  { ":postal_horn:",                           "&#x1f4ef;"                            },
  { ":postbox:",                               "&#x1f4ee;"                            },
  { ":potable_water:",                         "&#x1f6b0;"                            },
  { ":potato:",                                "&#x1f954;"                            },
  { ":pouch:",                                 "&#x1f45d;"                            },
  { ":poultry_leg:",                           "&#x1f357;"                            },
  { ":pound:",                                 "&#x1f4b7;"                            },
  { ":pout:",                                  "&#x1f621;"                            },
  { ":pouting_cat:",                           "&#x1f63e;"                            },
  { ":pouting_man:",                           "&#x1f64e;&#x2642;"                    },
  { ":pouting_woman:",                         "&#x1f64e;"                            },
  { ":pray:",                                  "&#x1f64f;"                            },
  { ":prayer_beads:",                          "&#x1f4ff;"                            },
  { ":pregnant_woman:",                        "&#x1f930;"                            },
  { ":previous_track_button:",                 "&#x23ee;"                             },
  { ":prince:",                                "&#x1f934;"                            },
  { ":princess:",                              "&#x1f478;"                            },
  { ":printer:",                               "&#x1f5a8;"                            },
  { ":puerto_rico:",                           "&#x1f1f5;&#x1f1f7;"                   },
  { ":punch:",                                 "&#x1f44a;"                            },
  { ":purple_heart:",                          "&#x1f49c;"                            },
  { ":purse:",                                 "&#x1f45b;"                            },
  { ":pushpin:",                               "&#x1f4cc;"                            },
  { ":put_litter_in_its_place:",               "&#x1f6ae;"                            },
  { ":qatar:",                                 "&#x1f1f6;&#x1f1e6;"                   },
  { ":question:",                              "&#x2753;"                             },
  { ":rabbit:",                                "&#x1f430;"                            },
  { ":rabbit2:",                               "&#x1f407;"                            },
  { ":racehorse:",                             "&#x1f40e;"                            },
  { ":racing_car:",                            "&#x1f3ce;"                            },
  { ":radio:",                                 "&#x1f4fb;"                            },
  { ":radio_button:",                          "&#x1f518;"                            },
  { ":radioactive:",                           "&#x2622;"                             },
  { ":rage:",                                  "&#x1f621;"                            },
  { ":railway_car:",                           "&#x1f683;"                            },
  { ":railway_track:",                         "&#x1f6e4;"                            },
  { ":rainbow:",                               "&#x1f308;"                            },
  { ":rainbow_flag:",                          "&#x1f3f3;&#x1f308;"                   },
  { ":raised_back_of_hand:",                   "&#x1f91a;"                            },
  { ":raised_hand:",                           "&#x270b;"                             },
  { ":raised_hand_with_fingers_splayed:",      "&#x1f590;"                            },
  { ":raised_hands:",                          "&#x1f64c;"                            },
  { ":raising_hand:",                          "&#x1f64b;"                            },
  { ":raising_hand_man:",                      "&#x1f64b;&#x2642;"                    },
  { ":raising_hand_woman:",                    "&#x1f64b;"                            },
  { ":ram:",                                   "&#x1f40f;"                            },
  { ":ramen:",                                 "&#x1f35c;"                            },
  { ":rat:",                                   "&#x1f400;"                            },
  { ":record_button:",                         "&#x23fa;"                             },
  { ":recycle:",                               "&#x267b;"                             },
  { ":red_car:",                               "&#x1f697;"                            },
  { ":red_circle:",                            "&#x1f534;"                            },
  { ":registered:",                            "&#x00ae;"                             },
  { ":relaxed:",                               "&#x263a;"                             },
  { ":relieved:",                              "&#x1f60c;"                            },
  { ":reminder_ribbon:",                       "&#x1f397;"                            },
  { ":repeat:",                                "&#x1f501;"                            },
  { ":repeat_one:",                            "&#x1f502;"                            },
  { ":rescue_worker_helmet:",                  "&#x26d1;"                             },
  { ":restroom:",                              "&#x1f6bb;"                            },
  { ":reunion:",                               "&#x1f1f7;&#x1f1ea;"                   },
  { ":revolving_hearts:",                      "&#x1f49e;"                            },
  { ":rewind:",                                "&#x23ea;"                             },
  { ":rhinoceros:",                            "&#x1f98f;"                            },
  { ":ribbon:",                                "&#x1f380;"                            },
  { ":rice:",                                  "&#x1f35a;"                            },
  { ":rice_ball:",                             "&#x1f359;"                            },
  { ":rice_cracker:",                          "&#x1f358;"                            },
  { ":rice_scene:",                            "&#x1f391;"                            },
  { ":right_anger_bubble:",                    "&#x1f5ef;"                            },
  { ":ring:",                                  "&#x1f48d;"                            },
  { ":robot:",                                 "&#x1f916;"                            },
  { ":rocket:",                                "&#x1f680;"                            },
  { ":rofl:",                                  "&#x1f923;"                            },
  { ":roll_eyes:",                             "&#x1f644;"                            },
  { ":roller_coaster:",                        "&#x1f3a2;"                            },
  { ":romania:",                               "&#x1f1f7;&#x1f1f4;"                   },
  { ":rooster:",                               "&#x1f413;"                            },
  { ":rose:",                                  "&#x1f339;"                            },
  { ":rosette:",                               "&#x1f3f5;"                            },
  { ":rotating_light:",                        "&#x1f6a8;"                            },
  { ":round_pushpin:",                         "&#x1f4cd;"                            },
  { ":rowboat:",                               "&#x1f6a3;"                            },
  { ":rowing_man:",                            "&#x1f6a3;"                            },
  { ":rowing_woman:",                          "&#x1f6a3;&#x2640;"                    },
  { ":ru:",                                    "&#x1f1f7;&#x1f1fa;"                   },
  { ":rugby_football:",                        "&#x1f3c9;"                            },
  { ":runner:",                                "&#x1f3c3;"                            },
  { ":running:",                               "&#x1f3c3;"                            },
  { ":running_man:",                           "&#x1f3c3;"                            },
  { ":running_shirt_with_sash:",               "&#x1f3bd;"                            },
  { ":running_woman:",                         "&#x1f3c3;&#x2640;"                    },
  { ":rwanda:",                                "&#x1f1f7;&#x1f1fc;"                   },
  { ":sa:",                                    "&#x1f202;"                            },
  { ":sagittarius:",                           "&#x2650;"                             },
  { ":sailboat:",                              "&#x26f5;"                             },
  { ":sake:",                                  "&#x1f376;"                            },
  { ":samoa:",                                 "&#x1f1fc;&#x1f1f8;"                   },
  { ":san_marino:",                            "&#x1f1f8;&#x1f1f2;"                   },
  { ":sandal:",                                "&#x1f461;"                            },
  { ":santa:",                                 "&#x1f385;"                            },
  { ":sao_tome_principe:",                     "&#x1f1f8;&#x1f1f9;"                   },
  { ":satellite:",                             "&#x1f4e1;"                            },
  { ":satisfied:",                             "&#x1f606;"                            },
  { ":saudi_arabia:",                          "&#x1f1f8;&#x1f1e6;"                   },
  { ":saxophone:",                             "&#x1f3b7;"                            },
  { ":school:",                                "&#x1f3eb;"                            },
  { ":school_satchel:",                        "&#x1f392;"                            },
  { ":scissors:",                              "&#x2702;"                             },
  { ":scorpion:",                              "&#x1f982;"                            },
  { ":scorpius:",                              "&#x264f;"                             },
  { ":scream:",                                "&#x1f631;"                            },
  { ":scream_cat:",                            "&#x1f640;"                            },
  { ":scroll:",                                "&#x1f4dc;"                            },
  { ":seat:",                                  "&#x1f4ba;"                            },
  { ":secret:",                                "&#x3299;"                             },
  { ":see_no_evil:",                           "&#x1f648;"                            },
  { ":seedling:",                              "&#x1f331;"                            },
  { ":selfie:",                                "&#x1f933;"                            },
  { ":senegal:",                               "&#x1f1f8;&#x1f1f3;"                   },
  { ":serbia:",                                "&#x1f1f7;&#x1f1f8;"                   },
  { ":seven:",                                 "&#x0037;&#x20e3;"                     },
  { ":seychelles:",                            "&#x1f1f8;&#x1f1e8;"                   },
  { ":shallow_pan_of_food:",                   "&#x1f958;"                            },
  { ":shamrock:",                              "&#x2618;"                             },
  { ":shark:",                                 "&#x1f988;"                            },
  { ":shaved_ice:",                            "&#x1f367;"                            },
  { ":sheep:",                                 "&#x1f411;"                            },
  { ":shell:",                                 "&#x1f41a;"                            },
  { ":shield:",                                "&#x1f6e1;"                            },
  { ":shinto_shrine:",                         "&#x26e9;"                             },
  { ":ship:",                                  "&#x1f6a2;"                            },
  { ":shirt:",                                 "&#x1f455;"                            },
  { ":shit:",                                  "&#x1f4a9;"                            },
  { ":shoe:",                                  "&#x1f45e;"                            },
  { ":shopping:",                              "&#x1f6cd;"                            },
  { ":shopping_cart:",                         "&#x1f6d2;"                            },
  { ":shower:",                                "&#x1f6bf;"                            },
  { ":shrimp:",                                "&#x1f990;"                            },
  { ":sierra_leone:",                          "&#x1f1f8;&#x1f1f1;"                   },
  { ":signal_strength:",                       "&#x1f4f6;"                            },
  { ":singapore:",                             "&#x1f1f8;&#x1f1ec;"                   },
  { ":sint_maarten:",                          "&#x1f1f8;&#x1f1fd;"                   },
  { ":six:",                                   "&#x0036;&#x20e3;"                     },
  { ":six_pointed_star:",                      "&#x1f52f;"                            },
  { ":ski:",                                   "&#x1f3bf;"                            },
  { ":skier:",                                 "&#x26f7;"                             },
  { ":skull:",                                 "&#x1f480;"                            },
  { ":skull_and_crossbones:",                  "&#x2620;"                             },
  { ":sleeping:",                              "&#x1f634;"                            },
  { ":sleeping_bed:",                          "&#x1f6cc;"                            },
  { ":sleepy:",                                "&#x1f62a;"                            },
  { ":slightly_frowning_face:",                "&#x1f641;"                            },
  { ":slightly_smiling_face:",                 "&#x1f642;"                            },
  { ":slot_machine:",                          "&#x1f3b0;"                            },
  { ":slovakia:",                              "&#x1f1f8;&#x1f1f0;"                   },
  { ":slovenia:",                              "&#x1f1f8;&#x1f1ee;"                   },
  { ":small_airplane:",                        "&#x1f6e9;"                            },
  { ":small_blue_diamond:",                    "&#x1f539;"                            },
  { ":small_orange_diamond:",                  "&#x1f538;"                            },
  { ":small_red_triangle:",                    "&#x1f53a;"                            },
  { ":small_red_triangle_down:",               "&#x1f53b;"                            },
  { ":smile:",                                 "&#x1f604;"                            },
  { ":smile_cat:",                             "&#x1f638;"                            },
  { ":smiley:",                                "&#x1f603;"                            },
  { ":smiley_cat:",                            "&#x1f63a;"                            },
  { ":smiling_imp:",                           "&#x1f608;"                            },
  { ":smirk:",                                 "&#x1f60f;"                            },
  { ":smirk_cat:",                             "&#x1f63c;"                            },
  { ":smoking:",                               "&#x1f6ac;"                            },
  { ":snail:",                                 "&#x1f40c;"                            },
  { ":snake:",                                 "&#x1f40d;"                            },
  { ":sneezing_face:",                         "&#x1f927;"                            },
  { ":snowboarder:",                           "&#x1f3c2;"                            },
  { ":snowflake:",                             "&#x2744;"                             },
  { ":snowman:",                               "&#x26c4;"                             },
  { ":snowman_with_snow:",                     "&#x2603;"                             },
  { ":sob:",                                   "&#x1f62d;"                            },
  { ":soccer:",                                "&#x26bd;"                             },
  { ":solomon_islands:",                       "&#x1f1f8;&#x1f1e7;"                   },
  { ":somalia:",                               "&#x1f1f8;&#x1f1f4;"                   },
  { ":soon:",                                  "&#x1f51c;"                            },
  { ":sos:",                                   "&#x1f198;"                            },
  { ":sound:",                                 "&#x1f509;"                            },
  { ":south_africa:",                          "&#x1f1ff;&#x1f1e6;"                   },
  { ":south_georgia_south_sandwich_islands:",  "&#x1f1ec;&#x1f1f8;"                   },
  { ":south_sudan:",                           "&#x1f1f8;&#x1f1f8;"                   },
  { ":space_invader:",                         "&#x1f47e;"                            },
  { ":spades:",                                "&#x2660;"                             },
  { ":spaghetti:",                             "&#x1f35d;"                            },
  { ":sparkle:",                               "&#x2747;"                             },
  { ":sparkler:",                              "&#x1f387;"                            },
  { ":sparkles:",                              "&#x2728;"                             },
  { ":sparkling_heart:",                       "&#x1f496;"                            },
  { ":speak_no_evil:",                         "&#x1f64a;"                            },
  { ":speaker:",                               "&#x1f508;"                            },
  { ":speaking_head:",                         "&#x1f5e3;"                            },
  { ":speech_balloon:",                        "&#x1f4ac;"                            },
  { ":speedboat:",                             "&#x1f6a4;"                            },
  { ":spider:",                                "&#x1f577;"                            },
  { ":spider_web:",                            "&#x1f578;"                            },
  { ":spiral_calendar:",                       "&#x1f5d3;"                            },
  { ":spiral_notepad:",                        "&#x1f5d2;"                            },
  { ":spoon:",                                 "&#x1f944;"                            },
  { ":squid:",                                 "&#x1f991;"                            },
  { ":sri_lanka:",                             "&#x1f1f1;&#x1f1f0;"                   },
  { ":st_barthelemy:",                         "&#x1f1e7;&#x1f1f1;"                   },
  { ":st_helena:",                             "&#x1f1f8;&#x1f1ed;"                   },
  { ":st_kitts_nevis:",                        "&#x1f1f0;&#x1f1f3;"                   },
  { ":st_lucia:",                              "&#x1f1f1;&#x1f1e8;"                   },
  { ":st_pierre_miquelon:",                    "&#x1f1f5;&#x1f1f2;"                   },
  { ":st_vincent_grenadines:",                 "&#x1f1fb;&#x1f1e8;"                   },
  { ":stadium:",                               "&#x1f3df;"                            },
  { ":star:",                                  "&#x2b50;"                             },
  { ":star2:",                                 "&#x1f31f;"                            },
  { ":star_and_crescent:",                     "&#x262a;"                             },
  { ":star_of_david:",                         "&#x2721;"                             },
  { ":stars:",                                 "&#x1f320;"                            },
  { ":station:",                               "&#x1f689;"                            },
  { ":statue_of_liberty:",                     "&#x1f5fd;"                            },
  { ":steam_locomotive:",                      "&#x1f682;"                            },
  { ":stew:",                                  "&#x1f372;"                            },
  { ":stop_button:",                           "&#x23f9;"                             },
  { ":stop_sign:",                             "&#x1f6d1;"                            },
  { ":stopwatch:",                             "&#x23f1;"                             },
  { ":straight_ruler:",                        "&#x1f4cf;"                            },
  { ":strawberry:",                            "&#x1f353;"                            },
  { ":stuck_out_tongue:",                      "&#x1f61b;"                            },
  { ":stuck_out_tongue_closed_eyes:",          "&#x1f61d;"                            },
  { ":stuck_out_tongue_winking_eye:",          "&#x1f61c;"                            },
  { ":studio_microphone:",                     "&#x1f399;"                            },
  { ":stuffed_flatbread:",                     "&#x1f959;"                            },
  { ":sudan:",                                 "&#x1f1f8;&#x1f1e9;"                   },
  { ":sun_behind_large_cloud:",                "&#x1f325;"                            },
  { ":sun_behind_rain_cloud:",                 "&#x1f326;"                            },
  { ":sun_behind_small_cloud:",                "&#x1f324;"                            },
  { ":sun_with_face:",                         "&#x1f31e;"                            },
  { ":sunflower:",                             "&#x1f33b;"                            },
  { ":sunglasses:",                            "&#x1f60e;"                            },
  { ":sunny:",                                 "&#x2600;"                             },
  { ":sunrise:",                               "&#x1f305;"                            },
  { ":sunrise_over_mountains:",                "&#x1f304;"                            },
  { ":surfer:",                                "&#x1f3c4;"                            },
  { ":surfing_man:",                           "&#x1f3c4;"                            },
  { ":surfing_woman:",                         "&#x1f3c4;&#x2640;"                    },
  { ":suriname:",                              "&#x1f1f8;&#x1f1f7;"                   },
  { ":sushi:",                                 "&#x1f363;"                            },
  { ":suspension_railway:",                    "&#x1f69f;"                            },
  { ":swaziland:",                             "&#x1f1f8;&#x1f1ff;"                   },
  { ":sweat:",                                 "&#x1f613;"                            },
  { ":sweat_drops:",                           "&#x1f4a6;"                            },
  { ":sweat_smile:",                           "&#x1f605;"                            },
  { ":sweden:",                                "&#x1f1f8;&#x1f1ea;"                   },
  { ":sweet_potato:",                          "&#x1f360;"                            },
  { ":swimmer:",                               "&#x1f3ca;"                            },
  { ":swimming_man:",                          "&#x1f3ca;"                            },
  { ":swimming_woman:",                        "&#x1f3ca;&#x2640;"                    },
  { ":switzerland:",                           "&#x1f1e8;&#x1f1ed;"                   },
  { ":symbols:",                               "&#x1f523;"                            },
  { ":synagogue:",                             "&#x1f54d;"                            },
  { ":syria:",                                 "&#x1f1f8;&#x1f1fe;"                   },
  { ":syringe:",                               "&#x1f489;"                            },
  { ":taco:",                                  "&#x1f32e;"                            },
  { ":tada:",                                  "&#x1f389;"                            },
  { ":taiwan:",                                "&#x1f1f9;&#x1f1fc;"                   },
  { ":tajikistan:",                            "&#x1f1f9;&#x1f1ef;"                   },
  { ":tanabata_tree:",                         "&#x1f38b;"                            },
  { ":tangerine:",                             "&#x1f34a;"                            },
  { ":tanzania:",                              "&#x1f1f9;&#x1f1ff;"                   },
  { ":taurus:",                                "&#x2649;"                             },
  { ":taxi:",                                  "&#x1f695;"                            },
  { ":tea:",                                   "&#x1f375;"                            },
  { ":telephone:",                             "&#x260e;"                             },
  { ":telephone_receiver:",                    "&#x1f4de;"                            },
  { ":telescope:",                             "&#x1f52d;"                            },
  { ":tennis:",                                "&#x1f3be;"                            },
  { ":tent:",                                  "&#x26fa;"                             },
  { ":thailand:",                              "&#x1f1f9;&#x1f1ed;"                   },
  { ":thermometer:",                           "&#x1f321;"                            },
  { ":thinking:",                              "&#x1f914;"                            },
  { ":thought_balloon:",                       "&#x1f4ad;"                            },
  { ":three:",                                 "&#x0033;&#x20e3;"                     },
  { ":thumbsdown:",                            "&#x1f44e;"                            },
  { ":thumbsup:",                              "&#x1f44d;"                            },
  { ":ticket:",                                "&#x1f3ab;"                            },
  { ":tickets:",                               "&#x1f39f;"                            },
  { ":tiger:",                                 "&#x1f42f;"                            },
  { ":tiger2:",                                "&#x1f405;"                            },
  { ":timer_clock:",                           "&#x23f2;"                             },
  { ":timor_leste:",                           "&#x1f1f9;&#x1f1f1;"                   },
  { ":tipping_hand_man:",                      "&#x1f481;&#x2642;"                    },
  { ":tipping_hand_woman:",                    "&#x1f481;"                            },
  { ":tired_face:",                            "&#x1f62b;"                            },
  { ":tm:",                                    "&#x2122;"                             },
  { ":togo:",                                  "&#x1f1f9;&#x1f1ec;"                   },
  { ":toilet:",                                "&#x1f6bd;"                            },
  { ":tokelau:",                               "&#x1f1f9;&#x1f1f0;"                   },
  { ":tokyo_tower:",                           "&#x1f5fc;"                            },
  { ":tomato:",                                "&#x1f345;"                            },
  { ":tonga:",                                 "&#x1f1f9;&#x1f1f4;"                   },
  { ":tongue:",                                "&#x1f445;"                            },
  { ":top:",                                   "&#x1f51d;"                            },
  { ":tophat:",                                "&#x1f3a9;"                            },
  { ":tornado:",                               "&#x1f32a;"                            },
  { ":tr:",                                    "&#x1f1f9;&#x1f1f7;"                   },
  { ":trackball:",                             "&#x1f5b2;"                            },
  { ":tractor:",                               "&#x1f69c;"                            },
  { ":traffic_light:",                         "&#x1f6a5;"                            },
  { ":train:",                                 "&#x1f68b;"                            },
  { ":train2:",                                "&#x1f686;"                            },
  { ":tram:",                                  "&#x1f68a;"                            },
  { ":triangular_flag_on_post:",               "&#x1f6a9;"                            },
  { ":triangular_ruler:",                      "&#x1f4d0;"                            },
  { ":trident:",                               "&#x1f531;"                            },
  { ":trinidad_tobago:",                       "&#x1f1f9;&#x1f1f9;"                   },
  { ":triumph:",                               "&#x1f624;"                            },
  { ":trolleybus:",                            "&#x1f68e;"                            },
  { ":trophy:",                                "&#x1f3c6;"                            },
  { ":tropical_drink:",                        "&#x1f379;"                            },
  { ":tropical_fish:",                         "&#x1f420;"                            },
  { ":truck:",                                 "&#x1f69a;"                            },
  { ":trumpet:",                               "&#x1f3ba;"                            },
  { ":tshirt:",                                "&#x1f455;"                            },
  { ":tulip:",                                 "&#x1f337;"                            },
  { ":tumbler_glass:",                         "&#x1f943;"                            },
  { ":tunisia:",                               "&#x1f1f9;&#x1f1f3;"                   },
  { ":turkey:",                                "&#x1f983;"                            },
  { ":turkmenistan:",                          "&#x1f1f9;&#x1f1f2;"                   },
  { ":turks_caicos_islands:",                  "&#x1f1f9;&#x1f1e8;"                   },
  { ":turtle:",                                "&#x1f422;"                            },
  { ":tuvalu:",                                "&#x1f1f9;&#x1f1fb;"                   },
  { ":tv:",                                    "&#x1f4fa;"                            },
  { ":twisted_rightwards_arrows:",             "&#x1f500;"                            },
  { ":two:",                                   "&#x0032;&#x20e3;"                     },
  { ":two_hearts:",                            "&#x1f495;"                            },
  { ":two_men_holding_hands:",                 "&#x1f46c;"                            },
  { ":two_women_holding_hands:",               "&#x1f46d;"                            },
  { ":u5272:",                                 "&#x1f239;"                            },
  { ":u5408:",                                 "&#x1f234;"                            },
  { ":u55b6:",                                 "&#x1f23a;"                            },
  { ":u6307:",                                 "&#x1f22f;"                            },
  { ":u6708:",                                 "&#x1f237;"                            },
  { ":u6709:",                                 "&#x1f236;"                            },
  { ":u6e80:",                                 "&#x1f235;"                            },
  { ":u7121:",                                 "&#x1f21a;"                            },
  { ":u7533:",                                 "&#x1f238;"                            },
  { ":u7981:",                                 "&#x1f232;"                            },
  { ":u7a7a:",                                 "&#x1f233;"                            },
  { ":uganda:",                                "&#x1f1fa;&#x1f1ec;"                   },
  { ":uk:",                                    "&#x1f1ec;&#x1f1e7;"                   },
  { ":ukraine:",                               "&#x1f1fa;&#x1f1e6;"                   },
  { ":umbrella:",                              "&#x2614;"                             },
  { ":unamused:",                              "&#x1f612;"                            },
  { ":underage:",                              "&#x1f51e;"                            },
  { ":unicorn:",                               "&#x1f984;"                            },
  { ":united_arab_emirates:",                  "&#x1f1e6;&#x1f1ea;"                   },
  { ":unlock:",                                "&#x1f513;"                            },
  { ":up:",                                    "&#x1f199;"                            },
  { ":upside_down_face:",                      "&#x1f643;"                            },
  { ":uruguay:",                               "&#x1f1fa;&#x1f1fe;"                   },
  { ":us:",                                    "&#x1f1fa;&#x1f1f8;"                   },
  { ":us_virgin_islands:",                     "&#x1f1fb;&#x1f1ee;"                   },
  { ":uzbekistan:",                            "&#x1f1fa;&#x1f1ff;"                   },
  { ":v:",                                     "&#x270c;"                             },
  { ":vanuatu:",                               "&#x1f1fb;&#x1f1fa;"                   },
  { ":vatican_city:",                          "&#x1f1fb;&#x1f1e6;"                   },
  { ":venezuela:",                             "&#x1f1fb;&#x1f1ea;"                   },
  { ":vertical_traffic_light:",                "&#x1f6a6;"                            },
  { ":vhs:",                                   "&#x1f4fc;"                            },
  { ":vibration_mode:",                        "&#x1f4f3;"                            },
  { ":video_camera:",                          "&#x1f4f9;"                            },
  { ":video_game:",                            "&#x1f3ae;"                            },
  { ":vietnam:",                               "&#x1f1fb;&#x1f1f3;"                   },
  { ":violin:",                                "&#x1f3bb;"                            },
  { ":virgo:",                                 "&#x264d;"                             },
  { ":volcano:",                               "&#x1f30b;"                            },
  { ":volleyball:",                            "&#x1f3d0;"                            },
  { ":vs:",                                    "&#x1f19a;"                            },
  { ":vulcan_salute:",                         "&#x1f596;"                            },
  { ":walking:",                               "&#x1f6b6;"                            },
  { ":walking_man:",                           "&#x1f6b6;"                            },
  { ":walking_woman:",                         "&#x1f6b6;&#x2640;"                    },
  { ":wallis_futuna:",                         "&#x1f1fc;&#x1f1eb;"                   },
  { ":waning_crescent_moon:",                  "&#x1f318;"                            },
  { ":waning_gibbous_moon:",                   "&#x1f316;"                            },
  { ":warning:",                               "&#x26a0;"                             },
  { ":wastebasket:",                           "&#x1f5d1;"                            },
  { ":watch:",                                 "&#x231a;"                             },
  { ":water_buffalo:",                         "&#x1f403;"                            },
  { ":watermelon:",                            "&#x1f349;"                            },
  { ":wave:",                                  "&#x1f44b;"                            },
  { ":wavy_dash:",                             "&#x3030;"                             },
  { ":waxing_crescent_moon:",                  "&#x1f312;"                            },
  { ":waxing_gibbous_moon:",                   "&#x1f314;"                            },
  { ":wc:",                                    "&#x1f6be;"                            },
  { ":weary:",                                 "&#x1f629;"                            },
  { ":wedding:",                               "&#x1f492;"                            },
  { ":weight_lifting_man:",                    "&#x1f3cb;"                            },
  { ":weight_lifting_woman:",                  "&#x1f3cb;&#x2640;"                    },
  { ":western_sahara:",                        "&#x1f1ea;&#x1f1ed;"                   },
  { ":whale:",                                 "&#x1f433;"                            },
  { ":whale2:",                                "&#x1f40b;"                            },
  { ":wheel_of_dharma:",                       "&#x2638;"                             },
  { ":wheelchair:",                            "&#x267f;"                             },
  { ":white_check_mark:",                      "&#x2705;"                             },
  { ":white_circle:",                          "&#x26aa;"                             },
  { ":white_flag:",                            "&#x1f3f3;"                            },
  { ":white_flower:",                          "&#x1f4ae;"                            },
  { ":white_large_square:",                    "&#x2b1c;"                             },
  { ":white_medium_small_square:",             "&#x25fd;"                             },
  { ":white_medium_square:",                   "&#x25fb;"                             },
  { ":white_small_square:",                    "&#x25ab;"                             },
  { ":white_square_button:",                   "&#x1f533;"                            },
  { ":wilted_flower:",                         "&#x1f940;"                            },
  { ":wind_chime:",                            "&#x1f390;"                            },
  { ":wind_face:",                             "&#x1f32c;"                            },
  { ":wine_glass:",                            "&#x1f377;"                            },
  { ":wink:",                                  "&#x1f609;"                            },
  { ":wolf:",                                  "&#x1f43a;"                            },
  { ":woman:",                                 "&#x1f469;"                            },
  { ":woman_artist:",                          "&#x1f469;&#x1f3a8;"                   },
  { ":woman_astronaut:",                       "&#x1f469;&#x1f680;"                   },
  { ":woman_cartwheeling:",                    "&#x1f938;&#x2640;"                    },
  { ":woman_cook:",                            "&#x1f469;&#x1f373;"                   },
  { ":woman_facepalming:",                     "&#x1f926;&#x2640;"                    },
  { ":woman_factory_worker:",                  "&#x1f469;&#x1f3ed;"                   },
  { ":woman_farmer:",                          "&#x1f469;&#x1f33e;"                   },
  { ":woman_firefighter:",                     "&#x1f469;&#x1f692;"                   },
  { ":woman_health_worker:",                   "&#x1f469;&#x2695;"                    },
  { ":woman_judge:",                           "&#x1f469;&#x2696;"                    },
  { ":woman_juggling:",                        "&#x1f939;&#x2640;"                    },
  { ":woman_mechanic:",                        "&#x1f469;&#x1f527;"                   },
  { ":woman_office_worker:",                   "&#x1f469;&#x1f4bc;"                   },
  { ":woman_pilot:",                           "&#x1f469;&#x2708;"                    },
  { ":woman_playing_handball:",                "&#x1f93e;&#x2640;"                    },
  { ":woman_playing_water_polo:",              "&#x1f93d;&#x2640;"                    },
  { ":woman_scientist:",                       "&#x1f469;&#x1f52c;"                   },
  { ":woman_shrugging:",                       "&#x1f937;&#x2640;"                    },
  { ":woman_singer:",                          "&#x1f469;&#x1f3a4;"                   },
  { ":woman_student:",                         "&#x1f469;&#x1f393;"                   },
  { ":woman_teacher:",                         "&#x1f469;&#x1f3eb;"                   },
  { ":woman_technologist:",                    "&#x1f469;&#x1f4bb;"                   },
  { ":woman_with_turban:",                     "&#x1f473;&#x2640;"                    },
  { ":womans_clothes:",                        "&#x1f45a;"                            },
  { ":womans_hat:",                            "&#x1f452;"                            },
  { ":women_wrestling:",                       "&#x1f93c;&#x2640;"                    },
  { ":womens:",                                "&#x1f6ba;"                            },
  { ":world_map:",                             "&#x1f5fa;"                            },
  { ":worried:",                               "&#x1f61f;"                            },
  { ":wrench:",                                "&#x1f527;"                            },
  { ":writing_hand:",                          "&#x270d;"                             },
  { ":x:",                                     "&#x274c;"                             },
  { ":yellow_heart:",                          "&#x1f49b;"                            },
  { ":yemen:",                                 "&#x1f1fe;&#x1f1ea;"                   },
  { ":yen:",                                   "&#x1f4b4;"                            },
  { ":yin_yang:",                              "&#x262f;"                             },
  { ":yum:",                                   "&#x1f60b;"                            },
  { ":zambia:",                                "&#x1f1ff;&#x1f1f2;"                   },
  { ":zap:",                                   "&#x26a1;"                             },
  { ":zero:",                                  "&#x0030;&#x20e3;"                     },
  { ":zimbabwe:",                              "&#x1f1ff;&#x1f1fc;"                   },
  { ":zipper_mouth_face:",                     "&#x1f910;"                            },
  { ":zzz:",                                   "&#x1f4a4;"                            }
};

static const int g_numEmojiEntities = (int)(sizeof(g_emojiEntities)/sizeof(*g_emojiEntities));

EmojiEntityMapper *EmojiEntityMapper::s_instance = 0;

EmojiEntityMapper::EmojiEntityMapper()
{
  // 2 loops to be able to give precedence to the unicodeName (CLDR)
  for (int i = 0; i < g_numEmojiEntities; i++)
  {
    m_name2symGh.insert(std::make_pair(g_emojiEntities[i].name, i));
  }
}

EmojiEntityMapper::~EmojiEntityMapper()
{
}

/** Returns the one and only instance of the Emoji entity mapper */
EmojiEntityMapper *EmojiEntityMapper::instance()
{
  if (s_instance==0)
  {
    s_instance = new EmojiEntityMapper;
  }
  return s_instance;
}

/** Deletes the one and only instance of the Emoji entity mapper */
void EmojiEntityMapper::deleteInstance()
{
  delete s_instance;
  s_instance=0;
}

/*!
 * @brief Returns a code for the requested Emoji entity name
 * @param symName Emoji entity name
 * @return the code for the requested Emoji entity name,
 *         in case the requested Emoji item does not exist `-1` is returned.
 */
int EmojiEntityMapper::symbol2index(const std::string &symName) const
{
  auto it = m_name2symGh.find(symName);
  return it!=m_name2symGh.end() ? it->second : -1;
}

/*!
 * @brief Writes the list of supported emojis to the given file.
 */
void EmojiEntityMapper::writeEmojiFile(TextStream &t)
{
  for (int i = 0; i < g_numEmojiEntities; i++)
  {
    t << g_emojiEntities[i].name << "\n";
  }
}

/*! @brief Access routine to the unicode sequence for the Emoji entity
 *
 * @param index code of the requested Emoji entity returned by symbol2index()
 * @return the unicode sequence of the Emoji entity,
 */
const char *EmojiEntityMapper::unicode(int index) const
{
  return index>=0 && index<g_numEmojiEntities ? g_emojiEntities[index].unicode : 0;
}

/*! @brief Access routine to the name of the Emoji entity
 *
 * @param index code of the requested Emoji entity returned by symbol2index()
 * @return the name of the Emoji entity in GitHub format (i.e. :smile:)
 */
const char *EmojiEntityMapper::name(int index) const
{
  return index>=0 && index<g_numEmojiEntities ? g_emojiEntities[index].name : 0;
}


