/* Operation.c generated by valac 0.30.0, the Vala compiler
 * generated from Operation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define DEJA_DUP_TYPE_OPERATION (deja_dup_operation_get_type ())
#define DEJA_DUP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperation))
#define DEJA_DUP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))
#define DEJA_DUP_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))

typedef struct _DejaDupOperation DejaDupOperation;
typedef struct _DejaDupOperationClass DejaDupOperationClass;
typedef struct _DejaDupOperationPrivate DejaDupOperationPrivate;

#define DEJA_DUP_TYPE_TOOL_JOB (deja_dup_tool_job_get_type ())
#define DEJA_DUP_TOOL_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_TOOL_JOB, DejaDupToolJob))
#define DEJA_DUP_TOOL_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_TOOL_JOB, DejaDupToolJobClass))
#define DEJA_DUP_IS_TOOL_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_TOOL_JOB))
#define DEJA_DUP_IS_TOOL_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_TOOL_JOB))
#define DEJA_DUP_TOOL_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_TOOL_JOB, DejaDupToolJobClass))

typedef struct _DejaDupToolJob DejaDupToolJob;
typedef struct _DejaDupToolJobClass DejaDupToolJobClass;

#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;

#define DEJA_DUP_TOOL_JOB_TYPE_MODE (deja_dup_tool_job_mode_get_type ())

#define DEJA_DUP_TYPE_FILTERED_SETTINGS (deja_dup_filtered_settings_get_type ())
#define DEJA_DUP_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettings))
#define DEJA_DUP_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))
#define DEJA_DUP_IS_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_IS_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_FILTERED_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))

typedef struct _DejaDupFilteredSettings DejaDupFilteredSettings;
typedef struct _DejaDupFilteredSettingsClass DejaDupFilteredSettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_OPERATION_TYPE_STATE (deja_dup_operation_state_get_type ())
#define DEJA_DUP_OPERATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_OPERATION_TYPE_STATE, DejaDupOperationState))
#define DEJA_DUP_OPERATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_OPERATION_TYPE_STATE, DejaDupOperationStateClass))
#define DEJA_DUP_OPERATION_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_OPERATION_TYPE_STATE))
#define DEJA_DUP_OPERATION_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_OPERATION_TYPE_STATE))
#define DEJA_DUP_OPERATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_OPERATION_TYPE_STATE, DejaDupOperationStateClass))

typedef struct _DejaDupOperationState DejaDupOperationState;
typedef struct _DejaDupOperationStateClass DejaDupOperationStateClass;
typedef struct _DejaDupOperationStatePrivate DejaDupOperationStatePrivate;
#define _deja_dup_operation_state_unref0(var) ((var == NULL) ? NULL : (var = (deja_dup_operation_state_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DEJA_DUP_TYPE_BACKEND_AUTO (deja_dup_backend_auto_get_type ())
#define DEJA_DUP_BACKEND_AUTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_AUTO, DejaDupBackendAuto))
#define DEJA_DUP_BACKEND_AUTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_AUTO, DejaDupBackendAutoClass))
#define DEJA_DUP_IS_BACKEND_AUTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_AUTO))
#define DEJA_DUP_IS_BACKEND_AUTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_AUTO))
#define DEJA_DUP_BACKEND_AUTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_AUTO, DejaDupBackendAutoClass))

typedef struct _DejaDupBackendAuto DejaDupBackendAuto;
typedef struct _DejaDupBackendAutoClass DejaDupBackendAutoClass;
typedef struct _DejaDupOperationStartData DejaDupOperationStartData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _DejaDupOperationOperationFinishedData DejaDupOperationOperationFinishedData;
typedef struct _Block4Data Block4Data;
typedef struct _DejaDupOperationChainOpData DejaDupOperationChainOpData;
typedef struct _Block5Data Block5Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

#define DEJA_DUP_TOOL_JOB_TYPE_FLAGS (deja_dup_tool_job_flags_get_type ())
typedef struct _DejaDupOperationParamSpecState DejaDupOperationParamSpecState;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DejaDupOperation {
	GObject parent_instance;
	DejaDupOperationPrivate * priv;
	DejaDupToolJob* job;
	gchar* passphrase;
};

struct _DejaDupOperationClass {
	GObjectClass parent_class;
	void (*start) (DejaDupOperation* self, gboolean try_claim_bus, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*start_finish) (DejaDupOperation* self, GAsyncResult* _res_);
	void (*connect_to_job) (DejaDupOperation* self);
	void (*send_action_file_changed) (DejaDupOperation* self, GFile* file, gboolean actual);
	void (*operation_finished) (DejaDupOperation* self, DejaDupToolJob* job, gboolean success, gboolean cancelled, const gchar* detail, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*operation_finished_finish) (DejaDupOperation* self, GAsyncResult* _res_);
	GList* (*make_argv) (DejaDupOperation* self);
};

typedef enum  {
	DEJA_DUP_TOOL_JOB_MODE_INVALID,
	DEJA_DUP_TOOL_JOB_MODE_BACKUP,
	DEJA_DUP_TOOL_JOB_MODE_RESTORE,
	DEJA_DUP_TOOL_JOB_MODE_STATUS,
	DEJA_DUP_TOOL_JOB_MODE_LIST,
	DEJA_DUP_TOOL_JOB_MODE_HISTORY
} DejaDupToolJobMode;

struct _DejaDupOperationPrivate {
	gboolean _use_cached_password;
	gboolean _needs_password;
	DejaDupBackend* _backend;
	DejaDupToolJobMode _mode;
	DejaDupFilteredSettings* settings;
	gboolean finished;
	gchar* saved_detail;
	DejaDupOperation* chained_op;
	guint bus_id;
};

struct _DejaDupOperationState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DejaDupOperationStatePrivate * priv;
	DejaDupBackend* backend;
	gchar* passphrase;
};

struct _DejaDupOperationStateClass {
	GTypeClass parent_class;
	void (*finalize) (DejaDupOperationState *self);
};

typedef enum  {
	DEJA_DUP_BACKUP_ERROR_BAD_CONFIG,
	DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING
} DejaDupBackupError;
#define DEJA_DUP_BACKUP_ERROR deja_dup_backup_error_quark ()
struct _DejaDupOperationStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperation* self;
	gboolean try_claim_bus;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	GError* e;
	GError* _tmp2_;
	const gchar* _tmp3_;
	DejaDupBackend* _tmp4_;
	DejaDupFilteredSettings* _tmp5_;
	DejaDupFilteredSettings* _tmp6_;
	GError * _inner_error_;
};

struct _DejaDupOperationOperationFinishedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperation* self;
	DejaDupToolJob* job;
	gboolean success;
	gboolean cancelled;
	gchar* detail;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
};

struct _Block4Data {
	int _ref_count_;
	DejaDupOperation* self;
	DejaDupOperation* subop;
	gpointer _async_data_;
};

struct _DejaDupOperationChainOpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperation* self;
	DejaDupOperation* subop;
	gchar* desc;
	gchar* detail;
	Block4Data* _data4_;
	DejaDupOperation* _tmp0_;
	DejaDupOperation* _tmp1_;
	DejaDupOperation* _tmp2_;
	DejaDupOperation* _tmp3_;
	DejaDupOperation* _tmp4_;
	DejaDupOperation* _tmp5_;
	DejaDupOperation* _tmp6_;
	DejaDupOperation* _tmp7_;
	DejaDupOperation* _tmp8_;
	DejaDupOperation* _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	DejaDupOperation* _tmp14_;
	DejaDupOperationState* _tmp15_;
	DejaDupOperationState* _tmp16_;
	const gchar* _tmp17_;
	DejaDupOperation* _tmp18_;
};

struct _Block5Data {
	int _ref_count_;
	DejaDupOperation* self;
	gboolean rv;
	GMainLoop* loop;
};

typedef enum  {
	DEJA_DUP_TOOL_JOB_FLAGS_NO_PROGRESS,
	DEJA_DUP_TOOL_JOB_FLAGS_NO_CACHE
} DejaDupToolJobFlags;

struct _DejaDupOperationParamSpecState {
	GParamSpec parent_instance;
};


static gpointer deja_dup_operation_parent_class = NULL;
static gpointer deja_dup_operation_state_parent_class = NULL;

GType deja_dup_operation_get_type (void) G_GNUC_CONST;
GType deja_dup_tool_job_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_tool_job_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_filtered_settings_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_OPERATION, DejaDupOperationPrivate))
enum  {
	DEJA_DUP_OPERATION_DUMMY_PROPERTY,
	DEJA_DUP_OPERATION_USE_CACHED_PASSWORD,
	DEJA_DUP_OPERATION_NEEDS_PASSWORD,
	DEJA_DUP_OPERATION_BACKEND,
	DEJA_DUP_OPERATION_USE_PROGRESS,
	DEJA_DUP_OPERATION_MODE
};
gchar* deja_dup_operation_mode_to_string (DejaDupToolJobMode mode);
gpointer deja_dup_operation_state_ref (gpointer instance);
void deja_dup_operation_state_unref (gpointer instance);
GParamSpec* deja_dup_operation_param_spec_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void deja_dup_operation_value_set_state (GValue* value, gpointer v_object);
void deja_dup_operation_value_take_state (GValue* value, gpointer v_object);
gpointer deja_dup_operation_value_get_state (const GValue* value);
GType deja_dup_operation_state_get_type (void) G_GNUC_CONST;
DejaDupOperationState* deja_dup_operation_get_state (DejaDupOperation* self);
DejaDupOperationState* deja_dup_operation_state_new (void);
DejaDupOperationState* deja_dup_operation_state_construct (GType object_type);
DejaDupBackend* deja_dup_operation_get_backend (DejaDupOperation* self);
void deja_dup_operation_set_state (DejaDupOperation* self, DejaDupOperationState* state);
static void deja_dup_operation_set_backend (DejaDupOperation* self, DejaDupBackend* value);
void deja_dup_operation_set_passphrase (DejaDupOperation* self, const gchar* passphrase);
static void deja_dup_operation_real_start_data_free (gpointer _data);
static void deja_dup_operation_real_start (DejaDupOperation* self, gboolean try_claim_bus, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_start (DejaDupOperation* self, gboolean try_claim_bus, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_start_finish (DejaDupOperation* self, GAsyncResult* _res_);
static gboolean deja_dup_operation_real_start_co (DejaDupOperationStartData* _data_);
GQuark deja_dup_backup_error_quark (void);
static void deja_dup_operation_claim_bus (DejaDupOperation* self, GError** error);
void deja_dup_network_ensure_status (GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_network_ensure_status_finish (GAsyncResult* _res_);
static void deja_dup_operation_start_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType deja_dup_backend_auto_get_type (void) G_GNUC_CONST;
DejaDupFilteredSettings* deja_dup_get_settings (const gchar* subdir);
static void deja_dup_operation_restart (DejaDupOperation* self);
static void _deja_dup_operation_restart_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void deja_dup_tool_job_stop (DejaDupToolJob* self);
DejaDupToolJob* deja_dup_make_tool_job (GError** error);
DejaDupToolJobMode deja_dup_operation_get_mode (DejaDupOperation* self);
void deja_dup_tool_job_set_mode (DejaDupToolJob* self, DejaDupToolJobMode value);
void deja_dup_tool_job_set_backend (DejaDupToolJob* self, DejaDupBackend* value);
GList* deja_dup_operation_make_argv (DejaDupOperation* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void deja_dup_operation_connect_to_job (DejaDupOperation* self);
gboolean deja_dup_operation_get_needs_password (DejaDupOperation* self);
void deja_dup_operation_set_needs_password (DejaDupOperation* self, gboolean value);
void deja_dup_tool_job_set_encrypt_password (DejaDupToolJob* self, const gchar* value);
void deja_dup_tool_job_start (DejaDupToolJob* self);
void deja_dup_operation_cancel (DejaDupOperation* self);
void deja_dup_tool_job_cancel (DejaDupToolJob* self);
void deja_dup_operation_stop (DejaDupOperation* self);
static void deja_dup_operation_real_connect_to_job (DejaDupOperation* self);
static void __lambda14_ (DejaDupOperation* self, DejaDupToolJob* d, gboolean o, gboolean c, const gchar* detail);
void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupToolJob* job, gboolean success, gboolean cancelled, const gchar* detail, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_operation_finished_finish (DejaDupOperation* self, GAsyncResult* _res_);
static void ___lambda14__deja_dup_tool_job_done (DejaDupToolJob* _sender, gboolean success, gboolean cancelled, const gchar* detail, gpointer self);
static void __lambda15_ (DejaDupOperation* self, DejaDupToolJob* d, const gchar* s, const gchar* detail);
static void ___lambda15__deja_dup_tool_job_raise_error (DejaDupToolJob* _sender, const gchar* errstr, const gchar* detail, gpointer self);
static void __lambda16_ (DejaDupOperation* self, DejaDupToolJob* d, const gchar* s);
static void ___lambda16__deja_dup_tool_job_action_desc_changed (DejaDupToolJob* _sender, const gchar* action, gpointer self);
static void __lambda17_ (DejaDupOperation* self, DejaDupToolJob* d, GFile* f, gboolean b);
void deja_dup_operation_send_action_file_changed (DejaDupOperation* self, GFile* file, gboolean actual);
static void ___lambda17__deja_dup_tool_job_action_file_changed (DejaDupToolJob* _sender, GFile* file, gboolean actual, gpointer self);
static void __lambda18_ (DejaDupOperation* self, DejaDupToolJob* d, gdouble p);
static void ___lambda18__deja_dup_tool_job_progress (DejaDupToolJob* _sender, gdouble percent, gpointer self);
static void __lambda19_ (DejaDupOperation* self, DejaDupToolJob* d, const gchar* t, const gchar* m);
static void ___lambda19__deja_dup_tool_job_question (DejaDupToolJob* _sender, const gchar* title, const gchar* msg, gpointer self);
static void __lambda20_ (DejaDupOperation* self, gboolean first);
static void ___lambda20__deja_dup_tool_job_is_full (DejaDupToolJob* _sender, gboolean first, gpointer self);
static void __lambda21_ (DejaDupOperation* self);
static void ___lambda21__deja_dup_tool_job_bad_encryption_password (DejaDupToolJob* _sender, gpointer self);
static void deja_dup_operation_real_send_action_file_changed (DejaDupOperation* self, GFile* file, gboolean actual);
static void deja_dup_operation_real_operation_finished_data_free (gpointer _data);
static void deja_dup_operation_real_operation_finished (DejaDupOperation* self, DejaDupToolJob* job, gboolean success, gboolean cancelled, const gchar* detail, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_operation_real_operation_finished_co (DejaDupOperationOperationFinishedData* _data_);
static void deja_dup_operation_unclaim_bus (DejaDupOperation* self);
void deja_dup_clean_tempdirs (GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_clean_tempdirs_finish (GAsyncResult* _res_);
static void deja_dup_operation_operation_finished_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GList* deja_dup_operation_real_make_argv (DejaDupOperation* self);
static gchar* deja_dup_operation_combine_details (const gchar* old_detail, const gchar* new_detail);
static void deja_dup_operation_chain_op_data_free (gpointer _data);
void deja_dup_operation_chain_op (DejaDupOperation* self, DejaDupOperation* subop, const gchar* desc, const gchar* detail, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_chain_op_finish (DejaDupOperation* self, GAsyncResult* _res_);
static gboolean deja_dup_operation_chain_op_co (DejaDupOperationChainOpData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda22_ (DejaDupOperation* self, gboolean s, gboolean c, const gchar* d);
static void ___lambda22__deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, const gchar* detail, gpointer self);
static void __lambda23_ (DejaDupOperation* self, const gchar* e, const gchar* d);
static void ___lambda23__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self);
static void __lambda24_ (DejaDupOperation* self, gdouble p);
static void ___lambda24__deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self);
static void __lambda25_ (Block4Data* _data4_);
static void ___lambda25__deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static void __lambda26_ (DejaDupOperation* self, const gchar* t, const gchar* m);
static void ___lambda26__deja_dup_operation_question (DejaDupOperation* _sender, const gchar* title, const gchar* msg, gpointer self);
gboolean deja_dup_operation_get_use_cached_password (DejaDupOperation* self);
void deja_dup_operation_set_use_cached_password (DejaDupOperation* self, gboolean value);
static void deja_dup_operation_chain_op_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda11_ (DejaDupOperation* self);
static void ___lambda11__gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda12_ (Block5Data* _data5_);
static void ___lambda12__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda13_ (Block5Data* _data5_);
static void ___lambda13__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
DejaDupOperation* deja_dup_operation_construct (GType object_type);
gboolean deja_dup_operation_get_use_progress (DejaDupOperation* self);
GType deja_dup_tool_job_flags_get_type (void) G_GNUC_CONST;
DejaDupToolJobFlags deja_dup_tool_job_get_flags (DejaDupToolJob* self);
void deja_dup_operation_set_use_progress (DejaDupOperation* self, gboolean value);
void deja_dup_tool_job_set_flags (DejaDupToolJob* self, DejaDupToolJobFlags value);
static void deja_dup_operation_set_mode (DejaDupOperation* self, DejaDupToolJobMode value);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * deja_dup_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
DejaDupBackend* deja_dup_backend_get_default (void);
enum  {
	DEJA_DUP_OPERATION_STATE_DUMMY_PROPERTY
};
static void deja_dup_operation_state_finalize (DejaDupOperationState* obj);
static void deja_dup_operation_finalize (GObject* obj);
static void _vala_deja_dup_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gchar* deja_dup_operation_mode_to_string (DejaDupToolJobMode mode) {
	gchar* result = NULL;
	DejaDupToolJobMode _tmp0_ = 0;
	_tmp0_ = mode;
	switch (_tmp0_) {
		case DEJA_DUP_TOOL_JOB_MODE_BACKUP:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
			_tmp1_ = _ ("Backing up…");
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case DEJA_DUP_TOOL_JOB_MODE_RESTORE:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			_tmp3_ = _ ("Restoring…");
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case DEJA_DUP_TOOL_JOB_MODE_STATUS:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp5_ = _ ("Checking for backups…");
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case DEJA_DUP_TOOL_JOB_MODE_LIST:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			_tmp7_ = _ ("Listing files…");
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
		default:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp9_ = _ ("Preparing…");
			_tmp10_ = g_strdup (_tmp9_);
			result = _tmp10_;
			return result;
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DejaDupOperationState* deja_dup_operation_get_state (DejaDupOperation* self) {
	DejaDupOperationState* result = NULL;
	DejaDupOperationState* rv = NULL;
	DejaDupOperationState* _tmp0_ = NULL;
	DejaDupBackend* _tmp1_ = NULL;
	DejaDupBackend* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_operation_state_new ();
	rv = _tmp0_;
	_tmp1_ = self->priv->_backend;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (rv->backend);
	rv->backend = _tmp2_;
	_tmp3_ = self->passphrase;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (rv->passphrase);
	rv->passphrase = _tmp4_;
	result = rv;
	return result;
}


void deja_dup_operation_set_state (DejaDupOperation* self, DejaDupOperationState* state) {
	DejaDupOperationState* _tmp0_ = NULL;
	DejaDupBackend* _tmp1_ = NULL;
	DejaDupOperationState* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	_tmp0_ = state;
	_tmp1_ = _tmp0_->backend;
	deja_dup_operation_set_backend (self, _tmp1_);
	_tmp2_ = state;
	_tmp3_ = _tmp2_->passphrase;
	deja_dup_operation_set_passphrase (self, _tmp3_);
}


static void deja_dup_operation_real_start_data_free (gpointer _data) {
	DejaDupOperationStartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupOperationStartData, _data_);
}


static void deja_dup_operation_real_start (DejaDupOperation* self, gboolean try_claim_bus, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationStartData* _data_;
	DejaDupOperation* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_data_ = g_slice_new0 (DejaDupOperationStartData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_real_start);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_real_start_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = try_claim_bus;
	_data_->try_claim_bus = _tmp1_;
	deja_dup_operation_real_start_co (_data_);
}


static void deja_dup_operation_real_start_finish (DejaDupOperation* self, GAsyncResult* _res_) {
	DejaDupOperationStartData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_operation_start_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupOperationStartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_operation_real_start_co (_data_);
}


static void _deja_dup_operation_restart_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	deja_dup_operation_restart ((DejaDupOperation*) self);
}


static gboolean deja_dup_operation_real_start_co (DejaDupOperationStartData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Preparing…");
	g_signal_emit_by_name (_data_->self, "action-desc-changed", _data_->_tmp0_);
	{
		_data_->_tmp1_ = FALSE;
		_data_->_tmp1_ = _data_->try_claim_bus;
		if (_data_->_tmp1_) {
			deja_dup_operation_claim_bus (_data_->self, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch31_g_error;
			}
		}
	}
	goto __finally31;
	__catch31_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_signal_emit_by_name (_data_->self, "raise-error", _data_->_tmp3_, NULL);
		g_signal_emit_by_name (_data_->self, "done", FALSE, FALSE, NULL);
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally31:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_state_ = 1;
	deja_dup_network_ensure_status (deja_dup_operation_start_ready, _data_);
	return FALSE;
	_state_1:
	deja_dup_network_ensure_status_finish (_data_->_res_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->_backend;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp4_, DEJA_DUP_TYPE_BACKEND_AUTO)) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = deja_dup_get_settings (NULL);
		_g_object_unref0 (_data_->self->priv->settings);
		_data_->self->priv->settings = _data_->_tmp5_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->priv->settings;
		g_signal_connect_object ((GObject*) _data_->_tmp6_, "notify::backend", (GCallback) _deja_dup_operation_restart_g_object_notify, _data_->self, 0);
	} else {
		deja_dup_operation_restart (_data_->self);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void deja_dup_operation_start (DejaDupOperation* self, gboolean try_claim_bus, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->start (self, try_claim_bus, _callback_, _user_data_);
}


void deja_dup_operation_start_finish (DejaDupOperation* self, GAsyncResult* _res_) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->start_finish (self, _res_);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void deja_dup_operation_restart (DejaDupOperation* self) {
	DejaDupFilteredSettings* _tmp0_ = NULL;
	DejaDupToolJob* _tmp4_ = NULL;
	DejaDupToolJob* _tmp12_ = NULL;
	DejaDupToolJobMode _tmp13_ = 0;
	DejaDupToolJob* _tmp14_ = NULL;
	DejaDupBackend* _tmp15_ = NULL;
	GList* _tmp16_ = NULL;
	GList* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (_tmp0_ != NULL) {
		DejaDupFilteredSettings* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		GQuark _tmp3_ = 0U;
		_tmp1_ = self->priv->settings;
		g_signal_parse_name ("notify::backend", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _deja_dup_operation_restart_g_object_notify, self);
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = NULL;
	}
	_tmp4_ = self->job;
	if (_tmp4_ != NULL) {
		DejaDupToolJob* _tmp5_ = NULL;
		DejaDupToolJob* _tmp6_ = NULL;
		_tmp5_ = self->job;
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
		_tmp6_ = self->job;
		deja_dup_tool_job_stop (_tmp6_);
		_g_object_unref0 (self->job);
		self->job = NULL;
	}
	{
		DejaDupToolJob* _tmp7_ = NULL;
		DejaDupToolJob* _tmp8_ = NULL;
		DejaDupToolJob* _tmp9_ = NULL;
		_tmp8_ = deja_dup_make_tool_job (&_inner_error_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch32_g_error;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (self->job);
		self->job = _tmp9_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_signal_emit_by_name (self, "raise-error", _tmp11_, NULL);
		g_signal_emit_by_name (self, "done", FALSE, FALSE, NULL);
		_g_error_free0 (e);
		return;
	}
	__finally32:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp12_ = self->job;
	_tmp13_ = self->priv->_mode;
	deja_dup_tool_job_set_mode (_tmp12_, _tmp13_);
	_tmp14_ = self->job;
	_tmp15_ = self->priv->_backend;
	deja_dup_tool_job_set_backend (_tmp14_, _tmp15_);
	_tmp16_ = deja_dup_operation_make_argv (self);
	_tmp17_ = _tmp16_;
	__g_list_free__g_free0_0 (_tmp17_);
	deja_dup_operation_connect_to_job (self);
	g_object_ref ((GObject*) self);
	_tmp19_ = self->priv->_needs_password;
	if (_tmp19_) {
		const gchar* _tmp20_ = NULL;
		_tmp20_ = self->passphrase;
		_tmp18_ = _tmp20_ == NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		deja_dup_operation_set_needs_password (self, TRUE);
		g_signal_emit_by_name (self, "passphrase-required");
	} else {
		DejaDupToolJob* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		_tmp21_ = self->job;
		_tmp22_ = self->passphrase;
		deja_dup_tool_job_set_encrypt_password (_tmp21_, _tmp22_);
	}
	_tmp23_ = self->priv->finished;
	if (!_tmp23_) {
		DejaDupToolJob* _tmp24_ = NULL;
		_tmp24_ = self->job;
		deja_dup_tool_job_start (_tmp24_);
	}
	g_object_unref ((GObject*) self);
}


void deja_dup_operation_cancel (DejaDupOperation* self) {
	DejaDupOperation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->chained_op;
	if (_tmp0_ != NULL) {
		DejaDupOperation* _tmp1_ = NULL;
		_tmp1_ = self->priv->chained_op;
		deja_dup_operation_cancel (_tmp1_);
	} else {
		DejaDupToolJob* _tmp2_ = NULL;
		_tmp2_ = self->job;
		deja_dup_tool_job_cancel (_tmp2_);
	}
}


void deja_dup_operation_stop (DejaDupOperation* self) {
	DejaDupOperation* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->chained_op;
	if (_tmp0_ != NULL) {
		DejaDupOperation* _tmp1_ = NULL;
		_tmp1_ = self->priv->chained_op;
		deja_dup_operation_stop (_tmp1_);
	} else {
		DejaDupToolJob* _tmp2_ = NULL;
		_tmp2_ = self->job;
		deja_dup_tool_job_stop (_tmp2_);
	}
}


static void __lambda14_ (DejaDupOperation* self, DejaDupToolJob* d, gboolean o, gboolean c, const gchar* detail) {
	DejaDupToolJob* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (d != NULL);
	_tmp0_ = d;
	_tmp1_ = o;
	_tmp2_ = c;
	_tmp3_ = detail;
	deja_dup_operation_operation_finished (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL, NULL);
}


static void ___lambda14__deja_dup_tool_job_done (DejaDupToolJob* _sender, gboolean success, gboolean cancelled, const gchar* detail, gpointer self) {
	__lambda14_ ((DejaDupOperation*) self, _sender, success, cancelled, detail);
}


static void __lambda15_ (DejaDupOperation* self, DejaDupToolJob* d, const gchar* s, const gchar* detail) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (d != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = detail;
	g_signal_emit_by_name (self, "raise-error", _tmp0_, _tmp1_);
}


static void ___lambda15__deja_dup_tool_job_raise_error (DejaDupToolJob* _sender, const gchar* errstr, const gchar* detail, gpointer self) {
	__lambda15_ ((DejaDupOperation*) self, _sender, errstr, detail);
}


static void __lambda16_ (DejaDupOperation* self, DejaDupToolJob* d, const gchar* s) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (d != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	g_signal_emit_by_name (self, "action-desc-changed", _tmp0_);
}


static void ___lambda16__deja_dup_tool_job_action_desc_changed (DejaDupToolJob* _sender, const gchar* action, gpointer self) {
	__lambda16_ ((DejaDupOperation*) self, _sender, action);
}


static void __lambda17_ (DejaDupOperation* self, DejaDupToolJob* d, GFile* f, gboolean b) {
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (d != NULL);
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	_tmp1_ = b;
	deja_dup_operation_send_action_file_changed (self, _tmp0_, _tmp1_);
}


static void ___lambda17__deja_dup_tool_job_action_file_changed (DejaDupToolJob* _sender, GFile* file, gboolean actual, gpointer self) {
	__lambda17_ ((DejaDupOperation*) self, _sender, file, actual);
}


static void __lambda18_ (DejaDupOperation* self, DejaDupToolJob* d, gdouble p) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (d != NULL);
	_tmp0_ = p;
	g_signal_emit_by_name (self, "progress", _tmp0_);
}


static void ___lambda18__deja_dup_tool_job_progress (DejaDupToolJob* _sender, gdouble percent, gpointer self) {
	__lambda18_ ((DejaDupOperation*) self, _sender, percent);
}


static void __lambda19_ (DejaDupOperation* self, DejaDupToolJob* d, const gchar* t, const gchar* m) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (d != NULL);
	g_return_if_fail (t != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = t;
	_tmp1_ = m;
	g_signal_emit_by_name (self, "question", _tmp0_, _tmp1_);
}


static void ___lambda19__deja_dup_tool_job_question (DejaDupToolJob* _sender, const gchar* title, const gchar* msg, gpointer self) {
	__lambda19_ ((DejaDupOperation*) self, _sender, title, msg);
}


static void __lambda20_ (DejaDupOperation* self, gboolean first) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = first;
	g_signal_emit_by_name (self, "is-full", _tmp0_);
}


static void ___lambda20__deja_dup_tool_job_is_full (DejaDupToolJob* _sender, gboolean first, gpointer self) {
	__lambda20_ ((DejaDupOperation*) self, first);
}


static void __lambda21_ (DejaDupOperation* self) {
	deja_dup_operation_set_needs_password (self, TRUE);
	_g_free0 (self->passphrase);
	self->passphrase = NULL;
	deja_dup_operation_restart (self);
}


static void ___lambda21__deja_dup_tool_job_bad_encryption_password (DejaDupToolJob* _sender, gpointer self) {
	__lambda21_ ((DejaDupOperation*) self);
}


static void deja_dup_operation_real_connect_to_job (DejaDupOperation* self) {
	DejaDupToolJob* _tmp0_ = NULL;
	DejaDupToolJob* _tmp1_ = NULL;
	DejaDupToolJob* _tmp2_ = NULL;
	DejaDupToolJob* _tmp3_ = NULL;
	DejaDupToolJob* _tmp4_ = NULL;
	DejaDupToolJob* _tmp5_ = NULL;
	DejaDupToolJob* _tmp6_ = NULL;
	DejaDupToolJob* _tmp7_ = NULL;
	_tmp0_ = self->job;
	g_signal_connect_object (_tmp0_, "done", (GCallback) ___lambda14__deja_dup_tool_job_done, self, 0);
	_tmp1_ = self->job;
	g_signal_connect_object (_tmp1_, "raise-error", (GCallback) ___lambda15__deja_dup_tool_job_raise_error, self, 0);
	_tmp2_ = self->job;
	g_signal_connect_object (_tmp2_, "action-desc-changed", (GCallback) ___lambda16__deja_dup_tool_job_action_desc_changed, self, 0);
	_tmp3_ = self->job;
	g_signal_connect_object (_tmp3_, "action-file-changed", (GCallback) ___lambda17__deja_dup_tool_job_action_file_changed, self, 0);
	_tmp4_ = self->job;
	g_signal_connect_object (_tmp4_, "progress", (GCallback) ___lambda18__deja_dup_tool_job_progress, self, 0);
	_tmp5_ = self->job;
	g_signal_connect_object (_tmp5_, "question", (GCallback) ___lambda19__deja_dup_tool_job_question, self, 0);
	_tmp6_ = self->job;
	g_signal_connect_object (_tmp6_, "is-full", (GCallback) ___lambda20__deja_dup_tool_job_is_full, self, 0);
	_tmp7_ = self->job;
	g_signal_connect_object (_tmp7_, "bad-encryption-password", (GCallback) ___lambda21__deja_dup_tool_job_bad_encryption_password, self, 0);
}


void deja_dup_operation_connect_to_job (DejaDupOperation* self) {
	g_return_if_fail (self != NULL);
	DEJA_DUP_OPERATION_GET_CLASS (self)->connect_to_job (self);
}


static void deja_dup_operation_real_send_action_file_changed (DejaDupOperation* self, GFile* file, gboolean actual) {
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = actual;
	g_signal_emit_by_name (self, "action-file-changed", _tmp0_, _tmp1_);
}


void deja_dup_operation_send_action_file_changed (DejaDupOperation* self, GFile* file, gboolean actual) {
	g_return_if_fail (self != NULL);
	DEJA_DUP_OPERATION_GET_CLASS (self)->send_action_file_changed (self, file, actual);
}


void deja_dup_operation_set_passphrase (DejaDupOperation* self, const gchar* passphrase) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	DejaDupToolJob* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	deja_dup_operation_set_needs_password (self, FALSE);
	_tmp0_ = passphrase;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->passphrase);
	self->passphrase = _tmp1_;
	_tmp2_ = self->job;
	if (_tmp2_ != NULL) {
		DejaDupToolJob* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = self->job;
		_tmp4_ = passphrase;
		deja_dup_tool_job_set_encrypt_password (_tmp3_, _tmp4_);
	}
}


static void deja_dup_operation_real_operation_finished_data_free (gpointer _data) {
	DejaDupOperationOperationFinishedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->job);
	_g_free0 (_data_->detail);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupOperationOperationFinishedData, _data_);
}


static void deja_dup_operation_real_operation_finished (DejaDupOperation* self, DejaDupToolJob* job, gboolean success, gboolean cancelled, const gchar* detail, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationOperationFinishedData* _data_;
	DejaDupOperation* _tmp0_ = NULL;
	DejaDupToolJob* _tmp1_ = NULL;
	DejaDupToolJob* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_data_ = g_slice_new0 (DejaDupOperationOperationFinishedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_real_operation_finished);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_real_operation_finished_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = job;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->job);
	_data_->job = _tmp2_;
	_tmp3_ = success;
	_data_->success = _tmp3_;
	_tmp4_ = cancelled;
	_data_->cancelled = _tmp4_;
	_tmp5_ = detail;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->detail);
	_data_->detail = _tmp6_;
	deja_dup_operation_real_operation_finished_co (_data_);
}


static void deja_dup_operation_real_operation_finished_finish (DejaDupOperation* self, GAsyncResult* _res_) {
	DejaDupOperationOperationFinishedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_operation_operation_finished_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupOperationOperationFinishedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_operation_real_operation_finished_co (_data_);
}


static gboolean deja_dup_operation_real_operation_finished_co (DejaDupOperationOperationFinishedData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->finished = TRUE;
	deja_dup_operation_unclaim_bus (_data_->self);
	_data_->_state_ = 1;
	deja_dup_clean_tempdirs (deja_dup_operation_operation_finished_ready, _data_);
	return FALSE;
	_state_1:
	deja_dup_clean_tempdirs_finish (_data_->_res_);
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->success;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->cancelled;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->detail;
	g_signal_emit_by_name (_data_->self, "done", _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupToolJob* job, gboolean success, gboolean cancelled, const gchar* detail, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->operation_finished (self, job, success, cancelled, detail, _callback_, _user_data_);
}


void deja_dup_operation_operation_finished_finish (DejaDupOperation* self, GAsyncResult* _res_) {
	DEJA_DUP_OPERATION_GET_CLASS (self)->operation_finished_finish (self, _res_);
}


static GList* deja_dup_operation_real_make_argv (DejaDupOperation* self) {
	GList* result = NULL;
	result = NULL;
	return result;
}


GList* deja_dup_operation_make_argv (DejaDupOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return DEJA_DUP_OPERATION_GET_CLASS (self)->make_argv (self);
}


static gchar* deja_dup_operation_combine_details (const gchar* old_detail, const gchar* new_detail) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = old_detail;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = new_detail;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = new_detail;
		if (_tmp3_ == NULL) {
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			_tmp4_ = old_detail;
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		} else {
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp6_ = old_detail;
			_tmp7_ = g_strconcat (_tmp6_, "\n\n", NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = new_detail;
			_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp8_);
			result = _tmp11_;
			return result;
		}
	}
}


static void deja_dup_operation_chain_op_data_free (gpointer _data) {
	DejaDupOperationChainOpData* _data_;
	_data_ = _data;
	_g_free0 (_data_->desc);
	_g_free0 (_data_->detail);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupOperationChainOpData, _data_);
}


void deja_dup_operation_chain_op (DejaDupOperation* self, DejaDupOperation* subop, const gchar* desc, const gchar* detail, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationChainOpData* _data_;
	DejaDupOperation* _tmp0_ = NULL;
	DejaDupOperation* _tmp1_ = NULL;
	DejaDupOperation* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_data_ = g_slice_new0 (DejaDupOperationChainOpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_chain_op);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_chain_op_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = subop;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->subop);
	_data_->subop = _tmp2_;
	_tmp3_ = desc;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->desc);
	_data_->desc = _tmp4_;
	_tmp5_ = detail;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->detail);
	_data_->detail = _tmp6_;
	deja_dup_operation_chain_op_co (_data_);
}


void deja_dup_operation_chain_op_finish (DejaDupOperation* self, GAsyncResult* _res_) {
	DejaDupOperationChainOpData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		DejaDupOperation* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->subop);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda22_ (DejaDupOperation* self, gboolean s, gboolean c, const gchar* d) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	_tmp0_ = s;
	_tmp1_ = c;
	_tmp2_ = self->priv->saved_detail;
	_tmp3_ = d;
	_tmp4_ = deja_dup_operation_combine_details (_tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_emit_by_name (self, "done", _tmp0_, _tmp1_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_object_unref0 (self->priv->chained_op);
	self->priv->chained_op = NULL;
}


static void ___lambda22__deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, const gchar* detail, gpointer self) {
	__lambda22_ ((DejaDupOperation*) self, success, cancelled, detail);
}


static void __lambda23_ (DejaDupOperation* self, const gchar* e, const gchar* d) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	_tmp1_ = d;
	g_signal_emit_by_name (self, "raise-error", _tmp0_, _tmp1_);
}


static void ___lambda23__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self) {
	__lambda23_ ((DejaDupOperation*) self, errstr, detail);
}


static void __lambda24_ (DejaDupOperation* self, gdouble p) {
	gdouble _tmp0_ = 0.0;
	_tmp0_ = p;
	g_signal_emit_by_name (self, "progress", _tmp0_);
}


static void ___lambda24__deja_dup_operation_progress (DejaDupOperation* _sender, gdouble percent, gpointer self) {
	__lambda24_ ((DejaDupOperation*) self, percent);
}


static void __lambda25_ (Block4Data* _data4_) {
	DejaDupOperation* self;
	gboolean _tmp0_ = FALSE;
	self = _data4_->self;
	deja_dup_operation_set_needs_password (self, TRUE);
	g_signal_emit_by_name (self, "passphrase-required");
	_tmp0_ = self->priv->_needs_password;
	if (!_tmp0_) {
		DejaDupOperation* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = _data4_->subop;
		_tmp2_ = self->passphrase;
		deja_dup_operation_set_passphrase (_tmp1_, _tmp2_);
	}
}


static void ___lambda25__deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	__lambda25_ (self);
}


static void __lambda26_ (DejaDupOperation* self, const gchar* t, const gchar* m) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (t != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = t;
	_tmp1_ = m;
	g_signal_emit_by_name (self, "question", _tmp0_, _tmp1_);
}


static void ___lambda26__deja_dup_operation_question (DejaDupOperation* _sender, const gchar* title, const gchar* msg, gpointer self) {
	__lambda26_ ((DejaDupOperation*) self, title, msg);
}


static void deja_dup_operation_chain_op_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupOperationChainOpData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_operation_chain_op_co (_data_);
}


static gboolean deja_dup_operation_chain_op_co (DejaDupOperationChainOpData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->subop;
	_g_object_unref0 (_data_->_data4_->subop);
	_data_->_data4_->subop = _data_->_tmp0_;
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->chained_op;
	_vala_assert (_data_->_tmp1_ == NULL, "chained_op == null");
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_data4_->subop;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_g_object_unref0 (_data_->self->priv->chained_op);
	_data_->self->priv->chained_op = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_data4_->subop;
	g_signal_connect_object (_data_->_tmp4_, "done", (GCallback) ___lambda22__deja_dup_operation_done, _data_->self, 0);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_data4_->subop;
	g_signal_connect_object (_data_->_tmp5_, "raise-error", (GCallback) ___lambda23__deja_dup_operation_raise_error, _data_->self, 0);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_data4_->subop;
	g_signal_connect_object (_data_->_tmp6_, "progress", (GCallback) ___lambda24__deja_dup_operation_progress, _data_->self, 0);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_data4_->subop;
	g_signal_connect_data (_data_->_tmp7_, "passphrase-required", (GCallback) ___lambda25__deja_dup_operation_passphrase_required, block4_data_ref (_data_->_data4_), (GClosureNotify) block4_data_unref, 0);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_data4_->subop;
	g_signal_connect_object (_data_->_tmp8_, "question", (GCallback) ___lambda26__deja_dup_operation_question, _data_->self, 0);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_data4_->subop;
	_data_->_tmp10_ = FALSE;
	_data_->_tmp10_ = _data_->_tmp9_->priv->_use_cached_password;
	deja_dup_operation_set_use_cached_password (_data_->self, _data_->_tmp10_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->self->priv->saved_detail;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->detail;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = deja_dup_operation_combine_details (_data_->_tmp11_, _data_->_tmp12_);
	_g_free0 (_data_->self->priv->saved_detail);
	_data_->self->priv->saved_detail = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_data4_->subop;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = deja_dup_operation_get_state (_data_->self);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->_tmp15_;
	deja_dup_operation_set_state (_data_->_tmp14_, _data_->_tmp16_);
	_deja_dup_operation_state_unref0 (_data_->_tmp16_);
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->desc;
	g_signal_emit_by_name (_data_->self, "action-desc-changed", _data_->_tmp17_);
	g_signal_emit_by_name (_data_->self, "progress", (gdouble) 0);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->_data4_->subop;
	_data_->_state_ = 1;
	deja_dup_operation_start (_data_->_tmp18_, FALSE, deja_dup_operation_chain_op_ready, _data_);
	return FALSE;
	_state_1:
	deja_dup_operation_start_finish (_data_->_tmp18_, _data_->_res_);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		DejaDupOperation* self;
		self = _data5_->self;
		_g_main_loop_unref0 (_data5_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda11_ (DejaDupOperation* self) {
}


static void ___lambda11__gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda11_ ((DejaDupOperation*) self);
}


static void __lambda12_ (Block5Data* _data5_) {
	DejaDupOperation* self;
	GMainLoop* _tmp0_ = NULL;
	self = _data5_->self;
	_data5_->rv = TRUE;
	_tmp0_ = _data5_->loop;
	g_main_loop_quit (_tmp0_);
}


static void ___lambda12__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda12_ (self);
}


static void __lambda13_ (Block5Data* _data5_) {
	DejaDupOperation* self;
	GMainLoop* _tmp0_ = NULL;
	self = _data5_->self;
	_data5_->rv = FALSE;
	_tmp0_ = _data5_->loop;
	g_main_loop_quit (_tmp0_);
}


static void ___lambda13__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda13_ (self);
}


static void deja_dup_operation_claim_bus (DejaDupOperation* self, GError** error) {
	Block5Data* _data5_;
	GMainLoop* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GMainLoop* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	guint _tmp4_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->rv = FALSE;
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data5_->loop = _tmp0_;
	_tmp1_ = g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.DejaDup.Operation", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((___lambda11__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda11__gbus_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((___lambda12__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda12__gbus_name_acquired_callback, block5_data_ref (_data5_), block5_data_unref)), (GClosure*) ((___lambda13__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda13__gbus_name_lost_callback, block5_data_ref (_data5_), block5_data_unref)));
	self->priv->bus_id = _tmp1_;
	_tmp2_ = _data5_->loop;
	g_main_loop_run (_tmp2_);
	_tmp4_ = self->priv->bus_id;
	if (_tmp4_ == ((guint) 0)) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = _data5_->rv;
		_tmp3_ = _tmp5_ == FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = _ ("Another backup operation is already running");
		_tmp7_ = g_error_new_literal (DEJA_DUP_BACKUP_ERROR, DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING, _tmp6_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == DEJA_DUP_BACKUP_ERROR) {
			g_propagate_error (error, _inner_error_);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return;
		} else {
			block5_data_unref (_data5_);
			_data5_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void deja_dup_operation_unclaim_bus (DejaDupOperation* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bus_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->bus_id;
		g_bus_unown_name (_tmp1_);
	}
}


DejaDupOperation* deja_dup_operation_construct (GType object_type) {
	DejaDupOperation * self = NULL;
	self = (DejaDupOperation*) g_object_new (object_type, NULL);
	return self;
}


gboolean deja_dup_operation_get_use_cached_password (DejaDupOperation* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_use_cached_password;
	result = _tmp0_;
	return result;
}


void deja_dup_operation_set_use_cached_password (DejaDupOperation* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_use_cached_password = _tmp0_;
	g_object_notify ((GObject *) self, "use-cached-password");
}


gboolean deja_dup_operation_get_needs_password (DejaDupOperation* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_needs_password;
	result = _tmp0_;
	return result;
}


void deja_dup_operation_set_needs_password (DejaDupOperation* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_needs_password = _tmp0_;
	g_object_notify ((GObject *) self, "needs-password");
}


DejaDupBackend* deja_dup_operation_get_backend (DejaDupOperation* self) {
	DejaDupBackend* result;
	DejaDupBackend* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend;
	result = _tmp0_;
	return result;
}


static void deja_dup_operation_set_backend (DejaDupOperation* self, DejaDupBackend* value) {
	DejaDupBackend* _tmp0_ = NULL;
	DejaDupBackend* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_backend);
	self->priv->_backend = _tmp1_;
	g_object_notify ((GObject *) self, "backend");
}


gboolean deja_dup_operation_get_use_progress (DejaDupOperation* self) {
	gboolean result;
	DejaDupToolJob* _tmp0_ = NULL;
	DejaDupToolJobFlags _tmp1_ = 0;
	DejaDupToolJobFlags _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->job;
	_tmp1_ = deja_dup_tool_job_get_flags (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (_tmp2_ & DEJA_DUP_TOOL_JOB_FLAGS_NO_PROGRESS) == 0;
	return result;
}


void deja_dup_operation_set_use_progress (DejaDupOperation* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_) {
		DejaDupToolJob* _tmp1_ = NULL;
		DejaDupToolJob* _tmp2_ = NULL;
		DejaDupToolJobFlags _tmp3_ = 0;
		DejaDupToolJobFlags _tmp4_ = 0;
		_tmp1_ = self->job;
		_tmp2_ = self->job;
		_tmp3_ = deja_dup_tool_job_get_flags (_tmp2_);
		_tmp4_ = _tmp3_;
		deja_dup_tool_job_set_flags (_tmp1_, _tmp4_ | DEJA_DUP_TOOL_JOB_FLAGS_NO_PROGRESS);
	} else {
		DejaDupToolJob* _tmp5_ = NULL;
		DejaDupToolJob* _tmp6_ = NULL;
		DejaDupToolJobFlags _tmp7_ = 0;
		DejaDupToolJobFlags _tmp8_ = 0;
		_tmp5_ = self->job;
		_tmp6_ = self->job;
		_tmp7_ = deja_dup_tool_job_get_flags (_tmp6_);
		_tmp8_ = _tmp7_;
		deja_dup_tool_job_set_flags (_tmp5_, _tmp8_ ^ DEJA_DUP_TOOL_JOB_FLAGS_NO_PROGRESS);
	}
	g_object_notify ((GObject *) self, "use-progress");
}


DejaDupToolJobMode deja_dup_operation_get_mode (DejaDupOperation* self) {
	DejaDupToolJobMode result;
	DejaDupToolJobMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


static void deja_dup_operation_set_mode (DejaDupOperation* self, DejaDupToolJobMode value) {
	DejaDupToolJobMode _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_mode = _tmp0_;
	g_object_notify ((GObject *) self, "mode");
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN_STRING) (gpointer data1, gboolean arg_1, gboolean arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static GObject * deja_dup_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupOperation * self;
	DejaDupBackend* _tmp0_ = NULL;
	DejaDupBackend* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (deja_dup_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_OPERATION, DejaDupOperation);
	_tmp0_ = deja_dup_backend_get_default ();
	_tmp1_ = _tmp0_;
	deja_dup_operation_set_backend (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}


DejaDupOperationState* deja_dup_operation_state_construct (GType object_type) {
	DejaDupOperationState* self = NULL;
	self = (DejaDupOperationState*) g_type_create_instance (object_type);
	return self;
}


DejaDupOperationState* deja_dup_operation_state_new (void) {
	return deja_dup_operation_state_construct (DEJA_DUP_OPERATION_TYPE_STATE);
}


static void deja_dup_operation_value_state_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void deja_dup_operation_value_state_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		deja_dup_operation_state_unref (value->data[0].v_pointer);
	}
}


static void deja_dup_operation_value_state_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = deja_dup_operation_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer deja_dup_operation_value_state_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* deja_dup_operation_value_state_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		DejaDupOperationState* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = deja_dup_operation_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* deja_dup_operation_value_state_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DejaDupOperationState** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = deja_dup_operation_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* deja_dup_operation_param_spec_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DejaDupOperationParamSpecState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DEJA_DUP_OPERATION_TYPE_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer deja_dup_operation_value_get_state (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DEJA_DUP_OPERATION_TYPE_STATE), NULL);
	return value->data[0].v_pointer;
}


void deja_dup_operation_value_set_state (GValue* value, gpointer v_object) {
	DejaDupOperationState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DEJA_DUP_OPERATION_TYPE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DEJA_DUP_OPERATION_TYPE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		deja_dup_operation_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		deja_dup_operation_state_unref (old);
	}
}


void deja_dup_operation_value_take_state (GValue* value, gpointer v_object) {
	DejaDupOperationState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DEJA_DUP_OPERATION_TYPE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DEJA_DUP_OPERATION_TYPE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		deja_dup_operation_state_unref (old);
	}
}


static void deja_dup_operation_state_class_init (DejaDupOperationStateClass * klass) {
	deja_dup_operation_state_parent_class = g_type_class_peek_parent (klass);
	((DejaDupOperationStateClass *) klass)->finalize = deja_dup_operation_state_finalize;
}


static void deja_dup_operation_state_instance_init (DejaDupOperationState * self) {
	self->ref_count = 1;
}


static void deja_dup_operation_state_finalize (DejaDupOperationState* obj) {
	DejaDupOperationState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_OPERATION_TYPE_STATE, DejaDupOperationState);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->backend);
	_g_free0 (self->passphrase);
}


GType deja_dup_operation_state_get_type (void) {
	static volatile gsize deja_dup_operation_state_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_operation_state_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { deja_dup_operation_value_state_init, deja_dup_operation_value_state_free_value, deja_dup_operation_value_state_copy_value, deja_dup_operation_value_state_peek_pointer, "p", deja_dup_operation_value_state_collect_value, "p", deja_dup_operation_value_state_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperationState), 0, (GInstanceInitFunc) deja_dup_operation_state_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType deja_dup_operation_state_type_id;
		deja_dup_operation_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DejaDupOperationState", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&deja_dup_operation_state_type_id__volatile, deja_dup_operation_state_type_id);
	}
	return deja_dup_operation_state_type_id__volatile;
}


gpointer deja_dup_operation_state_ref (gpointer instance) {
	DejaDupOperationState* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void deja_dup_operation_state_unref (gpointer instance) {
	DejaDupOperationState* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DEJA_DUP_OPERATION_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void deja_dup_operation_class_init (DejaDupOperationClass * klass) {
	deja_dup_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupOperationPrivate));
	((DejaDupOperationClass *) klass)->start = deja_dup_operation_real_start;
	((DejaDupOperationClass *) klass)->start_finish = deja_dup_operation_real_start_finish;
	((DejaDupOperationClass *) klass)->connect_to_job = deja_dup_operation_real_connect_to_job;
	((DejaDupOperationClass *) klass)->send_action_file_changed = deja_dup_operation_real_send_action_file_changed;
	((DejaDupOperationClass *) klass)->operation_finished = deja_dup_operation_real_operation_finished;
	((DejaDupOperationClass *) klass)->operation_finished_finish = deja_dup_operation_real_operation_finished_finish;
	((DejaDupOperationClass *) klass)->make_argv = deja_dup_operation_real_make_argv;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_USE_CACHED_PASSWORD, g_param_spec_boolean ("use-cached-password", "use-cached-password", "use-cached-password", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_NEEDS_PASSWORD, g_param_spec_boolean ("needs-password", "needs-password", "needs-password", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_BACKEND, g_param_spec_object ("backend", "backend", "backend", DEJA_DUP_TYPE_BACKEND, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_USE_PROGRESS, g_param_spec_boolean ("use-progress", "use-progress", "use-progress", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_MODE, g_param_spec_enum ("mode", "mode", "mode", DEJA_DUP_TOOL_JOB_TYPE_MODE, DEJA_DUP_TOOL_JOB_MODE_INVALID, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * Abstract class that abstracts low level operations of duplicity
	   * with specific classes for specific operations
	   *
	   * Abstract class that defines methods and properties that have to be defined
	   * by classes that abstract operations from duplicity. It is generally unnecessary
	   * but it is provided to provide easier development and an abstraction layer
	   * in case Deja Dup project ever replaces its backend.
	   */
	g_signal_new ("done", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN_STRING, G_TYPE_NONE, 3, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_STRING);
	g_signal_new ("raise_error", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("action_desc_changed", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("action_file_changed", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_FILE, G_TYPE_BOOLEAN);
	g_signal_new ("progress", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	g_signal_new ("passphrase_required", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("question", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	g_signal_new ("is_full", DEJA_DUP_TYPE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void deja_dup_operation_instance_init (DejaDupOperation * self) {
	self->priv = DEJA_DUP_OPERATION_GET_PRIVATE (self);
	self->priv->_use_cached_password = TRUE;
	self->priv->_mode = DEJA_DUP_TOOL_JOB_MODE_INVALID;
	self->priv->finished = FALSE;
	self->priv->saved_detail = NULL;
	self->priv->chained_op = NULL;
	self->priv->bus_id = (guint) 0;
}


static void deja_dup_operation_finalize (GObject* obj) {
	DejaDupOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_OPERATION, DejaDupOperation);
	_g_object_unref0 (self->priv->_backend);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->job);
	_g_free0 (self->passphrase);
	_g_free0 (self->priv->saved_detail);
	_g_object_unref0 (self->priv->chained_op);
	G_OBJECT_CLASS (deja_dup_operation_parent_class)->finalize (obj);
}


GType deja_dup_operation_get_type (void) {
	static volatile gsize deja_dup_operation_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperation), 0, (GInstanceInitFunc) deja_dup_operation_instance_init, NULL };
		GType deja_dup_operation_type_id;
		deja_dup_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&deja_dup_operation_type_id__volatile, deja_dup_operation_type_id);
	}
	return deja_dup_operation_type_id__volatile;
}


static void _vala_deja_dup_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_OPERATION, DejaDupOperation);
	switch (property_id) {
		case DEJA_DUP_OPERATION_USE_CACHED_PASSWORD:
		g_value_set_boolean (value, deja_dup_operation_get_use_cached_password (self));
		break;
		case DEJA_DUP_OPERATION_NEEDS_PASSWORD:
		g_value_set_boolean (value, deja_dup_operation_get_needs_password (self));
		break;
		case DEJA_DUP_OPERATION_BACKEND:
		g_value_set_object (value, deja_dup_operation_get_backend (self));
		break;
		case DEJA_DUP_OPERATION_USE_PROGRESS:
		g_value_set_boolean (value, deja_dup_operation_get_use_progress (self));
		break;
		case DEJA_DUP_OPERATION_MODE:
		g_value_set_enum (value, deja_dup_operation_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_OPERATION, DejaDupOperation);
	switch (property_id) {
		case DEJA_DUP_OPERATION_USE_CACHED_PASSWORD:
		deja_dup_operation_set_use_cached_password (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_OPERATION_NEEDS_PASSWORD:
		deja_dup_operation_set_needs_password (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_OPERATION_BACKEND:
		deja_dup_operation_set_backend (self, g_value_get_object (value));
		break;
		case DEJA_DUP_OPERATION_USE_PROGRESS:
		deja_dup_operation_set_use_progress (self, g_value_get_boolean (value));
		break;
		case DEJA_DUP_OPERATION_MODE:
		deja_dup_operation_set_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



