/* BackendS3.c generated by valac 0.30.0, the Vala compiler
 * generated from BackendS3.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libsecret/secret.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_TOOL_JOB_TYPE_MODE (deja_dup_tool_job_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_S3 (deja_dup_backend_s3_get_type ())
#define DEJA_DUP_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3))
#define DEJA_DUP_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))
#define DEJA_DUP_IS_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_IS_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_BACKEND_S3_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))

typedef struct _DejaDupBackendS3 DejaDupBackendS3;
typedef struct _DejaDupBackendS3Class DejaDupBackendS3Class;
typedef struct _DejaDupBackendS3Private DejaDupBackendS3Private;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_CHECKER (deja_dup_checker_get_type ())
#define DEJA_DUP_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupChecker))
#define DEJA_DUP_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))
#define DEJA_DUP_IS_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_IS_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))

typedef struct _DejaDupChecker DejaDupChecker;
typedef struct _DejaDupCheckerClass DejaDupCheckerClass;

#define DEJA_DUP_TYPE_PYTHON_CHECKER (deja_dup_python_checker_get_type ())
#define DEJA_DUP_PYTHON_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonChecker))
#define DEJA_DUP_PYTHON_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonCheckerClass))
#define DEJA_DUP_IS_PYTHON_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER))
#define DEJA_DUP_IS_PYTHON_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_PYTHON_CHECKER))
#define DEJA_DUP_PYTHON_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonCheckerClass))

typedef struct _DejaDupPythonChecker DejaDupPythonChecker;
typedef struct _DejaDupPythonCheckerClass DejaDupPythonCheckerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
typedef struct _DejaDupBackendS3IsReadyData DejaDupBackendS3IsReadyData;

#define DEJA_DUP_TYPE_FILTERED_SETTINGS (deja_dup_filtered_settings_get_type ())
#define DEJA_DUP_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettings))
#define DEJA_DUP_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))
#define DEJA_DUP_IS_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_IS_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_FILTERED_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))

typedef struct _DejaDupFilteredSettings DejaDupFilteredSettings;
typedef struct _DejaDupFilteredSettingsClass DejaDupFilteredSettingsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupBackendS3GetEnvpData DejaDupBackendS3GetEnvpData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _DejaDupBackendS3GotPasswordReplyData DejaDupBackendS3GotPasswordReplyData;

typedef enum  {
	DEJA_DUP_TOOL_JOB_MODE_INVALID,
	DEJA_DUP_TOOL_JOB_MODE_BACKUP,
	DEJA_DUP_TOOL_JOB_MODE_RESTORE,
	DEJA_DUP_TOOL_JOB_MODE_STATUS,
	DEJA_DUP_TOOL_JOB_MODE_LIST,
	DEJA_DUP_TOOL_JOB_MODE_HISTORY
} DejaDupToolJobMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	gchar* (*get_location) (DejaDupBackend* self, gboolean* as_root);
	gchar* (*get_location_pretty) (DejaDupBackend* self);
	void (*is_ready) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*is_ready_finish) (DejaDupBackend* self, GAsyncResult* _res_, gchar** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	gboolean (*space_can_be_infinite) (DejaDupBackend* self);
	void (*add_argv) (DejaDupBackend* self, DejaDupToolJobMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendS3 {
	DejaDupBackend parent_instance;
	DejaDupBackendS3Private * priv;
};

struct _DejaDupBackendS3Class {
	DejaDupBackendClass parent_class;
};

struct _DejaDupBackendS3Private {
	gchar* settings_id;
	gchar* id;
	gchar* secret_key;
};

struct _DejaDupBackendS3IsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendS3* self;
	gchar* when;
	gboolean result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	DejaDupNetwork* _tmp2_;
	DejaDupNetwork* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
};

struct _DejaDupBackendS3GetEnvpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendS3* self;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp0_;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	SecretSchema* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* e;
	GError * _inner_error_;
};

struct _DejaDupBackendS3GotPasswordReplyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendS3* self;
	GMountOperation* mount_op;
	GMountOperationResult _result_;
	GMountOperationResult _tmp0_;
	GList* _tmp1_;
	const gchar* _tmp2_;
	GMountOperation* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GMountOperation* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GPasswordSave remember;
	GMountOperation* _tmp11_;
	GPasswordSave _tmp12_;
	GPasswordSave _tmp13_;
	GPasswordSave _tmp14_;
	const gchar* _tmp15_;
	GPasswordSave _tmp16_;
	gchar* where;
	gchar* _tmp17_;
	SecretSchema* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GError* e;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError * _inner_error_;
};


static gpointer deja_dup_backend_s3_parent_class = NULL;

#define DEJA_DUP_S3_ROOT "S3"
#define DEJA_DUP_S3_ID_KEY "id"
#define DEJA_DUP_S3_BUCKET_KEY "bucket"
#define DEJA_DUP_S3_FOLDER_KEY "folder"
#define DEJA_DUP_S3_SERVER "s3.amazonaws.com"
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_tool_job_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_s3_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_BACKEND_S3_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Private))
enum  {
	DEJA_DUP_BACKEND_S3_DUMMY_PROPERTY
};
GType deja_dup_checker_get_type (void) G_GNUC_CONST;
DejaDupChecker* deja_dup_backend_s3_get_checker (void);
GType deja_dup_python_checker_get_type (void) G_GNUC_CONST;
DejaDupPythonChecker* deja_dup_python_checker_get_checker (const gchar* module);
static DejaDupBackend* deja_dup_backend_s3_real_clone (DejaDupBackend* base);
DejaDupBackendS3* deja_dup_backend_s3_new (void);
DejaDupBackendS3* deja_dup_backend_s3_construct (GType object_type);
static void deja_dup_backend_s3_real_add_argv (DejaDupBackend* base, DejaDupToolJobMode mode, GList** argv);
static gchar* deja_dup_backend_s3_get_default_bucket (DejaDupBackendS3* self);
static gboolean deja_dup_backend_s3_real_is_native (DejaDupBackend* base);
static GIcon* deja_dup_backend_s3_real_get_icon (DejaDupBackend* base);
static void deja_dup_backend_s3_real_is_ready_data_free (gpointer _data);
static void deja_dup_backend_s3_real_is_ready (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_s3_real_is_ready_co (DejaDupBackendS3IsReadyData* _data_);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
void deja_dup_network_can_reach (DejaDupNetwork* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean deja_dup_network_can_reach_finish (DejaDupNetwork* self, GAsyncResult* _res_);
static void deja_dup_backend_s3_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* deja_dup_backend_s3_real_get_location (DejaDupBackend* base, gboolean* as_root);
GType deja_dup_filtered_settings_get_type (void) G_GNUC_CONST;
DejaDupFilteredSettings* deja_dup_get_settings (const gchar* subdir);
void deja_dup_filtered_settings_set_string (DejaDupFilteredSettings* self, const gchar* k, const gchar* v);
gchar* deja_dup_get_folder_key (DejaDupFilteredSettings* settings, const gchar* key);
gboolean deja_dup_backend_s3_bump_bucket (DejaDupBackendS3* self);
static gchar* deja_dup_backend_s3_real_get_location_pretty (DejaDupBackend* base);
static void deja_dup_backend_s3_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_s3_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_s3_real_get_envp_co (DejaDupBackendS3GetEnvpData* _data_);
static void deja_dup_backend_s3_got_secret_key (DejaDupBackendS3* self);
static void deja_dup_backend_s3_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_backend_s3_ask_password (DejaDupBackendS3* self);
static void deja_dup_backend_s3_got_password_reply_data_free (gpointer _data);
static void deja_dup_backend_s3_got_password_reply (DejaDupBackendS3* self, GMountOperation* mount_op, GMountOperationResult _result_, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_s3_got_password_reply_finish (DejaDupBackendS3* self, GAsyncResult* _res_);
static gboolean deja_dup_backend_s3_got_password_reply_co (DejaDupBackendS3GotPasswordReplyData* _data_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void deja_dup_backend_s3_got_password_reply_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
static void _deja_dup_backend_s3_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self);
DejaDupBackend* deja_dup_backend_construct (GType object_type);
static void deja_dup_backend_s3_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


DejaDupChecker* deja_dup_backend_s3_get_checker (void) {
	DejaDupChecker* result = NULL;
	DejaDupPythonChecker* _tmp0_ = NULL;
	_tmp0_ = deja_dup_python_checker_get_checker ("boto");
	result = (DejaDupChecker*) _tmp0_;
	return result;
}


static DejaDupBackend* deja_dup_backend_s3_real_clone (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	DejaDupBackend* result = NULL;
	DejaDupBackendS3* _tmp0_ = NULL;
	self = (DejaDupBackendS3*) base;
	_tmp0_ = deja_dup_backend_s3_new ();
	result = (DejaDupBackend*) _tmp0_;
	return result;
}


static void deja_dup_backend_s3_real_add_argv (DejaDupBackend* base, DejaDupToolJobMode mode, GList** argv) {
	DejaDupBackendS3 * self;
	DejaDupToolJobMode _tmp0_ = 0;
	self = (DejaDupBackendS3*) base;
	_tmp0_ = mode;
	if (_tmp0_ == DEJA_DUP_TOOL_JOB_MODE_INVALID) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("--s3-use-new-style");
		*argv = g_list_append (*argv, _tmp1_);
	}
}


static gchar* deja_dup_backend_s3_get_default_bucket (DejaDupBackendS3* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->id;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("deja-dup-auto-%s", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gboolean deja_dup_backend_s3_real_is_native (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	gboolean result = FALSE;
	self = (DejaDupBackendS3*) base;
	result = FALSE;
	return result;
}


static GIcon* deja_dup_backend_s3_real_get_icon (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	GIcon* result = NULL;
	GThemedIcon* _tmp0_ = NULL;
	self = (DejaDupBackendS3*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("deja-dup-cloud");
	result = (GIcon*) _tmp0_;
	return result;
}


static void deja_dup_backend_s3_real_is_ready_data_free (gpointer _data) {
	DejaDupBackendS3IsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendS3IsReadyData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_backend_s3_real_is_ready (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendS3 * self;
	DejaDupBackendS3IsReadyData* _data_;
	DejaDupBackendS3* _tmp0_ = NULL;
	self = (DejaDupBackendS3*) base;
	_data_ = g_slice_new0 (DejaDupBackendS3IsReadyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_s3_real_is_ready);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_s3_real_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_s3_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_s3_real_is_ready_finish (DejaDupBackend* base, GAsyncResult* _res_, gchar** when) {
	gboolean result;
	DejaDupBackendS3IsReadyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (when) {
		*when = _data_->when;
	} else {
		_g_free0 (_data_->when);
	}
	_data_->when = NULL;
	result = _data_->result;
	return result;
}


static void deja_dup_backend_s3_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendS3IsReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_s3_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_s3_real_is_ready_co (DejaDupBackendS3IsReadyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Backup will begin when a network connection becomes available.");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_g_free0 (_data_->when);
	_data_->when = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = deja_dup_network_get ();
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strdup_printf ("http://%s/", DEJA_DUP_S3_SERVER);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_state_ = 1;
	deja_dup_network_can_reach (_data_->_tmp3_, _data_->_tmp5_, deja_dup_backend_s3_is_ready_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = deja_dup_network_can_reach_finish (_data_->_tmp3_, _data_->_res_);
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_free0 (_data_->_tmp5_);
	_g_object_unref0 (_data_->_tmp3_);
	_data_->result = _data_->_tmp7_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* deja_dup_backend_s3_real_get_location (DejaDupBackend* base, gboolean* as_root) {
	DejaDupBackendS3 * self;
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* bucket = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* default_bucket = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gchar* folder = NULL;
	DejaDupFilteredSettings* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	self = (DejaDupBackendS3*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_S3_BUCKET_KEY);
	bucket = _tmp2_;
	_tmp3_ = deja_dup_backend_s3_get_default_bucket (self);
	default_bucket = _tmp3_;
	_tmp6_ = bucket;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = bucket;
		_tmp5_ = g_strcmp0 (_tmp7_, "") == 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = bucket;
		_tmp10_ = g_str_has_prefix (_tmp9_, "deja-dup-auto-");
		if (_tmp10_) {
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			_tmp11_ = bucket;
			_tmp12_ = default_bucket;
			_tmp13_ = g_str_has_prefix (_tmp11_, _tmp12_);
			_tmp8_ = !_tmp13_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp4_ = _tmp8_;
	}
	if (_tmp4_) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		DejaDupFilteredSettings* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp14_ = default_bucket;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (bucket);
		bucket = _tmp15_;
		_tmp16_ = settings;
		_tmp17_ = bucket;
		deja_dup_filtered_settings_set_string (_tmp16_, DEJA_DUP_S3_BUCKET_KEY, _tmp17_);
	}
	_tmp18_ = settings;
	_tmp19_ = deja_dup_get_folder_key (_tmp18_, DEJA_DUP_S3_FOLDER_KEY);
	folder = _tmp19_;
	_tmp20_ = bucket;
	_tmp21_ = g_strdup_printf ("s3+http://%s/%s", _tmp20_, folder);
	result = _tmp21_;
	_g_free0 (folder);
	_g_free0 (default_bucket);
	_g_free0 (bucket);
	_g_object_unref0 (settings);
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


gboolean deja_dup_backend_s3_bump_bucket (DejaDupBackendS3* self) {
	gboolean result = FALSE;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* bucket = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gchar** bits = NULL;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint bits_length1 = 0;
	gint _bits_size_ = 0;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gchar** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	const gchar* _tmp26_ = NULL;
	DejaDupFilteredSettings* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_S3_BUCKET_KEY);
	bucket = _tmp2_;
	_tmp3_ = bucket;
	if (g_strcmp0 (_tmp3_, "deja-dup") == 0) {
		gchar* _tmp4_ = NULL;
		DejaDupFilteredSettings* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = deja_dup_backend_s3_get_default_bucket (self);
		_g_free0 (bucket);
		bucket = _tmp4_;
		_tmp5_ = settings;
		_tmp6_ = bucket;
		deja_dup_filtered_settings_set_string (_tmp5_, DEJA_DUP_S3_BUCKET_KEY, _tmp6_);
		result = TRUE;
		_g_free0 (bucket);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp7_ = bucket;
	_tmp8_ = g_str_has_prefix (_tmp7_, "deja-dup-auto-");
	if (!_tmp8_) {
		result = FALSE;
		_g_free0 (bucket);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp9_ = bucket;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "-", 0);
	bits = _tmp11_;
	bits_length1 = _vala_array_length (_tmp10_);
	_bits_size_ = bits_length1;
	_tmp16_ = bits;
	_tmp16__length1 = bits_length1;
	if (_tmp16_ == NULL) {
		_tmp15_ = TRUE;
	} else {
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = bits;
		_tmp17__length1 = bits_length1;
		_tmp18_ = _tmp17_[0];
		_tmp15_ = _tmp18_ == NULL;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		const gchar* _tmp20_ = NULL;
		_tmp19_ = bits;
		_tmp19__length1 = bits_length1;
		_tmp20_ = _tmp19_[1];
		_tmp14_ = _tmp20_ == NULL;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		const gchar* _tmp22_ = NULL;
		_tmp21_ = bits;
		_tmp21__length1 = bits_length1;
		_tmp22_ = _tmp21_[2];
		_tmp13_ = _tmp22_ == NULL;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		const gchar* _tmp24_ = NULL;
		_tmp23_ = bits;
		_tmp23__length1 = bits_length1;
		_tmp24_ = _tmp23_[3];
		_tmp12_ = _tmp24_ == NULL;
	}
	if (_tmp12_) {
		result = FALSE;
		bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (bucket);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp25_ = bits;
	_tmp25__length1 = bits_length1;
	_tmp26_ = _tmp25_[4];
	if (_tmp26_ == NULL) {
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		_tmp27_ = bucket;
		_tmp28_ = g_strconcat (_tmp27_, "-2", NULL);
		_g_free0 (bucket);
		bucket = _tmp28_;
	} else {
		glong num = 0L;
		gchar** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		const gchar* _tmp30_ = NULL;
		glong _tmp31_ = 0L;
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		glong _tmp33_ = 0L;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		gchar* _tmp37_ = NULL;
		_tmp29_ = bits;
		_tmp29__length1 = bits_length1;
		_tmp30_ = _tmp29_[4];
		_tmp31_ = atol (_tmp30_);
		num = _tmp31_;
		_tmp32_ = bits;
		_tmp32__length1 = bits_length1;
		_tmp33_ = num;
		_tmp34_ = g_strdup_printf ("%li", _tmp33_ + 1);
		_g_free0 (_tmp32_[4]);
		_tmp32_[4] = _tmp34_;
		_tmp35_ = _tmp32_[4];
		_tmp36_ = bits;
		_tmp36__length1 = bits_length1;
		_tmp37_ = _vala_g_strjoinv ("-", _tmp36_, _tmp36__length1);
		_g_free0 (bucket);
		bucket = _tmp37_;
	}
	_tmp38_ = settings;
	_tmp39_ = bucket;
	deja_dup_filtered_settings_set_string (_tmp38_, DEJA_DUP_S3_BUCKET_KEY, _tmp39_);
	result = TRUE;
	bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (bucket);
	_g_object_unref0 (settings);
	return result;
}


static gchar* deja_dup_backend_s3_real_get_location_pretty (DejaDupBackend* base) {
	DejaDupBackendS3 * self;
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* folder = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	self = (DejaDupBackendS3*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = deja_dup_get_folder_key (_tmp1_, DEJA_DUP_S3_FOLDER_KEY);
	folder = _tmp2_;
	_tmp3_ = folder;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = _ ("Amazon S3");
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_free0 (folder);
		_g_object_unref0 (settings);
		return result;
	} else {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp6_ = _ ("%s on Amazon S3");
		_tmp7_ = folder;
		_tmp8_ = g_strdup_printf (_tmp6_, _tmp7_);
		result = _tmp8_;
		_g_free0 (folder);
		_g_object_unref0 (settings);
		return result;
	}
	_g_free0 (folder);
	_g_object_unref0 (settings);
}


static void deja_dup_backend_s3_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendS3GetEnvpData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendS3GetEnvpData, _data_);
}


static void deja_dup_backend_s3_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendS3 * self;
	DejaDupBackendS3GetEnvpData* _data_;
	DejaDupBackendS3* _tmp0_ = NULL;
	self = (DejaDupBackendS3*) base;
	_data_ = g_slice_new0 (DejaDupBackendS3GetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_s3_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_s3_real_get_envp_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_s3_real_get_envp_co (_data_);
}


static void deja_dup_backend_s3_real_get_envp_finish (DejaDupBackend* base, GAsyncResult* _res_, GError** error) {
	DejaDupBackendS3GetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_s3_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendS3GetEnvpData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_s3_real_get_envp_co (_data_);
}


static gboolean deja_dup_backend_s3_real_get_envp_co (DejaDupBackendS3GetEnvpData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	_data_->settings = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->settings;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_settings_get_string ((GSettings*) _data_->_tmp1_, DEJA_DUP_S3_ID_KEY);
	_g_free0 (_data_->self->priv->settings_id);
	_data_->self->priv->settings_id = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->settings_id;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp3_ = "";
	} else {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->settings_id;
		_data_->_tmp3_ = _data_->_tmp5_;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup (_data_->_tmp3_);
	_g_free0 (_data_->self->priv->id);
	_data_->self->priv->id = _data_->_tmp6_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->self->priv->id;
	if (g_strcmp0 (_data_->_tmp8_, "") != 0) {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->self->priv->secret_key;
		_data_->_tmp7_ = _data_->_tmp9_ != NULL;
	} else {
		_data_->_tmp7_ = FALSE;
	}
	if (_data_->_tmp7_) {
		deja_dup_backend_s3_got_secret_key (_data_->self);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->priv->id;
	if (g_strcmp0 (_data_->_tmp10_, "") != 0) {
		{
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = SECRET_SCHEMA_COMPAT_NETWORK;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->self->priv->id;
			_data_->_state_ = 1;
			secret_password_lookup (_data_->_tmp12_, NULL, deja_dup_backend_s3_get_envp_ready, _data_, "user", _data_->_tmp13_, "server", DEJA_DUP_S3_SERVER, "protocol", "https", NULL);
			return FALSE;
			_state_1:
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = secret_password_lookup_finish (_data_->_res_, &_data_->_inner_error_);
			_data_->_tmp11_ = _data_->_tmp14_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch15_g_error;
			}
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->_tmp11_;
			_data_->_tmp11_ = NULL;
			_g_free0 (_data_->self->priv->secret_key);
			_data_->self->priv->secret_key = _data_->_tmp15_;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->self->priv->secret_key;
			if (_data_->_tmp16_ != NULL) {
				deja_dup_backend_s3_got_secret_key (_data_->self);
				_g_free0 (_data_->_tmp11_);
				_g_object_unref0 (_data_->settings);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->_tmp11_);
		}
		goto __finally15;
		__catch15_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->e);
		}
		__finally15:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->settings);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	deja_dup_backend_s3_ask_password (_data_->self);
	_g_object_unref0 (_data_->settings);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_backend_s3_got_password_reply_data_free (gpointer _data) {
	DejaDupBackendS3GotPasswordReplyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->mount_op);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendS3GotPasswordReplyData, _data_);
}


static void deja_dup_backend_s3_got_password_reply (DejaDupBackendS3* self, GMountOperation* mount_op, GMountOperationResult _result_, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendS3GotPasswordReplyData* _data_;
	DejaDupBackendS3* _tmp0_ = NULL;
	GMountOperation* _tmp1_ = NULL;
	GMountOperation* _tmp2_ = NULL;
	GMountOperationResult _tmp3_ = 0;
	_data_ = g_slice_new0 (DejaDupBackendS3GotPasswordReplyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_s3_got_password_reply);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_s3_got_password_reply_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = mount_op;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->mount_op);
	_data_->mount_op = _tmp2_;
	_tmp3_ = _result_;
	_data_->_result_ = _tmp3_;
	deja_dup_backend_s3_got_password_reply_co (_data_);
}


static void deja_dup_backend_s3_got_password_reply_finish (DejaDupBackendS3* self, GAsyncResult* _res_) {
	DejaDupBackendS3GotPasswordReplyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void deja_dup_backend_s3_got_password_reply_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendS3GotPasswordReplyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_s3_got_password_reply_co (_data_);
}


static gboolean deja_dup_backend_s3_got_password_reply_co (DejaDupBackendS3GotPasswordReplyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = _data_->_result_;
	if (_data_->_tmp0_ != G_MOUNT_OPERATION_HANDLED) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = NULL;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _ ("Permission denied");
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "envp-ready", FALSE, _data_->_tmp1_, _data_->_tmp2_);
		__g_list_free__g_free0_0 (_data_->_tmp1_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->mount_op;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_mount_operation_get_username (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_g_free0 (_data_->self->priv->id);
	_data_->self->priv->id = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->mount_op;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_mount_operation_get_password (_data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
	_g_free0 (_data_->self->priv->secret_key);
	_data_->self->priv->secret_key = _data_->_tmp10_;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->mount_op;
	_data_->_tmp12_ = 0;
	_data_->_tmp12_ = g_mount_operation_get_password_save (_data_->_tmp11_);
	_data_->_tmp13_ = 0;
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->remember = _data_->_tmp13_;
	_data_->_tmp14_ = 0;
	_data_->_tmp14_ = _data_->remember;
	if (_data_->_tmp14_ != G_PASSWORD_SAVE_NEVER) {
		_data_->_tmp16_ = 0;
		_data_->_tmp16_ = _data_->remember;
		if (_data_->_tmp16_ == G_PASSWORD_SAVE_FOR_SESSION) {
			_data_->_tmp15_ = SECRET_COLLECTION_SESSION;
		} else {
			_data_->_tmp15_ = SECRET_COLLECTION_DEFAULT;
		}
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup (_data_->_tmp15_);
		_data_->where = _data_->_tmp17_;
		{
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = SECRET_SCHEMA_COMPAT_NETWORK;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->where;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->self->priv->id;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = g_strdup_printf ("%s@%s", _data_->_tmp20_, DEJA_DUP_S3_SERVER);
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->_tmp21_;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->self->priv->secret_key;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->self->priv->id;
			_data_->_state_ = 1;
			secret_password_store (_data_->_tmp18_, _data_->_tmp19_, _data_->_tmp22_, _data_->_tmp23_, NULL, deja_dup_backend_s3_got_password_reply_ready, _data_, "user", _data_->_tmp24_, "server", DEJA_DUP_S3_SERVER, "protocol", "https", NULL);
			return FALSE;
			_state_1:
			secret_password_store_finish (_data_->_res_, &_data_->_inner_error_);
			_g_free0 (_data_->_tmp22_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch16_g_error;
			}
		}
		goto __finally16;
		__catch16_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->e;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->_tmp25_->message;
			g_warning ("BackendS3.vala:191: %s\n", _data_->_tmp26_);
			_g_error_free0 (_data_->e);
		}
		__finally16:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_free0 (_data_->where);
	}
	deja_dup_backend_s3_got_secret_key (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _deja_dup_backend_s3_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self) {
	deja_dup_backend_s3_got_password_reply ((DejaDupBackendS3*) self, _sender, _result_, NULL, NULL);
}


static void deja_dup_backend_s3_ask_password (DejaDupBackendS3* self) {
	GMountOperation* _tmp0_ = NULL;
	GMountOperation* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GMountOperation* _tmp5_ = NULL;
	GMountOperation* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GMountOperation* _tmp8_ = NULL;
	GMountOperation* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GMountOperation* _tmp11_ = NULL;
	GMountOperation* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GMountOperation* _tmp14_ = NULL;
	GMountOperation* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GMountOperation* _tmp17_ = NULL;
	GMountOperation* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GMountOperation* _tmp20_ = NULL;
	GMountOperation* _tmp21_ = NULL;
	GMountOperation* _tmp22_ = NULL;
	GMountOperation* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("You can sign up for an Amazon S3 account <a href=\"%s\">online</a>.");
	_tmp3_ = g_strdup_printf (_tmp2_, "http://aws.amazon.com/s3/");
	_tmp4_ = _tmp3_;
	g_object_set ((GObject*) _tmp1_, "label_help", _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_tmp5_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _ ("Connect to Amazon S3");
	g_object_set ((GObject*) _tmp6_, "label_title", _tmp7_, NULL);
	_tmp8_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _ ("_Access key ID");
	g_object_set ((GObject*) _tmp9_, "label_username", _tmp10_, NULL);
	_tmp11_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = _ ("_Secret access key");
	g_object_set ((GObject*) _tmp12_, "label_password", _tmp13_, NULL);
	_tmp14_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = _ ("S_how secret access key");
	g_object_set ((GObject*) _tmp15_, "label_show_password", _tmp16_, NULL);
	_tmp17_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp18_ = _tmp17_;
	_tmp19_ = _ ("_Remember secret access key");
	g_object_set ((GObject*) _tmp18_, "label_remember_password", _tmp19_, NULL);
	_tmp20_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp21_ = _tmp20_;
	g_signal_connect_object (_tmp21_, "reply", (GCallback) _deja_dup_backend_s3_got_password_reply_g_mount_operation_reply, self, 0);
	_tmp22_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->id;
	g_signal_emit_by_name (_tmp23_, "ask-password", "", _tmp24_, "", (G_ASK_PASSWORD_NEED_PASSWORD | G_ASK_PASSWORD_NEED_USERNAME) | G_ASK_PASSWORD_SAVING_SUPPORTED);
}


static void deja_dup_backend_s3_got_secret_key (DejaDupBackendS3* self) {
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GList* envp = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_S3_ROOT);
	settings = _tmp0_;
	_tmp1_ = self->priv->id;
	_tmp2_ = self->priv->settings_id;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		DejaDupFilteredSettings* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = settings;
		_tmp4_ = self->priv->id;
		deja_dup_filtered_settings_set_string (_tmp3_, DEJA_DUP_S3_ID_KEY, _tmp4_);
	}
	envp = NULL;
	_tmp5_ = self->priv->id;
	_tmp6_ = g_strdup_printf ("AWS_ACCESS_KEY_ID=%s", _tmp5_);
	envp = g_list_append (envp, _tmp6_);
	_tmp7_ = self->priv->secret_key;
	_tmp8_ = g_strdup_printf ("AWS_SECRET_ACCESS_KEY=%s", _tmp7_);
	envp = g_list_append (envp, _tmp8_);
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, envp, NULL);
	__g_list_free__g_free0_0 (envp);
	_g_object_unref0 (settings);
}


DejaDupBackendS3* deja_dup_backend_s3_construct (GType object_type) {
	DejaDupBackendS3 * self = NULL;
	self = (DejaDupBackendS3*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendS3* deja_dup_backend_s3_new (void) {
	return deja_dup_backend_s3_construct (DEJA_DUP_TYPE_BACKEND_S3);
}


static void deja_dup_backend_s3_class_init (DejaDupBackendS3Class * klass) {
	deja_dup_backend_s3_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendS3Private));
	((DejaDupBackendClass *) klass)->clone = deja_dup_backend_s3_real_clone;
	((DejaDupBackendClass *) klass)->add_argv = deja_dup_backend_s3_real_add_argv;
	((DejaDupBackendClass *) klass)->is_native = deja_dup_backend_s3_real_is_native;
	((DejaDupBackendClass *) klass)->get_icon = deja_dup_backend_s3_real_get_icon;
	((DejaDupBackendClass *) klass)->is_ready = deja_dup_backend_s3_real_is_ready;
	((DejaDupBackendClass *) klass)->is_ready_finish = deja_dup_backend_s3_real_is_ready_finish;
	((DejaDupBackendClass *) klass)->get_location = deja_dup_backend_s3_real_get_location;
	((DejaDupBackendClass *) klass)->get_location_pretty = deja_dup_backend_s3_real_get_location_pretty;
	((DejaDupBackendClass *) klass)->get_envp = deja_dup_backend_s3_real_get_envp;
	((DejaDupBackendClass *) klass)->get_envp_finish = deja_dup_backend_s3_real_get_envp_finish;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_s3_finalize;
}


static void deja_dup_backend_s3_instance_init (DejaDupBackendS3 * self) {
	self->priv = DEJA_DUP_BACKEND_S3_GET_PRIVATE (self);
}


static void deja_dup_backend_s3_finalize (GObject* obj) {
	DejaDupBackendS3 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3);
	_g_free0 (self->priv->settings_id);
	_g_free0 (self->priv->id);
	_g_free0 (self->priv->secret_key);
	G_OBJECT_CLASS (deja_dup_backend_s3_parent_class)->finalize (obj);
}


GType deja_dup_backend_s3_get_type (void) {
	static volatile gsize deja_dup_backend_s3_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_s3_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendS3Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_s3_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendS3), 0, (GInstanceInitFunc) deja_dup_backend_s3_instance_init, NULL };
		GType deja_dup_backend_s3_type_id;
		deja_dup_backend_s3_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendS3", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_s3_type_id__volatile, deja_dup_backend_s3_type_id);
	}
	return deja_dup_backend_s3_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



