
#include "bandit/bandit/bandit.h"
// BANDIT NEEDS TO BE INCLUDED FIRST!!!

#include <iostream>
#include "../../src/modules.h"

using namespace snowhouse;

go_bandit([]() {
  bandit::describe("Testing operator name extraction from command string", [&]() {

    bandit::it("returns the commandString if it and has no '-' and has no arguments",
               [&]() { AssertThat(extract_operator_name("test"),Is().EqualTo("test")); });

    bandit::it("returns the commandString without the '-' while it has no arguments",
               [&]() { AssertThat(extract_operator_name("-test"),Is().EqualTo("test")); });

    bandit::it("returns the commandString without the '-' while it has arguments",
               [&]() { AssertThat(extract_operator_name("-test,arg"),Is().EqualTo("test")); });

    bandit::it("returns the commandString while it has arguments and has no '-'",
               [&]() { AssertThat(extract_operator_name("test,arg"),Is().EqualTo("test")); });
  });
});

int
main(int argc, char **argv)
{

  int result = bandit::run(argc, argv);

  return result;
}
