%! Public Domain Software
%! 2023-01-31
%! 2.0.0-alpha
%! Elayson
%! abntexto.classe at gmail.com

%! RECOMENDAÇÕES
%! PRÉ-CONFIGURAÇÕES
%! FONTES
%! LAYOUT
%! SUMÁRIO
%! SECIONAMEMTO
%! CITAÇÕES
%! ALÍNEAS
%! TABELAS
%! ÁREAS DE LEGENDA
%! NOTAS DE RODAPÉ
%! IDENTIFICAÇÃO DO TRABALHO
%! A VÍRGULA COMO SEPARADOR DECIMAL
%! INICIALIZAÇÃO

% \sec RECOMENDAÇÕES

% Macros internas não podem ser modificadas ou usadas diretamente. Isso é porque essas macros podem ser redefinidas ou até renomeadas em futuras versões desta classe. Por macros internas entende-se aquelas com o prefixo do pacote em questão, neste caso, \cs{tnba@}. Se você precisa de algum comando interno, defina outro sem anexar o prefixo.

% \sec PRÉ-CONFIGURAÇÕES

% Identificação do formato \TeX\ e da classe. Apenas o pacote \pkg{keyval} é carregado no \pkg{abntexto}.

% |bcode !------------------------------------------------
\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{abntexto}[2023-01-31 2.0.0-alpha Preparation of works in ABNT standards]

\RequirePackage{keyval}
% |ecode !------------------------------------------------

% Definição de um sistema \emph{chave=valor} pessoal e de macros auxiliares.

% |bcode !------------------------------------------------
\def\tnba@key{\define@key{tnba@\tnba@keyfamily}}
\def\tnba@setkeys#1{\setkeys{tnba@#1}}

\def\tnba@addto#1#2{\expandafter\def\expandafter#1\expandafter{#1#2}}

\newif \iftnba@inbody
\AddToHook{begindocument}{\tnba@inbodytrue}
% |ecode !------------------------------------------------

% Alertas, mensagens, \emph{debug}.

% |bcode !------------------------------------------------
\def\tnba@warning{\ClassWarningNoLine{abntexto}}
\def\tnba@error#1{\ClassError{abntexto}{#1}{}}
% |ecode !------------------------------------------------

% Condicionais para identificação da extensão \TeX. 

% |bcode !------------------------------------------------
\newif \iftnba@PDFTEX
\newif \iftnba@XETEX
\newif \iftnba@LUATEX

\ifx\directlua\undefined \ifx\XeTeXversion\undefined
	\tnba@PDFTEXtrue \else
	\tnba@XETEXtrue  \fi \else
	\tnba@LUATEXtrue     \fi
% |ecode !------------------------------------------------

% \sec FONTE TIPOGRÁFICA

% Apenas o tamanho 12\,pt está definido. Defina outros usando \cs\definefontsize\cc{id}\hfil\break \cc{definições}.

% |bcode !------------------------------------------------
\def\definefontsize#1#2{\@namedef{tnba@fontsize@#1}{#2}}

\def\setfontsize#1{\ifcsname tnba@fontsize@#1\endcsname
	\def\tnba@setfontsizehook{\csname tnba@fontsize@#1\endcsname}\else
	\let\normalsize=\relax \tnba@error{Tamanho de fonte ''#1'' desconhecido}\relax \fi
}

\@onlypreamble \setfontsize

\def\sizedef#1#2#3#4{\DeclareRobustCommand#1{\fontsize{#2}{#3}\selectfont#4}}

\def\spacing#1{\def\currspacing{#1}%
	\@tempdima=\f@size pt \baselineskip=#1\@tempdima \ignorespaces
}

\def\currspacing{1.5}
\def\normalsize{}
\def\tnba@setfontsizehook{}

\AddToHook{begindocument}{%
	\tnba@setfontsizehook
	\normalsize
	\@tempdima=\f@size pt \baselineskip=\currspacing\@tempdima
}

\def\singlesp{\baselineskip=\normalbaselineskip}
\def\onehalfsp{\spacing{1.5}}
\def\doublesp{\spacing{2}}
% |ecode !------------------------------------------------

% \sec \emph{LAYOUT}

% Se você precisa de configurações de página mais avançadas use o pacote \pkg{geometry}, mas não use \cs\setlayout\ e \cs\geometry\ simultaneamente.

% |bcode !------------------------------------------------
\iftnba@LUATEX
	\protected\edef\pdfhorigin {\pdfvariable horigin}
	\protected\edef\pdfvorigin {\pdfvariable vorigin}
	\let\pdfpagewidth=\pagewidth
	\let\pdfpageheight=\pageheight
\fi

\def \tnba@keyfamily {setlayout}

\tnba@key{paper}        {\csname tnba@papersize@#1\endcsname}
\tnba@key{width}        {\def\tnba@W{#1}}
\tnba@key{height}       {\def\tnba@H{#1}}
\tnba@key{left}         {\def\tnba@L{#1}}
\tnba@key{right}        {\def\tnba@R{#1}}
\tnba@key{top}          {\def\tnba@T{#1}}
\tnba@key{bottom}       {\def\tnba@B{#1}}
\tnba@key{twoside}[true]{\csname @twoside#1\endcsname}

\def \setlayout #1{\tnba@setkeys{setlayout}{#1}%
	\paperwidth=\tnba@W    \paperheight=\tnba@H
	\oddsidemargin=\tnba@L \evensidemargin=\tnba@R
	\textwidth=\paperwidth \textheight=\paperheight
	\topmargin=\tnba@T
	\headheight=12pt 
	\headsep=1cm 
	\advance\topmargin-\headheight \advance\topmargin-\headsep
	\advance\textwidth-\tnba@L     \advance\textwidth-\tnba@R
	\advance\textheight-\tnba@T    \advance\textheight-\tnba@B
	\tnba@setlayoutA
}

\def \tnba@setlayoutA {%
	\iftnba@XETEX
		\advance\oddsidemargin-1in \advance\evensidemargin-1in \advance\topmargin-1in 
		\pdfpagewidth=\paperwidth  \pdfpageheight=\paperheight
	\else
		\pdfhorigin=0pt            \pdfvorigin=0pt 
		\pdfpagewidth=\paperwidth  \pdfpageheight=\paperheight
	\fi
}

\def\definepapersize#1#2#3{\@namedef{tnba@papersize@#1}{\def\tnba@W{#2}\def\tnba@H{#3}}}
% |ecode !------------------------------------------------

% O estilo de página \cs\pretextual\ omite a numeração de página e desliga o modo \cs{twoside} porque os elementos pré-textuais que compreendem as folhas da capa à do sumário, devem constar no anverso da página, ou seja, na “frente” da folha.

% A instrução \cs\textual\ põe a numeração de página no topo direito nas páginas ímpares e no topo esquerdo em paginas pares. Além disso, \cs{twoside} vai espelhar as margens horizontais.

% |bcode !------------------------------------------------
\def\pretextual{\setlayout{twoside=false}%
	\let\@oddhead=\empty
	\let\@evenhead=\empty
	\let\@oddfoot=\empty
	\let\@evenfoot=\empty
}
\def\textual{\setlayout{twoside=true}%
	\def\@oddhead{\hfil\small\thepage}%
	\def\@evenhead{\small\thepage\hfil}%
	\def\@oddfoot{}%
	\def\@evenfoot{}%
	\parindent=1.5cm 
}
% |ecode !------------------------------------------------

% \sec SUMÁRIO

% Aqui, a macro \cs\extline\ foi baseada em \cs\@dottedtocline, do kernel do \LaTeX. Ela não é uma instrução privada, ou seja, com prefixo interno, porque existe a chance de o leitor querer redefiní-la.

% |bcode !------------------------------------------------
\newdimen\extlabelwidth

\def\thepage{\the\c@page}

\def\extpagenumwidth{1.55em}
\def\extrightmargin{2.55em}

\def\extline#1#2#3#4#5{\vskip0pt plus.2pt
	\extlabelwidth=#2
	\begingroup
		\parindent=#1 \leftskip=#1
		\rightskip=\extrightmargin \parfillskip=-\rightskip
		\leavevmode #3{}\advance\leftskip\extlabelwidth \hskip-\leftskip #3{#4}\nobreak\extleaders\nobreak
		\hbox to\extpagenumwidth{\hfil #5\kern-1pt\kern1pt}\nbpar
	\endgroup
}
\def\extleaders{\leaders\hbox{$\mathsurround=0pt \mkern4.5mu\hbox{.}\mkern4.5mu$}\hfill}

\def \l@toci #1#2{\addpenalty{351}\addvspace{1em plus1pt}%
	\extlabelwidth=\toclabelwidth
	\begingroup
		\parindent=0pt \rightskip=\extrightmargin \parfillskip=-\rightskip
\leavevmode \tocifont{}\advance\leftskip\extlabelwidth
		\hskip-\leftskip \tocifont{#1}\nobreak\hfil\nobreak
		\hbox to\extpagenumwidth{\hfil #2\kern-1pt\kern1pt}\par
	\endgroup
}

\def \l@tocii  {\extline{0pt}{\toclabelwidth}{\tociifont}}
\def \l@tociii {\extline{0pt}{\toclabelwidth}{\tociiifont}}
\def \l@tociv  {\extline{0pt}{\toclabelwidth}{\tocivfont}}
\def \l@tocv   {\extline{0pt}{\toclabelwidth}{\tocvfont}}
% |ecode !------------------------------------------------

% \sec SECIONAMENTO

% O comando \cs\hangfrom\ foi retirado do kernel. Ele vai ser útil na formatação das seções.

% \cs\hreftocline\ habilita hyperlinks no sumário se o \pkg{hyperref} estiver carregado.

% |bcode !------------------------------------------------
\let\hangfrom=\@hangfrom
\def\nbpar{{\interlinepenalty=10000\par}}
\def\advcount#1{\advance#1by1 }
\def\addtotoc{\hreftocline\currsecname \addcontentsline{toc}}
% |ecode !------------------------------------------------

% |bcode !------------------------------------------------
\newcount\countseclevel

\newcount\countsection
\newcount\countsubsection
\newcount\countsubsubsection
\newcount\countparagraph
\newcount\countsubparagraph

\def\thesection{\the\countsection}
\def\thesubsection{\thesection .\the\countsubsection}
\def\thesubsubsection{\thesubsection .\the\countsubsubsection}
\def\theparagraph{\thesubsubsection .\the\countparagraph}
\def\thesubparagraph{\theparagraph .\the\countsubparagraph}
% |ecode !------------------------------------------------

% Nesta parte estão definidos os comandos secionais. Nenhum destes comandos são internos, caso o leitor queira redefiní-los.

% |bcode !------------------------------------------------
\def\recountseci   {\countsubsection=0 \recountsecii}
\def\recountsecii  {\countsubsubsection=0 \recountseciii}
\def\recountseciii {\countparagraph=0 \recountseciv}
\def\recountseciv  {\countsubparagraph=0 }

\def\noindentfirst{\global\everypar={\global\everypar={}\setbox7=\lastbox}}
\def\tryindentfirst{}

\def\startsection#1{\advcount\countsection \recountseci
	\hangfrom{\sectionfont\thesection\quad}%
	{\sectionfont{#1}\nbpar}%
	\tryindentfirst
}
\def\startsubsection#1{\advcount\countsubsection \recountsecii
	\hangfrom{\subsectionfont\thesubsection\quad}%
	{\subsectionfont{#1}\nbpar}%
	\tryindentfirst
}
\def\startsubsubsection#1{\advcount\countsubsubsection \recountseciii
	\hangfrom{\subsubsectionfont\thesubsubsection\quad}%
	{\subsubsectionfont{#1}\nbpar}%
	\tryindentfirst
}
\def\startparagraph#1{\advcount\countparagraph \recountseciv
	\hangfrom{\paragraphfont\theparagraph\quad}%
	{\paragraphfont{#1}\nbpar}%
	\tryindentfirst
}
\def\startsubparagraph#1{\advcount\countsubparagraph
	\hangfrom{\subparagraphfont\thesubparagraph\quad}%
	{\subparagraphfont{#1}\nbpar}%
	\tryindentfirst
}
% |ecode !------------------------------------------------

% A instrução \cs\setcurrlabel\ ensina a forma como \cs\label's devem ser referenciados. Esse comando pode ser útil em outros contextos.

% |bcode !------------------------------------------------
\def\setcurrlabel#1{\def\@currentlabel{#1}}

\def\cfsection       {\setcurrlabel{secão\,\thesection}}
\def\cfsubsection    {\setcurrlabel{subseção\,\thesubsection}}
\def\cfsubsubsection {\setcurrlabel{subseçao\,\thesubsubsection}}
\def\cfparagraph     {\setcurrlabel{subseçao\,\theparagraph}}
\def\cfsubparagraph  {\setcurrlabel{subseçao\,\thesubparagraph}}

\def\identifysection       {\def\currsecname{section}\countseclevel=1 \cfsection}
\def\identifysubsection    {\def\currsecname{subsection}\countseclevel=2 \cfsubsection}
\def\identifysubsubsection {\def\currsecname{subsubsection}\countseclevel=3 \cfsubsubsection}
\def\identifyparagraph     {\def\currsecname{paragraph}\countseclevel=4 \cfparagraph}
\def\identifysubparagraph  {\def\currsecname{subparagraph}\countseclevel=5 \cfsubparagraph}

\def\section#1{\par \addpenalty{351}\addvspace\abovesection
	\identifysection
	\startsection{#1}%
	\marksection{#1}%
	\addtotoc{toci}{\protect\toclabelbox{\thesection}#1}%
	\par\nobreak \vskip\belowsection
}
\def\subsection#1{\par \addpenalty{351}\addvspace\abovesubsection
	\identifysubsection
	\startsubsection{#1}%
	\marksubsection{#1}%
	\addtotoc{tocii}{\protect\toclabelbox{\thesubsection}#1}%
	\par\nobreak \vskip\belowsubsection
}
\def\subsubsection#1{\par \addpenalty{351}\addvspace\abovesubsubsection
	\identifysubsubsection
	\startsubsubsection{#1}%
	\marksubsubsection{#1}%
	\addtotoc{tociii}{\protect\toclabelbox{\thesubsubsection}#1}%
	\par\nobreak \vskip\belowsubsubsection
}
\def\paragraph#1{\par \addpenalty{351}\addvspace\aboveparagraph
	\identifyparagraph
	\startparagraph{#1}%
	\markparagraph{#1}%
	\addtotoc{tociv}{\protect\toclabelbox{\theparagraph}#1}%
	\par\nobreak \vskip\belowparagraph
}
\def\subparagraph#1{\par \addpenalty{351}\addvspace\abovesubparagraph
	\identifysubparagraph
	\startsubparagraph{#1}%
	\marksubparagraph{#1}%
	\addtotoc{tocv}{\protect\toclabelbox{\thesubparagraph}#1}%
	\par\nobreak \vskip\belowsubparagraph
}
% |ecode !------------------------------------------------

% O \cs\@starttoc\ pode ser usado não apenas para criar sumários, mas, também, listas em geral, como listas de figuras, tabelas etc. as quais são armazenadas em arquivos de extensão predefinida, a saber, .toc, .lof, .lot entre outros. Portanto, \cs\makeext\ parece ter mais valor semântico.

% |bcode !------------------------------------------------
\def\toclabelbox#1{\hbox to\extlabelwidth{#1\hfil}}
\def\makeext#1{\@starttoc{#1}}
\def\tocname{Sumário}

\def\marksection#1{\markboth
	{\MakeUppercase{\thesection\quad #1}}%
	{}%
}
\def\marksubsection#1{\markright{\MakeUppercase{\thesubsection\quad #1}}}

\def\hreftocline#1{\Hy@MakeCurrentHrefAuto{#1}%
	\Hy@raisedlink{\hyper@anchorstart{\@currentHref}\hyper@anchorend}%
}

\AddToHook{begindocument}{%
	\@ifpackageloaded{hyperref}{}{\let\hreftocline=\@gobble}%
}
% |ecode !------------------------------------------------

% A macro \cs\heading\ serve para produzir títulos não contados, como “Sumário”, “Lista de figuras”, “Apêndice” etc.

% |bcode !------------------------------------------------
\def\heading#1{\par {\centering \sectionfont{#1}\par}%
	\nobreak \vskip\belowsection
}
% |ecode !------------------------------------------------

% Após a chamada da instrução \cs\appendix, \cs\section\ vai ser alterado para produzir títulos centralizados com o prefixo “Apêndice”. O mesmo vale para \cs\annex.

% |bcode !------------------------------------------------
\newcount\countappendix
\newcount\countannex

\def\theappendix{\@Alph\countappendix}
\def\theannex{\@Alph\countannex}

\def\appendixlabelwidth{6.6em}
\def\annexlabelwidth{6.2em}

\def\appendixlabelbox#1{\hbox to\appendixlabelwidth{Apêndice~#1~---~\hfil}}
\def\annexlabelbox#1{\hbox to\annexlabelwidth{Anexo~#1~---~\hfil}}

\def\l@appendix{\l@toci}
\def\l@annex{\l@toci}

\def\appendix{\def\section##1{\newpage \global\advcount\countappendix
	{\centering \sectionfont{Apêndice~\theappendix~---~##1}\par}%
	\addcontentsline{toc}{appendix}{\protect\appendixlabelbox{\theappendix}##1}%
	\nobreak \vskip\belowsection
}}
\def\annex{\def\section##1{\newpage \global\advcount\countannex
	{\centering \sectionfont{Anexo~\theannex~---~##1}\par}%
	\addcontentsline{toc}{annex}{\protect\annexlabelbox{\theannex}##1}%
	\nobreak \vskip\belowsection
}}
% |ecode !------------------------------------------------

% \sec CITAÇÕES

% Se o pacote \pkg{csquotes} estiver carregado, ele definirá sua própria versão de \cs\enquote, do contrário, o \pkg{abntexto} criará uma.

% |bcode !------------------------------------------------
\AddToHook{begindocument}{%
	\@ifpackageloaded{csquotes}{}{\protected\def\enquote#1{``#1''}}%
}

\def\Enquote#1{\par\removelastskip
	\vskip\baselineskip
	{\noindent\leftskip=4cm \small #1\nbpar}%
	\vskip\baselineskip
}
% |ecode !------------------------------------------------

% \sec ALÍNEAS

% Estas linhas não foram baseadas no ambiente \cs{list} do LaTeX, portanto, não podem ser personalizadas por pacotes como \cs{enumitem}, por exemplo.

% |bcode !------------------------------------------------
\newcount\counttopicsdepth
\newcount\counttopics

\def\topicsitem{\par\leavevmode \advcount\counttopics 
	\setcurrlabel{alínea~\@alph\counttopics )}%
	\noindent \kern \dimexpr -\parindent-\topicslabelwidth \relax
	\hbox to\topicslabelwidth{\topicsmakelabel\hfil}%
	\ignorespaces
}
\def\topicslabeli{\@alph\counttopics )}
\def\topicslabelii{---}

\def\topics{\par\penalty51 \advcount\counttopicsdepth
	\ifnum\counttopicsdepth=1 \advance\leftskip\parindent \fi
	\advance\leftskip\topicslabelwidth
	\edef\topicsmakelabel{\expandafter\noexpand\csname topicslabel\romannumeral\counttopicsdepth\endcsname}%
	\let\item=\topicsitem
	\tnba@addto\@esphack\ignorespaces
}
\def\endtopics{\par}
% |ecode !------------------------------------------------

% |bcode !------------------------------------------------

\newenvironment{description}
	{\list{}{\labelwidth=0pt \leftmargin=2em \itemindent=-\leftmargin \let\makelabel=\descriptionlabel}}
	{\endlist}

\def\descriptionlabel#1{\bfseries #1\hskip.5em }
% |ecode !------------------------------------------------

% \sec TABELAS

% Na classe \cs{article} o ambiente \cs{table} inicia o modo flutuante, mas nesta classe ele é sinônimo de \cs{tabular} porque faz mais sentido para min.

% |bcode !------------------------------------------------
\newenvironment{table}[1]{\begin{tabular}{#1}}{\end{tabular}}
% |ecode !------------------------------------------------

% \sec ÁREAS DE LEGENDA

% |bcode !------------------------------------------------
\def\tnba@getprevdepth{\par\xdef\tnba@getprevdepthA{\the\prevdepth}}
\def\tnba@useprevdepth{\par\prevdepth=\tnba@getprevdepthA}
% |ecode !------------------------------------------------

% |bcode !------------------------------------------------
\def\tnba@lastplacenum{0}

\def\definelegendplace#1#2#3#4#5{\expandafter\newcount\csname count#1\endcsname
	\@namedef{#1name}{#2}%
	\@namedef{p@#1}##1{#4}%
	\@namedef{ext@#1}{#5}%
	\@namedef{l@#5i}{\extline{0pt}{\csname #5labelwidth\endcsname}{\csname #5ifont\endcsname}}%
	\expandafter\edef\csname the#1\endcsname{\expandafter\noexpand\the\csname count#1\endcsname}%
	\@namedef{#5labelwidth}{10.4ex}%
	\@namedef{#5labelbox}##1{\hbox to\extlabelwidth{#2~##1~---\hfil}}%
	\@namedef{#5ifont}{}%
	\@namedef{make#5}{\heading{#3} \makeext{#5}\twonewpage}%
}
% |ecode !------------------------------------------------

% |bcode !------------------------------------------------
\def\tnba@makelegend{\hbox to\hsize{\hfil\tnba@makelegendA\hfil}}
\def\tnba@makelegendA{%\global\advance\csname count\tnba@savedplace\endcsname by1 
	\global\advcount{\csname count\tnba@savedplace\endcsname}%
	\vtop{\setbox0=\hbox{\legendlabel \tnba@savedlegend}%
		\ifdim\wd0>\legendmaxwidth \hsize=\legendmaxwidth \else \hsize=\wd0 \fi
		\legendlabel
		\vtop{\setbox0=\hbox{\legendlabel}\advance\hsize-\wd0 \tnba@savedlegend}%
	}%
	\edef\@tempa{\expandafter\noexpand\csname \csname ext@\tnba@savedplace\endcsname labelbox\endcsname}%
	\edef\@tempa{\noexpand\addcontentsline{\expandafter\noexpand\csname ext@\tnba@savedplace\endcsname}%
			 			                 {\expandafter\noexpand\csname ext@\tnba@savedplace\endcsname i}%
			 			                 {\noexpand\protect\expandafter\noexpand\@tempa{\noexpand\thelegend}\noexpand\tnba@savedlegend}}%
	\@tempa
}

\def\tnba@makesrc{\hbox to\hsize{\hfil\tnba@makesrcA\hfil}\tnba@useprevdepth}
\def\tnba@makesrcA{\vtop{\hsize=\tnba@placewidth \srclabel 
	\vtop{\setbox0=\hbox{\srclabel}\advance\hsize-\wd0 \tnba@savedsrc \tnba@getprevdepth}}%
}
% |ecode !------------------------------------------------

% |bcode !------------------------------------------------
\def\legend#1#2{\removelastskip
	\def\tnba@savedplace{#1}%
	\def\tnba@savedlegend{#2}%
	\setcurrlabel{\csname p@#1\expandafter\endcsname
		\the\expandafter\numexpr\csname count#1\endcsname+1}%
}

\def\legendname{\csname \tnba@savedplace name\endcsname}
\def\thelegend{\the\csname count\tnba@savedplace\endcsname}

\def\src#1{\removelastskip \def\tnba@savedsrc{#1}}
% |ecode !------------------------------------------------

% |bcode !------------------------------------------------
\let\tnba@savedplace=\empty
\let\tnba@savedlegend=\empty
\let\tnba@savedsrc=\empty

\long\def\place#1{\vskip\aboveplace
	\begingroup
		\setbox0=\hbox{\ignorespaces#1\unskip}\edef\tnba@placewidth{\the\wd0}%
		\parindent=0pt 
		\ifx\tnba@savedplace\empty\else\tnba@makelegend\fi
		\par\nointerlineskip\nobreak\vskip10pt 
		\hbox to\hsize{\hfil\box0 \hfil}%
		\par\nointerlineskip\nobreak\vskip8pt 
		\tnba@makesrc \par
	\endgroup
	\vskip\belowplace
	\let\tnba@savedplace=\empty
	\let\tnba@savedlegend=\empty
	\let\tnba@savedsrc=\empty
	\let\@currentlabel=\empty
}
% |ecode !------------------------------------------------

% \sec NOTAS DE RODAPÉ

% As notas de rodapé também foram modificadas.

% |bcode !------------------------------------------------
\let\footnotesize=\relax
\def\@makefnmark{\hbox{\@textsuperscript{\selectfont\@thefnmark}}}
\def\@makefntext#1{\hangfrom{\@makefnmark\kern2pt}\small #1}
\def\footnoterule{\kern18pt \hrule width5cm \kern2.6pt }
% |ecode !------------------------------------------------

% \sec IDENTIFICAÇÃO DO TRABALHO

% |bcode !------------------------------------------------
\def\Enter{\@ifnextchar[\tnba@EnterS{\tnba@EnterS[]}}
\def\tnba@EnterS[#1]{\vskip#1\baselineskip}

\def\twonewpage{\newpage\leavevmode\newpage}

\long\def\indexcard#1{\hbox{\vrule\vbox to7.5cm{\hsize=12.5cm \advance\hsize by-2cm \advance\hsize by-0.8pt 
	\hrule\indexcardA{#1}\vss\xindexcardbar\hrule}\vrule}%
}
\long\def\indexcardA#1{\hbox spread2cm{\hss\vbox spread2cm{\vss\ttfamily#1\vss}\hss}%
}

\def\xindexcardbar{}
\def\indexcardbar{\def\xindexcardbar{\hrule\kern1cm}}

\def\judgeline#1{\par {\centering \rule{.7\linewidth}{.6pt}\\ #1\Enter[1.5]}}

\def\corrprinton{\begingroup \def\section##1##2{\heading{##2}}}
\def\corrprintoff{\par\endgroup}
% |ecode !------------------------------------------------

% \sec A VÍRGULA COMO SEPARADOR DECIMAL

% No Brasil e em outro lugares a vírgula é um separador decimal, portanto \verb+$1,2$+ deve produzir um resultado diferente de \verb+$1, 2$+, por exemplo.

% As linhas abaixo são uma cópia da implementação do pacote \pkg{icomma}.

% |bcode !------------------------------------------------
{\catcode`,=\active
	\gdef,{\futurelet\@let@token\tnba@smartcomma}
}
\def\tnba@smartcomma{%
	\ifx\@let@token\@sptoken \else
	\ifx\@let@token\space    \else \mathord \fi\fi
	\tnba@mathcomma
}

\mathchardef\tnba@mathcomma\mathcode`\,
\mathcode`\,="8000 
% |ecode !------------------------------------------------

% Abaixo está definido um ajuste para que o \pkg{hyperref} não crie conflitos com \cs\MakeUppercase\ nas entradas do sumário.

% |bcode !------------------------------------------------
\iftnba@XETEX \else
	\AddToHook{begindocument/before}{
		\let\tnba@hyper@linkstart=\hyper@linkstart
		\protected\def\hyper@linkstart#1#2{\lowercase{\tnba@hyper@linkstart{#1}{#2}}}
	}
\fi
% |ecode !------------------------------------------------

% \sec COMANDOS OBSOLETOS

% O \pkg{abntexto} emitirá um aviso ou erro caso um destes comandos esteja obsoleto ou inexistente.

% |bcode !------------------------------------------------
\def\tnba@undefcmd#1{\def#1{\tnba@error{%
	O comando ''\string#1'' não existe mais. Linha \the\inputlineno
}}}
\def\tnba@obscmd#1#2{\def#1{\tnba@error{%
	O comando ''\string#1'' é obsoleto, use ''\unexpanded{#2}'' ao invés. Linha \the\inputlineno
}}}
\def\tnba@switchcmd#1#2{\def#1{\tnba@warning{%
	O comando ''\string#1'' é obsoleto, use ''\string#2'' ao invés. Linha \the\inputlineno
}#2}}

\tnba@undefcmd \extlineshape

\tnba@obscmd \sectionuppercase {\def\sectionfont{\MakeUppercase}}
\tnba@obscmd \tociuppercase {\def\tocifont{\MakeUppercase}}
\tnba@obscmd \sectionspaces {\def\abovesection{valor}\def\belowsection{valor}}
\tnba@obscmd \subsectionspaces {\def\abovesubsection{valor}\def\belowsubsection{valor}}
\tnba@obscmd \subsubsectionspaces {\def\abovesubsubsection{valor}\def\belowsubsubsection{valor}}
\tnba@obscmd \paragraphspaces {\def\aboveparagraph{valor}\def\belowparagraph{valor}}
\tnba@obscmd \subparagraphspaces {\def\abovesubparagraph{valor}\def\belowsubparagraph{valor}}

\tnba@switchcmd \fontsizedef \definefontsize
\tnba@switchcmd \advancecount \advcount
\tnba@switchcmd \paper \setlayout
\tnba@switchcmd \papersizedef \definepapersize
\tnba@switchcmd \makeseci   \startsection
\tnba@switchcmd \makesecii  \startsubsection
\tnba@switchcmd \makeseciii \startsubsubsection
\tnba@switchcmd \makeseciv  \startparagraph
\tnba@switchcmd \makesecv   \startsubparagraph
\tnba@switchcmd \qt \enquote
\tnba@switchcmd \quote \Enquote
% |ecode !------------------------------------------------

% \sec INICIALIZAÇÃO

% Aqui o \pkg{abntexto} define as configurações padrões. Note que \cs\pretextual\ deve ser carregado após \cs{\begin\{document\}} para evitar múltiplas chamadas deste, caso seja redefinido pelo usuário ou escritor de pacotes.

% |bcode !------------------------------------------------
\def\setnormalsize{%
	\abovedisplayskip=12pt plus3pt minus7pt 
	\belowdisplayskip=\abovedisplayskip
	\abovedisplayshortskip=0pt plus3pt 
	\belowdisplayshortskip=6.5pt plus3.5pt minus3pt 
}
\def\setsmall{%
	\abovedisplayskip=10pt plus2pt minus5pt 
	\belowdisplayskip=\abovedisplayskip
	\abovedisplayshortskip=0pt plus3pt 
	\belowdisplayshortskip=6pt plus3pt minus3pt 
}

\definefontsize{12pt}{%
	\sizedef\normalsize{12pt}{14.5pt}{\setnormalsize}%
	\sizedef\small{10pt}{12pt}{\setsmall}%
}

\setfontsize{12pt}
\spacing{1.5}

\definepapersize{A4}{210mm}{297mm}

\setlayout{
	paper=A4,
	left=3cm,
	top=3cm,
	right=2cm,
	bottom=2cm
}

\frenchspacing
\parindent=0pt 
\parskip=0pt 

\def\tocifont   {\bfseries\MakeUppercase}
\def\tociifont  {\itshape}
\def\tociiifont {\scshape}
\def\tocivfont  {}
\def\tocvfont   {}

\def\sectionfont       {\bfseries\MakeUppercase}
\def\subsectionfont    {\itshape}
\def\subsubsectionfont {\scshape}
\def\paragraphfont     {}
\def\subparagraphfont  {}

\def\abovesection       {\baselineskip}
\def\abovesubsection    {\baselineskip}
\def\abovesubsubsection {\baselineskip}
\def\aboveparagraph     {\baselineskip}
\def\abovesubparagraph  {\baselineskip}

\def\belowsection       {\baselineskip}
\def\belowsubsection    {\baselineskip}
\def\belowsubsubsection {\baselineskip}
\def\belowparagraph     {\baselineskip}
\def\belowsubparagraph  {\baselineskip}

\definelegendplace{figure}{Figura}{Lista de figuras}{fig.\,#1}{lof}
\definelegendplace{table}{Tabela}{Lista de tabelas}{tab.\,#1}{lot}

\def\legendlabel{\legendname ~\thelegend ~---~}
\def\srclabel{\raggedright\small Fonte:~}
\def\legendmaxwidth{0.7\linewidth}

\def\aboveplace{\baselineskip}
\def\belowplace{\baselineskip}

\def\toclabelwidth{3.4ex}
\def\maketoc{\heading{Sumário} \makeext{toc}\newpage}

\def\topicslabelwidth{4ex}

\arrayrulewidth=0.4pt 

\topskip=12pt 

\AddToHook{begindocument}{\pretextual}

\endinput
% |ecode !------------------------------------------------
