.PS
# LoglogSVG.m4
gen_init(svg_font(sans-serif,11bp__))
maxpswid = 12

LL: [
define(`rint',`sign(`$1')*int(abs(`$1')+.5)')
S:[
  horiz = 4
  vert = horiz*2/3
  tmax = 10
  tmin = 1
  vmax = 100
  vmin = 0.1
  tic = 0.08
  denv = log(vmax) - log(vmin)
  denh = log(tmax) - log(tmin)

  Origin: Here
  define(`coord',
    `Origin+((log(`$1')-log(tmin))/denh*horiz,(log(`$2')-log(vmin))/denv*vert)')

thinlines_
# Left axes and labels
  psset_(linecolor=gray)
  for i = rint(log(vmin)) to rint(log(vmax)) do {
    move to coord(tmin,exp(i))
    line right horiz
    sprintf("%g",exp(i)) wid 0.2 rjust at last line.start
    if i < rint(log(vmax)) then {
      for j = 2 to 9 do { move to coord(tmin,j*exp(i))
        line right horiz
        if (j==2) || (j==5) then {
          sprintf("%g",j*exp(i)) rjust at last line.start }
        } } }

#Horizontal axis and labels
  for t = rint(log(tmin)) to rint(log(tmax)) do {
    move to coord(exp(t),vmin)
    line up vert
    sprintf("%g",exp(t)) wid 0.15 below at last line.start
    if t < rint(log(tmax)) then {
      for j = 2 to 9 do { move to coord(j*exp(t),vmin)
        line up vert
        if (j==2) || (j==5) then {
          sprintf("%g",j*exp(t)) below at last line.start }
        } } }
  psset_(linecolor=black)

# arrow from Origin up vert chop 0 chop -0.1
  line from Origin up vert
  "svg_it(y(t))" wid 0.3 at Origin+(-0.1,0.5*vert) rjust

# arrow from Origin right horiz chop 0 chop -0.1
  line from Origin right horiz
  "svg_it(t)" at Origin+(.5*horiz,-0.1) below

thicklines_
  alpha = 2.5
  beta = 3.0
  tm = max(tmin,(vmin/alpha)^(1/beta))
  tM = min(tmax,(vmax/alpha)^(1/beta))
  line from coord(tm,alpha*tm^beta) to coord(tM,alpha*tM^beta)
P: box invis fill_(1) wid 0.75 ht 0.18 \
   "svg_it(y(t) = 1.5 t)" with .w at coord(2.005,14)
   "svg_it(svg_small(3))" with .w at P.ne #ljust

  alpha = 0.05
  beta = 2.0
  tm = max(tmin,(vmin/alpha)^(1/beta))
  tM = min(tmax,(vmax/alpha)^(1/beta))
  line from coord(tm,alpha*tm^beta) to coord(tM,alpha*tM^beta)
Q: box invis fill_(1) wid 0.80 ht 0.18 \
   "svg_it(y(t) = 0.05 t)" with .e at coord(4.6,1.4)
   "svg_it(svg_small(2))" with .w at Q.ne #ljust

]

# box wid S.wid ht S.ht at S
# print (S.wid,S.ht)/(1 pc__)
 command "</g>" # end font
] # LL
#showbox_

Cons: [
#.PS
## Consumption.m4
#gen_init
svg_font(Helvetica,10pt__)

#svg_rot_init(test)
svg_rot_init(LoglogSVG)

divert(-1)
                               `brace(linespec,depth,arm thickness,attributes)
                                Curly brace along linespec
                                default depth is linewid/5
                                attributes = eg
                                  thick 0.4 outlined "string" shaded "string"
                                  (default black)'
define(`brace',`rpoint_(ifelse(`$1',,`to rvec_(linewid,0)',`$1'))
  M4brS: last line.start; M4brE: last line.end
  [ brdepth = ifelse(`$2',,linewid/5,`$2')
    brthick = ifelse(`$3',,brdepth/6,`$3')
    define(`m4braceattribs',
     `ifelse(`$4',,`thick 0.4 shaded rgbstring(0,0,0)',`$4')')dnl
    tension = 0.55
    halfwid = distance(M4brS,M4brE)
    smallrad = brdepth-brthick
    bigrad = brdepth+brthick
    for sgn=1 to -1 by -2 do {
      S: rvec_(sgn*halfwid/2,0)
      A: S+vec_(0,smallrad/2)
      B: vec_(0,smallrad/2)
      T: vec_(0,brdepth)
      C: vec_(0,bigrad/2)
      D: vec_(sgn*halfwid/2,bigrad/2)
      {spline tension m4braceattribs \
        from S to tension between S and A \
        then to tension between A-vec_(sgn*bigrad/2,0) and A \
        then to A-vec_(sgn*bigrad/2,0) \
        then to B+vec_(sgn*bigrad/2,0) \
        then to tension between B+vec_(sgn*bigrad/2,0) and B \
        then to tension between T and B \
        then to T \
        then to tension between T and C \
        then to tension between C+vec_(sgn*bigrad/2,0) and C \
        then to C+vec_(sgn*bigrad/2,0) \
        then to D-vec_(sgn*bigrad/2,0) \
        then to tension between D-vec_(sgn*bigrad/2,0) and D \
        then to tension between S and D \
        then to S }
      }
    E: (0,0)
] with .E at 0.5 between M4brS and M4brE')
divert(0)dnl

#nl                               raw data ranges
  rxmin=1.76665, rxmax=5.87332, rymin=1.49164, rymax=4.00836

#nl                               horiz range
  yearmin = 1850
  yearmax = 2040
#nl                               data ranges
  tonsmin = 0
  tonsmax = 2.0
  popmin = 0
  popmax = 10
#nl                               page graph size
  minx = 0
  maxx = 4.5
  maxx = 4.566
  miny = 0
  maxy = 3.5

define  dtop {(minx + ($1-yearmin)/(yearmax-yearmin)*(maxx-minx), \
               miny + ($2-tonsmin)/(tonsmax-tonsmin)*(maxy-miny))}
define  ptop {(minx + ($1-yearmin)/(yearmax-yearmin)*(maxx-minx), \
               miny + ($2-popmin)/(popmax-popmin)*(maxy-miny))}

define(`rtod',`yearmin + (`$1'-rxmin)/(rxmax-rxmin)*(2010-yearmin), \
               tonsmin + (`$2'-rymin)/(rymax-rymin)*1.8')

[
nD = 0
define data { nD+=1
  yr[nD]=$1; pop[nD]=$2/1e9; wood[nD]=$3; other[nD]=$4; hydro[nD]=$5
  coal[nD]=$6; oil[nD]=$7; gas[nD]=$8; nuclear[nD]=$9 }

data(1850,1241000000,0.238506368,0.238506368,0.238506368,0.274220157,0.274220157,0.276138711,0.276138711)
data(1851,1247847137,0.238701076,0.238701076,0.238701076,0.2788137,0.2788137,0.280785327,0.280785327)
data(1852,1254732053,0.238886465,0.238886465,0.238886465,0.287918165,0.287918165,0.289942225,0.289942225)
data(1853,1261654955,0.239062633,0.239062633,0.239062633,0.290097546,0.290097546,0.292173405,0.292173405)
data(1854,1268616055,0.239229675,0.239229675,0.239229675,0.289984551,0.289984551,0.292111579,0.292111579)
data(1855,1275615561,0.239387687,0.239387687,0.239387687,0.289864062,0.289864062,0.292041635,0.292041635)
data(1856,1282653687,0.239651345,0.239651345,0.239651345,0.301026039,0.301026039,0.303253538,0.303253538)
data(1857,1289730646,0.239904902,0.239904902,0.239904902,0.298720029,0.298720029,0.300996841,0.300996841)
data(1858,1296846651,0.24014846,0.24014846,0.24014846,0.303062054,0.303062054,0.30538757,0.30538757)
data(1859,1304001918,0.240382123,0.240382123,0.240382123,0.309545901,0.309914765,0.312288384,0.312288384)
data(1860,1311196664,0.24060599,0.24060599,0.24060599,0.309390256,0.310123937,0.312545059,0.312545059)
data(1861,1318431107,0.240590657,0.240590657,0.240590657,0.319869525,0.320964008,0.323432041,0.323432041)
data(1862,1325705465,0.240568247,0.240568247,0.240568247,0.308599723,0.310051026,0.312565381,0.312565381)
data(1863,1333019958,0.24053884,0.24053884,0.24053884,0.318950063,0.320754238,0.323314334,0.323314334)
data(1864,1340374810,0.240502511,0.240502511,0.240502511,0.327038715,0.329191844,0.331797103,0.331797103)
data(1865,1347770241,0.240459339,0.240459339,0.240459339,0.328647778,0.331145979,0.333795828,0.333795828)
data(1866,1347770241,0.242191279,0.242191279,0.242191279,0.330379718,0.333234804,0.335943539,0.335943539)
data(1867,1362683739,0.241253672,0.241253672,0.241253672,0.336892133,0.340068952,0.342806283,0.342806283)
data(1868,1370202258,0.24163346,0.24163346,0.24163346,0.336747138,0.340257568,0.3430378,0.3430378)
data(1869,1377762260,0.242001817,0.242001817,0.242001817,0.33659359,0.340433875,0.343256455,0.343256455)
data(1870,1385363974,0.242358855,0.242358855,0.242358855,0.348847699,0.353014113,0.355878493,0.355878493)
data(1871,1393007630,0.24215233,0.24215233,0.24215233,0.358346838,0.362835686,0.365741322,0.365741322)
data(1872,1400693459,0.241940775,0.241940775,0.241940775,0.365684522,0.37049214,0.373438493,0.373438493)
data(1873,1408421694,0.24172425,0.24172425,0.24172425,0.360718048,0.365840803,0.368827338,0.368827338)
data(1874,1416192570,0.241502816,0.241502816,0.241502816,0.363892286,0.369326575,0.372352763,0.372352763)
data(1875,1424006320,0.241276535,0.241276535,0.241276535,0.362994434,0.368736684,0.371802,0.371802)
data(1876,1431863183,0.240604702,0.240604702,0.240604702,0.369663316,0.375709983,0.378813907,0.378813907)
data(1877,1439763395,0.239932976,0.239932976,0.239932976,0.368283426,0.374630997,0.377773011,0.377773011)
data(1878,1447707196,0.239261379,0.239261379,0.239261379,0.366907548,0.373552539,0.376732133,0.376732133)
data(1879,1455694826,0.238589927,0.238589927,0.238589927,0.373413172,0.380352127,0.383568794,0.383568794)
data(1880,1463726528,0.23791864,0.23791864,0.23791864,0.383753486,0.390982979,0.394236217,0.394236217)
data(1881,1471802544,0.237570608,0.237570608,0.237570608,0.392344331,0.399860965,0.403150275,0.403150275)
data(1882,1479923119,0.237219231,0.237219231,0.237227977,0.396963826,0.404764232,0.40808912,0.40808912)
data(1883,1488088499,0.236864558,0.236864558,0.236881953,0.403447314,0.411528151,0.414888128,0.414888128)
data(1884,1496298931,0.236506634,0.236506634,0.236532584,0.406015836,0.414373792,0.417768372,0.417768372)
data(1885,1504554663,0.236145507,0.236145507,0.236179917,0.404733187,0.413364978,0.416793681,0.416793681)
data(1886,1512855946,0.235261191,0.235261191,0.235303968,0.40293236,0.411834727,0.415297076,0.415297076)
data(1887,1521203030,0.23437947,0.23437947,0.23443052,0.406792802,0.415962519,0.419458041,0.419458041)
data(1888,1529596169,0.233500342,0.233500342,0.233559574,0.423718314,0.433152176,0.436680404,0.436680404)
data(1889,1538035617,0.232623805,0.232623805,0.232691127,0.425534315,0.435229149,0.438789617,0.438789617)
data(1890,1546521628,0.231749857,0.231749857,0.231825179,0.431025052,0.44097771,0.444569959,0.444569959)
data(1891,1555054461,0.23057828,0.23057828,0.230661512,0.436142504,0.446349864,0.449973439,0.449973439)
data(1892,1563634373,0.229412583,0.229412583,0.229503635,0.439357394,0.449816361,0.453470809,0.453470809)
data(1893,1572261624,0.228252736,0.228252736,0.228351521,0.431583686,0.442291192,0.445976065,0.445976065)
data(1894,1580936476,0.22709871,0.22709871,0.22720514,0.436575574,0.447528576,0.45124343,0.45124343)
data(1895,1589659190,0.225950477,0.225950477,0.226064464,0.441499685,0.452695166,0.456439562,0.456439562)
data(1896,1598430032,0.225392144,0.225392144,0.225513603,0.450527775,0.461962746,0.465736247,0.465736247)
data(1897,1607249265,0.224833135,0.224833135,0.224961981,0.457659825,0.469331318,0.473133492,0.473133492)
data(1898,1616117159,0.224273475,0.224273475,0.224409622,0.473569462,0.48547454,0.489304958,0.489304958)
data(1899,1625033980,0.223713188,0.223713188,0.223856553,0.494583176,0.506718923,0.510577162,0.510577162)
data(1900,1634000000,0.223152296,0.223152296,0.223302795,0.504825195,0.51718872,0.521074359,0.521074359)
data(1901,1648219401,0.221510378,0.221510378,0.221677629,0.505816316,0.519528083,0.5237969,0.5237969)
data(1902,1662562543,0.219880182,0.219880182,0.220068436,0.508573752,0.523333498,0.527978592,0.527978592)
data(1903,1677030501,0.218261627,0.218261627,0.218478353,0.530583699,0.546223844,0.551238406,0.551238406)
data(1904,1691624363,0.216654634,0.216654634,0.216900192,0.527887731,0.545298807,0.550676116,0.550676116)
data(1905,1706345223,0.215059124,0.215059124,0.215337131,0.547716584,0.564693219,0.570426643,0.570426643)
data(1906,1721194188,0.214836225,0.214836225,0.215148552,0.563118074,0.579880854,0.585963848,0.585963848)
data(1907,1736172371,0.214601167,0.214601167,0.214954035,0.596547339,0.617095414,0.62352152,0.62352152)
data(1908,1751280897,0.214354174,0.214354174,0.214752998,0.574277169,0.596299335,0.60306218,0.60306218)
data(1909,1766520901,0.214095471,0.214095471,0.214542936,0.586977877,0.609919015,0.61701231,0.61701231)
data(1910,1781893526,0.213825278,0.213825278,0.214318488,0.603352348,0.628089516,0.635693908,0.635693908)
data(1911,1797399927,0.212500054,0.212500054,0.213041248,0.605588411,0.631564823,0.639504319,0.639504319)
data(1912,1813041268,0.211181781,0.211181781,0.211751647,0.620130467,0.646297549,0.654565803,0.654565803)
data(1913,1828818723,0.209870438,0.209870438,0.210513435,0.644310839,0.672912362,0.681503109,0.681503109)
data(1914,1844733476,0.208566004,0.208566004,0.209324315,0.595307622,0.624513467,0.633420528,0.633420528)
data(1915,1860786724,0.207268457,0.207268457,0.208098411,0.584702733,0.615780985,0.624998263,0.624998263)
data(1916,1876979669,0.204485426,0.204485975,0.205402589,0.605882504,0.638934007,0.648455487,0.648455487)
data(1917,1893313529,0.201734987,0.201735896,0.202715085,0.616179081,0.652399178,0.662218924,0.662218924)
data(1918,1909789530,0.199016787,0.199017732,0.200115349,0.602687652,0.638337653,0.648449811,0.648449811)
data(1919,1926408908,0.196330472,0.196331097,0.196945715,0.535439366,0.575689906,0.586088699,0.586088699)
data(1920,1943172912,0.193675695,0.193676005,0.195243412,0.579848388,0.630973534,0.641653264,0.641653264)
data(1921,1960082799,0.192957547,0.192958381,0.194440762,0.512833825,0.567705487,0.578660532,0.578660532)
data(1922,1977139839,0.192237376,0.192238246,0.193895625,0.527050727,0.587771773,0.599365431,0.599365431)
data(1923,1994345313,0.19151527,0.191516348,0.193525554,0.578230714,0.649426509,0.662893064,0.662893064)
data(1924,2011700513,0.190791315,0.190792469,0.192986897,0.564368556,0.634750802,0.650057077,0.650057077)
data(1925,2029206742,0.190065598,0.190066911,0.192579912,0.561692328,0.634850472,0.651963721,0.651963721)
data(1926,2046865313,0.189342426,0.18934419,0.192313939,0.556598403,0.631036129,0.649924035,0.649924035)
data(1927,2064677552,0.188617585,0.188619709,0.191901916,0.581066305,0.66532014,0.685950808,0.685950808)
data(1928,2082644798,0.187891159,0.187893595,0.191560967,0.570524051,0.658240401,0.680582356,0.680582356)
data(1929,2082644798,0.188791962,0.188794439,0.19317309,0.596191895,0.694524554,0.718247863,0.718247863)
data(1930,2119049713,0.186433874,0.186436187,0.190385499,0.552331717,0.644491424,0.668934944,0.668934944)
data(1931,2137490116,0.185921585,0.185923717,0.190113868,0.506565457,0.594964462,0.620348577,0.620348577)
data(1932,2156090991,0.185404259,0.185406253,0.189724679,0.468661357,0.552304395,0.578611056,0.578611056)
data(1933,2174853735,0.184882022,0.184885026,0.189466471,0.478973885,0.569521584,0.596732983,0.596732983)
data(1934,2193779755,0.184354996,0.184357857,0.189137885,0.50231919,0.597048389,0.625146959,0.625146959)
data(1935,2212870475,0.183823303,0.183826489,0.189391253,0.513244919,0.615346693,0.6443151,0.6443151)
data(1936,2232127325,0.183422624,0.183426207,0.189292235,0.541976812,0.652213355,0.6820345,0.6820345)
data(1937,2251551752,0.183015177,0.183016132,0.189691455,0.557024422,0.681411525,0.713128315,0.713128315)
data(1938,2271145215,0.182601109,0.182608794,0.189219601,0.528985648,0.649365004,0.682755166,0.682755166)
data(1939,2290909184,0.182180563,0.182198879,0.189050477,0.544855454,0.669193862,0.704673928,0.704673928)
data(1940,2310845143,0.181753683,0.181773628,0.188817984,0.577859192,0.705095325,0.742626751,0.742626751)
data(1941,2330954589,0.180256141,0.180280081,0.187681608,0.587475315,0.717410922,0.756955672,0.756955672)
data(1942,2351239032,0.17877091,0.178803567,0.18636161,0.589499673,0.710751063,0.752271606,0.752271606)
data(1943,2371699993,0.17729789,0.177330845,0.185849103,0.596589637,0.725948747,0.769408049,0.769408049)
data(1944,2392339011,0.17583698,0.175847008,0.183932936,0.574921594,0.722215099,0.767576618,0.767576618)
data(1945,2413157633,0.174388081,0.174391359,0.182283924,0.493293215,0.63914527,0.68637295,0.68637295)
data(1946,2434157423,0.173522919,0.173531361,0.182267965,0.514250229,0.668057865,0.717384008,0.717384008)
data(1947,2455339957,0.172659705,0.172683238,0.181755468,0.551547112,0.719518964,0.773619655,0.773619655)
data(1948,2476706827,0.17179847,0.171828917,0.181742644,0.560535238,0.749010917,0.809647204,0.809647204)
data(1949,2498259635,0.170939245,0.17097559,0.181133719,0.538171636,0.723949765,0.788183962,0.788183962)
data(1950,2557628654,0.167579756,0.167622721,0.178408185,0.559396293,0.762977841,0.834822272,0.834822272)
data(1951,2594938936,0.167032664,0.167085184,0.179115513,0.574723533,0.802272625,0.886283415,0.886283415)
data(1952,2636770386,0.166215588,0.166275557,0.178905263,0.565999791,0.801386992,0.890443027,0.890443027)
data(1953,2682050452,0.165211328,0.165271599,0.178153454,0.56040182,0.805094458,0.897685967,0.897685967)
data(1954,2730224110,0.164066346,0.164125585,0.177552809,0.548214509,0.799870041,0.895277726,0.895277726)
data(1955,2782093851,0.162744571,0.162802026,0.177062242,0.572289721,0.849071541,0.950920777,0.950920777)
data(1956,2835293441,0.161343608,0.161397559,0.176802814,0.586639897,0.882197665,0.990604979,0.990610309)
data(1957,2891342302,0.159836585,0.159890471,0.176313385,0.589494533,0.894932945,1.010584994,1.010622753)
data(1958,2948128605,0.158347259,0.158403549,0.176092897,0.594122165,0.901178987,1.023306716,1.023348608)
data(1959,3000706677,0.157134282,0.157194027,0.175092878,0.60075882,0.926301469,1.060278841,1.060403012)
data(1960,3042990271,0.156490706,0.156555865,0.175795691,0.61309257,0.958977014,1.102738263,1.102971765)
data(1961,3084007286,0.155724141,0.155801371,0.175847845,0.582341401,0.945610971,1.097964839,1.098333034)
data(1962,3140187350,0.154229357,0.154309778,0.175037739,0.583886676,0.970894477,1.134494733,1.135032498)
data(1963,3209978774,0.152139251,0.152229147,0.173552486,0.585699084,0.991892736,1.166953505,1.167858812)
data(1964,3281412257,0.150062967,0.150160837,0.171811855,0.592867755,1.021995792,1.209049525,1.210281169)
data(1965,3350699989,0.14816998,0.148271574,0.171655685,0.592192206,1.043069039,1.239349435,1.241269627)
data(1966,3421015609,0.147131043,0.14723349,0.171776593,0.589397107,1.068586677,1.275452622,1.27813231)
data(1967,3490735455,0.146158896,0.14626543,0.170803075,0.56557596,1.069927556,1.288070014,1.291237119)
data(1968,3562786611,0.145129793,0.1452355,0.170411047,0.568040201,1.107666962,1.34146315,1.345320724)
data(1969,3637707956,0.14402776,0.144141478,0.170254838,0.567570209,1.136409991,1.38786865,1.392325229)
data(1970,3713327898,0.142943308,0.143053274,0.169862261,0.574604634,1.187424472,1.460093809,1.4656198)
data(1971,3790980082,0.141867123,0.1419725,0.169518561,0.562377273,1.199174341,1.484731543,1.492185663)
data(1972,3867242256,0.14088476,0.141006603,0.169241956,0.55299154,1.211873977,1.508449967,1.518429829)
data(1973,3942790520,0.139965732,0.140098019,0.168229646,0.551337808,1.256519325,1.5637256,1.576827076)
data(1974,4017323955,0.139116394,0.139264313,0.169566501,0.548855283,1.243354913,1.55159078,1.568155026)
data(1975,4088810897,0.138401041,0.13856795,0.16866321,0.563492361,1.21131787,1.515162671,1.537578295)
data(1976,4158888836,0.137644673,0.137823056,0.167542119,0.566773642,1.257660106,1.569161684,1.594857237)
data(1977,4229748034,0.136888084,0.137068744,0.166990254,0.571441309,1.275256046,1.610533422,1.641644931)
data(1978,4300631215,0.136155668,0.136323913,0.168223987,0.572181835,1.27205561,1.591706702,1.627562741)
data(1979,4374349678,0.135359212,0.13557451,0.168367796,0.588798681,1.303224877,1.642092677,1.678738222)
data(1980,4445423675,0.13466922,0.135694224,0.169018612,0.535103352,1.264795628,1.575204786,1.612060086)
data(1981,4526817917,0.134213008,0.135336361,0.168515198,0.530410164,1.209074468,1.518426926,1.559512282)
data(1982,4607193353,0.133802494,0.135342954,0.168753641,0.536996737,1.176267133,1.47980709,1.52463367)
data(1983,4688582743,0.133377208,0.135246041,0.169576319,0.532088682,1.158420925,1.46002144,1.510279864)
data(1984,4767669177,0.133030663,0.135364454,0.170242063,0.54694641,1.180279911,1.506703536,1.566412047)
data(1985,4849860549,0.132610473,0.135051242,0.169658748,0.552747513,1.171095757,1.504285752,1.573424331)
data(1986,4934211409,0.131291387,0.133685377,0.168393392,0.554194404,1.186400652,1.520044231,1.593296333)
data(1987,5021085089,0.129951317,0.132539382,0.166722644,0.554231496,1.181208808,1.524791298,1.603295671)
data(1988,5108736553,0.128637242,0.13125772,0.166140318,0.556210491,1.195203161,1.549641815,1.633219996)
data(1989,5195979089,0.127377522,0.13079373,0.164881748,0.553926742,1.193159265,1.553390392,1.638232703)
data(1990,5284252039,0.126134805,0.129737215,0.164632138,0.553384674,1.190735096,1.553386431,1.640350219)
data(1991,5367488662,0.125428663,0.12928236,0.164254982,0.528423389,1.154980396,1.516498613,1.613399159)
data(1992,5452187873,0.124710625,0.128643771,0.163153115,0.518552304,1.13735672,1.494240768,1.590566106)
data(1993,5534418049,0.12406988,0.128046593,0.163990775,0.50470235,1.119339298,1.477198192,1.575200738)
data(1994,5614530098,0.123494469,0.127690239,0.163473418,0.506216459,1.12531413,1.481458633,1.580083078)
data(1995,5695823105,0.122909758,0.127213893,0.164248122,0.510641048,1.135855904,1.49167459,1.592774524)
data(1996,5776327747,0.12216812,0.12649691,0.163557636,0.510522671,1.141850345,1.503121808,1.606488473)
data(1997,5854841500,0.121488167,0.12619452,0.163583023,0.524945344,1.167177534,1.523679854,1.624760285)
data(1998,5932024858,0.120853308,0.125593429,0.162567495,0.521014085,1.167330383,1.52595967,1.627688406)
data(1999,6008646651,0.120245994,0.125081498,0.162173341,0.512693203,1.14325022,1.505666716,1.609442579)
data(2000,6084703879,0.119665076,0.124729832,0.16178992,0.513011266,1.158715327,1.529969497,1.634878653)
data(2001,6160890093,0.119894056,0.125258541,0.161095098,0.524198822,1.1611659,1.535602425,1.642047723)
data(2002,6237154134,0.118903979,0.124921559,0.160784753,0.529942594,1.153921617,1.530689162,1.637033401)
data(2003,6313942570,0.117913902,0.124642773,0.160192176,0.546832827,1.182503339,1.566938847,1.670839416)
data(2004,6390636309,0.116923825,0.12432827,0.161759107,0.565673251,1.221114221,1.610936278,1.717713694)
data(2005,6467431499,0.115933748,0.124259776,0.162887647,0.604148825,1.263290753,1.659620623,1.765386482)
data(2006,6545218993,0.114943672,0.124695239,0.164252513,0.623509498,1.274460793,1.680457898,1.786351327)
data(2007,6623523655,0.113953595,0.125629532,0.165251003,0.637952129,1.279256584,1.68820381,1.790810594)
data(2008,6702159402,0.112963518,0.127142703,0.167940953,0.64989848,1.292105043,1.710278853,1.811269586)
data(2009,6780833881,0.111973441,0.127858368,0.168866486,0.654393109,1.282816573,1.686869485,1.785251313)
data(2010,6858584755,0.110983364,0.12921584,0.172117414,0.680609275,1.328410794,1.756431211,1.856334479)
data(2011,6935999491,0.109993287,0.130385385,0.173636892,0.704216284,1.348176864,1.785673581,1.880255695)
data(2012,7013871313,0.10900321,0.130975574,0.175672274,0.688388925,1.341250864,1.785302272,1.872409847)
data(2013,7092128094,0.108013133,0.132480909,0.177353971,0.688378378,1.336238537,1.781754888,1.868322734)
data(2014,7169968185,0.107023056,0.133567224,0.177755023,0.681107631,1.336758872,1.78693987,1.874787234)
data(2015,7247892788,0,0,0,0,0,0,0)
data(2016,7325996709,0,0,0,0,0,0,0)
data(2017,7405107650,0,0,0,0,0,0,0)
nD0=nD-3

define yrdata { nyd +=1; yrd[nyd]=$1; ypop[nyd]=$2/1e9 }

nyd = 0
yrdata(1850,1169923623)
yrdata(1851,1177298999)
yrdata(1852,1184724181)
yrdata(1853,1192199527)
yrdata(1854,1199725401)
yrdata(1855,1207302168)
yrdata(1856,1214930197)
yrdata(1857,1222609858)
yrdata(1858,1230341525)
yrdata(1859,1238125576)
yrdata(1860,1245962390)
yrdata(1861,1253852349)
yrdata(1862,1261795840)
yrdata(1863,1269793250)
yrdata(1864,1277844972)
yrdata(1865,1285951399)
yrdata(1866,1294112930)
yrdata(1867,1302329966)
yrdata(1868,1310602910)
yrdata(1869,1318932168)
yrdata(1870,1327318152)
yrdata(1871,1335761275)
yrdata(1872,1344261952)
yrdata(1873,1352820603)
yrdata(1874,1361437653)
yrdata(1875,1370113525)
yrdata(1876,1379548537)
yrdata(1877,1389051752)
yrdata(1878,1398623687)
yrdata(1879,1408264863)
yrdata(1880,1417975804)
yrdata(1881,1427757042)
yrdata(1882,1437609109)
yrdata(1883,1447532543)
yrdata(1884,1457527886)
yrdata(1885,1467595685)
yrdata(1886,1477736490)
yrdata(1887,1487950857)
yrdata(1888,1498239345)
yrdata(1889,1508602518)
yrdata(1890,1519040944)
yrdata(1891,1529555197)
yrdata(1892,1540145854)
yrdata(1893,1550813497)
yrdata(1894,1561558712)
yrdata(1895,1572382092)
yrdata(1896,1583284233)
yrdata(1897,1594265734)
yrdata(1898,1605327202)
yrdata(1899,1616469247)
yrdata(1900,1630171098)
yrdata(1901,1644554295)
yrdata(1902,1659067684)
yrdata(1903,1673712471)
yrdata(1904,1688489874)
yrdata(1905,1703401122)
yrdata(1906,1718447458)
yrdata(1907,1733630134)
yrdata(1908,1748950415)
yrdata(1909,1764409579)
yrdata(1910,1780008913)
yrdata(1911,1795749721)
yrdata(1912,1811633314)
yrdata(1913,1827661021)
yrdata(1914,1843834178)
yrdata(1915,1860154139)
yrdata(1916,1876622267)
yrdata(1917,1893239939)
yrdata(1918,1910008546)
yrdata(1919,1926929491)
yrdata(1920,1944419089)
yrdata(1921,1962566145)
yrdata(1922,1980884876)
yrdata(1923,1999376931)
yrdata(1924,2018043972)
yrdata(1925,2023803913)
yrdata(1926,2043462180)
yrdata(1927,2063406322)
yrdata(1928,2082689730)
yrdata(1929,2103850414)
yrdata(1930,2124167500)
yrdata(1931,2143802732)
yrdata(1932,2164157870)
yrdata(1933,2184604692)
yrdata(1934,2205534997)
yrdata(1935,2226530597)
yrdata(1936,2247993326)
yrdata(1937,2268545035)
yrdata(1938,2290267593)
yrdata(1939,2312702889)
yrdata(1940,2350947590)
yrdata(1941,2373554827)
yrdata(1942,2396382640)
yrdata(1943,2419433211)
yrdata(1944,2442708748)
yrdata(1945,2466211477)
yrdata(1946,2489943650)
yrdata(1947,2513907539)
yrdata(1948,2538105439)
yrdata(1949,2562539670)
yrdata(1950,2579434878)
yrdata(1951,2653954580)
yrdata(1952,2692712961)
yrdata(1953,2732388944)
yrdata(1954,2772909569)
yrdata(1955,2814390135)
yrdata(1956,2856675848)
yrdata(1957,2899864004)
yrdata(1958,2943689748)
yrdata(1959,2987555529)
yrdata(1960,3030709021)
yrdata(1961,3090453463)
yrdata(1962,3137151355)
yrdata(1963,3211786601)
yrdata(1964,3270671214)
yrdata(1965,3330055803)
yrdata(1966,3401169329)
yrdata(1967,3463250974)
yrdata(1968,3526647458)
yrdata(1969,3591511933)
yrdata(1970,3657420066)
yrdata(1971,3724116214)
yrdata(1972,3791497136)
yrdata(1973,3859732004)
yrdata(1974,3928723212)
yrdata(1975,3998320921)
yrdata(1976,4080634693)
yrdata(1977,4156349026)
yrdata(1978,4233151108)
yrdata(1979,4311785729)
yrdata(1980,4391777096)
yrdata(1981,4472736872)
yrdata(1982,4555816222)
yrdata(1983,4640588050)
yrdata(1984,4726272158)
yrdata(1985,4813567478)
yrdata(1986,4902566593)
yrdata(1987,4985904892)
yrdata(1988,5070443631)
yrdata(1989,5156030340)
yrdata(1990,5219191372)
yrdata(1991,5304659362)
yrdata(1992,5390911229)
yrdata(1993,5477320137)
yrdata(1994,5564356643)
yrdata(1995,5652711036)
yrdata(1996,5738516173)
yrdata(1997,5824945702)
yrdata(1998,5912061676)
yrdata(1999,5999735497)
yrdata(2000,6088144560)
yrdata(2001,6173932167)
yrdata(2002,6250016823)
yrdata(2003,6326520742)
yrdata(2004,6403805522)
yrdata(2005,6481944062)
yrdata(2006,6525559210)
yrdata(2007,6602274812)
yrdata(2008,6789771253)
yrdata(2009,6873741054)
yrdata(2010,6958169159)
yrdata(2011,7043008586)
yrdata(2012,7128176935)
yrdata(2013,7213426452)
yrdata(2014,7298453033)
yrdata(2015,7383008820)
yrdata(2016,7466964280)
yrdata(2017,7550262101)

Left: line from dtop(yearmin,tonsmin) to dtop(yearmin,tonsmax)
  htic = 8pt__
# htic = maxy
  vtic = 13pt__/2
# vtic = maxy
  "0" wid 5bp__ at dtop(yearmin,tonsmin) rjust above
  for y=0.2 to 2 by 0.2 do {
    move to dtop(yearmin,y)
    if y<2 then {{ line right htic }}
    sprintf("%g",y) wid 5bp__ rjust }
  svg_rot(90,"Tonnes of oil equivalent per capita" at Left-(0.3,0))

Right: line from dtop(yearmax,tonsmin) to dtop(yearmax,tonsmax)
  for p=0 to popmax do {
    move to ptop(yearmax,p)
    if p>0 && p<popmax then {{ line left htic }}
    sprintf("%g",p) wid 5 bp__ ljust }
  [svg_rot(90,"World population (billions)")] wid 10bp__ ht 114bp__ \
    with .w at Right+(0.25,0)

Bot: line from Left.start to Right.start
  for t=yearmin+10 to yearmax-10 by 10 do {
    line up vtic from dtop(t,tonsmin) }
  for t=yearmin to yearmax by 50 do {
    sprintf("%g",t) wid 5bp__ at dtop(t,tonsmin) below }
  "Year" wid 20bp__ at Bot+(0,-0.15) below

Top: line from Left.end to Right.end

# Population to 2017
linethick_(2.5)

NPopulation: \
  spline ctension_ dotted 1.5pt__ from ptop(yrd[1],ypop[1]) \
    to ptop(yrd[2],ypop[2])
  for y=3 to nyd by 10 do { continue to ptop(yrd[y],ypop[y]) }
  for yy=y-10+1 to nyd do { continue to ptop(yrd[yy],ypop[yy]) }

thicklines_
# Wood
  spline ctension_ from dtop(yr[1],wood[1]) to dtop(yr[2],wood[2])
  for y=3 to nD0 do { continue to dtop(yr[y],wood[y]) }

# Other
  spline ctension_ from dtop(yr[1],other[1]) to dtop(yr[2],other[2])
  for y=3 to nD0 do { continue to dtop(yr[y],other[y]) }

# Hydro
  spline ctension_ from dtop(yr[1],hydro[1]) to dtop(yr[2],hydro[2])
  for y=3 to nD0 do { continue to dtop(yr[y],hydro[y]) }

# Coal
  spline ctension_ from dtop(yr[1],coal[1]) to dtop(yr[2],coal[2])
  for y=3 to nD0 do { continue to dtop(yr[y],coal[y]) }

# Oil
  spline ctension_ from dtop(yr[1],oil[1]) to dtop(yr[2],oil[2])
  for y=3 to nD0 do { continue to dtop(yr[y],oil[y]) }

# Gas
  spline ctension_ from dtop(yr[1],gas[1]) to dtop(yr[2],gas[2])
  for y=3 to nD0 do { continue to dtop(yr[y],gas[y]) }

# Total
linethick_(2.5)
Total: \
  spline ctension_ from dtop(yr[1],nuclear[1]) to dtop(yr[2],nuclear[2])
  for y=3 to nD0 do { continue to dtop(yr[y],nuclear[y]) }

thicklines_

#f_box(invis fill_(1) with .s at dtop(2000,0)+(0,2pt__),Wood)
Cl: "Coal" wid 20bp__ at dtop(2000,0.36+3pt__)
 "Oil" wid 15bp__ at dtop(2000,0.9)
 "Gas" wid 20bp__ at dtop(2000,1.41)
 "Wood" wid 20bp__ at dtop(1889,0.15)
 svg_rot(50,"Population" at dtop(1975,0.9))

brpos = 2017
 Q: brace(down_ 2.96 with .c at dtop(brpos,1.03))
  svg_rot(90,"90 %" at Q.c+(15bp__,2bp__))
  svg_rot(90,"nonrenewable" at Q.c+(26bp__,2bp__))

 R: brace(down_ 0.28 with .c at dtop(brpos,.09))
  [svg_rot(90,"10 %")] ht 15bp__ wid 10bp__ at R.c+(15bp__,4bp__)
  svg_rot(90,"renewable" at R.c+(26bp__,17bp__))

  linethick_(0.6)
  arrow <- from dtop(1998,1.55) left 0.15 up 0.2
  "Nuclear" wid 70bp__ above

  arrow <- from dtop(1960,1.09) left 0.5
  "Total energy consumption" wid 200bp__ rjust

  spline ctension_ <- \
    from dtop(2014,1.89) left 0.5 up 0.2 then left 0.5 down 0.2
   "680 % of 1850 energy consumption" wid 300bp__ rjust

H: "Hydro" wid 30bp__ with .w at (Cl.w.x,Cl.c.y-17pt__)
R: dtop(yr[nD0]-2,0.16)
  spline from H.e+(2pt__,0) to (R.x+0.11,H.y) then to (R.x+0.11,R.y) \
    then to R ->

  spline <- from dtop(yr[nD0]-1,0.12) left 0.2 up 0.1 then left 0.55 up 0.05
  "Other renewables" wid 100bp__ with .b at Here+(-0.4,2pt__)

Q: NPopulation.end + (-1.25,-0.1)
  spline ctension_ <- \
   from NPopulation.end+(-3pt__,0) left 0.3 down 0.1 then left 0.45 then to Q
  sprintf("%g %% of 1850 population",round_(ypop[nyd]/ypop[1]*10)*10) \
    wid 100bp__ rjust
]

 command "</g>" # end font
#.PE
  ] with .sw at last [].se+(-40bp__,0) # Cons
#showbox_

.PE
